

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_RefreshCSDBAccessKey.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/WFD_RefreshCSDBAccessKey.script,v $ $Id: WFD_RefreshCSDBAccessKey.script,v 1.1.2.4 2020/10/04 00:58:56 abilbrey Exp $";
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER ON

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.1.2.4 $'

SET @name = 'Refresh Commserve Database Access Key'

SET @description = 'Refresh Commserve Database Access Key'

SET @version = 1

SET @flags = 6

SET @definition='<workflow apiMode="0" description="Refresh Commserve Database Access Key" inputs="&lt;inputs />" interactive="0" isHtmlDescription="0" name="Refresh Commserve database access key" outputs="&lt;outputs />" revision="$Revision: 1.1.2.4 $" uniqueGuid="796090f9-d915-4405-a649-cd06ccbf9146" variables="&lt;variables>&lt;DelayedStartServiceName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/variables>">

    <schema>

        <outputs className="" name="outputs" type=""/>

        <variables className="" name="variables" type="">

            <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="DelayedStartServiceName" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

        </variables>

        <inputs className="" name="inputs" type=""/>

    </schema>

    <Start breakpoint="0" commented="0" continueOnFailure="0" created="0" description="" displayName="Start" height="36" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="0" style="image;image=/images/jgraphx/house.png" uniqueName="Start_1" waitSetting="0" width="55" x="45" y="41">

        <inputs val="&lt;inputs />"/>

        <transition activity="CommServDBQuery_1" commented="0" originalStyle="" points="" sourceX="72" sourceY="59" status="0" style="defaultEdge" targetX="233" targetY="61" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Start>

    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1464291942013" description="executes queries against a commcell database" displayName="List clients with access to CSDB" height="53" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=CommServDBQuery" uniqueName="CommServDBQuery_1" waitSetting="0" width="200" x="250" y="32">

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>-- This query selects local CS instance (always) and remote stand alone workflow/web server instances.&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;-- LOWER() so that behaviour is consistent with Installer.&amp;#xD;&#xd;&#xa;DECLARE @Password VARCHAR(255) = LOWER (CONVERT (VARCHAR(255), NEWID())) &amp;#xD;&#xd;&#xa;DECLARE @PAccess VARCHAR(255) = ''11sqladmin_cv''&amp;#xD;&#xd;&#xa;SET @PAccess = @PAccess + @Password&amp;#xD;&#xd;&#xa;EXEC pswEncryptionManaged @PAccess, @PAccess OUTPUT&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;SELECT  &amp;#xD;&#xd;&#xa;&#x9;name as ClientName,&amp;#xD;&#xd;&#xa;&#x9;@Password as Password, &amp;#xD;&#xd;&#xa;&#x9;(CASE WHEN CL.Id = 2 THEN ''DBMaintenance'' ELSE ''REG'' END) as Command,&amp;#xD;&#xd;&#xa;&#x9;-- Change password in both SQL and reg for local CS, only in reg for other instances. -SkipSQLConn is used to get DBMaint to not connect to SQL (doesn''t have to when just updating reg).&amp;#xD;&#xd;&#xa;&#x9;(CASE WHEN CL.Id = 2 &amp;#xD;&#xd;&#xa;&#x9;&#x9;THEN CONCAT (''-cslogin sqladmin_cv -cspwd '', @Password, '' -CreateSQLLogin -SetRegistry'')&amp;#xD;&#xd;&#xa;&#x9;&#x9;ELSE CONCAT (''ADD &quot;\\'', CL.net_hostname, ''\HKLM\Software\Commvault Systems\Galaxy\'', PROP.attrVal, ''\Database&quot; /f /v pAccess /t REG_SZ /d '', @PAccess)&amp;#xD;&#xd;&#xa;&#x9;END) AS Options&amp;#xD;&#xd;&#xa;FROM APP_Client CL, APP_ClientProp PROP&amp;#xD;&#xd;&#xa;WHERE &amp;#xD;&#xd;&#xa;&#x9;(&amp;#xD;&#xd;&#xa;&#x9;&#x9;-- Local CS.&amp;#xD;&#xd;&#xa;&#x9;&#x9;CL.Id = 2 or &amp;#xD;&#xd;&#xa;&#x9;&#x9;-- Standalone webservers (252), workflow engines (23) &amp;#xD;&#xd;&#xa;&#x9;&#x9;CL.Id in (SELECT DISTINCT ClientId FROM simInstalledPackages WHERE simPackageID IN (252, 23) AND ClientId &amp;lt;&amp;gt; 2)&amp;#xD;&#xd;&#xa;&#x9;) AND&amp;#xD;&#xd;&#xa;&#x9;-- Pick out the Instance name.&amp;#xD;&#xd;&#xa;&#x9;CL.Id = PROP.componentNameId AND PROP.attrName = ''Galaxy Instance name''&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;-- Ordering of these rows is very important - Local CS has to be first always. &amp;#xD;&#xd;&#xa;ORDER BY CL.Id DESC      &amp;#xD;&#xd;&#xa;&lt;/query>&lt;/inputs>"/>

        <transition activity="ForEach_1" commented="0" originalStyle="" points="" sourceX="296" sourceY="62" status="0" style="defaultEdge" targetX="567" targetY="152" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1464294389162" description="iterates a group of activities over a list of values" displayName="ForEach" height="216" interactive="0" jobMode="0" name="ForEach" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="swimlane" uniqueName="ForEach_1" waitSetting="0" width="553" x="699" y="15">

        <inputs val="&lt;inputs>&lt;name class=&quot;java.lang.String&quot;>row&lt;/name>&lt;values class=&quot;java.lang.Object&quot; _list_=&quot;false&quot;>xpath:{/workflow/CommServDBQuery_1/resultSets[1]/row}&lt;/values>&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>1&lt;/numberOfParallelExecutions>&lt;continueOnFailure class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/continueOnFailure>&lt;/inputs>"/>

        <superProcess>

            <Start breakpoint="0" commented="0" continueOnFailure="0" created="1464294389162" description="" displayName="Start" height="30" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="0" style="label;fillColor=#FFFF33;gradientColor=#FFFF00" uniqueName="Start_2" waitSetting="0" width="120" x="105" y="30">

                <inputs val="&lt;inputs />"/>

                <transition activity="ExecuteCommand_1" commented="0" originalStyle="" points="" sourceX="165" sourceY="45" status="0" style="defaultEdge" targetX="168" targetY="112" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1464294470939" description="Execute a command on a remote machine" displayName="Send newest CSDB access key" height="34" interactive="0" jobMode="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=ExecuteCommand" uniqueName="ExecuteCommand_1" waitSetting="0" width="200" x="77" y="108">

                <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>xpath:{/workflow/ForEach_1/row/col[@name=&quot;ClientName&quot;]}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/ForEach_1/row/col[@name=&quot;Command&quot;]}&lt;/command>&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/ForEach_1/row/col[@name=&quot;Options&quot;]}&lt;/arguments>&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

            </Activity>

        </superProcess>

        <activitySchema>

            <outputs name="outputs">

                <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="0" name="row" type="{workflow.types.data}DataRow">

                    <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                </children>

            </outputs>

            <inputs>

                <children className="java.lang.String" inputType="java.lang.String" name="name" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children className="java.lang.Object" inputType="java.lang.Object" name="values" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                <children className="java.lang.Integer" defaultValue="1" inputType="java.lang.Integer" name="numberOfParallelExecutions" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                <children className="java.lang.Boolean" defaultValue="false" inputType="java.lang.Boolean" name="continueOnFailure" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

            </inputs>

        </activitySchema>

        <transition activity="CommServDBQuery_5" commented="0" originalStyle="" points="" sourceX="975" sourceY="123" status="0" style="defaultEdge" targetX="927" targetY="278" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="1" created="1466625294231" description="Execute a list of commands" displayName="Restart services on Commserve" height="34" interactive="0" jobMode="0" maxRestarts="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=ExecuteCommand" uniqueName="ExecuteCommand_4" waitSetting="0" width="200" x="1331" y="61">

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/system/commCellName}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; />&lt;command class=&quot;java.lang.String&quot;>cmd.exe&lt;/command>&lt;arguments class=&quot;java.lang.String&quot;>/C DRRestore.exe a b RestartServices d&lt;/arguments>&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>false&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="Decision_2" commented="0" originalStyle="" points="" sourceX="1463" sourceY="95" status="0" style="defaultEdge" targetX="1463" targetY="268" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="1" created="1468874568653" description="Execute a command on a remote machine" displayName="Stop service" height="34" interactive="0" jobMode="0" maxRestarts="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=ExecuteCommand" uniqueName="ExecuteCommand_5" waitSetting="0" width="134" x="1396" y="268">

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>&lt;clientName />&lt;clientId />&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>cmd&lt;/command>&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>/c &quot;sc stop xpath:{/workflow/variables/DelayedStartServiceName} &amp;amp; timeout /t 15 &amp;amp; sc start xpath:{/workflow/variables/DelayedStartServiceName}&quot;&lt;/arguments>&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/waitForProcessCompletion>&lt;/inputs>"/>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="1" created="1468875295348" description="if/else based decision" displayName="Delayed Service Restart Required?" height="100" interactive="0" jobMode="0" maxRestarts="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1" uniqueName="Decision_2" waitSetting="0" width="200" x="1363" y="130">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;> !xpath:{/workflow/variables/DelayedStartServiceName}.isEmpty ()&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="ExecuteCommand_5" commented="0" displayName="YES" originalStyle="" points="" sourceX="1467" sourceY="184" status="0" style="defaultEdge" targetX="1461" targetY="268" transitionIndex="0" value="TRUE" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="Delay_3" commented="0" originalStyle="" points="" sourceX="1463" sourceY="180" status="0" style="defaultEdge" targetX="1634" targetY="183" transitionIndex="0" value="False" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1468875670952" description="activity to delay the workflow execution in minutes" displayName="Wait for remote service to go down" height="34" interactive="0" jobMode="0" name="Delay" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=Delay" uniqueName="Delay_3" waitSetting="0" width="200" x="1629" y="174">

        <inputs val="&lt;inputs>&lt;delayLength class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>1&lt;/delayLength>&lt;delayInterval class=&quot;workflow.types.DelayInterval&quot; _list_=&quot;false&quot;>Seconds&lt;/delayInterval>&lt;/inputs>"/>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1469561137627" description="iterates a group of activities over a list of values" displayName="ForEach" height="775" interactive="0" jobMode="0" name="ForEach" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="swimlane" uniqueName="ForEach_4" waitSetting="0" width="553" x="697" y="399">

        <inputs val="&lt;inputs>&lt;name class=&quot;java.lang.String&quot;>row&lt;/name>&lt;values class=&quot;java.lang.Object&quot; _list_=&quot;false&quot;>xpath:{/workflow/CommServDBQuery_5/resultSets[1]/row}&lt;/values>&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>1&lt;/numberOfParallelExecutions>&lt;continueOnFailure class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/continueOnFailure>&lt;/inputs>"/>

        <superProcess>

            <Start breakpoint="0" commented="0" continueOnFailure="0" created="1464294389162" description="" displayName="Start" height="30" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="0" style="label;fillColor=#FFFF33;gradientColor=#FFFF00" uniqueName="Start_7" waitSetting="0" width="120" x="105" y="30">

                <inputs val="&lt;inputs />"/>

                <transition activity="CommServDBQuery_4" commented="0" originalStyle="" points="" sourceX="165" sourceY="45" status="0" style="defaultEdge" targetX="169" targetY="91" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1465316990243" description="executes queries against a commcell database" displayName="List services to be restarted" height="34" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=CommServDBQuery" uniqueName="CommServDBQuery_4" waitSetting="0" width="200" x="71" y="80">

                <inputs val="&lt;inputs>&lt;commCell />&lt;query>-- This query selects workflow/webserver service name in a given remote client.&amp;#xD;&#xd;&#xa;SELECT &amp;#xD;&#xd;&#xa;&#x9;CL.name AS ClientName,&amp;#xD;&#xd;&#xa;&#x9;-- There can be only one web server on a 252 PKG client. And that WS is always from Simpana not from the customer.&amp;#xD;&#xd;&#xa;&#x9;CASE WHEN PKG.simPackageID = 252 THEN ''W3SVC'' ELSE CONCAT (''CVJavaWorkFlow('', PROP.attrVal, '')'') END AS ServiceName&amp;#xD;&#xd;&#xa;FROM APP_Client CL, APP_ClientProp PROP, SimInstalledPackages PKG&amp;#xD;&#xd;&#xa;WHERE&amp;#xD;&#xd;&#xa;&#x9;-- For local CS client, we are anyway gonna have to restart services. So, ignore it here.&amp;#xD;&#xd;&#xa;&#x9;CL.Id &amp;lt;&amp;gt; 2 AND&amp;#xD;&#xd;&#xa;&#x9;-- For the given client name.&amp;#xD;&#xd;&#xa;&#x9;CL.name = ''xpath:{/workflow/ForEach_4/row/col[@name=&quot;ClientName&quot;]}'' AND&amp;#xD;&#xd;&#xa;&#x9;-- Pick out the Instance name.&amp;#xD;&#xd;&#xa;&#x9;CL.Id = PROP.componentNameId AND PROP.attrName = ''Galaxy Instance name'' AND&amp;#xD;&#xd;&#xa;&#x9;-- Pick out the workflow/webserver packages. &amp;#xD;&#xd;&#xa;&#x9;CL.Id = PKG.ClientId AND PKG.simPackageID IN (252, 23)&lt;/query>&lt;/inputs>"/>

                <transition activity="ForEach_2" commented="0" originalStyle="" points="" sourceX="171" sourceY="97" status="0" style="defaultEdge" targetX="188" targetY="169" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="1" created="1465319100014" description="iterates a group of activities over a list of values" displayName="ForEach" height="568" interactive="0" jobMode="0" maxRestarts="0" name="ForEach" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="swimlane" uniqueName="ForEach_2" waitSetting="0" width="409" x="36" y="161">

                <inputs val="&lt;inputs>&lt;name class=&quot;java.lang.String&quot;>row&lt;/name>&lt;values class=&quot;java.lang.Object&quot; _list_=&quot;false&quot;>xpath:{/workflow/CommServDBQuery_4/resultSets[1]/row}&lt;/values>&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>1&lt;/numberOfParallelExecutions>&lt;continueOnFailure class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/continueOnFailure>&lt;/inputs>"/>

                <superProcess>

                    <Start breakpoint="0" commented="0" continueOnFailure="0" created="1465319100014" description="" displayName="Start" height="30" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="0" style="label;fillColor=#FFFF33;gradientColor=#FFFF00" uniqueName="Start_3" waitSetting="0" width="120" x="18" y="30">

                        <inputs val="&lt;inputs />"/>

                        <transition activity="Decision_1" commented="0" originalStyle="" points="" sourceX="78" sourceY="45" status="0" style="defaultEdge" targetX="100" targetY="86" transitionIndex="0" x="0" y="0">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Start>

                    <Activity breakpoint="0" commented="0" continueOnFailure="1" created="1465319116410" description="Execute a command on a remote machine" displayName="Stop service" height="34" interactive="0" jobMode="0" maxRestarts="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=ExecuteCommand" uniqueName="ExecuteCommand_2" waitSetting="0" width="134" x="35" y="229">

                        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>xpath:{/workflow/ForEach_2/row/col[@name=&quot;ClientName&quot;]}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>sc&lt;/command>&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>stop xpath:{/workflow/ForEach_2/row/col[@name=&quot;ServiceName&quot;]}&lt;/arguments>&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

                        <transition activity="Switch_1" commented="0" originalStyle="" points="" sourceX="98" sourceY="247" status="0" style="defaultEdge" targetX="96" targetY="290" transitionIndex="0" x="11" y="143">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1465319497079" description="Execute a command on a remote machine" displayName="Start service" height="34" interactive="0" jobMode="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=ExecuteCommand" uniqueName="ExecuteCommand_3" waitSetting="0" width="134" x="51" y="494">

                        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>xpath:{/workflow/ForEach_2/row/col[@name=&quot;ClientName&quot;]}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>sc&lt;/command>&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>start xpath:{/workflow/ForEach_2/row/col[@name=&quot;ServiceName&quot;]}&lt;/arguments>&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

                    </Activity>

                    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1465328890725" description="switch based decision" displayName="Switch" height="100" interactive="0" jobMode="0" name="Switch" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1" uniqueName="Switch_1" waitSetting="0" width="100" x="45" y="282">

                        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/ExecuteCommand_2/exitCode}&lt;/expression>&lt;/inputs>"/>

                        <transition activity="Delay_1" commented="0" displayName="SERVICE GOING DOWN" originalStyle="" points="" sourceX="95" sourceY="332" status="0" style="defaultEdge" targetX="89" targetY="415" transitionIndex="0" value="0" x="11" y="143">

                            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                        <transition activity="ExecuteCommand_3" commented="0" displayName="SERVICE NOT STARTED" offsetX="64" offsetY="-3" originalStyle="" points="276.0,444.0" sourceX="95" sourceY="332" status="0" style="defaultEdge" targetX="139" targetY="511" transitionIndex="0" value="1062" x="11" y="143">

                            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1465328988189" description="activity to delay the workflow execution in minutes" displayName="Wait for remote service to go down" height="34" interactive="0" jobMode="0" name="Delay" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=Delay" uniqueName="Delay_1" waitSetting="0" width="200" x="42" y="408">

                        <inputs val="&lt;inputs>&lt;delayLength class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>15&lt;/delayLength>&lt;delayInterval class=&quot;workflow.types.DelayInterval&quot; _list_=&quot;false&quot;>Seconds&lt;/delayInterval>&lt;/inputs>"/>

                        <transition activity="ExecuteCommand_3" commented="0" originalStyle="" points="" sourceX="117" sourceY="468" status="0" style="defaultEdge" targetX="143" targetY="519" transitionIndex="0" x="11" y="143">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1468873475194" description="if/else based decision" displayName="CURRENT WORKFLOW ENGINE?" height="100" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1" uniqueName="Decision_1" waitSetting="0" width="200" x="0" y="78">

                        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/ForEach_2/row/col[@name=&quot;ClientName&quot;]}.equals (xpath:{/workflow/system/workflowEngine/clientName}) &amp;amp;&amp;amp; xpath:{/workflow/ForEach_2/row/col[@name=&quot;ServiceName&quot;]}.startsWith (&quot;CVJavaWorkFlow&quot;) &lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                        <transition activity="ExecuteCommand_2" commented="0" displayName="NO" originalStyle="" points="" sourceX="96" sourceY="133" status="0" style="defaultEdge" targetX="101" targetY="236" transitionIndex="0" value="False" x="0" y="0">

                            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                        <transition activity="AssignValues_2" commented="0" displayName="YES&#xd;&#xa;" originalStyle="" points="" sourceX="104" sourceY="133" status="0" style="defaultEdge" targetX="329" targetY="131" transitionIndex="0" value="True" x="0" y="0">

                            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1468873579384" description="Updates process variables and inputs" displayName="AssignValues" height="34" interactive="0" jobMode="0" name="AssignValues" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.AssignValues" uniqueName="AssignValues_2" waitSetting="0" width="108" x="275" y="114">

                        <outputs variables="&lt;variables>&lt;DelayedStartServiceName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/ForEach_2/row/col[@name=&quot;ServiceName&quot;]}&lt;/DelayedStartServiceName>&lt;/variables>"/>

                        <inputs val="&lt;inputs />"/>

                    </Activity>

                </superProcess>

                <activitySchema>

                    <outputs name="outputs">

                        <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="0" name="row" type="{workflow.types.data}DataRow">

                            <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                        </children>

                    </outputs>

                    <inputs>

                        <children className="java.lang.String" inputType="java.lang.String" name="name" type="{http://www.w3.org/2001/XMLSchema}string"/>

                        <children className="java.lang.Object" inputType="java.lang.Object" name="values" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                        <children className="java.lang.Integer" defaultValue="1" inputType="java.lang.Integer" name="numberOfParallelExecutions" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                        <children className="java.lang.Boolean" defaultValue="false" inputType="java.lang.Boolean" name="continueOnFailure" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                    </inputs>

                </activitySchema>

            </Activity>

        </superProcess>

        <activitySchema>

            <outputs name="outputs">

                <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="0" name="row" type="{workflow.types.data}DataRow">

                    <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                </children>

            </outputs>

            <inputs>

                <children className="java.lang.String" inputType="java.lang.String" name="name" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children className="java.lang.Object" inputType="java.lang.Object" name="values" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                <children className="java.lang.Integer" defaultValue="1" inputType="java.lang.Integer" name="numberOfParallelExecutions" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                <children className="java.lang.Boolean" defaultValue="false" inputType="java.lang.Boolean" name="continueOnFailure" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

            </inputs>

        </activitySchema>

        <transition activity="ExecuteCommand_4" commented="0" originalStyle="" points="" sourceX="970" sourceY="657" status="0" style="defaultEdge" targetX="1388" targetY="80" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1469561832110" description="executes queries against a commcell database" displayName="List clients with access to CSDB" height="53" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=CommServDBQuery" uniqueName="CommServDBQuery_5" waitSetting="0" width="200" x="835" y="272">

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>-- This query selects local CS instance (always) and remote stand alone workflow/web server instances.&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;-- LOWER() so that behaviour is consistent with Installer.&amp;#xD;&#xd;&#xa;DECLARE @Password VARCHAR(255) = LOWER (CONVERT (VARCHAR(255), NEWID())) &amp;#xD;&#xd;&#xa;DECLARE @PAccess VARCHAR(255) = ''11sqladmin_cv''&amp;#xD;&#xd;&#xa;SET @PAccess = @PAccess + @Password&amp;#xD;&#xd;&#xa;EXEC pswEncryptionManaged @PAccess, @PAccess OUTPUT&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;SELECT  &amp;#xD;&#xd;&#xa;&#x9;name as ClientName,&amp;#xD;&#xd;&#xa;&#x9;@Password as Password, &amp;#xD;&#xd;&#xa;&#x9;(CASE WHEN CL.Id = 2 THEN ''DBMaintenance'' ELSE ''REG'' END) as Command,&amp;#xD;&#xd;&#xa;&#x9;-- Change password in both SQL and reg for local CS, only in reg for other instances. -SkipSQLConn is used to get DBMaint to not connect to SQL (doesn''t have to when just updating reg).&amp;#xD;&#xd;&#xa;&#x9;(CASE WHEN CL.Id = 2 &amp;#xD;&#xd;&#xa;&#x9;&#x9;THEN CONCAT (''-cslogin sqladmin_cv -cspwd '', @Password, '' -CreateSQLLogin -SetRegistry'')&amp;#xD;&#xd;&#xa;&#x9;&#x9;ELSE CONCAT (''ADD &quot;\\'', CL.net_hostname, ''\HKLM\Software\Commvault Systems\Galaxy\'', PROP.attrVal, ''\Database&quot; /f /v pAccess /t REG_SZ /d '', @PAccess)&amp;#xD;&#xd;&#xa;&#x9;END) AS Options&amp;#xD;&#xd;&#xa;FROM APP_Client CL, APP_ClientProp PROP&amp;#xD;&#xd;&#xa;WHERE &amp;#xD;&#xd;&#xa;&#x9;(&amp;#xD;&#xd;&#xa;&#x9;&#x9;-- Local CS.&amp;#xD;&#xd;&#xa;&#x9;&#x9;CL.Id = 2 or &amp;#xD;&#xd;&#xa;&#x9;&#x9;-- Standalone webservers (252), workflow engines (23) &amp;#xD;&#xd;&#xa;&#x9;&#x9;CL.Id in (SELECT DISTINCT ClientId FROM simInstalledPackages WHERE simPackageID IN (252, 23) AND ClientId &amp;lt;&amp;gt; 2)&amp;#xD;&#xd;&#xa;&#x9;) AND&amp;#xD;&#xd;&#xa;&#x9;-- Pick out the Instance name.&amp;#xD;&#xd;&#xa;&#x9;CL.Id = PROP.componentNameId AND PROP.attrName = ''Galaxy Instance name''&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;-- Ordering of these rows is very important - Local CS has to be first always. &amp;#xD;&#xd;&#xa;ORDER BY CL.Id DESC      &amp;#xD;&#xd;&#xa;&lt;/query>&lt;/inputs>"/>

        <transition activity="ForEach_4" commented="0" originalStyle="" points="" sourceX="935" sourceY="298" status="0" style="defaultEdge" targetX="936" targetY="400" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <formProperties css="" javaScript=""/>

</workflow>

' 

IF not exists (select * from WF_Definition where Name = @name)

BEGIN
	INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision)


	VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision)

	SET @workflowId = @@IDENTITY
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


	VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

	SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = ISNULL(revision, '') From WF_Definition WHERE Name = @name

	IF (@currentFlags & 6 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0) AND (@currentRevision <> @revision)

	BEGIN

		SET @version = @version + 1

		UPDATE WF_Definition

		SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision

		WHERE Name = @name

		IF (@currentFlags & 6 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0)

		BEGIN

			UPDATE WF_Definition

			SET flags = @flags

			WHERE Name = @name

		END
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


		VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

	END

END
