

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_PreventCopyOnJobs.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER OFF

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @guid nvarchar(256)

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.1.2.1 $'

SET @name = 'Prevent Copy On Jobs'

SET @description = 'Prevent Copy On Jobs'

SET @version = 1

SET @flags = 6

SET @guid = '7A6116FA-DF52-47CA-BA74-B3AAA3CEB321'

SET @definition = '<workflow apiMode="0" config="&lt;configuration /&gt;" description="Prevent Copy On Jobs" executeOnWeb="0" inputs="&lt;inputs&gt;&lt;Jobs class=&quot;java.lang.Integer&quot; _list_=&quot;true&quot; /&gt;&lt;CommCells class=&quot;java.lang.Integer&quot; _list_=&quot;true&quot; /&gt;&lt;CopyIds class=&quot;java.lang.Integer&quot; _list_=&quot;true&quot; /&gt;&lt;/inputs&gt;" interactive="1" isHtmlDescription="0" manualPercentageComplete="0" name="Prevent Copy On Jobs" outputs="&lt;outputs /&gt;" revision="$Revision: 1.1.2.1 $" tags="" uniqueGuid="afd5d49f-6d31-4863-abd5-b393781a00af" variables="&lt;variables&gt;&lt;CopiesStatusHtmlStr class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/variables&gt;" webHidden="0" workflowId="120">

  <schema>

    <inputs className="" name="inputs" type="">

      <children attribute="0" className="java.lang.Integer" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Integer" listType="1" name="Jobs" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}integer" />

      <children attribute="0" className="java.lang.Integer" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Integer" listType="1" name="CommCells" type="{http://www.w3.org/2001/XMLSchema}integer" />

      <children attribute="0" className="java.lang.Integer" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Integer" listType="1" name="CopyIds" type="{http://www.w3.org/2001/XMLSchema}integer" />

    </inputs>

    <variables attribute="0" className="" name="variables" type="">

      <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" hidden="0" inputType="java.lang.String" listType="0" name="CopiesStatusHtmlStr" type="{http://www.w3.org/2001/XMLSchema}string" />

    </variables>

    <outputs className="" name="outputs" type="" />

    <config className="" name="configuration" type="" />

  </schema>

  <Start commented="0" continueOnFailure="0" created="0" description="" displayName="Start" height="36" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="0" style="image;image=/images/jgraphx/house.png" uniqueName="Start_1" waitSetting="0" width="58" x="368" y="24">

    <inputs val="&lt;inputs /&gt;" />

    <transition activity="InformationalMessage_4" commented="0" originalStyle="" points="" sourceX="397" sourceY="42" status="0" style="defaultEdge" targetX="673" targetY="121" transitionIndex="0" x="0" y="0">

      <condition language="4" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Start>

  <Activity commented="0" continueOnFailure="0" created="1599661460663" description="executes queries against a commcell database" displayName="CommServDBQuery" height="34" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_1" waitSetting="0" width="143" x="316" y="231">

    <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;DECLARE @jobIds nvarchar(max) = ''xpath:{/workflow/inputs/Jobs}''&amp;#xD;&#xD;&#xA;DECLARE @commCellIds nvarchar(max) = ''xpath:{/workflow/inputs/CommCells}''&amp;#xD;&#xD;&#xA;DECLARE @copyIds nvarchar(max) = ''xpath:{/workflow/inputs/CopyIds}''&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;DECLARE @policyName NVARCHAR(144)&amp;#xD;&#xD;&#xA;DECLARE @copyName NVARCHAR(64)&amp;#xD;&#xD;&#xA;DECLARE @commCellName NVARCHAR(512)&amp;#xD;&#xD;&#xA;DECLARE @jobList nvarchar(max) = NULL&amp;#xD;&#xD;&#xA;DECLARE @jobId INTEGER&amp;#xD;&#xD;&#xA;DECLARE @commCellId INTEGER&amp;#xD;&#xD;&#xA;DECLARE @copyId INTEGER&amp;#xD;&#xD;&#xA;DECLARE @jobIdPos INTEGER&amp;#xD;&#xD;&#xA;DECLARE @commCellIdPos INTEGER&amp;#xD;&#xD;&#xA;DECLARE @copyIdPos INTEGER&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;DECLARE @CopiesStatusHtmlStr NVARCHAR(MAX) = ''''&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;IF OBJECT_ID(''tempdb..#getNonIdaObjects_OutputTable'') IS NOT NULL DROP TABLE #getNonIdaObjects_OutputTable&amp;#xD;&#xD;&#xA;CREATE TABLE #getNonIdaObjects_OutputTable (entityId INT PRIMARY KEY)    &amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;EXEC sec_getNonIdaObjectsForThisUser 1, 17 /*STORAGE_POLICY_ENTITY*/, 4 /*EV_MANAGE_ARCHIVES*/, ''#getNonIdaObjects_OutputTable'' &amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;BEGIN TRY&amp;#xD;&#xD;&#xA;    if object_id(''tempdb.dbo.#QS_MarkJobsOnCopy_Output'') is not null DROP TABLE #QS_MarkJobsOnCopy_Output&amp;#xD;&#xD;&#xA;    CREATE TABLE #QS_MarkJobsOnCopy_Output(Msg NVARCHAR(MAX))&amp;#xD;&#xD;&#xA;    IF object_id(''tempdb.dbo.#CorruptedJobsOnSrcCopy'') is not null DROP TABLE #CorruptedJobsOnSrcCopy&amp;#xD;&#xD;&#xA;    CREATE TABLE #CorruptedJobsOnSrcCopy (&amp;#xD;&#xD;&#xA;            JobId INT, CommCellId INT, Copyid INT PRIMARY KEY(JObId, CommCellId, CopyId)&amp;#xD;&#xD;&#xA;    )&amp;#xD;&#xD;&#xA;    &amp;#xD;&#xD;&#xA;    IF OBJECT_ID(''tempdb..#lt_SPs'') IS NOT NULL DROP TABLE #lt_SPs&amp;#xD;&#xD;&#xA;    CREATE TABLE #lt_SPs &amp;#xD;&#xD;&#xA;    (&amp;#xD;&#xD;&#xA;        PolicyName   nvarchar(256),&amp;#xD;&#xD;&#xA;        PolicyId        int,&amp;#xD;&#xD;&#xA;        CopyName    nvarchar(64),&amp;#xD;&#xD;&#xA;        CopyId      int,&amp;#xD;&#xD;&#xA;    )&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;    IF OBJECT_ID(''tempdb..#jobsToProcess'') IS NOT NULL DROP TABLE #jobsToProcess&amp;#xD;&#xD;&#xA;    CREATE TABLE #jobsToProcess&amp;#xD;&#xD;&#xA;    (&amp;#xD;&#xD;&#xA;        jobId                 INTEGER, &amp;#xD;&#xD;&#xA;        commCellId        INTEGER, &amp;#xD;&#xD;&#xA;        archGrpCopyId INTEGER, &amp;#xD;&#xD;&#xA;        Primary Key (jobId, commCellId, archGrpCopyId) WITH (ignore_dup_key = ON)&amp;#xD;&#xD;&#xA;    )        &amp;#xD;&#xD;&#xA;    &amp;#xD;&#xD;&#xA;    /* Remove the else part*/&amp;#xD;&#xD;&#xA;    IF (@jobIds IS NOT NULL AND (LEN(@jobIds) &amp;gt; 0))&amp;#xD;&#xD;&#xA;    BEGIN&amp;#xD;&#xD;&#xA;    &#x9;/* Change the logic to parse and insert to ensure jobid, commcellid, copyid are matching correctly*/&amp;#xD;&#xD;&#xA;        IF PATINDEX(''%[([,]%'', @jobIds) &amp;gt; 0&amp;#xD;&#xD;&#xA;            SET @jobIds = SUBSTRING(@jobIds, 2, LEN(@jobIds) -2)&amp;#xD;&#xD;&#xA;        IF PATINDEX(''%[([,]%'', @commCellIds) &amp;gt; 0&amp;#xD;&#xD;&#xA;            SET @commCellIds = SUBSTRING(@commCellIds, 2, LEN(@commCellIds) -2)&amp;#xD;&#xD;&#xA;        IF PATINDEX(''%[([,]%'', @copyIds) &amp;gt; 0&amp;#xD;&#xD;&#xA;            SET @copyIds = SUBSTRING(@copyIds, 2, LEN(@copyIds) -2)&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;        INSERT  INTO #lt_SPs&amp;#xD;&#xD;&#xA;        SELECT  DISTINCT AG.name, AG.id, AGC.name, AGC.id&amp;#xD;&#xD;&#xA;        FROM    ArchGroup AG WITH(READUNCOMMITTED), ArchGroupCopy AGC WITH(READUNCOMMITTED), (SELECT DISTINCT _ID FROM dbo.SplitIDs(@copyIds)) SEC        &amp;#xD;&#xD;&#xA;        WHERE    AG.id = AGC.archGroupId AND AGC.id = SEC._ID &amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&#x9;&#x9;SET @jobIds = LTRIM(RTRIM(@jobIds)) + '',''&amp;#xD;&#xD;&#xA;&#x9;&#x9;SET @commCellIds = LTRIM(RTRIM(@commCellIds)) + '',''&amp;#xD;&#xD;&#xA;&#x9;&#x9;SET @copyIds = LTRIM(RTRIM(@copyIds)) + '',''&amp;#xD;&#xD;&#xA;&#x9;&#x9;SET @jobIdPos = CHARINDEX('','', @jobIds, 1)&amp;#xD;&#xD;&#xA;&#x9;&#x9;SET @commCellIdPos = CHARINDEX('','', @commCellIds, 1)&amp;#xD;&#xD;&#xA;&#x9;&#x9;SET @copyIdPos = CHARINDEX('','', @copyIds, 1)&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&#x9;&#x9;IF ((REPLACE(@jobIds, '','', '''') &amp;lt;&amp;gt; '''') AND (REPLACE(@commCellIds, '','', '''') &amp;lt;&amp;gt; '''') AND (REPLACE(@copyIds, '','', '''') &amp;lt;&amp;gt; ''''))&amp;#xD;&#xD;&#xA;&#x9;&#x9;BEGIN&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;WHILE ((@jobIdPos &amp;gt; 0) AND (@commCellIdPos &amp;gt; 0) AND (@copyIdPos &amp;gt; 0))&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;BEGIN&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;SET @jobId = CAST(LTRIM(RTRIM(LEFT(@jobIds, @jobIdPos - 1))) AS int)&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;SET @commCellId = CAST(LTRIM(RTRIM(LEFT(@commCellIds, @commCellIdPos - 1))) AS int)&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;SET @copyId = CAST(LTRIM(RTRIM(LEFT(@copyIds, @copyIdPos - 1))) AS int)&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;IF ((@jobId &amp;lt;&amp;gt; 0) AND (@commCellId &amp;lt;&amp;gt; 0) AND (@copyId &amp;lt;&amp;gt; 0))&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;BEGIN&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;INSERT INTO #CorruptedJobsOnSrcCopy (JobId, CommCellId, Copyid)&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;VALUES(@jobId, @commCellId, @copyId)&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;END&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;SET @jobIds = RIGHT(@jobIds, LEN(@jobIds) - @jobIdPos)&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;SET @jobIdPos = CHARINDEX('','', @jobIds, 1)&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;SET @commCellIds = RIGHT(@commCellIds, LEN(@commCellIds) - @commCellIdPos)&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;SET @commCellIdPos = CHARINDEX('','', @commCellIds, 1)&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;SET @copyIds = RIGHT(@copyIds, LEN(@copyIds) - @copyIdPos)&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;SET @copyIdPos = CHARINDEX('','', @copyIds, 1)&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;END&amp;#xD;&#xD;&#xA;&#x9;&#x9;END     &amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;        DELETE    CJ&amp;#xD;&#xD;&#xA;        FROM    #CorruptedJobsOnSrcCopy CJ&amp;#xD;&#xD;&#xA;                INNER JOIN JMJobDataStats JDS WITH (READUNCOMMITTED) ON CJ.JobId = JDS.jobId AND CJ.CommCellId = JDS.commCellId AND CJ.CopyId = JDS.archGrpCopyId&amp;#xD;&#xD;&#xA;        WHERE    (JDS.disabled &amp;amp; 257 /*CVA_DONOTCOPY_FLAG+CVA_AGED_DATA_FLAG*/) &amp;gt; 0&amp;#xD;&#xD;&#xA;        &amp;#xD;&#xD;&#xA;        DELETE   CJ&amp;#xD;&#xD;&#xA;        FROM    #CorruptedJobsOnSrcCopy CJ&amp;#xD;&#xD;&#xA;                        INNER JOIN archGroupCopy AGC WITH (READUNCOMMITTED) ON CJ.copyId = AGC.id&amp;#xD;&#xD;&#xA;                        LEFT OUTER JOIN #getNonIdaObjects_OutputTable SEC ON AGC.archGroupId = SEC.entityId&amp;#xD;&#xD;&#xA;        WHERE   SEC.entityId IS NULL &amp;#xD;&#xD;&#xA;        &amp;#xD;&#xD;&#xA;        &amp;#xD;&#xD;&#xA;        WHILE EXISTS (SELECT 1 FROM #CorruptedJobsOnSrcCopy)&amp;#xD;&#xD;&#xA;        BEGIN&amp;#xD;&#xD;&#xA;            TRUNCATE TABLE #jobsToProcess&amp;#xD;&#xD;&#xA;            &amp;#xD;&#xD;&#xA;            --Pick jobs to retain and mark bad&amp;#xD;&#xD;&#xA;            ;WITH CTE&amp;#xD;&#xD;&#xA;            AS (&amp;#xD;&#xD;&#xA;                        SELECT TOP 5000 CJ.JobId, CJ.CommCellId, CJ.Copyid&amp;#xD;&#xD;&#xA;                        FROM #CorruptedJobsOnSrcCopy CJ&amp;#xD;&#xD;&#xA;                        ORDER BY Copyid, jobId&amp;#xD;&#xD;&#xA;                    )&amp;#xD;&#xD;&#xA;            DELETE FROM CTE&amp;#xD;&#xD;&#xA;            OUTPUT DELETED.JobId, DELETED.commCellId, DELETED.Copyid INTO #jobsToProcess    &amp;#xD;&#xD;&#xA;        &amp;#xD;&#xD;&#xA;        --Batching by copy&amp;#xD;&#xD;&#xA;            DECLARE COPYLIST_CURSOR CURSOR FOR&amp;#xD;&#xD;&#xA;            SELECT DISTINCT archGrpCopyId FROM #jobsToProcess&amp;#xD;&#xD;&#xA;            &amp;#xD;&#xD;&#xA;            OPEN COPYLIST_CURSOR&amp;#xD;&#xD;&#xA;            &amp;#xD;&#xD;&#xA;            FETCH NEXT FROM COPYLIST_CURSOR INTO @copyId&amp;#xD;&#xD;&#xA;            &amp;#xD;&#xD;&#xA;            WHILE (@@FETCH_STATUS = 0)&amp;#xD;&#xD;&#xA;            BEGIN&amp;#xD;&#xD;&#xA;                SELECT @policyName = SP.policyName, @copyName = SP.CopyName&amp;#xD;&#xD;&#xA;                FROM   #lt_SPs SP&amp;#xD;&#xD;&#xA;                WHERE   SP.CopyId  = @copyId    &amp;#xD;&#xD;&#xA;    &amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;SET @jobList = NULL&amp;#xD;&#xD;&#xA;                  &amp;#xD;&#xD;&#xA;                SELECT @jobList = COALESCE(@jobList+'', '' ,'''') + CAST(jobId as varchar(10))            &amp;#xD;&#xD;&#xA;                FROM #jobsToProcess        &amp;#xD;&#xD;&#xA;                WHERE archGrpCopyId = @copyId&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;DELETE FROM #QS_MarkJobsOnCopy_Output          &amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;                EXEC QS_MarkJobsOnCopy @PolicyName, @copyName, ''donotcopy'', @jobList&amp;#xD;&#xD;&#xA;                &amp;#xD;&#xD;&#xA;                IF EXISTS (SELECT 1 FROM  #QS_MarkJobsOnCopy_Output)&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;BEGIN&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;SELECT @CopiesStatusHtmlStr = @CopiesStatusHtmlStr +&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;''&amp;lt;tr&amp;gt;'' +&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;''&amp;lt;td&amp;gt;'' + ISNULL(@PolicyName,''N/A'') + ''&amp;lt;/td&amp;gt;'' +&amp;#xD;&#xD;&#xA;                    ''&amp;lt;td&amp;gt;'' + ISNULL(@copyName, ''N/A'') + ''&amp;lt;/td&amp;gt;'' +&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;''&amp;lt;td&amp;gt;'' + Msg + ''&amp;lt;/td&amp;gt;'' +&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;''&amp;lt;/tr&amp;gt;''&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;FROM #QS_MarkJobsOnCopy_Output&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;END          &amp;#xD;&#xD;&#xA;                &amp;#xD;&#xD;&#xA;                FETCH NEXT FROM COPYLIST_CURSOR INTO @copyId&amp;#xD;&#xD;&#xA;            END&amp;#xD;&#xD;&#xA;            &amp;#xD;&#xD;&#xA;            CLOSE COPYLIST_CURSOR&amp;#xD;&#xD;&#xA;            DEALLOCATE COPYLIST_CURSOR&amp;#xD;&#xD;&#xA;        END&amp;#xD;&#xD;&#xA;      &amp;#xD;&#xD;&#xA;    END&amp;#xD;&#xD;&#xA;    ELSE&amp;#xD;&#xD;&#xA;    BEGIN&amp;#xD;&#xD;&#xA;&#x9;&#x9;SELECT @CopiesStatusHtmlStr = @CopiesStatusHtmlStr +&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;''&amp;lt;tr&amp;gt;'' +&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;''&amp;lt;td&amp;gt;'' + @PolicyName + ''&amp;lt;/td&amp;gt;'' +&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;''&amp;lt;td&amp;gt;'' + @copyName + ''&amp;lt;/td&amp;gt;'' +&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;''&amp;lt;td&amp;gt;'' + ''Need atleast one job information'' + ''&amp;lt;/td&amp;gt;'' +&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;''&amp;lt;/tr&amp;gt;''&#x9;&#x9;    &amp;#xD;&#xD;&#xA;    END&amp;#xD;&#xD;&#xA;END TRY&amp;#xD;&#xD;&#xA;BEGIN CATCH&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;    IF (CURSOR_STATUS(''global'', ''COPYLIST_CURSOR'') &amp;gt;= -1) OR (CURSOR_STATUS(''local'', ''COPYLIST_CURSOR'') &amp;gt;= -1)&amp;#xD;&#xD;&#xA;    BEGIN&amp;#xD;&#xD;&#xA;        IF (CURSOR_STATUS(''global'', ''COPYLIST_CURSOR'') &amp;gt;= 0) OR (CURSOR_STATUS(''local'', ''COPYLIST_CURSOR'') &amp;gt;= 0)    &amp;#xD;&#xD;&#xA;        BEGIN&amp;#xD;&#xD;&#xA;            CLOSE COPYLIST_CURSOR&amp;#xD;&#xD;&#xA;        END&amp;#xD;&#xD;&#xA;        DEALLOCATE COPYLIST_CURSOR&amp;#xD;&#xD;&#xA;    END&amp;#xD;&#xD;&#xA; ;THROW&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;END CATCH&amp;#xD;&#xD;&#xA;SELECT @CopiesStatusHtmlStr&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;if object_id(''tempdb.dbo.#QS_MarkJobsOnCopy_Output'') is not null DROP TABLE #QS_MarkJobsOnCopy_Output&amp;#xD;&#xD;&#xA;IF OBJECT_ID(''tempdb..#lt_SPs'') IS NOT NULL DROP TABLE #lt_SPs&amp;#xD;&#xD;&#xA;IF OBJECT_ID(''tempdb..#jobsToProcess'') IS NOT NULL DROP TABLE #jobsToProcess&lt;/query&gt;&lt;/inputs&gt;" />

    <transition activity="Decision_1" commented="0" originalStyle="" points="" sourceX="390" sourceY="366" status="0" style="defaultEdge" targetX="379" targetY="424" transitionIndex="0" x="0" y="0">

      <condition language="4" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1599661532575" description="Ends the workflow" displayName="WorkflowEnd" height="34" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.EndActivity" uniqueName="WorkflowEnd_1" waitSetting="0" width="106" x="999" y="325">

    <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot; /&gt;&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/inputs&gt;" />

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1600805842431" description="displays an informational message to the user" displayName="Prevent Copy" height="34" interactive="0" jobMode="0" name="InformationalMessage" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.InteractiveMessageActivity" uniqueName="InformationalMessage_4" waitSetting="0" width="157" x="322" y="106">

    <activitySchema>

      <inputs className="" defaultValue="" listType="0" name="inputs" type="" />

      <outputs name="outputs">

        <children className="java.lang.String" inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string" />

      </outputs>

    </activitySchema>

    <inputs val="&lt;inputs&gt;&lt;message&gt;Are you sure you want to Prevent Copy of these jobs on copies, Going foward Auxiliary Copy operations on this Storage Policy will skip these jobs?&lt;/message&gt;&lt;dialogType&gt;Popup&lt;/dialogType&gt;&lt;iconType&gt;Warning&lt;/iconType&gt;&lt;title&gt;Prevent Copy&lt;/title&gt;&lt;html&gt;false&lt;/html&gt;&lt;actions&gt;&lt;name&gt;Yes&lt;/name&gt;&lt;validateForm&gt;true&lt;/validateForm&gt;&lt;/actions&gt;&lt;actions&gt;&lt;name&gt;No&lt;/name&gt;&lt;validateForm&gt;true&lt;/validateForm&gt;&lt;/actions&gt;&lt;formProperties /&gt;&lt;/inputs&gt;" />

    <transition activity="CommServDBQuery_1" commented="0" displayName="Yes" originalStyle="" points="" sourceX="400" sourceY="123" status="0" style="defaultEdge" targetX="429" targetY="355" transitionIndex="0" x="0" y="0">

      <condition language="4" script="xpath:{/workflow/InformationalMessage_4/actionSelected} == &quot;Yes&quot;" />

    </transition>

    <transition activity="EndUserSession_3" commented="0" displayName="No" originalStyle="" points="" sourceX="400" sourceY="123" status="0" style="defaultEdge" targetX="746" targetY="340" transitionIndex="0" x="0" y="0">

      <condition language="4" script="xpath:{/workflow/InformationalMessage_4/actionSelected} != &quot;Yes&quot;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1600827845775" description="activity to execute code snippets in the selected language" displayName="Script" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_1" waitSetting="0" width="100" x="336" y="494">

    <inputs val="&lt;inputs&gt;&lt;script language=&quot;4&quot; script=&quot;String tempStr = &amp;#xD;&amp;#xA;&amp;quot;&amp;lt;style&amp;gt;&amp;quot; +&amp;#xD;&amp;#xA;&amp;quot;table, th, td { border: 1px solid black; border-collapse: collapse; font-family: \&amp;quot;Times New Roman\&amp;quot;, serif; } &amp;quot; + &amp;#xD;&amp;#xA;&amp;quot;th, td {width:200; padding: 10px; } &amp;quot; + &amp;#xD;&amp;#xA;&amp;quot;th {vertical-align: top; text-align: center; background-color: rgb(0, 204, 204);} &amp;quot; + &amp;#xD;&amp;#xA;&amp;quot;td {text-align: left;} &amp;quot; + &amp;#xD;&amp;#xA;&amp;quot;&amp;lt;/style&amp;gt;&amp;quot; ;  &amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;tempStr +=&amp;quot;&amp;lt;table&amp;gt;&amp;quot; + &amp;#xD;&amp;#xA;&amp;quot;&amp;lt;tbody&amp;gt;&amp;quot; +&amp;#xD;&amp;#xA;&amp;quot;&amp;lt;tr&amp;gt;&amp;quot; +&amp;#xD;&amp;#xA;&amp;quot;&amp;lt;th&amp;gt;Storage Policy&amp;lt;/th&amp;gt;&amp;quot; +&amp;#xD;&amp;#xA;&amp;quot;&amp;lt;th&amp;gt;Copy&amp;lt;/th&amp;gt;&amp;quot; +&amp;#xD;&amp;#xA;&amp;quot;&amp;lt;th&amp;gt;Failure Message&amp;lt;/th&amp;gt;&amp;quot; +&amp;#xD;&amp;#xA;&amp;quot;&amp;lt;/tr&amp;gt;&amp;quot; +&amp;#xD;&amp;#xA;xpath:{/workflow/CommServDBQuery_1/resultSets/row/col[1]} +&amp;#xD;&amp;#xA;&amp;quot;&amp;lt;/tbody&amp;gt;&amp;quot; +&amp;#xD;&amp;#xA;&amp;quot;&amp;lt;/table&amp;gt;&amp;quot;;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;CopiesStatusHtmlStr&amp;quot;, tempStr);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;logger.info(tempStr);&quot; /&gt;&lt;/inputs&gt;" />

    <transition activity="InformationalMessage_5" commented="0" originalStyle="" points="" sourceX="386" sourceY="563" status="0" style="defaultEdge" targetX="393" targetY="628" transitionIndex="0" x="0" y="0">

      <condition language="4" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1600827884384" description="displays an informational message to the user" displayName="InformationalMessage" height="34" interactive="0" jobMode="0" name="InformationalMessage" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.InteractiveMessageActivity" uniqueName="InformationalMessage_5" waitSetting="0" width="157" x="326" y="569">

    <activitySchema>

      <inputs className="" defaultValue="" listType="0" name="inputs" type="" />

      <outputs name="outputs">

        <children className="java.lang.String" inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string" />

      </outputs>

    </activitySchema>

    <inputs val="&lt;inputs&gt;&lt;message&gt;xpath:{/workflow/variables/CopiesStatusHtmlStr}&lt;/message&gt;&lt;dialogType&gt;Popup&lt;/dialogType&gt;&lt;iconType&gt;Error&lt;/iconType&gt;&lt;title&gt;Prevent Copy Error&lt;/title&gt;&lt;html&gt;true&lt;/html&gt;&lt;formProperties /&gt;&lt;/inputs&gt;" />

    <transition activity="EndUserSession_3" commented="0" originalStyle="" points="" sourceX="404" sourceY="586" status="0" style="defaultEdge" targetX="713" targetY="344" transitionIndex="0" x="0" y="0">

      <condition language="4" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1600828828434" description="if/else based decision" displayName="Decision" height="100" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1" uniqueName="Decision_1" waitSetting="0" width="100" x="336" y="326">

    <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;(xpath:{/workflow/CommServDBQuery_1/resultSets/row/col[1]}).length() &amp;gt; 0&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

    <transition activity="Script_1" commented="0" displayName="Error Exist" originalStyle="" points="" sourceX="386" sourceY="468" status="0" style="defaultEdge" targetX="385" targetY="550" transitionIndex="0" value="True" x="0" y="0">

      <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

    <transition activity="EndUserSession_3" commented="0" displayName="No Error" originalStyle="" points="" sourceX="386" sourceY="376" status="0" style="defaultEdge" targetX="712" targetY="342" transitionIndex="0" value="False" x="0" y="0">

      <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1600829920676" description="ends the interactive user session" displayName="EndUserSession" height="34" interactive="0" jobMode="0" name="EndUserSession" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.InteractiveEndSessionActivity" uniqueName="EndUserSession_3" waitSetting="0" width="124" x="705" y="325">

    <inputs val="&lt;inputs /&gt;" />

    <transition activity="WorkflowEnd_1" commented="0" originalStyle="" points="" sourceX="767" sourceY="342" status="0" style="defaultEdge" targetX="929" targetY="351" transitionIndex="0" x="0" y="0">

      <condition language="4" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

</workflow>'

IF not exists (select * from WF_Definition where Name = @name)

BEGIN
	INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision, uniqueGuid)


	VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision, @guid)

	SET @workflowId = @@IDENTITY
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


	VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

	SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = revision From WF_Definition WHERE Name = @name

	IF (@currentRevision <> @revision)

	BEGIN

		SET @version = @version + 1

		UPDATE WF_Definition

		SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision, uniqueGuid = @guid, flags = @flags

		WHERE Name = @name
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


		VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

	END

	ELSE

	BEGIN

		UPDATE WF_Definition

		SET flags = @flags

		WHERE Name = @name	

	END	

END
