

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_PlannedFailover.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER OFF

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @guid nvarchar(256)

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.1.2.30 $'

SET @name = 'PlannedFailover'

SET @description = 'Fail over workflow to bring destination VMs online from latest Sync job'

SET @version = 1

SET @flags = 22

SET @guid = '227ee9fe-3465-425c-85f0-fdd2c49c1577'

SET @definition = '<workflow apiMode="0" config="&lt;configuration /&gt;" description="Fail over workflow to bring destination VMs online from latest Sync job" inputs="&lt;inputs&gt;&lt;replicationInfo class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;initiatedFromMonitor class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; /&gt;&lt;jobId class=&quot;java.lang.Long&quot; _list_=&quot;false&quot;&gt;0&lt;/jobId&gt;&lt;vappId class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; /&gt;&lt;version class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;2&lt;/version&gt;&lt;/inputs&gt;" interactive="0" isHtmlDescription="0" name="PlannedFailover" outputs="&lt;outputs /&gt;" revision="$Revision: 1.1.2.30 $" uniqueGuid="8192ad9c-b9c3-44d3-b0e6-ea193f6984d8" variables="&lt;variables /&gt;" webHidden="0" workflowId="50">

  <schema>

    <inputs className="" name="inputs" type="">

      <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="replicationInfo" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

      <children attribute="0" className="java.lang.Integer" controlType="0" defaultValue="" displayName="" hidden="0" inputType="java.lang.Integer" listType="0" name="initiatedFromMonitor" type="{http://www.w3.org/2001/XMLSchema}integer" />

      <children attribute="0" className="java.lang.Long" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Long" listType="0" name="jobId" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}long" />

      <children attribute="0" className="java.lang.Integer" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Integer" listType="0" name="vappId" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}integer" />

      <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="version" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

    </inputs>

    <variables className="" name="variables" type="" />

    <outputs className="" name="outputs" type="" />

    <config className="" name="" type="" />

  </schema>

  <Start commented="0" continueOnFailure="0" created="0" description="" displayName="Start" height="36" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="0" style="image;image=/images/jgraphx/house.png" uniqueName="Start_1" waitSetting="0" width="55" x="45" y="101">

    <inputs val="&lt;inputs /&gt;" />

    <transition activity="DRApproval_2" commented="0" originalStyle="" points="" sourceX="72" sourceY="119" status="0" style="defaultEdge" targetX="166" targetY="122" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Start>

  <Activity commented="0" continueOnFailure="1" created="1497732793640" description="Execute a command on a remote machine" displayName="Orchestration" height="36" interactive="0" jobMode="0" maxRestarts="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.ExecuteCommand;gradientColor=#CCCCCC;shadow=0" uniqueName="ExecuteCommand_VSDR_ENDPOINT" waitSetting="0" width="116" x="134" y="272">

    <inputs val="&lt;inputs&gt;&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;&gt;&lt;clientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;clientId class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; /&gt;&lt;clientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;hostName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;clientGUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;displayName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;commCellName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;csGUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;type class=&quot;commvault.msgs.CvEntities.CommCellType&quot; _list_=&quot;false&quot; /&gt;&lt;flags class=&quot;commvault.msgs.CvEntities.EntityFlags&quot; _list_=&quot;false&quot; /&gt;&lt;GUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;newName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/client&gt;&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; /&gt;&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;CVvsdr.exe&lt;/command&gt;&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;-j xpath:{/workflow/system/jobId} -cn xpath:{/workflow/system/commCellName} -vm xpath:{/workflow/CommServDBQuery_2/resultSets/row/col[@name=&quot;Instance&quot;]} -u xpath:{/workflow/system/executor/userId} -d 1 &lt;/arguments&gt;&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/waitForProcessCompletion&gt;&lt;/inputs&gt;" />

    <transition activity="CommServDBQuery_GetJobDetails" commented="0" originalStyle="" points="" sourceX="194" sourceY="120" status="0" style="defaultEdge" targetX="194" targetY="171" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1501795003623" description="executes a set of activities when the workflow completes" displayName="OnWorkflowComplete" height="536" interactive="0" jobMode="0" name="OnWorkflowComplete" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="swimlane" uniqueName="OnWorkflowComplete_1" waitSetting="0" width="381" x="451" y="65">

    <activitySchema>

      <inputs className="" defaultValue="" listType="0" name="inputs" type="" />

      <outputs className="" defaultValue="" listType="0" name="outputs" type="" />

    </activitySchema>

    <inputs val="&lt;inputs&gt;&lt;inputs /&gt;&lt;/inputs&gt;" />

    <superProcess>

      <Start commented="0" continueOnFailure="0" created="1501795003623" description="" displayName="Start" height="29" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="0" style="label;fillColor=#FFFF33;gradientColor=#FFFF00" uniqueName="Start_2" waitSetting="0" width="69" x="47" y="38">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="CommServDBQuery_1" commented="0" originalStyle="" points="" sourceX="60" sourceY="54" status="0" style="defaultEdge" targetX="79" targetY="113" transitionIndex="0" x="0" y="0">

          <condition language="1" script="xpath:{/workflow/DRApproval_2/workflow/variables/approved}==1;&#xA;/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

        <transition activity="WorkflowEnd_9" commented="0" originalStyle="" points="143.0,49.0" sourceX="81" sourceY="52" status="0" style="defaultEdge" targetX="220" targetY="49" transitionIndex="0" x="0" y="0">

          <condition language="1" script="xpath:{/workflow/DRApproval_2/workflow/variables/approved}==0;&#xA;/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Start>

      <Activity commented="0" continueOnFailure="0" created="1501795213782" description="executes queries against a commcell database" displayName="Process Results" height="45" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_1" waitSetting="0" width="124" x="22" y="93">

        <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;&amp;#xD;&#xD;&#xA;-- Update the pending replication jobs&amp;#xD;&#xD;&#xA;update APP_VSAReplication set failoverstatus = 4 where failoverstatus =2 and replicationId in (select distinct replicationId from App_VirtualAppJobStats(NOLOCK) where replicationId &amp;lt;&amp;gt; 0 and jobId=xpath:{/workflow/system/jobId})&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;--Get the status and the error details&amp;#xD;&#xD;&#xA;select status, details from App_VirtualAppJobStats (NOLOCK) where phase = 26 and jobId =xpath:{/workflow/system/jobId}&lt;/query&gt;&lt;/inputs&gt;" />

        <transition activity="Decision_5" commented="0" originalStyle="" points="" sourceX="76" sourceY="110" status="0" style="defaultEdge" targetX="74" targetY="215" transitionIndex="0" x="-316" y="-70">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1501795326263" description="if/else based decision" displayName="Check Failures" height="100" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1" uniqueName="Decision_3" waitSetting="0" width="114" x="237" y="156">

        <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;(xpath:{/workflow/CommServDBQuery_1/resultSets/row/col[@name=&quot;status&quot;]}==1)&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

        <transition activity="Decision_4" commented="0" displayName="No" originalStyle="" points="294.0,249.0" sourceX="69" sourceY="206" status="0" style="defaultEdge" targetX="207" targetY="205" transitionIndex="0" value="false" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

        <transition activity="WorkflowEnd_4" commented="0" displayName="CVvsdr failure" originalStyle="" points="" sourceX="294" sourceY="206" status="0" style="defaultEdge" targetX="299" targetY="74" transitionIndex="0" value="true" x="-316" y="-70">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1501795356567" description="Ends the workflow" displayName="Failed" height="26" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.EndActivity" uniqueName="WorkflowEnd_4" waitSetting="0" width="99" x="246" y="93">

        <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;&gt;FAILED&lt;/completionStatus&gt;&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/XPathQuery_GetVirtualAppPhaseInfoErrors/result}&lt;/failureMessage&gt;&lt;/inputs&gt;" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1501795397429" description="if/else based decision" displayName="Check Success" height="100" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1" uniqueName="Decision_4" waitSetting="0" width="119" x="233" y="293">

        <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/CommServDBQuery_1/resultSets/row/col[@name=&quot;status&quot;]}==0&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

        <transition activity="WorkflowEnd_6" commented="0" originalStyle="" points="290.0,410.0" sourceX="207" sourceY="205" status="0" style="defaultEdge" targetX="209" targetY="102" transitionIndex="0" value="true" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

        <transition activity="WorkflowEnd_5" commented="0" displayName="Completed with Errors" offsetX="-43" offsetY="12" originalStyle="" points="163.0,344.0" sourceX="207" sourceY="205" status="0" style="defaultEdge" targetX="213" targetY="300" transitionIndex="0" value="false" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1501795431272" description="Ends the workflow" displayName="COE" height="34" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.EndActivity" uniqueName="WorkflowEnd_5" waitSetting="0" width="106" x="76" y="421">

        <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;&gt;COMPLETED_WITH_ERRORS&lt;/completionStatus&gt;&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/XPathQuery_GetVirtualAppPhaseInfoErrors/result}&lt;/failureMessage&gt;&lt;/inputs&gt;" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1501795526046" description="Ends the workflow" displayName="Success" height="26" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.EndActivity" uniqueName="WorkflowEnd_6" waitSetting="0" width="109" x="221" y="429">

        <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot; /&gt;&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/inputs&gt;" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1502214973872" description="if/else based decision" displayName="Check Finalize" height="100" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1" uniqueName="Decision_5" waitSetting="0" width="111" x="19" y="165">

        <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/CommServDBQuery_1/resultSets/rowCount}&amp;gt;0&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

        <transition activity="WorkflowEnd_7" commented="0" displayName="Finalize not set" originalStyle="" points="" sourceX="74" sourceY="215" status="0" style="defaultEdge" targetX="73" targetY="327" transitionIndex="0" value="false" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

        <transition activity="XPathQuery_GetVirtualAppPhaseInfoErrors" commented="0" displayName="Finalize set" offsetX="17" offsetY="-26" originalStyle="" points="171.0,214.0" sourceX="74" sourceY="215" status="0" style="defaultEdge" targetX="183" targetY="144" transitionIndex="0" value="true" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1502215185549" description="Ends the workflow" displayName="WorkflowEnd" height="34" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.EndActivity" uniqueName="WorkflowEnd_7" waitSetting="0" width="106" x="17" y="328">

        <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;&gt;FAILED&lt;/completionStatus&gt;&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/inputs&gt;" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1502215978081" description="retrieves a list of values from xml" displayName="Get Failures" height="34" interactive="0" jobMode="0" name="XPathQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.XMLQueryActivity" uniqueName="XPathQuery_GetVirtualAppPhaseInfoErrors" waitSetting="0" width="106" x="122" y="242">

        <inputs val="&lt;inputs&gt;&lt;xml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/CommServDBQuery_1/resultSets/row/col[@name=&quot;details&quot;]}&lt;/xml&gt;&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;Api_VirtualAppPhaseInfo/job/errors/@val&lt;/xpath&gt;&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;&gt;String&lt;/outputType&gt;&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/outputAsList&gt;&lt;/inputs&gt;" />

        <transition activity="Decision_3" commented="0" originalStyle="" points="206.0,208.0" sourceX="175" sourceY="259" status="0" style="defaultEdge" targetX="242" targetY="198" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1503434678653" description="Ends the workflow" displayName="Failed" height="34" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.EndActivity" uniqueName="WorkflowEnd_9" waitSetting="0" width="106" x="169" y="37">

        <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;&gt;FAILED&lt;/completionStatus&gt;&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/inputs&gt;" />

      </Activity>

    </superProcess>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1501875218663" description="activity to execute code snippets in the selected language" displayName="VSDR" height="32" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_1" waitSetting="0" width="117" x="128" y="478">

    <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot; import commvault.cte.workflow.activities.cmd.operation.OperationExecute;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;    boolean failure  = xpath:{/workflow/ExecuteCommand_VSDR_ENDPOINT/commandOutput}.equals(&amp;quot;CVSDR_FINALIZE_FAILURE&amp;quot;);&amp;#xD;&amp;#xA;    boolean finalizeSet = false;&amp;#xD;&amp;#xA;    String commandOutput = &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;    String processName = &amp;quot;CVvsdr.exe&amp;quot;;&amp;#xD;&amp;#xA;    int POLL_INTERVAL_PROCESS_STATUS_CHECK = 1000* 10;&amp;#xD;&amp;#xA;    int MAX_RETRY_COUNT_PROCESS_STATUS_CHECK = 3;&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    qexecute(xml){&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        // Qoperation execute with xml as input&amp;#xD;&amp;#xA;        OperationExecute exec = new OperationExecute();&amp;#xD;&amp;#xA;        exec.inputXml = xml;&amp;#xD;&amp;#xA;        exec.commandArgs = &amp;quot; -tk &amp;quot;+workflow.getCurrentUserToken();&amp;#xD;&amp;#xA;        exec.execute(workflow);&amp;#xD;&amp;#xA;        commandOutput = exec.outputXml;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    int iter = 0;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;    // If the Orchestration activity returned an error&amp;#xD;&amp;#xA;    if(xpath:{/workflow/ExecuteCommand_VSDR_ENDPOINT/exitCode}!=0 || xpath:{/workflow/ExecuteCommand_VSDR_ENDPOINT/errorCode}!=0)&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        while(!failure)&amp;#xD;&amp;#xA;        {   &amp;#xD;&amp;#xA;            query = &amp;quot;select status from App_VirtualAppJobStats(NOLOCK) where phase = 26 and jobId =&amp;quot;+xpath:{/workflow/system/jobId}.toString();&amp;#xD;&amp;#xA;            DataSet rs = csdb.execute(query);&amp;#xD;&amp;#xA;            &amp;#xD;&amp;#xA;            if(rs.hasNext()) // This indicates the finalize phase has been recorded in csdb for vsdr job so we quit waiting&amp;#xD;&amp;#xA;            {&amp;#xD;&amp;#xA;                finalizeSet= true;&amp;#xD;&amp;#xA;                break;&amp;#xD;&amp;#xA;            }&amp;#xD;&amp;#xA;             &amp;#xD;&amp;#xA;            // Indicates that the timeout of 1 minute has expired,    &amp;#xD;&amp;#xA;            if(iter == 2)&amp;#xD;&amp;#xA;            {    logger.info(&amp;quot;Timeout reached. Exiting first round of checks&amp;quot;);&amp;#xD;&amp;#xA;                 break;&amp;#xD;&amp;#xA;            }&amp;#xD;&amp;#xA;            &amp;#xD;&amp;#xA;            logger.info(&amp;quot;Finalize phase not set for vsdr job. Checking again after 30 seconds&amp;quot;);&amp;#xD;&amp;#xA;            &amp;#xD;&amp;#xA;            // Reset the possible connection failure error on JPR&amp;#xD;&amp;#xA;            updateJPRQuery = &amp;quot;update JMJobInfo set failureReason = '''', lastStateChangeTime = dbo.GetUnixTime(GETUTCDATE()) * 2147483648, percentcomplete = 50 where jobId =&amp;quot;+xpath:{/workflow/system/jobId};&amp;#xD;&amp;#xA;            csdb.execute(updateJPRQuery);&amp;#xD;&amp;#xA;            &amp;#xD;&amp;#xA;            // Check the status every half a min&amp;#xD;&amp;#xA;            Thread.sleep(1000*30);&amp;#xD;&amp;#xA;            iter++;&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        // If PID is valid&amp;#xD;&amp;#xA;        if(xpath:{/workflow/XPathQuery_GetPID/result}!=null &amp;amp;&amp;amp; !xpath:{/workflow/XPathQuery_GetPID/result}.equals(&amp;quot;&amp;quot;))&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;            processID = xpath:{/workflow/XPathQuery_GetPID/result};&amp;#xD;&amp;#xA;            &amp;#xD;&amp;#xA;            pidcheckXML = &amp;quot;&amp;lt;App_ExecuteCommandReq arguments=\&amp;quot;\&amp;quot; command=\&amp;quot;tasklist /fi &amp;amp;quot;pid eq &amp;quot;+processID+&amp;quot;&amp;amp;quot; /fo CSV /NH\&amp;quot; startupPath=\&amp;quot;\&amp;quot; waitForProcessCompletion=\&amp;quot;1\&amp;quot;&amp;gt;&amp;lt;client _type_=\&amp;quot;3\&amp;quot; clientName=\&amp;quot;&amp;quot;+xpath:{/workflow/system/commCellName}.toString()+&amp;quot;\&amp;quot; hostName=\&amp;quot;&amp;quot;+xpath:{/workflow/system/commCellHost}.toString()+&amp;quot;\&amp;quot;/&amp;gt;&amp;lt;/App_ExecuteCommandReq&amp;gt;&amp;quot;;&amp;#xD;&amp;#xA;            &amp;#xD;&amp;#xA;            int retryCount = 0;&amp;#xD;&amp;#xA;            while(true)&amp;#xD;&amp;#xA;            {&amp;#xD;&amp;#xA;                qexecute(pidcheckXML);&amp;#xD;&amp;#xA;                &amp;#xD;&amp;#xA;                if(commandOutput == null || commandOutput.equals(&amp;quot;&amp;quot;))&amp;#xD;&amp;#xA;                {&amp;#xD;&amp;#xA;                    logger.info(&amp;quot;Bad response [QSDK server]. Check WorkflowEngine.log&amp;quot;);&amp;#xD;&amp;#xA;                    &amp;#xD;&amp;#xA;                    if(retryCount&amp;gt;MAX_RETRY_COUNT_PROCESS_STATUS_CHECK)&amp;#xD;&amp;#xA;                        break;&amp;#xD;&amp;#xA;                   &amp;#xD;&amp;#xA;                   Thread.sleep(POLL_INTERVAL_PROCESS_STATUS_CHECK);&amp;#xD;&amp;#xA;                   &amp;#xD;&amp;#xA;                   retryCount++;&amp;#xD;&amp;#xA;            &amp;#xD;&amp;#xA;                   continue;&amp;#xD;&amp;#xA;                }&amp;#xD;&amp;#xA;                &amp;#xD;&amp;#xA;                String output = commandOutput.substring(commandOutput.indexOf(&amp;quot;&amp;lt;commandLineOutput&amp;gt;&amp;quot;),commandOutput.indexOf(&amp;quot;&amp;lt;/commandLineOutput&amp;gt;&amp;quot;));&amp;#xD;&amp;#xA;                &amp;#xD;&amp;#xA;                if(output.split(&amp;quot;,&amp;quot;)!=null &amp;amp;&amp;amp; output.split(&amp;quot;,&amp;quot;)[0].contains(processName))&amp;#xD;&amp;#xA;                {&amp;#xD;&amp;#xA;                    logger.info(processName +&amp;quot; [RUNNING]&amp;quot;);&amp;#xD;&amp;#xA;                    retryCount = 0; // reset Counter&amp;#xD;&amp;#xA;                }&amp;#xD;&amp;#xA;                else&amp;#xD;&amp;#xA;                {&amp;#xD;&amp;#xA;                    logger.info(processName +&amp;quot; is not reachable OR running&amp;quot;);&amp;#xD;&amp;#xA;                    retryCount++;&amp;#xD;&amp;#xA;                    &amp;#xD;&amp;#xA;                    if(retryCount &amp;gt; MAX_RETRY_COUNT_PROCESS_STATUS_CHECK)&amp;#xD;&amp;#xA;                        break;&amp;#xD;&amp;#xA;                }&amp;#xD;&amp;#xA;                Thread.sleep(POLL_INTERVAL_PROCESS_STATUS_CHECK);&amp;#xD;&amp;#xA;                &amp;#xD;&amp;#xA;            }// End while&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;         } // End if&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;&quot; /&gt;&lt;/inputs&gt;" />

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1502664335336" description="executes queries against a commcell database" displayName="Get Job Details" height="30" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_GetJobDetails" waitSetting="0" width="117" x="130" y="336">

    <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;--Get the status and the error details&amp;#xD;&#xD;&#xA;select details from App_VirtualAppJobStats (NOLOCK) where phase = 13 and jobId =xpath:{/workflow/system/jobId}&lt;/query&gt;&lt;/inputs&gt;" />

    <transition activity="XPathQuery_GetPID" commented="0" originalStyle="" points="" sourceX="191" sourceY="169" status="0" style="defaultEdge" targetX="193" targetY="219" transitionIndex="0" x="0" y="0">

      <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1502664386928" description="retrieves a list of values from xml" displayName="Get Process ID" height="35" interactive="0" jobMode="0" name="XPathQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.XMLQueryActivity" uniqueName="XPathQuery_GetPID" waitSetting="0" width="120" x="128" y="398">

    <inputs val="&lt;inputs&gt;&lt;xml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/CommServDBQuery_GetJobDetails/resultSets/row/col[@name=&quot;details&quot;]}&lt;/xml&gt;&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;Api_VirtualAppPhaseInfo/job/@processID&lt;/xpath&gt;&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;&gt;String&lt;/outputType&gt;&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/outputAsList&gt;&lt;/inputs&gt;" />

    <transition activity="Script_1" commented="0" displayName="On loss of control safety mechanism" originalStyle="" points="" sourceX="194" sourceY="120" status="0" style="defaultEdge" targetX="192" targetY="175" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1503288313988" description="if/else based decision" displayName="is Approval?" height="100" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1" uniqueName="Decision_6" waitSetting="0" width="100" x="262" y="71">

    <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/DRApproval_2/workflow/variables/approved}==1&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

    <transition activity="WorkflowEnd_8" commented="0" originalStyle="" points="" sourceX="312" sourceY="121" status="0" style="defaultEdge" targetX="373" targetY="209" transitionIndex="0" value="false" x="0" y="0">

      <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

    <transition activity="CommServDBQuery_2" commented="0" originalStyle="" points="308.0,186.0" sourceX="312" sourceY="121" status="0" style="defaultEdge" targetX="222" targetY="215" transitionIndex="0" value="true" x="0" y="0">

      <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1503288507762" description="Ends the workflow" displayName="Failed" height="34" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.EndActivity" uniqueName="WorkflowEnd_8" waitSetting="0" width="106" x="320" y="192">

    <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;&gt;FAILED&lt;/completionStatus&gt;&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;Approval Denied for the Planned Failover operation&lt;/failureMessage&gt;&lt;/inputs&gt;" />

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1503291043327" description="" displayName="DRApproval" height="34" interactive="0" jobMode="0" name="DRApproval" namespaceUri="commvault.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.ExecuteWorkflow" uniqueName="DRApproval_2" waitSetting="0" width="100" x="127" y="104">

    <inputs val="&lt;inputs&gt;&lt;vappId class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/inputs/vappId}&lt;/vappId&gt;&lt;jobId class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/inputs/jobId}&lt;/jobId&gt;&lt;Action class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;Planned Failover&lt;/Action&gt;&lt;/inputs&gt;" />

    <transition activity="Decision_6" commented="0" originalStyle="" points="" sourceX="177" sourceY="121" status="0" style="defaultEdge" targetX="319" targetY="114" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1503329875822" description="executes queries against a commcell database" displayName="CS Instance" height="34" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_2" waitSetting="0" width="143" x="120" y="207">

    <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;select attrval as Instance from app_clientprop prop&amp;#xD;&#xD;&#xA;inner join app_commcell c&amp;#xD;&#xD;&#xA;on prop.componentNameId = c.clientId&amp;#xD;&#xD;&#xA;and c.id =2&amp;#xD;&#xD;&#xA;and prop.attrname = ''Galaxy Instance name''&amp;#xD;&#xD;&#xA;and prop.modified=0&lt;/query&gt;&lt;/inputs&gt;" />

    <transition activity="ExecuteCommand_VSDR_ENDPOINT" commented="0" originalStyle="" points="" sourceX="191" sourceY="224" status="0" style="defaultEdge" targetX="194" targetY="290" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

</workflow>'

IF not exists (select * from WF_Definition where Name = @name)

BEGIN
	INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision, uniqueGuid)


	VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision, @guid)

	SET @workflowId = @@IDENTITY
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


	VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

	SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = revision From WF_Definition WHERE Name = @name

	-- IF (@currentFlags & 4 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0) AND (@currentRevision <> @revision)

	BEGIN

		SET @version = @version + 1

		UPDATE WF_Definition

		SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision, uniqueGuid = @guid

		WHERE Name = @name

		IF (@flags & 8 > 0 OR @flags & 16 > 0)

		BEGIN

			UPDATE WF_Definition

			SET flags = @flags

			WHERE Name = @name

		END
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


		VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

	END

END
