

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_OracleRDStoAzureMigration.script] ---------- 


SET QUOTED_IDENTIFIER OFF

/*

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/WFD_OracleRDStoAzureMigration.script,v $ $Id: WFD_OracleRDStoAzureMigration.script,v 1.1.4.4 2020/10/04 00:52:13 abilbrey Exp $";
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

*/

-- SET QUOTED_IDENTIFIER ON

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int = NULL

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.1.4.4 $'

SET @name = 'OracleRDStoAzureMigration'

SET @description = 'A workflow to migrate schemas from Amazon RDS Instace to Oracle Instance running on Azure'

SET @version = 1

SET @flags = 6

SET @definition = '<Workflow apiMode="0" config="&lt;configuration />"

    description="A workflow to migrate schemas from Amazon RDS Instance to Oracle Instance running on Azure"

    inputs="&lt;inputs>&lt;RDSInstanceName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;RDSUsername class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;RDSPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; />&lt;AzureClient class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>&lt;clientName />&lt;clientId />&lt;/AzureClient>&lt;AzureInstanceName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;AzureStagingLocation class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/inputs>"

    interactive="0" isHtmlDescription="0"

    name="OracleRDStoAzureMigration" outputs="&lt;outputs />"

    revision="$Revision: 1.1.4.4 $"

    uniqueGuid="035ea09a-c145-4760-817a-787b4f4a766d"

    variables="&lt;variables>&lt;AzurePlatform class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;AzureCvInstallDir class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;migrateCmd class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;rdspasswordplaintext class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/RDSPassword}.getPlainText()&lt;/rdspasswordplaintext>&lt;/variables>"

    webHidden="0">

    <schema>

        <outputs className="" name="outputs" type=""/>

        <variables attribute="0" className="" name="variables" type="">

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="AzurePlatform" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="AzureCvInstallDir" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="migrateCmd" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="rdspasswordplaintext" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

        </variables>

        <inputs attribute="0" className="" name="inputs" type="">

            <children alignment="0" attribute="0"

                className="java.lang.String" controlHidden="0"

                controlType="0" defaultValue=""

                displayName="RDS Instance Name"

                documentation="TNS Entry for RDS instance from EC2"

                hidden="0" inputType="java.lang.String" listType="0"

                maximumValue="" minimumValue="" name="RDSInstanceName"

                readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children alignment="0" attribute="0"

                className="java.lang.String" controlHidden="0"

                controlType="0" defaultValue=""

                displayName="RDS Database Username"

                documentation="Username for RDS instance with DBA access"

                hidden="0" inputType="java.lang.String" listType="0"

                maximumValue="" minimumValue="" name="RDSUsername"

                readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children alignment="0" attribute="0"

                className="workflow.types.EncryptedString"

                controlHidden="0" controlType="0" defaultValue=""

                displayName="RDS Database Password"

                documentation="RDS Database Password" hidden="0"

                inputType="workflow.types.EncryptedString" listType="0"

                maximumValue="" minimumValue="" name="RDSPassword"

                readOnly="0" required="1" searchable="0" type="{workflow.types}EncryptedString"/>

            <children attribute="0"

                className="commvault.msgs.CvEntities.ClientEntity"

                controlHidden="0" controlType="2" defaultValue=""

                displayName="Azure Client Name"

                documentation="Name of the Azure Client" hidden="0"

                inputType="commvault.msgs.CvEntities.ClientEntity"

                listType="0" maximumValue="" minimumValue=""

                name="AzureClient" readOnly="0" required="1"

                searchable="0" type="{commvault.msgs.CvEntities}ClientEntity">

                <children attribute="0" className="java.lang.String"

                    defaultValue="" inputType="java.lang.String"

                    listType="0" name="clientName" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children attribute="0" className="java.lang.Integer"

                    defaultValue="" inputType="java.lang.Integer"

                    listType="0" name="clientId" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            </children>

            <children alignment="0" attribute="0"

                className="java.lang.String" controlHidden="0"

                controlType="0" defaultValue=""

                displayName="Azure Staging Location"

                documentation="Staging location on Azure Compute Node"

                hidden="0" inputType="java.lang.String" listType="0"

                maximumValue="" minimumValue=""

                name="AzureStagingLocation" readOnly="0" required="1"

                searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children alignment="0" attribute="0"

                className="java.lang.String" controlHidden="0"

                controlType="0" defaultValue=""

                displayName="Azure Database Instance Name"

                documentation="Azure Database Instance Name" hidden="0"

                inputType="java.lang.String" listType="0"

                maximumValue="" minimumValue="" name="AzureInstanceName"

                readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

        </inputs>

        <config className="" name="configuration" type=""/>

    </schema>

    <Start commented="0" continueOnFailure="0" created="0"

        description="" displayName="Start" height="36" interactive="0"

        jobMode="0" name="Start" originalStyle="" skipAttempt="0"

        style="image;image=/images/jgraphx/house.png"

        uniqueName="Start_1" waitSetting="0" width="55" x="45" y="41">

        <inputs val="&lt;inputs />"/>

        <transition activity="ProcessBlock_1" commented="0"

            originalStyle="" points="" sourceX="72" sourceY="59"

            status="0" style="defaultEdge" targetX="987" targetY="87"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Start>

    <Activity commented="0" continueOnFailure="0"

        created="1500045731666"

        description="creates a super process group"

        displayName="Validation Block" height="423" interactive="0"

        jobMode="0" name="ProcessBlock"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ProcessBlock_1" waitSetting="0" width="298" x="166" y="159">

        <inputs val="&lt;inputs>&lt;inputs />&lt;/inputs>"/>

        <superProcess>

            <Start commented="0" continueOnFailure="0"

                created="1500045731666" description=""

                displayName="Start" height="30" interactive="0"

                jobMode="0" name="Start" originalStyle=""

                skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_2" waitSetting="0" width="120" x="60" y="34">

                <inputs val="&lt;inputs />"/>

                <transition activity="CommServDBQuery_1" commented="0"

                    originalStyle="" points="" sourceX="120"

                    sourceY="49" status="0" style="defaultEdge"

                    targetX="121" targetY="155" transitionIndex="0"

                    x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity commented="0" continueOnFailure="0"

                created="1500045959859" description="Ends the workflow"

                displayName="WorkflowEnd" height="34" interactive="0"

                jobMode="0" name="WorkflowEnd"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.EndActivity"

                uniqueName="WorkflowEnd_4" waitSetting="0" width="106"

                x="16" y="381">

                <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;>FAILED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>Non-Linux OS detected in Azure Client&lt;/failureMessage>&lt;/inputs>"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1500051886569"

                description="executes queries against a commcell database"

                displayName="Get Azure OS Details" height="34"

                interactive="0" jobMode="0" name="CommServDBQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.CommServDBQuery"

                uniqueName="CommServDBQuery_1" waitSetting="0"

                width="147" x="48" y="138">

                <inputs val="&lt;inputs>&lt;commCell />&lt;query>DECLARE @plt NVARCHAR(MAX)&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;set @plt = (select platformType from app_platform with(NOLOCK) where platformType &amp;lt;&amp;gt; 2 and clientId = xpath:{/workflow/inputs/AzureClient/clientId})&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;select @plt as AzurePlatformType&lt;/query>&lt;/inputs>"/>

                <transition activity="Script_1" commented="0"

                    originalStyle="" points="" sourceX="121"

                    sourceY="155" status="0" style="defaultEdge"

                    targetX="99" targetY="229" transitionIndex="0" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1500051969610"

                description="activity to execute code snippets in the selected language"

                displayName="Set Azure Platform Type" height="34"

                interactive="0" jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.ScriptActivity"

                uniqueName="Script_1" waitSetting="0" width="167" x="16" y="212">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;if (xpath:{/workflow/CommServDBQuery_1/resultSets/row/col[@name=&amp;quot;AzurePlatformType&amp;quot;]}.equals(&amp;quot;4&amp;quot;)) &amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Detected Linux in source machine. Setting platform to Linux&amp;quot;);&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;AzurePlatform&amp;quot;, &amp;quot;Linux&amp;quot;);&amp;#xD;&amp;#xA;} &amp;#xD;&amp;#xA;else &amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Did not detect Linux. Setting platform to Unknown&amp;quot;);&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;AzurePlatform&amp;quot;, &amp;quot;Unknown&amp;quot;);&amp;#xD;&amp;#xA;}&quot; />&lt;/inputs>"/>

                <transition activity="Decision_1" commented="0"

                    originalStyle="" points="" sourceX="99"

                    sourceY="229" status="0" style="defaultEdge"

                    targetX="69" targetY="310" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1500052167103"

                description="if/else based decision"

                displayName="Is Linux" height="69" interactive="0"

                jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_1"

                waitSetting="0" width="100" x="19" y="276">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/AzurePlatform}.equals(&quot;Linux&quot;)&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="WorkflowEnd_4" commented="0"

                    displayName="No" originalStyle="" points=""

                    sourceX="104" sourceY="310" status="0"

                    style="defaultEdge" targetX="101" targetY="390"

                    transitionIndex="0" value="false" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="CommServDBQuery_2" commented="0"

                    displayName="Yes" originalStyle="" points=""

                    sourceX="69" sourceY="310" status="0"

                    style="defaultEdge" targetX="215" targetY="273"

                    transitionIndex="0" value="true" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1500052443188"

                description="executes queries against a commcell database"

                displayName="CV Install Dir" height="34" interactive="0"

                jobMode="0" name="CommServDBQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.CommServDBQuery"

                uniqueName="CommServDBQuery_2" waitSetting="0"

                width="143" x="144" y="256">

                <inputs val="&lt;inputs>&lt;commCell />&lt;query>-- Get the Commvault startup  directory on Client &amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;DECLARE @AzureInstallDir NVARCHAR(MAX)&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;SET @AzureInstallDir = (select install_dir from APP_Platform with(NOLOCK) where platformType = 4 and clientId=xpath:{/workflow/inputs/AzureClient/clientId})&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;SELECT @AzureInstallDir as AzureInstallDir&lt;/query>&lt;/inputs>"/>

                <transition activity="Script_2" commented="0"

                    originalStyle="" points="" sourceX="215"

                    sourceY="273" status="0" style="defaultEdge"

                    targetX="218" targetY="360" transitionIndex="0"

                    x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1500052667729"

                description="activity to execute code snippets in the selected language"

                displayName="Set Install Directory" height="34"

                interactive="0" jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.ScriptActivity"

                uniqueName="Script_2" waitSetting="0" width="141"

                x="148" y="343">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;logger.info(&amp;quot;Setting CV Installation Directories for Source and Target Proxies...&amp;quot;);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;AzureCvInstallDir&amp;quot;, &amp;quot;/opt/commvault/Base/CvOracleTools/dist&amp;quot;);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;rdspasswordplaintext&amp;quot;, xpath:{/workflow/inputs/RDSPassword}.getPlainText());&quot; />&lt;/inputs>"/>

            </Activity>

        </superProcess>

        <activitySchema>

            <outputs className="" defaultValue="" listType="0"

                name="outputs" type=""/>

            <inputs className="" defaultValue="" listType="0"

                name="inputs" type=""/>

        </activitySchema>

        <transition activity="ProcessBlock_2" commented="0"

            originalStyle="" points="" sourceX="315" sourceY="370"

            status="0" style="defaultEdge" targetX="793" targetY="370"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1500045765752"

        description="creates a super process group"

        displayName="Export Block" height="421" interactive="0"

        jobMode="0" name="ProcessBlock"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ProcessBlock_2" waitSetting="0" width="293" x="647" y="160">

        <inputs val="&lt;inputs>&lt;inputs />&lt;/inputs>"/>

        <superProcess>

            <Start commented="0" continueOnFailure="0"

                created="1500045765752" description=""

                displayName="Start" height="30" interactive="0"

                jobMode="0" name="Start" originalStyle=""

                skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_3" waitSetting="0" width="120" x="66" y="33">

                <inputs val="&lt;inputs />"/>

                <transition activity="ExecuteScript_1" commented="0"

                    originalStyle="" points="" sourceX="126"

                    sourceY="48" status="0" style="defaultEdge"

                    targetX="131" targetY="205" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity commented="0" continueOnFailure="0"

                created="1499986372640" description="Ends the workflow"

                displayName="WorkflowEnd" height="34" interactive="0"

                jobMode="0" name="WorkflowEnd"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.EndActivity"

                uniqueName="WorkflowEnd_2" waitSetting="0" width="106"

                x="70" y="296">

                <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;>FAILED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/inputs>"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1499986198199"

                description="Execute a script on a remote machine"

                displayName="Export RDS Data" height="34"

                interactive="0" jobMode="0" name="ExecuteScript"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.ExecuteScript"

                uniqueName="ExecuteScript_1" waitSetting="0" width="123"

                x="63" y="193">

                <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/AzureClient/clientName}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;scriptType class=&quot;commvault.msgs.App.ScriptType&quot; _list_=&quot;false&quot;>UnixShell&lt;/scriptType>&lt;script class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>su oracle &amp;lt;&amp;lt;EOF&amp;#xD;&#xd;&#xa;cd xpath:{/workflow/variables/AzureCvInstallDir}&amp;#xD;&#xd;&#xa;./migrate -d xpath:{/workflow/inputs/AzureInstanceName} -ru xpath:{/workflow/inputs/RDSUsername} -rp xpath:{/workflow/variables/rdspasswordplaintext} -rd xpath:{/workflow/inputs/RDSInstanceName}  -l xpath:{/workflow/inputs/AzureStagingLocation} -m crosscloud&amp;#xD;&#xd;&#xa;EOF&lt;/script>&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

                <transition activity="WorkflowEnd_2" commented="0"

                    originalStyle="" points="" sourceX="140"

                    sourceY="106" status="0" style="defaultEdge"

                    targetX="147" targetY="342" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

        </superProcess>

        <activitySchema>

            <outputs className="" defaultValue="" listType="0"

                name="outputs" type=""/>

            <inputs className="" defaultValue="" listType="0"

                name="inputs" type=""/>

        </activitySchema>

        <transition activity="WorkflowEnd_5" commented="0"

            originalStyle="" points="" sourceX="529" sourceY="367"

            status="0" style="defaultEdge" targetX="1539" targetY="375"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1500045977230" description="Ends the workflow"

        displayName="WorkflowEnd" height="34" interactive="0"

        jobMode="0" name="WorkflowEnd"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.EndActivity"

        uniqueName="WorkflowEnd_5" waitSetting="0" width="106" x="1040" y="354">

        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;>COMPLETED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/inputs>"/>

    </Activity>

    <formProperties css="" formVersion="0" javaScript=""/>

</Workflow>'

SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = ISNULL(revision, '') From WF_Definition WHERE Name = @name

IF (@workflowId IS NULL)

BEGIN
    INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision)


    VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision)

    SET @workflowId = @@IDENTITY
    INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


    VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

    IF (@currentFlags & 4 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0) AND (@currentRevision <> @revision)

    BEGIN

        SET @version = @version + 1

        UPDATE WF_Definition

        SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision

        WHERE Name = @name

        IF (@flags & 8 > 0 OR @flags & 16 > 0)

        BEGIN

            UPDATE WF_Definition

            SET flags = @flags

            WHERE Name = @name

        END
        INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


        VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

    END

END

