

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_NewUserSignup.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/WFD_NewUserSignup.script,v $ $Id: WFD_NewUserSignup.script,v 1.6.2.2 2016/06/14 05:49:48 mrkumar Exp $";
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER OFF

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.6.2.2 $'

SET @name = 'New User Signup'

SET @description = 'creates user and groups for webconsole registrations'

SET @version = 1

SET @flags = 6

SET @definition = '<workflow apiMode="0"

    description="creates user and groups for webconsole registrations"

    inputs="&lt;inputs>&lt;userName class=&quot;java.lang.String&quot; />&lt;userEmail class=&quot;java.lang.String&quot; />&lt;companyName class=&quot;java.lang.String&quot; />&lt;userFullName class=&quot;java.lang.String&quot; />&lt;userType class=&quot;java.lang.Integer&quot; />&lt;userPassword class=&quot;workflow.types.EncryptedString&quot; />&lt;userDescription class=&quot;java.lang.String&quot; />&lt;/inputs>"

    interactive="0" isHtmlDescription="0" name="New User Signup"

    outputs="&lt;outputs />" revision="$Revision: 1.6.2.2 $"

    uniqueGuid="e208cbac-3cfd-4e75-b802-fec457f49743"

    variables="&lt;variables>&lt;enableUser class=&quot;java.lang.Boolean&quot;>false&lt;/enableUser>&lt;userDescription class=&quot;java.lang.String&quot; />&lt;isCVEmail class=&quot;java.lang.Boolean&quot;>false&lt;/isCVEmail>&lt;referral class=&quot;java.lang.String&quot; />&lt;companyname class=&quot;java.lang.String&quot; />&lt;flags class=&quot;java.lang.Integer&quot; />&lt;permissions class=&quot;java.lang.Integer&quot; />&lt;newUser class=&quot;java.lang.Integer&quot;>0&lt;/newUser>&lt;CVAuthCode class=&quot;java.lang.String&quot; />&lt;adminEmail class=&quot;java.lang.String&quot; />&lt;/variables>" workflowId="0">

    <schema>

        <outputs className="" name="outputs" type=""/>

        <variables attribute="0" className="" listType="0"

            name="variables" required="1" type="">

            <children attribute="0" className="java.lang.Boolean"

                defaultValue="" hidden="0" inputType="java.lang.Boolean"

                listType="0" name="enableUser" required="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

            <children attribute="0" className="java.lang.String"

                defaultValue="" hidden="0" inputType="java.lang.String"

                listType="0" name="userDescription" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.Boolean"

                defaultValue="" hidden="0" inputType="java.lang.Boolean"

                listType="0" name="isCVEmail" required="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

            <children attribute="0" className="java.lang.String"

                defaultValue="" hidden="0" inputType="java.lang.String"

                listType="0" name="referral" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                defaultValue="" hidden="0" inputType="java.lang.String"

                listType="0" name="companyname" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.Integer"

                defaultValue="" hidden="0" inputType="java.lang.Integer"

                listType="0" name="flags" required="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.Integer"

                defaultValue="" hidden="0" inputType="java.lang.Integer"

                listType="0" name="permissions" required="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.Integer"

                defaultValue="" hidden="0" inputType="java.lang.Integer"

                listType="0" name="newUser" required="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.String"

                defaultValue="" hidden="0" inputType="java.lang.String"

                listType="0" name="CVAuthCode" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                defaultValue="" hidden="0" inputType="java.lang.String"

                listType="0" name="adminEmail" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

        </variables>

        <inputs attribute="0" className="" listType="0" name="inputs"

            required="1" type="">

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName="User Name"

                hidden="0" inputType="java.lang.String" listType="0"

                name="userName" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName="User Email"

                hidden="0" inputType="java.lang.String" listType="0"

                name="userEmail" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue=""

                displayName="Company Name" documentation="" hidden="0"

                inputType="java.lang.String" listType="0"

                name="companyName" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName="Full Name"

                hidden="0" inputType="java.lang.String" listType="0"

                name="userFullName" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.Integer"

                controlType="0" defaultValue="" displayName="User Type"

                hidden="0" inputType="java.lang.Integer" listType="0"

                name="userType" required="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0"

                className="workflow.types.EncryptedString"

                controlType="0" defaultValue="" displayName="Password"

                hidden="0" inputType="workflow.types.EncryptedString"

                listType="0" name="userPassword" required="0" type="{workflow.types}EncryptedString"/>

            <children attribute="0" className="java.lang.String"

                controlType="1" defaultValue=""

                displayName="User Description" hidden="0"

                inputType="java.lang.String" listType="0"

                name="userDescription" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

        </inputs>

    </schema>

    <Start commented="0" continueOnFailure="0" created="0"

        description="" displayName="Start" height="36" interactive="0"

        jobMode="0" name="Start" originalStyle="" skipAttempt="0"

        style="image;image=/images/jgraphx/house.png"

        uniqueName="Start_1" waitSetting="0" width="61" x="39" y="56">

        <inputs val="&lt;inputs />"/>

        <transition activity="UpdateJobDescription_1" commented="0"

            originalStyle="" points="" sourceX="69" sourceY="74"

            status="0" style="defaultEdge" targetX="197" targetY="72"

            transitionIndex="0" x="0" y="0"/>

    </Start>

    <Activity commented="0" continueOnFailure="1"

        created="1338846146977" description="Creates a new user"

        displayName="Create User" height="34" interactive="0"

        jobMode="0" name="Execute"

        namespaceUri="commvault.cte.workflow.activities.cmd.operation"

        originalStyle="" skipAttempt="0" style="label;image=Execute"

        uniqueName="Execute_5" waitSetting="0" width="161" x="1251" y="306">

        <inputs val="&lt;inputs>&lt;inputXml class=&quot;java.lang.String&quot;>&amp;lt;App_CreateUserRequest level=&quot;1&quot;&amp;gt;&amp;#xD;&#xd;&#xa;   &amp;lt;users enableUser=&quot;xpath:{/workflow/variables/enableUser}&quot; &amp;#xD;&#xd;&#xa;               password=&quot;java:{utils.encode(xpath:{/workflow/inputs/userPassword})}&quot; &amp;#xD;&#xd;&#xa;               fullName=&quot;xpath:{/workflow/inputs/userFullName}&quot; &amp;#xD;&#xd;&#xa;               email=&quot;xpath:{/workflow/inputs/userEmail}&quot;&amp;#xD;&#xd;&#xa;               description=&quot;xpath:{/workflow/variables/userDescription}&quot;&amp;#xD;&#xd;&#xa;               companyName=&quot;xpath:{/workflow/variables/companyname}&quot;&amp;gt;&amp;#xD;&#xd;&#xa;     &amp;lt;userEntity userName=&quot;xpath:{/workflow/inputs/userName}&quot;&amp;gt;&amp;lt;/userEntity&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/users&amp;gt;&amp;#xD;&#xd;&#xa; &amp;lt;/App_CreateUserRequest&amp;gt;&lt;/inputXml>&lt;commandArgs class=&quot;java.lang.String&quot; />&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot; />&lt;/sessionOptions>&lt;escapeXml class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/escapeXml>&lt;/inputs>"/>

        <transition activity="ProcessBlock_1" commented="0"

            originalStyle="" points="" sourceX="1340" sourceY="269"

            status="0" style="defaultEdge" targetX="1364" targetY="463"

            transitionIndex="0" x="0" y="0"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1345148592604"

        description="updates the job description for the workflow"

        displayName="Set Description" height="34" interactive="0"

        jobMode="0" name="UpdateJobDescription"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=UpdateJobDescription"

        uniqueName="UpdateJobDescription_1" waitSetting="0" width="144"

        x="138" y="57">

        <inputs val="&lt;inputs>&lt;operation class=&quot;workflow.types.cmd.AppendOverwrite&quot;>overwrite&lt;/operation>&lt;jobDescription class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/userName}&lt;/jobDescription>&lt;/inputs>"/>

        <transition activity="CommServDBQuery_24" commented="0"

            originalStyle="" points="" sourceX="210" sourceY="74"

            status="0" style="defaultEdge" targetX="450" targetY="78"

            transitionIndex="0" x="0" y="0"/>

    </Activity>

    <Activity commented="0" continueOnFailure="1"

        created="1347309910370"

        description="creates a super process group"

        displayName="TRY BLOCK" height="1017" interactive="0"

        jobMode="0" maxRestarts="0" name="ProcessBlock"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ProcessBlock_1" waitSetting="0" width="1723" x="27" y="411">

        <inputs val="&lt;inputs>&lt;inputs />&lt;/inputs>"/>

        <superProcess>

            <Start commented="0" continueOnFailure="0"

                created="1347309910370" description=""

                displayName="Start" height="30" interactive="0"

                jobMode="0" name="Start" originalStyle=""

                skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_2" waitSetting="0" width="120"

                x="1278" y="68">

                <inputs val="&lt;inputs />"/>

                <transition activity="XPathQuery_4" commented="0"

                    originalStyle="" points="1241.0,84.0" sourceX="990"

                    sourceY="55" status="0" style="defaultEdge"

                    targetX="832" targetY="57" transitionIndex="0" x="0" y="0"/>

            </Start>

            <Activity commented="0" continueOnFailure="0"

                created="1347309934615"

                description="Gets the output xml and error code for create user"

                displayName="Get ErrorCode" height="34" interactive="0"

                jobMode="0" name="XPathQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=XPathQuery" uniqueName="XPathQuery_4"

                waitSetting="0" width="124" x="1078" y="65">

                <inputs val="&lt;inputs>&lt;xml class=&quot;java.lang.String&quot;>xpath:{/workflow/Execute_5/outputXml}&lt;/xml>&lt;xpath class=&quot;java.lang.String&quot;>string(/App_CreateUserResponse/response/errorCode)&lt;/xpath>&lt;/inputs>"/>

                <transition activity="XPathQuery_5" commented="0"

                    originalStyle="" points="1040.0,82.0" sourceX="745"

                    sourceY="111" status="0" style="defaultEdge"

                    targetX="593" targetY="120" transitionIndex="0"

                    x="-27" y="-153"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1347309934631"

                description="Checks if the user creation was successful"

                displayName="Successful" height="100" interactive="0"

                jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_7"

                waitSetting="0" width="100" x="537" y="32">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/XPathQuery_4/result}.get(0).equals(&quot;0&quot;)&lt;/expression>&lt;/inputs>"/>

                <transition activity="AssignValues_6" commented="0"

                    displayName="YES" originalStyle="" points=""

                    sourceX="52" sourceY="-808" status="0"

                    style="defaultEdge" targetX="50" targetY="-678"

                    transitionIndex="0" value="true" x="-44" y="-977"/>

                <transition activity="Script_4" commented="0"

                    displayName="NO" originalStyle="" points=""

                    sourceX="96" sourceY="169" status="0"

                    style="defaultEdge" targetX="99" targetY="53"

                    transitionIndex="0" value="false" x="0" y="0"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1347309934647"

                description="Gets the output xml and error string for create user"

                displayName="Get Message" height="34" interactive="0"

                jobMode="0" name="XPathQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=XPathQuery" uniqueName="XPathQuery_5"

                waitSetting="0" width="114" x="895" y="65">

                <inputs val="&lt;inputs>&lt;xml class=&quot;java.lang.String&quot;>xpath:{/workflow/Execute_5/outputXml}&lt;/xml>&lt;xpath class=&quot;java.lang.String&quot;>string(/App_CreateUserResponse/response/errorString)&lt;/xpath>&lt;/inputs>"/>

                <transition activity="GenericResponse_2" commented="0"

                    originalStyle="" points="858.0,80.0" sourceX="589"

                    sourceY="111" status="0" style="defaultEdge"

                    targetX="479" targetY="112" transitionIndex="0"

                    x="-27" y="-153"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1347309934662"

                description="Sends any error message back to the console"

                displayName="Respond" height="34" interactive="0"

                jobMode="0" name="GenericResponse"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=GenericResponse"

                uniqueName="GenericResponse_2" waitSetting="0"

                width="114" x="712" y="65">

                <inputs val="&lt;inputs>&lt;errorCode class=&quot;java.lang.Integer&quot;>xpath:{/workflow/XPathQuery_4/result}&lt;/errorCode>&lt;errorMessage class=&quot;java.lang.String&quot;>xpath:{/workflow/XPathQuery_5/result}&lt;/errorMessage>&lt;/inputs>"/>

                <transition activity="Decision_7" commented="0"

                    originalStyle="" points="" sourceX="434"

                    sourceY="111" status="0" style="defaultEdge"

                    targetX="298" targetY="113" transitionIndex="0"

                    x="-27" y="-153"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1347309934803"

                description="Queries the database to check if the user is enabled"

                displayName="Check User isEnabled" height="34"

                interactive="0" jobMode="0" name="CommServDBQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=CommServDBQuery"

                uniqueName="CommServDBQuery_9" waitSetting="0"

                width="172" x="1266" y="236">

                <inputs val="&lt;inputs>&lt;commCell />&lt;query>SELECT enabled FROM UMUsers WHERE login=?&lt;/query>&lt;parameters>&lt;value>xpath:{/workflow/inputs/userName}&lt;/value>&lt;type>OBJECT&lt;/type>&lt;/parameters>&lt;/inputs>"/>

                <transition activity="Decision_8" commented="0"

                    originalStyle="" points="1463.0,251.0" sourceX="954"

                    sourceY="211" status="0" style="defaultEdge"

                    targetX="957" targetY="344" transitionIndex="0"

                    x="-27" y="-153"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1347309934818"

                description="Decision box to check if the user is enabled"

                displayName="User Enabled?" height="100" interactive="0"

                jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_8"

                waitSetting="0" width="124" x="1506" y="200">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{number(/workflow/CommServDBQuery_9/resultSets[1]/row[1]/col[1])} == 1&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="Script_14" commented="0"

                    displayName="NO" originalStyle=""

                    points="1568.0,164.0" sourceX="1401" sourceY="194"

                    status="0" style="defaultEdge" targetX="1402"

                    targetY="72" transitionIndex="0" value="false" x="0" y="0"/>

                <transition activity="Decision_29" commented="0"

                    displayName="YES" offsetX="-3" offsetY="0"

                    originalStyle="" points="" sourceX="894"

                    sourceY="-1356" status="0" style="defaultEdge"

                    targetX="760" targetY="-1353" transitionIndex="0"

                    value="true" x="-48" y="-1412"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1347309934834"

                description="Create a brand new client group with name companyName"

                displayName="Create Client Group" height="34"

                interactive="0" jobMode="0" name="CommServDBQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=CommServDBQuery"

                uniqueName="CommServDBQuery_10" waitSetting="0"

                width="162" x="146" y="619">

                <inputs val="&lt;inputs>&lt;commCell />&lt;query>IF NOT EXISTS(SELECT * FROM [APP_ClientGroup] WHERE name = ?)&amp;#xD;&#xd;&#xa;    INSERT INTO [CommServ].[dbo].[APP_ClientGroup] ([name],[description],[flag],[status],[userId],[refTime],[modified],[fwPorts],[origCCId],[GUID])&amp;#xD;&#xd;&#xa;    VALUES (?,''MSP client group'',0,0,?,dbo.GetUnixTime(GETUTCDATE()),dbo.GetUnixTime(GETUTCDATE()),'''',2,NEWID())&lt;/query>&lt;parameters>&lt;value>xpath:{/workflow/variables/companyname}&lt;/value>&lt;type>OBJECT&lt;/type>&lt;/parameters>&lt;parameters>&lt;value>xpath:{/workflow/variables/companyname}&lt;/value>&lt;type>OBJECT&lt;/type>&lt;/parameters>&lt;parameters>&lt;value>xpath:{/workflow/system/executor/userId}&lt;/value>&lt;type>OBJECT&lt;/type>&lt;/parameters>&lt;/inputs>"/>

                <transition activity="Execute_8" commented="0"

                    originalStyle="" points="" sourceX="400"

                    sourceY="673" status="0" style="defaultEdge"

                    targetX="216" targetY="750" transitionIndex="0"

                    x="0" y="0"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1347309934881"

                description="Add the user to the group with the name &quot;company name&quot;"

                displayName="Add User To Group" height="34"

                interactive="0" jobMode="0" name="Execute"

                namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                originalStyle="" skipAttempt="0"

                style="label;image=Execute" uniqueName="Execute_9"

                waitSetting="0" width="159" x="343" y="472">

                <inputs val="&lt;inputs>&lt;inputXml class=&quot;java.lang.String&quot;>&amp;lt;App_UpdateUserGroupPropertiesRequest&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;groups usersOperationType=&quot;ADD&quot;&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;userGroupEntity userGroupName=&quot;xpath:{/workflow/variables/companyname}&quot; /&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;users userName=&quot;xpath:{/workflow/inputs/userName}&quot;&amp;gt;&amp;lt;/users&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;/groups&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/App_UpdateUserGroupPropertiesRequest&amp;gt;&lt;/inputXml>&lt;commandArgs class=&quot;java.lang.String&quot; />&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot; />&lt;/sessionOptions>&lt;escapeXml class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/escapeXml>&lt;/inputs>"/>

                <transition activity="XPathQuery_9" commented="0"

                    originalStyle="" points="531.0,490.0" sourceX="220"

                    sourceY="378" status="0" style="defaultEdge"

                    targetX="224" targetY="451" transitionIndex="0"

                    x="0" y="0"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1347892311446"

                description="activity to execute code snippets in the selected language"

                displayName="Raise Error" height="34" interactive="0"

                jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Script" uniqueName="Script_4"

                waitSetting="0" width="104" x="377" y="66">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;workflow.setFailed(xpath:{/workflow/XPathQuery_5/result});&quot; />&lt;/inputs>"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1349105211428"

                description="Get the error code from the returning xml"

                displayName="Get ErrorCode" height="34" interactive="0"

                jobMode="0" name="XPathQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=XPathQuery" uniqueName="XPathQuery_7"

                waitSetting="0" width="124" x="163" y="767">

                <inputs val="&lt;inputs>&lt;xml class=&quot;java.lang.String&quot;>xpath:{/workflow/Execute_8/outputXml}&lt;/xml>&lt;xpath class=&quot;java.lang.String&quot;>string(/App_CreateUserGroupResponse/response/errorCode)&lt;/xpath>&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;>String&lt;/outputType>&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/outputAsList>&lt;/inputs>"/>

                <transition activity="Decision_11" commented="0"

                    originalStyle="" points="" sourceX="423"

                    sourceY="422" status="0" style="defaultEdge"

                    targetX="601" targetY="418" transitionIndex="0"

                    x="0" y="0"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1349105216092"

                description="Checks the error code of the response xml"

                displayName="Get ErrorCode" height="34" interactive="0"

                jobMode="0" name="XPathQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=XPathQuery" uniqueName="XPathQuery_9"

                waitSetting="0" width="124" x="576" y="476">

                <inputs val="&lt;inputs>&lt;xml class=&quot;java.lang.String&quot;>xpath:{/workflow/Execute_9/outputXml}&lt;/xml>&lt;xpath class=&quot;java.lang.String&quot;>string(/App_UpdateUserGroupPropertiesResponse/response/errorCode)&lt;/xpath>&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;>String&lt;/outputType>&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/outputAsList>&lt;/inputs>"/>

                <transition activity="Decision_10" commented="0"

                    originalStyle="" points="" sourceX="214"

                    sourceY="419" status="0" style="defaultEdge"

                    targetX="101" targetY="417" transitionIndex="0"

                    x="0" y="0"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1349105379796"

                description="Decides if adding the user to the group was successful"

                displayName="Decision" height="100" interactive="0"

                jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_10"

                waitSetting="0" width="100" x="587" y="546">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/XPathQuery_9/result}.equals(&quot;0&quot;)&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="Script_6" commented="0"

                    displayName="FAIL" originalStyle="" points=""

                    sourceX="70" sourceY="421" status="0"

                    style="defaultEdge" targetX="68" targetY="335"

                    transitionIndex="0" value="false" x="0" y="0"/>

                <transition activity="Email_25" commented="0"

                    displayName="SUCCEED" originalStyle="" points=""

                    sourceX="663" sourceY="681" status="0"

                    style="defaultEdge" targetX="715" targetY="1004"

                    transitionIndex="0" value="true" x="0" y="0"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1349105404429"

                description="Decide if creating the user group was successful or not"

                displayName="Decision" height="100" interactive="0"

                jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_11"

                waitSetting="0" width="100" x="176" y="828">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/XPathQuery_7/result}.equals(&quot;0&quot;)&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="Script_8" commented="0"

                    displayName="FAIL" originalStyle="" points=""

                    sourceX="588" sourceY="422" status="0"

                    style="defaultEdge" targetX="711" targetY="420"

                    transitionIndex="0" value="false" x="0" y="0"/>

                <transition activity="Execute_9" commented="0"

                    displayName="SUCCEED" offsetX="-19" offsetY="184"

                    originalStyle="" points="425.0,669.0" sourceX="563"

                    sourceY="-142" status="0" style="defaultEdge"

                    targetX="793" targetY="21" transitionIndex="0"

                    value="true" x="0" y="0"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1349105442650"

                description="If adding user to the group fails, error out"

                displayName="Raise Error" height="34" interactive="0"

                jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Script" uniqueName="Script_6"

                waitSetting="0" width="104" x="731" y="580">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;workflow.setFailed(&amp;quot;failed to add user to group&amp;quot;);&quot; />&lt;/inputs>"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1349105448073"

                description="If creating user group failed, error out"

                displayName="Raise Error" height="34" interactive="0"

                jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Script" uniqueName="Script_8"

                waitSetting="0" width="104" x="172" y="963">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;workflow.setFailed(&amp;quot;failed to create user group&amp;quot;);&quot; />&lt;/inputs>"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1352226349202"

                description="The new user that was created is now automatically enabled"

                displayName="Enable User" height="34" interactive="0"

                jobMode="0" name="CommServDBQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=CommServDBQuery"

                uniqueName="CommServDBQuery_15" waitSetting="0"

                width="162" x="762" y="171">

                <inputs val="&lt;inputs>&lt;commCell />&lt;query>UPDATE UMUsers SET enabled=1 WHERE login=?&lt;/query>&lt;parameters>&lt;value>xpath:{/workflow/inputs/userName}&lt;/value>&lt;type>OBJECT&lt;/type>&lt;/parameters>&lt;/inputs>"/>

                <transition activity="Decision_30" commented="0"

                    originalStyle="" points="945.0,186.0" sourceX="387"

                    sourceY="193" status="0" style="defaultEdge"

                    targetX="777" targetY="193" transitionIndex="0"

                    x="0" y="0"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1352226431402"

                description="Sends an email to a list of users"

                displayName="Auto Email to Admin" height="34"

                interactive="0" jobMode="0" name="Email"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Email" uniqueName="Email_12"

                waitSetting="0" width="162" x="1263" y="169">

                <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot;>&lt;from class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/adminEmail}&lt;/from>&lt;to class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/adminEmail}&lt;/to>&lt;subject class=&quot;java.lang.String&quot;>New request has been automatically approved&lt;/subject>&lt;body class=&quot;java.lang.String&quot;>&amp;lt;style type=&quot;text/css&quot;&amp;gt;&#xd;&#xa;      &amp;lt;!--&#xd;&#xa;        .content2 { padding-left: 50px; padding-right: 50px; color: #666666; width: 800px; background-color: WHITE; font-family: Calibri, Tahoma, Arial; padding-bottom: 25px; border-spacing: 0; padding-top: 25px }&#xd;&#xa;      --&amp;gt;&#xd;&#xa;    &amp;lt;/style&amp;gt;&#xd;&#xa;    &#xd;&#xa;  &#xd;&#xa;  &#xd;&#xa;    &amp;lt;table class=&quot;content2&quot;&amp;gt;&#xd;&#xa;      &amp;lt;tr&amp;gt;&#xd;&#xa;        &amp;lt;td&amp;gt;&#xd;&#xa;          &amp;lt;p&amp;gt;&#xd;&#xa;            &#xd;&#xa;          &amp;lt;/p&amp;gt;&#xd;&#xa;          &amp;lt;p&amp;gt;&#xd;&#xa;            User Registration was completed by Job Id: &#xd;&#xa;            [xpath:{/workflow/system/jobId}]&#xd;&#xa;          &amp;lt;/p&amp;gt;&#xd;&#xa;          &amp;lt;br&amp;gt;&#xd;&#xa;          &#xd;&#xa;&#xd;&#xa;          &amp;lt;p&amp;gt;&#xd;&#xa;            &amp;lt;b&amp;gt;Name : &amp;lt;/b&amp;gt;xpath:{/workflow/inputs/userFullName}&#xd;&#xa;          &amp;lt;/p&amp;gt;&#xd;&#xa;          &amp;lt;p&amp;gt;&#xd;&#xa;            &amp;lt;b&amp;gt;E-mail : &amp;lt;/b&amp;gt;xpath:{/workflow/inputs/userEmail}&#xd;&#xa;          &amp;lt;/p&amp;gt;&#xd;&#xa;          &amp;lt;p&amp;gt;&#xd;&#xa;            &amp;lt;b&amp;gt;User Name : &amp;lt;/b&amp;gt;xpath:{/workflow/inputs/userName}&#xd;&#xa;          &amp;lt;/p&amp;gt;&#xd;&#xa;          &amp;lt;p&amp;gt;&#xd;&#xa;            &amp;lt;b&amp;gt;Referring employee&amp;lt;/b&amp;gt;: xpath:{/workflow/variables/referral}&#xd;&#xa;          &amp;lt;/p&amp;gt;&#xd;&#xa;          &amp;lt;p&amp;gt;&#xd;&#xa;            &#xd;&#xa;          &amp;lt;/p&amp;gt;&#xd;&#xa;          &amp;lt;br&amp;gt;&#xd;&#xa;          &#xd;&#xa;&#xd;&#xa;          &amp;lt;p&amp;gt;&#xd;&#xa;            Thank you&#xd;&#xa;          &amp;lt;/p&amp;gt;&#xd;&#xa;        &amp;lt;/td&amp;gt;&#xd;&#xa;      &amp;lt;/tr&amp;gt;&#xd;&#xa;    &amp;lt;/table&amp;gt;&lt;/body>&lt;html class=&quot;java.lang.Boolean&quot;>true&lt;/html>&lt;/email>&lt;/inputs>"/>

                <transition activity="CommServDBQuery_9" commented="0"

                    originalStyle="" points="" sourceX="915"

                    sourceY="351" status="0" style="defaultEdge"

                    targetX="911" targetY="243" transitionIndex="0"

                    x="0" y="0"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1354807573986"

                description="Raises an error if the user is not enabled in teh database"

                displayName="Raise Error" height="34" interactive="0"

                jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Script" uniqueName="Script_14"

                waitSetting="0" width="104" x="1513" y="110">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;workflow.setFailed(&amp;quot;User not enabled&amp;quot;);&quot; />&lt;/inputs>"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1354907686835"

                description="If the user is a cloud laptop user, add user to &quot;Laptop users&quot; group"

                displayName="Add User To Laptop Group" height="34"

                interactive="0" jobMode="0" name="Execute"

                namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                originalStyle="" skipAttempt="0"

                style="label;image=Execute" uniqueName="Execute_18"

                waitSetting="0" width="200" x="933" y="510">

                <inputs val="&lt;inputs>&lt;inputXml class=&quot;java.lang.String&quot;>&amp;lt;App_UpdateUserGroupPropertiesRequest&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;groups usersOperationType=&quot;ADD&quot;&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;userGroupEntity userGroupName=&quot;Laptop users&quot; /&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;users userName=&quot;xpath:{/workflow/inputs/userName}&quot;&amp;gt;&amp;lt;/users&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;/groups&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/App_UpdateUserGroupPropertiesRequest&amp;gt;&lt;/inputXml>&lt;commandArgs class=&quot;java.lang.String&quot; />&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

                <transition activity="Email_23" commented="0"

                    originalStyle="" points="" sourceX="911"

                    sourceY="618" status="0" style="defaultEdge"

                    targetX="1081" targetY="931" transitionIndex="0"

                    x="0" y="0"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1355516302102"

                description="Checks if the user if for MSP services, Laptop services or for sizing tools only"

                displayName="User Permissions" height="100"

                interactive="0" jobMode="0" name="Switch"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Switch_1"

                waitSetting="0" width="145" x="1228" y="476">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/permissions}&lt;/expression>&lt;/inputs>"/>

                <transition activity="CommServDBQuery_20" commented="0"

                    displayName="MSP " offsetX="44" offsetY="8"

                    originalStyle="" points="1254.0,425.0" sourceX="864"

                    sourceY="476" status="0" style="defaultEdge"

                    targetX="684" targetY="474" transitionIndex="0"

                    value="512" x="0" y="0"/>

                <transition activity="Execute_20" commented="0"

                    displayName="EDC" offsetX="1" offsetY="-9"

                    originalStyle="" points="1298.0,602.0" sourceX="890"

                    sourceY="457" status="0" style="defaultEdge"

                    targetX="1274" targetY="569" transitionIndex="0"

                    value="0" x="0" y="0"/>

                <transition activity="Execute_18" commented="0"

                    displayName="LAPTOP" originalStyle="" points=""

                    sourceX="864" sourceY="476" status="0"

                    style="defaultEdge" targetX="864" targetY="605"

                    transitionIndex="0" value="256" x="0" y="0"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1355516646136"

                description="If the user is an MSP services user, get the company name of the user from the database."

                displayName="Get Company Name" height="34"

                interactive="0" jobMode="0" name="CommServDBQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=CommServDBQuery"

                uniqueName="CommServDBQuery_20" waitSetting="0"

                width="162" x="1006" y="390">

                <inputs val="&lt;inputs>&lt;commCell />&lt;query>SELECT CompanyName FROM cloudAuthorization WHERE AuthCode=?&lt;/query>&lt;parameters>&lt;value>xpath:{/workflow/inputs/companyName}&lt;/value>&lt;type>OBJECT&lt;/type>&lt;/parameters>&lt;/inputs>"/>

                <transition activity="AssignValues_4" commented="0"

                    originalStyle="" points="" sourceX="658"

                    sourceY="481" status="0" style="defaultEdge"

                    targetX="543" targetY="480" transitionIndex="0"

                    x="0" y="0"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1355517047560"

                description="Set the company name in the workflow variables"

                displayName="Set Company Name" height="34"

                interactive="0" jobMode="0" name="AssignValues"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=AssignValues"

                uniqueName="AssignValues_4" waitSetting="0" width="159"

                x="795" y="390">

                <outputs variables="&lt;variables>&lt;companyname class=&quot;java.lang.String&quot;>xpath:{/workflow/CommServDBQuery_20/resultSets[1]/row[1]/col[1]}&lt;/companyname>&lt;/variables>"/>

                <inputs val="&lt;inputs />"/>

                <transition activity="Decision_19" commented="0"

                    originalStyle="" points="747.0,413.0" sourceX="475"

                    sourceY="482" status="0" style="defaultEdge"

                    targetX="460" targetY="540" transitionIndex="0"

                    x="0" y="0"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1355517140428"

                description="Checks if the company name has been set successfully in the workflow variables"

                displayName="Company Name is Set" height="100"

                interactive="0" jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_19"

                waitSetting="0" width="174" x="558" y="364">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/companyname}!=&quot;&quot;&lt;/expression>&lt;/inputs>"/>

                <transition activity="CommServDBQuery_25" commented="0"

                    displayName="YES" offsetX="2" offsetY="2"

                    originalStyle="" sourceX="437" sourceY="568"

                    status="0" style="defaultEdge" targetX="308"

                    targetY="485" transitionIndex="0" value="true" x="0" y="0"/>

                <transition activity="Script_17" commented="0"

                    displayName="NO" originalStyle="" points=""

                    sourceX="437" sourceY="568" status="0"

                    style="defaultEdge" targetX="584" targetY="567"

                    transitionIndex="0" value="false" x="0" y="0"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1355517205965"

                description="If the company name is not set, error out"

                displayName="Raise Error" height="34" interactive="0"

                jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Script" uniqueName="Script_17"

                waitSetting="0" width="104" x="592" y="269">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;workflow.setFailed(&amp;quot;failed to set company name in workflow&amp;quot;);&quot; />&lt;/inputs>"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1355867221778"

                description="If a user group called by the company name does not exist, set the new MSP user flag in the workflow variables"

                displayName="Set New MSP User Flag" height="34"

                interactive="0" jobMode="0" name="AssignValues"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=AssignValues"

                uniqueName="AssignValues_5" waitSetting="0" width="186"

                x="134" y="559">

                <outputs variables="&lt;variables>&lt;newUser class=&quot;java.lang.Integer&quot;>2&lt;/newUser>&lt;/variables>"/>

                <inputs val="&lt;inputs />"/>

                <transition activity="CommServDBQuery_10" commented="0"

                    originalStyle="" points="" sourceX="97"

                    sourceY="662" status="0" style="defaultEdge"

                    targetX="91" targetY="735" transitionIndex="0" x="0" y="0"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1355867343598"

                description="The user creation is successful and we set a workflow variable called &quot;newUser&quot;"

                displayName="Set New User Flag" height="34"

                interactive="0" jobMode="0" name="AssignValues"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=AssignValues"

                uniqueName="AssignValues_6" waitSetting="0" width="153"

                x="522" y="172">

                <outputs variables="&lt;variables>&lt;newUser class=&quot;java.lang.Integer&quot;>1&lt;/newUser>&lt;/variables>"/>

                <inputs val="&lt;inputs />"/>

                <transition activity="CommServDBQuery_15" commented="0"

                    originalStyle="" points="717.0,189.0" sourceX="90"

                    sourceY="290" status="0" style="defaultEdge"

                    targetX="601" targetY="202" transitionIndex="0"

                    x="0" y="0"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1356020530877"

                description="The final email is sent to laptop user and the user referral letting them know that the account is ready for use."

                displayName="Final Email to Laptop User" height="34"

                interactive="0" jobMode="0" name="Email"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Email" uniqueName="Email_23"

                waitSetting="0" width="200" x="939" y="632">

                <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot;>&lt;from class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/adminEmail}&lt;/from>&lt;to class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/userEmail};xpath:{/workflow/variables/referral}&lt;/to>&lt;subject class=&quot;java.lang.String&quot;>Your registration has been approved&lt;/subject>&lt;body class=&quot;java.lang.String&quot;>&amp;lt;table class=&quot;content2&quot;&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;tr&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;td&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;p&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;#xD;&#xd;&#xa;&amp;lt;/p&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;p&amp;gt;&amp;#xD;&#xd;&#xa;  Good day xpath:{/workflow/inputs/userFullName},&amp;#xD;&#xd;&#xa;&amp;lt;/p&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;p&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;#xD;&#xd;&#xa;&amp;lt;/p&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;p&amp;gt;&amp;#xD;&#xd;&#xa;  Your account: [xpath:{/workflow/inputs/userName}] has been &amp;#xD;&#xd;&#xa;  configured and is ready for you to use.&amp;#xD;&#xd;&#xa;&amp;lt;/p&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;p&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;#xD;&#xd;&#xa;&amp;lt;/p&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;p&amp;gt;&amp;#xD;&#xd;&#xa;  Thank you&amp;#xD;&#xd;&#xa;&amp;lt;/p&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;/td&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/tr&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;/table&amp;gt;&lt;/body>&lt;html class=&quot;java.lang.Boolean&quot;>true&lt;/html>&lt;/email>&lt;/inputs>"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1357159016152"

                description="The final email is sent to MSP user and the user referral letting them know that the account is ready for use."

                displayName="Final Email to MSP User" height="34"

                interactive="0" jobMode="0" name="Email"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Email" uniqueName="Email_25"

                waitSetting="0" width="200" x="535" y="686">

                <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot;>&lt;from class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/adminEmail}&lt;/from>&lt;to class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/userEmail};xpath:{/workflow/variables/referral}&lt;/to>&lt;subject class=&quot;java.lang.String&quot;>Your registration has been approved&lt;/subject>&lt;body class=&quot;java.lang.String&quot;>&amp;lt;table class=&quot;content2&quot;&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;tr&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;td&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;p&amp;gt;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;  &amp;lt;/p&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;p&amp;gt;&amp;#xD;&#xd;&#xa;Good day xpath:{/workflow/inputs/userFullName},&amp;#xD;&#xd;&#xa;  &amp;lt;/p&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;p&amp;gt;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;  &amp;lt;/p&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;p&amp;gt;&amp;#xD;&#xd;&#xa;Your account [xpath:{/workflow/inputs/userName}] has been &amp;#xD;&#xd;&#xa;configured and is ready for you to use.&amp;#xD;&#xd;&#xa;  &amp;lt;/p&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;p&amp;gt;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;  &amp;lt;/p&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;p&amp;gt;&amp;#xD;&#xd;&#xa;Thank you&amp;#xD;&#xd;&#xa;  &amp;lt;/p&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/td&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;/tr&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/table&amp;gt;&lt;/body>&lt;html class=&quot;java.lang.Boolean&quot;>true&lt;/html>&lt;/email>&lt;/inputs>"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1357310342505"

                description="If the user needs only sizing tools, add the user to &quot;EDC users&quot; group only."

                displayName="Add User To EDC Group" height="34"

                interactive="0" jobMode="0" name="Execute"

                namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                originalStyle="" skipAttempt="0"

                style="label;image=Execute" uniqueName="Execute_20"

                waitSetting="0" width="200" x="1204" y="637">

                <inputs val="&lt;inputs>&lt;inputXml class=&quot;java.lang.String&quot;>&amp;lt;App_UpdateUserGroupPropertiesRequest&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;groups usersOperationType=&quot;ADD&quot;&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;userGroupEntity userGroupName=&quot;EDC users&quot; /&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;users userName=&quot;xpath:{/workflow/inputs/userName}&quot;&amp;gt;&amp;lt;/users&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;/groups&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/App_UpdateUserGroupPropertiesRequest&amp;gt;&lt;/inputXml>&lt;commandArgs class=&quot;java.lang.String&quot; />&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

                <transition activity="Email_32" commented="0"

                    originalStyle="" points="" sourceX="1284"

                    sourceY="659" status="0" style="defaultEdge"

                    targetX="1293" targetY="734" transitionIndex="0"

                    x="0" y="0"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1357589378492"

                description="The final email is sent to the sizing tools user and the user referral letting them know that the account is ready for use."

                displayName="Final email to EDC User" height="34"

                interactive="0" jobMode="0" name="Email"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Email" uniqueName="Email_32"

                waitSetting="0" width="200" x="1194" y="716">

                <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot;>&lt;from class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/adminEmail}&lt;/from>&lt;to class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/userEmail};xpath:{/workflow/variables/referral}&lt;/to>&lt;subject class=&quot;java.lang.String&quot;>Your registration has been approved&lt;/subject>&lt;body class=&quot;java.lang.String&quot;>&amp;lt;table class=&quot;content2&quot; width=&quot;667&quot;&amp;gt;&#xd;&#xa;  &amp;lt;tr&amp;gt;&#xd;&#xa;&amp;lt;td&amp;gt;&#xd;&#xa;  &amp;lt;p&amp;gt;&#xd;&#xa;Good day xpath:{/workflow/inputs/userFullName},&#xd;&#xa;  &amp;lt;/p&amp;gt;&#xd;&#xa;  &amp;lt;p&amp;gt;&#xd;&#xa;&#xd;&#xa;  &amp;lt;/p&amp;gt;&#xd;&#xa;  &amp;lt;p&amp;gt;&#xd;&#xa;Your account [xpath:{/workflow/inputs/userName}] has been &#xd;&#xa;configured and is ready for you to use.&#xd;&#xa;  &amp;lt;/p&amp;gt;&#xd;&#xa;  &amp;lt;p&amp;gt;&#xd;&#xa;&#xd;&#xa;  &amp;lt;/p&amp;gt;&#xd;&#xa;  &amp;lt;p&amp;gt;&#xd;&#xa;Thank you&#xd;&#xa;  &amp;lt;/p&amp;gt;&#xd;&#xa;&amp;lt;/td&amp;gt;&#xd;&#xa;  &amp;lt;/tr&amp;gt;&#xd;&#xa;&amp;lt;/table&amp;gt;&lt;/body>&lt;html class=&quot;java.lang.Boolean&quot;>true&lt;/html>&lt;/email>&lt;/inputs>"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1357592635591"

                description="If the user has any permissions other than laptop backup, the flags need to be updated into the database"

                displayName="Add Cloud properties to user" height="34"

                interactive="0" jobMode="0" name="CommServDBQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=CommServDBQuery"

                uniqueName="CommServDBQuery_22" waitSetting="0"

                width="200" x="1479" y="509">

                <inputs val="&lt;inputs>&lt;commCell />&lt;query>DECLARE @id integer&amp;#xD;&#xd;&#xa;DECLARE @nowTime integer&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;set @id = ISNULL((select id from UMUsers&amp;#xD;&#xd;&#xa;where login like ?),0)&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;SET @nowTime =  dbo.GetUnixTime (GetUTCdate())&amp;#xD;&#xd;&#xa;INSERT INTO UMUsersProp(componentNameId, attrName, attrType, attrVal, created, modified)&amp;#xD;&#xd;&#xa;    VALUES (@id, ''Cloud Capabilities'', 1, ?, @nowTime ,0)&lt;/query>&lt;parameters>&lt;value>xpath:{/workflow/inputs/userName}&lt;/value>&lt;type>OBJECT&lt;/type>&lt;/parameters>&lt;parameters>&lt;value>xpath:{/workflow/variables/flags}&lt;/value>&lt;type>OBJECT&lt;/type>&lt;/parameters>&lt;/inputs>"/>

                <transition activity="Switch_1" commented="0"

                    originalStyle="" points="" sourceX="1581"

                    sourceY="450" status="0" style="defaultEdge"

                    targetX="929" targetY="452" transitionIndex="0"

                    x="0" y="0"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1357600478058"

                description="Checks if the user is signing up for laptop backup only"

                displayName="Is this laptop only" height="100"

                interactive="0" jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_29"

                waitSetting="0" width="148" x="1496" y="347">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{number(/workflow/variables/flags)} == 0&lt;/expression>&lt;/inputs>"/>

                <transition activity="CommServDBQuery_22" commented="0"

                    displayName="NO" originalStyle="" points=""

                    sourceX="1576" sourceY="351" status="0"

                    style="defaultEdge" targetX="1575" targetY="448"

                    transitionIndex="0" value="false" x="0" y="0"/>

                <transition activity="Switch_1" commented="0"

                    displayName="YES" offsetX="47" offsetY="-53"

                    originalStyle="" points="1298.0,394.0"

                    sourceX="1552" sourceY="-355" status="0"

                    style="defaultEdge" targetX="1255" targetY="-272"

                    transitionIndex="0" value="true" x="0" y="0"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1357940742157"

                description="Checks if the CommServ admin has an email configured"

                displayName="is admin email configured" height="100"

                interactive="0" jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_30"

                waitSetting="0" width="199" x="973" y="137">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/adminEmail}.equals(&quot;&quot;)&lt;/expression>&lt;/inputs>"/>

                <transition activity="Email_12" commented="0"

                    displayName="YES" originalStyle="" points=""

                    sourceX="657" sourceY="195" status="0"

                    style="defaultEdge" targetX="902" targetY="191"

                    transitionIndex="0" value="false" x="0" y="0"/>

                <transition activity="CommServDBQuery_9" commented="0"

                    displayName="NO" offsetX="-73" offsetY="12"

                    originalStyle="" points="1072.0,257.0" sourceX="657"

                    sourceY="195" status="0" style="defaultEdge"

                    targetX="1121" targetY="195" transitionIndex="0"

                    value="true" x="0" y="0"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1347309934849"

                description="Create a brand new user group with name companyName and also associate this user group with the newly created client group"

                displayName="Create User Group" height="34"

                interactive="0" jobMode="0" name="Execute"

                namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                originalStyle="" skipAttempt="0"

                style="label;image=Execute" uniqueName="Execute_8"

                waitSetting="0" width="159" x="144" y="687">

                <inputs val="&lt;inputs>&lt;inputXml class=&quot;java.lang.String&quot;>&amp;lt;App_CreateUserGroupRequest&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;groups enabled=&quot;true&quot; allCapabilities=&quot;true&quot; allAssociations=&quot;false&quot; usersOperationType=&quot;ADD&quot;&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;userGroupEntity userGroupName=&quot;xpath:{/workflow/variables/companyname}&quot; /&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;users userName=&quot;xpath:{/workflow/inputs/userName}&quot; description=&quot;MSP user group&quot;&amp;gt;&amp;lt;/users&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;associations clientGroupName=&quot;xpath:{/workflow/variables/companyname}&quot;&amp;gt;&amp;lt;/associations&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;/groups&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/App_CreateUserGroupRequest&amp;gt;&amp;#xD;&#xd;&#xa;&lt;/inputXml>&lt;commandArgs class=&quot;java.lang.String&quot; />&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

                <transition activity="XPathQuery_7" commented="0"

                    originalStyle="" points="" sourceX="407"

                    sourceY="740" status="0" style="defaultEdge"

                    targetX="406" targetY="833" transitionIndex="0"

                    x="0" y="0"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1464029922488"

                description="executes queries against a commcell database"

                displayName="Check User Group" height="34"

                interactive="0" jobMode="0" name="CommServDBQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=CommServDBQuery"

                uniqueName="CommServDBQuery_25" waitSetting="0"

                width="143" x="366" y="395">

                <inputs val="&lt;inputs>&lt;commCell />&lt;query>select name from UMGroups&amp;#xD;&#xd;&#xa;where name = ?&lt;/query>&lt;parameters>&lt;value>xpath:{/workflow/variables/companyname}&lt;/value>&lt;type>OBJECT&lt;/type>&lt;/parameters>&lt;/inputs>"/>

                <transition activity="Execute_9" commented="0"

                    displayName="GROUP EXISTS" originalStyle=""

                    sourceX="437" sourceY="412" status="0"

                    style="defaultEdge" targetX="427" targetY="495"

                    transitionIndex="0" x="0" y="0">

                    <condition language="1" script="xpath:{/workflow/CommServDBQuery_25/resultSets[1]/rowCount}>0&#xa;"/>

                </transition>

                <transition activity="AssignValues_5" commented="0"

                    displayName="GROUP DOES NOT EXIST" offsetX="0"

                    offsetY="-31" originalStyle="" points="228.0,460.0"

                    sourceX="437" sourceY="412" status="0"

                    style="defaultEdge" targetX="269" targetY="572"

                    transitionIndex="0" x="1" y="-3">

                    <condition language="1" script="xpath:{/workflow/CommServDBQuery_25/resultSets[1]/rowCount}==0&#xa;"/>

                </transition>

            </Activity>

        </superProcess>

        <activitySchema>

            <outputs attribute="0" listType="0" name="outputs" required="1"/>

            <inputs attribute="0" listType="0" name="inputs" required="1"/>

        </activitySchema>

        <transition activity="ProcessBlock_3" commented="0"

            displayName="FAIL" originalStyle="" points="1771.0,895.0"

            sourceX="618" sourceY="470" status="2" style="defaultEdge"

            targetX="1468" targetY="470" transitionIndex="0" x="0" y="0"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1347659434273"

        description="creates a super process group"

        displayName="CATCH BLOCK" height="479" interactive="0"

        jobMode="0" name="ProcessBlock"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ProcessBlock_3" waitSetting="0" width="366" x="1846" y="596">

        <inputs val="&lt;inputs>&lt;inputs />&lt;/inputs>"/>

        <superProcess>

            <Start commented="0" continueOnFailure="0"

                created="1347659407111" description=""

                displayName="Start" height="30" interactive="0"

                jobMode="0" name="Start" originalStyle=""

                skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_3" waitSetting="0" width="120" x="18" y="30">

                <inputs val="&lt;inputs />"/>

                <transition activity="Decision_9" commented="0"

                    originalStyle="" points="" sourceX="78" sourceY="45"

                    status="0" style="defaultEdge" targetX="72"

                    targetY="118" transitionIndex="0" x="0" y="0"/>

            </Start>

            <Activity commented="0" continueOnFailure="0"

                created="1347659462195"

                description="if/else based decision"

                displayName="New MSP User" height="100" interactive="0"

                jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_9"

                waitSetting="0" width="128" x="19" y="102">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/newUser}==2&lt;/expression>&lt;/inputs>"/>

                <transition activity="CommServDBQuery_13" commented="0"

                    displayName="YES" originalStyle="" points=""

                    sourceX="69" sourceY="152" status="0"

                    style="defaultEdge" targetX="207" targetY="161"

                    transitionIndex="0" value="true" x="0" y="0"/>

                <transition activity="Decision_20" commented="0"

                    displayName="NO" originalStyle="" points=""

                    sourceX="-1642" sourceY="-824" status="0"

                    style="defaultEdge" targetX="-1611" targetY="-609"

                    transitionIndex="0" value="false" x="-1711" y="-976"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1347660152201" description=""

                displayName="Remove User" height="34" interactive="0"

                jobMode="0" name="Execute"

                namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                originalStyle="" skipAttempt="0"

                style="label;image=Execute" uniqueName="Execute_14"

                waitSetting="0" width="118" x="224" y="285">

                <inputs val="&lt;inputs>&lt;inputXml class=&quot;java.lang.String&quot;>&amp;lt;App_DeleteUserRequest&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&amp;lt;users&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&amp;lt;userEntity userName=&quot;xpath:{/workflow/inputs/userName}&quot; /&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&amp;lt;/users&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/App_DeleteUserRequest&amp;gt;&lt;/inputXml>&lt;commandArgs class=&quot;java.lang.String&quot; />&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

                <transition activity="WorkflowEnd_4" commented="0"

                    originalStyle="" points="290.0,361.0" sourceX="283"

                    sourceY="302" status="0" style="defaultEdge"

                    targetX="135" targetY="406" transitionIndex="0"

                    x="0" y="0"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1347935570912"

                description="executes queries against the commserv database"

                displayName="Remove Client Group" height="34"

                interactive="0" jobMode="0" name="CommServDBQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=CommServDBQuery"

                uniqueName="CommServDBQuery_13" waitSetting="0"

                width="169" x="197" y="135">

                <inputs val="&lt;inputs>&lt;commCell />&lt;query>DECLARE @clientGroupId INT&amp;#xD;&#xd;&#xa;SET @clientGroupId = (SELECT id FROM APP_ClientGroup WHERE name = ?)&amp;#xD;&#xd;&#xa;IF NOT EXISTS (SELECT * FROM APP_ClientGroupAssoc WHERE clientGroupId = @clientGroupId)&amp;#xD;&#xd;&#xa;      DELETE APP_ClientGroup WHERE id = @clientGroupId&amp;#xD;&#xd;&#xa;&lt;/query>&lt;parameters>&lt;value>xpath:{/workflow/variables/companyname}&lt;/value>&lt;type>OBJECT&lt;/type>&lt;/parameters>&lt;/inputs>"/>

                <transition activity="Execute_16" commented="0"

                    originalStyle="" points="" sourceX="281"

                    sourceY="152" status="0" style="defaultEdge"

                    targetX="279" targetY="209" transitionIndex="0"

                    x="0" y="0"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1348693702699" description="Ends the workflow"

                displayName="Fail Workflow" height="34" interactive="0"

                jobMode="0" name="WorkflowEnd"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=WorkflowEnd"

                uniqueName="WorkflowEnd_4" waitSetting="0" width="123"

                x="22" y="398">

                <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot;>FAILED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot;>registration for user [xpath:{/workflow/inputs/userName}] failed&lt;/failureMessage>&lt;/inputs>"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1355867559612"

                description="if/else based decision"

                displayName="New User" height="100" interactive="0"

                jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_20"

                waitSetting="0" width="142" x="12" y="251">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/newUser}==1&lt;/expression>&lt;/inputs>"/>

                <transition activity="WorkflowEnd_4" commented="0"

                    displayName="NO" originalStyle="" points=""

                    sourceX="83" sourceY="301" status="0"

                    style="defaultEdge" targetX="76" targetY="389"

                    transitionIndex="0" value="false" x="0" y="0"/>

                <transition activity="Execute_14" commented="0"

                    displayName="YES" originalStyle="" points=""

                    sourceX="83" sourceY="301" status="0"

                    style="defaultEdge" targetX="230" targetY="302"

                    transitionIndex="0" value="true" x="0" y="0"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1347660181250" description=""

                displayName="Remove User Group" height="34"

                interactive="0" jobMode="0" name="Execute"

                namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                originalStyle="" skipAttempt="0"

                style="label;image=Execute" uniqueName="Execute_16"

                waitSetting="0" width="169" x="189" y="204">

                <inputs val="&lt;inputs>&lt;inputXml class=&quot;java.lang.String&quot;>&amp;lt;App_DeleteUserGroupRequest&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&amp;lt;groups&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&amp;lt;userGroupEntity userGroupName=&quot;xpath:{/workflow/variables/companyname}&quot; /&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&amp;lt;/groups&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/App_DeleteUserGroupRequest&amp;gt;&lt;/inputXml>&lt;commandArgs class=&quot;java.lang.String&quot; />&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

                <transition activity="Execute_14" commented="0"

                    originalStyle="" points="" sourceX="273"

                    sourceY="221" status="0" style="defaultEdge"

                    targetX="270" targetY="299" transitionIndex="0"

                    x="0" y="0"/>

            </Activity>

        </superProcess>

        <activitySchema>

            <outputs attribute="0" listType="0" name="outputs" required="1"/>

            <inputs attribute="0" listType="0" name="inputs" required="1"/>

        </activitySchema>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1354735358878"

        description="Checks if the user has provided an authorization code on the registration page"

        displayName="Is Auth Code Provided" height="100" interactive="0"

        jobMode="0" name="Decision"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_13" waitSetting="0" width="177" x="392" y="17">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/companyName}==&quot;&quot;&lt;/expression>&lt;/inputs>"/>

        <transition activity="CommServDBQuery_16" commented="0"

            displayName="YES" originalStyle="" points="" sourceX="432"

            sourceY="79" status="0" style="defaultEdge" targetX="600"

            targetY="77" transitionIndex="0" value="false" x="0" y="0"/>

        <transition activity="Email_17" commented="0" displayName="NO"

            originalStyle="" points="" sourceX="657" sourceY="68"

            status="0" style="defaultEdge" targetX="650" targetY="323"

            transitionIndex="0" value="true" x="0" y="0"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1354735800253"

        description="Sends an email to the user that an authorization code has to be provided for registering"

        displayName="Email No Auth Code" height="34" interactive="0"

        jobMode="0" maxRestarts="0" name="Email"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Email"

        uniqueName="Email_17" waitSetting="0" width="200" x="381" y="179">

        <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot;>&lt;from class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/adminEmail}&lt;/from>&lt;to class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/userEmail}&lt;/to>&lt;subject class=&quot;java.lang.String&quot;>Please provide an Authorization Code&lt;/subject>&lt;body class=&quot;java.lang.String&quot;>&amp;lt;table class=&quot;content2&quot;&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;tr&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;td&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;p&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;#xD;&#xd;&#xa;          &amp;lt;/p&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;p&amp;gt;&amp;#xD;&#xd;&#xa;            Good day xpath:{/workflow/inputs/userFullName},&amp;#xD;&#xd;&#xa;          &amp;lt;/p&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;p&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;#xD;&#xd;&#xa;          &amp;lt;/p&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;p&amp;gt;&amp;#xD;&#xd;&#xa;            Please contact your commcell administrator for an authorization &amp;#xD;&#xd;&#xa;            code to complete the registration.&amp;#xD;&#xd;&#xa;          &amp;lt;/p&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;p&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;#xD;&#xd;&#xa;          &amp;lt;/p&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;p&amp;gt;&amp;#xD;&#xd;&#xa;            Thank you&amp;#xD;&#xd;&#xa;          &amp;lt;/p&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;/td&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/tr&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/table&amp;gt;&lt;/body>&lt;html class=&quot;java.lang.Boolean&quot;>true&lt;/html>&lt;/email>&lt;/inputs>"/>

        <transition activity="GenericResponse_4" commented="0"

            originalStyle="" points="480.0,232.0" sourceX="423"

            sourceY="176" status="0" style="defaultEdge" targetX="432"

            targetY="239" transitionIndex="0" x="0" y="0"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1354736124625" description="Ends the workflow"

        displayName="Fail Workflow" height="34" interactive="0"

        jobMode="0" name="WorkflowEnd"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=WorkflowEnd;fillColor=#FF3333;gradientColor=#990000;fontColor=#000000"

        uniqueName="WorkflowEnd_5" waitSetting="0" width="123" x="415" y="316">

        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot;>FAILED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot;>Missing authorization code for user [xpath:{/workflow/inputs/userName}]&lt;/failureMessage>&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1354736217442"

        description="queries the database for the authorization code"

        displayName="Read Auth Code from DB" height="34" interactive="0"

        jobMode="0" name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=CommServDBQuery"

        uniqueName="CommServDBQuery_16" waitSetting="0" width="192"

        x="673" y="51">

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>SELECT count(*) FROM cloudAuthorization WHERE AuthCode=? AND Enabled=1&lt;/query>&lt;parameters>&lt;value>xpath:{/workflow/inputs/companyName}&lt;/value>&lt;type>OBJECT&lt;/type>&lt;/parameters>&lt;/inputs>"/>

        <transition activity="Decision_14" commented="0"

            originalStyle="" points="" sourceX="670" sourceY="80"

            status="0" style="defaultEdge" targetX="890" targetY="80"

            transitionIndex="0" x="0" y="0"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1354737584093"

        description="Checks if the authorization code provided by user is valid"

        displayName="Is Auth Code Valid?" height="100" interactive="0"

        jobMode="0" name="Decision"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_14" waitSetting="0" width="158" x="924" y="18">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{number(/workflow/CommServDBQuery_16/resultSets[1]/row[1]/col[1])} ==0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="CommServDBQuery_17" commented="0"

            displayName="YES" originalStyle="" points="1209.0,66.0"

            sourceX="890" sourceY="80" status="0" style="defaultEdge"

            targetX="1029" targetY="83" transitionIndex="0"

            value="false" x="0" y="0"/>

        <transition activity="Email_18" commented="0" displayName="NO"

            originalStyle="" points="" sourceX="1090" sourceY="68"

            status="0" style="defaultEdge" targetX="1097" targetY="339"

            transitionIndex="0" value="true" x="0" y="0"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1354737696767"

        description="Sends an email to the user that an authorization code is invalid"

        displayName="Email Invalid Auth Code" height="34"

        interactive="0" jobMode="0" maxRestarts="0" name="Email"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Email"

        uniqueName="Email_18" waitSetting="0" width="248" x="875" y="176">

        <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot;>&lt;from class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/adminEmail}&lt;/from>&lt;to class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/userEmail}&lt;/to>&lt;subject class=&quot;java.lang.String&quot;>Invalid Authorization Code&lt;/subject>&lt;body class=&quot;java.lang.String&quot;>&amp;lt;table class=&quot;content2&quot;&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;tr&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;td&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;p&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;#xD;&#xd;&#xa;          &amp;lt;/p&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;p&amp;gt;&amp;#xD;&#xd;&#xa;            Good day xpath:{/workflow/inputs/userFullName},&amp;#xD;&#xd;&#xa;          &amp;lt;/p&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;p&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;#xD;&#xd;&#xa;          &amp;lt;/p&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;p&amp;gt;&amp;#xD;&#xd;&#xa;            The authorization code that you have provided is invalid.&amp;#xD;&#xd;&#xa;          &amp;lt;/p&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;p&amp;gt;&amp;#xD;&#xd;&#xa;            Please contact your commcell administrator for a valid &amp;#xD;&#xd;&#xa;            authorization code to complete the registration.&amp;#xD;&#xd;&#xa;          &amp;lt;/p&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;p&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;#xD;&#xd;&#xa;          &amp;lt;/p&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;p&amp;gt;&amp;#xD;&#xd;&#xa;            Thank you&amp;#xD;&#xd;&#xa;          &amp;lt;/p&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;/td&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/tr&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/table&amp;gt;&lt;/body>&lt;html class=&quot;java.lang.Boolean&quot;>true&lt;/html>&lt;/email>&lt;/inputs>"/>

        <transition activity="GenericResponse_5" commented="0"

            originalStyle="" points="" sourceX="886" sourceY="175"

            status="0" style="defaultEdge" targetX="888" targetY="240"

            transitionIndex="0" x="0" y="0"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1354738040973" description="Ends the workflow"

        displayName="Fail Workflow" height="34" interactive="0"

        jobMode="0" name="WorkflowEnd"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=WorkflowEnd;fillColor=#FF3333;gradientColor=#990000;fontColor=#000000"

        uniqueName="WorkflowEnd_6" waitSetting="0" width="123" x="945" y="309">

        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot;>FAILED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot;>Invalid Authorization Code for user [xpath:{/workflow/inputs/userName}]&lt;/failureMessage>&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1354740201091"

        description="Queries the database to get the referral and the permission flags for the user trying to register."

        displayName="Get Referral and Flags" height="34" interactive="0"

        jobMode="0" name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=CommServDBQuery"

        uniqueName="CommServDBQuery_17" waitSetting="0" width="192"

        x="1230" y="54">

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>SELECT CVReferral, flags FROM cloudAuthorization WHERE AuthCode=?&lt;/query>&lt;parameters>&lt;value>xpath:{/workflow/inputs/companyName}&lt;/value>&lt;type>OBJECT&lt;/type>&lt;/parameters>&lt;/inputs>"/>

        <transition activity="AssignValues_3" commented="0"

            originalStyle="" points="" sourceX="1361" sourceY="73"

            status="0" style="defaultEdge" targetX="1358" targetY="137"

            transitionIndex="0" x="0" y="0"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1354908899468"

        description="Updates the user description in the workflow variables"

        displayName="set Description" height="34" interactive="0"

        jobMode="0" name="AssignValues"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=AssignValues" uniqueName="AssignValues_2"

        waitSetting="0" width="239" x="1205" y="244">

        <outputs variables="&lt;variables>&lt;userDescription class=&quot;java.lang.String&quot;>Referred by xpath:{/workflow/variables/referral}. xpath:{/workflow/inputs/userDescription}&lt;/userDescription>&lt;/variables>"/>

        <inputs val="&lt;inputs />"/>

        <transition activity="Execute_5" commented="0" originalStyle=""

            points="1331.0,291.0" sourceX="1582" sourceY="283"

            status="0" style="defaultEdge" targetX="1409" targetY="408"

            transitionIndex="0" x="0" y="0"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1355325670293"

        description="Error message is sent to the web console that the user needs to provide an authorization code"

        displayName="Respond to Web Console" height="34" interactive="0"

        jobMode="0" name="GenericResponse"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=GenericResponse"

        uniqueName="GenericResponse_4" waitSetting="0" width="193"

        x="384" y="244">

        <inputs val="&lt;inputs>&lt;errorCode class=&quot;java.lang.Integer&quot;>1&lt;/errorCode>&lt;errorMessage class=&quot;java.lang.String&quot;>Please provide an authorization code to complete the registration.&lt;/errorMessage>&lt;/inputs>"/>

        <transition activity="WorkflowEnd_5" commented="0"

            originalStyle="" points="481.0,300.0" sourceX="677"

            sourceY="369" status="0" style="defaultEdge" targetX="588"

            targetY="451" transitionIndex="0" x="0" y="0"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1355325853191"

        description="Error message is sent to the web console that the user needs to provide a valid authorization code"

        displayName="Respond to Web Console" height="34" interactive="0"

        jobMode="0" name="GenericResponse"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=GenericResponse"

        uniqueName="GenericResponse_5" waitSetting="0" width="193"

        x="900" y="245">

        <inputs val="&lt;inputs>&lt;errorCode class=&quot;java.lang.Integer&quot;>xpath:{/workflow/CommServDBQuery_16/errorCode}&lt;/errorCode>&lt;errorMessage class=&quot;java.lang.String&quot;>Please provide a valid registration code to complete the registration.&lt;/errorMessage>&lt;/inputs>"/>

        <transition activity="WorkflowEnd_6" commented="0"

            originalStyle="" points="1004.0,290.0" sourceX="1140"

            sourceY="356" status="0" style="defaultEdge" targetX="1046"

            targetY="437" transitionIndex="0" x="0" y="0"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1355515359735"

        description="Sets the referral and the permission flags (for the user trying to register) in the workflow variables"

        displayName="set Referral and Flags" height="34" interactive="0"

        jobMode="0" name="AssignValues"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=AssignValues" uniqueName="AssignValues_3"

        waitSetting="0" width="175" x="1240" y="123">

        <outputs variables="&lt;variables>&lt;referral class=&quot;java.lang.String&quot;>xpath:{/workflow/CommServDBQuery_17/resultSets[1]/row[1]/col[1]}&lt;/referral>&lt;flags class=&quot;java.lang.Integer&quot;>java:{ xpath:{/workflow/CommServDBQuery_17/resultSets[1]/row[1]/col[2]}&amp;amp;255}&lt;/flags>&lt;permissions class=&quot;java.lang.Integer&quot;>java:{ xpath:{/workflow/CommServDBQuery_17/resultSets[1]/row[1]/col[2]}&amp;amp;768}&lt;/permissions>&lt;/variables>"/>

        <inputs val="&lt;inputs />"/>

        <transition activity="Email_26" commented="0" originalStyle=""

            points="1329.0,173.0" sourceX="1355" sourceY="151"

            status="0" style="defaultEdge" targetX="1353" targetY="480"

            transitionIndex="0" x="0" y="0"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1357163850807"

        description="Sends an email to the registering user and the users referral to indicate that the registration request has been received"

        displayName="Request received email" height="34" interactive="0"

        jobMode="0" maxRestarts="0" name="Email"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Email"

        uniqueName="Email_26" waitSetting="0" width="184" x="1237" y="183">

        <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot;>&lt;from class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/adminEmail}&lt;/from>&lt;to class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/userEmail};xpath:{/workflow/variables/referral}&lt;/to>&lt;subject class=&quot;java.lang.String&quot;>Your registration request has been received&lt;/subject>&lt;body class=&quot;java.lang.String&quot;>&amp;lt;table class=&quot;content2&quot;&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;tr&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;td&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;div&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;p&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;#xD;&#xd;&#xa;            &amp;lt;/p&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;p&amp;gt;&amp;#xD;&#xd;&#xa;              Good day xpath:{/workflow/inputs/userFullName},&amp;#xD;&#xd;&#xa;            &amp;lt;/p&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;p&amp;gt;&amp;#xD;&#xd;&#xa;              Your request for registration has been received. You will &amp;#xD;&#xd;&#xa;              receive an email confirmation once your account has been &amp;#xD;&#xd;&#xa;              activated.&amp;#xD;&#xd;&#xa;            &amp;lt;/p&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;p&amp;gt;&amp;#xD;&#xd;&#xa;              User Details:&amp;lt;br&amp;gt;&amp;lt;b&amp;gt;Name : &amp;lt;/b&amp;gt;xpath:{/workflow/inputs/userFullName}&amp;#xD;&#xd;&#xa;            &amp;lt;/p&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;p&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;b&amp;gt;E-mail : &amp;lt;/b&amp;gt;xpath:{/workflow/inputs/userEmail}&amp;#xD;&#xd;&#xa;            &amp;lt;/p&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;p&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;b&amp;gt;User Name : &amp;lt;/b&amp;gt;xpath:{/workflow/inputs/userName}&amp;#xD;&#xd;&#xa;            &amp;lt;/p&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;p&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;b&amp;gt;Referral: &amp;lt;/b&amp;gt;xpath:{/workflow/variables/referral}&amp;#xD;&#xd;&#xa;            &amp;lt;/p&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;p&amp;gt;&amp;#xD;&#xd;&#xa;              Thank you&amp;#xD;&#xd;&#xa;            &amp;lt;/p&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;/div&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;/td&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/tr&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/table&amp;gt;&lt;/body>&lt;html class=&quot;java.lang.Boolean&quot;>true&lt;/html>&lt;/email>&lt;/inputs>"/>

        <transition activity="AssignValues_2" commented="0"

            originalStyle="" points="" sourceX="1349" sourceY="490"

            status="0" style="defaultEdge" targetX="1358" targetY="557"

            transitionIndex="0" x="0" y="0"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1357855580471"

        description="Reads the Commsev admin email from the database"

        displayName="Get Admin email" height="34" interactive="0"

        jobMode="0" name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=CommServDBQuery"

        uniqueName="CommServDBQuery_24" waitSetting="0" width="162"

        x="142" y="117">

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>select email from UMUsers where flags &amp;amp; 0x040 = 0x040&lt;/query>&lt;/inputs>"/>

        <transition activity="AssignValues_12" commented="0"

            originalStyle="" points="" sourceX="429" sourceY="74"

            status="0" style="defaultEdge" targetX="424" targetY="169"

            transitionIndex="0" x="0" y="0"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1357855648170"

        description="Updates workflow variable - adminEmail"

        displayName="set Admin Email" height="34" interactive="0"

        jobMode="0" name="AssignValues"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=AssignValues" uniqueName="AssignValues_12"

        waitSetting="0" width="135" x="146" y="174">

        <outputs variables="&lt;variables>&lt;adminEmail class=&quot;java.lang.String&quot;>xpath:{/workflow/CommServDBQuery_24/resultSets[1]/row[1]/col[1]}&lt;/adminEmail>&lt;/variables>"/>

        <inputs val="&lt;inputs />"/>

        <transition activity="Decision_13" commented="0"

            originalStyle="" points="" sourceX="426" sourceY="165"

            status="0" style="defaultEdge" targetX="637" targetY="75"

            transitionIndex="0" x="0" y="0"/>

    </Activity>

</workflow>

'

IF not exists (select * from WF_Definition where Name = @name)

BEGIN
	INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision)


	VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision)

	SET @workflowId = @@IDENTITY
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


	VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

	SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = ISNULL(revision, '') From WF_Definition WHERE Name = @name

	IF (@currentFlags & 4 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0) AND (@currentRevision <> @revision)

	BEGIN

		SET @version = @version + 1

		UPDATE WF_Definition

		SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision

		WHERE Name = @name

		IF (@flags & 8 > 0 OR @flags & 16 > 0)

		BEGIN

			UPDATE WF_Definition

			SET flags = @flags

			WHERE Name = @name

		END
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


		VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

	END

END

