

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_NASRemoteSystemDiscovery.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/WFD_NASRemoteSystemDiscovery.script,v $ $Id: WFD_NASRemoteSystemDiscovery.script,v 1.7.2.8 2017/08/22 23:43:06 rmarigowda Exp $";
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER OFF

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.7.2.8 $'

SET @name = 'System Discovery for NAS'

SET @description = 'Collect information about Storage Pools, Volumes, LUNs etc for NAS File Servers'

SET @version = 1

SET @flags = 14

SET @definition = '<workflow apiMode="0" config="&lt;configuration />"

    description="Collect information about Storage Pools, Volumes, LUNs etc for NAS File Servers"

    inputs="&lt;inputs />" interactive="0" isHtmlDescription="0"

    name="System Discovery for NAS" outputs="&lt;outputs />"

    revision="$Revision: 1.7.2.8 $"

    uniqueGuid="5f90f6cd-0782-4281-a10c-7211634770f8"

    variables="&lt;variables>&lt;AuthCode class=&quot;java.lang.String&quot; />&lt;RestAPIReqMsg class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;sURL class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;CreationTime class=&quot;java.lang.Long&quot; _list_=&quot;false&quot; />&lt;RestAPIReqMsgForSearchArrays class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;RestAPIReqMsgForSearchSPools class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;RestAPIReqMsgForSearchVolumes class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;RestAPIReqMsgForSearchLUNs class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;RestAPIReqMsgForSearchCelerraArrays class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/variables>"

    webHidden="0" workflowId="0">

    <schema>

        <outputs attribute="0" className="" listType="0" name="outputs"

            required="1" type=""/>

        <variables attribute="0" className="" listType="0"

            name="variables" required="1" type="">

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" hidden="0"

                inputType="java.lang.String" listType="0"

                name="AuthCode" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="RestAPIReqMsg" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" hidden="0"

                inputType="java.lang.String" listType="0" name="sURL"

                required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.Long"

                controlType="0" defaultValue="" hidden="0"

                inputType="java.lang.Long" listType="0"

                name="CreationTime" required="0" type="{http://www.w3.org/2001/XMLSchema}long"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" hidden="0"

                inputType="java.lang.String" listType="0"

                name="RestAPIReqMsgForSearchArrays" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" hidden="0"

                inputType="java.lang.String" listType="0"

                name="RestAPIReqMsgForSearchSPools" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" hidden="0"

                inputType="java.lang.String" listType="0"

                name="RestAPIReqMsgForSearchVolumes" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" hidden="0"

                inputType="java.lang.String" listType="0"

                name="RestAPIReqMsgForSearchLUNs" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" hidden="0"

                inputType="java.lang.String" listType="0"

                name="RestAPIReqMsgForSearchCelerraArrays" type="{http://www.w3.org/2001/XMLSchema}string"/>

        </variables>

        <inputs attribute="0" className="" listType="0" name="inputs"

            required="1" type=""/>

        <config className="" name="" type=""/>

    </schema>

    <Start commented="0" continueOnFailure="0" created="0"

        description="" displayName="Start" height="40" interactive="0"

        jobMode="0" name="Start" originalStyle="" skipAttempt="0"

        style="image;image=/images/jgraphx/house.png"

        uniqueName="Start_1" waitSetting="0" width="63" x="12" y="65">

        <inputs val="&lt;inputs />"/>

        <transition activity="GetAnalyticsEngineInfo" commented="0"

            originalStyle="" points="" sourceX="-59" sourceY="275"

            status="0" style="defaultEdge" targetX="206" targetY="165"

            transitionIndex="0" x="-148" y="65">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Start>

    <Activity commented="0" continueOnFailure="0"

        created="1419371348997"

        description="executes queries against a commcell database"

        displayName="Get Arrays for Discovery" height="34"

        interactive="0" jobMode="0" name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=CommServDBQuery"

        uniqueName="GetArraysFromArrayManagement" waitSetting="0"

        width="194" x="127" y="327">

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>EXEC GetArraysForDiscovery&lt;/query>&lt;/inputs>"/>

        <transition activity="ForEachArray" commented="0"

            originalStyle="" points="" sourceX="94" sourceY="642"

            status="0" style="defaultEdge" targetX="301" targetY="344"

            transitionIndex="0" x="-370" y="214">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1420044291459"

        description="iterates a group of activities over a list of values"

        displayName="For each Array in Array Management" height="240"

        interactive="0" jobMode="0" name="ForEach"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ForEachArray" waitSetting="0" width="252" x="101" y="484">

        <inputs val="&lt;inputs>&lt;name class=&quot;java.lang.String&quot;>row&lt;/name>&lt;values class=&quot;java.lang.Object&quot;>xpath:{/workflow/GetArraysFromArrayManagement/resultSets[1]/row}&lt;/values>&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot;>1&lt;/numberOfParallelExecutions>&lt;continueOnFailure class=&quot;java.lang.Boolean&quot;>true&lt;/continueOnFailure>&lt;/inputs>"/>

        <superProcess>

            <Start commented="0" continueOnFailure="0"

                created="1420044291459" description=""

                displayName="Start" height="30" interactive="0"

                jobMode="0" name="Start" originalStyle=""

                skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_4" waitSetting="0" width="120" x="58" y="60">

                <inputs val="&lt;inputs />"/>

                <transition activity="RunDiscoveryExe" commented="0"

                    originalStyle="" points="" sourceX="51"

                    sourceY="235" status="0" style="defaultEdge"

                    targetX="52" targetY="318" transitionIndex="0"

                    x="-27" y="190">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity commented="0" continueOnFailure="0"

                created="1420044551162"

                description="Execute a command on a remote machine"

                displayName="ExecuteCommand" height="34" interactive="0"

                jobMode="0" maxRestarts="0" name="ExecuteCommand"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=ExecuteCommand"

                uniqueName="RunDiscoveryExe" waitSetting="0" width="147"

                x="46" y="153">

                <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/ForEachArray/row/col[@name=&quot;SMArrayController&quot;]}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; />&lt;command class=&quot;java.lang.String&quot;>NASSystemDiscovery&lt;/command>&lt;arguments class=&quot;java.lang.String&quot;>-array xpath:{/workflow/ForEachArray/row/col[@name=&quot;SMArrayId&quot;]} -vendorId xpath:{/workflow/ForEachArray/row/col[@name=&quot;SMVendorId&quot;]} -controlHost xpath:{/workflow/ForEachArray/row/col[@name=&quot;SMHostName&quot;]} -physicalArray xpath:{/workflow/ForEachArray/row/col[@name=&quot;phyArray&quot;]} -user xpath:{/workflow/ForEachArray/row/col[@name=&quot;SMHostUserName&quot;]} -password xpath:{/workflow/ForEachArray/row/col[@name=&quot;SMHostPassword&quot;]} -jobId xpath:{/workflow/system/jobId} -ma xpath:{/workflow/ForEachArray/row/col[@name=&quot;SMArrayController&quot;]} -interfaceType xpath:{/workflow/ForEachArray/row/col[@name=&quot;FilerType&quot;]} -instance java:{commvault.cte.workflow.WorkflowRegistry.getInstance().getVmInstance()} -sURL xpath:{/workflow/GetAnalyticsEngineInfo/resultSets[1]/row[1]/col[@name=''serverName'']}&lt;/arguments>&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

            </Activity>

        </superProcess>

        <activitySchema>

            <outputs name="outputs">

                <children attribute="0"

                    className="workflow.types.data.DataRow"

                    defaultValue="" hidden="0"

                    inputType="workflow.types.data.DataRow" listType="0"

                    name="row" type="{workflow.types.data}DataRow">

                    <children attribute="0" className="java.lang.Object"

                        defaultValue="" hidden="0"

                        inputType="java.lang.Object" listType="1"

                        name="col" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                </children>

            </outputs>

            <inputs>

                <children className="java.lang.String"

                    inputType="java.lang.String" name="name" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children className="java.lang.Object"

                    inputType="java.lang.Object" name="values" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                <children className="java.lang.Integer" defaultValue="1"

                    inputType="java.lang.Integer"

                    name="numberOfParallelExecutions" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                <children className="java.lang.Boolean"

                    defaultValue="false" inputType="java.lang.Boolean"

                    name="continueOnFailure" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

            </inputs>

        </activitySchema>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1430778774765"

        description="executes queries against a commcell database"

        displayName="Get Analytics Engine Info" height="34"

        interactive="0" jobMode="0" name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=CommServDBQuery"

        uniqueName="GetAnalyticsEngineInfo" waitSetting="0" width="196"

        x="202" y="68">

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>EXEC DM2GetAllAnalyticsEngine ''NAS Array Reporting''&lt;/query>&lt;/inputs>"/>

        <transition activity="GetURL" commented="0" originalStyle=""

            points="" sourceX="189" sourceY="167" status="0"

            style="defaultEdge" targetX="433" targetY="158"

            transitionIndex="0" x="-103" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1430859584734" description="performs http operations"

        displayName="CreateDataSource" height="34" interactive="0"

        jobMode="0" name="HttpClient"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=HttpClient"

        uniqueName="CreateDataSource" waitSetting="0" width="135"

        x="878" y="68">

        <inputs val="&lt;inputs>&lt;request>&lt;url>/SearchSvc/CVWebService.svc/dcube/CreateDataSource&lt;/url>&lt;method>POST&lt;/method>&lt;postType>Raw&lt;/postType>&lt;postContent>xpath:{/workflow/variables/RestAPIReqMsg}&lt;/postContent>&lt;postContentType>application/xml; charset=UTF-8&lt;/postContentType>&lt;headers>&lt;name>Authtoken&lt;/name>&lt;value>QSDKONLY xpath:{/workflow/system/token}&lt;/value>&lt;/headers>&lt;/request>&lt;/inputs>"/>

        <transition activity="ValidateRestAPIOutput" commented="0"

            originalStyle="" points="" sourceX="945" sourceY="85"

            status="0" style="defaultEdge" targetX="1150" targetY="84"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1430932650665"

        description="activity to execute code snippets in the selected language"

        displayName="ValidateRestAPIOutput" height="34" interactive="0"

        jobMode="0" name="Script"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Script"

        uniqueName="ValidateRestAPIOutput" waitSetting="0" width="159"

        x="1070" y="68">

        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;import commvault.msgs.DM2ContentIndexing.*;&amp;#xD;&amp;#xA;import commvault.cte.common.xml.XMLDecoder;&amp;#xD;&amp;#xA;import commvault.cte.common.xml.XMLEncoder;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    GetCollectionsResp oCollectionresp = (GetCollectionsResp)XMLDecoder.decode(xpath:{/workflow/CreateDataSource/output});&amp;#xD;&amp;#xA;    commvault.msgs.DM2ContentIndexing.Error oError = oCollectionresp.getError();&amp;#xD;&amp;#xA;    Integer __NOERROR = new Integer(0);&amp;#xD;&amp;#xA;    Integer __DATASOURCEEXISTS = new Integer(10631);&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    Integer iErr = new Integer(oError.getErrorCode()); &amp;#xD;&amp;#xA;    logger.info(&amp;quot;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;Error Code &amp;quot; + iErr.toString() +  &amp;quot;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;quot;);&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    if(iErr.equals(__NOERROR))&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        logger.info(&amp;quot;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;Created new Data Source for this user&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;quot;);&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    else if(iErr.equals(__DATASOURCEEXISTS))&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        logger.info(&amp;quot;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;Data Source already exists&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;quot;);&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    else&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        String sErrorMsg = &amp;quot;REST API[CreateDataSource] failed.&amp;quot;;&amp;#xD;&amp;#xA;        workflow.setFailed(sErrorMsg);&amp;#xD;&amp;#xA;    }    &amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(Exception e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    workflow.setFailed(&amp;quot;Error while forming the request:&amp;quot;+ e.getMessage());     &amp;#xD;&amp;#xA;}&quot; />&lt;/inputs>"/>

        <transition activity="GetDataSourceId" commented="0"

            originalStyle="" points="" sourceX="1149" sourceY="85"

            status="0" style="defaultEdge" targetX="1156" targetY="165"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1430936276996"

        description="activity to execute code snippets in the selected language"

        displayName="FormRESTInput" height="34" interactive="0"

        jobMode="0" name="Script"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Script"

        uniqueName="FormRESTInput" waitSetting="0" width="136" x="663" y="68">

        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;import commvault.msgs.DM2ContentIndexing.*;&amp;#xD;&amp;#xA;import commvault.cte.common.xml.XMLDecoder;&amp;#xD;&amp;#xA;import commvault.cte.common.xml.XMLEncoder;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    //validate the previous activity output&amp;#xD;&amp;#xA;    if((xpath:{/workflow/GetAnalyticsEngineInfo/resultSets[1]/row[1]/col[@name=''cloudId'']} == null) || &amp;#xD;&amp;#xA;       (xpath:{/workflow/GetAnalyticsEngineInfo/resultSets[1]/row[1]/col[@name=''cloudId'']} == 0))&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        String sErrorMsg = &amp;quot;Invalid Cloud ID.&amp;quot;;&amp;#xD;&amp;#xA;        workflow.setFailed(sErrorMsg);  &amp;#xD;&amp;#xA;        return false;  &amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    String sReqXML = &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;&amp;#x9;&amp;#xD;&amp;#xA;&amp;#x9;CreateDataSourceReq oCreateNewDataSource = new CreateDataSourceReq();&amp;#xD;&amp;#xA;    CreateCollectionReq oCollectionReq = new CreateCollectionReq();&amp;#xD;&amp;#xA;    CIServer oCIServer = new CIServer();&amp;#xD;&amp;#xA;    SEDataSource oDSProps = new SEDataSource();&amp;#xD;&amp;#xA;    SEDSType oType = SEDSType.nas;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;    oCollectionReq.setAttribute(3);&amp;#xD;&amp;#xA;    oCollectionReq.setCollectionName(&amp;quot;nasdb&amp;quot;);&amp;#xD;&amp;#xA;    oCIServer.setCloudID(xpath:{/workflow/GetAnalyticsEngineInfo/resultSets[1]/row[1]/col[@name=''cloudId'']});&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;    oCollectionReq.setCiserver(oCIServer);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;    oDSProps.setAttribute(0);&amp;#xD;&amp;#xA;    oDSProps.setDatasourceName(&amp;quot;DS_Array_Data&amp;quot;);&amp;#xD;&amp;#xA;    oDSProps.setDatasourceType(oType);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;    oCreateNewDataSource.setCollectionReq(oCollectionReq);&amp;#xD;&amp;#xA;    oCreateNewDataSource.setDataSource(oDSProps);&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    sReqXML = XMLEncoder.encode(oCreateNewDataSource);&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;RestAPIReqMsg&amp;quot;, sReqXML);&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    logger.info(&amp;quot;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;The Request XML to Create a new Data Source is &amp;quot; + sReqXML +  &amp;quot;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;quot;);    &amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(Exception e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    workflow.setFailed(&amp;quot;Error while forming create data source the request:&amp;quot;+ e.getMessage());     &amp;#xD;&amp;#xA;}&quot; />&lt;/inputs>"/>

        <transition activity="CreateDataSource" commented="0"

            originalStyle="" points="" sourceX="543" sourceY="85"

            status="0" style="defaultEdge" targetX="913" targetY="84"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1431129803558"

        description="executes queries against a commcell database"

        displayName="GetDataSourceId" height="34" interactive="0"

        jobMode="0" name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=CommServDBQuery" uniqueName="GetDataSourceId"

        waitSetting="0" width="143" x="1077" y="327">

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>SELECT sed.DataSourceId as ''DataSourceId'', sesv.SearchViewId as ''SearchViewId'', sesv.SearchViewName as ''SearchViewName'' &amp;#xD;&#xd;&#xa;FROM SEDataSource sed &amp;#xD;&#xd;&#xa;inner join SESearchView sesv&amp;#xD;&#xd;&#xa;on sed.DataSourceId = sesv.DataSourceId&amp;#xD;&#xd;&#xa;WHERE DataSourceName = ''DS_Array_Data''&lt;/query>&lt;/inputs>"/>

        <transition activity="FormRestInputForSearch" commented="0"

            originalStyle="" points="" sourceX="1148" sourceY="344"

            status="0" style="defaultEdge" targetX="955" targetY="344"

            transitionIndex="0" x="3" y="168">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1431130141239"

        description="activity to execute code snippets in the selected language"

        displayName="GetURL" height="34" interactive="0" jobMode="0"

        name="Script" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Script"

        uniqueName="GetURL" waitSetting="0" width="100" x="484" y="68">

        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;import java.lang.*;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    String sURL = xpath:{/workflow/GetAnalyticsEngineInfo/resultSets[1]/row[1]/col[@name=''serverName'']};&amp;#xD;&amp;#xA;    int iBasePort = xpath:{/workflow/GetAnalyticsEngineInfo/resultSets[1]/row[1]/col[@name=''basePort'']};&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    String sBasePort = Integer.toString(iBasePort);&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    logger.info(&amp;quot;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;Port is is &amp;quot; + sBasePort +  &amp;quot; &amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;quot;);&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    int iIndex = sURL.indexOf(&amp;quot;:&amp;quot; + sBasePort);&amp;#xD;&amp;#xA;    String sURLSub = &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    if(iIndex != -1)&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        sURLSub = sURL.substring(0, iIndex);&amp;#xD;&amp;#xA;        logger.info(&amp;quot;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;URL is &amp;quot; + sURLSub +  &amp;quot; &amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;quot;);&amp;#xD;&amp;#xA;        workflow.setVariable(&amp;quot;sURL&amp;quot;, sURLSub);&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        //Set Creation Time&amp;#xD;&amp;#xA;        long lUnixTimeStamp = System.currentTimeMillis()/1000L; &amp;#xD;&amp;#xA;        workflow.setVariable(&amp;quot;CreationTime&amp;quot;, lUnixTimeStamp);&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    else&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        String sErrorMsg = &amp;quot;Invalid URL&amp;quot;;&amp;#xD;&amp;#xA;        workflow.setFailed(sErrorMsg);        &amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(Exception e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    workflow.setFailed(&amp;quot;Error while forming the URL&amp;quot;+ e.getMessage());     &amp;#xD;&amp;#xA;}&quot; />&lt;/inputs>"/>

        <transition activity="FormRESTInput" commented="0"

            originalStyle="" points="" sourceX="433" sourceY="159"

            status="0" style="defaultEdge" targetX="218" targetY="238"

            transitionIndex="0" x="-103" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1431132075658"

        description="activity to execute code snippets in the selected language"

        displayName="FormRestInputForSearch" height="34" interactive="0"

        jobMode="0" name="Script"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Script"

        uniqueName="FormRestInputForSearch" waitSetting="0" width="172"

        x="849" y="327">

        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;import commvault.msgs.DM2ContentIndexing.*;&amp;#xD;&amp;#xA;import commvault.cte.common.xml.XMLDecoder;&amp;#xD;&amp;#xA;import commvault.cte.common.xml.XMLEncoder;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    //validate the previous activity output&amp;#xD;&amp;#xA;    Integer iDSId = xpath:{/workflow/GetDataSourceId/resultSets[1]/row[1]/col[@name=''DataSourceId'']};&amp;#xD;&amp;#xA;    if((iDSId == null) || &amp;#xD;&amp;#xA;       (iDSId == 0))&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        String sErrorMsg = &amp;quot;Invalid Data Source ID.&amp;quot;;&amp;#xD;&amp;#xA;        workflow.setFailed(sErrorMsg);  &amp;#xD;&amp;#xA;        return false;  &amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    String sReqXML = &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;&amp;#x9;&amp;#xD;&amp;#xA;&amp;#x9;SESearchView oCreateSearchViewReq = new SESearchView();&amp;#xD;&amp;#xA;    oCreateSearchViewReq.setDataSourceId(iDSId);    &amp;#xD;&amp;#xA;    oCreateSearchViewReq.setAttribute(0);    &amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;&amp;#x9;String[] sSearchViewNames = {&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;&amp;quot;Discovery Data for Arrays&amp;quot;,&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;&amp;quot;Discovery Data for Storage Pools&amp;quot;,&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;&amp;quot;Discovery Data for Volumes&amp;quot;,&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;&amp;quot;Discovery Data for LUNs&amp;quot;,&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;&amp;quot;Discovery Data for EMC Celerra Arrays&amp;quot;&amp;#xD;&amp;#xA;&amp;#x9;};&amp;#xD;&amp;#xA;&amp;#x9;&amp;#xD;&amp;#xA;&amp;#x9;int[] nSearchViewIds = {0,0,0,0,0};&amp;#xD;&amp;#xA;&amp;#x9;int rowCount = xpath:{/workflow/GetDataSourceId/resultSets[1]/rowCount};&amp;#xD;&amp;#xA;&amp;#x9;&amp;#xD;&amp;#xA;&amp;#x9;for(int i=1;i&amp;lt;rowCount;i++)&amp;#xD;&amp;#xA;&amp;#x9;{&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;for(int j=0; j&amp;lt;sSearchViewNames.length; j++)&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;{&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;&amp;#x9;workflow.types.data.DataRow dr = xpath:{/workflow/GetDataSourceId/resultSets[1]/row}.get(i);&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;&amp;#x9;if(dr.get(&amp;quot;SearchViewName&amp;quot;).equals(&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;&amp;#x9;&amp;#x9;sSearchViewNames[j]))&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;&amp;#x9;{&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;&amp;#x9;&amp;#x9;nSearchViewIds[j] = dr.get(&amp;quot;SearchViewId&amp;quot;);&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;&amp;#x9;&amp;#x9;break;&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;&amp;#x9;}&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;}&amp;#xD;&amp;#xA;&amp;#x9;}&amp;#xD;&amp;#xA;&amp;#x9;&amp;#xD;&amp;#xA;    //Set the search view for Arrays&amp;#xD;&amp;#xA;    oCreateSearchViewReq.setSearchViewName(sSearchViewNames[0]);     &amp;#xD;&amp;#xA;&amp;#x9;oCreateSearchViewReq.setSearchViewId(nSearchViewIds[0]);&amp;#xD;&amp;#xA;    oCreateSearchViewReq.setViewInfo(&amp;quot;{\&amp;quot;facetPanelTitle\&amp;quot;:\&amp;quot;Filter\&amp;quot;,\&amp;quot;columnConfig\&amp;quot;:[{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;contentid\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:0,\&amp;quot;dispName\&amp;quot;:\&amp;quot;contentid\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;nasdbid\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:1,\&amp;quot;dispName\&amp;quot;:\&amp;quot;nasdbid\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;Hash\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:2,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Hash\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;DocumentType\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:3,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Array Entity Type\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayManagementName\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:4,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayManagementName\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayName\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:5,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Array Name\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayOSVersion\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:6,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayOSVersion\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayFirmwareVersion\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:7,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayFirmwareVersion\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayUniqueId\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:8,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayUniqueId\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayStatus\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:9,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayStatus\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArraySerialNumber\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:10,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArraySerialNumber\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayModelNumber\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:11,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayModelNumber\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;PercentageUsedArray\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:12,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Array Percentage Used\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayTotalSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:12,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Array Total Space in GB\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayUsedSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:13,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Array Used Space in GB\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayFreeSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:14,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Array Free Space in GB\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayProperties\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:15,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayProperties\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;StoragePoolName\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:16,\&amp;quot;dispName\&amp;quot;:\&amp;quot;StoragePoolName\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;StoragePoolUniqueId\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:17,\&amp;quot;dispName\&amp;quot;:\&amp;quot;StoragePoolUniqueId\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;StoragePoolStatus\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:18,\&amp;quot;dispName\&amp;quot;:\&amp;quot;StoragePoolStatus\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;StoragePoolVolumeCount\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:19,\&amp;quot;dispName\&amp;quot;:\&amp;quot;StoragePoolVolumeCount\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;StoragePoolTotalSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:20,\&amp;quot;dispName\&amp;quot;:\&amp;quot;StoragePoolTotalSpace\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;StoragePoolUsedSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:21,\&amp;quot;dispName\&amp;quot;:\&amp;quot;StoragePoolUsedSpace\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;StoragePoolProperties\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:22,\&amp;quot;dispName\&amp;quot;:\&amp;quot;StoragePoolProperties\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayVolumeName\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:23,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayVolumeName\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayVolumePath\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:24,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayVolumePath\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayVolumeUniqueId\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:25,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayVolumeUniqueId\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayVolumeStatus\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:26,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayVolumeStatus\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayVolumeTotalSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:27,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayVolumeTotalSpace\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayVolumeUsedSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:28,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayVolumeUsedSpace\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayVolumeFreeSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:29,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayVolumeFreeSpace\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayVolumeProperties\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:30,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayVolumeProperties\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;LUNName\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:31,\&amp;quot;dispName\&amp;quot;:\&amp;quot;LUNName\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;LUNPath\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:32,\&amp;quot;dispName\&amp;quot;:\&amp;quot;LUNPath\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;LUNUniqueId\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:33,\&amp;quot;dispName\&amp;quot;:\&amp;quot;LUNUniqueId\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;LUNStatus\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:34,\&amp;quot;dispName\&amp;quot;:\&amp;quot;LUNStatus\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;LUNSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:35,\&amp;quot;dispName\&amp;quot;:\&amp;quot;LUNSpace\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;LUNUsedSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:36,\&amp;quot;dispName\&amp;quot;:\&amp;quot;LUNUsedSpace\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;LUNFreeSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:37,\&amp;quot;dispName\&amp;quot;:\&amp;quot;LUNFreeSpace\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;LUNProperties\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:38,\&amp;quot;dispName\&amp;quot;:\&amp;quot;LUNProperties\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;NFSExportName\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:39,\&amp;quot;dispName\&amp;quot;:\&amp;quot;NFSExportName\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;NFSExportPathName\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:40,\&amp;quot;dispName\&amp;quot;:\&amp;quot;NFSExportPathName\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;NFSExportSecurityRules\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:41,\&amp;quot;dispName\&amp;quot;:\&amp;quot;NFSExportSecurityRules\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;NFSExportProperties\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:42,\&amp;quot;dispName\&amp;quot;:\&amp;quot;NFSExportProperties\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;CIFSShareName\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:43,\&amp;quot;dispName\&amp;quot;:\&amp;quot;CIFSShareName\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;CIFSSharePath\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:44,\&amp;quot;dispName\&amp;quot;:\&amp;quot;CIFSSharePath\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;CIFSShareDescription\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:45,\&amp;quot;dispName\&amp;quot;:\&amp;quot;CIFSShareDescription\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;CIFSShareACL\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:46,\&amp;quot;dispName\&amp;quot;:\&amp;quot;CIFSShareACL\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;CIFSShareProperties\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:47,\&amp;quot;dispName\&amp;quot;:\&amp;quot;CIFSShareProperties\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;Flags\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:48,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Flags\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;CreationTime\&amp;quot;,\&amp;quot;renderer\&amp;quot;:{\&amp;quot;type\&amp;quot;:\&amp;quot;date\&amp;quot;},\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:49,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Discovery Timestamp\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;UpdateTime\&amp;quot;,\&amp;quot;renderer\&amp;quot;:{\&amp;quot;type\&amp;quot;:\&amp;quot;date\&amp;quot;},\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:50,\&amp;quot;dispName\&amp;quot;:\&amp;quot;UpdateTime\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;DeletionTime\&amp;quot;,\&amp;quot;renderer\&amp;quot;:{\&amp;quot;type\&amp;quot;:\&amp;quot;date\&amp;quot;},\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:51,\&amp;quot;dispName\&amp;quot;:\&amp;quot;DeletionTime\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ReserveFieldInt1\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:52,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ReserveFieldInt1\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ReserveFieldInt2\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:53,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ReserveFieldInt2\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ReserveFieldStr\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:54,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ReserveFieldStr\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;dicom_vr_val\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:false,\&amp;quot;dispOrder\&amp;quot;:55,\&amp;quot;dispName\&amp;quot;:\&amp;quot;dicom_vr_val\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;dicom_vr_len\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:false,\&amp;quot;dispOrder\&amp;quot;:56,\&amp;quot;dispName\&amp;quot;:\&amp;quot;dicom_vr_len\&amp;quot;,\&amp;quot;visible\&amp;quot;:false}],\&amp;quot;tableConfig\&amp;quot;:{\&amp;quot;order\&amp;quot;:[],\&amp;quot;pageLength\&amp;quot;:20},\&amp;quot;facetConfig\&amp;quot;:[{\&amp;quot;noOfValuesToShow\&amp;quot;:500,\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayName\&amp;quot;,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Array Name\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:0},{\&amp;quot;noOfValuesToShow\&amp;quot;:5,\&amp;quot;fieldName\&amp;quot;:\&amp;quot;DocumentType\&amp;quot;,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Array Entity Type\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:1},{\&amp;quot;noOfValuesToShow\&amp;quot;:5,\&amp;quot;fieldName\&amp;quot;:\&amp;quot;CreationTime\&amp;quot;,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Discovery Timestamp\&amp;quot;,\&amp;quot;renderer\&amp;quot;:{\&amp;quot;type\&amp;quot;:\&amp;quot;date\&amp;quot;,\&amp;quot;fmt\&amp;quot;:\&amp;quot;MM/DD/YYYY hh:mm:ss A\&amp;quot;},\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:2}]}&amp;quot;);      &amp;#xD;&amp;#xA;    sReqXML = XMLEncoder.encode(oCreateSearchViewReq);        &amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;RestAPIReqMsgForSearchArrays&amp;quot;, sReqXML);    &amp;#xD;&amp;#xA;    logger.info(&amp;quot;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;The Request XML to Create a new Search View for Arrays is &amp;quot; + sReqXML +  &amp;quot;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;quot;);&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    //Set the search view for Storage Pools&amp;#xD;&amp;#xA;    oCreateSearchViewReq.setSearchViewName(sSearchViewNames[1]);&amp;#xD;&amp;#xA;&amp;#x9;oCreateSearchViewReq.setSearchViewId(nSearchViewIds[1]);&amp;#xD;&amp;#xA;    oCreateSearchViewReq.setViewInfo(&amp;quot;{\&amp;quot;facetPanelTitle\&amp;quot;:\&amp;quot;Filter\&amp;quot;,\&amp;quot;columnConfig\&amp;quot;:[{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;contentid\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:0,\&amp;quot;dispName\&amp;quot;:\&amp;quot;contentid\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;nasdbid\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:1,\&amp;quot;dispName\&amp;quot;:\&amp;quot;nasdbid\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;Hash\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:2,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Hash\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;DocumentType\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:3,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Array Entity Type\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayManagementName\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:4,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayManagementName\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayName\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:5,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Array Name\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayOSVersion\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:6,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayOSVersion\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayFirmwareVersion\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:7,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayFirmwareVersion\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayUniqueId\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:8,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayUniqueId\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayStatus\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:9,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayStatus\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArraySerialNumber\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:10,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArraySerialNumber\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayModelNumber\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:11,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayModelNumber\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;PercentageUsedArray\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:12,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Array Percentage Used\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;PercentageUsedStoragePool\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:12,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Storage Pool Percentage Used\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayTotalSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:12,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayTotalSpace\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayUsedSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:13,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayUsedSpace\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayFreeSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:14,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayFreeSpace\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayProperties\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:15,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayProperties\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;StoragePoolName\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:16,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Storage Pool Name\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;StoragePoolUniqueId\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:17,\&amp;quot;dispName\&amp;quot;:\&amp;quot;StoragePoolUniqueId\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;StoragePoolStatus\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:18,\&amp;quot;dispName\&amp;quot;:\&amp;quot;StoragePoolStatus\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;StoragePoolVolumeCount\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:19,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Volume Count\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;StoragePoolTotalSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:20,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Storage Pool Total Space in GB\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;StoragePoolUsedSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:21,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Storage Pool Used Space in GB\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;StoragePoolProperties\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:22,\&amp;quot;dispName\&amp;quot;:\&amp;quot;StoragePoolProperties\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayVolumeName\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:23,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayVolumeName\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayVolumePath\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:24,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayVolumePath\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayVolumeUniqueId\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:25,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayVolumeUniqueId\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayVolumeStatus\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:26,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayVolumeStatus\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayVolumeTotalSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:27,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayVolumeTotalSpace\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayVolumeUsedSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:28,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayVolumeUsedSpace\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayVolumeFreeSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:29,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayVolumeFreeSpace\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayVolumeProperties\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:30,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayVolumeProperties\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;LUNName\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:31,\&amp;quot;dispName\&amp;quot;:\&amp;quot;LUNName\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;LUNPath\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:32,\&amp;quot;dispName\&amp;quot;:\&amp;quot;LUNPath\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;LUNUniqueId\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:33,\&amp;quot;dispName\&amp;quot;:\&amp;quot;LUNUniqueId\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;LUNStatus\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:34,\&amp;quot;dispName\&amp;quot;:\&amp;quot;LUNStatus\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;LUNSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:35,\&amp;quot;dispName\&amp;quot;:\&amp;quot;LUNSpace\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;LUNUsedSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:36,\&amp;quot;dispName\&amp;quot;:\&amp;quot;LUNUsedSpace\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;LUNFreeSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:37,\&amp;quot;dispName\&amp;quot;:\&amp;quot;LUNFreeSpace\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;LUNProperties\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:38,\&amp;quot;dispName\&amp;quot;:\&amp;quot;LUNProperties\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;NFSExportName\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:39,\&amp;quot;dispName\&amp;quot;:\&amp;quot;NFSExportName\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;NFSExportPathName\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:40,\&amp;quot;dispName\&amp;quot;:\&amp;quot;NFSExportPathName\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;NFSExportSecurityRules\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:41,\&amp;quot;dispName\&amp;quot;:\&amp;quot;NFSExportSecurityRules\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;NFSExportProperties\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:42,\&amp;quot;dispName\&amp;quot;:\&amp;quot;NFSExportProperties\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;CIFSShareName\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:43,\&amp;quot;dispName\&amp;quot;:\&amp;quot;CIFSShareName\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;CIFSSharePath\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:44,\&amp;quot;dispName\&amp;quot;:\&amp;quot;CIFSSharePath\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;CIFSShareDescription\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:45,\&amp;quot;dispName\&amp;quot;:\&amp;quot;CIFSShareDescription\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;CIFSShareACL\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:46,\&amp;quot;dispName\&amp;quot;:\&amp;quot;CIFSShareACL\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;CIFSShareProperties\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:47,\&amp;quot;dispName\&amp;quot;:\&amp;quot;CIFSShareProperties\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;Flags\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:48,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Flags\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;CreationTime\&amp;quot;,\&amp;quot;renderer\&amp;quot;:{\&amp;quot;type\&amp;quot;:\&amp;quot;date\&amp;quot;,\&amp;quot;fmt\&amp;quot;:\&amp;quot;MM/DD/YYYY hh:mm:ss A\&amp;quot;},\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:49,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Discovery Timestamp\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;UpdateTime\&amp;quot;,\&amp;quot;renderer\&amp;quot;:{\&amp;quot;type\&amp;quot;:\&amp;quot;date\&amp;quot;,\&amp;quot;fmt\&amp;quot;:\&amp;quot;MM/DD/YYYY hh:mm:ss A\&amp;quot;},\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:50,\&amp;quot;dispName\&amp;quot;:\&amp;quot;UpdateTime\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;DeletionTime\&amp;quot;,\&amp;quot;renderer\&amp;quot;:{\&amp;quot;type\&amp;quot;:\&amp;quot;date\&amp;quot;,\&amp;quot;fmt\&amp;quot;:\&amp;quot;MM/DD/YYYY hh:mm:ss A\&amp;quot;},\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:51,\&amp;quot;dispName\&amp;quot;:\&amp;quot;DeletionTime\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ReserveFieldInt1\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:52,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ReserveFieldInt1\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ReserveFieldInt2\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:53,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ReserveFieldInt2\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ReserveFieldStr\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:54,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ReserveFieldStr\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;dicom_vr_val\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:false,\&amp;quot;dispOrder\&amp;quot;:55,\&amp;quot;dispName\&amp;quot;:\&amp;quot;dicom_vr_val\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;dicom_vr_len\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:false,\&amp;quot;dispOrder\&amp;quot;:56,\&amp;quot;dispName\&amp;quot;:\&amp;quot;dicom_vr_len\&amp;quot;,\&amp;quot;visible\&amp;quot;:false}],\&amp;quot;tableConfig\&amp;quot;:{\&amp;quot;order\&amp;quot;:[],\&amp;quot;pageLength\&amp;quot;:20},\&amp;quot;facetConfig\&amp;quot;:[{\&amp;quot;noOfValuesToShow\&amp;quot;:500,\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayName\&amp;quot;,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Array Name\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:0},{\&amp;quot;noOfValuesToShow\&amp;quot;:5,\&amp;quot;fieldName\&amp;quot;:\&amp;quot;DocumentType\&amp;quot;,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Array Entity Type\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:1},{\&amp;quot;noOfValuesToShow\&amp;quot;:5,\&amp;quot;fieldName\&amp;quot;:\&amp;quot;CreationTime\&amp;quot;,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Discovery Timestamp\&amp;quot;,\&amp;quot;renderer\&amp;quot;:{\&amp;quot;type\&amp;quot;:\&amp;quot;date\&amp;quot;,\&amp;quot;fmt\&amp;quot;:\&amp;quot;MM/DD/YYYY hh:mm:ss A\&amp;quot;},\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:2}]}&amp;quot;);    &amp;#xD;&amp;#xA;    sReqXML = XMLEncoder.encode(oCreateSearchViewReq);        &amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;RestAPIReqMsgForSearchSPools&amp;quot;, sReqXML);    &amp;#xD;&amp;#xA;    logger.info(&amp;quot;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;The Request XML to Create a new Search View for Storage Pools is &amp;quot; + sReqXML +  &amp;quot;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;quot;);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;    //Set the search view for Volumes&amp;#xD;&amp;#xA;    oCreateSearchViewReq.setSearchViewName(sSearchViewNames[2]);&amp;#xD;&amp;#xA;&amp;#x9;oCreateSearchViewReq.setSearchViewId(nSearchViewIds[2]);&amp;#xD;&amp;#xA;    oCreateSearchViewReq.setViewInfo(&amp;quot;{\&amp;quot;facetPanelTitle\&amp;quot;:\&amp;quot;Filter\&amp;quot;,\&amp;quot;columnConfig\&amp;quot;:[{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;contentid\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:0,\&amp;quot;dispName\&amp;quot;:\&amp;quot;contentid\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;nasdbid\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:1,\&amp;quot;dispName\&amp;quot;:\&amp;quot;nasdbid\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;Hash\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:2,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Hash\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;DocumentType\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:3,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Array Entity Type\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayManagementName\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:4,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayManagementName\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayName\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:5,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Array Name\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayOSVersion\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:6,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayOSVersion\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayFirmwareVersion\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:7,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayFirmwareVersion\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayUniqueId\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:8,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayUniqueId\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayStatus\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:9,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayStatus\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArraySerialNumber\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:10,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArraySerialNumber\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayModelNumber\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:11,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayModelNumber\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;PercentageUsedArray\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:12,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Array Percentage Used\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;PercentageUsedStoragePool\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:12,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Storage Pool Percentage Used\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;PercentageUsedVolume\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:12,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Volume Percentage Used\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayTotalSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:12,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayTotalSpace\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayUsedSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:13,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayUsedSpace\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayFreeSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:14,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayFreeSpace\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayProperties\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:15,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayProperties\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;StoragePoolName\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:16,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Storage Pool Name\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;StoragePoolUniqueId\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:17,\&amp;quot;dispName\&amp;quot;:\&amp;quot;StoragePoolUniqueId\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;StoragePoolStatus\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:18,\&amp;quot;dispName\&amp;quot;:\&amp;quot;StoragePoolStatus\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;StoragePoolVolumeCount\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:19,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Storage Pool Volume Count\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;StoragePoolTotalSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:20,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Storage Pool Total Space in GB\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;StoragePoolUsedSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:21,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Storage Pool Used Space in GB\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;StoragePoolProperties\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:22,\&amp;quot;dispName\&amp;quot;:\&amp;quot;StoragePoolProperties\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayVolumeName\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:23,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Volume Name\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayVolumePath\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:24,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Volume Path\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayVolumeUniqueId\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:25,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayVolumeUniqueId\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayVolumeStatus\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:26,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayVolumeStatus\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayVolumeTotalSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:27,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Volume Total Space in GB\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayVolumeUsedSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:28,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Volume Used Space in GB\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayVolumeFreeSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:29,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Volume Free Space in GB\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayVolumeProperties\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:30,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayVolumeProperties\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;LUNName\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:31,\&amp;quot;dispName\&amp;quot;:\&amp;quot;LUNName\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;LUNPath\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:32,\&amp;quot;dispName\&amp;quot;:\&amp;quot;LUNPath\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;LUNUniqueId\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:33,\&amp;quot;dispName\&amp;quot;:\&amp;quot;LUNUniqueId\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;LUNStatus\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:34,\&amp;quot;dispName\&amp;quot;:\&amp;quot;LUNStatus\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;LUNSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:35,\&amp;quot;dispName\&amp;quot;:\&amp;quot;LUNSpace\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;LUNUsedSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:36,\&amp;quot;dispName\&amp;quot;:\&amp;quot;LUNUsedSpace\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;LUNFreeSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:37,\&amp;quot;dispName\&amp;quot;:\&amp;quot;LUNFreeSpace\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;LUNProperties\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:38,\&amp;quot;dispName\&amp;quot;:\&amp;quot;LUNProperties\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;NFSExportName\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:39,\&amp;quot;dispName\&amp;quot;:\&amp;quot;NFSExportName\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;NFSExportPathName\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:40,\&amp;quot;dispName\&amp;quot;:\&amp;quot;NFSExportPathName\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;NFSExportSecurityRules\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:41,\&amp;quot;dispName\&amp;quot;:\&amp;quot;NFSExportSecurityRules\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;NFSExportProperties\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:42,\&amp;quot;dispName\&amp;quot;:\&amp;quot;NFSExportProperties\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;CIFSShareName\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:43,\&amp;quot;dispName\&amp;quot;:\&amp;quot;CIFSShareName\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;CIFSSharePath\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:44,\&amp;quot;dispName\&amp;quot;:\&amp;quot;CIFSSharePath\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;CIFSShareDescription\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:45,\&amp;quot;dispName\&amp;quot;:\&amp;quot;CIFSShareDescription\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;CIFSShareACL\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:46,\&amp;quot;dispName\&amp;quot;:\&amp;quot;CIFSShareACL\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;CIFSShareProperties\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:47,\&amp;quot;dispName\&amp;quot;:\&amp;quot;CIFSShareProperties\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;Flags\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:48,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Flags\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;CreationTime\&amp;quot;,\&amp;quot;renderer\&amp;quot;:{\&amp;quot;type\&amp;quot;:\&amp;quot;date\&amp;quot;},\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:49,\&amp;quot;dispName\&amp;quot;:\&amp;quot;CreationTime\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;UpdateTime\&amp;quot;,\&amp;quot;renderer\&amp;quot;:{\&amp;quot;type\&amp;quot;:\&amp;quot;date\&amp;quot;},\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:50,\&amp;quot;dispName\&amp;quot;:\&amp;quot;UpdateTime\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;DeletionTime\&amp;quot;,\&amp;quot;renderer\&amp;quot;:{\&amp;quot;type\&amp;quot;:\&amp;quot;date\&amp;quot;},\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:51,\&amp;quot;dispName\&amp;quot;:\&amp;quot;DeletionTime\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ReserveFieldInt1\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:52,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ReserveFieldInt1\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ReserveFieldInt2\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:53,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ReserveFieldInt2\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ReserveFieldStr\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:54,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ReserveFieldStr\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;dicom_vr_val\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:false,\&amp;quot;dispOrder\&amp;quot;:55,\&amp;quot;dispName\&amp;quot;:\&amp;quot;dicom_vr_val\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;dicom_vr_len\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:false,\&amp;quot;dispOrder\&amp;quot;:56,\&amp;quot;dispName\&amp;quot;:\&amp;quot;dicom_vr_len\&amp;quot;,\&amp;quot;visible\&amp;quot;:false}],\&amp;quot;tableConfig\&amp;quot;:{\&amp;quot;order\&amp;quot;:[],\&amp;quot;pageLength\&amp;quot;:20},\&amp;quot;facetConfig\&amp;quot;:[{\&amp;quot;noOfValuesToShow\&amp;quot;:500,\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayName\&amp;quot;,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Array Name\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:0},{\&amp;quot;noOfValuesToShow\&amp;quot;:5,\&amp;quot;fieldName\&amp;quot;:\&amp;quot;DocumentType\&amp;quot;,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Array Entity Type\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:1},{\&amp;quot;noOfValuesToShow\&amp;quot;:5,\&amp;quot;fieldName\&amp;quot;:\&amp;quot;CreationTime\&amp;quot;,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Discovery Timestamp\&amp;quot;,\&amp;quot;renderer\&amp;quot;:{\&amp;quot;type\&amp;quot;:\&amp;quot;date\&amp;quot;,\&amp;quot;fmt\&amp;quot;:\&amp;quot;MM/DD/YYYY hh:mm:ss A\&amp;quot;},\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:2},{\&amp;quot;noOfValuesToShow\&amp;quot;:1000,\&amp;quot;fieldName\&amp;quot;:\&amp;quot;StoragePoolName\&amp;quot;,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Storage Pool Name\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:3}]}&amp;quot;);    &amp;#xD;&amp;#xA;    sReqXML = XMLEncoder.encode(oCreateSearchViewReq);        &amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;RestAPIReqMsgForSearchVolumes&amp;quot;, sReqXML);    &amp;#xD;&amp;#xA;    logger.info(&amp;quot;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;The Request XML to Create a new Search View for Volumes is &amp;quot; + sReqXML +  &amp;quot;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;quot;);&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    //Set the search view for LUNs&amp;#xD;&amp;#xA;    oCreateSearchViewReq.setSearchViewName(sSearchViewNames[3]);&amp;#xD;&amp;#xA;&amp;#x9;oCreateSearchViewReq.setSearchViewId(nSearchViewIds[3]);&amp;#xD;&amp;#xA;    oCreateSearchViewReq.setViewInfo(&amp;quot;{\&amp;quot;facetPanelTitle\&amp;quot;:\&amp;quot;Filter\&amp;quot;,\&amp;quot;columnConfig\&amp;quot;:[{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;contentid\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:0,\&amp;quot;dispName\&amp;quot;:\&amp;quot;contentid\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;nasdbid\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:1,\&amp;quot;dispName\&amp;quot;:\&amp;quot;nasdbid\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;Hash\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:2,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Hash\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;DocumentType\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:3,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Array Entity Type\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayManagementName\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:4,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayManagementName\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayName\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:5,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Array Name\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayOSVersion\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:6,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayOSVersion\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayFirmwareVersion\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:7,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayFirmwareVersion\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayUniqueId\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:8,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayUniqueId\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayStatus\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:9,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayStatus\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArraySerialNumber\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:10,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArraySerialNumber\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayModelNumber\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:11,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayModelNumber\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;PercentageUsedArray\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:12,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Array Percentage Used\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;PercentageUsedStoragePool\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:12,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Storage Pool Percentage Used\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;PercentageUsedVolume\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:12,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Volume Percentage Used\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;PercentageUsedLuns\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:12,\&amp;quot;dispName\&amp;quot;:\&amp;quot;LUN Percentage Used\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayTotalSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:12,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayTotalSpace\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayUsedSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:13,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayUsedSpace\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayFreeSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:14,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayFreeSpace\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayProperties\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:15,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayProperties\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;StoragePoolName\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:16,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Storage Pool Name\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;StoragePoolUniqueId\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:17,\&amp;quot;dispName\&amp;quot;:\&amp;quot;StoragePoolUniqueId\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;StoragePoolStatus\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:18,\&amp;quot;dispName\&amp;quot;:\&amp;quot;StoragePoolStatus\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;StoragePoolVolumeCount\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:19,\&amp;quot;dispName\&amp;quot;:\&amp;quot;StoragePool Volume Count\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;StoragePoolTotalSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:20,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Storage Pool Total Space in GB\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;StoragePoolUsedSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:21,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Storage Pool Used Space in GB\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;StoragePoolProperties\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:22,\&amp;quot;dispName\&amp;quot;:\&amp;quot;StoragePoolProperties\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayVolumeName\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:23,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Volume Name\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayVolumePath\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:24,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Volume Path\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayVolumeUniqueId\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:25,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayVolumeUniqueId\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayVolumeStatus\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:26,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayVolumeStatus\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayVolumeTotalSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:27,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Volume Total Space in GB\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayVolumeUsedSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:28,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Volume Used Space in GB\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayVolumeFreeSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:29,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Volume Free Space in GB\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayVolumeProperties\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:30,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ArrayVolumeProperties\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;LUNName\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:31,\&amp;quot;dispName\&amp;quot;:\&amp;quot;LUN Name\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;LUNPath\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:32,\&amp;quot;dispName\&amp;quot;:\&amp;quot;LUN Path\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;LUNUniqueId\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:33,\&amp;quot;dispName\&amp;quot;:\&amp;quot;LUNUniqueId\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;LUNStatus\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:34,\&amp;quot;dispName\&amp;quot;:\&amp;quot;LUNStatus\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;LUNSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:35,\&amp;quot;dispName\&amp;quot;:\&amp;quot;LUN Space in GB\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;LUNUsedSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:36,\&amp;quot;dispName\&amp;quot;:\&amp;quot;LUN Used Space in GB\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;LUNFreeSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:37,\&amp;quot;dispName\&amp;quot;:\&amp;quot;LUN Free Space in GB\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;LUNProperties\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:38,\&amp;quot;dispName\&amp;quot;:\&amp;quot;LUNProperties\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;NFSExportName\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:39,\&amp;quot;dispName\&amp;quot;:\&amp;quot;NFSExportName\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;NFSExportPathName\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:40,\&amp;quot;dispName\&amp;quot;:\&amp;quot;NFSExportPathName\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;NFSExportSecurityRules\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:41,\&amp;quot;dispName\&amp;quot;:\&amp;quot;NFSExportSecurityRules\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;NFSExportProperties\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:42,\&amp;quot;dispName\&amp;quot;:\&amp;quot;NFSExportProperties\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;CIFSShareName\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:43,\&amp;quot;dispName\&amp;quot;:\&amp;quot;CIFSShareName\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;CIFSSharePath\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:44,\&amp;quot;dispName\&amp;quot;:\&amp;quot;CIFSSharePath\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;CIFSShareDescription\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:45,\&amp;quot;dispName\&amp;quot;:\&amp;quot;CIFSShareDescription\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;CIFSShareACL\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:46,\&amp;quot;dispName\&amp;quot;:\&amp;quot;CIFSShareACL\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;CIFSShareProperties\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:47,\&amp;quot;dispName\&amp;quot;:\&amp;quot;CIFSShareProperties\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;Flags\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:48,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Flags\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;CreationTime\&amp;quot;,\&amp;quot;renderer\&amp;quot;:{\&amp;quot;type\&amp;quot;:\&amp;quot;date\&amp;quot;},\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:49,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Discovery Timestamp\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;UpdateTime\&amp;quot;,\&amp;quot;renderer\&amp;quot;:{\&amp;quot;type\&amp;quot;:\&amp;quot;date\&amp;quot;},\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:50,\&amp;quot;dispName\&amp;quot;:\&amp;quot;UpdateTime\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;DeletionTime\&amp;quot;,\&amp;quot;renderer\&amp;quot;:{\&amp;quot;type\&amp;quot;:\&amp;quot;date\&amp;quot;},\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:51,\&amp;quot;dispName\&amp;quot;:\&amp;quot;DeletionTime\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ReserveFieldInt1\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:52,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ReserveFieldInt1\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ReserveFieldInt2\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:53,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ReserveFieldInt2\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ReserveFieldStr\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:54,\&amp;quot;dispName\&amp;quot;:\&amp;quot;ReserveFieldStr\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;dicom_vr_val\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:false,\&amp;quot;dispOrder\&amp;quot;:55,\&amp;quot;dispName\&amp;quot;:\&amp;quot;dicom_vr_val\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;dicom_vr_len\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:false,\&amp;quot;dispOrder\&amp;quot;:56,\&amp;quot;dispName\&amp;quot;:\&amp;quot;dicom_vr_len\&amp;quot;,\&amp;quot;visible\&amp;quot;:false}],\&amp;quot;tableConfig\&amp;quot;:{\&amp;quot;order\&amp;quot;:[],\&amp;quot;pageLength\&amp;quot;:20},\&amp;quot;facetConfig\&amp;quot;:[{\&amp;quot;noOfValuesToShow\&amp;quot;:500,\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayName\&amp;quot;,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Array Name\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:0},{\&amp;quot;noOfValuesToShow\&amp;quot;:5,\&amp;quot;fieldName\&amp;quot;:\&amp;quot;DocumentType\&amp;quot;,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Array Entity Type\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:1},{\&amp;quot;noOfValuesToShow\&amp;quot;:5,\&amp;quot;fieldName\&amp;quot;:\&amp;quot;CreationTime\&amp;quot;,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Discovery Timestamp\&amp;quot;,\&amp;quot;renderer\&amp;quot;:{\&amp;quot;type\&amp;quot;:\&amp;quot;date\&amp;quot;,\&amp;quot;fmt\&amp;quot;:\&amp;quot;MM/DD/YYYY hh:mm:ss A\&amp;quot;},\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:2},{\&amp;quot;noOfValuesToShow\&amp;quot;:1000,\&amp;quot;fieldName\&amp;quot;:\&amp;quot;StoragePoolName\&amp;quot;,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Storage Pool Name\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:3},{\&amp;quot;noOfValuesToShow\&amp;quot;:10000,\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayVolumeName\&amp;quot;,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Volume Name\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:4}]}&amp;quot;);    &amp;#xD;&amp;#xA;    sReqXML = XMLEncoder.encode(oCreateSearchViewReq);        &amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;RestAPIReqMsgForSearchLUNs&amp;quot;, sReqXML);    &amp;#xD;&amp;#xA;    logger.info(&amp;quot;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;The Request XML to Create a new Search View for LUNs is &amp;quot; + sReqXML +  &amp;quot;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;quot;);&amp;#xD;&amp;#xA;&amp;#x9;&amp;#xD;&amp;#xA;    oCreateSearchViewReq.setSearchViewName(sSearchViewNames[4]);     &amp;#xD;&amp;#xA;&amp;#x9;oCreateSearchViewReq.setSearchViewId(nSearchViewIds[4]);&amp;#xD;&amp;#xA;    oCreateSearchViewReq.setViewInfo(&amp;quot;{\&amp;quot;facetPanelTitle\&amp;quot;:\&amp;quot;Filter\&amp;quot;,\&amp;quot;columnConfig\&amp;quot;:[{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;contentid\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:0,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Content Id\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;nasdbid\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:1,\&amp;quot;dispName\&amp;quot;:\&amp;quot;NAS DB Id\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;Hash\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:2,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Hash\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;DocumentType\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:3,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Array Entity Type\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayManagementName\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:4,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Array Management Name\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayName\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:5,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Array Name\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayVendorName\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:6,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Array Vendor Name\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayOSVersion\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:7,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Array OS Version\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayFirmwareVersion\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:8,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Array Firmware Version\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayUniqueId\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:9,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Array Unique Id\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayStatus\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:10,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Array Status\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArraySerialNumber\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:11,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Array Serial Number\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayModelNumber\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:12,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Array Model Number\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;PercentageUsedArray\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:13,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Array Percentage Used\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayTotalSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:14,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Array Total Space in GB\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayUsedSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:15,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Array Used Space in GB\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayFreeSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:16,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Array Free Space in GB\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;StoragePoolName\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:17,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Storage Pool Name\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;StoragePoolUniqueId\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:18,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Storage Pool Unique Id\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;StoragePoolStatus\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:19,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Storage Pool Status\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;StoragePoolTotalSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:20,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Storage Pool Total Space in GB\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;StoragePoolUsedSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:21,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Storage Pool Used Space in GB\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;StoragePoolProperties\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:22,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Storage Pool Properties\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;FileSystemName\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:23,\&amp;quot;dispName\&amp;quot;:\&amp;quot;File System Name\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;FileSystemType\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:24,\&amp;quot;dispName\&amp;quot;:\&amp;quot;File System Type\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;FileSystemTotalSize\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:25,\&amp;quot;dispName\&amp;quot;:\&amp;quot;File System Total Size in GB\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;FileSystemFreeSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:26,\&amp;quot;dispName\&amp;quot;:\&amp;quot;File System Free Space in GB\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;PercentageUsedFileSystem\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:27,\&amp;quot;dispName\&amp;quot;:\&amp;quot;File System Used Percentage\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;DataMover\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:28,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Data Mover Name\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;LUNName\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:28,\&amp;quot;dispName\&amp;quot;:\&amp;quot;LUN Name\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;LUNPath\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:29,\&amp;quot;dispName\&amp;quot;:\&amp;quot;LUN Path\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;LUNUniqueId\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:30,\&amp;quot;dispName\&amp;quot;:\&amp;quot;LUN Unique Id\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;LUNStatus\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:31,\&amp;quot;dispName\&amp;quot;:\&amp;quot;LUN Status\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;LUNSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:32,\&amp;quot;dispName\&amp;quot;:\&amp;quot;LUN Space in GB\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;LUNUsedSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:33,\&amp;quot;dispName\&amp;quot;:\&amp;quot;LUN Used Space in GB\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;LUNFreeSpace\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:34,\&amp;quot;dispName\&amp;quot;:\&amp;quot;LUN Free Space in GB\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;LUNProperties\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:35,\&amp;quot;dispName\&amp;quot;:\&amp;quot;LUN Properties\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;NFSExportName\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:36,\&amp;quot;dispName\&amp;quot;:\&amp;quot;NFS Export Name\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;NFSExportPathName\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:37,\&amp;quot;dispName\&amp;quot;:\&amp;quot;NFS Export Path Name\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;NFSExportReadOnly\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:38,\&amp;quot;dispName\&amp;quot;:\&amp;quot;NFS Export ReadOnly\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;NFSExportProperties\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:39,\&amp;quot;dispName\&amp;quot;:\&amp;quot;NFS Export Properties\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;CIFSShareName\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:40,\&amp;quot;dispName\&amp;quot;:\&amp;quot;CIFS Share Name\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;CIFSSharePath\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:41,\&amp;quot;dispName\&amp;quot;:\&amp;quot;CIFS Share Path\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;CIFSShareDescription\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:42,\&amp;quot;dispName\&amp;quot;:\&amp;quot;CIFS Share Description\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;CIFSShareACL\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:43,\&amp;quot;dispName\&amp;quot;:\&amp;quot;CIFS Share ACL\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;CIFSShareProperties\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:44,\&amp;quot;dispName\&amp;quot;:\&amp;quot;CIFS Share Properties\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;Flags\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:45,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Flags\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;CreationTime\&amp;quot;,\&amp;quot;renderer\&amp;quot;:{\&amp;quot;type\&amp;quot;:\&amp;quot;date\&amp;quot;},\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:46,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Discovery Timestamp\&amp;quot;,\&amp;quot;visible\&amp;quot;:true},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;UpdateTime\&amp;quot;,\&amp;quot;renderer\&amp;quot;:{\&amp;quot;type\&amp;quot;:\&amp;quot;date\&amp;quot;},\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:47,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Update Time\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;DeletionTime\&amp;quot;,\&amp;quot;renderer\&amp;quot;:{\&amp;quot;type\&amp;quot;:\&amp;quot;date\&amp;quot;},\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:48,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Deletion Time\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ReserveFieldInt1\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:49,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Reserve Field Int1\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ReserveFieldInt2\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:50,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Reserve Field Int2\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ReserveFieldStr\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:51,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Reserve Field Str\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;dicom_vr_val\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:false,\&amp;quot;dispOrder\&amp;quot;:52,\&amp;quot;dispName\&amp;quot;:\&amp;quot;dicom_vr_val\&amp;quot;,\&amp;quot;visible\&amp;quot;:false},{\&amp;quot;fieldName\&amp;quot;:\&amp;quot;dicom_vr_len\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:false,\&amp;quot;dispOrder\&amp;quot;:53,\&amp;quot;dispName\&amp;quot;:\&amp;quot;dicom_vr_len\&amp;quot;,\&amp;quot;visible\&amp;quot;:false}],\&amp;quot;tableConfig\&amp;quot;:{\&amp;quot;order\&amp;quot;:[],\&amp;quot;pageLength\&amp;quot;:20},\&amp;quot;facetConfig\&amp;quot;:[{\&amp;quot;noOfValuesToShow\&amp;quot;:500,\&amp;quot;fieldName\&amp;quot;:\&amp;quot;ArrayName\&amp;quot;,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Array Name\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:0},{\&amp;quot;noOfValuesToShow\&amp;quot;:5,\&amp;quot;fieldName\&amp;quot;:\&amp;quot;DocumentType\&amp;quot;,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Array Entity Type\&amp;quot;,\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:1},{\&amp;quot;noOfValuesToShow\&amp;quot;:5,\&amp;quot;fieldName\&amp;quot;:\&amp;quot;CreationTime\&amp;quot;,\&amp;quot;dispName\&amp;quot;:\&amp;quot;Discovery Timestamp\&amp;quot;,\&amp;quot;renderer\&amp;quot;:{\&amp;quot;type\&amp;quot;:\&amp;quot;date\&amp;quot;,\&amp;quot;fmt\&amp;quot;:\&amp;quot;MM/DD/YYYY hh:mm:ss A\&amp;quot;},\&amp;quot;isSortable\&amp;quot;:true,\&amp;quot;dispOrder\&amp;quot;:2}]}&amp;quot;);&amp;#xD;&amp;#xA;    sReqXML = XMLEncoder.encode(oCreateSearchViewReq);        &amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;RestAPIReqMsgForSearchCelerraArrays&amp;quot;, sReqXML);    &amp;#xD;&amp;#xA;    logger.info(&amp;quot;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;The Request XML to Create a new Search View for Celerra Arrays is &amp;quot; + sReqXML +  &amp;quot;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;quot;);&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(Exception e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    workflow.setFailed(&amp;quot;Error while forming the search view request:&amp;quot;+ e.getMessage());     &amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&quot; />&lt;/inputs>"/>

        <transition activity="ProcessRESTApis" commented="0"

            originalStyle="" points="" sourceX="935" sourceY="344"

            status="0" style="defaultEdge" targetX="776" targetY="172"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1431317984261"

        description="creates a super process group"

        displayName="ProcessRESTApis" height="454" interactive="0"

        jobMode="0" name="ProcessBlock"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ProcessRESTApis" waitSetting="0" width="266" x="521" y="161">

        <inputs val="&lt;inputs>&lt;inputs />&lt;/inputs>"/>

        <superProcess>

            <Start commented="0" continueOnFailure="0"

                created="1431317984261" description=""

                displayName="Start" height="30" interactive="0"

                jobMode="0" name="Start" originalStyle=""

                skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_5" waitSetting="0" width="120" x="73" y="42">

                <inputs val="&lt;inputs />"/>

                <transition activity="CreateSearchViews" commented="0"

                    originalStyle="" points="" sourceX="14"

                    sourceY="218" status="0" style="defaultEdge"

                    targetX="24" targetY="271" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity commented="0" continueOnFailure="0"

                created="1431129818543"

                description="performs http operations"

                displayName="CreateSearchViewsArrays" height="34"

                interactive="0" jobMode="0" name="HttpClient"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=HttpClient"

                uniqueName="CreateSearchViews" waitSetting="0"

                width="182" x="46" y="97">

                <inputs val="&lt;inputs>&lt;request>&lt;url>/SearchSvc/CVWebService.svc/dcube/savesearchview&lt;/url>&lt;method>POST&lt;/method>&lt;postType>Raw&lt;/postType>&lt;postContent>xpath:{/workflow/variables/RestAPIReqMsgForSearchArrays}&lt;/postContent>&lt;postContentType>application/xml; charset=UTF-8&lt;/postContentType>&lt;headers>&lt;name>Authtoken&lt;/name>&lt;value>QSDKONLY xpath:{/workflow/system/token}&lt;/value>&lt;/headers>&lt;/request>&lt;/inputs>"/>

                <transition activity="CreateSearchViewsStoragePools"

                    commented="0" originalStyle="" points=""

                    sourceX="140" sourceY="282" status="0"

                    style="defaultEdge" targetX="140" targetY="359"

                    transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1431318097604"

                description="performs http operations"

                displayName="CreateSearchViewsStoragePools" height="34"

                interactive="0" jobMode="0" name="HttpClient"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=HttpClient"

                uniqueName="CreateSearchViewsStoragePools"

                waitSetting="0" width="200" x="35" y="161">

                <inputs val="&lt;inputs>&lt;request>&lt;url>/SearchSvc/CVWebService.svc/dcube/savesearchview&lt;/url>&lt;method>POST&lt;/method>&lt;postType>Raw&lt;/postType>&lt;postContent>xpath:{/workflow/variables/RestAPIReqMsgForSearchSPools}&lt;/postContent>&lt;postContentType>application/xml; charset=UTF-8&lt;/postContentType>&lt;headers>&lt;name>Authtoken&lt;/name>&lt;value>QSDKONLY xpath:{/workflow/system/token}&lt;/value>&lt;/headers>&lt;/request>&lt;/inputs>"/>

                <transition activity="CreateSearchViewsVolumes"

                    commented="0" originalStyle="" points=""

                    sourceX="115" sourceY="340" status="0"

                    style="defaultEdge" targetX="111" targetY="411"

                    transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1431318106609"

                description="performs http operations"

                displayName="CreateSearchViewsVolumes" height="34"

                interactive="0" jobMode="0" name="HttpClient"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=HttpClient"

                uniqueName="CreateSearchViewsVolumes" waitSetting="0"

                width="194" x="43" y="231">

                <inputs val="&lt;inputs>&lt;request>&lt;url>/SearchSvc/CVWebService.svc/dcube/savesearchview&lt;/url>&lt;method>POST&lt;/method>&lt;postType>Raw&lt;/postType>&lt;postContent>xpath:{/workflow/variables/RestAPIReqMsgForSearchVolumes}&lt;/postContent>&lt;postContentType>application/xml; charset=UTF-8&lt;/postContentType>&lt;headers>&lt;name>Authtoken&lt;/name>&lt;value>QSDKONLY xpath:{/workflow/system/token}&lt;/value>&lt;/headers>&lt;/request>&lt;/inputs>"/>

                <transition activity="CreateSearchViewsLUNs"

                    commented="0" originalStyle="" points=""

                    sourceX="137" sourceY="278" status="0"

                    style="defaultEdge" targetX="146" targetY="344"

                    transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1431318164240"

                description="performs http operations"

                displayName="CreateSearchViewsLUNs" height="34"

                interactive="0" jobMode="0" name="HttpClient"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=HttpClient"

                uniqueName="CreateSearchViewsLUNs" waitSetting="0"

                width="174" x="51" y="299">

                <inputs val="&lt;inputs>&lt;request>&lt;url>/SearchSvc/CVWebService.svc/dcube/savesearchview&lt;/url>&lt;method>POST&lt;/method>&lt;postType>Raw&lt;/postType>&lt;postContent>xpath:{/workflow/variables/RestAPIReqMsgForSearchLUNs}&lt;/postContent>&lt;postContentType>application/xml; charset=UTF-8&lt;/postContentType>&lt;headers>&lt;name>Authtoken&lt;/name>&lt;value>QSDKONLY xpath:{/workflow/system/token}&lt;/value>&lt;/headers>&lt;/request>&lt;/inputs>"/>

                <transition activity="HttpClient_1" commented="0"

                    originalStyle="" points="" sourceX="138"

                    sourceY="316" status="0" style="defaultEdge"

                    targetX="142" targetY="386" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1473922830603"

                description="performs http operations"

                displayName="CreateSearchViewsCelerraArrays" height="34"

                interactive="0" jobMode="0" name="HttpClient"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=HttpClient" uniqueName="HttpClient_1"

                waitSetting="0" width="200" x="39" y="373">

                <inputs val="&lt;inputs>&lt;request>&lt;url>/SearchSvc/CVWebService.svc/dcube/savesearchview&lt;/url>&lt;method>POST&lt;/method>&lt;postType>Raw&lt;/postType>&lt;postContent>xpath:{/workflow/variables/RestAPIReqMsgForSearchCelerraArrays}&lt;/postContent>&lt;postContentType>application/xml; charset=UTF-8&lt;/postContentType>&lt;headers>&lt;name>Authtoken&lt;/name>&lt;value>QSDKONLY xpath:{/workflow/system/token}&lt;/value>&lt;/headers>&lt;/request>&lt;/inputs>"/>

            </Activity>

        </superProcess>

        <activitySchema>

            <outputs attribute="0" className="" defaultValue=""

                listType="0" name="outputs" required="1" type=""/>

            <inputs attribute="0" className="" defaultValue=""

                listType="0" name="inputs" required="1" type=""/>

        </activitySchema>

        <transition activity="GetArraysFromArrayManagement"

            commented="0" originalStyle="" points="" sourceX="654"

            sourceY="344" status="0" style="defaultEdge" targetX="305"

            targetY="343" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

</workflow>'

UPDATE WF_Definition SET Name = @name WHERE Name = 'NASRemoteSystemDiscovery'

UPDATE WF_DefinitionHistory SET Name = @name WHERE Name = 'NASRemoteSystemDiscovery'

IF not exists (select * from WF_Definition where Name = @name)

BEGIN
	INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision)


	VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision)

	SET @workflowId = @@IDENTITY
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


	VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

	SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = ISNULL(revision, '') From WF_Definition WHERE Name = @name

	IF (@currentFlags & 4 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0) AND (@currentRevision <> @revision)

	BEGIN

		SET @version = @version + 1

		UPDATE WF_Definition

		SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision

		WHERE Name = @name

		IF (@flags & 8 > 0 OR @flags & 16 > 0)

		BEGIN

			UPDATE WF_Definition

			SET flags = @flags

			WHERE Name = @name

		END
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


		VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

	END

END

