

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_MergeDuplicateClients.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER ON

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @guid nvarchar(256)

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.1.2.5 $'

SET @name = 'MergeDuplicateClients'

SET @description = 'Worflow to merge duplicate clients'

SET @version = 1

SET @flags = 6

SET @guid = '28a1067f-fb80-4334-a448-d3298538480f'

SET @definition = '<workflow apiMode="0" config="&lt;configuration /&gt;" description="" inputs="&lt;inputs&gt;&lt;ClientPairs class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/inputs&gt;" interactive="0" isHtmlDescription="0" name="MergeDuplicateClients" outputs="&lt;outputs /&gt;" revision="$Revision: 1.1.2.5 $" uniqueGuid="8c6d7fbc-1515-46e0-af38-e8f53743e542" variables="&lt;variables /&gt;" webHidden="0" workflowId="112">

  <schema>

    <inputs attribute="0" className="" name="inputs" type="">

      <children attribute="0" className="java.lang.String" controlHidden="0" controlType="1" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="ClientPairs" readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string" />

    </inputs>

    <variables attribute="0" className="" name="variables" type="" />

    <outputs className="" name="outputs" type="" />

    <config attribute="0" className="" name="configuration" type="" />

  </schema>

  <formProperties css="" formVersion="0" javaScript="" pageMode="0" />

  <Start commented="0" continueOnFailure="0" created="0" description="" displayName="Start" height="36" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="0" style="image;image=/images/jgraphx/house.png" uniqueName="Start_1" waitSetting="0" width="58" x="57" y="15">

    <inputs val="&lt;inputs /&gt;" />

    <transition activity="ImpersonateCreator_1" commented="0" originalStyle="" points="" sourceX="86" sourceY="33" status="0" style="defaultEdge" targetX="96" targetY="103" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Start>

  <Activity commented="0" continueOnFailure="1" created="1513301119061" description="iterates a group of activities over a list of values" displayName="ForEach" height="486" interactive="0" jobMode="0" name="ForEach" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="swimlane" uniqueName="ForEach_1" waitSetting="0" width="655" x="449" y="62">

    <activitySchema>

      <inputs className="" name="" type="">

        <children attribute="0" className="java.lang.String" hidden="0" inputType="java.lang.String" listType="0" name="name" type="{http://www.w3.org/2001/XMLSchema}string" />

        <children attribute="0" className="java.lang.Object" displayName="" documentation="" hidden="0" inputType="java.lang.Object" listType="0" name="values" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}anyType" />

        <children attribute="0" className="java.lang.Integer" defaultValue="1" displayName="" hidden="0" inputType="java.lang.Integer" listType="0" name="numberOfParallelExecutions" type="{http://www.w3.org/2001/XMLSchema}integer" />

        <children attribute="0" className="java.lang.Boolean" defaultValue="false" displayName="" documentation="" hidden="0" inputType="java.lang.Boolean" listType="0" name="continueOnFailure" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}boolean" />

      </inputs>

      <outputs name="outputs">

        <children attribute="0" className="java.lang.Object" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Object" listType="0" name="output" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}anyType" />

      </outputs>

    </activitySchema>

    <inputs val="&lt;inputs&gt;&lt;name class=&quot;java.lang.String&quot;&gt;output&lt;/name&gt;&lt;values class=&quot;java.lang.Object&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_1/output}&lt;/values&gt;&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;&gt;1&lt;/numberOfParallelExecutions&gt;&lt;continueOnFailure class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/continueOnFailure&gt;&lt;/inputs&gt;" />

    <transition activity="WorkflowEnd_8" commented="0" originalStyle="" points="" sourceX="776" sourceY="305" status="0" style="defaultEdge" targetX="1245" targetY="297" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

    <superProcess>

      <Start commented="0" continueOnFailure="0" created="1513301119061" description="" displayName="Start" height="30" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="0" style="label;fillColor=#FFFF33;gradientColor=#FFFF00" uniqueName="Start_3" waitSetting="0" width="120" x="18" y="61">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="Script_getClientName1" commented="0" originalStyle="" points="" sourceX="78" sourceY="76" status="0" style="defaultEdge" targetX="81" targetY="161" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Start>

      <Activity commented="0" continueOnFailure="1" created="1489530983964" description="executes queries against a commcell database" displayName="Merge Clients" height="34" interactive="0" jobMode="0" maxRestarts="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_1" waitSetting="0" width="143" x="35" y="298">

        <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;&amp;#xD;&#xD;&#xA;declare @locale int = xpath:{/workflow/CommServDBQuery_4/resultSets/row/col[@name=&quot;locale&quot;]}&amp;#xD;&#xD;&#xA;declare @clientName1 nvarchar(max)&amp;#xD;&#xD;&#xA;declare @clientName2 nvarchar(max)&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;SELECT @clientName1 = ''xpath:{/workflow/Script_getClientName1/output}''&amp;#xD;&#xD;&#xA;SELECT @clientName2 = ''xpath:{/workflow/Script_getClientName2/output}''&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;declare @output nvarchar(1024)&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;exec QS_SetVMClient @clientName1,@clientName2,@locale, @output output&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;select @output as ''Merge Output''&amp;#xD;&#xD;&#xA;&lt;/query&gt;&lt;/inputs&gt;" />

        <transition activity="Decision_2" commented="0" originalStyle="" points="" sourceX="-358" sourceY="91" status="0" style="defaultEdge" targetX="-277" targetY="205" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="1" created="1489533689043" description="if/else based decision" displayName="Is Merge Successful" height="100" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1" uniqueName="Decision_2" waitSetting="0" width="146" x="277" y="233">

        <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/CommServDBQuery_1/errorCode}==0 &amp;amp;&amp;amp; xpath:{/workflow/CommServDBQuery_1/resultSets/rowCount}&amp;gt;0&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

        <transition activity="LogEvent_5" commented="0" displayName="No" originalStyle="" points="" sourceX="-225" sourceY="190" status="0" style="defaultEdge" targetX="-213" targetY="352" transitionIndex="0" value="false" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

        <transition activity="LogEvent_1" commented="0" displayName="yes" originalStyle="" points="" sourceX="-156" sourceY="200" status="0" style="defaultEdge" targetX="11" targetY="180" transitionIndex="0" value="true" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="1" created="1513301825927" description="logs an event in the commcell console with the specified severity level" displayName="Log Failure Event" height="34" interactive="0" jobMode="0" name="LogEvent" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.LogEventActivity" uniqueName="LogEvent_5" waitSetting="0" width="126" x="247" y="426">

        <inputs val="&lt;inputs&gt;&lt;severity class=&quot;workflow.types.SeverityLevel&quot; _list_=&quot;false&quot;&gt;INFO&lt;/severity&gt;&lt;message class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/CommServDBQuery_1/errorMessage}&lt;/message&gt;&lt;/inputs&gt;" />

      </Activity>

      <Activity commented="0" continueOnFailure="1" created="1490130698857" description="logs an event in the commcell console with the specified severity level" displayName="Log Success Event" height="34" interactive="0" jobMode="0" name="LogEvent" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.LogEventActivity" uniqueName="LogEvent_1" waitSetting="0" width="138" x="466" y="153">

        <inputs val="&lt;inputs&gt;&lt;severity class=&quot;workflow.types.SeverityLevel&quot; _list_=&quot;false&quot;&gt;INFO&lt;/severity&gt;&lt;message class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/CommServDBQuery_1/resultSets/row[1]/col[@name=&quot;Merge Output&quot;]}&lt;/message&gt;&lt;/inputs&gt;" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1513646336350" description="activity to execute code snippets in the selected language" displayName="Get Client Name 1" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_getClientName1" waitSetting="0" width="130" x="34" y="153">

        <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;&amp;#xD;&amp;#xA;import org.json.JSONException;&amp;#xD;&amp;#xA;import org.json.JSONObject;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;String s = xpath:{/workflow/ForEach_1/output};&amp;#xD;&amp;#xA;JSONObject jsonObj = new JSONObject(s);&amp;#xD;&amp;#xA;return jsonObj.getString(&amp;quot;clientName1&amp;quot;) ;&amp;#xD;&amp;#xA;&quot; /&gt;&lt;/inputs&gt;" />

        <transition activity="Script_getClientName2" commented="0" originalStyle="" points="" sourceX="99" sourceY="170" status="0" style="defaultEdge" targetX="89" targetY="237" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1513646467068" description="activity to execute code snippets in the selected language" displayName="Get Client Name 2" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_getClientName2" waitSetting="0" width="130" x="35" y="219">

        <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;import org.json.JSONException;&amp;#xD;&amp;#xA;import org.json.JSONObject;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;String s = xpath:{/workflow/ForEach_1/output};&amp;#xD;&amp;#xA;JSONObject jsonObj = new JSONObject(s);&amp;#xD;&amp;#xA;return jsonObj.getString(&amp;quot;clientName2&amp;quot;) ;&amp;#xD;&amp;#xA;&quot; /&gt;&lt;/inputs&gt;" />

        <transition activity="CommServDBQuery_1" commented="0" originalStyle="" sourceX="91" sourceY="236" status="0" style="defaultEdge" targetX="94" targetY="310" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

    </superProcess>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1513303689446" description="executes queries against a commcell database" displayName="Get Locale" height="34" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_4" waitSetting="0" width="143" x="36" y="179">

    <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;declare @jobId int = xpath:{/workflow/system/jobId}&amp;#xD;&#xD;&#xA;declare @options xml&amp;#xD;&#xD;&#xA;declare @locale int &amp;#xD;&#xD;&#xA;declare @output nvarchar(1024)&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;select @options =  cast(cast(p.xmlJobInfo as varchar(max)) as xml) from JMJobStats p where jobId = @jobId&amp;#xD;&#xD;&#xA;SET @locale = ISNULL((SELECT @options.value(''(/*/processinginstructioninfo/locale/@localeId)[1]'',''integer'')),0)&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;select @locale as ''locale''&lt;/query&gt;&lt;/inputs&gt;" />

    <transition activity="Script_1" commented="0" originalStyle="" points="" sourceX="107" sourceY="196" status="0" style="defaultEdge" targetX="112" targetY="347" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1513304450839" description="Ends the workflow" displayName="WorkflowEnd" height="34" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.EndActivity" uniqueName="WorkflowEnd_8" waitSetting="0" width="106" x="1262" y="304">

    <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot; /&gt;&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/inputs&gt;" />

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1513370110109" description="impersonates the user who created the workflow" displayName="ImpersonateCreator" height="34" interactive="0" jobMode="0" name="ImpersonateCreator" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.ImpersonateCreator" uniqueName="ImpersonateCreator_1" waitSetting="0" width="145" x="29" y="98">

    <inputs val="&lt;inputs /&gt;" />

    <transition activity="CommServDBQuery_4" commented="0" originalStyle="" points="" sourceX="101" sourceY="115" status="0" style="defaultEdge" targetX="104" targetY="191" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1513626568410" description="activity to execute code snippets in the selected language" displayName="Parse Input" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_1" waitSetting="0" width="100" x="57" y="340">

    <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;import org.json.JSONArray;&amp;#xD;&amp;#xA;import org.json.JSONException;&amp;#xD;&amp;#xA;import org.json.JSONObject;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;arr=new ArrayList();&amp;#xD;&amp;#xA;JSONArray array = new JSONArray(xpath:{/workflow/inputs/ClientPairs}); &amp;#xD;&amp;#xA;logger.info(&amp;quot;INFO : JSON Client Pairs [&amp;quot; + array +&amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;for(int i=0; i&amp;lt;array.length(); i++){&amp;#xD;&amp;#xA;    JSONObject jsonObj = array.getJSONObject(i);&amp;#xD;&amp;#xA;    String s = jsonObj.toString();&amp;#xD;&amp;#xA;    arr.add(s);&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;return arr; &quot; /&gt;&lt;/inputs&gt;" />

    <transition activity="ForEach_1" commented="0" originalStyle="" points="" sourceX="107" sourceY="357" status="0" style="defaultEdge" targetX="645" targetY="66" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

</workflow>'

IF not exists (select * from WF_Definition where Name = @name)

BEGIN
	INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision, uniqueGuid)


	VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision, @guid)

	SET @workflowId = @@IDENTITY
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


	VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

	SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = revision From WF_Definition WHERE Name = @name

	IF (@currentFlags & 4 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0) AND (@currentRevision <> @revision)

	BEGIN

		SET @version = @version + 1

		UPDATE WF_Definition

		SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision, uniqueGuid = @guid, flags = @flags

		WHERE Name = @name
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


		VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

	END

END
