

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_MarkSelectedSubclientsToRunFullBackup.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER ON

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.1.2.4 $'

SET @name = 'Mark Selected Subclients To Run Full Backup'

SET @description = 'Use this workflow to mark the selected subclients to run full backup.'

SET @version = 1

SET @flags = 22

SET @definition = '<workflow apiMode="0" config="&lt;configuration />"

    description="Use this workflow to mark the selected subclients to run full backup."

    executeOnWeb="0"

    inputs="&lt;inputs>&lt;timeStamp class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>&lt;/timeStamp>&lt;/inputs>"

    interactive="1" isHtmlDescription="0" manualPercentageComplete="0"

    name="Mark Selected Subclients To Run Full Backup"

    outputs="&lt;outputs />" revision="$Revision: 1.1.2.4 $" tags=""

    uniqueGuid="b7527428-0c94-41c5-b75b-68a3716de92d"

    variables="&lt;variables />" webHidden="0" workflowId="0">

    <schema>

        <outputs className="" name="outputs" type=""/>

        <variables className="" name="variables" type=""/>

        <inputs attribute="0" className="" name="inputs" type="">

            <children attribute="0" className="java.lang.Integer"

                controlHidden="1" controlType="0" defaultValue=""

                displayName="" documentation="" hidden="0"

                inputType="java.lang.Integer" listType="0"

                maximumValue="" minimumValue="" name="timeStamp"

                readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

        </inputs>

        <config className="" name="configuration" type=""/>

    </schema>

    <Start commented="0" continueOnFailure="0" created="0"

        description="" displayName="Start" height="36" interactive="0"

        jobMode="0" name="Start" originalStyle="" skipAttempt="0"

        style="image;image=/images/jgraphx/house.png"

        uniqueName="Start_1" waitSetting="0" width="55" x="45" y="41">

        <inputs val="&lt;inputs />"/>

        <transition activity="InformationalMessage_1" commented="0"

            originalStyle="" points="" sourceX="72" sourceY="59"

            status="0" style="defaultEdge" targetX="262" targetY="80"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Start>

    <Activity commented="0" continueOnFailure="0"

        created="1569909547974"

        description="executes queries against a commcell database"

        displayName="CommServDBQuery" height="34" interactive="0"

        jobMode="0" name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.CommServDBQuery"

        uniqueName="CommServDBQuery_1" waitSetting="0" width="143"

        x="619" y="55">

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>IF xpath:{/workflow/inputs/timeStamp} &amp;lt;&amp;gt; 0&amp;#xD;&#xd;&#xa;BEGIN&amp;#xD;&#xd;&#xa;EXEC ArchMarkNextBackupFullForDVFailedSCs xpath:{/workflow/inputs/timeStamp}, 0&amp;#xD;&#xd;&#xa;END&amp;#xD;&#xd;&#xa;&lt;/query>&lt;/inputs>"/>

        <transition activity="Email_1" commented="0" originalStyle=""

            points="" sourceX="701" sourceY="51" status="0"

            style="defaultEdge" targetX="688" targetY="146"

            transitionIndex="0" x="435" y="-9">

            <condition language="1" script="xpath:{/workflow/CommServDBQuery_1/errorCode}!=0;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1569927460718"

        description="Sends an email to a list of users"

        displayName="Email" height="34" interactive="0" jobMode="0"

        name="Email" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.EmailActivity"

        uniqueName="Email_1" waitSetting="0" width="100" x="656" y="152">

        <inputs val="&lt;inputs>&lt;email>&lt;from />&lt;to>xpath:{/workflow/system/executor}&lt;/to>&lt;cc />&lt;bcc />&lt;subject>Error on executing workflow xpath:{/workflow/system/workflow/workflowName}&lt;/subject>&lt;attachments />&lt;repeatInterval />&lt;body>&amp;lt;p&amp;gt;&#xd;&#xa;      xpath:{/workflow/CommServDBQuery_1/errorMessage}&#xd;&#xa;    &amp;lt;/p&amp;gt;&lt;/body>&lt;html>true&lt;/html>&lt;/email>&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1576426259206"

        description="displays an informational message to the user"

        displayName="InformationalMessage" height="34" interactive="0"

        jobMode="0" name="InformationalMessage"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.InteractiveMessageActivity"

        uniqueName="InformationalMessage_1" waitSetting="0" width="157"

        x="259" y="58">

        <inputs val="&lt;inputs>&lt;message>&amp;#xD;&#xd;&#xa;Do you want to convert the next backup to Full for subclients detected with data corruption?&lt;/message>&lt;dialogType>Popup&lt;/dialogType>&lt;iconType>Information&lt;/iconType>&lt;title>Warning&lt;/title>&lt;html>false&lt;/html>&lt;actions>&lt;name>Ok&lt;/name>&lt;validateForm>true&lt;/validateForm>&lt;/actions>&lt;actions>&lt;name>Cancel&lt;/name>&lt;validateForm>true&lt;/validateForm>&lt;/actions>&lt;formProperties />&lt;/inputs>"/>

        <activitySchema>

            <outputs name="outputs">

                <children className="java.lang.String"

                    inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string"/>

            </outputs>

            <inputs className="" defaultValue="" listType="0"

                name="inputs" type=""/>

        </activitySchema>

        <transition activity="CommServDBQuery_1" commented="0"

            originalStyle="" points="" sourceX="337" sourceY="75"

            status="0" style="defaultEdge" targetX="630" targetY="77"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;&#xa;xpath:{/workflow/InformationalMessage_1/actionSelected}.equals(&quot;Ok&quot;);&#xa;"/>

        </transition>

    </Activity>

    <formProperties css="" formVersion="0" javaScript="" pageMode="0"/>

</workflow>'

IF not exists (select * from WF_Definition where Name = @name)

BEGIN
	INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision)


	VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision)

	SET @workflowId = @@IDENTITY
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


	VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

	SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = ISNULL(revision, '') From WF_Definition WHERE Name = @name

	IF (@currentFlags & 4 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0) AND (@currentRevision <> @revision)

	BEGIN

		SET @version = @version + 1

		UPDATE WF_Definition

		SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision

		WHERE Name = @name

		IF (@flags & 8 > 0 OR @flags & 16 > 0)

		BEGIN

			UPDATE WF_Definition

			SET flags = @flags

			WHERE Name = @name

		END
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


		VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

	END

END

