

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_MAXDB.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/WFD_MAXDB.script,v $ $Id: WFD_MAXDB.script,v 1.1.2.1 2016/05/09 05:19:42 stelagamsetti Exp $";
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER OFF

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.1.2.1 $'

SET @name = 'SAP MaxDB'

SET @description = 'Performs SAP MaxDB backup'

SET @version = 1

SET @flags = 14

SET @definition = '<workflow apiMode="0" description="Performs SAP MaxDB backup"

    inputs="&lt;inputs>&lt;CV_MAXDB_CLIENT_NAME class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>&lt;clientName />&lt;clientId />&lt;/CV_MAXDB_CLIENT_NAME>&lt;CV_BACKUP_TYPE class=&quot;java.lang.String&quot; _list_=&quot;true&quot;>online_full&lt;/CV_BACKUP_TYPE>&lt;CV_SIDADM_USER class=&quot;java.lang.String&quot;>root&lt;/CV_SIDADM_USER>&lt;CV_MAXDB_SUPERDBA_USER class=&quot;java.lang.String&quot;>DBADMIN&lt;/CV_MAXDB_SUPERDBA_USER>&lt;CV_SIDADM_PASSWORD class=&quot;workflow.types.EncryptedString&quot; />&lt;CV_MAXDB_INSTANCE_NAME class=&quot;java.lang.String&quot;>MaxDB&lt;/CV_MAXDB_INSTANCE_NAME>&lt;CV_MAXDB_SUPERDBA_PASSWORD class=&quot;workflow.types.EncryptedString&quot; />&lt;CV_SCRIPT_PATH class=&quot;java.lang.String&quot;>/home/sdb/scripts&lt;/CV_SCRIPT_PATH>&lt;CV_BINDIR_MAXDB class=&quot;java.lang.String&quot;>/opt/sdb/MaxDB/bin&lt;/CV_BINDIR_MAXDB>&lt;CV_EMAIL_ID class=&quot;java.lang.String&quot; _list_=&quot;true&quot;>abc@xyz.com;def@xyz.com&lt;/CV_EMAIL_ID>&lt;CV_DBMCLI_PATH class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>D:\sdb\MaxDB\pgm&lt;/CV_DBMCLI_PATH>&lt;/inputs>"

    interactive="0" isHtmlDescription="0" name="MaxDB"

    outputs="&lt;outputs />" revision="$Revision: 1.1.2.1 $"

    uniqueGuid="2aa93dd8-6eb9-4775-92f9-a5054285013f"

    variables="&lt;variables />" workflowId="0">

    <schema>

        <outputs attribute="0" className="" listType="0" name="outputs"

            required="1" type=""/>

        <variables attribute="0" className="" listType="0"

            name="variables" required="1" type=""/>

        <inputs attribute="0" className="" listType="0" name="inputs"

            required="1" type="">

            <children attribute="0"

                className="commvault.msgs.CvEntities.ClientEntity"

                controlType="2" displayName="Select your client"

                documentation="" hidden="0"

                inputType="commvault.msgs.CvEntities.ClientEntity"

                listType="0" maximumValue="" minimumValue=""

                name="CV_MAXDB_CLIENT_NAME" readOnly="0" required="1"

                searchable="0" type="{commvault.msgs.CvEntities}ClientEntity">

                <children attribute="0" className="java.lang.String"

                    inputType="java.lang.String" listType="0"

                    name="clientName" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children attribute="0" className="java.lang.Integer"

                    inputType="java.lang.Integer" listType="0"

                    name="clientId" required="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            </children>

            <children attribute="0" className="java.lang.String"

                controlType="0"

                displayName="Enter the name of database instance "

                hidden="0" inputType="java.lang.String" listType="0"

                name="CV_MAXDB_INSTANCE_NAME" required="1" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="4" displayName="Select the backup type"

                hidden="0" inputType="java.lang.String" listType="1"

                name="CV_BACKUP_TYPE" required="1" type="{http://www.w3.org/2001/XMLSchema}string">

                <options val="online_full"/>

                <options val="offline_full"/>

                <options val="online_incr"/>

                <options val="offline_incr"/>

                <options val="log_backup"/>

            </children>

            <children attribute="0" className="java.lang.String"

                controlType="0" displayName="Enter the OS username"

                hidden="0" inputType="java.lang.String" listType="0"

                name="CV_SIDADM_USER" required="1" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0"

                className="workflow.types.EncryptedString"

                controlType="0" displayName="Enter the OS user password"

                hidden="0" inputType="workflow.types.EncryptedString"

                listType="0" name="CV_SIDADM_PASSWORD" required="1" type="{workflow.types}EncryptedString"/>

            <children attribute="0" className="java.lang.String"

                controlType="0"

                displayName="Enter the username to connect to DB"

                hidden="0" inputType="java.lang.String" listType="0"

                name="CV_MAXDB_SUPERDBA_USER" required="1" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0"

                className="workflow.types.EncryptedString"

                controlType="0"

                displayName="Enter the password to connect to DB"

                hidden="0" inputType="workflow.types.EncryptedString"

                listType="0" name="CV_MAXDB_SUPERDBA_PASSWORD"

                required="1" type="{workflow.types}EncryptedString"/>

            <children attribute="0" className="java.lang.String"

                controlType="0"

                displayName="Enter a temp path for script" hidden="0"

                inputType="java.lang.String" listType="0"

                name="CV_SCRIPT_PATH" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0"

                displayName="Enter the path to MaxDB bin directory"

                hidden="0" inputType="java.lang.String" listType="0"

                name="CV_BINDIR_MAXDB" required="1" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0"

                displayName="Additional Recipients for Email" hidden="0"

                inputType="java.lang.String" listType="1"

                name="CV_EMAIL_ID" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue=""

                displayName="Enter the path to dbmcli executable"

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" maximumValue="" minimumValue=""

                name="CV_DBMCLI_PATH" readOnly="0" required="1"

                searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

        </inputs>

    </schema>

    <Start commented="0" continueOnFailure="0" created="0"

        description="" displayName="Start" height="36" interactive="0"

        jobMode="0" name="Start" originalStyle="" skipAttempt="0"

        style="image;image=/images/jgraphx/house.png"

        uniqueName="Start_1" waitSetting="0" width="61" x="0" y="626">

        <inputs val="&lt;inputs />"/>

        <transition activity="CommServDBQuery_1" commented="0"

            originalStyle="" points="73.0,655.0;99.0,655.0" sourceX="77"

            sourceY="310" status="0"

            style="defaultEdge;noEdgeStyle=1;orthogonal=1" targetX="103"

            targetY="210" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Start>

    <Activity commented="0" continueOnFailure="1"

        created="1402940307561"

        description="Execute a script on a remote machine"

        displayName="ExecuteScript&#xa;Online Full Backup" height="34"

        interactive="0" jobMode="0" name="ExecuteScript"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ExecuteScript" uniqueName="ExecuteScript_1"

        waitSetting="0" width="153" x="926" y="179">

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/inputs/CV_MAXDB_CLIENT_NAME/clientName}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/CV_SIDADM_USER}&lt;/impersonateUserName>&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot;>xpath:{/workflow/inputs/CV_SIDADM_PASSWORD}&lt;/impersonateUserPassword>&lt;startUpPath class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/CV_SCRIPT_PATH}&lt;/startUpPath>&lt;scriptType class=&quot;commvault.msgs.App.ScriptType&quot;>UnixShell&lt;/scriptType>&lt;script class=&quot;java.lang.String&quot;>export PATH=xpath:{/workflow/inputs/CV_BINDIR_MAXDB}:$PATH&amp;#xD;dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} db_warm&amp;#xD;dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} -uUTL -c backup_start BackData2 Recovery&amp;#xD;&lt;/script>&lt;arguments class=&quot;java.lang.String&quot; />&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="Decision_1" commented="0" originalStyle=""

            points="1110.0,197.0;1136.0,70.0" sourceX="496"

            sourceY="235" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="716" targetY="227" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1402948451764" description="if/else based decision"

        displayName="Decision" height="100" interactive="0" jobMode="0"

        name="Decision" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_1" waitSetting="0" width="100" x="1148" y="20">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/ExecuteScript_1/exitCode}==0&lt;/expression>&lt;/inputs>"/>

        <transition activity="Email_14" commented="0" displayName="Yes"

            originalStyle="" points="1260.0,47.5;1286.0,18.0"

            sourceX="797" sourceY="236" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="131" targetY="786" transitionIndex="0" value="true"

            x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="Email_15" commented="0" displayName="NO"

            originalStyle="" points="1260.0,92.5;1286.0,85.0"

            sourceX="783" sourceY="239" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="885" targetY="236" transitionIndex="0"

            value="False" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1403106254677" description="switch based decision"

        displayName="Switch" height="100" interactive="0" jobMode="0"

        name="Switch" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Switch_1" waitSetting="0" width="100" x="505" y="453">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/CV_BACKUP_TYPE}&lt;/expression>&lt;/inputs>"/>

        <transition activity="LogEvent_1" commented="0"

            displayName="Online Full" originalStyle=""

            points="617.0,467.0;643.0,325.0" sourceX="99" sourceY="236"

            status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="229" targetY="230" transitionIndex="0"

            value="online_full" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="LogEvent_2" commented="0"

            displayName="Online Incr" originalStyle=""

            points="619.0,485.0;643.0,394.0" sourceX="99" sourceY="236"

            status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="227" targetY="378" transitionIndex="0"

            value="online_incr" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="LogEvent_4" commented="0"

            displayName="offline Full" originalStyle=""

            points="621.0,503.0;643.0,467.0" sourceX="99" sourceY="236"

            status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="241" targetY="874" transitionIndex="0"

            value="offline_full" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="LogEvent_3" commented="0"

            displayName="Log Backup" originalStyle=""

            points="619.0,521.0;643.0,541.0" sourceX="99" sourceY="236"

            status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="256" targetY="589" transitionIndex="0"

            value="log_backup" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="LogEvent_5" commented="0"

            displayName="offline_incr" originalStyle=""

            points="617.0,539.0;643.0,615.0" sourceX="99" sourceY="236"

            status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="251" targetY="1119" transitionIndex="0"

            value="offline_incr" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="1"

        created="1403109708427"

        description="Execute a script on a remote machine"

        displayName="ExecuteScript&#xa;Online Incr Backup" height="34"

        interactive="0" jobMode="0" name="ExecuteScript"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ExecuteScript" uniqueName="ExecuteScript_2"

        waitSetting="0" width="156" x="924" y="279">

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/inputs/CV_MAXDB_CLIENT_NAME/clientName}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/CV_SIDADM_USER}&lt;/impersonateUserName>&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot;>xpath:{/workflow/inputs/CV_SIDADM_PASSWORD}&lt;/impersonateUserPassword>&lt;startUpPath class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/CV_SCRIPT_PATH}&lt;/startUpPath>&lt;scriptType class=&quot;commvault.msgs.App.ScriptType&quot;>UnixShell&lt;/scriptType>&lt;script class=&quot;java.lang.String&quot;>export PATH=xpath:{/workflow/inputs/CV_BINDIR_MAXDB}:$PATH&amp;#xD;dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} db_warm&amp;#xD;dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} -uUTL -c backup_start BackPages2 recovery&amp;#xD;&lt;/script>&lt;arguments class=&quot;java.lang.String&quot; />&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="Decision_2" commented="0" originalStyle=""

            points="1110.0,297.0;1136.0,200.0" sourceX="545"

            sourceY="415" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="687" targetY="439" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1403110057608" description="if/else based decision"

        displayName="Decision" height="100" interactive="0" jobMode="0"

        name="Decision" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_3" waitSetting="0" width="100" x="1148" y="410">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/ExecuteScript_3/exitCode}==0&lt;/expression>&lt;/inputs>"/>

        <transition activity="Email_12" commented="0" displayName="NO"

            originalStyle="" points="1260.0,437.5;1286.0,420.0"

            sourceX="781" sourceY="662" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="777" targetY="769" transitionIndex="0"

            value="false" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="Email_7" commented="0" displayName="YES"

            originalStyle="" points="1260.0,482.5;1286.0,487.0"

            sourceX="794" sourceY="660" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="948" targetY="685" transitionIndex="0" value="true"

            x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1403110158978"

        description="logs an event in the commcell console with the specified severity level"

        displayName="LogEvent&#xa;Online incr Backup" height="34"

        interactive="0" jobMode="0" name="LogEvent"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=LogEvent"

        uniqueName="LogEvent_2" waitSetting="0" width="200" x="656" y="376">

        <inputs val="&lt;inputs>&lt;severity class=&quot;workflow.types.SeverityLevel&quot;>INFO&lt;/severity>&lt;message class=&quot;java.lang.String&quot;>Starting online incremental backup of MaxDB database xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME}&lt;/message>&lt;/inputs>"/>

        <transition activity="ExecuteScript_2" commented="0"

            originalStyle="" points="871.0,394.0;897.0,297.0"

            sourceX="325" sourceY="416" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="500" targetY="418" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1403110488058"

        description="logs an event in the commcell console with the specified severity level"

        displayName="LogEvent&#xa;Online Full Backup" height="34"

        interactive="0" jobMode="0" name="LogEvent"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=LogEvent"

        uniqueName="LogEvent_1" waitSetting="0" width="153" x="679" y="307">

        <inputs val="&lt;inputs>&lt;severity class=&quot;workflow.types.SeverityLevel&quot;>INFO&lt;/severity>&lt;message class=&quot;java.lang.String&quot;>Starting online full backup of xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} on xpath:{/workflow/inputs/CV_MAXDB_CLIENT_NAME}&lt;/message>&lt;/inputs>"/>

        <transition activity="ExecuteScript_1" commented="0"

            originalStyle="" points="871.0,325.0;897.0,197.0"

            sourceX="299" sourceY="235" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="539" targetY="104" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1403110605118"

        description="logs an event in the commcell console with the specified severity level"

        displayName="LogEvent&#xa;Transaction Log Backup" height="34"

        interactive="0" jobMode="0" name="LogEvent"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=LogEvent"

        uniqueName="LogEvent_3" waitSetting="0" width="200" x="656" y="523">

        <inputs val="&lt;inputs>&lt;severity class=&quot;workflow.types.SeverityLevel&quot;>INFO&lt;/severity>&lt;message class=&quot;java.lang.String&quot;>Starting transaction log backup of MaxDB database xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME}&lt;/message>&lt;/inputs>"/>

        <transition activity="ExecuteScript_3" commented="0"

            originalStyle="" points="871.0,541.0;897.0,500.0"

            sourceX="326" sourceY="662" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="488" targetY="654" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="1"

        created="1403110729888"

        description="Execute a script on a remote machine"

        displayName="ExecuteScript&#xa;Transaction Log Backup"

        height="34" interactive="0" jobMode="0" name="ExecuteScript"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ExecuteScript" uniqueName="ExecuteScript_3"

        waitSetting="0" width="187" x="909" y="482">

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/inputs/CV_MAXDB_CLIENT_NAME/clientName}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/CV_SIDADM_USER}&lt;/impersonateUserName>&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot;>xpath:{/workflow/inputs/CV_SIDADM_PASSWORD}&lt;/impersonateUserPassword>&lt;startUpPath class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/CV_SCRIPT_PATH}&lt;/startUpPath>&lt;scriptType class=&quot;commvault.msgs.App.ScriptType&quot;>UnixShell&lt;/scriptType>&lt;script class=&quot;java.lang.String&quot;>export PATH=xpath:{/workflow/inputs/CV_BINDIR_MAXDB}:$PATH&amp;#xD;dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} db_warm&amp;#xD;dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} -uUTL -c backup_start BackLog&amp;#xD;&lt;/script>&lt;arguments class=&quot;java.lang.String&quot; />&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="Decision_3" commented="0" originalStyle=""

            points="1110.0,500.0;1136.0,460.0" sourceX="564"

            sourceY="661" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="755" targetY="657" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1403110945748" description="if/else based decision"

        displayName="Decision" height="100" interactive="0" jobMode="0"

        name="Decision" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_2" waitSetting="0" width="100" x="1148" y="150">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/ExecuteScript_2/exitCode}==0&lt;/expression>&lt;/inputs>"/>

        <transition activity="Email_13" commented="0" displayName="YES"

            originalStyle="" points="1260.0,177.5;1286.0,152.0"

            sourceX="792" sourceY="440" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="988" targetY="441" transitionIndex="0" value="true"

            x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="Email_9" commented="0" displayName="NO"

            originalStyle="" points="1260.0,222.5;1286.0,219.0"

            sourceX="792" sourceY="440" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="789" targetY="552" transitionIndex="0"

            value="false" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1404379598826"

        description="logs an event in the commcell console with the specified severity level"

        displayName="LogEvent&#xa;Offline full backup" height="46"

        interactive="0" jobMode="0" name="LogEvent"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=LogEvent"

        uniqueName="LogEvent_4" waitSetting="0" width="202" x="655" y="442">

        <inputs val="&lt;inputs>&lt;severity class=&quot;workflow.types.SeverityLevel&quot;>INFO&lt;/severity>&lt;message class=&quot;java.lang.String&quot;>Starting offline full backup of MaxDB database xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME}&lt;/message>&lt;/inputs>"/>

        <transition activity="ExecuteScript_4" commented="0"

            originalStyle="" points="871.0,467.0;897.0,398.0"

            sourceX="340" sourceY="875" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="481" targetY="871" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1404379752471" description="if/else based decision"

        displayName="Decision" height="100" interactive="0" jobMode="0"

        name="Decision" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_4" waitSetting="0" width="100" x="1148" y="280">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/ExecuteScript_4/exitCode}==0&lt;/expression>&lt;/inputs>"/>

        <transition activity="Email_10" commented="0" displayName="NO"

            originalStyle="" points="1260.0,307.5;1286.0,286.0"

            sourceX="820" sourceY="887" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="819" targetY="1033" transitionIndex="0"

            value="False" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="Email_4" commented="0" displayName="YES"

            originalStyle="" points="1260.0,352.5;1286.0,353.0"

            sourceX="820" sourceY="887" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="942" targetY="874" transitionIndex="0" value="True"

            x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="1"

        created="1404380254893"

        description="Execute a script on a remote machine"

        displayName="ExecuteScript&#xa;Offline full Backup" height="34"

        interactive="0" jobMode="0" name="ExecuteScript"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ExecuteScript" uniqueName="ExecuteScript_4"

        waitSetting="0" width="187" x="909" y="380">

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/inputs/CV_MAXDB_CLIENT_NAME/clientName}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/CV_SIDADM_USER}&lt;/impersonateUserName>&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot;>xpath:{/workflow/inputs/CV_SIDADM_PASSWORD}&lt;/impersonateUserPassword>&lt;startUpPath class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/CV_SCRIPT_PATH}&lt;/startUpPath>&lt;scriptType class=&quot;commvault.msgs.App.ScriptType&quot;>UnixShell&lt;/scriptType>&lt;script class=&quot;java.lang.String&quot;>export PATH=xpath:{/workflow/inputs/CV_BINDIR_MAXDB}:$PATH&amp;#xD;dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} db_cold&amp;#xD;dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} -uUTL -c backup_start BackData2 Migration&lt;/script>&lt;arguments class=&quot;java.lang.String&quot; />&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="Decision_4" commented="0" originalStyle=""

            points="1110.0,398.0;1136.0,330.0" sourceX="729"

            sourceY="320" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="993" targetY="333" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1404397428991"

        description="logs an event in the commcell console with the specified severity level"

        displayName="LogEvent&#xa;Offline incr backup" height="46"

        interactive="0" jobMode="0" name="LogEvent"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=LogEvent"

        uniqueName="LogEvent_5" waitSetting="0" width="202" x="655" y="590">

        <inputs val="&lt;inputs>&lt;severity class=&quot;workflow.types.SeverityLevel&quot;>INFO&lt;/severity>&lt;message class=&quot;java.lang.String&quot;>Starting offline incremental backup of MaxDB database xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME}&lt;/message>&lt;/inputs>"/>

        <transition activity="ExecuteScript_5" commented="0"

            originalStyle="" points="871.0,615.0;897.0,602.0"

            sourceX="352" sourceY="1120" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="589" targetY="1121" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="1"

        created="1404397440431"

        description="Execute a script on a remote machine"

        displayName="ExecuteScript&#xa;Offline incr Backup" height="34"

        interactive="0" jobMode="0" name="ExecuteScript"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ExecuteScript" uniqueName="ExecuteScript_5"

        waitSetting="0" width="187" x="909" y="584">

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/inputs/CV_MAXDB_CLIENT_NAME/clientName}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/CV_SIDADM_USER}&lt;/impersonateUserName>&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot;>xpath:{/workflow/inputs/CV_SIDADM_PASSWORD}&lt;/impersonateUserPassword>&lt;startUpPath class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/CV_SCRIPT_PATH}&lt;/startUpPath>&lt;scriptType class=&quot;commvault.msgs.App.ScriptType&quot;>UnixShell&lt;/scriptType>&lt;script class=&quot;java.lang.String&quot;>export PATH=xpath:{/workflow/inputs/CV_BINDIR_MAXDB}:$PATH&amp;#xD;dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} db_cold&amp;#xD;dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} -uUTL -c backup_start BackPages2 Migration&lt;/script>&lt;arguments class=&quot;java.lang.String&quot; />&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="Decision_5" commented="0" originalStyle=""

            points="1110.0,602.0;1136.0,590.0" sourceX="589"

            sourceY="1121" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="822" targetY="1123" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1404397467359" description="if/else based decision"

        displayName="Decision" height="100" interactive="0" jobMode="0"

        name="Decision" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_5" waitSetting="0" width="100" x="1148" y="540">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/ExecuteScript_5/exitCode}==0&lt;/expression>&lt;/inputs>"/>

        <transition activity="Email_3" commented="0" displayName="YES"

            originalStyle="" points="1260.0,567.5;1286.0,554.0"

            sourceX="822" sourceY="1123" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="1072" targetY="1203" transitionIndex="0"

            value="True" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="Email_6" commented="0" displayName="NO"

            originalStyle="" points="1260.0,612.5;1286.0,621.0"

            sourceX="822" sourceY="1123" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="827" targetY="1225" transitionIndex="0"

            value="False" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1404399248755"

        description="Sends an email to a list of users"

        displayName="Email" height="34" interactive="0" jobMode="0"

        name="Email" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Email"

        uniqueName="Email_3" waitSetting="0" width="100" x="1298" y="535">

        <inputs val="&lt;inputs>&lt;email>&lt;from>xpath:{/workflow/system/executor/userName}&lt;/from>&lt;to>xpath:{/workflow/system/executor/userName}&lt;/to>&lt;cc>xpath:{/workflow/inputs/CV_EMAIL_ID}&lt;/cc>&lt;bcc />&lt;subject>Offline incremental backup for MaxDB database xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} completed&lt;/subject>&lt;attachments />&lt;body>&amp;lt;div&amp;gt;&#xd;&#xa;      &#xd;&#xa;    &amp;lt;/div&amp;gt;&#xd;&#xa;    &amp;lt;div&amp;gt;&#xd;&#xa;      &amp;lt;font face=&quot;Segoe UI&quot; size=&quot;2&quot;&amp;gt;Summary: &amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/div&amp;gt;&#xd;&#xa;    &amp;lt;div&amp;gt;&#xd;&#xa;      &#xd;&#xa;    &amp;lt;/div&amp;gt;&#xd;&#xa;    &amp;lt;div&amp;gt;&#xd;&#xa;      &amp;lt;font face=&quot;Segoe UI&quot; size=&quot;2&quot;&amp;gt;Offline incremental backup using workflow &#xd;&#xa;      for MaxDB database xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} &#xd;&#xa;      completed &amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#006633&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;successfully&amp;lt;/font&amp;gt;&amp;lt;font size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;. &#xd;&#xa;      &amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/div&amp;gt;&#xd;&#xa;    &amp;lt;div&amp;gt;&#xd;&#xa;      &#xd;&#xa;    &amp;lt;/div&amp;gt;&#xd;&#xa;    &amp;lt;div&amp;gt;&#xd;&#xa;      &amp;lt;font size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Workflow jobId: &#xd;&#xa;      xpath:{/workflow/system/jobId} &amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/div&amp;gt;&#xd;&#xa;    &amp;lt;div&amp;gt;&#xd;&#xa;      &#xd;&#xa;    &amp;lt;/div&amp;gt;&#xd;&#xa;    &amp;lt;div&amp;gt;&#xd;&#xa;      &amp;lt;font size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Details: &#xd;&#xa;      xpath:{/workflow/ExecuteScript_5/commandOutput}&amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/div&amp;gt;&lt;/body>&lt;html>true&lt;/html>&lt;/email>&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1404401872593"

        description="Sends an email to a list of users"

        displayName="Email" height="34" interactive="0" jobMode="0"

        name="Email" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Email"

        uniqueName="Email_4" waitSetting="0" width="100" x="1298" y="334">

        <inputs val="&lt;inputs>&lt;email>&lt;from>xpath:{/workflow/system/executor/userName}&lt;/from>&lt;to>xpath:{/workflow/system/executor/userName}&lt;/to>&lt;cc>xpath:{/workflow/inputs/CV_EMAIL_ID}&lt;/cc>&lt;bcc />&lt;subject>Offline full backup for instance xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} completed&lt;/subject>&lt;attachments />&lt;body>&amp;lt;div&amp;gt;&#xd;&#xa;      &#xd;&#xa;    &amp;lt;/div&amp;gt;&#xd;&#xa;    &amp;lt;div&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Summary:&amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/div&amp;gt;&#xd;&#xa;    &amp;lt;div&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;&amp;lt;br&amp;gt;&#xd;&#xa;      Offline full backup using workflow for instance &#xd;&#xa;      xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} completed &amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#006633&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;successfully&amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;. &#xd;&#xa;      &amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/div&amp;gt;&#xd;&#xa;    &amp;lt;div&amp;gt;&#xd;&#xa;      &#xd;&#xa;    &amp;lt;/div&amp;gt;&#xd;&#xa;    &amp;lt;div&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Workflow jobId: &#xd;&#xa;      xpath:{/workflow/system/jobId} &amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/div&amp;gt;&#xd;&#xa;    &amp;lt;div&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;&#xd;&#xa;&amp;lt;/font&amp;gt;    &amp;lt;/div&amp;gt;&#xd;&#xa;    &amp;lt;div&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Details: &amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/div&amp;gt;&#xd;&#xa;    &amp;lt;div&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;&#xd;&#xa;&amp;lt;/font&amp;gt;    &amp;lt;/div&amp;gt;&#xd;&#xa;    &amp;lt;div&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;xpath:{/workflow/ExecuteScript_4/commandOutput}&amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/div&amp;gt;&lt;/body>&lt;html>true&lt;/html>&lt;/email>&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1404448716330"

        description="Sends an email to a list of users"

        displayName="Email" height="34" interactive="0" jobMode="0"

        name="Email" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Email"

        uniqueName="Email_6" waitSetting="0" width="100" x="1298" y="602">

        <inputs val="&lt;inputs>&lt;email>&lt;from>xpath:{/workflow/system/executor/userName}&lt;/from>&lt;to>xpath:{/workflow/system/executor/userName}&lt;/to>&lt;cc>xpath:{/workflow/inputs/CV_EMAIL_ID}&lt;/cc>&lt;bcc />&lt;subject>Offline incremental backup for MaxDB database xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} failed&lt;/subject>&lt;attachments />&lt;body>&amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Summary: &amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#000000&quot;&amp;gt;&#xd;&#xa;&amp;lt;/font&amp;gt;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Offline incremental &#xd;&#xa;      backup using workflow for MaxDB database &#xd;&#xa;      xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} &amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#990000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;failed&amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;.&amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#000000&quot;&amp;gt;&#xd;&#xa;&amp;lt;/font&amp;gt;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Workflow jobId: &#xd;&#xa;      xpath:{/workflow/system/jobId} &amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#000000&quot;&amp;gt;&#xd;&#xa;&amp;lt;/font&amp;gt;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Details:&amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#000000&quot;&amp;gt;&#xd;&#xa;&amp;lt;/font&amp;gt;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;xpath:{/workflow/ExecuteScript_5/commandOutput}&amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/p&amp;gt;&lt;/body>&lt;html>true&lt;/html>&lt;/email>&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1404448737171"

        description="Sends an email to a list of users"

        displayName="Email" height="34" interactive="0" jobMode="0"

        name="Email" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Email"

        uniqueName="Email_7" waitSetting="0" width="100" x="1298" y="468">

        <inputs val="&lt;inputs>&lt;email>&lt;from>xpath:{/workflow/system/executor/userName}&lt;/from>&lt;to>xpath:{/workflow/system/executor/userName}&lt;/to>&lt;cc>xpath:{/workflow/inputs/CV_EMAIL_ID}&lt;/cc>&lt;bcc />&lt;subject>Transaction log backup for MaxDB database xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} completed&lt;/subject>&lt;attachments />&lt;body>&amp;lt;font size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;&#xd;&#xa;&amp;lt;/font&amp;gt;  &#xd;&#xa;  &#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;&#xd;&#xa;&amp;lt;/font&amp;gt;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Summary:&#xd;&#xa;&amp;lt;/font&amp;gt;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Transaction log backup using workflow for &#xd;&#xa;      MaxDB database xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} completed &amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#006633&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;successfully&amp;lt;/font&amp;gt;&amp;lt;font size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;.&#xd;&#xa;&amp;lt;/font&amp;gt;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Workflow jobId: &#xd;&#xa;      xpath:{/workflow/system/jobId}&#xd;&#xa;&amp;lt;/font&amp;gt;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Details:&#xd;&#xa;&amp;lt;/font&amp;gt;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;xpath:{/workflow/ExecuteScript_3/commandOutput}&amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/p&amp;gt;&lt;/body>&lt;html>true&lt;/html>&lt;/email>&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1404448746335"

        description="Sends an email to a list of users"

        displayName="Email" height="34" interactive="0" jobMode="0"

        name="Email" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Email"

        uniqueName="Email_9" waitSetting="0" width="100" x="1298" y="200">

        <inputs val="&lt;inputs>&lt;email>&lt;from>xpath:{/workflow/system/executor/userName}&lt;/from>&lt;to>xpath:{/workflow/system/executor/userName}&lt;/to>&lt;cc>xpath:{/workflow/inputs/CV_EMAIL_ID}&lt;/cc>&lt;bcc />&lt;subject>Online incremental backup for instance xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} failed&lt;/subject>&lt;attachments />&lt;body>&amp;lt;p&amp;gt;&#xd;&#xa;      &#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font face=&quot;Segoe UI&quot; size=&quot;2&quot;&amp;gt;Summary: &amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font face=&quot;Segoe UI&quot; size=&quot;2&quot;&amp;gt;Online incremental backup using workflow &#xd;&#xa;      for MaxDB database xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} &amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#990000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;failed&amp;lt;/font&amp;gt;&amp;lt;font size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt; &#xd;&#xa;      &amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Workflow jobId: &#xd;&#xa;      xpath:{/workflow/system/jobId} &amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Details: &amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;xpath:{/workflow/ExecuteScript_2/commandOutput}&amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/p&amp;gt;&lt;/body>&lt;html>true&lt;/html>&lt;/email>&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1404448749663"

        description="Sends an email to a list of users"

        displayName="Email" height="34" interactive="0" jobMode="0"

        name="Email" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Email"

        uniqueName="Email_10" waitSetting="0" width="100" x="1298" y="267">

        <inputs val="&lt;inputs>&lt;email>&lt;from>xpath:{/workflow/system/executor/userName}&lt;/from>&lt;to>xpath:{/workflow/system/executor/userName}&lt;/to>&lt;cc>xpath:{/workflow/inputs/CV_EMAIL_ID}&lt;/cc>&lt;bcc />&lt;subject>Offline full backup for instance xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} failed&lt;/subject>&lt;attachments />&lt;body>&amp;lt;font color=&quot;#000000&quot;&amp;gt;&#xd;&#xa;&amp;lt;/font&amp;gt;  &#xd;&#xa;  &#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Summary: &amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#000000&quot;&amp;gt;&#xd;&#xa;&amp;lt;/font&amp;gt;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Offline full backup using &#xd;&#xa;      workflow for instance xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} &amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#990000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;failed&amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt; &#xd;&#xa;      &amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#000000&quot;&amp;gt;&#xd;&#xa;&amp;lt;/font&amp;gt;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Workflow jobId: &#xd;&#xa;      xpath:{/workflow/system/jobId} &amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#000000&quot;&amp;gt;&#xd;&#xa;&amp;lt;/font&amp;gt;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Details: &amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#000000&quot;&amp;gt;&#xd;&#xa;&amp;lt;/font&amp;gt;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;xpath:{/workflow/ExecuteScript_4/commandOutput}&amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/p&amp;gt;&lt;/body>&lt;html>true&lt;/html>&lt;/email>&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1404448757407"

        description="Sends an email to a list of users"

        displayName="Email" height="34" interactive="0" jobMode="0"

        name="Email" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Email"

        uniqueName="Email_12" waitSetting="0" width="100" x="1298" y="401">

        <inputs val="&lt;inputs>&lt;email>&lt;from>xpath:{/workflow/system/executor/userName}&lt;/from>&lt;to>xpath:{/workflow/system/executor/userName}&lt;/to>&lt;cc>xpath:{/workflow/inputs/CV_EMAIL_ID}&lt;/cc>&lt;bcc />&lt;subject>Transaction log backup for MaxDB database xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} failed&lt;/subject>&lt;attachments />&lt;body>&amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Summary: &amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#000000&quot;&amp;gt;&#xd;&#xa;&amp;lt;/font&amp;gt;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Transaction log backup &#xd;&#xa;      using workflow for MaxDB database &#xd;&#xa;      xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME}&amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#000066&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt; &#xd;&#xa;      &amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#990000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;failed&amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Workflow jobId: &#xd;&#xa;      xpath:{/workflow/system/jobId} &amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#000000&quot;&amp;gt;&#xd;&#xa;&amp;lt;/font&amp;gt;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Details: &amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#000000&quot;&amp;gt;&#xd;&#xa;&amp;lt;/font&amp;gt;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;xpath:{/workflow/ExecuteScript_3/commandOutput}&amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/p&amp;gt;&lt;/body>&lt;html>true&lt;/html>&lt;/email>&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1404448758747"

        description="Sends an email to a list of users"

        displayName="Email" height="34" interactive="0" jobMode="0"

        name="Email" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Email"

        uniqueName="Email_13" waitSetting="0" width="100" x="1298" y="133">

        <inputs val="&lt;inputs>&lt;email>&lt;from>xpath:{/workflow/system/executor/userName}&lt;/from>&lt;to>xpath:{/workflow/system/executor/userName}&lt;/to>&lt;cc>xpath:{/workflow/inputs/CV_EMAIL_ID}&lt;/cc>&lt;bcc />&lt;subject>Online incremental backup for instance xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} completed&lt;/subject>&lt;attachments />&lt;body>&amp;lt;p&amp;gt;&#xd;&#xa;      &#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font face=&quot;Segoe UI&quot; size=&quot;2&quot;&amp;gt;Summary: &amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font face=&quot;Segoe UI&quot; size=&quot;2&quot;&amp;gt;Online incremental backup using workflow &#xd;&#xa;      for MaxDB database xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} &#xd;&#xa;      completed &amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#006633&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;successfully&amp;lt;/font&amp;gt;&amp;lt;font size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;. &#xd;&#xa;      &amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Workflow jobId: &#xd;&#xa;      xpath:{/workflow/system/jobId} &amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Details: &amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;xpath:{/workflow/ExecuteScript_2/commandOutput}&amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/p&amp;gt;&lt;/body>&lt;html>true&lt;/html>&lt;/email>&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1404448760038"

        description="Sends an email to a list of users"

        displayName="Email" height="34" interactive="0" jobMode="0"

        name="Email" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Email"

        uniqueName="Email_14" waitSetting="0" width="100" x="1298" y="0">

        <inputs val="&lt;inputs>&lt;email>&lt;from>xpath:{/workflow/system/executor/userName}&lt;/from>&lt;to>xpath:{/workflow/system/executor/userName}&lt;/to>&lt;cc>xpath:{/workflow/inputs/CV_EMAIL_ID}&lt;/cc>&lt;bcc />&lt;subject>Online full backup for MaxDB database xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} completed&lt;/subject>&lt;attachments />&lt;body>&amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Summary: &amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#000000&quot;&amp;gt;&#xd;&#xa;&amp;lt;/font&amp;gt;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Online full backup using &#xd;&#xa;      workflow for MaxDB database &#xd;&#xa;      xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} completed &amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#006633&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;successfully&amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;. &#xd;&#xa;      &amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#000000&quot;&amp;gt;&#xd;&#xa;&amp;lt;/font&amp;gt;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Workflow jobId: &#xd;&#xa;      xpath:{/workflow/system/jobId} &amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#000000&quot;&amp;gt;&#xd;&#xa;&amp;lt;/font&amp;gt;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Details: &amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#000000&quot;&amp;gt;&#xd;&#xa;&amp;lt;/font&amp;gt;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;xpath:{/workflow/ExecuteScript_1/commandOutput}&amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/p&amp;gt;&lt;/body>&lt;html>true&lt;/html>&lt;/email>&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1404448761756"

        description="Sends an email to a list of users"

        displayName="Email" height="34" interactive="0" jobMode="0"

        name="Email" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Email"

        uniqueName="Email_15" waitSetting="0" width="100" x="1298" y="66">

        <inputs val="&lt;inputs>&lt;email>&lt;from>xpath:{/workflow/system/executor/userName}&lt;/from>&lt;to>xpath:{/workflow/system/executor/userName}&lt;/to>&lt;cc>xpath:{/workflow/inputs/CV_EMAIL_ID}&lt;/cc>&lt;bcc />&lt;subject>Online full backup for MaxDB database xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} failed&lt;/subject>&lt;attachments />&lt;body>&amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font face=&quot;Segoe UI&quot; color=&quot;#000000&quot; size=&quot;2&quot;&amp;gt;Summary: &amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font face=&quot;Segoe UI&quot; color=&quot;#000000&quot; size=&quot;2&quot;&amp;gt;Online full backup for &#xd;&#xa;      MaxDB database xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} &amp;lt;/font&amp;gt;&amp;lt;font face=&quot;Segoe UI&quot; color=&quot;#990000&quot; size=&quot;2&quot;&amp;gt;failed&amp;lt;/font&amp;gt;&amp;lt;font face=&quot;Segoe UI&quot; color=&quot;#000000&quot; size=&quot;2&quot;&amp;gt;. &#xd;&#xa;      &amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font face=&quot;Segoe UI&quot; color=&quot;#000000&quot; size=&quot;2&quot;&amp;gt;Workflow jobId: &#xd;&#xa;      xpath:{/workflow/system/jobId} &amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font face=&quot;Segoe UI&quot; color=&quot;#000000&quot; size=&quot;2&quot;&amp;gt;Details: &amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font face=&quot;Segoe UI&quot; color=&quot;#000000&quot; size=&quot;2&quot;&amp;gt;xpath:{/workflow/ExecuteScript_1/commandOutput}&amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/p&amp;gt;&lt;/body>&lt;html>true&lt;/html>&lt;/email>&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1447766659082"

        description="executes queries against a commcell database"

        displayName="Find Client in CS DB" height="34" interactive="0"

        jobMode="0" name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=CommServDBQuery"

        uniqueName="CommServDBQuery_1" waitSetting="0" width="143"

        x="111" y="636">

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>SELECT COUNT([name])&amp;#xD;&#xd;&#xa;FROM [CommServ].[dbo].[APP_Client]&amp;#xD;&#xd;&#xa;WHERE [name] = ''xpath:{/workflow/inputs/CV_MAXDB_CLIENT_NAME/clientName}''&lt;/query>&lt;/inputs>"/>

        <transition activity="WorkflowEnd_1" commented="0"

            displayName="Client Not Found" originalStyle=""

            points="268.0,648.25;294.0,621.0" sourceX="98" sourceY="210"

            status="0" style="defaultEdge;noEdgeStyle=1;orthogonal=1"

            targetX="191" targetY="143" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;xpath:{/workflow/CommServDBQuery_1/resultSets[1]/row[1]/col[1]} == 0"/>

        </transition>

        <transition activity="CommServDBQuery_2" commented="0"

            displayName="Client Found" originalStyle=""

            points="268.0,661.75;294.0,688.0" sourceX="98" sourceY="210"

            status="0" style="defaultEdge;noEdgeStyle=1;orthogonal=1"

            targetX="138" targetY="60" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;xpath:{/workflow/CommServDBQuery_1/resultSets[1]/row[1]/col[1]} == 1"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1449466525713" description="Ends the workflow"

        displayName="Failed to find Client" height="34" interactive="0"

        jobMode="0" name="WorkflowEnd"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=WorkflowEnd"

        uniqueName="WorkflowEnd_1" waitSetting="0" width="147" x="306" y="602">

        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;>COMPLETED_WITH_ERRORS&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>Failed to find the client is CS DB&lt;/failureMessage>&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1454926568914"

        description="executes queries against a commcell database"

        displayName="Find Client OS Type" height="34" interactive="0"

        jobMode="0" name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=CommServDBQuery"

        uniqueName="CommServDBQuery_2" waitSetting="0" width="143"

        x="308" y="669">

        <onExit language="1" script="logger.info(&quot;Operating System Type of client is &quot; + xpath:{/workflow/CommServDBQuery_2/resultSets[1]/row[1]/col[1]});"/>

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>SELECT sos.Type&amp;#xD;&#xd;&#xa;FROM [CommServ].[dbo].[APP_Client] client, simOperatingSystem sos&amp;#xD;&#xd;&#xa;WHERE client.[name] = ''xpath:{/workflow/inputs/CV_MAXDB_CLIENT_NAME/clientName}''&amp;#xD;&#xd;&#xa;AND sos.id = client.simOperatingSystemId&lt;/query>&lt;/inputs>"/>

        <transition activity="Switch_1" commented="0" displayName="UNIX"

            originalStyle="" points="467.0,681.25;493.0,503.0"

            sourceX="139" sourceY="61" status="0"

            style="defaultEdge;noEdgeStyle=1;orthogonal=1" targetX="136"

            targetY="332" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;xpath:{/workflow/CommServDBQuery_2/resultSets[1]/row[1]/col[1]}.equals(&quot;Unix&quot;)"/>

        </transition>

        <transition activity="Switch_6" commented="0"

            displayName="Windows" originalStyle=""

            points="467.0,694.75;493.0,807.0" sourceX="139" sourceY="61"

            status="0" style="defaultEdge;noEdgeStyle=1;orthogonal=1"

            targetX="202" targetY="838" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;xpath:{/workflow/CommServDBQuery_2/resultSets[1]/row[1]/col[1]}.equals(&quot;Windows&quot;)"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="1"

        created="1460368807754"

        description="Execute a script on a remote machine"

        displayName="ExecuteScript&#xa;Online Full Backup" height="34"

        interactive="0" jobMode="0" name="ExecuteScript"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ExecuteScript" uniqueName="ExecuteScript_26"

        waitSetting="0" width="153" x="926" y="671">

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/inputs/CV_MAXDB_CLIENT_NAME/clientName}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/CV_SIDADM_USER}&lt;/impersonateUserName>&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot;>xpath:{/workflow/inputs/CV_SIDADM_PASSWORD}&lt;/impersonateUserPassword>&lt;startUpPath class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/CV_SCRIPT_PATH}&lt;/startUpPath>&lt;scriptType class=&quot;commvault.msgs.App.ScriptType&quot;>WindowsBatch&lt;/scriptType>&lt;script class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/CV_DBMCLI_PATH}\dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} db_warm&amp;#xD;xpath:{/workflow/inputs/CV_DBMCLI_PATH}\dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} -uUTL -c backup_start BackData2 Recovery&amp;#xD;&lt;/script>&lt;arguments class=&quot;java.lang.String&quot; />&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="Decision_26" commented="0"

            originalStyle="" points="1110.0,689.0;1136.0,720.0"

            sourceX="605" sourceY="877" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="825" targetY="869" transitionIndex="0" x="109" y="642">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1460368807769" description="if/else based decision"

        displayName="Decision" height="100" interactive="0" jobMode="0"

        name="Decision" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_26" waitSetting="0" width="100" x="1148" y="670">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/ExecuteScript_1/exitCode}==0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="Email_64" commented="0" displayName="Yes"

            originalStyle="" points="1260.0,697.5;1286.0,688.0"

            sourceX="906" sourceY="878" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="240" targetY="1428" transitionIndex="0"

            value="true" x="109" y="642">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="Email_65" commented="0" displayName="NO"

            originalStyle="" points="1260.0,742.5;1286.0,755.0"

            sourceX="892" sourceY="881" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="994" targetY="878" transitionIndex="0"

            value="False" x="109" y="642">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1460368807796" description="switch based decision"

        displayName="Switch" height="100" interactive="0" jobMode="0"

        name="Switch" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Switch_6" waitSetting="0" width="100" x="505" y="757">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/CV_BACKUP_TYPE}&lt;/expression>&lt;/inputs>"/>

        <transition activity="LogEvent_27" commented="0"

            displayName="Online Full" originalStyle=""

            points="617.0,771.0;643.0,689.0" sourceX="208" sourceY="878"

            status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="338" targetY="872" transitionIndex="0"

            value="online_full" x="109" y="642">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="LogEvent_26" commented="0"

            displayName="Online Incr" originalStyle=""

            points="619.0,789.0;643.0,757.0" sourceX="208" sourceY="878"

            status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="336" targetY="1020" transitionIndex="0"

            value="online_incr" x="109" y="642">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="LogEvent_29" commented="0"

            displayName="offline Full" originalStyle=""

            points="621.0,807.0;643.0,831.0" sourceX="208" sourceY="878"

            status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="350" targetY="1516" transitionIndex="0"

            value="offline_full" x="109" y="642">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="LogEvent_28" commented="0"

            displayName="Log Backup" originalStyle=""

            points="619.0,825.0;643.0,905.0" sourceX="208" sourceY="878"

            status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="365" targetY="1231" transitionIndex="0"

            value="log_backup" x="109" y="642">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="LogEvent_30" commented="0"

            displayName="offline_incr" originalStyle=""

            points="617.0,843.0;643.0,979.0" sourceX="208" sourceY="878"

            status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="360" targetY="1761" transitionIndex="0"

            value="offline_incr" x="109" y="642">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="1"

        created="1460368807810"

        description="Execute a script on a remote machine"

        displayName="ExecuteScript&#xa;Online Incr Backup" height="34"

        interactive="0" jobMode="0" name="ExecuteScript"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ExecuteScript" uniqueName="ExecuteScript_27"

        waitSetting="0" width="156" x="924" y="739">

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/inputs/CV_MAXDB_CLIENT_NAME/clientName}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/CV_SIDADM_USER}&lt;/impersonateUserName>&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot;>xpath:{/workflow/inputs/CV_SIDADM_PASSWORD}&lt;/impersonateUserPassword>&lt;startUpPath class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/CV_SCRIPT_PATH}&lt;/startUpPath>&lt;scriptType class=&quot;commvault.msgs.App.ScriptType&quot;>WindowsBatch&lt;/scriptType>&lt;script class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/CV_DBMCLI_PATH}\dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} db_warm&amp;#xD;xpath:{/workflow/inputs/CV_DBMCLI_PATH}\dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} -uUTL -c backup_start BackPages2 recovery&amp;#xD;&lt;/script>&lt;arguments class=&quot;java.lang.String&quot; />&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="Decision_28" commented="0"

            originalStyle="" points="1110.0,757.0;1136.0,850.0"

            sourceX="654" sourceY="1057" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="796" targetY="1081" transitionIndex="0" x="109" y="642">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1460368807827" description="if/else based decision"

        displayName="Decision" height="100" interactive="0" jobMode="0"

        name="Decision" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_27" waitSetting="0" width="100" x="1148" y="1060">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/ExecuteScript_3/exitCode}==0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="Email_62" commented="0" displayName="NO"

            originalStyle="" points="1260.0,1087.5;1286.0,1090.0"

            sourceX="890" sourceY="1304" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="886" targetY="1411" transitionIndex="0"

            value="false" x="109" y="642">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="Email_59" commented="0" displayName="YES"

            originalStyle="" points="1260.0,1132.5;1286.0,1157.0"

            sourceX="903" sourceY="1302" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="1057" targetY="1327" transitionIndex="0"

            value="true" x="109" y="642">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1460368807842"

        description="logs an event in the commcell console with the specified severity level"

        displayName="LogEvent&#xa;Online incr Backup" height="34"

        interactive="0" jobMode="0" name="LogEvent"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=LogEvent"

        uniqueName="LogEvent_26" waitSetting="0" width="200" x="656" y="739">

        <inputs val="&lt;inputs>&lt;severity class=&quot;workflow.types.SeverityLevel&quot;>INFO&lt;/severity>&lt;message class=&quot;java.lang.String&quot;>Starting online incremental backup of MaxDB database xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME}&lt;/message>&lt;/inputs>"/>

        <transition activity="ExecuteScript_27" commented="0"

            originalStyle="" points="871.0,757.0;897.0,757.0"

            sourceX="434" sourceY="1058" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="609" targetY="1060" transitionIndex="0" x="109" y="642">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1460368807860"

        description="logs an event in the commcell console with the specified severity level"

        displayName="LogEvent&#xa;Online Full Backup" height="34"

        interactive="0" jobMode="0" name="LogEvent"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=LogEvent"

        uniqueName="LogEvent_27" waitSetting="0" width="153" x="679" y="671">

        <inputs val="&lt;inputs>&lt;severity class=&quot;workflow.types.SeverityLevel&quot;>INFO&lt;/severity>&lt;message class=&quot;java.lang.String&quot;>Starting online full backup of xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} on xpath:{/workflow/inputs/CV_MAXDB_CLIENT_NAME}&lt;/message>&lt;/inputs>"/>

        <transition activity="ExecuteScript_26" commented="0"

            originalStyle="" points="871.0,689.0;897.0,689.0"

            sourceX="408" sourceY="877" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="648" targetY="746" transitionIndex="0" x="109" y="642">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1460368807877"

        description="logs an event in the commcell console with the specified severity level"

        displayName="LogEvent&#xa;Transaction Log Backup" height="34"

        interactive="0" jobMode="0" name="LogEvent"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=LogEvent"

        uniqueName="LogEvent_28" waitSetting="0" width="200" x="656" y="887">

        <inputs val="&lt;inputs>&lt;severity class=&quot;workflow.types.SeverityLevel&quot;>INFO&lt;/severity>&lt;message class=&quot;java.lang.String&quot;>Starting transaction log backup of MaxDB database xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME}&lt;/message>&lt;/inputs>"/>

        <transition activity="ExecuteScript_28" commented="0"

            originalStyle="" points="871.0,905.0;897.0,894.0"

            sourceX="435" sourceY="1304" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="597" targetY="1296" transitionIndex="0" x="109" y="642">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="1"

        created="1460368807893"

        description="Execute a script on a remote machine"

        displayName="ExecuteScript&#xa;Transaction Log Backup"

        height="34" interactive="0" jobMode="0" name="ExecuteScript"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ExecuteScript" uniqueName="ExecuteScript_28"

        waitSetting="0" width="187" x="909" y="876">

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/inputs/CV_MAXDB_CLIENT_NAME/clientName}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/CV_SIDADM_USER}&lt;/impersonateUserName>&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot;>xpath:{/workflow/inputs/CV_SIDADM_PASSWORD}&lt;/impersonateUserPassword>&lt;startUpPath class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/CV_SCRIPT_PATH}&lt;/startUpPath>&lt;scriptType class=&quot;commvault.msgs.App.ScriptType&quot;>WindowsBatch&lt;/scriptType>&lt;script class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/CV_DBMCLI_PATH}\dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} db_warm&amp;#xD;xpath:{/workflow/inputs/CV_DBMCLI_PATH}\dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} -uUTL -c backup_start BackLog&amp;#xD;&lt;/script>&lt;arguments class=&quot;java.lang.String&quot; />&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="Decision_27" commented="0"

            originalStyle="" points="1110.0,894.0;1136.0,1110.0"

            sourceX="673" sourceY="1303" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="864" targetY="1299" transitionIndex="0" x="109" y="642">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1460368807921" description="if/else based decision"

        displayName="Decision" height="100" interactive="0" jobMode="0"

        name="Decision" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_28" waitSetting="0" width="100" x="1148" y="800">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/ExecuteScript_2/exitCode}==0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="Email_63" commented="0" displayName="YES"

            originalStyle="" points="1260.0,827.5;1286.0,822.0"

            sourceX="901" sourceY="1082" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="1097" targetY="1083" transitionIndex="0"

            value="true" x="109" y="642">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="Email_60" commented="0" displayName="NO"

            originalStyle="" points="1260.0,872.5;1286.0,889.0"

            sourceX="901" sourceY="1082" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="898" targetY="1194" transitionIndex="0"

            value="false" x="109" y="642">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1460368807940"

        description="logs an event in the commcell console with the specified severity level"

        displayName="LogEvent&#xa;Offline full backup" height="46"

        interactive="0" jobMode="0" name="LogEvent"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=LogEvent"

        uniqueName="LogEvent_29" waitSetting="0" width="202" x="655" y="806">

        <inputs val="&lt;inputs>&lt;severity class=&quot;workflow.types.SeverityLevel&quot;>INFO&lt;/severity>&lt;message class=&quot;java.lang.String&quot;>Starting offline full backup of MaxDB database xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME}&lt;/message>&lt;/inputs>"/>

        <transition activity="ExecuteScript_29" commented="0"

            originalStyle="" points="871.0,831.0;897.0,826.0"

            sourceX="449" sourceY="1517" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="590" targetY="1513" transitionIndex="0" x="109" y="642">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1460368807958" description="if/else based decision"

        displayName="Decision" height="100" interactive="0" jobMode="0"

        name="Decision" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_29" waitSetting="0" width="100" x="1148" y="930">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/ExecuteScript_4/exitCode}==0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="Email_61" commented="0" displayName="NO"

            originalStyle="" points="1260.0,957.5;1286.0,956.0"

            sourceX="929" sourceY="1529" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="928" targetY="1675" transitionIndex="0"

            value="False" x="109" y="642">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="Email_57" commented="0" displayName="YES"

            originalStyle="" points="1260.0,1002.5;1286.0,1023.0"

            sourceX="929" sourceY="1529" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="1051" targetY="1516" transitionIndex="0"

            value="True" x="109" y="642">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="1"

        created="1460368807973"

        description="Execute a script on a remote machine"

        displayName="ExecuteScript&#xa;Offline full Backup" height="34"

        interactive="0" jobMode="0" name="ExecuteScript"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ExecuteScript" uniqueName="ExecuteScript_29"

        waitSetting="0" width="187" x="909" y="808">

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/inputs/CV_MAXDB_CLIENT_NAME/clientName}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/CV_SIDADM_USER}&lt;/impersonateUserName>&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot;>xpath:{/workflow/inputs/CV_SIDADM_PASSWORD}&lt;/impersonateUserPassword>&lt;startUpPath class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/CV_SCRIPT_PATH}&lt;/startUpPath>&lt;scriptType class=&quot;commvault.msgs.App.ScriptType&quot;>WindowsBatch&lt;/scriptType>&lt;script class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/CV_DBMCLI_PATH}\dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} db_cold &amp;#xD;xpath:{/workflow/inputs/CV_DBMCLI_PATH}\dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} -uUTL -c backup_start BackData2 Migration&lt;/script>&lt;arguments class=&quot;java.lang.String&quot; />&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="Decision_29" commented="0"

            originalStyle="" points="1110.0,826.0;1136.0,980.0"

            sourceX="838" sourceY="962" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="1102" targetY="975" transitionIndex="0" x="109" y="642">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1460368807991"

        description="logs an event in the commcell console with the specified severity level"

        displayName="LogEvent&#xa;Offline incr backup" height="46"

        interactive="0" jobMode="0" name="LogEvent"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=LogEvent"

        uniqueName="LogEvent_30" waitSetting="0" width="202" x="655" y="954">

        <inputs val="&lt;inputs>&lt;severity class=&quot;workflow.types.SeverityLevel&quot;>INFO&lt;/severity>&lt;message class=&quot;java.lang.String&quot;>Starting offline incremental backup of MaxDB database xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME}&lt;/message>&lt;/inputs>"/>

        <transition activity="ExecuteScript_30" commented="0"

            originalStyle="" points="871.0,979.0;897.0,1109.0"

            sourceX="461" sourceY="1762" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="698" targetY="1763" transitionIndex="0" x="109" y="642">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="1"

        created="1460368808008"

        description="Execute a script on a remote machine"

        displayName="ExecuteScript&#xa;Offline incr Backup" height="34"

        interactive="0" jobMode="0" name="ExecuteScript"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ExecuteScript" uniqueName="ExecuteScript_30"

        waitSetting="0" width="187" x="909" y="1091">

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/inputs/CV_MAXDB_CLIENT_NAME/clientName}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/CV_SIDADM_USER}&lt;/impersonateUserName>&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot;>xpath:{/workflow/inputs/CV_SIDADM_PASSWORD}&lt;/impersonateUserPassword>&lt;startUpPath class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/CV_SCRIPT_PATH}&lt;/startUpPath>&lt;scriptType class=&quot;commvault.msgs.App.ScriptType&quot;>WindowsBatch&lt;/scriptType>&lt;script class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/CV_DBMCLI_PATH}\dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} db_cold&amp;#xD;xpath:{/workflow/inputs/CV_DBMCLI_PATH}\dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} -uUTL -c backup_start BackPages2 Migration&lt;/script>&lt;arguments class=&quot;java.lang.String&quot; />&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="Decision_30" commented="0"

            originalStyle="" points="1110.0,1109.0;1136.0,1240.0"

            sourceX="698" sourceY="1763" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="931" targetY="1765" transitionIndex="0" x="109" y="642">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1460368808037" description="if/else based decision"

        displayName="Decision" height="100" interactive="0" jobMode="0"

        name="Decision" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_30" waitSetting="0" width="100" x="1148" y="1190">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/ExecuteScript_5/exitCode}==0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="Email_56" commented="0" displayName="YES"

            originalStyle="" points="1260.0,1217.5;1286.0,1224.0"

            sourceX="931" sourceY="1765" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="1181" targetY="1845" transitionIndex="0"

            value="True" x="109" y="642">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="Email_58" commented="0" displayName="NO"

            originalStyle="" points="1260.0,1262.5;1286.0,1291.0"

            sourceX="931" sourceY="1765" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="936" targetY="1867" transitionIndex="0"

            value="False" x="109" y="642">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1460368808066"

        description="Sends an email to a list of users"

        displayName="Email" height="34" interactive="0" jobMode="0"

        name="Email" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Email"

        uniqueName="Email_56" waitSetting="0" width="100" x="1298" y="1205">

        <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot;>&lt;from class=&quot;java.lang.String&quot;>xpath:{/workflow/system/executor/userName}&lt;/from>&lt;to class=&quot;java.lang.String&quot;>xpath:{/workflow/system/executor/userName}&lt;/to>&lt;cc class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/CV_EMAIL_ID}&lt;/cc>&lt;bcc class=&quot;java.lang.String&quot; />&lt;subject class=&quot;java.lang.String&quot;>Offline incremental backup for MaxDB database xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} completed&lt;/subject>&lt;attachments class=&quot;java.lang.Object&quot; />&lt;body class=&quot;java.lang.String&quot;>&amp;lt;div&amp;gt;&#xd;&#xa;      &#xd;&#xa;    &amp;lt;/div&amp;gt;&#xd;&#xa;    &amp;lt;div&amp;gt;&#xd;&#xa;      &amp;lt;font face=&quot;Segoe UI&quot; size=&quot;2&quot;&amp;gt;Summary: &amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/div&amp;gt;&#xd;&#xa;    &amp;lt;div&amp;gt;&#xd;&#xa;      &#xd;&#xa;    &amp;lt;/div&amp;gt;&#xd;&#xa;    &amp;lt;div&amp;gt;&#xd;&#xa;      &amp;lt;font face=&quot;Segoe UI&quot; size=&quot;2&quot;&amp;gt;Offline incremental backup using workflow &#xd;&#xa;      for MaxDB database xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} &#xd;&#xa;      completed &amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#006633&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;successfully&amp;lt;/font&amp;gt;&amp;lt;font size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;. &#xd;&#xa;      &amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/div&amp;gt;&#xd;&#xa;    &amp;lt;div&amp;gt;&#xd;&#xa;      &#xd;&#xa;    &amp;lt;/div&amp;gt;&#xd;&#xa;    &amp;lt;div&amp;gt;&#xd;&#xa;      &amp;lt;font size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Workflow jobId: &#xd;&#xa;      xpath:{/workflow/system/jobId} &amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/div&amp;gt;&#xd;&#xa;    &amp;lt;div&amp;gt;&#xd;&#xa;      &#xd;&#xa;    &amp;lt;/div&amp;gt;&#xd;&#xa;    &amp;lt;div&amp;gt;&#xd;&#xa;      &amp;lt;font size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Details: &#xd;&#xa;      xpath:{/workflow/ExecuteScript_5/commandOutput}&amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/div&amp;gt;&lt;/body>&lt;html class=&quot;java.lang.Boolean&quot;>true&lt;/html>&lt;repeatInterval class=&quot;java.lang.Integer&quot; />&lt;replyTo class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/email>&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1460368808137"

        description="Sends an email to a list of users"

        displayName="Email" height="34" interactive="0" jobMode="0"

        name="Email" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Email"

        uniqueName="Email_57" waitSetting="0" width="100" x="1298" y="1004">

        <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot;>&lt;from class=&quot;java.lang.String&quot;>xpath:{/workflow/system/executor/userName}&lt;/from>&lt;to class=&quot;java.lang.String&quot;>xpath:{/workflow/system/executor/userName}&lt;/to>&lt;cc class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/CV_EMAIL_ID}&lt;/cc>&lt;bcc class=&quot;java.lang.String&quot; />&lt;subject class=&quot;java.lang.String&quot;>Offline full backup for instance xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} completed&lt;/subject>&lt;attachments class=&quot;java.lang.Object&quot; />&lt;body class=&quot;java.lang.String&quot;>&amp;lt;div&amp;gt;&#xd;&#xa;      &#xd;&#xa;    &amp;lt;/div&amp;gt;&#xd;&#xa;    &amp;lt;div&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Summary:&amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/div&amp;gt;&#xd;&#xa;    &amp;lt;div&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;&amp;lt;br&amp;gt;&#xd;&#xa;      Offline full backup using workflow for instance &#xd;&#xa;      xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} completed &amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#006633&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;successfully&amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;. &#xd;&#xa;      &amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/div&amp;gt;&#xd;&#xa;    &amp;lt;div&amp;gt;&#xd;&#xa;      &#xd;&#xa;    &amp;lt;/div&amp;gt;&#xd;&#xa;    &amp;lt;div&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Workflow jobId: &#xd;&#xa;      xpath:{/workflow/system/jobId} &amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/div&amp;gt;&#xd;&#xa;    &amp;lt;div&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;&#xd;&#xa;&amp;lt;/font&amp;gt;    &amp;lt;/div&amp;gt;&#xd;&#xa;    &amp;lt;div&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Details: &amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/div&amp;gt;&#xd;&#xa;    &amp;lt;div&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;&#xd;&#xa;&amp;lt;/font&amp;gt;    &amp;lt;/div&amp;gt;&#xd;&#xa;    &amp;lt;div&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;xpath:{/workflow/ExecuteScript_4/commandOutput}&amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/div&amp;gt;&lt;/body>&lt;html class=&quot;java.lang.Boolean&quot;>true&lt;/html>&lt;replyTo class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;repeatInterval class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;/email>&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1460368808258"

        description="Sends an email to a list of users"

        displayName="Email" height="34" interactive="0" jobMode="0"

        name="Email" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Email"

        uniqueName="Email_58" waitSetting="0" width="100" x="1298" y="1272">

        <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot;>&lt;from class=&quot;java.lang.String&quot;>xpath:{/workflow/system/executor/userName}&lt;/from>&lt;to class=&quot;java.lang.String&quot;>xpath:{/workflow/system/executor/userName}&lt;/to>&lt;cc class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/CV_EMAIL_ID}&lt;/cc>&lt;bcc class=&quot;java.lang.String&quot; />&lt;subject class=&quot;java.lang.String&quot;>Offline incremental backup for MaxDB database xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} failed&lt;/subject>&lt;attachments class=&quot;java.lang.Object&quot; />&lt;body class=&quot;java.lang.String&quot;>&amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Summary: &amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#000000&quot;&amp;gt;&#xd;&#xa;&amp;lt;/font&amp;gt;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Offline incremental &#xd;&#xa;      backup using workflow for MaxDB database &#xd;&#xa;      xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} &amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#990000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;failed&amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;.&amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#000000&quot;&amp;gt;&#xd;&#xa;&amp;lt;/font&amp;gt;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Workflow jobId: &#xd;&#xa;      xpath:{/workflow/system/jobId} &amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#000000&quot;&amp;gt;&#xd;&#xa;&amp;lt;/font&amp;gt;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Details:&amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#000000&quot;&amp;gt;&#xd;&#xa;&amp;lt;/font&amp;gt;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;xpath:{/workflow/ExecuteScript_5/commandOutput}&amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/p&amp;gt;&lt;/body>&lt;html class=&quot;java.lang.Boolean&quot;>true&lt;/html>&lt;replyTo class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;repeatInterval class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;/email>&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1460368808317"

        description="Sends an email to a list of users"

        displayName="Email" height="34" interactive="0" jobMode="0"

        name="Email" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Email"

        uniqueName="Email_59" waitSetting="0" width="100" x="1298" y="1138">

        <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot;>&lt;from class=&quot;java.lang.String&quot;>xpath:{/workflow/system/executor/userName}&lt;/from>&lt;to class=&quot;java.lang.String&quot;>xpath:{/workflow/system/executor/userName}&lt;/to>&lt;cc class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/CV_EMAIL_ID}&lt;/cc>&lt;bcc class=&quot;java.lang.String&quot; />&lt;subject class=&quot;java.lang.String&quot;>Transaction log backup for MaxDB database xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} completed&lt;/subject>&lt;attachments class=&quot;java.lang.Object&quot; />&lt;body class=&quot;java.lang.String&quot;>&amp;lt;font size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;&#xd;&#xa;&amp;lt;/font&amp;gt;  &#xd;&#xa;  &#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;&#xd;&#xa;&amp;lt;/font&amp;gt;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Summary:&#xd;&#xa;&amp;lt;/font&amp;gt;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Transaction log backup using workflow for &#xd;&#xa;      MaxDB database xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} completed &amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#006633&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;successfully&amp;lt;/font&amp;gt;&amp;lt;font size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;.&#xd;&#xa;&amp;lt;/font&amp;gt;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Workflow jobId: &#xd;&#xa;      xpath:{/workflow/system/jobId}&#xd;&#xa;&amp;lt;/font&amp;gt;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Details:&#xd;&#xa;&amp;lt;/font&amp;gt;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;xpath:{/workflow/ExecuteScript_3/commandOutput}&amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/p&amp;gt;&lt;/body>&lt;html class=&quot;java.lang.Boolean&quot;>true&lt;/html>&lt;replyTo class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;repeatInterval class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;/email>&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1460368808398"

        description="Sends an email to a list of users"

        displayName="Email" height="34" interactive="0" jobMode="0"

        name="Email" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Email"

        uniqueName="Email_60" waitSetting="0" width="100" x="1298" y="870">

        <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot;>&lt;from class=&quot;java.lang.String&quot;>xpath:{/workflow/system/executor/userName}&lt;/from>&lt;to class=&quot;java.lang.String&quot;>xpath:{/workflow/system/executor/userName}&lt;/to>&lt;cc class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/CV_EMAIL_ID}&lt;/cc>&lt;bcc class=&quot;java.lang.String&quot; />&lt;subject class=&quot;java.lang.String&quot;>Online incremental backup for instance xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} failed&lt;/subject>&lt;attachments class=&quot;java.lang.Object&quot; />&lt;body class=&quot;java.lang.String&quot;>&amp;lt;p&amp;gt;&#xd;&#xa;      &#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font face=&quot;Segoe UI&quot; size=&quot;2&quot;&amp;gt;Summary: &amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font face=&quot;Segoe UI&quot; size=&quot;2&quot;&amp;gt;Online incremental backup using workflow &#xd;&#xa;      for MaxDB database xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} &amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#990000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;failed&amp;lt;/font&amp;gt;&amp;lt;font size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt; &#xd;&#xa;      &amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Workflow jobId: &#xd;&#xa;      xpath:{/workflow/system/jobId} &amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Details: &amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;xpath:{/workflow/ExecuteScript_2/commandOutput}&amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/p&amp;gt;&lt;/body>&lt;html class=&quot;java.lang.Boolean&quot;>true&lt;/html>&lt;replyTo class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;repeatInterval class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;/email>&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1460368808471"

        description="Sends an email to a list of users"

        displayName="Email" height="34" interactive="0" jobMode="0"

        name="Email" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Email"

        uniqueName="Email_61" waitSetting="0" width="100" x="1298" y="937">

        <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot;>&lt;from class=&quot;java.lang.String&quot;>xpath:{/workflow/system/executor/userName}&lt;/from>&lt;to class=&quot;java.lang.String&quot;>xpath:{/workflow/system/executor/userName}&lt;/to>&lt;cc class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/CV_EMAIL_ID}&lt;/cc>&lt;bcc class=&quot;java.lang.String&quot; />&lt;subject class=&quot;java.lang.String&quot;>Offline full backup for instance xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} failed&lt;/subject>&lt;attachments class=&quot;java.lang.Object&quot; />&lt;body class=&quot;java.lang.String&quot;>&amp;lt;font color=&quot;#000000&quot;&amp;gt;&#xd;&#xa;&amp;lt;/font&amp;gt;  &#xd;&#xa;  &#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Summary: &amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#000000&quot;&amp;gt;&#xd;&#xa;&amp;lt;/font&amp;gt;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Offline full backup using &#xd;&#xa;      workflow for instance xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} &amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#990000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;failed&amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt; &#xd;&#xa;      &amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#000000&quot;&amp;gt;&#xd;&#xa;&amp;lt;/font&amp;gt;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Workflow jobId: &#xd;&#xa;      xpath:{/workflow/system/jobId} &amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#000000&quot;&amp;gt;&#xd;&#xa;&amp;lt;/font&amp;gt;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Details: &amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#000000&quot;&amp;gt;&#xd;&#xa;&amp;lt;/font&amp;gt;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;xpath:{/workflow/ExecuteScript_4/commandOutput}&amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/p&amp;gt;&lt;/body>&lt;html class=&quot;java.lang.Boolean&quot;>true&lt;/html>&lt;replyTo class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;repeatInterval class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;/email>&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1460368808558"

        description="Sends an email to a list of users"

        displayName="Email" height="34" interactive="0" jobMode="0"

        name="Email" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Email"

        uniqueName="Email_62" waitSetting="0" width="100" x="1298" y="1071">

        <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot;>&lt;from class=&quot;java.lang.String&quot;>xpath:{/workflow/system/executor/userName}&lt;/from>&lt;to class=&quot;java.lang.String&quot;>xpath:{/workflow/system/executor/userName}&lt;/to>&lt;cc class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/CV_EMAIL_ID}&lt;/cc>&lt;bcc class=&quot;java.lang.String&quot; />&lt;subject class=&quot;java.lang.String&quot;>Transaction log backup for MaxDB database xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} failed&lt;/subject>&lt;attachments class=&quot;java.lang.Object&quot; />&lt;body class=&quot;java.lang.String&quot;>&amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Summary: &amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#000000&quot;&amp;gt;&#xd;&#xa;&amp;lt;/font&amp;gt;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Transaction log backup &#xd;&#xa;      using workflow for MaxDB database &#xd;&#xa;      xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME}&amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#000066&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt; &#xd;&#xa;      &amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#990000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;failed&amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Workflow jobId: &#xd;&#xa;      xpath:{/workflow/system/jobId} &amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#000000&quot;&amp;gt;&#xd;&#xa;&amp;lt;/font&amp;gt;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Details: &amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#000000&quot;&amp;gt;&#xd;&#xa;&amp;lt;/font&amp;gt;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;xpath:{/workflow/ExecuteScript_3/commandOutput}&amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/p&amp;gt;&lt;/body>&lt;html class=&quot;java.lang.Boolean&quot;>true&lt;/html>&lt;replyTo class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;repeatInterval class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;/email>&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1460368808664"

        description="Sends an email to a list of users"

        displayName="Email" height="34" interactive="0" jobMode="0"

        name="Email" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Email"

        uniqueName="Email_63" waitSetting="0" width="100" x="1298" y="803">

        <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot;>&lt;from class=&quot;java.lang.String&quot;>xpath:{/workflow/system/executor/userName}&lt;/from>&lt;to class=&quot;java.lang.String&quot;>xpath:{/workflow/system/executor/userName}&lt;/to>&lt;cc class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/CV_EMAIL_ID}&lt;/cc>&lt;bcc class=&quot;java.lang.String&quot; />&lt;subject class=&quot;java.lang.String&quot;>Online incremental backup for instance xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} completed&lt;/subject>&lt;attachments class=&quot;java.lang.Object&quot; />&lt;body class=&quot;java.lang.String&quot;>&amp;lt;p&amp;gt;&#xd;&#xa;      &#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font face=&quot;Segoe UI&quot; size=&quot;2&quot;&amp;gt;Summary: &amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font face=&quot;Segoe UI&quot; size=&quot;2&quot;&amp;gt;Online incremental backup using workflow &#xd;&#xa;      for MaxDB database xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} &#xd;&#xa;      completed &amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#006633&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;successfully&amp;lt;/font&amp;gt;&amp;lt;font size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;. &#xd;&#xa;      &amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Workflow jobId: &#xd;&#xa;      xpath:{/workflow/system/jobId} &amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Details: &amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;xpath:{/workflow/ExecuteScript_2/commandOutput}&amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/p&amp;gt;&lt;/body>&lt;html class=&quot;java.lang.Boolean&quot;>true&lt;/html>&lt;replyTo class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;repeatInterval class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;/email>&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1460368808727"

        description="Sends an email to a list of users"

        displayName="Email" height="34" interactive="0" jobMode="0"

        name="Email" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Email"

        uniqueName="Email_64" waitSetting="0" width="100" x="1298" y="669">

        <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot;>&lt;from class=&quot;java.lang.String&quot;>xpath:{/workflow/system/executor/userName}&lt;/from>&lt;to class=&quot;java.lang.String&quot;>xpath:{/workflow/system/executor/userName}&lt;/to>&lt;cc class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/CV_EMAIL_ID}&lt;/cc>&lt;bcc class=&quot;java.lang.String&quot; />&lt;subject class=&quot;java.lang.String&quot;>Online full backup for MaxDB database xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} completed&lt;/subject>&lt;attachments class=&quot;java.lang.Object&quot; />&lt;body class=&quot;java.lang.String&quot;>&amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Summary: &amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#000000&quot;&amp;gt;&#xd;&#xa;&amp;lt;/font&amp;gt;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Online full backup using &#xd;&#xa;      workflow for MaxDB database &#xd;&#xa;      xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} completed &amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#006633&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;successfully&amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;. &#xd;&#xa;      &amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#000000&quot;&amp;gt;&#xd;&#xa;&amp;lt;/font&amp;gt;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Workflow jobId: &#xd;&#xa;      xpath:{/workflow/system/jobId} &amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#000000&quot;&amp;gt;&#xd;&#xa;&amp;lt;/font&amp;gt;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;Details: &amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#000000&quot;&amp;gt;&#xd;&#xa;&amp;lt;/font&amp;gt;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#000000&quot; size=&quot;2&quot; face=&quot;Segoe UI&quot;&amp;gt;xpath:{/workflow/ExecuteScript_1/commandOutput}&amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/p&amp;gt;&lt;/body>&lt;html class=&quot;java.lang.Boolean&quot;>true&lt;/html>&lt;replyTo class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;repeatInterval class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;/email>&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1460368808788"

        description="Sends an email to a list of users"

        displayName="Email" height="34" interactive="0" jobMode="0"

        name="Email" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Email"

        uniqueName="Email_65" waitSetting="0" width="100" x="1298" y="736">

        <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot;>&lt;from class=&quot;java.lang.String&quot;>xpath:{/workflow/system/executor/userName}&lt;/from>&lt;to class=&quot;java.lang.String&quot;>xpath:{/workflow/system/executor/userName}&lt;/to>&lt;cc class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/CV_EMAIL_ID}&lt;/cc>&lt;bcc class=&quot;java.lang.String&quot; />&lt;subject class=&quot;java.lang.String&quot;>Online full backup for MaxDB database xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} failed&lt;/subject>&lt;attachments class=&quot;java.lang.Object&quot; />&lt;body class=&quot;java.lang.String&quot;>&amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font face=&quot;Segoe UI&quot; color=&quot;#000000&quot; size=&quot;2&quot;&amp;gt;Summary: &amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font face=&quot;Segoe UI&quot; color=&quot;#000000&quot; size=&quot;2&quot;&amp;gt;Online full backup for &#xd;&#xa;      MaxDB database xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} &amp;lt;/font&amp;gt;&amp;lt;font face=&quot;Segoe UI&quot; color=&quot;#990000&quot; size=&quot;2&quot;&amp;gt;failed&amp;lt;/font&amp;gt;&amp;lt;font face=&quot;Segoe UI&quot; color=&quot;#000000&quot; size=&quot;2&quot;&amp;gt;. &#xd;&#xa;      &amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font face=&quot;Segoe UI&quot; color=&quot;#000000&quot; size=&quot;2&quot;&amp;gt;Workflow jobId: &#xd;&#xa;      xpath:{/workflow/system/jobId} &amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font face=&quot;Segoe UI&quot; color=&quot;#000000&quot; size=&quot;2&quot;&amp;gt;Details: &amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font face=&quot;Segoe UI&quot; color=&quot;#000000&quot; size=&quot;2&quot;&amp;gt;xpath:{/workflow/ExecuteScript_1/commandOutput}&amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/p&amp;gt;&lt;/body>&lt;html class=&quot;java.lang.Boolean&quot;>true&lt;/html>&lt;replyTo class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;repeatInterval class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;/email>&lt;/inputs>"/>

    </Activity>

    <formProperties css="" javaScript=""/>

</workflow>'

IF not exists (select * from WF_Definition where Name = @name)

BEGIN
	INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision)


	VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision)

	SET @workflowId = @@IDENTITY
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


	VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

	SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = ISNULL(revision, '') From WF_Definition WHERE Name = @name

	IF (@currentFlags & 4 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0) AND (@currentRevision <> @revision)

	BEGIN

		SET @version = @version + 1

		UPDATE WF_Definition

		SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision

		WHERE Name = @name

		IF (@flags & 8 > 0 OR @flags & 16 > 0)

		BEGIN

			UPDATE WF_Definition

			SET flags = @flags

			WHERE Name = @name

		END
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


		VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

	END

END


