

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_LoadBalanceIndexServers.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 2019  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/WFD_LoadBalanceIndexServers.script,v $";
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER ON

DECLARE @nowTime INT

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255) = 'System Load Balance Index Servers'

DECLARE @description nvarchar(MAX) = 'Run load balance algorithm for overloaded Index Servers and do index databases migrations to optimize servers usage'

DECLARE @workflowId INT

DECLARE @version INT = 1

DECLARE @flags INT = 30

DECLARE @currentFlags INT

DECLARE @uniqueGuid NVARCHAR(36) = '69c1365d-dbce-4037-a31a-5cce827223c1'

DECLARE @revision nvarchar(255) = '$Revision: 1.1.2.5 $'

DECLARE @currentRevision nvarchar(255)

DECLARE @definition nvarchar(MAX) ='<workflow apiMode="0"

    config="&lt;configuration>&lt;runAsJob class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/runAsJob>&lt;migratePending class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/migratePending>&lt;deletePending class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/deletePending>&lt;nMaxTries class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>10&lt;/nMaxTries>&lt;/configuration>"

    description="Run load balance algorithm for overloaded Index Servers and do index databases migrations to optimize servers usage"

    executeOnWeb="0"

    inputs="&lt;inputs>&lt;storagePolicy class=&quot;commvault.msgs.CvEntities.StoragePolicyEntity&quot; _list_=&quot;false&quot;>&lt;storagePolicyName />&lt;storagePolicyId />&lt;/storagePolicy>&lt;/inputs>"

    interactive="0" isHtmlDescription="0" manualPercentageComplete="0"

    name="Load Balance Index Servers" outputs="&lt;outputs />"

    revision="$Revision: 1.1.2.5 $" tags=""

    uniqueGuid="d5afd52e-78f8-4af3-8638-16971b0c77ea"

    variables="&lt;variables>&lt;curIndexId class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;curFromClientID class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;curToClientID class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;curBsGuid class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;curToClientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;curFromClientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;curToIdxCache class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;curAppName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;curVmName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;curAppPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;curDbGuid class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;nCount class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>0&lt;/nCount>&lt;/variables>"

    webHidden="0" workflowId="0">

    <schema>

        <outputs className="" name="outputs" type=""/>

        <variables attribute="0" className="" name="variables" type="">

            <children attribute="0" className="java.lang.Integer"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.Integer" listType="0"

                name="curIndexId" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.Integer"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.Integer" listType="0"

                name="curFromClientID" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.Integer"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.Integer" listType="0"

                name="curToClientID" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="curBsGuid" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="curToClientName" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="curFromClientName" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="curToIdxCache" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="curAppName" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="curVmName" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="curAppPath" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="curDbGuid" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.Integer"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0"

                inputType="java.lang.Integer" listType="0" name="nCount"

                readOnly="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

        </variables>

        <inputs attribute="0" className="" name="inputs" type="">

            <children attribute="0"

                className="commvault.msgs.CvEntities.StoragePolicyEntity"

                controlHidden="0" controlType="2" defaultValue=""

                displayName="Storage Policy"

                documentation="Select storage policy to run the index server load balance. If you want to run the load balance globally (over all index servers) don''t select a storage policy."

                hidden="0"

                inputType="commvault.msgs.CvEntities.StoragePolicyEntity"

                listType="0" maximumValue="" minimumValue=""

                name="storagePolicy" readOnly="0" required="0"

                searchable="0" type="{commvault.msgs.CvEntities}StoragePolicyEntity">

                <children attribute="0" className="java.lang.String"

                    defaultValue="" inputType="java.lang.String"

                    listType="0" name="storagePolicyName" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children attribute="0" className="java.lang.Integer"

                    defaultValue="" inputType="java.lang.Integer"

                    listType="0" name="storagePolicyId" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            </children>

        </inputs>

        <config attribute="0" className="" name="configuration" type="">

            <children attribute="0" className="java.lang.Boolean"

                controlHidden="0" controlType="5" defaultValue=""

                displayName="" documentation="" hidden="0"

                inputType="java.lang.Boolean" listType="0"

                maximumValue="" minimumValue="" name="runAsJob"

                readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

            <children attribute="0" className="java.lang.Boolean"

                controlType="5" defaultValue="" displayName=""

                documentation="" hidden="0"

                inputType="java.lang.Boolean" listType="0"

                name="migratePending" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

            <children attribute="0" className="java.lang.Boolean"

                controlType="5" defaultValue="" displayName=""

                documentation="" hidden="0"

                inputType="java.lang.Boolean" listType="0"

                name="deletePending" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

            <children attribute="0" className="java.lang.Integer"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0"

                inputType="java.lang.Integer" listType="0"

                name="nMaxTries" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

        </config>

    </schema>

    <Start commented="0" continueOnFailure="0" created="0"

        description="" displayName="Start" height="36" interactive="0"

        jobMode="0" name="Start" originalStyle="" skipAttempt="0"

        style="image;image=/images/jgraphx/house.png"

        uniqueName="Start_1" waitSetting="0" width="58" x="64" y="30">

        <inputs val="&lt;inputs />"/>

        <transition activity="AcquireLock_1" commented="0"

            originalStyle="" points="" sourceX="93" sourceY="48"

            status="0" style="defaultEdge" targetX="97" targetY="169"

            transitionIndex="0" x="-20" y="-397">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Start>

    <Activity commented="0" continueOnFailure="0"

        created="1519069763610" description="Ends the workflow"

        displayName="WorkflowEnd" height="34" interactive="0"

        jobMode="0" name="WorkflowEnd"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.EndActivity"

        uniqueName="WorkflowEnd_2" waitSetting="0" width="106" x="929" y="391">

        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot; />&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1521208032383"

        description="executes queries against a commcell database"

        displayName="Run Load Balance" height="34" interactive="0"

        jobMode="0" name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.CommServDBQuery"

        uniqueName="CommServDBQuery_18" waitSetting="0" width="143"

        x="322" y="274">

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>DECLARE @inXml XML = (SELECT xpath:{/workflow/inputs/storagePolicy/storagePolicyId} AS ''@archGrpId'' FOR XML PATH(''App_GetReportDetailsResp''), TYPE);&amp;#xD;&#xd;&#xa;EXEC AppLoadBalanceIdxServer @inXml;&lt;/query>&lt;/inputs>"/>

        <transition activity="CommServDBQuery_19" commented="0"

            originalStyle="" points="684.0,450.6666666666667"

            sourceX="393" sourceY="291" status="0" style="defaultEdge"

            targetX="711" targetY="557" transitionIndex="0" x="-20" y="-397">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <onEnter language="1" script="xpath:{/workflow/inputs/storagePolicy/storagePolicyId}"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1521208558740"

        description="executes queries against a commcell database"

        displayName="Get clients with pending migrations" height="34"

        interactive="0" jobMode="0" name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.CommServDBQuery;whiteSpace=wrap"

        uniqueName="CommServDBQuery_19" waitSetting="0" width="200"

        x="589" y="529">

        <onExit language="1" script="workflow.setVariable(&quot;nCount&quot;, workflow.getVariable(&quot;nCount&quot;) + 1);"/>

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>SELECT SM.fromClientId FROM IdxServerMigrations SM &amp;#xD;&#xd;&#xa;INNER JOIN App_IndexDBInfo DB ON SM.indexId = DB.id&amp;#xD;&#xd;&#xa;WHERE isMigrated = 0&lt;/query>&lt;/inputs>"/>

        <transition activity="Decision_20" commented="0"

            originalStyle="" points="" sourceX="689" sourceY="550"

            status="0" style="defaultEdge" targetX="911" targetY="549"

            transitionIndex="0" x="-20" y="-397">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1521240846399" description="if/else based decision"

        displayName="Will migrate ?" height="100" interactive="0"

        jobMode="0" name="Decision"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="rhombus;fontStyle=1;verticalAlign=middle"

        uniqueName="Decision_6" waitSetting="0" width="108" x="339" y="629">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/configuration/migratePending}&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVASCRIPT&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="Decision_13" commented="0"

            displayName="No" originalStyle="" points="" sourceX="384"

            sourceY="679" status="0" style="defaultEdge" targetX="384"

            targetY="569" transitionIndex="0" value="Yes" x="-20" y="-397">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="CommServDBQuery_19" commented="0"

            displayName="Yes" originalStyle=""

            points="527.0,602.6666666666667" sourceX="393" sourceY="679"

            status="0" style="defaultEdge" targetX="704" targetY="551"

            transitionIndex="0" value="True" x="-20" y="-397">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1521380000962"

        description="iterates a group of activities over a list of values"

        displayName="For each overloaded client" height="854"

        interactive="0" jobMode="0" name="ForEach"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ForEach_7" waitSetting="0" width="990" x="1183" y="215">

        <inputs val="&lt;inputs>&lt;name class=&quot;java.lang.String&quot;>col&lt;/name>&lt;values class=&quot;java.lang.Object&quot; _list_=&quot;false&quot;>xpath:{/workflow/CommServDBQuery_19/resultSets/row/col}&lt;/values>&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>1&lt;/numberOfParallelExecutions>&lt;continueOnFailure class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/continueOnFailure>&lt;/inputs>"/>

        <superProcess>

            <Start commented="0" continueOnFailure="0"

                created="1521380000962" description=""

                displayName="Start" height="30" interactive="0"

                jobMode="0" name="Start" originalStyle=""

                skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_10" waitSetting="0" width="120"

                x="424" y="49">

                <inputs val="&lt;inputs />"/>

                <transition activity="CommServDBQuery_27" commented="0"

                    originalStyle="" points="" sourceX="484"

                    sourceY="64" status="0" style="defaultEdge"

                    targetX="483" targetY="125" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity commented="0" continueOnFailure="0"

                created="1521380150003"

                description="executes queries against a commcell database"

                displayName="Get target clients for migration"

                height="34" interactive="0" jobMode="0"

                name="CommServDBQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.CommServDBQuery"

                uniqueName="CommServDBQuery_27" waitSetting="0"

                width="200" x="383" y="116">

                <inputs val="&lt;inputs>&lt;commCell />&lt;query>SELECT DISTINCT toClientId FROM IdxServerMigrations WHERE fromClientId = xpath:{/workflow/ForEach_7/col} AND isMigrated = 0&lt;/query>&lt;/inputs>"/>

                <transition activity="ForEach_10" commented="0"

                    originalStyle="" points="" sourceX="348"

                    sourceY="255" status="0" style="defaultEdge"

                    targetX="371" targetY="340" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1521384158329"

                description="iterates a group of activities over a list of values"

                displayName="For each target client" height="607"

                interactive="0" jobMode="0" name="ForEach"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0" style="swimlane"

                uniqueName="ForEach_10" waitSetting="0" width="932"

                x="33" y="212">

                <inputs val="&lt;inputs>&lt;name class=&quot;java.lang.String&quot;>col&lt;/name>&lt;values class=&quot;java.lang.Object&quot; _list_=&quot;false&quot;>xpath:{/workflow/CommServDBQuery_27/resultSets/row/col}&lt;/values>&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>1&lt;/numberOfParallelExecutions>&lt;continueOnFailure class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/continueOnFailure>&lt;/inputs>"/>

                <superProcess>

                    <Start commented="0" continueOnFailure="0"

                        created="1521384158329" description=""

                        displayName="Start" height="30" interactive="0"

                        jobMode="0" name="Start" originalStyle=""

                        skipAttempt="0"

                        style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                        uniqueName="Start_15" waitSetting="0"

                        width="120" x="392" y="40">

                        <inputs val="&lt;inputs />"/>

                        <transition activity="CommServDBQuery_28"

                            commented="0" originalStyle="" points=""

                            sourceX="360" sourceY="179" status="0"

                            style="defaultEdge" targetX="368"

                            targetY="250" transitionIndex="0" x="0" y="0">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Start>

                    <Activity commented="0" continueOnFailure="0"

                        created="1519069402844"

                        description="iterates a group of activities over a list of values"

                        displayName="For each pending migration"

                        height="382" interactive="0" jobMode="0"

                        name="ForEach"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="swimlane" uniqueName="ForEach_3"

                        waitSetting="0" width="897" x="20" y="192">

                        <inputs val="&lt;inputs>&lt;name class=&quot;java.lang.String&quot;>col&lt;/name>&lt;values class=&quot;java.lang.Object&quot; _list_=&quot;false&quot;>xpath:{/workflow/CommServDBQuery_28/resultSets/row/col}&lt;/values>&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>1&lt;/numberOfParallelExecutions>&lt;continueOnFailure class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/continueOnFailure>&lt;/inputs>"/>

                        <superProcess>

                            <Start commented="0" continueOnFailure="0"

                                created="1519069402844" description=""

                                displayName="Start" height="30"

                                interactive="0" jobMode="0" name="Start"

                                originalStyle="" skipAttempt="0"

                                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                                uniqueName="Start_4" waitSetting="0"

                                width="120" x="68" y="30">

                                <inputs val="&lt;inputs />"/>

                                <transition activity="ProcessBlock_1"

                                    commented="0" originalStyle=""

                                    points="" sourceX="128" sourceY="45"

                                    status="0" style="defaultEdge"

                                    targetX="133" targetY="102"

                                    transitionIndex="0" x="0" y="0">

                                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                                </transition>

                            </Start>

                            <Activity commented="0"

                                continueOnFailure="1"

                                created="1578661738250"

                                description="creates a super process group"

                                displayName="TRY" height="254"

                                interactive="0" jobMode="0"

                                name="ProcessBlock"

                                namespaceUri="commvault.cte.workflow.activities"

                                originalStyle="" skipAttempt="0"

                                style="swimlane"

                                uniqueName="ProcessBlock_1"

                                waitSetting="0" width="641" x="12" y="93">

                                <inputs val="&lt;inputs>&lt;inputs />&lt;/inputs>"/>

                                <superProcess>

                                    <Start commented="0"

                                    continueOnFailure="0"

                                    created="1578661738250"

                                    description=""

                                    displayName="Start" height="30"

                                    interactive="0" jobMode="0"

                                    name="Start" originalStyle=""

                                    skipAttempt="0"

                                    style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                                    uniqueName="Start_17"

                                    waitSetting="0" width="120"

                                    x="33" y="43">

                                    <inputs val="&lt;inputs />"/>

                                    <transition

                                    activity="getmigrationdetails"

                                    commented="0"

                                    originalStyle="" points=""

                                    sourceX="93" sourceY="58"

                                    status="0"

                                    style="defaultEdge"

                                    targetX="273" targetY="61"

                                    transitionIndex="0" x="0" y="0">

                                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                                    </transition>

                                    </Start>

                                    <Activity commented="0"

                                    continueOnFailure="0"

                                    created="1521209413967"

                                    description="executes queries against a commcell database"

                                    displayName="Get migration details"

                                    height="34" interactive="0"

                                    jobMode="0"

                                    name="CommServDBQuery"

                                    namespaceUri="commvault.cte.workflow.activities"

                                    originalStyle="" skipAttempt="0"

                                    style="label;image=commvault.cte.workflow.activities.CommServDBQuery"

                                    uniqueName="getmigrationdetails"

                                    waitSetting="0" width="147"

                                    x="240" y="41">

                                    <onExit language="1" script="workflow.setVariable(&quot;curIndexId&quot;, xpath:{/workflow/getmigrationdetails/resultSets/row/col[1]});&#xd;&#xa;workflow.setVariable(&quot;curBsGuid&quot;, xpath:{/workflow/getmigrationdetails/resultSets/row/col[2]});&#xd;&#xa;workflow.setVariable(&quot;curDbGuid&quot;, xpath:{/workflow/getmigrationdetails/resultSets/row/col[3]});&#xd;&#xa;workflow.setVariable(&quot;curFromClientID&quot;, xpath:{/workflow/getmigrationdetails/resultSets/row/col[4]});&#xd;&#xa;workflow.setVariable(&quot;curFromClientName&quot;, xpath:{/workflow/getmigrationdetails/resultSets/row/col[5]});&#xd;&#xa;workflow.setVariable(&quot;curToClientID&quot;, xpath:{/workflow/getmigrationdetails/resultSets/row/col[6]});&#xd;&#xa;workflow.setVariable(&quot;curToClientName&quot;, xpath:{/workflow/getmigrationdetails/resultSets/row/col[7]});&#xd;&#xa;workflow.setVariable(&quot;curToIdxCache&quot;, xpath:{/workflow/getmigrationdetails/resultSets/row/col[8]});&#xd;&#xa;workflow.setVariable(&quot;curVmName&quot;, xpath:{/workflow/getmigrationdetails/resultSets/row/col[9]});&#xd;&#xa;workflow.setVariable(&quot;curAppName&quot;, xpath:{/workflow/getmigrationdetails/resultSets/row/col[10]});&#xd;&#xa;workflow.setVariable(&quot;curAppPath&quot;, xpath:{/workflow/getmigrationdetails/resultSets/row/col[11]});"/>

                                    <inputs val="&lt;inputs>&lt;commCell />&lt;query>DECLARE @bsGuid NVARCHAR(36) = (SELECT ID.backupSetGUID FROM App_IndexDBInfo ID WITH (NOLOCK), IdxServerMigrations ISM WITH (NOLOCK) WHERE ID.id = ISM.indexId AND ISM.id = xpath:{/workflow/ForEach_3/col})&amp;#xD;&#xd;&#xa;DECLARE @dbGuid NVARCHAR(36) = (SELECT ID.dbName FROM App_IndexDBInfo ID WITH (NOLOCK), IdxServerMigrations ISM WITH (NOLOCK) WHERE ID.id = ISM.indexId AND ISM.id = xpath:{/workflow/ForEach_3/col})&amp;#xD;&#xd;&#xa;DECLARE @fromClientName NVARCHAR(max) = (SELECT C.name FROM APP_Client C WITH (NOLOCK), IdxServerMigrations ISM WITH (NOLOCK) WHERE C.id = ISM.fromClientId AND ISM.id = xpath:{/workflow/ForEach_3/col})&amp;#xD;&#xd;&#xa;DECLARE @toClientName NVARCHAR(max) = (SELECT C.name FROM APP_Client C WITH (NOLOCK), IdxServerMigrations ISM WITH (NOLOCK) WHERE C.id = ISM.toClientId AND ISM.id = xpath:{/workflow/ForEach_3/col})&amp;#xD;&#xd;&#xa;DECLARE @vmName NVARCHAR(max) = (SELECT attrval FROM APP_ClientProp  AP WITH (NOLOCK), IdxServerMigrations ISM WITH (NOLOCK) WHERE AP.componentNameId = ISM.toClientId AND attrName =''Galaxy Instance name'' AND ISM.id = xpath:{/workflow/ForEach_3/col})&amp;#xD;&#xd;&#xa;DECLARE @appName NVARCHAR(max) = (&amp;#xD;&#xd;&#xa;    SELECT IIF(OS.Type =''Windows'', ''CatalogMigration'',CONCAT(AP.attrval,''/MediaAgent/CatalogMigration''))&amp;#xD;&#xd;&#xa;    FROM APP_Client AC WITH (NOLOCK) &amp;#xD;&#xd;&#xa;    INNER JOIN APP_ClientProp AP WITH (NOLOCK) ON AC.id = AP.componentNameId&amp;#xD;&#xd;&#xa;    INNER JOIN simInstalledPackages SIP WITH (NOLOCK) ON SIP.ClientId = AC.id&amp;#xD;&#xd;&#xa;    INNER JOIN simOperatingSystem OS WITH(NOLOCK) ON OS.id = AC.simOperatingSystemId&amp;#xD;&#xd;&#xa;    INNER JOIN IdxServerMigrations ISM WITH(NOLOCK) ON ISM.toClientId = AC.id&amp;#xD;&#xd;&#xa;    WHERE AP.attrName =''Patch Local Location'' AND SIP.simPackageID in (51, 1301)&amp;#xD;&#xd;&#xa;    AND ISM.id = xpath:{/workflow/ForEach_3/col}&amp;#xD;&#xd;&#xa;)&amp;#xD;&#xd;&#xa;DECLARE @appPath NVARCHAR(max) = (&amp;#xD;&#xd;&#xa;    SELECT AP.attrVal&amp;#xD;&#xd;&#xa;    FROM APP_Client AC WITH (NOLOCK) &amp;#xD;&#xd;&#xa;        INNER JOIN APP_ClientProp AP WITH (NOLOCK) ON AC.id = AP.componentNameId    &amp;#xD;&#xd;&#xa;        INNER JOIN IdxServerMigrations ISM WITH(NOLOCK) ON ISM.toClientId = AC.id&amp;#xD;&#xd;&#xa;    WHERE AP.attrName =''Patch Local Location''&amp;#xD;&#xd;&#xa;    AND ISM.id = xpath:{/workflow/ForEach_3/col}&amp;#xD;&#xd;&#xa;)&amp;#xD;&#xd;&#xa;SELECT indexId, @bsGuid as ''bsGuid'', @dbGuid as ''dbGuid'', fromClientId, @fromClientName as ''fromClientName'', toClientId, @toClientName as ''toClientName'', CP.attrVal AS toCacheDir, @vmName AS ''vmName'', @appName AS ''appName'', @appPath AS ''appPath''&amp;#xD;&#xd;&#xa;FROM IdxServerMigrations ISM, APP_ClientProp CP&amp;#xD;&#xd;&#xa;WHERE&#x9;ISM.id = xpath:{/workflow/ForEach_3/col} AND &amp;#xD;&#xd;&#xa;&#x9;&#x9;CP.attrName = ''Idx: cache path'' AND &amp;#xD;&#xd;&#xa;&#x9;&#x9;CP.componentNameId = ISM.toClientId&lt;/query>&lt;/inputs>"/>

                                    <transition

                                    activity="CommServDBQuery_31"

                                    commented="0"

                                    originalStyle="" points=""

                                    sourceX="289" sourceY="123"

                                    status="0"

                                    style="defaultEdge"

                                    targetX="297" targetY="172"

                                    transitionIndex="0" x="-72" y="65">

                                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                                    </transition>

                                    </Activity>

                                    <Activity commented="0"

                                    continueOnFailure="0"

                                    created="1521487777968"

                                    description="executes queries against a commcell database"

                                    displayName="Update migration"

                                    height="34" interactive="0"

                                    jobMode="0"

                                    name="CommServDBQuery"

                                    namespaceUri="commvault.cte.workflow.activities"

                                    originalStyle="" skipAttempt="0"

                                    style="label;image=commvault.cte.workflow.activities.CommServDBQuery"

                                    uniqueName="CommServDBQuery_31"

                                    waitSetting="0" width="143"

                                    x="461" y="41">

                                    <inputs val="&lt;inputs>&lt;commCell />&lt;query>DECLARE @curtime INT = DBO.GetUnixTime(getdate())&amp;#xD;&#xd;&#xa;UPDATE IdxServerMigrations&amp;#xD;&#xd;&#xa;SET jobId = xpath:{/workflow/system/jobId}, startTime = @curTime&amp;#xD;&#xd;&#xa;WHERE id = xpath:{/workflow/ForEach_3/col}&lt;/query>&lt;/inputs>"/>

                                    <transition

                                    activity="CheckReady_1"

                                    commented="0"

                                    originalStyle="" points=""

                                    sourceX="290" sourceY="185"

                                    status="0"

                                    style="defaultEdge"

                                    targetX="295" targetY="306"

                                    transitionIndex="0" x="0" y="0">

                                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                                    </transition>

                                    </Activity>

                                    <Activity commented="0"

                                    continueOnFailure="0"

                                    created="1578603126876"

                                    description=""

                                    displayName="CheckReady"

                                    height="34" interactive="0"

                                    jobMode="0" name="CheckReady"

                                    namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                                    originalStyle="" skipAttempt="0"

                                    style="label;image=commvault.cte.workflow.activities.cmd.operation.OperationCheckReady"

                                    timeout="1"

                                    uniqueName="CheckReady_1"

                                    waitSetting="0" width="101"

                                    x="493" y="115">

                                    <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/curToClientName}&lt;/client>&lt;reportType class=&quot;workflow.types.cmd.ReportInformationType&quot; _list_=&quot;false&quot; />&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

                                    <transition

                                    activity="ExecuteCommand_2"

                                    commented="0"

                                    originalStyle="" points=""

                                    sourceX="544" sourceY="132"

                                    status="0"

                                    style="defaultEdge"

                                    targetX="361" targetY="133"

                                    transitionIndex="0" x="0" y="0">

                                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                                    </transition>

                                    </Activity>

                                    <Activity commented="0"

                                    continueOnFailure="0"

                                    created="1521245659315"

                                    description="Execute a command on a remote machine"

                                    displayName="Run Index Migration"

                                    height="34" interactive="0"

                                    jobMode="0" maxRestarts="1"

                                    name="ExecuteCommand"

                                    namespaceUri="commvault.cte.workflow.activities"

                                    originalStyle="" skipAttempt="0"

                                    style="label;image=commvault.cte.workflow.activities.ExecuteCommand"

                                    uniqueName="ExecuteCommand_2"

                                    waitSetting="0" width="142"

                                    x="242" y="115">

                                    <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/curToClientName}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/curAppPath}&lt;/startUpPath>&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/curAppName}&lt;/command>&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>-vm xpath:{/workflow/variables/curVmName} -cn xpath:{/workflow/variables/curToClientName} -source xpath:{/workflow/variables/curFromClientName} -target &quot;xpath:{/workflow/variables/curToIdxCache}&quot; -backupset xpath:{/workflow/variables/curBsGuid} -database xpath:{/workflow/variables/curDbGuid} -wj xpath:{/workflow/system/jobId} -move &lt;/arguments>&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

                                    <transition

                                    activity="CommServDBQuery_24"

                                    commented="0"

                                    originalStyle="" points=""

                                    sourceX="324" sourceY="135"

                                    status="0"

                                    style="defaultEdge"

                                    targetX="130" targetY="137"

                                    transitionIndex="0" x="0" y="0">

                                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                                    </transition>

                                    </Activity>

                                    <Activity commented="0"

                                    continueOnFailure="0"

                                    created="1521245838888"

                                    description="executes queries against a commcell database"

                                    displayName="Set Index Server in CS"

                                    height="34" interactive="0"

                                    jobMode="0"

                                    name="CommServDBQuery"

                                    namespaceUri="commvault.cte.workflow.activities"

                                    originalStyle="" skipAttempt="0"

                                    style="label;image=commvault.cte.workflow.activities.CommServDBQuery"

                                    uniqueName="CommServDBQuery_24"

                                    waitSetting="0" width="156"

                                    x="15" y="115">

                                    <inputs val="&lt;inputs>&lt;commCell />&lt;query>UPDATE App_IndexDBInfo&amp;#xD;&#xd;&#xa;SET currentIdxServer = xpath:{/workflow/variables/curToClientID}&amp;#xD;&#xd;&#xa;WHERE id = xpath:{/workflow/variables/curIndexId} AND currentIdxServer &amp;lt;&amp;gt; xpath:{/workflow/variables/curToClientID}&lt;/query>&lt;/inputs>"/>

                                    <transition

                                    activity="CommServDBQuery_33"

                                    commented="0"

                                    originalStyle="" points=""

                                    sourceX="510" sourceY="380"

                                    status="0"

                                    style="defaultEdge"

                                    targetX="351" targetY="381"

                                    transitionIndex="0" x="-72" y="65">

                                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                                    </transition>

                                    </Activity>

                                    <Activity commented="0"

                                    continueOnFailure="0"

                                    created="1525964024533"

                                    description="executes queries against a commcell database"

                                    displayName="Audit Index Server"

                                    height="34" interactive="0"

                                    jobMode="0"

                                    name="CommServDBQuery"

                                    namespaceUri="commvault.cte.workflow.activities"

                                    originalStyle="" skipAttempt="0"

                                    style="label;image=commvault.cte.workflow.activities.CommServDBQuery"

                                    uniqueName="CommServDBQuery_33"

                                    waitSetting="0" width="160"

                                    x="13" y="198">

                                    <inputs val="&lt;inputs>&lt;commCell />&lt;query>EXEC AppAuditIdxServerChange xpath:{/workflow/variables/curFromClientID}, xpath:{/workflow/variables/curToClientID}&lt;/query>&lt;/inputs>"/>

                                    <transition

                                    activity="CommServDBQuery_25"

                                    commented="0"

                                    originalStyle="" points=""

                                    sourceX="297" sourceY="382"

                                    status="0"

                                    style="defaultEdge"

                                    targetX="127" targetY="380"

                                    transitionIndex="0" x="-72" y="65">

                                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                                    </transition>

                                    </Activity>

                                    <Activity commented="0"

                                    continueOnFailure="0"

                                    created="1521296903494"

                                    description="executes queries against a commcell database"

                                    displayName="Set Migration Completed"

                                    height="34" interactive="0"

                                    jobMode="0"

                                    name="CommServDBQuery"

                                    namespaceUri="commvault.cte.workflow.activities"

                                    originalStyle="" skipAttempt="0"

                                    style="label;image=commvault.cte.workflow.activities.CommServDBQuery"

                                    uniqueName="CommServDBQuery_25"

                                    waitSetting="0" width="169"

                                    x="229" y="198">

                                    <inputs val="&lt;inputs>&lt;commCell />&lt;query>DECLARE @curtime INT = DBO.GetUnixTime(getdate())&amp;#xD;&#xd;&#xa;UPDATE IdxServerMigrations&amp;#xD;&#xd;&#xa;SET isMigrated = 1, endTime = @curtime&amp;#xD;&#xd;&#xa;WHERE indexId = xpath:{/workflow/variables/curIndexId} AND fromClientId = xpath:{/workflow/variables/curFromClientID} AND toClientId = xpath:{/workflow/variables/curToClientID} AND isMigrated = 0 AND jobId = xpath:{/workflow/system/jobId}&lt;/query>&lt;/inputs>"/>

                                    <transition

                                    activity="LogEvent_2"

                                    commented="0"

                                    originalStyle="" points=""

                                    sourceX="283" sourceY="384"

                                    status="0"

                                    style="defaultEdge"

                                    targetX="134" targetY="382"

                                    transitionIndex="0" x="-72" y="65">

                                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                                    </transition>

                                    </Activity>

                                    <Activity commented="0"

                                    continueOnFailure="0"

                                    created="1521233737403"

                                    description="logs an event in the commcell console with the specified severity level"

                                    displayName="Inform migration complete"

                                    height="34" interactive="0"

                                    jobMode="0" name="LogEvent"

                                    namespaceUri="commvault.cte.workflow.activities"

                                    originalStyle="" skipAttempt="0"

                                    style="label;image=commvault.cte.workflow.activities.LogEventActivity"

                                    uniqueName="LogEvent_2"

                                    waitSetting="0" width="180"

                                    x="454" y="198">

                                    <inputs val="&lt;inputs>&lt;severity class=&quot;workflow.types.SeverityLevel&quot; _list_=&quot;false&quot;>INFO&lt;/severity>&lt;message class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>Load balance status: Index [xpath:{/workflow/variables/curFromClientName}/xpath:{/workflow/variables/curBsGuid}] moved from [xpath:{/workflow/variables/curFromClientName}] to [xpath:{/workflow/variables/curToClientName}]&lt;/message>&lt;/inputs>"/>

                                    </Activity>

                                </superProcess>

                                <activitySchema>

                                    <outputs className=""

                                    defaultValue="" listType="0"

                                    name="outputs" type=""/>

                                    <inputs className="" defaultValue=""

                                    listType="0" name="inputs" type=""/>

                                </activitySchema>

                                <transition activity="ProcessBlock_2"

                                    commented="0" displayName="FAIL"

                                    originalStyle="" points=""

                                    sourceX="332" sourceY="220"

                                    status="2" style="defaultEdge"

                                    targetX="771" targetY="140"

                                    transitionIndex="0" x="0" y="0">

                                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                                </transition>

                            </Activity>

                            <Activity commented="0"

                                continueOnFailure="0"

                                created="1578662800434"

                                description="creates a super process group"

                                displayName="CATCH" height="166"

                                interactive="0" jobMode="0"

                                name="ProcessBlock"

                                namespaceUri="commvault.cte.workflow.activities"

                                originalStyle="" skipAttempt="0"

                                style="swimlane"

                                uniqueName="ProcessBlock_2"

                                waitSetting="0" width="173" x="712" y="138">

                                <inputs val="&lt;inputs>&lt;inputs />&lt;/inputs>"/>

                                <superProcess>

                                    <Start commented="0"

                                    continueOnFailure="0"

                                    created="1578662800434"

                                    description=""

                                    displayName="Start" height="30"

                                    interactive="0" jobMode="0"

                                    name="Start" originalStyle=""

                                    skipAttempt="0"

                                    style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                                    uniqueName="Start_18"

                                    waitSetting="0" width="120"

                                    x="18" y="30">

                                    <inputs val="&lt;inputs />"/>

                                    <transition

                                    activity="LogEvent_5"

                                    commented="0"

                                    originalStyle="" points=""

                                    sourceX="78" sourceY="45"

                                    status="0"

                                    style="defaultEdge"

                                    targetX="86" targetY="124"

                                    transitionIndex="0" x="0" y="0">

                                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                                    </transition>

                                    </Start>

                                    <Activity commented="0"

                                    continueOnFailure="0"

                                    created="1567777509179"

                                    description="logs an event in the commcell console with the specified severity level"

                                    displayName="Inform migration failed"

                                    height="34" interactive="0"

                                    jobMode="0" name="LogEvent"

                                    namespaceUri="commvault.cte.workflow.activities"

                                    originalStyle="" skipAttempt="0"

                                    style="label;image=commvault.cte.workflow.activities.LogEventActivity"

                                    uniqueName="LogEvent_5"

                                    waitSetting="0" width="158"

                                    x="6" y="112">

                                    <inputs val="&lt;inputs>&lt;severity class=&quot;workflow.types.SeverityLevel&quot; _list_=&quot;false&quot;>INFO&lt;/severity>&lt;message class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>Load balance status: Index [xpath:{/workflow/variables/curFromClientName}/xpath:{/workflow/variables/curBsGuid}] FAILED to move from [xpath:{/workflow/variables/curFromClientName}] to [xpath:{/workflow/variables/curToClientName}]. See logs for more details.&lt;/message>&lt;/inputs>"/>

                                    </Activity>

                                </superProcess>

                                <activitySchema>

                                    <outputs className=""

                                    defaultValue="" listType="0"

                                    name="outputs" type=""/>

                                    <inputs className="" defaultValue=""

                                    listType="0" name="inputs" type=""/>

                                </activitySchema>

                            </Activity>

                        </superProcess>

                        <activitySchema>

                            <outputs name="outputs">

                                <children attribute="0"

                                    className="java.lang.Object"

                                    defaultValue="" hidden="0"

                                    inputType="java.lang.Object"

                                    listType="0" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                            </outputs>

                            <inputs>

                                <children className="java.lang.String"

                                    inputType="java.lang.String"

                                    name="name" type="{http://www.w3.org/2001/XMLSchema}string"/>

                                <children className="java.lang.Object"

                                    inputType="java.lang.Object"

                                    name="values" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                                <children className="java.lang.Integer"

                                    defaultValue="1"

                                    inputType="java.lang.Integer"

                                    name="numberOfParallelExecutions" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                                <children className="java.lang.Boolean"

                                    defaultValue="false"

                                    inputType="java.lang.Boolean"

                                    name="continueOnFailure" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                            </inputs>

                        </activitySchema>

                    </Activity>

                    <Activity commented="0" continueOnFailure="0"

                        created="1521384325990"

                        description="executes queries against a commcell database"

                        displayName="Get pending migrations" height="34"

                        interactive="0" jobMode="0"

                        name="CommServDBQuery"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=commvault.cte.workflow.activities.CommServDBQuery"

                        uniqueName="CommServDBQuery_28" waitSetting="0"

                        width="200" x="352" y="115">

                        <inputs val="&lt;inputs>&lt;commCell />&lt;query>SELECT id FROM IdxServerMigrations WHERE fromClientId = xpath:{/workflow/ForEach_7/col} AND toClientId = xpath:{/workflow/ForEach_10/col} AND isMigrated = 0&lt;/query>&lt;/inputs>"/>

                        <transition activity="ForEach_3" commented="0"

                            originalStyle="" points="" sourceX="363"

                            sourceY="259" status="0" style="defaultEdge"

                            targetX="373" targetY="334"

                            transitionIndex="0" x="0" y="0">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                </superProcess>

                <activitySchema>

                    <outputs name="outputs">

                        <children attribute="0"

                            className="java.lang.Object" defaultValue=""

                            hidden="0" inputType="java.lang.Object"

                            listType="0" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                    </outputs>

                    <inputs>

                        <children className="java.lang.String"

                            inputType="java.lang.String" name="name" type="{http://www.w3.org/2001/XMLSchema}string"/>

                        <children className="java.lang.Object"

                            inputType="java.lang.Object" name="values" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                        <children className="java.lang.Integer"

                            defaultValue="1"

                            inputType="java.lang.Integer"

                            name="numberOfParallelExecutions" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                        <children className="java.lang.Boolean"

                            defaultValue="false"

                            inputType="java.lang.Boolean"

                            name="continueOnFailure" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                    </inputs>

                </activitySchema>

            </Activity>

        </superProcess>

        <activitySchema>

            <outputs name="outputs">

                <children attribute="0" className="java.lang.Object"

                    defaultValue="" hidden="0"

                    inputType="java.lang.Object" listType="0" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

            </outputs>

            <inputs>

                <children className="java.lang.String"

                    inputType="java.lang.String" name="name" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children className="java.lang.Object"

                    inputType="java.lang.Object" name="values" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                <children className="java.lang.Integer" defaultValue="1"

                    inputType="java.lang.Integer"

                    name="numberOfParallelExecutions" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                <children className="java.lang.Boolean"

                    defaultValue="false" inputType="java.lang.Boolean"

                    name="continueOnFailure" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

            </inputs>

        </activitySchema>

        <transition activity="CommServDBQuery_19" commented="0"

            displayName="Check Migrations Completed" offsetX="-42"

            offsetY="78" originalStyle=""

            points="681.0,726.6666666666667" sourceX="1678"

            sourceY="669" status="0" style="defaultEdge" targetX="678"

            targetY="536" transitionIndex="0" x="-20" y="-397"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1521406036192" description="if/else based decision"

        displayName="Are pending migrations ?" height="100"

        interactive="0" jobMode="0" name="Decision"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_12" waitSetting="0" width="175" x="8" y="374">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/CommServDBQuery_30/resultSets/rowCount} &amp;gt; 0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="CommServDBQuery_18" commented="0"

            displayName="No" originalStyle="" points="" sourceX="95"

            sourceY="424" status="0" style="defaultEdge" targetX="329"

            targetY="426" transitionIndex="0" value="False" x="-20" y="-397">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="Decision_6" commented="0"

            displayName="Yes" offsetX="-95" offsetY="85"

            originalStyle="" points="95.0,487.6666666666667"

            sourceX="95" sourceY="424" status="0" style="defaultEdge"

            targetX="354" targetY="552" transitionIndex="0" value="True"

            x="-20" y="-397">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1521407487587"

        description="executes queries against a commcell database"

        displayName="Get pending migrations" height="34" interactive="0"

        jobMode="0" name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.CommServDBQuery;whiteSpace=wrap"

        uniqueName="CommServDBQuery_30" waitSetting="0" width="200"

        x="-5" y="270">

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>SELECT fromClientId FROM IdxServerMigrations WHERE isMigrated = 0&lt;/query>&lt;/inputs>"/>

        <transition activity="Decision_12" commented="0"

            originalStyle="" points="" sourceX="95" sourceY="287"

            status="0" style="defaultEdge" targetX="102" targetY="390"

            transitionIndex="0" x="-20" y="-397">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1521489585137"

        description="executes queries against a commcell database"

        displayName="Delete pending migrations" height="34"

        interactive="0" jobMode="0" name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.CommServDBQuery"

        uniqueName="CommServDBQuery_32" waitSetting="0" width="178"

        x="304" y="366">

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>DELETE FROM IdxServerMigrations WHERE isMigrated = 0 &lt;/query>&lt;/inputs>"/>

        <transition activity="CommServDBQuery_18" commented="0"

            originalStyle="" points="" sourceX="381" sourceY="395"

            status="0" style="defaultEdge" targetX="388" targetY="291"

            transitionIndex="0" x="-20" y="-397">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1521489731444" description="if/else based decision"

        displayName="Delete them ?" height="100" interactive="0"

        jobMode="0" name="Decision"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_13" waitSetting="0" width="108" x="339" y="473">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/configuration/deletePending}&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="CommServDBQuery_32" commented="0"

            displayName="Yes" originalStyle="" points="" sourceX="386"

            sourceY="519" status="0" style="defaultEdge" targetX="485"

            targetY="515" transitionIndex="0" value="true" x="-20" y="-397">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="WorkflowEnd_4" commented="0"

            displayName="No" originalStyle="" points="" sourceX="393"

            sourceY="523" status="0" style="defaultEdge" targetX="212"

            targetY="523" transitionIndex="0" value="false" x="-20" y="-397">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1521489770874" description="Ends the workflow"

        displayName="WorkflowEnd" height="34" interactive="0"

        jobMode="0" name="WorkflowEnd"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.EndActivity"

        uniqueName="WorkflowEnd_4" waitSetting="0" width="106" x="159" y="506">

        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot; />&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1521551561142"

        description="synchronizes a workflow per named parameter"

        displayName="AcquireLock" height="34" interactive="0"

        jobMode="0" name="AcquireLock"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.LockAcquireActivity"

        uniqueName="AcquireLock_1" waitSetting="0" width="102" x="45" y="143">

        <inputs val="&lt;inputs>&lt;name class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/system/workflow/workflowName}&lt;/name>&lt;releaseLockOnCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/releaseLockOnCompletion>&lt;timeout class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;/inputs>"/>

        <transition activity="CommServDBQuery_30" commented="0"

            originalStyle="" points="" sourceX="84" sourceY="160"

            status="0" style="defaultEdge" targetX="95" targetY="271"

            transitionIndex="0" x="-20" y="-397">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1578597793118" description="if/else based decision"

        displayName="Has pending migrations ?" height="100"

        interactive="0" jobMode="0" name="Decision"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_20" waitSetting="0" width="174" x="897" y="496">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/CommServDBQuery_19/resultSets/rowCount} &amp;gt; 0 &amp;amp;&amp;amp; xpath:{/workflow/variables/nCount} &amp;lt; xpath:{/workflow/configuration/nMaxTries}&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="WorkflowEnd_2" commented="0"

            displayName="No" originalStyle="" points="" sourceX="984"

            sourceY="546" status="0" style="defaultEdge" targetX="982"

            targetY="681" transitionIndex="0" value="False" x="-20" y="-397">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="ForEach_7" commented="0" displayName="Yes"

            originalStyle="" points="1142.0,546.6666666666667"

            sourceX="984" sourceY="546" status="0" style="defaultEdge"

            targetX="1491" targetY="222" transitionIndex="0"

            value="True" x="-20" y="-397">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <formProperties css="" formVersion="0" javaScript="" pageMode="0">

        <rules/>

    </formProperties>

</workflow>'

IF not exists (select * from WF_Definition where Name = @name)

BEGIN
	INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, uniqueGuid, revision)


	VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @uniqueGuid, @revision)

	SET @workflowId = @@IDENTITY
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


	VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

	SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = ISNULL(revision, '') From WF_Definition WHERE Name = @name

	IF (@currentFlags & 6 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0) AND (@currentRevision <> @revision)

	BEGIN

		SET @version = @version + 1

		UPDATE WF_Definition

		SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision

		WHERE Name = @name

		IF (@currentFlags & 6 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0)

		BEGIN

			UPDATE WF_Definition

			SET flags = @flags

			WHERE Name = @name

		END
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


		VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

	END

END

