

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_Lic_RecalculateUsage.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 2017  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/WFD_Lic_RecalculateUsage.script,v $";
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER ON

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.1.2.3 $'

SET @name = 'ExecuteLSRMaster'

SET @description = 'Workflow to execute LSR master stored procedure from LSR custom reports'

SET @version = 1

SET @flags = 54	--AutoDeploy+cvWorkflow+Hidden+SkipSecurityCheck

SET @definition='<workflow apiMode="0" config="&lt;configuration />"

    description="Workflow to execute LSR master stored procedure from LSR custom reports"

    executeOnWeb="0" inputs="&lt;inputs />" interactive="1"

    isHtmlDescription="0" name="ExecuteLSRMaster"

    outputs="&lt;outputs />" revision="$Revision: 1.1.2.3 $" tags=""

    uniqueGuid="d14a2699-bffb-4ce6-829d-44f514dad60f"

    variables="&lt;variables />" webHidden="1" workflowId="0">

    <schema>

        <outputs className="" name="outputs" type=""/>

        <variables className="" name="variables" type=""/>

        <inputs className="" name="inputs" type=""/>

        <config className="" name="configuration" type=""/>

    </schema>

    <Start commented="0" continueOnFailure="0" created="0"

        description="" displayName="Start" height="36" interactive="0"

        jobMode="0" name="Start" originalStyle="" skipAttempt="0"

        style="image;image=/images/jgraphx/house.png"

        uniqueName="Start_1" waitSetting="0" width="55" x="41" y="57">

        <inputs val="&lt;inputs />"/>

        <transition activity="ImpersonateCreator_1" commented="0"

            originalStyle="" points="" sourceX="72" sourceY="59"

            status="0" style="defaultEdge" targetX="222" targetY="59"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Start>

    <Activity commented="0" continueOnFailure="0"

        created="1528835416187"

        description="executes queries against a commcell database"

        displayName="Execute Master LSR SP" height="34" interactive="0"

        jobMode="0" name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.CommServDBQuery"

        uniqueName="CommServDBQuery_1" waitSetting="0" width="164"

        x="353" y="59">

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>DECLARE @isMasterSPRunning INT = 0&amp;#xD;&#xd;&#xa;DECLARE @LastResetUnixTime INT = 0&amp;#xD;&#xd;&#xa;DECLARE @minElapsedFromLastReset INT = 0&amp;#xD;&#xd;&#xa;DECLARE @flag INT = 0&amp;#xD;&#xd;&#xa;SELECT @isMasterSPRunning = CONVERT(INT, value), @LastResetUnixTime = ISNULL(created, -1) FROM GXGlobalParam WITH (NOLOCK) WHERE name = ''LicCalcUsageMasterSPRunning'' &amp;#xD;&#xd;&#xa;SET @minElapsedFromLastReset = DATEDIFF(MINUTE, DATEADD(SECOND, @LastResetUnixTime, ''1970-01-01''), GETUTCDATE())&amp;#xD;&#xd;&#xa;      &amp;#xD;&#xd;&#xa;--first check if Master LSR SP is currently running or not. If LSR master SP is running for less than 1 hour, do nothing, just wait for it to complete &amp;#xD;&#xd;&#xa;IF @isMasterSPRunning = 1 AND @minElapsedFromLastReset &amp;lt;= 60&amp;#xD;&#xd;&#xa;BEGIN&amp;#xD;&#xd;&#xa;    --if it has been in running state for more than 130 seconds end the workflow job. &amp;#xD;&#xd;&#xa;    --Call to the workflow from report has a timeout of 120 seconds. So, by this time, user would have already got a timeout response back in the UI&amp;#xD;&#xd;&#xa;    WHILE @isMasterSPRunning = 1 AND @flag &amp;lt;= 26&amp;#xD;&#xd;&#xa;    BEGIN     &amp;#xD;&#xd;&#xa;        --wait for 5 seconds and check again&amp;#xD;&#xd;&#xa;        WAITFOR DELAY ''00:00:05''&amp;#xD;&#xd;&#xa;        SET @isMasterSPRunning = 0&amp;#xD;&#xd;&#xa;        SELECT @isMasterSPRunning = CONVERT(INT, value) FROM GXGlobalParam WITH (NOLOCK) WHERE name = ''LicCalcUsageMasterSPRunning''&amp;#xD;&#xd;&#xa;        SET @flag = @flag +1&amp;#xD;&#xd;&#xa;    END&amp;#xD;&#xd;&#xa;END&amp;#xD;&#xd;&#xa;ELSE&amp;#xD;&#xd;&#xa;BEGIN--execute master sp if is not already running or if it was running for more than 1 hour &amp;#xD;&#xd;&#xa;    EXEC LicCalcUsageMaster @nCallerType = 2&amp;#xD;&#xd;&#xa;END&amp;#xD;&#xd;&#xa;&lt;/query>&lt;/inputs>"/>

        <transition activity="WorkflowEnd_1" commented="0"

            originalStyle="" points="" sourceX="222" sourceY="59"

            status="0" style="defaultEdge" targetX="462" targetY="59"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1528836189554" description="Ends the workflow"

        displayName="WorkflowEnd" height="34" interactive="0"

        jobMode="0" name="WorkflowEnd"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.EndActivity"

        uniqueName="WorkflowEnd_1" waitSetting="0" width="106" x="571" y="58">

        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot; />&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1542135365404"

        description="impersonates the user who created the workflow"

        displayName="ImpersonateCreator" height="34" interactive="0"

        jobMode="0" name="ImpersonateCreator"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.ImpersonateCreator"

        uniqueName="ImpersonateCreator_1" waitSetting="0" width="145"

        x="164" y="60">

        <inputs val="&lt;inputs />"/>

        <transition activity="CommServDBQuery_1" commented="0"

            originalStyle="" sourceX="236" sourceY="77" status="0"

            style="defaultEdge" targetX="332" targetY="59"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <formProperties css="" formVersion="0" javaScript="" pageMode="0"/>

</workflow>'

IF not exists (select * from WF_Definition where Name = @name)

BEGIN
    INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision)


    VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision)

    SET @workflowId = @@IDENTITY
    INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


    VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

    SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = ISNULL(revision, '') From WF_Definition WHERE Name = @name

    IF (@currentFlags & 4 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0) AND (@currentRevision <> @revision)

    BEGIN

        SET @version = @version + 1

        UPDATE WF_Definition

        SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision

        WHERE Name = @name

        IF (@flags & 8 > 0 OR @flags & 16 > 0)

        BEGIN

            UPDATE WF_Definition

            SET flags = @flags

            WHERE Name = @name

        END
        INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


        VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

    END

END
