

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_InstallOrScheduleUpdates.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER ON

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @guid nvarchar(256)

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.1.2.6 $'

SET @name = 'Install or Schedule updates'

SET @description = 'Schedules or installs the latest available service pack and all corresponding hotfixes on the CommServe computer, all clients, and MediaAgents.'

SET @version = 1

SET @flags = 6

SET @guid = '90B74C33-C903-4574-B58C-F6A32D39E5B1'

SET @definition = '<workflow apiMode="0" config="&lt;configuration />" description="Schedules or installs the latest available service pack and all corresponding hotfixes on the CommServe computer, all clients, and MediaAgents." inputs="&lt;inputs />" interactive="1" isHtmlDescription="0" name="Install or Schedule Updates" outputs="&lt;outputs />" revision="$Revision: 1.1.2.6 $" uniqueGuid="" variables="&lt;variables>&lt;install_Now class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>1&lt;/install_Now>&lt;sched_Dwld_Date class=&quot;java.util.Date&quot; _list_=&quot;false&quot; />&lt;sched_Dwld_Time class=&quot;workflow.types.Time&quot; _list_=&quot;false&quot; />&lt;sched_wf_Xml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&amp;lt;TMMsg_CreateTaskReq&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;taskInfo&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;task&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;taskFlags&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;disabled&amp;gt;false&amp;lt;/disabled&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;isEdgeDrive&amp;gt;false&amp;lt;/isEdgeDrive&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/taskFlags&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;policyType&amp;gt;DATA_PROTECTION&amp;lt;/policyType&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;taskType&amp;gt;SCHEDULE&amp;lt;/taskType&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;initiatedFrom&amp;gt;COMMANDLINE&amp;lt;/initiatedFrom&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/task&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;associations&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;type&amp;gt;GALAXY&amp;lt;/type&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;subclientName&amp;gt;&amp;lt;/subclientName&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;backupsetName&amp;gt;&amp;lt;/backupsetName&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;instanceName&amp;gt;&amp;lt;/instanceName&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;appName&amp;gt;&amp;lt;/appName&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;clientName&amp;gt;&amp;lt;/clientName&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;clientGroupIdForGUI&amp;gt;0&amp;lt;/clientGroupIdForGUI&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;consumeLicense&amp;gt;true&amp;lt;/consumeLicense&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;clientSidePackage&amp;gt;true&amp;lt;/clientSidePackage&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;workflowName&amp;gt;Download and Install Updates&amp;lt;/workflowName&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/associations&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;subTasks&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;subTask&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;subTaskName&amp;gt;Workflow_Created_Schedule_To_Download_And_Install_Updates&amp;lt;/subTaskName&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;subTaskType&amp;gt;ADMIN&amp;lt;/subTaskType&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;operationType&amp;gt;WORK_FLOW&amp;lt;/operationType&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/subTask&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;pattern&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;freq_type&amp;gt;One_Time&amp;lt;/freq_type&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;active_start_date&amp;gt;$START_DATE$&amp;lt;/active_start_date&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;active_start_time&amp;gt;$START_TIME$&amp;lt;/active_start_time&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;timeZone&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;TimeZoneName&amp;gt;CommServe Time Zone&amp;lt;/TimeZoneName&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;/timeZone&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;description&amp;gt;&amp;lt;/description&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/pattern&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;options&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;backupOpts&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;backupLevel&amp;gt;INCREMENTAL&amp;lt;/backupLevel&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;dataOpt&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;autoCopy&amp;gt;false&amp;lt;/autoCopy&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;/dataOpt&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;/backupOpts&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;restoreOptions&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;virtualServerRstOption&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;isBlockLevelReplication&amp;gt;false&amp;lt;/isBlockLevelReplication&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;/virtualServerRstOption&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;/restoreOptions&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;adminOpts&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;contentIndexingOption&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;subClientBasedAnalytics&amp;gt;false&amp;lt;/subClientBasedAnalytics&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;/contentIndexingOption&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;/adminOpts&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;workflowJobOptions&amp;gt;&amp;lt;inputs&amp;gt;&amp;lt;/inputs&amp;gt;&amp;lt;/workflowJobOptions&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/options&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;subTaskOperation&amp;gt;OVERWRITE&amp;lt;/subTaskOperation&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/subTasks&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;/taskInfo&amp;gt;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&amp;lt;/TMMsg_CreateTaskReq&amp;gt;&amp;#xD;&#xd;&#xa;&lt;/sched_wf_Xml>&lt;formatted_sched_dwld_xml class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;now_or_Sched class=&quot;java.lang.String&quot; _list_=&quot;true&quot;>Run now&lt;/now_or_Sched>&lt;sched_date_time class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;sched_time_str class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;newDefaultTime class=&quot;workflow.types.Time&quot; _list_=&quot;false&quot; />&lt;/variables>" webHidden="0">

    <schema>

        <outputs className="" name="outputs" type=""/>

        <variables attribute="0" className="" name="variables" type="">

            <children attribute="0" className="java.lang.Integer" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Integer" listType="0" name="install_Now" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.util.Date" controlType="6" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.util.Date" listType="0" name="sched_Dwld_Date" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}date"/>

            <children attribute="0" className="workflow.types.Time" controlType="9" defaultValue="" displayName="" documentation="" hidden="0" inputType="workflow.types.Time" listType="0" name="sched_Dwld_Time" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}time"/>

            <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="sched_wf_Xml" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" hidden="0" inputType="java.lang.String" listType="0" name="formatted_sched_dwld_xml" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="1" name="now_or_Sched" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="sched_date_time" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="sched_time_str" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="workflow.types.Time" controlType="9" defaultValue="" hidden="0" inputType="workflow.types.Time" listType="0" name="newDefaultTime" type="{http://www.w3.org/2001/XMLSchema}time"/>

        </variables>

        <inputs className="" name="inputs" type=""/>

        <config className="" name="" type=""/>

    </schema>

    <Start breakpoint="0" commented="0" continueOnFailure="0" created="0" description="" displayName="Start" height="36" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="0" style="image;image=/images/jgraphx/house.png" uniqueName="Start_1" waitSetting="0" width="58" x="24" y="61">

        <inputs val="&lt;inputs />"/>

        <transition activity="ImpersonateCreator_1" commented="0" originalStyle="" points="" sourceX="55" sourceY="142" status="0" style="defaultEdge" targetX="141" targetY="153" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Start>

    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1484163304208" description="impersonates the user who created the workflow" displayName="ImpersonateCreator" height="16" interactive="0" jobMode="0" name="ImpersonateCreator" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.ImpersonateCreator" uniqueName="ImpersonateCreator_1" waitSetting="0" width="145" x="15" y="140">

        <inputs val="&lt;inputs />"/>

        <transition activity="CommServDBQuery_1" commented="0" originalStyle="" points="" sourceX="203" sourceY="147" status="0" style="defaultEdge" targetX="396" targetY="150" transitionIndex="0" x="-12" y="85">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1484164624659" description="" displayName="User Options" height="16" interactive="0" jobMode="0" name="PopupInput" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.InteractiveInputActivity" uniqueName="PopupInput_1" waitSetting="0" width="104" x="39" y="312">

        <onExit language="1" script="&#xd;&#xa;//workflow.setVariable(&quot;now_or_Sched&quot;, xpath:{/workflow/PopupInput_1/choose_runNow});&#xd;&#xa;&#xd;&#xa;//String[] userChoice = xpath:{/workflow/PopupInput_1/choose_runNow};&#xd;&#xa;logger.info(&quot;user Choice: [ &quot; + xpath:{/workflow/PopupInput_1/choose_runNow}.toString() +&quot;]&quot;);&#xd;&#xa;//logger.info(&quot;user Choice: [ &quot; + xpath:{/workflow/variables/now_or_Sched} +&quot;]&quot;);&#xd;&#xa;if(xpath:{/workflow/PopupInput_1/choose_runNow}.toString().equalsIgnoreCase(&quot;[Schedule]&quot;))&#xd;&#xa;{&#xd;&#xa;workflow.setVariable(&quot;install_Now&quot;,0);&#xd;&#xa;workflow.setVariable(&quot;now_or_Sched&quot;,&quot;Schedule&quot;);&#xd;&#xa;}&#xd;&#xa;else{&#xd;&#xa;workflow.setVariable(&quot;install_Now&quot;,1);&#xd;&#xa;workflow.setVariable(&quot;now_or_Sched&quot;,&quot;Run now&quot;);&#xd;&#xa;}"/>

        <inputs val="&lt;inputs>&lt;actions>&lt;name>Cancel&lt;/name>&lt;validateForm>true&lt;/validateForm>&lt;/actions>&lt;actions>&lt;name>Next&lt;/name>&lt;validateForm>true&lt;/validateForm>&lt;/actions>&lt;inputs>&lt;choose_runNow class=&quot;java.lang.String&quot; _list_=&quot;true&quot;>xpath:{/workflow/variables/now_or_Sched}&lt;/choose_runNow>&lt;/inputs>&lt;subject>Download and install updates options&lt;/subject>&lt;formProperties>&amp;lt;?xml version=&apos;1.0&apos; encoding=&apos;UTF-8&apos;?&amp;gt;&amp;lt;Workflow_FormProperties css=&quot;&quot; javaScript=&quot;&quot; width=&quot;465&quot; height=&quot;300&quot; /&amp;gt;&lt;/formProperties>&lt;/inputs>"/>

        <activitySchema>

            <outputs className="" defaultValue="" listType="0" name="outputs" type="">

                <children alignment="0" attribute="0" className="java.lang.String" controlHidden="0" controlType="4" defaultValue="" displayName="Install updates (Vxpath:{/workflow/CommServDBQuery_1/resultSets[1]/row[1]/col[1]}) : " documentation="Latest version available is  Commvault Vxpath:{/workflow/CommServDBQuery_1/resultSets[1]/row[1]/col[1]}" hidden="0" inputType="java.lang.String" listType="1" maximumValue="" minimumValue="" name="choose_runNow" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string">

                    <options val="Run now"/>

                    <options val="Schedule"/>

                </children>

                <children className="java.lang.Boolean" inputType="java.lang.Boolean" name="okClicked" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                <children className="java.lang.String" inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string"/>

            </outputs>

            <inputs className="" defaultValue="" listType="0" name="inputs" type="">

                <children alignment="0" attribute="0" className="java.lang.String" controlHidden="0" controlType="4" defaultValue="" displayName="Install updates (Vxpath:{/workflow/CommServDBQuery_1/resultSets[1]/row[1]/col[1]}) : " documentation="Latest version available is  Commvault Vxpath:{/workflow/CommServDBQuery_1/resultSets[1]/row[1]/col[1]}" hidden="0" inputType="java.lang.String" listType="1" maximumValue="" minimumValue="" name="choose_runNow" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string">

                    <options val="Run now"/>

                    <options val="Schedule"/>

                </children>

            </inputs>

        </activitySchema>

        <transition activity="WorkflowEnd_9" commented="0" displayName="X" offsetX="-60" offsetY="0" originalStyle="" points="" sourceX="153" sourceY="96" status="0" style="defaultEdge" targetX="308" targetY="276" transitionIndex="0" x="0" y="0">

            <condition language="1" script="!xpath:{/workflow/PopupInput_1/actionSelected}.equals(&quot;Next&quot;);&#xa;"/>

        </transition>

        <transition activity="CommServDBQuery_2" commented="0" displayName="Next" originalStyle="" points="" sourceX="263" sourceY="101" status="0" style="defaultEdge" targetX="353" targetY="103" transitionIndex="0" x="0" y="0">

            <condition language="1" script="xpath:{/workflow/PopupInput_1/actionSelected}.equals(&quot;Next&quot;);&#xa;"/>

        </transition>

        <onEnter language="1" script="logger.info(&quot;default is : [ &quot; + xpath:{/workflow/variables/now_or_Sched} +&quot;]&quot;);"/>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1484165511894" description="if/else based decision" displayName="Install Now?" height="27" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1;align=center" uniqueName="Decision_1" waitSetting="0" width="99" x="290" y="183">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/install_Now} == 1&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="InformationalMessage_1" commented="0" displayName="Now" originalStyle="" points="" sourceX="504" sourceY="240" status="0" style="defaultEdge;align=center" targetX="705" targetY="311" transitionIndex="0" value="true" x="-89" y="81">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="Decision_2" commented="0" displayName="Schedule upates" originalStyle="" points="" sourceX="504" sourceY="240" status="0" style="defaultEdge;align=center" targetX="509" targetY="355" transitionIndex="0" value="false" x="-72" y="173">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <onEnter language="1" script="logger.info(&quot;Run now: [ &quot; + xpath:{/workflow/variables/install_Now} +&quot;]&quot;);"/>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1484166730786" description="" displayName="Schedule Details" height="12" interactive="0" jobMode="0" name="PopupInput" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.InteractiveInputActivity;align=center" uniqueName="PopupInput_4" waitSetting="0" width="133" x="513" y="51">

        <onExit language="1" script="import java.lang.object.*;&#xd;&#xa;import org.apache.commons.io.FileUtils;&#xd;&#xa;import org.apache.commons.lang.StringEscapeUtils;&#xd;&#xa;import java.util.*;&#xd;&#xa;import java.text.*;&#xd;&#xa;&#xd;&#xa;Calendar cal = xpath:{/workflow/PopupInput_4/sched_Date};&#xd;&#xa;SimpleDateFormat format1 = new SimpleDateFormat(&quot;yyyy-MM-dd&quot;);&#xd;&#xa;String formattedDate = format1.format(cal.getTime());&#xd;&#xa;&#xd;&#xa;workflow.setVariable(&quot;sched_date_time&quot;, formattedDate);&#xd;&#xa;String timeStr = xpath:{/workflow/PopupInput_4/sched_Time}.toString();&#xd;&#xa;workflow.setVariable(&quot;sched_time_str&quot;, timeStr.substring(0, timeStr.length()-5));"/>

        <inputs val="&lt;inputs>&lt;actions>&lt;name>Cancel&lt;/name>&lt;validateForm>false&lt;/validateForm>&lt;/actions>&lt;actions>&lt;name>Next&lt;/name>&lt;validateForm>true&lt;/validateForm>&lt;/actions>&lt;inputs>&lt;sched_Date class=&quot;java.util.Date&quot; _list_=&quot;false&quot; />&lt;sched_Time class=&quot;workflow.types.Time&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/newDefaultTime}&lt;/sched_Time>&lt;/inputs>&lt;subject>Schedule Details&lt;/subject>&lt;formProperties>&amp;lt;?xml version=&apos;1.0&apos; encoding=&apos;UTF-8&apos;?&amp;gt;&amp;lt;Workflow_FormProperties css=&quot;&quot; javaScript=&quot;&quot; width=&quot;465&quot; height=&quot;560&quot; /&amp;gt;&lt;/formProperties>&lt;/inputs>"/>

        <activitySchema>

            <outputs className="" defaultValue="" listType="0" name="outputs" type="">

                <children attribute="0" className="java.util.Date" controlHidden="0" controlType="6" defaultValue="" displayName="Choose date" documentation="Please choose the date to install updates" hidden="0" inputType="java.util.Date" listType="0" maximumValue="" minimumValue="" name="sched_Date" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}date"/>

                <children attribute="0" className="workflow.types.Time" controlHidden="0" controlType="9" defaultValue="" displayName="Choose time" documentation="Please choose the time to install updates in 24hr format" hidden="0" inputType="workflow.types.Time" listType="0" maximumValue="" minimumValue="" name="sched_Time" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}time"/>

                <children className="java.lang.Boolean" inputType="java.lang.Boolean" name="okClicked" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                <children className="java.lang.String" inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string"/>

            </outputs>

            <inputs className="" defaultValue="" listType="0" name="inputs" type="">

                <children attribute="0" className="java.util.Date" controlHidden="0" controlType="6" defaultValue="" displayName="Choose date" documentation="Please choose the date to install updates" hidden="0" inputType="java.util.Date" listType="0" maximumValue="" minimumValue="" name="sched_Date" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}date"/>

                <children attribute="0" className="workflow.types.Time" controlHidden="0" controlType="9" defaultValue="" displayName="Choose time" documentation="Please choose the time to install updates in 24hr format" hidden="0" inputType="workflow.types.Time" listType="0" maximumValue="" minimumValue="" name="sched_Time" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}time"/>

            </inputs>

        </activitySchema>

        <transition activity="WorkflowEnd_10" commented="0" displayName="X" offsetX="57" offsetY="-80" originalStyle="" points="" sourceX="308" sourceY="28" status="0" style="defaultEdge" targetX="464" targetY="189" transitionIndex="0" x="0" y="0">

            <condition language="1" script="!(xpath:{/workflow/PopupInput_4/actionSelected}.equals(&quot;Cancel&quot;);&#xd;&#xa;"/>

        </transition>

        <transition activity="InformationalMessage_4" commented="0" displayName="Next" originalStyle="" points="" sourceX="308" sourceY="28" status="0" style="defaultEdge" targetX="458" targetY="66" transitionIndex="0" x="0" y="0">

            <condition language="1" script="xpath:{/workflow/PopupInput_4/actionSelected}.equals(&quot;Next&quot;);&#xa;"/>

        </transition>

        <onEnter language="1" script="import java.util.*;&#xd;&#xa;import java.lang.*;&#xd;&#xa;&#xd;&#xa;Time t = new Time();&#xd;&#xa;t.setMinute(0);&#xd;&#xa;t.setSecond(0);&#xd;&#xa;&#xd;&#xa;workflow.setVariable(&quot;newDefaultTime&quot;, t);"/>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1484838848011" description="" displayName="Inform User" height="21" interactive="0" jobMode="0" name="InformationalMessage" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.InteractiveMessageActivity;align=center" uniqueName="InformationalMessage_1" waitSetting="0" width="99" x="540" y="314">

        <inputs val="&lt;inputs>&lt;message>CommServ and all the clients will be upgraded to Commvault Vxpath:{/workflow/CommServDBQuery_1/resultSets[1]/row[1]/col[1]}&lt;/message>&lt;dialogType>Popup&lt;/dialogType>&lt;iconType>Information&lt;/iconType>&lt;title>Review&lt;/title>&lt;html>false&lt;/html>&lt;actions>&lt;name>Cancel&lt;/name>&lt;validateForm>true&lt;/validateForm>&lt;/actions>&lt;actions>&lt;name>Submit&lt;/name>&lt;validateForm>true&lt;/validateForm>&lt;/actions>&lt;formProperties />&lt;/inputs>"/>

        <activitySchema>

            <outputs name="outputs">

                <children className="java.lang.String" inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string"/>

            </outputs>

            <inputs className="" defaultValue="" listType="0" name="inputs" type=""/>

        </activitySchema>

        <transition activity="GenericResponse_3" commented="0" displayName="Submit" originalStyle="" points="" sourceX="309" sourceY="158" status="0" style="defaultEdge" targetX="494" targetY="177" transitionIndex="0" x="0" y="0">

            <condition language="1" script="xpath:{/workflow/InformationalMessage_1/actionSelected}.equals(&quot;Submit&quot;);"/>

        </transition>

        <transition activity="WorkflowEnd_10" commented="0" displayName="Cancel" originalStyle="" points="" sourceX="318" sourceY="295" status="0" style="defaultEdge" targetX="497" targetY="257" transitionIndex="0" x="0" y="0">

            <condition language="1" script="!xpath:{/workflow/InformationalMessage_1/actionSelected}.equals(&quot;Submit&quot;);"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1485120256576" description="returns a message to the caller of the workflow" displayName="RespondToCaller" height="17" interactive="0" jobMode="0" name="GenericResponse" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.GenericResponse" uniqueName="GenericResponse_2" waitSetting="0" width="127" x="1040" y="74">

        <inputs val="&lt;inputs>&lt;errorCode class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>0&lt;/errorCode>&lt;errorMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/inputs>"/>

        <transition activity="Script_4" commented="0" originalStyle="" points="" sourceX="464" sourceY="72" status="0" style="defaultEdge" targetX="467" targetY="105" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1485282556095" description="" displayName="Download and Install Updates" height="17" interactive="0" jobMode="0" name="Download_and_Install_Updates" namespaceUri="commvault.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.ExecuteWorkflow" uniqueName="Download_and_Install_Updates_1" waitSetting="0" width="197" x="503" y="512">

        <inputs val="&lt;inputs />"/>

        <transition activity="WorkflowEnd_9" commented="0" originalStyle="" points="" sourceX="319" sourceY="240" status="0" style="defaultEdge" targetX="317" targetY="284" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1482858692395" description="activity to execute code snippets in the selected language" displayName="Update Schedule XML files" height="18" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_4" waitSetting="0" width="181" x="1025" y="114">

        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;import java.lang.object.*;&amp;#xD;&amp;#xA;import org.apache.commons.io.FileUtils;&amp;#xD;&amp;#xA;import org.apache.commons.lang.StringEscapeUtils;&amp;#xD;&amp;#xA;import java.util.*;&amp;#xD;&amp;#xA;import java.text.*;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;String xmlFile = xpath:{/workflow/variables/sched_wf_Xml};&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;//File xmlOP = new File(&amp;quot;C:\\workflows\\wf_XMLS\\schedxml_Inp.xml&amp;quot;);&amp;#xD;&amp;#xA;StringBuffer sb =  new StringBuffer();&amp;#xD;&amp;#xA;BufferedReader br = new BufferedReader(new StringReader(xmlFile));&amp;#xD;&amp;#xA;String line = null;&amp;#xD;&amp;#xA;String newline = System.getProperty(&amp;quot;line.separator&amp;quot;);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;String sched_Time = xpath:{/workflow/PopupInput_4/sched_Time}.toString();&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;logger.info(&amp;quot;Chosen START_TIME: [&amp;quot; + sched_Time + &amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;Calendar cal = xpath:{/workflow/PopupInput_4/sched_Date};&amp;#xD;&amp;#xA;SimpleDateFormat format1 = new SimpleDateFormat(&amp;quot;yyyy-MM-dd HH:mm:ss&amp;quot;);&amp;#xD;&amp;#xA;String formattedDate = format1.format(cal.getTime());&amp;#xD;&amp;#xA;Date dateFromString = format1.parse(formattedDate);&amp;#xD;&amp;#xA;logger.info(&amp;quot;Chosen START_DATE: [&amp;quot; + formattedDate + &amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;long epoch_date =   dateFromString.getTime();&amp;#xD;&amp;#xA;logger.info(&amp;quot;epoch date: [&amp;quot; + epoch_date + &amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;String[] tokens = sched_Time.split(&amp;quot;-&amp;quot;);&amp;#xD;&amp;#xA;sched_Time = tokens[0];&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;while((line = br.readLine())!= null)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;//logger.info(&amp;quot;Reading new line: [&amp;quot; + line + &amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;    if(line.indexOf(&amp;quot;$START_DATE$&amp;quot;) != -1)&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        line = line.replace(&amp;quot;$START_DATE$&amp;quot;,formattedDate);&amp;#xD;&amp;#xA;        logger.info(&amp;quot;Replacing START_DATE: [&amp;quot; + line + &amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;    }  &amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    if(line.indexOf(&amp;quot;$START_TIME$&amp;quot;) != -1)&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;       line = line.replace(&amp;quot;$START_TIME$&amp;quot;,sched_Time);&amp;#xD;&amp;#xA;       &amp;#xD;&amp;#xA;       logger.info(&amp;quot;Replacing START_TIME: [&amp;quot; + line + &amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;    } &amp;#xD;&amp;#xA;    if(line.indexOf(&amp;quot;$ACT_DESC$&amp;quot;) != -1)&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;       line = line.replace(&amp;quot;$ACT_DESC$&amp;quot;,&amp;quot;One time on &amp;quot;+ new SimpleDateFormat(&amp;quot;MMM dd, yyyy&amp;quot;).format(cal.getTime()) +&amp;quot; &amp;quot; + sched_Time );&amp;#xD;&amp;#xA;       logger.info(&amp;quot;Replacing ACT_DESC: [&amp;quot; + line + &amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;    }  &amp;#xD;&amp;#xA;    sb.append(StringEscapeUtils.unescapeXml(line)).append(newline);               &amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;br.close();&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;formatted_sched_dwld_xml&amp;quot;,sb.toString());&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;//BufferedWriter bw = new BufferedWriter(new FileWriter(xmlOP));&amp;#xD;&amp;#xA;//bw.write(sb.toString());&amp;#xD;&amp;#xA;//bw.close();&quot; />&lt;/inputs>"/>

        <transition activity="Execute_3" commented="0" originalStyle="" points="" sourceX="481" sourceY="118" status="0" style="defaultEdge" targetX="482" targetY="152" transitionIndex="0" x="10" y="10">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1485281360889" description="" displayName="Add download schedule" height="14" interactive="0" jobMode="0" name="Execute" namespaceUri="commvault.cte.workflow.activities.cmd.operation" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.cmd.operation.OperationExecute" uniqueName="Execute_3" waitSetting="0" width="165" x="1041" y="151">

        <inputs val="&lt;inputs>&lt;inputXml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/formatted_sched_dwld_xml}&lt;/inputXml>&lt;escapeXml class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/escapeXml>&lt;commandArgs class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

        <transition activity="WorkflowEnd_10" commented="0" originalStyle="" points="" sourceX="488" sourceY="141" status="0" style="defaultEdge" targetX="481" targetY="185" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1487717352774" description="Ends the workflow" displayName="WorkflowEnd" height="34" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.EndActivity" uniqueName="WorkflowEnd_9" waitSetting="0" width="106" x="530" y="571">

        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot; />&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/inputs>"/>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1487717442016" description="Ends the workflow" displayName="WorkflowEnd" height="34" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.EndActivity" uniqueName="WorkflowEnd_10" waitSetting="0" width="106" x="730" y="256">

        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot; />&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/inputs>"/>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1487717499304" description="executes queries against a commcell database" displayName="CommServDBQuery" height="34" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_1" waitSetting="0" width="143" x="23" y="228">

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>IF OBJECT_ID(&apos;tempdb..#TempResSimGetPatchHealthStatus&apos;) IS NOT NULL&amp;#xD;&#xd;&#xa;       DROP TABLE #TempResSimGetPatchHealthStatus&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;CREATE TABLE #TempResSimGetPatchHealthStatus (ClientType VARCHAR(128)&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;, ClientName VARCHAR(2048)&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;, ReleaseStr VARCHAR(16)&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;, SPMajor INT&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;, SPMinor INT&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;, CSReleaseStr VARCHAR(16)&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;, CSSPMajor INT&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;, CSSPMinor INT&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;, LatestReleaseStr VARCHAR(16)&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;, LatestSPMajor INT&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;, LatestSPMinor INT&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;, LatestSPMajorForInstalledVersion INT&amp;#xD;&#xd;&#xa;                , LatestSPMinorForInstalledVersion INT&#x9;&#x9;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;, InstalledAddUpdates VARCHAR(max)&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;, missingInstalledPatches VARCHAR(max)&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;, missingDownloadedPatches VARCHAR(max)) &amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;EXEC simGetPatchHealthStatus 1&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;select LatestReleaseStr + &apos; SP&apos; + CAST(LatestSPMajor as varchar(10)) from #TempResSimGetPatchHealthStatus&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;IF OBJECT_ID(&apos;tempdb..#TempResSimGetPatchHealthStatus&apos;) IS NOT NULL&amp;#xD;&#xd;&#xa;       DROP TABLE #TempResSimGetPatchHealthStatus&amp;#xD;&#xd;&#xa;&lt;/query>&lt;/inputs>"/>

        <transition activity="PopupInput_1" commented="0" originalStyle="" points="" sourceX="242" sourceY="246" status="0" style="defaultEdge" targetX="381" targetY="122" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1487718615230" description="returns a message to the caller of the workflow" displayName="RespondToCaller" height="17" interactive="0" jobMode="0" name="GenericResponse" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.GenericResponse" uniqueName="GenericResponse_3" waitSetting="0" width="127" x="534" y="423">

        <inputs val="&lt;inputs>&lt;errorCode class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>0&lt;/errorCode>&lt;errorMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/inputs>"/>

        <transition activity="Download_and_Install_Updates_1" commented="0" originalStyle="" points="" sourceX="410" sourceY="431" status="0" style="defaultEdge" targetX="354" targetY="484" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1487718778248" description="" displayName="Inform User" height="21" interactive="0" jobMode="0" name="InformationalMessage" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.InteractiveMessageActivity;align=center" uniqueName="InformationalMessage_4" waitSetting="0" width="99" x="831" y="60">

        <inputs val="&lt;inputs>&lt;message>CommServ and all the clients will be scheduled to be upgraded to Commvault Vxpath:{/workflow/CommServDBQuery_1/resultSets[1]/row[1]/col[1]} at xpath:{/workflow/variables/sched_date_time} xpath:{/workflow/variables/sched_time_str}&lt;/message>&lt;dialogType>Popup&lt;/dialogType>&lt;iconType>Information&lt;/iconType>&lt;title>Review&lt;/title>&lt;html>false&lt;/html>&lt;actions>&lt;name>Cancel&lt;/name>&lt;validateForm>true&lt;/validateForm>&lt;/actions>&lt;actions>&lt;name>Submit&lt;/name>&lt;validateForm>true&lt;/validateForm>&lt;/actions>&lt;formProperties />&lt;/inputs>"/>

        <activitySchema>

            <outputs name="outputs">

                <children className="java.lang.String" inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string"/>

            </outputs>

            <inputs className="" defaultValue="" listType="0" name="inputs" type=""/>

        </activitySchema>

        <transition activity="GenericResponse_2" commented="0" displayName="Submit" originalStyle="" points="" sourceX="603" sourceY="97" status="0" style="defaultEdge" targetX="772" targetY="53" transitionIndex="0" x="0" y="0">

            <condition language="1" script="xpath:{/workflow/InformationalMessage_4/actionSelected}.equals(&quot;Submit&quot;);"/>

        </transition>

        <transition activity="WorkflowEnd_10" commented="0" displayName="Cancel" originalStyle="" points="" sourceX="609" sourceY="41" status="0" style="defaultEdge" targetX="515" targetY="233" transitionIndex="0" x="0" y="0">

            <condition language="1" script="!xpath:{/workflow/InformationalMessage_4/actionSelected}.equals(&quot;Submit&quot;);"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1504001269081" description="executes queries against a commcell database" displayName="CommServDBQuery" height="34" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_2" waitSetting="0" width="143" x="43" y="416">

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>;with DATA(taskID, subTaskID) as&amp;#xD;&#xd;&#xa;(&amp;#xD;&#xd;&#xa;select T.taskId, ST.subTaskId from TM_Task T&amp;#xD;&#xd;&#xa;INNER JOIN TM_SubTask ST&amp;#xD;&#xd;&#xa;ON T.taskId = ST.taskId&amp;#xD;&#xd;&#xa;where ST.operationType=2001 and t.deleted =0 and t.disabled = 0 and ST.subTaskName is not null and t.defaultTask = 0&amp;#xD;&#xd;&#xa;)&amp;#xD;&#xd;&#xa;select &amp;#xD;&#xd;&#xa;    case &amp;#xD;&#xd;&#xa;&#x9;&#x9;when COUNT(*) &amp;gt; 0 then 1&amp;#xD;&#xd;&#xa;&#x9;&#x9;when COUNT(*) = 0 then 0&amp;#xD;&#xd;&#xa;    END&#x9;&#x9;&#x9;&amp;#xD;&#xd;&#xa;from DATA;&amp;#xD;&#xd;&#xa;&lt;/query>&lt;/inputs>"/>

        <transition activity="Decision_1" commented="0" originalStyle="" points="" sourceX="114" sourceY="433" status="0" style="defaultEdge" targetX="297" targetY="186" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1504001375732" description="if/else based decision" displayName="Check if schedule already exists" height="55" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1" uniqueName="Decision_2" waitSetting="0" width="200" x="238" y="58">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/CommServDBQuery_2/resultSets[1]/row[1]/col[1]} == 1&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="CommServDBQuery_3" commented="0" displayName="Schedule Exists" originalStyle="" points="" sourceX="338" sourceY="85" status="0" style="defaultEdge" targetX="481" targetY="145" transitionIndex="0" value="true" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="PopupInput_4" commented="0" displayName="No Schedule" originalStyle="" points="" sourceX="338" sourceY="85" status="0" style="defaultEdge" targetX="516" targetY="57" transitionIndex="0" value="false" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1504010680432" description="executes queries against a commcell database" displayName="CommServDBQuery" height="34" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_3" waitSetting="0" width="143" x="479" y="122">

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>SELECT TOP 1 S.subTaskName,R.nextRunTime &amp;#xD;&#xd;&#xa;FROM TM_SubTask S&amp;#xD;&#xd;&#xa;INNER JOIN TM_PatternAssoc A&amp;#xD;&#xd;&#xa;ON S.subTaskId = A.subTaskId&amp;#xD;&#xd;&#xa;INNER JOIN TM_RunTime R &amp;#xD;&#xd;&#xa;ON A.patternId = R.patternId&amp;#xD;&#xd;&#xa;INNER JOIN TM_Task T&amp;#xD;&#xd;&#xa;ON T.taskId = S.taskId&amp;#xD;&#xd;&#xa;WHERE R.nextRunTime &amp;gt; GETDATE()&amp;#xD;&#xd;&#xa;AND S.operationType=2001 &amp;#xD;&#xd;&#xa;AND T.defaultTask = 0&amp;#xD;&#xd;&#xa;AND T.deleted = 0 &amp;#xD;&#xd;&#xa;AND T.disabled = 0&amp;#xD;&#xd;&#xa;ORDER BY R.nextRunTime ASC&lt;/query>&lt;/inputs>"/>

        <transition activity="InformationalMessage_5" commented="0" originalStyle="" points="" sourceX="550" sourceY="139" status="0" style="defaultEdge" targetX="547" targetY="202" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1504001561252" description="" displayName="Inform User" height="21" interactive="0" jobMode="0" name="InformationalMessage" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.InteractiveMessageActivity;align=center" uniqueName="InformationalMessage_5" waitSetting="0" width="99" x="482" y="196">

        <inputs val="&lt;inputs>&lt;message>Schedule Name: xpath:{/workflow/CommServDBQuery_3/resultSets[1]/row[1]/col[1]}&amp;#xD;&#xd;&#xa;Next Job On: xpath:{/workflow/CommServDBQuery_3/resultSets[1]/row[1]/col[2]}&lt;/message>&lt;dialogType>Popup&lt;/dialogType>&lt;iconType>Information&lt;/iconType>&lt;title>Schedule already exists&lt;/title>&lt;html>false&lt;/html>&lt;actions>&lt;name>Ok&lt;/name>&lt;validateForm>true&lt;/validateForm>&lt;/actions>&lt;formProperties>&amp;lt;?xml version=&apos;1.0&apos; encoding=&apos;UTF-8&apos;?&amp;gt;&amp;lt;Workflow_FormProperties css=&quot;&quot; javaScript=&quot;&quot; formVersion=&quot;0&quot; /&amp;gt;&lt;/formProperties>&lt;/inputs>"/>

        <activitySchema>

            <outputs name="outputs">

                <children className="java.lang.String" inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string"/>

            </outputs>

            <inputs className="" defaultValue="" listType="0" name="inputs" type=""/>

        </activitySchema>

        <transition activity="WorkflowEnd_10" commented="0" originalStyle="" points="" sourceX="531" sourceY="206" status="0" style="defaultEdge" targetX="743" targetY="277" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

</workflow>'

IF not exists (select * from WF_Definition where Name = @name)

BEGIN
	INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision, uniqueGuid)


	VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision, @guid)

	SET @workflowId = @@IDENTITY
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


	VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

	SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = revision From WF_Definition WHERE Name = @name

	-- IF (@currentFlags & 4 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0) AND (@currentRevision <> @revision)

	BEGIN

		SET @version = @version + 1

		UPDATE WF_Definition

		SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision, uniqueGuid = @guid

		WHERE Name = @name

		--IF (@flags & 8 > 0 OR @flags & 16 > 0)

		BEGIN

			UPDATE WF_Definition

			SET flags = @flags

			WHERE Name = @name

		END
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


		VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

	END

END

