

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_InstallAutoDiscoveredApps.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/ 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/WFD_InstallAutoDiscoveredApps.script,v $ $Id: WFD_InstallAutoDiscoveredApps.script,v 1.1.2.8 2020/10/04 01:04:44 abilbrey Exp $";
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER ON

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.1.2.8 $'

SET @name = 'InstallAutoDiscoveredApps'

SET @description = 'Work flow to Install Commvault packages of auto discovered applications'

SET @version = 1

SET @flags = 6

SET @definition = '<workflow apiMode="0" config="&lt;configuration />"

    description="Work flow to Install Commvault packages of auto discovered applications"

    inputs="&lt;inputs>&lt;ClientGroup class=&quot;commvault.msgs.CvEntities.ClientGroupEntity&quot; _list_=&quot;false&quot;>&lt;clientGroupName />&lt;clientGroupId />&lt;/ClientGroup>&lt;ClientName class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>&lt;clientName />&lt;clientId />&lt;/ClientName>&lt;/inputs>"

    interactive="0" isHtmlDescription="0"

    name="InstallAutoDiscoveredApps" outputs="&lt;outputs />"

    revision="$Revision: 1.1.2.8 $"

    uniqueGuid="4571c786-48f0-436c-8945-e849f00d1600"

    variables="&lt;variables>&lt;sInstallXML class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&amp;lt;?xml version=&quot;1.0&quot; encoding=&quot;UTF-8&quot; standalone=&quot;no&quot; ?&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;TMMsg_CreateTaskReq&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;taskInfo&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;associations&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;clientName&amp;gt;TargetVirtualMachine&amp;lt;/clientName&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;clientSidePackage&amp;gt;true&amp;lt;/clientSidePackage&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;consumeLicense&amp;gt;true&amp;lt;/consumeLicense&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;type&amp;gt;GALAXY&amp;lt;/type&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/associations&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;subTasks&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;options&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;adminOpts&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;clientInstallOption&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;clientAuthForJob/&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;clientDetails&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;clientEntity&amp;gt;&amp;#xD;&#xd;&#xa;                &amp;lt;clientName&amp;gt;TargetVirtualMachine&amp;lt;/clientName&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;/clientEntity&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;/clientDetails&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;discoveryType&amp;gt;MANUAL&amp;lt;/discoveryType&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;installOSType&amp;gt;OSVERSION&amp;lt;/installOSType&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;installerOption&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;CommServeHostName&amp;gt;SourceCSName&amp;lt;/CommServeHostName&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;CommServeInfo/&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;Operationtype&amp;gt;INSTALL_CLIENT&amp;lt;/Operationtype&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;RemoteClient&amp;gt;false&amp;lt;/RemoteClient&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;User&amp;gt;&amp;#xD;&#xd;&#xa;                &amp;lt;userName&amp;gt;Admin&amp;lt;/userName&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;/User&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;clientComposition&amp;gt;&amp;#xD;&#xd;&#xa;                &amp;lt;clientInfo&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;client&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;cvdPort&amp;gt;0&amp;lt;/cvdPort&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;/client&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;clientProps/&amp;gt;&amp;#xD;&#xd;&#xa;                &amp;lt;/clientInfo&amp;gt;&amp;#xD;&#xd;&#xa;                &amp;lt;components&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;activeDirectory&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;userAccount&amp;gt;&amp;#xD;&#xd;&#xa;                      &amp;lt;userName&amp;gt;&amp;lt;/userName&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;/userAccount&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;/activeDirectory&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;commonInfo&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;storagePolicyToUse/&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;/commonInfo&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;!--ORACLE Starts--&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;componentInfo&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;ComponentName&amp;gt;iDA for Oracle&amp;lt;/ComponentName&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;clientSidePackage&amp;gt;true&amp;lt;/clientSidePackage&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;consumeLicense&amp;gt;true&amp;lt;/consumeLicense&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;installCommand&amp;gt;&amp;lt;/installCommand&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;osType&amp;gt;OSVERSION&amp;lt;/osType&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;postInstallCommand&amp;gt;&amp;lt;/postInstallCommand&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;unInstallCommand&amp;gt;&amp;lt;/unInstallCommand&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;/componentInfo&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;!--ORACLE Ends--&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;!--SQL Starts--&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;componentInfo&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;ComponentName&amp;gt;iDA for MSSQL Server&amp;lt;/ComponentName&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;clientSidePackage&amp;gt;true&amp;lt;/clientSidePackage&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;consumeLicense&amp;gt;true&amp;lt;/consumeLicense&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;installCommand&amp;gt;&amp;lt;/installCommand&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;osType&amp;gt;OSVERSION&amp;lt;/osType&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;postInstallCommand&amp;gt;&amp;lt;/postInstallCommand&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;unInstallCommand&amp;gt;&amp;lt;/unInstallCommand&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;/componentInfo&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;!--SQL Ends--&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;!--Exchange Starts--&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;componentInfo&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;ComponentName&amp;gt;iDA for Exchange Database&amp;lt;/ComponentName&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;clientSidePackage&amp;gt;true&amp;lt;/clientSidePackage&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;consumeLicense&amp;gt;true&amp;lt;/consumeLicense&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;installCommand&amp;gt;&amp;lt;/installCommand&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;osType&amp;gt;OSVERSION&amp;lt;/osType&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;postInstallCommand&amp;gt;&amp;lt;/postInstallCommand&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;unInstallCommand&amp;gt;&amp;lt;/unInstallCommand&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;/componentInfo&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;!--Exchange Ends--&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;!--ActiveDirectory Starts--&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;componentInfo&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;ComponentName&amp;gt;iDA for Active Directory&amp;lt;/ComponentName&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;clientSidePackage&amp;gt;true&amp;lt;/clientSidePackage&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;consumeLicense&amp;gt;true&amp;lt;/consumeLicense&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;installCommand&amp;gt;&amp;lt;/installCommand&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;osType&amp;gt;OSVERSION&amp;lt;/osType&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;postInstallCommand&amp;gt;&amp;lt;/postInstallCommand&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;unInstallCommand&amp;gt;&amp;lt;/unInstallCommand&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;/componentInfo&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;!--ActiveDirectory Ends--&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;!--DB2 Starts--&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;componentInfo&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;ComponentName&amp;gt;iDA for DB2&amp;lt;/ComponentName&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;clientSidePackage&amp;gt;true&amp;lt;/clientSidePackage&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;consumeLicense&amp;gt;true&amp;lt;/consumeLicense&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;installCommand&amp;gt;&amp;lt;/installCommand&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;osType&amp;gt;OSVERSION&amp;lt;/osType&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;postInstallCommand&amp;gt;&amp;lt;/postInstallCommand&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;unInstallCommand&amp;gt;&amp;lt;/unInstallCommand&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;/componentInfo&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;contentIndexingEngine/&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;db2&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;db2ArchivePath&amp;gt;CV_DB2_ARCHIVE_PATH&amp;lt;/db2ArchivePath&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;db2AuditErrorPath&amp;gt;CV_DB2_AUDIT_ERROR_PATH&amp;lt;/db2AuditErrorPath&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;db2RetrievePath&amp;gt;CV_DB2_RETRIEVE_PATH&amp;lt;/db2RetrievePath&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;/db2&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;!--DB2 Ends--&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;!--PostgreSQL Starts--&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;componentInfo&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;ComponentName&amp;gt;PostgreSQL iDataAgent&amp;lt;/ComponentName&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;clientSidePackage&amp;gt;true&amp;lt;/clientSidePackage&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;consumeLicense&amp;gt;true&amp;lt;/consumeLicense&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;installCommand&amp;gt;&amp;lt;/installCommand&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;osType&amp;gt;OSVERSION&amp;lt;/osType&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;postInstallCommand&amp;gt;&amp;lt;/postInstallCommand&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;unInstallCommand&amp;gt;&amp;lt;/unInstallCommand&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;/componentInfo&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;!--PostgreSQL Ends--&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;!--MySQL Starts--&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;componentInfo&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;ComponentName&amp;gt;MySQL iDataAgent&amp;lt;/ComponentName&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;clientSidePackage&amp;gt;true&amp;lt;/clientSidePackage&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;consumeLicense&amp;gt;true&amp;lt;/consumeLicense&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;installCommand&amp;gt;&amp;lt;/installCommand&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;osType&amp;gt;OSVERSION&amp;lt;/osType&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;postInstallCommand&amp;gt;&amp;lt;/postInstallCommand&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;unInstallCommand&amp;gt;&amp;lt;/unInstallCommand&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;/componentInfo&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;!--MySQL Ends--&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;!--Sybase Starts--&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;componentInfo&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;ComponentName&amp;gt;Sybase iDataAgent&amp;lt;/ComponentName&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;clientSidePackage&amp;gt;true&amp;lt;/clientSidePackage&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;consumeLicense&amp;gt;true&amp;lt;/consumeLicense&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;installCommand&amp;gt;&amp;lt;/installCommand&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;osType&amp;gt;OSVERSION&amp;lt;/osType&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;postInstallCommand&amp;gt;&amp;lt;/postInstallCommand&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;unInstallCommand&amp;gt;&amp;lt;/unInstallCommand&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;/componentInfo&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;!--Sybase Ends--&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;contentIndexingEngine/&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;exchangeDatabase&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;userAccount&amp;gt;&amp;#xD;&#xd;&#xa;                      &amp;lt;userName&amp;gt;&amp;lt;/userName&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;/userAccount&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;/exchangeDatabase&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;exchangeServer&amp;gt;&amp;#xD;&#xd;&#xa;                    &amp;lt;serverName&amp;gt;&amp;lt;/serverName&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;/exchangeServer&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;fileSystem/&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;mediaAgent/&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;sqlAgent/&amp;gt;&amp;#xD;&#xd;&#xa;                &amp;lt;/components&amp;gt;&amp;#xD;&#xd;&#xa;                &amp;lt;overrideSoftwareCache&amp;gt;false&amp;lt;/overrideSoftwareCache&amp;gt;&amp;#xD;&#xd;&#xa;                &amp;lt;packageDeliveryOption&amp;gt;CopyPackage&amp;lt;/packageDeliveryOption&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;/clientComposition&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;installFlags&amp;gt;&amp;#xD;&#xd;&#xa;                &amp;lt;advancedOptions&amp;gt;&amp;lt;/advancedOptions&amp;gt;&amp;#xD;&#xd;&#xa;                &amp;lt;allowMultipleInstances&amp;gt;false&amp;lt;/allowMultipleInstances&amp;gt;&amp;#xD;&#xd;&#xa;                &amp;lt;disableOSFirewall&amp;gt;false&amp;lt;/disableOSFirewall&amp;gt;&amp;#xD;&#xd;&#xa;                &amp;lt;firewallInstall&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;enableFirewallConfig&amp;gt;false&amp;lt;/enableFirewallConfig&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;firewallConnectionType&amp;gt;0&amp;lt;/firewallConnectionType&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;portNumber&amp;gt;0&amp;lt;/portNumber&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;proxyClientName&amp;gt;&amp;lt;/proxyClientName&amp;gt;&amp;#xD;&#xd;&#xa;                  &amp;lt;proxyHostName&amp;gt;&amp;lt;/proxyHostName&amp;gt;&amp;#xD;&#xd;&#xa;                &amp;lt;/firewallInstall&amp;gt;&amp;#xD;&#xd;&#xa;                &amp;lt;forceReboot&amp;gt;true&amp;lt;/forceReboot&amp;gt;&amp;#xD;&#xd;&#xa;                &amp;lt;ignoreJobsRunning&amp;gt;true&amp;lt;/ignoreJobsRunning&amp;gt;&amp;#xD;&#xd;&#xa;                &amp;lt;install32Base&amp;gt;false&amp;lt;/install32Base&amp;gt;&amp;#xD;&#xd;&#xa;                &amp;lt;killBrowserProcesses&amp;gt;true&amp;lt;/killBrowserProcesses&amp;gt;&amp;#xD;&#xd;&#xa;                &amp;lt;overrideClientInfo&amp;gt;true&amp;lt;/overrideClientInfo&amp;gt;&amp;#xD;&#xd;&#xa;                &amp;lt;restoreOnlyAgents&amp;gt;false&amp;lt;/restoreOnlyAgents&amp;gt;&amp;#xD;&#xd;&#xa;                &amp;lt;skipClientsOfCS&amp;gt;false&amp;lt;/skipClientsOfCS&amp;gt;&amp;#xD;&#xd;&#xa;                &amp;lt;stopOracleServices&amp;gt;false&amp;lt;/stopOracleServices&amp;gt;&amp;#xD;&#xd;&#xa;                &amp;lt;unixGroupAccess&amp;gt;7&amp;lt;/unixGroupAccess&amp;gt;&amp;#xD;&#xd;&#xa;                &amp;lt;unixOtherAccess&amp;gt;7&amp;lt;/unixOtherAccess&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;/installFlags&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;requestType&amp;gt;PRE_DECLARE_CLIENT&amp;lt;/requestType&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;/installerOption&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;/clientInstallOption&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;updateOption/&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;/adminOpts&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/options&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;subTask&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;operationType&amp;gt;INSTALL_CLIENT&amp;lt;/operationType&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;subTaskType&amp;gt;ADMIN&amp;lt;/subTaskType&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/subTask&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/subTasks&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;task&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;initiatedFrom&amp;gt;COMMANDLINE&amp;lt;/initiatedFrom&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;taskFlags&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;disabled&amp;gt;false&amp;lt;/disabled&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/taskFlags&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;!--Name of the task--&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;taskName&amp;gt;&amp;lt;/taskName&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;taskType&amp;gt;IMMEDIATE&amp;lt;/taskType&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/task&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;/taskInfo&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/TMMsg_CreateTaskReq&amp;gt;&amp;#xD;&#xd;&#xa;&lt;/sInstallXML>&lt;nPackageList class=&quot;java.lang.Integer&quot; _list_=&quot;true&quot; />&lt;InstallSuccess class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/InstallSuccess>&lt;FailedClientList class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;discoverOraInstance class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>0&lt;/discoverOraInstance>&lt;/variables>" workflowId="0">

<schema>

	<outputs className="" name="outputs" type=""/>

	<variables attribute="0" className="" name="variables" type="">

		<children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="sInstallXML" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

		<children attribute="0" className="java.lang.Integer"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0"

                inputType="java.lang.Integer" listType="1"

                name="nPackageList" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

		<children attribute="0" className="java.lang.Boolean"

                controlType="5" defaultValue="" displayName=""

                documentation="" hidden="0"

                inputType="java.lang.Boolean" listType="0"

                name="InstallSuccess" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

		<children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="FailedClientList" type="{http://www.w3.org/2001/XMLSchema}string"/>

		<children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" documentation=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="discoverOraInstance" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

	</variables>

	<inputs attribute="0" className="" name="inputs" type="">

		<children attribute="0"

                className="commvault.msgs.CvEntities.ClientGroupEntity"

                controlType="2" defaultValue="" displayName=""

                documentation="" hidden="0"

                inputType="commvault.msgs.CvEntities.ClientGroupEntity"

                listType="0" maximumValue="" minimumValue=""

                name="ClientGroup" readOnly="0" required="0"

                searchable="0" type="{commvault.msgs.CvEntities}ClientGroupEntity">

			<children attribute="0" className="java.lang.String"

                    defaultValue="" inputType="java.lang.String"

                    listType="0" name="clientGroupName" type="{http://www.w3.org/2001/XMLSchema}string"/>

			<children attribute="0" className="java.lang.Integer"

                    defaultValue="" inputType="java.lang.Integer"

                    listType="0" name="clientGroupId" type="{http://www.w3.org/2001/XMLSchema}integer"/>

		</children>

		<children attribute="0"

                className="commvault.msgs.CvEntities.ClientEntity"

                controlType="2" defaultValue="" displayName=""

                documentation="" hidden="0"

                inputType="commvault.msgs.CvEntities.ClientEntity"

                listType="0" maximumValue="" minimumValue=""

                name="ClientName" readOnly="0" required="0"

                searchable="0" type="{commvault.msgs.CvEntities}ClientEntity">

			<children attribute="0" className="java.lang.String"

                    defaultValue="" inputType="java.lang.String"

                    listType="0" name="clientName" type="{http://www.w3.org/2001/XMLSchema}string"/>

			<children attribute="0" className="java.lang.Integer"

                    defaultValue="" inputType="java.lang.Integer"

                    listType="0" name="clientId" type="{http://www.w3.org/2001/XMLSchema}integer"/>

		</children>

	</inputs>

	<config className="" name="" type=""/>

</schema>

<Start commented="0" continueOnFailure="0" created="0"

        description="" displayName="Start" height="36" interactive="0"

        jobMode="0" name="Start" originalStyle="" skipAttempt="0"

        style="image;image=/images/jgraphx/house.png"

        uniqueName="Start_1" waitSetting="0" width="55" x="222" y="19">

	<inputs val="&lt;inputs />"/>

	<transition activity="GetClients" commented="0" originalStyle=""

            points="" sourceX="249" sourceY="37" status="0"

            style="defaultEdge" targetX="253" targetY="132"

            transitionIndex="0" x="0" y="0">

		<condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

	</transition>

</Start>

<Activity commented="0" continueOnFailure="0"

        created="1459348311109"

        description="iterates a group of activities over a list of values"

        displayName="Iterate Each Client Part of Selected ClientGroup"

        height="420" interactive="0" jobMode="0" name="ForEach"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ForEach_1" waitSetting="0" width="1160" x="390" y="54">

	<inputs val="&lt;inputs>&lt;name class=&quot;java.lang.String&quot;>row&lt;/name>&lt;values class=&quot;java.lang.Object&quot; _list_=&quot;false&quot;>xpath:{/workflow/GetClients/resultSets[1]/row}&lt;/values>&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>5&lt;/numberOfParallelExecutions>&lt;continueOnFailure class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/continueOnFailure>&lt;/inputs>"/>

		<superProcess>

			<Start commented="0" continueOnFailure="0"

                created="1459348311109" description=""

                displayName="Start" height="30" interactive="0"

                jobMode="0" name="Start" originalStyle=""

                skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_2" waitSetting="0" width="120" x="23" y="40">

				<inputs val="&lt;inputs />"/>

				<transition activity="AcquireLock_1" commented="0"

                    originalStyle="" points="" sourceX="83" sourceY="55"

                    status="0" style="defaultEdge" targetX="83"

                    targetY="129" transitionIndex="0" x="0" y="0">

					<condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

				</transition>

			</Start>

			<Activity commented="0" continueOnFailure="0"

                created="1459348494241"

                description="executes queries against a commcell database"

                displayName="Collect Application List" height="34"

                interactive="0" jobMode="0" name="CommServDBQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=CommServDBQuery"

                uniqueName="CollectAppList" waitSetting="0" width="159"

                x="11" y="220">

				<inputs val="&lt;inputs>&lt;commCell />&lt;query>SELECT distinct appTypeId from APP_IDAName WITH (NOLOCK) &amp;#xD;&#xd;&#xa;WHERE clientId in ( select id from app_client WITH (NOLOCK)  where name =''xpath:{/workflow/ForEach_1/row/col}'')  &amp;#xD;&#xd;&#xa;AND (status &amp;amp; 134217728) =  134217728    -- AUTO DISCOVER FLAG&amp;#xD;&#xd;&#xa;AND (status &amp;amp; 2 ) = 2                    -- UNINSTALL FLAG&amp;#xD;&#xd;&#xa;AND (status &amp;amp; 268435456) != 268435456    -- AUTO INSTALLED FLAG - If auto installed during previous attempt, ignore.&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;select Type from  simOperatingSystem WITH (NOLOCK)  where id in &amp;#xD;&#xd;&#xa;(select simOperatingSystemiD from app_client WITH (NOLOCK) where name = ''xpath:{/workflow/ForEach_1/row/col}'')&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;select jobResultDir from app_client WITH (NOLOCK) where name =''xpath:{/workflow/ForEach_1/row/col}''&lt;/query>&lt;/inputs>"/>

					<transition activity="Decision_1" commented="0"

                    originalStyle="" points="" sourceX="261"

                    sourceY="102" status="0" style="defaultEdge"

                    targetX="412" targetY="106" transitionIndex="0"

                    x="0" y="0">

						<condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

					</transition>

				</Activity>

				<Activity commented="0" continueOnFailure="0"

                created="1459388956969"

                description="activity to execute code snippets in the selected language"

                displayName="Prepare ClientInstall File" height="34"

                interactive="0" jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Script" uniqueName="Script_3"

                waitSetting="0" width="167" x="222" y="262">

					<inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;Map hInstallDetails = new HashMap();&amp;#xD;&amp;#xA;hInstallDetails.put(81, &amp;quot;SQL&amp;quot;);&amp;#xD;&amp;#xA;hInstallDetails.put(22, &amp;quot;ORACLE&amp;quot;);&amp;#xD;&amp;#xA;hInstallDetails.put(41, &amp;quot;ActiveDirectory&amp;quot;);&amp;#xD;&amp;#xA;hInstallDetails.put(51, &amp;quot;MediaAgent&amp;quot;);&amp;#xD;&amp;#xA;hInstallDetails.put(53, &amp;quot;Exchange&amp;quot;);&amp;#xD;&amp;#xA;hInstallDetails.put(37, &amp;quot;DB2&amp;quot;);&amp;#xD;&amp;#xA;hInstallDetails.put(125, &amp;quot;PostgreSQL&amp;quot;);&amp;#xD;&amp;#xA;hInstallDetails.put(104, &amp;quot;MySQL&amp;quot;);&amp;#xD;&amp;#xA;hInstallDetails.put(5, &amp;quot;Sybase&amp;quot;);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;nPackageList = workflow.getObject(&amp;quot;/workflow/CollectAppList/resultSets[1]/row/col[1]&amp;quot;, ArrayList.class);&amp;#xD;&amp;#xA;String sClientOSType = xpath:{ / workflow / CollectAppList / resultSets[2] / row / col[1]};&amp;#xD;&amp;#xA;String sJobResultsDir = xpath:{ / workflow / CollectAppList / resultSets[3] / row / col[1]};&amp;#xD;&amp;#xA;String sDelimiter = &amp;quot;/&amp;quot; ;&amp;#xD;&amp;#xA;sClientOSType = sClientOSType.toUpperCase();&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;logger.info(&amp;quot;OSType-&amp;gt; &amp;quot; + sClientOSType);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;String sMachineName = xpath:{/workflow/ForEach_1/row/col};&amp;#xD;&amp;#xA;String sModifiedXML = xpath:{ / workflow / variables / sInstallXML};&amp;#xD;&amp;#xA;String sCSName = xpath:{ / workflow / system / commCellName};&amp;#xD;&amp;#xA;String sInstallFileName =  xpath:{ / workflow / GetClients / resultSets[2] /row / col[1]}+  &amp;quot;/&amp;quot; + &amp;quot;Temp&amp;quot; + &amp;quot;/&amp;quot; + xpath:{/workflow/ForEach_1/row/col} + &amp;quot;-InstallFile.xml&amp;quot;;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;// Same package ID, but installer expects different component Name for Windows/UNIX&amp;#xD;&amp;#xA;if (sClientOSType.equalsIgnoreCase(&amp;quot;UNIX&amp;quot;))&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    sDelimiter = &amp;quot;/&amp;quot;;&amp;#xD;&amp;#xA;    sModifiedXML = sModifiedXML.replaceAll(&amp;quot;iDA for Oracle&amp;quot;, &amp;quot;Oracle Agent&amp;quot;);&amp;#xD;&amp;#xA;    sModifiedXML = sModifiedXML.replaceAll(&amp;quot;iDA for DB2&amp;quot;, &amp;quot;DB2 Agent&amp;quot;);&amp;#xD;&amp;#xA;    sModifiedXML = sModifiedXML.replaceAll(&amp;quot;PostgreSQL iDataAgent&amp;quot;, &amp;quot;Postgre SQL Agent&amp;quot;);&amp;#xD;&amp;#xA;    sModifiedXML = sModifiedXML.replaceAll(&amp;quot;MySQL iDataAgent&amp;quot;, &amp;quot;MySQL Agent&amp;quot;);&amp;#xD;&amp;#xA;    sModifiedXML = sModifiedXML.replaceAll(&amp;quot;Sybase iDataAgent&amp;quot;, &amp;quot;Sybase Agent&amp;quot;);&amp;#xD;&amp;#xA;   &amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;else&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    sDelimiter = &amp;quot;\\\\&amp;quot;;&amp;#xD;&amp;#xA;    sModifiedXML = sModifiedXML.replaceAll(&amp;quot;&amp;lt;unixGroup/&amp;gt;&amp;quot;, &amp;quot;&amp;lt;!-- &amp;lt;unixGroup/&amp;gt; --&amp;gt;&amp;quot;);&amp;#xD;&amp;#xA;    sModifiedXML = sModifiedXML.replaceAll(&amp;quot;&amp;lt;unixGroupAccess&amp;gt;7&amp;lt;/unixGroupAccess&amp;gt;&amp;quot;, &amp;quot;&amp;lt;!-- &amp;lt;unixGroupAccess&amp;gt;7&amp;lt;/unixGroupAccess&amp;gt; --&amp;gt;&amp;quot;);&amp;#xD;&amp;#xA;    sModifiedXML = sModifiedXML.replaceAll(&amp;quot;&amp;lt;unixOtherAccess&amp;gt;7&amp;lt;/unixOtherAccess&amp;gt;&amp;quot;, &amp;quot;&amp;lt;!-- &amp;lt;unixOtherAccess&amp;gt;7&amp;lt;/unixOtherAccess&amp;gt; --&amp;gt;&amp;quot;);&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;sJobResultsDir = sJobResultsDir.replace(&amp;quot;\\&amp;quot;,&amp;quot;\\\\&amp;quot;);&amp;#xD;&amp;#xA;/* Common Section */&amp;#xD;&amp;#xA;sModifiedXML = sModifiedXML.replaceAll(&amp;quot;OSVERSION&amp;quot;, sClientOSType);&amp;#xD;&amp;#xA;sModifiedXML = sModifiedXML.replaceAll(&amp;quot;TargetVirtualMachine&amp;quot;, sMachineName);&amp;#xD;&amp;#xA;sModifiedXML = sModifiedXML.replaceAll(&amp;quot;TargetMachineName&amp;quot;, sMachineName);&amp;#xD;&amp;#xA;sModifiedXML = sModifiedXML.replaceAll(&amp;quot;SourceCSName&amp;quot;, sCSName);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;/* DB2 Install Input Params*/&amp;#xD;&amp;#xA;sModifiedXML = sModifiedXML.replaceAll(&amp;quot;CV_DB2_ARCHIVE_PATH&amp;quot;, sJobResultsDir + sDelimiter + &amp;quot;DB2_ARCHIVE_PATH&amp;quot;);&amp;#xD;&amp;#xA;sModifiedXML = sModifiedXML.replaceAll(&amp;quot;CV_DB2_AUDIT_ERROR_PATH&amp;quot;, sJobResultsDir +sDelimiter + &amp;quot;DB2_AUDIT_ERROR_PATH&amp;quot;);&amp;#xD;&amp;#xA;sModifiedXML = sModifiedXML.replaceAll(&amp;quot;CV_DB2_RETRIEVE_PATH&amp;quot;, sJobResultsDir + sDelimiter + &amp;quot;DB2_RETRIEVE_PATH&amp;quot;);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;String sCommentStartTag = &amp;quot;&amp;lt;!--&amp;quot;;&amp;#xD;&amp;#xA;String sCommentEndTag = &amp;quot;--&amp;gt;&amp;quot;;&amp;#xD;&amp;#xA;String sMatchingTag, sReplaceTag;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;Iterator entry = hInstallDetails.entrySet().iterator();&amp;#xD;&amp;#xA;while (entry.hasNext())&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;&amp;#x9;Map.Entry next = entry.next();&amp;#xD;&amp;#xA;&amp;#x9;Integer nKey = next.getKey();&amp;#xD;&amp;#xA;&amp;#x9;String sValue = next.getValue();&amp;#xD;&amp;#xA;&amp;#x9;String output = &amp;quot;Package ID &amp;quot; + nKey + &amp;quot; Package Name -&amp;gt; &amp;quot; + sValue;&amp;#xD;&amp;#xA;&amp;#x9;logger.info(output);&amp;#xD;&amp;#xA;&amp;#x9;if (nPackageList.indexOf(nKey) == -1)&amp;#xD;&amp;#xA;&amp;#x9;{&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;logger.info(&amp;quot;Commenting Package -&amp;gt; &amp;quot; + sValue);&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;sMatchingTag = sCommentStartTag + sValue + &amp;quot; Starts&amp;quot; + sCommentEndTag;&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;sReplaceTag = sMatchingTag + sCommentStartTag;&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;sModifiedXML = sModifiedXML.replaceAll(sMatchingTag, sReplaceTag);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;sMatchingTag = sCommentStartTag + sValue + &amp;quot; Ends&amp;quot; + sCommentEndTag;&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;sReplaceTag = sCommentEndTag + sMatchingTag;&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;sModifiedXML = sModifiedXML.replaceAll(sMatchingTag, sReplaceTag);&amp;#xD;&amp;#xA;&amp;#x9;}&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;File newTextFile = new File(sInstallFileName);&amp;#xD;&amp;#xA;FileWriter fw = new FileWriter(newTextFile);&amp;#xD;&amp;#xA;fw.write(sModifiedXML);&amp;#xD;&amp;#xA;fw.close();&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;//logger.info(sModifiedXML);&amp;#xD;&amp;#xA;return sModifiedXML;&quot; />&lt;/inputs>"/>

						<transition activity="SubmitJob" commented="0"

                    originalStyle="" points="" sourceX="674"

                    sourceY="103" status="0" style="defaultEdge"

                    targetX="931" targetY="119" transitionIndex="0"

                    x="0" y="0">

							<condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

						</transition>

					</Activity>

					<Activity commented="0" continueOnFailure="0"

                created="1459449076676" description=""

                displayName="Submit Job" height="34" interactive="0"

                jobMode="0" name="Execute"

                namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                originalStyle="" skipAttempt="0"

                style="label;image=Execute" uniqueName="SubmitJob"

                waitSetting="0" width="100" x="256" y="344">

						<onExit language="1" script="try {&#xd;&#xa; //   String sInstallXMLFile = &quot;C:/&quot; + xpath:{/workflow/ForEach_1/row/col} + &quot;InstallFile.xml&quot;;&#xd;&#xa;  //  Files.delete(sInstallXMLFile);&#xd;&#xa;} &#xd;&#xa;catch (FileNotFoundException e) {&#xd;&#xa;            //do something clever with the exception&#xd;&#xa;        } catch (IOException e) {&#xd;&#xa;            //do something clever with the exception&#xd;&#xa;        }"/>

						<inputs val="&lt;inputs>&lt;inputXml class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;commandArgs class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>-af &quot;xpath:{ / workflow / GetClients / resultSets[2] /row / col[1]}/Temp/xpath:{/workflow/ForEach_1/row/col}-InstallFile.xml&quot;&lt;/commandArgs>&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/sessionOptions>&lt;escapeXml class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/escapeXml>&lt;/inputs>"/>

							<transition activity="XPathQuery_1" commented="0"

                    originalStyle="" points="" sourceX="291"

                    sourceY="254" status="0" style="defaultEdge"

                    targetX="415" targetY="253" transitionIndex="0"

                    x="0" y="0">

								<condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

							</transition>

							<transition activity="Script_3" commented="0"

                    originalStyle="" points="" sourceX="306"

                    sourceY="361" status="0" style="defaultEdge"

                    targetX="307" targetY="283" transitionIndex="0"

                    x="0" y="0">

								<condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

							</transition>

							<onEnter language="1" script="String sInstallXMLFile = xpath:{/workflow/GetClients/resultSets[2]/row}+  &quot;/&quot; + &quot;Temp&quot; + &quot;/&quot; + xpath:{/workflow/ForEach_1/row/col} + &quot;-InstallFile.xml&quot;;&#xd;&#xa;logger.info(&quot;Install xml present in -> &quot; + sInstallXMLFile);"/>

							</Activity>

							<Activity commented="0" continueOnFailure="0"

                created="1459542350788"

                description="if/else based decision"

                displayName="Is Install Needed?" height="100"

                interactive="0" jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_1"

                waitSetting="0" width="130" x="240" y="27">

								<inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/CollectAppList/resultSets[1]/rowCount}!=0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

									<transition activity="Script_4" commented="0"

                    displayName="NO" originalStyle="" points=""

                    sourceX="476" sourceY="105" status="0"

                    style="defaultEdge" targetX="475" targetY="241"

                    transitionIndex="0" value="false" x="0" y="0">

										<condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

									</transition>

									<transition activity="CacheAppIDS" commented="0"

                    displayName="YES" originalStyle="" points=""

                    sourceX="293" sourceY="80" status="0"

                    style="defaultEdge" targetX="394" targetY="137"

                    transitionIndex="0" value="true" x="0" y="0">

										<condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

									</transition>

								</Activity>

								<Activity commented="0" continueOnFailure="0"

                created="1459799891157"

                description="activity to execute code snippets in the selected language"

                displayName="Nothing to install" height="34"

                interactive="0" jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Script" uniqueName="Script_4"

                waitSetting="0" width="124" x="416" y="31">

									<inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;logger.info(&amp;quot;No package needed for client&amp;quot; + xpath:{/workflow/ForEach_1/row/col});&quot; />&lt;/inputs>"/>

									</Activity>

									<Activity commented="0" continueOnFailure="0"

                created="1459800002372"

                description="retrieves a list of values from xml"

                displayName="Get Job Id" height="34" interactive="0"

                jobMode="0" name="XPathQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=XPathQuery" uniqueName="XPathQuery_1"

                waitSetting="0" width="100" x="440" y="224">

										<inputs val="&lt;inputs>&lt;xml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/SubmitJob/outputXml}&lt;/xml>&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>/TMMsg_CreateTaskResp/jobIds[1]/@val&lt;/xpath>&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;>Integer&lt;/outputType>&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/outputAsList>&lt;/inputs>"/>

											<transition activity="WaitForJobCompletion_1"

                    commented="0" originalStyle="" points="500.0,171.0"

                    sourceX="426" sourceY="255" status="0"

                    style="defaultEdge" targetX="612" targetY="256"

                    transitionIndex="0" x="0" y="0">

												<condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

											</transition>

										</Activity>

										<Activity commented="0" continueOnFailure="0"

                created="1459800177606"

                description="waits until the list of jobs completes"

                displayName="WaitForJobCompletion" height="34"

                interactive="0" jobMode="0" name="WaitForJobCompletion"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=WaitForJobCompletion"

                uniqueName="WaitForJobCompletion_1" waitSetting="0"

                width="159" x="533" y="72">

											<inputs val="&lt;inputs>&lt;jobId class=&quot;java.lang.Integer&quot; _list_=&quot;true&quot;>xpath:{/workflow/XPathQuery_1/result}&lt;/jobId>&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

												<transition activity="Decision_2" commented="0"

                    originalStyle="" points="" sourceX="612"

                    sourceY="89" status="0" style="defaultEdge"

                    targetX="623" targetY="184" transitionIndex="0"

                    x="0" y="0">

													<condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

												</transition>

											</Activity>

											<Activity commented="0" continueOnFailure="0"

                created="1464277684563"

                description="if/else based decision"

                displayName="Did Job complete?" height="100"

                interactive="0" jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_2"

                waitSetting="0" width="135" x="556" y="134">

												<inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/WaitForJobCompletion_1/successful} == true&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

													<transition activity="CommServDBQuery_1" commented="0"

                    displayName="Yes" originalStyle="" points=""

                    sourceX="623" sourceY="184" status="0"

                    style="defaultEdge" targetX="642" targetY="283"

                    transitionIndex="0" value="true" x="0" y="0">

														<condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

													</transition>

													<transition activity="LogEvent_1" commented="0"

                    displayName="No" originalStyle="" points=""

                    sourceX="606" sourceY="184" status="0"

                    style="defaultEdge" targetX="690" targetY="220"

                    transitionIndex="0" value="false" x="0" y="0">

														<condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

													</transition>

												</Activity>

												<Activity commented="0" continueOnFailure="0"

                created="1464277862633"

                description="executes queries against a commcell database"

                displayName="Update Package Status" height="34"

                interactive="0" jobMode="0" name="CommServDBQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=CommServDBQuery"

                uniqueName="CommServDBQuery_1" waitSetting="0"

                width="163" x="561" y="266">

													<inputs val="&lt;inputs>&lt;commCell />&lt;query>UPDATE app_idaName set status = status | 268435456&amp;#xD;&#xd;&#xa;WHERE&amp;#xD;&#xd;&#xa;clientId in (select id from app_client WITH (NOLOCK)  WHERE name = ''xpath:{/workflow/ForEach_1/row/col}'' ) &amp;#xD;&#xd;&#xa;AND status = 0&amp;#xD;&#xd;&#xa;AND appTypeId in ( select DATA from dbo.SplitString(''xpath:{/workflow/CacheAppIDS/output}'','','') )&lt;/query>&lt;/inputs>"/>

														<transition activity="Script_5" commented="0"

                    originalStyle="" points="" sourceX="642"

                    sourceY="283" status="0" style="defaultEdge"

                    targetX="628" targetY="333" transitionIndex="0"

                    x="0" y="0">

															<condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

														</transition>

													</Activity>

													<Activity commented="0" continueOnFailure="0"

                created="1464278458388"

                description="logs an event in the commcell console with the specified severity level"

                displayName="Install Failed" height="34" interactive="0"

                jobMode="0" name="LogEvent"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=LogEvent" uniqueName="LogEvent_1"

                waitSetting="0" width="103" x="724" y="132">

														<onExit language="1" script="//logger.info(&quot;Submitted Job failed for Client &quot; + ''xpath:{/workflow/ForEach_1/row/col}'' );"/>

														<inputs val="&lt;inputs>&lt;severity class=&quot;workflow.types.SeverityLevel&quot; _list_=&quot;false&quot;>INFO&lt;/severity>&lt;message class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/inputs>"/>

															<onEnter language="1" script="String clientList = workflow.getVariable(&quot;FailedClientList&quot;);&#xd;&#xa;if(clientList.length() > 0 )&#xd;&#xa;{&#xd;&#xa;    clientList = clientList + &quot;,&quot;;&#xd;&#xa;}&#xd;&#xa;workflow.setVariable(&quot;InstallSuccess&quot;,false);&#xd;&#xa;clientList = clientList + xpath:{/workflow/ForEach_1/row/col};&#xd;&#xa;workflow.setVariable(&quot;FailedClientList&quot;,clientList);&#xd;&#xa;"/>

															</Activity>

															<Activity commented="0" continueOnFailure="0"

                created="1464380213788"

                description="activity to execute code snippets in the selected language"

                displayName="Cache Application IDs" height="34"

                interactive="0" jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Script" uniqueName="CacheAppIDS"

                waitSetting="0" width="153" x="228" y="178">

																<inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;nPackageList = workflow.getObject(&amp;quot;/workflow/CollectAppList/resultSets[1]/row/col[1]&amp;quot;, ArrayList.class);&amp;#xD;&amp;#xA;String sPackageList = new String(&amp;quot;&amp;quot;);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;for (int element : nPackageList) {&amp;#xD;&amp;#xA;&amp;#x9;logger.info(&amp;quot;Package ID to be Pushed -- &amp;gt; &amp;quot; + element);&amp;#xD;&amp;#xA;&amp;#x9;sPackageList = sPackageList.concat(Integer.toString(element));&amp;#xD;&amp;#xA;&amp;#x9;sPackageList = sPackageList.concat(&amp;quot;,&amp;quot;);&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;logger.info(&amp;quot; Package List is -&amp;gt; &amp;quot; + sPackageList);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;return sPackageList;&quot; />&lt;/inputs>"/>

																	<transition activity="Script_3" commented="0"

                    originalStyle="" points="" sourceX="293"

                    sourceY="168" status="0" style="defaultEdge"

                    targetX="294" targetY="206" transitionIndex="0"

                    x="0" y="0">

																		<condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

																	</transition>

																</Activity>

																<Activity commented="0" continueOnFailure="0"

                created="1459800349148"

                description="synchronizes a workflow per named parameter"

                displayName="AcquireLock" height="34" interactive="0"

                jobMode="0" name="AcquireLock"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=AcquireLock"

                uniqueName="AcquireLock_1" waitSetting="0" width="102"

                x="44" y="121">

																	<inputs val="&lt;inputs>&lt;name class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/system/workflow/workflowName}+xpath:{/workflow/ForEach_1/row/col}&lt;/name>&lt;releaseLockOnCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/releaseLockOnCompletion>&lt;timeout class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;/inputs>"/>

																		<transition activity="CollectAppList" commented="0"

                    originalStyle="" points="" sourceX="95"

                    sourceY="138" status="0" style="defaultEdge"

                    targetX="96" targetY="235" transitionIndex="0" x="0" y="0">

																			<condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

																		</transition>

																		<onEnter language="1" script="import java.io.*;&#xd;&#xa;import java.util.*;&#xd;&#xa;import java.util.Collections.*;&#xd;&#xa;import java.lang.*;&#xd;&#xa;import java.util.HashMap;&#xd;&#xa;import java.util.Map;&#xd;&#xa;import java.util.Iterator;&#xd;&#xa;"/>

																	</Activity>

																	<Activity commented="0" continueOnFailure="0"

                created="1469817735101"

                description="activity to execute code snippets in the selected language"

                displayName="Parse Application List" height="34"

                interactive="0" jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.ScriptActivity"

                uniqueName="Script_5" waitSetting="0" width="154"

                x="586" y="328">

																		<inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;nPackageList = workflow.getObject(&amp;quot;/workflow/CollectAppList/resultSets[1]/row/col[1]&amp;quot;, ArrayList.class);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;for (int element : nPackageList) {&amp;#xD;&amp;#xA;&amp;#x9;if( element == 22 )&amp;#xD;&amp;#xA;&amp;#x9;{&amp;#xD;&amp;#xA;&amp;#x9;   workflow.setVariable(&amp;quot;discoverOraInstance&amp;quot;,1);&amp;#xD;&amp;#xA;&amp;#x9;   break;&amp;#xD;&amp;#xA;&amp;#x9;}&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&quot; />&lt;/inputs>"/>

																			<transition activity="Decision_3" commented="0"

                    originalStyle="" points="" sourceX="663"

                    sourceY="345" status="0" style="defaultEdge"

                    targetX="888" targetY="345" transitionIndex="0"

                    x="0" y="0">

																				<condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

																			</transition>

																		</Activity>

																		<Activity commented="0" continueOnFailure="0"

                created="1469818965908"

                description="if/else based decision"

                displayName="Discover Oracle Instances ?" height="100"

                interactive="0" jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_3"

                waitSetting="0" width="190" x="793" y="295">

																			<inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/discoverOraInstance}!=0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

																				<transition activity="LogEvent_2" commented="0"

                    displayName="No" originalStyle="" points=""

                    sourceX="888" sourceY="345" status="0"

                    style="defaultEdge" targetX="886" targetY="221"

                    transitionIndex="0" value="false" x="0" y="0">

																					<condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

																				</transition>

																				<transition activity="Execute_1" commented="0"

                    displayName="Yes" originalStyle="" points=""

                    sourceX="888" sourceY="345" status="0"

                    style="defaultEdge" targetX="1045" targetY="347"

                    transitionIndex="0" value="true" x="0" y="0">

																					<condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

																				</transition>

																			</Activity>

																			<Activity commented="0" continueOnFailure="0"

                created="1469818997779"

                description="logs an event in the commcell console with the specified severity level"

                displayName="LogEvent" height="34" interactive="0"

                jobMode="0" name="LogEvent"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.LogEventActivity"

                uniqueName="LogEvent_2" waitSetting="0" width="100"

                x="836" y="204">

																				<inputs val="&lt;inputs>&lt;severity class=&quot;workflow.types.SeverityLevel&quot; _list_=&quot;false&quot;>INFO&lt;/severity>&lt;message class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/inputs>"/>

																				</Activity>

																				<Activity commented="0" continueOnFailure="0"

                created="1469819011986" description=""

                displayName="Execute" height="34" interactive="0"

                jobMode="0" name="Execute"

                namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.cmd.operation.OperationExecute"

                uniqueName="Execute_1" waitSetting="0" width="100"

                x="1023" y="328">

																					<inputs val="&lt;inputs>&lt;inputXml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&amp;lt;EVGui_OracleInstanceDiscoveryReq&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;clientName&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&amp;lt;clientName&amp;gt;xpath:{/workflow/ForEach_1/row/col}&amp;lt;/clientName&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/clientName&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/EVGui_OracleInstanceDiscoveryReq&amp;gt;&lt;/inputXml>&lt;commandArgs class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

																						<transition activity="LogEvent_3" commented="0"

                    originalStyle="" points="" sourceX="1073"

                    sourceY="345" status="0" style="defaultEdge"

                    targetX="1059" targetY="219" transitionIndex="0"

                    x="0" y="0">

																							<condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

																						</transition>

																					</Activity>

																					<Activity commented="0" continueOnFailure="0"

                created="1469819976095"

                description="logs an event in the commcell console with the specified severity level"

                displayName="LogEvent" height="34" interactive="0"

                jobMode="0" name="LogEvent"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.LogEventActivity"

                uniqueName="LogEvent_3" waitSetting="0" width="100"

                x="1009" y="202">

																						<inputs val="&lt;inputs>&lt;severity class=&quot;workflow.types.SeverityLevel&quot; _list_=&quot;false&quot;>INFO&lt;/severity>&lt;message class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/inputs>"/>

																						</Activity>

																					</superProcess>

																					<activitySchema>

																						<outputs name="outputs">

																							<children attribute="0"

                    className="workflow.types.data.DataRow"

                    defaultValue="" displayName="" hidden="0"

                    inputType="workflow.types.data.DataRow" listType="0"

                    name="row" type="{workflow.types.data}DataRow">

																								<children attribute="0" className="java.lang.Object"

                        defaultValue="" displayName="" hidden="0"

                        inputType="java.lang.Object" listType="1"

                        name="col" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

																							</children>

																						</outputs>

																						<inputs className="" name="" type="">

																							<children attribute="0" className="java.lang.String"

                    hidden="0" inputType="java.lang.String" listType="0"

                    name="name" type="{http://www.w3.org/2001/XMLSchema}string"/>

																							<children attribute="0" className="java.lang.Object"

                    hidden="0" inputType="java.lang.Object" listType="0"

                    name="values" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

																							<children attribute="0" className="java.lang.Integer"

                    defaultValue="1" hidden="0"

                    inputType="java.lang.Integer" listType="0"

                    name="numberOfParallelExecutions" type="{http://www.w3.org/2001/XMLSchema}integer"/>

																							<children attribute="0" className="java.lang.Boolean"

                    defaultValue="false" hidden="0"

                    inputType="java.lang.Boolean" listType="0"

                    name="continueOnFailure" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

																						</inputs>

																					</activitySchema>

																					<transition activity="WorkflowEnd_4" commented="0"

            displayName="Install Failed" originalStyle="" points=""

            sourceX="815" sourceY="264" status="0" style="defaultEdge"

            targetX="975" targetY="546" transitionIndex="0" x="0" y="0">

																						<condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;xpath:{/workflow/variables/InstallSuccess}==false"/>

																					</transition>

																					<transition activity="WorkflowEnd_1" commented="0"

            displayName="Install Success " originalStyle="" points=""

            sourceX="951" sourceY="213" status="0" style="defaultEdge"

            targetX="790" targetY="460" transitionIndex="0" x="0" y="0">

																						<condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;&#xa;xpath:{/workflow/variables/InstallSuccess}==true"/>

																					</transition>

																				</Activity>

																				<Activity commented="0" continueOnFailure="0"

        created="1459449166031" description="Ends the workflow"

        displayName="WorkflowEnd" height="34" interactive="0"

        jobMode="0" name="WorkflowEnd"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=WorkflowEnd"

        uniqueName="WorkflowEnd_1" waitSetting="0" width="106" x="755" y="535">

																					<inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot; />&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/inputs>"/>

																					</Activity>

																					<Activity commented="0" continueOnFailure="0"

        created="1460658184629"

        description="executes queries against a commcell database"

        displayName="Get Clients" height="34" interactive="0"

        jobMode="0" name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=CommServDBQuery" uniqueName="GetClients"

        waitSetting="0" width="143" x="179" y="131">

																						<inputs val="&lt;inputs>&lt;commCell />&lt;query>-- handle ClientGroup, cluster clients and single client scenario&amp;#xD;&#xd;&#xa;-- send out list of client-name in all above scenarios.&amp;#xD;&#xd;&#xa;-- For cluster client scenarios verify if there is any mapping in VMClientID table, and send out all pseudo client-name for install&amp;#xD;&#xd;&#xa;IF LEN(''xpath:{/workflow/inputs/ClientGroup/clientGroupName}'') &amp;gt; 0  &amp;#xD;&#xd;&#xa;    BEGIN&amp;#xD;&#xd;&#xa;        select name from app_client  WITH (NOLOCK) where id in (&amp;#xD;&#xd;&#xa;        select clientid from APP_ClientGroupAssoc  WITH (NOLOCK) where clientGroupId in (select id from app_clientgroup  WITH (NOLOCK) where name=''xpath:{/workflow/inputs/ClientGroup/clientGroupName}'') )&amp;#xD;&#xd;&#xa;    END    &amp;#xD;&#xd;&#xa;ELSE &amp;#xD;&#xd;&#xa;    BEGIN&amp;#xD;&#xd;&#xa;        DECLARE @tempClusterClients TABLE (  ClientId int )&amp;#xD;&#xd;&#xa;        INSERT into @tempClusterClients&amp;#xD;&#xd;&#xa;        select id from app_client WITH (NOLOCK) where id in &amp;#xD;&#xd;&#xa;            (select PMClientId from APP_VMToPMMap WITH (NOLOCK) where VMCLientID IN (select id from app_client WITH (NOLOCK) where name=''xpath:{/workflow/inputs/ClientName/clientName}''))&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;        IF EXISTS (select * from @tempClusterClients)&amp;#xD;&#xd;&#xa;            BEGIN&amp;#xD;&#xd;&#xa;                SELECT name from app_client WITH (NOLOCK) where id in (select ClientId from @tempClusterClients)&amp;#xD;&#xd;&#xa;            END&amp;#xD;&#xd;&#xa;        ELSE&amp;#xD;&#xd;&#xa;            BEGIN&amp;#xD;&#xd;&#xa;                select name from app_client  WITH (NOLOCK) where name = ''xpath:{/workflow/inputs/ClientName/clientName}''&amp;#xD;&#xd;&#xa;            END&amp;#xD;&#xd;&#xa;    END&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;select attrVal from APP_ClientProp with (NOLOCK) where attrName like ''Patch Local Location'' and componentNameId = xpath:{/workflow/system/workflowEngine/clientId}&lt;/query>&lt;/inputs>"/>

																							<transition activity="ValidClientCheck" commented="0"

            originalStyle="" points="" sourceX="242" sourceY="161"

            status="0" style="defaultEdge" targetX="243" targetY="261"

            transitionIndex="0" x="0" y="0">

																								<condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

																							</transition>

																						</Activity>

																						<Activity commented="0" continueOnFailure="0"

        created="1460658295549" description="if/else based decision"

        displayName="Clients Present?" height="100" interactive="0"

        jobMode="0" name="Decision"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="ValidClientCheck" waitSetting="0" width="124"

        x="187" y="198">

																							<inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/GetClients/resultSets[1]/rowCount} != 0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

																								<transition activity="ForEach_1" commented="0" displayName="YES"

            originalStyle="" points="" sourceX="271" sourceY="208"

            status="0" style="defaultEdge" targetX="506" targetY="60"

            transitionIndex="0" value="true" x="0" y="0">

																									<condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

																								</transition>

																								<transition activity="PopupInput_1" commented="0"

            displayName="NO" originalStyle="" points="" sourceX="255"

            sourceY="261" status="0" style="defaultEdge" targetX="261"

            targetY="404" transitionIndex="0" value="false" x="0" y="0">

																									<condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

																								</transition>

																							</Activity>

																							<Activity commented="0" continueOnFailure="0"

        created="1460658328121"

        description="popups an input form for the user to fill out"

        displayName="Display Error" height="34" interactive="0"

        jobMode="0" name="PopupInput"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=PopupInput"

        uniqueName="PopupInput_1" waitSetting="0" width="103" x="200" y="427">

																								<inputs val="&lt;inputs>&lt;inputs />&lt;subject>No Valid Clients! Exiting Workflow&lt;/subject>&lt;formProperties>&amp;lt;?xml version=''1.0'' encoding=''UTF-8''?&amp;gt;&amp;lt;Workflow_FormProperties css=&quot;&quot; javaScript=&quot;&quot; /&amp;gt;&lt;/formProperties>&lt;/inputs>"/>

																									<activitySchema>

																										<outputs className="" defaultValue="" listType="0"

                name="outputs" type="">

																											<children className="java.lang.Boolean"

                    inputType="java.lang.Boolean" name="okClicked" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

																											<children className="java.lang.String"

                    inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string"/>

																										</outputs>

																										<inputs className="" defaultValue="" listType="0"

                name="inputs" type=""/>

																									</activitySchema>

																									<transition activity="WorkflowEnd_1" commented="0"

            originalStyle="" points="250.0,561.0" sourceX="250"

            sourceY="444" status="0" style="defaultEdge" targetX="628"

            targetY="547" transitionIndex="0" x="0" y="0">

																										<condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

																									</transition>

																								</Activity>

																								<Activity commented="0" continueOnFailure="0"

        created="1467214072607" description="Ends the workflow"

        displayName="Completed With Errors" height="34" interactive="0"

        jobMode="0" name="WorkflowEnd"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=WorkflowEnd"

        uniqueName="WorkflowEnd_4" waitSetting="0" width="159" x="932" y="539">

																									<inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;>COMPLETED_WITH_ERRORS&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>Install failed for Clients - [xpath:{/workflow/variables/FailedClientList}]&lt;/failureMessage>&lt;/inputs>"/>

																									</Activity>

																									<formProperties css="" javaScript=""/>

																								</workflow>'

IF not exists (select * from WF_Definition where Name = @name)

BEGIN
	INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision)


	VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision)

	SET @workflowId = @@IDENTITY
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


	VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

	SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = ISNULL(revision, '') From WF_Definition WHERE Name = @name

	IF (@currentFlags & 4 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0) AND (@currentRevision <> @revision)

	BEGIN

		SET @version = @version + 1

		UPDATE WF_Definition

		SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision

		WHERE Name = @name

		IF (@flags & 8 > 0 OR @flags & 16 > 0 OR @flags & 6 > 0)

		BEGIN

			UPDATE WF_Definition

			SET flags = @flags

			WHERE Name = @name

		END
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


		VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

	END

END

