

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_IBMi_DataRecovery.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/ 
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER ON

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @oldname nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @guid nvarchar(256)

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.1.2.26 $'

SET @guid = '25e118f5-20b5-4472-a822-563ebaa8eb1e'

SET @name = 'IBM i DR Data Restore'

SET @oldname = 'IBM i DR Full Data Recovery'

SET @description = 'IBM i DR Data Restore'

SET @version = 1

SET @flags = 2 + 4 + 16 + 32

SET @definition = '<workflow apiMode="0" config="&lt;configuration /&gt;" description="IBM i DR Data Restore" executeOnWeb="0"

    inputs="&lt;inputs>&lt;sourceClient class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>&lt;clientName />&lt;clientId />&lt;displayName />&lt;/sourceClient>&lt;TimeoutForQSECRestore class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>300&lt;/TimeoutForQSECRestore>&lt;backupSetName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>defaultBackupSet&lt;/backupSetName>&lt;oDestinationClient class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>&lt;clientName />&lt;clientId />&lt;/oDestinationClient>&lt;bPVTAUT class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/bPVTAUT>&lt;bSPLFDTA class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/bSPLFDTA>&lt;sDFRID class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>*DFT&lt;/sDFRID>&lt;sOBJCNV class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>*YES *ALL&lt;/sOBJCNV>&lt;sALWJOBDIF class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>*ALL&lt;/sALWJOBDIF>&lt;bALWOBJDIF_AUTL class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/bALWOBJDIF_AUTL>&lt;bALWOBJDIF_FILELVL class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/bALWOBJDIF_FILELVL>&lt;bALWOBJDIF_OWNER class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/bALWOBJDIF_OWNER>&lt;bALWOBJDIF_PGP class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/bALWOBJDIF_PGP>&lt;sJOBLOG class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>*NONE&lt;/sJOBLOG>&lt;sMEMBEROpt class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>*REPLACE&lt;/sMEMBEROpt>&lt;sJOBLOGFileName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;sJOBLOGMemberName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>*FILE&lt;/sJOBLOGMemberName>&lt;sOUTTYPE class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>*OBJ&lt;/sOUTTYPE>&lt;retryAttempts class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>3&lt;/retryAttempts>&lt;delay class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>5&lt;/delay>&lt;dataRestoreDate class=&quot;java.util.Calendar&quot; _list_=&quot;false&quot; />&lt;nCopyPrecedence class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>0&lt;/nCopyPrecedence>&lt;lDRJobId class=&quot;java.lang.Long&quot; _list_=&quot;false&quot;>0&lt;/lDRJobId>&lt;sDVDImageRestorePath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;oDVDTargetClient class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>&lt;clientName />&lt;clientId />&lt;displayName />&lt;/oDVDTargetClient>&lt;strVolumeList class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/inputs>"

    interactive="1" isHtmlDescription="0" manualPercentageComplete="0"

    name="IBM i DR Data Restore"

    outputs="&lt;outputs>&lt;PickDestinationClient class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>&lt;clientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;clientId class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;/PickDestinationClient>&lt;/outputs>"

    revision="$Revision: 1.1.2.26 $" tags=""

    uniqueGuid="25e118f5-20b5-4472-a822-563ebaa8eb1e"

    variables="&lt;variables>&lt;backupSetName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;oDestinationClient class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>&lt;clientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;clientId class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;/oDestinationClient>&lt;oProxyClient class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>&lt;clientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;clientId class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;/oProxyClient>&lt;delayForWaitLoop class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>15&lt;/delayForWaitLoop>&lt;executorEMail class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;userMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;value_OUTOUT class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;value_MemberType class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;value_OutputType class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;value_TimeRange class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;attemptsRemain class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;copyPrecedenceXML class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;myclients class=&quot;java.lang.String&quot; _list_=&quot;true&quot; />&lt;clientsIBMi class=&quot;java.lang.String&quot; _list_=&quot;true&quot; />&lt;sourceClient class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>&lt;clientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;clientId class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;/sourceClient>&lt;strDateTo class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;value_ALWDIFF class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;xml class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;v_sDFRID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;subclientIDSourceSecurity class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;ProxyClientVM class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;CommCellIDForProxy_commcell class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;restoreTimeUnix class=&quot;java.lang.Long&quot; _list_=&quot;false&quot; />&lt;SecurityJobId class=&quot;java.lang.Long&quot; _list_=&quot;false&quot; />&lt;USRSysSubclientID class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;DRJobUsedVTL class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;securityJobUsedVTL class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;strVolumeList class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;sDRBackupSet class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;sDVDSourcePath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/variables>"

    webHidden="0" workflowId="0">

    <schema>

        <outputs className="" name="outputs" type="">

            <children attribute="0"

                className="commvault.msgs.CvEntities.ClientEntity"

                controlType="2" defaultValue="" displayName=""

                documentation="" hidden="0"

                inputType="commvault.msgs.CvEntities.ClientEntity"

                listType="0" name="PickDestinationClient" readOnly="0" type="{commvault.msgs.CvEntities}ClientEntity">

                <children attribute="0" className="java.lang.String"

                    defaultValue="" inputType="java.lang.String"

                    listType="0" name="clientName" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children attribute="0" className="java.lang.Integer"

                    defaultValue="" inputType="java.lang.Integer"

                    listType="0" name="clientId" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            </children>

        </outputs>

        <variables attribute="0" className="" name="variables" type="">

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="backupSetName" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0"

                className="commvault.msgs.CvEntities.ClientEntity"

                controlType="2" defaultValue="" displayName=""

                documentation="" hidden="0"

                inputType="commvault.msgs.CvEntities.ClientEntity"

                listType="0" name="oDestinationClient" type="{commvault.msgs.CvEntities}ClientEntity">

                <children attribute="0" className="java.lang.String"

                    defaultValue="" inputType="java.lang.String"

                    listType="0" name="clientName" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children attribute="0" className="java.lang.Integer"

                    defaultValue="" inputType="java.lang.Integer"

                    listType="0" name="clientId" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            </children>

            <children attribute="0"

                className="commvault.msgs.CvEntities.ClientEntity"

                controlType="2" defaultValue="" displayName=""

                documentation="" hidden="0"

                inputType="commvault.msgs.CvEntities.ClientEntity"

                listType="0" name="oProxyClient" type="{commvault.msgs.CvEntities}ClientEntity">

                <children attribute="0" className="java.lang.String"

                    defaultValue="" inputType="java.lang.String"

                    listType="0" name="clientName" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children attribute="0" className="java.lang.Integer"

                    defaultValue="" inputType="java.lang.Integer"

                    listType="0" name="clientId" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            </children>

            <children attribute="0" className="java.lang.Integer"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0"

                inputType="java.lang.Integer" listType="0"

                name="delayForWaitLoop" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="executorEMail" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="userMessage" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="value_OUTOUT" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="value_MemberType" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="value_OutputType" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="value_TimeRange" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.Integer"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.Integer" listType="0"

                name="attemptsRemain" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="failureMessage" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="copyPrecedenceXML" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="1"

                name="myclients" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="1" name="clientsIBMi" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0"

                className="commvault.msgs.CvEntities.ClientEntity"

                controlType="2" defaultValue="" displayName=""

                documentation="" hidden="0"

                inputType="commvault.msgs.CvEntities.ClientEntity"

                listType="0" name="sourceClient" type="{commvault.msgs.CvEntities}ClientEntity">

                <children attribute="0" className="java.lang.String"

                    defaultValue="" inputType="java.lang.String"

                    listType="0" name="clientName" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children attribute="0" className="java.lang.Integer"

                    defaultValue="" inputType="java.lang.Integer"

                    listType="0" name="clientId" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            </children>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="strDateTo" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="value_ALWDIFF" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                defaultValue="" displayName="" documentation=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="xml" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="v_sDFRID" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.Integer"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0"

                inputType="java.lang.Integer" listType="0"

                name="subclientIDSourceSecurity" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="ProxyClientVM" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.Integer"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0"

                inputType="java.lang.Integer" listType="0"

                name="CommCellIDForProxy_commcell" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.Long"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.Long"

                listType="0" name="restoreTimeUnix" type="{http://www.w3.org/2001/XMLSchema}long"/>

            <children attribute="0" className="java.lang.Long"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.Long"

                listType="0" name="SecurityJobId" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}long"/>

            <children attribute="0" className="java.lang.Integer"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.Integer" listType="0"

                name="USRSysSubclientID" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.Integer"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0"

                inputType="java.lang.Integer" listType="0"

                name="DRJobUsedVTL" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.Integer"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0"

                inputType="java.lang.Integer" listType="0"

                name="securityJobUsedVTL" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="strVolumeList" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="sDRBackupSet" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="sDVDSourcePath" type="{http://www.w3.org/2001/XMLSchema}string"/>

        </variables>

        <inputs attribute="0" className="" name="inputs" type="">

            <children attribute="0"

                className="commvault.msgs.CvEntities.ClientEntity"

                controlHidden="0" controlType="2" defaultValue=""

                displayName="Source Client:" documentation="" hidden="0"

                inputType="commvault.msgs.CvEntities.ClientEntity"

                listType="0" maximumValue="" minimumValue=""

                name="sourceClient" readOnly="0" required="0"

                searchable="0" type="{commvault.msgs.CvEntities}ClientEntity">

                <children attribute="0" className="java.lang.String"

                    defaultValue="" inputType="java.lang.String"

                    listType="0" name="clientName" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children attribute="0" className="java.lang.Integer"

                    defaultValue="" inputType="java.lang.Integer"

                    listType="0" name="clientId" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            </children>

            <children attribute="0"

                className="commvault.msgs.CvEntities.ClientEntity"

                controlHidden="0" controlType="2" defaultValue=""

                displayName="Destination Client:" documentation=""

                hidden="0"

                inputType="commvault.msgs.CvEntities.ClientEntity"

                listType="0" maximumValue="" minimumValue=""

                name="oDestinationClient" readOnly="0" required="0"

                searchable="0" type="{commvault.msgs.CvEntities}ClientEntity">

                <children attribute="0" className="java.lang.String"

                    defaultValue="" inputType="java.lang.String"

                    listType="0" name="clientName" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children attribute="0" className="java.lang.Integer"

                    defaultValue="" inputType="java.lang.Integer"

                    listType="0" name="clientId" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            </children>

            <children attribute="0" className="java.lang.String"

                controlHidden="0" controlType="0" defaultValue=""

                displayName="" documentation="" hidden="0"

                inputType="java.lang.String" listType="0"

                maximumValue="" minimumValue="" name="backupSetName"

                readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.Integer"

                controlHidden="0" controlType="0" defaultValue=""

                displayName="Abort timeout:"

                documentation="Some operations require to bring Subsystems down. This value will limit the subsystem down time for such operations."

                hidden="0" inputType="java.lang.Integer" listType="0"

                maximumValue="" minimumValue=""

                name="TimeoutForQSECRestore" readOnly="0" required="0"

                searchable="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.Boolean"

                controlHidden="0" controlType="5" defaultValue=""

                displayName="Restore private authority (PVTAUT)"

                documentation="Specifies whether to restore private authorities with the objects that are restored."

                hidden="0" inputType="java.lang.Boolean" listType="0"

                maximumValue="" minimumValue="" name="bPVTAUT"

                readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

            <children attribute="0" className="java.lang.Boolean"

                controlHidden="0" controlType="5" defaultValue=""

                displayName="Restore spooled file data (SPLFDTA) "

                documentation="Specifies whether to restore spooled file data and attributes."

                hidden="0" inputType="java.lang.Boolean" listType="0"

                maximumValue="" minimumValue="" name="bSPLFDTA"

                readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

            <children attribute="0" className="java.lang.String"

                controlHidden="0" controlType="2" defaultValue=""

                displayName="Allow object differences (ALWOBJDIF)"

                documentation="Specifies whether differences are allowed between the saved objects and the restored objects. "

                hidden="0" inputType="java.lang.String" listType="0"

                maximumValue="" minimumValue="" name="sALWJOBDIF"

                readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string">

                <options val="*NONE"/>

                <options val="*ALL"/>

                <options val="*COMPATIBLE"/>

                <options val="OTHER"/>

            </children>

            <children attribute="0" className="java.lang.Boolean"

                controlHidden="0" controlType="5" defaultValue=""

                displayName="*AUTL"

                documentation="Authorization list differences are allowed."

                hidden="0" inputType="java.lang.Boolean" listType="0"

                maximumValue="" minimumValue="" name="bALWOBJDIF_AUTL"

                readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

            <children attribute="0" className="java.lang.Boolean"

                controlHidden="0" controlType="5" defaultValue=""

                displayName="*FILELVL"

                documentation="File level id and member level id differences are allowed."

                hidden="0" inputType="java.lang.Boolean" listType="0"

                maximumValue="" minimumValue=""

                name="bALWOBJDIF_FILELVL" readOnly="0" required="0"

                searchable="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

            <children attribute="0" className="java.lang.Boolean"

                controlHidden="0" controlType="5" defaultValue=""

                displayName="*OWNER"

                documentation="Ownership differences are allowed. If an object already exists on the system with a different owner than the saved object, the object is restored with the owner of the object on the system."

                hidden="0" inputType="java.lang.Boolean" listType="0"

                maximumValue="" minimumValue="" name="bALWOBJDIF_OWNER"

                readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

            <children attribute="0" className="java.lang.Boolean"

                controlHidden="0" controlType="5" defaultValue=""

                displayName="*PGP"

                documentation="Primary group differences are allowed."

                hidden="0" inputType="java.lang.Boolean" listType="0"

                maximumValue="" minimumValue="" name="bALWOBJDIF_PGP"

                readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

            <children attribute="0" className="java.lang.String"

                controlHidden="0" controlType="2" defaultValue=""

                displayName="Force Object conversion (FRCOBJCNV)"

                documentation="Specifies whether to convert user objects to the format required for use in the current version of the operating system, or to be compatible with the current machine, when the objects are restored."

                hidden="0" inputType="java.lang.String" listType="0"

                maximumValue="" minimumValue="" name="sOBJCNV"

                readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string">

                <options val="*SYSVAL"/>

                <options val="*NO"/>

                <options val="*YES *RQD"/>

                <options val="*YES *ALL"/>

            </children>

            <children attribute="0" className="java.lang.String"

                controlHidden="0" controlType="0" defaultValue=""

                displayName="Defer ID"

                documentation="Specifies the identifier to be used if you want to defer the restore or the start journal requests for objects that depend on other objects that are not yet available. Default is ''*NONE''."

                hidden="0" inputType="java.lang.String" listType="0"

                maximumValue="" minimumValue="" name="sDFRID"

                readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlHidden="0" controlType="2" defaultValue=""

                displayName="Output option"

                documentation="Specifies whether a listing that shows information about the status of the objects is created and directed to an output file."

                hidden="0" inputType="java.lang.String" listType="0"

                maximumValue="" minimumValue="" name="sJOBLOG"

                readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string">

                <options val="*NONE"/>

                <options val="*PRINT"/>

                <options val="*OUTFILE"/>

            </children>

            <children attribute="0" className="java.lang.String"

                controlHidden="0" controlType="0" defaultValue=""

                displayName="Output file"

                documentation="Specifies the database file to which the output of the command is directed when *OUTFILE is specified. If the file does not exist, this command creates a database file in the specified library (LIBRARY/FILE)."

                hidden="0" inputType="java.lang.String" listType="0"

                maximumValue="" minimumValue="" name="sJOBLOGFileName"

                readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlHidden="0" controlType="0" defaultValue=""

                displayName="Output member"

                documentation="Specifies the name of the database file member to which the output is directed when *OUTFILE is specified."

                hidden="0" inputType="java.lang.String" listType="0"

                maximumValue="" minimumValue="" name="sJOBLOGMemberName"

                readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlHidden="0" controlType="2" defaultValue=""

                displayName="Replace or add records" documentation=""

                hidden="0" inputType="java.lang.String" listType="0"

                maximumValue="" minimumValue="" name="sMEMBEROpt"

                readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string">

                <options val="*REPLACE"/>

                <options val="*ADD"/>

            </children>

            <children attribute="0" className="java.lang.String"

                controlHidden="0" controlType="2" defaultValue=""

                displayName="Type of output information"

                documentation="Specifies the type of information which is printed or directed to the database file."

                hidden="0" inputType="java.lang.String" listType="0"

                maximumValue="" minimumValue="" name="sOUTTYPE"

                readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string">

                <options val="*OBJ"/>

                <options val="*MBR"/>

            </children>

            <children attribute="0" className="java.lang.Integer"

                controlHidden="0" controlType="0" defaultValue=""

                displayName="Copy Precedence:" documentation=""

                hidden="0" inputType="java.lang.Integer" listType="0"

                maximumValue="" minimumValue="" name="nCopyPrecedence"

                readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.util.Calendar"

                controlHidden="0" controlType="8" defaultValue=""

                displayName="Restore data backed up before date:"

                documentation="" hidden="0"

                inputType="java.util.Calendar" listType="0"

                maximumValue="" minimumValue="" name="dataRestoreDate"

                readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}dateTime"/>

            <children attribute="0" className="java.lang.Integer"

                controlHidden="0" controlType="0" defaultValue=""

                displayName="Number of retry before failing"

                documentation="" hidden="0"

                inputType="java.lang.Integer" listType="0"

                maximumValue="" minimumValue="" name="retryAttempts"

                readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.Integer"

                controlHidden="0" controlType="0" defaultValue=""

                displayName="Delay between retry attempts"

                documentation="Minutes" hidden="0"

                inputType="java.lang.Integer" listType="0"

                maximumValue="" minimumValue="" name="delay"

                readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.Long"

                controlHidden="1" controlType="0" defaultValue=""

                displayName="" documentation="" hidden="0"

                inputType="java.lang.Long" listType="0" maximumValue=""

                minimumValue="" name="lDRJobId" readOnly="0"

                required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}long"/>

            <children attribute="0" className="java.lang.String"

                controlHidden="1" controlType="0" defaultValue=""

                displayName="" documentation="" hidden="0"

                inputType="java.lang.String" listType="0"

                maximumValue="" minimumValue=""

                name="sDVDImageRestorePath" readOnly="0" required="0"

                searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0"

                className="commvault.msgs.CvEntities.ClientEntity"

                controlHidden="1" controlType="2" defaultValue=""

                displayName="" documentation="" hidden="0"

                inputType="commvault.msgs.CvEntities.ClientEntity"

                listType="0" maximumValue="" minimumValue=""

                name="oDVDTargetClient" readOnly="0" required="0"

                searchable="0" type="{commvault.msgs.CvEntities}ClientEntity">

                <children attribute="0" className="java.lang.String"

                    defaultValue="" inputType="java.lang.String"

                    listType="0" name="clientName" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children attribute="0" className="java.lang.String"

                    defaultValue="" inputType="java.lang.String"

                    listType="0" name="displayName" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children attribute="0" className="java.lang.Integer"

                    defaultValue="" inputType="java.lang.Integer"

                    listType="0" name="clientId" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            </children>

            <children attribute="0" className="java.lang.String"

                controlHidden="1" controlType="0" defaultValue=""

                displayName="" documentation="" hidden="0"

                inputType="java.lang.String" listType="0"

                maximumValue="" minimumValue="" name="strVolumeList"

                readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

        </inputs>

        <config className="" name="configuration" type=""/>

    </schema>

    <Start commented="0" continueOnFailure="0" created="0"

        description="" displayName="Start" height="36" interactive="0"

        jobMode="0" name="Start" originalStyle="" skipAttempt="0"

        style="image;image=/images/jgraphx/house.png"

        uniqueName="Start_1" waitSetting="0" width="76" x="10" y="30">

        <inputs val="&lt;inputs />"/>

        <transition activity="Script_1" commented="0" originalStyle=""

            points="" sourceX="713" sourceY="57" status="0"

            style="defaultEdge" targetX="821" targetY="91"

            transitionIndex="0" x="639" y="-2">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Start>

    <Activity commented="0" continueOnFailure="0"

        created="1467904489142" description="Ends the workflow"

        displayName="Success" height="22" interactive="0" jobMode="0"

        name="WorkflowEnd"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.EndActivity"

        uniqueName="WorkflowEnd_18" waitSetting="0" width="170" x="569" y="3079">

        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;>COMPLETED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/failureMessage}&lt;/failureMessage>&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1474397371667" description="if/else based decision"

        displayName="Input parameters provided?" height="40"

        interactive="0" jobMode="0" name="Decision"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_2" waitSetting="0" width="290" x="85" y="83">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/sourceClient/clientId}!=0 &amp;amp;&amp;amp; xpath:{/workflow/variables/backupSetName}!=&quot;&quot; &amp;amp;&amp;amp; xpath:{/workflow/variables/oDestinationClient/clientId}!=0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVASCRIPT&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="WizardBlock_2" commented="0"

            displayName="Get Client Inputs" originalStyle="" points=""

            sourceX="250" sourceY="60" status="0" style="defaultEdge"

            targetX="550" targetY="30" transitionIndex="0" value="false"

            x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="EndUserSessionWithOutputs_1" commented="0"

            displayName="YES" originalStyle="" points="" sourceX="230"

            sourceY="103" status="0" style="defaultEdge" targetX="634"

            targetY="99" transitionIndex="0" value="true" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1474397547758"

        description="activity to execute code snippets in the selected language"

        displayName="Assign Objects" height="20" interactive="0"

        jobMode="0" name="Script"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.ScriptActivity"

        uniqueName="Script_1" waitSetting="0" width="190" x="140" y="35">

        <inputs val="&lt;inputs>&lt;script language=&quot;3&quot; script=&quot;workflow.setVariable(&amp;quot;backupSetName&amp;quot;, xpath:{/workflow/inputs/backupSetName} );&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;oDestinationClient&amp;quot;, xpath:{/workflow/inputs/oDestinationClient} );&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;sourceClient&amp;quot;, xpath:{/workflow/inputs/sourceClient} );&amp;#xD;&amp;#xA;if(xpath:{/workflow/inputs/sDFRID}.trim().length == 0)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    workflow.setInput(&amp;quot;sDFRID&amp;quot;, &amp;quot;*NONE&amp;quot; );&amp;#xD;&amp;#xA;}&quot; />&lt;/inputs>"/>

        <transition activity="Decision_2" commented="0" originalStyle=""

            points="" sourceX="1022" sourceY="142" status="0"

            style="defaultEdge" targetX="1012" targetY="192"

            transitionIndex="0" x="762" y="2">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1496334715248"

        description="activity to execute code snippets in the selected language"

        displayName="Convert Job Options" height="20" interactive="0"

        jobMode="0" name="Script"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.ScriptActivity"

        uniqueName="Script_5" waitSetting="0" width="200" x="1130" y="412">

        <inputs val="&lt;inputs>&lt;script language=&quot;3&quot; script=&quot;if( xpath:{/workflow/inputs/sJOBLOG} == &amp;quot;*NONE&amp;quot; )&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;value_OUTOUT&amp;quot;, &amp;quot;0&amp;quot;);&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;value_OutputType&amp;quot;, &amp;quot;0&amp;quot;);&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;value_MemberType&amp;quot;, &amp;quot;0&amp;quot;);&amp;#xD;&amp;#xA;} else {&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;value_OUTOUT&amp;quot;, &amp;quot;1&amp;quot;); /* PRINT */&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;value_OutputType&amp;quot;, &amp;quot;0&amp;quot;);&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;value_MemberType&amp;quot;, &amp;quot;0&amp;quot;);&amp;#xD;&amp;#xA;    if(&amp;quot;*OUTFILE&amp;quot; == xpath:{/workflow/inputs/sJOBLOG})&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        workflow.setVariable(&amp;quot;value_OUTOUT&amp;quot;, &amp;quot;2&amp;quot;); /* OUTPUT */&amp;#xD;&amp;#xA;        if( xpath:{/workflow/inputs/sMEMBEROpt} == &amp;quot;*ADD&amp;quot; )&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            workflow.setVariable(&amp;quot;value_MemberType&amp;quot;, &amp;quot;1&amp;quot;);&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    if(  xpath:{/workflow/inputs/sOUTTYPE} == &amp;quot;*OBJ&amp;quot; )&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        workflow.setVariable(&amp;quot;value_OutputType&amp;quot;, &amp;quot;0&amp;quot;);&amp;#xD;&amp;#xA;    } else {&amp;#xD;&amp;#xA;        workflow.setVariable(&amp;quot;value_OutputType&amp;quot;, &amp;quot;2&amp;quot;);&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;if( xpath:{/workflow/inputs/dataRestoreDate} != null )&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    var timeRange = &amp;quot;&amp;lt;timeRange&amp;gt;&amp;lt;toTimeValue&amp;gt;&amp;quot;;&amp;#xD;&amp;#xA;    timeRange = timeRange + utils.formatDate(xpath:{/workflow/inputs/dataRestoreDate}.getTime(), &amp;quot;yyyy-MM-dd&amp;quot;);&amp;#xD;&amp;#xA;    timeRange = timeRange + &amp;quot; &amp;quot;;&amp;#xD;&amp;#xA;    timeRange = timeRange + utils.formatDate(xpath:{/workflow/inputs/dataRestoreDate}.getTime(), &amp;quot;HH:mm:ss&amp;quot;);&amp;#xD;&amp;#xA;    timeRange = timeRange + &amp;quot;&amp;lt;/toTimeValue&amp;gt;&amp;lt;/timeRange&amp;gt;&amp;quot;;&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;value_TimeRange&amp;quot;, timeRange);&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;restoreTimeUnix&amp;quot;, xpath:{/workflow/inputs/dataRestoreDate}.getTimeInMillis()/1000);&amp;#xD;&amp;#xA;} else {&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;value_TimeRange&amp;quot;, &amp;quot;&amp;quot;);&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;restoreTimeUnix&amp;quot;, 4294967296 );&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;attemptsRemain&amp;quot;, xpath:{/workflow/inputs/retryAttempts});&amp;#xD;&amp;#xA;if( xpath:{/workflow/inputs/nCopyPrecedence} &amp;gt; 0 )&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;copyPrecedenceXML&amp;quot;, &amp;quot;&amp;lt;copyPrecedence&amp;gt;&amp;lt;copyPrecedenceApplicable&amp;gt;true&amp;lt;/copyPrecedenceApplicable&amp;gt;&amp;lt;synchronousCopyPrecedence&amp;gt;&amp;quot;+xpath:{/workflow/inputs/nCopyPrecedence}+&amp;quot;&amp;lt;/synchronousCopyPrecedence&amp;gt;&amp;lt;copyPrecedence&amp;gt;&amp;quot;+xpath:{/workflow/inputs/nCopyPrecedence}+&amp;quot;&amp;lt;/copyPrecedence&amp;gt;&amp;lt;/copyPrecedence&amp;gt;&amp;quot;);&amp;#xD;&amp;#xA;} else {&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;copyPrecedenceXML&amp;quot;, &amp;quot;&amp;quot;);&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;if(xpath:{/workflow/inputs/sALWJOBDIF} == &amp;quot;*NONE&amp;quot; || xpath:{/workflow/inputs/sALWJOBDIF} == &amp;quot;NONE&amp;quot;)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;value_ALWDIFF&amp;quot;, &amp;quot;NONE&amp;quot;);&amp;#xD;&amp;#xA;} else if(xpath:{/workflow/inputs/sALWJOBDIF} == &amp;quot;*ALL&amp;quot;)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;value_ALWDIFF&amp;quot;, &amp;quot;ALL&amp;quot;);&amp;#xD;&amp;#xA;} else if(xpath:{/workflow/inputs/sALWJOBDIF} == &amp;quot;*COMPATIBLE&amp;quot;)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;value_ALWDIFF&amp;quot;, &amp;quot;COMPATIBLE&amp;quot;);&amp;#xD;&amp;#xA;} else if(xpath:{/workflow/inputs/sALWJOBDIF} == &amp;quot;OTHER&amp;quot; || xpath:{/workflow/inputs/sALWJOBDIF} == &amp;quot;*OTHER&amp;quot;)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;value_ALWDIFF&amp;quot;, &amp;quot;OTHER&amp;quot;);&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;var dfrIdStr = xpath:{/workflow/inputs/sDFRID}.trim();&amp;#xD;&amp;#xA;if( dfrIdStr.length &amp;gt; 10 )&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    dfrIdStr = dfrIdStr.substring(0,10);&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if(dfrIdStr.length == 0)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;v_sDFRID&amp;quot;, &amp;quot;*NONE&amp;quot; );&amp;#xD;&amp;#xA;} else if(dfrIdStr == &amp;quot;*DFT&amp;quot; ) {&amp;#xD;&amp;#xA;    // generate DFRID using job id&amp;#xD;&amp;#xA;    var jobstr = &amp;quot;&amp;quot; + xpath:{/workflow/system/jobId};&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;v_sDFRID&amp;quot;, &amp;quot;*MJCVDFR&amp;quot; + (&amp;quot;0000&amp;quot;+jobstr).substring(jobstr.length) );&amp;#xD;&amp;#xA;} else {&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;v_sDFRID&amp;quot;, &amp;quot;*MJ&amp;quot; + dfrIdStr );&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;// Set the volume list variable that might be used by VTL DR Tape restore&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;strVolumeList&amp;quot;, xpath:{/workflow/inputs/strVolumeList});&quot; />&lt;/inputs>"/>

        <transition activity="ProcessBlock_4" commented="0"

            originalStyle="" points="" sourceX="550" sourceY="380"

            status="0" style="defaultEdge" targetX="280" targetY="170"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1520454093425"

        description="creates a super process group"

        displayName="Get EMail" height="100" interactive="0" jobMode="0"

        name="ProcessBlock"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ProcessBlock_2" waitSetting="0" width="250" x="1146" y="77">

        <inputs val="&lt;inputs>&lt;inputs />&lt;/inputs>"/>

        <superProcess>

            <Start commented="0" continueOnFailure="0"

                created="1520454093425" description=""

                displayName="Start" height="20" interactive="0"

                jobMode="0" name="Start" originalStyle=""

                skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_3" waitSetting="0" width="70" x="12" y="30">

                <inputs val="&lt;inputs />"/>

                <transition activity="GetExecutorEmail" commented="0"

                    originalStyle="" points="" sourceX="79" sourceY="39"

                    status="0" style="defaultEdge" targetX="89"

                    targetY="69" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity commented="0" continueOnFailure="0"

                created="1520264383201"

                description="retrieves a list of values from xml"

                displayName="Get Email" height="20" interactive="0"

                jobMode="0" name="XPathQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.XMLQueryActivity"

                uniqueName="GetExecutorEmailQuery" waitSetting="0"

                width="100" x="14" y="69">

                <inputs val="&lt;inputs>&lt;xml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/GetExecutorEmail/output}&lt;/xml>&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>/App_GetUserPropertiesResponse/users/@email&lt;/xpath>&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;>String&lt;/outputType>&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/outputAsList>&lt;/inputs>"/>

                <transition activity="AssignValues_1" commented="0"

                    originalStyle="" points="" sourceX="64" sourceY="79"

                    status="0" style="defaultEdge" targetX="198"

                    targetY="77" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1520454021813"

                description="Updates process variables and inputs"

                displayName="Assign" height="20" interactive="0"

                jobMode="0" name="AssignValues"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.AssignValues"

                uniqueName="AssignValues_1" waitSetting="0" width="80"

                x="157" y="66">

                <outputs variables="&lt;variables>&lt;executorEMail class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/GetExecutorEmailQuery/result}&lt;/executorEMail>&lt;/variables>"/>

                <inputs val="&lt;inputs />"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1520264333021"

                description="performs http operations"

                displayName="Get user properties" height="20"

                interactive="0" jobMode="0" name="HttpClient"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.HttpClientActivity"

                uniqueName="GetExecutorEmail" waitSetting="0"

                width="140" x="100" y="30">

                <inputs val="&lt;inputs>&lt;request>&lt;url>/SearchSvc/CVWebService.svc/User/xpath:{/workflow/system/executor/userId}&lt;/url>&lt;method>GET&lt;/method>&lt;postType>Raw&lt;/postType>&lt;postContent>&lt;/postContent>&lt;postContentType>application/xml; charset=UTF-8&lt;/postContentType>&lt;headers>&lt;name>Authtoken&lt;/name>&lt;value>QSDKONLY xpath:{/workflow/system/token}&lt;/value>&lt;/headers>&lt;headers>&lt;name>Accept&lt;/name>&lt;value>application/xml&lt;/value>&lt;/headers>&lt;/request>&lt;/inputs>"/>

                <transition activity="GetExecutorEmailQuery"

                    commented="0" originalStyle="" points=""

                    sourceX="251" sourceY="66" status="0"

                    style="defaultEdge" targetX="251" targetY="96"

                    transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

        </superProcess>

        <activitySchema>

            <outputs className="" defaultValue="" listType="0"

                name="outputs" type=""/>

            <inputs className="" defaultValue="" listType="0"

                name="inputs" type=""/>

        </activitySchema>

        <transition activity="Script_5" commented="0" originalStyle=""

            points="" sourceX="276" sourceY="286" status="0"

            style="defaultEdge" targetX="266" targetY="426"

            transitionIndex="0" x="86" y="6">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1520461503732"

        description="creates a super process group"

        displayName="Find proxy" height="355" interactive="0"

        jobMode="0" name="ProcessBlock"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ProcessBlock_4" waitSetting="0" width="584" x="1042" y="467">

        <inputs val="&lt;inputs>&lt;inputs />&lt;/inputs>"/>

        <superProcess>

            <Start commented="0" continueOnFailure="0"

                created="1520461503732" description=""

                displayName="Start" height="20" interactive="0"

                jobMode="0" name="Start" originalStyle=""

                skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_5" waitSetting="0" width="80" x="20" y="30">

                <inputs val="&lt;inputs />"/>

                <transition activity="HttpClient_1" commented="0"

                    originalStyle="" points="" sourceX="60" sourceY="40"

                    status="0" style="defaultEdge" targetX="193"

                    targetY="40" transitionIndex="0" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity commented="0" continueOnFailure="0"

                created="1520461534460"

                description="performs http operations"

                displayName="Get Client properties" height="20"

                interactive="0" jobMode="0" name="HttpClient"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.HttpClientActivity"

                uniqueName="HttpClient_1" waitSetting="0" width="146"

                x="120" y="30">

                <inputs val="&lt;inputs>&lt;request>&lt;url>/SearchSvc/CVWebService.svc/Client/xpath:{/workflow/variables/oDestinationClient/clientId}&lt;/url>&lt;method>GET&lt;/method>&lt;postType>Raw&lt;/postType>&lt;postContent>&lt;/postContent>&lt;postContentType>application/xml; charset=UTF-8&lt;/postContentType>&lt;headers>&lt;name>Authtoken&lt;/name>&lt;value>QSDKONLY xpath:{/workflow/system/token}&lt;/value>&lt;/headers>&lt;headers>&lt;name>Accept&lt;/name>&lt;value>application/xml&lt;/value>&lt;/headers>&lt;/request>&lt;/inputs>"/>

                <transition activity="ForEachProxy_1" commented="0"

                    originalStyle="" points="" sourceX="193"

                    sourceY="40" status="0" style="defaultEdge"

                    targetX="130" targetY="180" transitionIndex="0"

                    x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="1"

                created="1520461668980"

                description="iterates a group of activities over a list of xml nodes"

                displayName="For each proxy" height="277"

                interactive="0" jobMode="0" maxRestarts="0"

                name="ForEachXml"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0" style="swimlane"

                uniqueName="ForEachProxy_1" waitSetting="0" width="313"

                x="6" y="68">

                <inputs val="&lt;inputs>&lt;xml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/HttpClient_1/output}&lt;/xml>&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>/App_GetClientPropertiesResponse/clientProperties/pseudoClientInfo/openVMSProperties/proxyClients/backupDataAccessNodes&lt;/xpath>&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>1&lt;/numberOfParallelExecutions>&lt;continueOnFailure class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/continueOnFailure>&lt;/inputs>"/>

                <superProcess>

                    <Start commented="0" continueOnFailure="0"

                        created="1520461668980" description=""

                        displayName="Start" height="20" interactive="0"

                        jobMode="0" name="Start" originalStyle=""

                        skipAttempt="0"

                        style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                        uniqueName="Start_6" waitSetting="0" width="70"

                        x="10" y="30">

                        <inputs val="&lt;inputs />"/>

                        <transition activity="GetProxyClientId"

                            commented="0" originalStyle="" points=""

                            sourceX="45" sourceY="40" status="0"

                            style="defaultEdge" targetX="148"

                            targetY="40" transitionIndex="0" x="0" y="0">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Start>

                    <Activity commented="0" continueOnFailure="0"

                        created="1520461843432"

                        description="activity to execute code snippets in the selected language"

                        displayName="Get Proxy Entry" height="20"

                        interactive="0" jobMode="0" name="Script"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=commvault.cte.workflow.activities.ScriptActivity"

                        uniqueName="Script_12" waitSetting="0"

                        width="117" x="144" y="40">

                        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;try {&amp;#xD;&amp;#xA;    commvault.msgs.CvEntities.ClientEntity clientEntity = commvault.cte.workflow.utils.CommServUtils.getClientEntity(xpath:{/workflow/GetProxyClientId/result});&amp;#xD;&amp;#xA;    return clientEntity;&amp;#xD;&amp;#xA;} catch (java.lang.Exception e) {&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;return null;&quot; />&lt;/inputs>"/>

                        <transition activity="Decision_49" commented="0"

                            originalStyle="" points="" sourceX="148"

                            sourceY="40" status="0" style="defaultEdge"

                            targetX="148" targetY="76"

                            transitionIndex="0" x="0" y="0">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity commented="0" continueOnFailure="1"

                        created="1520461902678" description=""

                        displayName="CheckReady" height="20"

                        interactive="0" jobMode="0" maxRestarts="0"

                        name="CheckReady"

                        namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                        originalStyle="" skipAttempt="0"

                        style="label;image=commvault.cte.workflow.activities.cmd.operation.OperationCheckReady"

                        uniqueName="CheckReady_2" waitSetting="0"

                        width="101" x="201" y="123">

                        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>xpath:{/workflow/Script_12/output}&lt;/client>&lt;reportType class=&quot;workflow.types.cmd.ReportInformationType&quot; _list_=&quot;false&quot;>Summary&lt;/reportType>&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

                        <transition activity="Decision_23" commented="0"

                            originalStyle="" points="" sourceX="148"

                            sourceY="76" status="0" style="defaultEdge"

                            targetX="120" targetY="110"

                            transitionIndex="0" x="0" y="0">

                            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity commented="0" continueOnFailure="0"

                        created="1520461911548"

                        description="if/else based decision"

                        displayName="Result?" height="20"

                        interactive="0" jobMode="0" name="Decision"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="rhombus;fontStyle=1"

                        uniqueName="Decision_23" waitSetting="0"

                        width="100" x="158" y="159">

                        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/CheckReady_2/exitCode} == 0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                        <transition activity="Script_13" commented="0"

                            displayName="Ready" originalStyle=""

                            points="" sourceX="120" sourceY="110"

                            status="0" style="defaultEdge" targetX="67"

                            targetY="160" transitionIndex="0"

                            value="true" x="0" y="0">

                            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                        <transition activity="Script_14" commented="0"

                            displayName="No ready" originalStyle=""

                            points="" sourceX="155" sourceY="119"

                            status="0" style="defaultEdge" targetX="155"

                            targetY="189" transitionIndex="0"

                            value="false" x="0" y="0">

                            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity commented="0" continueOnFailure="0"

                        created="1520462032586"

                        description="activity to execute code snippets in the selected language"

                        displayName="Set Proxy" height="20"

                        interactive="0" jobMode="0" name="Script"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=commvault.cte.workflow.activities.ScriptActivity"

                        uniqueName="Script_13" waitSetting="0"

                        width="85" x="169" y="201">

                        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;workflow.setVariable(&amp;quot;oProxyClient&amp;quot;, xpath:{/workflow/Script_12/output} );&quot; />&lt;/inputs>"/>

                        <transition activity="Break_1" commented="0"

                            originalStyle="" points="" sourceX="67"

                            sourceY="160" status="0" style="defaultEdge"

                            targetX="58" targetY="202"

                            transitionIndex="0" x="-655" y="-191">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity commented="0" continueOnFailure="0"

                        created="1520462095288"

                        description="activity to execute code snippets in the selected language"

                        displayName="Next" height="20" interactive="0"

                        jobMode="0" name="Script"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=commvault.cte.workflow.activities.ScriptActivity"

                        uniqueName="Script_14" waitSetting="0"

                        width="56" x="21" y="237">

                        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;&quot; />&lt;/inputs>"/>

                    </Activity>

                    <Activity commented="0" continueOnFailure="0"

                        created="1520462138353"

                        description="interrupts a process block execution"

                        displayName="Break" height="20" interactive="0"

                        jobMode="0" name="Break"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=commvault.cte.workflow.activities.InterruptActivity"

                        uniqueName="Break_1" waitSetting="0" width="64"

                        x="179" y="239">

                        <inputs val="&lt;inputs />"/>

                    </Activity>

                    <Activity commented="0" continueOnFailure="0"

                        created="1524593200747"

                        description="retrieves a list of values from xml"

                        displayName="Get ClientId" height="23"

                        interactive="0" jobMode="0" name="XPathQuery"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=commvault.cte.workflow.activities.XMLQueryActivity"

                        uniqueName="GetProxyClientId" waitSetting="0"

                        width="94" x="6" y="67">

                        <inputs val="&lt;inputs>&lt;xml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/ForEachProxy_1/values}&lt;/xml>&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>.//@clientId&lt;/xpath>&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;>Integer&lt;/outputType>&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/outputAsList>&lt;/inputs>"/>

                        <transition activity="Decision_35" commented="0"

                            originalStyle="" points="" sourceX="53"

                            sourceY="78" status="0" style="defaultEdge"

                            targetX="66" targetY="125"

                            transitionIndex="0" x="0" y="0">

                            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                        <onEnter language="1" script="logger.info (&quot;Checking if [&quot; + xpath:{/workflow/ForEachProxy_1/values} + &quot;] is active&quot;);"/>

                    </Activity>

                    <Activity commented="0" continueOnFailure="0"

                        created="1548191532206"

                        description="if/else based decision"

                        displayName="Has ID?" height="30"

                        interactive="0" jobMode="0" name="Decision"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="rhombus;fontStyle=1"

                        uniqueName="Decision_35" waitSetting="0"

                        width="100" x="13" y="132">

                        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/GetProxyClientId/result} != null &amp;amp;&amp;amp; xpath:{/workflow/GetProxyClientId/result} &amp;gt; 0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                        <transition activity="Script_12" commented="0"

                            originalStyle="" points="" sourceX="61"

                            sourceY="119" status="0" style="defaultEdge"

                            targetX="120" targetY="37"

                            transitionIndex="0" value="true" x="0" y="0">

                            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                        <transition activity="Script_14" commented="0"

                            originalStyle="" points="" sourceX="61"

                            sourceY="119" status="0" style="defaultEdge"

                            targetX="39" targetY="207"

                            transitionIndex="0" value="false" x="0" y="0">

                            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity commented="0" continueOnFailure="0"

                        created="1583790062135"

                        description="if/else based decision"

                        displayName="Good?" height="29" interactive="0"

                        jobMode="0" name="Decision"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="rhombus;fontStyle=1"

                        uniqueName="Decision_49" waitSetting="0"

                        width="79" x="153" y="74">

                        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/Script_12/output} != null&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                        <transition activity="CheckReady_2"

                            commented="0" displayName="YES"

                            originalStyle="" points="" sourceX="192"

                            sourceY="88" status="0" style="defaultEdge"

                            targetX="258" targetY="113"

                            transitionIndex="0" value="true" x="0" y="0">

                            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                        <transition activity="Script_14" commented="0"

                            displayName="NO" originalStyle=""

                            points="145.0,176.0" sourceX="192"

                            sourceY="88" status="0" style="defaultEdge"

                            targetX="69" targetY="251"

                            transitionIndex="0" value="false" x="0" y="0">

                            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                </superProcess>

                <transition activity="Decision_24" commented="0"

                    originalStyle="" points="" sourceX="130"

                    sourceY="180" status="0" style="defaultEdge"

                    targetX="130" targetY="335" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1520462182289"

                description="if/else based decision"

                displayName="Is Proxy found?" height="37"

                interactive="0" jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_24"

                waitSetting="0" width="158" x="380" y="38">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/oProxyClient} != null &amp;amp;&amp;amp; xpath:{/workflow/variables/oProxyClient/clientId} &amp;gt; 0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="XPathQuery_4" commented="0"

                    displayName="Not found" originalStyle="" points=""

                    sourceX="130" sourceY="335" status="0"

                    style="defaultEdge" targetX="225" targetY="378"

                    transitionIndex="0" value="false" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="Script_15" commented="0"

                    displayName="Found" originalStyle="" points=""

                    sourceX="130" sourceY="335" status="0"

                    style="defaultEdge" targetX="61" targetY="375"

                    transitionIndex="0" value="true" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1520462268765" description="Ends the workflow"

                displayName="WorkflowEnd" height="20" interactive="0"

                jobMode="0" name="WorkflowEnd"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.EndActivity"

                uniqueName="WorkflowEnd_24" waitSetting="0" width="110"

                x="464" y="315">

                <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;>FAILED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>No proxy found or no proxy server accessible to perform the restore of xpath:{/workflow/variables/oDestinationClient/clientName}.&lt;/failureMessage>&lt;/inputs>"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1520462298443"

                description="activity to execute code snippets in the selected language"

                displayName="Continue" height="28" interactive="0"

                jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.ScriptActivity"

                uniqueName="Script_15" waitSetting="0" width="92"

                x="477" y="123">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;&quot; />&lt;/inputs>"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1548191110142"

                description="retrieves a list of values from xml"

                displayName="Get Proxy" height="21" interactive="0"

                jobMode="0" name="XPathQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.XMLQueryActivity"

                uniqueName="XPathQuery_4" waitSetting="0" width="100"

                x="351" y="172">

                <inputs val="&lt;inputs>&lt;xml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/HttpClient_1/output}&lt;/xml>&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>//openVMSProperties/proxyClient/@clientId&lt;/xpath>&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;>Integer&lt;/outputType>&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/outputAsList>&lt;/inputs>"/>

                <transition activity="Script_20" commented="0"

                    originalStyle="" points="" sourceX="225"

                    sourceY="313" status="0" style="defaultEdge"

                    targetX="329" targetY="257" transitionIndex="0"

                    x="-29" y="-121">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1548191139009"

                description="if/else based decision"

                displayName="Found?" height="36" interactive="0"

                jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_34"

                waitSetting="0" width="100" x="473" y="237">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/oProxyClient} != null &amp;amp;&amp;amp; xpath:{/workflow/variables/oProxyClient/clientId} &amp;gt; 0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="Script_15" commented="0"

                    displayName="Found" originalStyle="" points=""

                    sourceX="328" sourceY="341" status="0"

                    style="defaultEdge" targetX="91" targetY="375"

                    transitionIndex="0" value="true" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="WorkflowEnd_24" commented="0"

                    displayName="NO" originalStyle="" points=""

                    sourceX="344" sourceY="332" status="0"

                    style="defaultEdge" targetX="186" targetY="387"

                    transitionIndex="0" value="false" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1548192210531"

                description="activity to execute code snippets in the selected language"

                displayName="Set Proxy" height="34" interactive="0"

                jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.ScriptActivity"

                uniqueName="Script_20" waitSetting="0" width="100"

                x="327" y="238">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;if( xpath:{/workflow/XPathQuery_4/result} != null ) {&amp;#xD;&amp;#xA;    commvault.msgs.CvEntities.ClientEntity clientEntity = commvault.cte.workflow.utils.CommServUtils.getClientEntity( xpath:{/workflow/XPathQuery_4/result} );&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;oProxyClient&amp;quot;, clientEntity );&amp;#xD;&amp;#xA;    return clientEntity;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;return null;&quot; />&lt;/inputs>"/>

                <transition activity="Decision_34" commented="0"

                    originalStyle="" points="" sourceX="329"

                    sourceY="257" status="0" style="defaultEdge"

                    targetX="334" targetY="327" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

        </superProcess>

        <activitySchema>

            <outputs className="" defaultValue="" listType="0"

                name="outputs" type=""/>

            <inputs className="" defaultValue="" listType="0"

                name="inputs" type=""/>

        </activitySchema>

        <transition activity="PrepCounterForQSEC" commented="0"

            originalStyle="" points="" sourceX="1355" sourceY="641"

            status="0" style="defaultEdge" targetX="1694" targetY="1145"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1520463302324"

        description="creates a super process group"

        displayName="Restore QSEC &amp; QCFG archives" height="216"

        interactive="0" jobMode="0" name="ProcessBlock"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ProcessBlock_5" waitSetting="0" width="524" x="1002" y="1690">

        <inputs val="&lt;inputs>&lt;inputs />&lt;/inputs>"/>

        <superProcess>

            <Start commented="0" continueOnFailure="0"

                created="1520463302324" description=""

                displayName="Start" height="20" interactive="0"

                jobMode="0" name="Start" originalStyle=""

                skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_8" waitSetting="0" width="58" x="58" y="35">

                <inputs val="&lt;inputs />"/>

                <transition activity="REST_SEC_CFG" commented="0"

                    originalStyle="" points="" sourceX="88" sourceY="45"

                    status="0" style="defaultEdge" targetX="168"

                    targetY="35" transitionIndex="0" x="38" y="5">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity commented="0" continueOnFailure="1"

                created="1449852128988"

                description="Sends an email to a list of users"

                displayName="Email" height="20" interactive="0"

                jobMode="0" maxRestarts="1" name="Email"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" restartInterval="1" skipAttempt="0"

                style="label;image=Email" uniqueName="Email_3"

                waitSetting="0" width="100" x="385" y="48">

                <onExit language="1" script="workflow.setVariable(&quot;failureMessage&quot;, &quot;Restore job for Security and Configuration objects has failed.&quot;);"/>

                <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot; _list_=&quot;false&quot;>&lt;to class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/executorEMail}&lt;/to>&lt;cc class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;bcc class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;from class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>IBMi-DR-Recovery@xpath:{/workflow/system/commCellName}&lt;/from>&lt;subject class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>IBM i Data Restore job xpath:{/workflow/system/jobId} failed (do not reply)&lt;/subject>&lt;body class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&amp;lt;p&amp;gt;&#xd;&#xa;      Restore job (xpath:{/workflow/QSEC_JOBID/result}) of Security and &#xd;&#xa;      Configuration objects has failed.&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      Please see job details and job log for more information.&#xd;&#xa;    &amp;lt;/p&amp;gt;&lt;/body>&lt;attachments class=&quot;java.lang.Object&quot; _list_=&quot;false&quot; />&lt;html class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/html>&lt;replyTo class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;repeatInterval class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;/email>&lt;/inputs>"/>

                <transition activity="WorkflowEnd_25" commented="0"

                    originalStyle="" points="" sourceX="298"

                    sourceY="205" status="0" style="defaultEdge"

                    targetX="328" targetY="255" transitionIndex="0"

                    x="38" y="5">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1467752617807" description=""

                displayName="Start QSEC &amp; QCFG restore" height="20"

                interactive="0" jobMode="0" name="Execute"

                namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.cmd.operation.OperationExecute"

                uniqueName="REST_SEC_CFG" waitSetting="0" width="200"

                x="138" y="35">

                <inputs val="&lt;inputs>&lt;inputXml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&amp;lt;TMMsg_CreateTaskReq&amp;gt;&amp;#xD;&#xd;&#xa;   &amp;lt;taskInfo&amp;gt;&amp;#xD;&#xd;&#xa;     &amp;lt;associations&amp;gt;&amp;#xD;&#xd;&#xa;       &amp;lt;appName&amp;gt;Proxy Client File System&amp;lt;/appName&amp;gt;&amp;#xD;&#xd;&#xa;       &amp;lt;backupsetName&amp;gt;xpath:{/workflow/variables/backupSetName}&amp;lt;/backupsetName&amp;gt;&amp;#xD;&#xd;&#xa;       &amp;lt;clientName&amp;gt;xpath:{/workflow/variables/sourceClient/clientName}&amp;lt;/clientName&amp;gt;&amp;#xD;&#xd;&#xa;       &amp;lt;clientSidePackage&amp;gt;true&amp;lt;/clientSidePackage&amp;gt;&amp;#xD;&#xd;&#xa;       &amp;lt;consumeLicense&amp;gt;true&amp;lt;/consumeLicense&amp;gt;&amp;#xD;&#xd;&#xa;       &amp;lt;instanceName&amp;gt;DefaultInstanceName&amp;lt;/instanceName&amp;gt;&amp;#xD;&#xd;&#xa;       &amp;lt;subclientName&amp;gt;&amp;lt;/subclientName&amp;gt;&amp;#xD;&#xd;&#xa;       &amp;lt;type&amp;gt;GALAXY&amp;lt;/type&amp;gt;&amp;#xD;&#xd;&#xa;     &amp;lt;/associations&amp;gt;&amp;#xD;&#xd;&#xa;     &amp;lt;subTasks&amp;gt;&amp;#xD;&#xd;&#xa;       &amp;lt;options&amp;gt;&amp;#xD;&#xd;&#xa;         &amp;lt;commonOpts&amp;gt;&amp;#xD;&#xd;&#xa;           &amp;lt;jobDescription&amp;gt;Restore Security and Configuration objects. Parent job xpath:{/workflow/system/jobId}.&amp;lt;/jobDescription&amp;gt;&amp;#xD;&#xd;&#xa;         &amp;lt;/commonOpts&amp;gt;&amp;#xD;&#xd;&#xa;         &amp;lt;restoreOptions&amp;gt;&amp;#xD;&#xd;&#xa;           &amp;lt;browseOption&amp;gt;&amp;#xD;&#xd;&#xa;             &amp;lt;backupset&amp;gt;&amp;#xD;&#xd;&#xa;               &amp;lt;backupsetName&amp;gt;xpath:{/workflow/variables/backupSetName}&amp;lt;/backupsetName&amp;gt;&amp;#xD;&#xd;&#xa;               &amp;lt;clientName&amp;gt;xpath:{/workflow/variables/sourceClient/clientName}&amp;lt;/clientName&amp;gt;&amp;#xD;&#xd;&#xa;             &amp;lt;/backupset&amp;gt;&amp;#xD;&#xd;&#xa;             &amp;lt;commCellId&amp;gt;2&amp;lt;/commCellId&amp;gt;&amp;#xD;&#xd;&#xa;             &amp;lt;useExactIndex&amp;gt;false&amp;lt;/useExactIndex&amp;gt;&amp;#xD;&#xd;&#xa;             xpath:{/workflow/variables/value_TimeRange}&amp;#xD;&#xd;&#xa;             &amp;lt;mediaOption&amp;gt;&amp;#xD;&#xd;&#xa;             xpath:{/workflow/variables/copyPrecedenceXML}&amp;#xD;&#xd;&#xa;             &amp;lt;/mediaOption&amp;gt;&amp;#xD;&#xd;&#xa;           &amp;lt;/browseOption&amp;gt;&amp;#xD;&#xd;&#xa;           &amp;lt;commonOptions&amp;gt;&amp;#xD;&#xd;&#xa;             &amp;lt;detectRegularExpression&amp;gt;true&amp;lt;/detectRegularExpression&amp;gt;&amp;#xD;&#xd;&#xa;             &amp;lt;doNotOverwriteFileOnDisk&amp;gt;false&amp;lt;/doNotOverwriteFileOnDisk&amp;gt;&amp;#xD;&#xd;&#xa;             &amp;lt;iSeriesObject&amp;gt;&amp;#xD;&#xd;&#xa;               &amp;lt;restorePrivateAuthority&amp;gt;xpath:{/workflow/inputs/bPVTAUT}&amp;lt;/restorePrivateAuthority&amp;gt;&amp;#xD;&#xd;&#xa;               &amp;lt;restoreSpooledFileData&amp;gt;xpath:{/workflow/inputs/bSPLFDTA}&amp;lt;/restoreSpooledFileData&amp;gt;&amp;#xD;&#xd;&#xa;               &amp;lt;autl&amp;gt;xpath:{/workflow/inputs/bALWOBJDIF_AUTL}&amp;lt;/autl&amp;gt;&amp;#xD;&#xd;&#xa;               &amp;lt;fileLevel&amp;gt;xpath:{/workflow/inputs/bALWOBJDIF_FILELVL}&amp;lt;/fileLevel&amp;gt;&amp;#xD;&#xd;&#xa;               &amp;lt;owner&amp;gt;xpath:{/workflow/inputs/bALWOBJDIF_OWNER}&amp;lt;/owner&amp;gt;&amp;#xD;&#xd;&#xa;               &amp;lt;pgp&amp;gt;xpath:{/workflow/inputs/bALWOBJDIF_PGP}&amp;lt;/pgp&amp;gt;&amp;#xD;&#xd;&#xa;               &amp;lt;iseriesDifferentObjectType&amp;gt;xpath:{/workflow/variables/value_ALWDIFF}&amp;lt;/iseriesDifferentObjectType&amp;gt;&amp;#xD;&#xd;&#xa;               &amp;lt;forceObjectConversionSelction&amp;gt;xpath:{/workflow/inputs/sOBJCNV}&amp;lt;/forceObjectConversionSelction&amp;gt;&amp;#xD;&#xd;&#xa;               &amp;lt;deferId&amp;gt;xpath:{/workflow/variables/v_sDFRID}&amp;lt;/deferId&amp;gt;&amp;#xD;&#xd;&#xa;             &amp;lt;/iSeriesObject&amp;gt;&amp;#xD;&#xd;&#xa;             &amp;lt;logOutputOption&amp;gt;&amp;#xD;&#xd;&#xa;               &amp;lt;outputType&amp;gt;xpath:{/workflow/variables/value_OUTOUT}&amp;lt;/outputType&amp;gt;&amp;#xD;&#xd;&#xa;               &amp;lt;outputfilename&amp;gt;xpath:{/workflow/inputs/sJOBLOGFileName}&amp;lt;/outputfilename&amp;gt;&amp;#xD;&#xd;&#xa;               &amp;lt;outputMember&amp;gt;xpath:{/workflow/inputs/sJOBLOGMemberName}&amp;lt;/outputMember&amp;gt;&amp;#xD;&#xd;&#xa;               &amp;lt;membertype&amp;gt;xpath:{/workflow/variables/value_MemberType}&amp;lt;/membertype&amp;gt;&amp;#xD;&#xd;&#xa;               &amp;lt;outputTypeInfo&amp;gt;xpath:{/workflow/variables/value_OutputType}&amp;lt;/outputTypeInfo&amp;gt;&amp;#xD;&#xd;&#xa;             &amp;lt;/logOutputOption&amp;gt;&amp;#xD;&#xd;&#xa;             &amp;lt;overwriteFiles&amp;gt;true&amp;lt;/overwriteFiles&amp;gt;&amp;#xD;&#xd;&#xa;             &amp;lt;preserveLevel&amp;gt;1&amp;lt;/preserveLevel&amp;gt;&amp;#xD;&#xd;&#xa;             &amp;lt;stripLevel&amp;gt;0&amp;lt;/stripLevel&amp;gt;&amp;#xD;&#xd;&#xa;             &amp;lt;stripLevelType&amp;gt;PRESERVE_LEVEL&amp;lt;/stripLevelType&amp;gt;&amp;#xD;&#xd;&#xa;             &amp;lt;unconditionalOverwrite&amp;gt;false&amp;lt;/unconditionalOverwrite&amp;gt;&amp;#xD;&#xd;&#xa;             &amp;lt;wildCard&amp;gt;false&amp;lt;/wildCard&amp;gt;&amp;#xD;&#xd;&#xa;           &amp;lt;/commonOptions&amp;gt;&amp;#xD;&#xd;&#xa;           &amp;lt;destination&amp;gt;&amp;#xD;&#xd;&#xa;             &amp;lt;destClient&amp;gt;&amp;#xD;&#xd;&#xa;               &amp;lt;clientName&amp;gt;xpath:{/workflow/variables/oDestinationClient/clientName}&amp;lt;/clientName&amp;gt;&amp;#xD;&#xd;&#xa;             &amp;lt;/destClient&amp;gt;&amp;#xD;&#xd;&#xa;             &amp;lt;iSeriesDestinationAsp&amp;gt;*SAVASP&amp;lt;/iSeriesDestinationAsp&amp;gt;&amp;#xD;&#xd;&#xa;             &amp;lt;iSeriesDestinationAspValue&amp;gt;&amp;lt;/iSeriesDestinationAspValue&amp;gt;&amp;#xD;&#xd;&#xa;             &amp;lt;inPlace&amp;gt;true&amp;lt;/inPlace&amp;gt;&amp;#xD;&#xd;&#xa;             &amp;lt;restoreOnlyIfTargetExists&amp;gt;false&amp;lt;/restoreOnlyIfTargetExists&amp;gt;&amp;#xD;&#xd;&#xa;           &amp;lt;/destination&amp;gt;&amp;#xD;&#xd;&#xa;           &amp;lt;fileOption&amp;gt;&amp;#xD;&#xd;&#xa;             &amp;lt;browseFilters&amp;gt;&amp;amp;lt;?xml version=''1.0'' encoding=''UTF-8''?&amp;amp;gt;&amp;amp;lt;databrowse_Query type=&quot;0&quot; queryId=&quot;0&quot;&amp;amp;gt;&amp;amp;lt;dataParam&amp;amp;gt;&amp;amp;lt;sortParam ascending=&quot;1&quot;&amp;amp;gt;&amp;amp;lt;sortBy val=&quot;38&quot; /&amp;amp;gt;&amp;amp;lt;sortBy val=&quot;0&quot; /&amp;amp;gt;&amp;amp;lt;/sortParam&amp;amp;gt;&amp;amp;lt;paging firstNode=&quot;0&quot; pageSize=&quot;1000&quot; skipNode=&quot;0&quot; /&amp;amp;gt;&amp;amp;lt;/dataParam&amp;amp;gt;&amp;amp;lt;/databrowse_Query&amp;amp;gt;&amp;lt;/browseFilters&amp;gt;&amp;#xD;&#xd;&#xa;             &amp;lt;sourceItem&amp;gt;/&amp;amp;lt;System Configuration&amp;amp;gt;/*ALL - Configuration&amp;lt;/sourceItem&amp;gt;&amp;#xD;&#xd;&#xa;             &amp;lt;sourceItem&amp;gt;/&amp;amp;lt;System Security&amp;amp;gt;/*ALL - Security Attributes&amp;lt;/sourceItem&amp;gt;&amp;#xD;&#xd;&#xa;           &amp;lt;/fileOption&amp;gt;&amp;#xD;&#xd;&#xa;         &amp;lt;/restoreOptions&amp;gt;&amp;#xD;&#xd;&#xa;       &amp;lt;/options&amp;gt;&amp;#xD;&#xd;&#xa;       &amp;lt;subTask&amp;gt;&amp;#xD;&#xd;&#xa;         &amp;lt;operationType&amp;gt;RESTORE&amp;lt;/operationType&amp;gt;&amp;#xD;&#xd;&#xa;         &amp;lt;subTaskType&amp;gt;RESTORE&amp;lt;/subTaskType&amp;gt;&amp;#xD;&#xd;&#xa;       &amp;lt;/subTask&amp;gt;&amp;#xD;&#xd;&#xa;     &amp;lt;/subTasks&amp;gt;&amp;#xD;&#xd;&#xa;     &amp;lt;task&amp;gt;&amp;#xD;&#xd;&#xa;       &amp;lt;initiatedFrom&amp;gt;COMMANDLINE&amp;lt;/initiatedFrom&amp;gt;&amp;#xD;&#xd;&#xa;       &amp;lt;policyType&amp;gt;DATA_PROTECTION&amp;lt;/policyType&amp;gt;&amp;#xD;&#xd;&#xa;       &amp;lt;taskFlags&amp;gt;&amp;#xD;&#xd;&#xa;         &amp;lt;disabled&amp;gt;false&amp;lt;/disabled&amp;gt;&amp;#xD;&#xd;&#xa;       &amp;lt;/taskFlags&amp;gt;&amp;#xD;&#xd;&#xa;       &amp;lt;taskType&amp;gt;IMMEDIATE&amp;lt;/taskType&amp;gt;&amp;#xD;&#xd;&#xa;     &amp;lt;/task&amp;gt;&amp;#xD;&#xd;&#xa;   &amp;lt;/taskInfo&amp;gt;&amp;#xD;&#xd;&#xa; &amp;lt;/TMMsg_CreateTaskReq&amp;gt;&lt;/inputXml>&lt;commandArgs class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/sessionOptions>&lt;escapeXml class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/escapeXml>&lt;/inputs>"/>

                <transition activity="Decision_3" commented="0"

                    originalStyle="" points="" sourceX="-164"

                    sourceY="324" status="0" style="defaultEdge"

                    targetX="-158" targetY="378" transitionIndex="0"

                    x="-359" y="-116">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <onEnter language="1" script="workflow.setVariable(&quot;attemptsRemain&quot;, xpath:{/workflow/variables/attemptsRemain} - 1);"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1467753064751"

                description="retrieves a list of values from xml"

                displayName="Get JOBID" height="20" interactive="0"

                jobMode="0" name="XPathQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.XMLQueryActivity"

                uniqueName="QSEC_JOBID" waitSetting="0" width="90"

                x="10" y="134">

                <inputs val="&lt;inputs>&lt;xml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/REST_SEC_CFG/outputXml}&lt;/xml>&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>//jobIds[last()]/@val&lt;/xpath>&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;>Integer&lt;/outputType>&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/outputAsList>&lt;/inputs>"/>

                <transition activity="WaitForJobCompletion_1"

                    commented="0" originalStyle="" points=""

                    sourceX="-168" sourceY="290" status="0"

                    style="defaultEdge" targetX="70" targetY="290"

                    transitionIndex="0" x="-359" y="-172">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1479323200836"

                description="if/else based decision"

                displayName="Exit Code" height="30" interactive="0"

                jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_3"

                waitSetting="0" width="130" x="9" y="78">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/REST_SEC_CFG/exitCode} == 0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="Decision_17" commented="0"

                    originalStyle="" points="" sourceX="-175"

                    sourceY="319" status="0" style="defaultEdge"

                    targetX="128" targetY="317" transitionIndex="0"

                    value="false" x="-359" y="-286">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="QSEC_JOBID" commented="0"

                    displayName="0" originalStyle="" points=""

                    sourceX="-229" sourceY="334" status="0"

                    style="defaultEdge" targetX="-119" targetY="324"

                    transitionIndex="0" value="true" x="-359" y="-286">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1496337436947"

                description="waits until the list of jobs completes"

                displayName="Wait for job" height="20" interactive="0"

                jobMode="0" name="WaitForJobCompletion"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.WaitForJobCompletion"

                uniqueName="WaitForJobCompletion_1" waitSetting="0"

                width="95" x="3" y="175">

                <inputs val="&lt;inputs>&lt;jobId class=&quot;java.lang.Integer&quot; _list_=&quot;true&quot;>xpath:{/workflow/QSEC_JOBID/result}&lt;/jobId>&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

                <transition activity="Decision_13" commented="0"

                    originalStyle="" points="" sourceX="85"

                    sourceY="270" status="0" style="defaultEdge"

                    targetX="360" targetY="250" transitionIndex="0"

                    x="-359" y="-286">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1496337668915"

                description="if/else based decision"

                displayName="Success?" height="30" interactive="0"

                jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_13"

                waitSetting="0" width="140" x="146" y="170">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/WaitForJobCompletion_1/successful}&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="Decision_17" commented="0"

                    displayName="No" originalStyle="" points=""

                    sourceX="329" sourceY="249" status="0"

                    style="defaultEdge" targetX="337" targetY="362"

                    transitionIndex="0" value="false" x="-390" y="-287">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="Script_11" commented="0"

                    originalStyle="" points="" sourceX="128"

                    sourceY="235" status="0" style="defaultEdge"

                    targetX="128" targetY="265" transitionIndex="0"

                    value="true" x="38" y="5">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1503596380680"

                description="activity to delay the workflow execution in minutes"

                displayName="Delay" height="20" interactive="0"

                jobMode="0" name="Delay"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.DelayActivity"

                uniqueName="Delay_1" waitSetting="0" width="100" x="196" y="77">

                <inputs val="&lt;inputs>&lt;delayLength class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/delay}&lt;/delayLength>&lt;delayInterval class=&quot;workflow.types.DelayInterval&quot; _list_=&quot;false&quot;>Minutes&lt;/delayInterval>&lt;/inputs>"/>

                <transition activity="REST_SEC_CFG" commented="0"

                    originalStyle="" points="" sourceX="31"

                    sourceY="319" status="0" style="defaultEdge"

                    targetX="-166" targetY="236" transitionIndex="0"

                    value="true" x="-359" y="-286">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1503596010142"

                description="if/else based decision" displayName="Retry"

                height="30" interactive="0" jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_17"

                waitSetting="0" width="100" x="185" y="123">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/attemptsRemain} &amp;gt; 0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="Delay_1" commented="0"

                    displayName="Yes" originalStyle="" points=""

                    sourceX="55" sourceY="344" status="0"

                    style="defaultEdge" targetX="47" targetY="263"

                    transitionIndex="0" value="true" x="-390" y="-287">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="Email_3" commented="0"

                    displayName="No" originalStyle="" points=""

                    sourceX="114" sourceY="133" status="0"

                    style="defaultEdge" targetX="674" targetY="263"

                    transitionIndex="0" value="false" x="-26" y="-477">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1503598635487"

                description="activity to execute code snippets in the selected language"

                displayName="Prepare number of attempts" height="20"

                interactive="0" jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.ScriptActivity"

                uniqueName="Script_11" waitSetting="0" width="191"

                x="318" y="173">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;workflow.setVariable(&amp;quot;attemptsRemain&amp;quot;, xpath:{/workflow/inputs/retryAttempts});&quot; />&lt;/inputs>"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1520463433136" description="Ends the workflow"

                displayName="WorkflowEnd" height="20" interactive="0"

                jobMode="0" name="WorkflowEnd"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.EndActivity"

                uniqueName="WorkflowEnd_25" waitSetting="0" width="106"

                x="365" y="93">

                <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;>FAILED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/failureMessage}&lt;/failureMessage>&lt;/inputs>"/>

            </Activity>

        </superProcess>

        <activitySchema>

            <outputs className="" defaultValue="" listType="0"

                name="outputs" type=""/>

            <inputs className="" defaultValue="" listType="0"

                name="inputs" type=""/>

        </activitySchema>

        <transition activity="ProcessBlock_6" commented="0"

            originalStyle="" points="" sourceX="653" sourceY="503"

            status="0" style="defaultEdge" targetX="219" targetY="719"

            transitionIndex="0" x="6" y="20">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1520463575872"

        description="creates a super process group"

        displayName="Restore User profiles" height="241" interactive="0"

        jobMode="0" name="ProcessBlock"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ProcessBlock_6" waitSetting="0" width="394" x="1141" y="1957">

        <inputs val="&lt;inputs>&lt;inputs />&lt;/inputs>"/>

        <superProcess>

            <Start commented="0" continueOnFailure="0"

                created="1520463575872" description=""

                displayName="Start" height="20" interactive="0"

                jobMode="0" name="Start" originalStyle=""

                skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_9" waitSetting="0" width="80" x="10" y="40">

                <inputs val="&lt;inputs />"/>

                <transition activity="RSTUSRPRF" commented="0"

                    originalStyle="" points="" sourceX="80" sourceY="50"

                    status="0" style="defaultEdge" targetX="190"

                    targetY="40" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity commented="0" continueOnFailure="1"

                created="1467311973160"

                description="Execute a command on a remote machine"

                displayName="Run RSTUSRPRF" height="20" interactive="0"

                jobMode="0" maxRestarts="0" name="ExecuteCommand"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=ExecuteCommand" timeout="120"

                uniqueName="RSTUSRPRF" waitSetting="0" width="124"

                x="120" y="40">

                <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/oProxyClient}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>iDataAgent/ClProxyClientUtils&lt;/command>&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/oDestinationClient/clientId} -drrst ''*SEC'' -timelimit xpath:{/workflow/inputs/TimeoutForQSECRestore} &lt;/arguments>&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

                <transition activity="IsSECRSTFailed" commented="0"

                    originalStyle="" points="" sourceX="185"

                    sourceY="202" status="0" style="defaultEdge"

                    targetX="-8" targetY="201" transitionIndex="0"

                    x="-294" y="-323">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <onEnter language="1" script="workflow.setVariable(&quot;attemptsRemain&quot;, xpath:{/workflow/variables/attemptsRemain} - 1);"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1467839934711"

                description="if/else based decision"

                displayName="Success?" height="30" interactive="0"

                jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="IsSECRSTFailed"

                waitSetting="0" width="120" x="29" y="93">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/RSTUSRPRF/exitCode} == 0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="Script_10" commented="0"

                    displayName="Yes" originalStyle="" points=""

                    sourceX="152" sourceY="115" status="0"

                    style="defaultEdge" targetX="40" targetY="114"

                    transitionIndex="0" value="true" x="-227" y="-722">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="Decision_18" commented="0"

                    displayName="No" originalStyle="" points=""

                    sourceX="252" sourceY="196" status="0"

                    style="defaultEdge" targetX="419" targetY="197"

                    transitionIndex="0" value="false" x="-289" y="-635">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="1"

                created="1467840021521"

                description="Sends an email to a list of users"

                displayName="Email" height="20" interactive="0"

                jobMode="0" maxRestarts="1" name="Email"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" restartInterval="1" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.EmailActivity"

                uniqueName="Email_7" waitSetting="0" width="80" x="260" y="150">

                <onExit language="1" script="workflow.setVariable(&quot;failureMessage&quot;, &quot;System Configuration and System Security Objects recovery has failed.&quot;);"/>

                <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot; _list_=&quot;false&quot;>&lt;to class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/executorEMail}&lt;/to>&lt;cc class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;bcc class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;from class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>IBMi-DR-Recovery@xpath:{/workflow/system/commCellName}&lt;/from>&lt;subject class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>IBM i Data Restore job xpath:{/workflow/system/jobId} failed (do not reply) &lt;/subject>&lt;body class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&amp;lt;p&amp;gt;&#xd;&#xa;      System Configuration and System Security Objects recovery has failed.&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      See job log for CVDRRST* job log files for more details on &#xd;&#xa;      xpath:{/workflow/variables/oDestinationClient/clientName} system.&#xd;&#xa;    &amp;lt;/p&amp;gt;&lt;/body>&lt;attachments class=&quot;java.lang.Object&quot; _list_=&quot;false&quot; />&lt;html class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/html>&lt;replyTo class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;repeatInterval class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;/email>&lt;/inputs>"/>

                <transition activity="WorkflowEnd_26" commented="0"

                    originalStyle="" points="" sourceX="300"

                    sourceY="160" status="0" style="defaultEdge"

                    targetX="300" targetY="200" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1503596795274"

                description="if/else based decision" displayName="Retry"

                height="30" interactive="0" jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_18"

                waitSetting="0" width="100" x="246" y="91">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/attemptsRemain} &amp;gt; 0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="Delay_2" commented="0"

                    displayName="Yes" originalStyle="" points=""

                    sourceX="342" sourceY="195" status="0"

                    style="defaultEdge" targetX="367" targetY="118"

                    transitionIndex="0" value="true" x="-227" y="-722">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="Email_7" commented="0"

                    displayName="No" originalStyle="" points=""

                    sourceX="342" sourceY="194" status="0"

                    style="defaultEdge" targetX="509" targetY="193"

                    transitionIndex="0" value="false" x="-227" y="-722">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1503596805881"

                description="activity to delay the workflow execution in minutes"

                displayName="Delay" height="20" interactive="0"

                jobMode="0" name="Delay"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.DelayActivity"

                uniqueName="Delay_2" waitSetting="0" width="70" x="270" y="40">

                <inputs val="&lt;inputs>&lt;delayLength class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/delay}&lt;/delayLength>&lt;delayInterval class=&quot;workflow.types.DelayInterval&quot; _list_=&quot;false&quot;>Minutes&lt;/delayInterval>&lt;/inputs>"/>

                <transition activity="RSTUSRPRF" commented="0"

                    originalStyle="" points="" sourceX="406"

                    sourceY="113" status="0" style="defaultEdge"

                    targetX="297" targetY="102" transitionIndex="0"

                    x="-227" y="-722">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1503598604821"

                description="activity to execute code snippets in the selected language"

                displayName="Prepare number of attempts" height="20"

                interactive="0" jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.ScriptActivity"

                uniqueName="Script_10" waitSetting="0" width="191"

                x="10" y="189">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;workflow.setVariable(&amp;quot;attemptsRemain&amp;quot;, xpath:{/workflow/inputs/retryAttempts});&quot; />&lt;/inputs>"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1520463687721" description="Ends the workflow"

                displayName="WorkflowEnd" height="20" interactive="0"

                jobMode="0" name="WorkflowEnd"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.EndActivity"

                uniqueName="WorkflowEnd_26" waitSetting="0" width="110"

                x="250" y="190">

                <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;>FAILED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/failureMessage}&lt;/failureMessage>&lt;/inputs>"/>

            </Activity>

        </superProcess>

        <activitySchema>

            <outputs className="" defaultValue="" listType="0"

                name="outputs" type=""/>

            <inputs className="" defaultValue="" listType="0"

                name="inputs" type=""/>

        </activitySchema>

        <transition activity="ProcessBlock_7" commented="0"

            originalStyle="" points="" sourceX="204" sourceY="1265"

            status="0" style="defaultEdge" targetX="611" targetY="1466"

            transitionIndex="0" x="-8" y="566">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1520463800882"

        description="creates a super process group" displayName="QSYS"

        height="302" interactive="0" jobMode="0" name="ProcessBlock"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ProcessBlock_7" waitSetting="0" width="382" x="677" y="1926">

        <inputs val="&lt;inputs>&lt;inputs />&lt;/inputs>"/>

        <superProcess>

            <Start commented="0" continueOnFailure="0"

                created="1520463800882" description=""

                displayName="Start" height="20" interactive="0"

                jobMode="0" name="Start" originalStyle=""

                skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_10" waitSetting="0" width="70" x="50" y="34">

                <inputs val="&lt;inputs />"/>

                <transition activity="Restore_QSYS" commented="0"

                    originalStyle="" points="" sourceX="116"

                    sourceY="43" status="0" style="defaultEdge"

                    targetX="286" targetY="43" transitionIndex="0"

                    x="57" y="4">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity commented="0" continueOnFailure="0"

                created="1467057106055" description=""

                displayName="Start QSYS restore" height="20"

                interactive="0" jobMode="0" name="Execute"

                namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                originalStyle="" skipAttempt="0"

                style="label;image=Execute" uniqueName="Restore_QSYS"

                waitSetting="0" width="140" x="199" y="35">

                <inputs val="&lt;inputs>&lt;inputXml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&amp;lt;TMMsg_CreateTaskReq&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;taskInfo&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;associations&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;appName&amp;gt;Proxy Client File System&amp;lt;/appName&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;backupsetName&amp;gt;xpath:{/workflow/variables/backupSetName}&amp;lt;/backupsetName&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;clientName&amp;gt;xpath:{/workflow/variables/sourceClient/clientName}&amp;lt;/clientName&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;clientSidePackage&amp;gt;true&amp;lt;/clientSidePackage&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;consumeLicense&amp;gt;true&amp;lt;/consumeLicense&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;instanceName&amp;gt;DefaultInstanceName&amp;lt;/instanceName&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;subclientName&amp;gt;&amp;lt;/subclientName&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;type&amp;gt;GALAXY&amp;lt;/type&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/associations&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;subTasks&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;options&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;backupOpts&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;backupLevel&amp;gt;INCREMENTAL&amp;lt;/backupLevel&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;/backupOpts&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;commonOpts&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;jobDescription&amp;gt;Restore QSYS data. Parent job xpath:{/workflow/system/jobId}.&amp;lt;/jobDescription&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;/commonOpts&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;restoreOptions&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;browseOption&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;backupset&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;backupsetName&amp;gt;xpath:{/workflow/variables/backupSetName}&amp;lt;/backupsetName&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;clientName&amp;gt;xpath:{/workflow/variables/sourceClient/clientName}&amp;lt;/clientName&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;/backupset&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;commCellId&amp;gt;2&amp;lt;/commCellId&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;listMedia&amp;gt;false&amp;lt;/listMedia&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;specifyRestoreTime&amp;gt;false&amp;lt;/specifyRestoreTime&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;useExactIndex&amp;gt;false&amp;lt;/useExactIndex&amp;gt;&amp;#xD;&#xd;&#xa;            xpath:{/workflow/variables/value_TimeRange}&amp;#xD;&#xd;&#xa;            &amp;lt;mediaOption&amp;gt;&amp;#xD;&#xd;&#xa;            xpath:{/workflow/variables/copyPrecedenceXML}&amp;#xD;&#xd;&#xa;            &amp;lt;/mediaOption&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;/browseOption&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;commonOptions&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;detectRegularExpression&amp;gt;true&amp;lt;/detectRegularExpression&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;doNotOverwriteFileOnDisk&amp;gt;false&amp;lt;/doNotOverwriteFileOnDisk&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;iSeriesObject&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;autl&amp;gt;xpath:{/workflow/inputs/bALWOBJDIF_AUTL}&amp;lt;/autl&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;fileLevel&amp;gt;xpath:{/workflow/inputs/bALWOBJDIF_FILELVL}&amp;lt;/fileLevel&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;forceObjectConversionSelction&amp;gt;xpath:{/workflow/inputs/sOBJCNV}&amp;lt;/forceObjectConversionSelction&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;iseriesDifferentObjectType&amp;gt;xpath:{/workflow/variables/value_ALWDIFF}&amp;lt;/iseriesDifferentObjectType&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;owner&amp;gt;xpath:{/workflow/inputs/bALWOBJDIF_OWNER}&amp;lt;/owner&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;pgp&amp;gt;xpath:{/workflow/inputs/bALWOBJDIF_PGP}&amp;lt;/pgp&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;restorePrivateAuthority&amp;gt;xpath:{/workflow/inputs/bPVTAUT}&amp;lt;/restorePrivateAuthority&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;restoreSpooledFileData&amp;gt;xpath:{/workflow/inputs/bSPLFDTA}&amp;lt;/restoreSpooledFileData&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;deferId&amp;gt;xpath:{/workflow/variables/v_sDFRID}&amp;lt;/deferId&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;/iSeriesObject&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;isFromBrowseBackup&amp;gt;false&amp;lt;/isFromBrowseBackup&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;logOutputOption&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;membertype&amp;gt;xpath:{/workflow/variables/value_MemberType}&amp;lt;/membertype&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;outputMember&amp;gt;xpath:{/workflow/inputs/sJOBLOGMemberName}&amp;lt;/outputMember&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;outputType&amp;gt;xpath:{/workflow/variables/value_OutputType}&amp;lt;/outputType&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;outputTypeInfo&amp;gt;xpath:{/workflow/variables/value_OutputType}&amp;lt;/outputTypeInfo&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;outputfilename&amp;gt;xpath:{/workflow/inputs/sJOBLOGFileName}&amp;lt;/outputfilename&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;/logOutputOption&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;overwriteFiles&amp;gt;true&amp;lt;/overwriteFiles&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;preserveLevel&amp;gt;1&amp;lt;/preserveLevel&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;skipErrorsAndContinue&amp;gt;true&amp;lt;/skipErrorsAndContinue&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;stripLevel&amp;gt;0&amp;lt;/stripLevel&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;stripLevelType&amp;gt;PRESERVE_LEVEL&amp;lt;/stripLevelType&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;unconditionalOverwrite&amp;gt;false&amp;lt;/unconditionalOverwrite&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;wildCard&amp;gt;false&amp;lt;/wildCard&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;/commonOptions&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;destination&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;destClient&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;clientName&amp;gt;xpath:{/workflow/variables/oDestinationClient/clientName}&amp;lt;/clientName&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;/destClient&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;iSeriesDestinationAsp&amp;gt;*SAVASP&amp;lt;/iSeriesDestinationAsp&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;iSeriesDestinationAspValue&amp;gt;&amp;lt;/iSeriesDestinationAspValue&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;inPlace&amp;gt;true&amp;lt;/inPlace&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;isLegalHold&amp;gt;false&amp;lt;/isLegalHold&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;noOfStreams&amp;gt;0&amp;lt;/noOfStreams&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;restoreOnlyIfTargetExists&amp;gt;false&amp;lt;/restoreOnlyIfTargetExists&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;/destination&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;fileOption&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;browseFilters&amp;gt;&amp;amp;lt;?xml version=''1.0'' encoding=''UTF-8''?&amp;amp;gt;&amp;amp;lt;databrowse_Query type=&quot;0&quot; queryId=&quot;0&quot;&amp;amp;gt;&amp;amp;lt;whereClause connector=&quot;0&quot;&amp;amp;gt;&amp;amp;lt;criteria field=&quot;0&quot;&amp;amp;gt;&amp;amp;lt;values val=&quot;/QSYS.LIB/*.LIB/**&quot; /&amp;amp;gt;&amp;amp;lt;/criteria&amp;amp;gt;&amp;amp;lt;/whereClause&amp;amp;gt;&amp;amp;lt;dataParam&amp;amp;gt;&amp;amp;lt;sortParam ascending=&quot;1&quot;&amp;amp;gt;&amp;amp;lt;sortBy val=&quot;38&quot; /&amp;amp;gt;&amp;amp;lt;sortBy val=&quot;0&quot; /&amp;amp;gt;&amp;amp;lt;/sortParam&amp;amp;gt;&amp;amp;lt;paging firstNode=&quot;0&quot; pageSize=&quot;1000&quot; skipNode=&quot;0&quot; /&amp;amp;gt;&amp;amp;lt;/dataParam&amp;amp;gt;&amp;amp;lt;/databrowse_Query&amp;amp;gt;&amp;lt;/browseFilters&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;filterItem&amp;gt;/QSYS.LIB/CVLIB.LIB&amp;lt;/filterItem&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;filterItem&amp;gt;/QSYS.LIB/CVLIBOBJ.LIB&amp;lt;/filterItem&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;filterItem&amp;gt;/QSYS.LIB/QTCP.LIB&amp;lt;/filterItem&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;sourceItem&amp;gt;/QSYS.LIB&amp;lt;/sourceItem&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;/fileOption&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;/restoreOptions&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/options&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;subTask&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;operationType&amp;gt;RESTORE&amp;lt;/operationType&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;subTaskType&amp;gt;RESTORE&amp;lt;/subTaskType&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/subTask&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/subTasks&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;task&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;initiatedFrom&amp;gt;COMMANDLINE&amp;lt;/initiatedFrom&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;policyType&amp;gt;DATA_PROTECTION&amp;lt;/policyType&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;taskFlags&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;disabled&amp;gt;false&amp;lt;/disabled&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/taskFlags&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;taskType&amp;gt;IMMEDIATE&amp;lt;/taskType&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/task&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;/taskInfo&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/TMMsg_CreateTaskReq&amp;gt;&amp;#xD;&#xd;&#xa;&lt;/inputXml>&lt;commandArgs class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/sessionOptions>&lt;escapeXml class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/escapeXml>&lt;/inputs>"/>

                <transition activity="Decision_4" commented="0"

                    originalStyle="" points="" sourceX="258"

                    sourceY="-191" status="0" style="defaultEdge"

                    targetX="258" targetY="-68" transitionIndex="0"

                    x="67" y="-1046">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <onEnter language="1" script="workflow.setVariable(&quot;attemptsRemain&quot;, xpath:{/workflow/variables/attemptsRemain} - 1);"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1467903242581"

                description="retrieves a list of values from xml"

                displayName="Get JOBID" height="20" interactive="0"

                jobMode="0" name="XPathQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.XMLQueryActivity"

                uniqueName="QSYS_JOBID" waitSetting="0" width="90"

                x="36" y="136">

                <inputs val="&lt;inputs>&lt;xml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/Restore_QSYS/outputXml}&lt;/xml>&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>//jobIds[last()]/@val&lt;/xpath>&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;>String&lt;/outputType>&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/outputAsList>&lt;/inputs>"/>

                <transition activity="WaitForJobCompletion_2"

                    commented="0" originalStyle="" points=""

                    sourceX="258" sourceY="-51" status="0"

                    style="defaultEdge" targetX="449" targetY="-52"

                    transitionIndex="0" x="67" y="-1046">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="1"

                created="1479241521512"

                description="Sends an email to a list of users"

                displayName="Email" height="20" interactive="0"

                jobMode="0" maxRestarts="1" name="Email"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" restartInterval="1" skipAttempt="0"

                style="label;image=Email" uniqueName="Email_16"

                waitSetting="0" width="70" x="251" y="205">

                <onExit language="1" script="workflow.setVariable(&quot;failureMessage&quot;, &quot;Restore job for QSYS libraries has failed.&quot;);"/>

                <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot; _list_=&quot;false&quot;>&lt;to class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/executorEMail}&lt;/to>&lt;cc class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;bcc class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;from class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>IBMi-DR-Recovery@xpath:{/workflow/system/commCellName}&lt;/from>&lt;subject class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>IBM i Data Restore job xpath:{/workflow/system/jobId} killed (do not reply)&lt;/subject>&lt;body class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&amp;lt;p&amp;gt;&#xd;&#xa;      Restore job (xpath:{/workflow/QSYS_JOBID/result}) of QSYS objects has &#xd;&#xa;      been killed.&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      Please see job details and job log for more information.&#xd;&#xa;    &amp;lt;/p&amp;gt;&lt;/body>&lt;attachments class=&quot;java.lang.Object&quot; _list_=&quot;false&quot; />&lt;html class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/html>&lt;replyTo class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;repeatInterval class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;/email>&lt;/inputs>"/>

                <transition activity="WorkflowEnd_27" commented="0"

                    originalStyle="" points="" sourceX="287"

                    sourceY="214" status="0" style="defaultEdge"

                    targetX="357" targetY="264" transitionIndex="0"

                    x="57" y="4">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1479323307149"

                description="if/else based decision"

                displayName="Exit code" height="40" interactive="0"

                jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_4"

                waitSetting="0" width="125" x="43" y="71">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/Restore_QSYS/exitCode}==0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="QSYS_JOBID" commented="0"

                    displayName="0" originalStyle="" points=""

                    sourceX="257" sourceY="-146" status="0"

                    style="defaultEdge" targetX="257" targetY="-66"

                    transitionIndex="0" value="true" x="67" y="-1046">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="Decision_22" commented="0"

                    originalStyle="" points="" sourceX="257"

                    sourceY="-146" status="0" style="defaultEdge"

                    targetX="807" targetY="84" transitionIndex="0"

                    value="false" x="67" y="-1046">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1496847106540"

                description="waits until the list of jobs completes"

                displayName="Wait for Job" height="20" interactive="0"

                jobMode="0" name="WaitForJobCompletion"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.WaitForJobCompletion"

                uniqueName="WaitForJobCompletion_2" waitSetting="0"

                width="110" x="26" y="181">

                <inputs val="&lt;inputs>&lt;jobId class=&quot;java.lang.Integer&quot; _list_=&quot;true&quot;>xpath:{/workflow/QSYS_JOBID/result}&lt;/jobId>&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

                <transition activity="Decision_14" commented="0"

                    originalStyle="" points="" sourceX="396"

                    sourceY="-72" status="0" style="defaultEdge"

                    targetX="559" targetY="-73" transitionIndex="0"

                    x="68" y="-1059">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1496847207534"

                description="if/else based decision"

                displayName="Success?" height="30" interactive="0"

                jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_14"

                waitSetting="0" width="130" x="10" y="222">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/WaitForJobCompletion_2/successful}&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="Decision_22" commented="0"

                    displayName="No" originalStyle="" points=""

                    sourceX="594" sourceY="264" status="0"

                    style="defaultEdge" targetX="656" targetY="-138"

                    transitionIndex="0" value="false" x="67" y="-1046">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="Script_9" commented="0"

                    displayName="Yes" originalStyle="" points=""

                    sourceX="759" sourceY="-3" status="0"

                    style="defaultEdge" targetX="675" targetY="232"

                    transitionIndex="0" value="true" x="97" y="-963">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1503597634724"

                description="if/else based decision"

                displayName="Retry?" height="41" interactive="0"

                jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_22"

                waitSetting="0" width="100" x="235" y="130">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/attemptsRemain} &amp;gt; 0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="Email_16" commented="0"

                    displayName="No" originalStyle="" points=""

                    sourceX="729" sourceY="-86" status="0"

                    style="defaultEdge" targetX="826" targetY="-14"

                    transitionIndex="0" value="false" x="67" y="-1046">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="Delay_6" commented="0"

                    displayName="Yes" originalStyle="" points=""

                    sourceX="522" sourceY="129" status="0"

                    style="defaultEdge" targetX="527" targetY="51"

                    transitionIndex="0" value="true" x="67" y="-1046">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1503597834677"

                description="activity to delay the workflow execution in minutes"

                displayName="Delay" height="20" interactive="0"

                jobMode="0" name="Delay"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.DelayActivity"

                uniqueName="Delay_6" waitSetting="0" width="100" x="240" y="75">

                <inputs val="&lt;inputs>&lt;delayLength class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/delay}&lt;/delayLength>&lt;delayInterval class=&quot;workflow.types.DelayInterval&quot; _list_=&quot;false&quot;>Minutes&lt;/delayInterval>&lt;/inputs>"/>

                <transition activity="Restore_QSYS" commented="0"

                    originalStyle="" points="" sourceX="526"

                    sourceY="133" status="0" style="defaultEdge"

                    targetX="304" targetY="-218" transitionIndex="0"

                    x="97" y="-963">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1503598580978"

                description="activity to execute code snippets in the selected language"

                displayName="Prepare number of attempts" height="21"

                interactive="0" jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.ScriptActivity"

                uniqueName="Script_9" waitSetting="0" width="191" x="13" y="272">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;workflow.setVariable(&amp;quot;attemptsRemain&amp;quot;, xpath:{/workflow/inputs/retryAttempts});&quot; />&lt;/inputs>"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1520463949954" description="Ends the workflow"

                displayName="WorkflowEnd" height="20" interactive="0"

                jobMode="0" name="WorkflowEnd"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.EndActivity"

                uniqueName="WorkflowEnd_27" waitSetting="0" width="110"

                x="249" y="253">

                <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot; />&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/failureMessage}&lt;/failureMessage>&lt;/inputs>"/>

            </Activity>

        </superProcess>

        <activitySchema>

            <outputs className="" defaultValue="" listType="0"

                name="outputs" type=""/>

            <inputs className="" defaultValue="" listType="0"

                name="inputs" type=""/>

        </activitySchema>

        <transition activity="ProcessBlock_8" commented="0"

            originalStyle="" points="" sourceX="611" sourceY="1466"

            status="0" style="defaultEdge" targetX="198" targetY="1582"

            transitionIndex="0" x="-8" y="566">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1520463987970"

        description="creates a super process group" displayName="DLO"

        height="230" interactive="0" jobMode="0" name="ProcessBlock"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ProcessBlock_8" waitSetting="0" width="541" x="60" y="2272">

        <inputs val="&lt;inputs>&lt;inputs />&lt;/inputs>"/>

        <superProcess>

            <Start commented="0" continueOnFailure="0"

                created="1520463987970" description=""

                displayName="Start" height="20" interactive="0"

                jobMode="0" name="Start" originalStyle=""

                skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_11" waitSetting="0" width="60" x="20" y="30">

                <inputs val="&lt;inputs />"/>

                <transition activity="RCLDLO" commented="0"

                    originalStyle="" points="" sourceX="52" sourceY="44"

                    status="0" style="defaultEdge" targetX="312"

                    targetY="94" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity commented="0" continueOnFailure="1"

                created="1467903670059"

                description="Execute a command on a remote machine"

                displayName="Run RCLDLO" height="20" interactive="0"

                jobMode="0" maxRestarts="0" name="ExecuteCommand"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=ExecuteCommand" timeout="120"

                uniqueName="RCLDLO" waitSetting="0" width="110" x="100" y="30">

                <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/oProxyClient}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>iDataAgent/ClProxyClientUtils&lt;/command>&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/oDestinationClient/clientId} -drrst ''*DLO'' -timelimit xpath:{/workflow/inputs/TimeoutForQSECRestore} &lt;/arguments>&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

                <transition activity="IsDLOFailed" commented="0"

                    originalStyle="" points="" sourceX="385"

                    sourceY="128" status="0" style="defaultEdge"

                    targetX="224" targetY="175" transitionIndex="0"

                    x="-158" y="-1028">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <onEnter language="1" script="workflow.setVariable(&quot;attemptsRemain&quot;, xpath:{/workflow/variables/attemptsRemain} - 1);"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1467903793888"

                description="if/else based decision"

                displayName="Success?" height="30" interactive="0"

                jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="IsDLOFailed"

                waitSetting="0" width="110" x="22" y="84">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/RCLDLO/exitCode} == 0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="Script_8" commented="0"

                    displayName="Yes" originalStyle="" points=""

                    sourceX="260" sourceY="3" status="0"

                    style="defaultEdge" targetX="148" targetY="2"

                    transitionIndex="0" value="true" x="-119" y="-834">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="Decision_21" commented="0"

                    displayName="No" originalStyle="" points=""

                    sourceX="403" sourceY="76" status="0"

                    style="defaultEdge" targetX="507" targetY="129"

                    transitionIndex="0" value="false" x="-156" y="-709">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="1"

                created="1467903793970"

                description="Sends an email to a list of users"

                displayName="Email" height="20" interactive="0"

                jobMode="0" maxRestarts="1" name="Email"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" restartInterval="1" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.EmailActivity"

                uniqueName="Email_9" waitSetting="0" width="100" x="231" y="148">

                <onExit language="1" script="workflow.setVariable(&quot;failureMessage&quot;, &quot;Reclaim of the document library objects has failed.&quot;);"/>

                <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot; _list_=&quot;false&quot;>&lt;to class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/executorEMail}&lt;/to>&lt;cc class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;bcc class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;from class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>IBMi-DR-Recovery@xpath:{/workflow/system/commCellName}&lt;/from>&lt;subject class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>IBM i Data Restore job xpath:{/workflow/system/jobId} failed (do not reply)&lt;/subject>&lt;body class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&amp;lt;p&amp;gt;&#xd;&#xa;      The reclaim of the document library objects job has failed.&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      See job log for CVDRRST* job log files for more details on &#xd;&#xa;      xpath:{/workflow/variables/oDestinationClient/clientName} system.&#xd;&#xa;    &amp;lt;/p&amp;gt;&lt;/body>&lt;attachments class=&quot;java.lang.Object&quot; _list_=&quot;false&quot; />&lt;html class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/html>&lt;replyTo class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;repeatInterval class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;/email>&lt;/inputs>"/>

                <transition activity="WorkflowEnd_28" commented="0"

                    originalStyle="" points="" sourceX="282"

                    sourceY="154" status="0" style="defaultEdge"

                    targetX="342" targetY="234" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1503597509174"

                description="if/else based decision"

                displayName="Retry?" height="30" interactive="0"

                jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_21"

                waitSetting="0" width="100" x="230" y="90">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/attemptsRemain} &amp;gt; 0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="Email_9" commented="0"

                    displayName="No" originalStyle="" points=""

                    sourceX="384" sourceY="144" status="0"

                    style="defaultEdge" targetX="386" targetY="220"

                    transitionIndex="0" value="false" x="5" y="-693">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="Delay_5" commented="0"

                    displayName="Yes" originalStyle="" points=""

                    sourceX="482" sourceY="185" status="0"

                    style="defaultEdge" targetX="485" targetY="110"

                    transitionIndex="0" value="true" x="-98" y="-1458">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1503597574398"

                description="activity to delay the workflow execution in minutes"

                displayName="Delay" height="20" interactive="0"

                jobMode="0" name="Delay"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.DelayActivity"

                uniqueName="Delay_5" waitSetting="0" width="100" x="236" y="30">

                <inputs val="&lt;inputs>&lt;delayLength class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/delay}&lt;/delayLength>&lt;delayInterval class=&quot;workflow.types.DelayInterval&quot; _list_=&quot;false&quot;>Minutes&lt;/delayInterval>&lt;/inputs>"/>

                <transition activity="RCLDLO" commented="0"

                    originalStyle="" points="" sourceX="485"

                    sourceY="110" status="0" style="defaultEdge"

                    targetX="377" targetY="106" transitionIndex="0"

                    x="-108" y="-1200">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1503598559002"

                description="activity to execute code snippets in the selected language"

                displayName="Prepare number of attempts" height="20"

                interactive="0" jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.ScriptActivity"

                uniqueName="Script_8" waitSetting="0" width="191" x="9" y="180">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;workflow.setVariable(&amp;quot;attemptsRemain&amp;quot;, xpath:{/workflow/inputs/retryAttempts});&quot; />&lt;/inputs>"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1520464082781" description="Ends the workflow"

                displayName="WorkflowEnd" height="20" interactive="0"

                jobMode="0" name="WorkflowEnd"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.EndActivity"

                uniqueName="WorkflowEnd_28" waitSetting="0" width="110"

                x="223" y="184">

                <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot; />&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/failureMessage}&lt;/failureMessage>&lt;/inputs>"/>

            </Activity>

        </superProcess>

        <activitySchema>

            <outputs className="" defaultValue="" listType="0"

                name="outputs" type=""/>

            <inputs className="" defaultValue="" listType="0"

                name="inputs" type=""/>

        </activitySchema>

        <transition activity="ProcessBlock_9" commented="0"

            originalStyle="" points="" sourceX="198" sourceY="1582"

            status="0" style="defaultEdge" targetX="596" targetY="1834"

            transitionIndex="0" x="-8" y="566">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1520464120282"

        description="creates a super process group"

        displayName="Restore DLO data" height="320" interactive="0"

        jobMode="0" name="ProcessBlock"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ProcessBlock_9" waitSetting="0" width="403" x="704" y="2280">

        <inputs val="&lt;inputs>&lt;inputs />&lt;/inputs>"/>

        <superProcess>

            <Start commented="0" continueOnFailure="0"

                created="1520464120282" description=""

                displayName="Start" height="20" interactive="0"

                jobMode="0" name="Start" originalStyle=""

                skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_12" waitSetting="0" width="60" x="55" y="41">

                <inputs val="&lt;inputs />"/>

                <transition activity="RestoreQDLO" commented="0"

                    originalStyle="" points="" sourceX="90" sourceY="54"

                    status="0" style="defaultEdge" targetX="250"

                    targetY="74" transitionIndex="0" x="35" y="1">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity commented="0" continueOnFailure="0"

                created="1467903793813" description=""

                displayName="Start QDLO restore" height="20"

                interactive="0" jobMode="0" name="Execute"

                namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                originalStyle="" skipAttempt="0"

                style="label;image=Execute" uniqueName="RestoreQDLO"

                waitSetting="0" width="150" x="145" y="41">

                <inputs val="&lt;inputs>&lt;inputXml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&amp;lt;TMMsg_CreateTaskReq&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;taskInfo&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;associations&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;appName&amp;gt;Proxy Client File System&amp;lt;/appName&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;backupsetName&amp;gt;xpath:{/workflow/variables/backupSetName}&amp;lt;/backupsetName&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;clientName&amp;gt;xpath:{/workflow/variables/sourceClient/clientName}&amp;lt;/clientName&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;clientSidePackage&amp;gt;true&amp;lt;/clientSidePackage&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;consumeLicense&amp;gt;true&amp;lt;/consumeLicense&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;instanceName&amp;gt;DefaultInstanceName&amp;lt;/instanceName&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;subclientName&amp;gt;&amp;lt;/subclientName&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;type&amp;gt;GALAXY&amp;lt;/type&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/associations&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;subTasks&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;options&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;backupOpts&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;backupLevel&amp;gt;INCREMENTAL&amp;lt;/backupLevel&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;/backupOpts&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;commonOpts&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;jobDescription&amp;gt;Restore DLO data. Parent job xpath:{/workflow/system/jobId}.&amp;lt;/jobDescription&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;/commonOpts&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;restoreOptions&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;browseOption&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;backupset&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;backupsetName&amp;gt;xpath:{/workflow/variables/backupSetName}&amp;lt;/backupsetName&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;clientName&amp;gt;xpath:{/workflow/variables/sourceClient/clientName}&amp;lt;/clientName&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;/backupset&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;commCellId&amp;gt;2&amp;lt;/commCellId&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;listMedia&amp;gt;false&amp;lt;/listMedia&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;specifyRestoreTime&amp;gt;false&amp;lt;/specifyRestoreTime&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;useExactIndex&amp;gt;false&amp;lt;/useExactIndex&amp;gt;&amp;#xD;&#xd;&#xa;            xpath:{/workflow/variables/value_TimeRange}&amp;#xD;&#xd;&#xa;            &amp;lt;mediaOption&amp;gt;&amp;#xD;&#xd;&#xa;            xpath:{/workflow/variables/copyPrecedenceXML}&amp;#xD;&#xd;&#xa;            &amp;lt;/mediaOption&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;/browseOption&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;commonOptions&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;detectRegularExpression&amp;gt;true&amp;lt;/detectRegularExpression&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;doNotOverwriteFileOnDisk&amp;gt;false&amp;lt;/doNotOverwriteFileOnDisk&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;iSeriesObject&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;autl&amp;gt;false&amp;lt;/autl&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;fileLevel&amp;gt;false&amp;lt;/fileLevel&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;forceObjectConversionSelction&amp;gt;*SYSVAL&amp;lt;/forceObjectConversionSelction&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;iseriesDifferentObjectType&amp;gt;NONE&amp;lt;/iseriesDifferentObjectType&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;owner&amp;gt;false&amp;lt;/owner&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;pgp&amp;gt;false&amp;lt;/pgp&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;restorePrivateAuthority&amp;gt;true&amp;lt;/restorePrivateAuthority&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;restoreSpooledFileData&amp;gt;true&amp;lt;/restoreSpooledFileData&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;/iSeriesObject&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;isFromBrowseBackup&amp;gt;false&amp;lt;/isFromBrowseBackup&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;logOutputOption&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;membertype&amp;gt;0&amp;lt;/membertype&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;outputMember&amp;gt;&amp;lt;/outputMember&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;outputType&amp;gt;1&amp;lt;/outputType&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;outputTypeInfo&amp;gt;0&amp;lt;/outputTypeInfo&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;outputfilename&amp;gt;&amp;lt;/outputfilename&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;/logOutputOption&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;overwriteFiles&amp;gt;true&amp;lt;/overwriteFiles&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;preserveLevel&amp;gt;1&amp;lt;/preserveLevel&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;skipErrorsAndContinue&amp;gt;true&amp;lt;/skipErrorsAndContinue&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;stripLevel&amp;gt;0&amp;lt;/stripLevel&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;stripLevelType&amp;gt;PRESERVE_LEVEL&amp;lt;/stripLevelType&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;unconditionalOverwrite&amp;gt;false&amp;lt;/unconditionalOverwrite&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;wildCard&amp;gt;false&amp;lt;/wildCard&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;/commonOptions&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;destination&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;destClient&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;clientName&amp;gt;xpath:{/workflow/variables/oDestinationClient/clientName}&amp;lt;/clientName&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;/destClient&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;iSeriesDestinationAsp&amp;gt;*SAVASP&amp;lt;/iSeriesDestinationAsp&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;iSeriesDestinationAspValue&amp;gt;&amp;lt;/iSeriesDestinationAspValue&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;inPlace&amp;gt;true&amp;lt;/inPlace&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;isLegalHold&amp;gt;false&amp;lt;/isLegalHold&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;noOfStreams&amp;gt;0&amp;lt;/noOfStreams&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;restoreOnlyIfTargetExists&amp;gt;false&amp;lt;/restoreOnlyIfTargetExists&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;/destination&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;fileOption&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;browseFilters&amp;gt;&amp;amp;lt;?xml version=''1.0'' encoding=''UTF-8''?&amp;amp;gt;&amp;amp;lt;databrowse_Query type=&quot;0&quot; queryId=&quot;0&quot;&amp;amp;gt;&amp;amp;lt;dataParam&amp;amp;gt;&amp;amp;lt;sortParam ascending=&quot;1&quot;&amp;amp;gt;&amp;amp;lt;sortBy val=&quot;38&quot; /&amp;amp;gt;&amp;amp;lt;sortBy val=&quot;0&quot; /&amp;amp;gt;&amp;amp;lt;/sortParam&amp;amp;gt;&amp;amp;lt;paging firstNode=&quot;0&quot; pageSize=&quot;1000&quot; skipNode=&quot;0&quot; /&amp;amp;gt;&amp;amp;lt;/dataParam&amp;amp;gt;&amp;amp;lt;/databrowse_Query&amp;amp;gt;&amp;lt;/browseFilters&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;sourceItem&amp;gt;/QDLS&amp;lt;/sourceItem&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;sourceItem&amp;gt;/QOpenSys/etc&amp;lt;/sourceItem&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;/fileOption&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;/restoreOptions&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/options&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;subTask&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;operationType&amp;gt;RESTORE&amp;lt;/operationType&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;subTaskType&amp;gt;RESTORE&amp;lt;/subTaskType&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/subTask&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/subTasks&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;task&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;initiatedFrom&amp;gt;COMMANDLINE&amp;lt;/initiatedFrom&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;policyType&amp;gt;DATA_PROTECTION&amp;lt;/policyType&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;taskFlags&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;disabled&amp;gt;false&amp;lt;/disabled&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/taskFlags&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;taskType&amp;gt;IMMEDIATE&amp;lt;/taskType&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/task&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;/taskInfo&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/TMMsg_CreateTaskReq&amp;gt;&amp;#xD;&#xd;&#xa;&lt;/inputXml>&lt;commandArgs class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/sessionOptions>&lt;escapeXml class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/escapeXml>&lt;/inputs>"/>

                <transition activity="Decision_5" commented="0"

                    originalStyle="" points="" sourceX="309"

                    sourceY="25" status="0" style="defaultEdge"

                    targetX="309" targetY="156" transitionIndex="0"

                    x="114" y="-877">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <onEnter language="1" script="workflow.setVariable(&quot;attemptsRemain&quot;, xpath:{/workflow/variables/attemptsRemain} - 1);"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1467903794228"

                description="retrieves a list of values from xml"

                displayName="Get JOBID" height="20" interactive="0"

                jobMode="0" name="XPathQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.XMLQueryActivity"

                uniqueName="GetQDLOJobID" waitSetting="0" width="110"

                x="43" y="141">

                <inputs val="&lt;inputs>&lt;xml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/RestoreQDLO/outputXml}&lt;/xml>&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>//jobIds[last()]/@val&lt;/xpath>&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;>String&lt;/outputType>&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/outputAsList>&lt;/inputs>"/>

                <transition activity="WaitForJobCompletion_3"

                    commented="0" originalStyle="" points=""

                    sourceX="299" sourceY="84" status="0"

                    style="defaultEdge" targetX="490" targetY="83"

                    transitionIndex="0" x="108" y="-911">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="1"

                created="1479241820870"

                description="Sends an email to a list of users"

                displayName="Email" height="20" interactive="0"

                jobMode="0" maxRestarts="1" name="Email"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" restartInterval="1" skipAttempt="0"

                style="label;image=Email" uniqueName="Email_17"

                waitSetting="0" width="100" x="245" y="211">

                <onExit language="1" script="workflow.setVariable(&quot;failureMessage&quot;, &quot;QDLO Restore job has failed.&quot;);"/>

                <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot; _list_=&quot;false&quot;>&lt;to class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/executorEMail}&lt;/to>&lt;cc class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;bcc class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;from class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>IBMi-DR-Recovery@xpath:{/workflow/system/commCellName}&lt;/from>&lt;subject class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>IBM i Data Restore job xpath:{/workflow/system/jobId} killed (do not reply)&lt;/subject>&lt;body class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&amp;lt;p&amp;gt;&#xd;&#xa;      Restore job (xpath:{/workflow/GetQDLOJobID/result}) of DLO data has been &#xd;&#xa;      killed.&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      Please see job details and job log for more information.&#xd;&#xa;    &amp;lt;/p&amp;gt;&lt;/body>&lt;attachments class=&quot;java.lang.Object&quot; _list_=&quot;false&quot; />&lt;html class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/html>&lt;replyTo class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;repeatInterval class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;/email>&lt;/inputs>"/>

                <transition activity="WorkflowEnd_29" commented="0"

                    originalStyle="" points="" sourceX="300"

                    sourceY="224" status="0" style="defaultEdge"

                    targetX="320" targetY="274" transitionIndex="0"

                    x="35" y="1">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1479323404008"

                description="if/else based decision"

                displayName="Exit code" height="30" interactive="0"

                jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_5"

                waitSetting="0" width="130" x="45" y="78">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/RestoreQDLO/exitCode}==0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="Decision_20" commented="0"

                    originalStyle="" points="" sourceX="313"

                    sourceY="87" status="0" style="defaultEdge"

                    targetX="863" targetY="307" transitionIndex="0"

                    value="false" x="113" y="-1193">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="GetQDLOJobID" commented="0"

                    displayName="0" originalStyle="" points=""

                    sourceX="318" sourceY="15" status="0"

                    style="defaultEdge" targetX="318" targetY="95"

                    transitionIndex="0" value="true" x="118" y="-1265">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1496847808706"

                description="waits until the list of jobs completes"

                displayName="Wait for Job" height="20" interactive="0"

                jobMode="0" name="WaitForJobCompletion"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.WaitForJobCompletion"

                uniqueName="WaitForJobCompletion_3" waitSetting="0"

                width="110" x="43" y="184">

                <inputs val="&lt;inputs>&lt;jobId class=&quot;java.lang.Integer&quot; _list_=&quot;true&quot;>xpath:{/workflow/GetQDLOJobID/result}&lt;/jobId>&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

                <transition activity="Decision_15" commented="0"

                    originalStyle="" points="" sourceX="481"

                    sourceY="51" status="0" style="defaultEdge"

                    targetX="503" targetY="148" transitionIndex="0"

                    x="116" y="-1285">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1496847837367"

                description="if/else based decision"

                displayName="Success?" height="30" interactive="0"

                jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_15"

                waitSetting="0" width="130" x="38" y="220">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/WaitForJobCompletion_3/successful}&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="Script_7" commented="0"

                    displayName="Yes" originalStyle="" points=""

                    sourceX="461" sourceY="242" status="0"

                    style="defaultEdge" targetX="423" targetY="377"

                    transitionIndex="0" value="true" x="102" y="-1002">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="Decision_20" commented="0"

                    displayName="No" originalStyle="" points=""

                    sourceX="594" sourceY="262" status="0"

                    style="defaultEdge" targetX="780" targetY="55"

                    transitionIndex="0" value="false" x="113" y="-1193">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1503597375927"

                description="if/else based decision" displayName="Retry"

                height="30" interactive="0" jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_20"

                waitSetting="0" width="100" x="197" y="133">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/attemptsRemain} &amp;gt; 0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="Email_17" commented="0"

                    displayName="No" originalStyle="" points=""

                    sourceX="673" sourceY="135" status="0"

                    style="defaultEdge" targetX="854" targetY="209"

                    transitionIndex="0" value="false" x="113" y="-1193">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="Delay_4" commented="0"

                    displayName="Yes" originalStyle="" points=""

                    sourceX="525" sourceY="140" status="0"

                    style="defaultEdge" targetX="522" targetY="64"

                    transitionIndex="0" value="true" x="113" y="-1193">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1503597431532"

                description="activity to delay the workflow execution in minutes"

                displayName="Delay" height="20" interactive="0"

                jobMode="0" name="Delay"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.DelayActivity"

                uniqueName="Delay_4" waitSetting="0" width="100" x="237" y="83">

                <inputs val="&lt;inputs>&lt;delayLength class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/delay}&lt;/delayLength>&lt;delayInterval class=&quot;workflow.types.DelayInterval&quot; _list_=&quot;false&quot;>Minutes&lt;/delayInterval>&lt;/inputs>"/>

                <transition activity="RestoreQDLO" commented="0"

                    originalStyle="" points="" sourceX="525"

                    sourceY="140" status="0" style="defaultEdge"

                    targetX="389" targetY="-23" transitionIndex="0"

                    x="92" y="-1409">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1503598498254"

                description="activity to execute code snippets in the selected language"

                displayName="Prepare number of attempts" height="20"

                interactive="0" jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.ScriptActivity"

                uniqueName="Script_7" waitSetting="0" width="191" x="41" y="281">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;workflow.setVariable(&amp;quot;attemptsRemain&amp;quot;, xpath:{/workflow/inputs/retryAttempts});&quot; />&lt;/inputs>"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1520464254161" description="Ends the workflow"

                displayName="WorkflowEnd" height="20" interactive="0"

                jobMode="0" name="WorkflowEnd"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.EndActivity"

                uniqueName="WorkflowEnd_29" waitSetting="0" width="106"

                x="240" y="279">

                <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot; />&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/failureMessage}&lt;/failureMessage>&lt;/inputs>"/>

            </Activity>

        </superProcess>

        <activitySchema>

            <outputs className="" defaultValue="" listType="0"

                name="outputs" type=""/>

            <inputs className="" defaultValue="" listType="0"

                name="inputs" type=""/>

        </activitySchema>

        <transition activity="ProcessBlock_10" commented="0"

            originalStyle="" points="" sourceX="596" sourceY="1834"

            status="0" style="defaultEdge" targetX="180" targetY="1994"

            transitionIndex="0" x="-8" y="566">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1520464307132"

        description="creates a super process group"

        displayName="Restore IFS data" height="320" interactive="0"

        jobMode="0" name="ProcessBlock"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ProcessBlock_10" waitSetting="0" width="310" x="718" y="2675">

        <inputs val="&lt;inputs>&lt;inputs />&lt;/inputs>"/>

        <superProcess>

            <Start commented="0" continueOnFailure="0"

                created="1520464307132" description=""

                displayName="Start" height="30" interactive="0"

                jobMode="0" name="Start" originalStyle=""

                skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_13" waitSetting="0" width="58" x="20" y="30">

                <inputs val="&lt;inputs />"/>

                <transition activity="StartAllRestore" commented="0"

                    originalStyle="" points="" sourceX="50" sourceY="50"

                    status="0" style="defaultEdge" targetX="150"

                    targetY="40" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity commented="0" continueOnFailure="0"

                created="1467904160019" description=""

                displayName="Start User and IFS restore" height="20"

                interactive="0" jobMode="0" name="Execute"

                namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                originalStyle="" skipAttempt="0"

                style="label;image=Execute" uniqueName="StartAllRestore"

                waitSetting="0" width="177" x="100" y="40">

                <inputs val="&lt;inputs>&lt;inputXml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&amp;lt;TMMsg_CreateTaskReq&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;taskInfo&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;associations&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;appName&amp;gt;Proxy Client File System&amp;lt;/appName&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;backupsetName&amp;gt;xpath:{/workflow/variables/backupSetName}&amp;lt;/backupsetName&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;clientName&amp;gt;xpath:{/workflow/variables/sourceClient/clientName}&amp;lt;/clientName&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;clientSidePackage&amp;gt;true&amp;lt;/clientSidePackage&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;consumeLicense&amp;gt;true&amp;lt;/consumeLicense&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;instanceName&amp;gt;DefaultInstanceName&amp;lt;/instanceName&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;subclientName&amp;gt;&amp;lt;/subclientName&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;type&amp;gt;GALAXY&amp;lt;/type&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/associations&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;subTasks&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;options&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;backupOpts&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;backupLevel&amp;gt;INCREMENTAL&amp;lt;/backupLevel&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;/backupOpts&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;commonOpts&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;jobDescription&amp;gt;Restore User and IFS data. Parent job xpath:{/workflow/system/jobId}.&amp;lt;/jobDescription&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;/commonOpts&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;restoreOptions&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;browseOption&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;backupset&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;backupsetName&amp;gt;xpath:{/workflow/variables/backupSetName}&amp;lt;/backupsetName&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;clientName&amp;gt;xpath:{/workflow/variables/sourceClient/clientName}&amp;lt;/clientName&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;/backupset&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;commCellId&amp;gt;2&amp;lt;/commCellId&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;useExactIndex&amp;gt;false&amp;lt;/useExactIndex&amp;gt;&amp;#xD;&#xd;&#xa;            xpath:{/workflow/variables/value_TimeRange}&amp;#xD;&#xd;&#xa;            &amp;lt;mediaOption&amp;gt;&amp;#xD;&#xd;&#xa;            xpath:{/workflow/variables/copyPrecedenceXML}&amp;#xD;&#xd;&#xa;            &amp;lt;/mediaOption&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;/browseOption&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;commonOptions&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;detectRegularExpression&amp;gt;true&amp;lt;/detectRegularExpression&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;doNotOverwriteFileOnDisk&amp;gt;false&amp;lt;/doNotOverwriteFileOnDisk&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;iSeriesObject&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;autl&amp;gt;false&amp;lt;/autl&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;fileLevel&amp;gt;false&amp;lt;/fileLevel&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;forceObjectConversionSelction&amp;gt;*SYSVAL&amp;lt;/forceObjectConversionSelction&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;iseriesDifferentObjectType&amp;gt;NONE&amp;lt;/iseriesDifferentObjectType&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;owner&amp;gt;false&amp;lt;/owner&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;pgp&amp;gt;false&amp;lt;/pgp&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;restorePrivateAuthority&amp;gt;true&amp;lt;/restorePrivateAuthority&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;restoreSpooledFileData&amp;gt;true&amp;lt;/restoreSpooledFileData&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;/iSeriesObject&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;isFromBrowseBackup&amp;gt;false&amp;lt;/isFromBrowseBackup&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;logOutputOption&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;membertype&amp;gt;0&amp;lt;/membertype&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;outputMember&amp;gt;&amp;lt;/outputMember&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;outputType&amp;gt;1&amp;lt;/outputType&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;outputTypeInfo&amp;gt;0&amp;lt;/outputTypeInfo&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;outputfilename&amp;gt;&amp;lt;/outputfilename&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;/logOutputOption&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;overwriteFiles&amp;gt;true&amp;lt;/overwriteFiles&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;preserveLevel&amp;gt;1&amp;lt;/preserveLevel&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;skipErrorsAndContinue&amp;gt;true&amp;lt;/skipErrorsAndContinue&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;stripLevel&amp;gt;0&amp;lt;/stripLevel&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;stripLevelType&amp;gt;PRESERVE_LEVEL&amp;lt;/stripLevelType&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;unconditionalOverwrite&amp;gt;false&amp;lt;/unconditionalOverwrite&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;wildCard&amp;gt;false&amp;lt;/wildCard&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;/commonOptions&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;destination&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;destClient&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;clientName&amp;gt;xpath:{/workflow/variables/oDestinationClient/clientName}&amp;lt;/clientName&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;/destClient&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;iSeriesDestinationAsp&amp;gt;*SAVASP&amp;lt;/iSeriesDestinationAsp&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;iSeriesDestinationAspValue&amp;gt;&amp;lt;/iSeriesDestinationAspValue&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;inPlace&amp;gt;true&amp;lt;/inPlace&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;noOfStreams&amp;gt;0&amp;lt;/noOfStreams&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;restoreOnlyIfTargetExists&amp;gt;false&amp;lt;/restoreOnlyIfTargetExists&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;/destination&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;fileOption&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;browseFilters&amp;gt;&amp;amp;lt;?xml version=''1.0'' encoding=''UTF-8''?&amp;amp;gt;&amp;amp;lt;databrowse_Query type=&quot;0&quot; queryId=&quot;0&quot;&amp;amp;gt;&amp;amp;lt;dataParam&amp;amp;gt;&amp;amp;lt;sortParam ascending=&quot;1&quot;&amp;amp;gt;&amp;amp;lt;sortBy val=&quot;38&quot; /&amp;amp;gt;&amp;amp;lt;sortBy val=&quot;0&quot; /&amp;amp;gt;&amp;amp;lt;/sortParam&amp;amp;gt;&amp;amp;lt;paging firstNode=&quot;0&quot; pageSize=&quot;1000&quot; skipNode=&quot;0&quot; /&amp;amp;gt;&amp;amp;lt;/dataParam&amp;amp;gt;&amp;amp;lt;/databrowse_Query&amp;amp;gt;&amp;lt;/browseFilters&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;filterItem&amp;gt;/&amp;amp;lt;System Configuration&amp;amp;gt;&amp;lt;/filterItem&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;filterItem&amp;gt;/&amp;amp;lt;System Security&amp;amp;gt;&amp;lt;/filterItem&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;filterItem&amp;gt;/&amp;amp;lt;DR.IMAGE&amp;amp;gt;&amp;lt;/filterItem&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;filterItem&amp;gt;/QDLS&amp;lt;/filterItem&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;filterItem&amp;gt;/QSYS.LIB&amp;lt;/filterItem&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;sourceItem&amp;gt;/&amp;lt;/sourceItem&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;/fileOption&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;/restoreOptions&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/options&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;subTask&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;operationType&amp;gt;RESTORE&amp;lt;/operationType&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;subTaskType&amp;gt;RESTORE&amp;lt;/subTaskType&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/subTask&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/subTasks&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;task&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;initiatedFrom&amp;gt;COMMANDLINE&amp;lt;/initiatedFrom&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;policyType&amp;gt;DATA_PROTECTION&amp;lt;/policyType&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;taskFlags&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;disabled&amp;gt;false&amp;lt;/disabled&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/taskFlags&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;taskType&amp;gt;IMMEDIATE&amp;lt;/taskType&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/task&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;/taskInfo&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/TMMsg_CreateTaskReq&amp;gt;&amp;#xD;&#xd;&#xa;&lt;/inputXml>&lt;commandArgs class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/sessionOptions>&lt;escapeXml class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/escapeXml>&lt;/inputs>"/>

                <transition activity="Decision_6" commented="0"

                    originalStyle="" points="" sourceX="253"

                    sourceY="162" status="0" style="defaultEdge"

                    targetX="253" targetY="205" transitionIndex="0"

                    x="70" y="-676">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <onEnter language="1" script="workflow.setVariable(&quot;attemptsRemain&quot;, xpath:{/workflow/variables/attemptsRemain} - 1);"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1467904160373"

                description="retrieves a list of values from xml"

                displayName="Get JOBID" height="20" interactive="0"

                jobMode="0" name="XPathQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.XMLQueryActivity"

                uniqueName="GetAllJobId" waitSetting="0" width="110"

                x="10" y="140">

                <inputs val="&lt;inputs>&lt;xml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/StartAllRestore/outputXml}&lt;/xml>&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>//jobIds[last()]/@val&lt;/xpath>&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;>String&lt;/outputType>&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/outputAsList>&lt;/inputs>"/>

                <transition activity="WaitForJobCompletion_4"

                    commented="0" originalStyle="" points=""

                    sourceX="252" sourceY="357" status="0"

                    style="defaultEdge" targetX="443" targetY="356"

                    transitionIndex="0" x="61" y="-638">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="1"

                created="1479241937934"

                description="Sends an email to a list of users"

                displayName="Email" height="20" interactive="0"

                jobMode="0" maxRestarts="1" name="Email"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" restartInterval="1" skipAttempt="0"

                style="label;image=Email" uniqueName="Email_18"

                waitSetting="0" width="100" x="180" y="210">

                <onExit language="1" script="workflow.setVariable(&quot;failureMessage&quot;, &quot;User Data restore job has failed.&quot;);"/>

                <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot; _list_=&quot;false&quot;>&lt;to class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/executorEMail}&lt;/to>&lt;cc class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;bcc class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;from class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>IBMi-DR-Recovery@xpath:{/workflow/system/commCellName}&lt;/from>&lt;subject class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>IBM i Data Restore job xpath:{/workflow/system/jobId} failed (do not reply)&lt;/subject>&lt;body class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&amp;lt;p&amp;gt;&#xd;&#xa;      Restore job (xpath:{/workflow/GetAllJobId/result}) of User and IFS data &#xd;&#xa;      has been killed.&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      Please see job details and job log for more information.&#xd;&#xa;    &amp;lt;/p&amp;gt;&lt;/body>&lt;attachments class=&quot;java.lang.Object&quot; _list_=&quot;false&quot; />&lt;html class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/html>&lt;replyTo class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;repeatInterval class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;/email>&lt;/inputs>"/>

                <transition activity="WorkflowEnd_23" commented="0"

                    originalStyle="" points="" sourceX="230"

                    sourceY="220" status="0" style="defaultEdge"

                    targetX="220" targetY="280" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1479323476363"

                description="if/else based decision"

                displayName="Exit code" height="40" interactive="0"

                jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_6"

                waitSetting="0" width="130" x="11" y="81">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/StartAllRestore/exitCode}==0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="GetAllJobId" commented="0"

                    displayName="0" originalStyle="" points=""

                    sourceX="449" sourceY="140" status="0"

                    style="defaultEdge" targetX="329" targetY="130"

                    transitionIndex="0" value="true" x="69" y="-1430">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="Decision_19" commented="0"

                    originalStyle="" points="" sourceX="449"

                    sourceY="140" status="0" style="defaultEdge"

                    targetX="799" targetY="400" transitionIndex="0"

                    value="false" x="69" y="-1430">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1496847955460"

                description="waits until the list of jobs completes"

                displayName="Wait for Job" height="20" interactive="0"

                jobMode="0" name="WaitForJobCompletion"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.WaitForJobCompletion"

                uniqueName="WaitForJobCompletion_4" waitSetting="0"

                width="110" x="10" y="180">

                <inputs val="&lt;inputs>&lt;jobId class=&quot;java.lang.Integer&quot; _list_=&quot;true&quot;>xpath:{/workflow/GetAllJobId/result}&lt;/jobId>&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

                <transition activity="Decision_16" commented="0"

                    originalStyle="" points="" sourceX="442"

                    sourceY="175" status="0" style="defaultEdge"

                    targetX="606" targetY="175" transitionIndex="0"

                    x="69" y="-1430">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1496847985865"

                description="if/else based decision"

                displayName="Success?" height="40" interactive="0"

                jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_16"

                waitSetting="0" width="130" x="4" y="220">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/WaitForJobCompletion_4/successful}&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="IFS_Prep" commented="0"

                    displayName="Yes" originalStyle="" points=""

                    sourceX="606" sourceY="175" status="0"

                    style="defaultEdge" targetX="604" targetY="452"

                    transitionIndex="0" value="true" x="69" y="-1430">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="Decision_19" commented="0"

                    displayName="No" originalStyle="" points=""

                    sourceX="563" sourceY="251" status="0"

                    style="defaultEdge" targetX="770" targetY="97"

                    transitionIndex="0" value="false" x="69" y="-1430">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1503597113887"

                description="if/else based decision" displayName="Retry"

                height="40" interactive="0" jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_19"

                waitSetting="0" width="100" x="184" y="134">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/attemptsRemain} &amp;gt; 0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="Email_18" commented="0"

                    displayName="No" originalStyle="" points=""

                    sourceX="606" sourceY="175" status="0"

                    style="defaultEdge" targetX="815" targetY="274"

                    transitionIndex="0" value="false" x="69" y="-1430">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="Delay_3" commented="0"

                    displayName="Yes" originalStyle="" points=""

                    sourceX="488" sourceY="124" status="0"

                    style="defaultEdge" targetX="485" targetY="54"

                    transitionIndex="0" value="true" x="68" y="-1547">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1503597326423"

                description="activity to delay the workflow execution in minutes"

                displayName="Delay" height="20" interactive="0"

                jobMode="0" name="Delay"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.DelayActivity"

                uniqueName="Delay_3" waitSetting="0" width="80" x="197" y="84">

                <inputs val="&lt;inputs>&lt;delayLength class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/delay}&lt;/delayLength>&lt;delayInterval class=&quot;workflow.types.DelayInterval&quot; _list_=&quot;false&quot;>Minutes&lt;/delayInterval>&lt;/inputs>"/>

                <transition activity="StartAllRestore" commented="0"

                    originalStyle="" points="" sourceX="664"

                    sourceY="197" status="0" style="defaultEdge"

                    targetX="340" targetY="4" transitionIndex="0" x="31" y="-1748">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1479241937995" description="Ends the workflow"

                displayName="Failure" height="20" interactive="0"

                jobMode="0" name="WorkflowEnd"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=WorkflowEnd"

                uniqueName="WorkflowEnd_23" waitSetting="0" width="100"

                x="178" y="252">

                <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;>FAILED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/failureMessage}&lt;/failureMessage>&lt;/inputs>"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1551280040346"

                description="activity to execute code snippets in the selected language"

                displayName="Prepare number of attempts" height="23"

                interactive="0" jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.ScriptActivity"

                uniqueName="IFS_Prep" waitSetting="0" width="191" x="13" y="287">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;workflow.setVariable(&amp;quot;attemptsRemain&amp;quot;, xpath:{/workflow/inputs/retryAttempts});&quot; />&lt;/inputs>"/>

            </Activity>

        </superProcess>

        <activitySchema>

            <outputs className="" defaultValue="" listType="0"

                name="outputs" type=""/>

            <inputs className="" defaultValue="" listType="0"

                name="inputs" type=""/>

        </activitySchema>

        <transition activity="ProcessBlock_11" commented="0"

            originalStyle="" points="" sourceX="521" sourceY="2246"

            status="0" style="defaultEdge" targetX="1031" targetY="2636"

            transitionIndex="0" x="-8" y="566">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1520522678621" description="" displayName="WizardBlock"

        height="526" interactive="0" jobMode="0" name="WizardBlock"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="WizardBlock_2" waitSetting="0" width="897" x="30" y="160">

        <inputs val="&lt;inputs>&lt;hideCancelButton class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/hideCancelButton>&lt;/inputs>"/>

        <superProcess>

            <Start commented="0" continueOnFailure="0"

                created="1520522678621" description=""

                displayName="Start" height="20" interactive="0"

                jobMode="0" name="Start" originalStyle=""

                skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_15" waitSetting="0" width="120" x="46" y="31">

                <inputs val="&lt;inputs />"/>

                <transition activity="getClients" commented="0"

                    originalStyle="" points="" sourceX="80" sourceY="50"

                    status="0" style="defaultEdge" targetX="700"

                    targetY="40" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity commented="0" continueOnFailure="0"

                created="1467053384372" description=""

                displayName="Get BackupSet List" height="20"

                interactive="0" jobMode="0" name="BackupSet"

                namespaceUri="commvault.cte.workflow.activities.cmd.list"

                originalStyle="" skipAttempt="0"

                style="label;image=BackupSet"

                uniqueName="SourceBackupSet" waitSetting="0" width="200"

                x="16" y="131">

                <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/sourceClient}&lt;/client>&lt;dataAgent class=&quot;workflow.types.cmd.DataAgent&quot; _list_=&quot;false&quot;>Q_FILESYSTEM&lt;/dataAgent>&lt;instance class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

                <transition activity="PickBackupSet" commented="0"

                    originalStyle="" points="" sourceX="41"

                    sourceY="327" status="0" style="defaultEdge"

                    targetX="185" targetY="327" transitionIndex="0"

                    x="-140" y="234">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1467053848372"

                description="popups an input form for the user to fill out"

                displayName="Select backupset" height="20"

                interactive="0" jobMode="0" name="PopupInput"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=PopupInput"

                uniqueName="PickBackupSet" waitSetting="0" width="200"

                x="19" y="170">

                <onExit language="1" script="if(&quot;Next&quot;.equals(xpath:{/workflow/PickBackupSet/actionSelected}))&#xd;&#xa;{&#xd;&#xa;    workflow.setVariable(&quot;backupSetName&quot;, xpath:{/workflow/PickBackupSet/backupSetName} );&#xd;&#xa;}"/>

                <inputs val="&lt;inputs>&lt;inputs>&lt;backupSetName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/backupSetName}&lt;/backupSetName>&lt;dummy1 class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/sourceClient/clientName}&lt;/dummy1>&lt;/inputs>&lt;subject>Select source backupset&lt;/subject>&lt;formProperties>&amp;lt;?xml version=''1.0'' encoding=''UTF-8''?&amp;gt;&amp;lt;Workflow_FormProperties css=&quot;&quot; javaScript=&quot;&quot; pageMode=&quot;0&quot; width=&quot;530&quot; formVersion=&quot;0&quot; height=&quot;360&quot; /&amp;gt;&lt;/formProperties>&lt;/inputs>"/>

                <activitySchema>

                    <outputs className="" defaultValue="" listType="0"

                        name="outputs" type="">

                        <children attribute="0"

                            className="java.lang.String"

                            controlHidden="0" controlType="0"

                            defaultValue="" displayName="Source Client"

                            documentation="" hidden="0"

                            inputType="java.lang.String" listType="0"

                            maximumValue="" minimumValue=""

                            name="dummy1" readOnly="1" required="0"

                            searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

                        <children attribute="0"

                            className="java.lang.String"

                            controlHidden="0" controlType="2"

                            defaultValue=""

                            displayName="Backupset name for data source"

                            documentation="" hidden="0"

                            inputType="java.lang.String" listType="0"

                            maximumValue="" minimumValue=""

                            name="backupSetName" readOnly="0"

                            required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string">

                            <options val="xpath:{/workflow/SourceBackupSet/backupSet}"/>

                        </children>

                        <children className="java.lang.Boolean"

                            inputType="java.lang.Boolean"

                            name="okClicked" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                        <children className="java.lang.String"

                            inputType="java.lang.String"

                            name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string"/>

                    </outputs>

                    <inputs className="" defaultValue="" listType="0"

                        name="inputs" type="">

                        <children attribute="0"

                            className="java.lang.String"

                            controlHidden="0" controlType="0"

                            defaultValue="" displayName="Source Client"

                            documentation="" hidden="0"

                            inputType="java.lang.String" listType="0"

                            maximumValue="" minimumValue=""

                            name="dummy1" readOnly="1" required="0"

                            searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

                        <children attribute="0"

                            className="java.lang.String"

                            controlHidden="0" controlType="2"

                            defaultValue=""

                            displayName="Backupset name for data source"

                            documentation="" hidden="0"

                            inputType="java.lang.String" listType="0"

                            maximumValue="" minimumValue=""

                            name="backupSetName" readOnly="0"

                            required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string">

                            <options val="xpath:{/workflow/SourceBackupSet/backupSet}"/>

                        </children>

                    </inputs>

                </activitySchema>

                <transition activity="PickDestinationClient"

                    commented="0" originalStyle="" points=""

                    sourceX="185" sourceY="327" status="0"

                    style="defaultEdge" targetX="361" targetY="328"

                    transitionIndex="0" x="-140" y="234">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1467054058464" description="Ends the workflow"

                displayName="WorkflowEnd" height="20" interactive="0"

                jobMode="0" name="WorkflowEnd"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=WorkflowEnd"

                uniqueName="WorkflowEnd_1" waitSetting="0" width="170"

                x="704" y="473">

                <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;>FAILED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/failureMessage}&lt;/failureMessage>&lt;/inputs>"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1447862501403"

                description="displays an informational message to the user"

                displayName="Restore Overview" height="20"

                interactive="0" jobMode="0" name="InformationalMessage"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=InformationalMessage"

                uniqueName="RestoreOverview" waitSetting="0" width="200"

                x="247" y="488">

                <inputs val="&lt;inputs>&lt;message>Latest data on or before xpath:{/workflow/variables/strDateTo} from client xpath:{/workflow/variables/sourceClient/clientName} will be restored to xpath:{/workflow/variables/oDestinationClient/clientName} with following options:&amp;#xD;&#xd;&#xa;xpath:{/workflow/variables/userMessage}&lt;/message>&lt;dialogType>Popup&lt;/dialogType>&lt;iconType>Information&lt;/iconType>&lt;title>Restore Job Overview&lt;/title>&lt;html>false&lt;/html>&lt;actions>&lt;name>Begin restore&lt;/name>&lt;validateForm>true&lt;/validateForm>&lt;/actions>&lt;actions>&lt;name>Cancel&lt;/name>&lt;validateForm>true&lt;/validateForm>&lt;/actions>&lt;formProperties />&lt;/inputs>"/>

                <activitySchema>

                    <outputs name="outputs">

                        <children className="java.lang.String"

                            inputType="java.lang.String"

                            name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string"/>

                    </outputs>

                    <inputs className="" defaultValue="" listType="0"

                        name="inputs" type=""/>

                </activitySchema>

                <transition activity="Switch_2" commented="0"

                    originalStyle="" points="" sourceX="278"

                    sourceY="919" status="0" style="defaultEdge"

                    targetX="282" targetY="1046" transitionIndex="0"

                    x="91" y="-236">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1447878541631"

                description="switch based decision"

                displayName="User select" height="40" interactive="0"

                jobMode="0" name="Switch"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Switch_2"

                waitSetting="0" width="144" x="500" y="400">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/RestoreOverview/actionSelected}&lt;/expression>&lt;/inputs>"/>

                <transition activity="EndUserSession_4" commented="0"

                    displayName="Cancel" originalStyle="" points=""

                    sourceX="282" sourceY="1216" status="0"

                    style="defaultEdge" targetX="488" targetY="1218"

                    transitionIndex="0" value="Cancel" x="170" y="868">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="Script_25" commented="0"

                    displayName="Begin restore" originalStyle=""

                    points="" sourceX="97" sourceY="809" status="0"

                    style="defaultEdge" targetX="24" targetY="902"

                    transitionIndex="0" value="Begin restore" x="-53" y="-30">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1447873549215"

                description="popups an input form for the user to fill out"

                displayName="Select Destination Client" height="20"

                interactive="0" jobMode="0" name="PopupInput"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=PopupInput"

                uniqueName="PickDestinationClient" waitSetting="0"

                width="200" x="18" y="211">

                <onExit language="1" script="if(&quot;Next&quot;.equals(xpath:{/workflow/PickDestinationClient/actionSelected}))&#xd;&#xa;{&#xd;&#xa;    commvault.msgs.CvEntities.ClientEntity clientEntity = commvault.cte.workflow.utils.CommServUtils.getClientEntity(xpath:{/workflow/PickDestinationClient/sDestinationClient});&#xd;&#xa;    workflow.setVariable(&quot;oDestinationClient&quot;, clientEntity );&#xd;&#xa;}"/>

                <inputs val="&lt;inputs>&lt;inputs>&lt;sDestinationClient class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/oDestinationClient/clientName}&lt;/sDestinationClient>&lt;dumm1 class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/sourceClient/clientName}&lt;/dumm1>&lt;dumm2 class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/backupSetName}&lt;/dumm2>&lt;latestDataFlag class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/latestDataFlag>&lt;/inputs>&lt;subject>Select destination client&lt;/subject>&lt;formProperties>&amp;lt;?xml version=''1.0'' encoding=''UTF-8''?&amp;gt;&amp;lt;Workflow_FormProperties css=&quot;&quot; javaScript=&quot;&quot; pageMode=&quot;0&quot; width=&quot;530&quot; formVersion=&quot;0&quot; height=&quot;360&quot; /&amp;gt;&lt;/formProperties>&lt;/inputs>"/>

                <activitySchema>

                    <outputs className="" defaultValue="" listType="0"

                        name="outputs" type="">

                        <children attribute="0"

                            className="java.lang.String"

                            controlHidden="0" controlType="0"

                            defaultValue="" displayName="Source Client"

                            documentation="" hidden="0"

                            inputType="java.lang.String" listType="0"

                            maximumValue="" minimumValue="" name="dumm1"

                            readOnly="1" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

                        <children attribute="0"

                            className="java.lang.String"

                            controlHidden="0" controlType="0"

                            defaultValue=""

                            displayName="Backupset name for data source"

                            documentation="" hidden="0"

                            inputType="java.lang.String" listType="0"

                            maximumValue="" minimumValue="" name="dumm2"

                            readOnly="1" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

                        <children attribute="0"

                            className="java.lang.String"

                            controlHidden="0" controlType="2"

                            defaultValue=""

                            displayName="Select destination client"

                            documentation="" hidden="0"

                            inputType="java.lang.String" listType="0"

                            maximumValue="" minimumValue=""

                            name="sDestinationClient" readOnly="0"

                            required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string">

                            <options val="xpath:{/workflow/variables/clientsIBMi}"/>

                        </children>

                        <children attribute="0"

                            className="java.lang.Boolean"

                            controlHidden="0" controlType="5"

                            defaultValue=""

                            displayName="Restore Latest User Data"

                            documentation="" hidden="0"

                            inputType="java.lang.Boolean" listType="0"

                            maximumValue="" minimumValue=""

                            name="latestDataFlag" readOnly="0"

                            required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                        <children className="java.lang.Boolean"

                            inputType="java.lang.Boolean"

                            name="okClicked" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                        <children className="java.lang.String"

                            inputType="java.lang.String"

                            name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string"/>

                    </outputs>

                    <inputs className="" defaultValue="" listType="0"

                        name="inputs" type="">

                        <children attribute="0"

                            className="java.lang.String"

                            controlHidden="0" controlType="0"

                            defaultValue="" displayName="Source Client"

                            documentation="" hidden="0"

                            inputType="java.lang.String" listType="0"

                            maximumValue="" minimumValue="" name="dumm1"

                            readOnly="1" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

                        <children attribute="0"

                            className="java.lang.String"

                            controlHidden="0" controlType="0"

                            defaultValue=""

                            displayName="Backupset name for data source"

                            documentation="" hidden="0"

                            inputType="java.lang.String" listType="0"

                            maximumValue="" minimumValue="" name="dumm2"

                            readOnly="1" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

                        <children attribute="0"

                            className="java.lang.String"

                            controlHidden="0" controlType="2"

                            defaultValue=""

                            displayName="Select destination client"

                            documentation="" hidden="0"

                            inputType="java.lang.String" listType="0"

                            maximumValue="" minimumValue=""

                            name="sDestinationClient" readOnly="0"

                            required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string">

                            <options val="xpath:{/workflow/variables/clientsIBMi}"/>

                        </children>

                        <children attribute="0"

                            className="java.lang.Boolean"

                            controlHidden="0" controlType="5"

                            defaultValue=""

                            displayName="Restore Latest User Data"

                            documentation="" hidden="0"

                            inputType="java.lang.Boolean" listType="0"

                            maximumValue="" minimumValue=""

                            name="latestDataFlag" readOnly="0"

                            required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                    </inputs>

                </activitySchema>

                <transition activity="CheckClientName" commented="0"

                    originalStyle="" points="" sourceX="103"

                    sourceY="482" status="0" style="defaultEdge"

                    targetX="304" targetY="521" transitionIndex="0"

                    x="-203" y="322">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1448478903360"

                description="if/else based decision"

                displayName="Client selected?" height="35"

                interactive="0" jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="CheckClientName"

                waitSetting="0" width="192" x="350" y="204">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/oDestinationClient/clientId} &amp;gt; 0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="WarningMessageNoClient"

                    commented="0" displayName="NO" originalStyle=""

                    points="" sourceX="78" sourceY="661" status="0"

                    style="defaultEdge" targetX="-73" targetY="632"

                    transitionIndex="0" value="false" x="-224" y="413">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="Decision_30" commented="0"

                    displayName="YES" originalStyle="" points=""

                    sourceX="205" sourceY="695" status="0"

                    style="defaultEdge" targetX="250" targetY="876"

                    transitionIndex="0" value="true" x="-129" y="389">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1448478960198"

                description="displays an informational message to the user"

                displayName="Message" height="20" interactive="0"

                jobMode="0" name="InformationalMessage"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=InformationalMessage"

                uniqueName="WarningMessageNoClient" waitSetting="0"

                width="160" x="367" y="152">

                <inputs val="&lt;inputs>&lt;message />&lt;dialogType>Popup&lt;/dialogType>&lt;iconType>Information&lt;/iconType>&lt;title />&lt;html>false&lt;/html>&lt;actions>&lt;name>OK&lt;/name>&lt;validateForm>false&lt;/validateForm>&lt;/actions>&lt;formProperties />&lt;/inputs>"/>

                <activitySchema>

                    <outputs name="outputs">

                        <children className="java.lang.String"

                            inputType="java.lang.String"

                            name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string"/>

                    </outputs>

                    <inputs className="" defaultValue="" listType="0"

                        name="inputs" type=""/>

                </activitySchema>

                <transition activity="PickDestinationClient"

                    commented="0" originalStyle="" points=""

                    sourceX="470" sourceY="260" status="0"

                    style="defaultEdge" targetX="210" targetY="240"

                    transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1496263767126"

                description="if/else based decision"

                displayName="Is source set?" height="40" interactive="0"

                jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_7"

                waitSetting="0" width="130" x="379" y="88">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/sourceClient/clientId}==0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="SelectSrcClient" commented="0"

                    displayName="NO" originalStyle="" points=""

                    sourceX="100" sourceY="99" status="0"

                    style="defaultEdge" targetX="142" targetY="186"

                    transitionIndex="0" value="true" x="0" y="-5">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="SourceBackupSet" commented="0"

                    displayName="YES" originalStyle="" points=""

                    sourceX="100" sourceY="99" status="0"

                    style="defaultEdge" targetX="224" targetY="284"

                    transitionIndex="0" value="false" x="0" y="-5">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1447351930360"

                description="popups an input form for the user to fill out"

                displayName="Select Source Client" height="20"

                interactive="0" jobMode="0" name="PopupInput"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=PopupInput"

                uniqueName="SelectSrcClient" waitSetting="0" width="200"

                x="15" y="79">

                <onExit language="1" script="if(&quot;Next&quot;.equals(xpath:{/workflow/SelectSrcClient/actionSelected}))&#xa;{&#xa;    commvault.msgs.CvEntities.ClientEntity clientEntity = commvault.cte.workflow.utils.CommServUtils.getClientEntity(xpath:{/workflow/SelectSrcClient/sDRSourceClient});&#xa;    workflow.setVariable(&quot;sourceClient&quot;, clientEntity );&#xa;}"/>

                <inputs val="&lt;inputs>&lt;inputs>&lt;sDRSourceClient class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/sourceClient/clientName}&lt;/sDRSourceClient>&lt;/inputs>&lt;subject>Select client as a source for DR recovery&lt;/subject>&lt;formProperties>&amp;lt;?xml version=''1.0'' encoding=''UTF-8''?&amp;gt;&amp;lt;Workflow_FormProperties css=&quot;&quot; javaScript=&quot;&quot; pageMode=&quot;0&quot; width=&quot;530&quot; formVersion=&quot;0&quot; height=&quot;360&quot; /&amp;gt;&lt;/formProperties>&lt;/inputs>"/>

                <activitySchema>

                    <outputs className="" defaultValue="" listType="0"

                        name="outputs" type="">

                        <children attribute="0"

                            className="java.lang.String"

                            controlHidden="0" controlType="2"

                            defaultValue="" displayName="Source Client"

                            documentation="Select a client you want to use as a source for DR recovery."

                            hidden="0" inputType="java.lang.String"

                            listType="0" maximumValue="" minimumValue=""

                            name="sDRSourceClient" readOnly="0"

                            required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string">

                            <options val="xpath:{/workflow/variables/clientsIBMi}"/>

                        </children>

                        <children className="java.lang.Boolean"

                            inputType="java.lang.Boolean"

                            name="okClicked" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                        <children className="java.lang.String"

                            inputType="java.lang.String"

                            name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string"/>

                    </outputs>

                    <inputs className="" defaultValue="" listType="0"

                        name="inputs" type="">

                        <children attribute="0"

                            className="java.lang.String"

                            controlHidden="0" controlType="2"

                            defaultValue="" displayName="Source Client"

                            documentation="Select a client you want to use as a source for DR recovery."

                            hidden="0" inputType="java.lang.String"

                            listType="0" maximumValue="" minimumValue=""

                            name="sDRSourceClient" readOnly="0"

                            required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string">

                            <options val="xpath:{/workflow/variables/clientsIBMi}"/>

                        </children>

                    </inputs>

                </activitySchema>

                <transition activity="SourceBackupSet" commented="0"

                    originalStyle="" points="" sourceX="116"

                    sourceY="85" status="0" style="defaultEdge"

                    targetX="226" targetY="275" transitionIndex="0"

                    x="-34" y="-15">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1496239623967"

                description="popups an input form for the user to fill out"

                displayName="Restore Options" height="20"

                interactive="0" jobMode="0" name="PopupInput"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.InteractiveInputActivity"

                uniqueName="RestoreOptions_1" waitSetting="0"

                width="190" x="672" y="217">

                <onExit language="1" script="if(&quot;Next&quot;.equals(xpath:{/workflow/RestoreOptions_1/actionSelected}))&#xd;&#xa;{&#xd;&#xa;    workflow.setInput(&quot;bPVTAUT&quot;, xpath:{/workflow/RestoreOptions_1/bPVTAUTInput} );&#xd;&#xa;    workflow.setInput(&quot;bSPLFDTA&quot;, xpath:{/workflow/RestoreOptions_1/bSPLFDTAInput} );&#xd;&#xa;    workflow.setInput(&quot;sALWJOBDIF&quot;, xpath:{/workflow/RestoreOptions_1/sALWOBJDIFInput} );&#xd;&#xa;    workflow.setInput(&quot;sOBJCNV&quot;, xpath:{/workflow/RestoreOptions_1/sOBJCNVInput} );&#xd;&#xa;    String dfrIdStr = xpath:{/workflow/RestoreOptions_1/sDFRIDInput};&#xd;&#xa;    if( dfrIdStr.length() > 10 )&#xd;&#xa;    {&#xd;&#xa;        dfrIdStr = dfrIdStr.substring(0,10);&#xd;&#xa;    }&#xd;&#xa;    workflow.setInput(&quot;sDFRID&quot;, dfrIdStr );&#xd;&#xa;}&#xd;&#xa;if( xpath:{/workflow/PickDestinationClient/latestDataFlag} == false )&#xd;&#xa;{&#xd;&#xa;    var timeRange = &quot;&quot;;&#xd;&#xa;    timeRange = timeRange + utils.formatDate(xpath:{/workflow/inputs/dataRestoreDate}.getTime(), &quot;yyyy-MM-dd&quot;);&#xd;&#xa;    timeRange = timeRange + &quot; &quot;;&#xd;&#xa;    timeRange = timeRange + utils.formatDate(xpath:{/workflow/inputs/dataRestoreDate}.getTime(), &quot;HH:mm:ss&quot;);&#xd;&#xa;    workflow.setVariable(&quot;strDateTo&quot;, timeRange);&#xd;&#xa;} else {&#xd;&#xa;    workflow.setVariable(&quot;strDateTo&quot;, &quot;(latest)&quot;);&#xd;&#xa;}&#xd;&#xa;"/>

                <inputs val="&lt;inputs>&lt;inputs>&lt;bSPLFDTAInput class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/bSPLFDTA}&lt;/bSPLFDTAInput>&lt;sALWOBJDIFInput class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/sALWJOBDIF}&lt;/sALWOBJDIFInput>&lt;bPVTAUTInput class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/bPVTAUT}&lt;/bPVTAUTInput>&lt;sOBJCNVInput class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/sOBJCNV}&lt;/sOBJCNVInput>&lt;sDFRIDInput class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/sDFRID}&lt;/sDFRIDInput>&lt;/inputs>&lt;subject>Restore Options&lt;/subject>&lt;formProperties>&amp;lt;?xml version=''1.0'' encoding=''UTF-8''?&amp;gt;&amp;lt;Workflow_FormProperties css=&quot;&quot; javaScript=&quot;&quot; pageMode=&quot;0&quot; width=&quot;530&quot; formVersion=&quot;0&quot; height=&quot;360&quot;&amp;gt;&amp;lt;rules /&amp;gt;&amp;lt;/Workflow_FormProperties&amp;gt;&lt;/formProperties>&lt;/inputs>"/>

                <activitySchema>

                    <outputs className="" defaultValue="" listType="0"

                        name="outputs" type="">

                        <children attribute="0"

                            className="java.lang.Boolean"

                            controlHidden="0" controlType="5"

                            defaultValue=""

                            displayName="Restore private authority (PVTAUT)"

                            documentation="Specifies whether to restore private authorities with the objects that are restored."

                            hidden="0" inputType="java.lang.Boolean"

                            listType="0" maximumValue="" minimumValue=""

                            name="bPVTAUTInput" readOnly="0"

                            required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                        <children attribute="0"

                            className="java.lang.Boolean"

                            controlHidden="0" controlType="5"

                            defaultValue=""

                            displayName="Restore spooled file data (SPLFDTA)"

                            documentation="Specifies whether to restore spooled file data and attributes."

                            hidden="0" inputType="java.lang.Boolean"

                            listType="0" maximumValue="" minimumValue=""

                            name="bSPLFDTAInput" readOnly="0"

                            required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                        <children attribute="0"

                            className="java.lang.String"

                            controlHidden="0" controlType="3"

                            defaultValue=""

                            displayName="Allow object differences (ALWOBJDIF)"

                            documentation="Specifies whether differences are allowed between the saved objects and the restored objects."

                            hidden="0" inputType="java.lang.String"

                            listType="0" maximumValue="" minimumValue=""

                            name="sALWOBJDIFInput" readOnly="0"

                            required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string">

                            <options val="*NONE"/>

                            <options val="*ALL"/>

                            <options val="*COMPATIBLE"/>

                            <options val="OTHER"/>

                        </children>

                        <children attribute="0"

                            className="java.lang.String"

                            controlHidden="0" controlType="2"

                            defaultValue=""

                            displayName="Force Object conversion (FRCOBJCNV)"

                            documentation="Specifies whether to convert user objects to the format required for use in the current version of the operating system, or to be compatible with the current machine, when the objects are restored."

                            hidden="0" inputType="java.lang.String"

                            listType="0" maximumValue="" minimumValue=""

                            name="sOBJCNVInput" readOnly="0"

                            required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string">

                            <options val="*SYSVAL"/>

                            <options val="*NO"/>

                            <options val="*YES *RQD"/>

                            <options val="*YES *ALL"/>

                        </children>

                        <children attribute="0"

                            className="java.lang.String"

                            controlHidden="0" controlType="0"

                            defaultValue="" displayName="Defer ID"

                            documentation="Identifier to be used if you want to defer the restore of objects that depend on other objects that are not yet available. Specify value ''*NONE'' if you don''t want to use any identifiers."

                            hidden="0" inputType="java.lang.String"

                            listType="0" maximumValue="" minimumValue=""

                            name="sDFRIDInput" readOnly="0" required="1"

                            searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

                        <children className="java.lang.Boolean"

                            inputType="java.lang.Boolean"

                            name="okClicked" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                        <children className="java.lang.String"

                            inputType="java.lang.String"

                            name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string"/>

                    </outputs>

                    <inputs className="" defaultValue="" listType="0"

                        name="inputs" type="">

                        <children attribute="0"

                            className="java.lang.Boolean"

                            controlHidden="0" controlType="5"

                            defaultValue=""

                            displayName="Restore private authority (PVTAUT)"

                            documentation="Specifies whether to restore private authorities with the objects that are restored."

                            hidden="0" inputType="java.lang.Boolean"

                            listType="0" maximumValue="" minimumValue=""

                            name="bPVTAUTInput" readOnly="0"

                            required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                        <children attribute="0"

                            className="java.lang.Boolean"

                            controlHidden="0" controlType="5"

                            defaultValue=""

                            displayName="Restore spooled file data (SPLFDTA)"

                            documentation="Specifies whether to restore spooled file data and attributes."

                            hidden="0" inputType="java.lang.Boolean"

                            listType="0" maximumValue="" minimumValue=""

                            name="bSPLFDTAInput" readOnly="0"

                            required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                        <children attribute="0"

                            className="java.lang.String"

                            controlHidden="0" controlType="3"

                            defaultValue=""

                            displayName="Allow object differences (ALWOBJDIF)"

                            documentation="Specifies whether differences are allowed between the saved objects and the restored objects."

                            hidden="0" inputType="java.lang.String"

                            listType="0" maximumValue="" minimumValue=""

                            name="sALWOBJDIFInput" readOnly="0"

                            required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string">

                            <options val="*NONE"/>

                            <options val="*ALL"/>

                            <options val="*COMPATIBLE"/>

                            <options val="OTHER"/>

                        </children>

                        <children attribute="0"

                            className="java.lang.String"

                            controlHidden="0" controlType="2"

                            defaultValue=""

                            displayName="Force Object conversion (FRCOBJCNV)"

                            documentation="Specifies whether to convert user objects to the format required for use in the current version of the operating system, or to be compatible with the current machine, when the objects are restored."

                            hidden="0" inputType="java.lang.String"

                            listType="0" maximumValue="" minimumValue=""

                            name="sOBJCNVInput" readOnly="0"

                            required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string">

                            <options val="*SYSVAL"/>

                            <options val="*NO"/>

                            <options val="*YES *RQD"/>

                            <options val="*YES *ALL"/>

                        </children>

                        <children attribute="0"

                            className="java.lang.String"

                            controlHidden="0" controlType="0"

                            defaultValue="" displayName="Defer ID"

                            documentation="Identifier to be used if you want to defer the restore of objects that depend on other objects that are not yet available. Specify value ''*NONE'' if you don''t want to use any identifiers."

                            hidden="0" inputType="java.lang.String"

                            listType="0" maximumValue="" minimumValue=""

                            name="sDFRIDInput" readOnly="0" required="1"

                            searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

                    </inputs>

                </activitySchema>

                <transition activity="Decision_36" commented="0"

                    originalStyle="" points="" sourceX="-209"

                    sourceY="792" status="0" style="defaultEdge"

                    targetX="87" targetY="745" transitionIndex="0"

                    x="-337" y="-81">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1496243882943"

                description="if/else based decision"

                displayName="If OBJDIF" height="30" interactive="0"

                jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_11"

                waitSetting="0" width="130" x="430" y="303">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/sALWJOBDIF} == &quot;OTHER&quot;&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVASCRIPT&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="JOBLOG_Options" commented="0"

                    originalStyle="" points="" sourceX="123"

                    sourceY="589" status="0" style="defaultEdge"

                    targetX="153" targetY="709" transitionIndex="0"

                    value="false" x="-26" y="129">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="OBJDIFOptions" commented="0"

                    displayName="YES" originalStyle="" points=""

                    sourceX="-113" sourceY="866" status="0"

                    style="defaultEdge" targetX="26" targetY="866"

                    transitionIndex="0" value="true" x="-361" y="-23">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1496244517924"

                description="popups an input form for the user to fill out"

                displayName="OBJDIF Options" height="20" interactive="0"

                jobMode="0" name="PopupInput"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.InteractiveInputActivity"

                uniqueName="OBJDIFOptions" waitSetting="0" width="200"

                x="457" y="363">

                <onExit language="1" script="if(&quot;Next&quot;.equals(xpath:{/workflow/OBJDIFOptions/actionSelected}))&#xd;&#xa;{&#xd;&#xa;    workflow.setInput(&quot;bALWOBJDIF_AUTL&quot;, xpath:{/workflow/OBJDIFOptions/bALWOBJDIF_AUTL_input} );&#xd;&#xa;    workflow.setInput(&quot;bALWOBJDIF_FILELVL&quot;, xpath:{/workflow/OBJDIFOptions/bALWOBJDIF_FILELVL_input} );&#xd;&#xa;    workflow.setInput(&quot;bALWOBJDIF_OWNER&quot;, xpath:{/workflow/OBJDIFOptions/bALWOBJDIF_OWNER_input} );&#xd;&#xa;    workflow.setInput(&quot;bALWOBJDIF_PGP&quot;, xpath:{/workflow/OBJDIFOptions/bALWOBJDIF_PGP_input} );&#xd;&#xa;}"/>

                <inputs val="&lt;inputs>&lt;inputs>&lt;bALWOBJDIF_AUTL_input class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/bALWOBJDIF_AUTL}&lt;/bALWOBJDIF_AUTL_input>&lt;bALWOBJDIF_FILELVL_input class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/bALWOBJDIF_FILELVL}&lt;/bALWOBJDIF_FILELVL_input>&lt;bALWOBJDIF_OWNER_input class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/bALWOBJDIF_OWNER}&lt;/bALWOBJDIF_OWNER_input>&lt;bALWOBJDIF_PGP_input class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/bALWOBJDIF_PGP}&lt;/bALWOBJDIF_PGP_input>&lt;/inputs>&lt;subject>Select object differences level for this restore.&lt;/subject>&lt;formProperties>&amp;lt;?xml version=''1.0'' encoding=''UTF-8''?&amp;gt;&amp;lt;Workflow_FormProperties css=&quot;&quot; javaScript=&quot;&quot; pageMode=&quot;0&quot; width=&quot;530&quot; formVersion=&quot;0&quot; height=&quot;360&quot; /&amp;gt;&lt;/formProperties>&lt;/inputs>"/>

                <activitySchema>

                    <outputs className="" defaultValue="" listType="0"

                        name="outputs" type="">

                        <children attribute="0"

                            className="java.lang.Boolean"

                            controlHidden="0" controlType="5"

                            defaultValue="" displayName="*AUTL"

                            documentation="Authorization list differences are allowed."

                            hidden="0" inputType="java.lang.Boolean"

                            listType="0" maximumValue="" minimumValue=""

                            name="bALWOBJDIF_AUTL_input" readOnly="0"

                            required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                        <children attribute="0"

                            className="java.lang.Boolean"

                            controlHidden="0" controlType="5"

                            defaultValue="" displayName="*FILELVL"

                            documentation="File level id and member level id differences are allowed."

                            hidden="0" inputType="java.lang.Boolean"

                            listType="0" maximumValue="" minimumValue=""

                            name="bALWOBJDIF_FILELVL_input" readOnly="0"

                            required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                        <children attribute="0"

                            className="java.lang.Boolean"

                            controlHidden="0" controlType="5"

                            defaultValue="" displayName="*OWNER"

                            documentation="Ownership differences are allowed. If an object already exists on the system with a different owner than the saved object, the object is restored with the owner of the object on the system."

                            hidden="0" inputType="java.lang.Boolean"

                            listType="0" maximumValue="" minimumValue=""

                            name="bALWOBJDIF_OWNER_input" readOnly="0"

                            required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                        <children attribute="0"

                            className="java.lang.Boolean"

                            controlHidden="0" controlType="5"

                            defaultValue="" displayName="*PGP"

                            documentation="Primary group differences are allowed."

                            hidden="0" inputType="java.lang.Boolean"

                            listType="0" maximumValue="" minimumValue=""

                            name="bALWOBJDIF_PGP_input" readOnly="0"

                            required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                        <children className="java.lang.Boolean"

                            inputType="java.lang.Boolean"

                            name="okClicked" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                        <children className="java.lang.String"

                            inputType="java.lang.String"

                            name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string"/>

                    </outputs>

                    <inputs className="" defaultValue="" listType="0"

                        name="inputs" type="">

                        <children attribute="0"

                            className="java.lang.Boolean"

                            controlHidden="0" controlType="5"

                            defaultValue="" displayName="*AUTL"

                            documentation="Authorization list differences are allowed."

                            hidden="0" inputType="java.lang.Boolean"

                            listType="0" maximumValue="" minimumValue=""

                            name="bALWOBJDIF_AUTL_input" readOnly="0"

                            required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                        <children attribute="0"

                            className="java.lang.Boolean"

                            controlHidden="0" controlType="5"

                            defaultValue="" displayName="*FILELVL"

                            documentation="File level id and member level id differences are allowed."

                            hidden="0" inputType="java.lang.Boolean"

                            listType="0" maximumValue="" minimumValue=""

                            name="bALWOBJDIF_FILELVL_input" readOnly="0"

                            required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                        <children attribute="0"

                            className="java.lang.Boolean"

                            controlHidden="0" controlType="5"

                            defaultValue="" displayName="*OWNER"

                            documentation="Ownership differences are allowed. If an object already exists on the system with a different owner than the saved object, the object is restored with the owner of the object on the system."

                            hidden="0" inputType="java.lang.Boolean"

                            listType="0" maximumValue="" minimumValue=""

                            name="bALWOBJDIF_OWNER_input" readOnly="0"

                            required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                        <children attribute="0"

                            className="java.lang.Boolean"

                            controlHidden="0" controlType="5"

                            defaultValue="" displayName="*PGP"

                            documentation="Primary group differences are allowed."

                            hidden="0" inputType="java.lang.Boolean"

                            listType="0" maximumValue="" minimumValue=""

                            name="bALWOBJDIF_PGP_input" readOnly="0"

                            required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                    </inputs>

                </activitySchema>

                <transition activity="JOBLOG_Options" commented="0"

                    originalStyle="" points="" sourceX="356"

                    sourceY="961" status="0" style="defaultEdge"

                    targetX="353" targetY="1007" transitionIndex="0"

                    x="-346" y="-114">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1496245474984"

                description="popups an input form for the user to fill out"

                displayName="JOBLOG Options" height="20" interactive="0"

                jobMode="0" name="PopupInput"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.InteractiveInputActivity"

                uniqueName="JOBLOG_Options" waitSetting="0" width="200"

                x="165" y="338">

                <onExit language="1" script="if(&quot;Next&quot;.equals(xpath:{/workflow/JOBLOG_Options/actionSelected}))&#xd;&#xa;{&#xd;&#xa;    workflow.setInput(&quot;sJOBLOG&quot;, xpath:{/workflow/JOBLOG_Options/sJOBLOG_input} );&#xd;&#xa;    workflow.setInput(&quot;sJOBLOGFileName&quot;, xpath:{/workflow/JOBLOG_Options/sOUTFILE_input} );&#xd;&#xa;    workflow.setInput(&quot;sJOBLOGMemberName&quot;, xpath:{/workflow/JOBLOG_Options/sMEMBER_input} );&#xd;&#xa;    workflow.setInput(&quot;sMEMBEROpt&quot;, xpath:{/workflow/JOBLOG_Options/sMEMBEROpt_input} );&#xd;&#xa;    workflow.setInput(&quot;sOUTTYPE&quot;, xpath:{/workflow/JOBLOG_Options/sOUTTYPE_input} );&#xd;&#xa;}"/>

                <inputs val="&lt;inputs>&lt;inputs>&lt;sJOBLOG_input class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/sJOBLOG}&lt;/sJOBLOG_input>&lt;sOUTFILE_input class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/sJOBLOGFileName}&lt;/sOUTFILE_input>&lt;sMEMBER_input class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/sJOBLOGMemberName}&lt;/sMEMBER_input>&lt;sMEMBEROpt_input class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/sMEMBEROpt}&lt;/sMEMBEROpt_input>&lt;sOUTTYPE_input class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/sOUTTYPE}&lt;/sOUTTYPE_input>&lt;/inputs>&lt;subject>JOBLOG Options&lt;/subject>&lt;formProperties>&amp;lt;?xml version=''1.0'' encoding=''UTF-8''?&amp;gt;&amp;lt;Workflow_FormProperties css=&quot;&quot; javaScript=&quot;&quot; pageMode=&quot;0&quot; width=&quot;530&quot; formVersion=&quot;0&quot; height=&quot;360&quot; /&amp;gt;&lt;/formProperties>&lt;/inputs>"/>

                <activitySchema>

                    <outputs className="" defaultValue="" listType="0"

                        name="outputs" type="">

                        <children attribute="0"

                            className="java.lang.String"

                            controlHidden="0" controlType="2"

                            defaultValue="" displayName="Output option"

                            documentation="Specifies whether a listing that shows information about the status of the objects is created and directed to an output file."

                            hidden="0" inputType="java.lang.String"

                            listType="0" maximumValue="" minimumValue=""

                            name="sJOBLOG_input" readOnly="0"

                            required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string">

                            <options val="*NONE"/>

                            <options val="*PRINT"/>

                            <options val="*OUTFILE"/>

                        </children>

                        <children attribute="0"

                            className="java.lang.String"

                            controlHidden="0" controlType="0"

                            defaultValue="" displayName="Output file"

                            documentation="Specifies the database file to which the output of the command is directed when *OUTFILE is specified. If the file does not exist, this command creates a database file in the specified library (LIBRARY/FILE)."

                            hidden="0" inputType="java.lang.String"

                            listType="0" maximumValue="" minimumValue=""

                            name="sOUTFILE_input" readOnly="0"

                            required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

                        <children attribute="0"

                            className="java.lang.String"

                            controlHidden="0" controlType="0"

                            defaultValue="" displayName="Output member"

                            documentation="Specifies the name of the database file member to which the output is directed when *OUTFILE is specified."

                            hidden="0" inputType="java.lang.String"

                            listType="0" maximumValue="" minimumValue=""

                            name="sMEMBER_input" readOnly="0"

                            required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

                        <children attribute="0"

                            className="java.lang.String"

                            controlHidden="0" controlType="2"

                            defaultValue=""

                            displayName="Replace or add records"

                            documentation="" hidden="0"

                            inputType="java.lang.String" listType="0"

                            maximumValue="" minimumValue=""

                            name="sMEMBEROpt_input" readOnly="0"

                            required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string">

                            <options val="*REPLACE"/>

                            <options val="*ADD"/>

                        </children>

                        <children attribute="0"

                            className="java.lang.String"

                            controlHidden="0" controlType="2"

                            defaultValue=""

                            displayName="Type of output information"

                            documentation="Specifies the type of information which is printed or directed to the database file."

                            hidden="0" inputType="java.lang.String"

                            listType="0" maximumValue="" minimumValue=""

                            name="sOUTTYPE_input" readOnly="0"

                            required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string">

                            <options val="*OBJ"/>

                            <options val="*MBR"/>

                        </children>

                        <children className="java.lang.Boolean"

                            inputType="java.lang.Boolean"

                            name="okClicked" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                        <children className="java.lang.String"

                            inputType="java.lang.String"

                            name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string"/>

                    </outputs>

                    <inputs className="" defaultValue="" listType="0"

                        name="inputs" type="">

                        <children attribute="0"

                            className="java.lang.String"

                            controlHidden="0" controlType="2"

                            defaultValue="" displayName="Output option"

                            documentation="Specifies whether a listing that shows information about the status of the objects is created and directed to an output file."

                            hidden="0" inputType="java.lang.String"

                            listType="0" maximumValue="" minimumValue=""

                            name="sJOBLOG_input" readOnly="0"

                            required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string">

                            <options val="*NONE"/>

                            <options val="*PRINT"/>

                            <options val="*OUTFILE"/>

                        </children>

                        <children attribute="0"

                            className="java.lang.String"

                            controlHidden="0" controlType="0"

                            defaultValue="" displayName="Output file"

                            documentation="Specifies the database file to which the output of the command is directed when *OUTFILE is specified. If the file does not exist, this command creates a database file in the specified library (LIBRARY/FILE)."

                            hidden="0" inputType="java.lang.String"

                            listType="0" maximumValue="" minimumValue=""

                            name="sOUTFILE_input" readOnly="0"

                            required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

                        <children attribute="0"

                            className="java.lang.String"

                            controlHidden="0" controlType="0"

                            defaultValue="" displayName="Output member"

                            documentation="Specifies the name of the database file member to which the output is directed when *OUTFILE is specified."

                            hidden="0" inputType="java.lang.String"

                            listType="0" maximumValue="" minimumValue=""

                            name="sMEMBER_input" readOnly="0"

                            required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

                        <children attribute="0"

                            className="java.lang.String"

                            controlHidden="0" controlType="2"

                            defaultValue=""

                            displayName="Replace or add records"

                            documentation="" hidden="0"

                            inputType="java.lang.String" listType="0"

                            maximumValue="" minimumValue=""

                            name="sMEMBEROpt_input" readOnly="0"

                            required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string">

                            <options val="*REPLACE"/>

                            <options val="*ADD"/>

                        </children>

                        <children attribute="0"

                            className="java.lang.String"

                            controlHidden="0" controlType="2"

                            defaultValue=""

                            displayName="Type of output information"

                            documentation="Specifies the type of information which is printed or directed to the database file."

                            hidden="0" inputType="java.lang.String"

                            listType="0" maximumValue="" minimumValue=""

                            name="sOUTTYPE_input" readOnly="0"

                            required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string">

                            <options val="*OBJ"/>

                            <options val="*MBR"/>

                        </children>

                    </inputs>

                </activitySchema>

                <transition activity="Script_4" commented="0"

                    originalStyle="" points="" sourceX="356"

                    sourceY="1081" status="0" style="defaultEdge"

                    targetX="363" targetY="1151" transitionIndex="0"

                    x="-346" y="-114">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1496247842574"

                description="activity to execute code snippets in the selected language"

                displayName="Script" height="34" interactive="0"

                jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.ScriptActivity"

                uniqueName="Script_4" waitSetting="0" width="100" x="22" y="337">

                <inputs val="&lt;inputs>&lt;script language=&quot;3&quot; script=&quot;/* validate */&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;userMessage&amp;quot;, &amp;quot;&amp;quot;);&amp;#xD;&amp;#xA;if(xpath:{/workflow/inputs/sJOBLOG} == &amp;quot;*OUTFILE&amp;quot;)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    var pattern = /^[^\/]*\/[^\/]*$/;&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    if( xpath:{/workflow/inputs/sJOBLOGFileName} == &amp;quot;&amp;quot; )&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        workflow.setVariable(&amp;quot;userMessage&amp;quot;, &amp;quot;Output file parameter is not provided&amp;quot;);&amp;#xD;&amp;#xA;    } else if(pattern.test( xpath:{/workflow/inputs/sJOBLOGFileName} ).toString() == &amp;quot;false&amp;quot;) {&amp;#xD;&amp;#xA;        workflow.setVariable(&amp;quot;userMessage&amp;quot;, &amp;quot;Output file parameter must be in a form LIBRARY/FILE&amp;quot;);&amp;#xD;&amp;#xA;    } else if( xpath:{/workflow/inputs/sJOBLOGMemberName} == &amp;quot;&amp;quot; )&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        workflow.setVariable(&amp;quot;userMessage&amp;quot;, &amp;quot;Member name parameter is not provided&amp;quot;);&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&quot; />&lt;/inputs>"/>

                <transition activity="Decision_12" commented="0"

                    originalStyle="" points="" sourceX="354"

                    sourceY="1208" status="0" style="defaultEdge"

                    targetX="355" targetY="1279" transitionIndex="0"

                    x="-346" y="-114">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1496248133591"

                description="if/else based decision"

                displayName="Check output options" height="60"

                interactive="0" jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_12"

                waitSetting="0" width="174" x="30" y="450">

                <onExit language="3" script="var commandOption = &quot;&quot;;&#xd;&#xa;commandOption = commandOption + &quot;   PVTAUT(&quot; + (xpath:{/workflow/inputs/bPVTAUT} ? &quot;*YES&quot; : &quot;*NO&quot;) + &quot;)\n&quot;;&#xd;&#xa;commandOption = commandOption + &quot;   SPLFDTA(&quot; + (xpath:{/workflow/inputs/bSPLFDTA} ? &quot;*NEW&quot; : &quot;*NONE&quot;) + &quot;)\n&quot;;&#xd;&#xa;commandOption = commandOption + &quot;   DFRID(&quot; + xpath:{/workflow/variables/v_sDFRID} + &quot;)\n&quot;;&#xd;&#xa;commandOption = commandOption + &quot;   ALWOBJDIF(&quot;;&#xd;&#xa;if( xpath:{/workflow/inputs/sALWJOBDIF} == &quot;Other&quot; )&#xd;&#xa;{&#xd;&#xa;    if(xpath:{/workflow/inputs/bALWOBJDIF_AUTL}) {&#xd;&#xa;        commandOption = commandOption + &quot;*AUTL&quot;;&#xd;&#xa;    }&#xd;&#xa;    if(xpath:{/workflow/inputs/bALWOBJDIF_FILELVL}) {&#xd;&#xa;        commandOption = commandOption + &quot;*FILELVL&quot;;&#xd;&#xa;    }&#xd;&#xa;    if(xpath:{/workflow/inputs/bALWOBJDIF_OWNER}) {&#xd;&#xa;        commandOption = commandOption + &quot;*OWNER&quot;;&#xd;&#xa;    }&#xd;&#xa;    if(xpath:{/workflow/inputs/bALWOBJDIF_PGP}) {&#xd;&#xa;        commandOption = commandOption + &quot;*PGP&quot;;&#xd;&#xa;    }&#xd;&#xa;} else {&#xd;&#xa;    commandOption = commandOption + xpath:{/workflow/inputs/sALWJOBDIF};&#xd;&#xa;}&#xd;&#xa;commandOption = commandOption + &quot;)\n&quot;;&#xd;&#xa;commandOption = commandOption + &quot;   FRCOBJCVN(&quot; + xpath:{/workflow/inputs/sOBJCNV} + &quot;)\n&quot;;&#xd;&#xa;&#xd;&#xa;if( xpath:{/workflow/inputs/sJOBLOG} == &quot;*NONE&quot; )&#xd;&#xa;{&#xd;&#xa;    commandOption = commandOption + &quot;   OUTPUT(&quot; + xpath:{/workflow/inputs/sJOBLOG} + &quot;)\n&quot;;&#xd;&#xa;} else {&#xd;&#xa;    commandOption = commandOption + &quot;   OUTPUT(&quot; + xpath:{/workflow/inputs/sJOBLOG} + &quot;)&quot;;&#xd;&#xa;    if(&quot;*OUTFILE&quot; == xpath:{/workflow/inputs/sJOBLOG})&#xd;&#xa;    {&#xd;&#xa;        commandOption = commandOption + &quot;   OUTFILE(&quot; + xpath:{/workflow/inputs/sJOBLOGFileName} + &quot;)&quot;;&#xd;&#xa;        commandOption = commandOption + &quot;   OUTMBR(&quot; + xpath:{/workflow/inputs/sJOBLOGMemberName} + &quot; &quot; + xpath:{/workflow/inputs/sMEMBEROpt} +  &quot;)&quot;;&#xd;&#xa;    }&#xd;&#xa;    commandOption = commandOption + &quot;   INFTYPE(&quot; + xpath:{/workflow/inputs/sOUTTYPE} + &quot;)\n&quot;;&#xd;&#xa;}&#xd;&#xa;&#xd;&#xa;workflow.setVariable(&quot;userMessage&quot;, commandOption );&#xd;&#xa;"/>

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/userMessage} == &quot;&quot;&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVASCRIPT&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="InformationalMessage_7"

                    commented="0" displayName="Missing parameter"

                    originalStyle="" points="" sourceX="355"

                    sourceY="1279" status="0" style="defaultEdge"

                    targetX="141" targetY="1243" transitionIndex="0"

                    value="false" x="-346" y="-114">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="RestoreOverview" commented="0"

                    originalStyle="" points="" sourceX="575"

                    sourceY="1319" status="0" style="defaultEdge"

                    targetX="578" targetY="1478" transitionIndex="0"

                    value="true" x="-26" y="124">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1520264707620"

                description="performs http operations"

                displayName="Get Clients" height="20" interactive="0"

                jobMode="0" name="HttpClient"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.HttpClientActivity"

                uniqueName="getClients" waitSetting="0" width="112"

                x="197" y="31">

                <inputs val="&lt;inputs>&lt;request>&lt;url>/SearchSvc/CVWebService.svc/Client&lt;/url>&lt;method>GET&lt;/method>&lt;postType>Raw&lt;/postType>&lt;postContent>&lt;/postContent>&lt;postContentType>application/xml; charset=UTF-8&lt;/postContentType>&lt;parameters>&lt;name>propertylevel&lt;/name>&lt;value>10&lt;/value>&lt;/parameters>&lt;headers>&lt;name>Authtoken&lt;/name>&lt;value>QSDKONLY xpath:{/workflow/system/token}&lt;/value>&lt;/headers>&lt;headers>&lt;name>Accept&lt;/name>&lt;value>application/xml&lt;/value>&lt;/headers>&lt;/request>&lt;/inputs>"/>

                <transition activity="Script_19" commented="0"

                    originalStyle="" points="" sourceX="1418"

                    sourceY="181" status="0" style="defaultEdge"

                    targetX="1418" targetY="312" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1496248246583"

                description="displays an informational message to the user"

                displayName="InformationalMessage" height="20"

                interactive="0" jobMode="0" name="InformationalMessage"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.InteractiveMessageActivity"

                uniqueName="InformationalMessage_7" waitSetting="0"

                width="200" x="155" y="386">

                <inputs val="&lt;inputs>&lt;message />&lt;dialogType>Popup&lt;/dialogType>&lt;iconType>Information&lt;/iconType>&lt;title />&lt;html>false&lt;/html>&lt;actions>&lt;name>OK&lt;/name>&lt;validateForm>true&lt;/validateForm>&lt;/actions>&lt;formProperties />&lt;/inputs>"/>

                <activitySchema>

                    <outputs name="outputs">

                        <children className="java.lang.String"

                            inputType="java.lang.String"

                            name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string"/>

                    </outputs>

                    <inputs className="" defaultValue="" listType="0"

                        name="inputs" type=""/>

                </activitySchema>

                <transition activity="JOBLOG_Options" commented="0"

                    originalStyle="" points="" sourceX="107"

                    sourceY="1215" status="0" style="defaultEdge"

                    targetX="339" targetY="1084" transitionIndex="0"

                    x="-346" y="-114">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1520872026126"

                description="if/else based decision"

                displayName="Select date?" height="58" interactive="0"

                jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_30"

                waitSetting="0" width="176" x="664" y="59">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/PickDestinationClient/latestDataFlag} == false&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="RestoreOptions_1" commented="0"

                    displayName="NO" originalStyle="" points=""

                    sourceX="323" sourceY="479" status="0"

                    style="defaultEdge" targetX="153" targetY="499"

                    transitionIndex="0" value="false" x="-26" y="109">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="PopupInput_1" commented="0"

                    displayName="YES" originalStyle="" points=""

                    sourceX="323" sourceY="479" status="0"

                    style="defaultEdge" targetX="343" targetY="549"

                    transitionIndex="0" value="true" x="-26" y="109">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1520872054988"

                description="popups an input form for the user to fill out"

                displayName="Select Date" height="20" interactive="0"

                jobMode="0" name="PopupInput"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=PopupInput" uniqueName="PopupInput_1"

                waitSetting="0" width="115" x="774" y="167">

                <onExit language="3" script="if(&quot;Next&quot;.equals(xpath:{/workflow/PopupInput_1/actionSelected}))&#xd;&#xa;{&#xd;&#xa;    workflow.setInput(&quot;dataRestoreDate&quot;, xpath:{/workflow/PopupInput_1/dateSelected} );&#xd;&#xa;}"/>

                <inputs val="&lt;inputs>&lt;inputs>&lt;sDestinationClient class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/oDestinationClient/clientName}&lt;/sDestinationClient>&lt;dumm1 class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/sourceClient/clientName}&lt;/dumm1>&lt;dumm2 class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/backupSetName}&lt;/dumm2>&lt;latestDataFlag class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>xpath:{/workflow/PickDestinationClient/latestDataFlag}&lt;/latestDataFlag>&lt;dateSelected class=&quot;java.util.Calendar&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/dataRestoreDate}&lt;/dateSelected>&lt;/inputs>&lt;subject>Select destination client&lt;/subject>&lt;formProperties>&amp;lt;?xml version=''1.0'' encoding=''UTF-8''?&amp;gt;&amp;lt;Workflow_FormProperties css=&quot;&quot; javaScript=&quot;&quot; pageMode=&quot;0&quot; width=&quot;530&quot; formVersion=&quot;0&quot; height=&quot;360&quot; /&amp;gt;&lt;/formProperties>&lt;/inputs>"/>

                <activitySchema>

                    <outputs className="" defaultValue="" listType="0"

                        name="outputs" type="">

                        <children attribute="0"

                            className="java.lang.String"

                            controlHidden="0" controlType="0"

                            defaultValue="" displayName="Source Client"

                            documentation="" hidden="0"

                            inputType="java.lang.String" listType="0"

                            maximumValue="" minimumValue="" name="dumm1"

                            readOnly="1" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

                        <children attribute="0"

                            className="java.lang.String"

                            controlHidden="0" controlType="0"

                            defaultValue=""

                            displayName="Backupset name for data source"

                            documentation="" hidden="0"

                            inputType="java.lang.String" listType="0"

                            maximumValue="" minimumValue="" name="dumm2"

                            readOnly="1" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

                        <children attribute="0"

                            className="java.lang.String"

                            controlHidden="0" controlType="2"

                            defaultValue=""

                            displayName="Select destination client"

                            documentation="" hidden="0"

                            inputType="java.lang.String" listType="0"

                            maximumValue="" minimumValue=""

                            name="sDestinationClient" readOnly="1"

                            required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string">

                            <options val="xpath:{/workflow/variables/clientsIBMi}"/>

                        </children>

                        <children attribute="0"

                            className="java.lang.Boolean"

                            controlHidden="0" controlType="5"

                            defaultValue=""

                            displayName="Restore Latest User Data"

                            documentation="" hidden="0"

                            inputType="java.lang.Boolean" listType="0"

                            maximumValue="" minimumValue=""

                            name="latestDataFlag" readOnly="1"

                            required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                        <children alignment="0" attribute="0"

                            className="java.util.Calendar"

                            controlHidden="0" controlType="8"

                            defaultValue=""

                            displayName="Restore Data on or before"

                            documentation="" hidden="0"

                            inputType="java.util.Calendar" listType="0"

                            maximumValue="" minimumValue=""

                            name="dateSelected" readOnly="0"

                            required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}dateTime"/>

                        <children className="java.lang.Boolean"

                            inputType="java.lang.Boolean"

                            name="okClicked" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                        <children className="java.lang.String"

                            inputType="java.lang.String"

                            name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string"/>

                    </outputs>

                    <inputs className="" defaultValue="" listType="0"

                        name="inputs" type="">

                        <children attribute="0"

                            className="java.lang.String"

                            controlHidden="0" controlType="0"

                            defaultValue="" displayName="Source Client"

                            documentation="" hidden="0"

                            inputType="java.lang.String" listType="0"

                            maximumValue="" minimumValue="" name="dumm1"

                            readOnly="1" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

                        <children attribute="0"

                            className="java.lang.String"

                            controlHidden="0" controlType="0"

                            defaultValue=""

                            displayName="Backupset name for data source"

                            documentation="" hidden="0"

                            inputType="java.lang.String" listType="0"

                            maximumValue="" minimumValue="" name="dumm2"

                            readOnly="1" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

                        <children attribute="0"

                            className="java.lang.String"

                            controlHidden="0" controlType="2"

                            defaultValue=""

                            displayName="Select destination client"

                            documentation="" hidden="0"

                            inputType="java.lang.String" listType="0"

                            maximumValue="" minimumValue=""

                            name="sDestinationClient" readOnly="1"

                            required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string">

                            <options val="xpath:{/workflow/variables/clientsIBMi}"/>

                        </children>

                        <children attribute="0"

                            className="java.lang.Boolean"

                            controlHidden="0" controlType="5"

                            defaultValue=""

                            displayName="Restore Latest User Data"

                            documentation="" hidden="0"

                            inputType="java.lang.Boolean" listType="0"

                            maximumValue="" minimumValue=""

                            name="latestDataFlag" readOnly="1"

                            required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                        <children alignment="0" attribute="0"

                            className="java.util.Calendar"

                            controlHidden="0" controlType="8"

                            defaultValue=""

                            displayName="Restore Data on or before"

                            documentation="" hidden="0"

                            inputType="java.util.Calendar" listType="0"

                            maximumValue="" minimumValue=""

                            name="dateSelected" readOnly="0"

                            required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}dateTime"/>

                    </inputs>

                </activitySchema>

                <transition activity="RestoreOptions_1" commented="0"

                    originalStyle="" points="" sourceX="353"

                    sourceY="509" status="0" style="defaultEdge"

                    targetX="193" targetY="519" transitionIndex="0"

                    x="-26" y="109">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1543352611406"

                description="activity to execute code snippets in the selected language"

                displayName="Sort Clients" height="24" interactive="0"

                jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.ScriptActivity"

                uniqueName="Script_19" waitSetting="0" width="100"

                x="365" y="27">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;import commvault.cte.common.xml.XMLDecoder;&amp;#xD;&amp;#xA;import commvault.msgs.App.ClientInfo;&amp;#xD;&amp;#xA;import commvault.msgs.App.GetClientPropertiesResponse;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;GetClientPropertiesResponse resp = XMLDecoder.decode(xpath:{/workflow/getClients/output});&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;List IBMClients = workflow.getVariable(&amp;quot;clientsIBMi&amp;quot;);&amp;#xD;&amp;#xA;List noIBMClients = workflow.getVariable(&amp;quot;myclients&amp;quot;);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;for (ClientInfo client : resp.getClientProperties()) {&amp;#xD;&amp;#xA;    // clientProps ClientNoPhysicalMachine=&amp;quot;true&amp;quot; EnableContentIndexing=&amp;quot;true&amp;quot; EnableSnapBackups=&amp;quot;false&amp;quot; IsDeletedClient=&amp;quot;true&amp;quot;&amp;#xD;&amp;#xA;    if (client.getClientProps().getIsDeletedClient() == false) {&amp;#xD;&amp;#xA;        if (client.getClient().getOsInfo().getOsId() == 118) {&amp;#xD;&amp;#xA;            // only IOBM i Clients&amp;#xD;&amp;#xA;            IBMClients.add(client.getClient().getClientEntity().getClientName());&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;        // clients to restore data to&amp;#xD;&amp;#xA;        noIBMClients.add(client.getClient().getClientEntity().getClientName());&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;clientsIBMi&amp;quot;, IBMClients);&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;myclients&amp;quot;, noIBMClients);&amp;#xD;&amp;#xA;&quot; />&lt;/inputs>"/>

                <transition activity="Decision_7" commented="0"

                    originalStyle="" points="" sourceX="297"

                    sourceY="45" status="0" style="defaultEdge"

                    targetX="527" targetY="45" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1556822080659"

                description="ends the interactive user session"

                displayName="EndUserSession" height="18" interactive="0"

                jobMode="0" name="EndUserSession"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.InteractiveEndSessionActivity"

                uniqueName="EndUserSession_4" waitSetting="0"

                width="124" x="744" y="409">

                <inputs val="&lt;inputs />"/>

                <transition activity="WorkflowEnd_1" commented="0"

                    originalStyle="" points="" sourceX="300"

                    sourceY="837" status="0" style="defaultEdge"

                    targetX="250" targetY="897" transitionIndex="0"

                    x="-53" y="-30">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1556903244470"

                description="if/else based decision"

                displayName="DFRID Good?" height="30" interactive="0"

                jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_36"

                waitSetting="0" width="102" x="613" y="306">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/sDFRID}.match(/^\d/) || xpath:{/workflow/inputs/sDFRID}.length &amp;gt; 10&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVASCRIPT&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="InformationalMessage_8"

                    commented="0" displayName="Invalid" originalStyle=""

                    points="" sourceX="115" sourceY="580" status="0"

                    style="defaultEdge" targetX="243" targetY="580"

                    transitionIndex="0" value="true" x="-26" y="129">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="Decision_11" commented="0"

                    displayName="OK" originalStyle="" points=""

                    sourceX="115" sourceY="580" status="0"

                    style="defaultEdge" targetX="119" targetY="624"

                    transitionIndex="0" value="false" x="-26" y="129">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1556903301789"

                description="displays an informational message to the user"

                displayName="Bad DFRID" height="24" interactive="0"

                jobMode="0" name="InformationalMessage"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.InteractiveMessageActivity"

                uniqueName="InformationalMessage_8" waitSetting="0"

                width="99" x="764" y="307">

                <inputs val="&lt;inputs>&lt;message>Defer ID can be anything alphanumeric string up to 10 characters, but must begin with a letter.&lt;/message>&lt;dialogType>Popup&lt;/dialogType>&lt;iconType>Error&lt;/iconType>&lt;title>Invalid input&lt;/title>&lt;html>false&lt;/html>&lt;formProperties />&lt;/inputs>"/>

                <activitySchema>

                    <outputs name="outputs">

                        <children className="java.lang.String"

                            inputType="java.lang.String"

                            name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string"/>

                    </outputs>

                    <inputs className="" defaultValue="" listType="0"

                        name="inputs" type=""/>

                </activitySchema>

                <transition activity="RestoreOptions_1" commented="0"

                    originalStyle="" points="" sourceX="243"

                    sourceY="560" status="0" style="defaultEdge"

                    targetX="182" targetY="523" transitionIndex="0"

                    x="-26" y="109">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1561020049558"

                description="activity to execute code snippets in the selected language"

                displayName="Begin Restore" height="34" interactive="0"

                jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.ScriptActivity"

                uniqueName="Script_25" waitSetting="0" width="110"

                x="516" y="482">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;&quot; />&lt;/inputs>"/>

            </Activity>

        </superProcess>

        <transition activity="EndUserSession_13" commented="0"

            originalStyle="" points="" sourceX="1652" sourceY="412"

            status="0" style="defaultEdge" targetX="969" targetY="133"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1520522804480" description="if/else based decision"

        displayName="Canceled?" height="57" interactive="0" jobMode="0"

        name="Decision" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_27" waitSetting="0" width="116" x="976" y="280">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/WizardBlock_2/cancelled}&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="WorkflowEnd_30" commented="0"

            displayName="YES" originalStyle="" points="" sourceX="932"

            sourceY="195" status="0" style="defaultEdge" targetX="936"

            targetY="252" transitionIndex="0" value="true" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="ProcessBlock_2" commented="0"

            displayName="NO" originalStyle="" points="" sourceX="932"

            sourceY="195" status="0" style="defaultEdge" targetX="772"

            targetY="72" transitionIndex="0" value="false" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1520522843185" description="Ends the workflow"

        displayName="WorkflowEnd" height="34" interactive="0"

        jobMode="0" name="WorkflowEnd"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.EndActivity"

        uniqueName="WorkflowEnd_30" waitSetting="0" width="110" x="968" y="406">

        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;>FAILED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/failureMessage}&lt;/failureMessage>&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1520528409672"

        description="creates a super process group"

        displayName="RSTAUTH" height="261" interactive="0" jobMode="0"

        name="ProcessBlock"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ProcessBlock_11" waitSetting="0" width="405" x="128" y="2598">

        <inputs val="&lt;inputs>&lt;inputs />&lt;/inputs>"/>

        <superProcess>

            <Start commented="0" continueOnFailure="0"

                created="1520463987970" description=""

                displayName="Start" height="20" interactive="0"

                jobMode="0" name="Start" originalStyle=""

                skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_17" waitSetting="0" width="60" x="50" y="47">

                <inputs val="&lt;inputs />"/>

                <transition activity="RSTAUTH" commented="0"

                    originalStyle="" points="" sourceX="82" sourceY="61"

                    status="0" style="defaultEdge" targetX="342"

                    targetY="111" transitionIndex="0" x="30" y="17">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity commented="0" continueOnFailure="1"

                created="1467903670059"

                description="Execute a command on a remote machine"

                displayName="Run RSTAUTH" height="20" interactive="0"

                jobMode="0" maxRestarts="0" name="ExecuteCommand"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=ExecuteCommand" timeout="120"

                uniqueName="RSTAUTH" waitSetting="0" width="110" x="130" y="47">

                <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/oProxyClient}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>iDataAgent/ClProxyClientUtils&lt;/command>&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/oDestinationClient/clientId} -drrst ''*AUTH'' -timelimit xpath:{/workflow/inputs/TimeoutForQSECRestore} &lt;/arguments>&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

                <transition activity="Decision_28" commented="0"

                    originalStyle="" points="" sourceX="415"

                    sourceY="145" status="0" style="defaultEdge"

                    targetX="254" targetY="192" transitionIndex="0"

                    x="-128" y="-1011">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <onEnter language="1" script="workflow.setVariable(&quot;attemptsRemain&quot;, xpath:{/workflow/variables/attemptsRemain} - 1);"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1467903793888"

                description="if/else based decision"

                displayName="Success?" height="30" interactive="0"

                jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_28"

                waitSetting="0" width="110" x="52" y="101">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/RSTAUTH/exitCode} == 0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="Decision_29" commented="0"

                    displayName="No" originalStyle="" points=""

                    sourceX="433" sourceY="93" status="0"

                    style="defaultEdge" targetX="537" targetY="146"

                    transitionIndex="0" value="false" x="-126" y="-692">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="Script_16" commented="0"

                    displayName="Yes" originalStyle="" points=""

                    sourceX="290" sourceY="20" status="0"

                    style="defaultEdge" targetX="178" targetY="19"

                    transitionIndex="0" value="true" x="-89" y="-817">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="1"

                created="1467903793970"

                description="Sends an email to a list of users"

                displayName="Email" height="20" interactive="0"

                jobMode="0" maxRestarts="1" name="Email"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" restartInterval="1" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.EmailActivity"

                uniqueName="Email_19" waitSetting="0" width="100"

                x="261" y="165">

                <onExit language="1" script="workflow.setVariable(&quot;failureMessage&quot;, &quot;Reclaim of the document library objects has failed.&quot;);"/>

                <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot; _list_=&quot;false&quot;>&lt;to class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/executorEMail}&lt;/to>&lt;cc class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;bcc class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;from class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>IBMi-DR-Recovery@xpath:{/workflow/system/commCellName}&lt;/from>&lt;subject class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>IBM i Data Restore job xpath:{/workflow/system/jobId} failed (do not reply)&lt;/subject>&lt;body class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&amp;lt;p&amp;gt;&#xd;&#xa;      Restore Authority command has failed.&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      See cvd.log for more details on &#xd;&#xa;      xpath:{/workflow/variables/oDestinationClient/clientName} system.&#xd;&#xa;    &amp;lt;/p&amp;gt;&lt;/body>&lt;attachments class=&quot;java.lang.Object&quot; _list_=&quot;false&quot; />&lt;html class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/html>&lt;replyTo class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;repeatInterval class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;/email>&lt;/inputs>"/>

                <transition activity="WorkflowEnd_31" commented="0"

                    originalStyle="" points="" sourceX="312"

                    sourceY="171" status="0" style="defaultEdge"

                    targetX="372" targetY="251" transitionIndex="0"

                    x="30" y="17">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1503597509174"

                description="if/else based decision"

                displayName="Retry?" height="30" interactive="0"

                jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_29"

                waitSetting="0" width="100" x="260" y="107">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/attemptsRemain} &amp;gt; 0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="Delay_7" commented="0"

                    displayName="Yes" originalStyle="" points=""

                    sourceX="512" sourceY="202" status="0"

                    style="defaultEdge" targetX="515" targetY="127"

                    transitionIndex="0" value="true" x="-68" y="-1441">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="Email_19" commented="0"

                    displayName="No" originalStyle="" points=""

                    sourceX="414" sourceY="161" status="0"

                    style="defaultEdge" targetX="416" targetY="237"

                    transitionIndex="0" value="false" x="35" y="-676">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1503597574398"

                description="activity to delay the workflow execution in minutes"

                displayName="Delay" height="20" interactive="0"

                jobMode="0" name="Delay"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.DelayActivity"

                uniqueName="Delay_7" waitSetting="0" width="100" x="266" y="47">

                <inputs val="&lt;inputs>&lt;delayLength class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/delay}&lt;/delayLength>&lt;delayInterval class=&quot;workflow.types.DelayInterval&quot; _list_=&quot;false&quot;>Minutes&lt;/delayInterval>&lt;/inputs>"/>

                <transition activity="RSTAUTH" commented="0"

                    originalStyle="" points="" sourceX="515"

                    sourceY="127" status="0" style="defaultEdge"

                    targetX="407" targetY="123" transitionIndex="0"

                    x="-78" y="-1183">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1503598559002"

                description="activity to execute code snippets in the selected language"

                displayName="Prepare number of attempts" height="20"

                interactive="0" jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.ScriptActivity"

                uniqueName="Script_16" waitSetting="0" width="191"

                x="39" y="197">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;workflow.setVariable(&amp;quot;attemptsRemain&amp;quot;, xpath:{/workflow/inputs/retryAttempts});&quot; />&lt;/inputs>"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1520464082781" description="Ends the workflow"

                displayName="WorkflowEnd" height="20" interactive="0"

                jobMode="0" name="WorkflowEnd"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.EndActivity"

                uniqueName="WorkflowEnd_31" waitSetting="0" width="110"

                x="253" y="201">

                <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot; />&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/failureMessage}&lt;/failureMessage>&lt;/inputs>"/>

            </Activity>

        </superProcess>

        <activitySchema>

            <outputs className="" defaultValue="" listType="0"

                name="outputs" type=""/>

            <inputs className="" defaultValue="" listType="0"

                name="inputs" type=""/>

        </activitySchema>

        <transition activity="Decision_31" commented="0"

            originalStyle="" points="" sourceX="556" sourceY="2209"

            status="0" style="defaultEdge" targetX="443" targetY="2376"

            transitionIndex="0" x="-8" y="566">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1525292081128" description="if/else based decision"

        displayName="DFR is set?" height="111" interactive="0"

        jobMode="0" name="Decision"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_31" waitSetting="0" width="100" x="277" y="2936">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/v_sDFRID} == &quot;*NONE&quot;&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVASCRIPT&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="ProcessBlock_12" commented="0"

            displayName="Yes" originalStyle="" points="" sourceX="443"

            sourceY="2376" status="0"

            style="defaultEdge;fillColor=#CCCCCC;gradientColor=#999999;strokeColor=#999999;fontColor=#666666;fontStyle=1"

            targetX="176" targetY="2376" transitionIndex="0"

            value="false" x="-8" y="566">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="Email_13" commented="0" displayName="No"

            originalStyle="" points="" sourceX="294" sourceY="2449"

            status="0"

            style="defaultEdge;fillColor=#CCCCCC;gradientColor=#999999;strokeColor=#999999;fontColor=#666666;fontStyle=1"

            targetX="187" targetY="2373" transitionIndex="0"

            value="true" x="-12" y="656">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1525292179597"

        description="creates a super process group"

        displayName="RSTDFROBJ" height="261" interactive="0" jobMode="0"

        name="ProcessBlock"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ProcessBlock_12" waitSetting="0" width="323" x="129" y="3088">

        <inputs val="&lt;inputs>&lt;inputs />&lt;/inputs>"/>

        <superProcess>

            <Start commented="0" continueOnFailure="0"

                created="1525292179597" description=""

                displayName="Start" height="22" interactive="0"

                jobMode="0" name="Start" originalStyle=""

                skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_18" waitSetting="0" width="58" x="18" y="30">

                <inputs val="&lt;inputs />"/>

                <transition activity="Script_17" commented="0"

                    originalStyle="" points="" sourceX="47" sourceY="39"

                    status="0" style="defaultEdge" targetX="137"

                    targetY="67" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity commented="0" continueOnFailure="1"

                created="1525292219658"

                description="Execute a command on a remote machine"

                displayName="Run RSTDFROBJ" height="20" interactive="0"

                jobMode="0" maxRestarts="0" name="ExecuteCommand"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=ExecuteCommand" timeout="120"

                uniqueName="RSTDFROBJ" waitSetting="0" width="124"

                x="30" y="66">

                <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/oProxyClient}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>iDataAgent/ClProxyClientUtils&lt;/command>&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/oDestinationClient/clientId} -drrst ''*DFR_xpath:{/workflow/variables/v_sDFRID}'' -timelimit xpath:{/workflow/inputs/TimeoutForQSECRestore} &lt;/arguments>&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

                <transition activity="Decision_32" commented="0"

                    originalStyle="" points="" sourceX="164"

                    sourceY="82" status="0" style="defaultEdge"

                    targetX="84" targetY="127" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <onEnter language="1" script="workflow.setVariable(&quot;attemptsRemain&quot;, xpath:{/workflow/variables/attemptsRemain} - 1);"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1525292322254"

                description="activity to execute code snippets in the selected language"

                displayName="Prep Command" height="20" interactive="0"

                jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.ScriptActivity"

                uniqueName="Script_17" waitSetting="0" width="118"

                x="102" y="30">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;String cmdValue = &amp;quot;*DFR_&amp;quot;;&amp;#xD;&amp;#xA;cmdValue += xpath:{/workflow/variables/v_sDFRID};&amp;#xD;&amp;#xA;return cmdValue;&quot; />&lt;/inputs>"/>

                <transition activity="RSTDFROBJ" commented="0"

                    originalStyle="" points="" sourceX="161"

                    sourceY="40" status="0" style="defaultEdge"

                    targetX="154" targetY="84" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1525293169221"

                description="if/else based decision"

                displayName="Success?" height="39" interactive="0"

                jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_32"

                waitSetting="0" width="100" x="26" y="118">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/RSTDFROBJ/exitCode} == 0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="Decision_33" commented="0"

                    displayName="No" originalStyle="" points=""

                    sourceX="76" sourceY="137" status="0"

                    style="defaultEdge" targetX="268" targetY="134"

                    transitionIndex="0" value="false" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="Script_18" commented="0"

                    displayName="Yes" originalStyle="" points=""

                    sourceX="76" sourceY="137" status="0"

                    style="defaultEdge" targetX="93" targetY="239"

                    transitionIndex="0" value="true" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1525293201593"

                description="if/else based decision"

                displayName="Retry?" height="41" interactive="0"

                jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_33"

                waitSetting="0" width="100" x="218" y="114">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/attemptsRemain} &amp;gt; 0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="Email_20" commented="0"

                    displayName="No" originalStyle="" points=""

                    sourceX="229" sourceY="132" status="0"

                    style="defaultEdge" targetX="238" targetY="187"

                    transitionIndex="0" value="false" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="Delay_8" commented="0"

                    displayName="Yes" originalStyle="" points=""

                    sourceX="229" sourceY="132" status="0"

                    style="defaultEdge" targetX="228" targetY="76"

                    transitionIndex="0" value="true" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1525293261033"

                description="activity to delay the workflow execution in minutes"

                displayName="Delay" height="23" interactive="0"

                jobMode="0" name="Delay"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.DelayActivity"

                uniqueName="Delay_8" waitSetting="0" width="100" x="212" y="64">

                <inputs val="&lt;inputs>&lt;delayLength class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/delay}&lt;/delayLength>&lt;delayInterval class=&quot;workflow.types.DelayInterval&quot; _list_=&quot;false&quot;>Minutes&lt;/delayInterval>&lt;/inputs>"/>

                <transition activity="RSTDFROBJ" commented="0"

                    originalStyle="" points="" sourceX="232"

                    sourceY="77" status="0" style="defaultEdge"

                    targetX="124" targetY="75" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1525293377176"

                description="activity to execute code snippets in the selected language"

                displayName="Prepare number of attempts" height="20"

                interactive="0" jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.ScriptActivity"

                uniqueName="Script_18" waitSetting="0" width="191" x="9" y="184">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;workflow.setVariable(&amp;quot;attemptsRemain&amp;quot;, xpath:{/workflow/inputs/retryAttempts});&quot; />&lt;/inputs>"/>

            </Activity>

            <Activity commented="0" continueOnFailure="1"

                created="1525293405614"

                description="Sends an email to a list of users"

                displayName="Email" height="20" interactive="0"

                jobMode="0" maxRestarts="1" name="Email"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" restartInterval="1" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.EmailActivity"

                uniqueName="Email_20" waitSetting="0" width="100"

                x="213" y="183">

                <onExit language="1" script="workflow.setVariable(&quot;failureMessage&quot;, &quot;Restore Deferred Objects has failed. Check client cvd.log on client for more details.&quot;);"/>

                <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot; _list_=&quot;false&quot;>&lt;to class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/executorEMail}&lt;/to>&lt;cc class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;bcc class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;from class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>IBMi-DR-Recovery@xpath:{/workflow/system/commCellName}&lt;/from>&lt;subject class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>IBM i Data Restore job xpath:{/workflow/system/jobId} failed (do not reply)&lt;/subject>&lt;body class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&amp;lt;p&amp;gt;&#xd;&#xa;      Restore Deferred Objects command has failed.&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      See cvd.log for more details on &#xd;&#xa;      xpath:{/workflow/variables/oDestinationClient/clientName} system.&#xd;&#xa;    &amp;lt;/p&amp;gt;&lt;/body>&lt;attachments class=&quot;java.lang.Object&quot; _list_=&quot;false&quot; />&lt;html class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/html>&lt;replyTo class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;repeatInterval class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;/email>&lt;/inputs>"/>

                <transition activity="WorkflowEnd_32" commented="0"

                    originalStyle="" points="" sourceX="263"

                    sourceY="193" status="0" style="defaultEdge"

                    targetX="254" targetY="247" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1525293561002" description="Ends the workflow"

                displayName="WorkflowEnd" height="20" interactive="0"

                jobMode="0" name="WorkflowEnd"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.EndActivity"

                uniqueName="WorkflowEnd_32" waitSetting="0" width="110"

                x="201" y="217">

                <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot; />&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/failureMessage}&lt;/failureMessage>&lt;/inputs>"/>

            </Activity>

        </superProcess>

        <activitySchema>

            <outputs className="" defaultValue="" listType="0"

                name="outputs" type=""/>

            <inputs className="" defaultValue="" listType="0"

                name="inputs" type=""/>

        </activitySchema>

        <transition activity="Email_13" commented="0" originalStyle=""

            points="" sourceX="192" sourceY="2353" status="0"

            style="defaultEdge;fillColor=#CCCCCC;gradientColor=#999999;strokeColor=#999999;fontColor=#666666;fontStyle=1"

            targetX="512" targetY="2469" transitionIndex="0" x="-8" y="566">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="1"

        created="1467904499198"

        description="Sends an email to a list of users"

        displayName="Email" height="20" interactive="0" jobMode="0"

        maxRestarts="1" name="Email"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" restartInterval="1" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.EmailActivity"

        uniqueName="Email_13" waitSetting="0" width="172" x="435" y="2982">

        <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot; _list_=&quot;false&quot;>&lt;to class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/executorEMail}&lt;/to>&lt;cc class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;bcc class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;from class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>IBMi-DR-Recovery@xpath:{/workflow/system/commCellName}&lt;/from>&lt;subject class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>IBM i Data Restore job xpath:{/workflow/system/jobId} complete (do not reply)&lt;/subject>&lt;body class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&amp;lt;p&amp;gt;&#xd;&#xa;      The Data Restore job xpath:{/workflow/system/jobId} completed.&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      It is recommended to IPL the system before use.&#xd;&#xa;    &amp;lt;/p&amp;gt;&lt;/body>&lt;attachments class=&quot;java.lang.Object&quot; _list_=&quot;false&quot; />&lt;html class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/html>&lt;replyTo class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;repeatInterval class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;/email>&lt;/inputs>"/>

        <transition activity="WorkflowEnd_18" commented="0"

            originalStyle="" points="" sourceX="552" sourceY="2587"

            status="0"

            style="defaultEdge;fillColor=#CCCCCC;gradientColor=#999999;strokeColor=#999999;fontColor=#666666;fontStyle=1"

            targetX="425" targetY="2641" transitionIndex="0" x="-12" y="656">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1551297526793"

        description="activity to execute code snippets in the selected language"

        displayName="Prepare attempts" height="26" interactive="0"

        jobMode="0" name="Script"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.ScriptActivity"

        uniqueName="PrepCounterForQSEC" waitSetting="0" width="159"

        x="1051" y="1025">

        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;workflow.setVariable(&amp;quot;attemptsRemain&amp;quot;, xpath:{/workflow/inputs/retryAttempts});&quot; />&lt;/inputs>"/>

        <transition activity="ProcessBlock_Restore_DR" commented="0"

            originalStyle="" points="" sourceX="1345" sourceY="918"

            status="0" style="defaultEdge" targetX="817" targetY="724"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1560940583786" description="if/else based decision"

        displayName="Is *SEC VTL?" height="56" interactive="0"

        jobMode="0" name="Decision"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_37" waitSetting="0" width="125" x="691" y="1772">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/securityJobUsedVTL} == 1&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="ProcessBlock_5" commented="0"

            displayName="Non-VTL Job" originalStyle="" points=""

            sourceX="338" sourceY="909" status="0" style="defaultEdge"

            targetX="720" targetY="913" transitionIndex="0"

            value="false" x="6" y="20">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="ProcessBlock_Restore_SEC_Tapes"

            commented="0" displayName="VTL Job" originalStyle=""

            points="" sourceX="496" sourceY="916" status="0"

            style="defaultEdge" targetX="193" targetY="706"

            transitionIndex="0" value="true" x="6" y="20">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1560940867564"

        description="creates a super process group"

        displayName="VTL Restore QSEC Tapes &amp; QCFG Data"

        height="285" interactive="0" jobMode="0" name="ProcessBlock"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ProcessBlock_Restore_SEC_Tapes" waitSetting="0"

        width="449" x="53" y="1641">

        <inputs val="&lt;inputs>&lt;inputs />&lt;/inputs>"/>

        <superProcess>

            <Start commented="0" continueOnFailure="0"

                created="1520463302324" description=""

                displayName="Start" height="20" interactive="0"

                jobMode="0" name="Start" originalStyle=""

                skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_22" waitSetting="0" width="58" x="12" y="34">

                <inputs val="&lt;inputs />"/>

                <transition activity="REST_SEC_CFG_VTL" commented="0"

                    originalStyle="" points="" sourceX="88" sourceY="45"

                    status="0" style="defaultEdge" targetX="168"

                    targetY="35" transitionIndex="0" x="38" y="5">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity commented="0" continueOnFailure="1"

                created="1449852128988"

                description="Sends an email to a list of users"

                displayName="Email" height="20" interactive="0"

                jobMode="0" maxRestarts="1" name="Email"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" restartInterval="1" skipAttempt="0"

                style="label;image=Email" uniqueName="Email_22"

                waitSetting="0" width="100" x="232" y="180">

                <onExit language="1" script="workflow.setVariable(&quot;failureMessage&quot;, &quot;Restore job for Security and Configuration objects has failed.&quot;);"/>

                <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot; _list_=&quot;false&quot;>&lt;to class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/executorEMail}&lt;/to>&lt;cc class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;bcc class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;from class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>IBMi-DR-Recovery@xpath:{/workflow/system/commCellName}&lt;/from>&lt;subject class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>IBM i Data Restore job xpath:{/workflow/system/jobId} failed (do not reply)&lt;/subject>&lt;body class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&amp;lt;p&amp;gt;&#xd;&#xa;      Restore job (xpath:{/workflow/QSEC_JOBID/result}) of Security and &#xd;&#xa;      Configuration objects has failed.&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      Please see job details and job log for more information.&#xd;&#xa;    &amp;lt;/p&amp;gt;&lt;/body>&lt;attachments class=&quot;java.lang.Object&quot; _list_=&quot;false&quot; />&lt;html class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/html>&lt;replyTo class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;repeatInterval class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;/email>&lt;/inputs>"/>

                <transition activity="WorkflowEnd_35" commented="0"

                    originalStyle="" points="" sourceX="298"

                    sourceY="205" status="0" style="defaultEdge"

                    targetX="328" targetY="255" transitionIndex="0"

                    x="38" y="5">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1467752617807" description=""

                displayName="Start QSEC &amp; QCFG restore" height="20"

                interactive="0" jobMode="0" name="Execute"

                namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.cmd.operation.OperationExecute"

                uniqueName="REST_SEC_CFG_VTL" waitSetting="0"

                width="200" x="101" y="35">

                <inputs val="&lt;inputs>&lt;inputXml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&amp;lt;TMMsg_CreateTaskReq&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;taskInfo&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;associations&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;appName&amp;gt;Proxy Client File System&amp;lt;/appName&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;backupsetName&amp;gt;xpath:{/workflow/variables/backupSetName}&amp;lt;/backupsetName&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;clientName&amp;gt;xpath:{/workflow/variables/sourceClient/clientName}&amp;lt;/clientName&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;clientSidePackage&amp;gt;true&amp;lt;/clientSidePackage&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;consumeLicense&amp;gt;true&amp;lt;/consumeLicense&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;instanceName&amp;gt;DefaultInstanceName&amp;lt;/instanceName&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;subclientName&amp;gt;&amp;lt;/subclientName&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;type&amp;gt;GALAXY&amp;lt;/type&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/associations&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;subTasks&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;options&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;commonOpts&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;jobDescription&amp;gt;Restore Security and Configuration objects. Parent job xpath:{/workflow/system/jobId}.&amp;lt;/jobDescription&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;/commonOpts&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;restoreOptions&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;browseOption&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;backupset&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;backupsetName&amp;gt;xpath:{/workflow/variables/backupSetName}&amp;lt;/backupsetName&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;clientName&amp;gt;xpath:{/workflow/variables/sourceClient/clientName}&amp;lt;/clientName&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;/backupset&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;commCellId&amp;gt;2&amp;lt;/commCellId&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;useExactIndex&amp;gt;false&amp;lt;/useExactIndex&amp;gt;&amp;#xD;&#xd;&#xa;            xpath:{/workflow/variables/value_TimeRange}&amp;#xD;&#xd;&#xa;            &amp;lt;mediaOption&amp;gt;&amp;#xD;&#xd;&#xa;            xpath:{/workflow/variables/copyPrecedenceXML}&amp;#xD;&#xd;&#xa;            &amp;lt;/mediaOption&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;/browseOption&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;commonOptions&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;detectRegularExpression&amp;gt;true&amp;lt;/detectRegularExpression&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;doNotOverwriteFileOnDisk&amp;gt;false&amp;lt;/doNotOverwriteFileOnDisk&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;iSeriesObject&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;restorePrivateAuthority&amp;gt;xpath:{/workflow/inputs/bPVTAUT}&amp;lt;/restorePrivateAuthority&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;restoreSpooledFileData&amp;gt;xpath:{/workflow/inputs/bSPLFDTA}&amp;lt;/restoreSpooledFileData&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;autl&amp;gt;xpath:{/workflow/inputs/bALWOBJDIF_AUTL}&amp;lt;/autl&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;fileLevel&amp;gt;xpath:{/workflow/inputs/bALWOBJDIF_FILELVL}&amp;lt;/fileLevel&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;owner&amp;gt;xpath:{/workflow/inputs/bALWOBJDIF_OWNER}&amp;lt;/owner&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;pgp&amp;gt;xpath:{/workflow/inputs/bALWOBJDIF_PGP}&amp;lt;/pgp&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;iseriesDifferentObjectType&amp;gt;xpath:{/workflow/variables/value_ALWDIFF}&amp;lt;/iseriesDifferentObjectType&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;forceObjectConversionSelction&amp;gt;xpath:{/workflow/inputs/sOBJCNV}&amp;lt;/forceObjectConversionSelction&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;deferId&amp;gt;xpath:{/workflow/variables/v_sDFRID}&amp;lt;/deferId&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;/iSeriesObject&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;logOutputOption&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;outputType&amp;gt;xpath:{/workflow/variables/value_OUTOUT}&amp;lt;/outputType&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;outputfilename&amp;gt;xpath:{/workflow/inputs/sJOBLOGFileName}&amp;lt;/outputfilename&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;outputMember&amp;gt;xpath:{/workflow/inputs/sJOBLOGMemberName}&amp;lt;/outputMember&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;membertype&amp;gt;xpath:{/workflow/variables/value_MemberType}&amp;lt;/membertype&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;outputTypeInfo&amp;gt;xpath:{/workflow/variables/value_OutputType}&amp;lt;/outputTypeInfo&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;/logOutputOption&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;overwriteFiles&amp;gt;true&amp;lt;/overwriteFiles&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;preserveLevel&amp;gt;1&amp;lt;/preserveLevel&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;stripLevel&amp;gt;0&amp;lt;/stripLevel&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;stripLevelType&amp;gt;PRESERVE_LEVEL&amp;lt;/stripLevelType&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;unconditionalOverwrite&amp;gt;false&amp;lt;/unconditionalOverwrite&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;wildCard&amp;gt;false&amp;lt;/wildCard&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;/commonOptions&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;destination&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;destClient&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;clientName&amp;gt;xpath:{/workflow/variables/oDestinationClient/clientName}&amp;lt;/clientName&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;/destClient&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;iSeriesDestinationAsp&amp;gt;*SAVASP&amp;lt;/iSeriesDestinationAsp&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;iSeriesDestinationAspValue&amp;gt;&amp;lt;/iSeriesDestinationAspValue&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;inPlace&amp;gt;true&amp;lt;/inPlace&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;restoreOnlyIfTargetExists&amp;gt;false&amp;lt;/restoreOnlyIfTargetExists&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;/destination&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;fileOption&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;browseFilters&amp;gt;&amp;amp;lt;?xml version=''1.0'' encoding=''UTF-8''?&amp;amp;gt;&amp;amp;lt;databrowse_Query type=&quot;0&quot; queryId=&quot;0&quot;&amp;amp;gt;&amp;amp;lt;dataParam&amp;amp;gt;&amp;amp;lt;sortParam ascending=&quot;1&quot;&amp;amp;gt;&amp;amp;lt;sortBy val=&quot;38&quot; /&amp;amp;gt;&amp;amp;lt;sortBy val=&quot;0&quot; /&amp;amp;gt;&amp;amp;lt;/sortParam&amp;amp;gt;&amp;amp;lt;paging firstNode=&quot;0&quot; pageSize=&quot;1000&quot; skipNode=&quot;0&quot; /&amp;amp;gt;&amp;amp;lt;/dataParam&amp;amp;gt;&amp;amp;lt;/databrowse_Query&amp;amp;gt;&amp;lt;/browseFilters&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;sourceItem&amp;gt;/&amp;amp;lt;System Configuration&amp;amp;gt;&amp;lt;/sourceItem&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;sourceItem&amp;gt;/&amp;amp;lt;System Security&amp;amp;gt;/*ALL - Security Attributes&amp;lt;/sourceItem&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;/fileOption&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;/restoreOptions&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/options&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;subTask&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;operationType&amp;gt;RESTORE&amp;lt;/operationType&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;subTaskType&amp;gt;RESTORE&amp;lt;/subTaskType&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/subTask&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/subTasks&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;task&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;initiatedFrom&amp;gt;COMMANDLINE&amp;lt;/initiatedFrom&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;policyType&amp;gt;DATA_PROTECTION&amp;lt;/policyType&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;taskFlags&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;disabled&amp;gt;false&amp;lt;/disabled&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/taskFlags&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;taskType&amp;gt;IMMEDIATE&amp;lt;/taskType&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/task&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;/taskInfo&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/TMMsg_CreateTaskReq&amp;gt;&amp;#xD;&#xd;&#xa;&lt;/inputXml>&lt;commandArgs class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/sessionOptions>&lt;escapeXml class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/escapeXml>&lt;/inputs>"/>

                <transition activity="Decision_41" commented="0"

                    originalStyle="" points="" sourceX="-164"

                    sourceY="324" status="0" style="defaultEdge"

                    targetX="-158" targetY="378" transitionIndex="0"

                    x="-359" y="-116">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <onEnter language="1" script="workflow.setVariable(&quot;attemptsRemain&quot;, xpath:{/workflow/variables/attemptsRemain} - 1);"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1467753064751"

                description="retrieves a list of values from xml"

                displayName="Get JOBID" height="20" interactive="0"

                jobMode="0" name="XPathQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.XMLQueryActivity"

                uniqueName="QSEC_VTL_JOBID" waitSetting="0" width="90"

                x="8" y="129">

                <inputs val="&lt;inputs>&lt;xml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/REST_SEC_CFG_VTL/outputXml}&lt;/xml>&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>//jobIds[last()]/@val&lt;/xpath>&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;>Integer&lt;/outputType>&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/outputAsList>&lt;/inputs>"/>

                <transition activity="WaitForJobCompletion_VTL_QSEC"

                    commented="0" originalStyle="" points=""

                    sourceX="-168" sourceY="290" status="0"

                    style="defaultEdge" targetX="70" targetY="290"

                    transitionIndex="0" x="-359" y="-172">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1479323200836"

                description="if/else based decision"

                displayName="Exit Code" height="30" interactive="0"

                jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_41"

                waitSetting="0" width="130" x="9" y="78">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/REST_SEC_CFG_VTL/exitCode} == 0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="Decision_43" commented="0"

                    originalStyle="" points="" sourceX="-175"

                    sourceY="319" status="0" style="defaultEdge"

                    targetX="128" targetY="317" transitionIndex="0"

                    value="false" x="-359" y="-286">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="QSEC_VTL_JOBID" commented="0"

                    displayName="0" originalStyle="" points=""

                    sourceX="-229" sourceY="334" status="0"

                    style="defaultEdge" targetX="-119" targetY="324"

                    transitionIndex="0" value="true" x="-359" y="-286">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1496337436947"

                description="waits until the list of jobs completes"

                displayName="Wait for job" height="20" interactive="0"

                jobMode="0" name="WaitForJobCompletion"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.WaitForJobCompletion"

                uniqueName="WaitForJobCompletion_VTL_QSEC"

                waitSetting="0" width="95" x="3" y="167">

                <inputs val="&lt;inputs>&lt;jobId class=&quot;java.lang.Integer&quot; _list_=&quot;true&quot;>xpath:{/workflow/QSEC_VTL_JOBID/result}&lt;/jobId>&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

                <transition activity="Decision_42" commented="0"

                    originalStyle="" points="" sourceX="85"

                    sourceY="270" status="0" style="defaultEdge"

                    targetX="360" targetY="250" transitionIndex="0"

                    x="-359" y="-286">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1496337668915"

                description="if/else based decision"

                displayName="Success?" height="30" interactive="0"

                jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_42"

                waitSetting="0" width="140" x="113" y="202">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/WaitForJobCompletion_VTL_QSEC/successful}&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="Script_22" commented="0"

                    originalStyle="" points="" sourceX="128"

                    sourceY="235" status="0" style="defaultEdge"

                    targetX="128" targetY="265" transitionIndex="0"

                    value="true" x="38" y="5">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="Decision_43" commented="0"

                    displayName="No" originalStyle="" points=""

                    sourceX="329" sourceY="249" status="0"

                    style="defaultEdge" targetX="337" targetY="362"

                    transitionIndex="0" value="false" x="-390" y="-287">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1503596380680"

                description="activity to delay the workflow execution in minutes"

                displayName="Delay" height="20" interactive="0"

                jobMode="0" name="Delay"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.DelayActivity"

                uniqueName="Delay_10" waitSetting="0" width="100"

                x="167" y="77">

                <inputs val="&lt;inputs>&lt;delayLength class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/delay}&lt;/delayLength>&lt;delayInterval class=&quot;workflow.types.DelayInterval&quot; _list_=&quot;false&quot;>Minutes&lt;/delayInterval>&lt;/inputs>"/>

                <transition activity="REST_SEC_CFG_VTL" commented="0"

                    originalStyle="" points="" sourceX="31"

                    sourceY="319" status="0" style="defaultEdge"

                    targetX="-166" targetY="236" transitionIndex="0"

                    value="true" x="-359" y="-286">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1503596010142"

                description="if/else based decision" displayName="Retry"

                height="30" interactive="0" jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_43"

                waitSetting="0" width="100" x="125" y="140">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/attemptsRemain} &amp;gt; 0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="Delay_10" commented="0"

                    displayName="Yes" originalStyle="" points=""

                    sourceX="55" sourceY="344" status="0"

                    style="defaultEdge" targetX="47" targetY="263"

                    transitionIndex="0" value="true" x="-390" y="-287">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="Email_22" commented="0"

                    displayName="No" originalStyle="" points=""

                    sourceX="114" sourceY="133" status="0"

                    style="defaultEdge" targetX="674" targetY="263"

                    transitionIndex="0" value="false" x="-26" y="-477">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1503598635487"

                description="activity to execute code snippets in the selected language"

                displayName="Prepare number of attempts" height="20"

                interactive="0" jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.ScriptActivity"

                uniqueName="Script_22" waitSetting="0" width="191" x="4" y="248">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;workflow.setVariable(&amp;quot;attemptsRemain&amp;quot;, xpath:{/workflow/inputs/retryAttempts});&quot; />&lt;/inputs>"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1520463433136" description="Ends the workflow"

                displayName="WorkflowEnd" height="20" interactive="0"

                jobMode="0" name="WorkflowEnd"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.EndActivity"

                uniqueName="WorkflowEnd_35" waitSetting="0" width="106"

                x="231" y="246">

                <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;>FAILED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/failureMessage}&lt;/failureMessage>&lt;/inputs>"/>

            </Activity>

        </superProcess>

        <activitySchema>

            <outputs className="" defaultValue="" listType="0"

                name="outputs" type=""/>

            <inputs className="" defaultValue="" listType="0"

                name="inputs" type=""/>

        </activitySchema>

        <transition activity="ProcessBlock_RSTUSRPRF" commented="0"

            originalStyle="" points="" sourceX="193" sourceY="706"

            status="0" style="defaultEdge" targetX="198" targetY="984"

            transitionIndex="0" x="6" y="20">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1560941457289"

        description="creates a super process group"

        displayName="Restore User profiles from Tapes" height="230"

        interactive="0" jobMode="0" name="ProcessBlock"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ProcessBlock_RSTUSRPRF" waitSetting="0" width="535"

        x="47" y="1972">

        <inputs val="&lt;inputs>&lt;inputs />&lt;/inputs>"/>

        <superProcess>

            <Start commented="0" continueOnFailure="0"

                created="1520463575872" description=""

                displayName="Start" height="20" interactive="0"

                jobMode="0" name="Start" originalStyle=""

                skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_27" waitSetting="0" width="80" x="10" y="40">

                <inputs val="&lt;inputs />"/>

                <transition activity="RSTUSRPRF_VTL" commented="0"

                    originalStyle="" points="" sourceX="80" sourceY="50"

                    status="0" style="defaultEdge" targetX="190"

                    targetY="40" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity commented="0" continueOnFailure="1"

                created="1467311973160"

                description="Execute a command on a remote machine"

                displayName="Run RSTUSRPRF" height="20" interactive="0"

                jobMode="0" maxRestarts="0" name="ExecuteCommand"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=ExecuteCommand" timeout="120"

                uniqueName="RSTUSRPRF_VTL" waitSetting="0" width="124"

                x="120" y="40">

                <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/oProxyClient}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>iDataAgent/ClProxyClientUtils&lt;/command>&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/oDestinationClient/clientId} -vtldrrst ''*SEC'' -timelimit xpath:{/workflow/inputs/TimeoutForQSECRestore} -cn xpath:{/workflow/variables/oProxyClient/clientName} -vm xpath:{/workflow/variables/ProxyClientVM} -job xpath:{/workflow/system/jobId} -commcell xpath:{/workflow/variables/CommCellIDForProxy_commcell} -app xpath:{/workflow/variables/subclientIDSourceSecurity} &lt;/arguments>&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

                <transition activity="Decision_46" commented="0"

                    originalStyle="" points="" sourceX="185"

                    sourceY="202" status="0" style="defaultEdge"

                    targetX="-8" targetY="201" transitionIndex="0"

                    x="-294" y="-323">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <onEnter language="1" script="workflow.setVariable(&quot;attemptsRemain&quot;, xpath:{/workflow/variables/attemptsRemain} - 1);"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1467839934711"

                description="if/else based decision"

                displayName="Success?" height="30" interactive="0"

                jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_46"

                waitSetting="0" width="120" x="29" y="93">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/RSTUSRPRF_VTL/exitCode} == 0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="Script_24" commented="0"

                    displayName="Yes" originalStyle="" points=""

                    sourceX="152" sourceY="115" status="0"

                    style="defaultEdge" targetX="40" targetY="114"

                    transitionIndex="0" value="true" x="-227" y="-722">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="Decision_47" commented="0"

                    displayName="No" originalStyle="" points=""

                    sourceX="252" sourceY="196" status="0"

                    style="defaultEdge" targetX="419" targetY="197"

                    transitionIndex="0" value="false" x="-289" y="-635">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="1"

                created="1467840021521"

                description="Sends an email to a list of users"

                displayName="Email" height="20" interactive="0"

                jobMode="0" maxRestarts="1" name="Email"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" restartInterval="1" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.EmailActivity"

                uniqueName="Email_24" waitSetting="0" width="80" x="260" y="150">

                <onExit language="1" script="workflow.setVariable(&quot;failureMessage&quot;, &quot;System Configuration and System Security Objects recovery has failed.&quot;);"/>

                <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot; _list_=&quot;false&quot;>&lt;to class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/executorEMail}&lt;/to>&lt;cc class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;bcc class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;from class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>IBMi-DR-Recovery@xpath:{/workflow/system/commCellName}&lt;/from>&lt;subject class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>IBM i Data Restore job xpath:{/workflow/system/jobId} failed (do not reply) &lt;/subject>&lt;body class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&amp;lt;p&amp;gt;&#xd;&#xa;      System Configuration and System Security Objects recovery has failed.&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      See job log for CVDRRST* job log files for more details on &#xd;&#xa;      xpath:{/workflow/variables/oDestinationClient/clientName} system.&#xd;&#xa;    &amp;lt;/p&amp;gt;&lt;/body>&lt;attachments class=&quot;java.lang.Object&quot; _list_=&quot;false&quot; />&lt;html class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/html>&lt;replyTo class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;repeatInterval class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;/email>&lt;/inputs>"/>

                <transition activity="WorkflowEnd_37" commented="0"

                    originalStyle="" points="" sourceX="300"

                    sourceY="160" status="0" style="defaultEdge"

                    targetX="300" targetY="200" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1503596795274"

                description="if/else based decision" displayName="Retry"

                height="30" interactive="0" jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_47"

                waitSetting="0" width="100" x="246" y="91">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/attemptsRemain} &amp;gt; 0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="Delay_12" commented="0"

                    displayName="Yes" originalStyle="" points=""

                    sourceX="342" sourceY="195" status="0"

                    style="defaultEdge" targetX="367" targetY="118"

                    transitionIndex="0" value="true" x="-227" y="-722">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="Email_24" commented="0"

                    displayName="No" originalStyle="" points=""

                    sourceX="342" sourceY="194" status="0"

                    style="defaultEdge" targetX="509" targetY="193"

                    transitionIndex="0" value="false" x="-227" y="-722">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1503596805881"

                description="activity to delay the workflow execution in minutes"

                displayName="Delay" height="20" interactive="0"

                jobMode="0" name="Delay"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.DelayActivity"

                uniqueName="Delay_12" waitSetting="0" width="70" x="270" y="40">

                <inputs val="&lt;inputs>&lt;delayLength class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/delay}&lt;/delayLength>&lt;delayInterval class=&quot;workflow.types.DelayInterval&quot; _list_=&quot;false&quot;>Minutes&lt;/delayInterval>&lt;/inputs>"/>

                <transition activity="RSTUSRPRF_VTL" commented="0"

                    originalStyle="" points="" sourceX="406"

                    sourceY="113" status="0" style="defaultEdge"

                    targetX="297" targetY="102" transitionIndex="0"

                    x="-227" y="-722">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1503598604821"

                description="activity to execute code snippets in the selected language"

                displayName="Prepare number of attempts" height="20"

                interactive="0" jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.ScriptActivity"

                uniqueName="Script_24" waitSetting="0" width="191"

                x="10" y="189">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;workflow.setVariable(&amp;quot;attemptsRemain&amp;quot;, xpath:{/workflow/inputs/retryAttempts});&quot; />&lt;/inputs>"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1520463687721" description="Ends the workflow"

                displayName="WorkflowEnd" height="20" interactive="0"

                jobMode="0" name="WorkflowEnd"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.EndActivity"

                uniqueName="WorkflowEnd_37" waitSetting="0" width="110"

                x="250" y="190">

                <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;>FAILED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/failureMessage}&lt;/failureMessage>&lt;/inputs>"/>

            </Activity>

        </superProcess>

        <activitySchema>

            <outputs className="" defaultValue="" listType="0"

                name="outputs" type=""/>

            <inputs className="" defaultValue="" listType="0"

                name="inputs" type=""/>

        </activitySchema>

        <transition activity="ProcessBlock_7" commented="0"

            originalStyle="" points="" sourceX="195" sourceY="1130"

            status="0" style="defaultEdge" targetX="205" targetY="1290"

            transitionIndex="0" x="3" y="166">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1568024224683"

        description="ends the interactive user session"

        displayName="EndUserSession" height="18" interactive="0"

        jobMode="0" name="EndUserSession"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.InteractiveEndSessionActivity"

        uniqueName="EndUserSession_13" waitSetting="0" width="124"

        x="964" y="188">

        <inputs val="&lt;inputs />"/>

        <transition activity="Decision_27" commented="0"

            originalStyle="" points="" sourceX="964" sourceY="142"

            status="0" style="defaultEdge" targetX="1084" targetY="196"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1568028801193"

        description="creates a super process group"

        displayName="DR Restore" height="626" interactive="0"

        jobMode="0" name="ProcessBlock"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ProcessBlock_Restore_DR" waitSetting="0" width="978"

        x="33" y="723">

        <inputs val="&lt;inputs>&lt;inputs />&lt;/inputs>"/>

        <superProcess>

            <Start commented="0" continueOnFailure="0"

                created="1568028801193" description=""

                displayName="Start" height="30" interactive="0"

                jobMode="0" name="Start" originalStyle=""

                skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_28" waitSetting="0" width="89" x="18" y="30">

                <inputs val="&lt;inputs />"/>

                <transition activity="Decision_RestoreDR" commented="0"

                    originalStyle="" points="" sourceX="62" sourceY="45"

                    status="0" style="defaultEdge" targetX="77"

                    targetY="198" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity commented="0" continueOnFailure="0"

                created="1568032425678"

                description="performs http operations"

                displayName="Get client jobs" height="32"

                interactive="0" jobMode="0" name="HttpClient"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.HttpClientActivity"

                uniqueName="HttpClient_GetDR_Jobs" waitSetting="0"

                width="117" x="162" y="40">

                <onExit language="1" script="&#xd;&#xa;"/>

                <inputs val="&lt;inputs>&lt;request>&lt;url>/SearchSvc/CVWebService.svc/Job&lt;/url>&lt;method>GET&lt;/method>&lt;postType>Raw&lt;/postType>&lt;postContent>&lt;/postContent>&lt;postContentType>application/xml; charset=UTF-8&lt;/postContentType>&lt;parameters>&lt;name>clientId&lt;/name>&lt;value>xpath:{/workflow/inputs/sourceClient/clientId}&lt;/value>&lt;/parameters>&lt;parameters>&lt;name>jobFilter&lt;/name>&lt;value>SYSRECOVERYBACKUP&lt;/value>&lt;/parameters>&lt;headers>&lt;name>Authtoken&lt;/name>&lt;value>QSDKONLY xpath:{/workflow/system/token}&lt;/value>&lt;/headers>&lt;headers>&lt;name>Accept&lt;/name>&lt;value>application/xml&lt;/value>&lt;/headers>&lt;/request>&lt;/inputs>"/>

                <transition activity="Script_Filter_DR_Job"

                    commented="0" originalStyle="" points=""

                    sourceX="220" sourceY="56" status="0"

                    style="defaultEdge" targetX="344" targetY="83"

                    transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1568035316714"

                description="impersonates the user who created the workflow"

                displayName="ImpersonateCreator" height="34"

                interactive="0" jobMode="0" name="ImpersonateCreator"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.ImpersonateCreator"

                uniqueName="ImpersonateCreator_1" waitSetting="0"

                width="145" x="466" y="42">

                <inputs val="&lt;inputs />"/>

                <transition

                    activity="CommServDBQuery_DR_BackupSet_Proxy"

                    commented="0" originalStyle="" points=""

                    sourceX="569" sourceY="79" status="0"

                    style="defaultEdge" targetX="753" targetY="74"

                    transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1474404177602"

                description="executes queries against a commcell database"

                displayName="Find DR Backupset and Proxy " height="31"

                interactive="0" jobMode="0" name="CommServDBQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=CommServDBQuery"

                uniqueName="CommServDBQuery_DR_BackupSet_Proxy"

                waitSetting="0" width="244" x="675" y="44">

                <onExit language="1" script="DataSet ds = xpath:{/workflow/CommServDBQuery_DR_BackupSet_Proxy/resultSets[1]}.get(0);&#xd;&#xa;while (ds.hasNext()) {&#xd;&#xa;    workflow.setVariable(&quot;sDRBackupSet&quot;, ds.get(0) );&#xd;&#xa;    break;&#xd;&#xa;}&#xd;&#xa;workflow.setVariable(&quot;ProxyClientVM&quot;, xpath:{/workflow/CommServDBQuery_DR_BackupSet_Proxy/resultSets[2]/row[1]/col[1]});&#xd;&#xa;workflow.setVariable(&quot;CommCellIDForProxy_commcell&quot;, xpath:{/workflow/CommServDBQuery_DR_BackupSet_Proxy/resultSets[3]/row[1]/col[1]});"/>

                <inputs val="&lt;inputs>&lt;commCell />&lt;query>SELECT name FROM APP_BackupSetName WITH (NOLOCK) WHERE id IN (SELECT backupSet FROM APP_Application WITH (NOLOCK) WHERE id=?)&amp;#xD;&#xd;&#xa;SELECT attrVal FROM  App_ClientProp WITH (NOLOCK) WHERE attrName LIKE ''%Galaxy Instance Name%'' AND componentNameId=xpath:{/workflow/variables/oProxyClient/clientId}&amp;#xD;&#xd;&#xa;SELECT AppPrxy.origCCId FROM App_Application as AppPrxy WITH (NOLOCK) WHERE clientId=xpath:{/workflow/variables/oProxyClient/clientId}&lt;/query>&lt;parameters>&lt;value>xpath:{/workflow/variables/USRSysSubclientID}&lt;/value>&lt;type>LONG&lt;/type>&lt;/parameters>&lt;/inputs>"/>

                <transition activity="Decision_DR_Tapes" commented="0"

                    originalStyle="" points="" sourceX="824"

                    sourceY="81" status="0" style="defaultEdge"

                    targetX="799" targetY="162" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1565598339694"

                description="executes queries against a commcell database"

                displayName="Query for Chunks by Copy" height="34"

                interactive="0" jobMode="0" name="CommServDBQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.CommServDBQuery"

                uniqueName="CommServDBQuery_Tapes_VTL" waitSetting="0"

                width="214" x="477" y="193">

                <onExit language="1" script="&#xd;&#xa;String strListOfVolume = &quot;&quot;;&#xd;&#xa;&#xd;&#xa;if ( xpath:{/workflow/CommServDBQuery_Tapes_VTL/resultSets[1]/rowCount} != 0 )&#xd;&#xa;{&#xd;&#xa;    List volumeId = xpath:{/workflow/CommServDBQuery_Tapes_VTL/resultSets/row/col[6]};&#xd;&#xa;    List fileTypes = xpath:{/workflow/CommServDBQuery_Tapes_VTL/resultSets/row/col[14]};&#xd;&#xa;    Iterator volumeItr = volumeId.iterator();&#xd;&#xa;    Iterator fileTypeItr = fileTypes.iterator();&#xd;&#xa;    &#xd;&#xa;    while(volumeItr.hasNext()) {&#xd;&#xa;        Integer intInstance = new Integer(volumeItr.next());&#xd;&#xa;        Integer intFileType = new Integer(fileTypeItr.next());&#xd;&#xa;        &#xd;&#xa;        // Filter out files that are part of archive Index, that is fileType != 1 &#xd;&#xa;        if ( intFileType == 1 )&#xd;&#xa;        {&#xd;&#xa;            logger.info(&quot;Restore from [&quot; + intInstance.toString() + &quot;]&quot;);&#xd;&#xa;            strListOfVolume   = strListOfVolume + intInstance.toString() + &quot;, &quot;;&#xd;&#xa;        }&#xd;&#xa;        else&#xd;&#xa;        {&#xd;&#xa;            logger.info(&quot;Don''t restore from &quot; + intInstance.toString() );&#xd;&#xa;        }&#xd;&#xa;    }&#xd;&#xa;    &#xd;&#xa;    // Remove trailing comma and save list of volumes for further use.&#xd;&#xa;    strListOfVolume = strListOfVolume.substring(0, strListOfVolume.length() - 2);&#xd;&#xa;    logger.info(&quot;Volume list for DR [&quot; + strListOfVolume + &quot;]&quot;);&#xd;&#xa;    workflow.setVariable(&quot;strVolumeList&quot;, strListOfVolume);&#xd;&#xa;}&#xd;&#xa;&#xd;&#xa;// Incase no volumes were found, add dummy volume&#xd;&#xa;if (strListOfVolume.length() == 0)&#xd;&#xa;{&#xd;&#xa;    workflow.setVariable(&quot;strVolumeList&quot;, &quot;0&quot;);&#xd;&#xa;}"/>

                <inputs val="&lt;inputs>&lt;commCell />&lt;query>EXEC&#x9;[dbo].[archChunkByJob]&amp;#xD;&#xd;&#xa;&#x9;&#x9;@i_jobId = xpath:{/workflow/inputs/lDRJobId},&amp;#xD;&#xd;&#xa;&#x9;&#x9;@i_commCellId = 2,&amp;#xD;&#xd;&#xa;&#x9;&#x9;@i_dataType = 0,&amp;#xD;&#xd;&#xa;&#x9;&#x9;@i_copyPrecedence = xpath:{/workflow/inputs/nCopyPrecedence},&amp;#xD;&#xd;&#xa;&#x9;&#x9;@i_includeAgedData = 0,&amp;#xD;&#xd;&#xa;&#x9;&#x9;@i_excludeSystemState = 0,&amp;#xD;&#xd;&#xa;&#x9;&#x9;@i_excludeInvalidAF = 1,&amp;#xD;&#xd;&#xa;&#x9;&#x9;@i_preferAccessible = 0&lt;/query>&lt;/inputs>"/>

                <transition

                    activity="CommServDBQuery_Tapes_DR_VTL_Filter"

                    commented="0" originalStyle="" points=""

                    sourceX="822" sourceY="270" status="0"

                    style="defaultEdge" targetX="413" targetY="186"

                    transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1567152562889"

                description="executes queries against a commcell database"

                displayName="Query for DR VTL Tapes" height="34"

                interactive="0" jobMode="0" name="CommServDBQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.CommServDBQuery"

                uniqueName="CommServDBQuery_Tapes_DR_VTL_Filter"

                waitSetting="0" width="211" x="479" y="107">

                <onExit language="1" script="if ( xpath:{/workflow/CommServDBQuery_Tapes_DR_VTL_Filter/resultSets[1]/row[1]/col[4]} == 4 )&#xd;&#xa;{&#xd;&#xa;    workflow.setVariable(&quot;DRJobUsedVTL&quot;, 1);&#xd;&#xa;}&#xd;&#xa;else&#xd;&#xa;{&#xd;&#xa;    workflow.setVariable(&quot;DRJobUsedVTL&quot;, 0);&#xd;&#xa;    workflow.setVariable(&quot;strVolumeList&quot;, &quot;&quot;);&#xd;&#xa;}"/>

                <inputs val="&lt;inputs>&lt;commCell />&lt;query>SELECT MM.MediaId, Vol.VolumeId, MM.BarCode, MLib.VTLType from MMMedia as MM WITH (NOLOCK), MMLibrary as MLib WITH (NOLOCK), MMVolume as Vol WITH (NOLOCK) WHERE Vol.VolumeId in (xpath:{/workflow/variables/strVolumeList}) and Vol.MediaId = MM.MediaId and MM.LibraryId = MLib.LibraryId&amp;#xD;&#xd;&#xa;&lt;/query>&lt;/inputs>"/>

                <transition activity="ImpersonateExecutor_1"

                    commented="0" originalStyle="" points=""

                    sourceX="298" sourceY="115" status="0"

                    style="defaultEdge" targetX="125" targetY="123"

                    transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1568040669308"

                description="iterates a group of activities over a list of values"

                displayName="ForEach_Tape" height="251" interactive="0"

                jobMode="0" name="ForEach"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0" style="swimlane"

                uniqueName="ForEach_Tape" waitSetting="0" width="330"

                x="6" y="300">

                <inputs val="&lt;inputs>&lt;name class=&quot;java.lang.String&quot;>row&lt;/name>&lt;values class=&quot;java.lang.Object&quot; _list_=&quot;false&quot;>xpath:{/workflow/CommServDBQuery_Tapes_DR_VTL_Filter/resultSets/row}&lt;/values>&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>1&lt;/numberOfParallelExecutions>&lt;continueOnFailure class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/continueOnFailure>&lt;/inputs>"/>

                <superProcess>

                    <Start commented="0" continueOnFailure="0"

                        created="1558692628369" description=""

                        displayName="Start" height="30" interactive="0"

                        jobMode="0" name="Start" originalStyle=""

                        skipAttempt="0"

                        style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                        uniqueName="Start_34" waitSetting="0"

                        width="120" x="15" y="35">

                        <inputs val="&lt;inputs />"/>

                        <transition activity="ExecuteCommand_MountTape"

                            commented="0" originalStyle="" points=""

                            sourceX="78" sourceY="45" status="0"

                            style="defaultEdge" targetX="78"

                            targetY="98" transitionIndex="0" x="0" y="0">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Start>

                    <Activity commented="0" continueOnFailure="1"

                        created="1560934110277"

                        description="Execute a command on a remote machine"

                        displayName="Mount Tape" height="40"

                        interactive="0" jobMode="0"

                        name="ExecuteCommand"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=commvault.cte.workflow.activities.ExecuteCommand"

                        timeout="480"

                        uniqueName="ExecuteCommand_MountTape"

                        waitSetting="0" width="96" x="16" y="94">

                        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/oProxyClient}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>iDataAgent/ClProxyClientUtils&lt;/command>&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/oDestinationClient/clientId} -cn xpath:{/workflow/variables/oProxyClient/clientName} -vtlmount -vm xpath:{/workflow/variables/ProxyClientVM} -job xpath:{/workflow/system/jobId} -commcell xpath:{/workflow/variables/CommCellIDForProxy_commcell} -app xpath:{/workflow/variables/USRSysSubclientID} -volume xpath:{/workflow/ForEach_Tape/row/col[2]}&lt;/arguments>&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

                        <transition activity="ImpersonateCreator_3"

                            commented="0" originalStyle="" points=""

                            sourceX="64" sourceY="114" status="0"

                            style="defaultEdge" targetX="188"

                            targetY="46" transitionIndex="0" x="0" y="0">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity commented="0" continueOnFailure="0"

                        created="1560937072562"

                        description="activity to execute code snippets in the selected language"

                        displayName="Next Tape" height="34"

                        interactive="0" jobMode="0" name="Script"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=commvault.cte.workflow.activities.ScriptActivity"

                        uniqueName="Script_NextTape" waitSetting="0"

                        width="100" x="17" y="153">

                        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;&quot; />&lt;/inputs>"/>

                    </Activity>

                    <Activity commented="0" continueOnFailure="0"

                        created="1566369072066"

                        description="suspends execution of the workflow"

                        displayName="SuspendWorkflow" height="34"

                        interactive="0" jobMode="0"

                        name="SuspendWorkflow"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=commvault.cte.workflow.activities.SuspendActivity"

                        uniqueName="SuspendWorkflow_5" waitSetting="0"

                        width="135" x="11" y="206">

                        <inputs val="&lt;inputs>&lt;reason class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>Tape [xpath:{/workflow/ForEach_Tape/row/col[3]}] has been mounted on drive [xpath:{/workflow/CommServDBQuery_DriveInfo/resultSets[1]/row[1]/col[1]}]. Wait for user to resume job&lt;/reason>&lt;resumeIntervalHours class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;resumeIntervalMins class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;/inputs>"/>

                        <transition activity="Script_NextTape"

                            commented="0" originalStyle="" points=""

                            sourceX="242" sourceY="220" status="0"

                            style="defaultEdge" targetX="76"

                            targetY="170" transitionIndex="0" x="0" y="0">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity commented="0" continueOnFailure="0"

                        created="1568378835836"

                        description="impersonates the user who created the workflow"

                        displayName="ImpersonateCreator" height="34"

                        interactive="0" jobMode="0"

                        name="ImpersonateCreator"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=commvault.cte.workflow.activities.ImpersonateCreator"

                        uniqueName="ImpersonateCreator_3"

                        waitSetting="0" width="145" x="177" y="34">

                        <inputs val="&lt;inputs />"/>

                        <transition activity="CommServDBQuery_DriveInfo"

                            commented="0" originalStyle="" points=""

                            sourceX="249" sourceY="51" status="0"

                            style="defaultEdge" targetX="243"

                            targetY="103" transitionIndex="0" x="0" y="0">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity commented="0" continueOnFailure="0"

                        created="1568378846761"

                        description="impersonates the user who executes the workflow"

                        displayName="ImpersonateExecutor" height="34"

                        interactive="0" jobMode="0"

                        name="ImpersonateExecutor"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=commvault.cte.workflow.activities.ImpersonateUser"

                        uniqueName="ImpersonateExecutor_3"

                        waitSetting="0" width="153" x="169" y="147">

                        <inputs val="&lt;inputs />"/>

                        <transition activity="LogEvent_TapeEvent"

                            commented="0" originalStyle="" points=""

                            sourceX="245" sourceY="164" status="0"

                            style="defaultEdge" targetX="72"

                            targetY="220" transitionIndex="0" x="0" y="0">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity commented="0" continueOnFailure="0"

                        created="1568378870604"

                        description="executes queries against a commcell database"

                        displayName="Get Drive Info" height="34"

                        interactive="0" jobMode="0"

                        name="CommServDBQuery"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=commvault.cte.workflow.activities.CommServDBQuery"

                        uniqueName="CommServDBQuery_DriveInfo"

                        waitSetting="0" width="143" x="175" y="93">

                        <onExit language="1" script="logger.info(&quot;Media ID: &quot; + xpath:{/workflow/ForEach_Tape/row/col[1]}); &#xd;&#xa;logger.info(&quot;BarCode: &quot; + xpath:{/workflow/ForEach_Tape/row/col[3]}); &#xd;&#xa;logger.info(&quot;Volume ID: &quot; + xpath:{/workflow/ForEach_Tape/row/col[2]});&#xd;&#xa;logger.info(&quot;Drive Serial: &quot; + xpath:{/workflow/CommServDBQuery_DriveInfo/resultSets[1]/row[1]/col[1]});"/>

                        <inputs val="&lt;inputs>&lt;commCell />&lt;query>SELECT SerialNumber from MMDrive WITH (NOLOCK) where DriveOccupied=1 and MediaId=xpath:{/workflow/ForEach_Tape/row/col[1]} &lt;/query>&lt;/inputs>"/>

                        <transition activity="ImpersonateExecutor_3"

                            commented="0" originalStyle="" points=""

                            sourceX="252" sourceY="101" status="0"

                            style="defaultEdge" targetX="249"

                            targetY="145" transitionIndex="0" x="0" y="0">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity commented="0" continueOnFailure="0"

                        created="1568379305272"

                        description="logs an event in the commcell console with the specified severity level"

                        displayName="Log Tape" height="34"

                        interactive="0" jobMode="0" name="LogEvent"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=commvault.cte.workflow.activities.LogEventActivity"

                        uniqueName="LogEvent_TapeEvent" waitSetting="0"

                        width="100" x="191" y="204">

                        <inputs val="&lt;inputs>&lt;severity class=&quot;workflow.types.SeverityLevel&quot; _list_=&quot;false&quot;>INFO&lt;/severity>&lt;message class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>Tape [xpath:{/workflow/ForEach_Tape/row/col[3]}] has been mounted on drive [xpath:{/workflow/CommServDBQuery_DriveInfo/resultSets[1]/row[1]/col[1]}]. Suspending Job [xpath:{/workflow/system/jobId}]&lt;/message>&lt;/inputs>"/>

                        <transition activity="SuspendWorkflow_5"

                            commented="0" originalStyle="" points=""

                            sourceX="69" sourceY="221" status="0"

                            style="defaultEdge" targetX="216"

                            targetY="218" transitionIndex="0" x="0" y="0">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                </superProcess>

                <activitySchema>

                    <outputs name="outputs">

                        <children

                            className="workflow.types.data.DataRow"

                            inputType="workflow.types.data.DataRow"

                            listType="0" name="row" type="{workflow.types.data}DataRow">

                            <children className="java.lang.Object"

                                inputType="java.lang.Object"

                                listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                        </children>

                    </outputs>

                    <inputs>

                        <children className="java.lang.String"

                            inputType="java.lang.String" name="name" type="{http://www.w3.org/2001/XMLSchema}string"/>

                        <children className="java.lang.Object"

                            inputType="java.lang.Object" name="values" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                        <children className="java.lang.Integer"

                            defaultValue="1"

                            inputType="java.lang.Integer"

                            name="numberOfParallelExecutions" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                        <children className="java.lang.Boolean"

                            defaultValue="false"

                            inputType="java.lang.Boolean"

                            name="continueOnFailure" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                    </inputs>

                </activitySchema>

                <transition activity="ExecuteCommand_4" commented="0"

                    originalStyle="" points="" sourceX="423"

                    sourceY="-711" status="0" style="defaultEdge"

                    targetX="418" targetY="-590" transitionIndex="0"

                    x="138" y="-1011">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="1"

                created="1568040669356"

                description="Execute a command on a remote machine"

                displayName="UnMount Tape" height="40" interactive="0"

                jobMode="0" name="ExecuteCommand"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.ExecuteCommand"

                timeout="240" uniqueName="ExecuteCommand_4"

                waitSetting="0" width="111" x="66" y="572">

                <onExit language="1" script="workflow.setVariable(&quot;attemptsRemain&quot;, xpath:{/workflow/inputs/retryAttempts});"/>

                <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/oProxyClient}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>iDataAgent/ClProxyClientUtils&lt;/command>&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/oDestinationClient/clientId} -cn xpath:{/workflow/variables/oProxyClient/clientName} -vtlmount -vm xpath:{/workflow/variables/ProxyClientVM} -job xpath:{/workflow/system/jobId} -commcell xpath:{/workflow/variables/CommCellIDForProxy_commcell} -app xpath:{/workflow/variables/USRSysSubclientID} -volume 0&lt;/arguments>&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1568038667891"

                description="creates a super process group"

                displayName="Restore DVD Image" height="324"

                interactive="0" jobMode="0" name="ProcessBlock"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0" style="swimlane"

                uniqueName="ProcessBlock_13" waitSetting="0" width="610"

                x="353" y="282">

                <inputs val="&lt;inputs>&lt;inputs />&lt;/inputs>"/>

                <superProcess>

                    <Start commented="0" continueOnFailure="0"

                        created="1447351379215" description=""

                        displayName="Begin" height="30" interactive="0"

                        jobMode="0" name="Start" originalStyle=""

                        skipAttempt="0"

                        style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                        uniqueName="Start_30" waitSetting="0"

                        width="120" x="21" y="39">

                        <inputs val="&lt;inputs />"/>

                        <transition activity="RestoreImages"

                            commented="0" originalStyle="" points=""

                            sourceX="81" sourceY="54" status="0"

                            style="defaultEdge" targetX="350"

                            targetY="113" transitionIndex="0" x="0" y="0">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Start>

                    <Activity commented="0" continueOnFailure="0"

                        created="1448315904032"

                        description="waits until the list of jobs completes"

                        displayName="Wait For DVD Restore" height="30"

                        interactive="0" jobMode="0"

                        name="WaitForJobCompletion"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=WaitForJobCompletion"

                        uniqueName="WaitForJobCompletion_DVDRestore"

                        waitSetting="0" width="160" x="196" y="173">

                        <inputs val="&lt;inputs>&lt;jobId class=&quot;java.lang.Integer&quot; _list_=&quot;true&quot;>xpath:{/workflow/GetJobID/result}&lt;/jobId>&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

                        <transition activity="Decision_8" commented="0"

                            originalStyle="" points="" sourceX="319"

                            sourceY="501" status="0" style="defaultEdge"

                            targetX="314" targetY="574"

                            transitionIndex="0" x="206" y="7">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity commented="0" continueOnFailure="0"

                        created="1448315942556"

                        description="if/else based decision"

                        displayName="Job success?" height="50"

                        interactive="0" jobMode="0" name="Decision"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="rhombus;fontStyle=1"

                        uniqueName="Decision_8" waitSetting="0"

                        width="140" x="196" y="239">

                        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/WaitForJobCompletion_DVDRestore/successful}&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                        <transition activity="Decision_48" commented="0"

                            displayName="Failure" originalStyle=""

                            points="" sourceX="287" sourceY="400"

                            status="0" style="defaultEdge" targetX="480"

                            targetY="400" transitionIndex="0"

                            value="false" x="179" y="-167">

                            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                        <transition activity="Email_1" commented="0"

                            displayName="Success" originalStyle=""

                            points="" sourceX="286" sourceY="355"

                            status="0" style="defaultEdge" targetX="282"

                            targetY="462" transitionIndex="0"

                            value="true" x="178" y="-212">

                            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity commented="0" continueOnFailure="1"

                        created="1449851734500"

                        description="Sends an email to a list of users"

                        displayName="Email" height="34" interactive="0"

                        jobMode="0" maxRestarts="1" name="Email"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" restartInterval="1"

                        skipAttempt="0" style="label;image=Email"

                        uniqueName="Email_1" waitSetting="0" width="100"

                        x="11" y="103">

                        <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot; _list_=&quot;false&quot;>&lt;to class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/executorEMail}&lt;/to>&lt;cc class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;bcc class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;from class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>IBMi-DR-Recovery@xpath:{/workflow/system/commCellName}&lt;/from>&lt;subject class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>IBM i DR Image recovery complete (do not reply)&lt;/subject>&lt;body class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&amp;lt;p&amp;gt;&#xd;&#xa;      Restore job xpath:{/workflow/GetJobID/result} complete.&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      The image files are created under &#xd;&#xa;      xpath:{/workflow/inputs/sDVDImageRestorePath} on client &#xd;&#xa;      xpath:{/workflow/variables/oDestinationClient}.&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      You can IPL your DR system using physical DVD created using those &#xd;&#xa;      image(s) or configured DVD images on your VIOS server.&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      Resume the workflow job once IPL is completed and TCP/IP service is &#xd;&#xa;      configured.&#xd;&#xa;    &amp;lt;/p&amp;gt;&lt;/body>&lt;attachments class=&quot;java.lang.Object&quot; _list_=&quot;false&quot; />&lt;html class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/html>&lt;replyTo class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;repeatInterval class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;/email>&lt;/inputs>"/>

                        <transition activity="SuspendWorkflow_3"

                            commented="0" originalStyle="" points=""

                            sourceX="111" sourceY="314" status="0"

                            style="defaultEdge" targetX="121"

                            targetY="374" transitionIndex="0" x="0" y="0">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity commented="0" continueOnFailure="1"

                        created="1449852128988"

                        description="Sends an email to a list of users"

                        displayName="Email" height="34" interactive="0"

                        jobMode="0" maxRestarts="1" name="Email"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" restartInterval="1"

                        skipAttempt="0" style="label;image=Email"

                        uniqueName="Email_25" waitSetting="0"

                        width="100" x="427" y="193">

                        <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot; _list_=&quot;false&quot;>&lt;to class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/executorEMail}&lt;/to>&lt;cc class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;bcc class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;from class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>IBMi-DR-Recovery@xpath:{/workflow/system/commCellName}&lt;/from>&lt;subject class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>IBM i DR Image recovery complete (do not reply)&lt;/subject>&lt;body class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&amp;lt;p&amp;gt;&#xd;&#xa;      Restore job xpath:{/workflow/GetJobID/result} failed.&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      Please see job details and job log for more information.&#xd;&#xa;    &amp;lt;/p&amp;gt;&lt;/body>&lt;attachments class=&quot;java.lang.Object&quot; _list_=&quot;false&quot; />&lt;html class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/html>&lt;replyTo class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;repeatInterval class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;/email>&lt;/inputs>"/>

                        <transition activity="WorkflowEnd_9"

                            commented="0" originalStyle="" points=""

                            sourceX="446" sourceY="316" status="0"

                            style="defaultEdge" targetX="443"

                            targetY="421" transitionIndex="0" x="4" y="-212">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity commented="0" continueOnFailure="0"

                        created="1450192518871"

                        description="Ends the workflow"

                        displayName="WorkflowEnd" height="34"

                        interactive="0" jobMode="0" name="WorkflowEnd"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=WorkflowEnd"

                        uniqueName="WorkflowEnd_9" waitSetting="0"

                        width="106" x="423" y="252">

                        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;>FAILED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>DVD Images restore job failed&lt;/failureMessage>&lt;/inputs>"/>

                    </Activity>

                    <Activity commented="0" continueOnFailure="0"

                        created="1474390394069"

                        description="suspends execution of the workflow"

                        displayName="SuspendWorkflow" height="34"

                        interactive="0" jobMode="0"

                        name="SuspendWorkflow"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=commvault.cte.workflow.activities.SuspendActivity"

                        uniqueName="SuspendWorkflow_3" waitSetting="0"

                        width="135" x="8" y="260">

                        <onExit language="1" script="workflow.setVariable(&quot;attemptsRemain&quot;, xpath:{/workflow/inputs/retryAttempts});"/>

                        <inputs val="&lt;inputs>&lt;reason class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>Waiting for user to confirm when IBM i OS recovery is completed.&lt;/reason>&lt;resumeIntervalHours class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;resumeIntervalMins class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;/inputs>"/>

                    </Activity>

                    <Activity commented="0" continueOnFailure="0"

                        created="1504273330594" description=""

                        displayName="Start Restore DVD Images job"

                        height="30" interactive="0" jobMode="0"

                        name="Execute"

                        namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                        originalStyle="" skipAttempt="0"

                        style="label;image=commvault.cte.workflow.activities.cmd.operation.OperationExecute"

                        uniqueName="RestoreImages" waitSetting="0"

                        width="198" x="194" y="39">

                        <onExit language="1" script="&#xd;&#xa;"/>

                        <inputs val="&lt;inputs>&lt;inputXml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&amp;lt;?xml version=&quot;1.0&quot; encoding=&quot;UTF-8&quot; standalone=&quot;no&quot; ?&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;TMMsg_CreateTaskReq&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;taskInfo&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;task&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;taskFlags&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;disabled&amp;gt;false&amp;lt;/disabled&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;isEdgeDrive&amp;gt;false&amp;lt;/isEdgeDrive&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/taskFlags&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;policyType&amp;gt;DATA_PROTECTION&amp;lt;/policyType&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;taskType&amp;gt;IMMEDIATE&amp;lt;/taskType&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;initiatedFrom&amp;gt;WorkFlow job xpath:{/workflow/system/jobId}&amp;lt;/initiatedFrom&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/task&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;associations&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;subclientName&amp;gt;&amp;lt;/subclientName&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;backupsetName&amp;gt;xpath:{/workflow/variables/sDRBackupSet}&amp;lt;/backupsetName&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;instanceName&amp;gt;DefaultInstanceName&amp;lt;/instanceName&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;appName&amp;gt;File System&amp;lt;/appName&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;clientName&amp;gt;xpath:{/workflow/variables/sourceClient/clientName}&amp;lt;/clientName&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/associations&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;subTasks&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;subTask&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;subTaskType&amp;gt;RESTORE&amp;lt;/subTaskType&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;operationType&amp;gt;RESTORE&amp;lt;/operationType&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/subTask&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;options&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;restoreOptions&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;browseOption&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;commCellId&amp;gt;2&amp;lt;/commCellId&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;backupset&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;backupsetName&amp;gt;xpath:{/workflow/variables/sDRBackupSet}&amp;lt;/backupsetName&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;clientName&amp;gt;xpath:{/workflow/variables/sourceClient/clientName}&amp;lt;/clientName&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;/backupset&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;noImage&amp;gt;false&amp;lt;/noImage&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;useExactIndex&amp;gt;false&amp;lt;/useExactIndex&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;mediaOption&amp;gt;&amp;#xD;&#xd;&#xa;            xpath:{/workflow/variables/copyPrecedenceXML}&amp;#xD;&#xd;&#xa;            &amp;lt;/mediaOption&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;timeZone&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;TimeZoneName&amp;gt;(UTC-05:00) Eastern Time (US &amp;amp;amp; Canada)&amp;lt;/TimeZoneName&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;/timeZone&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;listMedia&amp;gt;false&amp;lt;/listMedia&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;/browseOption&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;destination&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;destPath&amp;gt;xpath:{/workflow/inputs/sDVDImageRestorePath}&amp;lt;/destPath&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;destClient&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;clientName&amp;gt;xpath:{/workflow/inputs/oDVDTargetClient/clientName}&amp;lt;/clientName&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;/destClient&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;inPlace&amp;gt;false&amp;lt;/inPlace&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;isLegalHold&amp;gt;false&amp;lt;/isLegalHold&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;restoreOnlyIfTargetExists&amp;gt;false&amp;lt;/restoreOnlyIfTargetExists&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;iSeriesDestinationAsp&amp;gt;*SAVASP&amp;lt;/iSeriesDestinationAsp&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;iSeriesDestinationAspValue&amp;gt;&amp;lt;/iSeriesDestinationAspValue&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;noOfStreams&amp;gt;1&amp;lt;/noOfStreams&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;/destination&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;sharePointRstOption&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;is90OrUpgradedClient&amp;gt;false&amp;lt;/is90OrUpgradedClient&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;/sharePointRstOption&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;volumeRstOption&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;volumeLeveRestore&amp;gt;false&amp;lt;/volumeLeveRestore&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;/volumeRstOption&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;virtualServerRstOption&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;isDiskBrowse&amp;gt;false&amp;lt;/isDiskBrowse&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;viewType&amp;gt;DEFAULT&amp;lt;/viewType&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;isBlockLevelReplication&amp;gt;false&amp;lt;/isBlockLevelReplication&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;/virtualServerRstOption&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;fileOption&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;sourceItem&amp;gt;xpath:{/workflow/variables/sDVDSourcePath}&amp;lt;/sourceItem&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;browseFilters&amp;gt;&amp;amp;lt;?xml version=''1.0'' encoding=''UTF-8''?&amp;amp;gt;&amp;amp;lt;databrowse_Query type=&quot;0&quot; queryId=&quot;0&quot;&amp;amp;gt;&amp;amp;lt;dataParam&amp;amp;gt;&amp;amp;lt;sortParam ascending=&quot;1&quot;&amp;amp;gt;&amp;amp;lt;sortBy val=&quot;38&quot; /&amp;amp;gt;&amp;amp;lt;sortBy val=&quot;0&quot; /&amp;amp;gt;&amp;amp;lt;/sortParam&amp;amp;gt;&amp;amp;lt;paging firstNode=&quot;0&quot; pageSize=&quot;1000&quot; skipNode=&quot;0&quot; /&amp;amp;gt;&amp;amp;lt;/dataParam&amp;amp;gt;&amp;amp;lt;/databrowse_Query&amp;amp;gt;&amp;lt;/browseFilters&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;/fileOption&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;commonOptions&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;overwriteFiles&amp;gt;true&amp;lt;/overwriteFiles&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;detectRegularExpression&amp;gt;true&amp;lt;/detectRegularExpression&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;wildCard&amp;gt;false&amp;lt;/wildCard&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;unconditionalOverwrite&amp;gt;false&amp;lt;/unconditionalOverwrite&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;stripLevelType&amp;gt;REMOVE_LEVEL&amp;lt;/stripLevelType&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;preserveLevel&amp;gt;0&amp;lt;/preserveLevel&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;stripLevel&amp;gt;3&amp;lt;/stripLevel&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;powerRestore&amp;gt;false&amp;lt;/powerRestore&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;doNotOverwriteFileOnDisk&amp;gt;false&amp;lt;/doNotOverwriteFileOnDisk&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;systemStateBackup&amp;gt;false&amp;lt;/systemStateBackup&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;onePassRestore&amp;gt;false&amp;lt;/onePassRestore&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;offlineMiningRestore&amp;gt;false&amp;lt;/offlineMiningRestore&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;isFromBrowseBackup&amp;gt;false&amp;lt;/isFromBrowseBackup&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;clusterDBBackedup&amp;gt;false&amp;lt;/clusterDBBackedup&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;restoreToDisk&amp;gt;false&amp;lt;/restoreToDisk&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;syncRestore&amp;gt;false&amp;lt;/syncRestore&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;deleteFilesBeforeRestore&amp;gt;false&amp;lt;/deleteFilesBeforeRestore&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;/commonOptions&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;distributedAppsRestoreOptions&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;distributedRestore&amp;gt;false&amp;lt;/distributedRestore&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;isMultiNodeRestore&amp;gt;false&amp;lt;/isMultiNodeRestore&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;/distributedAppsRestoreOptions&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;/restoreOptions&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;adminOpts&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;contentIndexingOption&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;subClientBasedAnalytics&amp;gt;false&amp;lt;/subClientBasedAnalytics&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;/contentIndexingOption&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;/adminOpts&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;commonOpts&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;jobRetryOpts&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;runningTime&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;enableTotalRunningTime&amp;gt;false&amp;lt;/enableTotalRunningTime&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;totalRunningTime&amp;gt;01:00:00&amp;lt;/totalRunningTime&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;/runningTime&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;killRunningJobWhenTotalRunningTimeExpires&amp;gt;false&amp;lt;/killRunningJobWhenTotalRunningTimeExpires&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;enableNumberOfRetries&amp;gt;true&amp;lt;/enableNumberOfRetries&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;numberOfRetries&amp;gt;xpath:{/workflow/inputs/retryAttempts}&amp;lt;/numberOfRetries&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;/jobRetryOpts&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;jobDescription&amp;gt;OS DVD Image files Restore job xpath:{/workflow/system/jobId}&amp;lt;/jobDescription&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;/commonOpts&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/options&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;subTaskOperation&amp;gt;OVERWRITE&amp;lt;/subTaskOperation&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/subTasks&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;/taskInfo&amp;gt;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&amp;lt;/TMMsg_CreateTaskReq&amp;gt;&lt;/inputXml>&lt;escapeXml class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/escapeXml>&lt;commandArgs class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

                        <transition activity="GetJobID" commented="0"

                            originalStyle="" points="" sourceX="624"

                            sourceY="1251" status="0"

                            style="defaultEdge" targetX="624"

                            targetY="1313" transitionIndex="0" x="201" y="-164">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity commented="0" continueOnFailure="0"

                        created="1504280609455"

                        description="if/else based decision"

                        displayName="Retry?" height="30" interactive="0"

                        jobMode="0" name="Decision"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="rhombus;fontStyle=1"

                        uniqueName="Decision_48" waitSetting="0"

                        width="100" x="449" y="135">

                        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/attemptsRemain} &amp;gt; 0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                        <transition activity="Delay_13" commented="0"

                            displayName="YES" originalStyle="" points=""

                            sourceX="768" sourceY="1311" status="0"

                            style="defaultEdge" targetX="705"

                            targetY="1236" transitionIndex="0"

                            value="true" x="0" y="0">

                            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                        <transition activity="Email_25" commented="0"

                            displayName="NO" originalStyle="" points=""

                            sourceX="515" sourceY="269" status="0"

                            style="defaultEdge" targetX="475"

                            targetY="309" transitionIndex="0"

                            value="false" x="0" y="0">

                            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity commented="0" continueOnFailure="0"

                        created="1504878889003"

                        description="retrieves a list of values from xml"

                        displayName="Get Job ID" height="20"

                        interactive="0" jobMode="0" name="XPathQuery"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=commvault.cte.workflow.activities.XMLQueryActivity"

                        uniqueName="GetJobID" waitSetting="0"

                        width="160" x="193" y="121">

                        <inputs val="&lt;inputs>&lt;xml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/RestoreImages/outputXml}&lt;/xml>&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>//jobIds[last()]/@val&lt;/xpath>&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;>String&lt;/outputType>&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/outputAsList>&lt;/inputs>"/>

                        <transition

                            activity="WaitForJobCompletion_DVDRestore"

                            commented="0" originalStyle="" points=""

                            sourceX="308" sourceY="266" status="0"

                            style="defaultEdge" targetX="314"

                            targetY="330" transitionIndex="0" x="201" y="-164">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity commented="0" continueOnFailure="0"

                        created="1504879291387"

                        description="activity to delay the workflow execution in minutes"

                        displayName="Delay" height="28" interactive="0"

                        jobMode="0" name="Delay"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=commvault.cte.workflow.activities.DelayActivity"

                        uniqueName="Delay_13" waitSetting="0"

                        width="100" x="425" y="39">

                        <onExit language="1" script="workflow.setVariable(&quot;attemptsRemain&quot;, xpath:{/workflow/variables/attemptsRemain} - 1);"/>

                        <inputs val="&lt;inputs>&lt;delayLength class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/delay}&lt;/delayLength>&lt;delayInterval class=&quot;workflow.types.DelayInterval&quot; _list_=&quot;false&quot;>Minutes&lt;/delayInterval>&lt;/inputs>"/>

                        <transition activity="RestoreImages"

                            commented="0" originalStyle="" points=""

                            sourceX="473" sourceY="158" status="0"

                            style="defaultEdge" targetX="346"

                            targetY="165" transitionIndex="0" x="0" y="0">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                </superProcess>

                <activitySchema>

                    <outputs className="" defaultValue="" listType="0"

                        name="outputs" type=""/>

                    <inputs className="" defaultValue="" listType="0"

                        name="inputs" type=""/>

                </activitySchema>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1568042547974"

                description="impersonates the user who executes the workflow"

                displayName="ImpersonateExecutor" height="34"

                interactive="0" jobMode="0" name="ImpersonateExecutor"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.ImpersonateUser"

                uniqueName="ImpersonateExecutor_1" waitSetting="0"

                width="153" x="269" y="109">

                <inputs val="&lt;inputs />"/>

                <transition activity="Decision_DR_VTL" commented="0"

                    originalStyle="" points="" sourceX="89"

                    sourceY="243" status="0" style="defaultEdge"

                    targetX="304" targetY="258" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1568042566289"

                description="if/else based decision"

                displayName="Restore DR?" height="100" interactive="0"

                jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1"

                uniqueName="Decision_RestoreDR" waitSetting="0"

                width="101" x="17" y="90">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/lDRJobId}==0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="Continue_to_Security"

                    commented="0" displayName="NO" originalStyle=""

                    points="" sourceX="93" sourceY="223" status="0"

                    style="defaultEdge" targetX="80" targetY="330"

                    transitionIndex="0" value="true" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="HttpClient_GetDR_Jobs"

                    commented="0" displayName="YES" originalStyle=""

                    points="" sourceX="93" sourceY="223" status="0"

                    style="defaultEdge" targetX="213" targetY="45"

                    transitionIndex="0" value="false" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1568042637894"

                description="if/else based decision"

                displayName="DR was VTL" height="100" interactive="0"

                jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_DR_VTL"

                waitSetting="0" width="100" x="274" y="165">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/DRJobUsedVTL}==1&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="ForEach_Tape" commented="0"

                    displayName="Yes" originalStyle="" points=""

                    sourceX="285" sourceY="260" status="0"

                    style="defaultEdge" targetX="151" targetY="290"

                    transitionIndex="0" value="true" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="ProcessBlock_13" commented="0"

                    displayName="No" originalStyle="" points=""

                    sourceX="341" sourceY="201" status="0"

                    style="defaultEdge" targetX="400" targetY="354"

                    transitionIndex="0" value="false" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1568042796737"

                description="activity to execute code snippets in the selected language"

                displayName="Continue" height="34" interactive="0"

                jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.ScriptActivity"

                uniqueName="Continue_to_Security" waitSetting="0"

                width="100" x="7" y="237">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;&quot; />&lt;/inputs>"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1568096370593"

                description="if/else based decision"

                displayName="Query DR Tapes?" height="100"

                interactive="0" jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1"

                uniqueName="Decision_DR_Tapes" waitSetting="0"

                width="128" x="752" y="119">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/strVolumeList}.isEmpty()&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="CommServDBQuery_Tapes_VTL"

                    commented="0" displayName="YES" originalStyle=""

                    points="" sourceX="806" sourceY="178" status="0"

                    style="defaultEdge" targetX="796" targetY="282"

                    transitionIndex="0" value="true" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition

                    activity="CommServDBQuery_Tapes_DR_VTL_Filter"

                    commented="0" displayName="NO" originalStyle=""

                    points="" sourceX="806" sourceY="178" status="0"

                    style="defaultEdge" targetX="425" targetY="190"

                    transitionIndex="0" value="false" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1568110989615"

                description="activity to execute code snippets in the selected language"

                displayName="Filter DR Job" height="34" interactive="0"

                jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.ScriptActivity"

                uniqueName="Script_Filter_DR_Job" waitSetting="0"

                width="101" x="318" y="39">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;import commvault.cte.common.xml.XMLDecoder;&amp;#xD;&amp;#xA;import commvault.msgs.JobManager.Job;&amp;#xD;&amp;#xA;import commvault.msgs.JobManager.JobListResponse;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;JobListResponse resp = XMLDecoder.decode(xpath:{/workflow/HttpClient_GetDR_Jobs/output});&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;List drJobList = new ArrayList();&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;for (Job job : resp.getJobs())&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    if( job.getJobSummary().getJobId() == xpath:{/workflow/inputs/lDRJobId} )&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        String str = &amp;quot;/&amp;amp;lt;DR.IMAGE&amp;amp;gt;/&amp;quot; + job.getJobSummary().getJobId();&amp;#xD;&amp;#xA;        logger.info(&amp;quot;Restore path is [&amp;quot; + str + &amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;        workflow.setVariable(&amp;quot;USRSysSubclientID&amp;quot;, job.getJobSummary().getSubclient().getSubclientId() );&amp;#xD;&amp;#xA;        workflow.setVariable(&amp;quot;sDVDSourcePath&amp;quot;, str );&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        break;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;}&quot; />&lt;/inputs>"/>

                <transition activity="ImpersonateCreator_1"

                    commented="0" originalStyle="" points=""

                    sourceX="374" sourceY="78" status="0"

                    style="defaultEdge" targetX="480" targetY="58"

                    transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

        </superProcess>

        <activitySchema>

            <outputs className="" defaultValue="" listType="0"

                name="outputs" type=""/>

            <inputs className="" defaultValue="" listType="0"

                name="inputs" type=""/>

        </activitySchema>

        <transition activity="ProcessBlock_Security_Restore_Tape_Query"

            commented="0" originalStyle="" points="" sourceX="522"

            sourceY="1036" status="0" style="defaultEdge" targetX="1500"

            targetY="1319" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1568103300399"

        description="creates a super process group"

        displayName="Security Restore Tape Query" height="197"

        interactive="0" jobMode="0" name="ProcessBlock"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ProcessBlock_Security_Restore_Tape_Query"

        waitSetting="0" width="401" x="552" y="1442">

        <inputs val="&lt;inputs>&lt;inputs />&lt;/inputs>"/>

        <superProcess>

            <Start commented="0" continueOnFailure="0"

                created="1568103300399" description=""

                displayName="Start" height="30" interactive="0"

                jobMode="0" name="Start" originalStyle=""

                skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_35" waitSetting="0" width="120" x="18" y="30">

                <inputs val="&lt;inputs />"/>

                <transition activity="ImpersonateCreator_2"

                    commented="0" originalStyle="" points=""

                    sourceX="78" sourceY="45" status="0"

                    style="defaultEdge" targetX="261" targetY="46"

                    transitionIndex="0" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity commented="0" continueOnFailure="0"

                created="1568103365064"

                description="impersonates the user who created the workflow"

                displayName="ImpersonateCreator" height="34"

                interactive="0" jobMode="0" name="ImpersonateCreator"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.ImpersonateCreator"

                uniqueName="ImpersonateCreator_2" waitSetting="0"

                width="145" x="208" y="29">

                <inputs val="&lt;inputs />"/>

                <transition activity="CommServDBQuery_SEC_SC"

                    commented="0" originalStyle="" points=""

                    sourceX="261" sourceY="46" status="0"

                    style="defaultEdge" targetX="493" targetY="47"

                    transitionIndex="0" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1568103378149"

                description="executes queries against a commcell database"

                displayName="Query for *SEC subclient" height="42"

                interactive="0" jobMode="0" name="CommServDBQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.CommServDBQuery"

                uniqueName="CommServDBQuery_SEC_SC" waitSetting="0"

                width="169" x="200" y="86">

                <onExit language="1" script="workflow.setVariable(&quot;subclientIDSourceSecurity&quot;, xpath:{/workflow/CommServDBQuery_SEC_SC/resultSets[1]/row[1]/col[1]});&#xd;&#xa;workflow.setVariable(&quot;ProxyClientVM&quot;, xpath:{/workflow/CommServDBQuery_SEC_SC/resultSets[2]/row[1]/col[1]});&#xd;&#xa;workflow.setVariable(&quot;CommCellIDForProxy_commcell&quot;, xpath:{/workflow/CommServDBQuery_SEC_SC/resultSets[3]/row[1]/col[1]});"/>

                <inputs val="&lt;inputs>&lt;commCell />&lt;query>select App.id from App_Application as App WITH (NOLOCK) where clientId=xpath:{/workflow/variables/sourceClient/clientId} and backupSet in ( select id from App_BackupSetName WITH (NOLOCK) where name like ''xpath:{/workflow/variables/backupSetName}'') and subclientName like ''*SECDTA''&amp;#xD;&#xd;&#xa;select attrVal from  App_ClientProp WITH (NOLOCK) where attrName like ''%Galaxy Instance Name%'' and componentNameId=xpath:{/workflow/variables/oProxyClient/clientId}&amp;#xD;&#xd;&#xa;select AppPrxy.origCCId from App_Application as AppPrxy WITH (NOLOCK) where clientId=xpath:{/workflow/variables/oProxyClient/clientId}&lt;/query>&lt;/inputs>"/>

                <transition activity="CommServDBQuery_SEC_Job"

                    commented="0" originalStyle="" points=""

                    sourceX="304" sourceY="97" status="0"

                    style="defaultEdge" targetX="303" targetY="162"

                    transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1568103565686"

                description="executes queries against a commcell database"

                displayName="Query for SEC Tapes" height="34"

                interactive="0" jobMode="0" name="CommServDBQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.CommServDBQuery"

                uniqueName="CommServDBQuery_SEC_Tapes" waitSetting="0"

                width="147" x="15" y="86">

                <onExit language="1" script="if ( xpath:{/workflow/CommServDBQuery_SEC_Tapes/resultSets[1]/rowCount} != 0 )&#xd;&#xa;{&#xd;&#xa;    workflow.setVariable(&quot;securityJobUsedVTL&quot;, 1); &#xd;&#xa;}&#xd;&#xa;else&#xd;&#xa;{&#xd;&#xa;    workflow.setVariable(&quot;securityJobUsedVTL&quot;, 0);&#xd;&#xa;}"/>

                <inputs val="&lt;inputs>&lt;commCell />&lt;query>select MM.MediaId, Vol.VolumeId, MM.BarCode from MMMedia as MM WITH (NOLOCK), MMVolume as Vol WITH (NOLOCK), MMLibrary as MLib WITH (NOLOCK) WHERE MM.MediaId = Vol.MediaId AND MLib.LibraryId = MM.LibraryId AND MLib.VTLType = 4 AND Vol.VolumeId in (select volumeId from archChunk where id in ( select archChunkId from archChunkMapping where jobId=xpath:{/workflow/variables/SecurityJobId}))&lt;/query>&lt;/inputs>"/>

                <transition activity="ImpersonateExecutor_2"

                    commented="0" originalStyle="" points=""

                    sourceX="88" sourceY="103" status="0"

                    style="defaultEdge" targetX="88" targetY="161"

                    transitionIndex="0" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1568105273823"

                description="impersonates the user who executes the workflow"

                displayName="ImpersonateExecutor" height="34"

                interactive="0" jobMode="0" name="ImpersonateExecutor"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.ImpersonateUser"

                uniqueName="ImpersonateExecutor_2" waitSetting="0"

                width="153" x="12" y="144">

                <inputs val="&lt;inputs />"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1568105838144"

                description="executes queries against a commcell database"

                displayName="Query for *SEC Jobs" height="34"

                interactive="0" jobMode="0" name="CommServDBQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.CommServDBQuery"

                uniqueName="CommServDBQuery_SEC_Job" waitSetting="0"

                width="145" x="209" y="151">

                <onExit language="1" script="workflow.setVariable(&quot;SecurityJobId&quot;, xpath:{/workflow/CommServDBQuery_SEC_Job/resultSets[1]/row[1]/col[1]});"/>

                <inputs val="&lt;inputs>&lt;commCell />&lt;query>select TOP 1  jobId from JMBkpStats  as stat WITH (NOLOCK) where appId=xpath:{/workflow/variables/subclientIDSourceSecurity} and servEndDate&amp;lt;=xpath:{/workflow/variables/restoreTimeUnix} and status = 1 and agedTime = 0 order by jobId DESC&amp;#xD;&#xd;&#xa;&lt;/query>&lt;/inputs>"/>

                <transition activity="CommServDBQuery_SEC_Tapes"

                    commented="0" originalStyle="" points=""

                    sourceX="280" sourceY="163" status="0"

                    style="defaultEdge" targetX="147" targetY="97"

                    transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

        </superProcess>

        <activitySchema>

            <outputs className="" defaultValue="" listType="0"

                name="outputs" type=""/>

            <inputs className="" defaultValue="" listType="0"

                name="inputs" type=""/>

        </activitySchema>

        <transition activity="Decision_37" commented="0"

            originalStyle="" points="" sourceX="1345" sourceY="1268"

            status="0" style="defaultEdge" targetX="750" targetY="1692"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1569399934422"

        description="ends the interactive user session"

        displayName="EndUserSessionWithOutputs" height="34"

        interactive="0" jobMode="0" name="EndUserSessionWithOutputs"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.InteractiveEndSessionOutputsActivity"

        uniqueName="EndUserSessionWithOutputs_1" waitSetting="0"

        width="195" x="597" y="85">

        <inputs val="&lt;inputs />"/>

        <activitySchema>

            <outputs className="" defaultValue="" listType="0"

                name="outputs" type=""/>

        </activitySchema>

        <transition activity="ProcessBlock_2" commented="0"

            originalStyle="" points="" sourceX="694" sourceY="102"

            status="0" style="defaultEdge" targetX="1270" targetY="86"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <formProperties css="" formVersion="0" javaScript="" pageMode="0">

        <rules/>

    </formProperties>

</workflow>'

IF exists (select * from WF_Definition where Name = @oldname)

BEGIN

	UPDATE WF_Definition

	SET flags = 23

	WHERE Name = @oldname

END

IF not exists (select * from WF_Definition where Name = @name)

BEGIN
	INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision, uniqueGuid)


	VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision, @guid)

	SET @workflowId = @@IDENTITY
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


	VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

	SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = ISNULL(revision, '') From WF_Definition WHERE Name = @name

	IF (@currentFlags & 4 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0) AND (@currentRevision <> @revision)

	BEGIN

		SET @version = @version + 1

		UPDATE WF_Definition

		SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision, uniqueGuid = @guid

		WHERE Name = @name

		IF (@flags & 8 > 0 OR @flags & 16 > 0)

		BEGIN

			UPDATE WF_Definition

			SET flags = @flags

			WHERE Name = @name

		END
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


		VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

	END

END

