

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_GenerateAuthCode.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/WFD_GenerateAuthCode.script,v $ $Id: WFD_GenerateAuthCode.script,v 1.5 2015/06/05 16:35:53 csunderland Exp $";
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER OFF

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.5 $'

SET @name = 'Generate Auth Code'

SET @description = 'Creates Authorization Code'

SET @version = 1

SET @flags = 6

SET @definition = '<workflow apiMode="0" description="Creates Authorization Code"

    inputs="&lt;inputs>&lt;email class=&quot;java.lang.String&quot; />&lt;services class=&quot;java.lang.Integer&quot; />&lt;companyName class=&quot;java.lang.String&quot; />&lt;name class=&quot;java.lang.String&quot; />&lt;userName class=&quot;java.lang.String&quot; />&lt;/inputs>"

    interactive="0" name="Generate Auth Code" outputs="&lt;outputs />"

    variables="&lt;variables>&lt;authCode class=&quot;java.lang.String&quot; />&lt;serviceCode class=&quot;java.lang.String&quot; />&lt;initials class=&quot;java.lang.String&quot; />&lt;servicesText class=&quot;java.lang.String&quot; />&lt;newMSPGroup class=&quot;java.lang.Integer&quot;>0&lt;/newMSPGroup>&lt;oldAuthCode class=&quot;java.lang.Integer&quot;>0&lt;/oldAuthCode>&lt;/variables>" workflowId="0">

    <Start breakpoint="0" commented="0" continueOnFailure="0"

        created="0" description="" displayName="Start" height="36"

        interactive="0" name="Start" originalStyle="" skipAttempt="0"

        style="image;image=/images/jgraphx/house.png"

        uniqueName="Start_1" waitSetting="0" width="61" x="44" y="83">

        <inputs val="&lt;inputs />"/>

        <transition activity="ImpersonateCreator_1" commented="0"

            originalStyle="" points="122.0,99.0" sourceX="74"

            sourceY="101" status="0" style="defaultEdge" targetX="187"

            targetY="97" transitionIndex="0" x="0" y="0"/>

    </Start>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1360013277205"

        description="activity to execute code snippets in the selected language"

        displayName="Parse Initials" height="34" interactive="0"

        maxRestarts="0" name="Script"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Script"

        uniqueName="Script_1" waitSetting="0" width="118" x="333" y="139">

        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;String fullName = xpath:{/workflow/inputs/name};&amp;#xD;&amp;#xA;String[] parts =  fullName.split(&amp;quot;\\s+&amp;quot;);&amp;#xD;&amp;#xA;if (parts.length &amp;gt; 1)&amp;#xD;&amp;#xA;    return parts[0].substring(0,1).toUpperCase() + parts[1].substring(0,1).toUpperCase();&amp;#xD;&amp;#xA;else&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    if (parts[0].length() &amp;gt; 1)&amp;#xD;&amp;#xA;        return parts[0].substring(0,1).toUpperCase() + parts[0].substring(1,2).toUpperCase();&amp;#xD;&amp;#xA;    else&amp;#xD;&amp;#xA;        return parts[0].substring(0,1).toUpperCase() + parts[0].substring(0,1).toUpperCase();&amp;#xD;&amp;#xA; }&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;&quot; />&lt;/inputs>"/>

        <transition activity="AssignValues_3" commented="0"

            originalStyle="" points="388.0,116.0" sourceX="283"

            sourceY="100" status="0" style="defaultEdge" targetX="439"

            targetY="100" transitionIndex="0" x="0" y="0"/>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1360093728750"

        description="Updates process variables and inputs"

        displayName="Set Initials" height="34" interactive="0"

        maxRestarts="0" name="AssignValues"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=AssignValues" uniqueName="AssignValues_3"

        waitSetting="0" width="117" x="331" y="80">

        <inputs val="&lt;inputs />"/>

        <outputs variables="&lt;variables>&lt;initials class=&quot;java.lang.String&quot;>xpath:{/workflow/Script_1/output}&lt;/initials>&lt;/variables>"/>

        <transition activity="Script_3" commented="0" originalStyle=""

            points="478.0,95.0" sourceX="389" sourceY="97" status="0"

            style="defaultEdge" targetX="525" targetY="98"

            transitionIndex="0" x="0" y="0"/>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1360094804147"

        description="activity to execute code snippets in the selected language"

        displayName="Calculate Service Code" height="34" interactive="0"

        maxRestarts="0" name="Script"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Script"

        uniqueName="Script_3" waitSetting="0" width="182" x="507" y="78">

        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;if ((xpath:{workflow/inputs/services}&amp;amp;512) == 512)&amp;#xD;&amp;#xA;    return (&amp;quot;MP&amp;quot;);&amp;#xD;&amp;#xA;else if ((xpath:{workflow/inputs/services}&amp;amp;16) == 16)&amp;#xD;&amp;#xA;    return (&amp;quot;CF&amp;quot;);&amp;#xD;&amp;#xA;else if ((xpath:{workflow/inputs/services}&amp;amp;8) == 8)&amp;#xD;&amp;#xA;    return (&amp;quot;MT&amp;quot;);&amp;#xD;&amp;#xA;else if ((xpath:{workflow/inputs/services}&amp;amp;256) == 256)&amp;#xD;&amp;#xA;    return (&amp;quot;LP&amp;quot;);&amp;#xD;&amp;#xA;else if ((xpath:{workflow/inputs/services}&amp;amp;4) == 4)&amp;#xD;&amp;#xA;    return (&amp;quot;ED&amp;quot;);&amp;#xD;&amp;#xA;else if ((xpath:{workflow/inputs/services}&amp;amp;2048) == 2048)   &amp;#xD;&amp;#xA;    return (&amp;quot;DL&amp;quot;);&amp;#xD;&amp;#xA;else if ((xpath:{workflow/inputs/services}&amp;amp;32) == 32)   &amp;#xD;&amp;#xA;    return (&amp;quot;DL&amp;quot;);&amp;#xD;&amp;#xA;else&amp;#xD;&amp;#xA;    return (&amp;quot;UN&amp;quot;);&quot; />&lt;/inputs>"/>

        <transition activity="Decision_5" commented="0" originalStyle=""

            points="708.0,95.0" sourceX="598" sourceY="95" status="0"

            style="defaultEdge" targetX="747" targetY="103"

            transitionIndex="0" x="0" y="0"/>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1360098103698"

        description="Updates process variables and inputs"

        displayName="Set Service Code" height="34" interactive="0"

        maxRestarts="0" name="AssignValues"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=AssignValues" uniqueName="AssignValues_7"

        waitSetting="0" width="143" x="961" y="78">

        <inputs val="&lt;inputs />"/>

        <outputs variables="&lt;variables>&lt;serviceCode class=&quot;java.lang.String&quot;>xpath:{/workflow/Script_3/output}&lt;/serviceCode>&lt;/variables>"/>

        <transition activity="CommServDBQuery_1" commented="0"

            originalStyle="" points="" sourceX="1032" sourceY="95"

            status="0" style="defaultEdge" targetX="1254" targetY="96"

            transitionIndex="0" x="0" y="0"/>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1360098583119" description="if/else based decision"

        displayName="Invalid Service Code" height="100" interactive="0"

        maxRestarts="0" name="Decision"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_5" waitSetting="0" width="167" x="735" y="46">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/Script_3/output}.equals(&quot;UN&quot;)&lt;/expression>&lt;/inputs>"/>

        <transition activity="AssignValues_7" commented="0"

            displayName="NO" originalStyle="" points="930.0,96.0"

            sourceX="818" sourceY="96" status="0" style="defaultEdge"

            targetX="979" targetY="96" transitionIndex="0" value="false"

            x="0" y="0"/>

        <transition activity="WorkflowEnd_1" commented="0"

            displayName="YES" originalStyle="" points="" sourceX="818"

            sourceY="96" status="0" style="defaultEdge" targetX="816"

            targetY="221" transitionIndex="0" value="true" x="0" y="0"/>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1360098699506" description="Ends the workflow"

        displayName="Failed" height="34" interactive="0" maxRestarts="0"

        name="WorkflowEnd"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=WorkflowEnd"

        uniqueName="WorkflowEnd_1" waitSetting="0" width="119" x="755" y="202">

        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot;>FAILED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot;>Invalid Service combination&lt;/failureMessage>&lt;/inputs>"/>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1360101670468"

        description="executes queries against the commserv database"

        displayName="Create New Auth Code" height="34" interactive="0"

        maxRestarts="0" name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=CommServDBQuery"

        uniqueName="CommServDBQuery_1" waitSetting="0" width="179"

        x="1169" y="78">

        <inputs val="&lt;inputs>&lt;commCell>&lt;/commCell>&lt;query>declare @authCodePattern nvarchar(25)&amp;#xD;&#xd;&#xa;declare @newAuthCode nvarchar(25)&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;set @authCodePattern = ''xpath:{/workflow/variables/initials}'' + ''xpath:{/workflow/variables/serviceCode}''&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;set @newAuthCode = @authCodePattern + (select CAST(CAST(RAND()*100000 AS INT) AS NVARCHAR(25)))&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;select @newAuthCode&amp;#xD;&#xd;&#xa;&lt;/query>&lt;/inputs>"/>

        <transition activity="AssignValues_8" commented="0"

            originalStyle="" points="" sourceX="1258" sourceY="95"

            status="0" style="defaultEdge" targetX="1263" targetY="166"

            transitionIndex="0" x="0" y="0"/>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1360167560868"

        description="Queries the DB for the newly created auth code"

        displayName="Read Auth Code from DB" height="34" interactive="0"

        maxRestarts="0" name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=CommServDBQuery"

        uniqueName="CommServDBQuery_2" waitSetting="0" width="192"

        x="1169" y="237">

        <inputs val="&lt;inputs>&lt;commCell>&lt;/commCell>&lt;query>SELECT count(*) FROM cloudAuthorization WHERE AuthCode=''xpath:{/workflow/variables/authCode}''&lt;/query>&lt;/inputs>"/>

        <transition activity="Decision_6" commented="0" originalStyle=""

            points="" sourceX="1265" sourceY="254" status="0"

            style="defaultEdge" targetX="1267" targetY="312"

            transitionIndex="0" x="0" y="0"/>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1360167638511"

        description="Sets the newly generated auth code as a workflow variable"

        displayName="Set Auth Code" height="34" interactive="0"

        maxRestarts="0" name="AssignValues"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=AssignValues" uniqueName="AssignValues_8"

        waitSetting="0" width="143" x="1190" y="156">

        <inputs val="&lt;inputs />"/>

        <outputs variables="&lt;variables>&lt;serviceCode class=&quot;java.lang.String&quot;>xpath:{/workflow/Script_3/output}&lt;/serviceCode>&lt;authCode class=&quot;java.lang.String&quot;>xpath:{/workflow/CommServDBQuery_1/resultSets[1]/row[1]/col[1]}&lt;/authCode>&lt;/variables>"/>

        <transition activity="CommServDBQuery_2" commented="0"

            originalStyle="" points="" sourceX="1261" sourceY="173"

            status="0" style="defaultEdge" targetX="1271" targetY="251"

            transitionIndex="0" x="0" y="0"/>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1360167690788"

        description="Checks to see if the auth code already exists in the DB"

        displayName="Does Auth Code exist " height="100" interactive="0"

        maxRestarts="0" name="Decision"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_6" waitSetting="0" width="174" x="1179" y="303">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{number(/workflow/CommServDBQuery_2/resultSets[1]/row[1]/col[1])}&amp;gt;0&lt;/expression>&lt;/inputs>"/>

        <transition activity="CommServDBQuery_1" commented="0"

            displayName="YES" originalStyle="" points="1409.0,207.0"

            sourceX="1266" sourceY="353" status="0" style="defaultEdge"

            targetX="1302" targetY="105" transitionIndex="0"

            value="true" x="0" y="0"/>

        <transition activity="CommServDBQuery_3" commented="0"

            displayName="NO" originalStyle="" points="" sourceX="1266"

            sourceY="353" status="0" style="defaultEdge" targetX="1258"

            targetY="456" transitionIndex="0" value="false" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1360338983561"

        description="impersonates the user who created the workflow"

        displayName="ImpersonateCreator" height="34" interactive="0"

        name="ImpersonateCreator"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ImpersonateCreator"

        uniqueName="ImpersonateCreator_1" waitSetting="0" width="164"

        x="135" y="83">

        <inputs val="&lt;inputs />"/>

        <transition activity="CommServDBQuery_7" commented="0"

            originalStyle="" points="" sourceX="220" sourceY="177"

            status="0" style="defaultEdge" targetX="218" targetY="112"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="1"

        created="1360354531406"

        description="creates a super process group"

        displayName="TRY BLOCK" height="945" interactive="0"

        maxRestarts="0" name="ProcessBlock"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ProcessBlock_1" waitSetting="0" width="1863" x="27" y="453">

        <activitySchema>

            <inputs attribute="0" listType="0" name="inputs" required="1"/>

            <outputs attribute="0" listType="0" name="outputs" required="1"/>

        </activitySchema>

        <inputs val="&lt;inputs>&lt;inputs />&lt;/inputs>"/>

        <transition activity="ProcessBlock_2" commented="0"

            displayName="FAIL" originalStyle="" points="1965.0,801.0"

            sourceX="831" sourceY="802" status="2" style="defaultEdge"

            targetX="1795" targetY="597" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <superProcess>

            <Start breakpoint="0" commented="0" continueOnFailure="0"

                created="1360354531406" description=""

                displayName="Start" height="30" interactive="0"

                name="Start" originalStyle="" skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_2" waitSetting="0" width="120"

                x="1418" y="110">

                <inputs val="&lt;inputs />"/>

                <transition activity="Decision_12" commented="0"

                    originalStyle="" points="" sourceX="1487"

                    sourceY="97" status="0" style="defaultEdge"

                    targetX="1501" targetY="232" transitionIndex="0"

                    x="186" y="-1">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1360178561215"

                description="Send the auth code requestor an email with the authorization code."

                displayName="Send email" height="34" interactive="0"

                name="Email"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Email" uniqueName="Email_1"

                waitSetting="0" width="103" x="1022" y="839">

                <inputs val="&lt;inputs>&lt;email>&lt;from>cloudservices@commvault.com&lt;/from>&lt;to>xpath:{/workflow/inputs/email}&lt;/to>&lt;subject>Authorization Code for CommVault Cloud&lt;/subject>&lt;body>&amp;lt;style type=&quot;text/css&quot;&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;!--&amp;#xD;&#xd;&#xa;        hr { height: 1px; color: black }&amp;#xD;&#xd;&#xa;        body { background-image: url(http://cloud.commvault.com:8080/webconsole/images/bgc.png) }&amp;#xD;&#xd;&#xa;        .content2 { width: 800px; padding-bottom: 25px; border-spacing: 0; padding-top: 25px; padding-left: 50px; padding-right: 50px; color: #666666; background-color: WHITE; font-family: Calibri, Tahoma, Arial }&amp;#xD;&#xd;&#xa;        .content1 { border-spacing: 0; padding-top: 20px; width: 800px }&amp;#xD;&#xd;&#xa;      --&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/style&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;#xD;&#xd;&#xa;  &amp;#xD;&#xd;&#xa;  &amp;#xD;&#xd;&#xa;    &amp;lt;div align=&quot;center&quot;&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;table class=&quot;content1&quot;&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;tr&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;td&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;img border=&quot;0&quot; src=&quot;https://cloud.commvault.com:8443/webconsole/images/simpana_home.png&quot; alt=&quot;Simpana Cloud&quot;&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;#xD;&#xd;&#xa;          &amp;lt;/td&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;td&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;#xD;&#xd;&#xa;          &amp;lt;/td&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;/tr&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/table&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;table class=&quot;content2&quot;&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;tr&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;td&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;p&amp;gt;&amp;#xD;&#xd;&#xa;              Good day xpath:{/workflow/inputs/name},&amp;#xD;&#xd;&#xa;            &amp;lt;/p&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;p&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;#xD;&#xd;&#xa;            &amp;lt;/p&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;p&amp;gt;&amp;#xD;&#xd;&#xa;              Thank you for using &amp;lt;font color=&quot;#008ACD&quot;&amp;gt;&amp;lt;span&amp;gt;&amp;lt;a href=&quot;http://cloud.commvault.com:8080/webconsole/cloud/edc/edcservices.jsp&quot;&amp;gt;CommVault &amp;#xD;&#xd;&#xa;              Cloud.&amp;lt;/a&amp;gt;&amp;lt;/span&amp;gt;&amp;lt;/font&amp;gt; The following authorization code has &amp;#xD;&#xd;&#xa;              been created for you:&amp;#xD;&#xd;&#xa;            &amp;lt;/p&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;p&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;b&amp;gt;xpath:{/workflow/variables/authCode}&amp;lt;/b&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;/p&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;p&amp;gt;&amp;#xD;&#xd;&#xa;              All new users registering for a cloud account using this &amp;#xD;&#xd;&#xa;              authorization code will have access to the following cloud &amp;#xD;&#xd;&#xa;              sevices: xpath:{/workflow/variables/servicesText}&amp;#xD;&#xd;&#xa;            &amp;lt;/p&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;p&amp;gt;&amp;#xD;&#xd;&#xa;              Thank you,&amp;lt;br&amp;gt;CommVault Cloud Services&amp;#xD;&#xd;&#xa;            &amp;lt;/p&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;hr&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;br&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;            &amp;lt;div align=&quot;center&quot;&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;font color=&quot;#008ACD&quot;&amp;gt;&amp;lt;span&amp;gt;&amp;lt;a href=&quot;mailto:cloudservices@commvault.com&quot;&amp;gt;Contact &amp;#xD;&#xd;&#xa;              Us&amp;lt;/a&amp;gt;&amp;lt;/span&amp;gt;&amp;lt;/font&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;/div&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;/td&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;/tr&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/table&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/div&amp;gt;&lt;/body>&lt;html>true&lt;/html>&lt;/email>&lt;/inputs>"/>

                <transition activity="GenericResponse_2" commented="0"

                    originalStyle="" points="" sourceX="887"

                    sourceY="835" status="0" style="defaultEdge"

                    targetX="887" targetY="905" transitionIndex="0"

                    x="466" y="268">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1360186228055"

                description="Checks if the bit for Sizing Tools is set (bit 3)"

                displayName="Sizing Tools Bit Set" height="100"

                interactive="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_12"

                waitSetting="0" width="157" x="886" y="184">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>java:{(xpath:{workflow/inputs/services}&amp;amp;4)==4}&lt;/expression>&lt;/inputs>"/>

                <transition activity="AssignValues_13" commented="0"

                    displayName="YES" offsetX="0" offsetY="-2"

                    originalStyle="" points="" sourceX="979"

                    sourceY="233" status="0" style="defaultEdge"

                    targetX="976" targetY="103" transitionIndex="0"

                    value="true" x="233" y="-266"/>

                <transition activity="Decision_13" commented="0"

                    displayName="NO" originalStyle="" points=""

                    sourceX="979" sourceY="233" status="0"

                    style="defaultEdge" targetX="805" targetY="227"

                    transitionIndex="0" value="false" x="233" y="-258"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1360186228076"

                description="Updates process variables and inputs"

                displayName="Sizing Tools Text" height="34"

                interactive="0" name="AssignValues"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=AssignValues"

                uniqueName="AssignValues_13" waitSetting="0" width="142"

                x="890" y="91">

                <inputs val="&lt;inputs />"/>

                <outputs variables="&lt;variables>&lt;servicesText class=&quot;java.lang.String&quot;>java:{xpath:{/workflow/variables/servicesText} + &quot;&amp;lt;br&amp;gt;Data Sizing and Prediction&amp;lt;br&amp;gt;CommServe Database Analysis&quot;}&lt;/servicesText>&lt;/variables>"/>

                <transition activity="Decision_13" commented="0"

                    originalStyle="" points="860.0,204.0" sourceX="989"

                    sourceY="107" status="0" style="defaultEdge"

                    targetX="836" targetY="203" transitionIndex="0"

                    x="233" y="-258"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1360186228090"

                description="Checks if the bit for Survey is set (bit 4)"

                displayName="Survey Bit Set" height="100"

                interactive="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_13"

                waitSetting="0" width="125" x="715" y="185">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>java:{(xpath:{workflow/inputs/services}&amp;amp;8)==8}&lt;/expression>&lt;/inputs>"/>

                <transition activity="AssignValues_14" commented="0"

                    displayName="YES" originalStyle=""

                    points="776.0,160.0" sourceX="713" sourceY="190"

                    status="0" style="defaultEdge" targetX="710"

                    targetY="60" transitionIndex="0" value="true"

                    x="233" y="-258"/>

                <transition activity="Decision_14" commented="0"

                    displayName="NO" originalStyle="" points=""

                    sourceX="777" sourceY="235" status="0"

                    style="defaultEdge" targetX="650" targetY="234"

                    transitionIndex="0" value="false" x="233" y="-258"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1360186228114"

                description="Updates process variables and inputs"

                displayName="Survey Text" height="34" interactive="0"

                name="AssignValues"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=AssignValues"

                uniqueName="AssignValues_14" waitSetting="0" width="117"

                x="711" y="92">

                <inputs val="&lt;inputs />"/>

                <outputs variables="&lt;variables>&lt;servicesText class=&quot;java.lang.String&quot;>java:{xpath:{/workflow/variables/servicesText} + &quot;&amp;lt;br&amp;gt;Metrics Reporting, Survey (coming soon)&quot;}&lt;/servicesText>&lt;/variables>"/>

                <transition activity="Decision_14" commented="0"

                    originalStyle="" points="686.0,193.0" sourceX="769"

                    sourceY="109" status="0" style="defaultEdge"

                    targetX="612" targetY="189" transitionIndex="0"

                    x="233" y="-258"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1360186848415"

                description="Checks if the bit for Config Request is set (bit 5)"

                displayName="Config Request Bit Set" height="100"

                interactive="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_14"

                waitSetting="0" width="177" x="500" y="185">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>java:{(xpath:{workflow/inputs/services}&amp;amp;16)==16}&lt;/expression>&lt;/inputs>"/>

                <transition activity="AssignValues_15" commented="0"

                    displayName="YES" offsetX="0" offsetY="-2"

                    originalStyle="" points="587.0,156.0" sourceX="630"

                    sourceY="234" status="0" style="defaultEdge"

                    targetX="627" targetY="104" transitionIndex="0"

                    value="true" x="233" y="-266"/>

                <transition activity="Decision_15" commented="0"

                    displayName="NO" originalStyle="" points=""

                    sourceX="630" sourceY="234" status="0"

                    style="defaultEdge" targetX="456" targetY="228"

                    transitionIndex="0" value="false" x="233" y="-258"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1360186848435"

                description="Updates process variables and inputs"

                displayName="Config Request Text" height="34"

                interactive="0" name="AssignValues"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=AssignValues"

                uniqueName="AssignValues_15" waitSetting="0" width="162"

                x="501" y="92">

                <inputs val="&lt;inputs />"/>

                <outputs variables="&lt;variables>&lt;servicesText class=&quot;java.lang.String&quot;>java:{xpath:{/workflow/variables/servicesText} + &quot;&amp;lt;br&amp;gt;Config Services (coming soon)&quot;}&lt;/servicesText>&lt;/variables>"/>

                <transition activity="Decision_15" commented="0"

                    originalStyle="" points="451.0,195.0" sourceX="640"

                    sourceY="108" status="0" style="defaultEdge"

                    targetX="487" targetY="204" transitionIndex="0"

                    x="233" y="-258"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1360186848444"

                description="Checks if the bit for Download Center is set (bit 6)"

                displayName="V10 Download Bit Set" height="100"

                interactive="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_15"

                waitSetting="0" width="175" x="299" y="185">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>java:{(xpath:{workflow/inputs/services}&amp;amp;2048)==2048}&lt;/expression>&lt;/inputs>"/>

                <transition activity="AssignValues_16" commented="0"

                    displayName="YES" offsetX="0" offsetY="-3"

                    originalStyle="" points="386.0,156.0" sourceX="364"

                    sourceY="191" status="0" style="defaultEdge"

                    targetX="361" targetY="61" transitionIndex="0"

                    value="true" x="233" y="-257"/>

                <transition activity="Decision_28" commented="0"

                    displayName="NO" offsetX="12" offsetY="-15"

                    originalStyle="" points="" sourceX="371"

                    sourceY="235" status="0" style="defaultEdge"

                    targetX="390" targetY="342" transitionIndex="0"

                    value="false" x="0" y="0"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1360186848468"

                description="Updates process variables and inputs"

                displayName="V10 Download Text" height="34"

                interactive="0" name="AssignValues"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=AssignValues"

                uniqueName="AssignValues_16" waitSetting="0" width="160"

                x="281" y="85">

                <inputs val="&lt;inputs />"/>

                <outputs variables="&lt;variables>&lt;servicesText class=&quot;java.lang.String&quot;>java:{xpath:{/workflow/variables/servicesText} + &quot;&amp;lt;br&amp;gt;V10 Media Kit&quot;}&lt;/servicesText>&lt;/variables>"/>

                <transition activity="Decision_16" commented="0"

                    originalStyle="" points="23.0,245.0" sourceX="374"

                    sourceY="105" status="0" style="defaultEdge"

                    targetX="430" targetY="330" transitionIndex="0"

                    x="233" y="-258"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1360250160364"

                description="Checks if the bit for Laptop Backup is set (bit 9)"

                displayName="Laptop Bit Set" height="100"

                interactive="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_16"

                waitSetting="0" width="177" x="293" y="405">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>java:{(xpath:{workflow/inputs/services}&amp;amp;256)==256}&lt;/expression>&lt;/inputs>"/>

                <transition activity="AssignValues_17" commented="0"

                    displayName="YES" offsetX="0" offsetY="-2"

                    originalStyle="" points="380.0,376.0" sourceX="423"

                    sourceY="454" status="0" style="defaultEdge"

                    targetX="420" targetY="324" transitionIndex="0"

                    value="true" x="26" y="-46"/>

                <transition activity="Decision_17" commented="0"

                    displayName="NO" originalStyle="" points=""

                    sourceX="381" sourceY="455" status="0"

                    style="defaultEdge" targetX="528" targetY="453"

                    transitionIndex="0" value="false" x="233" y="-258"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1360250160390"

                description="Updates process variables and inputs"

                displayName="Laptop Text" height="34" interactive="0"

                name="AssignValues"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=AssignValues"

                uniqueName="AssignValues_17" waitSetting="0" width="162"

                x="303" y="306">

                <inputs val="&lt;inputs />"/>

                <outputs variables="&lt;variables>&lt;servicesText class=&quot;java.lang.String&quot;>java:{xpath:{/workflow/variables/servicesText} + &quot;&amp;lt;br&amp;gt;Laptop Backup Showcase (Edge User Experience)&quot;}&lt;/servicesText>&lt;/variables>"/>

                <transition activity="Decision_17" commented="0"

                    originalStyle="" points="500.0,421.0" sourceX="384"

                    sourceY="323" status="0" style="defaultEdge"

                    targetX="551" targetY="434" transitionIndex="0"

                    x="233" y="-258"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1360250426672"

                description="Checks if the bit for MSP is set (bit 10)"

                displayName="MSP Bit Set" height="100" interactive="0"

                name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_17"

                waitSetting="0" width="177" x="515" y="404">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>java:{(xpath:{workflow/inputs/services}&amp;amp;512)==512}&lt;/expression>&lt;/inputs>"/>

                <transition activity="AssignValues_18" commented="0"

                    displayName="YES" offsetX="0" offsetY="-2"

                    originalStyle="" points="602.0,375.0" sourceX="645"

                    sourceY="453" status="0" style="defaultEdge"

                    targetX="642" targetY="323" transitionIndex="0"

                    value="true" x="248" y="-47"/>

                <transition activity="Decision_25" commented="0"

                    displayName="NO" offsetX="0" offsetY="-8"

                    originalStyle="" points="" sourceX="603"

                    sourceY="454" status="0" style="defaultEdge"

                    targetX="611" targetY="541" transitionIndex="0"

                    value="false" x="186" y="-20">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1360250426695"

                description="Updates process variables and inputs"

                displayName="MSP Text" height="34" interactive="0"

                name="AssignValues"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=AssignValues"

                uniqueName="AssignValues_18" waitSetting="0" width="162"

                x="517" y="317">

                <inputs val="&lt;inputs />"/>

                <outputs variables="&lt;variables>&lt;servicesText class=&quot;java.lang.String&quot;>java:{xpath:{/workflow/variables/servicesText} + &quot;&amp;lt;br&amp;gt;Multi Tenant experience&amp;lt;br&amp;gt;&amp;lt;br&amp;gt;&amp;lt;b&amp;gt;Please note: This authorization code should only be used for registration by employees of the company &amp;lt;i&amp;gt;&quot; + xpath:{/workflow/inputs/companyName} + &quot;&amp;lt;/i&amp;gt;&amp;lt;/b&amp;gt;&quot;}&lt;/servicesText>&lt;/variables>"/>

                <transition activity="Decision_18" commented="0"

                    originalStyle="" points="709.0,329.0" sourceX="601"

                    sourceY="324" status="0" style="defaultEdge"

                    targetX="791" targetY="447" transitionIndex="0"

                    x="233" y="-258"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1360254730227"

                description="if/else based decision"

                displayName="Is Company Name set" height="100"

                interactive="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_18"

                waitSetting="0" width="174" x="739" y="280">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/companyName}!=&quot;&quot;&lt;/expression>&lt;/inputs>"/>

                <transition activity="Script_4" commented="0"

                    displayName="NO" offsetX="0" offsetY="1"

                    originalStyle="" points="" sourceX="830"

                    sourceY="453" status="0" style="defaultEdge"

                    targetX="841" targetY="328" transitionIndex="0"

                    value="false" x="233" y="-265"/>

                <transition activity="Execute_1" commented="0"

                    displayName="YES" originalStyle=""

                    points="822.0,405.0" sourceX="826" sourceY="330"

                    status="0" style="defaultEdge" targetX="986"

                    targetY="333" transitionIndex="0" value="true"

                    x="233" y="-258"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1360254798227"

                description="activity to execute code snippets in the selected language"

                displayName="Raise Error" height="34" interactive="0"

                name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Script" uniqueName="Script_4"

                waitSetting="0" width="104" x="982" y="313">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;workflow.setFailed(&amp;quot;Company name Missing&amp;quot;);&quot; />&lt;/inputs>"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1360255029454"

                description="Check if the user group exists"

                displayName="Check User Group" height="34"

                interactive="0" name="Execute"

                namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                originalStyle="" skipAttempt="0"

                style="label;image=Execute" uniqueName="Execute_1"

                waitSetting="0" width="159" x="752" y="424">

                <inputs val="&lt;inputs>&lt;inputXml class=&quot;java.lang.String&quot;>&amp;lt;App_GetUserGroupPropertiesRequest level=&quot;1&quot;&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;userGroup userGroupName=&quot;xpath:{/workflow/inputs/companyName}&quot; /&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/App_GetUserGroupPropertiesRequest&amp;gt;&lt;/inputXml>&lt;commandArgs class=&quot;java.lang.String&quot; />&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

                <transition activity="Script_5" commented="0"

                    originalStyle="" points="928.0,442.0" sourceX="1051"

                    sourceY="328" status="0" style="defaultEdge"

                    targetX="1203" targetY="329" transitionIndex="0"

                    x="233" y="-258"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1360255977080"

                description="activity to execute code snippets in the selected language"

                displayName="Group Exists" height="34" interactive="0"

                name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Script" uniqueName="Script_5"

                waitSetting="0" width="113" x="952" y="424">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;XML xml = utils.parseXml(xpath:{/workflow/Execute_1/outputXml});&amp;#xD;&amp;#xA;xml.getName().equals(&amp;quot;App_GetUserGroupPropertiesResponse&amp;quot;);&quot; />&lt;/inputs>"/>

                <transition activity="Script_6" commented="0"

                    originalStyle="" points="1089.0,446.0"

                    sourceX="1008" sourceY="441" status="0"

                    style="defaultEdge" targetX="1148" targetY="436"

                    transitionIndex="0" x="233" y="-258"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1360256180508"

                description="activity to execute code snippets in the selected language"

                displayName="Validate" height="34" interactive="0"

                name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Script" uniqueName="Script_6"

                waitSetting="0" width="100" x="1113" y="426">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;boolean groupExists = xpath:{/workflow/Script_5/output};&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if (!groupExists)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;   return true;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;else&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;   return false;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&quot; />&lt;/inputs>"/>

                <transition activity="CommServDBQuery_4" commented="0"

                    displayName="GROUP DOES NOT EXIST" originalStyle=""

                    points="" sourceX="1163" sourceY="443" status="0"

                    style="defaultEdge" targetX="1155" targetY="340"

                    transitionIndex="0" x="233" y="-258">

                    <condition language="1" script="xpath:{/workflow/Script_6/output}==true;"/>

                </transition>

                <transition activity="Execute_3" commented="0"

                    displayName="GROUP EXISTS" offsetX="-5"

                    offsetY="-54" originalStyle="" points="1336.0,478.0"

                    sourceX="1163" sourceY="443" status="0"

                    style="defaultEdge" targetX="1297" targetY="438"

                    transitionIndex="0" x="186" y="-1">

                    <condition language="1" script="xpath:{/workflow/Script_6/output}==false;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1360256326421"

                description="executes queries against the commserv database"

                displayName="Create Client Group" height="34"

                interactive="0" name="CommServDBQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=CommServDBQuery"

                uniqueName="CommServDBQuery_4" waitSetting="0"

                width="162" x="1098" y="313">

                <inputs val="&lt;inputs>&lt;commCell>&lt;/commCell>&lt;query>IF NOT EXISTS(SELECT * FROM [APP_ClientGroup] WHERE name = ''xpath:{/workflow/inputs/companyName}'')&amp;#xD;&#xd;&#xa;    INSERT INTO [CommServ].[dbo].[APP_ClientGroup] ([name],[description],[flag],[status],[userId],[refTime],[modified],[fwPorts],[origCCId],[GUID])&amp;#xD;&#xd;&#xa;    VALUES (''xpath:{/workflow/inputs/companyName}'',''MSP client group'',0,0,xpath:{/workflow/system/executor/userId},dbo.GetUnixTime(GETUTCDATE()),dbo.GetUnixTime(GETUTCDATE()),'''',2,NEWID())&lt;/query>&lt;/inputs>"/>

                <transition activity="AssignValues_19" commented="0"

                    originalStyle="" points="" sourceX="1179"

                    sourceY="330" status="0" style="defaultEdge"

                    targetX="1382" targetY="323" transitionIndex="0"

                    x="233" y="-258"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1360256525317" description=""

                displayName="Create User Group" height="34"

                interactive="0" name="Execute"

                namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                originalStyle="" skipAttempt="0"

                style="label;image=Execute" uniqueName="Execute_2"

                waitSetting="0" width="159" x="1580" y="368">

                <inputs val="&lt;inputs>&lt;inputXml class=&quot;java.lang.String&quot;>&amp;lt;App_CreateUserGroupRequest&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;groups enabled=&quot;true&quot; allCapabilities=&quot;true&quot; allAssociations=&quot;false&quot; usersOperationType=&quot;ADD&quot;&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;userGroupEntity userGroupName=&quot;xpath:{/workflow/inputs/companyName}&quot; /&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;users userName=&quot;xpath:{/workflow/inputs/userName}&quot; description=&quot;MSP user group&quot;&amp;gt;&amp;lt;/users&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;associations clientGroupName=&quot;xpath:{/workflow/inputs/companyName}&quot;&amp;gt;&amp;lt;/associations&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;/groups&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/App_CreateUserGroupRequest&amp;gt;&amp;#xD;&#xd;&#xa;&lt;/inputXml>&lt;commandArgs class=&quot;java.lang.String&quot; />&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

                <transition activity="XPathQuery_1" commented="0"

                    originalStyle="" points="1654.0,418.0"

                    sourceX="1375" sourceY="328" status="0"

                    style="defaultEdge" targetX="1611" targetY="324"

                    transitionIndex="0" x="233" y="-258"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1360256961956"

                description="retrieves a list of values from xml"

                displayName="Get Error Code" height="34" interactive="0"

                name="XPathQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=XPathQuery" uniqueName="XPathQuery_1"

                waitSetting="0" width="128" x="1592" y="443">

                <inputs val="&lt;inputs>&lt;xml class=&quot;java.lang.String&quot;>xpath:{/workflow/Execute_2/outputXml}&lt;/xml>&lt;xpath class=&quot;java.lang.String&quot;>string(/App_CreateUserGroupResponse/response/@errorCode)&lt;/xpath>&lt;/inputs>"/>

                <transition activity="Decision_19" commented="0"

                    originalStyle="" points="1656.0,492.0"

                    sourceX="1571" sourceY="327" status="0"

                    style="defaultEdge" targetX="1585" targetY="392"

                    transitionIndex="0" x="233" y="-258"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1360257172290"

                description="if/else based decision"

                displayName="User Group Creation" height="100"

                interactive="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_19"

                waitSetting="0" width="200" x="1558" y="512">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/XPathQuery_1/result}.get(0).equals(&quot;0&quot;)&lt;/expression>&lt;/inputs>"/>

                <transition activity="Script_8" commented="0"

                    displayName="FAILURE" offsetX="1" offsetY="2"

                    originalStyle="" points="1660.0,619.0"

                    sourceX="1646" sourceY="440" status="0"

                    style="defaultEdge" targetX="1653" targetY="552"

                    transitionIndex="0" value="false" x="186" y="-1"/>

                <transition activity="Execute_3" commented="0"

                    displayName="SUCCESS" offsetX="-42" offsetY="-14"

                    originalStyle="" points="1487.0,570.0"

                    sourceX="1586" sourceY="450" status="0"

                    style="defaultEdge" targetX="1416" targetY="448"

                    transitionIndex="0" value="true" x="186" y="-1"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1360257300912" description=""

                displayName="Add User to Group" height="34"

                interactive="0" name="Execute"

                namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                originalStyle="" skipAttempt="0"

                style="label;image=Execute" uniqueName="Execute_3"

                waitSetting="0" width="159" x="1263" y="559">

                <inputs val="&lt;inputs>&lt;inputXml class=&quot;java.lang.String&quot;>&amp;lt;App_UpdateUserGroupPropertiesRequest&amp;gt;    &amp;#xD;&#xd;&#xa;    &amp;lt;groups usersOperationType=&quot;ADD&quot;&amp;gt;      &amp;#xD;&#xd;&#xa;        &amp;lt;userGroupEntity userGroupName=&quot;xpath:{/workflow/inputs/companyName}&quot; /&amp;gt;      &amp;#xD;&#xd;&#xa;        &amp;lt;users userName=&quot;xpath:{/workflow/inputs/userName}&quot;&amp;gt;&amp;lt;/users&amp;gt;    &amp;#xD;&#xd;&#xa;    &amp;lt;/groups&amp;gt;  &amp;#xD;&#xd;&#xa;&amp;lt;/App_UpdateUserGroupPropertiesRequest&amp;gt;&lt;/inputXml>&lt;commandArgs class=&quot;java.lang.String&quot; />&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

                <transition activity="XPathQuery_2" commented="0"

                    originalStyle="" points="1215.0,580.0"

                    sourceX="1356" sourceY="444" status="0"

                    style="defaultEdge" targetX="1351" targetY="542"

                    transitionIndex="0" x="233" y="-258"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1360257488010"

                description="retrieves a list of values from xml"

                displayName="Get Error Code" height="34" interactive="0"

                name="XPathQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=XPathQuery" uniqueName="XPathQuery_2"

                waitSetting="0" width="128" x="1045" y="567">

                <inputs val="&lt;inputs>&lt;xml class=&quot;java.lang.String&quot;>xpath:{/workflow/Execute_3/outputXml}&lt;/xml>&lt;xpath class=&quot;java.lang.String&quot;>string(/App_UpdateUserGroupPropertiesResponse/response/@errorCode)&lt;/xpath>&lt;/inputs>"/>

                <transition activity="Decision_20" commented="0"

                    originalStyle="" points="1007.0,587.0"

                    sourceX="1079" sourceY="559" status="0"

                    style="defaultEdge" targetX="927" targetY="563"

                    transitionIndex="0" x="233" y="-258"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1360257566780"

                description="if/else based decision"

                displayName="User added to Group" height="100"

                interactive="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_20"

                waitSetting="0" width="200" x="777" y="538">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/XPathQuery_2/result}.get(0).equals(&quot;0&quot;)&lt;/expression>&lt;/inputs>"/>

                <transition activity="Decision_23" commented="0"

                    displayName="SUCCESS" originalStyle=""

                    points="884.0,718.0" sourceX="844" sourceY="564"

                    status="0" style="defaultEdge" targetX="641"

                    targetY="562" transitionIndex="0" value="true"

                    x="233" y="-258"/>

                <transition activity="Script_7" commented="0"

                    displayName="FAILURE" offsetX="44" offsetY="-1"

                    originalStyle="" points="" sourceX="869"

                    sourceY="566" status="0" style="defaultEdge"

                    targetX="873" targetY="646" transitionIndex="0"

                    value="false" x="186" y="-1"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1360257689880"

                description="activity to execute code snippets in the selected language"

                displayName="Raise Error" height="34" interactive="0"

                name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Script" uniqueName="Script_7"

                waitSetting="0" width="104" x="828" y="477">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;workflow.setFailed(&amp;quot;Failed to add user to group&amp;quot;);&quot; />&lt;/inputs>"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1360257872396"

                description="activity to execute code snippets in the selected language"

                displayName="Raise Error" height="34" interactive="0"

                name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Script" uniqueName="Script_8"

                waitSetting="0" width="104" x="1598" y="654">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;workflow.setFailed(&amp;quot;Failed to Create User Group&amp;quot;);&quot; />&lt;/inputs>"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1360355375596" description="Ends the workflow"

                displayName="WorkflowEnd" height="34" interactive="0"

                name="WorkflowEnd"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=WorkflowEnd"

                uniqueName="WorkflowEnd_2" waitSetting="0" width="119"

                x="1405" y="840">

                <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; />&lt;failureMessage class=&quot;java.lang.String&quot; />&lt;/inputs>"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1360358738875"

                description="Updates process variables and inputs"

                displayName="Set New MSP Group Flag" height="34"

                interactive="0" name="AssignValues"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=AssignValues"

                uniqueName="AssignValues_19" waitSetting="0" width="198"

                x="1333" y="313">

                <inputs val="&lt;inputs />"/>

                <outputs variables="&lt;variables>&lt;newMSPGroup class=&quot;java.lang.Integer&quot;>1&lt;/newMSPGroup>&lt;/variables>"/>

                <transition activity="Execute_2" commented="0"

                    originalStyle="" points="1652.0,350.0"

                    sourceX="1432" sourceY="330" status="0"

                    style="defaultEdge" targetX="1642" targetY="376"

                    transitionIndex="0" x="186" y="-1">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1360874393416"

                description="if/else based decision"

                displayName="Old Auth Code?" height="100"

                interactive="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_23"

                waitSetting="0" width="131" x="819" y="808">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/oldAuthCode}==1&lt;/expression>&lt;/inputs>"/>

                <transition activity="Email_1" commented="0"

                    displayName="NO" originalStyle="" points=""

                    sourceX="884" sourceY="858" status="0"

                    style="defaultEdge" targetX="654" targetY="825"

                    transitionIndex="0" value="false" x="466" y="268">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="Email_2" commented="0"

                    displayName="YES" originalStyle=""

                    points="886.0,930.0" sourceX="884" sourceY="858"

                    status="0" style="defaultEdge" targetX="756"

                    targetY="930" transitionIndex="0" value="true"

                    x="466" y="268">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1360871826188"

                description="Send the auth code requestor an email with the authorization code."

                displayName="Send email" height="34" interactive="0"

                name="Email"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Email" uniqueName="Email_2"

                waitSetting="0" width="103" x="1178" y="904">

                <inputs val="&lt;inputs>&lt;email>&lt;from>cloudservices@commvault.com&lt;/from>&lt;to>xpath:{/workflow/inputs/email}&lt;/to>&lt;subject>Authorization Code for CommVault Cloud&lt;/subject>&lt;body>&amp;lt;style type=&quot;text/css&quot;&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;!--&amp;#xD;&#xd;&#xa;        body { background-image: url(http://cloud.commvault.com:8080/webconsole/images/bgc.png) }&amp;#xD;&#xd;&#xa;        hr { height: 1px; color: black }&amp;#xD;&#xd;&#xa;        .content2 { width: 800px; padding-bottom: 25px; border-spacing: 0; padding-top: 25px; padding-left: 50px; padding-right: 50px; color: #666666; background-color: WHITE; font-family: Calibri, Tahoma, Arial }&amp;#xD;&#xd;&#xa;        .content1 { border-spacing: 0; padding-top: 20px; width: 800px }&amp;#xD;&#xd;&#xa;      --&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/style&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;#xD;&#xd;&#xa;  &amp;#xD;&#xd;&#xa;  &amp;#xD;&#xd;&#xa;    &amp;lt;div align=&quot;center&quot;&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;table class=&quot;content1&quot;&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;tr&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;td&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;img border=&quot;0&quot; src=&quot;https://cloud.commvault.com:8443/webconsole/images/simpana_home.png&quot; alt=&quot;Simpana Cloud&quot;&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;#xD;&#xd;&#xa;          &amp;lt;/td&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;td&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;#xD;&#xd;&#xa;          &amp;lt;/td&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;/tr&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/table&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;table class=&quot;content2&quot;&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;tr&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;td&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;p&amp;gt;&amp;#xD;&#xd;&#xa;              Good day xpath:{/workflow/inputs/name},&amp;#xD;&#xd;&#xa;            &amp;lt;/p&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;p&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;#xD;&#xd;&#xa;            &amp;lt;/p&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;p&amp;gt;&amp;#xD;&#xd;&#xa;              Thank you for using &amp;lt;font color=&quot;#008ACD&quot;&amp;gt;&amp;lt;span&amp;gt;&amp;lt;a href=&quot;http://cloud.commvault.com:8080/webconsole/cloud/edc/edcservices.jsp&quot;&amp;gt;CommVault &amp;#xD;&#xd;&#xa;              Cloud.&amp;lt;/a&amp;gt;&amp;lt;/span&amp;gt;&amp;lt;/font&amp;gt; You can use your existing authorization &amp;#xD;&#xd;&#xa;              code:&amp;#xD;&#xd;&#xa;            &amp;lt;/p&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;p&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;b&amp;gt;xpath:{/workflow/variables/authCode}&amp;lt;/b&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;/p&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;p&amp;gt;&amp;#xD;&#xd;&#xa;              All new users registering for a cloud account using this &amp;#xD;&#xd;&#xa;              authorization code will have access to the following cloud &amp;#xD;&#xd;&#xa;              sevices: xpath:{/workflow/variables/servicesText}&amp;#xD;&#xd;&#xa;            &amp;lt;/p&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;p&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;#xD;&#xd;&#xa;            &amp;lt;/p&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;p&amp;gt;&amp;#xD;&#xd;&#xa;              Thank you,&amp;lt;br&amp;gt;CommVault Cloud Services&amp;#xD;&#xd;&#xa;            &amp;lt;/p&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;hr&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;br&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;            &amp;lt;div align=&quot;center&quot;&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;font color=&quot;#008ACD&quot;&amp;gt;&amp;lt;span&amp;gt;&amp;lt;a href=&quot;mailto:cloudservices@commvault.com&quot;&amp;gt;Contact &amp;#xD;&#xd;&#xa;              Us&amp;lt;/a&amp;gt;&amp;lt;/span&amp;gt;&amp;lt;/font&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;/div&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;/td&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;/tr&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/table&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/div&amp;gt;&lt;/body>&lt;html>true&lt;/html>&lt;/email>&lt;/inputs>"/>

                <transition activity="GenericResponse_2" commented="0"

                    originalStyle="" points="" sourceX="721"

                    sourceY="933" status="0" style="defaultEdge"

                    targetX="593" targetY="868" transitionIndex="0"

                    x="466" y="268">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1361998961882"

                description="Checks if the bit for Config Request or Survey is set (bit 4 or 5)"

                displayName="Config or Survey Bit Set" height="100"

                interactive="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_25"

                waitSetting="0" width="189" x="512" y="535">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>java:{(xpath:{workflow/inputs/services}&amp;amp;16)==16||(xpath:{workflow/inputs/services}&amp;amp;8)==8}&lt;/expression>&lt;/inputs>"/>

                <transition activity="Decision_29" commented="0"

                    displayName="NO" offsetX="25" offsetY="-7"

                    originalStyle="" points="608.0,641.0" sourceX="606"

                    sourceY="585" status="0" style="defaultEdge"

                    targetX="837" targetY="688" transitionIndex="0"

                    value="false" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="Decision_26" commented="0"

                    displayName="YES" offsetX="2" offsetY="0"

                    originalStyle="" points="" sourceX="606"

                    sourceY="585" status="0" style="defaultEdge"

                    targetX="587" targetY="712" transitionIndex="0"

                    value="true" x="186" y="-20">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1361999236622"

                description="Adds extra note to the email"

                displayName="Extra Text" height="34" interactive="0"

                name="AssignValues"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=AssignValues"

                uniqueName="AssignValues_22" waitSetting="0" width="162"

                x="529" y="842">

                <inputs val="&lt;inputs />"/>

                <outputs variables="&lt;variables>&lt;servicesText class=&quot;java.lang.String&quot;>java:{xpath:{/workflow/variables/servicesText} + &quot;&amp;lt;br&amp;gt;&amp;lt;br&amp;gt;&amp;lt;b&amp;gt;Please note: This authorization code should only be used for registration by employees of the company &amp;lt;i&amp;gt;&quot; + xpath:{/workflow/inputs/companyName} + &quot;&amp;lt;/i&amp;gt;. If this authorization code has been generated for a partner, please request a separate authorization code for every customer of the partner.&amp;lt;/b&amp;gt;&quot;}&lt;/servicesText>&lt;/variables>"/>

                <transition activity="Decision_23" commented="0"

                    originalStyle="" points="751.0,857.0" sourceX="609"

                    sourceY="864" status="0" style="defaultEdge"

                    targetX="870" targetY="872" transitionIndex="0"

                    x="193" y="136">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1361999573596"

                description="if/else based decision"

                displayName="Is Company Name set" height="100"

                interactive="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_26"

                waitSetting="0" width="174" x="312" y="535">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/companyName}!=&quot;&quot;&lt;/expression>&lt;/inputs>"/>

                <transition activity="AssignValues_22" commented="0"

                    displayName="YES" offsetX="-43" offsetY="-99"

                    originalStyle="" points="398.0,657.0" sourceX="399"

                    sourceY="585" status="0" style="defaultEdge"

                    targetX="550" targetY="709" transitionIndex="0"

                    value="true" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="Script_9" commented="0"

                    displayName="NO" offsetX="16" offsetY="-7"

                    originalStyle="" points="260.0,586.0" sourceX="399"

                    sourceY="585" status="0" style="defaultEdge"

                    targetX="290" targetY="645" transitionIndex="0"

                    value="false" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1361999666579"

                description="activity to execute code snippets in the selected language"

                displayName="Raise Error" height="34" interactive="0"

                name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Script" uniqueName="Script_9"

                waitSetting="0" width="104" x="214" y="635">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;workflow.setFailed(&amp;quot;Company name Missing&amp;quot;);&quot; />&lt;/inputs>"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1362165920545"

                description="Checks if the bit for Download Center is set (bit 6)"

                displayName="Download Bit Set" height="100"

                interactive="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_28"

                waitSetting="0" width="144" x="120" y="186">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>java:{(xpath:{workflow/inputs/services}&amp;amp;32)==32}&lt;/expression>&lt;/inputs>"/>

                <transition activity="Decision_16" commented="0"

                    displayName="NO" offsetX="-6" offsetY="0"

                    originalStyle="" points="191.0,410.0" sourceX="192"

                    sourceY="236" status="0" style="defaultEdge"

                    targetX="314" targetY="459" transitionIndex="0"

                    value="false" x="0" y="110">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="AssignValues_23" commented="0"

                    displayName="YES" offsetX="0" offsetY="-6"

                    originalStyle="" points="" sourceX="192"

                    sourceY="236" status="0" style="defaultEdge"

                    targetX="185" targetY="143" transitionIndex="0"

                    value="true" x="-1" y="-22">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1362166038528"

                description="Updates process variables and inputs"

                displayName="Download Text" height="34" interactive="0"

                name="AssignValues"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=AssignValues"

                uniqueName="AssignValues_23" waitSetting="0" width="160"

                x="117" y="115">

                <inputs val="&lt;inputs />"/>

                <outputs variables="&lt;variables>&lt;servicesText class=&quot;java.lang.String&quot;>java:{xpath:{/workflow/variables/servicesText} + &quot;&amp;lt;br&amp;gt;Download Center&quot;}&lt;/servicesText>&lt;/variables>"/>

                <transition activity="Decision_16" commented="0"

                    originalStyle="" points="79.0,433.0" sourceX="197"

                    sourceY="132" status="0" style="defaultEdge"

                    targetX="343" targetY="453" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1362168762712"

                description="Checks if the bit for Config Request or Survey is set (bit 4 or 5)"

                displayName="My Group Bit Set" height="100"

                interactive="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_29"

                waitSetting="0" width="189" x="516" y="664">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>java:{(xpath:{workflow/inputs/services}&amp;amp;1024)==1024}&lt;/expression>&lt;/inputs>"/>

                <transition activity="AssignValues_24" commented="0"

                    displayName="YES" offsetX="0" offsetY="-4"

                    originalStyle="" points="606.0,773.0" sourceX="610"

                    sourceY="714" status="0" style="defaultEdge"

                    targetX="598" targetY="787" transitionIndex="0"

                    value="true" x="0" y="31">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="Decision_23" commented="0"

                    displayName="NO" originalStyle=""

                    points="794.0,814.0" sourceX="610" sourceY="714"

                    status="0" style="defaultEdge" targetX="875"

                    targetY="821" transitionIndex="0" value="false"

                    x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1362168912244"

                description="Adds extra note to the email"

                displayName="Extra Text" height="34" interactive="0"

                name="AssignValues"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=AssignValues"

                uniqueName="AssignValues_24" waitSetting="0" width="162"

                x="539" y="785">

                <inputs val="&lt;inputs />"/>

                <outputs variables="&lt;variables>&lt;servicesText class=&quot;java.lang.String&quot;>java:{xpath:{/workflow/variables/servicesText} + &quot;&amp;lt;br&amp;gt;&amp;lt;br&amp;gt;&amp;lt;b&amp;gt;Please note: This authorization code should only be used for cloud account registration by users requiring access to &amp;lt;i&amp;gt;&quot; + xpath:{/workflow/inputs/companyName} + &quot;&amp;lt;/i&amp;gt; packages.&amp;lt;/b&amp;gt;&quot;}&lt;/servicesText>&lt;/variables>"/>

                <transition activity="Decision_23" commented="0"

                    originalStyle="" points="774.0,834.0" sourceX="620"

                    sourceY="802" status="0" style="defaultEdge"

                    targetX="852" targetY="830" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1365523462945"

                description="returns a message to the caller of the workflow"

                displayName="Respond to Web Console" height="34"

                interactive="0" name="GenericResponse"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=GenericResponse"

                uniqueName="GenericResponse_2" waitSetting="0"

                width="193" x="1162" y="839">

                <inputs val="&lt;inputs>&lt;errorCode class=&quot;java.lang.Integer&quot;>0&lt;/errorCode>&lt;errorMessage class=&quot;java.lang.String&quot;>Failed to create an authcode. Please contact cloudservices@commvault.com&lt;/errorMessage>&lt;/inputs>"/>

                <transition activity="WorkflowEnd_2" commented="0"

                    originalStyle="" points="" sourceX="1258"

                    sourceY="856" status="0" style="defaultEdge"

                    targetX="1442" targetY="851" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

        </superProcess>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1360357098186"

        description="creates a super process group"

        displayName="CATCH BLOCK" height="547" interactive="0"

        maxRestarts="0" name="ProcessBlock"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ProcessBlock_2" waitSetting="0" width="402" x="2028" y="670">

        <activitySchema>

            <inputs attribute="0" listType="0" name="inputs" required="1"/>

            <outputs attribute="0" listType="0" name="outputs" required="1"/>

        </activitySchema>

        <inputs val="&lt;inputs>&lt;inputs />&lt;/inputs>"/>

        <superProcess>

            <Start breakpoint="0" commented="0" continueOnFailure="0"

                created="1360357098186" description=""

                displayName="Start" height="30" interactive="0"

                name="Start" originalStyle="" skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_3" waitSetting="0" width="120" x="18" y="30">

                <inputs val="&lt;inputs />"/>

                <transition activity="Decision_21" commented="0"

                    originalStyle="" points="" sourceX="78" sourceY="45"

                    status="0" style="defaultEdge" targetX="82"

                    targetY="117" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1360595291235"

                description="if/else based decision"

                displayName="New MSP Group" height="100" interactive="0"

                name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_21"

                waitSetting="0" width="137" x="11" y="92">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/newMSPGroup}==1&lt;/expression>&lt;/inputs>"/>

                <transition activity="CommServDBQuery_5" commented="0"

                    displayName="YES" originalStyle="" points=""

                    sourceX="79" sourceY="142" status="0"

                    style="defaultEdge" targetX="222" targetY="142"

                    transitionIndex="0" value="true" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="CommServDBQuery_6" commented="0"

                    displayName="NO" originalStyle="" points=""

                    sourceX="79" sourceY="142" status="0"

                    style="defaultEdge" targetX="75" targetY="359"

                    transitionIndex="0" value="false" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1360595957897"

                description="executes queries against the commserv database"

                displayName="Remove Client Group" height="34"

                interactive="0" name="CommServDBQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=CommServDBQuery"

                uniqueName="CommServDBQuery_5" waitSetting="0"

                width="169" x="206" y="125">

                <inputs val="&lt;inputs>&lt;commCell>&lt;/commCell>&lt;query>DECLARE @clientGroupId INT&amp;#xD;&#xd;&#xa;SET @clientGroupId = (SELECT id FROM APP_ClientGroup WHERE name = ''xpath:{/workflow/inputs/companyName}'')&amp;#xD;&#xd;&#xa;IF NOT EXISTS (SELECT * FROM APP_ClientGroupAssoc WHERE clientGroupId = @clientGroupId)&amp;#xD;&#xd;&#xa;      DELETE APP_ClientGroup WHERE id = @clientGroupId&lt;/query>&lt;/inputs>"/>

                <transition activity="Execute_4" commented="0"

                    originalStyle="" points="" sourceX="290"

                    sourceY="142" status="0" style="defaultEdge"

                    targetX="287" targetY="205" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1360596139959" description=""

                displayName="Remove User Group" height="34"

                interactive="0" name="Execute"

                namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                originalStyle="" skipAttempt="0"

                style="label;image=Execute" uniqueName="Execute_4"

                waitSetting="0" width="162" x="208" y="197">

                <inputs val="&lt;inputs>&lt;inputXml class=&quot;java.lang.String&quot;>&amp;lt;App_DeleteUserGroupRequest&amp;gt; &#x9;&amp;#xD;&#xd;&#xa;    &amp;lt;groups&amp;gt; &#x9;&#x9;&amp;#xD;&#xd;&#xa;        &amp;lt;userGroupEntity userGroupName=&quot;xpath:{/workflow/inputs/companyName}&quot; /&amp;gt; &#x9;&amp;#xD;&#xd;&#xa;    &amp;lt;/groups&amp;gt; &amp;#xD;&#xd;&#xa;&amp;lt;/App_DeleteUserGroupRequest&amp;gt;&lt;/inputXml>&lt;commandArgs class=&quot;java.lang.String&quot; />&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

                <transition activity="CommServDBQuery_6" commented="0"

                    originalStyle="" points="291.0,257.0" sourceX="289"

                    sourceY="214" status="0" style="defaultEdge"

                    targetX="172" targetY="259" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1360596708446" description="Ends the workflow"

                displayName="Fail Workflow" height="34" interactive="0"

                name="WorkflowEnd"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=WorkflowEnd"

                uniqueName="WorkflowEnd_3" waitSetting="0" width="123"

                x="49" y="473">

                <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot;>FAILED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot;>Failed to Generate Authorization Code for xpath:{/workflow/inputs/name}&lt;/failureMessage>&lt;/inputs>"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1360597135199"

                description="Writes the auth code into the DB"

                displayName="Delete Auth Code from DB" height="34"

                interactive="0" maxRestarts="0" name="CommServDBQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=CommServDBQuery"

                uniqueName="CommServDBQuery_6" waitSetting="0"

                width="200" x="7" y="272">

                <inputs val="&lt;inputs>&lt;commCell>&lt;/commCell>&lt;query>delete from cloudAuthorization&amp;#xD;&#xd;&#xa;where AuthCode = ''xpath:{/workflow/variables/authCode}''&lt;/query>&lt;/inputs>"/>

                <transition activity="GenericResponse_1" commented="0"

                    originalStyle="" points="" sourceX="104"

                    sourceY="259" status="0" style="defaultEdge"

                    targetX="107" targetY="350" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1365517457836"

                description="returns a message to the caller of the workflow"

                displayName="Respond to Web Console" height="34"

                interactive="0" name="GenericResponse"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=GenericResponse"

                uniqueName="GenericResponse_1" waitSetting="0"

                width="193" x="10" y="374">

                <inputs val="&lt;inputs>&lt;errorCode class=&quot;java.lang.Integer&quot;>1&lt;/errorCode>&lt;errorMessage class=&quot;java.lang.String&quot;>Failed to create an authcode. Please contact cloudservices@commvault.com&lt;/errorMessage>&lt;/inputs>"/>

                <transition activity="WorkflowEnd_3" commented="0"

                    originalStyle="" points="" sourceX="106"

                    sourceY="391" status="0" style="defaultEdge"

                    targetX="99" targetY="479" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

        </superProcess>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1360871303137"

        description="Does auth code exist for the same email and permissions"

        displayName="Check for auth code in DB" height="34"

        interactive="0" maxRestarts="0" name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=CommServDBQuery"

        uniqueName="CommServDBQuery_7" waitSetting="0" width="200"

        x="122" y="163">

        <inputs val="&lt;inputs>&lt;commCell>&lt;/commCell>&lt;query>SELECT count(*) FROM cloudAuthorization &amp;#xD;&#xd;&#xa;WHERE CVReferral=''xpath:{/workflow/inputs/email}'' &amp;#xD;&#xd;&#xa;and flags=xpath:{/workflow/inputs/services}&amp;#xD;&#xd;&#xa;and flags&amp;amp;512=0&amp;#xD;&#xd;&#xa;and flags&amp;amp;8=0&amp;#xD;&#xd;&#xa;and flags&amp;amp;16=0&amp;#xD;&#xd;&#xa;and flags&amp;amp;1024=0&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;SELECT AuthCode FROM cloudAuthorization &amp;#xD;&#xd;&#xa;WHERE CVReferral=''xpath:{/workflow/inputs/email}'' &amp;#xD;&#xd;&#xa;and flags=xpath:{/workflow/inputs/services}&amp;#xD;&#xd;&#xa;and flags&amp;amp;512=0&amp;#xD;&#xd;&#xa;and flags&amp;amp;8=0&amp;#xD;&#xd;&#xa;and flags&amp;amp;16=0&lt;/query>&lt;/inputs>"/>

        <transition activity="Decision_22" commented="0"

            originalStyle="" points="" sourceX="222" sourceY="180"

            status="0" style="defaultEdge" targetX="211" targetY="230"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1360871596781"

        description="If there is already an auth code with the same email and services, use it instead of creating a new one."

        displayName="Does Auth Code exist " height="100" interactive="0"

        maxRestarts="0" name="Decision"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_22" waitSetting="0" width="174" x="128" y="228">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/CommServDBQuery_7/resultSets[1]/row[1]/col[1]}==0&lt;/expression>&lt;/inputs>"/>

        <transition activity="CommServDBQuery_8" commented="0"

            displayName="NO" offsetX="13" offsetY="-18" originalStyle=""

            points="332.0,277.0" sourceX="215" sourceY="278" status="0"

            style="defaultEdge" targetX="410" targetY="161"

            transitionIndex="0" value="true" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="AssignValues_20" commented="0"

            displayName="YES" originalStyle="" points="" sourceX="215"

            sourceY="278" status="0" style="defaultEdge" targetX="205"

            targetY="369" transitionIndex="0" value="false" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1360872982829"

        description="Set the Auth Code variable with the existing auth code"

        displayName="Set Auth Code" height="34" interactive="0"

        name="AssignValues"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=AssignValues" uniqueName="AssignValues_20"

        waitSetting="0" width="123" x="152" y="367">

        <inputs val="&lt;inputs />"/>

        <outputs variables="&lt;variables>&lt;authCode class=&quot;java.lang.String&quot;>xpath:{/workflow/CommServDBQuery_7/resultSets[2]/row[1]/col[1]}&lt;/authCode>&lt;oldAuthCode class=&quot;java.lang.Integer&quot;>1&lt;/oldAuthCode>&lt;/variables>"/>

        <transition activity="ProcessBlock_1" commented="0"

            originalStyle="" points="" sourceX="210" sourceY="384"

            status="0" style="defaultEdge" targetX="380" targetY="384"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1360167825907"

        description="Writes the auth code into the DB"

        displayName="Write Auth Code in DB" height="34" interactive="0"

        name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=CommServDBQuery"

        uniqueName="CommServDBQuery_3" waitSetting="0" width="177"

        x="934" y="333">

        <inputs val="&lt;inputs>&lt;commCell>&lt;/commCell>&lt;query>Insert into cloudAuthorization&amp;#xD;&#xd;&#xa;Values(''xpath:{/workflow/variables/authCode}'', ''xpath:{/workflow/inputs/companyName}'', xpath:{/workflow/inputs/services}, ''xpath:{/workflow/inputs/email}'', 1, ''Auth Code created on '' + convert(varchar(15),getdate(),101))&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&lt;/query>&lt;/inputs>"/>

        <transition activity="ProcessBlock_1" commented="0"

            originalStyle="" points="" sourceX="1022" sourceY="350"

            status="0" style="defaultEdge" targetX="987" targetY="467"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1360876933350"

        description="Does auth code exist for the same email and permissions"

        displayName="Check for MSP auth code in DB" height="34"

        interactive="0" maxRestarts="0" name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=CommServDBQuery"

        uniqueName="CommServDBQuery_8" waitSetting="0" width="200"

        x="362" y="257">

        <inputs val="&lt;inputs>&lt;commCell>&lt;/commCell>&lt;query>SELECT count(*) FROM cloudAuthorization &amp;#xD;&#xd;&#xa;WHERE CVReferral=''xpath:{/workflow/inputs/email}'' &amp;#xD;&#xd;&#xa;and flags=xpath:{/workflow/inputs/services}&amp;#xD;&#xd;&#xa;and CompanyName = ''xpath:{/workflow/inputs/companyName}''&amp;#xD;&#xd;&#xa;and (flags&amp;amp;512=512&amp;#xD;&#xd;&#xa;or flags&amp;amp;8=8&amp;#xD;&#xd;&#xa;or flags&amp;amp;16=16&amp;#xD;&#xd;&#xa;or flags&amp;amp;1024=1024)&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;SELECT AuthCode FROM cloudAuthorization &amp;#xD;&#xd;&#xa;WHERE CVReferral=''xpath:{/workflow/inputs/email}'' &amp;#xD;&#xd;&#xa;and flags=xpath:{/workflow/inputs/services}&amp;#xD;&#xd;&#xa;and CompanyName = ''xpath:{/workflow/inputs/companyName}''&amp;#xD;&#xd;&#xa;and (flags&amp;amp;512=512&amp;#xD;&#xd;&#xa;or flags&amp;amp;8=8&amp;#xD;&#xd;&#xa;or flags&amp;amp;16=16&amp;#xD;&#xd;&#xa;or flags&amp;amp;1024=1024)&lt;/query>&lt;/inputs>"/>

        <transition activity="Decision_24" commented="0"

            originalStyle="" points="585.0,276.0" sourceX="462"

            sourceY="274" status="0" style="defaultEdge" targetX="623"

            targetY="270" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1360877109681"

        description="If there is already an auth code with the same email and services for MSP users, use it instead of creating a new one."

        displayName="Does Auth Code exist " height="100" interactive="0"

        maxRestarts="0" name="Decision"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_24" waitSetting="0" width="174" x="602" y="225">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/CommServDBQuery_8/resultSets[1]/row[1]/col[1]}.equals(0)&lt;/expression>&lt;/inputs>"/>

        <transition activity="Script_1" commented="0" displayName="NO"

            offsetX="95" offsetY="28" originalStyle=""

            points="689.0,195.0" sourceX="689" sourceY="275" status="0"

            style="defaultEdge" targetX="426" targetY="163"

            transitionIndex="0" value="true" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="AssignValues_21" commented="0"

            displayName="YES" originalStyle="" points="" sourceX="689"

            sourceY="275" status="0" style="defaultEdge" targetX="694"

            targetY="379" transitionIndex="0" value="false" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1360877200740"

        description="Set the Auth Code variable with the existing auth code"

        displayName="Set Auth Code" height="34" interactive="0"

        name="AssignValues"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=AssignValues" uniqueName="AssignValues_21"

        waitSetting="0" width="123" x="631" y="363">

        <inputs val="&lt;inputs />"/>

        <outputs variables="&lt;variables>&lt;authCode class=&quot;java.lang.String&quot;>xpath:{/workflow/CommServDBQuery_8/resultSets[2]/row[1]/col[1]}&lt;/authCode>&lt;oldAuthCode class=&quot;java.lang.Integer&quot;>1&lt;/oldAuthCode>&lt;/variables>"/>

        <transition activity="ProcessBlock_1" commented="0"

            originalStyle="" points="" sourceX="692" sourceY="380"

            status="0" style="defaultEdge" targetX="677" targetY="470"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <schema>

        <inputs attribute="0" className="" listType="0" name="inputs"

            required="1" type="">

            <children attribute="0" className="java.lang.String"

                controlType="0" displayName="Email" hidden="0"

                inputType="java.lang.String" listType="0" name="email"

                required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.Integer"

                controlType="0" displayName="Services" hidden="0"

                inputType="java.lang.Integer" listType="0"

                name="services" required="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" displayName="Company Name" hidden="0"

                inputType="java.lang.String" listType="0"

                name="companyName" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" displayName="Full Name" hidden="0"

                inputType="java.lang.String" listType="0" name="name"

                required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" displayName="User Name" hidden="0"

                inputType="java.lang.String" listType="0"

                name="userName" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

        </inputs>

        <variables attribute="0" className="" listType="0"

            name="variables" required="1" type="">

            <children attribute="0" className="java.lang.String"

                hidden="0" inputType="java.lang.String" listType="0"

                name="authCode" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                hidden="0" inputType="java.lang.String" listType="0"

                name="serviceCode" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                hidden="0" inputType="java.lang.String" listType="0"

                name="initials" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                hidden="0" inputType="java.lang.String" listType="0"

                name="servicesText" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.Integer"

                hidden="0" inputType="java.lang.Integer" listType="0"

                name="newMSPGroup" required="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.Integer"

                hidden="0" inputType="java.lang.Integer" listType="0"

                name="oldAuthCode" required="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

        </variables>

        <outputs className="" name="outputs" type=""/>

    </schema>

</workflow>'

IF not exists (select * from WF_Definition where Name = @name)

BEGIN
	INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision)


	VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision)

	SET @workflowId = @@IDENTITY
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


	VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

	SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = ISNULL(revision, '') From WF_Definition WHERE Name = @name

	IF (@currentFlags & 4 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0) AND (@currentRevision <> @revision)

	BEGIN

		SET @version = @version + 1

		UPDATE WF_Definition

		SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision

		WHERE Name = @name

		IF (@flags & 8 > 0 OR @flags & 16 > 0)

		BEGIN

			UPDATE WF_Definition

			SET flags = @flags

			WHERE Name = @name

		END
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


		VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

	END

END


