

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_FormatString.script] ---------- 


SET QUOTED_IDENTIFIER OFF

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_FormatString.script] ---------- 

SET QUOTED_IDENTIFIER ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 2015  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/WFD_FormatString.script,v $ $Id: WFD_FormatString.script,v 1.1.2.7 2020/10/22 14:45:52 spakhare Exp $";

-- TABLENAME WF_Definition

GO ---Remove it in upgrade scripts

DECLARE @tblRetCode integer

-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER ON

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @guid nvarchar(256)

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.1.2.7 $'

SET @name = 'Format String'

SET @description = 'Workflow to format given input string'

SET @version = 1

SET @flags = 30

SET @guid = '01cd315a-e38b-4096-a904-ddc480b37f1d'

SET @definition = '<workflow apiMode="1" config="&lt;configuration /&gt;" description="Workflow to format given input string" executeOnWeb="0" inputs="&lt;inputs&gt;&lt;inputString class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/inputs&gt;" interactive="1" isHtmlDescription="0" manualPercentageComplete="0" name="Format String" outputs="&lt;outputs&gt;&lt;output class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/variables/output}&lt;/output&gt;&lt;/outputs&gt;" revision="$Revision: 1.1.2.7 $" tags="" uniqueGuid="01cd315a-e38b-4096-a904-ddc480b37f1d" variables="&lt;variables&gt;&lt;output class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/variables&gt;" webHidden="1" workflowId="0">

  <schema>

    <inputs attribute="0" className="" name="inputs" type="">

      <children attribute="0" className="java.lang.String" controlHidden="0" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="inputString" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string" />

    </inputs>

    <variables attribute="0" className="" name="variables" type="">

      <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" hidden="0" inputType="java.lang.String" listType="0" name="output" type="{http://www.w3.org/2001/XMLSchema}string" />

    </variables>

    <outputs className="" name="outputs" type="">

      <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="output" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

    </outputs>

    <config className="" name="configuration" type="" />

  </schema>

  <formProperties css="" javaScript="" />

  <Start commented="0" continueOnFailure="0" created="0" description="" displayName="Start" height="36" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="0" style="image;image=/images/jgraphx/house.png" uniqueName="Start_1" waitSetting="0" width="58" x="44" y="52">

    <inputs val="&lt;inputs /&gt;" />

    <transition activity="ImpersonateCreator_1" commented="0" originalStyle="" points="" sourceX="72" sourceY="59" status="0" style="straight" targetX="205" targetY="67" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Start>

  <Activity commented="0" continueOnFailure="0" created="1496814651672" description="activity to execute code snippets in the selected language" displayName="Format String" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.ScriptActivity" uniqueName="Script_1" waitSetting="0" width="135" x="669" y="311">

    <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;String inputString = xpath:{/workflow/inputs/inputString} + &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;String formattedString = utils.decryptString(inputString);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;formattedString = Base64.getEncoder().encodeToString(formattedString.getBytes(&amp;quot;utf-8&amp;quot;));&amp;#xD;&amp;#xA;logger.info(&amp;quot;Output: &amp;quot; + formattedString);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;output&amp;quot;, formattedString);&quot; /&gt;&lt;/inputs&gt;" />

    <transition activity="WorkflowEnd_1" commented="0" originalStyle="" points="" sourceX="736" sourceY="336" status="0" style="defaultEdge" targetX="727" targetY="237" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1496816894934" description="Ends the workflow" displayName="WorkflowEnd" height="34" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.EndActivity" uniqueName="WorkflowEnd_1" waitSetting="0" width="106" x="673" y="169">

    <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot; /&gt;&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/inputs&gt;" />

    <outputs outputs="&lt;outputs&gt;&lt;output class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/variables/output}&lt;/output&gt;&lt;/outputs&gt;" />

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1496826454170" description="impersonates the user who created the workflow" displayName="ImpersonateCreator" height="34" interactive="0" jobMode="0" name="ImpersonateCreator" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.ImpersonateCreator" uniqueName="ImpersonateCreator_1" waitSetting="0" width="145" x="193" y="54">

    <inputs val="&lt;inputs /&gt;" />

    <transition activity="CommServDBQuery_1" commented="0" originalStyle="" points="" sourceX="265" sourceY="71" status="0" style="defaultEdge" targetX="466" targetY="124" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1497936164396" description="executes queries against a commcell database" displayName="Validate user" height="34" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_1" waitSetting="0" width="143" x="421" y="54">

    <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;USE [CommServ]&amp;#xD;&#xD;&#xA;DECLARE @user_id int&amp;#xD;&#xD;&#xA;DECLARE&#x9;@return_value int&amp;#xD;&#xD;&#xA;DECLARE @is_allowed int = 0&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;EXEC&#x9;@return_value = [dbo].[sec_isUserAdmin]&amp;#xD;&#xD;&#xA;&#x9;&#x9;xpath:{/workflow/system/executor/userId},&amp;#xD;&#xD;&#xA;&#x9;&#x9;@is_allowed OUTPUT&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;IF @is_allowed &amp;lt;&amp;gt; 1 AND @return_value = 0&amp;#xD;&#xD;&#xA;BEGIN&amp;#xD;&#xD;&#xA;    EXEC @return_value = [dbo].[sec_checkPermissionOnEntity]&amp;#xD;&#xD;&#xA;&#x9;&#x9;@userId = xpath:{/workflow/system/executor/userId},&amp;#xD;&#xD;&#xA;&#x9;&#x9;@permissionIdList = ''112,113'',&amp;#xD;&#xD;&#xA;&#x9;&#x9;@isAllowed = @is_allowed OUTPUT,&amp;#xD;&#xD;&#xA;&#x9;&#x9;@entityType1 = 83,&amp;#xD;&#xD;&#xA;&#x9;&#x9;@entityId1 = xpath:{/workflow/system/workflow/workflowId},&amp;#xD;&#xD;&#xA;        @AndOperation = 1&amp;#xD;&#xD;&#xA;END&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;SELECT @is_allowed AS ''Is Allowed'', @return_value AS ''Return Value''&amp;#xD;&#xD;&#xA;&lt;/query&gt;&lt;/inputs&gt;" />

    <transition activity="Decision_2" commented="0" originalStyle="" points="" sourceX="487" sourceY="119" status="0" style="defaultEdge" targetX="497" targetY="198" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1497937865108" description="if/else based decision" displayName="Is Admin" height="100" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1" uniqueName="Decision_2" waitSetting="0" width="100" x="448" y="136">

    <onEnter language="1" script="logger.info(&quot;Admin User: &quot; + xpath:{/workflow/CommServDBQuery_1/resultSets/row/col[@name=''Is Allowed'']});" />

    <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;if (xpath:{/workflow/CommServDBQuery_1/resultSets/row/col[@name=''Return Value'']} == 1) {&amp;#xD;&#xD;&#xA;    logger.info(&quot;Failed to execute script&quot;);&amp;#xD;&#xD;&#xA;    workflow.setVariable(&quot;output&quot;, &quot;&quot; + -1);&amp;#xD;&#xD;&#xA;    return false;&amp;#xD;&#xD;&#xA;}&amp;#xD;&#xD;&#xA;else if (xpath:{/workflow/CommServDBQuery_1/resultSets/row/col[@name=''Is Allowed'']} == 1) {&amp;#xD;&#xD;&#xA;    logger.info(&quot;Is a Admin User&quot;);&amp;#xD;&#xD;&#xA;    return true;&amp;#xD;&#xD;&#xA;}&amp;#xD;&#xD;&#xA;else {&amp;#xD;&#xD;&#xA;    logger.info(&quot;Is not an Admin user&quot;);&amp;#xD;&#xD;&#xA;    workflow.setVariable(&quot;output&quot;, &quot;&quot; + 1);&amp;#xD;&#xD;&#xA;    return false;&amp;#xD;&#xD;&#xA;}&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

    <transition activity="Decision_3" commented="0" displayName="Yes" offsetX="4" offsetY="1" originalStyle="" sourceX="496" sourceY="231" status="0" style="defaultEdge" targetX="687" targetY="304" transitionIndex="0" value="true" x="0" y="0">

      <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

    <transition activity="WorkflowEnd_1" commented="0" displayName="No" originalStyle="" points="" sourceX="496" sourceY="231" status="0" style="straight" targetX="715" targetY="208" transitionIndex="0" value="false" x="0" y="0">

      <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1603115063402" description="if/else based decision" displayName="Is v5 password" height="100" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1" uniqueName="Decision_3" waitSetting="0" width="116" x="442" y="333">

    <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/inputs/inputString}.startsWith(&quot;5&quot;)&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

    <transition activity="Script_1" commented="0" displayName="No" originalStyle="" sourceX="500" sourceY="383" status="0" style="defaultEdge" targetX="669" targetY="327" transitionIndex="0" value="false" x="0" y="0">

      <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

    <transition activity="CommServDBQuery_2" commented="0" displayName="Yes" originalStyle="" status="0" style="defaultEdge" transitionIndex="0" value="true" x="0" y="0">

      <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1603115201715" description="executes queries against a commcell database" displayName="Convert v5 to v3" height="34" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_2" waitSetting="0" width="143" x="445" y="470">

    <onExit language="4" script="workflow.setInput(&quot;inputString&quot;, xpath:{/workflow/CommServDBQuery_2/resultSets/row/col});" />

    <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;use CommServ&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;DECLARE @v3Password NVARCHAR(MAX) = dbo.pswConvertV5ToV3(''xpath:{/workflow/inputs/inputString}'');&amp;#xD;&#xD;&#xA;SELECT @v3Password&lt;/query&gt;&lt;/inputs&gt;" />

    <transition activity="Script_1" commented="0" originalStyle="" points="712.0,415.0" sourceX="516" sourceY="487" status="0" style="defaultEdge" targetX="719" targetY="343" transitionIndex="0" x="0" y="0">

      <condition language="4" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

</workflow>'

IF not exists (select * from WF_Definition where Name = @name)

BEGIN
	INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision, uniqueGuid)


	VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision, @guid)

	SET @workflowId = @@IDENTITY
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


	VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

	SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = revision From WF_Definition WHERE Name = @name

	-- IF (@currentFlags & 4 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0) AND (@currentRevision <> @revision)

	BEGIN

		SET @version = @version + 1

		UPDATE WF_Definition

		SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision, uniqueGuid = @guid

		WHERE Name = @name

		IF (@flags & 8 > 0 OR @flags & 16 > 0)

		BEGIN

			UPDATE WF_Definition

			SET flags = @flags

			WHERE Name = @name

		END
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


		VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

	END

END

