

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_FirewallrulesforServiceCommcell.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER ON

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.1.2.4 $'

SET @name = 'Firewall rules for Service Commcell'

SET @description = '<html><p>     Workflow to configure firewall rules for service commcell    </p></html>'

SET @version = 1

SET @flags = 22

SET @definition = '<workflow apiMode="0" config="&lt;configuration />"

    description="&lt;html>&lt;p>     Workflow to configure firewall rules for service commcell    &lt;/p>&lt;/html>"

    executeOnWeb="0"

    inputs="&lt;inputs>&lt;Commcell class=&quot;commvault.msgs.CvEntities.CommCellEntity&quot; _list_=&quot;false&quot;>&lt;commCellName />&lt;commCellId />&lt;/Commcell>&lt;ChildWebserver class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;CustomReportsEnginePort class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;WorkflowEnginePort class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;MasterWebconsole class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;OperationType class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>ADD&lt;/OperationType>&lt;/inputs>"

    interactive="1" isHtmlDescription="1" manualPercentageComplete="0"

    name="Firewall rules for Service Commcell" outputs="&lt;outputs />"

    revision="$Revision: 1.1.2.4 $" tags=""

    uniqueGuid="a9065407-383d-416e-a732-8212719f993b"

    variables="&lt;variables>&lt;Commcelldict class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;FirewallRule class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;FailureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/variables>"

    webHidden="0" workflowId="0">

    <schema>

        <outputs className="" name="outputs" type=""/>

        <variables attribute="0" className="" name="variables" type="">

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="Commcelldict" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" hidden="0"

                inputType="java.lang.String" listType="0"

                name="FirewallRule" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" hidden="0"

                inputType="java.lang.String" listType="0"

                name="FailureMessage" type="{http://www.w3.org/2001/XMLSchema}string"/>

        </variables>

        <inputs attribute="0" className="" name="inputs" type="">

            <children attribute="0"

                className="commvault.msgs.CvEntities.CommCellEntity"

                controlHidden="0" controlType="2" defaultValue=""

                displayName="" documentation="" hidden="0"

                inputType="commvault.msgs.CvEntities.CommCellEntity"

                listType="0" maximumValue="" minimumValue=""

                name="Commcell" readOnly="0" required="1" searchable="0" type="{commvault.msgs.CvEntities}CommCellEntity">

                <children attribute="0" className="java.lang.String"

                    defaultValue="" inputType="java.lang.String"

                    listType="0" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children attribute="0" className="java.lang.Integer"

                    defaultValue="" inputType="java.lang.Integer"

                    listType="0" name="commCellId" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            </children>

            <children attribute="0" className="java.lang.String"

                controlHidden="0" controlType="0" defaultValue=""

                displayName="" documentation="" hidden="0"

                inputType="java.lang.String" listType="0"

                maximumValue="" minimumValue="" name="ChildWebserver"

                readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.Integer"

                controlHidden="0" controlType="0" defaultValue=""

                displayName="" documentation="" hidden="0"

                inputType="java.lang.Integer" listType="0"

                maximumValue="" minimumValue=""

                name="CustomReportsEnginePort" readOnly="0" required="0"

                searchable="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.Integer"

                controlHidden="0" controlType="0" defaultValue=""

                displayName="" documentation="" hidden="0"

                inputType="java.lang.Integer" listType="0"

                maximumValue="" minimumValue=""

                name="WorkflowEnginePort" readOnly="0" required="0"

                searchable="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.String"

                controlHidden="0" controlType="0" defaultValue=""

                displayName="" documentation="" hidden="0"

                inputType="java.lang.String" listType="0"

                maximumValue="" minimumValue="" name="MasterWebconsole"

                readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlHidden="0" controlType="2" defaultValue=""

                displayName="" documentation="" hidden="0"

                inputType="java.lang.String" listType="0"

                maximumValue="" minimumValue="" name="OperationType"

                readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string">

                <options val="ADD"/>

                <options val="DELETE"/>

            </children>

        </inputs>

        <config className="" name="configuration" type=""/>

    </schema>

    <Start commented="0" continueOnFailure="0" created="0"

        description="" displayName="Start" height="36" interactive="0"

        jobMode="0" name="Start" originalStyle="" skipAttempt="0"

        style="image;image=/images/jgraphx/house.png"

        uniqueName="Start_1" waitSetting="0" width="55" x="19" y="90">

        <onExit language="1" script="logger.info(&quot;Selected registered Commcell is : &quot;+xpath:{/workflow/inputs/Commcell/commCellName});&#xd;&#xa;Map dict = new HashMap();&#xd;&#xa;//Mapping the Child Commcell, Child webserver client, CREPort,WFEnginePort&#xd;&#xa;Map childdict = new HashMap();&#xd;&#xa;childdict.put(&quot;WebServer&quot;,xpath:{/workflow/inputs/ChildWebserver});&#xd;&#xa;childdict.put(&quot;CREPort&quot;,xpath:{/workflow/inputs/CustomReportsEnginePort});&#xd;&#xa;childdict.put(&quot;WFEnginePort&quot;,xpath:{/workflow/inputs/WorkflowEnginePort});&#xd;&#xa;dict.put(xpath:{/workflow/inputs/Commcell/commCellName},childdict);&#xd;&#xa;workflow.setVariable(&quot;Commcelldict&quot;,dict);&#xd;&#xa;"/>

        <inputs val="&lt;inputs />"/>

        <transition activity="Script_6" commented="0" originalStyle=""

            points="" sourceX="46" sourceY="108" status="0"

            style="defaultEdge" targetX="256" targetY="229"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Start>

    <Activity commented="0" continueOnFailure="0"

        created="1581594062786"

        description="executes queries against a commcell database"

        displayName="Master WC - Port,HostName" height="26"

        interactive="0" jobMode="0" name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.CommServDBQuery"

        uniqueName="CommServDBQuery_3" waitSetting="0" width="189"

        x="133" y="166">

        <onExit language="1" script="//logger.info(&quot;TunnelConnection Port : &quot;+xpath:{/workflow/CommServDBQuery_3/resultSets[1]/row/col[2]});&#xd;&#xa;logger.info(&quot;NetHostname of the Master WebConsole Client [&quot;+xpath:{/workflow/inputs/MasterWebconsole}+&quot;] is &quot;+xpath:{/workflow/CommServDBQuery_3/resultSets[1]/row/col});"/>

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>--Get Tunnel Port, NetHostname of Master Webconsole client&amp;#xD;&#xd;&#xa;--DECLARE @clientId INT;&amp;#xD;&#xd;&#xa;--DECLARE @nethostname nvarchar(max);&amp;#xD;&#xd;&#xa;select net_hostname from APP_Client where name=''xpath:{/workflow/inputs/MasterWebconsole}''&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;--Exec appgetfirewalloptions @clientId,0&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;--select @nethostname&lt;/query>&lt;/inputs>"/>

        <transition activity="Script_1" commented="0" originalStyle=""

            points="221.33333333333334,212.0" sourceX="227"

            sourceY="179" status="0" style="defaultEdge" targetX="225"

            targetY="244" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="1"

        created="1581687967944"

        description="Execute a command on a remote machine"

        displayName="Master ContentStore Path" height="25"

        interactive="0" jobMode="0" maxRestarts="0"

        name="ExecuteCommand"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.ExecuteCommand"

        uniqueName="ExecuteCommand_3" waitSetting="0" width="177"

        x="537" y="298">

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/MasterWebconsole}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>for /f &quot;tokens=3,*&quot; %a in (''REG QUERY &quot;HKEY_LOCAL_MACHINE\SOFTWARE\CommVault Systems\Galaxy\xpath:{/workflow/CommServDBQuery_6/resultSets/row/col}\Base&quot; /v dBASEHOME'') do @echo %a %b&lt;/command>&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="Script_5" commented="0" originalStyle=""

            points="" sourceX="878" sourceY="379" status="0"

            style="defaultEdge;dashed=1" targetX="876" targetY="434"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="xpath:{/workflow/ExecuteCommand_3/exitCode}==0 &amp;&amp; xpath:{/workflow/ExecuteCommand_3/errorCode}==0;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1581688017482"

        description="executes queries against a commcell database"

        displayName="Master Client Instance" height="24" interactive="0"

        jobMode="0" name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.CommServDBQuery"

        uniqueName="CommServDBQuery_6" waitSetting="0" width="157"

        x="549" y="242">

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>--Instance Name&amp;#xD;&#xd;&#xa;select CP.attrVal from APP_ClientProp CP with(nolock) inner join APP_Client C with(nolock) on C.id=CP.componentNameId where C.name=''xpath:{/workflow/inputs/MasterWebconsole}'' and CP.attrName=''Galaxy Instance name''&lt;/query>&lt;/inputs>"/>

        <transition activity="ExecuteCommand_3" commented="0"

            originalStyle="" points="" sourceX="876" sourceY="329"

            status="0" style="defaultEdge" targetX="874" targetY="387"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="1"

        created="1581688133130"

        description="Execute a script on a remote machine"

        displayName="Update FwConfigLocal.txt" height="25"

        interactive="0" jobMode="0" maxRestarts="0" name="ExecuteScript"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.ExecuteScript"

        uniqueName="ExecuteScript_2" waitSetting="0" width="177" x="781" y="362">

        <onExit language="1" script="logger.info(&quot;Response on executing powershell command for updating FwConfigLocal file&quot;);&#xd;&#xa;logger.info(&quot;Exit Code : &quot;+xpath:{/workflow/ExecuteScript_2/exitCode});&#xd;&#xa;logger.info(&quot;Error Code : &quot;+xpath:{/workflow/ExecuteScript_2/errorCode});&#xd;&#xa;logger.info(&quot;Command Output : &quot;+xpath:{/workflow/ExecuteScript_2/commandOutput});"/>

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/MasterWebconsole}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;scriptType class=&quot;commvault.msgs.App.ScriptType&quot; _list_=&quot;false&quot;>PowerShell&lt;/scriptType>&lt;script class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>$modified=&quot;&quot;&amp;#xD;&#xd;&#xa;$match=0&amp;#xD;&#xd;&#xa;$first_line = &quot;0&quot;&amp;#xD;&#xd;&#xa;$test_string = &quot;[outgoing]&quot;&amp;#xD;&#xd;&#xa;$Path = &quot;xpath:{/workflow/Script_5/output}&quot;&amp;#xD;&#xd;&#xa;$NewPath = &quot;xpath:{/workflow/Script_5/output}.tmp&quot;&amp;#xD;&#xd;&#xa;$rule = &quot;xpath:{/workflow/variables/FirewallRule}&quot;&amp;#xD;&#xd;&#xa;$operation = &quot;xpath:{/workflow/inputs/OperationType}&quot;&amp;#xD;&#xd;&#xa;if(Test-Path $Path)&amp;#xD;&#xd;&#xa;{&amp;#xD;&#xd;&#xa;$firewalls = Get-content -path $Path&amp;#xD;&#xd;&#xa;Copy-Item $Path -Destination $NewPath&amp;#xD;&#xd;&#xa;write-host &quot;Original Firewall : $firewalls&quot;&amp;#xD;&#xd;&#xa;foreach($firewall in $firewalls)&amp;#xD;&#xd;&#xa;{&amp;#xD;&#xd;&#xa;if($firewall -eq &quot;&quot; -or $firewall -eq $null)&amp;#xD;&#xd;&#xa;{&amp;#xD;&#xd;&#xa;$modified += &quot;`r`n&quot; + $firewall&amp;#xD;&#xd;&#xa;continue&amp;#xD;&#xd;&#xa;}&amp;#xD;&#xd;&#xa;if($firewall -eq $test_string)&amp;#xD;&#xd;&#xa;{&amp;#xD;&#xd;&#xa;&#x9;if($operation -eq &quot;ADD&quot;)&amp;#xD;&#xd;&#xa;&#x9;{&amp;#xD;&#xd;&#xa;&#x9;&#x9;$firewall = $firewall + &quot;`r`n&quot; + $rule&amp;#xD;&#xd;&#xa;&#x9;}&amp;#xD;&#xd;&#xa;&#x9;else&amp;#xD;&#xd;&#xa;&#x9;{&amp;#xD;&#xd;&#xa;&#x9;&#x9;$match = 1&amp;#xD;&#xd;&#xa;&#x9;}&amp;#xD;&#xd;&#xa;}&amp;#xD;&#xd;&#xa;if($match -eq 1 -and $firewall -match $rule)&amp;#xD;&#xd;&#xa;{&amp;#xD;&#xd;&#xa;continue&amp;#xD;&#xd;&#xa;}&amp;#xD;&#xd;&#xa;if($first_line -ne &quot;0&quot;)&amp;#xD;&#xd;&#xa;{&amp;#xD;&#xd;&#xa;$modified += &quot;`r`n&quot; + $firewall&amp;#xD;&#xd;&#xa;}&amp;#xD;&#xd;&#xa;else&amp;#xD;&#xd;&#xa;{&amp;#xD;&#xd;&#xa;$modified = $firewall&amp;#xD;&#xd;&#xa;$first_line = &quot;1&quot;&amp;#xD;&#xd;&#xa;}&amp;#xD;&#xd;&#xa;}&amp;#xD;&#xd;&#xa;$modified | out-file -encoding ASCII -FilePath $Path&amp;#xD;&#xd;&#xa;write-host &quot;Updated Firewall File content&quot;&amp;#xD;&#xd;&#xa;Get-content -Path $Path&amp;#xD;&#xd;&#xa;}&amp;#xD;&#xd;&#xa;&lt;/script>&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="WorkflowEnd_1" commented="0"

            originalStyle="" points="" sourceX="1076" sourceY="433"

            status="0" style="defaultEdge" targetX="1067" targetY="386"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1581688196666"

        description="activity to execute code snippets in the selected language"

        displayName="FilePath" height="26" interactive="0" jobMode="0"

        name="Script" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.ScriptActivity"

        uniqueName="Script_5" waitSetting="0" width="100" x="578" y="362">

        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;//Full Path of File FwConfigLocal in Master Commcell selected webconsole&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;String base_path = xpath:{/workflow/ExecuteCommand_3/commandOutput}.replaceAll(&amp;quot;\\n&amp;quot;,&amp;quot;&amp;quot;);&amp;#xD;&amp;#xA;String temp = base_path.trim() + &amp;quot;\\FwConfigLocal.txt&amp;quot;;&amp;#xD;&amp;#xA;return temp;&quot; />&lt;/inputs>"/>

        <transition activity="ExecuteScript_2" commented="0"

            originalStyle="" points="" sourceX="884" sourceY="434"

            status="0" style="defaultEdge" targetX="1090" targetY="373"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1581688343267" description="Ends the workflow"

        displayName="WorkflowEnd" height="22" interactive="0"

        jobMode="0" name="WorkflowEnd"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.EndActivity"

        uniqueName="WorkflowEnd_1" waitSetting="0" width="106" x="815" y="299">

        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;>COMPLETED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1584430035661"

        description="activity to execute code snippets in the selected language"

        displayName="Script" height="34" interactive="0" jobMode="0"

        name="Script" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.ScriptActivity"

        uniqueName="Script_6" waitSetting="0" width="68" x="194" y="90">

        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;import java.util.*;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;Map test = xpath:{/workflow/variables/Commcelldict}; //If only Master Commcell provided as input, then workflow execution need to be end.&amp;#xD;&amp;#xA;if(test.isEmpty())&amp;#xD;&amp;#xA;    return true;&amp;#xD;&amp;#xA;else&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;FailureMessage&amp;quot;,&amp;quot;Child Commcell need to be provided for configuring firewall rules&amp;quot;);&amp;#xD;&amp;#xA;    return false;&amp;#xD;&amp;#xA;}&quot; />&lt;/inputs>"/>

        <transition activity="WorkflowEnd_2" commented="0"

            originalStyle=""

            points="106.66666666666667,149.33333333333334" sourceX="275"

            sourceY="238" status="0" style="defaultEdge" targetX="163"

            targetY="244" transitionIndex="0" x="0" y="0">

            <condition language="1" script="xpath:{/workflow/Script_6/output};"/>

        </transition>

        <transition activity="CommServDBQuery_3" commented="0"

            originalStyle="" points="" sourceX="275" sourceY="238"

            status="0" style="defaultEdge" targetX="446" targetY="144"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="!xpath:{/workflow/Script_6/output};"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1584430731759" description="Ends the workflow"

        displayName="END" height="28" interactive="0" jobMode="0"

        name="WorkflowEnd"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.EndActivity"

        uniqueName="WorkflowEnd_2" waitSetting="0" width="67" x="25" y="173">

        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;>FAILED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/FailureMessage}&lt;/failureMessage>&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1581664240101"

        description="activity to execute code snippets in the selected language"

        displayName="WebServer Client" height="26" interactive="0"

        jobMode="0" name="Script"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.ScriptActivity"

        uniqueName="Script_1" waitSetting="0" width="129" x="153" y="234">

        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;//Get Details provided for this iteration Commcell&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;Map tempdict = xpath:{/workflow/variables/Commcelldict};&amp;#xD;&amp;#xA;Map iterdict = new HashMap();&amp;#xD;&amp;#xA;iterdict = tempdict.get(xpath:{/workflow/inputs/Commcell/commCellName});&amp;#xD;&amp;#xA;return iterdict.get(&amp;quot;WebServer&amp;quot;);&quot; />&lt;/inputs>"/>

        <transition activity="CommServDBQuery_5" commented="0"

            originalStyle="" points="" sourceX="217" sourceY="247"

            status="0" style="defaultEdge" targetX="218" targetY="309"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1581684950555"

        description="executes queries against a commcell database"

        displayName="Client Instance" height="24" interactive="0"

        jobMode="0" name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.CommServDBQuery"

        uniqueName="CommServDBQuery_5" waitSetting="0" width="118"

        x="160" y="298">

        <inputs val="&lt;inputs>&lt;commCell>xpath:{/workflow/inputs/Commcell/commCellName}&lt;/commCell>&lt;query>--Instance Name &amp;#xD;&#xd;&#xa;select CP.attrVal from APP_ClientProp CP with(nolock) inner join APP_Client C with(nolock) on C.id=CP.componentNameId where C.name=''xpath:{/workflow/Script_1/output}'' and CP.attrName=''Galaxy Instance name''&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&lt;/query>&lt;/inputs>"/>

        <transition activity="TransferToken_1" commented="0"

            originalStyle="" points="" sourceX="219" sourceY="310"

            status="0" style="defaultEdge" targetX="228" targetY="384"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1581664178569"

        description="transfers your logged in session to a registered commcell"

        displayName="TransferToken" height="23" interactive="0"

        jobMode="0" name="TransferToken"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.ImpersonateCommCell"

        uniqueName="TransferToken_1" waitSetting="0" width="114" x="159" y="365">

        <inputs val="&lt;inputs>&lt;commCell class=&quot;commvault.msgs.CvEntities.CommCellEntity&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/Commcell}&lt;/commCell>&lt;/inputs>"/>

        <transition activity="ExecuteCommand_2" commented="0"

            originalStyle="" points="" sourceX="216" sourceY="376"

            status="0" style="defaultEdge" targetX="330" targetY="378"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="1"

        created="1556540269200"

        description="Execute a command on a remote machine"

        displayName="ContentStore Path" height="25" interactive="0"

        jobMode="0" maxRestarts="0" name="ExecuteCommand"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.ExecuteCommand"

        uniqueName="ExecuteCommand_2" waitSetting="0" width="134"

        x="339" y="364">

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>xpath:{/workflow/Script_1/output}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>for /f &quot;tokens=3,*&quot; %a in (''REG QUERY &quot;HKEY_LOCAL_MACHINE\SOFTWARE\CommVault Systems\Galaxy\xpath:{/workflow/CommServDBQuery_5/resultSets/row/col}\Base&quot; /v dBASEHOME'') do @echo %a %b&lt;/command>&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="Script_2" commented="0" originalStyle=""

            points="" sourceX="368" sourceY="380" status="0"

            style="defaultEdge" targetX="372" targetY="297"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="xpath:{/workflow/ExecuteCommand_2/exitCode}==0 &amp;&amp; xpath:{/workflow/ExecuteCommand_2/errorCode}==0;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1581685453921"

        description="activity to execute code snippets in the selected language"

        displayName="FilePath" height="26" interactive="0" jobMode="0"

        name="Script" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.ScriptActivity"

        uniqueName="Script_2" waitSetting="0" width="100" x="364" y="295">

        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;//Full Path of File FwConfigLocal in Child Commcell WebServer&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;String base_path = xpath:{/workflow/ExecuteCommand_2/commandOutput}.replaceAll(&amp;quot;\\n&amp;quot;,&amp;quot;&amp;quot;);&amp;#xD;&amp;#xA;String temp = base_path.trim() + &amp;quot;\\FwConfigLocal.txt&amp;quot;;&amp;#xD;&amp;#xA;return temp;&quot; />&lt;/inputs>"/>

        <transition activity="Script_3" commented="0" originalStyle=""

            points="" sourceX="368" sourceY="306" status="0"

            style="defaultEdge" targetX="368" targetY="253"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1581685666006"

        description="activity to execute code snippets in the selected language"

        displayName="Firewall Rule" height="25" interactive="0"

        jobMode="0" name="Script"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.ScriptActivity"

        uniqueName="Script_3" waitSetting="0" width="102" x="365" y="237">

        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;//ChildWebServer MasterWebconsole type=persistent proto=httpsa cvfwd=MasterWebConsoleNethostname:TunnelConnectionPort&amp;#xD;&amp;#xA;//Setting 8403 as default Tunnel Connection port&amp;#xD;&amp;#xA;String outgoing_rule = &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;if(xpath:{/workflow/inputs/OperationType}.equals(&amp;quot;ADD&amp;quot;))&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    outgoing_rule = xpath:{/workflow/Script_1/output} + &amp;quot; &amp;quot; + xpath:{/workflow/inputs/MasterWebconsole} + &amp;quot; type=persistent proto=httpsa cvfwd=&amp;quot;+ xpath:{/workflow/CommServDBQuery_3/resultSets[1]/row/col} + &amp;quot;:8403&amp;quot;;&amp;#xD;&amp;#xA;    outgoing_rule += &amp;quot;`r`n&amp;quot; + xpath:{/workflow/Script_1/output} + &amp;quot; &amp;quot; + xpath:{/workflow/system/commCellName} + &amp;quot; proxy=&amp;quot; + xpath:{/workflow/inputs/MasterWebconsole};&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;else&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    outgoing_rule = xpath:{/workflow/Script_1/output} + &amp;quot; &amp;quot; + xpath:{/workflow/inputs/MasterWebconsole} + &amp;quot; type=persistent proto=httpsa cvfwd=&amp;quot;;&amp;#xD;&amp;#xA;    String outgoing_2 = xpath:{/workflow/Script_1/output} + &amp;quot; &amp;quot; + xpath:{/workflow/system/commCellName} + &amp;quot; proxy=&amp;quot; + xpath:{/workflow/inputs/MasterWebconsole};&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;FirewallRule&amp;quot;, outgoing_2);&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;return outgoing_rule;&quot; />&lt;/inputs>"/>

        <transition activity="ExecuteScript_1" commented="0"

            originalStyle="" points="" sourceX="416" sourceY="250"

            status="0" style="defaultEdge" targetX="418" targetY="181"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="1"

        created="1556794715865"

        description="Execute a script on a remote machine"

        displayName="Update FwConfigLocal.txt" height="25"

        interactive="0" jobMode="0" maxRestarts="0" name="ExecuteScript"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.ExecuteScript"

        uniqueName="ExecuteScript_1" waitSetting="0" width="177" x="339" y="165">

        <onExit language="1" script="logger.info(&quot;Response on executing powershell command for updating FwConfigLocal file&quot;);&#xd;&#xa;logger.info(&quot;Exit Code : &quot;+xpath:{/workflow/ExecuteScript_1/exitCode});&#xd;&#xa;logger.info(&quot;Error Code : &quot;+xpath:{/workflow/ExecuteScript_1/errorCode});&#xd;&#xa;logger.info(&quot;Command Output : &quot;+xpath:{/workflow/ExecuteScript_1/commandOutput});&#xd;&#xa;&#xd;&#xa;"/>

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>xpath:{/workflow/Script_1/output}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;scriptType class=&quot;commvault.msgs.App.ScriptType&quot; _list_=&quot;false&quot;>PowerShell&lt;/scriptType>&lt;script class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>$modified=&quot;&quot;&amp;#xD;&#xd;&#xa;$match=0&amp;#xD;&#xd;&#xa;$match_1=0&amp;#xD;&#xd;&#xa;$first_line = &quot;0&quot;&amp;#xD;&#xd;&#xa;$outgoing_section = &quot;[outgoing]&quot;&amp;#xD;&#xd;&#xa;$incoming_section = &quot;[incoming]&quot;&amp;#xD;&#xd;&#xa;$Path = &quot;xpath:{/workflow/Script_2/output}&quot;&amp;#xD;&#xd;&#xa;$NewPath = &quot;xpath:{/workflow/Script_2/output}.tmp&quot;&amp;#xD;&#xd;&#xa;$outgoing_rule = &quot;xpath:{/workflow/Script_3/output}&quot;&amp;#xD;&#xd;&#xa;$outgoing_rule_2 = &quot;xpath:{/workflow/variables/FirewallRule}&quot;&amp;#xD;&#xd;&#xa;$incoming_rule = &quot;allowed_tppms=81,80&quot;&amp;#xD;&#xd;&#xa;$operation = &quot;xpath:{/workflow/inputs/OperationType}&quot;&amp;#xD;&#xd;&#xa;if(Test-Path $Path)&amp;#xD;&#xd;&#xa;{&amp;#xD;&#xd;&#xa;$firewalls = Get-content -path $Path&amp;#xD;&#xd;&#xa;Copy-Item $Path -Destination $NewPath&amp;#xD;&#xd;&#xa;write-host &quot;Original Firewall : $firewalls&quot;&amp;#xD;&#xd;&#xa;foreach($firewall in $firewalls)&amp;#xD;&#xd;&#xa;{&amp;#xD;&#xd;&#xa;if($firewall -eq &quot;&quot; -or $firewall -eq $null)&amp;#xD;&#xd;&#xa;{&amp;#xD;&#xd;&#xa;$modified += &quot;`r`n&quot; + $firewall&amp;#xD;&#xd;&#xa;continue&amp;#xD;&#xd;&#xa;}&amp;#xD;&#xd;&#xa;if($firewall -eq $outgoing_section)&amp;#xD;&#xd;&#xa;{&amp;#xD;&#xd;&#xa;&#x9;if($operation -eq &quot;ADD&quot;)&amp;#xD;&#xd;&#xa;&#x9;{&amp;#xD;&#xd;&#xa;&#x9;&#x9;$firewall = $firewall + &quot;`r`n&quot; + $outgoing_rule&amp;#xD;&#xd;&#xa;&#x9;}&amp;#xD;&#xd;&#xa;&#x9;else&amp;#xD;&#xd;&#xa;&#x9;{&amp;#xD;&#xd;&#xa;&#x9;&#x9;$match = 1&amp;#xD;&#xd;&#xa;&#x9;}&amp;#xD;&#xd;&#xa;}&amp;#xD;&#xd;&#xa;if($firewall -eq $incoming_section)&amp;#xD;&#xd;&#xa;{&amp;#xD;&#xd;&#xa;&#x9;if($operation -eq &quot;ADD&quot;)&amp;#xD;&#xd;&#xa;&#x9;{&amp;#xD;&#xd;&#xa;&#x9;&#x9;$firewall = $firewall + &quot;`r`n&quot; + $incoming_rule&amp;#xD;&#xd;&#xa;&#x9;}&amp;#xD;&#xd;&#xa;&#x9;else&amp;#xD;&#xd;&#xa;&#x9;{&amp;#xD;&#xd;&#xa;&#x9;&#x9;$match_1 = 1&amp;#xD;&#xd;&#xa;&#x9;}&amp;#xD;&#xd;&#xa;}&amp;#xD;&#xd;&#xa;if($match -eq 1 -and $firewall -match $outgoing_rule)&amp;#xD;&#xd;&#xa;{&amp;#xD;&#xd;&#xa;&#x9;continue&amp;#xD;&#xd;&#xa;}&amp;#xD;&#xd;&#xa;if($match -eq 1 -and $firewall -match $outgoing_rule_2)&amp;#xD;&#xd;&#xa;{&amp;#xD;&#xd;&#xa;&#x9;continue&amp;#xD;&#xd;&#xa;}&amp;#xD;&#xd;&#xa;if($match_1 -eq 1 -and $firewall -match $incoming_rule)&amp;#xD;&#xd;&#xa;{&amp;#xD;&#xd;&#xa;&#x9;continue&amp;#xD;&#xd;&#xa;}&amp;#xD;&#xd;&#xa;if($first_line -ne &quot;0&quot;)&amp;#xD;&#xd;&#xa;{&amp;#xD;&#xd;&#xa;$modified += &quot;`r`n&quot; + $firewall&amp;#xD;&#xd;&#xa;}&amp;#xD;&#xd;&#xa;else&amp;#xD;&#xd;&#xa;{&amp;#xD;&#xd;&#xa;$modified = $firewall&amp;#xD;&#xd;&#xa;$first_line = &quot;1&quot;&amp;#xD;&#xd;&#xa;}&amp;#xD;&#xd;&#xa;}&amp;#xD;&#xd;&#xa;$modified | out-file -encoding ASCII -FilePath $Path&amp;#xD;&#xd;&#xa;write-host &quot;Updated Firewall File content&quot;&amp;#xD;&#xd;&#xa;Get-content -Path $Path&amp;#xD;&#xd;&#xa;}&amp;#xD;&#xd;&#xa;&lt;/script>&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="Script_4" commented="0" originalStyle=""

            points="" sourceX="427" sourceY="177" status="0"

            style="defaultEdge" targetX="424" targetY="102"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1581686420009"

        description="activity to execute code snippets in the selected language"

        displayName="Script" height="21" interactive="0" jobMode="0"

        name="Script" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.ScriptActivity"

        uniqueName="Script_4" waitSetting="0" width="74" x="378" y="95">

        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;// Processing Firewall Rule for Master Webconsole client&amp;#xD;&amp;#xA;String rule = xpath:{/workflow/variables/FirewallRule};&amp;#xD;&amp;#xA;Map tempdict = xpath:{/workflow/variables/Commcelldict};&amp;#xD;&amp;#xA;Map iterdict = new HashMap();&amp;#xD;&amp;#xA;iterdict = tempdict.get(xpath:{/workflow/inputs/Commcell/commCellName});&amp;#xD;&amp;#xA;//type=passive tppm=any:9000:81, tppm=any:9001:80&amp;#xD;&amp;#xA;if(xpath:{/workflow/inputs/OperationType}.equals(&amp;quot;ADD&amp;quot;))&amp;#xD;&amp;#xA;    rule += &amp;quot;\n&amp;quot; + xpath:{/workflow/inputs/MasterWebconsole} + &amp;quot; &amp;quot; + xpath:{/workflow/Script_1/output} + &amp;quot; type=passive tppm=any:&amp;quot; + iterdict.get(&amp;quot;CREPort&amp;quot;) + &amp;quot;:81, tppm=any:&amp;quot; + iterdict.get(&amp;quot;WFEnginePort&amp;quot;) + &amp;quot;:80&amp;quot;;&amp;#xD;&amp;#xA;else&amp;#xD;&amp;#xA;    rule = xpath:{/workflow/inputs/MasterWebconsole} + &amp;quot; &amp;quot; + xpath:{/workflow/Script_1/output} + &amp;quot; type=passive tppm=any:&amp;quot;;&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;FirewallRule&amp;quot;,rule);&quot; />&lt;/inputs>"/>

        <transition activity="TransferToken_2" commented="0"

            originalStyle="" points="" sourceX="415" sourceY="105"

            status="0" style="defaultEdge" targetX="557" targetY="109"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1581686056198"

        description="transfers your logged in session to a registered commcell"

        displayName="TransferToken to Master" height="25"

        interactive="0" jobMode="0" name="TransferToken"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.ImpersonateCommCell"

        uniqueName="TransferToken_2" waitSetting="0" width="171" x="541" y="94">

        <inputs val="&lt;inputs>&lt;commCell class=&quot;commvault.msgs.CvEntities.CommCellEntity&quot; _list_=&quot;false&quot;>xpath:{/workflow/system/commCellName}&lt;/commCell>&lt;/inputs>"/>

        <transition activity="CommServDBQuery_7" commented="0"

            originalStyle="" points="" sourceX="627" sourceY="107"

            status="0" style="defaultEdge" targetX="634" targetY="182"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1588600542403"

        description="executes queries against a commcell database"

        displayName="update client prop" height="24" interactive="0"

        jobMode="0" name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.CommServDBQuery"

        uniqueName="CommServDBQuery_7" waitSetting="0" width="143"

        x="559" y="166">

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>DECLARE @clientId INT;&amp;#xD;&#xd;&#xa;set @clientId = (select id from APP_Client where name=''xpath:{/workflow/inputs/Commcell/commCellName}'')&amp;#xD;&#xd;&#xa;EXEC DBO.AppInsertClientProp @clientId, 0, 0,  ''ServiceCommcell TppmWebServerport'',7,xpath:{/workflow/inputs/CustomReportsEnginePort}&lt;/query>&lt;/inputs>"/>

        <transition activity="CommServDBQuery_6" commented="0"

            originalStyle="" points="" sourceX="631" sourceY="178"

            status="0" style="defaultEdge" targetX="629" targetY="253"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <formProperties css="" formVersion="0" javaScript="" pageMode="0">

        <rules/>

    </formProperties>

</workflow>'

IF not exists (select * from WF_Definition where Name = @name)

BEGIN
    INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision)


    VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision)

    SET @workflowId = @@IDENTITY
    INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


    VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

    SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = ISNULL(revision, '') From WF_Definition WHERE Name = @name

    IF (@currentFlags & 4 > 0 OR @flags & 16 > 0) AND (@currentRevision <> @revision)

    BEGIN

        SET @version = @version + 1

        UPDATE WF_Definition

        SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision

        WHERE Name = @name

        IF (@flags & 8 > 0 OR @flags & 16 > 0)

        BEGIN

            UPDATE WF_Definition

            SET flags = @flags

            WHERE Name = @name

        END
        INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


        VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

    END

END

