

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_FileOperationsBulk.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 2017  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER ON

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.1.4.14 $'

SET @name = 'FileOperationsBulk'

SET @description = 'Workflow fires search requests to WebServer and processes search results in loop'

SET @version = 1

SET @flags = 30

SET @definition='<workflow apiMode="0" config="&lt;configuration />"

    description="Workflow fires search requests to WebServer and processes search results in loop"

    executeOnWeb="0"

    inputs="&lt;inputs>&lt;INP_OPERATION class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;INP_HANDLERID class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;INP_SEARCHREQUEST class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;INP_WAIT_FOR_JOBS class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/INP_WAIT_FOR_JOBS>&lt;INP_NOOFDOCS class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>100&lt;/INP_NOOFDOCS>&lt;INP_DEST_PASSWORD class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; />&lt;INP_DEST_LOC class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;INP_DEST_USER class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;INP_STORAGE_POLICY class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;INP_SUB_CLIENT_NAME class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;INP_APP_NAME class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;INP_PROXY_CLIENT class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>&lt;clientName />&lt;clientId />&lt;/INP_PROXY_CLIENT>&lt;INP_SECOND_APPROVAL class=&quot;commvault.msgs.CvEntities.UserEntity&quot; _list_=&quot;true&quot;>&lt;userName />&lt;userId />&lt;/INP_SECOND_APPROVAL>&lt;INP_DELETE_FILES_POST_BACKUP class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/INP_DELETE_FILES_POST_BACKUP>&lt;INP_WAIT_FOR_WORKFLOW_JOBS class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/INP_WAIT_FOR_WORKFLOW_JOBS>&lt;X11 class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot; />&lt;INP_INDEX_CONFIG class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;INP_NO_OF_FILES_TO_PROCESS class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>100&lt;/INP_NO_OF_FILES_TO_PROCESS>&lt;INP_RETENTION_DAYS class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;INP_RETENTION_MONTHS class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;INP_RETENTION_YEARS class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;INP_DELETE_FROM_BACKUP class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot; />&lt;INP_TASK_ID class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>0&lt;/INP_TASK_ID>&lt;/inputs>"

    interactive="0" isHtmlDescription="0" manualPercentageComplete="0"

    name="FileOperationsBulk"

    outputs="&lt;outputs>&lt;JOBIDLIST class=&quot;java.lang.Integer&quot; _list_=&quot;true&quot; />&lt;/outputs>"

    revision="$Revision: 1.1.4.14 $" tags=""

    uniqueGuid="d84832b8-9254-4a0f-8f3e-eb52a1d0184b"

    variables="&lt;variables>&lt;VAR_START_POSITION class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>0&lt;/VAR_START_POSITION>&lt;VAR_SEARCH_REQUEST class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;VAR_NOOFFILES class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>0&lt;/VAR_NOOFFILES>&lt;VAR_WORKFLOW_MESSAGE class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;VAR_WORKFLOW_STATUS class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>COMPLETED&lt;/VAR_WORKFLOW_STATUS>&lt;VAR_RESPONSE_CLIENT_IDS class=&quot;java.lang.Integer&quot; _list_=&quot;true&quot; />&lt;VAR_WORKFLOW_INPUT_JSON class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;VAR_WORKFLOW_JOBID_LIST class=&quot;java.lang.Integer&quot; _list_=&quot;true&quot; />&lt;VAR_WORKFLOW_INPUT_JSON_UNC class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;VAR_DSID_LIST class=&quot;java.lang.String&quot; _list_=&quot;true&quot; />&lt;VAR_UNC_FILE_JSON class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;VAR_TASK_STATUS class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>TaskCompleted&lt;/VAR_TASK_STATUS>&lt;/variables>"

    webHidden="0" workflowId="0">

    <schema>

        <outputs className="" name="outputs" type="">

            <children attribute="0" className="java.lang.Integer"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0"

                inputType="java.lang.Integer" listType="1"

                name="JOBIDLIST" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

        </outputs>

        <variables attribute="0" className="" name="variables" type="">

            <children attribute="0" className="java.lang.Integer"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0"

                inputType="java.lang.Integer" listType="0"

                name="VAR_START_POSITION" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="VAR_SEARCH_REQUEST" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.Integer"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0"

                inputType="java.lang.Integer" listType="0"

                name="VAR_NOOFFILES" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="VAR_WORKFLOW_MESSAGE" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="VAR_WORKFLOW_STATUS" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.Integer"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.Integer" listType="1"

                name="VAR_RESPONSE_CLIENT_IDS" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="VAR_WORKFLOW_INPUT_JSON" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.Integer"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.Integer" listType="1"

                name="VAR_WORKFLOW_JOBID_LIST" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="VAR_WORKFLOW_INPUT_JSON_UNC" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="1"

                name="VAR_DSID_LIST" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" hidden="0"

                inputType="java.lang.String" listType="0"

                name="VAR_UNC_FILE_JSON" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" documentation=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="VAR_TASK_STATUS" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

        </variables>

        <inputs attribute="0" className="" name="inputs" type="">

            <children attribute="0" className="java.lang.String"

                controlHidden="0" controlType="2" defaultValue=""

                displayName="Select operation" documentation=""

                hidden="0" inputType="java.lang.String" listType="0"

                maximumValue="" minimumValue="" name="INP_OPERATION"

                readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string">

                <options val="Delete"/>

                <options val="Backup and delete"/>

                <options val="Move to a different location"/>

                <options val="Add or Remove permissions"/>

                <options val="Set Expiry Date"/>

                <options val="Set ignored risk"/>

            </children>

            <children attribute="0" className="java.lang.Integer"

                controlHidden="0" controlType="0" defaultValue=""

                displayName="Handler id" documentation="" hidden="0"

                inputType="java.lang.Integer" listType="0"

                maximumValue="" minimumValue="" name="INP_HANDLERID"

                readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.String"

                controlHidden="0" controlType="0" defaultValue=""

                displayName="Search request json" documentation=""

                hidden="0" inputType="java.lang.String" listType="0"

                maximumValue="" minimumValue="" name="INP_SEARCHREQUEST"

                readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.Integer"

                controlHidden="0" controlType="0" defaultValue=""

                displayName="Number of files to process in a job"

                documentation="" hidden="0"

                inputType="java.lang.Integer" listType="0"

                maximumValue="" minimumValue="" name="INP_NOOFDOCS"

                readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.Boolean"

                controlHidden="0" controlType="5" defaultValue=""

                displayName="Wait for jobs?" documentation="" hidden="0"

                inputType="java.lang.Boolean" listType="0"

                maximumValue="" minimumValue="" name="INP_WAIT_FOR_JOBS"

                readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

            <children attribute="0"

                className="workflow.types.EncryptedString"

                controlHidden="0" controlType="0" defaultValue=""

                displayName="" documentation="" hidden="0"

                inputType="workflow.types.EncryptedString" listType="0"

                maximumValue="" minimumValue="" name="INP_DEST_PASSWORD"

                readOnly="0" required="0" searchable="0" type="{workflow.types}EncryptedString"/>

            <children attribute="0" className="java.lang.String"

                controlHidden="0" controlType="0" defaultValue=""

                displayName="" documentation="" hidden="0"

                inputType="java.lang.String" listType="0"

                maximumValue="" minimumValue="" name="INP_DEST_LOC"

                readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlHidden="0" controlType="0" defaultValue=""

                displayName="" documentation="" hidden="0"

                inputType="java.lang.String" listType="0"

                maximumValue="" minimumValue="" name="INP_DEST_USER"

                readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlHidden="0" controlType="0" defaultValue=""

                displayName="" documentation="" hidden="0"

                inputType="java.lang.String" listType="0"

                maximumValue="" minimumValue=""

                name="INP_STORAGE_POLICY" readOnly="0" required="0"

                searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlHidden="0" controlType="0" defaultValue=""

                displayName="" documentation="" hidden="0"

                inputType="java.lang.String" listType="0"

                maximumValue="" minimumValue=""

                name="INP_SUB_CLIENT_NAME" readOnly="0" required="0"

                searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlHidden="0" controlType="0" defaultValue=""

                displayName="" documentation="" hidden="0"

                inputType="java.lang.String" listType="0"

                maximumValue="" minimumValue="" name="INP_APP_NAME"

                readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0"

                className="commvault.msgs.CvEntities.ClientEntity"

                controlHidden="0" controlType="2" defaultValue=""

                displayName="" documentation="" hidden="0"

                inputType="commvault.msgs.CvEntities.ClientEntity"

                listType="0" maximumValue="" minimumValue=""

                name="INP_PROXY_CLIENT" readOnly="0" required="0"

                searchable="0" type="{commvault.msgs.CvEntities}ClientEntity">

                <children attribute="0" className="java.lang.String"

                    defaultValue="" inputType="java.lang.String"

                    listType="0" name="clientName" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children attribute="0" className="java.lang.Integer"

                    defaultValue="" inputType="java.lang.Integer"

                    listType="0" name="clientId" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            </children>

            <children attribute="0"

                className="commvault.msgs.CvEntities.UserEntity"

                controlHidden="0" controlType="2" defaultValue=""

                displayName="" documentation="" hidden="0"

                inputType="commvault.msgs.CvEntities.UserEntity"

                listType="1" maximumValue="" minimumValue=""

                name="INP_SECOND_APPROVAL" readOnly="0" required="0"

                searchable="0" type="{commvault.msgs.CvEntities}UserEntity">

                <children attribute="0" className="java.lang.String"

                    defaultValue="" inputType="java.lang.String"

                    listType="0" name="userName" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children attribute="0" className="java.lang.Integer"

                    defaultValue="" inputType="java.lang.Integer"

                    listType="0" name="userId" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            </children>

            <children attribute="0" className="java.lang.Boolean"

                controlHidden="0" controlType="5" defaultValue=""

                displayName="" documentation="" hidden="0"

                inputType="java.lang.Boolean" listType="0"

                maximumValue="" minimumValue=""

                name="INP_DELETE_FILES_POST_BACKUP" readOnly="0"

                required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

            <children attribute="0" className="java.lang.Boolean"

                controlHidden="0" controlType="5" defaultValue=""

                displayName="" documentation="" hidden="0"

                inputType="java.lang.Boolean" listType="0"

                maximumValue="" minimumValue=""

                name="INP_WAIT_FOR_WORKFLOW_JOBS" readOnly="0"

                required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

            <children attribute="0" className="java.lang.Integer"

                controlHidden="0" controlType="0" defaultValue=""

                displayName="Task id" documentation="" hidden="0"

                inputType="java.lang.Integer" listType="0"

                maximumValue="" minimumValue="" name="INP_TASK_ID"

                readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.Boolean"

                controlHidden="0" controlType="5" defaultValue=""

                displayName="---------- Options for operation-- Set Expiry Date OR Set ignored risk"

                documentation="" hidden="0"

                inputType="java.lang.Boolean" listType="0"

                maximumValue="" minimumValue="" name="X11" readOnly="1"

                required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

            <children attribute="0" className="java.lang.String"

                controlHidden="0" controlType="0" defaultValue=""

                displayName="Index configuration from Solr"

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" maximumValue="" minimumValue=""

                name="INP_INDEX_CONFIG" readOnly="0" required="0"

                searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.Integer"

                controlHidden="0" controlType="0" defaultValue=""

                displayName="Number of files to process in the Documents API"

                documentation="" hidden="0"

                inputType="java.lang.Integer" listType="0"

                maximumValue="" minimumValue=""

                name="INP_NO_OF_FILES_TO_PROCESS" readOnly="0"

                required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.Integer"

                controlHidden="0" controlType="0" defaultValue=""

                displayName="Number of days to retain the files"

                documentation="" hidden="0"

                inputType="java.lang.Integer" listType="0"

                maximumValue="" minimumValue=""

                name="INP_RETENTION_DAYS" readOnly="0" required="0"

                searchable="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.Integer"

                controlHidden="0" controlType="0" defaultValue=""

                displayName="Number of months to retain the files"

                documentation="" hidden="0"

                inputType="java.lang.Integer" listType="0"

                maximumValue="" minimumValue=""

                name="INP_RETENTION_MONTHS" readOnly="0" required="0"

                searchable="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.Integer"

                controlHidden="0" controlType="0" defaultValue=""

                displayName="Number of years to retain the files"

                documentation="" hidden="0"

                inputType="java.lang.Integer" listType="0"

                maximumValue="" minimumValue=""

                name="INP_RETENTION_YEARS" readOnly="0" required="0"

                searchable="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.Boolean"

                controlHidden="0" controlType="5" defaultValue=""

                displayName="Delete files from backup" documentation=""

                hidden="0" inputType="java.lang.Boolean" listType="0"

                maximumValue="" minimumValue=""

                name="INP_DELETE_FROM_BACKUP" readOnly="0" required="0"

                searchable="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

        </inputs>

        <config className="" name="configuration" type=""/>

    </schema>

    <Start commented="0" continueOnFailure="0" created="0"

        description="" displayName="Start" height="36" interactive="0"

        jobMode="0" name="Start" originalStyle="" skipAttempt="0"

        style="image;image=/images/jgraphx/house.png"

        uniqueName="Start_1" waitSetting="0" width="58" x="45" y="41">

        <inputs val="&lt;inputs />"/>

        <transition activity="Script_2" commented="0" originalStyle=""

            points="" sourceX="72" sourceY="59" status="0"

            style="defaultEdge" targetX="133" targetY="155"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Start>

    <Activity commented="0" continueOnFailure="0"

        created="1521485970035"

        description="iterates a group of activities over a list of values"

        displayName="While true" height="489" interactive="0"

        jobMode="0" name="ForEach"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ForEach_1" waitSetting="0" width="749" x="289" y="11">

        <inputs val="&lt;inputs>&lt;name class=&quot;java.lang.String&quot;>item&lt;/name>&lt;values class=&quot;java.lang.Object&quot; _list_=&quot;false&quot;>dummy&lt;/values>&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>1&lt;/numberOfParallelExecutions>&lt;continueOnFailure class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/continueOnFailure>&lt;/inputs>"/>

        <superProcess>

            <Start commented="0" continueOnFailure="0"

                created="1521485970035" description=""

                displayName="Start" height="30" interactive="0"

                jobMode="0" name="Start" originalStyle=""

                skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_2" waitSetting="0" width="59" x="29" y="30">

                <inputs val="&lt;inputs />"/>

                <transition activity="Script_3" commented="0"

                    originalStyle="" points="" sourceX="54" sourceY="45"

                    status="0" style="defaultEdge" targetX="74"

                    targetY="133" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity commented="0" continueOnFailure="1"

                created="1521485644081"

                description="performs http operations"

                displayName="Search &#xa;Request " height="34"

                interactive="0" jobMode="0" maxRestarts="0"

                name="HttpClient"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.HttpClientActivity"

                uniqueName="HttpClient_1" waitSetting="0" width="100"

                x="241" y="29">

                <onExit language="1" script="logger.info(&quot;INFO: Search Request O/P Response : [&quot; + xpath:{/workflow/HttpClient_1/output} +&quot;]&quot;);&#xd;&#xa;logger.info(&quot;INFO: Search Request statusCode : [&quot; + xpath:{/workflow/HttpClient_1/statusCode} +&quot;]&quot;);&#xd;&#xa;logger.info(&quot;INFO: Search Request statusText : [&quot; + xpath:{/workflow/HttpClient_1/statusText} +&quot;]&quot;);&#xd;&#xa;&#xd;&#xa;String message = &quot;&quot;;&#xd;&#xa;if (xpath:{/workflow/HttpClient_1/statusCode} != 200)&#xd;&#xa;{&#xd;&#xa;    message = &quot;Search API request failed to execute. Status Code recieved: &quot; + xpath:{/workflow/HttpClient_1/statusCode} + &quot;, Status text: &quot; + xpath:{/workflow/HttpClient_1/statusText} ;&#xd;&#xa;    workflow.setVariable(&quot;VAR_WORKFLOW_MESSAGE&quot;,message);&#xd;&#xa;    workflow.setVariable(&quot;VAR_WORKFLOW_STATUS&quot;,&quot;FAILED&quot;);&#xd;&#xa;}&#xd;&#xa;&#xd;&#xa;logger.info(&quot;INFO: VAR_WORKFLOW_MESSAGE [&quot;+ workflow.getVariable(&quot;VAR_WORKFLOW_MESSAGE&quot;) +&quot;]&quot;);&#xd;&#xa;logger.info(&quot;INFO: VAR_WORKFLOW_STATUS [&quot;+ workflow.getVariable(&quot;VAR_WORKFLOW_STATUS&quot;) +&quot;]&quot;);"/>

                <inputs val="&lt;inputs>&lt;request>&lt;url>/SearchSvc/CVWebService.svc/dcube/handler/xpath:{/workflow/inputs/INP_HANDLERID}&lt;/url>&lt;method>POST&lt;/method>&lt;postType>Raw&lt;/postType>&lt;postContent>xpath:{/workflow/variables/VAR_SEARCH_REQUEST}&lt;/postContent>&lt;postContentType>application/text; charset=UTF-8&lt;/postContentType>&lt;headers>&lt;name>Authtoken&lt;/name>&lt;value>QSDKONLY xpath:{/workflow/system/token}&lt;/value>&lt;/headers>&lt;headers>&lt;name>Accept&lt;/name>&lt;value>application/xml&lt;/value>&lt;/headers>&lt;/request>&lt;/inputs>"/>

                <transition activity="Script_1" commented="0"

                    originalStyle="" points="" sourceX="315"

                    sourceY="45" status="0"

                    style="defaultEdge;dashed=1;" targetX="448"

                    targetY="72" transitionIndex="0" x="82" y="-60">

                    <condition language="1" script="(!xpath:{/workflow/variables/VAR_WORKFLOW_STATUS}.contains(&quot;FAILED&quot;));"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1521485984482"

                description="activity to execute code snippets in the selected language"

                displayName="Set no of files and client id list"

                height="34" interactive="0" jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.ScriptActivity"

                uniqueName="Script_1" waitSetting="0" width="198"

                x="395" y="29">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;import org.json.JSONArray;&amp;#xD;&amp;#xA;import org.json.JSONException;&amp;#xD;&amp;#xA;import org.json.JSONObject;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;int val = xpath:{/workflow/variables/VAR_START_POSITION} + xpath:{/workflow/inputs/INP_NOOFDOCS};&amp;#xD;&amp;#xA;val = val - 1;&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;VAR_START_POSITION&amp;quot;, val);&amp;#xD;&amp;#xA;logger.info(&amp;quot;INFO: Start position : [&amp;quot;+workflow.getVariable(&amp;quot;VAR_START_POSITION&amp;quot;)+&amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    JSONObject jsonObject = new JSONObject(xpath:{/workflow/HttpClient_1/output}.toString());&amp;#xD;&amp;#xA;    JSONObject newJSON = jsonObject.getJSONObject(&amp;quot;response&amp;quot;);&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    if (xpath:{/workflow/variables/VAR_NOOFFILES} == 0)&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        jsonObject = new JSONObject(newJSON.toString());&amp;#xD;&amp;#xA;        int nooffiles = jsonObject.getInt(&amp;quot;numFound&amp;quot;);&amp;#xD;&amp;#xA;        workflow.setVariable(&amp;quot;VAR_NOOFFILES&amp;quot;, nooffiles);&amp;#xD;&amp;#xA;        logger.info(&amp;quot;INFO: Number of files [&amp;quot;+workflow.getVariable(&amp;quot;VAR_NOOFFILES&amp;quot;)+&amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    JSONArray json_array_docs = newJSON.getJSONArray(&amp;quot;docs&amp;quot;);&amp;#xD;&amp;#xA;    logger.info(&amp;quot;INFO: Json docs = &amp;quot;+json_array_docs+&amp;quot;&amp;quot;);&amp;#xD;&amp;#xA;    int _clientid;&amp;#xD;&amp;#xA;    clientid_array=new ArrayList();&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;    for(int i=0; i&amp;lt;json_array_docs.length(); i++){&amp;#xD;&amp;#xA;        JSONObject jsonObj = json_array_docs.getJSONObject(i);&amp;#xD;&amp;#xA;        _clientid = jsonObj.getInt(&amp;quot;ClientId&amp;quot;);&amp;#xD;&amp;#xA;        if (!clientid_array.contains(_clientid))&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            clientid_array.add(_clientid);&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;VAR_RESPONSE_CLIENT_IDS&amp;quot;, clientid_array);&amp;#xD;&amp;#xA;    logger.info(&amp;quot;INFO: VAR_RESPONSE_CLIENT_IDS = &amp;quot;+workflow.getVariable(&amp;quot;VAR_RESPONSE_CLIENT_IDS&amp;quot;)+&amp;quot;&amp;quot;);&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;EXCEPTION: [&amp;quot;+e+&amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;VAR_WORKFLOW_MESSAGE&amp;quot;,&amp;quot;Failed to process search response with exception &amp;quot; + e);&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;VAR_WORKFLOW_STATUS&amp;quot;,&amp;quot;FAILED&amp;quot;);&amp;#xD;&amp;#xA;    logger.info(&amp;quot;INFO: VAR_WORKFLOW_MESSAGE [&amp;quot;+ workflow.getVariable(&amp;quot;VAR_WORKFLOW_MESSAGE&amp;quot;) +&amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;    logger.info(&amp;quot;INFO: VAR_WORKFLOW_STATUS [&amp;quot;+ workflow.getVariable(&amp;quot;VAR_WORKFLOW_STATUS&amp;quot;) +&amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;    return false;&amp;#xD;&amp;#xA;}&quot; />&lt;/inputs>"/>

                <transition activity="ForEach_2" commented="0"

                    originalStyle="" points="" sourceX="455"

                    sourceY="46" status="0" style="defaultEdge;dashed=1"

                    targetX="278" targetY="96" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="(!xpath:{/workflow/variables/VAR_WORKFLOW_STATUS}.contains(&quot;FAILED&quot;));"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1521488371152"

                description="activity to execute code snippets in the selected language"

                displayName="Set Request" height="34" interactive="0"

                jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.ScriptActivity"

                uniqueName="Script_3" waitSetting="0" width="100"

                x="111" y="29">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;import org.json.simple.JSONArray;&amp;#xD;&amp;#xA;import org.json.simple.JSONObject;&amp;#xD;&amp;#xA;import org.json.simple.parser.*;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;/*&amp;#xD;&amp;#xA;Sample search request&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;&amp;#x9;&amp;quot;searchParams&amp;quot;: [&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;{&amp;quot;key&amp;quot;: &amp;quot;q&amp;quot;,&amp;quot;value&amp;quot;: &amp;quot;*:*&amp;quot;},&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;{&amp;quot;key&amp;quot;: &amp;quot;wt&amp;quot;,&amp;quot;value&amp;quot;: &amp;quot;json&amp;quot;},&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;{&amp;quot;key&amp;quot;: &amp;quot;fl&amp;quot;,&amp;quot;value&amp;quot;: &amp;quot;FileName&amp;quot;},&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;{&amp;quot;key&amp;quot;: &amp;quot;fl&amp;quot;,&amp;quot;value&amp;quot;: &amp;quot;Url&amp;quot;},&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;{&amp;quot;key&amp;quot;: &amp;quot;fl&amp;quot;,&amp;quot;value&amp;quot;: &amp;quot;ClientId&amp;quot;},&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;{&amp;quot;key&amp;quot;: &amp;quot;fl&amp;quot;,&amp;quot;value&amp;quot;: &amp;quot;contentid&amp;quot;},&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;{&amp;quot;key&amp;quot;: &amp;quot;fl&amp;quot;,&amp;quot;value&amp;quot;: &amp;quot;data_source&amp;quot;},&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;{&amp;quot;key&amp;quot;: &amp;quot;fq&amp;quot;,&amp;quot;value&amp;quot;: &amp;quot;IsFile:1&amp;quot;},&amp;#xD;&amp;#xA;&amp;#x9;]&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;*/&amp;#xD;&amp;#xA; &amp;#xD;&amp;#xA;/*&amp;#xD;&amp;#xA;Add following key values to original Json string&amp;#xD;&amp;#xA;    {&amp;quot;key&amp;quot;:&amp;quot;start&amp;quot;, &amp;quot;value&amp;quot;:&amp;quot;0&amp;quot;},&amp;#xD;&amp;#xA;    {&amp;quot;key&amp;quot;:&amp;quot;rows&amp;quot;, &amp;quot;value&amp;quot;:&amp;quot;15&amp;quot;}&amp;#xD;&amp;#xA;*/&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;logger.info(&amp;quot;INFO: Start position : [&amp;quot;+xpath:{/workflow/variables/VAR_START_POSITION}+&amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    public static void appendToList(JSONObject jsonObj, JSONObject toBeAppended) &amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        JSONArray arr = (JSONArray) jsonObj.get(&amp;quot;searchParams&amp;quot;);        &amp;#xD;&amp;#xA;        arr.add(toBeAppended);&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;    String jsonString = xpath:{/workflow/inputs/INP_SEARCHREQUEST}.toString();&amp;#xD;&amp;#xA;    JSONParser parser = new JSONParser();&amp;#xD;&amp;#xA;    JSONObject jsonObj = (JSONObject) parser.parse(jsonString);&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    JSONObject newJSON = new JSONObject();&amp;#xD;&amp;#xA;    newJSON.put(&amp;quot;key&amp;quot;, &amp;quot;start&amp;quot;);&amp;#xD;&amp;#xA;    String val = xpath:{/workflow/variables/VAR_START_POSITION}.toString();&amp;#xD;&amp;#xA;    newJSON.put(&amp;quot;value&amp;quot;, val);&amp;#xD;&amp;#xA;    appendToList(jsonObj, newJSON);&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    JSONObject newJSON = new JSONObject();&amp;#xD;&amp;#xA;    newJSON.put(&amp;quot;key&amp;quot;, &amp;quot;rows&amp;quot;);&amp;#xD;&amp;#xA;    String val = xpath:{/workflow/inputs/INP_NOOFDOCS}.toString();&amp;#xD;&amp;#xA;    newJSON.put(&amp;quot;value&amp;quot;, val);&amp;#xD;&amp;#xA;    appendToList(jsonObj, newJSON);    &amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;VAR_SEARCH_REQUEST&amp;quot;,jsonObj);&amp;#xD;&amp;#xA;    logger.info(&amp;quot;INFO: Modified search request [&amp;quot;+workflow.getVariable(&amp;quot;VAR_SEARCH_REQUEST&amp;quot;)+&amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;    return true;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;EXCEPTION: [&amp;quot;+e+&amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;VAR_WORKFLOW_MESSAGE&amp;quot;,&amp;quot;Failed to create search request. Exception: &amp;quot; + e);&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;VAR_WORKFLOW_STATUS&amp;quot;,&amp;quot;FAILED&amp;quot;);&amp;#xD;&amp;#xA;    logger.info(&amp;quot;INFO: VAR_WORKFLOW_MESSAGE [&amp;quot;+ workflow.getVariable(&amp;quot;VAR_WORKFLOW_MESSAGE&amp;quot;) +&amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;    logger.info(&amp;quot;INFO: VAR_WORKFLOW_STATUS [&amp;quot;+ workflow.getVariable(&amp;quot;VAR_WORKFLOW_STATUS&amp;quot;) +&amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;    return false;&amp;#xD;&amp;#xA;}&quot; />&lt;/inputs>"/>

                <transition activity="HttpClient_1" commented="0"

                    originalStyle="" points="" sourceX="154"

                    sourceY="87" status="3" style="defaultEdge;dashed=1"

                    targetX="297" targetY="41" transitionIndex="0"

                    x="82" y="-60">

                    <condition language="1" script="(!xpath:{/workflow/variables/VAR_WORKFLOW_STATUS}.contains(&quot;FAILED&quot;));"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1523244654438"

                description="iterates a group of activities over a list of values"

                displayName="Loop on each client id" height="388"

                interactive="0" jobMode="0" name="ForEach"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0" style="swimlane"

                uniqueName="ForEach_2" waitSetting="0" width="726" x="6" y="91">

                <inputs val="&lt;inputs>&lt;name class=&quot;java.lang.String&quot;>VAR_RESPONSE_CLIENT_IDS&lt;/name>&lt;values class=&quot;java.lang.Object&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/VAR_RESPONSE_CLIENT_IDS}&lt;/values>&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>1&lt;/numberOfParallelExecutions>&lt;continueOnFailure class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/continueOnFailure>&lt;/inputs>"/>

                <superProcess>

                    <Start commented="0" continueOnFailure="0"

                        created="1523240760315" description=""

                        displayName="Start" height="30" interactive="0"

                        jobMode="0" name="Start" originalStyle=""

                        skipAttempt="0"

                        style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                        uniqueName="Start_4" waitSetting="0" width="58"

                        x="5" y="28">

                        <inputs val="&lt;inputs />"/>

                        <transition activity="Script_6" commented="0"

                            originalStyle="" points="" sourceX="49"

                            sourceY="45" status="0" style="defaultEdge"

                            targetX="192" targetY="45"

                            transitionIndex="0" x="-174" y="-66">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Start>

                    <Activity commented="0" continueOnFailure="0"

                        created="1523241042771"

                        description="activity to execute code snippets in the selected language"

                        displayName="Create json string" height="34"

                        interactive="0" jobMode="0" name="Script"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=commvault.cte.workflow.activities.ScriptActivity"

                        uniqueName="Script_6" waitSetting="0"

                        width="131" x="104" y="27">

                        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;/*&amp;#xD;&amp;#xA;Sample file content to create here :&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;[{  &amp;quot;file&amp;quot;:&amp;quot;\\\\devshare\\devl\\psinha\\monitored\\IndexData\\6822_Protecting_your_data_with_Windows_10_BitLocker.docx&amp;quot;,&amp;#xD;&amp;#xA;    &amp;quot;dsid&amp;quot;:&amp;quot;444&amp;quot;,&amp;#xD;&amp;#xA;    &amp;quot;contentid&amp;quot;:&amp;quot;1970bc1c3d94584044d950ca70b8616e&amp;quot;,&amp;#xD;&amp;#xA;    &amp;quot;ClientId&amp;quot;:0&amp;#xD;&amp;#xA; },&amp;#xD;&amp;#xA; {&amp;#xD;&amp;#xA;    &amp;quot;file&amp;quot;:&amp;quot;C:\AF103733448_en-us_word2013quickstartguide.pdf&amp;quot;,&amp;#xD;&amp;#xA;    &amp;quot;dsid&amp;quot;:&amp;quot;445&amp;quot;,&amp;#xD;&amp;#xA;    &amp;quot;contentid&amp;quot;:&amp;quot;bcc180a3ed4eaf17d08861ca579b4bd7&amp;quot;,&amp;#xD;&amp;#xA;    &amp;quot;ClientId&amp;quot;:0&amp;#xD;&amp;#xA; }&amp;#xD;&amp;#xA;]&amp;#xD;&amp;#xA;*/&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;import org.json.JSONArray;&amp;#xD;&amp;#xA;import org.json.JSONException;&amp;#xD;&amp;#xA;import org.json.JSONObject;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    JSONObject jsonObject = new JSONObject(xpath:{/workflow/HttpClient_1/output}.toString());&amp;#xD;&amp;#xA;    JSONObject newJSON = jsonObject.getJSONObject(&amp;quot;response&amp;quot;);&amp;#xD;&amp;#xA;    JSONArray json_array_docs = newJSON.getJSONArray(&amp;quot;docs&amp;quot;);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;    logger.info(&amp;quot;INFO: Response json = &amp;quot;+json_array_docs+&amp;quot;&amp;quot;);&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    int _clientid;&amp;#xD;&amp;#xA;    int client_id;&amp;#xD;&amp;#xA;    String client_id_string = &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;    String _createdtime;&amp;#xD;&amp;#xA;            &amp;#xD;&amp;#xA;    JSONArray WorkflowInputJson = new JSONArray();&amp;#xD;&amp;#xA;    JSONArray WorkflowInputJson_unc = new JSONArray();&amp;#xD;&amp;#xA;    dsid_array=new ArrayList();&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    for(int i=0; i&amp;lt;json_array_docs.length(); i++)&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        JSONObject jsonObj = json_array_docs.getJSONObject(i);&amp;#xD;&amp;#xA;        _clientid = jsonObj.getInt(&amp;quot;ClientId&amp;quot;);&amp;#xD;&amp;#xA;        client_id_string = xpath:{/workflow/ForEach_2/VAR_RESPONSE_CLIENT_IDS}.toString();&amp;#xD;&amp;#xA;        client_id = Integer.parseInt(client_id_string);&amp;#xD;&amp;#xA;        if (_clientid != client_id)&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            continue;&amp;#xD;&amp;#xA;        }        &amp;#xD;&amp;#xA;        // For set retention and ignore risk the URL might be empty &amp;#xD;&amp;#xA;        if (jsonObj.has(&amp;quot;Url&amp;quot;))&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            _file = jsonObj.getString(&amp;quot;Url&amp;quot;);&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;        else&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            _file = &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;           &amp;#xD;&amp;#xA;        _dsid = jsonObj.getString(&amp;quot;data_source&amp;quot;);&amp;#xD;&amp;#xA;        _dstype = jsonObj.getString(&amp;quot;data_source_type&amp;quot;);&amp;#xD;&amp;#xA;        _contentid = jsonObj.getString(&amp;quot;contentid&amp;quot;);&amp;#xD;&amp;#xA;        // For set retention and ignore risk the CreatedTime might be empty&amp;#xD;&amp;#xA;        if (jsonObj.has(&amp;quot;CreatedTime&amp;quot;))&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            _createdtime = jsonObj.getString(&amp;quot;CreatedTime&amp;quot;);&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;        else&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            _createdtime = &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;        JSONObject jo = new JSONObject();&amp;#xD;&amp;#xA;        jo.put(&amp;quot;file&amp;quot;, _file);&amp;#xD;&amp;#xA;        jo.put(&amp;quot;dsid&amp;quot;, _dsid);&amp;#xD;&amp;#xA;        jo.put(&amp;quot;contentid&amp;quot;, _contentid);&amp;#xD;&amp;#xA;        jo.put(&amp;quot;ClientId&amp;quot;, _clientid);&amp;#xD;&amp;#xA;        jo.put(&amp;quot;CreatedTime&amp;quot;, _createdtime);&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        if (_dstype.equals(&amp;quot;onedrive&amp;quot;))&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            jo.put(&amp;quot;dstype&amp;quot;, &amp;quot;27&amp;quot;);&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;        if (jsonObj.has(&amp;quot;OneDriveOwnerName&amp;quot;))&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            jo.put(&amp;quot;AppSpecificOwnerName&amp;quot;, jsonObj.getString(&amp;quot;OneDriveOwnerName&amp;quot;));&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;        if (jsonObj.has(&amp;quot;OneDriveNodeName&amp;quot;))&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            jo.put(&amp;quot;AppSpecificNodeName&amp;quot;, jsonObj.getString(&amp;quot;OneDriveNodeName&amp;quot;));&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;        if (jsonObj.has(&amp;quot;OneDriveNodeId&amp;quot;))&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            jo.put(&amp;quot;AppSpecificNodeId&amp;quot;, jsonObj.getString(&amp;quot;OneDriveNodeId&amp;quot;));&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;        if (_file.startsWith(&amp;quot;//&amp;quot;) || _file.startsWith(&amp;quot;\\\\&amp;quot;))&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            if (!dsid_array.contains(_dsid))&amp;#xD;&amp;#xA;            {&amp;#xD;&amp;#xA;                dsid_array.add(_dsid);&amp;#xD;&amp;#xA;            }&amp;#xD;&amp;#xA;        &amp;#x9;WorkflowInputJson_unc.put(jo);&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;        else&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;        &amp;#x9;WorkflowInputJson.put(jo);&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;VAR_DSID_LIST&amp;quot;, dsid_array);&amp;#xD;&amp;#xA;    logger.info(&amp;quot;INFO: VAR_DSID_LIST = &amp;quot;+workflow.getVariable(&amp;quot;VAR_DSID_LIST&amp;quot;)+&amp;quot;&amp;quot;);&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;VAR_WORKFLOW_INPUT_JSON&amp;quot;, WorkflowInputJson.toString());&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;VAR_WORKFLOW_INPUT_JSON_UNC&amp;quot;, WorkflowInputJson_unc.toString());&amp;#xD;&amp;#xA;    logger.info(&amp;quot;INFO: Local files workflow input json: &amp;quot;+ workflow.getVariable(&amp;quot;VAR_WORKFLOW_INPUT_JSON&amp;quot;) +&amp;quot;&amp;quot;);&amp;#xD;&amp;#xA;    logger.info(&amp;quot;INFO: UNC files workflow input json: &amp;quot;+ workflow.getVariable(&amp;quot;VAR_WORKFLOW_INPUT_JSON_UNC&amp;quot;) +&amp;quot;&amp;quot;);&amp;#xD;&amp;#xA;    if ( workflow.getVariable(&amp;quot;VAR_WORKFLOW_INPUT_JSON&amp;quot;) == &amp;quot;&amp;quot; || workflow.getVariable(&amp;quot;VAR_WORKFLOW_INPUT_JSON&amp;quot;) == null)&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        logger.info(&amp;quot;INFO: Empty local JSON for local files&amp;quot;);&amp;#xD;&amp;#xA;        return false;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    return true;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;EXCEPTION: [&amp;quot;+e+&amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;VAR_WORKFLOW_MESSAGE&amp;quot;,&amp;quot;Failed to create json file string for FileOperations workflow. Exception: &amp;quot; + e);&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;VAR_WORKFLOW_STATUS&amp;quot;,&amp;quot;FAILED&amp;quot;);&amp;#xD;&amp;#xA;    logger.info(&amp;quot;INFO: VAR_WORKFLOW_MESSAGE [&amp;quot;+ workflow.getVariable(&amp;quot;VAR_WORKFLOW_MESSAGE&amp;quot;) +&amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;    logger.info(&amp;quot;INFO: VAR_WORKFLOW_STATUS [&amp;quot;+ workflow.getVariable(&amp;quot;VAR_WORKFLOW_STATUS&amp;quot;) +&amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;    return false;&amp;#xD;&amp;#xA;}&quot; />&lt;/inputs>"/>

                        <transition activity="Break_1" commented="0"

                            originalStyle="" points="" sourceX="169"

                            sourceY="44" status="0"

                            style="defaultEdge;dashed=1" targetX="287"

                            targetY="39" transitionIndex="0" x="0" y="0">

                            <condition language="1" script="(xpath:{/workflow/variables/VAR_WORKFLOW_STATUS}.contains(&quot;FAILED&quot;));"/>

                        </transition>

                        <transition activity="ForEach_3" commented="0"

                            originalStyle="" points="123.0,111.0"

                            sourceX="169" sourceY="44" status="0"

                            style="defaultEdge;dashed=1" targetX="124"

                            targetY="163" transitionIndex="0" x="0" y="0">

                            <condition language="1" script="(!xpath:{/workflow/variables/VAR_WORKFLOW_STATUS}.contains(&quot;FAILED&quot;) &amp;&amp; !xpath:{/workflow/Script_6/output}); "/>

                        </transition>

                        <transition activity="DisableLogging_1"

                            commented="0" originalStyle="" points=""

                            sourceX="169" sourceY="44" status="0"

                            style="defaultEdge;dashed=1" targetX="170"

                            targetY="117" transitionIndex="0" x="0" y="0">

                            <condition language="1" script="(!xpath:{/workflow/variables/VAR_WORKFLOW_STATUS}.contains(&quot;FAILED&quot;) &amp;&amp; xpath:{/workflow/Script_6/output});"/>

                        </transition>

                    </Activity>

                    <Activity commented="0" continueOnFailure="0"

                        created="1523384164302"

                        description="retrieves a list of values from xml"

                        displayName="JobId" height="34" interactive="0"

                        jobMode="0" name="XPathQuery"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=commvault.cte.workflow.activities.XMLQueryActivity"

                        uniqueName="XPathQuery_1" waitSetting="0"

                        width="76" x="405" y="97">

                        <onExit language="1" script="logger.info(&quot;INFO: Local files Workflow Request O/P Response : [&quot; + xpath:{/workflow/HttpClient_2/output} +&quot;]&quot;);&#xd;&#xa;logger.info(&quot;INFO: Local files Workflow Request statusCode : [&quot; + xpath:{/workflow/HttpClient_2/statusCode} +&quot;]&quot;);&#xd;&#xa;logger.info(&quot;INFO: Local files Workflow Request statusText : [&quot; + xpath:{/workflow/HttpClient_2/statusText} +&quot;]&quot;);&#xd;&#xa;&#xd;&#xa;String message = &quot;&quot;;&#xd;&#xa;if (xpath:{/workflow/HttpClient_2/statusCode} != 200)&#xd;&#xa;{&#xd;&#xa;    message = &quot;Workflow failed to execute for local files. Status Code recieved: &quot; + xpath:{/workflow/HttpClient_2/statusCode} + &quot;, Status text: &quot; + xpath:{/workflow/HttpClient_2/statusText} ;&#xd;&#xa;    workflow.setVariable(&quot;VAR_WORKFLOW_MESSAGE&quot;,message);&#xd;&#xa;    workflow.setVariable(&quot;VAR_WORKFLOW_STATUS&quot;,&quot;FAILED&quot;);&#xd;&#xa;    logger.info(&quot;INFO: VAR_WORKFLOW_MESSAGE [&quot;+ workflow.getVariable(&quot;VAR_WORKFLOW_MESSAGE&quot;) +&quot;]&quot;);&#xd;&#xa;    logger.info(&quot;INFO: VAR_WORKFLOW_STATUS [&quot;+ workflow.getVariable(&quot;VAR_WORKFLOW_STATUS&quot;) +&quot;]&quot;);&#xd;&#xa;}&#xd;&#xa;&#xd;&#xa;if (xpath:{/workflow/XPathQuery_1/result} == null || xpath:{/workflow/XPathQuery_1/result} == &quot;&quot;)&#xd;&#xa;{&#xd;&#xa;    logger.info(&quot;ERROR: Failed to get workflow job id&quot;);&#xd;&#xa;    message = &quot;Failed to get workflow job id &quot;;&#xd;&#xa;    workflow.setVariable(&quot;VAR_WORKFLOW_MESSAGE&quot;,message);&#xd;&#xa;    workflow.setVariable(&quot;VAR_WORKFLOW_STATUS&quot;,&quot;FAILED&quot;);&#xd;&#xa;    logger.info(&quot;INFO: VAR_WORKFLOW_MESSAGE [&quot;+ workflow.getVariable(&quot;VAR_WORKFLOW_MESSAGE&quot;) +&quot;]&quot;);&#xd;&#xa;    logger.info(&quot;INFO: VAR_WORKFLOW_STATUS [&quot;+ workflow.getVariable(&quot;VAR_WORKFLOW_STATUS&quot;) +&quot;]&quot;);&#xd;&#xa;}&#xd;&#xa;"/>

                        <inputs val="&lt;inputs>&lt;xml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/HttpClient_2/output}&lt;/xml>&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>/Workflow_StartWorkflowResponse/@jobId&lt;/xpath>&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;>Integer&lt;/outputType>&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/outputAsList>&lt;/inputs>"/>

                        <transition activity="AddToList_1" commented="0"

                            originalStyle="" points="" sourceX="523"

                            sourceY="177" status="0"

                            style="defaultEdge;dashed=1" targetX="533"

                            targetY="228" transitionIndex="0" x="452" y="81">

                            <condition language="1" script="(!xpath:{/workflow/variables/VAR_WORKFLOW_STATUS}.contains(&quot;FAILED&quot;));"/>

                        </transition>

                    </Activity>

                    <Activity commented="0" continueOnFailure="1"

                        created="1523384355000"

                        description="utility to add objects to a list"

                        displayName="Add to JobId list" height="34"

                        interactive="0" jobMode="0" maxRestarts="0"

                        name="AddToList"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=commvault.cte.workflow.activities.ListActivityAdd"

                        uniqueName="AddToList_1" waitSetting="0"

                        width="128" x="447" y="33">

                        <inputs val="&lt;inputs>&lt;addToList class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/VAR_WORKFLOW_JOBID_LIST}&lt;/addToList>&lt;itemToAdd class=&quot;java.lang.Object&quot; _list_=&quot;false&quot;>xpath:{/workflow/XPathQuery_1/result}&lt;/itemToAdd>&lt;/inputs>"/>

                        <transition activity="WaitForJobCompletion_2"

                            commented="0" originalStyle="" points=""

                            sourceX="523" sourceY="178" status="0"

                            style="defaultEdge;dashed=1" targetX="527"

                            targetY="223" transitionIndex="0" x="0" y="0">

                            <condition language="1" script="!(xpath:{/workflow/variables/VAR_WORKFLOW_STATUS}.contains(&quot;FAILED&quot;));"/>

                        </transition>

                    </Activity>

                    <Activity commented="0" continueOnFailure="1"

                        created="1523459559819"

                        description="performs http operations"

                        displayName="Execute &#xa;FileOperations &#xa;Workflow for Local Files"

                        height="48" interactive="0" jobMode="0"

                        maxRestarts="0" name="HttpClient"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=commvault.cte.workflow.activities.HttpClientActivity"

                        uniqueName="HttpClient_2" waitSetting="0"

                        width="168" x="257" y="31">

                        <inputs val="&lt;inputs>&lt;request>&lt;url>/SearchSvc/CVWebService.svc/Workflow/FileOperations/Action/Execute&lt;/url>&lt;method>POST&lt;/method>&lt;postType>Raw&lt;/postType>&lt;postContent>&amp;lt;Workflow_StartWorkflow&amp;gt;&#xd;&#xa;&#x9;&amp;lt;outputFormat&amp;gt;&amp;lt;/outputFormat&amp;gt;&#xd;&#xa;&#x9;&#x9;&amp;lt;options&amp;gt;&#xd;&#xa;&#x9;&#x9;&amp;lt;inputs&amp;gt;&#xd;&#xa;            &amp;lt;INP_OPERATION&amp;gt;xpath:{/workflow/inputs/INP_OPERATION}&amp;lt;/INP_OPERATION&amp;gt;&#xd;&#xa;            &amp;lt;INP_FILES&amp;gt;xpath:{/workflow/variables/VAR_WORKFLOW_INPUT_JSON}&amp;lt;/INP_FILES&amp;gt;&#xd;&#xa;            &amp;lt;INP_DEST_PASSWORD&amp;gt;xpath:{/workflow/inputs/INP_DEST_PASSWORD}&amp;lt;/INP_DEST_PASSWORD&amp;gt;&#xd;&#xa;            &amp;lt;INP_DELETE_FILES_POST_BACKUP&amp;gt;xpath:{/workflow/inputs/INP_DELETE_FILES_POST_BACKUP}&amp;lt;/INP_DELETE_FILES_POST_BACKUP&amp;gt;&#xd;&#xa;            &amp;lt;INP_WAIT_FOR_JOBS&amp;gt;xpath:{/workflow/inputs/INP_WAIT_FOR_JOBS}&amp;lt;/INP_WAIT_FOR_JOBS&amp;gt;&#xd;&#xa;            &amp;lt;INP_DEST_USER&amp;gt;xpath:{/workflow/inputs/INP_DEST_USER}&amp;lt;/INP_DEST_USER&amp;gt;&#xd;&#xa;            &amp;lt;INP_CLIENT_ID&amp;gt;xpath:{/workflow/ForEach_2/VAR_RESPONSE_CLIENT_IDS}&amp;lt;/INP_CLIENT_ID&amp;gt;&#xd;&#xa;            &amp;lt;INP_DEST_LOC&amp;gt;xpath:{/workflow/inputs/INP_DEST_LOC}&amp;lt;/INP_DEST_LOC&amp;gt;&#xd;&#xa;            &amp;lt;INP_APP_NAME&amp;gt;Windows File System&amp;lt;/INP_APP_NAME&amp;gt;&#xd;&#xa;            &amp;lt;INP_SUB_CLIENT_NAME&amp;gt;xpath:{/workflow/inputs/INP_SUB_CLIENT_NAME}&amp;lt;/INP_SUB_CLIENT_NAME&amp;gt;&#xd;&#xa;            &amp;lt;INP_PROXY_CLIENT&amp;gt;xpath:{/workflow/inputs/INP_PROXY_CLIENT}&amp;lt;/INP_PROXY_CLIENT&amp;gt;&#xd;&#xa;            &amp;lt;INP_SECOND_APPROVAL&amp;gt;xpath:{/workflow/inputs/INP_SECOND_APPROVAL}&amp;lt;/INP_SECOND_APPROVAL&amp;gt;&#xd;&#xa;            &amp;lt;INP_INDEX_CONFIG&amp;gt;xpath:{/workflow/inputs/INP_INDEX_CONFIG}&amp;lt;/INP_INDEX_CONFIG&amp;gt;&#xd;&#xa;            &amp;lt;INP_RETENTION_DAYS&amp;gt;xpath:{/workflow/inputs/INP_RETENTION_DAYS}&amp;lt;/INP_RETENTION_DAYS&amp;gt;&#xd;&#xa;            &amp;lt;INP_RETENTION_MONTHS&amp;gt;xpath:{/workflow/inputs/INP_RETENTION_MONTHS}&amp;lt;/INP_RETENTION_MONTHS&amp;gt;&#xd;&#xa;            &amp;lt;INP_RETENTION_YEARS&amp;gt;xpath:{/workflow/inputs/INP_RETENTION_YEARS}&amp;lt;/INP_RETENTION_YEARS&amp;gt;&#xd;&#xa;            &amp;lt;INP_NO_OF_FILES_TO_PROCESS&amp;gt;xpath:{/workflow/inputs/INP_NO_OF_FILES_TO_PROCESS}&amp;lt;/INP_NO_OF_FILES_TO_PROCESS&amp;gt;&#xd;&#xa;            &amp;lt;INP_DELETE_FROM_BACKUP&amp;gt;xpath:{/workflow/inputs/INP_DELETE_FROM_BACKUP}&amp;lt;/INP_DELETE_FROM_BACKUP&amp;gt;&#xd;&#xa;&amp;lt;/inputs&amp;gt;&#xd;&#xa;&#x9;&amp;lt;/options&amp;gt;&#xd;&#xa;&#x9;&amp;lt;client&amp;gt;&#xd;&#xa;&#x9;&#x9;&amp;lt;clientName&amp;gt;xpath:{/workflow/system/workflowEngine/clientName}&amp;lt;/clientName&amp;gt;&#xd;&#xa;&#x9;&#x9;&amp;lt;clientId&amp;gt;xpath:{/workflow/system/workflowEngine/clientId}&amp;lt;/clientId&amp;gt;&#xd;&#xa;&#x9;&amp;lt;/client&amp;gt;&#xd;&#xa;&amp;lt;/Workflow_StartWorkflow&amp;gt;&lt;/postContent>&lt;postContentType>application/xml; charset=UTF-8&lt;/postContentType>&lt;headers>&lt;name>Authtoken&lt;/name>&lt;value>QSDKONLY xpath:{/workflow/system/token}&lt;/value>&lt;/headers>&lt;headers>&lt;name>Accept&lt;/name>&lt;value>application/xml&lt;/value>&lt;/headers>&lt;/request>&lt;/inputs>"/>

                        <transition activity="EnableLogging_1"

                            commented="0" originalStyle=""

                            points="335.0,116.0" sourceX="339"

                            sourceY="115" status="0"

                            style="defaultEdge;dashed=0" targetX="495"

                            targetY="116" transitionIndex="0" x="0" y="0"/>

                    </Activity>

                    <Activity commented="0" continueOnFailure="0"

                        created="1523761598647"

                        description="interrupts a process block execution"

                        displayName="Break" height="46" interactive="0"

                        jobMode="0" name="Break"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=commvault.cte.workflow.activities.InterruptActivity"

                        uniqueName="Break_1" waitSetting="0" width="69"

                        x="8" y="85">

                        <inputs val="&lt;inputs />"/>

                    </Activity>

                    <Activity commented="0" continueOnFailure="1"

                        created="1523765081613"

                        description="waits until the list of jobs completes"

                        displayName="WaitForJobCompletion" height="34"

                        interactive="0" jobMode="0" maxRestarts="0"

                        name="WaitForJobCompletion"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=commvault.cte.workflow.activities.WaitForJobCompletion"

                        uniqueName="WaitForJobCompletion_2"

                        waitSetting="0" width="182" x="519" y="95">

                        <inputs val="&lt;inputs>&lt;jobId class=&quot;java.lang.Integer&quot; _list_=&quot;true&quot;>xpath:{/workflow/XPathQuery_1/result}&lt;/jobId>&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

                        <transition activity="ForEach_3" commented="0"

                            originalStyle="" points="499.0,264.0"

                            sourceX="394" sourceY="104" status="0"

                            style="defaultEdge" targetX="252"

                            targetY="256" transitionIndex="0" x="0" y="0">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity commented="0" continueOnFailure="0"

                        created="1523802186025"

                        description="iterates a group of activities over a list of values"

                        displayName="Loop for each dsid" height="199"

                        interactive="0" jobMode="0" name="ForEach"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="swimlane" uniqueName="ForEach_3"

                        waitSetting="0" width="594" x="16" y="157">

                        <inputs val="&lt;inputs>&lt;name class=&quot;java.lang.String&quot;>VAR_DSID_LIST&lt;/name>&lt;values class=&quot;java.lang.Object&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/VAR_DSID_LIST}&lt;/values>&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>1&lt;/numberOfParallelExecutions>&lt;continueOnFailure class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/continueOnFailure>&lt;/inputs>"/>

                        <superProcess>

                            <Start commented="0" continueOnFailure="0"

                                created="1523802186025" description=""

                                displayName="Start" height="18"

                                interactive="0" jobMode="0" name="Start"

                                originalStyle="" skipAttempt="0"

                                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                                uniqueName="Start_5" waitSetting="0"

                                width="58" x="5" y="32">

                                <inputs val="&lt;inputs />"/>

                                <transition

                                    activity="ImpersonateCreator_1"

                                    commented="0" originalStyle=""

                                    points="" sourceX="34" sourceY="37"

                                    status="0" style="defaultEdge"

                                    targetX="104" targetY="57"

                                    transitionIndex="0" x="0" y="0">

                                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                                </transition>

                            </Start>

                            <Activity commented="0"

                                continueOnFailure="0"

                                created="1523802254937"

                                description="executes queries against a commcell database"

                                displayName="Get client id" height="34"

                                interactive="0" jobMode="0"

                                name="CommServDBQuery"

                                namespaceUri="commvault.cte.workflow.activities"

                                originalStyle="" skipAttempt="0"

                                style="label;image=commvault.cte.workflow.activities.CommServDBQuery"

                                uniqueName="CommServDBQuery_1"

                                waitSetting="0" width="97" x="13" y="68">

                                <onExit language="1" script="logger.info(&quot;INFO: Client id = [&quot;+xpath:{/workflow/CommServDBQuery_1/resultSets/row/col}+&quot;], for dsid [&quot;+xpath:{/workflow/ForEach_3/VAR_DSID_LIST}+&quot;]&quot;);&#xd;&#xa;if (xpath:{/workflow/CommServDBQuery_1/resultSets/rowCount} &lt; 1)&#xd;&#xa;{&#xd;&#xa;    workflow.setVariable(&quot;VAR_WORKFLOW_MESSAGE&quot;,&quot;Failed to get client id for dsid [&quot;+xpath:{/workflow/ForEach_3/VAR_DSID_LIST}+&quot;]&quot;);&#xd;&#xa;    workflow.setVariable(&quot;VAR_WORKFLOW_STATUS&quot;,&quot;FAILED&quot;);&#xd;&#xa;    logger.info(&quot;INFO: VAR_WORKFLOW_MESSAGE [&quot;+ workflow.getVariable(&quot;VAR_WORKFLOW_MESSAGE&quot;) +&quot;]&quot;);&#xd;&#xa;    logger.info(&quot;INFO: VAR_WORKFLOW_STATUS [&quot;+ workflow.getVariable(&quot;VAR_WORKFLOW_STATUS&quot;) +&quot;]&quot;);&#xd;&#xa;}"/>

                                <inputs val="&lt;inputs>&lt;commCell />&lt;query>SELECT DISTINCT DSP.PropertyValue FROM SEDataSourceProperty AS DSP &amp;#xD;&#xd;&#xa;WITH (NOLOCK) INNER JOIN SEProperty AS P ON P.PropertyId = DSP.PropertyId &amp;#xD;&#xd;&#xa;AND P.PropertyName = ''accessnodeclientid''&amp;#xD;&#xd;&#xa;WHERE DSP.DataSourceId = ?&amp;#xD;&#xd;&#xa;&lt;/query>&lt;parameters>&lt;value>xpath:{/workflow/ForEach_3/VAR_DSID_LIST}&lt;/value>&lt;type>OBJECT&lt;/type>&lt;/parameters>&lt;/inputs>"/>

                                <transition

                                    activity="ImpersonateExecutor_1"

                                    commented="0" originalStyle=""

                                    points="" sourceX="61" sourceY="85"

                                    status="0"

                                    style="defaultEdge;dashed=1"

                                    targetX="104" targetY="124"

                                    transitionIndex="0" x="0" y="0">

                                    <condition language="1" script="!(xpath:{/workflow/variables/VAR_WORKFLOW_STATUS}.contains(&quot;FAILED&quot;));"/>

                                </transition>

                            </Activity>

                            <Activity commented="0"

                                continueOnFailure="0"

                                created="1523803707400"

                                description="activity to execute code snippets in the selected language"

                                displayName="Create Json " height="21"

                                interactive="0" jobMode="0"

                                name="Script"

                                namespaceUri="commvault.cte.workflow.activities"

                                originalStyle="" skipAttempt="0"

                                style="label;image=commvault.cte.workflow.activities.ScriptActivity"

                                uniqueName="Script_7" waitSetting="0"

                                width="102" x="15" y="167">

                                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;import org.json.JSONArray;&amp;#xD;&amp;#xA;import org.json.JSONException;&amp;#xD;&amp;#xA;import org.json.JSONObject;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;/* Input Files example &amp;#xD;&amp;#xA;[{  &amp;quot;file&amp;quot;:&amp;quot;\\\\devshare\\devl\\username\\monitored\\IndexData\\6822_Protecting_your_data_with_Windows_10_BitLocker.docx&amp;quot;,&amp;#xD;&amp;#xA;    &amp;quot;dsid&amp;quot;:&amp;quot;444&amp;quot;,&amp;#xD;&amp;#xA;    &amp;quot;contentid&amp;quot;:&amp;quot;1970bc1c3d94584044d950ca70b8616e&amp;quot;,&amp;#xD;&amp;#xA;    &amp;quot;ClientId&amp;quot;:0&amp;#xD;&amp;#xA; },&amp;#xD;&amp;#xA; {&amp;#xD;&amp;#xA;    &amp;quot;file&amp;quot;:&amp;quot;\\\\devshare\\devl\\username\\monitored\\IndexData\\6822_Protecting.txt&amp;quot;,&amp;#xD;&amp;#xA;    &amp;quot;dsid&amp;quot;:&amp;quot;445&amp;quot;,&amp;#xD;&amp;#xA;    &amp;quot;contentid&amp;quot;:&amp;quot;bcc180a3ed4eaf17d08861ca579b4bd7&amp;quot;,&amp;#xD;&amp;#xA;    &amp;quot;ClientId&amp;quot;:0&amp;#xD;&amp;#xA; }&amp;#xD;&amp;#xA;]&amp;#xD;&amp;#xA;*/&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;VAR_UNC_FILE_JSON&amp;quot;, &amp;quot;&amp;quot;);&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    JSONArray array = new JSONArray(xpath:{/workflow/variables/VAR_WORKFLOW_INPUT_JSON_UNC}); &amp;#xD;&amp;#xA;    logger.info(&amp;quot;INFO : UNC JSON File mapping for all dsids: [&amp;quot; + array +&amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    JSONArray WorkflowInputJson_unc_dsid = new JSONArray();&amp;#xD;&amp;#xA;    String _file = &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;    String _dsid = &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;    String _contentid = &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;    String ds_id;&amp;#xD;&amp;#xA;    String _createdtime;&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    for(int i=0; i&amp;lt;array.length(); i++){&amp;#xD;&amp;#xA;        JSONObject jsonObj = array.getJSONObject(i);&amp;#xD;&amp;#xA;        _dsid = jsonObj.getString(&amp;quot;dsid&amp;quot;).trim();&amp;#xD;&amp;#xA;        ds_id = xpath:{/workflow/ForEach_3/VAR_DSID_LIST}.toString().trim();&amp;#xD;&amp;#xA;        if (!_dsid.equals(ds_id))&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            continue;&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;        JSONObject jo = new JSONObject();&amp;#xD;&amp;#xA;        jo.put(&amp;quot;file&amp;quot;, jsonObj.getString(&amp;quot;file&amp;quot;));&amp;#xD;&amp;#xA;        jo.put(&amp;quot;dsid&amp;quot;, _dsid);&amp;#xD;&amp;#xA;        jo.put(&amp;quot;contentid&amp;quot;, jsonObj.getString(&amp;quot;contentid&amp;quot;));&amp;#xD;&amp;#xA;        jo.put(&amp;quot;ClientId&amp;quot;, xpath:{/workflow/CommServDBQuery_1/resultSets/row/col});&amp;#xD;&amp;#xA;        jo.put(&amp;quot;CreatedTime&amp;quot;, jsonObj.getString(&amp;quot;CreatedTime&amp;quot;));&amp;#xD;&amp;#xA;        WorkflowInputJson_unc_dsid.put(jo);&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;VAR_UNC_FILE_JSON&amp;quot;, WorkflowInputJson_unc_dsid.toString());&amp;#xD;&amp;#xA;    logger.info(&amp;quot;INFO: VAR_UNC_FILE_JSON: [&amp;quot; + workflow.getVariable(&amp;quot;VAR_UNC_FILE_JSON&amp;quot;) + &amp;quot;] for dsid [&amp;quot;+xpath:{/workflow/ForEach_3/VAR_DSID_LIST}+&amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;    if ( workflow.getVariable(&amp;quot;VAR_UNC_FILE_JSON&amp;quot;) == null || workflow.getVariable(&amp;quot;VAR_UNC_FILE_JSON&amp;quot;) == &amp;quot;&amp;quot;)&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        logger.info(&amp;quot;INFO: UNC File Json is empty&amp;quot;);&amp;#xD;&amp;#xA;        return false;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    return true;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;EXCEPTION: [&amp;quot;+e+&amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;VAR_WORKFLOW_MESSAGE&amp;quot;,&amp;quot;Failed to create UNC json file string for FileOperations workflow. Exception: &amp;quot; + e);&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;VAR_WORKFLOW_STATUS&amp;quot;,&amp;quot;FAILED&amp;quot;);&amp;#xD;&amp;#xA;    logger.info(&amp;quot;INFO: VAR_WORKFLOW_MESSAGE [&amp;quot;+ workflow.getVariable(&amp;quot;VAR_WORKFLOW_MESSAGE&amp;quot;) +&amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;    logger.info(&amp;quot;INFO: VAR_WORKFLOW_STATUS [&amp;quot;+ workflow.getVariable(&amp;quot;VAR_WORKFLOW_STATUS&amp;quot;) +&amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;    return false;&amp;#xD;&amp;#xA;}&quot; />&lt;/inputs>"/>

                                <transition activity="DisableLogging_2"

                                    commented="0" originalStyle=""

                                    points="" sourceX="66" sourceY="150"

                                    status="0"

                                    style="defaultEdge;dashed=1"

                                    targetX="170" targetY="116"

                                    transitionIndex="0" x="0" y="0">

                                    <condition language="1" script="(xpath:{/workflow/Script_7/output});"/>

                                </transition>

                            </Activity>

                            <Activity commented="0"

                                continueOnFailure="1"

                                created="1523804684221"

                                description="performs http operations"

                                displayName="Execute &#xa;FileOperations &#xa;Workflow for UNC Files"

                                height="48" interactive="0" jobMode="0"

                                maxRestarts="0" name="HttpClient"

                                namespaceUri="commvault.cte.workflow.activities"

                                originalStyle="" skipAttempt="0"

                                style="label;image=commvault.cte.workflow.activities.HttpClientActivity"

                                uniqueName="HttpClient_3"

                                waitSetting="0" width="168" x="284" y="33">

                                <inputs val="&lt;inputs>&lt;request>&lt;url>/SearchSvc/CVWebService.svc/Workflow/FileOperations/Action/Execute&lt;/url>&lt;method>POST&lt;/method>&lt;postType>Raw&lt;/postType>&lt;postContent>&amp;lt;Workflow_StartWorkflow&amp;gt;&#xd;&#xa;&#x9;&amp;lt;outputFormat&amp;gt;&amp;lt;/outputFormat&amp;gt;&#xd;&#xa;&#x9;&#x9;&amp;lt;options&amp;gt;&#xd;&#xa;&#x9;&#x9;&amp;lt;inputs&amp;gt;&#xd;&#xa;            &amp;lt;INP_OPERATION&amp;gt;xpath:{/workflow/inputs/INP_OPERATION}&amp;lt;/INP_OPERATION&amp;gt;&#xd;&#xa;            &amp;lt;INP_FILES&amp;gt;xpath:{/workflow/variables/VAR_UNC_FILE_JSON}&amp;lt;/INP_FILES&amp;gt;&#xd;&#xa;            &amp;lt;INP_DEST_PASSWORD&amp;gt;xpath:{/workflow/inputs/INP_DEST_PASSWORD}&amp;lt;/INP_DEST_PASSWORD&amp;gt;&#xd;&#xa;            &amp;lt;INP_DELETE_FILES_POST_BACKUP&amp;gt;xpath:{/workflow/inputs/INP_DELETE_FILES_POST_BACKUP}&amp;lt;/INP_DELETE_FILES_POST_BACKUP&amp;gt;&#xd;&#xa;            &amp;lt;INP_WAIT_FOR_JOBS&amp;gt;xpath:{/workflow/inputs/INP_WAIT_FOR_JOBS}&amp;lt;/INP_WAIT_FOR_JOBS&amp;gt;&#xd;&#xa;            &amp;lt;INP_DEST_USER&amp;gt;xpath:{/workflow/inputs/INP_DEST_USER}&amp;lt;/INP_DEST_USER&amp;gt;&#xd;&#xa;            &amp;lt;INP_CLIENT_ID&amp;gt;xpath:{/workflow/CommServDBQuery_1/resultSets/row/col}&amp;lt;/INP_CLIENT_ID&amp;gt;&#xd;&#xa;            &amp;lt;INP_DEST_LOC&amp;gt;xpath:{/workflow/inputs/INP_DEST_LOC}&amp;lt;/INP_DEST_LOC&amp;gt;&#xd;&#xa;            &amp;lt;INP_APP_NAME&amp;gt;Windows File System&amp;lt;/INP_APP_NAME&amp;gt;&#xd;&#xa;            &amp;lt;INP_SUB_CLIENT_NAME&amp;gt;xpath:{/workflow/inputs/INP_SUB_CLIENT_NAME}&amp;lt;/INP_SUB_CLIENT_NAME&amp;gt;&#xd;&#xa;            &amp;lt;INP_PROXY_CLIENT&amp;gt;xpath:{/workflow/inputs/INP_PROXY_CLIENT}&amp;lt;/INP_PROXY_CLIENT&amp;gt;&#xd;&#xa;            &amp;lt;INP_SECOND_APPROVAL&amp;gt;xpath:{/workflow/inputs/INP_SECOND_APPROVAL}&amp;lt;/INP_SECOND_APPROVAL&amp;gt;&#xd;&#xa;            &amp;lt;INP_INDEX_CONFIG&amp;gt;xpath:{/workflow/inputs/INP_INDEX_CONFIG}&amp;lt;/INP_INDEX_CONFIG&amp;gt;&#xd;&#xa;            &amp;lt;INP_RETENTION_DAYS&amp;gt;xpath:{/workflow/inputs/INP_RETENTION_DAYS}&amp;lt;/INP_RETENTION_DAYS&amp;gt;&#xd;&#xa;            &amp;lt;INP_RETENTION_MONTHS&amp;gt;xpath:{/workflow/inputs/INP_RETENTION_MONTHS}&amp;lt;/INP_RETENTION_MONTHS&amp;gt;&#xd;&#xa;            &amp;lt;INP_RETENTION_YEARS&amp;gt;xpath:{/workflow/inputs/INP_RETENTION_YEARS}&amp;lt;/INP_RETENTION_YEARS&amp;gt;&#xd;&#xa;            &amp;lt;INP_NO_OF_FILES_TO_PROCESS&amp;gt;xpath:{/workflow/inputs/INP_NO_OF_FILES_TO_PROCESS}&amp;lt;/INP_NO_OF_FILES_TO_PROCESS&amp;gt;&#xd;&#xa;            &amp;lt;INP_DELETE_FROM_BACKUP&amp;gt;xpath:{/workflow/inputs/INP_DELETE_FROM_BACKUP}&amp;lt;/INP_DELETE_FROM_BACKUP&amp;gt;&#xd;&#xa;&#x9;&#x9;&amp;lt;/inputs&amp;gt;&#xd;&#xa;&#x9;&amp;lt;/options&amp;gt;&#xd;&#xa;&#x9;&amp;lt;client&amp;gt;&#xd;&#xa;&#x9;&#x9;&amp;lt;clientName&amp;gt;xpath:{/workflow/system/workflowEngine/clientName}&amp;lt;/clientName&amp;gt;&#xd;&#xa;&#x9;&#x9;&amp;lt;clientId&amp;gt;xpath:{/workflow/system/workflowEngine/clientId}&amp;lt;/clientId&amp;gt;&#xd;&#xa;&#x9;&amp;lt;/client&amp;gt;&#xd;&#xa;&amp;lt;/Workflow_StartWorkflow&amp;gt;&lt;/postContent>&lt;postContentType>application/xml; charset=UTF-8&lt;/postContentType>&lt;headers>&lt;name>Authtoken&lt;/name>&lt;value>QSDKONLY xpath:{/workflow/system/token}&lt;/value>&lt;/headers>&lt;headers>&lt;name>Accept&lt;/name>&lt;value>application/xml&lt;/value>&lt;/headers>&lt;/request>&lt;/inputs>"/>

                                <transition activity="EnableLogging_2"

                                    commented="0" originalStyle=""

                                    points="" sourceX="326" sourceY="57"

                                    status="0"

                                    style="defaultEdge;dashed=0"

                                    targetX="461" targetY="86"

                                    transitionIndex="0" x="0" y="0"/>

                            </Activity>

                            <Activity commented="0"

                                continueOnFailure="1"

                                created="1523804800925"

                                description="retrieves a list of values from xml"

                                displayName="JobId" height="34"

                                interactive="0" jobMode="0"

                                maxRestarts="0" name="XPathQuery"

                                namespaceUri="commvault.cte.workflow.activities"

                                originalStyle="" skipAttempt="0"

                                style="label;image=commvault.cte.workflow.activities.XMLQueryActivity"

                                uniqueName="XPathQuery_2"

                                waitSetting="0" width="76" x="508" y="134">

                                <onExit language="1" script="logger.info(&quot;INFO: UNC files Workflow Request O/P Response : [&quot; + xpath:{/workflow/HttpClient_3/output} +&quot;]&quot;);&#xd;&#xa;logger.info(&quot;INFO: UNC files Workflow Request statusCode : [&quot; + xpath:{/workflow/HttpClient_3/statusCode} +&quot;]&quot;);&#xd;&#xa;logger.info(&quot;INFO: UNC files Workflow Request statusText : [&quot; + xpath:{/workflow/HttpClient_3/statusText} +&quot;]&quot;);&#xd;&#xa;&#xd;&#xa;if (xpath:{/workflow/HttpClient_3/statusCode} != 200)&#xd;&#xa;{&#xd;&#xa;    String message = &quot;&quot;;&#xd;&#xa;    message = &quot;UNC files Workflow failed to execute. Status Code recieved: &quot; + xpath:{/workflow/HttpClient_3/statusCode} + &quot;, Status text: &quot; + xpath:{/workflow/HttpClient_3/statusText} ;&#xd;&#xa;    workflow.setVariable(&quot;VAR_WORKFLOW_MESSAGE&quot;,message);&#xd;&#xa;    workflow.setVariable(&quot;VAR_WORKFLOW_STATUS&quot;,&quot;FAILED&quot;);&#xd;&#xa;    logger.info(&quot;INFO: VAR_WORKFLOW_MESSAGE [&quot;+ workflow.getVariable(&quot;VAR_WORKFLOW_MESSAGE&quot;) +&quot;]&quot;);&#xd;&#xa;    logger.info(&quot;INFO: VAR_WORKFLOW_STATUS [&quot;+ workflow.getVariable(&quot;VAR_WORKFLOW_STATUS&quot;) +&quot;]&quot;);&#xd;&#xa;}&#xd;&#xa;&#xd;&#xa;if (xpath:{/workflow/XPathQuery_2/result} == null || xpath:{/workflow/XPathQuery_2/result} == &quot;&quot;)&#xd;&#xa;{&#xd;&#xa;    logger.info(&quot;ERROR: Failed to get workflow job id for unc files&quot;);&#xd;&#xa;    message = &quot;Failed to get workflow job id for unc files &quot;;&#xd;&#xa;    workflow.setVariable(&quot;VAR_WORKFLOW_MESSAGE&quot;,message);&#xd;&#xa;    workflow.setVariable(&quot;VAR_WORKFLOW_STATUS&quot;,&quot;FAILED&quot;);&#xd;&#xa;    logger.info(&quot;INFO: VAR_WORKFLOW_MESSAGE [&quot;+ workflow.getVariable(&quot;VAR_WORKFLOW_MESSAGE&quot;) +&quot;]&quot;);&#xd;&#xa;    logger.info(&quot;INFO: VAR_WORKFLOW_STATUS [&quot;+ workflow.getVariable(&quot;VAR_WORKFLOW_STATUS&quot;) +&quot;]&quot;);&#xd;&#xa;}&#xd;&#xa;"/>

                                <inputs val="&lt;inputs>&lt;xml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/HttpClient_3/output}&lt;/xml>&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>/Workflow_StartWorkflowResponse/@jobId&lt;/xpath>&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;>Integer&lt;/outputType>&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/outputAsList>&lt;/inputs>"/>

                                <transition activity="AddToList_2"

                                    commented="0" originalStyle=""

                                    points="" sourceX="354" sourceY="53"

                                    status="0"

                                    style="defaultEdge;dashed=1"

                                    targetX="377" targetY="97"

                                    transitionIndex="0" x="0" y="0">

                                    <condition language="1" script="(xpath:{/workflow/XPathQuery_2/result} != null &amp;&amp; xpath:{/workflow/XPathQuery_2/result} != &quot;&quot;);"/>

                                </transition>

                            </Activity>

                            <Activity commented="0"

                                continueOnFailure="1"

                                created="1523804889303"

                                description="utility to add objects to a list"

                                displayName="Add to JobId list"

                                height="34" interactive="0" jobMode="0"

                                maxRestarts="0" name="AddToList"

                                namespaceUri="commvault.cte.workflow.activities"

                                originalStyle="" skipAttempt="0"

                                style="label;image=commvault.cte.workflow.activities.ListActivityAdd"

                                uniqueName="AddToList_2" waitSetting="0"

                                width="128" x="340" y="134">

                                <inputs val="&lt;inputs>&lt;addToList class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/VAR_WORKFLOW_JOBID_LIST}&lt;/addToList>&lt;itemToAdd class=&quot;java.lang.Object&quot; _list_=&quot;false&quot;>xpath:{/workflow/XPathQuery_2/result}&lt;/itemToAdd>&lt;/inputs>"/>

                                <transition

                                    activity="WaitForJobCompletion_3"

                                    commented="0" originalStyle=""

                                    points="" sourceX="374"

                                    sourceY="105" status="0"

                                    style="defaultEdge" targetX="350"

                                    targetY="152" transitionIndex="0"

                                    x="0" y="0">

                                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                                </transition>

                            </Activity>

                            <Activity commented="0"

                                continueOnFailure="1"

                                created="1523804910846"

                                description="waits until the list of jobs completes"

                                displayName="WaitForJobCompletion"

                                height="34" interactive="0" jobMode="0"

                                maxRestarts="0"

                                name="WaitForJobCompletion"

                                namespaceUri="commvault.cte.workflow.activities"

                                originalStyle="" skipAttempt="0"

                                style="label;image=commvault.cte.workflow.activities.WaitForJobCompletion"

                                uniqueName="WaitForJobCompletion_3"

                                waitSetting="0" width="162" x="146" y="133">

                                <inputs val="&lt;inputs>&lt;jobId class=&quot;java.lang.Integer&quot; _list_=&quot;true&quot;>xpath:{/workflow/XPathQuery_2/result}&lt;/jobId>&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

                            </Activity>

                            <Activity commented="0"

                                continueOnFailure="0"

                                created="1524580207431"

                                description="turns on all logging for the current job"

                                displayName="Enable&#xa;Logging"

                                height="34" interactive="0" jobMode="0"

                                name="EnableLogging"

                                namespaceUri="commvault.cte.workflow.activities"

                                originalStyle="" skipAttempt="0"

                                style="label;image=commvault.cte.workflow.activities.LoggingEnable"

                                uniqueName="EnableLogging_2"

                                waitSetting="0" width="87" x="469" y="40">

                                <inputs val="&lt;inputs />"/>

                                <transition activity="XPathQuery_2"

                                    commented="0" originalStyle=""

                                    points="" sourceX="490" sourceY="99"

                                    status="0"

                                    style="defaultEdge;dashed=0"

                                    targetX="609" targetY="66"

                                    transitionIndex="0" x="0" y="0"/>

                            </Activity>

                            <Activity commented="0"

                                continueOnFailure="0"

                                created="1524580231012"

                                description="turns off all logging, except for errors, for current job"

                                displayName="Disable&#xa;Logging"

                                height="34" interactive="0" jobMode="0"

                                name="DisableLogging"

                                namespaceUri="commvault.cte.workflow.activities"

                                originalStyle="" skipAttempt="0"

                                style="label;image=commvault.cte.workflow.activities.LoggingDisable"

                                uniqueName="DisableLogging_2"

                                waitSetting="0" width="82" x="166" y="40">

                                <inputs val="&lt;inputs />"/>

                                <transition activity="HttpClient_3"

                                    commented="0" originalStyle=""

                                    points="" sourceX="178"

                                    sourceY="112" status="0"

                                    style="defaultEdge" targetX="243"

                                    targetY="80" transitionIndex="0"

                                    x="0" y="0">

                                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                                </transition>

                            </Activity>

                            <Activity commented="0"

                                continueOnFailure="0"

                                created="1574276351110"

                                description="impersonates the user who created the workflow"

                                displayName="IC" height="22"

                                interactive="0" jobMode="0"

                                name="ImpersonateCreator"

                                namespaceUri="commvault.cte.workflow.activities"

                                originalStyle="" skipAttempt="0"

                                style="label;image=commvault.cte.workflow.activities.ImpersonateCreator"

                                uniqueName="ImpersonateCreator_1"

                                waitSetting="0" width="44" x="82" y="30">

                                <inputs val="&lt;inputs />"/>

                                <transition activity="CommServDBQuery_1"

                                    commented="0" originalStyle=""

                                    points="" sourceX="95" sourceY="56"

                                    status="0" style="defaultEdge"

                                    targetX="80" targetY="91"

                                    transitionIndex="0" x="0" y="0">

                                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                                </transition>

                            </Activity>

                            <Activity commented="0"

                                continueOnFailure="0"

                                created="1574276410291"

                                description="impersonates the user who executes the workflow"

                                displayName="IE" height="24"

                                interactive="0" jobMode="0"

                                name="ImpersonateExecutor"

                                namespaceUri="commvault.cte.workflow.activities"

                                originalStyle="" skipAttempt="0"

                                style="label;image=commvault.cte.workflow.activities.ImpersonateUser"

                                uniqueName="ImpersonateExecutor_1"

                                waitSetting="0" width="43" x="14" y="125">

                                <inputs val="&lt;inputs />"/>

                                <transition activity="Script_7"

                                    commented="0" originalStyle=""

                                    points="" sourceX="101"

                                    sourceY="129" status="0"

                                    style="defaultEdge" targetX="92"

                                    targetY="174" transitionIndex="0"

                                    x="0" y="0">

                                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                                </transition>

                            </Activity>

                        </superProcess>

                        <activitySchema>

                            <outputs name="outputs">

                                <children attribute="0"

                                    className="java.lang.String"

                                    controlType="0" defaultValue=""

                                    displayName="" hidden="0"

                                    inputType="java.lang.String"

                                    listType="0" name="VAR_DSID_LIST" type="{http://www.w3.org/2001/XMLSchema}string"/>

                            </outputs>

                            <inputs>

                                <children className="java.lang.String"

                                    inputType="java.lang.String"

                                    name="name" type="{http://www.w3.org/2001/XMLSchema}string"/>

                                <children className="java.lang.Object"

                                    inputType="java.lang.Object"

                                    name="values" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                                <children className="java.lang.Integer"

                                    defaultValue="1"

                                    inputType="java.lang.Integer"

                                    name="numberOfParallelExecutions" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                                <children className="java.lang.Boolean"

                                    defaultValue="false"

                                    inputType="java.lang.Boolean"

                                    name="continueOnFailure" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                            </inputs>

                        </activitySchema>

                    </Activity>

                    <Activity commented="0" continueOnFailure="0"

                        created="1524579998925"

                        description="turns off all logging, except for errors, for current job"

                        displayName="Disable&#xa;Logging" height="34"

                        interactive="0" jobMode="0"

                        name="DisableLogging"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=commvault.cte.workflow.activities.LoggingDisable"

                        uniqueName="DisableLogging_1" waitSetting="0"

                        width="90" x="138" y="97">

                        <inputs val="&lt;inputs />"/>

                        <transition activity="HttpClient_2"

                            commented="0" originalStyle="" points=""

                            sourceX="171" sourceY="137" status="0"

                            style="defaultEdge" targetX="287"

                            targetY="129" transitionIndex="0" x="0" y="0">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity commented="0" continueOnFailure="0"

                        created="1524580049605"

                        description="turns on all logging for the current job"

                        displayName="Enable&#xa;Logging" height="34"

                        interactive="0" jobMode="0" name="EnableLogging"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=commvault.cte.workflow.activities.LoggingEnable"

                        uniqueName="EnableLogging_1" waitSetting="0"

                        width="113" x="260" y="97">

                        <inputs val="&lt;inputs />"/>

                        <transition activity="XPathQuery_1"

                            commented="0" originalStyle="" points=""

                            sourceX="506" sourceY="116" status="0"

                            style="defaultEdge;dashed=1" targetX="295"

                            targetY="55" transitionIndex="0" x="0" y="0">

                            <condition language="1" script="(!xpath:{/workflow/variables/VAR_WORKFLOW_STATUS}.contains(&quot;FAILED&quot;));"/>

                        </transition>

                    </Activity>

                </superProcess>

                <activitySchema>

                    <outputs name="outputs">

                        <children attribute="0"

                            className="java.lang.Integer"

                            controlType="0" defaultValue=""

                            displayName="" hidden="0"

                            inputType="java.lang.Integer" listType="0"

                            name="VAR_RESPONSE_CLIENT_IDS" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                    </outputs>

                    <inputs>

                        <children className="java.lang.String"

                            inputType="java.lang.String" name="name" type="{http://www.w3.org/2001/XMLSchema}string"/>

                        <children className="java.lang.Object"

                            inputType="java.lang.Object" name="values" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                        <children className="java.lang.Integer"

                            defaultValue="1"

                            inputType="java.lang.Integer"

                            name="numberOfParallelExecutions" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                        <children className="java.lang.Boolean"

                            defaultValue="false"

                            inputType="java.lang.Boolean"

                            name="continueOnFailure" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                    </inputs>

                </activitySchema>

            </Activity>

        </superProcess>

        <activitySchema>

            <outputs name="outputs">

                <children className="java.lang.Object"

                    inputType="java.lang.Object" name="item" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

            </outputs>

            <inputs>

                <children className="java.lang.String"

                    inputType="java.lang.String" name="name" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children className="java.lang.Object"

                    inputType="java.lang.Object" name="values" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                <children className="java.lang.Integer" defaultValue="1"

                    inputType="java.lang.Integer"

                    name="numberOfParallelExecutions" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                <children className="java.lang.Boolean"

                    defaultValue="false" inputType="java.lang.Boolean"

                    name="continueOnFailure" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

            </inputs>

        </activitySchema>

        <transition activity="Delay_1" commented="0" originalStyle=""

            points="261.0,199.0" sourceX="574" sourceY="139" status="0"

            style="defaultEdge" targetX="207" targetY="176"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1521486218572"

        description="activity to execute code snippets in the selected language"

        displayName="Readme.txt" height="34" interactive="0" jobMode="0"

        name="Script" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.ScriptActivity"

        uniqueName="Script_2" waitSetting="0" width="100" x="129" y="42">

        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;/*&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;Bulk Operations Workflow Flow: &amp;#xD;&amp;#xA;-----------------------------&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;A) This workflow will execute the Search request and will get the &amp;#xD;&amp;#xA;total number of files need to be processed. &amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;B) A while loop is executed and total number of files that will be&amp;#xD;&amp;#xA;proccessed in each loop will be as defined in the input INP_NOOFDOCS&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;    1) Client Id list is created from the json response received &amp;#xD;&amp;#xA;    from this search request&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    2) For each client id a UNC Path JSon and a Local Path Json is created &amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    3) FileOperations workflow is executed for the local json and will&amp;#xD;&amp;#xA;    wait for workflow job to be over&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    4) Another loop is now run on the dsid list for the UNC files&amp;#xD;&amp;#xA;        - Client id is fetched for this dsid from database.&amp;#xD;&amp;#xA;        - Unc json is created for this dsid &amp;#xD;&amp;#xA;        - FileOperations workflow is now executed for each dsid &amp;#xD;&amp;#xA;        - Wait for this workflow job to complete&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;Exceptions handled: &amp;#xD;&amp;#xA;-------------------&amp;#xD;&amp;#xA;Bulk Workflow will stop execution if :&amp;#xD;&amp;#xA;    - Failed to create modified Handler search request.&amp;#xD;&amp;#xA;    - Failed to execute Handler Search Request.&amp;#xD;&amp;#xA;    - Failed to create client id list from search request json response.&amp;#xD;&amp;#xA;    - Failed to create number of files from search request json response.&amp;#xD;&amp;#xA;    - Failed to create input file LOCAL json for FileOperations workflow.&amp;#xD;&amp;#xA;    - Failed to execute the workflow FileOperations for Local files.&amp;#xD;&amp;#xA;    - Failed to get jobid for the Workflow FileOperations.&amp;#xD;&amp;#xA;    - Failed to create Json String for dsids.&amp;#xD;&amp;#xA;    - Failed to create input file UNC json for FileOperations workflow.&amp;#xD;&amp;#xA;    - Failed to execute the workflow FileOperations for UNC files.&amp;#xD;&amp;#xA;    - Failed to get jobid for the Workflow FileOperations.&amp;#xD;&amp;#xA;    - Failed to get client id from Database for DSID&amp;#xD;&amp;#xA;           &amp;#xD;&amp;#xA;*/&quot; />&lt;/inputs>"/>

        <transition activity="ForEach_1" commented="0" originalStyle=""

            points="295.0,58.0" sourceX="127" sourceY="144" status="0"

            style="defaultEdge" targetX="286" targetY="133"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1521492758977"

        description="activity to delay the workflow execution in minutes"

        displayName="Delay" height="34" interactive="0" jobMode="0"

        name="Delay" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.DelayActivity"

        uniqueName="Delay_1" waitSetting="0" width="100" x="130" y="180">

        <inputs val="&lt;inputs>&lt;delayLength class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>1&lt;/delayLength>&lt;delayInterval class=&quot;workflow.types.DelayInterval&quot; _list_=&quot;false&quot;>Seconds&lt;/delayInterval>&lt;/inputs>"/>

        <transition activity="Script_4" commented="0" originalStyle=""

            points="" sourceX="180" sourceY="197" status="0"

            style="defaultEdge;dashed=1" targetX="179" targetY="115"

            transitionIndex="0" x="-26" y="0">

            <condition language="1" script="(xpath:{/workflow/variables/VAR_NOOFFILES} > 0 &amp;&amp; xpath:{/workflow/variables/VAR_START_POSITION} &lt;= xpath:{/workflow/variables/VAR_NOOFFILES});"/>

        </transition>

        <transition activity="Script_8" commented="0" originalStyle=""

            points="178.0,231.0" sourceX="180" sourceY="197" status="0"

            style="defaultEdge;dashed=1" targetX="73" targetY="309"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="((xpath:{/workflow/variables/VAR_NOOFFILES} > 0 &amp;&amp; xpath:{/workflow/variables/VAR_START_POSITION} > xpath:{/workflow/variables/VAR_NOOFFILES}) || xpath:{/workflow/variables/VAR_WORKFLOW_STATUS}.contains(&quot;FAILED&quot;));"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1521493229331" description="Ends the workflow"

        displayName="WorkflowEnd" height="34" interactive="0"

        jobMode="0" name="WorkflowEnd"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.EndActivity;gradientColor=#FF9999"

        uniqueName="WorkflowEnd_1" waitSetting="0" width="135" x="130" y="463">

        <outputs outputs="&lt;outputs>&lt;JOBIDLIST class=&quot;java.lang.Integer&quot; _list_=&quot;true&quot;>xpath:{/workflow/variables/VAR_WORKFLOW_JOBID_LIST}&lt;/JOBIDLIST>&lt;/outputs>"/>

        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/VAR_WORKFLOW_STATUS}&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/VAR_WORKFLOW_MESSAGE}&lt;/failureMessage>&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1521493244427"

        description="activity to execute code snippets in the selected language"

        displayName="continue" height="34" interactive="0" jobMode="0"

        name="Script" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.ScriptActivity"

        uniqueName="Script_4" waitSetting="0" width="100" x="129" y="101">

        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;logger.info(&amp;quot;INFO: Start position [VAR_START_POSITION] : [&amp;quot;+xpath:{/workflow/variables/VAR_START_POSITION}+&amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;logger.info(&amp;quot;INFO: Number of files [VAR_NOOFILES] [&amp;quot;+xpath:{/workflow/variables/VAR_NOOFFILES}+&amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;logger.info(&amp;quot;INFO: Number of docs [INP_NOOFDOCS] [&amp;quot;+xpath:{/workflow/inputs/INP_NOOFDOCS}+&amp;quot;]&amp;quot;);&quot; />&lt;/inputs>"/>

        <transition activity="ForEach_1" commented="0" originalStyle=""

            points="346.0,115.0" sourceX="205" sourceY="118" status="0"

            style="defaultEdge" targetX="356" targetY="33"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1546984394075" description="performs http operations"

        displayName="Update task status" height="34" interactive="0"

        jobMode="0" name="HttpClient"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.HttpClientActivity"

        uniqueName="HttpClient_7" waitSetting="0" width="143" x="129" y="293">

        <inputs val="&lt;inputs>&lt;request>&lt;url>/SearchSvc/CVWebService.svc/EDiscoveryClient/ConfigureTask&lt;/url>&lt;method>POST&lt;/method>&lt;postType>Raw&lt;/postType>&lt;postContent>&amp;lt;WebReport_EDiscoveryCreateTaskReq&amp;gt;&#xd;&#xa;                                                                                &amp;lt;taskReq&amp;gt;&#xd;&#xa;                                                                                                &amp;lt;tasks&amp;gt;&#xd;&#xa;                                                                                                                &amp;lt;taskInfo taskId=&quot;xpath:{/workflow/inputs/INP_TASK_ID}&quot;/&amp;gt;   &#xd;&#xa;                                                                                                                &amp;lt;taskProps attrName=&quot;progress&quot;  attrVal=&quot;xpath:{/workflow/variables/VAR_TASK_STATUS}&quot;  /&amp;gt;&#xd;&#xa;                                                                                                &amp;lt;/tasks&amp;gt;&#xd;&#xa;                                                                                &amp;lt;/taskReq&amp;gt;&#xd;&#xa;                &amp;lt;/WebReport_EDiscoveryCreateTaskReq&amp;gt;&#xd;&#xa;&lt;/postContent>&lt;postContentType>application/xml; charset=UTF-8&lt;/postContentType>&lt;headers>&lt;name>Authtoken&lt;/name>&lt;value>QSDKONLY xpath:{/workflow/system/token}&lt;/value>&lt;/headers>&lt;headers>&lt;name>Accept&lt;/name>&lt;value>application/json&lt;/value>&lt;/headers>&lt;/request>&lt;/inputs>"/>

        <transition activity="CommServDBQuery_3" commented="0"

            originalStyle="" points="" sourceX="200" sourceY="310"

            status="0" style="defaultEdge" targetX="202" targetY="371"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1547048051058"

        description="activity to execute code snippets in the selected language"

        displayName="Valid Task id? " height="34" interactive="0"

        jobMode="0" name="Script"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.ScriptActivity"

        uniqueName="Script_8" waitSetting="0" width="112" x="130" y="236">

        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;String status = xpath:{/workflow/variables/VAR_WORKFLOW_STATUS};&amp;#xD;&amp;#xA;status = status.toString();&amp;#xD;&amp;#xA;if (status.contains(&amp;quot;FAILED&amp;quot;))&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;VAR_TASK_STATUS&amp;quot;,&amp;quot;CompletedWithErrors&amp;quot;);&amp;#xD;&amp;#xA;    logger.info(&amp;quot;INFO: VAR_TASK_STATUS [&amp;quot;+ workflow.getVariable(&amp;quot;VAR_TASK_STATUS&amp;quot;) +&amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;if (xpath:{/workflow/inputs/INP_TASK_ID} &amp;gt; 0)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    return true;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;else&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    return false;&amp;#xD;&amp;#xA;}&quot; />&lt;/inputs>"/>

        <transition activity="HttpClient_7" commented="0"

            originalStyle="" points="179.0,289.0" sourceX="73"

            sourceY="319" status="0" style="defaultEdge;dashed=1"

            targetX="203" targetY="274" transitionIndex="0" x="0" y="0">

            <condition language="1" script="(xpath:{/workflow/Script_8/output});"/>

        </transition>

        <transition activity="WorkflowEnd_1" commented="0"

            originalStyle="" points="106.0,316.0" sourceX="73"

            sourceY="319" status="0" style="defaultEdge;dashed=1"

            targetX="181" targetY="385" transitionIndex="0" x="0" y="0">

            <condition language="1" script="!(xpath:{/workflow/Script_8/output});"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1582134572177"

        description="executes queries against a commcell database"

        displayName="Audit" height="34" interactive="0" jobMode="0"

        name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.CommServDBQuery"

        uniqueName="CommServDBQuery_2" waitSetting="0" width="140"

        x="130" y="404">

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>EXEC EDiscoveryAuditOperation&amp;#xD;&#xd;&#xa;      @i_xmlText = N''&amp;lt;DM2ContentIndexing_DM2AuditOperation clientId=&quot;2&quot; userId=&quot;xpath:{/workflow/system/executor/userId}&quot; operationMsgId=&quot;596&quot;&amp;gt;&amp;lt;paramList paramMsgId=&quot;1612&quot;&amp;gt;&amp;lt;paramDatas val=&quot;xpath:{/workflow/inputs/INP_TASK_ID}&quot; /&amp;gt;&amp;lt;/paramList&amp;gt;&amp;lt;paramList paramMsgId=&quot;1613&quot;&amp;gt;&amp;lt;paramDatas val=&quot;xpath:{/workflow/CommServDBQuery_3/resultSets/row/col}&quot; /&amp;gt;&amp;lt;/paramList&amp;gt;&amp;lt;paramList paramMsgId=&quot;1614&quot;&amp;gt;&amp;lt;paramDatas val=&quot;xpath:{/workflow/variables/VAR_WORKFLOW_MESSAGE};&quot; /&amp;gt;&amp;lt;/paramList&amp;gt;&amp;lt;/DM2ContentIndexing_DM2AuditOperation&amp;gt;'',&amp;#xD;&#xd;&#xa;      @i_entityType = 9515,&amp;#xD;&#xd;&#xa;      @i_entityId = xpath:{/workflow/inputs/INP_TASK_ID}&lt;/query>&lt;/inputs>"/>

        <transition activity="WorkflowEnd_1" commented="0"

            originalStyle="" points="" sourceX="232" sourceY="366"

            status="0" style="defaultEdge" targetX="204" targetY="418"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1512764871518"

        description="executes queries against a commcell database"

        displayName="Get TaskName" height="28" interactive="0"

        jobMode="0" name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.CommServDBQuery"

        uniqueName="CommServDBQuery_3" waitSetting="0" width="142"

        x="129" y="348">

        <onExit language="1" script="if (xpath:{/workflow/variables/VAR_WORKFLOW_MESSAGE} == null || xpath:{/workflow/variables/VAR_WORKFLOW_MESSAGE} == &quot;&quot;)&#xd;&#xa;{&#xd;&#xa;    workflow.setVariable(&quot;VAR_WORKFLOW_MESSAGE&quot;, &quot;Successfully proccessed all files&quot;);&#xd;&#xa;    logger.info(&quot;INFO: VAR_WORKFLOW_MESSAGE [&quot;+ workflow.getVariable(&quot;VAR_WORKFLOW_MESSAGE&quot;) +&quot;]&quot;);&#xd;&#xa;}"/>

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>select taskSummary from ProfileTaskInfo WITH (NOLOCK) where taskId=xpath:{/workflow/inputs/INP_TASK_ID}&lt;/query>&lt;/inputs>"/>

        <transition activity="CommServDBQuery_2" commented="0"

            originalStyle="" points="" sourceX="192" sourceY="374"

            status="0" style="defaultEdge" targetX="194" targetY="420"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <formProperties css="" formVersion="0" javaScript="" pageMode="0">

        <rules/>

    </formProperties>

</workflow>

'

IF not exists (select * from WF_Definition where Name = @name)

BEGIN
	INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision)


	VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision)

	SET @workflowId = @@IDENTITY
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


	VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

	SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = ISNULL(revision, '') From WF_Definition WHERE Name = @name

	IF (@currentFlags & 6 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0) AND (@currentRevision <> @revision)

	BEGIN

		SET @version = @version + 1

		UPDATE WF_Definition

		SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision

		WHERE Name = @name

		IF (@currentFlags & 6 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0)

		BEGIN

			UPDATE WF_Definition

			SET flags = @flags

			WHERE Name = @name

		END
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


		VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

	END

END
