

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_ExecuteToolsRequest.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/WFD_ExecuteToolsRequest.script,v $ $Id: WFD_ExecuteToolsRequest.script,v 1.1.2.4 2020/10/04 00:51:17 abilbrey Exp $";
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER ON

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.1.2.4 $'

SET @name = 'Run Quick Access Tool'

SET @description = 'Workflow to execute tools request on remote clients'

SET @version = 1

SET @flags = 46

SET @definition = '<workflow apiMode="0" config="&lt;configuration /&gt;" description="Workflow to execute tools request on remote clients" inputs="&lt;inputs&gt;&lt;ToolName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;ExecutableName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;Parameters class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;StartUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;UserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;Password class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; /&gt;&lt;ShowOutputOnConsole class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/ShowOutputOnConsole&gt;&lt;ClientName class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;&gt;&lt;clientName /&gt;&lt;clientId /&gt;&lt;/ClientName&gt;&lt;/inputs&gt;" interactive="1" isHtmlDescription="0" name="Run Quick Access Tool" outputs="&lt;outputs /&gt;" revision="$Revision: 1.1.2.4 $" uniqueGuid="" variables="&lt;variables /&gt;" webHidden="1" workflowId="114">

  <schema>

    <inputs attribute="0" className="" name="inputs" type="">

      <children attribute="0" className="java.lang.String" controlHidden="0" controlType="0" defaultValue="" displayName="Tool" documentation="" hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="ToolName" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string" />

      <children attribute="0" className="java.lang.String" controlHidden="0" controlType="0" defaultValue="" displayName="Executable" documentation="" hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="ExecutableName" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string" />

      <children attribute="0" className="java.lang.String" controlHidden="0" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="Parameters" readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string" />

      <children attribute="0" className="java.lang.String" controlHidden="0" controlType="0" defaultValue="" displayName="StartUp Path" documentation="" hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="StartUpPath" readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string" />

      <children attribute="0" className="commvault.msgs.CvEntities.ClientEntity" controlHidden="0" controlType="2" defaultValue="" displayName="Client" documentation="" hidden="0" inputType="commvault.msgs.CvEntities.ClientEntity" listType="0" maximumValue="" minimumValue="" name="ClientName" readOnly="0" required="1" searchable="0" type="{commvault.msgs.CvEntities}ClientEntity">

        <children attribute="0" className="java.lang.String" defaultValue="" inputType="java.lang.String" listType="0" name="clientName" type="{http://www.w3.org/2001/XMLSchema}string" />

        <children attribute="0" className="java.lang.Integer" defaultValue="" inputType="java.lang.Integer" listType="0" name="clientId" type="{http://www.w3.org/2001/XMLSchema}integer" />

      </children>

      <children attribute="0" className="java.lang.String" controlHidden="0" controlType="0" defaultValue="" displayName="Username" documentation="" hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="UserName" readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string" />

      <children attribute="0" className="workflow.types.EncryptedString" controlHidden="0" controlType="0" defaultValue="" displayName="Password" documentation="" hidden="0" inputType="workflow.types.EncryptedString" listType="0" maximumValue="" minimumValue="" name="Password" readOnly="0" required="0" searchable="0" type="{workflow.types}EncryptedString" />

      <children alignment="0" attribute="0" className="java.lang.Boolean" controlHidden="0" controlType="5" defaultValue="" displayName="Show output on Commcell Console" documentation="" hidden="0" inputType="java.lang.Boolean" listType="0" maximumValue="" minimumValue="" name="ShowOutputOnConsole" readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}boolean" />

    </inputs>

    <variables className="" name="variables" type="" />

    <outputs className="" name="outputs" type="" />

    <config className="" name="configuration" type="" />

  </schema>

  <formProperties css="" javaScript="" />

  <Start commented="0" continueOnFailure="0" created="0" description="" displayName="Start" height="36" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="0" style="image;image=/images/jgraphx/house.png" uniqueName="Start_1" waitSetting="0" width="55" x="45" y="41">

    <inputs val="&lt;inputs /&gt;" />

    <transition activity="ExecuteCommand_1" commented="0" originalStyle="" points="" sourceX="72" sourceY="59" status="0" style="defaultEdge" targetX="289" targetY="72" transitionIndex="0" x="0" y="0">

      <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Start>

  <Activity commented="0" continueOnFailure="0" created="1489995201825" description="Execute a command on a remote machine" displayName="Execute Tool" height="34" interactive="0" jobMode="0" maxRestarts="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.ExecuteCommand" uniqueName="ExecuteCommand_1" waitSetting="0" width="134" x="212" y="55">

    <inputs val="&lt;inputs&gt;&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/inputs/ClientName}&lt;/client&gt;&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/inputs/UserName}&lt;/impersonateUserName&gt;&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/inputs/Password}&lt;/impersonateUserPassword&gt;&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/inputs/StartUpPath}&lt;/startUpPath&gt;&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/inputs/ExecutableName}&lt;/command&gt;&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/inputs/Parameters}&lt;/arguments&gt;&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/inputs/ShowOutputOnConsole}&lt;/waitForProcessCompletion&gt;&lt;/inputs&gt;" />

    <transition activity="Decision_1" commented="0" originalStyle="" points="" sourceX="279" sourceY="72" status="0" style="defaultEdge" targetX="355" targetY="193" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1489995211531" description="displays an informational message to the user" displayName="Display output" height="34" interactive="0" jobMode="0" name="InformationalMessage" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.InteractiveMessageActivity" uniqueName="InformationalMessage_1" waitSetting="0" width="157" x="682" y="78">

    <activitySchema>

      <inputs className="" defaultValue="" listType="0" name="inputs" type="" />

      <outputs className="" defaultValue="" listType="0" name="outputs" type="">

        <children attribute="0" className="java.lang.String" defaultValue="" hidden="0" inputType="java.lang.String" listType="0" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string" />

      </outputs>

    </activitySchema>

    <inputs val="&lt;inputs&gt;&lt;message&gt;Process Exit Code: xpath:{/workflow/ExecuteCommand_1/exitCode}&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;xpath:{/workflow/ExecuteCommand_1/commandOutput}&lt;/message&gt;&lt;dialogType&gt;Popup&lt;/dialogType&gt;&lt;iconType&gt;Information&lt;/iconType&gt;&lt;title&gt;Output for xpath:{/workflow/inputs/ToolName}&lt;/title&gt;&lt;html&gt;false&lt;/html&gt;&lt;formProperties /&gt;&lt;/inputs&gt;" />

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1490938368592" description="if/else based decision" displayName="Show output?" height="100" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1" uniqueName="Decision_1" waitSetting="0" width="108" x="422" y="21">

    <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/inputs/ShowOutputOnConsole}&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

    <transition activity="InformationalMessage_1" commented="0" displayName="Yes" originalStyle="" points="" sourceX="472" sourceY="71" status="0" style="defaultEdge" targetX="691" targetY="93" transitionIndex="0" value="true" x="0" y="0">

      <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

    <transition activity="EndUserSession_1" commented="0" displayName="No" originalStyle="" points="" sourceX="472" sourceY="71" status="0" style="defaultEdge" targetX="488" targetY="230" transitionIndex="0" value="false" x="0" y="0">

      <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1490938404881" description="ends the interactive user session" displayName="EndUserSession" height="34" interactive="0" jobMode="0" name="EndUserSession" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.InteractiveEndSessionActivity" uniqueName="EndUserSession_1" waitSetting="0" width="124" x="420" y="214">

    <inputs val="&lt;inputs /&gt;" />

  </Activity>

</workflow>'																																																						

IF not exists (select 1 from WF_Definition where Name = @name)

BEGIN
	INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision)


	VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision)

	SET @workflowId = SCOPE_IDENTITY()
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


	VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

	SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = ISNULL(revision, '') From WF_Definition WHERE Name = @name

	IF (@currentFlags & 4 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0) AND (@currentRevision <> @revision)

	BEGIN

		SET @version = @version + 1

		UPDATE WF_Definition

		SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision, flags = @flags

		WHERE Name = @name
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


		VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

	END

END

