

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_EarlyCaseAssessment.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/WFD_EarlyCaseAssessment.script,v $ $Id: WFD_EarlyCaseAssessment.script,v 1.1.2.2 2020/10/04 00:59:54 abilbrey Exp $";
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER ON

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @guid nvarchar(256)

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.1.2.2 $'

SET @name = 'Early Case Assessment'

SET @description = 'Workflow to send email to a group of people as part of early case assessment'

SET @version = 1

SET @flags = 30

SET @guid = 'b036be54-2f25-4903-8c9d-facf19ce4672'

SET @definition = '<workflow apiMode="0" config="&lt;configuration />"

    description=""

    inputs="&lt;inputs>&lt;sendEmailList class=&quot;java.lang.String&quot; _list_=&quot;true&quot; />&lt;optUrl class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;statusEmailAddr class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;customFromAddr class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/inputs>"

    interactive="1" isHtmlDescription="0" name="Early Case Assessment"

    outputs="&lt;outputs />" revision="$Revision: 1.1.2.2 $" uniqueGuid="b036be54-2f25-4903-8c9d-facf19ce4672"

    variables="&lt;variables>&lt;fromAddr class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;emailText class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>Hello,&amp;lt;br/&amp;gt; We request your response regarding the communication with any of our customers.&lt;/emailText>&lt;adminEmail class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;distributeList class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;userName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;executorEmail class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;invalidEmails class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;adminTrackingText class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/variables>"

    webHidden="0" workflowId="0">

    <schema>

        <outputs className="" name="outputs" type=""/>

        <variables attribute="0" className="" name="variables" type="">

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="fromAddr" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="emailText" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="adminEmail" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="distributeList" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="userName" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="executorEmail" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" hidden="0"

                inputType="java.lang.String" listType="0"

                name="invalidEmails" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" hidden="0"

                inputType="java.lang.String" listType="0"

                name="adminTrackingText" type="{http://www.w3.org/2001/XMLSchema}string"/>

        </variables>

        <inputs attribute="0" className="" name="inputs" type="">

            <children alignment="1" attribute="0"

                className="java.lang.String" controlHidden="0"

                controlType="1" defaultValue="" displayName="Email(s):"

                documentation="List of email addresses one per line"

                hidden="0" inputType="java.lang.String" listType="0"

                maximumValue="" minimumValue="" name="sendEmailList"

                readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children alignment="1" attribute="0"

                className="java.lang.String" controlHidden="0"

                controlType="0" defaultValue=""

                displayName="URL to include:" documentation=""

                hidden="0" inputType="java.lang.String" listType="0"

                maximumValue="" minimumValue="" name="optUrl"

                readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children alignment="1" attribute="0"

                className="java.lang.String" controlHidden="0"

                controlType="0" defaultValue=""

                displayName="Also Notify Email:" documentation=""

                hidden="0" inputType="java.lang.String" listType="0"

                maximumValue="" minimumValue="" name="statusEmailAddr"

                readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children alignment="1" attribute="0"

                className="java.lang.String" controlHidden="0"

                controlType="0" defaultValue=""

                displayName="Custom Email Sender:" documentation=""

                hidden="0" inputType="java.lang.String" listType="0"

                maximumValue="" minimumValue="" name="customFromAddr"

                readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

        </inputs>

        <config className="" name="configuration" type=""/>

    </schema>

    <Start commented="0" continueOnFailure="0" created="0"

        description="" displayName="Start" height="36" interactive="0"

        jobMode="0" name="Start" originalStyle="" skipAttempt="0"

        style="image;image=/images/jgraphx/house.png"

        uniqueName="Start_1" waitSetting="0" width="55" x="22" y="-6">

        <inputs val="&lt;inputs />"/>

        <transition activity="ImpersonateCreator_1" commented="0"

            originalStyle="" points="" sourceX="72" sourceY="59"

            status="0" style="defaultEdge" targetX="211" targetY="13"

            transitionIndex="0" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Start>

    <Activity commented="0" continueOnFailure="0"

        created="1493995293048"

        description="impersonates the user who created the workflow"

        displayName="ImpersonateCreator" height="20" interactive="0"

        jobMode="0" name="ImpersonateCreator"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.ImpersonateCreator"

        uniqueName="ImpersonateCreator_1" waitSetting="0" width="145"

        x="139" y="3">

        <inputs val="&lt;inputs />"/>

        <transition activity="GenericResponse_1" commented="0"

            originalStyle="" points="" sourceX="211" sourceY="13"

            status="0" style="defaultEdge" targetX="340" targetY="27"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1494016240664"

        description="creates a super process group"

        displayName="Catch Block" height="166" interactive="0"

        jobMode="0" name="ProcessBlock"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ProcessBlock_2" waitSetting="0" width="160" x="566" y="245">

        <inputs val="&lt;inputs>&lt;inputs />&lt;/inputs>"/>

        <superProcess>

            <Start commented="0" continueOnFailure="0"

                created="1494016240664" description=""

                displayName="Start" height="30" interactive="0"

                jobMode="0" name="Start" originalStyle=""

                skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_3" waitSetting="0" width="120" x="18" y="30">

                <inputs val="&lt;inputs />"/>

                <transition activity="Email_2" commented="0"

                    originalStyle="" points="" sourceX="78" sourceY="45"

                    status="0" style="defaultEdge" targetX="81"

                    targetY="113" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity commented="0" continueOnFailure="0"

                created="1494016293320"

                description="Sends an email to a list of users"

                displayName="Email" height="34" interactive="0"

                jobMode="0" name="Email"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.EmailActivity"

                uniqueName="Email_2" waitSetting="0" width="100" x="30" y="93">

                <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot; _list_=&quot;false&quot;>&lt;to class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/adminEmail}&lt;/to>&lt;cc class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;bcc class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;from class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/fromAddr}&lt;/from>&lt;subject class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>FAILURE : Early case assessment&lt;/subject>&lt;body class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&amp;lt;p&amp;gt;&#xd;&#xa;      We have noticed a failure in early case assessment response.&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      Please check the log files.&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      Thanks you.&#xd;&#xa;    &amp;lt;/p&amp;gt;&lt;/body>&lt;attachments class=&quot;java.lang.Object&quot; _list_=&quot;false&quot; />&lt;html class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/html>&lt;replyTo class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;repeatInterval class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;/email>&lt;/inputs>"/>

            </Activity>

        </superProcess>

        <activitySchema>

            <outputs className="" defaultValue="" listType="0"

                name="outputs" type=""/>

            <inputs className="" defaultValue="" listType="0"

                name="inputs" type=""/>

        </activitySchema>

        <transition activity="WorkflowEnd_2" commented="0"

            originalStyle="" points="" sourceX="646" sourceY="377"

            status="0" style="defaultEdge" targetX="800" targetY="370"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1494344955600"

        description="Sends an email to a list of users"

        displayName="Email" height="34" interactive="0" jobMode="0"

        name="Email" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.EmailActivity"

        uniqueName="Email_3" waitSetting="0" width="100" x="249" y="701">

        <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot; _list_=&quot;false&quot;>&lt;to class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/adminEmail}&lt;/to>&lt;cc class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;bcc class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;from class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/fromAddr}&lt;/from>&lt;subject class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>SUCCESS : Early case assessment&lt;/subject>&lt;body class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&amp;lt;p&amp;gt;&#xd;&#xa;      Status for early case assessment is shown below.&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      xpath:{/workflow/variables/adminTrackingText}&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      Thanks you.&#xd;&#xa;    &amp;lt;/p&amp;gt;&lt;/body>&lt;attachments class=&quot;java.lang.Object&quot; _list_=&quot;false&quot; />&lt;html class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/html>&lt;replyTo class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;repeatInterval class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;/email>&lt;/inputs>"/>

        <transition activity="WorkflowEnd_1" commented="0"

            originalStyle="" points="" sourceX="269" sourceY="585"

            status="0" style="defaultEdge" targetX="276" targetY="642"

            transitionIndex="0" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1494344989216" description="Ends the workflow"

        displayName="END" height="34" interactive="0" jobMode="0"

        name="WorkflowEnd"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.EndActivity;gradientColor=#00CC33"

        uniqueName="WorkflowEnd_1" waitSetting="0" width="69" x="226" y="777">

        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot; />&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1494345065450" description="Ends the workflow"

        displayName="END " height="34" interactive="0" jobMode="0"

        name="WorkflowEnd"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.EndActivity;gradientColor=#FF0000"

        uniqueName="WorkflowEnd_2" waitSetting="0" width="67" x="789" y="350">

        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot; />&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1494359240449"

        description="creates a super process group"

        displayName="ProcessBlock" height="573" interactive="0"

        jobMode="0" name="ProcessBlock"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ProcessBlock_3" waitSetting="0" width="424" x="25" y="74">

        <inputs val="&lt;inputs>&lt;inputs />&lt;/inputs>"/>

        <superProcess>

            <Start commented="0" continueOnFailure="0"

                created="1494359240449" description=""

                displayName="Start" height="17" interactive="0"

                jobMode="0" name="Start" originalStyle=""

                skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_4" waitSetting="0" width="59" x="16" y="77">

                <inputs val="&lt;inputs />"/>

                <transition activity="Script_4" commented="0"

                    originalStyle="" points="" sourceX="52" sourceY="46"

                    status="0" style="defaultEdge" targetX="111"

                    targetY="56" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity commented="0" continueOnFailure="0"

                created="1494008957583"

                description="if/else based decision"

                displayName="From given?" height="40" interactive="0"

                jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_1"

                waitSetting="0" width="100" x="162" y="155">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>(xpath:{/workflow/inputs/customFromAddr} != null) &amp;amp;&amp;amp; ( !xpath:{/workflow/inputs/customFromAddr}.isEmpty()  ) &lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="AssignValues_1" commented="0"

                    displayName="Yes" offsetX="27" offsetY="-2"

                    originalStyle="" points="318.0,210.0" sourceX="216"

                    sourceY="123" status="0" style="defaultEdge"

                    targetX="340" targetY="189" transitionIndex="0"

                    value="true" x="2" y="41">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="AssignValues_2" commented="0"

                    displayName="No" offsetX="-10" offsetY="-14"

                    originalStyle="" points="88.0,176.0" sourceX="212"

                    sourceY="175" status="0" style="defaultEdge"

                    targetX="109" targetY="225" transitionIndex="0"

                    value="false" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1494009116690"

                description="Updates process variables and inputs"

                displayName="AssignValues" height="15" interactive="0"

                jobMode="0" name="AssignValues"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.AssignValues"

                uniqueName="AssignValues_1" waitSetting="0" width="108"

                x="286" y="231">

                <outputs variables="&lt;variables>&lt;fromAddr class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/customFromAddr}&lt;/fromAddr>&lt;/variables>"/>

                <inputs val="&lt;inputs />"/>

                <transition activity="Decision_2" commented="0"

                    originalStyle="" points="312.0,235.0" sourceX="340"

                    sourceY="238" status="0" style="defaultEdge"

                    targetX="210" targetY="290" transitionIndex="0"

                    x="2" y="41">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1494015769024"

                description="Sends an email to a list of users"

                displayName="Email" height="16" interactive="0"

                jobMode="0" name="Email"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.EmailActivity"

                uniqueName="Email_1" waitSetting="0" width="163" x="122" y="438">

                <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot; _list_=&quot;false&quot;>&lt;to class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;cc class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;bcc class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/distributeList}&lt;/bcc>&lt;from class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/fromAddr}&lt;/from>&lt;subject class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>Early case assessment&lt;/subject>&lt;body class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&amp;lt;p&amp;gt;&#xd;&#xa;      xpath:{/workflow/variables/emailText}&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      Thanks you.&#xd;&#xa;    &amp;lt;/p&amp;gt;&lt;/body>&lt;attachments class=&quot;java.lang.Object&quot; _list_=&quot;false&quot; />&lt;html class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/html>&lt;replyTo class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;repeatInterval class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;/email>&lt;/inputs>"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1494348120292"

                description="activity to execute code snippets in the selected language"

                displayName="Format Emails List" height="16"

                interactive="0" jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.ScriptActivity"

                uniqueName="Script_3" waitSetting="0" width="135"

                x="156" y="96">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;import java.util.ArrayList;&amp;#xD;&amp;#xA;import java.util.List;&amp;#xD;&amp;#xA;import java.lang.Object.*;&amp;#xD;&amp;#xA;import java.util.regex.Matcher;&amp;#xD;&amp;#xA;import java.util.regex.Pattern;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;String emails = &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;String invalid = &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;String sendEmails = xpath:{/workflow/inputs/sendEmailList};&amp;#xD;&amp;#xA;String[] items = sendEmails.split(&amp;quot;\\s+|;|,&amp;quot;);&amp;#xD;&amp;#xA;String email_text = &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;Pattern VALID_EMAIL_ADDRESS_REGEX = &amp;#xD;&amp;#xA;    Pattern.compile(&amp;quot;^[A-Z0-9._%+-]+@[A-Z0-9.-]+\\.[A-Z]{2,6}$&amp;quot;, Pattern.CASE_INSENSITIVE);&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;logger.info(&amp;quot;Number of email recipient(s) : [ &amp;quot; + items.length +&amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    for(int i = 0; i &amp;lt; items.length; i++)&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        Matcher m = VALID_EMAIL_ADDRESS_REGEX .matcher(items[i].trim().toString());&amp;#xD;&amp;#xA;        if (m.find())&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            logger.info(&amp;quot;Valid email :[&amp;quot; + items[i].trim().toString() +&amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;            emails = emails + &amp;quot;;&amp;quot; + items[i].toString().trim();&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;        else{&amp;#xD;&amp;#xA;            invalid = invalid + &amp;quot;\n&amp;quot; + items[i].trim().toString();&amp;#xD;&amp;#xA;            logger.info(&amp;quot;Email :[&amp;quot; + items[i].trim().toString() +&amp;quot;] is invalid&amp;quot;);&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;distributeList&amp;quot;, emails);&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;invalidEmails&amp;quot;, invalid);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if(invalid != &amp;quot;&amp;quot;)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    email_text = email_text +System.getProperty(&amp;quot;line.separator&amp;quot;)+ &amp;quot;Below are emails are invalid:&amp;quot; + &amp;quot;\r\n&amp;quot; + invalid;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;if(emails != &amp;quot;&amp;quot;)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    email_text = email_text +System.getProperty(&amp;quot;line.separator&amp;quot;)+ &amp;quot;Below are emails are valid:&amp;quot; + &amp;quot;\r\n&amp;quot; + emails.replaceAll(&amp;quot;;&amp;quot;,&amp;quot;\r\n&amp;quot;);&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;adminTrackingText&amp;quot;, email_text);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;&quot; />&lt;/inputs>"/>

                <transition activity="Decision_1" commented="0"

                    originalStyle="" points="" sourceX="228"

                    sourceY="139" status="0" style="defaultEdge"

                    targetX="213" targetY="196" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1494015495879"

                description="activity to execute code snippets in the selected language"

                displayName="Format email text" height="25"

                interactive="0" jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.ScriptActivity"

                uniqueName="Script_1" waitSetting="0" width="129" x="87" y="348">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;String newline = System.getProperty(&amp;quot;line.separator&amp;quot;);&amp;#xD;&amp;#xA;String urlText = xpath:{/workflow/variables/emailText} + &amp;quot;Please click on the below link to respond:&amp;quot; ;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;emailText&amp;quot;, urlText + newline + xpath:{/workflow/inputs/optUrl}.trim());&amp;#xD;&amp;#xA;&quot; />&lt;/inputs>"/>

                <transition activity="Email_1" commented="0"

                    originalStyle="" points="" sourceX="151"

                    sourceY="360" status="0" style="defaultEdge"

                    targetX="169" targetY="446" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1494015355990"

                description="if/else based decision"

                displayName="URL given?" height="48" interactive="0"

                jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_2"

                waitSetting="0" width="100" x="160" y="266">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>(xpath:{/workflow/inputs/optUrl} != null) &amp;amp;&amp;amp; ( !xpath:{/workflow/inputs/optUrl}.trim().isEmpty()  )&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="Script_1" commented="0"

                    displayName="Yes" originalStyle="" points=""

                    sourceX="210" sourceY="290" status="0"

                    style="defaultEdge" targetX="151" targetY="360"

                    transitionIndex="0" value="true" x="2" y="41">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="Email_1" commented="0"

                    displayName="No" originalStyle=""

                    points="245.0,379.0" sourceX="210" sourceY="290"

                    status="0" style="defaultEdge" targetX="234"

                    targetY="444" transitionIndex="0" value="false"

                    x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1494941367512"

                description="activity to execute code snippets in the selected language"

                displayName="Script" height="22" interactive="0"

                jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.ScriptActivity"

                uniqueName="Script_4" waitSetting="0" width="100" x="35" y="36">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;&amp;#xD;&amp;#xA;String user = xpath:{/workflow/system/executor/userName};&amp;#xD;&amp;#xA;String[] login = user.split(&amp;quot;\\\\&amp;quot;);&amp;#xD;&amp;#xA;String username = user;&amp;#xD;&amp;#xA;if (login.length &amp;gt;= 2)&amp;#xD;&amp;#xA;     username = login[1];&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;userName&amp;quot;, username);&quot; />&lt;/inputs>"/>

                <transition activity="CommServDBQuery_6" commented="0"

                    originalStyle="" points="" sourceX="85" sourceY="47"

                    status="0" style="defaultEdge" targetX="175"

                    targetY="54" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1494941481732"

                description="executes queries against a commcell database"

                displayName="Get Executor Email" height="20"

                interactive="0" jobMode="0" name="CommServDBQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.CommServDBQuery"

                uniqueName="CommServDBQuery_6" waitSetting="0"

                width="143" x="155" y="39">

                <onExit language="1" script="String email = xpath:{/workflow/CommServDBQuery_6/resultSets[1]/row[1]/col[1]};&#xd;&#xa;&#xd;&#xa;workflow.setVariable(&quot;executorEmail&quot;, email);&#xd;&#xa;&#xd;&#xa;logger.info(&quot;Logged in user email: &quot; + email );&#xd;&#xa;&#xd;&#xa;workflow.setVariable(&quot;adminEmail&quot;, email);&#xd;&#xa;&#xd;&#xa;if(xpath:{/workflow/inputs/statusEmailAddr} != null &amp;&amp; !xpath:{/workflow/inputs/statusEmailAddr}.isEmpty())&#xd;&#xa;{&#xd;&#xa;   workflow.setVariable(&quot;adminEmail&quot;, xpath:{/workflow/inputs/statusEmailAddr}.trim()); &#xd;&#xa;}&#xd;&#xa;&#xd;&#xa;"/>

                <inputs val="&lt;inputs>&lt;commCell />&lt;query>select email from UMUsers where id = xpath:{/workflow/system/executor/userId};&lt;/query>&lt;/inputs>"/>

                <transition activity="Script_3" commented="0"

                    originalStyle="" points="" sourceX="226"

                    sourceY="49" status="0" style="defaultEdge"

                    targetX="222" targetY="138" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1494945131318"

                description="Updates process variables and inputs"

                displayName="Use logged in email" height="20"

                interactive="0" jobMode="0" name="AssignValues"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.AssignValues"

                uniqueName="AssignValues_2" waitSetting="0" width="140"

                x="54" y="209">

                <outputs variables="&lt;variables>&lt;fromAddr class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/executorEmail}&lt;/fromAddr>&lt;/variables>"/>

                <inputs val="&lt;inputs />"/>

                <transition activity="Decision_2" commented="0"

                    originalStyle="" points="110.0,289.0" sourceX="108"

                    sourceY="226" status="0" style="defaultEdge"

                    targetX="175" targetY="295" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

        </superProcess>

        <activitySchema>

            <outputs className="" defaultValue="" listType="0"

                name="outputs" type=""/>

            <inputs className="" defaultValue="" listType="0"

                name="inputs" type=""/>

        </activitySchema>

        <transition activity="ProcessBlock_2" commented="0"

            displayName="FAIL" originalStyle="" points="" sourceX="250"

            sourceY="290" status="2" style="defaultEdge" targetX="576"

            targetY="268" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="Email_3" commented="0"

            displayName="SUCCESS" originalStyle="" points=""

            sourceX="250" sourceY="290" status="1" style="defaultEdge"

            targetX="276" targetY="566" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1494945656191"

        description="returns a message to the caller of the workflow"

        displayName="RespondToCaller" height="34" interactive="0"

        jobMode="0" name="GenericResponse"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.GenericResponse"

        uniqueName="GenericResponse_1" waitSetting="0" width="127"

        x="332" y="6">

        <inputs val="&lt;inputs>&lt;errorCode class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>0&lt;/errorCode>&lt;errorMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/inputs>"/>

        <transition activity="ProcessBlock_3" commented="0"

            originalStyle="" points="" sourceX="395" sourceY="23"

            status="0" style="defaultEdge" targetX="376" targetY="80"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <formProperties css="" javaScript="var re = new RegExp( /^[a-zA-Z0-9.!#$%&amp;''*+/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)+$/);&#xd;&#xa;&#xd;&#xa;$(&quot;#okButton&quot;).click(function(event) {&#xd;&#xa;    var str = $(&quot;#statusEmailAddr&quot;).val();&#xd;&#xa;    var focusSet = false;&#xd;&#xa;    var isValid = true;&#xd;&#xa;    if (($(&quot;#statusEmailAddr&quot;).val() != &quot;&quot;)) {&#xd;&#xa;     if( (!re.test(str))){&#xd;&#xa;        if ($(&quot;.error&quot;).val().length == 0) // only add if not added&#xd;&#xa;             {&#xd;&#xa;                 $(&quot;.error&quot;).text(&quot;Please provide an email address.&quot;);&#xd;&#xa;                 isValid = false; &#xd;&#xa;             }&#xd;&#xa;        }&#xd;&#xa;      &#xd;&#xa;      else {&#xd;&#xa;              $(&quot;.error&quot;).text(&quot;&quot;); // remove it&#xd;&#xa;          }&#xd;&#xa;&#x9;}&#xd;&#xa;      if(isValid == false){&#xd;&#xa;                          event.stopImmediatePropagation();&#xd;&#xa;                          } &#xd;&#xa;          });&#xd;&#xa;"/>

</workflow>'

IF not exists (select * from WF_Definition where Name = @name)

BEGIN
	INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision)


	VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision)

	SET @workflowId = @@IDENTITY
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


	VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

	SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = ISNULL(revision, '') From WF_Definition WHERE Name = @name

	IF (@currentFlags & 4 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0) AND (@currentRevision <> @revision)

	BEGIN

		SET @version = @version + 1

		UPDATE WF_Definition

		SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision

		WHERE Name = @name

		IF (@flags & 8 > 0 OR @flags & 16 > 0)

		BEGIN

			UPDATE WF_Definition

			SET flags = @flags

			WHERE Name = @name

		END
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


		VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

	END

END

