

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_DemoServiceNowCreateIncident.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/WFD_DemoServiceNowCreateIncident.script,v $ $Id: WFD_DemoServiceNowCreateIncident.script,v 1.2.2.2 2020/10/04 00:50:35 abilbrey Exp $";
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER ON

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.2.2.2 $'

SET @name = 'Demo_ServiceNowCreateIncident'

SET @description = 'Create incident on ServiceNow in case of restore job failure'

SET @version = 1

SET @flags = 7

SET @definition = '<workflow apiMode="1" description="Create incident on ServiceNow in case of restore job failure" inputs="&lt;inputs&gt;&lt;AlertName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;AlertType class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;CommCell class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;DetectedCriteria class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;DetectedTime class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;User class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;JobID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;Status class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;StartTime class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;EndTime class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;ErrorCode class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;FailureReason class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;BackupSet class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/inputs&gt;" interactive="0" isHtmlDescription="0" name="Demo_ServiceNowCreateIncident" outputs="&lt;outputs /&gt;" revision="$Revision: 1.2.2.2 $" uniqueGuid="6864e1c1-53ac-4210-a321-7e657f54bf4d" variables="&lt;variables /&gt;" workflowId="34">

  <Activity commented="0" continueOnFailure="0" created="1434562207873" description="Login to ServiceNow and obtain oauth token OR Renew oauth token" displayName="Login to ServiceNow" height="34" interactive="0" name="ServiceNowLogin" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=ServiceNowLogin" uniqueName="ServiceNowLogin_1" waitSetting="0" width="156" x="114" y="78">

    <inputs val="&lt;inputs&gt;&lt;username class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;&lt;/username&gt;&lt;password class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot;&gt;&lt;/password&gt;&lt;clientId class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;&lt;/clientId&gt;&lt;clientSecret class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot;&gt;&lt;/clientSecret&gt;&lt;refreshTokenRequest class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/refreshTokenRequest&gt;&lt;refreshToken class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;EndPointURL class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;&lt;/EndPointURL&gt;&lt;/inputs&gt;" />

    <transition activity="ServiceNowQueryRows_1" commented="0" displayName="Login Successful" offsetX="11" offsetY="2" originalStyle="" points="" sourceX="192" sourceY="95" status="1" style="defaultEdge" targetX="520" targetY="95" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

    <transition activity="WorkflowEnd_1" commented="0" displayName="Login Failed" originalStyle="" points="296.0,166.0" sourceX="300" sourceY="95" status="2" style="defaultEdge" targetX="724" targetY="237" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1434562234942" description="Fetch records from ServiceNow" displayName="Get Simpana ID on ServiceNow" height="34" interactive="0" name="ServiceNowQueryRows" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=ServiceNowQueryRows" uniqueName="ServiceNowQueryRows_1" waitSetting="0" width="215" x="413" y="78">

    <inputs val="&lt;inputs&gt;&lt;displayLimit class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;10&lt;/displayLimit&gt;&lt;filterQuery class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;name=Simpana&lt;/filterQuery&gt;&lt;displayValue class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;true&lt;/displayValue&gt;&lt;displayFields class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;sys_id&lt;/displayFields&gt;&lt;authToken class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/ServiceNowLogin_1/authToken}&lt;/authToken&gt;&lt;tableName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;cmdb_ci&lt;/tableName&gt;&lt;EndPointURL class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/ServiceNowLogin_1/EndPointURL}&lt;/EndPointURL&gt;&lt;/inputs&gt;" />

    <transition activity="Decision_1" commented="0" originalStyle="" points="" sourceX="520" sourceY="95" status="0" style="defaultEdge" targetX="719" targetY="95" transitionIndex="0" x="94" y="1">

      <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1434562261218" description="if/else based decision" displayName="Does ID exists ?" height="100" interactive="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1" uniqueName="Decision_1" waitSetting="0" width="121" x="659" y="45">

    <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/ServiceNowQueryRows_1/rows/rowCount} == 1&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

    <transition activity="ServiceNowQueryRows_2" commented="0" displayName="Yes" originalStyle="" points="" sourceX="719" sourceY="95" status="0" style="defaultEdge" targetX="936" targetY="95" transitionIndex="0" value="true" x="94" y="1">

      <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

    <transition activity="WorkflowEnd_1" commented="0" displayName="No" originalStyle="" points="720.0,179.0" sourceX="709" sourceY="95" status="0" style="defaultEdge" targetX="708" targetY="238" transitionIndex="0" value="false" x="0" y="0">

      <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1434562285733" description="Fetch records from ServiceNow" displayName="Get CVWorkflow Caller ID" height="34" interactive="0" name="ServiceNowQueryRows" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=ServiceNowQueryRows" uniqueName="ServiceNowQueryRows_2" waitSetting="0" width="185" x="844" y="78">

    <inputs val="&lt;inputs&gt;&lt;displayLimit class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;10&lt;/displayLimit&gt;&lt;filterQuery class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;last_name=cvworkflow&lt;/filterQuery&gt;&lt;displayValue class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;true&lt;/displayValue&gt;&lt;displayFields class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;sys_id&lt;/displayFields&gt;&lt;authToken class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/ServiceNowLogin_1/authToken}&lt;/authToken&gt;&lt;tableName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;sys_user&lt;/tableName&gt;&lt;EndPointURL class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/ServiceNowLogin_1/EndPointURL}&lt;/EndPointURL&gt;&lt;/inputs&gt;" />

    <transition activity="Decision_2" commented="0" originalStyle="" points="" sourceX="926" sourceY="95" status="0" style="defaultEdge" targetX="1146" targetY="133" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1434562342540" description="if/else based decision" displayName="Does ID exists?" height="100" interactive="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1" uniqueName="Decision_2" waitSetting="0" width="118" x="1071" y="45">

    <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/ServiceNowQueryRows_2/rows/rowCount} == 1&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

    <transition activity="Script_1" commented="0" displayName="Yes" originalStyle="" points="" sourceX="1130" sourceY="95" status="0" style="defaultEdge" targetX="1314" targetY="95" transitionIndex="0" value="true" x="90" y="13">

      <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

    <transition activity="WorkflowEnd_1" commented="0" displayName="No" offsetX="181" offsetY="3" originalStyle="" points="1130.0,180.0" sourceX="1121" sourceY="95" status="0" style="defaultEdge" targetX="743" targetY="234" transitionIndex="0" value="false" x="0" y="0">

      <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1434562521922" description="activity to execute code snippets in the selected language" displayName="Script" height="34" interactive="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=Script" uniqueName="Script_1" waitSetting="0" width="100" x="1271" y="77">

    <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;//generate comments&amp;#xD;&amp;#xA;String message = xpath:{/workflow/inputs/AlertName}+&amp;quot;\n--------------------\n\tCommCell:&amp;quot;+xpath:{/workflow/inputs/CommCell}+&amp;quot;\n\tType:&amp;quot;+xpath:{/workflow/inputs/AlertType}+&amp;quot;\n\tDetect Criteria:&amp;quot;+xpath:{/workflow/inputs/DetectedCriteria};&amp;#xD;&amp;#xA;message += &amp;quot;\n\tDetected Time:&amp;quot;+xpath:{/workflow/inputs/DetectedTime}+&amp;quot;\n--------------------\n\t\tUser:&amp;quot;+xpath:{/workflow/inputs/User}+&amp;quot;\n\t\tJob ID:&amp;quot;+xpath:{/workflow/inputs/JobID}+&amp;quot;\n\t\tStatus:&amp;quot;+xpath:{/workflow/inputs/Status};&amp;#xD;&amp;#xA;message += &amp;quot;\n\t\tBackup Set Name:&amp;quot;+xpath:{/workflow/inputs/BackupSet}+&amp;quot;\n\t\tStart Time:&amp;quot;+xpath:{/workflow/inputs/StartTime}+&amp;quot;\n\t\tEnd Time:&amp;quot;+xpath:{/workflow/inputs/EndTime}+&amp;quot;\n\t\tError Code:&amp;quot;+xpath:{/workflow/inputs/ErrorCode}+&amp;quot;\n\t\tFailure Reason:&amp;quot;+xpath:{/workflow/inputs/FailureReason}+&amp;quot;\n&amp;quot;;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;return message;&quot; /&gt;&lt;/inputs&gt;" />

    <transition activity="ServiceNowAddRow_4" commented="0" originalStyle="" points="" sourceX="1321" sourceY="94" status="0" style="defaultEdge" targetX="1305" targetY="240" transitionIndex="0" x="0" y="0">

      <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1434562551071" description="Ends the workflow" displayName="Stop" height="34" interactive="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=WorkflowEnd" uniqueName="WorkflowEnd_1" waitSetting="0" width="106" x="661" y="223">

    <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot; /&gt;&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/inputs&gt;" />

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1434726375366" description="Create new record on ServiceNow for a given table" displayName="ServiceNowAddRow" height="34" interactive="0" name="ServiceNowAddRow" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=ServiceNowAddRow" uniqueName="ServiceNowAddRow_4" waitSetting="0" width="145" x="1233" y="223">

    <inputs val="&lt;inputs&gt;&lt;fields class=&quot;workflow.types.NameValue&quot; _list_=&quot;true&quot;&gt;&lt;name class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;caller_id&lt;/name&gt;&lt;value class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/ServiceNowQueryRows_2/rows/row[1]/col[1]}&lt;/value&gt;&lt;/fields&gt;&lt;authToken class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/ServiceNowLogin_1/authToken}&lt;/authToken&gt;&lt;tableName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;incident&lt;/tableName&gt;&lt;EndPointURL class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/ServiceNowLogin_1/EndPointURL}&lt;/EndPointURL&gt;&lt;fields class=&quot;workflow.types.NameValue&quot; _list_=&quot;true&quot;&gt;&lt;name class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;short_description&lt;/name&gt;&lt;value class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;Simpana restore job failed or completed with errors.&lt;/value&gt;&lt;/fields&gt;&lt;fields class=&quot;workflow.types.NameValue&quot; _list_=&quot;true&quot;&gt;&lt;name class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;category&lt;/name&gt;&lt;value class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;inquiry&lt;/value&gt;&lt;/fields&gt;&lt;fields class=&quot;workflow.types.NameValue&quot; _list_=&quot;true&quot;&gt;&lt;name class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;contact_type&lt;/name&gt;&lt;value class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;self-service&lt;/value&gt;&lt;/fields&gt;&lt;fields class=&quot;workflow.types.NameValue&quot; _list_=&quot;true&quot;&gt;&lt;name class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;subcategory&lt;/name&gt;&lt;value class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;internal application&lt;/value&gt;&lt;/fields&gt;&lt;fields class=&quot;workflow.types.NameValue&quot; _list_=&quot;true&quot;&gt;&lt;name class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;sys_created_by&lt;/name&gt;&lt;value class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;cvworkflow&lt;/value&gt;&lt;/fields&gt;&lt;fields class=&quot;workflow.types.NameValue&quot; _list_=&quot;true&quot;&gt;&lt;name class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;opened_by&lt;/name&gt;&lt;value class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/ServiceNowQueryRows_2/rows/row[1]/col[1]}&lt;/value&gt;&lt;/fields&gt;&lt;fields class=&quot;workflow.types.NameValue&quot; _list_=&quot;true&quot;&gt;&lt;name class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;cmdb_ci&lt;/name&gt;&lt;value class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/ServiceNowQueryRows_1/rows/row[1]/col[1]}&lt;/value&gt;&lt;/fields&gt;&lt;fields class=&quot;workflow.types.NameValue&quot; _list_=&quot;true&quot;&gt;&lt;name class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;impact&lt;/name&gt;&lt;value class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;1&lt;/value&gt;&lt;/fields&gt;&lt;fields class=&quot;workflow.types.NameValue&quot; _list_=&quot;true&quot;&gt;&lt;name class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;urgency&lt;/name&gt;&lt;value class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;2&lt;/value&gt;&lt;/fields&gt;&lt;fields class=&quot;workflow.types.NameValue&quot; _list_=&quot;true&quot;&gt;&lt;name class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;state&lt;/name&gt;&lt;value class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;1&lt;/value&gt;&lt;/fields&gt;&lt;fields class=&quot;workflow.types.NameValue&quot; _list_=&quot;true&quot;&gt;&lt;name class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;comments&lt;/name&gt;&lt;value class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Script_1/output}&lt;/value&gt;&lt;/fields&gt;&lt;/inputs&gt;" />

    <transition activity="WorkflowEnd_1" commented="0" originalStyle="" points="" sourceX="1319" sourceY="242" status="0" style="defaultEdge" targetX="722" targetY="239" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Start commented="0" continueOnFailure="0" created="0" description="" displayName="Start" height="36" interactive="0" name="Start" originalStyle="" skipAttempt="0" style="image;image=/images/jgraphx/house.png" uniqueName="Start_1" waitSetting="0" width="55" x="22" y="77">

    <inputs val="&lt;inputs /&gt;" />

    <transition activity="ServiceNowLogin_1" commented="0" originalStyle="" points="" sourceX="49" sourceY="95" status="0" style="defaultEdge" targetX="192" targetY="95" transitionIndex="0" x="90" y="13">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Start>

  <schema>

    <inputs className="" name="inputs" type="">

      <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="AlertName" type="{http://www.w3.org/2001/XMLSchema}string" />

      <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" hidden="0" inputType="java.lang.String" listType="0" name="AlertType" type="{http://www.w3.org/2001/XMLSchema}string" />

      <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" hidden="0" inputType="java.lang.String" listType="0" name="CommCell" type="{http://www.w3.org/2001/XMLSchema}string" />

      <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="DetectedCriteria" type="{http://www.w3.org/2001/XMLSchema}string" />

      <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" hidden="0" inputType="java.lang.String" listType="0" name="DetectedTime" type="{http://www.w3.org/2001/XMLSchema}string" />

      <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" hidden="0" inputType="java.lang.String" listType="0" name="User" type="{http://www.w3.org/2001/XMLSchema}string" />

      <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="JobID" type="{http://www.w3.org/2001/XMLSchema}string" />

      <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" hidden="0" inputType="java.lang.String" listType="0" name="Status" type="{http://www.w3.org/2001/XMLSchema}string" />

      <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" hidden="0" inputType="java.lang.String" listType="0" name="StartTime" type="{http://www.w3.org/2001/XMLSchema}string" />

      <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" hidden="0" inputType="java.lang.String" listType="0" name="EndTime" type="{http://www.w3.org/2001/XMLSchema}string" />

      <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" hidden="0" inputType="java.lang.String" listType="0" name="ErrorCode" type="{http://www.w3.org/2001/XMLSchema}string" />

      <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" hidden="0" inputType="java.lang.String" listType="0" name="FailureReason" type="{http://www.w3.org/2001/XMLSchema}string" />

      <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" hidden="0" inputType="java.lang.String" listType="0" name="BackupSet" type="{http://www.w3.org/2001/XMLSchema}string" />

    </inputs>

    <outputs className="" name="outputs" type="" />

    <variables className="" name="variables" type="" />

  </schema>

</workflow>'

IF not exists (select * from WF_Definition where Name = @name)

BEGIN
	INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision)


	VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision)

	SET @workflowId = @@IDENTITY
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


	VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

	SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = ISNULL(revision, '') From WF_Definition WHERE Name = @name

	IF (@currentFlags & 4 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0) AND (@currentRevision <> @revision)

	BEGIN

		SET @version = @version + 1

		UPDATE WF_Definition

		SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision

		WHERE Name = @name

		IF (@flags & 8 > 0 OR @flags & 16 > 0)

		BEGIN

			UPDATE WF_Definition

			SET flags = @flags

			WHERE Name = @name

		END
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


		VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

	END

END

