

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_DemoNewMachineRequest.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/WFD_DemoNewMachineRequest.script,v $ $Id: WFD_DemoNewMachineRequest.script,v 1.5.2.1 2020/10/04 00:54:31 abilbrey Exp $";
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER ON

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.5.2.1 $'

SET @name = 'Demo - New Machine Request'

SET @description = 'Request a new machine'

SET @version = 1

SET @flags = 6

SET @definition = '<workflow apiMode="0" description="Request a new machine"

    inputs="&lt;inputs>&lt;Memory class=&quot;java.lang.Integer&quot;>16&lt;/Memory>&lt;Disk class=&quot;java.lang.Integer&quot;>500&lt;/Disk>&lt;software class=&quot;java.lang.String&quot; _list_=&quot;true&quot; />&lt;name class=&quot;java.lang.String&quot; />&lt;/inputs>"

    interactive="1" name="Demo - New Machine Request"

    outputs="&lt;outputs />" variables="&lt;variables />" workflowId="0">

    <Start breakpoint="0" commented="0" continueOnFailure="0"

        created="0" description="" displayName="Start" height="36"

        interactive="0" name="Start" originalStyle="" skipAttempt="0"

        style="image;image=/images/jgraphx/house.png"

        uniqueName="Start_1" waitSetting="0" width="61" x="209" y="1">

        <inputs val="&lt;inputs />"/>

        <transition activity="IsNameValid" commented="0"

            originalStyle="" points="" sourceX="229" sourceY="20"

            status="0" style="defaultEdge" targetX="234" targetY="120"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Start>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1377278253593"

        description="Sends an email to a list of users"

        displayName="Approved Email" height="34" interactive="0"

        name="Email" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Email"

        uniqueName="ApprovedEmail" waitSetting="0" width="133" x="770" y="567">

        <inputs val="&lt;inputs>&lt;email>&lt;from />&lt;to>xpath:{/workflow/system/executor}&lt;/to>&lt;cc />&lt;bcc />&lt;subject>Your machine was approved by xpath:{/workflow/GetApproval/completedBy/userName}&lt;/subject>&lt;attachments />&lt;body>&amp;lt;div&amp;gt;&#xd;&#xa;      Your machine request was &amp;lt;font color=&quot;#009933&quot;&amp;gt;approved &amp;lt;/font&amp;gt;by &#xd;&#xa;      xpath:{/workflow/GetApproval/completedBy/userName}&#xd;&#xa;    &amp;lt;/div&amp;gt;&#xd;&#xa;    &amp;lt;div&amp;gt;&#xd;&#xa;      &amp;lt;br&amp;gt;&#xd;&#xa;      Machine Name: xpath:{/workflow/GetApproval/name}&amp;lt;br&amp;gt;Memory: &#xd;&#xa;      xpath:{/workflow/GetApproval/memory}&amp;lt;br&amp;gt;Disk: &#xd;&#xa;      xpath:{/workflow/GetApproval/disk}&amp;lt;br&amp;gt;Additional Software: &#xd;&#xa;      xpath:{/workflow/GetApproval/software}&amp;lt;br&amp;gt;&#xd;&#xa;    &amp;lt;/div&amp;gt;&lt;/body>&lt;html>true&lt;/html>&lt;/email>&lt;/inputs>"/>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1377278319788"

        description="Sends an email to a list of users"

        displayName="Denied Email" height="34" interactive="0"

        name="Email" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Email"

        uniqueName="DeniedEmail" waitSetting="0" width="116" x="756" y="371">

        <inputs val="&lt;inputs>&lt;email>&lt;from />&lt;to>xpath:{/workflow/system/executor}&lt;/to>&lt;cc />&lt;bcc />&lt;subject>Your machine was declined by xpath:{/workflow/GetApproval/completedBy/userName}&lt;/subject>&lt;attachments />&lt;body>&amp;lt;p&amp;gt;&#xd;&#xa;      Your machine request was &amp;lt;font color=&quot;#ff0000&quot;&amp;gt;declined&amp;lt;/font&amp;gt; by &#xd;&#xa;      xpath:{/workflow/GetApproval/completedBy/userName}&#xd;&#xa;    &amp;lt;/p&amp;gt;&lt;/body>&lt;html>true&lt;/html>&lt;/email>&lt;/inputs>"/>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1377280895561"

        description="Sends an email to a list of users"

        displayName="Confirmation Email" height="34" interactive="0"

        name="Email" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Email"

        uniqueName="ConfirmationEmail" waitSetting="0" width="155"

        x="425" y="255">

        <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot;>&lt;from class=&quot;java.lang.String&quot; />&lt;to class=&quot;java.lang.String&quot;>xpath:{/workflow/system/executor}&lt;/to>&lt;cc class=&quot;java.lang.String&quot; />&lt;bcc class=&quot;java.lang.String&quot; />&lt;subject class=&quot;java.lang.String&quot;>Your new machine request has been submitted for approval&lt;/subject>&lt;attachments class=&quot;java.lang.Object&quot; />&lt;body class=&quot;java.lang.String&quot;>&amp;#xD;&#xd;&#xa;Machine Name: xpath:{/workflow/inputs/name}&amp;#xD;&#xd;&#xa;Memory: xpath:{/workflow/inputs/Memory}&amp;#xD;&#xd;&#xa;Disk: xpath:{/workflow/inputs/Disk}&amp;#xD;&#xd;&#xa;Additional Software: xpath:{/workflow/inputs/software}&amp;#xD;&#xd;&#xa;&lt;/body>&lt;html class=&quot;java.lang.Boolean&quot;>false&lt;/html>&lt;/email>&lt;/inputs>"/>

        <transition activity="ImpersonateCreator_1" commented="0"

            originalStyle="" points="" sourceX="510" sourceY="272"

            status="0" style="defaultEdge" targetX="515" targetY="349"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1377524911861"

        description="Machine name has invalid characters. Please give a new machine name"

        displayName="Fix machine name" height="34" interactive="0"

        name="PopupInput"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=PopupInput"

        timeout="5" uniqueName="FixMachineName" waitSetting="0"

        width="149" x="168" y="237">

        <activitySchema>

            <inputs attribute="0" listType="0" name="inputs"

                required="1" type="">

                <children attribute="0" className="java.lang.String"

                    controlType="0" displayName="Machine Name"

                    documentation="the following characters are not allowed: !@#$%^&amp;*()+~`-={}[]:;''\&quot;&lt;>,."

                    inputType="java.lang.String" listType="0"

                    name="name" required="1" type="{http://www.w3.org/2001/XMLSchema}string"/>

            </inputs>

            <outputs attribute="0" listType="0" name="outputs"

                required="1" type="">

                <children attribute="0" className="java.lang.String"

                    controlType="0" displayName="Machine Name"

                    documentation="the following characters are not allowed: !@#$%^&amp;*()+~`-={}[]:;''\&quot;&lt;>,."

                    inputType="java.lang.String" listType="0"

                    name="name" required="1" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children className="java.lang.Boolean"

                    inputType="java.lang.Boolean" name="okClicked" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                <children className="java.lang.String"

                    inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string"/>

            </outputs>

        </activitySchema>

        <inputs val="&lt;inputs>&lt;inputs>&lt;name class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/name}&lt;/name>&lt;/inputs>&lt;subject>Machine name has invalid characters&lt;/subject>&lt;/inputs>"/>

        <transition activity="SetNewName" commented="0"

            displayName="New Name entered" offsetX="-39" offsetY="5"

            originalStyle="" points="104.0,207.0" sourceX="242"

            sourceY="237" status="0" style="defaultEdge" targetX="81"

            targetY="185" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;xpath:{/workflow/FixMachineName/okClicked}==true"/>

        </transition>

        <transition activity="WorkflowEnd_1" commented="0"

            displayName="Action cancelled" offsetX="43" offsetY="2"

            originalStyle="" points="240.0,291.0" sourceX="242"

            sourceY="237" status="0" style="defaultEdge" targetX="80"

            targetY="283" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;xpath:{/workflow/FixMachineName/okClicked}==false || xpath:{/workflow/FixMachineName/system/timedOut}==true"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1377524985011" description="if/else based decision"

        displayName="Name has invalid characters?" height="100"

        interactive="0" name="Decision"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="IsNameValid" waitSetting="0" width="200" x="145" y="72">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>new StringTokenizer(xpath:{/workflow/inputs/name}, &quot; !@#$%^&amp;amp;*()+~`-={}[]:;''\&quot;&amp;lt;&amp;gt;,.&quot;,true).countTokens()&amp;gt;1&lt;/expression>&lt;/inputs>"/>

        <transition activity="FixMachineName" commented="0"

            displayName="yes" originalStyle="" points="" sourceX="236"

            sourceY="124" status="0" style="defaultEdge" targetX="231"

            targetY="205" transitionIndex="0" value="true" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="InformationalMessage_1" commented="0"

            displayName="No" originalStyle="" points="" sourceX="245"

            sourceY="122" status="0" style="defaultEdge" targetX="425"

            targetY="296" transitionIndex="0" value="false" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1377525309362"

        description="Updates process variables and inputs"

        displayName="Set New Name" height="34" interactive="0"

        name="AssignValues"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=AssignValues" uniqueName="SetNewName"

        waitSetting="0" width="149" x="15" y="156">

        <inputs val="&lt;inputs />"/>

        <outputs inputs="&lt;inputs>&lt;name class=&quot;java.lang.String&quot;>xpath:{/workflow/FixMachineName/name}&lt;/name>&lt;/inputs>"/>

        <transition activity="IsNameValid" commented="0"

            originalStyle="" points="106.0,122.0" sourceX="113"

            sourceY="185" status="0" style="defaultEdge" targetX="177"

            targetY="130" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1377529856940"

        description="ends the interactive user session"

        displayName="EndUserSession" height="34" interactive="0"

        name="EndUserSession"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=EndUserSession" uniqueName="EndUserSession_1"

        waitSetting="0" width="136" x="435" y="177">

        <inputs val="&lt;inputs />"/>

        <transition activity="ConfirmationEmail" commented="0"

            originalStyle="" points="" sourceX="503" sourceY="202"

            status="0" style="defaultEdge" targetX="504" targetY="288"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1377534220230" description="Ends the workflow"

        displayName="Action Cancelled" height="34" interactive="0"

        name="WorkflowEnd"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=WorkflowEnd"

        uniqueName="WorkflowEnd_1" waitSetting="0" width="139" x="16" y="322">

        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot;>FAILED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot;>The user cancelled the workflow or it timed out waiting for a response&lt;/failureMessage>&lt;/inputs>"/>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1378483315839"

        description="displays an informational message to the user"

        displayName="Submit message" height="34" interactive="0"

        name="InformationalMessage"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=InformationalMessage"

        uniqueName="InformationalMessage_1" waitSetting="0" width="177"

        x="414" y="106">

        <inputs val="&lt;inputs>&lt;message class=&quot;java.lang.String&quot;>Your new machine request has been submitted for approval&lt;/message>&lt;dialogType>Popup&lt;/dialogType>&lt;iconType>Information&lt;/iconType>&lt;html>false&lt;/html>&lt;/inputs>"/>

        <transition activity="EndUserSession_1" commented="0"

            originalStyle="" points="" sourceX="502" sourceY="131"

            status="0" style="defaultEdge" targetX="498" targetY="206"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1379524645998"

        description="sends an action to specified users"

        displayName="Get Approval" height="34" interactive="0"

        name="UserInput"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=UserInput"

        uniqueName="GetApproval" waitSetting="0" width="146" x="638" y="469">

        <activitySchema>

            <inputs attribute="0" listType="0" name="inputs"

                required="1" type="">

                <children attribute="0" className="java.lang.String"

                    controlType="0" displayName="Machine Name"

                    inputType="java.lang.String" listType="0"

                    name="name" readOnly="1" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children attribute="0" className="java.lang.Integer"

                    controlType="4" displayName="Memory (GB)"

                    inputType="java.lang.Integer" listType="0"

                    name="memory" required="1" type="{http://www.w3.org/2001/XMLSchema}integer">

                    <options val="8"/>

                    <options val="16"/>

                    <options val="32"/>

                </children>

                <children attribute="0" className="java.lang.Integer"

                    controlType="2" displayName="Disk (GB)"

                    inputType="java.lang.Integer" listType="0"

                    name="disk" required="1" type="{http://www.w3.org/2001/XMLSchema}integer">

                    <options val="250"/>

                    <options val="500"/>

                    <options val="1000"/>

                </children>

                <children attribute="0" className="java.lang.String"

                    controlType="5" displayName="Additional software"

                    inputType="java.lang.String" listType="1"

                    name="software" readOnly="1" required="0" type="{http://www.w3.org/2001/XMLSchema}string">

                    <options val="Backup"/>

                    <options val="Outlook"/>

                    <options val="Chrome"/>

                </children>

                <children attribute="0" className="java.lang.String"

                    controlType="4" displayName="Approved?"

                    inputType="java.lang.String" listType="0"

                    name="approved" required="1" type="{http://www.w3.org/2001/XMLSchema}string">

                    <options val="Yes"/>

                    <options val="No"/>

                </children>

            </inputs>

            <outputs attribute="0" listType="0" name="outputs"

                required="1" type="">

                <children attribute="0" className="java.lang.String"

                    controlType="0" displayName="Machine Name"

                    inputType="java.lang.String" listType="0"

                    name="name" readOnly="1" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children attribute="0" className="java.lang.Integer"

                    controlType="4" displayName="Memory (GB)"

                    inputType="java.lang.Integer" listType="0"

                    name="memory" required="1" type="{http://www.w3.org/2001/XMLSchema}integer">

                    <options val="8"/>

                    <options val="16"/>

                    <options val="32"/>

                </children>

                <children attribute="0" className="java.lang.Integer"

                    controlType="2" displayName="Disk (GB)"

                    inputType="java.lang.Integer" listType="0"

                    name="disk" required="1" type="{http://www.w3.org/2001/XMLSchema}integer">

                    <options val="250"/>

                    <options val="500"/>

                    <options val="1000"/>

                </children>

                <children attribute="0" className="java.lang.String"

                    controlType="5" displayName="Additional software"

                    inputType="java.lang.String" listType="1"

                    name="software" readOnly="1" required="0" type="{http://www.w3.org/2001/XMLSchema}string">

                    <options val="Backup"/>

                    <options val="Outlook"/>

                    <options val="Chrome"/>

                </children>

                <children attribute="0" className="java.lang.String"

                    controlType="4" displayName="Approved?"

                    inputType="java.lang.String" listType="0"

                    name="approved" required="1" type="{http://www.w3.org/2001/XMLSchema}string">

                    <options val="Yes"/>

                    <options val="No"/>

                </children>

                <children

                    className="commvault.msgs.CvEntities.UserEntity"

                    inputType="commvault.msgs.CvEntities.UserEntity"

                    name="completedBy" type="{commvault.msgs.CvEntities}UserEntity">

                    <children className="java.lang.String"

                        inputType="java.lang.String" name="userName" type="{http://www.w3.org/2001/XMLSchema}string"/>

                    <children className="java.lang.Integer"

                        inputType="java.lang.Integer" name="userId" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                </children>

                <children className="java.lang.String"

                    inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string"/>

            </outputs>

        </activitySchema>

        <inputs val="&lt;inputs>&lt;interactionUsers class=&quot;commvault.msgs.CvEntities.UserGroupEntity&quot;>&lt;userGroupName>master&lt;/userGroupName>&lt;userGroupId>1&lt;/userGroupId>&lt;/interactionUsers>&lt;inputs>&lt;name class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/name}&lt;/name>&lt;memory class=&quot;java.lang.Integer&quot;>xpath:{/workflow/inputs/Memory}&lt;/memory>&lt;disk class=&quot;java.lang.Integer&quot;>xpath:{/workflow/inputs/Disk}&lt;/disk>&lt;software class=&quot;java.lang.String&quot; _list_=&quot;true&quot;>xpath:{/workflow/inputs/software}&lt;/software>&lt;approved class=&quot;java.lang.String&quot; />&lt;/inputs>&lt;subject>New machine request from xpath:{/workflow/system/executor/userName}&lt;/subject>&lt;sendEmail>true&lt;/sendEmail>&lt;email>&lt;from />&lt;to />&lt;cc />&lt;bcc />&lt;subject>New machine request from xpath:{/workflow/system/executor/userName}&lt;/subject>&lt;attachments />&lt;body>&amp;lt;div&amp;gt;&#xd;&#xa;      &amp;lt;b&amp;gt;xpath:{/workflow/system/executor/userName}&amp;lt;/b&amp;gt; has submitted a &#xd;&#xa;      request for a new machine which requires approval&amp;lt;br&amp;gt;&amp;lt;br&amp;gt;&#xd;&#xa;    &amp;lt;/div&amp;gt;&#xd;&#xa;    &amp;lt;div&amp;gt;&#xd;&#xa;      Machine Name: xpath:{/workflow/inputs/name}&#xd;&#xa;    &amp;lt;/div&amp;gt;&#xd;&#xa;    &amp;lt;div&amp;gt;&#xd;&#xa;      Memory: xpath:{/workflow/inputs/Memory}&#xd;&#xa;    &amp;lt;/div&amp;gt;&#xd;&#xa;    &amp;lt;div&amp;gt;&#xd;&#xa;      Disk: xpath:{/workflow/inputs/Disk}&#xd;&#xa;    &amp;lt;/div&amp;gt;&#xd;&#xa;    &amp;lt;div&amp;gt;&#xd;&#xa;      Additional Software: xpath:{/workflow/inputs/software}&#xd;&#xa;    &amp;lt;/div&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      Please visit this page to approve or deny this request: &#xd;&#xa;      xpath:{/workflow/CommServDBQuery_1/resultSets[1]/row[1]/col[1]}&#xd;&#xa;    &amp;lt;/p&amp;gt;&lt;/body>&lt;html>true&lt;/html>&lt;/email>&lt;/inputs>"/>

        <transition activity="ApprovedEmail" commented="0"

            displayName="Approved" offsetX="-37" offsetY="0"

            originalStyle="" points="701.0,551.0" sourceX="679"

            sourceY="494" status="0" style="defaultEdge" targetX="584"

            targetY="601" transitionIndex="0" x="-164" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;xpath:{/workflow/GetApproval/approved}.equals(&quot;Yes&quot;);"/>

        </transition>

        <transition activity="DeniedEmail" commented="0"

            displayName="Not Approved" offsetX="-35" offsetY="-1"

            originalStyle="" points="694.0,431.0" sourceX="679"

            sourceY="494" status="0" style="defaultEdge" targetX="748"

            targetY="577" transitionIndex="0" x="-164" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;xpath:{/workflow/GetApproval/approved}.equals(&quot;No&quot;);"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1379526426610"

        description="executes a set of activities when the workflow completes"

        displayName="On Job Kill" height="153" interactive="0"

        name="OnWorkflowComplete"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="OnWorkflowComplete_2" waitSetting="0" width="185"

        x="710" y="35">

        <activitySchema>

            <inputs attribute="0" listType="0" name="inputs" required="1"/>

            <outputs attribute="0" listType="0" name="outputs" required="1"/>

        </activitySchema>

        <inputs val="&lt;inputs>&lt;inputs />&lt;/inputs>"/>

        <superProcess>

            <Start breakpoint="0" commented="0" continueOnFailure="0"

                created="1379526426610" description=""

                displayName="Start" height="30" interactive="0"

                name="Start" originalStyle="" skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_3" waitSetting="0" width="120" x="26" y="31">

                <inputs val="&lt;inputs />"/>

                <transition activity="Email_3" commented="0"

                    displayName="Is Job Killed" originalStyle=""

                    points="" sourceX="102" sourceY="46" status="0"

                    style="defaultEdge" targetX="101" targetY="121"

                    transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;xpath:{/workflow/system/status}.equalsIgnoreCase(&quot;Kill pending&quot;);"/>

                </transition>

            </Start>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1379526415867"

                description="Sends an email to a list of users"

                displayName="Cancellation Email" height="34"

                interactive="0" name="Email"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Email" uniqueName="Email_3"

                waitSetting="0" width="155" x="13" y="110">

                <inputs val="&lt;inputs>&lt;email>&lt;from />&lt;to>xpath:{/workflow/system/executor}&lt;/to>&lt;cc />&lt;bcc />&lt;subject>Your new machine request was cancelled&lt;/subject>&lt;attachments />&lt;body>&amp;lt;div&amp;gt;&#xd;&#xa;      Your new machine request was &amp;lt;font color=&quot;#ff0033&quot;&amp;gt;cancelled&amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/div&amp;gt;&#xd;&#xa;    &amp;lt;div&amp;gt;&#xd;&#xa;      &amp;lt;br&amp;gt;&#xd;&#xa;      Machine Name: xpath:{/workflow/inputs/name}&amp;lt;br&amp;gt;Memory: &#xd;&#xa;      xpath:{/workflow/inputs/Memory}&amp;lt;br&amp;gt;Disk: xpath:{/workflow/inputs/Disk}&amp;lt;br&amp;gt;Additional &#xd;&#xa;      Software: xpath:{/workflow/inputs/software}&amp;lt;br&amp;gt;&#xd;&#xa;    &amp;lt;/div&amp;gt;&lt;/body>&lt;html>true&lt;/html>&lt;/email>&lt;/inputs>"/>

            </Activity>

        </superProcess>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1379957432506"

        description="impersonates the user who created the workflow"

        displayName="ImpersonateCreator" height="34" interactive="0"

        name="ImpersonateCreator"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ImpersonateCreator"

        uniqueName="ImpersonateCreator_1" waitSetting="0" width="175"

        x="422" y="329">

        <inputs val="&lt;inputs />"/>

        <transition activity="CommServDBQuery_1" commented="0"

            originalStyle="" points="" sourceX="509" sourceY="346"

            status="0" style="defaultEdge" targetX="505" targetY="429"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1379957535310"

        description="impersonates the user who executes the workflow"

        displayName="ImpersonateExecutor" height="34" interactive="0"

        name="ImpersonateExecutor"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ImpersonateExecutor"

        uniqueName="ImpersonateExecutor_1" waitSetting="0" width="172"

        x="426" y="469">

        <inputs val="&lt;inputs />"/>

        <transition activity="GetApproval" commented="0"

            originalStyle="" points="" sourceX="512" sourceY="486"

            status="0" style="defaultEdge" targetX="816" targetY="481"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1379957695430"

        description="executes queries against the commserv database"

        displayName="Get WebConsole URL" height="34" interactive="0"

        name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=CommServDBQuery"

        uniqueName="CommServDBQuery_1" waitSetting="0" width="170"

        x="426" y="401">

        <inputs val="&lt;inputs>&lt;commCell>&lt;/commCell>&lt;query>select attrVal+''/forms'' from APP_ClientProp where attrName = ''WebURL'' and attrVal &amp;lt;&amp;gt; '''' and modified=0 order by created desc&amp;#xD;&#xd;&#xa;&lt;/query>&lt;/inputs>"/>

        <transition activity="ImpersonateExecutor_1" commented="0"

            originalStyle="" points="" sourceX="511" sourceY="418"

            status="0" style="defaultEdge" targetX="509" targetY="484"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <schema>

        <inputs attribute="0" className="" listType="0" name="inputs"

            required="1" type="">

            <children attribute="0" className="java.lang.String"

                controlType="0" displayName="Machine Name" hidden="0"

                inputType="java.lang.String" listType="0" name="name"

                required="1" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.Integer"

                controlType="4" displayName="Memory (GB)" hidden="0"

                inputType="java.lang.Integer" listType="0" name="Memory"

                required="1" type="{http://www.w3.org/2001/XMLSchema}integer">

                <options val="8"/>

                <options val="16"/>

                <options val="32"/>

            </children>

            <children attribute="0" className="java.lang.Integer"

                controlType="2" displayName="Disk (GB)" hidden="0"

                inputType="java.lang.Integer" listType="0" name="Disk"

                required="1" type="{http://www.w3.org/2001/XMLSchema}integer">

                <options val="250"/>

                <options val="500"/>

                <options val="1000"/>

            </children>

            <children attribute="0" className="java.lang.String"

                controlType="5" displayName="Additional Software"

                hidden="0" inputType="java.lang.String" listType="1"

                name="software" required="0" type="{http://www.w3.org/2001/XMLSchema}string">

                <options val="Backup"/>

                <options val="Outlook"/>

                <options val="Chrome"/>

            </children>

        </inputs>

        <variables attribute="0" className="" listType="0"

            name="variables" required="1" type=""/>

        <outputs className="" name="outputs" type=""/>

    </schema>

</workflow>'

IF not exists (select * from WF_Definition where Name = @name)

BEGIN
	INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision)


	VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision)

	SET @workflowId = @@IDENTITY
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


	VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

	SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = ISNULL(revision, '') From WF_Definition WHERE Name = @name

	IF (@currentFlags & 4 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0) AND (@currentRevision <> @revision)

	BEGIN

		SET @version = @version + 1

		UPDATE WF_Definition

		SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision

		WHERE Name = @name

		IF (@flags & 8 > 0 OR @flags & 16 > 0)

		BEGIN

			UPDATE WF_Definition

			SET flags = @flags

			WHERE Name = @name

		END
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


		VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

	END

END

