

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_DemoFileSystemBackupRestore.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/WFD_DemoFileSystemBackupRestore.script,v $ $Id: WFD_DemoFileSystemBackupRestore.script,v 1.5.2.1 2020/10/04 00:53:34 abilbrey Exp $";
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER ON

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.5.2.1 $'

SET @name = 'Demo_FileSystemBackupRestore'

SET @description = 'workflow to perform a file system backup and out of place restore'

SET @version = 1

SET @flags = 6

SET @definition = '<workflow apiMode="0"

    description="workflow to perform a file system backup and out of place restore"

    inputs="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>&lt;clientName />&lt;clientId>0&lt;/clientId>&lt;/client>&lt;restoreClient class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>&lt;clientName />&lt;clientId>0&lt;/clientId>&lt;/restoreClient>&lt;sourcePath class=&quot;java.lang.String&quot; />&lt;destinationPath class=&quot;java.lang.String&quot; />&lt;/inputs>"

    interactive="0" name="Demo_FileSystemBackupRestore"

    outputs="&lt;outputs />" variables="&lt;variables />" workflowId="0">

    <Start breakpoint="0" commented="0" continueOnFailure="0"

        created="0" description="" displayName="Start" height="36"

        interactive="0" name="Start" originalStyle="" skipAttempt="0"

        style="image;image=/images/jgraphx/house.png"

        uniqueName="Start_1" waitSetting="0" width="61" x="59" y="46">

        <inputs val="&lt;inputs />"/>

        <transition activity="OperationBackup_1" commented="0"

            originalStyle="" points="" sourceX="49" sourceY="64"

            status="0" style="defaultEdge" targetX="336" targetY="66"

            transitionIndex="0" x="0" y="0"/>

    </Start>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1329338712083" description="" displayName="Backup"

        height="34" interactive="0" name="Backup"

        namespaceUri="commvault.cte.workflow.activities.cmd.operation"

        originalStyle="" skipAttempt="0"

        style="label;image=OperationBackup"

        uniqueName="OperationBackup_1" waitSetting="0" width="119"

        x="190" y="47">

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/inputs/client}&lt;/client>&lt;dataAgent class=&quot;java.lang.String&quot;>Q_FILESYSTEM&lt;/dataAgent>&lt;backupSet class=&quot;java.lang.String&quot;>defaultBackupSet&lt;/backupSet>&lt;subClient class=&quot;java.lang.String&quot;>default&lt;/subClient>&lt;instance class=&quot;java.lang.String&quot; />&lt;backupType class=&quot;workflow.types.BackupType&quot;>Q_INC&lt;/backupType>&lt;argumentFilepath class=&quot;java.lang.String&quot; />&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

        <transition activity="WaitForJobCompletion_1" commented="0"

            originalStyle="" points="" sourceX="483" sourceY="61"

            status="0" style="defaultEdge" targetX="758" targetY="60"

            transitionIndex="0" x="0" y="0"/>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1329338783708"

        description="waits until the list of jobs completes"

        displayName="WaitForJobCompletion" height="34" interactive="0"

        name="WaitForJobCompletion"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=WaitForJobCompletion"

        uniqueName="WaitForJobCompletion_1" waitSetting="0" width="180"

        x="351" y="47">

        <inputs val="&lt;inputs>&lt;jobId class=&quot;java.lang.Integer&quot; _list_=&quot;true&quot;>xpath:{/workflow/OperationBackup_1/jobId}&lt;/jobId>&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

        <transition activity="Decision_1" commented="0" originalStyle=""

            points="" sourceX="559" sourceY="64" status="0"

            style="defaultEdge" targetX="773" targetY="64"

            transitionIndex="0" x="0" y="0"/>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1329421978487" description="" displayName="Restore"

        height="34" interactive="0" name="Restore"

        namespaceUri="commvault.cte.workflow.activities.cmd.operation"

        originalStyle="" skipAttempt="0"

        style="label;image=OperationRestore"

        uniqueName="OperationRestore_1" waitSetting="0" width="128"

        x="573" y="151">

        <inputs val="&lt;inputs>&lt;sourceClient class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/inputs/client}&lt;/sourceClient>&lt;dataAgent class=&quot;java.lang.String&quot;>Q_FILESYSTEM&lt;/dataAgent>&lt;backupSet class=&quot;java.lang.String&quot;>defaultBackupSet&lt;/backupSet>&lt;instance class=&quot;java.lang.String&quot; />&lt;sourcePath class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/sourcePath}&lt;/sourcePath>&lt;destinationClient class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/inputs/restoreClient}&lt;/destinationClient>&lt;destinationPath class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/destinationPath}&lt;/destinationPath>&lt;argumentFilepath class=&quot;java.lang.String&quot; />&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

        <transition activity="WaitForJobCompletion_2" commented="0"

            originalStyle="" points="" sourceX="802" sourceY="63"

            status="0" style="defaultEdge" targetX="800" targetY="164"

            transitionIndex="0" x="0" y="0"/>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1329422113285"

        description="waits until the list of jobs completes"

        displayName="WaitForJobCompletion" height="34" interactive="0"

        name="WaitForJobCompletion"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=WaitForJobCompletion"

        uniqueName="WaitForJobCompletion_2" waitSetting="0" width="180"

        x="350" y="151">

        <inputs val="&lt;inputs>&lt;jobId class=&quot;java.lang.Integer&quot;>xpath:{/workflow/OperationRestore_1/jobId}&lt;/jobId>&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

        <transition activity="Decision_2" commented="0" originalStyle=""

            points="" sourceX="558" sourceY="168" status="0"

            style="defaultEdge" targetX="390" targetY="166"

            transitionIndex="0" x="0" y="0"/>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1329422200603" description="if/else based decision"

        displayName="Successful" height="90" interactive="0"

        name="Decision" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_1" waitSetting="0" width="100" x="591" y="19">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/WaitForJobCompletion_1/successful}&lt;/expression>&lt;/inputs>"/>

        <transition activity="WorkflowEnd_1" commented="0"

            displayName="no" originalStyle="" points="" sourceX="751"

            sourceY="64" status="0" style="defaultEdge" targetX="889"

            targetY="63" transitionIndex="0" value="false" x="0" y="0"/>

        <transition activity="OperationRestore_1" commented="0"

            displayName="yes" originalStyle="" points="" sourceX="751"

            sourceY="64" status="0" style="defaultEdge" targetX="751"

            targetY="203" transitionIndex="0" value="true" x="0" y="0"/>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1329422222147" description="Ends the workflow"

        displayName="Backup Failed" height="34" interactive="0"

        name="WorkflowEnd"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=WorkflowEnd"

        uniqueName="WorkflowEnd_1" waitSetting="0" width="122" x="756" y="47">

        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot;>FAILED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot;>the backup job xpath:{/workflow/OperationBackup_1/jobId} did not complete successfully&lt;/failureMessage>&lt;/inputs>"/>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1329422350792" description="if/else based decision"

        displayName="Successful" height="91" interactive="0"

        name="Decision" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_2" waitSetting="0" width="100" x="207" y="123">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/WaitForJobCompletion_2/successful}&lt;/expression>&lt;/inputs>"/>

        <transition activity="WorkflowEnd_2" commented="0"

            displayName="no" originalStyle="" points="" sourceX="372"

            sourceY="168" status="0" style="defaultEdge" targetX="254"

            targetY="177" transitionIndex="0" value="false" x="0" y="0"/>

        <transition activity="Email_1" commented="0" displayName="yes"

            originalStyle="" points="" sourceX="372" sourceY="168"

            status="0" style="defaultEdge" targetX="371" targetY="275"

            transitionIndex="0" value="true" x="0" y="0"/>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1329422391229" description="Ends the workflow"

        displayName="Restore Failed" height="34" interactive="0"

        name="WorkflowEnd"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=WorkflowEnd"

        uniqueName="WorkflowEnd_2" waitSetting="0" width="125" x="26" y="151">

        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot;>FAILED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot;>the restore job xpath:{/workflow/OperationRestore_1/jobId} did not complete successfully&lt;/failureMessage>&lt;/inputs>"/>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1329422420170"

        description="Sends an email to a list of users"

        displayName="Email" height="34" interactive="0" name="Email"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Email"

        uniqueName="Email_1" waitSetting="0" width="100" x="205" y="261">

        <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot;>&lt;from class=&quot;java.lang.String&quot; />&lt;to class=&quot;java.lang.String&quot;>xpath:{/workflow/system/executor/userName}&lt;/to>&lt;subject class=&quot;java.lang.String&quot;>Workflow xpath:{/workflow/system/workflow/workflowName} Completed&lt;/subject>&lt;body class=&quot;java.lang.String&quot;>&amp;lt;p&amp;gt;&#xd;&#xa;      The backup and restore workflow completed successfully&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;ul&amp;gt;&#xd;&#xa;      &amp;lt;li&amp;gt;&#xd;&#xa;        Backup Job Id: xpath:{/workflow/OperationBackup_1/jobId}&#xd;&#xa;      &amp;lt;/li&amp;gt;&#xd;&#xa;      &amp;lt;li&amp;gt;&#xd;&#xa;        Restore Job Id: xpath:{/workflow/OperationRestore_1/jobId}&#xd;&#xa;      &amp;lt;/li&amp;gt;&#xd;&#xa;    &amp;lt;/ul&amp;gt;&lt;/body>&lt;/email>&lt;/inputs>"/>

    </Activity>

    <schema>

        <inputs attribute="0" className="" listType="0" name="inputs"

            required="1" type="">

            <children attribute="0"

                className="commvault.msgs.CvEntities.ClientEntity"

                controlType="2" displayName="Source Client" hidden="0"

                inputType="commvault.msgs.CvEntities.ClientEntity"

                listType="0" name="client" required="1" type="{commvault.msgs.CvEntities}ClientEntity">

                <children attribute="0" className="java.lang.String"

                    inputType="java.lang.String" listType="0"

                    name="clientName" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children attribute="0" className="java.lang.Integer"

                    inputType="java.lang.Integer" listType="0"

                    name="clientId" required="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            </children>

            <children attribute="0"

                className="commvault.msgs.CvEntities.ClientEntity"

                controlType="2" displayName="Destination Client"

                hidden="0"

                inputType="commvault.msgs.CvEntities.ClientEntity"

                listType="0" name="restoreClient" required="0" type="{commvault.msgs.CvEntities}ClientEntity">

                <children attribute="0" className="java.lang.String"

                    inputType="java.lang.String" listType="0"

                    name="clientName" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children attribute="0" className="java.lang.Integer"

                    inputType="java.lang.Integer" listType="0"

                    name="clientId" required="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            </children>

            <children attribute="0" className="java.lang.String"

                controlType="0" displayName="Source Path" hidden="0"

                inputType="java.lang.String" listType="0"

                name="sourcePath" required="1" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" displayName="Desintation Path"

                hidden="0" inputType="java.lang.String" listType="0"

                name="destinationPath" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

        </inputs>

        <variables attribute="0" className="" listType="0"

            name="variables" required="1" type=""/>

        <outputs className="" name="outputs" type=""/>

    </schema>

</workflow>'

IF not exists (select * from WF_Definition where Name = @name)

BEGIN
	INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision)


	VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision)

	SET @workflowId = @@IDENTITY
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


	VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

	SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = ISNULL(revision, '') From WF_Definition WHERE Name = @name

	IF (@currentFlags & 4 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0) AND (@currentRevision <> @revision)

	BEGIN

		SET @version = @version + 1

		UPDATE WF_Definition

		SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision

		WHERE Name = @name

		IF (@flags & 8 > 0 OR @flags & 16 > 0)

		BEGIN

			UPDATE WF_Definition

			SET flags = @flags

			WHERE Name = @name

		END
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


		VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

	END

END

