

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_DemoExecuteProcessOnGroup.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/WFD_DemoExecuteProcessOnGroup.script,v $ $Id: WFD_DemoExecuteProcessOnGroup.script,v 1.5.2.1 2020/10/04 01:02:23 abilbrey Exp $";
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER ON

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.5.2.1 $'

SET @name = 'Demo_ExecuteProcessOnGroup'

SET @description = 'executes a process on all clients within a client group'

SET @version = 1

SET @flags = 6

SET @definition = '<workflow apiMode="0"

    description="executes a process on all clients within a client group"

    inputs="&lt;inputs>&lt;processName class=&quot;java.lang.String&quot; />&lt;arguments class=&quot;java.lang.String&quot; />&lt;startupPath class=&quot;java.lang.String&quot; />&lt;impersonateUserName class=&quot;java.lang.String&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; />&lt;clientGroup class=&quot;commvault.msgs.CvEntities.ClientGroupEntity&quot;>&lt;clientGroupName />&lt;clientGroupId>0&lt;/clientGroupId>&lt;/clientGroup>&lt;/inputs>"

    interactive="0" name="Demo_ExecuteProcessOnGroup"

    outputs="&lt;outputs />"

    variables="&lt;variables>&lt;results class=&quot;java.lang.String&quot; _list_=&quot;true&quot; />&lt;/variables>" workflowId="0">

    <Start breakpoint="0" commented="0" continueOnFailure="0"

        created="0" description="" displayName="Start" height="36"

        interactive="0" name="Start" originalStyle="" skipAttempt="0"

        style="image;image=/images/jgraphx/house.png"

        uniqueName="Start_1" waitSetting="0" width="61" x="80" y="179">

        <inputs val="&lt;inputs />"/>

        <transition activity="CommServDBQuery_1" commented="0"

            originalStyle="" points="" sourceX="112" sourceY="179"

            status="0" style="defaultEdge" targetX="233" targetY="181"

            transitionIndex="0" x="0" y="0"/>

    </Start>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1345146696038"

        description="iterates a group of activities over a list of values"

        displayName="ForEach" height="315" interactive="0"

        name="ForEach" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ForEach_1" waitSetting="0" width="217" x="399" y="40">

        <activitySchema>

            <inputs>

                <children className="java.lang.String"

                    inputType="java.lang.String" name="name" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children className="java.lang.Object"

                    inputType="java.lang.Object" name="values" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                <children className="java.lang.Integer" defaultValue="1"

                    inputType="java.lang.Integer"

                    name="numberOfParallelExecutions" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                <children className="java.lang.Boolean"

                    defaultValue="false" inputType="java.lang.Boolean"

                    name="continueOnFailure" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

            </inputs>

            <outputs name="outputs">

                <children className="workflow.types.data.DataRow"

                    inputType="workflow.types.data.DataRow" listType="0"

                    name="row" type="{workflow.types.data}DataRow">

                    <children className="java.lang.Object"

                        inputType="java.lang.Object" listType="1"

                        name="col" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                </children>

            </outputs>

        </activitySchema>

        <inputs val="&lt;inputs>&lt;name class=&quot;java.lang.String&quot;>row&lt;/name>&lt;values class=&quot;java.lang.Object&quot;>xpath:{/workflow/CommServDBQuery_1/resultSets/row}&lt;/values>&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot;>1&lt;/numberOfParallelExecutions>&lt;/inputs>"/>

        <transition activity="Email_1" commented="0" originalStyle=""

            points="" sourceX="507" sourceY="197" status="0"

            style="defaultEdge" targetX="683" targetY="202"

            transitionIndex="0" x="0" y="0"/>

        <superProcess>

            <Start breakpoint="0" commented="0" continueOnFailure="0"

                created="1345146696038" description=""

                displayName="Start" height="30" interactive="0"

                name="Start" originalStyle="" skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_2" waitSetting="0" width="120" x="47" y="30">

                <inputs val="&lt;inputs />"/>

                <transition activity="ExecuteCommand_1" commented="0"

                    originalStyle="" points="" sourceX="107"

                    sourceY="45" status="0" style="defaultEdge"

                    targetX="103" targetY="119" transitionIndex="0"

                    x="0" y="0"/>

            </Start>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1345146725290"

                description="Execute a list of commands"

                displayName="ExecuteCommand" height="34" interactive="0"

                maxRestarts="0" name="ExecuteCommand"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=ExecuteCommand"

                uniqueName="ExecuteCommand_1" waitSetting="0"

                width="147" x="37" y="107">

                <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/ForEach_1/row/col[1]}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/impersonateUserName}&lt;/impersonateUserName>&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot;>xpath:{/workflow/inputs/impersonateUserPassword}&lt;/impersonateUserPassword>&lt;startUpPath class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/startupPath}&lt;/startUpPath>&lt;command class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/processName}&lt;/command>&lt;arguments class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/arguments}&lt;/arguments>&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

                <transition activity="Script_1" commented="0"

                    originalStyle="" points="" sourceX="110"

                    sourceY="124" status="0" style="defaultEdge"

                    targetX="106" targetY="205" transitionIndex="0"

                    x="0" y="0"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1345147459285"

                description="activity to execute code snippets in the selected language"

                displayName="Generate Result" height="34"

                interactive="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Script" uniqueName="Script_1"

                waitSetting="0" width="136" x="40" y="184">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;if (xpath:{/workflow/ExecuteCommand_1/exitCode} == 0)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    return xpath:{/workflow/ForEach_1/row/col[1]} + &amp;quot;: Completed&amp;quot;;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;else&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    return xpath:{/workflow/ForEach_1/row/col[1]} + &amp;quot;: &amp;quot; + xpath:{/workflow/ExecuteCommand_1/commandOutput};&amp;#xD;&amp;#xA;} &quot; />&lt;/inputs>"/>

                <transition activity="AddToList_1" commented="0"

                    originalStyle="" points="" sourceX="108"

                    sourceY="201" status="0" style="defaultEdge"

                    targetX="107" targetY="269" transitionIndex="0"

                    x="0" y="0"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1345147493782"

                description="utility to add objects to a list"

                displayName="Update Results" height="34" interactive="0"

                name="AddToList"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=AddToList" uniqueName="AddToList_1"

                waitSetting="0" width="129" x="45" y="260">

                <inputs val="&lt;inputs>&lt;addToList class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/results}&lt;/addToList>&lt;itemToAdd class=&quot;java.lang.Object&quot;>xpath:{/workflow/Script_1/output}&lt;/itemToAdd>&lt;/inputs>"/>

            </Activity>

        </superProcess>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1345146976527"

        description="executes queries against the commserv database"

        displayName="Retrieve Clients" height="34" interactive="0"

        name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=CommServDBQuery"

        uniqueName="CommServDBQuery_1" waitSetting="0" width="162"

        x="186" y="180">

        <inputs val="&lt;inputs>&lt;commCell>&lt;/commCell>&lt;query>Select name&amp;#xD;&#xd;&#xa;From APP_Client&amp;#xD;&#xd;&#xa;Where id in (&amp;#xD;&#xd;&#xa;&#x9;Select a.clientId&amp;#xD;&#xd;&#xa;&#x9;From APP_ClientGroup g&amp;#xD;&#xd;&#xa;&#x9;INNER JOIN APP_ClientGroupAssoc a ON g.id = a.clientGroupId&amp;#xD;&#xd;&#xa;&#x9;WHere g.name = ''xpath:{/workflow/inputs/clientGroup/clientGroupName}''&amp;#xD;&#xd;&#xa;)&lt;/query>&lt;/inputs>"/>

        <transition activity="ForEach_1" commented="0" originalStyle=""

            points="" sourceX="265" sourceY="180" status="0"

            style="defaultEdge" targetX="437" targetY="56"

            transitionIndex="0" x="0" y="0"/>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1345147527076"

        description="Sends an email to a list of users"

        displayName="Email" height="34" interactive="0" name="Email"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Email"

        uniqueName="Email_1" waitSetting="0" width="100" x="657" y="180">

        <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot;>&lt;from class=&quot;java.lang.String&quot; />&lt;to class=&quot;java.lang.String&quot;>xpath:{/workflow/system/executor/userName}&lt;/to>&lt;subject class=&quot;java.lang.String&quot;>Execute Process Results&lt;/subject>&lt;body class=&quot;java.lang.String&quot;>The workflow xpath:{/workflow/system/workflow/workflowName} completed with the following results&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;xpath:{/workflow/variables/results}&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&lt;/body>&lt;html class=&quot;java.lang.Boolean&quot;>false&lt;/html>&lt;/email>&lt;/inputs>"/>

    </Activity>

    <schema>

        <inputs attribute="0" className="" listType="0" name="inputs"

            required="1" type="">

            <children attribute="0"

                className="commvault.msgs.CvEntities.ClientGroupEntity"

                controlType="2" displayName="Client Group" hidden="0"

                inputType="commvault.msgs.CvEntities.ClientGroupEntity"

                listType="0" name="clientGroup" required="1" type="{commvault.msgs.CvEntities}ClientGroupEntity">

                <children attribute="0" className="java.lang.String"

                    inputType="java.lang.String" listType="0"

                    name="clientGroupName" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children attribute="0" className="java.lang.Integer"

                    inputType="java.lang.Integer" listType="0"

                    name="clientGroupId" required="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            </children>

            <children attribute="0" className="java.lang.String"

                controlType="0" displayName="Command" hidden="0"

                inputType="java.lang.String" listType="0"

                name="processName" required="1" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" displayName="Arguments" hidden="0"

                inputType="java.lang.String" listType="0"

                name="arguments" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" displayName="Startup Path" hidden="0"

                inputType="java.lang.String" listType="0"

                name="startupPath" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" displayName="User Name"

                documentation="the host username to execute the command as"

                hidden="0" inputType="java.lang.String" listType="0"

                name="impersonateUserName" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0"

                className="workflow.types.EncryptedString"

                controlType="0" displayName="User Password"

                documentation="the credentials to execute the command as"

                hidden="0" inputType="workflow.types.EncryptedString"

                listType="0" name="impersonateUserPassword" required="0" type="{workflow.types}EncryptedString"/>

        </inputs>

        <variables attribute="0" className="" listType="0"

            name="variables" required="1" type="">

            <children attribute="0" className="java.lang.String"

                hidden="0" inputType="java.lang.String" listType="1"

                name="results" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

        </variables>

        <outputs className="" name="outputs" type=""/>

    </schema>

</workflow>'

IF not exists (select * from WF_Definition where Name = @name)

BEGIN
	INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision)


	VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision)

	SET @workflowId = @@IDENTITY
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


	VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

	SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = ISNULL(revision, '') From WF_Definition WHERE Name = @name

	IF (@currentFlags & 4 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0) AND (@currentRevision <> @revision)

	BEGIN

		SET @version = @version + 1

		UPDATE WF_Definition

		SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision

		WHERE Name = @name

		IF (@flags & 8 > 0 OR @flags & 16 > 0)

		BEGIN

			UPDATE WF_Definition

			SET flags = @flags

			WHERE Name = @name

		END
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


		VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

	END

END

