

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_DemoClientGroupPolicy.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/WFD_DemoClientGroupPolicy.script,v $ $Id: WFD_DemoClientGroupPolicy.script,v 1.5.2.1 2020/10/04 00:54:37 abilbrey Exp $";
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER ON

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.5.2.1 $'

SET @name = 'Demo - Client Group Policy'

SET @description = 'Demo workflow to show how to change storage policy for all FS subclients of clients belonging to a given client group.'

SET @version = 1

SET @flags = 6

SET @definition = '<workflow apiMode="0"

    description="Demo workflow to show how to change storage policy for all FS subclients of clients belonging to a given client group."

    inputs="&lt;inputs>&lt;clientGroup class=&quot;commvault.msgs.CvEntities.ClientGroupEntity&quot;>&lt;clientGroupName />&lt;clientGroupId>0&lt;/clientGroupId>&lt;/clientGroup>&lt;storagePolicy class=&quot;commvault.msgs.CvEntities.StoragePolicyEntity&quot;>&lt;storagePolicyName />&lt;storagePolicyId>0&lt;/storagePolicyId>&lt;/storagePolicy>&lt;/inputs>"

    interactive="0" name="Demo - Client Group Policy"

    outputs="&lt;outputs />"

    variables="&lt;variables>&lt;completedClients class=&quot;java.lang.String&quot; _list_=&quot;true&quot; />&lt;failedClients class=&quot;java.lang.String&quot; _list_=&quot;true&quot; />&lt;/variables>" workflowId="0">

    <Start breakpoint="0" commented="0" continueOnFailure="0"

        created="0" description="" displayName="Start" height="36"

        interactive="0" name="Start" originalStyle="" skipAttempt="0"

        style="image;image=/images/jgraphx/house.png"

        uniqueName="Start_1" waitSetting="0" width="61" x="70" y="225">

        <inputs val="&lt;inputs />"/>

        <transition activity="CommServDBQuery_1" commented="0"

            originalStyle="" points="" sourceX="83" sourceY="240"

            status="0" style="defaultEdge" targetX="242" targetY="239"

            transitionIndex="0" x="-22" y="1"/>

    </Start>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1337083648420"

        description="executes queries against the commserv database"

        displayName="Fetch Clients" height="34" interactive="0"

        name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=CommServDBQuery"

        uniqueName="CommServDBQuery_1" waitSetting="0" width="122"

        x="183" y="226">

        <inputs val="&lt;inputs>&lt;commCell>&lt;/commCell>&lt;query>Select c.id, c.name&amp;#xD;&#xd;&#xa;From APP_Client c&amp;#xD;&#xd;&#xa;INNER JOIN APP_ClientGroupAssoc a ON c.id = a.clientId&amp;#xD;&#xd;&#xa;WHERE a.clientGroupId in (Select id From APP_ClientGroup Where name = ''xpath:{/workflow/inputs/clientGroup/clientGroupName}'')&lt;/query>&lt;/inputs>"/>

        <transition activity="ForEach_1" commented="0" originalStyle=""

            points="" sourceX="222" sourceY="59" status="0"

            style="defaultEdge" targetX="395" targetY="45"

            transitionIndex="0" x="0" y="0"/>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1337084147619"

        description="iterates a group of activities over a list of values"

        displayName="ForEach" height="412" interactive="0"

        name="ForEach" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" restartInterval="0" skipAttempt="0"

        style="swimlane" uniqueName="ForEach_1" waitSetting="0"

        width="565" x="367" y="37">

        <activitySchema>

            <inputs>

                <children className="java.lang.String"

                    inputType="java.lang.String" name="name" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children className="java.lang.Object"

                    inputType="java.lang.Object" name="values" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                <children className="java.lang.Integer" defaultValue="1"

                    inputType="java.lang.Integer"

                    name="numberOfParallelExecutions" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                <children className="java.lang.Boolean"

                    defaultValue="false" inputType="java.lang.Boolean"

                    name="continueOnFailure" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

            </inputs>

            <outputs name="outputs">

                <children className="workflow.types.data.DataRow"

                    inputType="workflow.types.data.DataRow" listType="0"

                    name="row" type="{workflow.types.data}DataRow">

                    <children className="java.lang.Object"

                        inputType="java.lang.Object" listType="1"

                        name="col" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                </children>

            </outputs>

        </activitySchema>

        <inputs val="&lt;inputs>&lt;name class=&quot;java.lang.String&quot;>row&lt;/name>&lt;values class=&quot;java.lang.Object&quot;>xpath:{/workflow/CommServDBQuery_1/resultSets/row}&lt;/values>&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot;>1&lt;/numberOfParallelExecutions>&lt;/inputs>"/>

        <transition activity="Email_1" commented="0" originalStyle=""

            points="" sourceX="577" sourceY="239" status="0"

            style="defaultEdge" targetX="896" targetY="181"

            transitionIndex="0" x="0" y="0"/>

        <superProcess>

            <Start breakpoint="0" commented="0" continueOnFailure="0"

                created="1337084147620" description=""

                displayName="Start" height="30" interactive="0"

                name="Start" originalStyle="" skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_2" waitSetting="0" width="120" x="225" y="37">

                <inputs val="&lt;inputs />"/>

                <transition activity="Execute_1" commented="0"

                    originalStyle="" points="" sourceX="285"

                    sourceY="52" status="0" style="defaultEdge"

                    targetX="282" targetY="148" transitionIndex="0"

                    x="80" y="-4"/>

            </Start>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1337088814975"

                description="utility to add objects to a list"

                displayName="Completed Clients" height="34"

                interactive="0" name="AddToList"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=AddToList" uniqueName="AddToList_1"

                waitSetting="0" width="149" x="26" y="322">

                <inputs val="&lt;inputs>&lt;itemToAdd class=&quot;java.lang.Object&quot;>xpath:{/workflow/ForEach_1/row/col[@name=&quot;name&quot;]}&lt;/itemToAdd>&lt;addToList class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/completedClients}&lt;/addToList>&lt;/inputs>"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1337088821160"

                description="utility to add objects to a list"

                displayName="Failed Clients" height="34" interactive="0"

                name="AddToList"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=AddToList" uniqueName="AddToList_2"

                waitSetting="0" width="119" x="408" y="322">

                <inputs val="&lt;inputs>&lt;itemToAdd class=&quot;java.lang.Object&quot;>xpath:{/workflow/ForEach_1/row/col[@name=&quot;name&quot;]}&lt;/itemToAdd>&lt;addToList class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/failedClients}&lt;/addToList>&lt;/inputs>"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1337097162674" description=""

                displayName="Modify Subclient" height="34"

                interactive="0" maxRestarts="0" name="Execute"

                namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                originalStyle="" skipAttempt="0"

                style="label;image=Execute" uniqueName="Execute_1"

                waitSetting="0" width="159" x="210" y="123">

                <inputs val="&lt;inputs>&lt;inputXml class=&quot;java.lang.String&quot;>&amp;lt;App_UpdateSubClientPropertiesRequest&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;subClientProperties&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;commonProperties&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;storageDevice&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;dataBackupStoragePolicy storagePolicyName=&quot;xpath:{/workflow/inputs/storagePolicy/storagePolicyName}&quot; /&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/storageDevice&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/commonProperties&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;/subClientProperties&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;association&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;entity backupsetName=&quot;defaultBackupSet&quot; &amp;#xD;&#xd;&#xa;                 subclientName=&quot;default&quot; &amp;#xD;&#xd;&#xa;                 clientName=&quot;xpath:{/workflow/ForEach_1/row/col[@name=&quot;name&quot;]}&quot; &amp;#xD;&#xd;&#xa;                 appName=&quot;File System&quot; /&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;/association&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/App_UpdateSubClientPropertiesRequest&amp;gt;&lt;/inputXml>&lt;commandArgs class=&quot;java.lang.String&quot; />&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

                <transition activity="XPathQuery_2" commented="0"

                    originalStyle="" points="" sourceX="289"

                    sourceY="140" status="1" style="defaultEdge"

                    targetX="285" targetY="240" transitionIndex="0"

                    x="0" y="0"/>

                <transition activity="AddToList_2" commented="0"

                    displayName="Failure" offsetX="-3" offsetY="-90"

                    originalStyle="" points="462.0,210.0" sourceX="289"

                    sourceY="140" status="2" style="defaultEdge"

                    targetX="473" targetY="335" transitionIndex="0"

                    x="0" y="0"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1337611401219"

                description="retrieves a list of values from xml"

                displayName="Get XML Status" height="34" interactive="0"

                name="XPathQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=XPathQuery" uniqueName="XPathQuery_2"

                waitSetting="0" width="148" x="215" y="208">

                <inputs val="&lt;inputs>&lt;xml class=&quot;java.lang.String&quot;>xpath:{/workflow/Execute_1/outputXml}&lt;/xml>&lt;xpath class=&quot;java.lang.String&quot;>number(/App_UpdateSubClientPropertiesResponse/response/errorCode)&lt;/xpath>&lt;/inputs>"/>

                <transition activity="Decision_2" commented="0"

                    originalStyle="" points="" sourceX="288"

                    sourceY="238" status="0" style="defaultEdge"

                    targetX="284" targetY="330" transitionIndex="0"

                    x="0" y="0"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1337611471348"

                description="if/else based decision"

                displayName="Success" height="100" interactive="0"

                name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_2"

                waitSetting="0" width="100" x="240" y="289">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{number(/workflow/XPathQuery_2/result)} == 0&lt;/expression>&lt;/inputs>"/>

                <transition activity="AddToList_2" commented="0"

                    displayName="NO" originalStyle="" points=""

                    sourceX="290" sourceY="339" status="0"

                    style="defaultEdge" targetX="473" targetY="340"

                    transitionIndex="0" value="false" x="0" y="0"/>

                <transition activity="AddToList_1" commented="0"

                    displayName="YES" originalStyle="" points=""

                    sourceX="290" sourceY="339" status="0"

                    style="defaultEdge" targetX="138" targetY="343"

                    transitionIndex="0" value="true" x="0" y="0"/>

            </Activity>

        </superProcess>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1337088945053"

        description="Sends an email to a list of users"

        displayName="Email" height="34" interactive="0" name="Email"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Email"

        uniqueName="Email_1" waitSetting="0" width="100" x="988" y="226">

        <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot;>&lt;from class=&quot;java.lang.String&quot; />&lt;to class=&quot;java.lang.String&quot;>xpath:{/workflow/system/executor/userName}&lt;/to>&lt;subject class=&quot;java.lang.String&quot;>Client Policy Update&lt;/subject>&lt;body class=&quot;java.lang.String&quot;>&amp;lt;p&amp;gt;&#xd;&#xa;      The workflow xpath:{/workflow/system/workflow/workflowName} completed&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;b&amp;gt;Successful client updates:&amp;lt;/b&amp;gt; &#xd;&#xa;      xpath:{/workflow/variables/completedClients}&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;b&amp;gt;Failed client updates:&amp;lt;/b&amp;gt; xpath:{/workflow/variables/failedClients}&#xd;&#xa;    &amp;lt;/p&amp;gt;&lt;/body>&lt;html class=&quot;java.lang.Boolean&quot;>true&lt;/html>&lt;/email>&lt;/inputs>"/>

    </Activity>

    <schema>

        <inputs attribute="0" className="" listType="0" name="inputs"

            required="1" type="">

            <children attribute="0"

                className="commvault.msgs.CvEntities.ClientGroupEntity"

                controlType="2" displayName="Client Group" hidden="0"

                inputType="commvault.msgs.CvEntities.ClientGroupEntity"

                listType="0" name="clientGroup" required="1" type="{commvault.msgs.CvEntities}ClientGroupEntity">

                <children attribute="0" className="java.lang.String"

                    inputType="java.lang.String" listType="0"

                    name="clientGroupName" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children attribute="0" className="java.lang.Integer"

                    inputType="java.lang.Integer" listType="0"

                    name="clientGroupId" required="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            </children>

            <children attribute="0"

                className="commvault.msgs.CvEntities.StoragePolicyEntity"

                controlType="2" displayName="Storage Policy" hidden="0"

                inputType="commvault.msgs.CvEntities.StoragePolicyEntity"

                listType="0" name="storagePolicy" required="1" type="{commvault.msgs.CvEntities}StoragePolicyEntity">

                <children attribute="0" className="java.lang.String"

                    inputType="java.lang.String" listType="0"

                    name="storagePolicyName" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children attribute="0" className="java.lang.Integer"

                    inputType="java.lang.Integer" listType="0"

                    name="storagePolicyId" required="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            </children>

        </inputs>

        <variables attribute="0" className="" listType="0"

            name="variables" required="1" type="">

            <children attribute="0" className="java.lang.String"

                hidden="0" inputType="java.lang.String" listType="1"

                name="completedClients" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                hidden="0" inputType="java.lang.String" listType="1"

                name="failedClients" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

        </variables>

        <outputs className="" name="outputs" type=""/>

    </schema>

</workflow>'

IF not exists (select * from WF_Definition where Name = @name)

BEGIN
	INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision)


	VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision)

	SET @workflowId = @@IDENTITY
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


	VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

	SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = ISNULL(revision, '') From WF_Definition WHERE Name = @name

	IF (@currentFlags & 4 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0) AND (@currentRevision <> @revision)

	BEGIN

		SET @version = @version + 1

		UPDATE WF_Definition

		SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision

		WHERE Name = @name

		IF (@flags & 8 > 0 OR @flags & 16 > 0)

		BEGIN

			UPDATE WF_Definition

			SET flags = @flags

			WHERE Name = @name

		END
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


		VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

	END

END

