

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_DemoCheckReadiness.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/WFD_DemoCheckReadiness.script,v $ $Id: WFD_DemoCheckReadiness.script,v 1.5.2.3 2020/10/04 01:02:16 abilbrey Exp $";
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER ON

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.5.2.3 $'

SET @name = 'Demo_CheckReadiness'

SET @description = 'iterates through the clients in a group and performs a readiness check on them'

SET @version = 1

SET @flags = 6

SET @definition = '<workflow apiMode="0"

	description="iterates through the clients in a group and performs a readiness check on them"

	inputs="&lt;inputs>&lt;ClientGroupName class=&quot;commvault.msgs.CvEntities.ClientGroupEntity&quot;>&lt;clientGroupName />&lt;clientGroupId>0&lt;/clientGroupId>&lt;/ClientGroupName>&lt;/inputs>"

	interactive="0" isHtmlDescription="0" name="Demo_CheckReadiness"

	outputs="&lt;outputs />" revision="$Revision: 1.5.2.3 $"

	uniqueGuid="36ab3657-a146-4fec-940f-7b911917e992"

	variables="&lt;variables>&lt;success class=&quot;java.lang.String&quot; _list_=&quot;true&quot; />&lt;failed class=&quot;java.lang.String&quot; _list_=&quot;true&quot; />&lt;failedNoOwners class=&quot;java.lang.String&quot; _list_=&quot;true&quot; />&lt;/variables>">

	<schema>

		<outputs className="" name="outputs" type="" />

		<variables attribute="0" className="" listType="0" name="variables"

			required="1" type="">

			<children attribute="0" className="java.lang.String" hidden="0"

				inputType="java.lang.String" listType="1" name="success" required="0"

				type="{http://www.w3.org/2001/XMLSchema}string" />

			<children attribute="0" className="java.lang.String" hidden="0"

				inputType="java.lang.String" listType="1" name="failed" required="0"

				type="{http://www.w3.org/2001/XMLSchema}string" />

			<children attribute="0" className="java.lang.String" hidden="0"

				inputType="java.lang.String" listType="1" name="failedNoOwners"

				required="0" type="{http://www.w3.org/2001/XMLSchema}string" />

		</variables>

		<inputs attribute="0" className="" listType="0" name="inputs"

			required="1" type="">

			<children attribute="0"

				className="commvault.msgs.CvEntities.ClientGroupEntity" controlType="2"

				displayName="Client Group" hidden="0"

				inputType="commvault.msgs.CvEntities.ClientGroupEntity" listType="0"

				name="ClientGroupName" required="1"

				type="{commvault.msgs.CvEntities}ClientGroupEntity">

				<children attribute="0" className="java.lang.String"

					inputType="java.lang.String" listType="0" name="clientGroupName"

					required="0" type="{http://www.w3.org/2001/XMLSchema}string" />

				<children attribute="0" className="java.lang.Integer"

					inputType="java.lang.Integer" listType="0" name="clientGroupId"

					required="0" type="{http://www.w3.org/2001/XMLSchema}integer" />

			</children>

		</inputs>

	</schema>

	<Start breakpoint="0" commented="0" continueOnFailure="0"

		created="0" description="" displayName="Start" height="36"

		interactive="0" name="Start" originalStyle="" skipAttempt="0"

		style="image;image=/images/jgraphx/house.png" uniqueName="Start_1"

		waitSetting="0" width="61" x="24" y="210">

		<inputs val="&lt;inputs />" />

		<transition activity="CommServDBQuery_1" commented="0"

			originalStyle="" points="" sourceX="54" sourceY="228" status="0"

			style="defaultEdge" targetX="312" targetY="226" transitionIndex="0"

			x="0" y="0">

			<condition language="1"

				script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;" />

		</transition>

	</Start>

	<Activity breakpoint="0" commented="0" continueOnFailure="0"

		created="1366753045549" description="executes queries against the commserv database"

		displayName="Get Clients In Group" height="34" interactive="0"

		name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities"

		originalStyle="" skipAttempt="0" style="label;image=CommServDBQuery"

		uniqueName="CommServDBQuery_1" waitSetting="0" width="164" x="134" y="211">

		<inputs

			val="&lt;inputs>&lt;commCell />&lt;query>Select c.name&amp;#xD;&#xd;&#xa;From APP_Client c&amp;#xD;&#xd;&#xa;INNER JOIN APP_ClientGroupAssoc a ON c.id = a.clientId&amp;#xD;&#xd;&#xa;WHERE a.clientGroupId in (Select id From APP_ClientGroup Where name =N''java:{xpath:{/workflow/inputs/ClientGroupName/clientGroupName}.replaceAll(&quot;''&quot;, &quot;''''&quot;)}'')&lt;/query>&lt;/inputs>" />

		<transition activity="ForEach_1" commented="0"

			originalStyle="" points="" sourceX="206" sourceY="62" status="0"

			style="defaultEdge" targetX="483" targetY="170" transitionIndex="0"

			x="0" y="0">

			<condition

				script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;" />

		</transition>

	</Activity>

	<Activity breakpoint="0" commented="0" continueOnFailure="0"

		created="1366753062303" description="iterates a group of activities over a list of values"

		displayName="ForEach" height="379" interactive="0" name="ForEach"

		namespaceUri="commvault.cte.workflow.activities" originalStyle=""

		skipAttempt="0" style="swimlane" uniqueName="ForEach_1" waitSetting="0"

		width="824" x="353" y="39">

		<inputs

			val="&lt;inputs>&lt;name class=&quot;java.lang.String&quot;>row&lt;/name>&lt;values class=&quot;java.lang.Object&quot;>xpath:{/workflow/CommServDBQuery_1/resultSets/row}&lt;/values>&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot;>10&lt;/numberOfParallelExecutions>&lt;/inputs>" />

		<superProcess>

			<Start breakpoint="0" commented="0" continueOnFailure="0"

				created="1366753062303" description="" displayName="Start" height="30"

				interactive="0" name="Start" originalStyle="" skipAttempt="0"

				style="label;fillColor=#FFFF33;gradientColor=#FFFF00" uniqueName="Start_2"

				waitSetting="0" width="120" x="18" y="30">

				<inputs val="&lt;inputs />" />

				<transition activity="CheckReady_1" commented="0"

					originalStyle="" points="" sourceX="78" sourceY="45" status="0"

					style="defaultEdge" targetX="84" targetY="174" transitionIndex="0"

					x="0" y="0">

					<condition language="1"

						script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;" />

				</transition>

			</Start>

			<Activity breakpoint="0" commented="0" continueOnFailure="1"

				created="1366753401328" description="Sends an email to a list of users"

				displayName="Email Client Owners" height="34" interactive="0"

				maxRestarts="0" name="Email" namespaceUri="commvault.cte.workflow.activities"

				originalStyle="" skipAttempt="0" style="label;image=Email"

				uniqueName="Email_1" waitSetting="0" width="200" x="454" y="115">

				<inputs

					val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot;>&lt;from class=&quot;java.lang.String&quot; />&lt;to class=&quot;java.lang.String&quot;>xpath:{/workflow/Script_3/output}&lt;/to>&lt;subject class=&quot;java.lang.String&quot;>Readiness Checking Failure Alert&lt;/subject>&lt;body class=&quot;java.lang.String&quot;>&amp;lt;p&amp;gt;&#xd;&#xa;      The admin is alerting you that the monitored client &#xd;&#xa;      [xpath:{/workflow/ForEach_1/row/col[1]}] that you own has failed on the &#xd;&#xa;      readiness checking. Please conduct the corrective operation. &#xd;&#xa;    &amp;lt;/p&amp;gt;&lt;/body>&lt;html class=&quot;java.lang.Boolean&quot;>true&lt;/html>&lt;/email>&lt;/inputs>" />

				<transition activity="Decision_3" commented="0"

					originalStyle="" points="" sourceX="554" sourceY="132" status="0"

					style="defaultEdge" targetX="553" targetY="234" transitionIndex="0"

					x="0" y="0">

					<condition language="1"

						script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;" />

				</transition>

			</Activity>

			<Activity breakpoint="0" commented="0" continueOnFailure="1"

				created="1366834907020" description="" displayName="Check Readiness"

				height="34" interactive="0" maxRestarts="0" name="CheckReady"

				namespaceUri="commvault.cte.workflow.activities.cmd.operation"

				originalStyle="" skipAttempt="0" style="label;image=CheckReady"

				uniqueName="CheckReady_1" waitSetting="0" width="141" x="18" y="93">

				<inputs

					val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/ForEach_1/row/col[1]}&lt;/client>&lt;reportType class=&quot;workflow.types.cmd.ReportInformationType&quot; />&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot; />&lt;/sessionOptions>&lt;/inputs>" />

				<transition activity="Decision_1" commented="0"

					originalStyle="" points="" sourceX="111" sourceY="198" status="0"

					style="defaultEdge" targetX="331" targetY="198" transitionIndex="0"

					x="0" y="0">

					<condition

						script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;" />

				</transition>

			</Activity>

			<Activity breakpoint="0" commented="0" continueOnFailure="0"

				created="1366835388801" description="if/else based decision"

				displayName="Client Ready?" height="100" interactive="0" name="Decision"

				namespaceUri="commvault.cte.workflow.activities" originalStyle=""

				skipAttempt="0" style="rhombus;fontStyle=1" uniqueName="Decision_1"

				waitSetting="0" width="120" x="21" y="161">

				<inputs

					val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/CheckReady_1/exitCode}==0&lt;/expression>&lt;/inputs>" />

				<transition activity="AddToList_1" commented="0"

					displayName="Yes" originalStyle="" points="" sourceX="331" sourceY="198"

					status="0" style="defaultEdge" targetX="331" targetY="345"

					transitionIndex="0" value="true" x="0" y="0">

					<condition

						script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;" />

				</transition>

				<transition activity="Execute_1" commented="0"

					displayName="No" originalStyle="" points="" sourceX="79" sourceY="320"

					status="0" style="defaultEdge" targetX="238" targetY="326"

					transitionIndex="0" value="false" x="0" y="0">

					<condition

						script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;" />

				</transition>

			</Activity>

			<Activity breakpoint="0" commented="0" continueOnFailure="0"

				created="1366924520373" description="utility to add objects to a list"

				displayName="Add To Success List" height="34" interactive="0"

				name="AddToList" namespaceUri="commvault.cte.workflow.activities"

				originalStyle="" skipAttempt="0" style="label;image=AddToList"

				uniqueName="AddToList_1" waitSetting="0" width="160" x="12" y="311">

				<inputs

					val="&lt;inputs>&lt;addToList class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/success}&lt;/addToList>&lt;itemToAdd class=&quot;java.lang.Object&quot;>xpath:{/workflow/ForEach_1/row/col[1]}&lt;/itemToAdd>&lt;/inputs>" />

			</Activity>

			<Activity breakpoint="0" commented="0" continueOnFailure="1"

				created="1367004312173" description="" displayName="Get Client Owners"

				height="34" interactive="0" maxRestarts="0" name="Execute"

				namespaceUri="commvault.cte.workflow.activities.cmd.operation"

				originalStyle="" skipAttempt="0" style="label;image=Execute"

				uniqueName="Execute_1" waitSetting="0" width="151" x="263" y="295">

				<inputs

					val="&lt;inputs>&lt;inputXml class=&quot;java.lang.String&quot;>&amp;lt;App_GetClientPropertiesReq&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&amp;lt;association&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&amp;lt;entity&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&amp;lt;clientName&amp;gt;&amp;lt;/clientName&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&amp;lt;/entity&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&amp;lt;/association&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/App_GetClientPropertiesReq&amp;gt;&lt;/inputXml>&lt;commandArgs class=&quot;java.lang.String&quot;>-clientName xpath:{/workflow/ForEach_1/row/col[1]}&lt;/commandArgs>&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot; />&lt;/sessionOptions>&lt;/inputs>" />

				<transition activity="XPathQuery_2" commented="0"

					originalStyle="" points="" sourceX="307" sourceY="387" status="0"

					style="defaultEdge" targetX="478" targetY="386" transitionIndex="0"

					x="29" y="71">

					<condition language="1"

						script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;" />

				</transition>

			</Activity>

			<Activity breakpoint="0" commented="0" continueOnFailure="0"

				created="1367004458362" description="retrieves a list of values from xml"

				displayName="Parse Owners" height="34" interactive="0" name="XPathQuery"

				namespaceUri="commvault.cte.workflow.activities" originalStyle=""

				skipAttempt="0" style="label;image=XPathQuery" uniqueName="XPathQuery_2"

				waitSetting="0" width="124" x="279" y="234">

				<inputs

					val="&lt;inputs>&lt;xml class=&quot;java.lang.String&quot;>xpath:{/workflow/Execute_1/outputXml}&lt;/xml>&lt;xpath class=&quot;java.lang.String&quot;>/App_ClientProperties/clients/clientInfo/clientProps/clientSecurity/clientOwners&lt;/xpath>&lt;/inputs>" />

				<transition activity="Decision_2" commented="0"

					originalStyle="" points="" sourceX="341" sourceY="251" status="0"

					style="defaultEdge" targetX="343" targetY="169" transitionIndex="0"

					x="0" y="0">

					<condition language="1"

						script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;" />

				</transition>

			</Activity>

			<Activity breakpoint="0" commented="0" continueOnFailure="0"

				created="1367006118509" description="activity to execute code snippets in the selected language"

				displayName="Format email address" height="34" interactive="0" name="Script"

				namespaceUri="commvault.cte.workflow.activities" originalStyle=""

				skipAttempt="0" style="label;image=Script" uniqueName="Script_3"

				waitSetting="0" width="173" x="465" y="42">

				<inputs

					val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;StringBuilder sb = new StringBuilder();&amp;#xD;&amp;#xA;for (String u : xpath:{/workflow/XPathQuery_2/result}) {&amp;#xD;&amp;#xA;    sb.append(u).append(&amp;quot;;&amp;quot;);&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;return sb.toString();&quot; />&lt;/inputs>" />

				<transition activity="Email_1" commented="0"

					originalStyle="" points="" sourceX="471" sourceY="285" status="0"

					style="defaultEdge" targetX="473" targetY="35" transitionIndex="0"

					x="22" y="-30">

					<condition language="1"

						script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;" />

				</transition>

			</Activity>

			<Activity breakpoint="0" commented="0" continueOnFailure="0"

				created="1367009663875" description="utility to add objects to a list"

				displayName="Add To Fail List" height="34" interactive="0" name="AddToList"

				namespaceUri="commvault.cte.workflow.activities" originalStyle=""

				skipAttempt="0" style="label;image=AddToList" uniqueName="AddToList_2"

				waitSetting="0" width="131" x="494" y="321">

				<inputs

					val="&lt;inputs>&lt;addToList class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/failed}&lt;/addToList>&lt;itemToAdd class=&quot;java.lang.Object&quot;>xpath:{/workflow/ForEach_1/row/col[1]}&lt;/itemToAdd>&lt;/inputs>" />

			</Activity>

			<Activity breakpoint="0" commented="0" continueOnFailure="0"

				created="1367069544724" description="if/else based decision"

				displayName="Has Owners" height="100" interactive="0" name="Decision"

				namespaceUri="commvault.cte.workflow.activities" originalStyle=""

				skipAttempt="0" style="rhombus;fontStyle=1" uniqueName="Decision_2"

				waitSetting="0" width="111" x="284" y="110">

				<inputs

					val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/XPathQuery_2/result} != null &amp;amp;&amp;amp; xpath:{/workflow/XPathQuery_2/result}.size() &amp;gt; 0&lt;/expression>&lt;/inputs>" />

				<transition activity="Script_3" commented="0"

					displayName="Yes" originalStyle="" points="" sourceX="340" sourceY="91"

					status="0" style="defaultEdge" targetX="509" targetY="110"

					transitionIndex="0" value="true" x="0" y="0">

					<condition

						script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;" />

				</transition>

				<transition activity="AddToList_3" commented="0"

					displayName="No" originalStyle="" points="" sourceX="339" sourceY="160"

					status="0" style="defaultEdge" targetX="337" targetY="63"

					transitionIndex="0" value="false" x="0" y="0">

					<condition

						script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;" />

				</transition>

			</Activity>

			<Activity breakpoint="0" commented="0" continueOnFailure="0"

				created="1367069644759" description="utility to add objects to a list"

				displayName="AddToList" height="34" interactive="0" name="AddToList"

				namespaceUri="commvault.cte.workflow.activities" originalStyle=""

				skipAttempt="0" style="label;image=AddToList" uniqueName="AddToList_3"

				waitSetting="0" width="100" x="286" y="37">

				<inputs

					val="&lt;inputs>&lt;addToList class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/failedNoOwners}&lt;/addToList>&lt;itemToAdd class=&quot;java.lang.Object&quot;>xpath:{/workflow/ForEach_1/row/col[1]}&lt;/itemToAdd>&lt;/inputs>" />

			</Activity>

			<Activity breakpoint="0" commented="0" continueOnFailure="0"

				created="1367249111777" description="if/else based decision"

				displayName="Email Sent?" height="100" interactive="0" name="Decision"

				namespaceUri="commvault.cte.workflow.activities" originalStyle=""

				skipAttempt="0" style="rhombus;fontStyle=1" uniqueName="Decision_3"

				waitSetting="0" width="107" x="502" y="186">

				<inputs

					val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/Email_1/emailSent}&lt;/expression>&lt;/inputs>" />

				<transition activity="AddToList_2" commented="0"

					displayName="Yes" originalStyle="" points="" sourceX="555" sourceY="236"

					status="0" style="defaultEdge" targetX="553" targetY="339"

					transitionIndex="0" value="true" x="0" y="0">

					<condition

						script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;" />

				</transition>

				<transition activity="AddToList_4" commented="0"

					displayName="No" originalStyle="" points="" sourceX="555" sourceY="236"

					status="0" style="defaultEdge" targetX="694" targetY="234"

					transitionIndex="0" value="false" x="0" y="0">

					<condition

						script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;" />

				</transition>

			</Activity>

			<Activity breakpoint="0" commented="0" continueOnFailure="0"

				created="1367249148343" description="utility to add objects to a list"

				displayName="AddToList" height="34" interactive="0" name="AddToList"

				namespaceUri="commvault.cte.workflow.activities" originalStyle=""

				skipAttempt="0" style="label;image=AddToList" uniqueName="AddToList_4"

				waitSetting="0" width="100" x="664" y="219">

				<inputs

					val="&lt;inputs>&lt;addToList class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/failedNoOwners}&lt;/addToList>&lt;itemToAdd class=&quot;java.lang.Object&quot;>xpath:{/workflow/ForEach_1/row/col[1]}&lt;/itemToAdd>&lt;/inputs>" />

			</Activity>

		</superProcess>

		<activitySchema>

			<outputs name="outputs">

				<children attribute="0" className="workflow.types.data.DataRow"

					defaultValue="" hidden="0" inputType="workflow.types.data.DataRow"

					listType="0" name="row" type="{workflow.types.data}DataRow">

					<children attribute="0" className="java.lang.Object"

						defaultValue="" hidden="0" inputType="java.lang.Object" listType="1"

						name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

				</children>

			</outputs>

			<inputs>

				<children className="java.lang.String" inputType="java.lang.String"

					name="name" type="{http://www.w3.org/2001/XMLSchema}string" />

				<children className="java.lang.Object" inputType="java.lang.Object"

					name="values" type="{http://www.w3.org/2001/XMLSchema}anyType" />

				<children className="java.lang.Integer" defaultValue="1"

					inputType="java.lang.Integer" name="numberOfParallelExecutions"

					type="{http://www.w3.org/2001/XMLSchema}integer" />

				<children className="java.lang.Boolean" defaultValue="false"

					inputType="java.lang.Boolean" name="continueOnFailure"

					type="{http://www.w3.org/2001/XMLSchema}boolean" />

			</inputs>

		</activitySchema>

		<transition activity="Email_2" commented="0" originalStyle=""

			points="" sourceX="736" sourceY="264" status="0" style="defaultEdge"

			targetX="1276" targetY="261" transitionIndex="0" x="0" y="0">

			<condition language="1"

				script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;" />

		</transition>

	</Activity>

	<Activity breakpoint="0" commented="0" continueOnFailure="0"

		created="1366835771917" description="Sends an email to a list of users"

		displayName="Summary Email to Admin" height="34" interactive="0" name="Email"

		namespaceUri="commvault.cte.workflow.activities" originalStyle=""

		skipAttempt="0" style="label;image=Email" uniqueName="Email_2"

		waitSetting="0" width="195" x="1222" y="211">

		<inputs

			val="&lt;inputs>&lt;email>&lt;from />&lt;to>admin&lt;/to>&lt;subject>Summary of check readiness for client group xpath:{/workflow/inputs/ClientGroupName/clientGroupName}&lt;/subject>&lt;body>&amp;lt;div&amp;gt;&#xd;&#xa;  The following java:{xpath:{/workflow/variables/failedNoOwners}.size()} &#xd;&#xa;  clients have &amp;lt;font color=&quot;#ff3333&quot;&amp;gt;failed&amp;lt;/font&amp;gt; on the readiness check &#xd;&#xa;  and no owners were found to contact&#xd;&#xa;&amp;lt;/div&amp;gt;&#xd;&#xa;&amp;lt;div&amp;gt;&#xd;&#xa;  xpath:{/workflow/variables/failedNoOwners}&#xd;&#xa;&amp;lt;/div&amp;gt;&#xd;&#xa;&amp;lt;div&amp;gt;&#xd;&#xa;  &amp;lt;br&amp;gt;&#xd;&#xa;  &#xd;&#xa;&amp;lt;/div&amp;gt;&#xd;&#xa;&amp;lt;div&amp;gt;&#xd;&#xa;  The following java:{xpath:{/workflow/variables/failed}.size()} clients &#xd;&#xa;  have &amp;lt;font color=&quot;#ff3333&quot;&amp;gt;failed&amp;lt;/font&amp;gt; on the readiness check and &#xd;&#xa;  client owners have been alerted.&#xd;&#xa;&amp;lt;/div&amp;gt;&#xd;&#xa;&amp;lt;div&amp;gt;&#xd;&#xa;  xpath:{/workflow/variables/failed}&#xd;&#xa;&amp;lt;/div&amp;gt;&#xd;&#xa;&amp;lt;div&amp;gt;&#xd;&#xa;  &amp;lt;br&amp;gt;&#xd;&#xa;  &#xd;&#xa;&amp;lt;/div&amp;gt;&#xd;&#xa;&amp;lt;div&amp;gt;&#xd;&#xa;  The following java:{xpath:{/workflow/variables/success}.size()} clients &#xd;&#xa;  have passed the readiness check.&#xd;&#xa;&amp;lt;/div&amp;gt;&#xd;&#xa;&amp;lt;div&amp;gt;&#xd;&#xa;  xpath:{/workflow/variables/success}&#xd;&#xa;&amp;lt;/div&amp;gt;&lt;/body>&lt;html>true&lt;/html>&lt;/email>&lt;/inputs>" />

	</Activity>

</workflow>'

IF not exists (select * from WF_Definition where Name = @name)

BEGIN
	INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision)


	VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision)

	SET @workflowId = @@IDENTITY
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


	VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

	SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = ISNULL(revision, '') From WF_Definition WHERE Name = @name

	IF (@currentFlags & 4 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0) AND (@currentRevision <> @revision)

	BEGIN

		SET @version = @version + 1

		UPDATE WF_Definition

		SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision

		WHERE Name = @name

		IF (@flags & 8 > 0 OR @flags & 16 > 0)

		BEGIN

			UPDATE WF_Definition

			SET flags = @flags

			WHERE Name = @name

		END
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


		VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

	END

END

