

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_DeleteLibraryMountPathAuthorization.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- 

----------------------------------------------------------------------*/
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER ON

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @guid nvarchar(256)

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.1.2.9 $'

SET @guid = '7e2436b4-e58b-4753-be35-5e5196ca3e76'

SET @name = 'DeleteLibraryMountPathAuthorization'

SET @description = 'Workflow to authenticate delete library mount path request.'

SET @version = 1

SET @flags = 6

SET @definition = '<workflow apiMode="1" businessLogic="1"

    businessLogicExecutedBy="evmgrs,webserver"

    businessLogicMessage="EVGui_ConfigureStorageLibraryReq"

    businessLogicProcessing="Request"

    config="&lt;configuration>&lt;CONFIG_AUTH_USERS class=&quot;commvault.msgs.CvEntities.UserEntity&quot; _list_=&quot;true&quot;>&lt;userName />&lt;userId />&lt;/CONFIG_AUTH_USERS>&lt;CONFIG_AUTH_USER_GROUPS class=&quot;commvault.msgs.CvEntities.UserGroupEntity&quot; _list_=&quot;true&quot;>&lt;userGroupName />&lt;userGroupId />&lt;/CONFIG_AUTH_USER_GROUPS>&lt;/configuration>"

    description="&lt;html>&#xd;&#xa;  &lt;head>&#xd;&#xa;&#xd;&#xa;  &lt;/head>&#xd;&#xa;  &lt;body>&#xd;&#xa;    &lt;p style=&quot;margin-top: 0&quot;>&#xd;&#xa;      Workflow to authenticate delete library mount path request.&#xd;&#xa;    &lt;/p>&#xd;&#xa;  &lt;/body>&#xd;&#xa;&lt;/html>&#xd;&#xa;"

    executeOnWeb="0"

    inputs="&lt;inputs>&lt;requestXML class=&quot;workflow.types.XML&quot; _list_=&quot;false&quot;>&lt;/requestXML>&lt;processingInstruction class=&quot;workflow.types.XML&quot; _list_=&quot;false&quot;>&lt;/processingInstruction>&lt;responseXML class=&quot;workflow.types.XML&quot; _list_=&quot;false&quot;>&lt;/responseXML>&lt;/inputs>"

    interactive="1" isHtmlDescription="0" manualPercentageComplete="0"

    name="DeleteLibraryMountPathAuthorization"

    outputs="&lt;outputs>&lt;returnCode class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>&lt;/returnCode>&lt;returnString class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&lt;/returnString>&lt;outputXML class=&quot;workflow.types.XML&quot; _list_=&quot;false&quot;>&lt;/outputXML>&lt;/outputs>"

    revision="$Revision: 1.1.2.9 $" tags=""

    uniqueGuid="7e2436b4-e58b-4753-be35-5e5196ca3e76"

    variables="&lt;variables>&lt;BL_PROCEED_WITH_INPUTXML class=&quot;java.lang.Integer&quot;>1&lt;/BL_PROCEED_WITH_INPUTXML>&lt;BL_DO_NOT_PROCEED class=&quot;java.lang.Integer&quot;>3&lt;/BL_DO_NOT_PROCEED>&lt;authCode class=&quot;java.lang.String&quot; />&lt;strRequest class=&quot;java.lang.String&quot; />&lt;VAR_REQUEST_STRING class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;errorCode class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;VAR_APPROVE class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>False&lt;/VAR_APPROVE>&lt;VAR_MESSAGE_STRING class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;VAR_REQUEST_TYPE class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;VAR_OBJECT_NAME class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;VAR_OBJECT_ID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;VAR_OBJECT class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;VAR_ERROR_CODE class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>string(/EVGui_GenericResp/errorCode)&lt;/VAR_ERROR_CODE>&lt;VAR_ERROR_STRING class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>string(/EVGui_GenericResp/errorMessage)&lt;/VAR_ERROR_STRING>&lt;VAR_CUSTOM_MESSAGE_TO_USER class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;libraryId class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>0&lt;/libraryId>&lt;VAR_USER_LIST class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;OperationType class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;authorizedUsers class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;VAR_LOOPBACK class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;VAR_CUSTOM_MSG_MAIL class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;isUserConfigured class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>0&lt;/isUserConfigured>&lt;isAuthorizationRequired class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>0&lt;/isAuthorizationRequired>&lt;MountPathId class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>0&lt;/MountPathId>&lt;libraryName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&lt;/libraryName>&lt;/variables>"

    webHidden="0" workflowId="0">

    <schema>

        <outputs attribute="0" className="" listType="0" name="outputs"

            required="1" type="">

            <children attribute="0" className="java.lang.Integer"

                defaultValue="" hidden="0" inputType="java.lang.Integer"

                listType="0" name="returnCode" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.String"

                defaultValue="" hidden="0" inputType="java.lang.String"

                listType="0" name="returnString" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="workflow.types.XML"

                defaultValue="" hidden="0"

                inputType="workflow.types.XML" listType="0"

                name="outputXML" type="{workflow.types}XML"/>

        </outputs>

        <variables attribute="0" className="" listType="0"

            name="variables" required="1" type="">

            <children attribute="0" className="java.lang.Integer"

                controlType="0" defaultValue="1" displayName=""

                documentation="" hidden="0"

                inputType="java.lang.Integer" listType="0"

                name="BL_PROCEED_WITH_INPUTXML" readOnly="0"

                required="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.Integer"

                controlType="0" defaultValue="3" displayName=""

                documentation="" hidden="0"

                inputType="java.lang.Integer" listType="0"

                name="BL_DO_NOT_PROCEED" readOnly="0" required="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" displayName="" documentation=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="authCode" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" displayName="" documentation=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="strRequest" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" displayName="" documentation=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="VAR_REQUEST_STRING" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.Integer"

                controlType="0" displayName="" documentation=""

                hidden="0" inputType="java.lang.Integer" listType="0"

                name="errorCode" readOnly="0" required="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="False" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="VAR_APPROVE" readOnly="0"

                required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" displayName="" documentation=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="VAR_MESSAGE_STRING" readOnly="0" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" displayName="" documentation=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="VAR_REQUEST_TYPE" readOnly="0" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" displayName="" documentation=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="VAR_OBJECT_NAME" readOnly="0" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" displayName="" documentation=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="VAR_OBJECT_ID" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" displayName="" documentation=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="VAR_OBJECT" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0"

                defaultValue="string(/EVGui_ConfigureStorageLibraryResp/library/errorCode)"

                displayName="" documentation="" hidden="0"

                inputType="java.lang.String" listType="0"

                name="VAR_ERROR_CODE" readOnly="0" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0"

                defaultValue="string(/EVGui_ConfigureStorageLibraryResp/library/errorString)"

                displayName="" documentation="" hidden="0"

                inputType="java.lang.String" listType="0"

                name="VAR_ERROR_STRING" readOnly="0" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="VAR_CUSTOM_MESSAGE_TO_USER" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.Integer"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0"

                inputType="java.lang.Integer" listType="0"

                name="libraryId" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="VAR_USER_LIST" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.Integer"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0"

                inputType="java.lang.Integer" listType="0"

                name="OperationType" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="authorizedUsers" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="VAR_LOOPBACK" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="VAR_CUSTOM_MSG_MAIL" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.Integer"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0"

                inputType="java.lang.Integer" listType="0"

                name="isUserConfigured" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.Integer"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0"

                inputType="java.lang.Integer" listType="0"

                name="isAuthorizationRequired" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.Integer"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0"

                inputType="java.lang.Integer" listType="0"

                name="MountPathId" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" hidden="0"

                inputType="java.lang.String" listType="0"

                name="libraryName" type="{http://www.w3.org/2001/XMLSchema}string"/>

        </variables>

        <inputs attribute="0" className="" listType="0" name="inputs"

            required="1" type="">

            <children attribute="0" className="workflow.types.XML"

                defaultValue="" hidden="0"

                inputType="workflow.types.XML" listType="0"

                name="requestXML" type="{workflow.types}XML"/>

            <children attribute="0" className="workflow.types.XML"

                defaultValue="" displayName="" hidden="0"

                inputType="workflow.types.XML" listType="0"

                name="processingInstruction" type="{workflow.types}XML"/>

            <children attribute="0" className="workflow.types.XML"

                defaultValue="" hidden="0"

                inputType="workflow.types.XML" listType="0"

                name="responseXML" type="{workflow.types}XML"/>

        </inputs>

        <config attribute="0" className="" name="configuration" type="">

            <children attribute="0"

                className="commvault.msgs.CvEntities.UserEntity"

                controlHidden="0" controlType="2" defaultValue=""

                displayName="Configure Users who can authenticate the request"

                documentation="" hidden="0"

                inputType="commvault.msgs.CvEntities.UserEntity"

                listType="1" maximumValue="" minimumValue=""

                name="CONFIG_AUTH_USERS" readOnly="0" required="0"

                searchable="0" type="{commvault.msgs.CvEntities}UserEntity">

                <children attribute="0" className="java.lang.String"

                    defaultValue="" inputType="java.lang.String"

                    listType="0" name="userName" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children attribute="0" className="java.lang.Integer"

                    defaultValue="" inputType="java.lang.Integer"

                    listType="0" name="userId" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            </children>

            <children attribute="0"

                className="commvault.msgs.CvEntities.UserGroupEntity"

                controlHidden="0" controlType="2" defaultValue=""

                displayName="Configure User Groups which can authenticate the request"

                documentation="" hidden="0"

                inputType="commvault.msgs.CvEntities.UserGroupEntity"

                listType="1" maximumValue="" minimumValue=""

                name="CONFIG_AUTH_USER_GROUPS" readOnly="0" required="0"

                searchable="0" type="{commvault.msgs.CvEntities}UserGroupEntity">

                <children attribute="0" className="java.lang.String"

                    defaultValue="" inputType="java.lang.String"

                    listType="0" name="userGroupName" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children attribute="0" className="java.lang.Integer"

                    defaultValue="" inputType="java.lang.Integer"

                    listType="0" name="userGroupId" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            </children>

        </config>

    </schema>

    <Start commented="0" continueOnFailure="0" created="0"

        description="" displayName="Start" height="36" interactive="0"

        jobMode="0" name="Start" originalStyle="" skipAttempt="0"

        style="image;image=/images/jgraphx/house.png"

        uniqueName="Start_1" waitSetting="0" width="61" x="7" y="26">

        <onExit language="4" script="workflow.setLoggingDisabled(false);"/>

        <inputs val="&lt;inputs />"/>

        <transition activity="Script_1" commented="0" originalStyle=""

            points="" sourceX="37" sourceY="44" status="0"

            style="defaultEdge" targetX="76" targetY="180"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Start>

    <Activity commented="0" continueOnFailure="0"

        created="1445363271018" description="Ends the workflow"

        displayName="Allow Server to process request" height="35"

        interactive="0" jobMode="0" name="WorkflowEnd"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=WorkflowEnd"

        uniqueName="AllowServertoprocessrequest" waitSetting="0"

        width="255" x="375" y="186">

        <outputs outputs="&lt;outputs>&lt;returnCode class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/BL_PROCEED_WITH_INPUTXML}&lt;/returnCode>&lt;returnString class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>Success&lt;/returnString>&lt;/outputs>"/>

        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot;>COMPLETED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot; />&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1445894442223"

        description="activity to execute code snippets in the selected language"

        displayName="Set Vars" height="34" interactive="0" jobMode="0"

        name="Script" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Script"

        uniqueName="Script_1" waitSetting="0" width="128" x="-25" y="347">

        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;XML inXML = xpath:{/workflow/inputs/requestXML};&amp;#xD;&amp;#xA;XML reqXml = inXML.selectSingleNode(&amp;quot;/requestXML/*&amp;quot;);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;String requestStr = &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;strRequest&amp;quot;, reqXml.toString());&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;VAR_REQUEST_TYPE&amp;quot;,reqXml.getName());&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;String objectOpType = reqXml.selectSingleNode(&amp;quot;string(//./library/@opType)&amp;quot;);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if ( objectOpType != null &amp;amp;&amp;amp; !objectOpType.equals(&amp;quot;&amp;quot;))&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    if (objectOpType.equals(&amp;quot;8192&amp;quot;) || objectOpType.equals(&amp;quot;1024&amp;quot;))&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        // send approcal only for library or mountpath delete operation &amp;#xD;&amp;#xA;        workflow.setVariable(&amp;quot;VAR_APPROVE&amp;quot;,&amp;quot;False&amp;quot;);&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        int operationTypeId  = Integer.parseInt(objectOpType);&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;workflow.setVariable(&amp;quot;OperationType&amp;quot;,operationTypeId);&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;// Getting LibraryId to find the admin list to approve &amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;String libraryIdStr = reqXml.selectSingleNode(&amp;quot;string(//./library/@libraryId)&amp;quot;);&amp;#xD;&amp;#xA;        if(libraryIdStr != null &amp;amp;&amp;amp; !libraryIdStr.equals(&amp;quot;&amp;quot;))&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            int libraryId  = Integer.parseInt(libraryIdStr);&amp;#xD;&amp;#xA;            workflow.setVariable(&amp;quot;libraryId&amp;quot;, libraryId);     &amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;String messageStr = &amp;quot;&amp;lt;br&amp;gt;CommServe Name - &amp;quot; + xpath:{/workflow/system/commCellName} + &amp;quot;&amp;lt;br&amp;gt;&amp;quot;;&amp;#xD;&amp;#xA;        if (objectOpType.equals(&amp;quot;1024&amp;quot;))&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            requestStr = &amp;quot;Delete Mount Path&amp;quot;;&amp;#xD;&amp;#xA;            workflow.setVariable(&amp;quot;VAR_MESSAGE_STRING&amp;quot;,&amp;quot;An email has been sent to the administrator to authorize the request. The library mount path will be automatically deleted once the request is accepted.&amp;quot;);&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;&amp;#x9;&amp;#x9;&amp;#x9;&amp;#x9;&amp;#x9;&amp;#x9;&amp;#xD;&amp;#xA;            String mountpathIdStr = reqXml.selectSingleNode(&amp;quot;string(//./library/@mountPathId)&amp;quot;);&amp;#xD;&amp;#xA;            if(mountpathIdStr != null &amp;amp;&amp;amp; !mountpathIdStr.equals(&amp;quot;&amp;quot;))&amp;#xD;&amp;#xA;            {&amp;#xD;&amp;#xA;                int mountpathId  = Integer.parseInt(mountpathIdStr);&amp;#xD;&amp;#xA;                workflow.setVariable(&amp;quot;MountPathId&amp;quot;,mountpathId);&amp;#xD;&amp;#xA;            }&amp;#xD;&amp;#xA;            &amp;#xD;&amp;#xA;            String mountpath = reqXml.selectSingleNode(&amp;quot;string(//./library/@mountPath)&amp;quot;);&amp;#xD;&amp;#xA;            &amp;#xD;&amp;#xA;            String LibraryName = reqXml.selectSingleNode(&amp;quot;string(//./library/@libraryName)&amp;quot;);&amp;#xD;&amp;#xA;            messageStr = messageStr + &amp;quot;Library Name - &amp;quot; + LibraryName + &amp;quot;&amp;lt;br&amp;gt;&amp;quot;;&amp;#xD;&amp;#xA;            messageStr = messageStr + &amp;quot;Mount Path requested for deletion: &amp;quot; + mountpath + &amp;quot;\n&amp;quot;; &amp;#xD;&amp;#xA;            &amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;&amp;#x9;workflow.setVariable(&amp;quot;VAR_OBJECT_NAME&amp;quot;,mountpath + &amp;quot; from Library - &amp;quot; + LibraryName);&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;&amp;#x9;workflow.setVariable(&amp;quot;libraryName&amp;quot;,LibraryName);&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;&amp;#x9;&amp;#xD;&amp;#xA;        } &amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;else&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;{&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;&amp;#x9;requestStr = &amp;quot;Delete Library&amp;quot;; &amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;&amp;#x9;workflow.setVariable(&amp;quot;VAR_MESSAGE_STRING&amp;quot;,&amp;quot;An email has been sent to the administrator to authorize the request. The library will be automatically deleted once the request is accepted.&amp;quot;); &amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;&amp;#x9;workflow.setVariable(&amp;quot;VAR_OBJECT_NAME&amp;quot;,reqXml.selectSingleNode(&amp;quot;string(//./library/@libraryName)&amp;quot;));&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;&amp;#x9;workflow.setVariable(&amp;quot;libraryName&amp;quot;,reqXml.selectSingleNode(&amp;quot;string(//./library/@libraryName)&amp;quot;));&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;logger.info(&amp;quot;INFO: Operation : &amp;quot; + requestStr);&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;workflow.setVariable(&amp;quot;VAR_REQUEST_STRING&amp;quot;,requestStr);&amp;#xD;&amp;#xA;        workflow.setVariable(&amp;quot;VAR_CUSTOM_MESSAGE_TO_USER&amp;quot;, messageStr);&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    else&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;logger.info(&amp;quot;This operation not required approval, proceeding further...&amp;quot;);&amp;#xD;&amp;#xA;        workflow.setVariable(&amp;quot;VAR_APPROVE&amp;quot;,&amp;quot;True&amp;quot;);&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;}    &amp;#xD;&amp;#xA;else&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;&amp;#x9;logger.info(&amp;quot;Invalid operation type proceeding further...&amp;quot;);&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;VAR_APPROVE&amp;quot;,&amp;quot;True&amp;quot;); &amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;String myObject= &amp;quot;&amp;quot;+workflow.getVariable(&amp;quot;VAR_OBJECT_NAME&amp;quot;)+&amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;VAR_OBJECT&amp;quot;,myObject);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;logger.info(&amp;quot;INFO: VAR_MESSAGE_STRING: &amp;quot;+workflow.getVariable(&amp;quot;VAR_MESSAGE_STRING&amp;quot;)+&amp;quot;&amp;quot;);&amp;#xD;&amp;#xA;logger.info(&amp;quot;INFO: VAR_REQUEST_TYPE : [&amp;quot; + workflow.getVariable(&amp;quot;VAR_REQUEST_TYPE&amp;quot;) + &amp;quot;] &amp;quot;);&amp;#xD;&amp;#xA;logger.info(&amp;quot;INFO: VAR_OBJECT = &amp;quot;+ workflow.getVariable(&amp;quot;VAR_OBJECT&amp;quot;) +&amp;quot;&amp;quot;);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;/*&amp;#xD;&amp;#xA;Case 1: If User or User Group set then approval request mail will send to that users  &amp;#xD;&amp;#xA;Case 2: If User or User Group is not set then send mail to admin group users&amp;#xD;&amp;#xA;*/&amp;#xD;&amp;#xA;int is_approver_available = 0;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if (xpath:{/workflow/configuration/CONFIG_AUTH_USERS/userName} != null &amp;amp;&amp;amp; xpath:{/workflow/configuration/CONFIG_AUTH_USERS/userName} != &amp;quot;&amp;quot;)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;INFO: Configured users [&amp;quot;+ xpath:{/workflow/configuration/CONFIG_AUTH_USERS/userName} +&amp;quot;] to authorize &amp;quot;+xpath:{/workflow/variables/VAR_REQUEST_STRING}+&amp;quot; request&amp;quot;);&amp;#xD;&amp;#xA;    is_approver_available++;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if (xpath:{/workflow/configuration/CONFIG_AUTH_USER_GROUPS/userGroupName} != null &amp;amp;&amp;amp; xpath:{/workflow/configuration/CONFIG_AUTH_USER_GROUPS/userGroupName} != &amp;quot;&amp;quot;)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;INFO: Configured user groups [&amp;quot;+ xpath:{/workflow/configuration/CONFIG_AUTH_USER_GROUPS/userGroupName} +&amp;quot;] to authorize &amp;quot;+xpath:{/workflow/variables/VAR_REQUEST_STRING}+&amp;quot; request&amp;quot;);&amp;#xD;&amp;#xA;    is_approver_available++;  &amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if(is_approver_available &amp;gt; 0)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;isUserConfigured&amp;quot;, 1);&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&quot; />&lt;/inputs>"/>

        <transition activity="ImpersonateCreator_1" commented="0"

            originalStyle="" points="" sourceX="69" sourceY="311"

            status="0" style="defaultEdge;dashed=1" targetX="197"

            targetY="172" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;!(xpath:{/workflow/variables/VAR_APPROVE}.equals(&quot;True&quot;));"/>

        </transition>

        <transition activity="AllowServertoprocessrequest" commented="0"

            originalStyle="" points="502.0,367.0" sourceX="196"

            sourceY="44" status="0" style="defaultEdge;dashed=1"

            targetX="376" targetY="115" transitionIndex="0" x="0" y="0">

            <condition language="1" script="!(xpath:{/workflow/variables/VAR_APPROVE}.equals(&quot;False&quot;));"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1452723299590"

        description="ends the interactive user session"

        displayName="EndUserSessionWithOutputs" height="34"

        interactive="0" jobMode="0" name="EndUserSessionWithOutputs"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=EndUserSessionWithOutputs"

        uniqueName="EndUserSessionWithOutputs_1" waitSetting="0"

        width="195" x="692" y="30">

        <inputs val="&lt;inputs>&lt;returnCode class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/BL_DO_NOT_PROCEED}&lt;/returnCode>&lt;returnString class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/VAR_MESSAGE_STRING}&lt;/returnString>&lt;outputXML class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&amp;lt;EVGui_GenericResp&amp;gt;   &amp;#xD;  &amp;lt;errorCode&amp;gt;-2&amp;lt;/errorCode&amp;gt;&amp;#xD;  &amp;lt;errorMessage&amp;gt;xpath:{/workflow/variables/VAR_MESSAGE_STRING}&amp;lt;/errorMessage&amp;gt;&amp;#xD; &amp;lt;/EVGui_GenericResp&amp;gt;&lt;/outputXML>&lt;/inputs>"/>

        <activitySchema>

            <outputs attribute="0" className="" listType="0"

                name="outputs" required="1" type="">

                <children attribute="0" className="java.lang.Integer"

                    controlType="0" defaultValue="" displayName=""

                    documentation="" hidden="0"

                    inputType="java.lang.Integer" listType="0"

                    name="returnCode" readOnly="0" required="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                <children attribute="0" className="java.lang.String"

                    controlType="0" defaultValue="" displayName=""

                    documentation="" hidden="0"

                    inputType="java.lang.String" listType="0"

                    name="returnString" readOnly="0" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children attribute="0" className="java.lang.String"

                    controlType="0" defaultValue="" displayName=""

                    documentation="" hidden="0"

                    inputType="java.lang.String" listType="0"

                    name="outputXML" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            </outputs>

        </activitySchema>

        <transition activity="SwitchToJob_1" commented="0"

            originalStyle="" points="" sourceX="789" sourceY="47"

            status="0" style="defaultEdge" targetX="1024" targetY="51"

            transitionIndex="0" x="0" y="0">

            <condition language="4" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1480959366124"

        description="check if input request is signed"

        displayName="IsRequestSigned" height="34" interactive="0"

        jobMode="0" name="IsRequestSigned"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.IsRequestSigned"

        uniqueName="IsRequestSigned_1" waitSetting="0" width="126"

        x="461" y="41">

        <inputs val="&lt;inputs>&lt;request class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/strRequest}&lt;/request>&lt;/inputs>"/>

        <transition activity="EndUserSessionWithOutputs_1" commented="0"

            displayName="needs approval" originalStyle="" points=""

            sourceX="257" sourceY="135" status="0"

            style="defaultEdge;dashed=1" targetX="789" targetY="43"

            transitionIndex="0" x="74" y="11">

            <condition language="1" script="!(xpath:{/workflow/IsRequestSigned_1/signed});"/>

        </transition>

        <transition activity="AllowServertoprocessrequest" commented="0"

            displayName="valid" originalStyle="" points="" sourceX="183"

            sourceY="124" status="0" style="defaultEdge;dashed=1"

            targetX="397" targetY="115" transitionIndex="0" x="0" y="0">

            <condition language="1" script="(xpath:{/workflow/IsRequestSigned_1/signed});"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1483586947160"

        description="switches an API job to a regular job"

        displayName="SwitchToJob" height="34" interactive="0"

        jobMode="0" name="SwitchToJob"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.SwitchToJobActivity"

        uniqueName="SwitchToJob_1" waitSetting="0" width="104" x="951" y="37">

        <inputs val="&lt;inputs />"/>

        <transition activity="ProcessBlock_1" commented="0"

            originalStyle="" points="" sourceX="1003" sourceY="86"

            status="0" style="defaultEdge" targetX="1180" targetY="53"

            transitionIndex="0" x="74" y="11">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1541765572169"

        description="executes queries against a commcell database"

        displayName="Authorization &#xa;Required?" height="34"

        interactive="0" jobMode="0" name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.CommServDBQuery;gradientColor=#FFFFCC"

        uniqueName="CommServDBQuery_6" waitSetting="0" width="108"

        x="194" y="258">

        <onExit language="1" script="import java.util.ArrayList;&#xd;&#xa;import java.util.List;&#xd;&#xa;import commvault.msgs.CvEntities.UserEntity;&#xd;&#xa;    &#xd;&#xa;int isAuthorizationNeeded = xpath:{/workflow/CommServDBQuery_6/resultSets[2]/row/col};&#xd;&#xa;if (isAuthorizationNeeded &lt; 0)&#xd;&#xa;{&#xd;&#xa;     logger.info(&quot;Error in finding users list...&quot;);&#xd;&#xa;     workflow.setVariable(&quot;VAR_MESSAGE_STRING&quot;,&quot;Invalid input received...&quot;);&#xd;&#xa;} &#xd;&#xa;else if( (xpath:{/workflow/CommServDBQuery_6/resultSets[1]/row/col[1]} &amp; 2) == 0)&#xd;&#xa;{&#xd;&#xa;    // Mountpath does not have data then no need to send mail for approval    MP_DELETE_HAS_VALID_DATA  - 2&#xd;&#xa;    isAuthorizationNeeded = 0;&#xd;&#xa;    logger.info(&quot;Library or MountPath does not have any data, authorization not required... &quot;);   &#xd;&#xa;}&#xd;&#xa;else if (isAuthorizationNeeded == 0) &#xd;&#xa;{&#xd;&#xa;    logger.info(&quot;No other user in admin group to approve delete request. Authorization not required...&quot;);&#xd;&#xa;}&#xd;&#xa;else &#xd;&#xa;{&#xd;&#xa;    // If Mount path has data then proceed with approval.    &#xd;&#xa;    logger.info(&quot;Authorization Required... &quot;);   &#xd;&#xa;    &#xd;&#xa;    // If users not configured in workflow, then sending mail to admin groups    &#xd;&#xa;    if(xpath:{/workflow/CommServDBQuery_6/resultSets[3]/row/col} != null &amp;&amp; xpath:{/workflow/CommServDBQuery_6/resultSets[3]/row/col} != &quot;&quot; &amp;&amp; xpath:{/workflow/CommServDBQuery_6/resultSets[3]/rowCount} > 0 )&#xd;&#xa;    {&#xd;&#xa;        List users = new ArrayList();&#xd;&#xa;                 &#xd;&#xa;        DataSet ds =  xpath:{/workflow/CommServDBQuery_6/resultSets}.get(2);&#xd;&#xa;        while (ds.hasNext())&#xd;&#xa;        {&#xd;&#xa;            UserEntity userEntity = new UserEntity();&#xd;&#xa;            userEntity.setUserId(ds.get(0));&#xd;&#xa;            userEntity.setUserName(ds.get(1));&#xd;&#xa;            users.add(userEntity);&#xd;&#xa;            logger.info(&quot;INFO: Will send mail to User [&quot;+ ds.get(1) + &quot;], id [&quot;+ ds.get(0) +&quot;] to authorize &quot;+xpath:{/workflow/variables/VAR_REQUEST_STRING}+&quot; request&quot;);&#xd;&#xa;        }&#xd;&#xa;        workflow.setVariable(&quot;authorizedUsers&quot;, users);      &#xd;&#xa;    }&#xd;&#xa;  &#xd;&#xa;    // Adding Moutn path force delete reason in mail content &#xd;&#xa;    String messageStr = xpath:{/workflow/variables/VAR_CUSTOM_MESSAGE_TO_USER};&#xd;&#xa;    messageStr = messageStr + &quot;&lt;br>&quot; + xpath:{/workflow/CommServDBQuery_6/resultSets[1]/row/col[2]};&#xd;&#xa;    workflow.setVariable(&quot;VAR_CUSTOM_MESSAGE_TO_USER&quot;, messageStr);&#xd;&#xa;      &#xd;&#xa;    if( xpath:{/workflow/variables/OperationType} == 1024)&#xd;&#xa;    {  &#xd;&#xa;        logger.info(&quot;Mount Path Force delete validation: &quot;+xpath:{/workflow/CommServDBQuery_6/resultSets[1]/row/col[2]});&#xd;&#xa;    }&#xd;&#xa;    else&#xd;&#xa;    {&#xd;&#xa;        logger.info(&quot;Library Force delete validation: &quot;+xpath:{/workflow/CommServDBQuery_6/resultSets[1]/row/col[2]});&#xd;&#xa;    }&#xd;&#xa;}&#xd;&#xa;&#xd;&#xa;workflow.setVariable(&quot;isAuthorizationRequired&quot;,isAuthorizationNeeded);&#xd;&#xa;logger.info(&quot;isAuthorizationNeeded - &quot; + isAuthorizationNeeded);"/>

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>DECLARE @IsAuthorizationRequired INTEGER = 0&amp;#xD;&#xd;&#xa;DECLARE @LibraryId Integer = xpath:{/workflow/variables/libraryId}&amp;#xD;&#xd;&#xa; &amp;#xD;&#xd;&#xa;IF @LibraryId = 0&amp;#xD;&#xd;&#xa;BEGIN&amp;#xD;&#xd;&#xa;    SELECT @LibraryId = LibraryId FROM MMLibrary WHERE AliasName = ''xpath:{/workflow/variables/libraryName}''&amp;#xD;&#xd;&#xa;END&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;DECLARE @UsersTable TABLE(id int, login varchar(1024))&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;IF @LibraryId &amp;gt; 0&amp;#xD;&#xd;&#xa;BEGIN&amp;#xD;&#xd;&#xa;    -- To check Mount path or library hass data&amp;#xD;&#xd;&#xa;    EXEC MMCheckMPCanDelete xpath:{/workflow/variables/MountPathId}, @LibraryId&amp;#xD;&#xd;&#xa;    &amp;#xD;&#xd;&#xa;    IF xpath:{/workflow/variables/isUserConfigured} &amp;gt; 0&amp;#xD;&#xd;&#xa;    BEGIN&amp;#xD;&#xd;&#xa;        DECLARE @usersTbl TABLE(id INTEGER)&amp;#xD;&#xd;&#xa;        DECLARE @Users VARCHAR(MAX) = ''''&amp;#xD;&#xd;&#xa;        &amp;#xD;&#xd;&#xa;        IF ''xpath:{/workflow/configuration/CONFIG_AUTH_USERS/userId}'' &amp;lt;&amp;gt; ''null''&amp;#xD;&#xd;&#xa;        BEGIN&amp;#xD;&#xd;&#xa;            &amp;#xD;&#xd;&#xa;            SELECT @Users = ''xpath:{/workflow/configuration/CONFIG_AUTH_USERS/userId}''&amp;#xD;&#xd;&#xa;            -- Removing start and end []&amp;#xD;&#xd;&#xa;            IF CHARINDEX(''['', @Users) = 1&amp;#xD;&#xd;&#xa;                Select @Users = LEFT(RIGHT(@Users, len(@Users)-1),len(@Users)-2)&amp;#xD;&#xd;&#xa;            -- Getting users list in table &amp;#xD;&#xd;&#xa;            INSERT INTO @usersTbl &amp;#xD;&#xd;&#xa;            select CAST(Data AS INT) from split(@users,'','')&amp;#xD;&#xd;&#xa;            &amp;#xD;&#xd;&#xa;            INSERT INTO @UsersTable&amp;#xD;&#xd;&#xa;            SELECT U.id, U.login from UMUsers U WITH(NOLOCK)&amp;#xD;&#xd;&#xa;            INNER JOIN @usersTbl TMP ON U.id = TMP.id AND U.id &amp;lt;&amp;gt; xpath:{/workflow/system/executor/userId} &amp;#xD;&#xd;&#xa;            AND (U.flags &amp;amp; dbo.sec_getExcludeFlagsForUser()) = 0&amp;#xD;&#xd;&#xa;        END&amp;#xD;&#xd;&#xa;        &amp;#xD;&#xd;&#xa;        IF ''xpath:{/workflow/configuration/CONFIG_AUTH_USER_GROUPS/userGroupId}'' &amp;lt;&amp;gt; ''null''&amp;#xD;&#xd;&#xa;        BEGIN&amp;#xD;&#xd;&#xa;            &amp;#xD;&#xd;&#xa;            SELECT @Users = ''xpath:{/workflow/configuration/CONFIG_AUTH_USER_GROUPS/userGroupId}''&amp;#xD;&#xd;&#xa;            -- Removing start and end []&amp;#xD;&#xd;&#xa;            IF CHARINDEX(''['', @Users) = 1&amp;#xD;&#xd;&#xa;                Select @Users = LEFT(RIGHT(@Users, len(@Users)-1),len(@Users)-2)&amp;#xD;&#xd;&#xa;            -- Getting users list in table &amp;#xD;&#xd;&#xa;            INSERT INTO @usersTbl &amp;#xD;&#xd;&#xa;            select CAST(Data AS INT) from split(@users,'','')&amp;#xD;&#xd;&#xa;            &amp;#xD;&#xd;&#xa;            INSERT INTO @UsersTable&amp;#xD;&#xd;&#xa;            SELECT U.id, U.login from UMUserGroup UUG WITH(NOLOCK) &amp;#xD;&#xd;&#xa;            INNER JOIN @usersTbl TMP ON TMP.id = UUG.groupId&amp;#xD;&#xd;&#xa;            INNER JOIN UMUsers U WITH(NOLOCK) ON UUG.userId = U.id AND UUG.userId &amp;lt;&amp;gt; xpath:{/workflow/system/executor/userId} &amp;#xD;&#xd;&#xa;            AND (U.flags &amp;amp; dbo.sec_getExcludeFlagsForUser()) = 0&amp;#xD;&#xd;&#xa;        END&amp;#xD;&#xd;&#xa;                     &amp;#xD;&#xd;&#xa;        IF EXISTS(SELECT 1 FROM @UsersTable)&amp;#xD;&#xd;&#xa;            SET @IsAuthorizationRequired = 1&amp;#xD;&#xd;&#xa;        ELSE&amp;#xD;&#xd;&#xa;            SET @IsAuthorizationRequired = 0    -- No users in group to send mail&amp;#xD;&#xd;&#xa;        &amp;#xD;&#xd;&#xa;    END&amp;#xD;&#xd;&#xa;    ELSE&amp;#xD;&#xd;&#xa;    BEGIN&amp;#xD;&#xd;&#xa;                &amp;#xD;&#xd;&#xa;            DECLARE @GroupId INT = 0&amp;#xD;&#xd;&#xa;            DECLARE @UMDSProvider INT = 0&amp;#xD;&#xd;&#xa;            &amp;#xD;&#xd;&#xa;            SELECT @UMDSProvider = companyId FROM UMSecurityAssociations WITH(NOLOCK) WHERE isCreator = 1 AND entityType1 = 9 /* LIBRARY_ENTITY */ AND entityId1 = @LibraryId &amp;#xD;&#xd;&#xa;            &amp;#xD;&#xd;&#xa;            IF @UMDSProvider = 0&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;-- Commcell Normal User, Commcell AD User&amp;#xD;&#xd;&#xa;            BEGIN&amp;#xD;&#xd;&#xa;                SET @GroupId = 1&#x9;/* US_ADMIN_GROUP_ID */&#x9;-- Use Master Admin Group&amp;#xD;&#xd;&#xa;            END&amp;#xD;&#xd;&#xa;            ELSE           &#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;-- Company Normal User, Company AD user &amp;#xD;&#xd;&#xa;            BEGIN&amp;#xD;&#xd;&#xa;                SELECT @GroupId = id FROM UMGroups WITH(NOLOCK) WHERE umdsProviderId = @UMDSProvider AND (groupFlags &amp;amp; 65536 /* GF_GROUP_TENANT_ADMIN */) &amp;gt; 0&#x9;&#x9;-- Use Company Admin Group &#x9; &amp;#xD;&#xd;&#xa;            END&amp;#xD;&#xd;&#xa;            &amp;#xD;&#xd;&#xa;            &amp;#xD;&#xd;&#xa;            INSERT INTO @UsersTable&amp;#xD;&#xd;&#xa;            SELECT U.id, U.login from UMUserGroup UUG WITH(NOLOCK) &amp;#xD;&#xd;&#xa;            INNER JOIN UMUsers U WITH(NOLOCK) ON UUG.groupId = @GroupId AND UUG.userId = U.id AND UUG.userId &amp;lt;&amp;gt; xpath:{/workflow/system/executor/userId} &amp;#xD;&#xd;&#xa;            AND (U.flags &amp;amp; dbo.sec_getExcludeFlagsForUser()) = 0&amp;#xD;&#xd;&#xa;              &amp;#xD;&#xd;&#xa;            &amp;#xD;&#xd;&#xa;            IF EXISTS(SELECT 1 FROM @UsersTable)&amp;#xD;&#xd;&#xa;                SET @IsAuthorizationRequired = 1&amp;#xD;&#xd;&#xa;            ELSE&amp;#xD;&#xd;&#xa;                SET @IsAuthorizationRequired = 0    -- No users in group to send mail&amp;#xD;&#xd;&#xa;    END&amp;#xD;&#xd;&#xa;END&amp;#xD;&#xd;&#xa;ELSE&amp;#xD;&#xd;&#xa;BEGIN        &amp;#xD;&#xd;&#xa;    SELECT 0, '''', '''' ,''''&amp;#xD;&#xd;&#xa;    SET @IsAuthorizationRequired = -1&amp;#xD;&#xd;&#xa;    &amp;#xD;&#xd;&#xa;END&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;SELECT @IsAuthorizationRequired&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;SELECT id, login FROM @UsersTable &amp;#xD;&#xd;&#xa;&lt;/query>&lt;/inputs>"/>

        <transition activity="ImpersonateExecutor_1" commented="0"

            originalStyle="" points="" sourceX="179" sourceY="242"

            status="0" style="defaultEdge" targetX="135" targetY="191"

            transitionIndex="0" x="10" y="10">

            <condition language="1" script="xpath:{/workflow/variables/isAuthorizationRequired} == 0 || xpath:{/workflow/variables/isAuthorizationRequired} > 0;"/>

        </transition>

        <transition activity="EndUserSessionWithOutputs_2" commented="0"

            originalStyle="" points="198.0,161.0" sourceX="185"

            sourceY="191" status="0" style="defaultEdge" targetX="748"

            targetY="44" transitionIndex="0" x="0" y="0">

            <condition language="1" script="xpath:{/workflow/variables/isAuthorizationRequired} &lt; 0;"/>

        </transition>

        <onEnter language="1" script="logger.info(&quot;libraryID - &quot; + xpath:{/workflow/variables/libraryId});&#xd;&#xa;&#xd;&#xa;"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1553124093298"

        description="impersonates the user who created the workflow"

        displayName="IC" height="34" interactive="0" jobMode="0"

        name="ImpersonateCreator"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.ImpersonateCreator"

        uniqueName="ImpersonateCreator_1" waitSetting="0" width="61"

        x="79" y="261">

        <inputs val="&lt;inputs />"/>

        <transition activity="CommServDBQuery_6" commented="0"

            originalStyle="" points="" sourceX="64" sourceY="190"

            status="0" style="defaultEdge" targetX="66" targetY="312"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1553124144124"

        description="impersonates the user who executes the workflow"

        displayName="IE" height="34" interactive="0" jobMode="0"

        name="ImpersonateExecutor"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.ImpersonateUser"

        uniqueName="ImpersonateExecutor_1" waitSetting="0" width="62"

        x="209" y="178">

        <inputs val="&lt;inputs />"/>

        <transition activity="IsRequestSigned_1" commented="0"

            originalStyle=""

            points="337.3333333333333,122.66666666666667" sourceX="158"

            sourceY="127" status="0" style="defaultEdge;dashed=1"

            targetX="158" targetY="32" transitionIndex="0" x="0" y="0">

            <condition language="1" script="xpath:{/workflow/variables/isAuthorizationRequired} > 0;"/>

        </transition>

        <transition activity="AllowServertoprocessrequest" commented="0"

            originalStyle="" points="426.0,210.0" sourceX="158"

            sourceY="127" status="0" style="defaultEdge;dashed=1"

            targetX="384" targetY="129" transitionIndex="0" x="0" y="0">

            <condition language="1" script="xpath:{/workflow/variables/isAuthorizationRequired} == 0;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1574783477621"

        description="ends the interactive user session"

        displayName="ExitWithError" height="34" interactive="0"

        jobMode="0" name="EndUserSessionWithOutputs"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=EndUserSessionWithOutputs"

        uniqueName="EndUserSessionWithOutputs_2" waitSetting="0"

        width="195" x="120" y="41">

        <inputs val="&lt;inputs>&lt;returnCode class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/BL_DO_NOT_PROCEED}&lt;/returnCode>&lt;returnString class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/VAR_MESSAGE_STRING}&lt;/returnString>&lt;outputXML class=&quot;workflow.types.XML&quot; _list_=&quot;false&quot;>&amp;lt;EVGui_GenericResp&amp;gt;   &amp;#xD;&#xd;&#xa;  &amp;lt;errorCode&amp;gt;-2&amp;lt;/errorCode&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;errorMessage&amp;gt;xpath:{/workflow/variables/VAR_MESSAGE_STRING}&amp;lt;/errorMessage&amp;gt;&amp;#xD;&#xd;&#xa; &amp;lt;/EVGui_GenericResp&amp;gt;&lt;/outputXML>&lt;/inputs>"/>

        <activitySchema>

            <outputs attribute="0" className="" listType="0"

                name="outputs" required="1" type="">

                <children attribute="0" className="java.lang.Integer"

                    defaultValue="" displayName="" documentation=""

                    hidden="0" inputType="java.lang.Integer"

                    listType="0" name="returnCode" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                <children attribute="0" className="java.lang.String"

                    defaultValue="" displayName="" documentation=""

                    hidden="0" inputType="java.lang.String" listType="0"

                    name="returnString" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children attribute="0" className="workflow.types.XML"

                    defaultValue="" displayName="" documentation=""

                    hidden="0" inputType="workflow.types.XML"

                    listType="0" name="outputXML" readOnly="0" type="{workflow.types}XML"/>

            </outputs>

        </activitySchema>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1481051531560"

        description="creates a super process group"

        displayName="TRY BLOCK" height="283" interactive="0" jobMode="0"

        name="ProcessBlock"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ProcessBlock_1" waitSetting="0" width="1164" x="639" y="140">

        <inputs val="&lt;inputs>&lt;inputs />&lt;/inputs>"/>

        <superProcess>

            <Start commented="0" continueOnFailure="0"

                created="1481051531560" description=""

                displayName="Start" height="30" interactive="0"

                jobMode="0" name="Start" originalStyle=""

                skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_2" waitSetting="0" width="120" x="17" y="35">

                <inputs val="&lt;inputs />"/>

                <transition activity="Script_2" commented="0"

                    originalStyle="" points="" sourceX="77" sourceY="50"

                    status="0" style="defaultEdge" targetX="219"

                    targetY="50" transitionIndex="0" x="0" y="0">

                    <condition language="4" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity commented="0" continueOnFailure="0"

                created="1445359537909" description=""

                displayName="ProcessRequest" height="34" interactive="0"

                jobMode="0" name="Execute"

                namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                originalStyle="" skipAttempt="0"

                style="label;image=Execute" uniqueName="Execute_1"

                waitSetting="0" width="159" x="453" y="131">

                <onExit language="1" script="&#xd;&#xa;"/>

                <inputs val="&lt;inputs>&lt;inputXml class=&quot;java.lang.String&quot;>xpath:{/workflow/SignRequest_1/signedRequest}&lt;/inputXml>&lt;commandArgs class=&quot;java.lang.String&quot; />&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot; />&lt;/sessionOptions>&lt;escapeXml class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/escapeXml>&lt;/inputs>"/>

                <transition activity="Script_3" commented="0"

                    originalStyle="" points="" sourceX="672"

                    sourceY="148" status="0" style="defaultEdge"

                    targetX="479" targetY="96" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="1"

                created="1445631515045"

                description="Sends an email to a list of users"

                displayName="Declined Email" height="34" interactive="0"

                jobMode="0" maxRestarts="0" name="Email"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Email" uniqueName="Email_1"

                waitSetting="0" width="127" x="971" y="34">

                <onExit language="1" script="logger.info(&quot;INFO: Request declined by [&quot; + xpath:{/workflow/UserInput_1/completedBy/userName} + &quot;]&quot;);"/>

                <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot;>&lt;to class=&quot;java.lang.String&quot;>xpath:{/workflow/system/executor/userName}&lt;/to>&lt;cc class=&quot;java.lang.String&quot; />&lt;bcc class=&quot;java.lang.String&quot; />&lt;from class=&quot;java.lang.String&quot; />&lt;subject class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/VAR_REQUEST_STRING}[ xpath:{/workflow/variables/VAR_OBJECT} ] was denied.&lt;/subject>&lt;body class=&quot;java.lang.String&quot;>&amp;lt;p&amp;gt;&#xd;&#xa;      xpath:{/workflow/variables/VAR_REQUEST_STRING} &#xd;&#xa;      [xpath:{/workflow/variables/VAR_OBJECT}] was denied by [ &#xd;&#xa;      xpath:{/workflow/UserInput_1/completedBy/userName} ]&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      xpath:{/workflow/variables/VAR_CUSTOM_MESSAGE_TO_USER}&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      Please take appropriate action/approval.&#xd;&#xa;    &amp;lt;/p&amp;gt;&lt;/body>&lt;attachments class=&quot;java.lang.Object&quot; />&lt;html class=&quot;java.lang.Boolean&quot;>true&lt;/html>&lt;repeatInterval class=&quot;java.lang.Integer&quot; />&lt;replyTo class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/email>&lt;/inputs>"/>

            </Activity>

            <Activity commented="0" continueOnFailure="1"

                created="1445998947220"

                description="Sends an email to a list of users"

                displayName="Passed Email " height="34" interactive="0"

                jobMode="0" maxRestarts="0" name="Email"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Email" uniqueName="Email_2"

                waitSetting="0" width="128" x="71" y="105">

                <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot;>&lt;to class=&quot;java.lang.String&quot;>xpath:{/workflow/system/executor/userName}&lt;/to>&lt;cc class=&quot;java.lang.String&quot; />&lt;bcc class=&quot;java.lang.String&quot; />&lt;from class=&quot;java.lang.String&quot; />&lt;subject class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/VAR_REQUEST_STRING} [xpath:{/workflow/variables/VAR_OBJECT}] successful&lt;/subject>&lt;body class=&quot;java.lang.String&quot;>&amp;lt;p&amp;gt;&#xd;&#xa;      xpath:{/workflow/variables/VAR_REQUEST_STRING} &#xd;&#xa;      [xpath:{/workflow/variables/VAR_OBJECT}] request was authorized by [ &#xd;&#xa;      xpath:{/workflow/UserInput_1/completedBy/userName} ] and processed &#xd;&#xa;      successfully.&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      xpath:{/workflow/variables/VAR_CUSTOM_MSG_MAIL}&#xd;&#xa;    &amp;lt;/p&amp;gt;&lt;/body>&lt;attachments class=&quot;java.lang.Object&quot; />&lt;html class=&quot;java.lang.Boolean&quot;>true&lt;/html>&lt;repeatInterval class=&quot;java.lang.Integer&quot; />&lt;replyTo class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/email>&lt;/inputs>"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1445626990039" description=""

                displayName="Get Authorization" height="34"

                interactive="1" jobMode="0" name="UserInput"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=UserInput" uniqueName="UserInput_1"

                waitSetting="0" width="200" x="550" y="34">

                <onExit language="4" script="logger.info(&quot;INFO: User[&quot; + xpath:{/workflow/UserInput_1/completedBy/userName}+ &quot;] response [&quot;+ xpath:{/workflow/UserInput_1/actionSelected} + &quot;]&quot; );&#xd;&#xa;String completedByUser = xpath:{/workflow/UserInput_1/completedBy/userId}.toString();&#xd;&#xa;String executedByUser = xpath:{/workflow/system/executor/userId}.toString();&#xd;&#xa;logger.info(&quot;INFO: Executed by user [&quot; + xpath:{/workflow/system/executor/userName} + &quot;], id [&quot;+executedByUser+&quot;] &quot;); &#xd;&#xa;logger.info(&quot;INFO: [&quot;+xpath:{/workflow/UserInput_1/actionSelected}+&quot;] by user [&quot; + xpath:{/workflow/UserInput_1/completedBy/userName} + &quot;], id [&quot;+completedByUser+&quot;] &quot;);&#xd;&#xa;if (completedByUser.equals(executedByUser))&#xd;&#xa;{&#xd;&#xa;    logger.info(&quot;ERROR: Executing user and approving user cannot be the same&quot;);&#xd;&#xa;    workflow.setVariable(&quot;VAR_LOOPBACK&quot;, &quot;True&quot;);    &#xd;&#xa;}&#xd;&#xa;else&#xd;&#xa;{&#xd;&#xa;    workflow.setVariable(&quot;VAR_LOOPBACK&quot;, &quot;False&quot;);&#xd;&#xa;}    &#xd;&#xa;logger.info(&quot;INFO: Loopback to user interaction [&quot; + workflow.getVariable(&quot;VAR_LOOPBACK&quot;) + &quot;]&quot;); "/>

                <inputs val="&lt;inputs>&lt;interactionUsers>xpath:{/workflow/variables/authorizedUsers}&lt;/interactionUsers>&lt;actions>&lt;name>Accept&lt;/name>&lt;validateForm>true&lt;/validateForm>&lt;/actions>&lt;actions>&lt;name>Decline&lt;/name>&lt;validateForm>true&lt;/validateForm>&lt;/actions>&lt;inputs>&lt;requestedBy class=&quot;java.lang.String&quot;>xpath:{/workflow/system/executor/userName}&lt;/requestedBy>&lt;objectName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/VAR_OBJECT} &lt;/objectName>&lt;CustomMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/VAR_CUSTOM_MESSAGE_TO_USER}&lt;/CustomMessage>&lt;/inputs>&lt;subject>xpath:{/workflow/variables/VAR_REQUEST_STRING} [ xpath:{/workflow/variables/VAR_OBJECT} ] requested by [ xpath:{/workflow/system/executor/userName} ]&lt;/subject>&lt;sendEmail>true&lt;/sendEmail>&lt;approvalEnabled>false&lt;/approvalEnabled>&lt;email>&lt;from />&lt;to />&lt;cc />&lt;bcc />&lt;subject>xpath:{/workflow/variables/VAR_REQUEST_STRING} [ xpath:{/workflow/variables/VAR_OBJECT} ] requested by [ xpath:{/workflow/system/executor/userName} ]&lt;/subject>&lt;attachments />&lt;repeatInterval />&lt;body>&amp;lt;table width=&quot;100%&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; border=&quot;0&quot;&amp;gt;&#xd;&#xa;      &amp;lt;tr&amp;gt;&#xd;&#xa;        &amp;lt;td width=&quot;100%&quot; height=&quot;40&quot;&amp;gt;&#xd;&#xa;          &#xd;&#xa;        &amp;lt;/td&amp;gt;&#xd;&#xa;      &amp;lt;/tr&amp;gt;&#xd;&#xa;      &amp;lt;tr&amp;gt;&#xd;&#xa;        &amp;lt;td width=&quot;100%&quot; valign=&quot;top&quot;&amp;gt;&#xd;&#xa;          &amp;lt;table align=&quot;center&quot; bgcolor=&quot;#ffffff&quot; border=&quot;1&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; width=&quot;801&quot; style=&quot;border-left-color: #e9e9e9; border-left-style: solid; border-left-width: 2px; border-right-color: #e9e9e9; border-right-style: solid; border-right-width: 1px; border-top-color: #e9e9e9; border-top-style: solid; border-top-width: 2px&quot;&amp;gt;&#xd;&#xa;            &amp;lt;tr&amp;gt;&#xd;&#xa;              &amp;lt;td&amp;gt;&#xd;&#xa;                &amp;lt;table width=&quot;801&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; border=&quot;0&quot;&amp;gt;&#xd;&#xa;                  &amp;lt;tr&amp;gt;&#xd;&#xa;                    &amp;lt;td width=&quot;100%&quot; height=&quot;161&quot;&amp;gt;&#xd;&#xa;                      &amp;lt;img alt=&quot;commvault.com&quot; border=&quot;1&quot; src=&quot;https://world.commvault.com/saas_services_email_header.png&quot;&amp;gt;&#xd;&#xa;                      &#xd;&#xa;&#xd;&#xa;                      &amp;lt;table width=&quot;100%&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; border=&quot;0&quot;&amp;gt;&#xd;&#xa;                        &amp;lt;tr&amp;gt;&#xd;&#xa;                          &amp;lt;td width=&quot;100%&quot; height=&quot;40&quot;&amp;gt;&#xd;&#xa;                            &#xd;&#xa;                          &amp;lt;/td&amp;gt;&#xd;&#xa;                        &amp;lt;/tr&amp;gt;&#xd;&#xa;                        &amp;lt;tr&amp;gt;&#xd;&#xa;                          &amp;lt;td width=&quot;100%&quot; valign=&quot;top&quot;&amp;gt;&#xd;&#xa;                            &amp;lt;table align=&quot;center&quot; bgcolor=&quot;#ffffff&quot; border=&quot;1&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; width=&quot;801&quot; style=&quot;border-left-color: #e9e9e9; border-left-style: solid; border-left-width: 2px; border-right-color: #e9e9e9; border-right-style: solid; border-right-width: 1px; border-top-color: #e9e9e9; border-top-style: solid; border-top-width: 2px&quot;&amp;gt;&#xd;&#xa;                              &amp;lt;tr&amp;gt;&#xd;&#xa;                                &amp;lt;td&amp;gt;&#xd;&#xa;                                  &amp;lt;table width=&quot;801&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; border=&quot;1&quot;&amp;gt;&#xd;&#xa;                                    &amp;lt;tr&amp;gt;&#xd;&#xa;                                      &amp;lt;td width=&quot;100%&quot; height=&quot;161&quot;&amp;gt;&#xd;&#xa;                                        &amp;lt;br&amp;gt;&#xd;&#xa;                                        &#xd;&#xa;&#xd;&#xa;                                        &amp;lt;div&amp;gt;&#xd;&#xa;                                          Hello,&#xd;&#xa;                                        &amp;lt;/div&amp;gt;&#xd;&#xa;                                        &amp;lt;div&amp;gt;&#xd;&#xa;                                          &amp;lt;br&amp;gt;&#xd;&#xa;                                          User &#xd;&#xa;                                          [xpath:{/workflow/system/executor/userName}] &#xd;&#xa;                                          has initiated a &#xd;&#xa;                                          xpath:{/workflow/variables/VAR_REQUEST_STRING} &#xd;&#xa;                                          request for &#xd;&#xa;                                          [xpath:{/workflow/variables/VAR_OBJECT}] &#xd;&#xa;                                          xpath:{/workflow/variables/VAR_CUSTOM_MESSAGE_TO_USER}&#xd;&#xa;                                        &amp;lt;/div&amp;gt;&#xd;&#xa;                                        &amp;lt;div&amp;gt;&#xd;&#xa;                                          &#xd;&#xa;                                        &amp;lt;/div&amp;gt;&#xd;&#xa;                                        &amp;lt;div&amp;gt;&#xd;&#xa;                                          Click the &amp;lt;a href=&quot;$FORM_URL$&quot;&amp;gt;Open &#xd;&#xa;                                          Form&amp;lt;/a&amp;gt; link to view the task &#xd;&#xa;                                          actions.&#xd;&#xa;                                        &amp;lt;/div&amp;gt;&#xd;&#xa;                                        &amp;lt;div&amp;gt;&#xd;&#xa;                                          &amp;lt;br&amp;gt;&#xd;&#xa;                                          Please click the appropriate action &#xd;&#xa;                                          to &amp;lt;a href=&quot;action:{Accept}&quot;&amp;gt;Accept&amp;lt;/a&amp;gt; &#xd;&#xa;                                          or &amp;lt;a href=&quot;action:{Deny}&quot;&amp;gt;Deny&amp;lt;/a&amp;gt; &#xd;&#xa;                                          the request.&#xd;&#xa;                                        &amp;lt;/div&amp;gt;&#xd;&#xa;                                        &amp;lt;div&amp;gt;&#xd;&#xa;                                          &#xd;&#xa;                                        &amp;lt;/div&amp;gt;&#xd;&#xa;                                        &amp;lt;div&amp;gt;&#xd;&#xa;                                          &amp;lt;br&amp;gt;&#xd;&#xa;                                          &#xd;&#xa;&#xd;&#xa;                                          &amp;lt;p&amp;gt;&#xd;&#xa;                                            Thank you,&#xd;&#xa;                                          &amp;lt;/p&amp;gt;&#xd;&#xa;                                          &amp;lt;p&amp;gt;&#xd;&#xa;                                            Commvault Team&#xd;&#xa;                                          &amp;lt;/p&amp;gt;&#xd;&#xa;                                        &amp;lt;/div&amp;gt;&#xd;&#xa;                                      &amp;lt;/td&amp;gt;&#xd;&#xa;                                    &amp;lt;/tr&amp;gt;&#xd;&#xa;                                  &amp;lt;/table&amp;gt;&#xd;&#xa;                                &amp;lt;/td&amp;gt;&#xd;&#xa;                              &amp;lt;/tr&amp;gt;&#xd;&#xa;                            &amp;lt;/table&amp;gt;&#xd;&#xa;                          &amp;lt;/td&amp;gt;&#xd;&#xa;                        &amp;lt;/tr&amp;gt;&#xd;&#xa;                      &amp;lt;/table&amp;gt;&#xd;&#xa;                    &amp;lt;/td&amp;gt;&#xd;&#xa;                  &amp;lt;/tr&amp;gt;&#xd;&#xa;                &amp;lt;/table&amp;gt;&#xd;&#xa;              &amp;lt;/td&amp;gt;&#xd;&#xa;            &amp;lt;/tr&amp;gt;&#xd;&#xa;          &amp;lt;/table&amp;gt;&#xd;&#xa;        &amp;lt;/td&amp;gt;&#xd;&#xa;      &amp;lt;/tr&amp;gt;&#xd;&#xa;    &amp;lt;/table&amp;gt;&lt;/body>&lt;html>true&lt;/html>&lt;/email>&lt;formProperties>&amp;lt;?xml version=''1.0'' encoding=''UTF-8''?&amp;gt;&amp;lt;Workflow_FormProperties css=&quot;&quot; javaScript=&quot;&quot; pageMode=&quot;0&quot; formVersion=&quot;0&quot;&amp;gt;&amp;lt;rules /&amp;gt;&amp;lt;/Workflow_FormProperties&amp;gt;&lt;/formProperties>&lt;/inputs>"/>

                <activitySchema>

                    <outputs attribute="0" className="" listType="0"

                        name="outputs" required="1" type="">

                        <children attribute="0"

                            className="java.lang.String"

                            controlHidden="0" controlType="0"

                            defaultValue="" displayName="Requested By"

                            documentation="User requesting to delete the xpath:{/workflow/variables/VAR_REQUEST_STRING}"

                            hidden="0" inputType="java.lang.String"

                            listType="0" maximumValue="" minimumValue=""

                            name="requestedBy" readOnly="1" required="0"

                            searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

                        <children attribute="0"

                            className="java.lang.String"

                            controlHidden="0" controlType="1"

                            defaultValue=""

                            displayName="xpath:{/workflow/variables/VAR_REQUEST_STRING}"

                            documentation="Request object" hidden="0"

                            inputType="java.lang.String" listType="0"

                            maximumValue="" minimumValue=""

                            name="objectName" readOnly="1" required="0"

                            searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

                        <children attribute="0"

                            className="java.lang.String"

                            controlHidden="0" controlType="1"

                            defaultValue=""

                            displayName="Message to user"

                            documentation="" hidden="0"

                            inputType="java.lang.String" listType="0"

                            maximumValue="" minimumValue=""

                            name="CustomMessage" readOnly="1"

                            required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

                        <children

                            className="commvault.msgs.CvEntities.UserEntity"

                            inputType="commvault.msgs.CvEntities.UserEntity"

                            name="completedBy" type="{commvault.msgs.CvEntities}UserEntity">

                            <children className="java.lang.String"

                                inputType="java.lang.String"

                                name="userName" type="{http://www.w3.org/2001/XMLSchema}string"/>

                            <children className="java.lang.Integer"

                                inputType="java.lang.Integer"

                                name="userId" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                        </children>

                        <children className="java.lang.String"

                            inputType="java.lang.String"

                            name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string"/>

                    </outputs>

                    <inputs attribute="0" className="" listType="0"

                        name="inputs" required="1" type="">

                        <children attribute="0"

                            className="java.lang.String"

                            controlHidden="0" controlType="0"

                            defaultValue="" displayName="Requested By"

                            documentation="User requesting to delete the xpath:{/workflow/variables/VAR_REQUEST_STRING}"

                            hidden="0" inputType="java.lang.String"

                            listType="0" maximumValue="" minimumValue=""

                            name="requestedBy" readOnly="1" required="0"

                            searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

                        <children attribute="0"

                            className="java.lang.String"

                            controlHidden="0" controlType="1"

                            defaultValue=""

                            displayName="xpath:{/workflow/variables/VAR_REQUEST_STRING}"

                            documentation="Request object" hidden="0"

                            inputType="java.lang.String" listType="0"

                            maximumValue="" minimumValue=""

                            name="objectName" readOnly="1" required="0"

                            searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

                        <children attribute="0"

                            className="java.lang.String"

                            controlHidden="0" controlType="1"

                            defaultValue=""

                            displayName="Message to user"

                            documentation="" hidden="0"

                            inputType="java.lang.String" listType="0"

                            maximumValue="" minimumValue=""

                            name="CustomMessage" readOnly="1"

                            required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

                    </inputs>

                </activitySchema>

                <transition activity="InformationalMessage_2"

                    commented="0" originalStyle="" points=""

                    sourceX="650" sourceY="51" status="0"

                    style="defaultEdge" targetX="749" targetY="98"

                    transitionIndex="0" x="0" y="0">

                    <condition language="1" script="(xpath:{/workflow/variables/VAR_LOOPBACK}.equals(&quot;True&quot;));"/>

                </transition>

                <transition activity="EndUserSession_2" commented="0"

                    originalStyle="" points="" sourceX="650"

                    sourceY="51" status="0" style="defaultEdge"

                    targetX="725" targetY="96" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="(xpath:{/workflow/variables/VAR_LOOPBACK}.equals(&quot;False&quot;));"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1445630636670"

                description="if/else based decision"

                displayName="Authorized?" height="39" interactive="0"

                jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_1"

                waitSetting="0" width="104" x="779" y="32">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>String action = xpath:{/workflow/UserInput_1/actionSelected}; &amp;#xD;&#xd;&#xa;if( action != null &amp;amp;&amp;amp; action.equals(&quot;Accept&quot;))&amp;#xD;&#xd;&#xa;{&amp;#xD;&#xd;&#xa;    return true;&amp;#xD;&#xd;&#xa;}&amp;#xD;&#xd;&#xa;else&amp;#xD;&#xd;&#xa;{&amp;#xD;&#xd;&#xa;    return false;&amp;#xD;&#xd;&#xa;}&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="Email_1" commented="0"

                    displayName="no" originalStyle="" points=""

                    sourceX="402" sourceY="533" status="0"

                    style="defaultEdge;dashed=1" targetX="401"

                    targetY="655" transitionIndex="0" value="false"

                    x="149" y="12">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="SignRequest_1" commented="0"

                    displayName="yes" originalStyle="" points=""

                    sourceX="831" sourceY="51" status="0"

                    style="defaultEdge;dashed=1" targetX="877"

                    targetY="223" transitionIndex="0" value="true"

                    x="28" y="-8">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1445894442223"

                description="activity to execute code snippets in the selected language"

                displayName="Set Vars" height="34" interactive="0"

                jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Script" uniqueName="Script_2"

                waitSetting="0" width="128" x="170" y="34">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;XML inXML = xpath:{/workflow/inputs/requestXML};&amp;#xD;&amp;#xA;XML reqXml = inXML.selectSingleNode(&amp;quot;/requestXML/*&amp;quot;);&amp;#xD;&amp;#xA;String authCode = reqXml.selectSingleNode(&amp;quot;string(//./processinginstructioninfo/attributes/@value)&amp;quot;);&amp;#xD;&amp;#xA;if( authCode != null &amp;amp;&amp;amp; !authCode.equals(&amp;quot;&amp;quot;))&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;authCode&amp;quot;, authCode);&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;else&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    authCode = &amp;quot;0&amp;quot;;&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;authCode&amp;quot;, authCode);    &amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;strRequest&amp;quot;, reqXml.toString());&amp;#xD;&amp;#xA;logger.info(&amp;quot;INFO: Received request for &amp;quot;+xpath:{/workflow/variables/VAR_REQUEST_STRING}+&amp;quot; &amp;quot;+xpath:{/workflow/variables/VAR_OBJECT}+&amp;quot;, authcode[&amp;quot;+ authCode +&amp;quot;], by executor user[&amp;quot; + xpath:{/workflow/system/executor/userName} + &amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;&quot; />&lt;/inputs>"/>

                <transition activity="ImpersonateCreator_4"

                    commented="0" originalStyle="" points=""

                    sourceX="234" sourceY="51" status="0"

                    style="defaultEdge" targetX="372" targetY="46"

                    transitionIndex="0" x="0" y="0">

                    <condition language="4" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1480695390057"

                description="generate authorization signature and sign the request xml"

                displayName="SignRequest" height="34" interactive="0"

                jobMode="0" name="SignRequest"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.SignRequest"

                uniqueName="SignRequest_1" waitSetting="0" width="112"

                x="845" y="130">

                <inputs val="&lt;inputs>&lt;request class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/strRequest}&lt;/request>&lt;/inputs>"/>

                <transition activity="ImpersonateExecutor_2"

                    commented="0" originalStyle="" points=""

                    sourceX="867" sourceY="148" status="0"

                    style="defaultEdge" targetX="779" targetY="170"

                    transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1481040584562"

                description="Sends an email to a list of users"

                displayName="Failed Email" height="34" interactive="0"

                jobMode="0" name="Email"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.EmailActivity"

                uniqueName="Email_3" waitSetting="0" width="128" x="70" y="160">

                <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot;>&lt;from class=&quot;java.lang.String&quot; />&lt;to class=&quot;java.lang.String&quot;>xpath:{/workflow/system/executor/userName}&lt;/to>&lt;cc class=&quot;java.lang.String&quot; />&lt;bcc class=&quot;java.lang.String&quot; />&lt;subject class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/VAR_REQUEST_STRING} [xpath:{/workflow/variables/VAR_OBJECT}] failed&lt;/subject>&lt;attachments class=&quot;java.lang.Object&quot; />&lt;repeatInterval class=&quot;java.lang.Integer&quot; />&lt;body class=&quot;java.lang.String&quot;>&amp;lt;p&amp;gt;&#xd;&#xa;      xpath:{/workflow/variables/VAR_REQUEST_STRING} &#xd;&#xa;      [xpath:{/workflow/variables/VAR_OBJECT}] request was authorized by [ &#xd;&#xa;      xpath:{/workflow/UserInput_1/completedBy/userName} ] , but the server &#xd;&#xa;      failed to process the request.&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      xpath:{/workflow/variables/VAR_CUSTOM_MESSAGE_TO_USER}&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      xpath:{/workflow/variables/VAR_ERROR_STRING}&#xd;&#xa;    &amp;lt;/p&amp;gt;&lt;/body>&lt;html class=&quot;java.lang.Boolean&quot;>true&lt;/html>&lt;replyTo class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/email>&lt;/inputs>"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1446138494485"

                description="activity to execute code snippets in the selected language"

                displayName="GetStatus" height="34" interactive="0"

                jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Script" uniqueName="Script_3"

                waitSetting="0" width="100" x="295" y="131">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;logger.info(&amp;quot;INFO: qoperation output[&amp;quot;+ xpath:{/workflow/Execute_1/outputXml} +&amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;XML response = utils.parseXml(xpath:{/workflow/Execute_1/outputXml});&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;String RequestErrorCode = response.selectSingleNode(xpath:{/workflow/variables/VAR_ERROR_CODE});&amp;#xD;&amp;#xA;String RequestErrorString = response.selectSingleNode(xpath:{/workflow/variables/VAR_ERROR_STRING});    &amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;logger.info(&amp;quot;INFO: RequestErrorCode = [&amp;quot;+ RequestErrorCode +&amp;quot;] &amp;quot;);&amp;#xD;&amp;#xA;logger.info(&amp;quot;INFO: RequestErrorString = [&amp;quot;+ RequestErrorString +&amp;quot;] &amp;quot;);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;VAR_ERROR_STRING&amp;quot;,&amp;quot;&amp;quot;);&amp;#xD;&amp;#xA;if (RequestErrorString != null &amp;amp;&amp;amp; RequestErrorString != &amp;quot;&amp;quot;)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;VAR_ERROR_STRING&amp;quot;,&amp;quot;Reason: &amp;quot;+RequestErrorString);&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;logger.info(&amp;quot;INFO: VAR_ERROR_STRING = [&amp;quot;+ workflow.getVariable(&amp;quot;VAR_ERROR_STRING&amp;quot;) +&amp;quot;] &amp;quot;);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;VAR_CUSTOM_MSG_MAIL&amp;quot;,&amp;quot;Please refresh the library node in console before continue...&amp;quot;);&amp;#xD;&amp;#xA;if (RequestErrorCode.equals(&amp;quot;&amp;quot;) || RequestErrorCode == null)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    return true;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;else if (RequestErrorCode.equals(&amp;quot;0&amp;quot;))&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    return true;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;else&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    return false;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&quot; />&lt;/inputs>"/>

                <transition activity="Email_2" commented="0"

                    originalStyle="" points="" sourceX="467"

                    sourceY="98" status="0" style="defaultEdge;dashed=1"

                    targetX="181" targetY="122" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="(xpath:{/workflow/Script_3/output});"/>

                </transition>

                <transition activity="Email_3" commented="0"

                    originalStyle="" points="" sourceX="467"

                    sourceY="98" status="0" style="defaultEdge;dashed=1"

                    targetX="165" targetY="187" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="!(xpath:{/workflow/Script_3/output});"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1485447828048"

                description="impersonates the user who executes the workflow"

                displayName="ImpersonateExecutor" height="34"

                interactive="0" jobMode="0" name="ImpersonateExecutor"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.ImpersonateUser"

                uniqueName="ImpersonateExecutor_2" waitSetting="0"

                width="153" x="650" y="131">

                <inputs val="&lt;inputs />"/>

                <transition activity="Execute_1" commented="0"

                    originalStyle="" points="" sourceX="718"

                    sourceY="173" status="0" style="defaultEdge"

                    targetX="549" targetY="147" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1547063490678"

                description="displays an informational message to the user"

                displayName="Info" height="34" interactive="0"

                jobMode="0" name="InformationalMessage"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.InteractiveMessageActivity"

                uniqueName="InformationalMessage_2" waitSetting="0"

                width="69" x="590" y="82">

                <inputs val="&lt;inputs>&lt;message>User initiating the request and user authorizing the request should be different.&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;Request initiated by user : xpath:{/workflow/system/executor/userName}&amp;#xD;&#xd;&#xa;Request authorizing user : xpath:{/workflow/UserInput_1/completedBy/userName}&lt;/message>&lt;dialogType>Popup&lt;/dialogType>&lt;iconType>Error&lt;/iconType>&lt;title>Error&lt;/title>&lt;html>false&lt;/html>&lt;formProperties />&lt;/inputs>"/>

                <activitySchema>

                    <outputs name="outputs">

                        <children className="java.lang.String"

                            inputType="java.lang.String"

                            name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string"/>

                    </outputs>

                    <inputs className="" defaultValue="" listType="0"

                        name="inputs" type=""/>

                </activitySchema>

                <transition activity="EndUserSession_1" commented="0"

                    originalStyle="" points="" sourceX="718"

                    sourceY="101" status="0" style="defaultEdge"

                    targetX="500" targetY="117" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <onEnter language="1" script="logger.info(&quot;INFO: Executing user : [&quot;+ xpath:{/workflow/system/executor/userName} +&quot;]&quot;);&#xd;&#xa;logger.info(&quot;INFO: Approving user : [&quot;+ xpath:{/workflow/UserInput_1/completedBy/userName} +&quot;]&quot;);"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1547063580744"

                description="ends the interactive user session"

                displayName="EUS" height="34" interactive="0"

                jobMode="0" name="EndUserSession"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.InteractiveEndSessionActivity"

                uniqueName="EndUserSession_1" waitSetting="0" width="63"

                x="471" y="82">

                <inputs val="&lt;inputs />"/>

                <transition activity="UserInput_1" commented="0"

                    originalStyle=""

                    points="485.66666666666663,62.333333333333314"

                    sourceX="502" sourceY="99" status="0"

                    style="defaultEdge" targetX="604" targetY="45"

                    transitionIndex="0" x="0" y="0">

                    <condition language="4" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1547065327700"

                description="ends the interactive user session"

                displayName="EUS" height="34" interactive="0"

                jobMode="0" name="EndUserSession"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.InteractiveEndSessionActivity"

                uniqueName="EndUserSession_2" waitSetting="0" width="56"

                x="690" y="81">

                <inputs val="&lt;inputs />"/>

                <transition activity="Decision_1" commented="0"

                    originalStyle="" points="" sourceX="718"

                    sourceY="98" status="0" style="defaultEdge"

                    targetX="834" targetY="52" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1599494222972"

                description="impersonates the user who created the workflow"

                displayName="ImpersonateCreator" height="34"

                interactive="0" jobMode="0" name="ImpersonateCreator"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.ImpersonateCreator"

                uniqueName="ImpersonateCreator_4" waitSetting="0"

                width="145" x="263" y="88">

                <inputs val="&lt;inputs />"/>

                <transition activity="UserInput_1" commented="0"

                    originalStyle=""

                    points="345.66666666666674,46.333333333333314"

                    sourceX="336" sourceY="105" status="0"

                    style="defaultEdge" targetX="657" targetY="54"

                    transitionIndex="0" x="0" y="0">

                    <condition language="4" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

        </superProcess>

        <activitySchema>

            <outputs className="" defaultValue="" listType="0"

                name="outputs" type=""/>

            <inputs className="" defaultValue="" listType="0"

                name="inputs" type=""/>

        </activitySchema>

        <transition activity="ProcessBlock_2" commented="0"

            displayName="Failed" originalStyle="" points=""

            sourceX="1066" sourceY="330" status="2" style="defaultEdge"

            targetX="987" targetY="497" transitionIndex="0" x="0" y="0">

            <condition language="4" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1481051574591"

        description="creates a super process group"

        displayName="Catch Block" height="73" interactive="0"

        jobMode="0" name="ProcessBlock"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ProcessBlock_2" waitSetting="0" width="284" x="1010" y="537">

        <inputs val="&lt;inputs>&lt;inputs />&lt;/inputs>"/>

        <superProcess>

            <Start commented="0" continueOnFailure="0"

                created="1481051574591" description=""

                displayName="Start" height="35" interactive="0"

                jobMode="0" name="Start" originalStyle=""

                skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_3" waitSetting="0" width="85" x="18" y="30">

                <inputs val="&lt;inputs />"/>

                <transition activity="Email_4" commented="0"

                    originalStyle="" points="" sourceX="55" sourceY="42"

                    status="0" style="defaultEdge" targetX="172"

                    targetY="41" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity commented="0" continueOnFailure="0"

                created="1481051610195"

                description="Sends an email to a list of users"

                displayName="Failed Email" height="34" interactive="0"

                jobMode="0" name="Email"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.EmailActivity"

                uniqueName="Email_4" waitSetting="0" width="128" x="145" y="30">

                <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot;>&lt;from class=&quot;java.lang.String&quot; />&lt;to class=&quot;java.lang.String&quot;>xpath:{/workflow/system/executor/userName}&lt;/to>&lt;cc class=&quot;java.lang.String&quot; />&lt;bcc class=&quot;java.lang.String&quot; />&lt;subject class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/VAR_REQUEST_STRING}[ xpath:{/workflow/variables/VAR_OBJECT} ] failed&lt;/subject>&lt;attachments class=&quot;java.lang.Object&quot; />&lt;repeatInterval class=&quot;java.lang.Integer&quot; />&lt;body class=&quot;java.lang.String&quot;>&amp;lt;p&amp;gt;&#xd;&#xa;      Failed to process request :: &#xd;&#xa;      xpath:{/workflow/variables/VAR_REQUEST_STRING} [ &#xd;&#xa;      xpath:{/workflow/variables/VAR_OBJECT} ]&#xd;&#xa;    &amp;lt;/p&amp;gt;&lt;/body>&lt;html class=&quot;java.lang.Boolean&quot;>true&lt;/html>&lt;replyTo class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/email>&lt;/inputs>"/>

            </Activity>

        </superProcess>

        <activitySchema>

            <outputs className="" defaultValue="" listType="0"

                name="outputs" type=""/>

            <inputs className="" defaultValue="" listType="0"

                name="inputs" type=""/>

        </activitySchema>

    </Activity>

    <onStart language="4" script="workflow.setLoggingDisabled(true);"/>

    <formProperties css="" formVersion="0" javaScript="" pageMode="0">

        <rules/>

    </formProperties>

    <onComplete language="4" script="workflow.setLoggingDisabled(false);"/>

</workflow>

'

IF NOT EXISTS (SELECT 1 FROM MMConfigs WHERE name = 'MMCONFIG_FORCE_DELETE_MP_ENABLED_FLAG' AND value = 0)

BEGIN

	IF not exists (select * from WF_Definition where Name = @name)

	BEGIN
		INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision, uniqueGuid)


		VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision, @guid)

		SET @workflowId = @@IDENTITY
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


		VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

	END

	ELSE

	BEGIN

		SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = ISNULL(revision, '') From WF_Definition WHERE Name = @name

		IF (@currentRevision <> @revision)

		BEGIN

			SET @version = @version + 1

			UPDATE WF_Definition

			SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision, flags = @flags

			WHERE Name = @name   
			INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


			VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

		END

	END

END
