

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_DefaultAlarm.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/WFD_DefaultAlarm.script,v $ $Id: WFD_DefaultAlarm.script,v 1.5 2015/06/05 16:36:32 csunderland Exp $";
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER OFF

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.5 $'

SET @name = 'DefaultAlarm'

SET @description = 'Runs Custom Alarms'

SET @version = 1

SET @flags = 6

SET @definition = '<workflow apiMode="0" description="Runs Custom Alarms"

    inputs="&lt;inputs>&lt;sCLOUDINSTANCE class=&quot;java.lang.String&quot; />&lt;pCLOUDACCESS class=&quot;java.lang.String&quot; />&lt;/inputs>"

    interactive="0" name="DefaultAlarm" outputs="&lt;outputs />"

    variables="&lt;variables />" workflowId="0">

    <Start breakpoint="0" commented="0" continueOnFailure="0"

        created="0" description="" displayName="Start" height="36"

        interactive="0" name="Start" originalStyle="" skipAttempt="0"

        style="image;image=/images/jgraphx/house.png"

        uniqueName="Start_1" waitSetting="0" width="61" x="36" y="17">

        <inputs val="&lt;inputs />"/>

        <transition activity="CommServDBQuery_1" commented="0"

            originalStyle="" points="" sourceX="75" sourceY="59"

            status="0" style="defaultEdge" targetX="251" targetY="57"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Start>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1383862129306"

        description="executes queries against the commserv database"

        displayName="Fetch List of Alarms" height="34" interactive="0"

        name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=CommServDBQuery"

        uniqueName="CommServDBQuery_1" waitSetting="0" width="162"

        x="156" y="18">

        <inputs val="&lt;inputs>&lt;commCell>&lt;/commCell>&lt;query>SELECT&#x9;C.EntityLabel,&amp;#xD;&#xd;&#xa;&#x9;&#x9;REPLACE(REPLACE(CAST(A.extendedProps AS NVARCHAR(MAX)), ''&quot;'', ''\&quot;''), '''''''', ''''''''''''),&amp;#xD;&#xd;&#xa;&#x9;&#x9;A.type,&amp;#xD;&#xd;&#xa;&#x9;&#x9;A.CommCellGUID,&amp;#xD;&#xd;&#xa;&#x9;&#x9;A.email,&amp;#xD;&#xd;&#xa;&#x9;&#x9;A.userId,&amp;#xD;&#xd;&#xa;&#x9;&#x9;(CASE WHEN ISNULL(U.name, '''') = '''' THEN U.login ELSE U.name END),&amp;#xD;&#xd;&#xa;&#x9;&#x9;A.ParamName,&amp;#xD;&#xd;&#xa;&#x9;&#x9;A.displayName,&amp;#xD;&#xd;&#xa;&#x9;&#x9;(SELECT CC.aliasName from APP_CommCell CC WHERE id = 2) AS ''CommCell Name'',&amp;#xD;&#xd;&#xa;&#x9;&#x9;A.reportName&amp;#xD;&#xd;&#xa;FROM&#x9;CustomReports C &amp;#xD;&#xd;&#xa;&#x9;&#x9;INNER JOIN CustomAlarmProps A &amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;ON C.ID = A.CustomReportId&amp;#xD;&#xd;&#xa;&#x9;&#x9;INNER JOIN UMUsers U&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;ON A.userId = U.id&amp;#xD;&#xd;&#xa;WHERE&#x9;A.flags = 0&lt;/query>&lt;/inputs>"/>

        <transition activity="ForEach_1" commented="0" originalStyle=""

            points="" sourceX="251" sourceY="57" status="0"

            style="defaultEdge" targetX="561" targetY="322"

            transitionIndex="0" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1383862199490"

        description="iterates a group of activities over a list of values"

        displayName="ForEach" height="568" interactive="0"

        name="ForEach" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ForEach_1" waitSetting="0" width="1329" x="76" y="89">

        <activitySchema>

            <inputs>

                <children className="java.lang.String"

                    inputType="java.lang.String" name="name" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children className="java.lang.Object"

                    inputType="java.lang.Object" name="values" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                <children className="java.lang.Integer" defaultValue="1"

                    inputType="java.lang.Integer"

                    name="numberOfParallelExecutions" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                <children className="java.lang.Boolean"

                    defaultValue="false" inputType="java.lang.Boolean"

                    name="continueOnFailure" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

            </inputs>

            <outputs name="outputs">

                <children className="workflow.types.data.DataRow"

                    inputType="workflow.types.data.DataRow" listType="0"

                    name="row" type="{workflow.types.data}DataRow">

                    <children className="java.lang.Object"

                        inputType="java.lang.Object" listType="1"

                        name="col" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                </children>

            </outputs>

        </activitySchema>

        <inputs val="&lt;inputs>&lt;name class=&quot;java.lang.String&quot;>row&lt;/name>&lt;values class=&quot;java.lang.Object&quot;>xpath:{/workflow/CommServDBQuery_1/resultSets/row}&lt;/values>&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot;>1&lt;/numberOfParallelExecutions>&lt;continueOnFailure class=&quot;java.lang.Boolean&quot;>false&lt;/continueOnFailure>&lt;/inputs>"/>

        <transition activity="WorkflowEnd_1" commented="0"

            originalStyle="" points="" sourceX="574" sourceY="320"

            status="0" style="defaultEdge" targetX="574" targetY="600"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <superProcess>

            <Start breakpoint="0" commented="0" continueOnFailure="0"

                created="1383862199491" description=""

                displayName="Start" height="30" interactive="0"

                name="Start" originalStyle="" skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_2" waitSetting="0" width="120" x="465" y="27">

                <inputs val="&lt;inputs />"/>

                <transition activity="ProcessBlock_1" commented="0"

                    originalStyle="" points="" sourceX="657"

                    sourceY="46" status="0" style="defaultEdge"

                    targetX="525" targetY="84" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1387808245219"

                description="creates a super process group"

                displayName="Try Block" height="455" interactive="0"

                maxRestarts="0" name="ProcessBlock"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0" style="swimlane"

                uniqueName="ProcessBlock_1" waitSetting="0" width="929"

                x="74" y="79">

                <activitySchema>

                    <inputs attribute="0" listType="0" name="inputs" required="1"/>

                    <outputs attribute="0" listType="0" name="outputs" required="1"/>

                </activitySchema>

                <inputs val="&lt;inputs>&lt;inputs />&lt;/inputs>"/>

                <transition activity="ProcessBlock_2" commented="0"

                    displayName="Fail" originalStyle="" points=""

                    sourceX="538" sourceY="306" status="2"

                    style="defaultEdge" targetX="1190" targetY="304"

                    transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <superProcess>

                    <Start breakpoint="0" commented="0"

                        continueOnFailure="0" created="1387808245219"

                        description="" displayName="Start" height="30"

                        interactive="0" name="Start" originalStyle=""

                        skipAttempt="0"

                        style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                        uniqueName="Start_3" waitSetting="0" width="120"

                        x="390" y="32">

                        <inputs val="&lt;inputs />"/>

                        <transition activity="ExecuteCommand_1"

                            commented="0" originalStyle="" points=""

                            sourceX="450" sourceY="47" status="0"

                            style="defaultEdge" targetX="453"

                            targetY="91" transitionIndex="0" x="0" y="0">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Start>

                    <Activity breakpoint="0" commented="0"

                        continueOnFailure="0" created="1383862256004"

                        description="Execute a list of commands"

                        displayName="Run Alarm" height="34"

                        interactive="0" name="ExecuteCommand"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=ExecuteCommand"

                        uniqueName="ExecuteCommand_1" waitSetting="0"

                        width="147" x="371" y="90">

                        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>&lt;clientName />&lt;clientId />&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; />&lt;command class=&quot;java.lang.String&quot;>GetCustomReportData.cmd&lt;/command>&lt;arguments class=&quot;java.lang.String&quot;>&quot;xpath:{/workflow/ForEach_1/row/col[1]}&quot; &quot;xpath:{/workflow/inputs/sCLOUDINSTANCE}&quot; &quot;xpath:{/workflow/inputs/pCLOUDACCESS}&quot; &quot;xpath:{/workflow/ForEach_1/row/col[2]}&quot; &quot;xpath:{/workflow/ForEach_1/row/col[3]}&quot; &quot;xpath:{/workflow/ForEach_1/row/col[4]}&quot; 2&amp;gt;NUL&lt;/arguments>&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

                        <transition activity="Decision_2" commented="0"

                            originalStyle="" points="" sourceX="246"

                            sourceY="97" status="0" style="defaultEdge"

                            targetX="243" targetY="170"

                            transitionIndex="0" x="0" y="0">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity breakpoint="0" commented="0"

                        continueOnFailure="0" created="1387298525754"

                        description="retrieves a list of values from xml"

                        displayName="Get Result" height="34"

                        interactive="0" name="XPathQuery"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=XPathQuery"

                        uniqueName="XPathQuery_6" waitSetting="0"

                        width="110" x="101" y="120">

                        <inputs val="&lt;inputs>&lt;xml class=&quot;java.lang.String&quot;>xpath:{/workflow/ExecuteCommand_1/commandOutput}&lt;/xml>&lt;xpath class=&quot;java.lang.String&quot;>(/Results/TableResults/Row[1]/Column[@columnName=&quot;Result&quot;])&lt;/xpath>&lt;outputType class=&quot;workflow.types.SimpleType&quot;>String&lt;/outputType>&lt;outputAsList class=&quot;java.lang.Boolean&quot;>true&lt;/outputAsList>&lt;/inputs>"/>

                        <transition activity="Decision_3" commented="0"

                            originalStyle="" points="" sourceX="55"

                            sourceY="150" status="0" style="defaultEdge"

                            targetX="80" targetY="219"

                            transitionIndex="0" x="0" y="0">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity breakpoint="0" commented="0"

                        continueOnFailure="0" created="1387298850645"

                        description="if/else based decision"

                        displayName="Should I send Alarm?" height="100"

                        interactive="0" name="Decision"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="rhombus;fontStyle=1"

                        uniqueName="Decision_3" waitSetting="0"

                        width="170" x="72" y="187">

                        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/XPathQuery_6/result}.size() == 0&lt;/expression>&lt;/inputs>"/>

                        <transition activity="CommServDBQuery_2"

                            commented="0" displayName="Yes"

                            originalStyle="" points="" sourceX="85"

                            sourceY="234" status="0" style="defaultEdge"

                            targetX="83" targetY="327"

                            transitionIndex="0" value="true" x="0" y="0">

                            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                        <transition activity="Script_1" commented="0"

                            displayName="Yes" originalStyle="" points=""

                            sourceX="157" sourceY="237" status="0"

                            style="defaultEdge" targetX="379"

                            targetY="379" transitionIndex="0"

                            value="false" x="0" y="0">

                            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity breakpoint="0" commented="0"

                        continueOnFailure="0" created="1387373165359"

                        description="executes queries against the commserv database"

                        displayName="Get Table Result" height="34"

                        interactive="0" name="CommServDBQuery"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=CommServDBQuery"

                        uniqueName="CommServDBQuery_2" waitSetting="0"

                        width="162" x="75" y="314">

                        <inputs val="&lt;inputs>&lt;commCell>&lt;/commCell>&lt;query>SELECT * FROM CommServ.dbo.getHTMLTableFromXML(N''xpath:{/workflow/ExecuteCommand_1/commandOutput}'')&lt;/query>&lt;/inputs>"/>

                        <transition activity="Email_2" commented="0"

                            originalStyle="" points="" sourceX="156"

                            sourceY="331" status="0" style="defaultEdge"

                            targetX="155" targetY="415"

                            transitionIndex="0" x="0" y="0">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity breakpoint="0" commented="0"

                        continueOnFailure="0" created="1387298310111"

                        description="if/else based decision"

                        displayName="Is Health Param?" height="100"

                        interactive="0" name="Decision"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="rhombus;fontStyle=1"

                        uniqueName="Decision_2" waitSetting="0"

                        width="144" x="372" y="144">

                        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/ForEach_1/row/col[3]} == 0&lt;/expression>&lt;/inputs>"/>

                        <transition activity="XPathQuery_6"

                            commented="0" displayName="No"

                            originalStyle="" points="" sourceX="245"

                            sourceY="187" status="0" style="defaultEdge"

                            targetX="76" targetY="148"

                            transitionIndex="0" value="false" x="0" y="0">

                            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                        <transition activity="XPathQuery_1"

                            commented="0" displayName="Yes"

                            originalStyle="" points="" sourceX="245"

                            sourceY="187" status="0" style="defaultEdge"

                            targetX="430" targetY="186"

                            transitionIndex="0" value="true" x="0" y="0">

                            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity breakpoint="0" commented="0"

                        continueOnFailure="0" created="1383924496681"

                        description="retrieves a list of values from xml"

                        displayName="Get CommCell name" height="34"

                        interactive="0" name="XPathQuery"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=XPathQuery"

                        uniqueName="XPathQuery_1" waitSetting="0"

                        width="163" x="726" y="91">

                        <inputs val="&lt;inputs>&lt;xml class=&quot;java.lang.String&quot;>xpath:{/workflow/ExecuteCommand_1/commandOutput}&lt;/xml>&lt;xpath class=&quot;java.lang.String&quot;>(/Results/TableResults/Row/Column[@columnName=&quot;CommServeName&quot;])&lt;/xpath>&lt;outputType class=&quot;workflow.types.SimpleType&quot;>String&lt;/outputType>&lt;outputAsList class=&quot;java.lang.Boolean&quot;>true&lt;/outputAsList>&lt;/inputs>"/>

                        <transition activity="XPathQuery_2"

                            commented="0" originalStyle="" points=""

                            sourceX="520" sourceY="159" status="0"

                            style="defaultEdge" targetX="533"

                            targetY="213" transitionIndex="0" x="0" y="0">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity breakpoint="0" commented="0"

                        continueOnFailure="0" created="1383925095617"

                        description="retrieves a list of values from xml"

                        displayName="Get Result" height="34"

                        interactive="0" name="XPathQuery"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=XPathQuery"

                        uniqueName="XPathQuery_2" waitSetting="0"

                        width="110" x="753" y="169">

                        <inputs val="&lt;inputs>&lt;xml class=&quot;java.lang.String&quot;>xpath:{/workflow/ExecuteCommand_1/commandOutput}&lt;/xml>&lt;xpath class=&quot;java.lang.String&quot;>(/Results/TableResults/Row[1]/Column[@columnName=&quot;xpath:{/workflow/ForEach_1/row/col[8]}&quot;])&lt;/xpath>&lt;outputType class=&quot;workflow.types.SimpleType&quot;>String&lt;/outputType>&lt;outputAsList class=&quot;java.lang.Boolean&quot;>true&lt;/outputAsList>&lt;/inputs>"/>

                        <transition activity="XPathQuery_3"

                            commented="0" originalStyle="" points=""

                            sourceX="537" sourceY="222" status="0"

                            style="defaultEdge" targetX="539"

                            targetY="276" transitionIndex="0" x="0" y="0">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity breakpoint="0" commented="0"

                        continueOnFailure="0" created="1384163974505"

                        description="retrieves a list of values from xml"

                        displayName="Get Reason" height="34"

                        interactive="0" name="XPathQuery"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=XPathQuery"

                        uniqueName="XPathQuery_3" waitSetting="0"

                        width="110" x="746" y="245">

                        <inputs val="&lt;inputs>&lt;xml class=&quot;java.lang.String&quot;>xpath:{/workflow/ExecuteCommand_1/commandOutput}&lt;/xml>&lt;xpath class=&quot;java.lang.String&quot;>(/Results/TableResults/Row/Column[@columnName=&quot;Reason&quot;])&lt;/xpath>&lt;outputType class=&quot;workflow.types.SimpleType&quot;>String&lt;/outputType>&lt;outputAsList class=&quot;java.lang.Boolean&quot;>true&lt;/outputAsList>&lt;/inputs>"/>

                        <transition activity="XPathQuery_4"

                            commented="0" originalStyle="" points=""

                            sourceX="534" sourceY="275" status="0"

                            style="defaultEdge" targetX="547"

                            targetY="330" transitionIndex="0" x="0" y="0">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity breakpoint="0" commented="0"

                        continueOnFailure="0" created="1384528391037"

                        description="retrieves a list of values from xml"

                        displayName="Get Remarks" height="34"

                        interactive="0" name="XPathQuery"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=XPathQuery"

                        uniqueName="XPathQuery_4" waitSetting="0"

                        width="115" x="740" y="310">

                        <inputs val="&lt;inputs>&lt;xml class=&quot;java.lang.String&quot;>xpath:{/workflow/ExecuteCommand_1/commandOutput}&lt;/xml>&lt;xpath class=&quot;java.lang.String&quot;>(/Results/TableResults/Row/Column[@columnName=&quot;Remarks&quot;])&lt;/xpath>&lt;outputType class=&quot;workflow.types.SimpleType&quot;>String&lt;/outputType>&lt;outputAsList class=&quot;java.lang.Boolean&quot;>true&lt;/outputAsList>&lt;/inputs>"/>

                        <transition activity="XPathQuery_5"

                            commented="0" originalStyle="" points=""

                            sourceX="533" sourceY="329" status="0"

                            style="defaultEdge" targetX="546"

                            targetY="373" transitionIndex="0" x="0" y="0">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity breakpoint="0" commented="0"

                        continueOnFailure="0" created="1384551009704"

                        description="retrieves a list of values from xml"

                        displayName="Get CS Unique Id" height="34"

                        interactive="0" name="XPathQuery"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=XPathQuery"

                        uniqueName="XPathQuery_5" waitSetting="0"

                        width="143" x="726" y="375">

                        <inputs val="&lt;inputs>&lt;xml class=&quot;java.lang.String&quot;>xpath:{/workflow/ExecuteCommand_1/commandOutput}&lt;/xml>&lt;xpath class=&quot;java.lang.String&quot;>(/Results/TableResults/Row/Column[@columnName=&quot;CsUniqueId&quot;])&lt;/xpath>&lt;outputType class=&quot;workflow.types.SimpleType&quot;>String&lt;/outputType>&lt;outputAsList class=&quot;java.lang.Boolean&quot;>true&lt;/outputAsList>&lt;/inputs>"/>

                        <transition activity="Decision_1" commented="0"

                            originalStyle="" points="" sourceX="663"

                            sourceY="378" status="0" style="defaultEdge"

                            targetX="502" targetY="288"

                            transitionIndex="0" x="0" y="0">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity breakpoint="0" commented="0"

                        continueOnFailure="0" created="1384726154371"

                        description="if/else based decision"

                        displayName="Should Send Alarm?" height="100"

                        interactive="0" name="Decision"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="rhombus;fontStyle=1"

                        uniqueName="Decision_1" waitSetting="0"

                        width="162" x="527" y="236">

                        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/XPathQuery_2/result}.contains(&quot;NoNotifReq&quot;)&lt;/expression>&lt;/inputs>"/>

                        <transition activity="Email_1" commented="0"

                            displayName="Yes" originalStyle="" points=""

                            sourceX="457" sourceY="295" status="0"

                            style="defaultEdge" targetX="454"

                            targetY="383" transitionIndex="0"

                            value="false" x="0" y="0">

                            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                        <transition activity="Script_1" commented="0"

                            displayName="No" originalStyle="" points=""

                            sourceX="608" sourceY="286" status="0"

                            style="defaultEdge" targetX="418"

                            targetY="369" transitionIndex="0"

                            value="true" x="0" y="0">

                            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity breakpoint="0" commented="0"

                        continueOnFailure="0" created="1383862686193"

                        description="Sends an email to a list of users"

                        displayName="Email" height="34" interactive="0"

                        name="Email"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=Email" uniqueName="Email_1"

                        waitSetting="0" width="100" x="555" y="385">

                        <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot;>&lt;from class=&quot;java.lang.String&quot;>admin@xpath:{/workflow/ForEach_1/row/col[10]}&lt;/from>&lt;to class=&quot;java.lang.String&quot;>xpath:{/workflow/ForEach_1/row/col[5]}&lt;/to>&lt;cc class=&quot;java.lang.String&quot; />&lt;bcc class=&quot;java.lang.String&quot; />&lt;subject class=&quot;java.lang.String&quot;>Alarm for xpath:{/workflow/ForEach_1/row/col[8]} for CommCell xpath:{/workflow/XPathQuery_1/result}&lt;/subject>&lt;attachments class=&quot;java.lang.Object&quot; />&lt;body class=&quot;java.lang.String&quot;>&amp;lt;style type=&quot;text/css&quot;&amp;gt;&#xd;&#xa;  &amp;lt;!--&#xd;&#xa;body { font-family: Arial, Helvetica, sans-serif; background-color: white; line-height: 18px; color: #000; font-size: 12px }&#xd;&#xa;h3 { font-family: UbuntuRegular; color: #444; font-size: 20px }&#xd;&#xa;a:visited { text-decoration: underline; color: #0000ff }&#xd;&#xa;h2 { font-family: UbuntuRegular; color: #000000; font-size: 20px }&#xd;&#xa;p { margin-left: 0px }&#xd;&#xa;h1 { font-family: UbuntuRegular; color: #000000; font-size: 18px }&#xd;&#xa;ul { margin-left: -20px }&#xd;&#xa;a:active { text-decoration: underline; color: #0000ff }&#xd;&#xa;li { padding-bottom: 12px }&#xd;&#xa;a:link { text-decoration: underline; color: #0000ff }&#xd;&#xa;th { font-family: Arial, Helvetica, sans-serif; line-height: 18px; color: #000; font-size: 12px }&#xd;&#xa;td { font-family: Arial, Helvetica, sans-serif; line-height: 18px; color: #000; font-size: 13px }&#xd;&#xa;a:hover { text-decoration: none; color: #0000ff }&#xd;&#xa;  --&amp;gt;&#xd;&#xa;&amp;lt;/style&amp;gt;&#xd;&#xa;&#xd;&#xa;  &#xd;&#xa;  &#xd;&#xa;&amp;lt;div align=&quot;left&quot;&amp;gt;&#xd;&#xa;  &amp;lt;table cellpadding=&quot;0&quot; border=&quot;0&quot; width=&quot;800&quot; align=&quot;center&quot; cellspacing=&quot;0&quot;&amp;gt;&#xd;&#xa;&#xd;&#xa;&amp;lt;tr&amp;gt;&#xd;&#xa;  &amp;lt;td&amp;gt;&#xd;&#xa;&amp;lt;p&amp;gt;&#xd;&#xa;  &#xd;&#xa;&amp;lt;/p&amp;gt;&#xd;&#xa;  &amp;lt;/td&amp;gt;&#xd;&#xa;&amp;lt;/tr&amp;gt;&#xd;&#xa;&amp;lt;tr&amp;gt;&#xd;&#xa;  &amp;lt;td style=&quot;border-bottom-width: 1px; border-right-width: 1px; border-left-width: 1px&quot;&amp;gt;&#xd;&#xa;&amp;lt;div align=&quot;left&quot;&amp;gt;&#xd;&#xa;  &amp;lt;table background-repeat=&quot;repeat&quot; class=&quot;MsoNormalTable&quot; background-image=&quot;null&quot; background-color=&quot;white&quot; width=&quot;800&quot; background-position=&quot;null&quot; align=&quot;left&quot; background-attachment=&quot;scroll&quot;&amp;gt;&#xd;&#xa;&amp;lt;tr&amp;gt;&#xd;&#xa;  &amp;lt;td&amp;gt;&#xd;&#xa;&amp;lt;p&amp;gt;&#xd;&#xa;  Hello &amp;lt;b&amp;gt;xpath:{/workflow/ForEach_1/row/col[7]} &amp;lt;/b&amp;gt;,&amp;lt;o p=&quot;#DEFAULT&quot;&amp;gt;&amp;lt;/o&amp;gt;&#xd;&#xa;&amp;lt;/p&amp;gt;&#xd;&#xa;&amp;lt;p&amp;gt;&#xd;&#xa;  The current &amp;lt;b&amp;gt;xpath:{/workflow/ForEach_1/row/col[2]} &amp;lt;/b&amp;gt;for &#xd;&#xa;  the CommCell &amp;lt;b&amp;gt;xpath:{/workflow/XPathQuery_1/result} &amp;lt;/b&amp;gt;is &#xd;&#xa;  &amp;lt;b&amp;gt;xpath:{/workflow/XPathQuery_2/result}.&amp;lt;/b&amp;gt;&#xd;&#xa;&amp;lt;/p&amp;gt;&#xd;&#xa;&amp;lt;p&amp;gt;&#xd;&#xa;  &amp;lt;br&amp;gt;&#xd;&#xa;  &#xd;&#xa;&amp;lt;/p&amp;gt;&#xd;&#xa;&amp;lt;p&amp;gt;&#xd;&#xa;  &amp;lt;b&amp;gt;Why this notification?&amp;lt;/b&amp;gt;&#xd;&#xa;&amp;lt;/p&amp;gt;&#xd;&#xa;&amp;lt;p&amp;gt;&#xd;&#xa;  xpath:{/workflow/XPathQuery_3/result}&#xd;&#xa;&amp;lt;/p&amp;gt;&#xd;&#xa;&amp;lt;p&amp;gt;&#xd;&#xa;  &amp;lt;br&amp;gt;&#xd;&#xa;  &#xd;&#xa;&amp;lt;/p&amp;gt;&#xd;&#xa;&amp;lt;p&amp;gt;&#xd;&#xa;  &amp;lt;b&amp;gt;Remarks:&amp;lt;/b&amp;gt;&#xd;&#xa;&amp;lt;/p&amp;gt;&#xd;&#xa;&amp;lt;p&amp;gt;&#xd;&#xa;  xpath:{/workflow/XPathQuery_4/result}&#xd;&#xa;&amp;lt;/p&amp;gt;&#xd;&#xa;&amp;lt;p&amp;gt;&#xd;&#xa;  &#xd;&#xa;&amp;lt;/p&amp;gt;&#xd;&#xa;&amp;lt;br&amp;gt;&#xd;&#xa;&#xd;&#xa;&#xd;&#xa;&amp;lt;p&amp;gt;&#xd;&#xa;  &amp;lt;i&amp;gt;To unsubscribe, please contact your Administrator.&amp;lt;/i&amp;gt;&#xd;&#xa;&amp;lt;/p&amp;gt;&#xd;&#xa;&amp;lt;p&amp;gt;&#xd;&#xa;  &amp;lt;br&amp;gt;&#xd;&#xa;  &#xd;&#xa;&amp;lt;/p&amp;gt;&#xd;&#xa;&amp;lt;p&amp;gt;&#xd;&#xa;  &#xd;&#xa;&amp;lt;/p&amp;gt;&#xd;&#xa;&amp;lt;p&amp;gt;&#xd;&#xa;  Thank you,&amp;lt;o p=&quot;#DEFAULT&quot;&amp;gt;&amp;lt;/o&amp;gt;&amp;lt;br&amp;gt;Administrator&amp;lt;o p=&quot;#DEFAULT&quot;&amp;gt;&amp;lt;/o&amp;gt;&#xd;&#xa;&amp;lt;/p&amp;gt;&#xd;&#xa;  &amp;lt;/td&amp;gt;&#xd;&#xa;&amp;lt;/tr&amp;gt;&#xd;&#xa;  &amp;lt;/table&amp;gt;&#xd;&#xa;&amp;lt;/div&amp;gt;&#xd;&#xa;  &amp;lt;/td&amp;gt;&#xd;&#xa;&amp;lt;/tr&amp;gt;&#xd;&#xa;  &amp;lt;/table&amp;gt;&#xd;&#xa;  &amp;lt;br&amp;gt;&#xd;&#xa;&amp;lt;/div&amp;gt;&lt;/body>&lt;html class=&quot;java.lang.Boolean&quot;>true&lt;/html>&lt;/email>&lt;/inputs>"/>

                    </Activity>

                    <Activity breakpoint="0" commented="0"

                        continueOnFailure="0" created="1387298886030"

                        description="Sends an email to a list of users"

                        displayName="Email" height="34" interactive="0"

                        name="Email"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=Email" uniqueName="Email_2"

                        waitSetting="0" width="100" x="98" y="395">

                        <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot;>&lt;from class=&quot;java.lang.String&quot;>admin@xpath:{/workflow/ForEach_1/row/col[10]}&lt;/from>&lt;to class=&quot;java.lang.String&quot;>xpath:{/workflow/ForEach_1/row/col[5]}&lt;/to>&lt;cc class=&quot;java.lang.String&quot; />&lt;bcc class=&quot;java.lang.String&quot; />&lt;subject class=&quot;java.lang.String&quot;>Alarm [xpath:{/workflow/ForEach_1/row/col[9]}] for Report [xpath:{/workflow/ForEach_1/row/col[11]}]&lt;/subject>&lt;attachments class=&quot;java.lang.Object&quot; />&lt;body class=&quot;java.lang.String&quot;>&amp;lt;style type=&quot;text/css&quot;&amp;gt;&#xd;&#xa;      &amp;lt;!--&#xd;&#xa;        body { font-family: Arial, Helvetica, sans-serif; background-color: white; line-height: 18px; color: #000; font-size: 12px }&#xd;&#xa;        h3 { font-family: UbuntuRegular; color: #444; font-size: 20px }&#xd;&#xa;        a:visited { text-decoration: underline; color: #0000ff }&#xd;&#xa;        h2 { font-family: UbuntuRegular; color: #000000; font-size: 20px }&#xd;&#xa;        p { margin-left: 0px }&#xd;&#xa;        h1 { font-family: UbuntuRegular; color: #000000; font-size: 18px }&#xd;&#xa;        ul { margin-left: -20px }&#xd;&#xa;        a:active { text-decoration: underline; color: #0000ff }&#xd;&#xa;        .header { border-right-style: solid; padding-left: 0; border-top-style: solid; font-size: 12px; margin-right: 0; border-left-width: 1px; border-left-style: solid; text-align: center; background-color: #F4F4F4; margin-bottom: 5px; padding-right: 0; padding-bottom: 15px; border-top-width: 1px; border-bottom-style: solid; padding-top: 15px; margin-left: 0; border-right-width: 1px; border-bottom-width: 1px; margin-top: 5px }&#xd;&#xa;        li { padding-bottom: 12px }&#xd;&#xa;        a:link { text-decoration: underline; color: #0000ff }&#xd;&#xa;        .datatable th { border-right-style: solid; border-top-style: solid; border-top-color: #cccccc; border-left-width: 1px; border-left-style: solid; border-bottom-color: #cccccc; border-left-color: #cccccc; border-top-width: 1px; border-right-color: #cccccc; border-bottom-style: solid; border-right-width: 1px; border-bottom-width: 1px }&#xd;&#xa;        .datatable td { border-right-style: solid; border-top-style: solid; border-top-color: #cccccc; border-left-width: 1px; border-left-style: solid; border-bottom-color: #cccccc; border-left-color: #cccccc; border-top-width: 1px; border-right-color: #cccccc; border-bottom-style: solid; border-right-width: 1px; border-bottom-width: 1px }&#xd;&#xa;        a:hover { text-decoration: none; color: #0000ff }&#xd;&#xa;        .datatable { border-right-style: solid; border-top-style: solid; border-top-color: #cccccc; border-left-width: 1px; border-left-style: solid; width: 100%; text-align: center; border-bottom-color: #cccccc; background-color: #ECF8E0; border-left-color: #cccccc; border-top-width: 1px; border-right-color: #cccccc; border-bottom-style: solid; border-right-width: 1px; border-bottom-width: 1px }&#xd;&#xa;      --&amp;gt;&#xd;&#xa;    &amp;lt;/style&amp;gt;&#xd;&#xa;    &#xd;&#xa;  &#xd;&#xa;  &#xd;&#xa;    &amp;lt;div align=&quot;left&quot;&amp;gt;&#xd;&#xa;      &amp;lt;table cellpadding=&quot;0&quot; border=&quot;0&quot; width=&quot;800&quot; align=&quot;center&quot; cellspacing=&quot;0&quot;&amp;gt;&#xd;&#xa;        &amp;lt;tr&amp;gt;&#xd;&#xa;          &amp;lt;td&amp;gt;&#xd;&#xa;            &amp;lt;p&amp;gt;&#xd;&#xa;              &#xd;&#xa;            &amp;lt;/p&amp;gt;&#xd;&#xa;          &amp;lt;/td&amp;gt;&#xd;&#xa;        &amp;lt;/tr&amp;gt;&#xd;&#xa;        &amp;lt;tr&amp;gt;&#xd;&#xa;          &amp;lt;td style=&quot;border-bottom-width: 1px; border-right-width: 1px; border-left-width: 1px&quot;&amp;gt;&#xd;&#xa;            &amp;lt;div align=&quot;left&quot;&amp;gt;&#xd;&#xa;              &amp;lt;table background-repeat=&quot;repeat&quot; class=&quot;MsoNormalTable&quot; background-image=&quot;null&quot; background-color=&quot;white&quot; width=&quot;800&quot; background-position=&quot;null&quot; align=&quot;left&quot; background-attachment=&quot;scroll&quot;&amp;gt;&#xd;&#xa;                &amp;lt;tr&amp;gt;&#xd;&#xa;                  &amp;lt;td&amp;gt;&#xd;&#xa;                    &amp;lt;p&amp;gt;&#xd;&#xa;                      Hello &amp;lt;b&amp;gt;xpath:{/workflow/ForEach_1/row/col[7]} &amp;lt;/b&amp;gt;,&amp;lt;o p=&quot;#DEFAULT&quot;&amp;gt;&amp;lt;/o&amp;gt;&#xd;&#xa;                    &amp;lt;/p&amp;gt;&#xd;&#xa;                    &amp;lt;p&amp;gt;&#xd;&#xa;                      The following results have been generated for the alarm &amp;lt;b&amp;gt;xpath:{/workflow/ForEach_1/row/col[9]} &#xd;&#xa;                      &amp;lt;/b&amp;gt;on report &amp;lt;b&amp;gt;xpath:{/workflow/ForEach_1/row/col[11]}.&amp;lt;/b&amp;gt;&#xd;&#xa;                    &amp;lt;/p&amp;gt;&#xd;&#xa;                    &amp;lt;p&amp;gt;&#xd;&#xa;                      &#xd;&#xa;                    &amp;lt;/p&amp;gt;&#xd;&#xa;                    &amp;lt;p&amp;gt;&#xd;&#xa;                      &amp;lt;b&amp;gt;Results:&amp;lt;/b&amp;gt;&#xd;&#xa;                    &amp;lt;/p&amp;gt;&#xd;&#xa;                    &amp;lt;p&amp;gt;&#xd;&#xa;                      &#xd;&#xa;                    &amp;lt;/p&amp;gt;&#xd;&#xa;                    xpath:{/workflow/CommServDBQuery_2/resultSets/row/col}&#xd;&#xa;&#xd;&#xa;                    &amp;lt;p&amp;gt;&#xd;&#xa;                      &#xd;&#xa;                    &amp;lt;/p&amp;gt;&#xd;&#xa;                    &amp;lt;p&amp;gt;&#xd;&#xa;                      &amp;lt;br&amp;gt;&#xd;&#xa;                      &#xd;&#xa;                    &amp;lt;/p&amp;gt;&#xd;&#xa;                    &amp;lt;p&amp;gt;&#xd;&#xa;                      &#xd;&#xa;                    &amp;lt;/p&amp;gt;&#xd;&#xa;                    &amp;lt;p&amp;gt;&#xd;&#xa;                      Thank you,&amp;lt;o p=&quot;#DEFAULT&quot;&amp;gt;&amp;lt;/o&amp;gt;&amp;lt;br&amp;gt;Administrator&amp;lt;o p=&quot;#DEFAULT&quot;&amp;gt;&amp;lt;/o&amp;gt;&#xd;&#xa;                    &amp;lt;/p&amp;gt;&#xd;&#xa;                  &amp;lt;/td&amp;gt;&#xd;&#xa;                &amp;lt;/tr&amp;gt;&#xd;&#xa;              &amp;lt;/table&amp;gt;&#xd;&#xa;            &amp;lt;/div&amp;gt;&#xd;&#xa;          &amp;lt;/td&amp;gt;&#xd;&#xa;        &amp;lt;/tr&amp;gt;&#xd;&#xa;      &amp;lt;/table&amp;gt;&#xd;&#xa;      &amp;lt;br&amp;gt;&#xd;&#xa;    &amp;lt;/div&amp;gt;&lt;/body>&lt;html class=&quot;java.lang.Boolean&quot;>true&lt;/html>&lt;/email>&lt;/inputs>"/>

                    </Activity>

                    <Activity breakpoint="0" commented="0"

                        continueOnFailure="0" created="1387821553862"

                        description="activity to execute code snippets in the selected language"

                        displayName="Do Nothing" height="34"

                        interactive="0" name="Script"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=Script" uniqueName="Script_1"

                        waitSetting="0" width="103" x="342" y="296">

                        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;&quot; />&lt;/inputs>"/>

                    </Activity>

                </superProcess>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1387808592259"

                description="creates a super process group"

                displayName="Catch Block" height="247" interactive="0"

                name="ProcessBlock"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0" style="swimlane"

                uniqueName="ProcessBlock_2" waitSetting="0" width="160"

                x="1110" y="181">

                <activitySchema>

                    <inputs attribute="0" listType="0" name="inputs" required="1"/>

                    <outputs attribute="0" listType="0" name="outputs" required="1"/>

                </activitySchema>

                <inputs val="&lt;inputs>&lt;inputs />&lt;/inputs>"/>

                <superProcess>

                    <Start breakpoint="0" commented="0"

                        continueOnFailure="0" created="1387808592259"

                        description="" displayName="Start" height="30"

                        interactive="0" name="Start" originalStyle=""

                        skipAttempt="0"

                        style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                        uniqueName="Start_4" waitSetting="0" width="120"

                        x="23" y="57">

                        <inputs val="&lt;inputs />"/>

                        <transition activity="LogEvent_2" commented="0"

                            originalStyle="" points="" sourceX="83"

                            sourceY="72" status="0" style="defaultEdge"

                            targetX="81" targetY="157"

                            transitionIndex="0" x="5" y="27">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Start>

                    <Activity breakpoint="0" commented="0"

                        continueOnFailure="0" created="1387808951154"

                        description="logs an event in the commcell console with the specified severity level"

                        displayName="Create Info Event" height="34"

                        interactive="0" name="LogEvent"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=LogEvent"

                        uniqueName="LogEvent_2" waitSetting="0"

                        width="146" x="8" y="140">

                        <inputs val="&lt;inputs>&lt;severity class=&quot;workflow.types.SeverityLevel&quot;>INFO&lt;/severity>&lt;message class=&quot;java.lang.String&quot;>Failed to run Alarm [xpath:{/workflow/ForEach_1/row/col[9]}] for Report [xpath:{/workflow/ForEach_1/row/col[11]}]&lt;/message>&lt;/inputs>"/>

                    </Activity>

                </superProcess>

            </Activity>

        </superProcess>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1384553069200" description="Ends the workflow"

        displayName="End" height="34" interactive="0" name="WorkflowEnd"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=WorkflowEnd"

        uniqueName="WorkflowEnd_1" waitSetting="0" width="119" x="677" y="681">

        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; />&lt;failureMessage class=&quot;java.lang.String&quot; />&lt;/inputs>"/>

    </Activity>

    <schema>

        <inputs attribute="0" className="" listType="0" name="inputs"

            required="1" type="">

            <children attribute="0" className="java.lang.String"

                controlType="0" hidden="0" inputType="java.lang.String"

                listType="0" name="sCLOUDINSTANCE" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" hidden="0" inputType="java.lang.String"

                listType="0" name="pCLOUDACCESS" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

        </inputs>

        <variables attribute="0" className="" listType="0"

            name="variables" required="1" type=""/>

        <outputs className="" name="outputs" type=""/>

    </schema>

</workflow>'

IF not exists (select * from WF_Definition where Name = @name)

BEGIN
	INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision)


	VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision)

	SET @workflowId = @@IDENTITY
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


	VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

	SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = ISNULL(revision, '') From WF_Definition WHERE Name = @name

	IF (@currentFlags & 4 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0) AND (@currentRevision <> @revision)

	BEGIN

		SET @version = @version + 1

		UPDATE WF_Definition

		SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision

		WHERE Name = @name

		IF (@flags & 8 > 0 OR @flags & 16 > 0)

		BEGIN

			UPDATE WF_Definition

			SET flags = @flags

			WHERE Name = @name

		END
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


		VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

	END

END


