

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_DRTestingWorkflow.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/WFD_DRTestingWorkflow.script,v $ $Id: WFD_DRTestingWorkflow.script,v 1.5 2015/06/05 16:36:14 csunderland Exp $";
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER OFF

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.5 $'

SET @name = 'DRTestingWorkflow'

SET @description = 'This workflow allows to test the disaster recovery server using some clients and media agents from production server and sends an email to the admin about the status in the end.'

SET @version = 1

SET @flags = 6

SET @definition = '<workflow apiMode="0"

    description="This workflow allows to test the disaster recovery server using some clients and media agents from production server and sends an email to the admin about the status in the end."

    inputs="&lt;inputs>&lt;clientList class=&quot;java.lang.String&quot;>Clients participating in the testing (ex: client1.xyz.commvault.com,client2.xyz.commvault.com)&lt;/clientList>&lt;DRCSName class=&quot;java.lang.String&quot;>FQDN of DRCS (ex: drcs.xyz.commvault.com)&lt;/DRCSName>&lt;dbDumpPath class=&quot;java.lang.String&quot;>local path on DR CS where DR dump gets copied to (ex: C:\DRdump)&lt;/dbDumpPath>&lt;sourceClient class=&quot;java.lang.String&quot;>Name of the client used for backup (ex: client1.xyz.commvault.com)&lt;/sourceClient>&lt;restoreClient class=&quot;java.lang.String&quot;>Name of the client used for out of place restore (ex: client2.xyz.commvault.com)&lt;/restoreClient>&lt;sourcePath class=&quot;java.lang.String&quot;>Path on source client which is backed up (C:\Program Files\CommVault\Simpana\Base)&lt;/sourcePath>&lt;destinationPath class=&quot;java.lang.String&quot;>Path on restore client for out of place restore (C:\TestRestore)&lt;/destinationPath>&lt;DRCSComputerUsername class=&quot;java.lang.String&quot;>ex: .\administrator&lt;/DRCSComputerUsername>&lt;DRCSComputerPassword class=&quot;workflow.types.EncryptedString&quot;>370cd171cea49d45b46f2f99a9624aac8&lt;/DRCSComputerPassword>&lt;DRCSSqlPassword_sa_user class=&quot;workflow.types.EncryptedString&quot;>39028fa472beeecec151f1078ad921947&lt;/DRCSSqlPassword_sa_user>&lt;mediaAgent class=&quot;java.lang.String&quot;>Media agent participating in the testing  - FQDN (ex: mediaagent.xyz.commvault.com)&lt;/mediaAgent>&lt;EmailID class=&quot;java.lang.String&quot;>admin@xyz.com&lt;/EmailID>&lt;IsProdCSandDRCSonSameDomain class=&quot;java.lang.Boolean&quot;>true&lt;/IsProdCSandDRCSonSameDomain>&lt;IsProdCSandMAonSameDomain class=&quot;java.lang.Boolean&quot;>true&lt;/IsProdCSandMAonSameDomain>&lt;SubClientName class=&quot;java.lang.String&quot;>Name of subclient which is backed up and using for restore(ex: subclient1)&lt;/SubClientName>&lt;MAComputerUserName class=&quot;java.lang.String&quot;>ex: .\administrator&lt;/MAComputerUserName>&lt;MAComputerPassword class=&quot;workflow.types.EncryptedString&quot;>32b665035848c73e83f4c871ac552f27c&lt;/MAComputerPassword>&lt;ProductionCSUsername class=&quot;java.lang.String&quot;>ex: admin&lt;/ProductionCSUsername>&lt;ProductionCSPassword class=&quot;workflow.types.EncryptedString&quot;>39028fa472beeecec151f1078ad921947&lt;/ProductionCSPassword>&lt;CopyPrecedenceNumber class=&quot;java.lang.Integer&quot;>2&lt;/CopyPrecedenceNumber>&lt;/inputs>"

    interactive="0" name="DRTestingWorkflow" outputs="&lt;outputs />"

    variables="&lt;variables>&lt;noOfClients class=&quot;java.lang.Integer&quot; />&lt;success class=&quot;java.lang.String&quot; />&lt;DRCSShortName class=&quot;java.lang.String&quot; />&lt;NameChangeSuccess1 class=&quot;java.lang.String&quot; _list_=&quot;true&quot; />&lt;NameChangeSuccess2 class=&quot;java.lang.String&quot; _list_=&quot;true&quot; />&lt;NameChangeFail1 class=&quot;java.lang.String&quot; _list_=&quot;true&quot; />&lt;NameChangeFail2 class=&quot;java.lang.String&quot; _list_=&quot;true&quot; />&lt;CheckReadinessSuccess1 class=&quot;java.lang.String&quot; _list_=&quot;true&quot; />&lt;CheckReadinessSuccess2 class=&quot;java.lang.String&quot; _list_=&quot;true&quot; />&lt;CheckReadinessFail1 class=&quot;java.lang.String&quot; _list_=&quot;true&quot; />&lt;CheckReadinessFail2 class=&quot;java.lang.String&quot; _list_=&quot;true&quot; />&lt;WorkflowStatus class=&quot;java.lang.String&quot;>Incomplete&lt;/WorkflowStatus>&lt;TestRestoreFail class=&quot;java.lang.String&quot; _list_=&quot;true&quot; />&lt;ReasonForFailure class=&quot;java.lang.String&quot; />&lt;RemoveDIPSuccess class=&quot;java.lang.String&quot; _list_=&quot;true&quot; />&lt;RemoveDIPFail class=&quot;java.lang.String&quot; _list_=&quot;true&quot; />&lt;ProductionCSName class=&quot;java.lang.String&quot; />&lt;EmailBody class=&quot;java.lang.String&quot; />&lt;DRCSBasePath class=&quot;java.lang.String&quot; />&lt;MABasePath class=&quot;java.lang.String&quot; />&lt;MAShortName class=&quot;java.lang.String&quot; />&lt;SourceClientShortName class=&quot;java.lang.String&quot; />&lt;RestoreClientShortName class=&quot;java.lang.String&quot; />&lt;/variables>" workflowId="0">

    <Start breakpoint="0" commented="0" continueOnFailure="0"

        created="0" description="" displayName="Start" height="36"

        interactive="0" name="Start" originalStyle="" skipAttempt="0"

        style="image;image=/images/jgraphx/house.png"

        uniqueName="Start_1" waitSetting="0" width="61" x="-13" y="12">

        <inputs val="&lt;inputs />"/>

        <transition activity="ProcessBlock_1" commented="0"

            originalStyle="" points="" sourceX="17" sourceY="30"

            status="0" style="defaultEdge" targetX="66" targetY="75"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Start>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1379702192705"

        description="executes a set of activities when the workflow completes"

        displayName="OnWorkflowComplete-RevertSetupToOriginalState"

        height="530" interactive="0" maxRestarts="0"

        name="OnWorkflowComplete"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="swimlane;fillColor=#00CC00;gradientColor=#009933"

        uniqueName="OnWorkflowComplete_5" waitSetting="0" width="1449"

        x="460" y="815">

        <activitySchema>

            <inputs attribute="0" listType="0" name="inputs" required="1"/>

            <outputs attribute="0" listType="0" name="outputs" required="1"/>

        </activitySchema>

        <inputs val="&lt;inputs>&lt;inputs />&lt;/inputs>"/>

        <superProcess>

            <Start breakpoint="0" commented="0" continueOnFailure="0"

                created="1379702192705" description=""

                displayName="Start" height="30" interactive="0"

                name="Start" originalStyle="" skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_13" waitSetting="0" width="120" x="11" y="30">

                <inputs val="&lt;inputs />"/>

                <transition activity="Login_2" commented="0"

                    originalStyle="" points="" sourceX="71" sourceY="45"

                    status="0" style="defaultEdge" targetX="58"

                    targetY="140" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1379344754155"

                description="Sends an email to a list of users"

                displayName="SuccessEmail" height="34" interactive="0"

                maxRestarts="0" name="Email"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Email;gradientColor=#009900;fillColor=#009900"

                uniqueName="Email_2" waitSetting="0" width="119"

                x="1171" y="335">

                <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot;>&lt;to class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/EmailID}&lt;/to>&lt;cc class=&quot;java.lang.String&quot; />&lt;bcc class=&quot;java.lang.String&quot; />&lt;from class=&quot;java.lang.String&quot; />&lt;subject class=&quot;java.lang.String&quot;>DRWorkflow Status - xpath:{/workflow/variables/WorkflowStatus}&lt;/subject>&lt;body class=&quot;java.lang.String&quot;>&amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font size=&quot;5&quot;&amp;gt;DRWorkflow Status&amp;lt;/font&amp;gt; - &amp;lt;font color=&quot;#009900&quot; size=&quot;5&quot;&amp;gt;xpath:{/workflow/variables/WorkflowStatus}&amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font color=&quot;#666666&quot; size=&quot;5&quot;&amp;gt;xpath:{/workflow/variables/EmailBody}&amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/p&amp;gt;&lt;/body>&lt;attachments class=&quot;java.lang.Object&quot; />&lt;html class=&quot;java.lang.Boolean&quot;>true&lt;/html>&lt;/email>&lt;/inputs>"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1377804965210"

                description="iterates a group of activities over a list of values"

                displayName="RevertNameChange(DRtoProductionCS)"

                height="390" interactive="0" maxRestarts="0"

                name="ForEach"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0" style="swimlane"

                uniqueName="ForEach_3" waitSetting="0" width="300"

                x="220" y="37">

                <activitySchema>

                    <inputs>

                        <children className="java.lang.String"

                            inputType="java.lang.String" name="name" type="{http://www.w3.org/2001/XMLSchema}string"/>

                        <children className="java.lang.Object"

                            inputType="java.lang.Object" name="values" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                        <children className="java.lang.Integer"

                            defaultValue="1"

                            inputType="java.lang.Integer"

                            name="numberOfParallelExecutions" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                        <children className="java.lang.Boolean"

                            defaultValue="false"

                            inputType="java.lang.Boolean"

                            name="continueOnFailure" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                    </inputs>

                    <outputs name="outputs">

                        <children className="java.lang.Object"

                            inputType="java.lang.Object" listType="0"

                            name="output" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                    </outputs>

                </activitySchema>

                <inputs val="&lt;inputs>&lt;name class=&quot;java.lang.String&quot;>output&lt;/name>&lt;values class=&quot;java.lang.Object&quot;>xpath:{/workflow/Script_2/output}&lt;/values>&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot;>xpath:{/workflow/variables/noOfClients}&lt;/numberOfParallelExecutions>&lt;continueOnFailure class=&quot;java.lang.Boolean&quot;>true&lt;/continueOnFailure>&lt;/inputs>"/>

                <transition activity="Delay_4" commented="0"

                    originalStyle="" points="" sourceX="-792"

                    sourceY="217" status="0" style="defaultEdge"

                    targetX="-762" targetY="464" transitionIndex="0"

                    x="-1120" y="-8">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <superProcess>

                    <Start breakpoint="0" commented="0"

                        continueOnFailure="0" created="1377791413595"

                        description="" displayName="Start" height="30"

                        interactive="0" name="Start" originalStyle=""

                        skipAttempt="0"

                        style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                        uniqueName="Start_4" waitSetting="0" width="120"

                        x="17" y="29">

                        <inputs val="&lt;inputs />"/>

                        <transition activity="Execute_3" commented="0"

                            originalStyle="" points="" sourceX="70"

                            sourceY="43" status="0" style="defaultEdge"

                            targetX="68" targetY="123"

                            transitionIndex="0" x="-41" y="-6">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Start>

                    <Activity breakpoint="0" commented="0"

                        continueOnFailure="1" created="1366835388801"

                        description="if/else based decision"

                        displayName="Successful ?" height="100"

                        interactive="0" maxRestarts="0" name="Decision"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="rhombus;fontStyle=1"

                        uniqueName="Decision_5" waitSetting="0"

                        width="120" x="16" y="212">

                        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/XPathQuery_3/result}==0&lt;/expression>&lt;/inputs>"/>

                        <transition activity="AddToList_3" commented="0"

                            displayName="Yes" originalStyle="" points=""

                            sourceX="-28" sourceY="198" status="0"

                            style="defaultEdge" targetX="-28"

                            targetY="345" transitionIndex="0"

                            value="true" x="-359" y="0">

                            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                        <transition activity="AddToList_8" commented="0"

                            displayName="no" offsetX="-3" offsetY="-16"

                            originalStyle="" points="196.0,262.0"

                            sourceX="76" sourceY="262" status="0"

                            style="defaultEdge" targetX="217"

                            targetY="309" transitionIndex="0"

                            value="false" x="0" y="0">

                            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity breakpoint="0" commented="0"

                        continueOnFailure="1" created="1366924520373"

                        description="utility to add objects to a list"

                        displayName="AddToSuccessList" height="34"

                        interactive="0" maxRestarts="0" name="AddToList"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=AddToList"

                        uniqueName="AddToList_3" waitSetting="0"

                        width="160" x="6" y="350">

                        <inputs val="&lt;inputs>&lt;addToList class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/NameChangeSuccess2}&lt;/addToList>&lt;itemToAdd class=&quot;java.lang.Object&quot;>xpath:{/workflow/ForEach_3/output}&lt;/itemToAdd>&lt;/inputs>"/>

                    </Activity>

                    <Activity breakpoint="0" commented="0"

                        continueOnFailure="1" created="1376757443273"

                        description="" displayName="NameChangeOperation"

                        height="34" interactive="0" maxRestarts="0"

                        name="Execute"

                        namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                        originalStyle="" skipAttempt="0"

                        style="label;image=Execute"

                        uniqueName="Execute_3" waitSetting="0"

                        width="183" x="7" y="90">

                        <inputs val="&lt;inputs>&lt;inputXml class=&quot;java.lang.String&quot;>&amp;lt;?xml version=&quot;1.0&quot; encoding=&quot;UTF-8&quot; standalone=&quot;no&quot; ?&amp;gt; &amp;#xD;&#xd;&#xa;&amp;lt;App_NameChangeRequest&amp;gt; &amp;#xD;&#xd;&#xa;    &amp;lt;updateDBOnClientsUnreachable&amp;gt;false&amp;lt;/updateDBOnClientsUnreachable&amp;gt; &amp;#xD;&#xd;&#xa;    &amp;lt;operation&amp;gt;CS_HOST_NAME_CHANGE&amp;lt;/operation&amp;gt; &amp;#xD;&#xd;&#xa;    &amp;lt;csHostName&amp;gt; &amp;#xD;&#xd;&#xa;        &amp;lt;oldData&amp;gt;xpath:{/workflow/variables/ProductionCSName}&amp;lt;/oldData&amp;gt; &amp;#xD;&#xd;&#xa;        &amp;lt;newData&amp;gt;xpath:{/workflow/variables/ProductionCSName}&amp;lt;/newData&amp;gt; &amp;#xD;&#xd;&#xa;    &amp;lt;/csHostName&amp;gt; &amp;#xD;&#xd;&#xa;    &amp;lt;clientList&amp;gt; &amp;#xD;&#xd;&#xa;        &amp;lt;clientName&amp;gt;xpath:{/workflow/ForEach_3/output}&amp;lt;/clientName&amp;gt; &amp;#xD;&#xd;&#xa;    &amp;lt;/clientList&amp;gt; &amp;#xD;&#xd;&#xa;&amp;lt;/App_NameChangeRequest&amp;gt;&lt;/inputXml>&lt;commandArgs class=&quot;java.lang.String&quot;>-cs xpath:{/workflow/system/commCellName}&lt;/commandArgs>&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>false&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot;>xpath:{/workflow/Login_2/commandOutput}&lt;/token>&lt;/sessionOptions>&lt;/inputs>"/>

                        <transition activity="XPathQuery_3"

                            commented="0" originalStyle="" points=""

                            sourceX="95" sourceY="114" status="0"

                            style="defaultEdge" targetX="80"

                            targetY="154" transitionIndex="0" x="-24" y="-1">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity breakpoint="0" commented="0"

                        continueOnFailure="1" created="1379019625493"

                        description="retrieves a list of values from xml"

                        displayName="OutputParsing" height="34"

                        interactive="0" maxRestarts="0"

                        name="XPathQuery"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=XPathQuery"

                        uniqueName="XPathQuery_3" waitSetting="0"

                        width="125" x="15" y="147">

                        <inputs val="&lt;inputs>&lt;xml class=&quot;java.lang.String&quot;>xpath:{/workflow/Execute_3/outputXml}&lt;/xml>&lt;xpath class=&quot;java.lang.String&quot;>/App_NameChangeResponse/failedClientList/errorCode&lt;/xpath>&lt;outputType class=&quot;workflow.types.SimpleType&quot;>Integer&lt;/outputType>&lt;outputAsList class=&quot;java.lang.Boolean&quot;>false&lt;/outputAsList>&lt;/inputs>"/>

                        <transition activity="Decision_5" commented="0"

                            originalStyle="" points="" sourceX="77"

                            sourceY="164" status="0" style="defaultEdge"

                            targetX="76" targetY="202"

                            transitionIndex="0" x="-24" y="-1">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity breakpoint="0" commented="0"

                        continueOnFailure="1" created="1379506982842"

                        description="utility to add objects to a list"

                        displayName="AddToFailedList" height="34"

                        interactive="0" maxRestarts="0" name="AddToList"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=AddToList"

                        uniqueName="AddToList_8" waitSetting="0"

                        width="135" x="127" y="294">

                        <onEnter language="1" script="String s = workflow.getVariable(&quot;ReasonForFailure&quot;);&#xd;&#xa;s = s + &quot;- Reverting of Name Change Operation Failed, Please do the name change operation manually (From DR CS to Production CS) and check for readiness \n&quot;;&#xd;&#xa;workflow.setVariable(&quot;WorkflowStatus&quot;, &quot;Failed&quot;);&#xd;&#xa;workflow.setVariable(&quot;ReasonForFailure&quot;, s);&#xd;&#xa;&#xd;&#xa;&#xd;&#xa;"/>

                        <inputs val="&lt;inputs>&lt;addToList class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/NameChangeFail2}&lt;/addToList>&lt;itemToAdd class=&quot;java.lang.Object&quot;>xpath:{/workflow/ForEach_3/output}&lt;/itemToAdd>&lt;/inputs>"/>

                    </Activity>

                </superProcess>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1377805026993"

                description="iterates a group of activities over a list of values"

                displayName="CheckReadiness(OnProductionCS)"

                height="389" interactive="0" maxRestarts="0"

                name="ForEach"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0" style="swimlane"

                uniqueName="ForEach_4" waitSetting="0" width="274"

                x="778" y="35">

                <activitySchema>

                    <inputs>

                        <children className="java.lang.String"

                            inputType="java.lang.String" name="name" type="{http://www.w3.org/2001/XMLSchema}string"/>

                        <children className="java.lang.Object"

                            inputType="java.lang.Object" name="values" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                        <children className="java.lang.Integer"

                            defaultValue="1"

                            inputType="java.lang.Integer"

                            name="numberOfParallelExecutions" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                        <children className="java.lang.Boolean"

                            defaultValue="false"

                            inputType="java.lang.Boolean"

                            name="continueOnFailure" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                    </inputs>

                    <outputs name="outputs">

                        <children className="java.lang.Object"

                            inputType="java.lang.Object" listType="0"

                            name="output" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                    </outputs>

                </activitySchema>

                <onExit language="1" script="if(xpath:{/workflow/variables/WorkflowStatus}.equals(&quot;Successful&quot;)){&#xd;&#xa;    String emailBody = &quot;Manually check the restored data at the location: &quot; + xpath:{/workflow/inputs/destinationPath} + &quot; on client: &quot; + xpath:{/workflow/inputs/restoreClient};&#xd;&#xa;    workflow.setVariable(&quot;EmailBody&quot;, emailBody);&#xd;&#xa;}&#xd;&#xa;else if(xpath:{/workflow/variables/WorkflowStatus}.equals(&quot;Incomplete&quot;)){&#xd;&#xa;    String emailBody = &quot;Workflow has ended abnormally, Reverted the setup to original state. Please check the WorkflowEngine.log under Simpana Log Files folder for details.&quot;;&#xd;&#xa;    workflow.setVariable(&quot;EmailBody&quot;, emailBody);&#xd;&#xa;}"/>

                <inputs val="&lt;inputs>&lt;name class=&quot;java.lang.String&quot;>output&lt;/name>&lt;values class=&quot;java.lang.Object&quot;>xpath:{/workflow/Script_2/output}&lt;/values>&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot;>xpath:{/workflow/variables/noOfClients}&lt;/numberOfParallelExecutions>&lt;continueOnFailure class=&quot;java.lang.Boolean&quot;>true&lt;/continueOnFailure>&lt;/inputs>"/>

                <transition activity="Decision_16" commented="0"

                    originalStyle="" points="" sourceX="980"

                    sourceY="227" status="0" style="defaultEdge"

                    targetX="1174" targetY="194" transitionIndex="0"

                    x="335" y="5">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <superProcess>

                    <Start breakpoint="0" commented="0"

                        continueOnFailure="0" created="1377791413595"

                        description="" displayName="Start" height="30"

                        interactive="0" name="Start" originalStyle=""

                        skipAttempt="0"

                        style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                        uniqueName="Start_5" waitSetting="0" width="120"

                        x="5" y="25">

                        <inputs val="&lt;inputs />"/>

                        <transition activity="Delay_7" commented="0"

                            originalStyle="" points="" sourceX="65"

                            sourceY="40" status="0" style="defaultEdge"

                            targetX="55" targetY="97"

                            transitionIndex="0" x="0" y="0">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Start>

                    <Activity breakpoint="0" commented="0"

                        continueOnFailure="1" created="1377791354104"

                        description="" displayName="CheckReady"

                        height="34" interactive="0" maxRestarts="0"

                        name="CheckReady"

                        namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                        originalStyle="" skipAttempt="0"

                        style="label;image=CheckReady"

                        uniqueName="CheckReady_2" waitSetting="0"

                        width="188" x="7" y="141">

                        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/ForEach_4/output}&lt;/client>&lt;reportType class=&quot;workflow.types.cmd.ReportInformationType&quot; />&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>false&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot;>xpath:{/workflow/Login_2/commandOutput}&lt;/token>&lt;/sessionOptions>&lt;/inputs>"/>

                        <transition activity="Decision_6" commented="0"

                            originalStyle="" points="" sourceX="93"

                            sourceY="156" status="0" style="defaultEdge"

                            targetX="105" targetY="212"

                            transitionIndex="0" x="-11" y="-9">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity breakpoint="0" commented="0"

                        continueOnFailure="1" created="1366835388801"

                        description="if/else based decision"

                        displayName="ClientReady?" height="100"

                        interactive="0" maxRestarts="0" name="Decision"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="rhombus;fontStyle=1"

                        uniqueName="Decision_6" waitSetting="0"

                        width="120" x="8" y="209">

                        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/CheckReady_2/exitCode}==0&lt;/expression>&lt;/inputs>"/>

                        <transition activity="AddToList_4" commented="0"

                            displayName="Yes" originalStyle="" points=""

                            sourceX="2" sourceY="195" status="0"

                            style="defaultEdge" targetX="2"

                            targetY="342" transitionIndex="0"

                            value="true" x="-329" y="-3">

                            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                        <transition activity="AddToList_9" commented="0"

                            displayName="no" offsetX="4" offsetY="-19"

                            originalStyle="" points="201.0,239.0"

                            sourceX="67" sourceY="241" status="0"

                            style="defaultEdge" targetX="207"

                            targetY="313" transitionIndex="0"

                            value="false" x="0" y="0">

                            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity breakpoint="0" commented="0"

                        continueOnFailure="1" created="1366924520373"

                        description="utility to add objects to a list"

                        displayName="AddToSuccessList" height="34"

                        interactive="0" maxRestarts="0" name="AddToList"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=AddToList"

                        uniqueName="AddToList_4" waitSetting="0"

                        width="160" x="8" y="347">

                        <inputs val="&lt;inputs>&lt;addToList class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/CheckReadinessSuccess2}&lt;/addToList>&lt;itemToAdd class=&quot;java.lang.Object&quot;>xpath:{/workflow/ForEach_4/output}&lt;/itemToAdd>&lt;/inputs>"/>

                    </Activity>

                    <Activity breakpoint="0" commented="0"

                        continueOnFailure="1" created="1379507083234"

                        description="utility to add objects to a list"

                        displayName="AddToFailedList" height="34"

                        interactive="0" maxRestarts="0" name="AddToList"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=AddToList"

                        uniqueName="AddToList_9" waitSetting="0"

                        width="135" x="136" y="280">

                        <onEnter language="1" script="String s = workflow.getVariable(&quot;ReasonForFailure&quot;);&#xd;&#xa;s = s + &quot;- Check Readiness Operation is Failed (After Reverting the Name Change from DR CS to Production CS), Please check the readiness manually on Production CS \n&quot;;&#xd;&#xa;workflow.setVariable(&quot;WorkflowStatus&quot;, &quot;Failed&quot;);&#xd;&#xa;workflow.setVariable(&quot;ReasonForFailure&quot;, s);&#xd;&#xa;&#xd;&#xa;"/>

                        <inputs val="&lt;inputs>&lt;addToList class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/CheckReadinessFail2}&lt;/addToList>&lt;itemToAdd class=&quot;java.lang.Object&quot;>xpath:{/workflow/ForEach_4/output}&lt;/itemToAdd>&lt;/inputs>"/>

                    </Activity>

                    <Activity breakpoint="0" commented="0"

                        continueOnFailure="1" created="1384791205929"

                        description="activity to delay the workflow execution in minutes"

                        displayName="ReflectingChanges" height="34"

                        interactive="0" maxRestarts="0" name="Delay"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=Delay" uniqueName="Delay_7"

                        waitSetting="0" width="152" x="7" y="81">

                        <inputs val="&lt;inputs>&lt;delayLength class=&quot;java.lang.Integer&quot;>1&lt;/delayLength>&lt;delayInterval class=&quot;workflow.types.DelayInterval&quot;>Minutes&lt;/delayInterval>&lt;/inputs>"/>

                        <transition activity="CheckReady_2"

                            commented="0" originalStyle=""

                            points="69.0,126.25" sourceX="83"

                            sourceY="98" status="0" style="defaultEdge"

                            targetX="57" targetY="158"

                            transitionIndex="0" x="0" y="0">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                </superProcess>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1379098112570"

                description="activity to delay the workflow execution in minutes"

                displayName="ReflectingNameChange" height="34"

                interactive="0" maxRestarts="0" name="Delay"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Delay" uniqueName="Delay_4"

                waitSetting="0" width="199" x="258" y="452">

                <inputs val="&lt;inputs>&lt;delayLength class=&quot;java.lang.Integer&quot;>1&lt;/delayLength>&lt;delayInterval class=&quot;workflow.types.DelayInterval&quot;>Minutes&lt;/delayInterval>&lt;/inputs>"/>

                <transition activity="ExecuteScript_3" commented="0"

                    originalStyle="" points="536.25,261.25"

                    sourceX="360" sourceY="470" status="0"

                    style="defaultEdge" targetX="570" targetY="470"

                    transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1379694974612"

                description="if/else based decision"

                displayName="Successful?" height="100" interactive="0"

                maxRestarts="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_13"

                waitSetting="0" width="107" x="17" y="313">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/PSExec_2/errorCode}==0&lt;/expression>&lt;/inputs>"/>

                <transition activity="ForEach_3" commented="0"

                    displayName="yes" offsetX="-3" offsetY="31"

                    originalStyle="" points="168.0,359.66666666666674"

                    sourceX="-1053" sourceY="234" status="0"

                    style="defaultEdge" targetX="-922" targetY="25"

                    transitionIndex="0" value="true" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="Script_7" commented="0"

                    displayName="no" originalStyle="" points=""

                    sourceX="-1049" sourceY="315" status="0"

                    style="defaultEdge" targetX="-1050" targetY="430"

                    transitionIndex="0" value="false" x="-1120" y="90">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1379696482214"

                description="activity to execute code snippets in the selected language"

                displayName="RaiseError" height="34" interactive="0"

                maxRestarts="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Script" uniqueName="Script_7"

                waitSetting="0" width="100" x="24" y="465">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;String s = workflow.getVariable(&amp;quot;ReasonForFailure&amp;quot;);&amp;#xD;&amp;#xA;s = s + &amp;quot;- Services Failed to Stop on DRCS. Manually stop the services on DRCS and uncheck ?uto-start services when OS starts?option in Process Manager(Under Services Tab) \n&amp;quot;;&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;WorkflowStatus&amp;quot;, &amp;quot;Failed&amp;quot;);&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;ReasonForFailure&amp;quot;, s);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;&quot; />&lt;/inputs>"/>

                <transition activity="ForEach_3" commented="0"

                    originalStyle=""

                    points="166.66666666666663,402.33333333333326"

                    sourceX="73" sourceY="339" status="0"

                    style="defaultEdge" targetX="245" targetY="34"

                    transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1380228057146"

                description="if/else based decision"

                displayName="AnyFailure?" height="100" interactive="0"

                maxRestarts="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_16"

                waitSetting="0" width="108" x="1171" y="177">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/WorkflowStatus}.equals(&quot;Failed&quot;) &lt;/expression>&lt;/inputs>"/>

                <transition activity="Email_2" commented="0"

                    displayName="no" originalStyle="" points=""

                    sourceX="1225" sourceY="227" status="0"

                    style="defaultEdge" targetX="1223" targetY="333"

                    transitionIndex="0" value="false" x="335" y="5">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="Email_3" commented="0"

                    displayName="yes" originalStyle="" points=""

                    sourceX="1225" sourceY="227" status="0"

                    style="defaultEdge" targetX="1393" targetY="227"

                    transitionIndex="0" value="true" x="335" y="5">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1380228120188"

                description="Sends an email to a list of users"

                displayName="FailureEmail" height="34" interactive="0"

                maxRestarts="0" name="Email"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Email;fillColor=#FF0000;gradientColor=#FF0000"

                uniqueName="Email_3" waitSetting="0" width="112"

                x="1325" y="210">

                <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot;>&lt;to class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/EmailID}&lt;/to>&lt;cc class=&quot;java.lang.String&quot; />&lt;bcc class=&quot;java.lang.String&quot; />&lt;from class=&quot;java.lang.String&quot; />&lt;subject class=&quot;java.lang.String&quot;>DRWorkflow Status - xpath:{/workflow/variables/WorkflowStatus}&lt;/subject>&lt;body class=&quot;java.lang.String&quot;>&amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font size=&quot;5&quot;&amp;gt;DRWorkflow Status - &amp;lt;/font&amp;gt;&amp;lt;font color=&quot;#ff0000&quot; size=&quot;5&quot;&amp;gt;xpath:{/workflow/variables/WorkflowStatus}&amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &amp;lt;font size=&quot;5&quot;&amp;gt;Reason For Failure = &#xd;&#xa;      xpath:{/workflow/variables/ReasonForFailure}&amp;lt;/font&amp;gt;&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      Clients failed in Name change operation (Pointing of clients from &#xd;&#xa;      Production CS to DRCS) = xpath:{/workflow/variables/NameChangeFail1}&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      Clients failed in Check readiness operation (After Pointing of clients &#xd;&#xa;      from Production CS to DRCS)= &#xd;&#xa;      xpath:{/workflow/variables/CheckReadinessFail1}&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      Clients failed in Name change operation (Pointing back of clients from &#xd;&#xa;      DRCS to Production CS)= xpath:{/workflow/variables/NameChangeFail2}&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      Clients failed in Check readiness operation (Pointing back of clients &#xd;&#xa;      from DRCS to Production CS)= &#xd;&#xa;      xpath:{/workflow/variables/CheckReadinessFail2}&#xd;&#xa;    &amp;lt;/p&amp;gt;&lt;/body>&lt;attachments class=&quot;java.lang.Object&quot; />&lt;html class=&quot;java.lang.Boolean&quot;>true&lt;/html>&lt;/email>&lt;/inputs>"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1380901532936"

                description="Execute a command on a remote machine"

                displayName="StopServicesOnDRCS" height="34"

                interactive="0" maxRestarts="0" name="PSExec"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=PSExec" uniqueName="PSExec_2"

                waitSetting="0" width="173" x="3" y="194">

                <inputs val="&lt;inputs>&lt;hostName class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/DRCSName}&lt;/hostName>&lt;userName class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/DRCSComputerUsername}&lt;/userName>&lt;password class=&quot;workflow.types.EncryptedString&quot;>xpath:{/workflow/inputs/DRCSComputerPassword}&lt;/password>&lt;program class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/DRCSBasePath}\DRRestore.exe&lt;/program>&lt;arguments class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/dbDumpPath} cs StopServicesAndManual java:{xpath:{/workflow/inputs/DRCSSqlPassword_sa_user}.getPlainText()}&lt;/arguments>&lt;useImpersonation class=&quot;java.lang.Boolean&quot;>xpath:{/workflow/inputs/IsProdCSandDRCSonSameDomain}&lt;/useImpersonation>&lt;/inputs>"/>

                <transition activity="PSExec_8" commented="0"

                    originalStyle="" points="72.0,247.66666666666674"

                    sourceX="89" sourceY="211" status="0"

                    style="defaultEdge" targetX="58" targetY="283"

                    transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1383926149141" description=""

                displayName="EnableDDBMountPath" height="34"

                interactive="0" maxRestarts="0" name="ExecuteScript"

                namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                originalStyle="" skipAttempt="0"

                style="label;image=ExecuteScript"

                uniqueName="ExecuteScript_3" waitSetting="0" width="178"

                x="554" y="34">

                <inputs val="&lt;inputs>&lt;scriptName class=&quot;java.lang.String&quot;>QS_ToggleMountPathsofDDBMA.sql&lt;/scriptName>&lt;arguments class=&quot;java.lang.String&quot;>-si 1 -si xpath:{/workflow/variables/MAShortName}&lt;/arguments>&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>false&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot;>xpath:{/workflow/Login_2/commandOutput}&lt;/token>&lt;/sessionOptions>&lt;/inputs>"/>

                <transition activity="CommServDBQuery_2" commented="0"

                    originalStyle="" points="" sourceX="643"

                    sourceY="51" status="0" style="defaultEdge"

                    targetX="646" targetY="172" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1384381612427" description=""

                displayName="QLoginToProductionCS" height="34"

                interactive="0" maxRestarts="0" name="Login"

                namespaceUri="commvault.cte.workflow.activities.cmd"

                originalStyle="" skipAttempt="0"

                style="label;image=Login" uniqueName="Login_2"

                waitSetting="0" width="182" x="11" y="114">

                <inputs val="&lt;inputs>&lt;commCellName class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/ProductionCSName}&lt;/commCellName>&lt;commCellClientName class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/ProductionCSName}&lt;/commCellClientName>&lt;userName class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/ProductionCSUsername}&lt;/userName>&lt;password class=&quot;workflow.types.EncryptedString&quot;>xpath:{/workflow/inputs/ProductionCSPassword}&lt;/password>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;/inputs>"/>

                <transition activity="PSExec_2" commented="0"

                    originalStyle="" points="73.0,168.0" sourceX="102"

                    sourceY="131" status="0" style="defaultEdge"

                    targetX="63" targetY="216" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1384460668247"

                description="Execute a command on a remote machine"

                displayName="StartServicesOnMA" height="34"

                interactive="0" maxRestarts="0" name="PSExec"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=PSExec" uniqueName="PSExec_8"

                waitSetting="0" width="159" x="2" y="259">

                <inputs val="&lt;inputs>&lt;hostName class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/mediaAgent}&lt;/hostName>&lt;userName class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/MAComputerUserName}&lt;/userName>&lt;password class=&quot;workflow.types.EncryptedString&quot;>xpath:{/workflow/inputs/MAComputerPassword}&lt;/password>&lt;useImpersonation class=&quot;java.lang.Boolean&quot;>xpath:{/workflow/inputs/IsProdCSandMAonSameDomain}&lt;/useImpersonation>&lt;program class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/MABasePath}\DRRestore.exe&lt;/program>&lt;arguments class=&quot;java.lang.String&quot;>a b StartServices d&lt;/arguments>&lt;/inputs>"/>

                <transition activity="Decision_13" commented="0"

                    originalStyle="" points="" sourceX="81"

                    sourceY="276" status="0" style="defaultEdge"

                    targetX="62" targetY="330" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1384548587683"

                description="executes queries against the commserv database"

                displayName="EnableMediaAgent" height="34"

                interactive="0" maxRestarts="0" name="CommServDBQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=CommServDBQuery"

                uniqueName="CommServDBQuery_2" waitSetting="0"

                width="162" x="556" y="120">

                <inputs val="&lt;inputs>&lt;commCell>&lt;/commCell>&lt;query>update MMHost set MmHostEnabled = 1 where ClientId = (select id from APP_Client where name = ''xpath:{/workflow/variables/MAShortName}'')&lt;/query>&lt;/inputs>"/>

                <transition activity="PSExec_11" commented="0"

                    originalStyle="" points="" sourceX="637"

                    sourceY="137" status="0" style="defaultEdge"

                    targetX="637" targetY="230" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1384549330023"

                description="Execute a command on a remote machine"

                displayName="RestartServicesOnMA" height="34"

                interactive="0" maxRestarts="0" name="PSExec"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=PSExec" uniqueName="PSExec_11"

                waitSetting="0" width="174" x="557" y="213">

                <inputs val="&lt;inputs>&lt;hostName class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/mediaAgent}&lt;/hostName>&lt;userName class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/MAComputerUserName}&lt;/userName>&lt;password class=&quot;workflow.types.EncryptedString&quot;>xpath:{/workflow/inputs/MAComputerPassword}&lt;/password>&lt;useImpersonation class=&quot;java.lang.Boolean&quot;>xpath:{/workflow/inputs/IsProdCSandMAonSameDomain}&lt;/useImpersonation>&lt;program class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/MABasePath}\DRRestore.exe&lt;/program>&lt;arguments class=&quot;java.lang.String&quot;>a b RestartServices d&lt;/arguments>&lt;/inputs>"/>

                <transition activity="Decision_29" commented="0"

                    originalStyle="" points="" sourceX="644"

                    sourceY="230" status="0" style="defaultEdge"

                    targetX="638" targetY="308" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1384549549596"

                description="if/else based decision"

                displayName="Successful?" height="100" interactive="0"

                maxRestarts="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_29"

                waitSetting="0" width="107" x="585" y="295">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/PSExec_11/errorCode}==0&lt;/expression>&lt;/inputs>"/>

                <transition activity="Script_9" commented="0"

                    displayName="no" originalStyle="" points=""

                    sourceX="639" sourceY="345" status="0"

                    style="defaultEdge" targetX="642" targetY="448"

                    transitionIndex="0" value="false" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="ForEach_4" commented="0"

                    displayName="yes" originalStyle=""

                    points="741.25,343.75" sourceX="639" sourceY="345"

                    status="0" style="defaultEdge" targetX="796"

                    targetY="41" transitionIndex="0" value="true" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1384551874166"

                description="activity to execute code snippets in the selected language"

                displayName="RaiseError" height="34" interactive="0"

                maxRestarts="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Script" uniqueName="Script_9"

                waitSetting="0" width="100" x="589" y="452">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;String s = workflow.getVariable(&amp;quot;ReasonForFailure&amp;quot;);&amp;#xD;&amp;#xA;s = s + &amp;quot;Failed to restart the services on MA, Manually restart the services. \n&amp;quot;;&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;WorkflowStatus&amp;quot;, &amp;quot;Failed&amp;quot;);&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;ReasonForFailure&amp;quot;, s);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;&quot; />&lt;/inputs>"/>

                <transition activity="ForEach_4" commented="0"

                    originalStyle="" points="731.25,396.25"

                    sourceX="639" sourceY="469" status="0"

                    style="defaultEdge" targetX="820" targetY="42"

                    transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

        </superProcess>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1384383425721"

        description="creates a super process group"

        displayName="Intial Phase" height="764" interactive="0"

        maxRestarts="0" name="ProcessBlock"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ProcessBlock_1" waitSetting="0" width="214" x="64" y="15">

        <activitySchema>

            <inputs attribute="0" listType="0" name="inputs" required="1"/>

            <outputs attribute="0" listType="0" name="outputs" required="1"/>

        </activitySchema>

        <inputs val="&lt;inputs>&lt;inputs />&lt;/inputs>"/>

        <transition activity="ProcessBlock_2" commented="0"

            originalStyle=""

            points="286.8421052631579,360.5263157894737" sourceX="171"

            sourceY="153" status="0" style="defaultEdge" targetX="326"

            targetY="9" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <superProcess>

            <Start breakpoint="0" commented="0" continueOnFailure="0"

                created="1384383425721" description=""

                displayName="Start" height="30" interactive="0"

                name="Start" originalStyle="" skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_15" waitSetting="0" width="120" x="11" y="30">

                <inputs val="&lt;inputs />"/>

                <transition activity="PSExec_3" commented="0"

                    originalStyle="" points="" sourceX="71" sourceY="45"

                    status="0" style="defaultEdge" targetX="74"

                    targetY="88" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1377786255346"

                description="activity to execute code snippets in the selected language"

                displayName="ProcessingClientList" height="34"

                interactive="0" maxRestarts="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Script" uniqueName="Script_2"

                waitSetting="0" width="164" x="22" y="406">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    String clientlist = xpath:{/workflow/inputs/clientList};&amp;#xD;&amp;#xA;    String[] clients = clientlist.split(&amp;quot;,&amp;quot;);&amp;#xD;&amp;#xA;    int noOfClients = clients.length;&amp;#xD;&amp;#xA;    String[] outputList = new String[noOfClients+1];&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;noOfClients&amp;quot;, noOfClients);&amp;#xD;&amp;#xA;    for(int i=0;i&amp;lt;noOfClients;i++){&amp;#xD;&amp;#xA;        String sql = &amp;quot;select name from APP_Client where net_hostname = ''&amp;quot; + clients[i] + &amp;quot;''&amp;quot;;&amp;#xD;&amp;#xA;        DataSet rs = csdb.execute(sql);&amp;#xD;&amp;#xA;        while(rs.hasNext()) {&amp;#xD;&amp;#xA;           outputList[i] = rs.get(&amp;quot;name&amp;quot;);&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    outputList[noOfClients] = xpath:{/workflow/variables/MAShortName};&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;    for(int j=0;j&amp;lt;outputList.length;j++){&amp;#xD;&amp;#xA;        logger.info(&amp;quot;&amp;gt;&amp;gt; outputList for foreach loop: &amp;quot;+ outputList[j]);&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    return outputList;&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(Exception e )&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;&amp;gt;&amp;gt; &amp;quot;+&amp;quot;Failed to process the clientlist&amp;quot;);&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&quot; />&lt;/inputs>"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1383860900655"

                description="Execute a list of commands"

                displayName="GetMAInstallationPath" height="34"

                interactive="0" maxRestarts="0" name="ExecuteCommand"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=ExecuteCommand"

                uniqueName="ExecuteCommand_1" waitSetting="0"

                width="178" x="9" y="159">

                <onEnter language="1" script="try&#xd;&#xa;{&#xd;&#xa;    String basePath = xpath:{/workflow/PSExec_3/commandOutput};&#xd;&#xa;    String[] list = basePath.split(&quot;\n&quot;);&#xd;&#xa;    String[] list1 = list[2].split(&quot;    &quot;);&#xd;&#xa;    String drBasePath = list1[3].trim();&#xd;&#xa;    logger.info(&quot;>>drBasePath: &quot;+drBasePath);&#xd;&#xa;    workflow.setVariable(&quot;DRCSBasePath&quot;, drBasePath);&#xd;&#xa;}&#xd;&#xa;catch(Exception e )&#xd;&#xa;{&#xd;&#xa;    logger.info(&quot;>> &quot;+&quot;Failed to parse the output of DRInstallation path&quot;);&#xd;&#xa;}"/>

                <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/variables/MAShortName}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; />&lt;command class=&quot;java.lang.String&quot;>REG&lt;/command>&lt;arguments class=&quot;java.lang.String&quot;>QUERY &quot;HKLM\SOFTWARE\CommVault Systems\Galaxy\Instance001\Base&quot; /v dBASEHOME&lt;/arguments>&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

                <transition activity="Decision_26" commented="0"

                    originalStyle="" points="" sourceX="82"

                    sourceY="176" status="0" style="defaultEdge"

                    targetX="72" targetY="227" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1383860874024"

                description="Execute a command on a remote machine"

                displayName="GetDRCSInstallationPath" height="34"

                interactive="0" maxRestarts="0" name="PSExec"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=PSExec" uniqueName="PSExec_3"

                waitSetting="0" width="195" x="11" y="83">

                <inputs val="&lt;inputs>&lt;hostName class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/DRCSName}&lt;/hostName>&lt;userName class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/DRCSComputerUsername}&lt;/userName>&lt;password class=&quot;workflow.types.EncryptedString&quot;>xpath:{/workflow/inputs/DRCSComputerPassword}&lt;/password>&lt;useImpersonation class=&quot;java.lang.Boolean&quot;>xpath:{/workflow/inputs/IsProdCSandDRCSonSameDomain}&lt;/useImpersonation>&lt;program class=&quot;java.lang.String&quot;>REG&lt;/program>&lt;arguments class=&quot;java.lang.String&quot;>QUERY &quot;HKLM\SOFTWARE\CommVault Systems\CommVaultROMS&quot; /v INSTALLATIONDIRECTORY&lt;/arguments>&lt;/inputs>"/>

                <transition activity="ExecuteCommand_1" commented="0"

                    originalStyle="" points="73.125,136.95833333333334"

                    sourceX="109" sourceY="100" status="0"

                    style="defaultEdge" targetX="101" targetY="179"

                    transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1383929429674" description="Ends the workflow"

                displayName="FailWorkflow" height="34" interactive="0"

                maxRestarts="0" name="WorkflowEnd"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=WorkflowEnd;gradientColor=#FF0000;fillColor=#FF0000"

                uniqueName="WorkflowEnd_10" waitSetting="0" width="119"

                x="47" y="681">

                <onEnter language="1" script="String s = workflow.getVariable(&quot;ReasonForFailure&quot;);&#xd;&#xa;s = s +&quot;Failed to get the Installation path of On DR CS or MA \n&quot;;&#xd;&#xa;workflow.setVariable(&quot;WorkflowStatus&quot;, &quot;Failed&quot;);&#xd;&#xa;workflow.setVariable(&quot;ReasonForFailure&quot;, s);"/>

                <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot;>FAILED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot;>Failed to get the Installation path of On DR CS or MA&lt;/failureMessage>&lt;/inputs>"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1384386320323"

                description="if/else based decision"

                displayName="Successful?" height="100" interactive="0"

                name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_26"

                waitSetting="0" width="107" x="24" y="223">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>(xpath:{/workflow/PSExec_3/errorCode}==0) &amp;amp;&amp;amp; (xpath:{/workflow/ExecuteCommand_1/errorCode}==0)&lt;/expression>&lt;/inputs>"/>

                <transition activity="Script_2" commented="0"

                    displayName="yes" originalStyle="" points=""

                    sourceX="74" sourceY="273" status="0"

                    style="defaultEdge" targetX="79" targetY="439"

                    transitionIndex="0" value="true" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="WorkflowEnd_10" commented="0"

                    displayName="no" originalStyle=""

                    points="17.578947368421055,435.7368421052632"

                    sourceX="74" sourceY="273" status="0"

                    style="defaultEdge" targetX="34" targetY="568"

                    transitionIndex="0" value="false" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

        </superProcess>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1384383904756"

        description="creates a super process group"

        displayName="MA Operations" height="762" interactive="0"

        maxRestarts="0" name="ProcessBlock"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ProcessBlock_2" waitSetting="0" width="422" x="299" y="15">

        <activitySchema>

            <inputs attribute="0" listType="0" name="inputs" required="1"/>

            <outputs attribute="0" listType="0" name="outputs" required="1"/>

        </activitySchema>

        <inputs val="&lt;inputs>&lt;inputs />&lt;/inputs>"/>

        <transition activity="ProcessBlock_3" commented="0"

            originalStyle=""

            points="740.7894736842105,364.4736842105263" sourceX="510"

            sourceY="284" status="0" style="defaultEdge" targetX="803"

            targetY="13" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <superProcess>

            <Start breakpoint="0" commented="0" continueOnFailure="0"

                created="1384383904756" description=""

                displayName="Start" height="30" interactive="0"

                name="Start" originalStyle="" skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_16" waitSetting="0" width="120" x="20" y="27">

                <inputs val="&lt;inputs />"/>

                <transition activity="ExecuteScript_2" commented="0"

                    originalStyle=""

                    points="70.2222222222222,94.22222222222223"

                    sourceX="80" sourceY="42" status="0"

                    style="defaultEdge" targetX="81" targetY="167"

                    transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1383860988934" description=""

                displayName="DisableDDBMountPath" height="34"

                interactive="0" maxRestarts="0" name="ExecuteScript"

                namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                originalStyle="" skipAttempt="0"

                style="label;image=ExecuteScript"

                uniqueName="ExecuteScript_2" waitSetting="0" width="178"

                x="19" y="135">

                <onEnter language="1" script="String basePath = xpath:{/workflow/ExecuteCommand_1/commandOutput};&#xd;&#xa;String[] list = basePath.split(&quot;\n&quot;);&#xd;&#xa;String[] list1 = list[2].split(&quot;    &quot;);&#xd;&#xa;String MABasePath = list1[3].trim();&#xd;&#xa;workflow.setVariable(&quot;MABasePath&quot;, MABasePath);"/>

                <inputs val="&lt;inputs>&lt;scriptName class=&quot;java.lang.String&quot;>QS_ToggleMountPathsofDDBMA.sql&lt;/scriptName>&lt;arguments class=&quot;java.lang.String&quot;>-si 0 -si xpath:{/workflow/variables/MAShortName}&lt;/arguments>&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

                <transition activity="Decision_23" commented="0"

                    originalStyle="" points="" sourceX="108"

                    sourceY="152" status="0" style="defaultEdge"

                    targetX="115" targetY="239" transitionIndex="0"

                    x="-278" y="125">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1383928889909"

                description="if/else based decision"

                displayName="Successful?" height="100" interactive="0"

                maxRestarts="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_20"

                waitSetting="0" width="107" x="242" y="226">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/PSExec_5/errorCode}==0&lt;/expression>&lt;/inputs>"/>

                <transition activity="PSExec_4" commented="0"

                    displayName="yes" offsetX="0" offsetY="-11"

                    originalStyle="" points="295.375,412.5625"

                    sourceX="-225" sourceY="731" status="0"

                    style="defaultEdge" targetX="-235" targetY="831"

                    transitionIndex="0" value="true" x="-274" y="227">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="WorkflowEnd_9" commented="0"

                    displayName="no" offsetX="8" offsetY="-119"

                    originalStyle="" points="407.25,444.4375"

                    sourceX="247" sourceY="407" status="0"

                    style="defaultEdge" targetX="257" targetY="607"

                    transitionIndex="0" value="false" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1384200920351"

                description="Execute a command on a remote machine"

                displayName="WaitForSIDBtoGoDown" height="34"

                interactive="0" maxRestarts="0" name="PSExec"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=PSExec" uniqueName="PSExec_4"

                waitSetting="0" width="186" x="210" y="426">

                <inputs val="&lt;inputs>&lt;hostName class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/mediaAgent}&lt;/hostName>&lt;userName class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/MAComputerUserName}&lt;/userName>&lt;password class=&quot;workflow.types.EncryptedString&quot;>xpath:{/workflow/inputs/MAComputerPassword}&lt;/password>&lt;useImpersonation class=&quot;java.lang.Boolean&quot;>xpath:{/workflow/inputs/IsProdCSandMAonSameDomain}&lt;/useImpersonation>&lt;program class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/MABasePath}\DRRestore.exe&lt;/program>&lt;arguments class=&quot;java.lang.String&quot;>a b CheckForSIDB2 d&lt;/arguments>&lt;/inputs>"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1384201375562"

                description="Execute a command on a remote machine"

                displayName="StopServicesOnMA" height="34"

                interactive="0" maxRestarts="0" name="PSExec"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=PSExec" uniqueName="PSExec_5"

                waitSetting="0" width="156" x="220" y="133">

                <inputs val="&lt;inputs>&lt;hostName class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/mediaAgent}&lt;/hostName>&lt;userName class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/MAComputerUserName}&lt;/userName>&lt;password class=&quot;workflow.types.EncryptedString&quot;>xpath:{/workflow/inputs/MAComputerPassword}&lt;/password>&lt;useImpersonation class=&quot;java.lang.Boolean&quot;>xpath:{/workflow/inputs/IsProdCSandMAonSameDomain}&lt;/useImpersonation>&lt;program class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/MABasePath}\DRRestore.exe&lt;/program>&lt;arguments class=&quot;java.lang.String&quot;>a b StopServices d&lt;/arguments>&lt;/inputs>"/>

                <transition activity="Decision_20" commented="0"

                    originalStyle="" points="" sourceX="250"

                    sourceY="399" status="0" style="defaultEdge"

                    targetX="250" targetY="479" transitionIndex="0"

                    x="90" y="-78">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1384362203765"

                description="if/else based decision"

                displayName="Successful?" height="100" interactive="0"

                maxRestarts="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_23"

                waitSetting="0" width="107" x="17" y="225">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/ExecuteScript_2/exitCode}==0&lt;/expression>&lt;/inputs>"/>

                <transition activity="CommServDBQuery_1" commented="0"

                    displayName="yes" offsetX="-2" offsetY="27"

                    originalStyle="" points="208.5,161.25" sourceX="111"

                    sourceY="282" status="0" style="defaultEdge"

                    targetX="317" targetY="303" transitionIndex="0"

                    value="true" x="-278" y="125">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="WorkflowEnd_13" commented="0"

                    displayName="no" originalStyle="" points=""

                    sourceX="67" sourceY="275" status="0"

                    style="defaultEdge" targetX="56" targetY="710"

                    transitionIndex="0" value="false" x="-321" y="118">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1383929410671" description="Ends the workflow"

                displayName="FailWorkflow" height="34" interactive="0"

                maxRestarts="0" name="WorkflowEnd"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=WorkflowEnd;gradientColor=#FF0000;fillColor=#FF0000"

                uniqueName="WorkflowEnd_9" waitSetting="0" width="119"

                x="230" y="677">

                <onEnter language="1" script="String s = workflow.getVariable(&quot;ReasonForFailure&quot;);&#xd;&#xa;s = s + &quot;Failed to stop the services on Media Agent \n&quot;;&#xd;&#xa;workflow.setVariable(&quot;WorkflowStatus&quot;, &quot;Failed&quot;);&#xd;&#xa;workflow.setVariable(&quot;ReasonForFailure&quot;, s);"/>

                <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot;>FAILED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot;>Failed to stop the services on Media Agent&lt;/failureMessage>&lt;/inputs>"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1384362313919" description="Ends the workflow"

                displayName="FailWorkflow" height="34" interactive="0"

                maxRestarts="0" name="WorkflowEnd"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=WorkflowEnd;gradientColor=#FF0000;fillColor=#FF0000"

                uniqueName="WorkflowEnd_13" waitSetting="0" width="119"

                x="19" y="681">

                <onEnter language="1" script="String s = workflow.getVariable(&quot;ReasonForFailure&quot;);&#xd;&#xa;s = s +&quot;Failed to disable the ddb mountpath of MA \n&quot;;&#xd;&#xa;workflow.setVariable(&quot;WorkflowStatus&quot;, &quot;Failed&quot;);&#xd;&#xa;workflow.setVariable(&quot;ReasonForFailure&quot;, s);"/>

                <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot;>FAILED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot;>Failed to disable the ddb mountpath of MA&lt;/failureMessage>&lt;/inputs>"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1384546778508"

                description="executes queries against the commserv database"

                displayName="DisableMediaAgent" height="34"

                interactive="0" maxRestarts="0" name="CommServDBQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=CommServDBQuery"

                uniqueName="CommServDBQuery_1" waitSetting="0"

                width="162" x="221" y="32">

                <inputs val="&lt;inputs>&lt;commCell>&lt;/commCell>&lt;query>update MMHost set MmHostEnabled = 0 where ClientId = (select id from APP_Client where name = ''xpath:{/workflow/variables/MAShortName}'')&lt;/query>&lt;/inputs>"/>

                <transition activity="PSExec_5" commented="0"

                    originalStyle="" points="" sourceX="302"

                    sourceY="49" status="0" style="defaultEdge"

                    targetX="302" targetY="150" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

        </superProcess>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1384384264786"

        description="creates a super process group"

        displayName="DRBackUpPhase" height="759" interactive="0"

        maxRestarts="0" name="ProcessBlock"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ProcessBlock_3" waitSetting="0" width="247" x="754" y="16">

        <activitySchema>

            <inputs attribute="0" listType="0" name="inputs" required="1"/>

            <outputs attribute="0" listType="0" name="outputs" required="1"/>

        </activitySchema>

        <inputs val="&lt;inputs>&lt;inputs />&lt;/inputs>"/>

        <transition activity="ProcessBlock_4" commented="0"

            originalStyle=""

            points="1015.7894736842105,364.4736842105263" sourceX="876"

            sourceY="253" status="0" style="defaultEdge" targetX="1160"

            targetY="26" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <superProcess>

            <Start breakpoint="0" commented="0" continueOnFailure="0"

                created="1384384264786" description=""

                displayName="Start" height="30" interactive="0"

                name="Start" originalStyle="" skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_17" waitSetting="0" width="120" x="49" y="30">

                <inputs val="&lt;inputs />"/>

                <transition activity="DRBackup_1" commented="0"

                    originalStyle="" points="" sourceX="78" sourceY="44"

                    status="0" style="defaultEdge" targetX="67"

                    targetY="104" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1383861873875" description=""

                displayName="DRBackUpToDRMachine" height="34"

                interactive="0" maxRestarts="0" name="DRBackup"

                namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                originalStyle="" skipAttempt="0"

                style="label;image=DRBackup" uniqueName="DRBackup_1"

                waitSetting="0" width="188" x="19" y="76">

                <inputs val="&lt;inputs>&lt;type class=&quot;workflow.types.cmd.DRType&quot;>Q_FULL&lt;/type>&lt;argumentFilepath class=&quot;java.lang.String&quot; />&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

                <transition activity="WaitForJobCompletion_2"

                    commented="0" originalStyle="" points=""

                    sourceX="118" sourceY="93" status="0"

                    style="defaultEdge" targetX="108" targetY="163"

                    transitionIndex="0" x="-301" y="14">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1383929180694"

                description="waits until the list of jobs completes"

                displayName="WaitForDRBackupToComplete" height="34"

                interactive="0" maxRestarts="0"

                name="WaitForJobCompletion"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=WaitForJobCompletion"

                uniqueName="WaitForJobCompletion_2" waitSetting="0"

                width="200" x="16" y="145">

                <inputs val="&lt;inputs>&lt;jobId class=&quot;java.lang.Integer&quot; _list_=&quot;true&quot;>xpath:{/workflow/DRBackup_1/jobId}&lt;/jobId>&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

                <transition activity="Decision_21" commented="0"

                    originalStyle="" points="" sourceX="108"

                    sourceY="163" status="0" style="defaultEdge"

                    targetX="108" targetY="233" transitionIndex="0"

                    x="-301" y="14">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1384285130757"

                description="if/else based decision"

                displayName="Successful?" height="100" interactive="0"

                maxRestarts="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_21"

                waitSetting="0" width="107" x="58" y="213">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/WaitForJobCompletion_2/successful}==true&lt;/expression>&lt;/inputs>"/>

                <transition activity="PSExec_7" commented="0"

                    displayName="yes" originalStyle="" points=""

                    sourceX="111" sourceY="263" status="0"

                    style="defaultEdge" targetX="111" targetY="370"

                    transitionIndex="0" value="true" x="-301" y="14">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="WorkflowEnd_11" commented="0"

                    displayName="no" offsetX="-32" offsetY="-6"

                    originalStyle=""

                    points="34.172413793103395,263.83908045977006"

                    sourceX="-396" sourceY="274" status="0"

                    style="defaultEdge" targetX="-436" targetY="644"

                    transitionIndex="0" value="false" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1384285203386"

                description="Execute a command on a remote machine"

                displayName="GetLatestDRBackupFile" height="34"

                interactive="0" maxRestarts="0" name="PSExec"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=PSExec" uniqueName="PSExec_7"

                waitSetting="0" width="185" x="53" y="372">

                <inputs val="&lt;inputs>&lt;hostName class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/DRCSName}&lt;/hostName>&lt;userName class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/DRCSComputerUsername}&lt;/userName>&lt;password class=&quot;workflow.types.EncryptedString&quot;>xpath:{/workflow/inputs/DRCSComputerPassword}&lt;/password>&lt;program class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/DRCSBasePath}\DRRestore.exe&lt;/program>&lt;arguments class=&quot;java.lang.String&quot;>a cs xpath:{/workflow/inputs/dbDumpPath} java:{xpath:{/workflow/inputs/DRCSSqlPassword_sa_user}.getPlainText()}&lt;/arguments>&lt;useImpersonation class=&quot;java.lang.Boolean&quot;>xpath:{/workflow/inputs/IsProdCSandDRCSonSameDomain}&lt;/useImpersonation>&lt;/inputs>"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1384285554214" description="Ends the workflow"

                displayName="FailWorkflow" height="34" interactive="0"

                maxRestarts="0" name="WorkflowEnd"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=WorkflowEnd;gradientColor=#FF0000;fillColor=#FF0000"

                uniqueName="WorkflowEnd_11" waitSetting="0" width="119"

                x="81" y="675">

                <onEnter language="1" script="String s = workflow.getVariable(&quot;ReasonForFailure&quot;);&#xd;&#xa;s = s + &quot;DRBackup has Failed \n&quot;;&#xd;&#xa;workflow.setVariable(&quot;WorkflowStatus&quot;, &quot;Failed&quot;);&#xd;&#xa;workflow.setVariable(&quot;ReasonForFailure&quot;, s);"/>

                <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot;>FAILED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot;>DRBackup has Failed&lt;/failureMessage>&lt;/inputs>"/>

            </Activity>

        </superProcess>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1384385621058"

        description="creates a super process group"

        displayName="DRTestingPhase" height="758" interactive="0"

        maxRestarts="0" name="ProcessBlock"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ProcessBlock_4" waitSetting="0" width="1702"

        x="1037" y="17">

        <activitySchema>

            <inputs attribute="0" listType="0" name="inputs" required="1"/>

            <outputs attribute="0" listType="0" name="outputs" required="1"/>

        </activitySchema>

        <inputs val="&lt;inputs>&lt;inputs />&lt;/inputs>"/>

        <superProcess>

            <Start breakpoint="0" commented="0" continueOnFailure="0"

                created="1384385621058" description=""

                displayName="Start" height="30" interactive="0"

                name="Start" originalStyle="" skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_18" waitSetting="0" width="120"

                x="102" y="38">

                <inputs val="&lt;inputs />"/>

                <transition activity="PSExec_1" commented="0"

                    originalStyle=""

                    points="163.18713450292375,118.61988304093566"

                    sourceX="142" sourceY="67" status="0"

                    style="defaultEdge" targetX="156" targetY="165"

                    transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1377802600253" description=""

                displayName="LoginToDRCS" height="34" interactive="0"

                maxRestarts="0" name="Login"

                namespaceUri="commvault.cte.workflow.activities.cmd"

                originalStyle="" skipAttempt="0"

                style="label;image=Login" uniqueName="Login_1"

                waitSetting="0" width="119" x="99" y="456">

                <inputs val="&lt;inputs>&lt;commCellName class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/DRCSName}&lt;/commCellName>&lt;commCellClientName class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/DRCSName}&lt;/commCellClientName>&lt;userName class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/ProductionCSUsername}&lt;/userName>&lt;password class=&quot;workflow.types.EncryptedString&quot;>xpath:{/workflow/inputs/ProductionCSPassword}&lt;/password>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;/inputs>"/>

                <transition activity="Decision_17" commented="0"

                    originalStyle="" points="" sourceX="155"

                    sourceY="475" status="0" style="defaultEdge"

                    targetX="154" targetY="550" transitionIndex="0"

                    x="17" y="137">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1377540162739" description=""

                displayName="TestRestore" height="34" interactive="0"

                maxRestarts="0" name="Execute"

                namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                originalStyle="" skipAttempt="0"

                style="label;image=Execute" uniqueName="Execute_1"

                waitSetting="0" width="159" x="1367" y="98">

                <inputs val="&lt;inputs>&lt;inputXml class=&quot;java.lang.String&quot;>&amp;lt;?xml version=&quot;1.0&quot; encoding=&quot;UTF-8&quot; standalone=&quot;no&quot; ?&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;TMMsg_CreateTaskReq&amp;gt;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;  &amp;lt;taskInfo&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;associations&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;appName&amp;gt;File System&amp;lt;/appName&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;backupsetName&amp;gt;defaultBackupSet&amp;lt;/backupsetName&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;clientName&amp;gt;xpath:{/workflow/variables/SourceClientShortName}&amp;lt;/clientName&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;instanceName&amp;gt;DefaultInstanceName&amp;lt;/instanceName&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;subclientName&amp;gt;xpath:{/workflow/inputs/SubClientName}&amp;lt;/subclientName&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/associations&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;subTasks&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;options&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;restoreOptions&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;browseOption&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;backupset&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;backupsetName&amp;gt;defaultBackupSet&amp;lt;/backupsetName&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;clientName&amp;gt;xpath:{/workflow/variables/SourceClientShortName}&amp;lt;/clientName&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;/backupset&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;commCellId&amp;gt;2&amp;lt;/commCellId&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;listMedia&amp;gt;false&amp;lt;/listMedia&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;mediaOption&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;copyPrecedence&amp;gt;&amp;#xD;&#xd;&#xa;                &amp;lt;copyPrecedence&amp;gt;xpath:{/workflow/inputs/CopyPrecedenceNumber}&amp;lt;/copyPrecedence&amp;gt;&amp;#xD;&#xd;&#xa;                &amp;lt;copyPrecedenceApplicable&amp;gt;true&amp;lt;/copyPrecedenceApplicable&amp;gt;&amp;#xD;&#xd;&#xa;                &amp;lt;copyPrecedenceType&amp;gt;SYNCHRONOUS&amp;lt;/copyPrecedenceType&amp;gt;&amp;#xD;&#xd;&#xa;                &amp;lt;synchronousCopyPrecedence&amp;gt;xpath:{/workflow/inputs/CopyPrecedenceNumber}&amp;lt;/synchronousCopyPrecedence&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;/copyPrecedence&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;drivePool/&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;library/&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;mediaAgent/&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;/mediaOption&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;noImage&amp;gt;false&amp;lt;/noImage&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;timeRange/&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;timeZone&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;TimeZoneName&amp;gt;(UTC-05:00) Eastern Time (US &amp;amp;amp; Canada)&amp;lt;/TimeZoneName&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;/timeZone&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;useExactIndex&amp;gt;false&amp;lt;/useExactIndex&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;/browseOption&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;commonOptions&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;clusterDBBackedup&amp;gt;false&amp;lt;/clusterDBBackedup&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;clusterDbBackupType&amp;gt;ER_NON_AUTHORITATIVE&amp;lt;/clusterDbBackupType&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;detectRegularExpression&amp;gt;true&amp;lt;/detectRegularExpression&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;doNotOverwriteFileOnDisk&amp;gt;false&amp;lt;/doNotOverwriteFileOnDisk&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;isFromBrowseBackup&amp;gt;true&amp;lt;/isFromBrowseBackup&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;offlineMiningRestore&amp;gt;false&amp;lt;/offlineMiningRestore&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;onePassRestore&amp;gt;false&amp;lt;/onePassRestore&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;overwriteFiles&amp;gt;true&amp;lt;/overwriteFiles&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;powerRestore&amp;gt;false&amp;lt;/powerRestore&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;preserveLevel&amp;gt;1&amp;lt;/preserveLevel&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;recreateMountPoints&amp;gt;true&amp;lt;/recreateMountPoints&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;restoreOnlyStubExists&amp;gt;false&amp;lt;/restoreOnlyStubExists&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;restoreToDisk&amp;gt;false&amp;lt;/restoreToDisk&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;stripLevel&amp;gt;2&amp;lt;/stripLevel&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;stripLevelType&amp;gt;PRESERVE_LEVEL&amp;lt;/stripLevelType&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;systemStateBackup&amp;gt;false&amp;lt;/systemStateBackup&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;unconditionalOverwrite&amp;gt;false&amp;lt;/unconditionalOverwrite&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;wildCard&amp;gt;false&amp;lt;/wildCard&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;/commonOptions&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;destination&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;destClient&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;clientName&amp;gt;xpath:{/workflow/variables/RestoreClientShortName}&amp;lt;/clientName&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;/destClient&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;destPath&amp;gt;xpath:{/workflow/inputs/destinationPath}&amp;lt;/destPath&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;inPlace&amp;gt;false&amp;lt;/inPlace&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;isLegalHold&amp;gt;false&amp;lt;/isLegalHold&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;restoreOnlyIfTargetExists&amp;gt;false&amp;lt;/restoreOnlyIfTargetExists&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;/destination&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;fileOption&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;browseFilters&amp;gt;&amp;amp;lt;?xml version=''1.0'' encoding=''UTF-8''?&amp;amp;gt;&amp;amp;lt;databrowse_Query type=&quot;0&quot; queryId=&quot;0&quot;&amp;amp;gt;&amp;amp;lt;dataParam&amp;amp;gt;&amp;amp;lt;paging firstNode=&quot;0&quot; skipNode=&quot;0&quot; pageSize=&quot;100&quot; /&amp;amp;gt;&amp;amp;lt;/dataParam&amp;amp;gt;&amp;amp;lt;/databrowse_Query&amp;amp;gt;&amp;lt;/browseFilters&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;sourceItem&amp;gt;xpath:{/workflow/inputs/sourcePath}&amp;lt;/sourceItem&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;/fileOption&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;impersonation&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;useImpersonation&amp;gt;false&amp;lt;/useImpersonation&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;user&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;userName&amp;gt;&amp;lt;/userName&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;/user&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;/impersonation&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;!--Restore Access Control Type--&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;restoreACLsType&amp;gt;ACL_DATA&amp;lt;/restoreACLsType&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;sharePointRstOption&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;is90OrUpgradedClient&amp;gt;false&amp;lt;/is90OrUpgradedClient&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;/sharePointRstOption&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;virtualServerRstOption&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;isDiskBrowse&amp;gt;false&amp;lt;/isDiskBrowse&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;viewType&amp;gt;DEFAULT&amp;lt;/viewType&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;/virtualServerRstOption&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;/restoreOptions&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/options&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;subTask&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;operationType&amp;gt;RESTORE&amp;lt;/operationType&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;subTaskType&amp;gt;RESTORE&amp;lt;/subTaskType&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/subTask&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/subTasks&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;task&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;initiatedFrom&amp;gt;COMMANDLINE&amp;lt;/initiatedFrom&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;policyType&amp;gt;DATA_PROTECTION&amp;lt;/policyType&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;taskFlags&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;disabled&amp;gt;false&amp;lt;/disabled&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/taskFlags&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;taskType&amp;gt;IMMEDIATE&amp;lt;/taskType&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/task&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;/taskInfo&amp;gt;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&amp;lt;/TMMsg_CreateTaskReq&amp;gt;&amp;#xD;&#xd;&#xa;&lt;/inputXml>&lt;commandArgs class=&quot;java.lang.String&quot;>-cs xpath:{/workflow/inputs/DRCSName}&lt;/commandArgs>&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>false&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot;>xpath:{/workflow/Login_1/commandOutput}&lt;/token>&lt;/sessionOptions>&lt;/inputs>"/>

                <transition activity="XPathQuery_4" commented="0"

                    originalStyle="" points="" sourceX="1444"

                    sourceY="60" status="0" style="defaultEdge"

                    targetX="1444" targetY="139" transitionIndex="0"

                    x="512" y="30">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1379104107277"

                description="waits until the list of jobs completes"

                displayName="WaitForRestoreJob" height="34"

                interactive="0" maxRestarts="0"

                name="WaitForJobCompletion"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=WaitForJobCompletion"

                uniqueName="WaitForJobCompletion_1" waitSetting="0"

                width="180" x="1355" y="249">

                <inputs val="&lt;inputs>&lt;jobId class=&quot;java.lang.Integer&quot; _list_=&quot;true&quot;>xpath:{/workflow/XPathQuery_4/result}&lt;/jobId>&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>false&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot;>xpath:{/workflow/Login_1/commandOutput}&lt;/token>&lt;/sessionOptions>&lt;/inputs>"/>

                <transition activity="Decision_9" commented="0"

                    originalStyle="" points="" sourceX="1448"

                    sourceY="206" status="0" style="defaultEdge"

                    targetX="1455" targetY="250" transitionIndex="0"

                    x="512" y="30">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1379104232612"

                description="retrieves a list of values from xml"

                displayName="GettingTheJobID" height="34"

                interactive="0" maxRestarts="0" name="XPathQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=XPathQuery" uniqueName="XPathQuery_4"

                waitSetting="0" width="176" x="1361" y="172">

                <inputs val="&lt;inputs>&lt;xml class=&quot;java.lang.String&quot;>xpath:{/workflow/Execute_1/outputXml}&lt;/xml>&lt;xpath class=&quot;java.lang.String&quot;>/TMMsg_CreateTaskResp/jobIds/@val&lt;/xpath>&lt;outputType class=&quot;workflow.types.SimpleType&quot;>Integer&lt;/outputType>&lt;outputAsList class=&quot;java.lang.Boolean&quot;>false&lt;/outputAsList>&lt;/inputs>"/>

                <transition activity="WaitForJobCompletion_1"

                    commented="0" originalStyle="" points=""

                    sourceX="1451" sourceY="149" status="0"

                    style="defaultEdge" targetX="1446" targetY="261"

                    transitionIndex="0" x="512" y="30">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1379353676109"

                description="if/else based decision"

                displayName="Successful?" height="100" interactive="0"

                maxRestarts="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_9"

                waitSetting="0" width="107" x="1390" y="313">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/WaitForJobCompletion_1/successful}==true&lt;/expression>&lt;/inputs>"/>

                <transition activity="AddToList_7" commented="0"

                    displayName="no" originalStyle="" points=""

                    sourceX="1429" sourceY="295" status="0"

                    style="defaultEdge" targetX="1424" targetY="412"

                    transitionIndex="0" value="false" x="445" y="29">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="WorkflowEnd_4" commented="0"

                    displayName="yes" originalStyle="" points=""

                    sourceX="1429" sourceY="295" status="0"

                    style="defaultEdge" targetX="1585" targetY="294"

                    transitionIndex="0" value="true" x="445" y="29">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1377791413595"

                description="iterates a group of activities over a list of values"

                displayName="ClientNameChange(ProductionToDRCS)"

                height="410" interactive="0" maxRestarts="0"

                name="ForEach"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0" style="swimlane"

                uniqueName="ForEach_1" waitSetting="0" width="300"

                x="824" y="37">

                <activitySchema>

                    <inputs>

                        <children className="java.lang.String"

                            inputType="java.lang.String" name="name" type="{http://www.w3.org/2001/XMLSchema}string"/>

                        <children className="java.lang.Object"

                            inputType="java.lang.Object" name="values" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                        <children className="java.lang.Integer"

                            defaultValue="1"

                            inputType="java.lang.Integer"

                            name="numberOfParallelExecutions" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                        <children className="java.lang.Boolean"

                            defaultValue="false"

                            inputType="java.lang.Boolean"

                            name="continueOnFailure" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                    </inputs>

                    <outputs name="outputs">

                        <children className="java.lang.Object"

                            inputType="java.lang.Object" listType="0"

                            name="output" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                    </outputs>

                </activitySchema>

                <inputs val="&lt;inputs>&lt;name class=&quot;java.lang.String&quot;>output&lt;/name>&lt;values class=&quot;java.lang.Object&quot;>xpath:{/workflow/Script_2/output}&lt;/values>&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot;>xpath:{/workflow/variables/noOfClients}&lt;/numberOfParallelExecutions>&lt;continueOnFailure class=&quot;java.lang.Boolean&quot;>true&lt;/continueOnFailure>&lt;/inputs>"/>

                <transition activity="Delay_5" commented="0"

                    originalStyle=""

                    points="969.4835353879608,475.5489015477332"

                    sourceX="964" sourceY="238" status="0"

                    style="defaultEdge" targetX="896" targetY="505"

                    transitionIndex="0" x="575" y="-41">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <superProcess>

                    <Start breakpoint="0" commented="0"

                        continueOnFailure="0" created="1377791413595"

                        description="" displayName="Start" height="30"

                        interactive="0" name="Start" originalStyle=""

                        skipAttempt="0"

                        style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                        uniqueName="Start_2" waitSetting="0" width="120"

                        x="15" y="27">

                        <inputs val="&lt;inputs />"/>

                        <transition activity="Execute_2" commented="0"

                            originalStyle="" points="" sourceX="73"

                            sourceY="41" status="0" style="defaultEdge"

                            targetX="71" targetY="121"

                            transitionIndex="0" x="-38" y="-8">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Start>

                    <Activity breakpoint="0" commented="0"

                        continueOnFailure="1" created="1366924520373"

                        description="utility to add objects to a list"

                        displayName="AddToSuccessList" height="34"

                        interactive="0" maxRestarts="0" name="AddToList"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=AddToList"

                        uniqueName="AddToList_1" waitSetting="0"

                        width="160" x="8" y="357">

                        <inputs val="&lt;inputs>&lt;addToList class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/NameChangeSuccess1}&lt;/addToList>&lt;itemToAdd class=&quot;java.lang.Object&quot;>xpath:{/workflow/ForEach_1/output}&lt;/itemToAdd>&lt;/inputs>"/>

                    </Activity>

                    <Activity breakpoint="0" commented="0"

                        continueOnFailure="1" created="1376757443273"

                        description="" displayName="NameChangeOperation"

                        height="34" interactive="0" maxRestarts="0"

                        name="Execute"

                        namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                        originalStyle="" skipAttempt="0"

                        style="label;image=Execute"

                        uniqueName="Execute_2" waitSetting="0"

                        width="183" x="4" y="93">

                        <inputs val="&lt;inputs>&lt;inputXml class=&quot;java.lang.String&quot;>&amp;lt;?xml version=&quot;1.0&quot; encoding=&quot;UTF-8&quot; standalone=&quot;no&quot; ?&amp;gt; &amp;#xD;&#xd;&#xa;&amp;lt;App_NameChangeRequest&amp;gt; &amp;#xD;&#xd;&#xa;    &amp;lt;updateDBOnClientsUnreachable&amp;gt;false&amp;lt;/updateDBOnClientsUnreachable&amp;gt; &amp;#xD;&#xd;&#xa;    &amp;lt;operation&amp;gt;CS_HOST_NAME_CHANGE&amp;lt;/operation&amp;gt; &amp;#xD;&#xd;&#xa;    &amp;lt;csHostName&amp;gt; &amp;#xD;&#xd;&#xa;        &amp;lt;oldData&amp;gt;xpath:{/workflow/variables/ProductionCSName}&amp;lt;/oldData&amp;gt; &amp;#xD;&#xd;&#xa;        &amp;lt;newData&amp;gt;xpath:{/workflow/inputs/DRCSName}&amp;lt;/newData&amp;gt; &amp;#xD;&#xd;&#xa;    &amp;lt;/csHostName&amp;gt; &amp;#xD;&#xd;&#xa;    &amp;lt;clientList&amp;gt; &amp;#xD;&#xd;&#xa;        &amp;lt;clientName&amp;gt;xpath:{/workflow/ForEach_1/output}&amp;lt;/clientName&amp;gt; &amp;#xD;&#xd;&#xa;    &amp;lt;/clientList&amp;gt; &amp;#xD;&#xd;&#xa;&amp;lt;/App_NameChangeRequest&amp;gt;&lt;/inputXml>&lt;commandArgs class=&quot;java.lang.String&quot;>-cs xpath:{/workflow/inputs/DRCSName}&lt;/commandArgs>&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>false&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot;>xpath:{/workflow/Login_1/commandOutput}&lt;/token>&lt;/sessionOptions>&lt;/inputs>"/>

                        <transition activity="XPathQuery_2"

                            commented="0" originalStyle="" points=""

                            sourceX="95" sourceY="110" status="0"

                            style="defaultEdge" targetX="81"

                            targetY="154" transitionIndex="0" x="-15" y="-1">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity breakpoint="0" commented="0"

                        continueOnFailure="1" created="1379001884949"

                        description="if/else based decision"

                        displayName="Successful?" height="100"

                        interactive="0" maxRestarts="0" name="Decision"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="rhombus;fontStyle=1"

                        uniqueName="Decision_7" waitSetting="0"

                        width="107" x="22" y="220">

                        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/XPathQuery_2/result}==0&lt;/expression>&lt;/inputs>"/>

                        <transition activity="AddToList_1" commented="0"

                            displayName="yes" originalStyle="" points=""

                            sourceX="79" sourceY="284" status="0"

                            style="defaultEdge" targetX="79"

                            targetY="352" transitionIndex="0"

                            value="true" x="-38" y="-8">

                            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                        <transition activity="AddToList_5" commented="0"

                            displayName="no" offsetX="1" offsetY="-13"

                            originalStyle="" points="192.0,272.0"

                            sourceX="75" sourceY="270" status="0"

                            style="defaultEdge" targetX="183"

                            targetY="292" transitionIndex="0"

                            value="false" x="0" y="0">

                            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity breakpoint="0" commented="0"

                        continueOnFailure="1" created="1379019070485"

                        description="retrieves a list of values from xml"

                        displayName="OutputParsing" height="34"

                        interactive="0" maxRestarts="0"

                        name="XPathQuery"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=XPathQuery"

                        uniqueName="XPathQuery_2" waitSetting="0"

                        width="125" x="15" y="153">

                        <inputs val="&lt;inputs>&lt;xml class=&quot;java.lang.String&quot;>xpath:{/workflow/Execute_2/outputXml}&lt;/xml>&lt;xpath class=&quot;java.lang.String&quot;>/App_NameChangeResponse/failedClientList/errorCode&lt;/xpath>&lt;outputType class=&quot;workflow.types.SimpleType&quot;>Integer&lt;/outputType>&lt;outputAsList class=&quot;java.lang.Boolean&quot;>false&lt;/outputAsList>&lt;/inputs>"/>

                        <transition activity="Decision_7" commented="0"

                            originalStyle="" points="" sourceX="77"

                            sourceY="170" status="0" style="defaultEdge"

                            targetX="75" targetY="234"

                            transitionIndex="0" x="-15" y="-1">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity breakpoint="0" commented="0"

                        continueOnFailure="1" created="1379449227670"

                        description="utility to add objects to a list"

                        displayName="AddToFailedList" height="34"

                        interactive="0" maxRestarts="0" name="AddToList"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=AddToList"

                        uniqueName="AddToList_5" waitSetting="0"

                        width="135" x="131" y="299">

                        <onEnter language="1" script="String s = workflow.getVariable(&quot;ReasonForFailure&quot;);&#xd;&#xa;s = s + &quot;-  Name Change Operation Failed (Pointing of clients from Production CS to DR CS) \n&quot;;&#xd;&#xa;workflow.setVariable(&quot;WorkflowStatus&quot;, &quot;Failed&quot;);&#xd;&#xa;workflow.setVariable(&quot;ReasonForFailure&quot;, s);&#xd;&#xa;&#xd;&#xa;"/>

                        <inputs val="&lt;inputs>&lt;addToList class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/NameChangeFail1}&lt;/addToList>&lt;itemToAdd class=&quot;java.lang.Object&quot;>xpath:{/workflow/ForEach_1/output}&lt;/itemToAdd>&lt;/inputs>"/>

                    </Activity>

                </superProcess>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1379449395632"

                description="if/else based decision"

                displayName="AnyFailure?" height="100" interactive="0"

                maxRestarts="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_10"

                waitSetting="0" width="108" x="912" y="545">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/WorkflowStatus}.equals(&quot;Failed&quot;) &lt;/expression>&lt;/inputs>"/>

                <transition activity="WorkflowEnd_2" commented="0"

                    displayName="yes" originalStyle=""

                    points="966.4835353879608,663.5489015477332"

                    sourceX="919" sourceY="596" status="0"

                    style="defaultEdge" targetX="910" targetY="677"

                    transitionIndex="0" value="true" x="570" y="28">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="SQLQuery_1" commented="0"

                    displayName="no" offsetX="53" offsetY="-135"

                    originalStyle="" points="1136.75,344.25"

                    sourceX="966" sourceY="597" status="0"

                    style="defaultEdge" targetX="1185" targetY="55"

                    transitionIndex="0" value="false" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1379506449444"

                description="utility to add objects to a list"

                displayName="AddToFailedList" height="34"

                interactive="0" maxRestarts="0" name="AddToList"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=AddToList" uniqueName="AddToList_7"

                waitSetting="0" width="135" x="1390" y="453">

                <onEnter language="1" script="String s = workflow.getVariable(&quot;ReasonForFailure&quot;);&#xd;&#xa;s = s + &quot;- Data Restore Operation Failed \n&quot;;&#xd;&#xa;workflow.setVariable(&quot;WorkflowStatus&quot;, &quot;Failed&quot;);&#xd;&#xa;workflow.setVariable(&quot;ReasonForFailure&quot;, s);&#xd;&#xa;"/>

                <inputs val="&lt;inputs>&lt;addToList class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/TestRestoreFail}&lt;/addToList>&lt;itemToAdd class=&quot;java.lang.Object&quot;>xpath:{/workflow/XPathQuery_4/result}&lt;/itemToAdd>&lt;/inputs>"/>

                <transition activity="WorkflowEnd_5" commented="0"

                    originalStyle="" points="" sourceX="1313"

                    sourceY="474" status="0" style="defaultEdge"

                    targetX="1338" targetY="596" transitionIndex="0"

                    x="204" y="141">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1379694157755"

                description="if/else based decision"

                displayName="Successful?" height="100" interactive="0"

                maxRestarts="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_12"

                waitSetting="0" width="107" x="108" y="255">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/PSExec_1/errorCode}==0&lt;/expression>&lt;/inputs>"/>

                <transition activity="WorkflowEnd_1" commented="0"

                    displayName="no" offsetX="-13" offsetY="-50"

                    originalStyle=""

                    points="80.53318077803195,462.24866514111363"

                    sourceX="159" sourceY="355" status="0"

                    style="defaultEdge" targetX="84" targetY="577"

                    transitionIndex="0" value="false" x="17" y="137">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="Login_1" commented="0"

                    displayName="yes" originalStyle="" points=""

                    sourceX="159" sourceY="355" status="0"

                    style="defaultEdge" targetX="146" targetY="634"

                    transitionIndex="0" value="true" x="17" y="137">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1379696284917"

                description="activity to delay the workflow execution in minutes"

                displayName="ReflectingNameChange" height="34"

                interactive="0" name="Delay"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Delay" uniqueName="Delay_5"

                waitSetting="0" width="199" x="867" y="482">

                <inputs val="&lt;inputs>&lt;delayLength class=&quot;java.lang.Integer&quot;>1&lt;/delayLength>&lt;delayInterval class=&quot;workflow.types.DelayInterval&quot;>Minutes&lt;/delayInterval>&lt;/inputs>"/>

                <transition activity="Decision_10" commented="0"

                    originalStyle="" points="" sourceX="966"

                    sourceY="499" status="0" style="defaultEdge"

                    targetX="918" targetY="551" transitionIndex="0"

                    x="631" y="-47">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1379701777803" description="Ends the workflow"

                displayName="FailWorkflow" height="34" interactive="0"

                maxRestarts="0" name="WorkflowEnd"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=WorkflowEnd;gradientColor=#FF0000;fillColor=#FF0000"

                uniqueName="WorkflowEnd_1" waitSetting="0" width="119"

                x="9" y="672">

                <onEnter language="1" script="String s = workflow.getVariable(&quot;ReasonForFailure&quot;);&#xd;&#xa;s = s + &quot;Database Restore Operation Failed (On DR CS) \n&quot;;&#xd;&#xa;workflow.setVariable(&quot;WorkflowStatus&quot;, &quot;Failed&quot;);&#xd;&#xa;workflow.setVariable(&quot;ReasonForFailure&quot;, s);"/>

                <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot;>FAILED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot;>Database Restore Operation Failed&lt;/failureMessage>&lt;/inputs>"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1379701826254" description="Ends the workflow"

                displayName="FailWorkflow" height="34" interactive="0"

                maxRestarts="0" name="WorkflowEnd"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=WorkflowEnd;gradientColor=#FF0000;fillColor=#FF0000"

                uniqueName="WorkflowEnd_2" waitSetting="0" width="119"

                x="902" y="676">

                <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot;>FAILED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot;>Name Change Operation Failed (Pointing of clients from Production CS to DR CS&lt;/failureMessage>&lt;/inputs>"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1379701868126" description="Ends the workflow"

                displayName="WorkflowEnd" height="34" interactive="0"

                maxRestarts="0" name="WorkflowEnd"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=WorkflowEnd;fillColor=#009900;gradientColor=#009900"

                uniqueName="WorkflowEnd_4" waitSetting="0" width="119"

                x="1573" y="278">

                <onEnter language="1" script="workflow.setVariable(&quot;WorkflowStatus&quot;, &quot;Successful&quot;);"/>

                <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot;>COMPLETED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot; />&lt;/inputs>"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1379701880567" description="Ends the workflow"

                displayName="FailWorkflow" height="34" interactive="0"

                maxRestarts="0" name="WorkflowEnd"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=WorkflowEnd;gradientColor=#FF0000;fillColor=#FF0000"

                uniqueName="WorkflowEnd_5" waitSetting="0" width="119"

                x="1387" y="679">

                <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot;>FAILED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot;>Data Restore Operation Failed&lt;/failureMessage>&lt;/inputs>"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1380034964754"

                description="iterates a group of activities over a list of values"

                displayName="RemoveDIPs" height="400" interactive="0"

                maxRestarts="0" name="ForEach"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0" style="swimlane"

                uniqueName="ForEach_5" waitSetting="0" width="298"

                x="285" y="41">

                <activitySchema>

                    <inputs>

                        <children className="java.lang.String"

                            inputType="java.lang.String" name="name" type="{http://www.w3.org/2001/XMLSchema}string"/>

                        <children className="java.lang.Object"

                            inputType="java.lang.Object" name="values" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                        <children className="java.lang.Integer"

                            defaultValue="1"

                            inputType="java.lang.Integer"

                            name="numberOfParallelExecutions" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                        <children className="java.lang.Boolean"

                            defaultValue="false"

                            inputType="java.lang.Boolean"

                            name="continueOnFailure" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                    </inputs>

                    <outputs name="outputs">

                        <children className="java.lang.Object"

                            inputType="java.lang.Object" listType="0"

                            name="output" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                    </outputs>

                </activitySchema>

                <inputs val="&lt;inputs>&lt;name class=&quot;java.lang.String&quot;>output&lt;/name>&lt;values class=&quot;java.lang.Object&quot;>xpath:{/workflow/Script_2/output}&lt;/values>&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot;>xpath:{/workflow/variables/noOfClients}&lt;/numberOfParallelExecutions>&lt;continueOnFailure class=&quot;java.lang.Boolean&quot;>true&lt;/continueOnFailure>&lt;/inputs>"/>

                <transition activity="Decision_15" commented="0"

                    originalStyle="" points="" sourceX="445"

                    sourceY="350" status="0" style="defaultEdge"

                    targetX="386" targetY="700" transitionIndex="0"

                    x="17" y="137">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <superProcess>

                    <Start breakpoint="0" commented="0"

                        continueOnFailure="0" created="1380034964754"

                        description="" displayName="Start" height="30"

                        interactive="0" name="Start" originalStyle=""

                        skipAttempt="0"

                        style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                        uniqueName="Start_14" waitSetting="0"

                        width="120" x="18" y="30">

                        <inputs val="&lt;inputs />"/>

                        <transition activity="ExecuteScript_1"

                            commented="0" originalStyle="" points=""

                            sourceX="78" sourceY="45" status="0"

                            style="defaultEdge" targetX="102"

                            targetY="112" transitionIndex="0" x="0" y="0">

                            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Start>

                    <Activity breakpoint="0" commented="0"

                        continueOnFailure="1" created="1380035099807"

                        description="" displayName="RemoveDIP"

                        height="34" interactive="0" maxRestarts="0"

                        name="ExecuteScript"

                        namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                        originalStyle="" skipAttempt="0"

                        style="label;image=ExecuteScript"

                        uniqueName="ExecuteScript_1" waitSetting="0"

                        width="177" x="14" y="95">

                        <inputs val="&lt;inputs>&lt;scriptName class=&quot;java.lang.String&quot;>DataInterfacePairConfig.sql&lt;/scriptName>&lt;arguments class=&quot;java.lang.String&quot;>-si deleteByClient -si xpath:{/workflow/ForEach_5/output}&lt;/arguments>&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>false&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot;>xpath:{/workflow/Login_1/commandOutput}&lt;/token>&lt;/sessionOptions>&lt;/inputs>"/>

                        <transition activity="Decision_14" commented="0"

                            originalStyle="" points="" sourceX="102"

                            sourceY="112" status="0" style="defaultEdge"

                            targetX="81" targetY="216"

                            transitionIndex="0" x="0" y="0">

                            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity breakpoint="0" commented="0"

                        continueOnFailure="1" created="1380035553874"

                        description="if/else based decision"

                        displayName="Successful?" height="100"

                        interactive="0" maxRestarts="0" name="Decision"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="rhombus;fontStyle=1"

                        uniqueName="Decision_14" waitSetting="0"

                        width="107" x="28" y="166">

                        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/ExecuteScript_1/exitCode}==0&lt;/expression>&lt;/inputs>"/>

                        <transition activity="AddToList_10"

                            commented="0" displayName="yes"

                            originalStyle="" points="" sourceX="81"

                            sourceY="216" status="0" style="defaultEdge"

                            targetX="94" targetY="371"

                            transitionIndex="0" value="true" x="0" y="0">

                            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                        <transition activity="AddToList_11"

                            commented="0" displayName="no" offsetX="-2"

                            offsetY="-38" originalStyle=""

                            points="212.0,215.0" sourceX="81"

                            sourceY="216" status="0" style="defaultEdge"

                            targetX="216" targetY="277"

                            transitionIndex="0" value="false" x="0" y="0">

                            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity breakpoint="0" commented="0"

                        continueOnFailure="1" created="1380035617551"

                        description="utility to add objects to a list"

                        displayName="AddToSuccessList" height="34"

                        interactive="0" maxRestarts="0" name="AddToList"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=AddToList"

                        uniqueName="AddToList_10" waitSetting="0"

                        width="148" x="20" y="354">

                        <inputs val="&lt;inputs>&lt;addToList class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/RemoveDIPSuccess}&lt;/addToList>&lt;itemToAdd class=&quot;java.lang.Object&quot;>xpath:{/workflow/ForEach_5/output}&lt;/itemToAdd>&lt;/inputs>"/>

                    </Activity>

                    <Activity breakpoint="0" commented="0"

                        continueOnFailure="1" created="1380035620575"

                        description="utility to add objects to a list"

                        displayName="AddToFailedList" height="34"

                        interactive="0" maxRestarts="0" name="AddToList"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=AddToList"

                        uniqueName="AddToList_11" waitSetting="0"

                        width="135" x="140" y="294">

                        <onEnter language="1" script="String s = workflow.getVariable(&quot;ReasonForFailure&quot;);&#xd;&#xa;s = s + &quot;- Remove DIP Operation Failed (Removing Data Interface Pairs to Production CS from DR CS) \n&quot;;&#xd;&#xa;workflow.setVariable(&quot;WorkflowStatus&quot;, &quot;Failed&quot;);&#xd;&#xa;workflow.setVariable(&quot;ReasonForFailure&quot;, s);&#xd;&#xa;"/>

                        <inputs val="&lt;inputs>&lt;addToList class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/RemoveDIPFail}&lt;/addToList>&lt;itemToAdd class=&quot;java.lang.Object&quot;>xpath:{/workflow/ForEach_5/output}&lt;/itemToAdd>&lt;/inputs>"/>

                    </Activity>

                </superProcess>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1380036163396"

                description="if/else based decision"

                displayName="AnyFailure?" height="100" interactive="0"

                maxRestarts="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_15"

                waitSetting="0" width="108" x="380" y="528">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/WorkflowStatus}.equals(&quot;Failed&quot;) &lt;/expression>&lt;/inputs>"/>

                <transition activity="WorkflowEnd_6" commented="0"

                    displayName="yes" originalStyle="" points=""

                    sourceX="386" sourceY="700" status="0"

                    style="defaultEdge" targetX="387" targetY="824"

                    transitionIndex="0" value="true" x="17" y="137">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="PSExec_6" commented="0"

                    displayName="no" offsetX="-1" offsetY="-3"

                    originalStyle="" points="608.0,252.1111111111111"

                    sourceX="386" sourceY="700" status="0"

                    style="defaultEdge" targetX="721" targetY="160"

                    transitionIndex="0" value="false" x="-550" y="138">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1380036341606" description="Ends the workflow"

                displayName="FailWorkflow" height="34" interactive="0"

                maxRestarts="0" name="WorkflowEnd"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=WorkflowEnd;gradientColor=#FF0000;fillColor=#FF0000"

                uniqueName="WorkflowEnd_6" waitSetting="0" width="119"

                x="368" y="675">

                <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot;>FAILED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot;>Remove DIP Operation Failed (Removing Data Interface Pairs to Production CS from DR CS)&lt;/failureMessage>&lt;/inputs>"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1380552716752"

                description="if/else based decision"

                displayName="Successful?" height="100" interactive="0"

                maxRestarts="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_17"

                waitSetting="0" width="107" x="108" y="566">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/Login_1/exitCode}==0&lt;/expression>&lt;/inputs>"/>

                <transition activity="WorkflowEnd_7" commented="0"

                    displayName="no" offsetX="21" offsetY="-13"

                    originalStyle=""

                    points="258.5331807780319,697.2486651411136"

                    sourceX="158" sourceY="601" status="0"

                    style="defaultEdge" targetX="256" targetY="826"

                    transitionIndex="0" value="false" x="17" y="137">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="ForEach_5" commented="0"

                    displayName="yes" offsetX="3" offsetY="3"

                    originalStyle="" points="" sourceX="158"

                    sourceY="601" status="0" style="defaultEdge"

                    targetX="349" targetY="161" transitionIndex="0"

                    value="true" x="17" y="137">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1380552863556" description="Ends the workflow"

                displayName="FailWorkflow" height="34" interactive="0"

                maxRestarts="0" name="WorkflowEnd"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=WorkflowEnd;fillColor=#FF0000;gradientColor=#FF0000"

                uniqueName="WorkflowEnd_7" waitSetting="0" width="119"

                x="190" y="671">

                <onEnter language="1" script="String s = workflow.getVariable(&quot;ReasonForFailure&quot;);&#xd;&#xa;s = s + &quot;Qlogin to DRCS has Failed \n&quot;;&#xd;&#xa;workflow.setVariable(&quot;WorkflowStatus&quot;, &quot;Failed&quot;);&#xd;&#xa;workflow.setVariable(&quot;ReasonForFailure&quot;, s);"/>

                <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot;>FAILED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot;>Qlogin to DRCS has Failed&lt;/failureMessage>&lt;/inputs>"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1380901447321"

                description="Execute a command on a remote machine"

                displayName="DBRestoreOnDRCS" height="34"

                interactive="0" maxRestarts="0" name="PSExec"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=PSExec" uniqueName="PSExec_1"

                waitSetting="0" width="156" x="78" y="150">

                <inputs val="&lt;inputs>&lt;hostName class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/DRCSName}&lt;/hostName>&lt;userName class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/DRCSComputerUsername}&lt;/userName>&lt;password class=&quot;workflow.types.EncryptedString&quot;>xpath:{/workflow/inputs/DRCSComputerPassword}&lt;/password>&lt;program class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/DRCSBasePath}\DRRestore.exe&lt;/program>&lt;arguments class=&quot;java.lang.String&quot;>xpath:{/workflow/PSExec_7/commandOutput} cs dbrestore java:{xpath:{/workflow/inputs/DRCSSqlPassword_sa_user}.getPlainText()}&lt;/arguments>&lt;useImpersonation class=&quot;java.lang.Boolean&quot;>xpath:{/workflow/inputs/IsProdCSandDRCSonSameDomain}&lt;/useImpersonation>&lt;/inputs>"/>

                <transition activity="Decision_12" commented="0"

                    originalStyle="" points="" sourceX="161"

                    sourceY="247" status="0" style="defaultEdge"

                    targetX="163" targetY="311" transitionIndex="0"

                    x="17" y="137">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1384201537352"

                description="Execute a command on a remote machine"

                displayName="StartServicesOnMA" height="34"

                interactive="0" maxRestarts="0" name="PSExec"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=PSExec" uniqueName="PSExec_6"

                waitSetting="0" width="159" x="623" y="35">

                <inputs val="&lt;inputs>&lt;hostName class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/mediaAgent}&lt;/hostName>&lt;userName class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/MAComputerUserName}&lt;/userName>&lt;password class=&quot;workflow.types.EncryptedString&quot;>xpath:{/workflow/inputs/MAComputerPassword}&lt;/password>&lt;useImpersonation class=&quot;java.lang.Boolean&quot;>xpath:{/workflow/inputs/IsProdCSandMAonSameDomain}&lt;/useImpersonation>&lt;program class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/MABasePath}\DRRestore.exe&lt;/program>&lt;arguments class=&quot;java.lang.String&quot;>a b StartServices d&lt;/arguments>&lt;/inputs>"/>

                <transition activity="Decision_25" commented="0"

                    originalStyle="" points="" sourceX="492"

                    sourceY="905" status="0" style="defaultEdge"

                    targetX="509" targetY="976" transitionIndex="0"

                    x="-1042" y="133">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1384369014121"

                description="if/else based decision"

                displayName="Successful?" height="100" interactive="0"

                maxRestarts="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_25"

                waitSetting="0" width="107" x="637" y="177">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/PSExec_6/errorCode}==0&lt;/expression>&lt;/inputs>"/>

                <transition activity="WorkflowEnd_15" commented="0"

                    displayName="no" originalStyle="" points=""

                    sourceX="513" sourceY="1019" status="0"

                    style="defaultEdge" targetX="312" targetY="1019"

                    transitionIndex="0" value="false" x="-1042" y="133">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="ForEach_1" commented="0"

                    displayName="yes" originalStyle=""

                    points="794.6666666666665,47.66666666666667"

                    sourceX="513" sourceY="1019" status="0"

                    style="defaultEdge" targetX="661" targetY="152"

                    transitionIndex="0" value="true" x="-1042" y="133">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1384369040798" description="Ends the workflow"

                displayName="FailWorkflow" height="34" interactive="0"

                maxRestarts="0" name="WorkflowEnd"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=WorkflowEnd;gradientColor=#FF0000;fillColor=#FF0000"

                uniqueName="WorkflowEnd_15" waitSetting="0" width="119"

                x="632" y="674">

                <onEnter language="1" script="String s = workflow.getVariable(&quot;ReasonForFailure&quot;);&#xd;&#xa;s = s +&quot;Failed to stop the services on MA \n&quot;;&#xd;&#xa;workflow.setVariable(&quot;WorkflowStatus&quot;, &quot;Failed&quot;);&#xd;&#xa;workflow.setVariable(&quot;ReasonForFailure&quot;, s);"/>

                <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot;>FAILED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot;>Failed to stop the services on MA&lt;/failureMessage>&lt;/inputs>"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1384547025771"

                description="executes queries against a specified database"

                displayName="EnableMediaAgent" height="34"

                interactive="0" maxRestarts="0" name="SQLQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=SQLQuery" uniqueName="SQLQuery_1"

                waitSetting="0" width="151" x="1159" y="36">

                <inputs val="&lt;inputs>&lt;databaseType class=&quot;workflow.types.DatabaseType&quot;>MSSQL&lt;/databaseType>&lt;server class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/DRCSName}\commvault&lt;/server>&lt;databaseName class=&quot;java.lang.String&quot;>CommServ&lt;/databaseName>&lt;userName class=&quot;java.lang.String&quot;>sa&lt;/userName>&lt;password class=&quot;workflow.types.EncryptedString&quot;>xpath:{/workflow/inputs/DRCSSqlPassword_sa_user}&lt;/password>&lt;query class=&quot;java.lang.String&quot;>update MMHost set MmHostEnabled = 1 where ClientId = (select id from APP_Client where name = ''xpath:{/workflow/variables/MAShortName}'')&lt;/query>&lt;/inputs>"/>

                <transition activity="PSExec_9" commented="0"

                    originalStyle="" points="" sourceX="1234"

                    sourceY="53" status="0" style="defaultEdge"

                    targetX="1231" targetY="223" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1384548692767"

                description="Execute a command on a remote machine"

                displayName="RestartServicesOnMA" height="34"

                interactive="0" maxRestarts="0" name="PSExec"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=PSExec" uniqueName="PSExec_9"

                waitSetting="0" width="174" x="1160" y="171">

                <inputs val="&lt;inputs>&lt;hostName class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/mediaAgent}&lt;/hostName>&lt;userName class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/MAComputerUserName}&lt;/userName>&lt;password class=&quot;workflow.types.EncryptedString&quot;>xpath:{/workflow/inputs/MAComputerPassword}&lt;/password>&lt;useImpersonation class=&quot;java.lang.Boolean&quot;>xpath:{/workflow/inputs/IsProdCSandMAonSameDomain}&lt;/useImpersonation>&lt;program class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/MABasePath}\DRRestore.exe&lt;/program>&lt;arguments class=&quot;java.lang.String&quot;>a b RestartServices d&lt;/arguments>&lt;/inputs>"/>

                <transition activity="Decision_28" commented="0"

                    originalStyle="" points="" sourceX="1239"

                    sourceY="188" status="0" style="defaultEdge"

                    targetX="1243" targetY="286" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1384548800345"

                description="if/else based decision"

                displayName="Successful?" height="100" interactive="0"

                maxRestarts="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_28"

                waitSetting="0" width="107" x="1180" y="264">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/PSExec_9/errorCode}==0&lt;/expression>&lt;/inputs>"/>

                <transition activity="WorkflowEnd_16" commented="0"

                    displayName="no" originalStyle="" points=""

                    sourceX="1234" sourceY="314" status="0"

                    style="defaultEdge" targetX="1266" targetY="690"

                    transitionIndex="0" value="false" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="Delay_6" commented="0"

                    displayName="yes" originalStyle="" points=""

                    sourceX="1234" sourceY="314" status="0"

                    style="defaultEdge" targetX="1471" targetY="46"

                    transitionIndex="0" value="true" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1384548824769" description="Ends the workflow"

                displayName="FailWorkflow" height="34" interactive="0"

                maxRestarts="0" name="WorkflowEnd"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=WorkflowEnd;gradientColor=#FF0000;fillColor=#FF0000"

                uniqueName="WorkflowEnd_16" waitSetting="0" width="119"

                x="1182" y="675">

                <onEnter language="1" script="String s = workflow.getVariable(&quot;ReasonForFailure&quot;);&#xd;&#xa;s = s +&quot;Failed to Restart the services on MA \n&quot;;&#xd;&#xa;workflow.setVariable(&quot;WorkflowStatus&quot;, &quot;Failed&quot;);&#xd;&#xa;workflow.setVariable(&quot;ReasonForFailure&quot;, s);"/>

                <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot;>FAILED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot;>Failed to Restart the services on MA&lt;/failureMessage>&lt;/inputs>"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1384790934283"

                description="activity to delay the workflow execution in minutes"

                displayName="ReflectingChanges" height="34"

                interactive="0" maxRestarts="0" name="Delay"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Delay" uniqueName="Delay_6"

                waitSetting="0" width="152" x="1369" y="38">

                <inputs val="&lt;inputs>&lt;delayLength class=&quot;java.lang.Integer&quot;>1&lt;/delayLength>&lt;delayInterval class=&quot;workflow.types.DelayInterval&quot;>Minutes&lt;/delayInterval>&lt;/inputs>"/>

                <transition activity="Execute_1" commented="0"

                    originalStyle="" points="" sourceX="1445"

                    sourceY="55" status="0" style="defaultEdge"

                    targetX="1445" targetY="106" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

        </superProcess>

    </Activity>

    <onStart language="1" script="try&#xd;&#xa;{&#xd;&#xa;    String drcsName = xpath:{/workflow/inputs/DRCSName};&#xd;&#xa;    String[] name = drcsName.split(&quot;[.]&quot;);&#xd;&#xa;    workflow.setVariable(&quot;DRCSShortName&quot;, name[0]);&#xd;&#xa;    logger.info(&quot;>>DRCS ShortName: &quot;+name[0]);&#xd;&#xa;    &#xd;&#xa;    String sql = &quot;select name from APP_Client where net_hostname = ''&quot; + xpath:{/workflow/inputs/sourceClient} + &quot;''&quot;;&#xd;&#xa;    DataSet rs = csdb.execute(sql);&#xd;&#xa;    String sourceclientShortName = &quot;&quot;;&#xd;&#xa;    while(rs.hasNext()) {&#xd;&#xa;       sourceclientShortName = rs.get(&quot;name&quot;);&#xd;&#xa;    }&#xd;&#xa;    workflow.setVariable(&quot;SourceClientShortName&quot;, sourceclientShortName);    &#xd;&#xa;    logger.info(&quot;>> SourceClientShortName: &quot; + sourceclientShortName);&#xd;&#xa;       &#xd;&#xa;    String sql = &quot;select name from APP_Client where net_hostname = ''&quot; + xpath:{/workflow/inputs/restoreClient} + &quot;''&quot;;&#xd;&#xa;    DataSet rs = csdb.execute(sql);&#xd;&#xa;    String restoreclientShortName = &quot;&quot;;&#xd;&#xa;    while(rs.hasNext()) {&#xd;&#xa;       restoreclientShortName = rs.get(&quot;name&quot;);&#xd;&#xa;    }&#xd;&#xa;    workflow.setVariable(&quot;RestoreClientShortName&quot;, restoreclientShortName);    &#xd;&#xa;    logger.info(&quot;>> RestoreClientShortName: &quot; + restoreclientShortName);&#xd;&#xa;    &#xd;&#xa;    String sql = &quot;select csHostName from APP_Client where displayName = ''&quot;+ xpath:{/workflow/system/commCellName}+&quot;''&quot;;&#xd;&#xa;    DataSet rs = csdb.execute(sql);&#xd;&#xa;    String csHostName = &quot;&quot;;&#xd;&#xa;    while(rs.hasNext()) {&#xd;&#xa;       csHostName= rs.get(&quot;csHostName&quot;);&#xd;&#xa;    }&#xd;&#xa;    workflow.setVariable(&quot;ProductionCSName&quot;, csHostName);&#xd;&#xa;    &#xd;&#xa;    String sql = &quot;select name from APP_Client where net_hostname = ''&quot; + xpath:{/workflow/inputs/mediaAgent} + &quot;''&quot;;&#xd;&#xa;    DataSet rs = csdb.execute(sql);&#xd;&#xa;    String maShortName = &quot;&quot;;&#xd;&#xa;    while(rs.hasNext()) {&#xd;&#xa;       maShortName = rs.get(&quot;name&quot;);&#xd;&#xa;    }&#xd;&#xa;    workflow.setVariable(&quot;MAShortName&quot;, maShortName);&#xd;&#xa;    logger.info(&quot;>> CSHostName: &quot;+csHostName);&#xd;&#xa;    logger.info(&quot;>> MAShortName: &quot;+maShortName);&#xd;&#xa;}&#xd;&#xa;catch(Exception e )&#xd;&#xa;{&#xd;&#xa;    logger.info(&quot;>> &quot;+ &quot;Failed in parsing the user inputs&quot;);&#xd;&#xa;}"/>

    <schema>

        <inputs attribute="0" className="" listType="0" name="inputs"

            required="1" type="">

            <children attribute="0" className="java.lang.String"

                controlType="0" hidden="0" inputType="java.lang.String"

                listType="0" name="ProductionCSUsername" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0"

                className="workflow.types.EncryptedString"

                controlType="0" hidden="0"

                inputType="workflow.types.EncryptedString" listType="0"

                name="ProductionCSPassword" required="0" type="{workflow.types}EncryptedString"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" hidden="0" inputType="java.lang.String"

                listType="0" name="DRCSName" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" hidden="0" inputType="java.lang.String"

                listType="0" name="DRCSComputerUsername" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0"

                className="workflow.types.EncryptedString"

                controlType="0" hidden="0"

                inputType="workflow.types.EncryptedString" listType="0"

                name="DRCSComputerPassword" required="0" type="{workflow.types}EncryptedString"/>

            <children attribute="0"

                className="workflow.types.EncryptedString"

                controlType="0" hidden="0"

                inputType="workflow.types.EncryptedString" listType="0"

                name="DRCSSqlPassword_sa_user" required="0" type="{workflow.types}EncryptedString"/>

            <children attribute="0" className="java.lang.Boolean"

                controlType="5" hidden="0" inputType="java.lang.Boolean"

                listType="0" name="IsProdCSandDRCSonSameDomain"

                required="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" hidden="0" inputType="java.lang.String"

                listType="0" name="dbDumpPath" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" hidden="0" inputType="java.lang.String"

                listType="0" name="clientList" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" hidden="0" inputType="java.lang.String"

                listType="0" name="mediaAgent" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" hidden="0" inputType="java.lang.String"

                listType="0" name="MAComputerUserName" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0"

                className="workflow.types.EncryptedString"

                controlType="0" hidden="0"

                inputType="workflow.types.EncryptedString" listType="0"

                name="MAComputerPassword" required="0" type="{workflow.types}EncryptedString"/>

            <children attribute="0" className="java.lang.Boolean"

                controlType="5" hidden="0" inputType="java.lang.Boolean"

                listType="0" name="IsProdCSandMAonSameDomain"

                required="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" hidden="0" inputType="java.lang.String"

                listType="0" name="SubClientName" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" hidden="0" inputType="java.lang.String"

                listType="0" name="sourceClient" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" hidden="0" inputType="java.lang.String"

                listType="0" name="restoreClient" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" hidden="0" inputType="java.lang.String"

                listType="0" name="sourcePath" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" hidden="0" inputType="java.lang.String"

                listType="0" name="destinationPath" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.Integer"

                controlType="0" hidden="0" inputType="java.lang.Integer"

                listType="0" name="CopyPrecedenceNumber" required="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" hidden="0" inputType="java.lang.String"

                listType="0" name="EmailID" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

        </inputs>

        <variables attribute="0" className="" listType="0"

            name="variables" required="1" type="">

            <children attribute="0" className="java.lang.Integer"

                controlType="0" hidden="0" inputType="java.lang.Integer"

                listType="0" name="noOfClients" required="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" hidden="0" inputType="java.lang.String"

                listType="0" name="success" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" hidden="0" inputType="java.lang.String"

                listType="0" name="DRCSShortName" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" hidden="0" inputType="java.lang.String"

                listType="1" name="NameChangeSuccess1" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" hidden="0" inputType="java.lang.String"

                listType="1" name="NameChangeSuccess2" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" hidden="0" inputType="java.lang.String"

                listType="1" name="NameChangeFail1" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" hidden="0" inputType="java.lang.String"

                listType="1" name="NameChangeFail2" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" hidden="0" inputType="java.lang.String"

                listType="1" name="CheckReadinessSuccess1" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" hidden="0" inputType="java.lang.String"

                listType="1" name="CheckReadinessSuccess2" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" hidden="0" inputType="java.lang.String"

                listType="1" name="CheckReadinessFail1" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" hidden="0" inputType="java.lang.String"

                listType="1" name="CheckReadinessFail2" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" hidden="0" inputType="java.lang.String"

                listType="0" name="WorkflowStatus" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" hidden="0" inputType="java.lang.String"

                listType="1" name="TestRestoreFail" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" hidden="0" inputType="java.lang.String"

                listType="0" name="ReasonForFailure" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" hidden="0" inputType="java.lang.String"

                listType="1" name="RemoveDIPSuccess" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" hidden="0" inputType="java.lang.String"

                listType="1" name="RemoveDIPFail" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" hidden="0" inputType="java.lang.String"

                listType="0" name="ProductionCSName" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" hidden="0" inputType="java.lang.String"

                listType="0" name="EmailBody" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" hidden="0" inputType="java.lang.String"

                listType="0" name="DRCSBasePath" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" hidden="0" inputType="java.lang.String"

                listType="0" name="MABasePath" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" hidden="0" inputType="java.lang.String"

                listType="0" name="MAShortName" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" hidden="0" inputType="java.lang.String"

                listType="0" name="SourceClientShortName" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" hidden="0" inputType="java.lang.String"

                listType="0" name="RestoreClientShortName" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

        </variables>

        <outputs className="" name="outputs" type=""/>

    </schema>

</workflow>'

IF not exists (select * from WF_Definition where Name = @name)

BEGIN
	INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision)


	VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision)

	SET @workflowId = @@IDENTITY
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


	VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

	SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = ISNULL(revision, '') From WF_Definition WHERE Name = @name

	IF (@currentFlags & 4 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0) AND (@currentRevision <> @revision)

	BEGIN

		SET @version = @version + 1

		UPDATE WF_Definition

		SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision

		WHERE Name = @name

		IF (@flags & 8 > 0 OR @flags & 16 > 0)

		BEGIN

			UPDATE WF_Definition

			SET flags = @flags

			WHERE Name = @name

		END
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


		VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

	END

END


