

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_DM2CacheDirectoryMove.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/WFD_DM2CacheDirectoryMove.script,v $ $Id: WFD_DM2CacheDirectoryMove.script,v 1.5 2015/06/05 16:36:11 csunderland Exp $";
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER OFF

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.5 $'

SET @name = 'DM2CacheDirectoryMove'

SET @description = 'Move DM2 Cache Directory on Webserver'

SET @version = 1

SET @flags = 6

SET @definition = '<workflow apiMode="0"

    description="Move DM2 Cache Directory on Webserver"

    inputs="&lt;inputs />" interactive="1" name="DM2CacheDirectoryMove"

    outputs="&lt;outputs />" variables="&lt;variables />" workflowId="0">

    <Start breakpoint="0" commented="0" continueOnFailure="0"

        created="0" description="" displayName="Start" height="36"

        interactive="0" name="Start" originalStyle="" skipAttempt="0"

        style="image;image=/images/jgraphx/house.png"

        uniqueName="Start_1" waitSetting="0" width="61" x="45" y="41">

        <inputs val="&lt;inputs />"/>

        <transition activity="getAllWebServers" commented="0"

            originalStyle="" points="" sourceX="75" sourceY="59"

            status="0" style="defaultEdge" targetX="279" targetY="57"

            transitionIndex="0" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Start>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1405927035476"

        description="executes queries against the commserv database"

        displayName="Get Webserver Lists" height="34" interactive="0"

        name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=CommServDBQuery"

        uniqueName="getAllWebServers" waitSetting="0" width="165"

        x="197" y="40">

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>SELECT distinct C.name&amp;#xD;&#xd;&#xa;&#x9;FROM APP_Client C&amp;#xD;&#xd;&#xa;&#x9;&#x9;INNER JOIN simInstalledPackages P ON C.id = P.ClientId&amp;#xD;&#xd;&#xa;&#x9;WHERE P.OpType IN (''Install'', ''Reinstall'', ''Release Upgrade'', ''Package Sync'') AND P.simpackageId =252&amp;#xD;&#xd;&#xa;&#x9;&lt;/query>&lt;/inputs>"/>

        <transition activity="SelectedWS" commented="0" originalStyle=""

            points="" sourceX="279" sourceY="57" status="0"

            style="defaultEdge" targetX="296" targetY="147"

            transitionIndex="0" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1405927397966"

        description="popups an input form for the user to fill out"

        displayName="Select Webserver" height="34" interactive="0"

        name="PopupInput"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=PopupInput"

        uniqueName="SelectedWS" waitSetting="0" width="164" x="408" y="47">

        <activitySchema>

            <inputs attribute="0" listType="0" name="inputs"

                required="1" type="">

                <children attribute="0" className="java.lang.String"

                    controlType="2"

                    displayName="Select Webserver For Cache Directory Move"

                    documentation="Select Webserver"

                    inputType="java.lang.String" listType="0"

                    name="Webserver" required="0" type="{http://www.w3.org/2001/XMLSchema}string">

                    <options val="xpath:{/workflow/getAllWebServers/resultSets/row/col}"/>

                </children>

            </inputs>

            <outputs attribute="0" listType="0" name="outputs"

                required="1" type="">

                <children attribute="0" className="java.lang.String"

                    controlType="2"

                    displayName="Select Webserver For Cache Directory Move"

                    documentation="Select Webserver"

                    inputType="java.lang.String" listType="0"

                    name="Webserver" required="0" type="{http://www.w3.org/2001/XMLSchema}string">

                    <options val="xpath:{/workflow/getAllWebServers/resultSets/row/col}"/>

                </children>

                <children className="java.lang.Boolean"

                    inputType="java.lang.Boolean" name="okClicked" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                <children className="java.lang.String"

                    inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string"/>

            </outputs>

        </activitySchema>

        <inputs val="&lt;inputs>&lt;inputs>&lt;Webserver class=&quot;java.lang.String&quot; />&lt;/inputs>&lt;subject>Select Webserver&lt;/subject>&lt;/inputs>"/>

        <transition activity="newDM2CachePath" commented="0"

            originalStyle="" points="" sourceX="296" sourceY="147"

            status="0" style="defaultEdge" targetX="318" targetY="241"

            transitionIndex="0" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1405927643828"

        description="popups an input form for the user to fill out"

        displayName="Specify New DM2 Cache Directory" height="47"

        interactive="0" name="PopupInput"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=PopupInput;whiteSpace=wrap"

        uniqueName="newDM2CachePath" waitSetting="0" width="200" x="671" y="40">

        <activitySchema>

            <inputs attribute="0" listType="0" name="inputs"

                required="1" type="">

                <children attribute="0" className="java.lang.String"

                    controlType="0"

                    displayName="Specify New DM2 Cache Folder"

                    inputType="java.lang.String" listType="0"

                    name="newDM2CachePath" required="1" type="{http://www.w3.org/2001/XMLSchema}string"/>

            </inputs>

            <outputs attribute="0" listType="0" name="outputs"

                required="1" type="">

                <children attribute="0" className="java.lang.String"

                    controlType="0"

                    displayName="Specify New DM2 Cache Folder"

                    inputType="java.lang.String" listType="0"

                    name="newDM2CachePath" required="1" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children className="java.lang.Boolean"

                    inputType="java.lang.Boolean" name="okClicked" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                <children className="java.lang.String"

                    inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string"/>

            </outputs>

        </activitySchema>

        <inputs val="&lt;inputs>&lt;inputs>&lt;newDM2CachePath class=&quot;java.lang.String&quot; />&lt;/inputs>&lt;subject>New DM2 Cache Directory&lt;/subject>&lt;/inputs>"/>

        <transition activity="runningJobCheck" commented="0"

            originalStyle="" points="" sourceX="336" sourceY="241"

            status="0" style="defaultEdge" targetX="605" targetY="95"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1405927907879"

        description="displays an informational message to the user"

        displayName="IM Job is running on the webserver.&#xd;&#xa;Please wait for job completion and try again."

        height="66" interactive="0" name="InformationalMessage"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=InformationalMessage"

        uniqueName="MessageJobRunning" waitSetting="0" width="370"

        x="1002" y="268">

        <inputs val="&lt;inputs>&lt;message class=&quot;java.lang.String&quot;>Information Management Job is running on the webserver [xpath:{/workflow/SelectedWS/Webserver}]. Please wait for job completion and try again.&lt;/message>&lt;html class=&quot;java.lang.Boolean&quot; />&lt;dialogType class=&quot;commvault.msgs.Workflow.MessageDialogType&quot;>Popup&lt;/dialogType>&lt;iconType class=&quot;commvault.msgs.Workflow.MessageIconType&quot;>Information&lt;/iconType>&lt;title class=&quot;java.lang.String&quot;>IM job running.&lt;/title>&lt;/inputs>"/>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1405946464166" description="Execute a list of commands"

        displayName="Update Registry" height="34" interactive="0"

        name="ExecuteCommand"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ExecuteCommand"

        uniqueName="UpdateWSRegNewCachePach" waitSetting="0" width="147"

        x="1063" y="718">

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/SelectedWS/Webserver}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; />&lt;command class=&quot;java.lang.String&quot;>reg &lt;/command>&lt;arguments class=&quot;java.lang.String&quot;>add &quot;HKLM\SOFTWARE\CommVault Systems\Galaxy\xpath:{/workflow/instance/resultSets/row/col}\DM2WebSearchServer&quot; /f /v sZCACHEDATAFILESPATH /t REG_SZ /d xpath:{/workflow/newDM2CachePath/newDM2CachePath} &lt;/arguments>&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="ReadRegWSBaeDir" commented="0"

            originalStyle="" points="" sourceX="1069" sourceY="713"

            status="0" style="defaultEdge" targetX="1170" targetY="774"

            transitionIndex="0" x="-7" y="227">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1406033589510"

        description="executes queries against the commserv database"

        displayName="IM /Restore job check" height="34" interactive="0"

        name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=CommServDBQuery" uniqueName="runningJobCheck"

        waitSetting="0" width="177" x="702" y="193">

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>IF EXISTS (select * from JMJobInfo where opType = 64 and xmlJobInfo like ''%webServerClientName=&quot;xpath:{/workflow/SelectedWS/Webserver}%'')   --IM JOB&amp;#xD;&#xd;&#xa;OR EXISTS (select * from JMRstJobInfo where destClientId IN (select id from app_client where name =  ''xpath:{/workflow/SelectedWS/Webserver}%'')) -- Restore job&amp;#xD;&#xd;&#xa;BEGIN&amp;#xD;&#xd;&#xa;&#x9;SELECT 1&amp;#xD;&#xd;&#xa;END&amp;#xD;&#xd;&#xa;ELSE&amp;#xD;&#xd;&#xa;BEGIN&amp;#xD;&#xd;&#xa;&#x9;SELECT 0&amp;#xD;&#xd;&#xa;END&lt;/query>&lt;/inputs>"/>

        <transition activity="RunningJobCheck" commented="0"

            originalStyle="" points="" sourceX="783" sourceY="210"

            status="0" style="defaultEdge" targetX="812" targetY="317"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1406287404125"

        description="displays an informational message to the user"

        displayName="Successfully Move DM2Cache Directory" height="34"

        interactive="0" name="InformationalMessage"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=InformationalMessage;whiteSpace=wrap"

        uniqueName="SuccessMessage" waitSetting="0" width="200" x="1067" y="1406">

        <inputs val="&lt;inputs>&lt;message class=&quot;java.lang.String&quot;>Successfully move DM2 Cache directory from  [xpath:{/workflow/GetRegOldDM2CachePathValue/output}] to [xpath:{/workflow/newDM2CachePath/newDM2CachePath}] on Webserver [xpath:{/workflow/SelectedWS/Webserver}]&lt;/message>&lt;html class=&quot;java.lang.Boolean&quot; />&lt;dialogType class=&quot;commvault.msgs.Workflow.MessageDialogType&quot;>Popup&lt;/dialogType>&lt;iconType class=&quot;commvault.msgs.Workflow.MessageIconType&quot;>Information&lt;/iconType>&lt;title class=&quot;java.lang.String&quot;>Success&lt;/title>&lt;/inputs>"/>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1406895584114" description="Execute a list of commands"

        displayName="Read registry to get existing DM2 Cache Path"

        height="62" interactive="0" name="ExecuteCommand"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ExecuteCommand;whiteSpace=wrap"

        uniqueName="ReadRegOldDM2CachePath" waitSetting="0" width="200"

        x="216" y="408">

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/SelectedWS/Webserver}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; />&lt;command class=&quot;java.lang.String&quot;>reg&lt;/command>&lt;arguments class=&quot;java.lang.String&quot;>Query &quot;HKLM\SOFTWARE\CommVault Systems\Galaxy\xpath:{/workflow/instance/resultSets/row/col}\DM2WebSearchServer&quot; /v sZCACHEDATAFILESPATH &lt;/arguments>&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="GetRegOldDM2CachePathValue" commented="0"

            originalStyle="" points="" sourceX="409" sourceY="365"

            status="0" style="defaultEdge" targetX="151" targetY="492"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1406897831896"

        description="activity to execute code snippets in the selected language"

        displayName="Get Existing Dm2 Cache Direcotry" height="49"

        interactive="0" name="Script"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=Script;whiteSpace=wrap"

        uniqueName="GetRegOldDM2CachePathValue" waitSetting="0"

        width="200" x="219" y="521">

        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;String regValue=xpath:{/workflow/ReadRegOldDM2CachePath/commandOutput};&amp;#xD;&amp;#xA;int idx =regValue.indexOf(&amp;quot;REG_SZ&amp;quot;);&amp;#xD;&amp;#xA;String val=null;&amp;#xD;&amp;#xA;if ( idx &amp;gt;= 0 )&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;val=regValue.substring(idx+&amp;quot;REG_SZ&amp;quot;.length());&amp;#xD;&amp;#xA;val=val.trim();&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;val;&amp;#xD;&amp;#xA;&quot; />&lt;/inputs>"/>

        <transition activity="ReadRegCSBaseDir" commented="0"

            originalStyle="" points="" sourceX="105" sourceY="518"

            status="0" style="defaultEdge" targetX="119" targetY="604"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1406900680642"

        description="displays an informational message to the user"

        displayName="Failed to move Dm2 Cache Directory" height="64"

        interactive="0" name="InformationalMessage"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=InformationalMessage;whiteSpace=wrap"

        uniqueName="FailMessage" waitSetting="0" width="200" x="570" y="1066">

        <inputs val="&lt;inputs>&lt;message class=&quot;java.lang.String&quot;>Failed to move Dm2 Cache directory from  [xpath:{/workflow/GetRegOldDM2CachePathValue/output}] to [xpath:{/workflow/newDM2CachePath/newDM2CachePath}] on Webserver [xpath:{/workflow/SelectedWS/Webserver}]&lt;/message>&lt;html class=&quot;java.lang.Boolean&quot; />&lt;dialogType class=&quot;commvault.msgs.Workflow.MessageDialogType&quot;>Popup&lt;/dialogType>&lt;iconType class=&quot;commvault.msgs.Workflow.MessageIconType&quot;>Information&lt;/iconType>&lt;title class=&quot;java.lang.String&quot;>copy dir failed&lt;/title>&lt;/inputs>"/>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1407314927356" description="Execute a list of commands"

        displayName="Move DM2 Cache Directory" height="34"

        interactive="0" name="ExecuteCommand"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ExecuteCommand" uniqueName="MoveDir"

        waitSetting="0" width="200" x="208" y="821">

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>&lt;clientName />&lt;clientId />&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; />&lt;startUpPath class=&quot;java.lang.String&quot;>xpath:{/workflow/GetCSBaseDir/output}&lt;/startUpPath>&lt;command class=&quot;java.lang.String&quot;>MoveDDBClientCacheServer.exe&lt;/command>&lt;arguments class=&quot;java.lang.String&quot;>-sourceInstance xpath:{/workflow/instance/resultSets/row/col} -targetInstance  xpath:{/workflow/instance/resultSets/row/col}  -sourceClient xpath:{/workflow/SelectedWS/Webserver} -sourcePath xpath:{/workflow/GetRegOldDM2CachePathValue/output}  -targetClient xpath:{/workflow/SelectedWS/Webserver} -targetPath xpath:{/workflow/newDM2CachePath/newDM2CachePath}&lt;/arguments>&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="isMoveDirSuccess" commented="0"

            originalStyle="" points="" sourceX="308" sourceY="838"

            status="0" style="defaultEdge" targetX="590" targetY="728"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1409821481407" description="Execute a list of commands"

        displayName="Update Db Entries" height="34" interactive="0"

        name="ExecuteCommand"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ExecuteCommand"

        uniqueName="updateDM2dbEntries" waitSetting="0" width="149"

        x="1054" y="985">

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/SelectedWS/Webserver}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; />&lt;command class=&quot;java.lang.String&quot;>DM2DBOperation.exe&lt;/command>&lt;arguments class=&quot;java.lang.String&quot;>-I Instance001 -option UPDATE_CACHEPATH -oldCacheDir xpath:{/workflow/GetRegOldDM2CachePathValue/output}   -newCacheDir xpath:{/workflow/newDM2CachePath/newDM2CachePath}&lt;/arguments>&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="resetIIS" commented="0" originalStyle=""

            points="" sourceX="1129" sourceY="1017" status="0"

            style="defaultEdge" targetX="1156" targetY="1165"

            transitionIndex="0" x="-7" y="227">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1409821740889" description="Execute a list of commands"

        displayName="Read Registry to get Base directory" height="34"

        interactive="0" name="ExecuteCommand"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ExecuteCommand;whiteSpace=wrap"

        uniqueName="ReadRegWSBaeDir" waitSetting="0" width="200"

        x="1033" y="807">

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/SelectedWS/Webserver}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; />&lt;command class=&quot;java.lang.String&quot;>reg&lt;/command>&lt;arguments class=&quot;java.lang.String&quot;>Query &quot;HKLM\SOFTWARE\CommVault Systems\Galaxy\xpath:{/workflow/instance/resultSets/row/col}\Base&quot; /v dBASEHOME &lt;/arguments>&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="GetWSBaseDir" commented="0"

            originalStyle="" points="" sourceX="1125" sourceY="810"

            status="0" style="defaultEdge" targetX="1192" targetY="916"

            transitionIndex="0" x="-7" y="227">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1409821963500"

        description="activity to execute code snippets in the selected language"

        displayName="Get websever  Base Directory" height="34"

        interactive="0" name="Script"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=Script;whiteSpace=wrap"

        uniqueName="GetWSBaseDir" waitSetting="0" width="200" x="1036" y="894">

        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;String regValue=xpath:{/workflow/ReadRegWSBaeDir/commandOutput};&amp;#xD;&amp;#xA;int idx =regValue.indexOf(&amp;quot;REG_SZ&amp;quot;);&amp;#xD;&amp;#xA;String val=null;&amp;#xD;&amp;#xA;if ( idx &amp;gt;= 0 )&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;val=regValue.substring(idx+&amp;quot;REG_SZ&amp;quot;.length());&amp;#xD;&amp;#xA;val=val.trim();&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;val;&amp;#xD;&amp;#xA;&quot; />&lt;/inputs>"/>

        <transition activity="updateDM2dbEntries" commented="0"

            originalStyle="" points="" sourceX="1142" sourceY="916"

            status="0" style="defaultEdge" targetX="1162" targetY="1009"

            transitionIndex="0" x="-7" y="227">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1409841398153" description="Execute a list of commands"

        displayName="Read Registry to get Base directory" height="49"

        interactive="0" name="ExecuteCommand"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ExecuteCommand;whiteSpace=wrap"

        uniqueName="ReadRegCSBaseDir" waitSetting="0" width="200"

        x="212" y="620">

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>&lt;clientName class=&quot;java.lang.String&quot; />&lt;clientId class=&quot;java.lang.Integer&quot; />&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; />&lt;command class=&quot;java.lang.String&quot;>reg&lt;/command>&lt;arguments class=&quot;java.lang.String&quot;>Query &quot;HKLM\SOFTWARE\CommVault Systems\Galaxy\Instance001\Base&quot; /v dBASEHOME&lt;/arguments>&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="GetCSBaseDir" commented="0"

            originalStyle="" points="" sourceX="172" sourceY="611"

            status="0" style="defaultEdge" targetX="156" targetY="708"

            transitionIndex="0" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1409841404954"

        description="activity to execute code snippets in the selected language"

        displayName="Get CS  Base Directory" height="34" interactive="0"

        name="Script" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Script"

        uniqueName="GetCSBaseDir" waitSetting="0" width="200" x="209" y="721">

        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;String regValue=xpath:{/workflow/ReadRegCSBaseDir/commandOutput};&amp;#xD;&amp;#xA;int idx =regValue.indexOf(&amp;quot;REG_SZ&amp;quot;);&amp;#xD;&amp;#xA;String val=null;&amp;#xD;&amp;#xA;if ( idx &amp;gt;= 0 )&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;val=regValue.substring(idx+&amp;quot;REG_SZ&amp;quot;.length());&amp;#xD;&amp;#xA;val=val.trim();&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;val;&amp;#xD;&amp;#xA;&quot; />&lt;/inputs>"/>

        <transition activity="MoveDir" commented="0" originalStyle=""

            points="" sourceX="303" sourceY="644" status="0"

            style="defaultEdge" targetX="302" targetY="837"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1409841642435" description="Execute a list of commands"

        displayName="Reset IIS" height="34" interactive="0"

        name="ExecuteCommand"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ExecuteCommand" uniqueName="resetIIS"

        waitSetting="0" width="147" x="1056" y="1079">

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/SelectedWS/Webserver}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; />&lt;command class=&quot;java.lang.String&quot;>IISReset&lt;/command>&lt;arguments class=&quot;java.lang.String&quot; />&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="enablerestore" commented="0"

            originalStyle="" points="" sourceX="1142" sourceY="1130"

            status="0" style="defaultEdge" targetX="1144" targetY="1254"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1409841927459" description="Execute a list of commands"

        displayName="Remove new Directory" height="34" interactive="0"

        name="ExecuteCommand"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ExecuteCommand" uniqueName="remnewDir"

        waitSetting="0" width="181" x="566" y="839">

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/SelectedWS/Webserver}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; />&lt;command class=&quot;java.lang.String&quot;>rmdir&lt;/command>&lt;arguments class=&quot;java.lang.String&quot;>/S /Q xpath:{/workflow/newDM2CachePath/newDM2CachePath}&lt;/arguments>&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="EnableRestoreacivity" commented="0"

            originalStyle="" points="" sourceX="656" sourceY="856"

            status="0" style="defaultEdge" targetX="653" targetY="919"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1409898582384"

        description="executes queries against the commserv database"

        displayName="Get Instance" height="34" interactive="0"

        name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=CommServDBQuery" uniqueName="instance"

        waitSetting="0" width="162" x="230" y="238">

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>SELECT distinct attrVal&amp;#xD;&#xd;&#xa;&#x9;FROM APP_ClientProp  CP&amp;#xD;&#xd;&#xa;&#x9;&#x9;INNER JOIN APP_client C ON C.id = CP.ComponentnameId&amp;#xD;&#xd;&#xa;&#x9;WHERE C.name = ''xpath:{/workflow/SelectedWS/Webserver}'' AND  CP.attrName = ''Galaxy Instance name'' AND CP.modified =0&lt;/query>&lt;/inputs>"/>

        <transition activity="ExecuteCommand_11" commented="0"

            originalStyle="" points="" sourceX="293" sourceY="209"

            status="0" style="defaultEdge" targetX="286" targetY="274"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1409911882748" description="switch based decision"

        displayName="CheckIfJobsRunning" height="100" interactive="0"

        name="Switch" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="RunningJobCheck" waitSetting="0" width="164" x="694" y="286">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/runningJobCheck/resultSets/row/col}&lt;/expression>&lt;/inputs>"/>

        <transition activity="MessageJobRunning" commented="0"

            displayName="Found IM Job running" originalStyle=""

            points="" sourceX="808" sourceY="338" status="0"

            style="defaultEdge" targetX="975" targetY="262"

            transitionIndex="0" value="1" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="DM2PruneCheck" commented="0"

            displayName="IM job not running" originalStyle="" points=""

            sourceX="769" sourceY="361" status="0" style="defaultEdge"

            targetX="769" targetY="458" transitionIndex="0" value="0"

            x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1409913159735" description="switch based decision"

        displayName="Is Success?" height="100" interactive="0"

        name="Switch" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="isMoveDirSuccess" waitSetting="0" width="107"

        x="583" y="681">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/MoveDir/errorCode}&lt;/expression>&lt;/inputs>"/>

        <transition activity="remnewDir" commented="0"

            displayName="fail" originalStyle="" points="" sourceX="633"

            sourceY="731" status="0" style="defaultEdge" targetX="640"

            targetY="852" transitionIndex="0" value=">0" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="UpdateWSRegNewCachePach" commented="0"

            displayName="Success" originalStyle="" points=""

            sourceX="636" sourceY="731" status="0" style="defaultEdge"

            targetX="1081" targetY="730" transitionIndex="0" value="0"

            x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1409916306726"

        description="executes queries against the commserv database"

        displayName="Audit" height="34" interactive="0"

        name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=CommServDBQuery" uniqueName="AuditSuccess"

        waitSetting="0" width="162" x="1067" y="1339">

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>DECLARE @opEvMsgId          INT&amp;#xD;&#xd;&#xa;&#x9;DECLARE @opId               INT&amp;#xD;&#xd;&#xa;&#x9;DECLARE  @opMsgId&#x9;&#x9;&#x9;INT = (440 | (CAST(POWER(2, 24) AS BIGINT) * 84))  ----GUIAUDIT_OPS_DM2_CACHE_DIR_MOVE -- Move DM2 Cache Directory&amp;#xD;&#xd;&#xa;&#x9;DECLARE  @paramMsgId &#x9;&#x9;INT = (1158 | (CAST(POWER(2, 24) AS BIGINT) * 85))  ---- GUIAUDIT_PARAMS_DM2_CACHE_DIR_MOVE  -- DM2 Cache Directory is moved from [] to [] on Webserver []&amp;#xD;&#xd;&#xa;&#x9;EXEC EvGuiAuditSetOperation @opMsgId, xpath:{/workflow/system/executor/userId}, @opEvMsgId OUTPUT, @opId OUTPUT&amp;#xD;&#xd;&#xa;&#x9;-- SET GUI AUDIT PARAMETER&amp;#xD;&#xd;&#xa;&#x9;EXEC EvGuiAuditSetParamData @opId, ''xpath:{/workflow/GetRegOldDM2CachePathValue/output}'', 0&amp;#xD;&#xd;&#xa;&#x9;EXEC EvGuiAuditSetParamData @opId, ''xpath:{/workflow/newDM2CachePath/newDM2CachePath}'', 0&amp;#xD;&#xd;&#xa;&#x9;EXEC EvGuiAuditSetParamData @opId, ''xpath:{/workflow/SelectedWS/Webserver}'', 0&amp;#xD;&#xd;&#xa;&#x9;EXEC EvGuiAuditSetParameter @opId, @paramMsgId, xpath:{/workflow/system/executor/userId}&lt;/query>&lt;/inputs>"/>

        <transition activity="SuccessMessage" commented="0"

            originalStyle="" points="" sourceX="1164" sourceY="1362"

            status="0" style="defaultEdge" targetX="1160" targetY="1416"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1410978191222" description="Execute a list of commands"

        displayName="DM2Cache pruining check" height="34"

        interactive="0" name="ExecuteCommand"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ExecuteCommand;whiteSpace=wrap"

        uniqueName="DM2PruneCheck" waitSetting="0" width="200" x="696" y="442">

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>&lt;clientName class=&quot;java.lang.String&quot; />&lt;clientId class=&quot;java.lang.Integer&quot; />&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; />&lt;command class=&quot;java.lang.String&quot;>TASKLIST&lt;/command>&lt;arguments class=&quot;java.lang.String&quot; />&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="PruneUtilityRunning" commented="0"

            originalStyle="" points="" sourceX="796" sourceY="459"

            status="0" style="defaultEdge" targetX="780" targetY="531"

            transitionIndex="0" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1410978463683"

        description="activity to execute code snippets in the selected language"

        displayName="GetProcessName" height="34" interactive="0"

        name="Script" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Script"

        uniqueName="PruneUtilityRunning" waitSetting="0" width="143"

        x="709" y="514">

        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;String ProcessList=xpath:{/workflow/DM2PruneCheck/commandOutput};&amp;#xD;&amp;#xA;int idx =ProcessList.indexOf(&amp;quot;PruneDM2Cache&amp;quot;);&amp;#xD;&amp;#xA;if(idx &amp;gt; 0)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;idx=1;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;else&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;idx=0;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;idx;&quot; />&lt;/inputs>"/>

        <transition activity="isPruneJobRunning" commented="0"

            originalStyle="" points="" sourceX="780" sourceY="531"

            status="0" style="defaultEdge" targetX="779" targetY="626"

            transitionIndex="0" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1410978721235" description="switch based decision"

        displayName="isDM2PruningRunning" height="100" interactive="0"

        name="Switch" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="isPruneJobRunning" waitSetting="0" width="175"

        x="692" y="576">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/PruneUtilityRunning/output}&lt;/expression>&lt;/inputs>"/>

        <transition activity="PruneJobisRunning" commented="0"

            displayName="Found Prunig job" originalStyle="" points=""

            sourceX="779" sourceY="626" status="0" style="defaultEdge"

            targetX="1185" targetY="556" transitionIndex="0" value="1"

            x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="DisableRestore" commented="0"

            displayName="prune job not running" originalStyle=""

            points="" sourceX="779" sourceY="626" status="0"

            style="defaultEdge" targetX="392" targetY="142"

            transitionIndex="0" value="0" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1410978984738"

        description="displays an informational message to the user"

        displayName="DM2 Pruning job is in progress.&#xa;Please wait for job completion and try again."

        height="66" interactive="0" name="InformationalMessage"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=InformationalMessage"

        uniqueName="PruneJobisRunning" waitSetting="0" width="370"

        x="1000" y="523">

        <inputs val="&lt;inputs>&lt;message class=&quot;java.lang.String&quot;>Information Management Job is running on the webserver [xpath:{/workflow/SelectedWS/Webserver}]. Please wait for job completion and try again.&lt;/message>&lt;html class=&quot;java.lang.Boolean&quot; />&lt;dialogType class=&quot;commvault.msgs.Workflow.MessageDialogType&quot;>Popup&lt;/dialogType>&lt;iconType class=&quot;commvault.msgs.Workflow.MessageIconType&quot;>Information&lt;/iconType>&lt;title class=&quot;java.lang.String&quot;>IM job running.&lt;/title>&lt;/inputs>"/>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1410979802056"

        description="executes queries against the commserv database"

        displayName="Disable Restore Activity on WS" height="34"

        interactive="0" name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=CommServDBQuery;whiteSpace=wrap"

        uniqueName="DisableRestore" waitSetting="0" width="200" x="214" y="182">

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>UPDATE JMJobAction&amp;#xD;&#xd;&#xa;SET action =1&amp;#xD;&#xd;&#xa;WHERE appType = 0 AND opType = 5 AND clientId = (SELECT id from APP_client WITH (NOLOCK) WHERE name =''xpath:{/workflow/SelectedWS/Webserver}'')&amp;#xD;&#xd;&#xa; &lt;/query>&lt;/inputs>"/>

        <transition activity="instance" commented="0" originalStyle=""

            points="" sourceX="322" sourceY="148" status="0"

            style="defaultEdge" targetX="303" targetY="210"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1410980141837"

        description="executes queries against the commserv database"

        displayName="Enable Restore Activity" height="34"

        interactive="0" name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=CommServDBQuery"

        uniqueName="EnableRestoreacivity" waitSetting="0" width="183"

        x="567" y="920">

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>UPDATE JMJobAction&amp;#xD;&#xd;&#xa;SET action =1&amp;#xD;&#xd;&#xa;WHERE appType = 0 AND opType = 5 AND clientId = (SELECT id from APP_client WITH (NOLOCK) WHERE name =''xpath:{/workflow/SelectedWS/Webserver}'')&amp;#xD;&#xd;&#xa; &lt;/query>&lt;/inputs>"/>

        <transition activity="EnablePrune" commented="0"

            originalStyle="" points="" sourceX="667" sourceY="940"

            status="0" style="defaultEdge" targetX="676" targetY="1000"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1410980198662"

        description="executes queries against the commserv database"

        displayName="Enable Restore Activity" height="34"

        interactive="0" name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=CommServDBQuery" uniqueName="enablerestore"

        waitSetting="0" width="183" x="1053" y="1180">

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>UPDATE JMJobAction&amp;#xD;&#xd;&#xa;SET action =1&amp;#xD;&#xd;&#xa;WHERE appType = 0 AND opType = 5 AND clientId = (SELECT id from APP_client WITH (NOLOCK) WHERE name =''xpath:{/workflow/SelectedWS/Webserver}'')&amp;#xD;&#xd;&#xa; &lt;/query>&lt;/inputs>"/>

        <transition activity="enableprune" commented="0"

            originalStyle="" points="" sourceX="1154" sourceY="1257"

            status="0" style="defaultEdge" targetX="1160" targetY="1309"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1410980811049" description="Execute a list of commands"

        displayName="Disable Dm2 Cache Pruning" height="34"

        interactive="0" name="ExecuteCommand"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ExecuteCommand"

        uniqueName="ExecuteCommand_11" waitSetting="0" width="200"

        x="217" y="312">

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/SelectedWS/Webserver}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; />&lt;command class=&quot;java.lang.String&quot;>reg&lt;/command>&lt;arguments class=&quot;java.lang.String&quot;>ADD  &quot;HKLM\SOFTWARE\CommVault Systems\Galaxy\xpath:{/workflow/instance/resultSets/row/col}\DM2WebSearchServer&quot; /v disableDM2OrphanFileCleanup /t REG_DWORD /d 1 /f&lt;/arguments>&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="ReadRegOldDM2CachePath" commented="0"

            originalStyle="" points="" sourceX="288" sourceY="277"

            status="0" style="defaultEdge" targetX="285" targetY="355"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1410980986189" description="Execute a list of commands"

        displayName="Enable Dm2 Cache Pruning" height="34"

        interactive="0" name="ExecuteCommand"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ExecuteCommand" uniqueName="EnablePrune"

        waitSetting="0" width="200" x="573" y="986">

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/SelectedWS/Webserver}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; />&lt;command class=&quot;java.lang.String&quot;>reg&lt;/command>&lt;arguments class=&quot;java.lang.String&quot;>ADD  &quot;HKLM\SOFTWARE\CommVault Systems\Galaxy\xpath:{/workflow/instance/resultSets/row/col}\DM2WebSearchServer&quot; /v disableDM2OrphanFileCleanup /t REG_DWORD /d 0 /f&lt;/arguments>&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="FailMessage" commented="0"

            originalStyle="" points="" sourceX="695" sourceY="995"

            status="0" style="defaultEdge" targetX="690" targetY="1093"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1410981035739" description="Execute a list of commands"

        displayName="Enable Dm2 Cache Pruning" height="34"

        interactive="0" name="ExecuteCommand"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ExecuteCommand" uniqueName="enableprune"

        waitSetting="0" width="200" x="1046" y="1260">

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/SelectedWS/Webserver}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; />&lt;command class=&quot;java.lang.String&quot;>reg&lt;/command>&lt;arguments class=&quot;java.lang.String&quot;>ADD  &quot;HKLM\SOFTWARE\CommVault Systems\Galaxy\xpath:{/workflow/instance/resultSets/row/col}\DM2WebSearchServer&quot; /v disableDM2OrphanFileCleanup /t REG_DWORD /d 0 /f&lt;/arguments>&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="AuditSuccess" commented="0"

            originalStyle="" points="" sourceX="1159" sourceY="1313"

            status="0" style="defaultEdge" targetX="1162" targetY="1359"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <schema>

        <inputs attribute="0" className="" listType="0" name="inputs"

            required="1" type=""/>

        <variables attribute="0" className="" listType="0"

            name="variables" required="1" type=""/>

        <outputs attribute="0" className="" listType="0" name="outputs"

            required="1" type=""/>

    </schema>

</workflow>'

IF not exists (select * from WF_Definition where Name = @name)

BEGIN
	INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision)


	VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision)

	SET @workflowId = @@IDENTITY
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


	VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

	SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = ISNULL(revision, '') From WF_Definition WHERE Name = @name

	IF (@currentFlags & 4 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0) AND (@currentRevision <> @revision)

	BEGIN

		SET @version = @version + 1

		UPDATE WF_Definition

		SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision

		WHERE Name = @name

		IF (@flags & 8 > 0 OR @flags & 16 > 0)

		BEGIN

			UPDATE WF_Definition

			SET flags = @flags

			WHERE Name = @name

		END
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


		VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

	END

END


