

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_DDBSeeding.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/WFD_DDBSeeding.script,v $ $Id: WFD_DDBSeeding.script,v 1.5 2015/06/05 16:35:47 csunderland Exp $";
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER OFF

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.5 $'

SET @name = 'DDB Seeding'

SET @description = 'DDB Seeding allows you to transfer initial baseline backup between two sites using easily available removable disks such as USB disks. In order to execute this workflow user needs to provide name of Storage Policy to be seeded, Global deduplication Policy and Path of USB Drive. More info can be found at http://documentation.commvault.com/commvault/release_10_0_0/books_online_1/english_us/prod_info/workflow.htm?var1=http://documentation.commvault.com/commvault/release_10_0_0/books_online_1/english_us/features/workflow/templates/set_global_property.htm'

SET @version = 1

SET @flags = 6

SET @definition = '<workflow apiMode="0"

    description="DDB Seeding allows you to transfer initial baseline backup between two sites using easily available removable disks such as USB disks. In order to execute this workflow user needs to provide name of Storage Policy to be seeded, Global deduplication Policy and Path of USB Drive. More info can be found at http://documentation.commvault.com/commvault/release_10_0_0/books_online_1/english_us/prod_info/workflow.htm?var1=http://documentation.commvault.com/commvault/release_10_0_0/books_online_1/english_us/features/workflow/templates/set_global_property.htm"

    inputs="&lt;inputs>&lt;LibraryPath class=&quot;java.lang.String&quot; />&lt;StoragePolicyToSeed class=&quot;commvault.msgs.CvEntities.StoragePolicyEntity&quot;>&lt;storagePolicyName class=&quot;java.lang.String&quot; />&lt;storagePolicyId class=&quot;java.lang.Integer&quot; />&lt;/StoragePolicyToSeed>&lt;GDSPName class=&quot;commvault.msgs.CvEntities.StoragePolicyEntity&quot;>&lt;storagePolicyName class=&quot;java.lang.String&quot; />&lt;storagePolicyId class=&quot;java.lang.Integer&quot; />&lt;/GDSPName>&lt;skipSourceSideOperation class=&quot;java.lang.Boolean&quot;>false&lt;/skipSourceSideOperation>&lt;/inputs>"

    interactive="0" name="DDB Seeding" outputs="&lt;outputs />"

    variables="&lt;variables>&lt;copyName class=&quot;java.lang.String&quot;>copytogdsp&lt;/copyName>&lt;newSourceCopy class=&quot;java.lang.String&quot;>usbcopy&lt;/newSourceCopy>&lt;backupJobs class=&quot;java.lang.Integer&quot; _list_=&quot;true&quot; />&lt;GDSPMA class=&quot;java.lang.String&quot; />&lt;LocalMA class=&quot;java.lang.String&quot; />&lt;GDSPMediaAgent class=&quot;java.lang.String&quot; />&lt;GDSPLibrary class=&quot;java.lang.String&quot; />&lt;sharedLibrary class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/StoragePolicyToSeed/storagePolicyName}_TempDashSeedLibrary&lt;/sharedLibrary>&lt;sourceInstance class=&quot;java.lang.String&quot; />&lt;targetInstance class=&quot;java.lang.String&quot; />&lt;destPath class=&quot;java.lang.String&quot; />&lt;sourcePath class=&quot;java.lang.String&quot; />&lt;destHostName class=&quot;java.lang.String&quot; />&lt;pathSimpana class=&quot;java.lang.String&quot; />&lt;dcmaList class=&quot;java.lang.String&quot; />&lt;/variables>" workflowId="0">

    <Start breakpoint="0" commented="0" continueOnFailure="0"

        created="0" description="" displayName="Start" height="34"

        interactive="0" name="Start" originalStyle="" skipAttempt="0"

        style="image;image=/images/jgraphx/house.png"

        uniqueName="Start_1" waitSetting="0" width="61" x="83" y="33">

        <inputs val="&lt;inputs />"/>

        <transition activity="Script_2" commented="0" originalStyle=""

            points="" sourceX="32" sourceY="42" status="0"

            style="defaultEdge" targetX="154" targetY="50"

            transitionIndex="0" x="-43" y="-17">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Start>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1329165635226"

        description="activity to execute code snippets in the selected language"

        displayName="GDSP MA" height="34" interactive="0" name="Script"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Script"

        uniqueName="Script_2" waitSetting="0" width="114" x="63" y="195">

        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;String storagePolicy = xpath:{/workflow/inputs/GDSPName}.getStoragePolicyName();&amp;#xA;String ma_name;&amp;#xA;StringBuffer sb = new StringBuffer();&amp;#xA;int i=0;&amp;#xA;&amp;#xA;String sql = &amp;quot;Select name,jobResultDir from APP_Client where id in (select HostClientId from MMDataPath where CopyId in ( select id from archGroupCopy where name like ''%Primary%'' and archGroupId in ( select id from archGroup where name = ''&amp;quot; + storagePolicy + &amp;quot;'')))&amp;quot;;&amp;#xA;&amp;#xA;DataSet rs = csdb.execute(sql);&amp;#xA;if (rs.hasNext()) {&amp;#xA;   workflow.setVariable(&amp;quot;GDSPMA&amp;quot;, rs.get(&amp;quot;name&amp;quot;));&amp;#xA;   ma_name =  rs.get(&amp;quot;name&amp;quot;);&amp;#xA;}&amp;#xA;&amp;#xA;DataSet rs = csdb.execute(sql);&amp;#xA;while (rs.hasNext()) {&amp;#xA;   if (i&amp;gt;0) sb.append(&amp;quot;,&amp;quot;);&amp;#xA;                sb.append(rs.get(&amp;quot;name&amp;quot;));&amp;#xA;                i++;&amp;#xA;}&amp;#xA;&amp;#xA;workflow.setVariable(&amp;quot;dcmaList&amp;quot;, sb.toString());&amp;#xA;&amp;#xA;String sql = &amp;quot;SELECT install_dir FROM APP_Platform WHERE clientId = 2 AND platformType = 1&amp;quot;;&amp;#xA;DataSet rs = csdb.execute(sql);&amp;#xA;if (rs.hasNext()) {&amp;#xA;   workflow.setVariable(&amp;quot;pathSimpana&amp;quot;, rs.get(&amp;quot;install_dir&amp;quot;));&amp;#xA;}&amp;#xA;&amp;#xA;String sql = &amp;quot;select attrVal from APP_ClientProp where attrName = ''Galaxy Instance name'' and componentNameId in (select id from APP_Client where name = ''&amp;quot;+ma_name+&amp;quot;'' )&amp;quot;;&amp;#xA;DataSet rs = csdb.execute(sql);&amp;#xA;if (rs.hasNext()) {&amp;#xA;   workflow.setVariable(&amp;quot;sourceInstance&amp;quot;, rs.get(&amp;quot;attrVal&amp;quot;));&amp;#xA;}&amp;#xA;&quot; />&lt;/inputs>"/>

        <transition activity="Script_3" commented="0" originalStyle=""

            points="" sourceX="196" sourceY="51" status="0"

            style="defaultEdge" targetX="190" targetY="120"

            transitionIndex="0" x="-43" y="-17">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1329165886958"

        description="activity to execute code snippets in the selected language"

        displayName="Local MA" height="34" interactive="0" name="Script"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Script"

        uniqueName="Script_3" waitSetting="0" width="108" x="61" y="305">

        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;String storagePolicy = xpath:{/workflow/inputs/StoragePolicyToSeed}.getStoragePolicyName();&amp;#xA;String ma_name;&amp;#xA;&amp;#xA;String sql = &amp;quot;Select name,jobResultDir from APP_Client where id in (select HostClientId from MMDataPath where CopyId in ( select id from archGroupCopy where name like ''%Primary%'' and archGroupId in ( select id from archGroup where name = ''&amp;quot; + storagePolicy + &amp;quot;'')))&amp;quot;;&amp;#xA;&amp;#xA;DataSet rs = csdb.execute(sql);&amp;#xA;if (rs.hasNext()) {&amp;#xA;   workflow.setVariable(&amp;quot;LocalMA&amp;quot;, rs.get(&amp;quot;name&amp;quot;));&amp;#xA;   ma_name =  rs.get(&amp;quot;name&amp;quot;);&amp;#xA;}&amp;#xA;&amp;#xA;&amp;#xA;String sql = &amp;quot;select attrVal from APP_ClientProp where attrName = ''Galaxy Instance name'' and componentNameId in (select id from APP_Client where name = ''&amp;quot;+ma_name+&amp;quot;'')&amp;quot;;&amp;#xA;&amp;#xA;DataSet rs = csdb.execute(sql);&amp;#xA;if (rs.hasNext()) {&amp;#xA;   workflow.setVariable(&amp;quot;targetInstance&amp;quot;, rs.get(&amp;quot;attrVal&amp;quot;));&amp;#xA;}&quot; />&lt;/inputs>"/>

        <transition activity="Decision_2" commented="0" originalStyle=""

            points="" sourceX="196" sourceY="171" status="0"

            style="defaultEdge" targetX="196" targetY="466"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1371670139480" description="if/else based decision"

        displayName="Skip SourceSide Operation?" height="100"

        interactive="0" name="Decision"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_2" waitSetting="0" width="200" x="17" y="429">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/skipSourceSideOperation}==true&lt;/expression>&lt;/inputs>"/>

        <transition activity="ProcessBlock_1" commented="0"

            displayName="No" originalStyle="" points="" sourceX="196"

            sourceY="330" status="0" style="defaultEdge" targetX="928"

            targetY="213" transitionIndex="0" value="false" x="-43" y="-17">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="ProcessBlock_2" commented="0"

            displayName="Yes" originalStyle="" points="" sourceX="196"

            sourceY="330" status="0" style="defaultEdge" targetX="454"

            targetY="446" transitionIndex="0" value="true" x="-43" y="-17">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="1"

        created="1371741556831"

        description="creates a super process group"

        displayName="Source Side Operation" height="691" interactive="0"

        maxRestarts="1" name="ProcessBlock"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ProcessBlock_1" waitSetting="0" width="945" x="528" y="17">

        <activitySchema>

            <inputs attribute="0" listType="0" name="inputs" required="1"/>

            <outputs attribute="0" listType="0" name="outputs" required="1"/>

        </activitySchema>

        <inputs val="&lt;inputs>&lt;inputs />&lt;/inputs>"/>

        <transition activity="ProcessBlock_3" commented="0"

            displayName="Failed" originalStyle="" points=""

            sourceX="928" sourceY="213" status="2" style="defaultEdge"

            targetX="1631" targetY="164" transitionIndex="0" x="-43" y="-17">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="ProcessBlock_2" commented="0"

            displayName="Success" originalStyle="" points=""

            sourceX="943" sourceY="708" status="1" style="defaultEdge"

            targetX="943" targetY="831" transitionIndex="0" x="-43" y="-17">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <superProcess>

            <Start breakpoint="0" commented="0" continueOnFailure="0"

                created="1371741556831" description=""

                displayName="Start" height="30" interactive="0"

                name="Start" originalStyle="" skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_2" waitSetting="0" width="120" x="12" y="68">

                <inputs val="&lt;inputs />"/>

                <transition activity="CommServDBQuery_4" commented="0"

                    originalStyle="" points="" sourceX="77" sourceY="50"

                    status="0" style="defaultEdge" targetX="202"

                    targetY="58" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity breakpoint="0" commented="0" continueOnFailure="1"

                created="1366055217871"

                description="Execute a list of commands"

                displayName="Create Shared Library" height="34"

                interactive="0" name="ExecuteCommand"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=ExecuteCommand"

                uniqueName="ExecuteCommand_2" waitSetting="0"

                width="177" x="711" y="64">

                <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>&lt;clientName />&lt;clientId>0&lt;/clientId>&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; />&lt;startUpPath class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/pathSimpana}\Base&lt;/startUpPath>&lt;command class=&quot;java.lang.String&quot;>ScanScsiTool.exe&lt;/command>&lt;arguments class=&quot;java.lang.String&quot;>-h xpath:{/workflow/variables/LocalMA},xpath:{/workflow/variables/dcmaList} -a xpath:{/workflow/variables/sharedLibrary} -f  xpath:{/workflow/inputs/LibraryPath}&lt;/arguments>&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

                <transition activity="CommServDBQuery_5" commented="0"

                    originalStyle="" points="" sourceX="733"

                    sourceY="75" status="0" style="defaultEdge"

                    targetX="640" targetY="207" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1329167718565" description=""

                displayName="CreateSPCopy" height="34" interactive="0"

                name="SPCopy"

                namespaceUri="commvault.cte.workflow.activities.cmd.create"

                originalStyle="" skipAttempt="0"

                style="label;image=CreateSPCopy"

                uniqueName="CreateSPCopy_2" waitSetting="0" width="125"

                x="742" y="434">

                <inputs val="&lt;inputs>&lt;storagePolicy class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/StoragePolicyToSeed}&lt;/storagePolicy>&lt;copy class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/newSourceCopy}&lt;/copy>&lt;mediaAgent class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/LocalMA}&lt;/mediaAgent>&lt;library class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/sharedLibrary}&lt;/library>&lt;drivePool class=&quot;java.lang.String&quot; />&lt;scratchPool class=&quot;java.lang.String&quot; />&lt;dedupPath class=&quot;java.lang.String&quot;>C:\SIDB_xpath:{/workflow/system/jobId}_xpath:{/workflow/inputs/StoragePolicyToSeed}_xpath:{/workflow/variables/copyName}&lt;/dedupPath>&lt;encryptData class=&quot;workflow.types.cmd.Answer&quot;>no&lt;/encryptData>&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

                <transition activity="CommServDBQuery_1" commented="0"

                    originalStyle="" points="" sourceX="525"

                    sourceY="50" status="0" style="defaultEdge"

                    targetX="952" targetY="58" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1329173758241"

                description="executes queries against the commserv database"

                displayName="Get Subclients" height="34" interactive="0"

                name="CommServDBQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=CommServDBQuery"

                uniqueName="CommServDBQuery_1" waitSetting="0"

                width="125" x="538" y="356">

                <inputs val="&lt;inputs>&lt;commCell>&lt;/commCell>&lt;query>declare @storagePolicy AS VARCHAR(255)&amp;#xD;&#xd;&#xa;set @storagePolicy = ''xpath:{/workflow/inputs/StoragePolicyToSeed/storagePolicyName}'';&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;declare @spid int&amp;#xD;&#xd;&#xa;Select @spid = id From archGroup with(NOLOCK) Where name = @storagePolicy;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;exec archGroupAssociatedClients @spid&lt;/query>&lt;/inputs>"/>

                <transition activity="ForEach_1" commented="0"

                    originalStyle="" points="" sourceX="999"

                    sourceY="48" status="0" style="defaultEdge"

                    targetX="750" targetY="115" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1328644368366"

                description="repeats until job completes"

                displayName="WaitForJobCompletion" height="34"

                interactive="0" name="WaitForJobCompletion"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=WaitForJobCompletion"

                uniqueName="WaitForJobCompletion_1" waitSetting="0"

                width="180" x="36" y="621">

                <inputs val="&lt;inputs>&lt;jobId class=&quot;java.lang.Integer&quot;>xpath:{/workflow/variables/backupJobs}&lt;/jobId>&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

                <transition activity="AuxCopy_1" commented="0"

                    originalStyle="" points="" sourceX="161"

                    sourceY="121" status="0" style="defaultEdge"

                    targetX="156" targetY="187" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1357772157026" description=""

                displayName="OperationAuxCopy" height="34"

                interactive="0" name="AuxCopy"

                namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                originalStyle="" skipAttempt="0"

                style="label;image=OperationAuxCopy"

                uniqueName="AuxCopy_1" waitSetting="0" width="154"

                x="285" y="621">

                <inputs val="&lt;inputs>&lt;storagePolicy class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/StoragePolicyToSeed}&lt;/storagePolicy>&lt;copy class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/newSourceCopy}&lt;/copy>&lt;argumentFilepath class=&quot;java.lang.String&quot; />&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

                <transition activity="WaitForJobCompletion_3"

                    commented="0" originalStyle="" points=""

                    sourceX="166" sourceY="197" status="0"

                    style="defaultEdge" targetX="167" targetY="261"

                    transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1357772545133"

                description="waits until the list of jobs completes"

                displayName="WaitForJobCompletion" height="34"

                interactive="0" name="WaitForJobCompletion"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=WaitForJobCompletion"

                uniqueName="WaitForJobCompletion_3" waitSetting="0"

                width="180" x="504" y="621">

                <inputs val="&lt;inputs>&lt;jobId class=&quot;java.lang.Integer&quot;>xpath:{/workflow/AuxCopy_1/jobId}&lt;/jobId>&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

                <transition activity="SuspendWorkflow_1" commented="0"

                    originalStyle="" points="" sourceX="172"

                    sourceY="264" status="0" style="defaultEdge"

                    targetX="168" targetY="336" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1329165494080"

                description="suspends execution of the workflow"

                displayName="SuspendWorkflow" height="34"

                interactive="0" name="SuspendWorkflow"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=SuspendWorkflow"

                uniqueName="SuspendWorkflow_1" waitSetting="0"

                width="151" x="763" y="621">

                <inputs val="&lt;inputs>&lt;reason class=&quot;java.lang.String&quot;>Please plug in the USB  on any of these MediaAgent [xpath:{/workflow/variables/dcmaList}], you will get an option to select MediaAgent to be used for AuxCopy later in the job. Please  Resume the job to continue&lt;/reason>&lt;/inputs>"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1371750760924"

                description="iterates a group of activities over a list of values"

                displayName="ForEach" height="272" interactive="0"

                name="ForEach"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0" style="swimlane"

                uniqueName="ForEach_1" waitSetting="0" width="459"

                x="24" y="237">

                <activitySchema>

                    <inputs>

                        <children className="java.lang.String"

                            inputType="java.lang.String" name="name" type="{http://www.w3.org/2001/XMLSchema}string"/>

                        <children className="java.lang.Object"

                            inputType="java.lang.Object" name="values" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                        <children className="java.lang.Integer"

                            defaultValue="1"

                            inputType="java.lang.Integer"

                            name="numberOfParallelExecutions" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                        <children className="java.lang.Boolean"

                            defaultValue="false"

                            inputType="java.lang.Boolean"

                            name="continueOnFailure" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                    </inputs>

                    <outputs name="outputs">

                        <children

                            className="workflow.types.data.DataRow"

                            inputType="workflow.types.data.DataRow"

                            listType="0" name="row" type="{workflow.types.data}DataRow">

                            <children className="java.lang.Object"

                                inputType="java.lang.Object"

                                listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                        </children>

                    </outputs>

                </activitySchema>

                <inputs val="&lt;inputs>&lt;name class=&quot;java.lang.String&quot;>row&lt;/name>&lt;values class=&quot;java.lang.Object&quot;>xpath:{/workflow/CommServDBQuery_1/resultSets/row}&lt;/values>&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot;>1&lt;/numberOfParallelExecutions>&lt;continueOnFailure class=&quot;java.lang.Boolean&quot;>false&lt;/continueOnFailure>&lt;/inputs>"/>

                <transition activity="WaitForJobCompletion_1"

                    commented="0" originalStyle="" points=""

                    sourceX="537" sourceY="227" status="0"

                    style="defaultEdge" targetX="231" targetY="119"

                    transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <superProcess>

                    <Start breakpoint="0" commented="0"

                        continueOnFailure="0" created="1371750760924"

                        description="" displayName="Start" height="30"

                        interactive="0" name="Start" originalStyle=""

                        skipAttempt="0"

                        style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                        uniqueName="Start_8" waitSetting="0" width="120"

                        x="18" y="30">

                        <inputs val="&lt;inputs />"/>

                        <transition activity="Execute_1" commented="0"

                            originalStyle="" points="" sourceX="78"

                            sourceY="45" status="0" style="defaultEdge"

                            targetX="87" targetY="98"

                            transitionIndex="0" x="0" y="0">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Start>

                    <Activity breakpoint="0" commented="0"

                        continueOnFailure="1" created="1362673946334"

                        description="" displayName="Backup" height="34"

                        interactive="0" maxRestarts="0" name="Execute"

                        namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                        originalStyle="" skipAttempt="0"

                        style="label;image=Execute"

                        uniqueName="Execute_1" waitSetting="0"

                        width="105" x="31" y="86">

                        <onExit language="1" script="if (activity.exitCode == 0)&#xd;&#xa;{&#xd;&#xa;    if (activity.outputXml != null &amp;&amp; activity.outputXml.length() > 0)&#xd;&#xa;    {&#xd;&#xa;        XML response = utils.parseXml(activity.outputXml);&#xd;&#xa;        if (response.getName().equals(&quot;TMMsg_GenericResp&quot;))&#xd;&#xa;        {&#xd;&#xa;            activity.exitCode = Integer.parseInt(response.selectSingleNode(&quot;string(/TMMsg_GenericResp/@errorCode)&quot;));&#xd;&#xa;            activity.commandOutput = response.selectSingleNode(&quot;string(/TMMsg_GenericResp/@errorMessage)&quot;);&#xd;&#xa;        }&#xd;&#xa;    } &#xd;&#xa;    else &#xd;&#xa;    {&#xd;&#xa;        activity.exitCode = -1;&#xd;&#xa;        activity.commandOutput = &quot;failed to retrieve xml response&quot;;&#xd;&#xa;    }&#xd;&#xa;}"/>

                        <inputs val="&lt;inputs>&lt;inputXml class=&quot;java.lang.String&quot;>&amp;lt;TMMsg_CreateTaskReq&amp;gt;&amp;#xD; &amp;#xD;   &amp;lt;taskInfo&amp;gt;&amp;#xD;     &amp;lt;associations&amp;gt;&amp;#xD;       &amp;lt;appName&amp;gt;xpath:{/workflow/ForEach_1/row/col[@name=&quot;appTypeName&quot;]}&amp;lt;/appName&amp;gt;&amp;#xD;       &amp;lt;backupsetName&amp;gt;xpath:{/workflow/ForEach_1/row/col[@name=&quot;backupSetName&quot;]}&amp;lt;/backupsetName&amp;gt;&amp;#xD;       &amp;lt;clientName&amp;gt;xpath:{/workflow/ForEach_1/row/col[@name=&quot;clientName&quot;]}&amp;lt;/clientName&amp;gt;&amp;#xD;       &amp;lt;instanceName&amp;gt;xpath:{/workflow/ForEach_1/row/col[@name=&quot;instanceName&quot;]}&amp;lt;/instanceName&amp;gt;&amp;#xD;       &amp;lt;subclientName&amp;gt;xpath:{/workflow/ForEach_1/row/col[@name=&quot;subclientName&quot;]}&amp;lt;/subclientName&amp;gt;&amp;#xD;     &amp;lt;/associations&amp;gt;&amp;#xD;     &amp;lt;subTasks&amp;gt;&amp;#xD;       &amp;lt;options originalJobId=&quot;xpath:{/workflow/system/jobId}&quot;&amp;gt;&amp;#xD;         &amp;lt;backupOpts&amp;gt;&amp;#xD;           &amp;lt;backupLevel&amp;gt;INCREMENTAL&amp;lt;/backupLevel&amp;gt;&amp;#xD;           &amp;lt;dataOpt&amp;gt;&amp;#xD;             &amp;lt;bkpFilesProctedByFS&amp;gt;true&amp;lt;/bkpFilesProctedByFS&amp;gt;&amp;#xD;             &amp;lt;collectHotFixInformation&amp;gt;true&amp;lt;/collectHotFixInformation&amp;gt;&amp;#xD;             &amp;lt;collectSysInfo&amp;gt;false&amp;lt;/collectSysInfo&amp;gt;&amp;#xD;             &amp;lt;createNewIndex&amp;gt;false&amp;lt;/createNewIndex&amp;gt;&amp;#xD;             &amp;lt;enableIndexCheckPointing&amp;gt;false&amp;lt;/enableIndexCheckPointing&amp;gt;&amp;#xD;             &amp;lt;enforceTransactionLogUsage&amp;gt;true&amp;lt;/enforceTransactionLogUsage&amp;gt;&amp;#xD;             &amp;lt;followMountPoints&amp;gt;true&amp;lt;/followMountPoints&amp;gt;&amp;#xD;             &amp;lt;ignorErrorInSynthFull&amp;gt;false&amp;lt;/ignorErrorInSynthFull&amp;gt;&amp;#xD;             &amp;lt;skipCatalogPhaseForSnapBackup&amp;gt;false&amp;lt;/skipCatalogPhaseForSnapBackup&amp;gt;&amp;#xD;             &amp;lt;skipConsistencyCheck&amp;gt;false&amp;lt;/skipConsistencyCheck&amp;gt;&amp;#xD;             &amp;lt;spaceReclamation&amp;gt;false&amp;lt;/spaceReclamation&amp;gt;&amp;#xD;             &amp;lt;stopDhcpService&amp;gt;true&amp;lt;/stopDhcpService&amp;gt;&amp;#xD;             &amp;lt;stopWinService&amp;gt;true&amp;lt;/stopWinService&amp;gt;&amp;#xD;             &amp;lt;useCatalogServer&amp;gt;true&amp;lt;/useCatalogServer&amp;gt;&amp;#xD;             &amp;lt;verifySynthFull&amp;gt;true&amp;lt;/verifySynthFull&amp;gt;&amp;#xD;           &amp;lt;/dataOpt&amp;gt;&amp;#xD;           &amp;lt;dataPathOpt&amp;gt;&amp;#xD;             &amp;lt;drive/&amp;gt;&amp;#xD;             &amp;lt;drivePool/&amp;gt;&amp;#xD;             &amp;lt;library/&amp;gt;&amp;#xD;             &amp;lt;mediaAgent/&amp;gt;&amp;#xD;           &amp;lt;/dataPathOpt&amp;gt;&amp;#xD;           &amp;lt;doNotTruncateLog&amp;gt;false&amp;lt;/doNotTruncateLog&amp;gt;&amp;#xD;           &amp;lt;incLevel&amp;gt;BEFORE_SYNTH&amp;lt;/incLevel&amp;gt;&amp;#xD;           &amp;lt;mediaOpt&amp;gt;&amp;#xD;             &amp;lt;allowOtherSchedulesToUseMediaSet&amp;gt;true&amp;lt;/allowOtherSchedulesToUseMediaSet&amp;gt;&amp;#xD;             &amp;lt;markMediaFullOnSuccess&amp;gt;false&amp;lt;/markMediaFullOnSuccess&amp;gt;&amp;#xD;             &amp;lt;numberofDays&amp;gt;30&amp;lt;/numberofDays&amp;gt;&amp;#xD;             &amp;lt;reserveResourcesBeforeScan&amp;gt;false&amp;lt;/reserveResourcesBeforeScan&amp;gt;&amp;#xD;             &amp;lt;retentionJobType&amp;gt;STORAGE_POLICY_DEFAULT&amp;lt;/retentionJobType&amp;gt;&amp;#xD;             &amp;lt;startNewMedia&amp;gt;false&amp;lt;/startNewMedia&amp;gt;&amp;#xD;           &amp;lt;/mediaOpt&amp;gt;&amp;#xD;           &amp;lt;runIncrementalBackup&amp;gt;true&amp;lt;/runIncrementalBackup&amp;gt;&amp;#xD;           &amp;lt;sybaseSkipFullafterLogBkp&amp;gt;false&amp;lt;/sybaseSkipFullafterLogBkp&amp;gt;&amp;#xD;           &amp;lt;truncateLogsOnSource&amp;gt;false&amp;lt;/truncateLogsOnSource&amp;gt;&amp;#xD;           &amp;lt;vaultTrackerOpt&amp;gt;&amp;#xD;             &amp;lt;excludeMediaNotCopied&amp;gt;false&amp;lt;/excludeMediaNotCopied&amp;gt;&amp;#xD;             &amp;lt;exportLocation/&amp;gt;&amp;#xD;             &amp;lt;exportMediaAfterJobFinishes&amp;gt;false&amp;lt;/exportMediaAfterJobFinishes&amp;gt;&amp;#xD;             &amp;lt;filterMediaByRetention&amp;gt;false&amp;lt;/filterMediaByRetention&amp;gt;&amp;#xD;             &amp;lt;inTransitLocation/&amp;gt;&amp;#xD;             &amp;lt;mediaStatus&amp;gt;&amp;#xD;               &amp;lt;active&amp;gt;false&amp;lt;/active&amp;gt;&amp;#xD;               &amp;lt;all&amp;gt;false&amp;lt;/all&amp;gt;&amp;#xD;               &amp;lt;bad&amp;gt;true&amp;lt;/bad&amp;gt;&amp;#xD;               &amp;lt;full&amp;gt;true&amp;lt;/full&amp;gt;&amp;#xD;               &amp;lt;overwriteProtected&amp;gt;true&amp;lt;/overwriteProtected&amp;gt;&amp;#xD;             &amp;lt;/mediaStatus&amp;gt;&amp;#xD;             &amp;lt;mediaWithExtendedRetentionJobs&amp;gt;false&amp;lt;/mediaWithExtendedRetentionJobs&amp;gt;&amp;#xD;             &amp;lt;trackTransit&amp;gt;false&amp;lt;/trackTransit&amp;gt;&amp;#xD;             &amp;lt;useVirtualMailSlots&amp;gt;false&amp;lt;/useVirtualMailSlots&amp;gt;&amp;#xD;           &amp;lt;/vaultTrackerOpt&amp;gt;&amp;#xD;         &amp;lt;/backupOpts&amp;gt;&amp;#xD;         &amp;lt;commonOpts&amp;gt;&amp;#xD;           &amp;lt;!--User Description for the job--&amp;gt;&amp;#xD;           &amp;lt;jobDescription&amp;gt;&amp;lt;/jobDescription&amp;gt;&amp;#xD;           &amp;lt;jobRetryOpts&amp;gt;&amp;#xD;             &amp;lt;enableNumberOfRetries&amp;gt;false&amp;lt;/enableNumberOfRetries&amp;gt;&amp;#xD;             &amp;lt;killRunningJobWhenTotalRunningTimeExpires&amp;gt;false&amp;lt;/killRunningJobWhenTotalRunningTimeExpires&amp;gt;&amp;#xD;             &amp;lt;numberOfRetries&amp;gt;0&amp;lt;/numberOfRetries&amp;gt;&amp;#xD;             &amp;lt;runningTime&amp;gt;&amp;#xD;               &amp;lt;enableTotalRunningTime&amp;gt;false&amp;lt;/enableTotalRunningTime&amp;gt;&amp;#xD;               &amp;lt;totalRunningTime&amp;gt;01:00:00&amp;lt;/totalRunningTime&amp;gt;&amp;#xD;             &amp;lt;/runningTime&amp;gt;&amp;#xD;           &amp;lt;/jobRetryOpts&amp;gt;&amp;#xD;           &amp;lt;perfJobOpts/&amp;gt;&amp;#xD;           &amp;lt;startUpOpts&amp;gt;&amp;#xD;             &amp;lt;priority&amp;gt;166&amp;lt;/priority&amp;gt;&amp;#xD;             &amp;lt;startInSuspendedState&amp;gt;false&amp;lt;/startInSuspendedState&amp;gt;&amp;#xD;             &amp;lt;useDefaultPriority&amp;gt;true&amp;lt;/useDefaultPriority&amp;gt;&amp;#xD;           &amp;lt;/startUpOpts&amp;gt;&amp;#xD;         &amp;lt;/commonOpts&amp;gt;&amp;#xD;         &amp;lt;restoreOptions/&amp;gt;&amp;#xD;       &amp;lt;/options&amp;gt;&amp;#xD;       &amp;lt;subTask&amp;gt;&amp;#xD;         &amp;lt;operationType&amp;gt;BACKUP&amp;lt;/operationType&amp;gt;&amp;#xD;         &amp;lt;subTaskType&amp;gt;BACKUP&amp;lt;/subTaskType&amp;gt;&amp;#xD;       &amp;lt;/subTask&amp;gt;&amp;#xD;     &amp;lt;/subTasks&amp;gt;&amp;#xD;     &amp;lt;task&amp;gt;&amp;#xD;       &amp;lt;alert&amp;gt;&amp;#xD;         &amp;lt;alertName&amp;gt;&amp;lt;/alertName&amp;gt;&amp;#xD;       &amp;lt;/alert&amp;gt;&amp;#xD;       &amp;lt;initiatedFrom&amp;gt;COMMANDLINE&amp;lt;/initiatedFrom&amp;gt;&amp;#xD;       &amp;lt;policyType&amp;gt;DATA_PROTECTION&amp;lt;/policyType&amp;gt;&amp;#xD;       &amp;lt;taskFlags&amp;gt;&amp;#xD;         &amp;lt;disabled&amp;gt;false&amp;lt;/disabled&amp;gt;&amp;#xD;       &amp;lt;/taskFlags&amp;gt;&amp;#xD;       &amp;lt;taskType&amp;gt;IMMEDIATE&amp;lt;/taskType&amp;gt;&amp;#xD;     &amp;lt;/task&amp;gt;&amp;#xD;   &amp;lt;/taskInfo&amp;gt;&amp;#xD; &amp;#xD; &amp;lt;/TMMsg_CreateTaskReq&amp;gt;&amp;#xD; &lt;/inputXml>&lt;commandArgs class=&quot;java.lang.String&quot; />&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

                        <transition activity="Decision_1" commented="0"

                            originalStyle="" points="" sourceX="83"

                            sourceY="103" status="0" style="defaultEdge"

                            targetX="202" targetY="97"

                            transitionIndex="0" x="0" y="0">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity breakpoint="0" commented="0"

                        continueOnFailure="0" created="1329165533623"

                        description="utility to add objects to a list"

                        displayName="AddToList" height="34"

                        interactive="0" name="AddToList"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=AddToList"

                        uniqueName="AddToList_1" waitSetting="0"

                        width="100" x="33" y="209">

                        <inputs val="&lt;inputs>&lt;addToList class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/backupJobs}&lt;/addToList>&lt;itemToAdd class=&quot;java.lang.Object&quot;>xpath:{/workflow/XPathQuery_1/result}&lt;/itemToAdd>&lt;/inputs>"/>

                    </Activity>

                    <Activity breakpoint="0" commented="0"

                        continueOnFailure="0" created="1362674330843"

                        description="retrieves a list of values from xml"

                        displayName="Get JobId" height="34"

                        interactive="0" name="XPathQuery"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=XPathQuery"

                        uniqueName="XPathQuery_1" waitSetting="0"

                        width="110" x="186" y="209">

                        <inputs val="&lt;inputs>&lt;xml class=&quot;java.lang.String&quot;>xpath:{/workflow/Execute_1/outputXml}&lt;/xml>&lt;xpath class=&quot;java.lang.String&quot;>/TMMsg_CreateTaskResp/jobIds[1]/@val&lt;/xpath>&lt;outputType class=&quot;workflow.types.SimpleType&quot;>String&lt;/outputType>&lt;outputAsList class=&quot;java.lang.Boolean&quot;>true&lt;/outputAsList>&lt;/inputs>"/>

                        <transition activity="AddToList_1" commented="0"

                            originalStyle="" points="" sourceX="241"

                            sourceY="226" status="0" style="defaultEdge"

                            targetX="77" targetY="217"

                            transitionIndex="0" x="0" y="0">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity breakpoint="0" commented="0"

                        continueOnFailure="0" created="1362674070454"

                        description="if/else based decision"

                        displayName="Success" height="100"

                        interactive="0" name="Decision"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="rhombus;fontStyle=1"

                        uniqueName="Decision_1" waitSetting="0"

                        width="100" x="192" y="53">

                        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/Execute_1/exitCode} == 0&lt;/expression>&lt;/inputs>"/>

                        <transition activity="XPathQuery_1"

                            commented="0" originalStyle="" points=""

                            sourceX="242" sourceY="103" status="0"

                            style="defaultEdge" targetX="239"

                            targetY="216" transitionIndex="0"

                            value="true" x="0" y="0">

                            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                        <transition activity="WorkflowEnd_1"

                            commented="0" originalStyle="" points=""

                            sourceX="242" sourceY="103" status="0"

                            style="defaultEdge" targetX="354"

                            targetY="145" transitionIndex="0"

                            value="false" x="0" y="0">

                            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity breakpoint="0" commented="0"

                        continueOnFailure="0" created="1362674131734"

                        description="Ends the workflow"

                        displayName="Fail Workflow" height="34"

                        interactive="0" name="WorkflowEnd"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=WorkflowEnd"

                        uniqueName="WorkflowEnd_1" waitSetting="0"

                        width="123" x="325" y="140">

                        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot;>FAILED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot;>xpath:{/workflow/Execute_1/commandOutput}&lt;/failureMessage>&lt;/inputs>"/>

                    </Activity>

                </superProcess>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1381430342097"

                description="if/else based decision"

                displayName="Library Exists?" height="100"

                interactive="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_3"

                waitSetting="0" width="128" x="402" y="33">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/CommServDBQuery_4/resultSets/rowCount}==1&lt;/expression>&lt;/inputs>"/>

                <transition activity="ExecuteCommand_2" commented="0"

                    displayName="No" originalStyle="" points=""

                    sourceX="375" sourceY="73" status="0"

                    style="defaultEdge" targetX="468" targetY="47"

                    transitionIndex="0" value="false" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="ExecuteScript_2" commented="0"

                    displayName="Yes" originalStyle="" points=""

                    sourceX="483" sourceY="82" status="0"

                    style="defaultEdge" targetX="487" targetY="192"

                    transitionIndex="0" value="True" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1381430567331"

                description="executes queries against the commserv database"

                displayName="Check Library" height="34" interactive="0"

                name="CommServDBQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=CommServDBQuery"

                uniqueName="CommServDBQuery_4" waitSetting="0"

                width="162" x="187" y="66">

                <inputs val="&lt;inputs>&lt;commCell>&lt;/commCell>&lt;query>select LibraryName from MMLibrary where AliasName = ''xpath:{/workflow/variables/sharedLibrary}''&lt;/query>&lt;/inputs>"/>

                <transition activity="Decision_3" commented="0"

                    originalStyle="" points="" sourceX="207"

                    sourceY="52" status="0" style="defaultEdge"

                    targetX="338" targetY="75" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1381431357812"

                description="executes queries against the commserv database"

                displayName="Check SPCopy" height="34" interactive="0"

                name="CommServDBQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=CommServDBQuery"

                uniqueName="CommServDBQuery_5" waitSetting="0"

                width="162" x="716" y="159">

                <inputs val="&lt;inputs>&lt;commCell>&lt;/commCell>&lt;query>select id from archGroupCopy where name= ''xpath:{/workflow/variables/newSourceCopy}'' and archGroupId in ( select id from archGroup where name = ''xpath:{/workflow/inputs/StoragePolicyToSeed/storagePolicyName}'')&lt;/query>&lt;/inputs>"/>

                <transition activity="Decision_4" commented="0"

                    originalStyle="" points="" sourceX="731"

                    sourceY="176" status="0" style="defaultEdge"

                    targetX="731" targetY="259" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1381431576602"

                description="if/else based decision"

                displayName="SPCopy Exists?" height="100"

                interactive="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_4"

                waitSetting="0" width="131" x="739" y="258">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/CommServDBQuery_5/resultSets/rowCount}==1&lt;/expression>&lt;/inputs>"/>

                <transition activity="CommServDBQuery_1" commented="0"

                    displayName="Yes" originalStyle="" points=""

                    sourceX="727" sourceY="268" status="0"

                    style="defaultEdge" targetX="662" targetY="370"

                    transitionIndex="0" value="true" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="CreateSPCopy_2" commented="0"

                    displayName="No" originalStyle="" points=""

                    sourceX="727" sourceY="268" status="0"

                    style="defaultEdge" targetX="837" targetY="391"

                    transitionIndex="0" value="false" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1382716536031" description=""

                displayName="ChangeControllerMP" height="34"

                interactive="0" name="ExecuteScript"

                namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                originalStyle="" skipAttempt="0"

                style="label;image=ExecuteScript"

                uniqueName="ExecuteScript_2" waitSetting="0" width="177"

                x="388" y="175">

                <inputs val="&lt;inputs>&lt;scriptName class=&quot;java.lang.String&quot;>ChangeDeviceControllerPathForMP&lt;/scriptName>&lt;arguments class=&quot;java.lang.String&quot;>-si xpath:{/workflow/variables/LocalMA} -si xpath:{/workflow/variables/sharedLibrary} -si xpath:{/workflow/inputs/LibraryPath}&lt;/arguments>&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

                <transition activity="CommServDBQuery_5" commented="0"

                    originalStyle="" points="" sourceX="493"

                    sourceY="176" status="0" style="defaultEdge"

                    targetX="755" targetY="178" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

        </superProcess>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="1"

        created="1371741959000"

        description="creates a super process group"

        displayName="Destination Side Operation" height="507"

        interactive="0" maxRestarts="1" name="ProcessBlock"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ProcessBlock_2" waitSetting="0" width="1095" x="433" y="837">

        <activitySchema>

            <inputs attribute="0" listType="0" name="inputs" required="1"/>

            <outputs attribute="0" listType="0" name="outputs" required="1"/>

        </activitySchema>

        <inputs val="&lt;inputs>&lt;inputs />&lt;/inputs>"/>

        <transition activity="ProcessBlock_3" commented="0"

            displayName="Cleanup" originalStyle="" points=""

            sourceX="954" sourceY="564" status="0" style="defaultEdge"

            targetX="1739" targetY="319" transitionIndex="0" x="-43" y="-17">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <superProcess>

            <Start breakpoint="0" commented="0" continueOnFailure="0"

                created="1371741959000" description=""

                displayName="Start" height="30" interactive="0"

                name="Start" originalStyle="" skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_5" waitSetting="0" width="120" x="26" y="42">

                <inputs val="&lt;inputs />"/>

                <transition activity="CommServDBQuery_6" commented="0"

                    originalStyle="" points="" sourceX="86" sourceY="57"

                    status="0" style="defaultEdge" targetX="240"

                    targetY="58" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1371483745188"

                description="executes queries against the commserv database"

                displayName="Change Source Copy" height="34"

                interactive="0" name="CommServDBQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=CommServDBQuery"

                uniqueName="CommServDBQuery_2" waitSetting="0"

                width="166" x="834" y="212">

                <inputs val="&lt;inputs>&lt;commCell>&lt;/commCell>&lt;query>Declare @newSourceId int&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;select @newSourceId = id from archGroupCopy where name = ''xpath:{/workflow/variables/newSourceCopy}'' and archGroupId in ( select id from archGroup where name = ''xpath:{/workflow/inputs/StoragePolicyToSeed/storagePolicyName}'')&amp;#xD;&#xd;&#xa;Update archGroupCopy set sourceCopyId = @newSourceId where name = ''xpath:{/workflow/variables/copyName}'' and archGroupId in ( select id from archGroup where name = ''xpath:{/workflow/inputs/StoragePolicyToSeed/storagePolicyName}'')&lt;/query>&lt;/inputs>"/>

                <transition activity="AuxCopy_2" commented="0"

                    originalStyle="" points="" sourceX="814"

                    sourceY="57" status="0" style="defaultEdge"

                    targetX="824" targetY="151" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1371483745218" description=""

                displayName="OperationAuxCopy" height="34"

                interactive="0" name="AuxCopy"

                namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                originalStyle="" skipAttempt="0"

                style="label;image=OperationAuxCopy"

                uniqueName="AuxCopy_2" waitSetting="0" width="154"

                x="875" y="323">

                <inputs val="&lt;inputs>&lt;storagePolicy class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/StoragePolicyToSeed}&lt;/storagePolicy>&lt;copy class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/copyName}&lt;/copy>&lt;argumentFilepath class=&quot;java.lang.String&quot; />&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

                <transition activity="WaitForJobCompletion_4"

                    commented="0" originalStyle="" points=""

                    sourceX="506" sourceY="52" status="0"

                    style="defaultEdge" targetX="634" targetY="46"

                    transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1371483745255"

                description="repeats until job completes"

                displayName="WaitForJobCompletion" height="34"

                interactive="0" name="WaitForJobCompletion"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=WaitForJobCompletion"

                uniqueName="WaitForJobCompletion_4" waitSetting="0"

                width="180" x="601" y="323">

                <inputs val="&lt;inputs>&lt;jobId class=&quot;java.lang.Integer&quot;>xpath:{/workflow/AuxCopy_2/jobId}&lt;/jobId>&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

                <transition activity="CommServDBQuery_3" commented="0"

                    originalStyle="" points="" sourceX="708"

                    sourceY="51" status="0" style="defaultEdge"

                    targetX="936" targetY="54" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1371483745292"

                description="executes queries against the commserv database"

                displayName="Change Source Copy" height="34"

                interactive="0" name="CommServDBQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=CommServDBQuery"

                uniqueName="CommServDBQuery_3" waitSetting="0"

                width="166" x="351" y="323">

                <inputs val="&lt;inputs>&lt;commCell>&lt;/commCell>&lt;query>DECLARE @newSourceId INT&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;SELECT @newSourceId = id FROM archGroupCopy WHERE name = ''Primary'' AND archGroupId in ( select id from archGroup where name = ''xpath:{/workflow/inputs/StoragePolicyToSeed/storagePolicyName}'')&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;Update archGroupCopy set sourceCopyId = @newSourceId where name in (''xpath:{/workflow/variables/copyName}'', ''xpath:{/workflow/variables/newSourceCopy}'') and archGroupId in ( select id from archGroup where name = ''xpath:{/workflow/inputs/StoragePolicyToSeed/storagePolicyName}'')&amp;#xD;&#xd;&#xa;&lt;/query>&lt;/inputs>"/>

                <transition activity="Script_7" commented="0"

                    originalStyle="" points="" sourceX="998"

                    sourceY="49" status="0" style="defaultEdge"

                    targetX="999" targetY="157" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1371483745321"

                description="activity to execute code snippets in the selected language"

                displayName="CopySIDBtoRemoteMA" height="49"

                interactive="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Script" uniqueName="Script_7"

                waitSetting="0" width="186" x="82" y="316">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;String localMA = xpath:{/workflow/variables/LocalMA};&amp;#xD;&amp;#xA;String GDSPMA = xpath:{/workflow/variables/GDSPMA};&amp;#xD;&amp;#xA;String storagePolicy = xpath:{/workflow/inputs/StoragePolicyToSeed}.getStoragePolicyName();&amp;#xD;&amp;#xA;String GSDPCopyName = xpath:{/workflow/variables/copyName};&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;String sql;&amp;#xD;&amp;#xA;DataSet rs;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;String destHostName;&amp;#xD;&amp;#xA;String destPath;&amp;#xD;&amp;#xA;String sourcePath;&amp;#xD;&amp;#xA;int auxcopy_id;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;sql = &amp;quot;Select net_hostname,name,cvdPort,evmgrcPort,jobResultDir from APP_Client where name = ''&amp;quot;+localMA+&amp;quot;''&amp;quot;;&amp;#xD;&amp;#xA;rs = csdb.execute(sql);&amp;#xD;&amp;#xA;if (rs.hasNext()) {&amp;#xD;&amp;#xA;   destHostName = rs.get(&amp;quot;net_hostname&amp;quot;)+&amp;quot;*&amp;quot;+rs.get(&amp;quot;name&amp;quot;)+&amp;quot;*&amp;quot;+rs.get(&amp;quot;cvdPort&amp;quot;)+&amp;quot;*&amp;quot;+rs.get(&amp;quot;evmgrcPort&amp;quot;);&amp;#xD;&amp;#xA;   destPath = rs.get(&amp;quot;jobResultDir&amp;quot;)+&amp;quot;\\CV_CLDB\\CV_CLDB_AUX_&amp;quot;;&amp;#xD;&amp;#xA;} else {&amp;#xD;&amp;#xA;   workflow.setFailed(&amp;quot;failed to retrieve client details for &amp;quot;+localMA);&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;sql = &amp;quot;select id from archGroupCopy where name = ''&amp;quot;+GSDPCopyName+&amp;quot;'' and archGroupId in ( select id from archGroup where name = ''&amp;quot;+storagePolicy+&amp;quot;'')&amp;quot;;&amp;#xD;&amp;#xA;rs = csdb.execute(sql);&amp;#xD;&amp;#xA;if (rs.hasNext()) {&amp;#xD;&amp;#xA;   auxcopy_id = rs.get(&amp;quot;id&amp;quot;);&amp;#xD;&amp;#xA;} else {&amp;#xD;&amp;#xA;   workflow.setFailed(&amp;quot;failed to retrieve archGroupCopy for &amp;quot;+GSDPCopyName);&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;destPath = destPath + auxcopy_id;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;sql = &amp;quot;Select jobResultDir from APP_Client where name = ''&amp;quot;+GDSPMA+&amp;quot;''&amp;quot;;&amp;#xD;&amp;#xA;rs = csdb.execute(sql);&amp;#xD;&amp;#xA;if (rs.hasNext()) {&amp;#xD;&amp;#xA;   sourcePath = rs.get(&amp;quot;jobResultDir&amp;quot;) + &amp;quot;\\CV_CLDB\\CV_CLDB_AUX_&amp;quot; + auxcopy_id;&amp;#xD;&amp;#xA;} else {&amp;#xD;&amp;#xA;   workflow.setFailed(&amp;quot;failed to retrieve jobResultDir for &amp;quot;+GDSPMA);&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;destHostName&amp;quot;, destHostName);&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;sourcePath&amp;quot;, sourcePath);&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;destPath&amp;quot;, destPath);&amp;#xD;&amp;#xA;&quot; />&lt;/inputs>"/>

                <transition activity="ExecuteCommand_3" commented="0"

                    originalStyle="" points="" sourceX="1015"

                    sourceY="159" status="0" style="defaultEdge"

                    targetX="833" targetY="157" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1371483745353"

                description="Execute a list of commands"

                displayName="Move DDB" height="34" interactive="0"

                name="ExecuteCommand"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=ExecuteCommand"

                uniqueName="ExecuteCommand_3" waitSetting="0"

                width="125" x="67" y="446">

                <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>&lt;clientName />&lt;clientId>0&lt;/clientId>&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; />&lt;command class=&quot;java.lang.String&quot;>MoveDDBClientCacheServer.exe&lt;/command>&lt;arguments class=&quot;java.lang.String&quot;>-sourceInstance xpath:{/workflow/variables/sourceInstance} -targetInstance xpath:{/workflow/variables/targetInstance} -sourceClient xpath:{/workflow/variables/GDSPMA} -sourcePath &quot;xpath:{/workflow/variables/sourcePath}&quot; -targetClient xpath:{/workflow/variables/LocalMA} -targetPath &quot;xpath:{/workflow/variables/destPath}&quot;&lt;/arguments>&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

                <transition activity="Execute_4" commented="0"

                    originalStyle="" points="" sourceX="80"

                    sourceY="289" status="0" style="defaultEdge"

                    targetX="313" targetY="300" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1371483745415"

                description="Send email to a list of users"

                displayName="Email" height="34" interactive="0"

                name="Email"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Email" uniqueName="Email_1"

                waitSetting="0" width="85" x="826" y="445">

                <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot;>&lt;from class=&quot;java.lang.String&quot;>DDBSeeding@xpath:{/workflow/system/commCellName}&lt;/from>&lt;to class=&quot;java.lang.String&quot;>xpath:{/workflow/system/executor/userName}&lt;/to>&lt;subject class=&quot;java.lang.String&quot;>DDB Seeding Workflow Completed&lt;/subject>&lt;body class=&quot;java.lang.String&quot;>&amp;lt;p&amp;gt;&#xd;&#xa;      DDB Seeding completed for Storage Policy &#xd;&#xa;      xpath:{/workflow/inputs/StoragePolicyToSeed}&#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      &#xd;&#xa;    &amp;lt;/p&amp;gt;&#xd;&#xa;    &amp;lt;p&amp;gt;&#xd;&#xa;      Thanks&#xd;&#xa;    &amp;lt;/p&amp;gt;&lt;/body>&lt;html class=&quot;java.lang.Boolean&quot;>true&lt;/html>&lt;cc class=&quot;java.lang.String&quot; />&lt;bcc class=&quot;java.lang.String&quot; />&lt;attachments class=&quot;java.lang.Object&quot; />&lt;/email>&lt;/inputs>"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1329168616610"

                description="activity to execute code snippets in the selected language"

                displayName="Get GDSP Info" height="34" interactive="0"

                name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Script" uniqueName="Script_5"

                waitSetting="0" width="126" x="78" y="212">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;String storagePolicy = xpath:{/workflow/inputs/StoragePolicyToSeed}.getStoragePolicyName();&amp;#xA;String copyName = xpath:{/workflow/variables/copyName};&amp;#xA;String GDSP = xpath:{/workflow/inputs/GDSPName}.getStoragePolicyName();&amp;#xA;&amp;#xA;String sql;&amp;#xA;DataSet rs;&amp;#xA;String libraryAlias;&amp;#xA;String mediaAgent;&amp;#xA;int ma_id;&amp;#xA;int drivePoolId;&amp;#xA;&amp;#xA;sql = &amp;quot;select HostClientId,DrivePoolId from MMDataPath where CopyId in ( select defaultCopy from archGroup where name = ''&amp;quot;+GDSP+&amp;quot;'' )&amp;quot;;&amp;#xA;rs = csdb.execute(sql);&amp;#xA;if (rs.hasNext()) {&amp;#xA;   ma_id = rs.get(&amp;quot;HostClientId&amp;quot;);&amp;#xA;   drivePoolId = rs.get(&amp;quot;DrivePoolId&amp;quot;);&amp;#xA;} else {&amp;#xA;   workflow.setFailed(&amp;quot;failed to retrieve datapath for &amp;quot;+GDSP);&amp;#xA;   return;&amp;#xA;}&amp;#xA;&amp;#xA;sql = &amp;quot;select AliasName from MMLibrary where LibraryId in ( select libraryId from MMMasterPool where MasterPoolId in ( select MasterPoolId from MMDrivePool where DrivePoolId = &amp;quot;+drivePoolId+&amp;quot; ))&amp;quot;;&amp;#xA;rs = csdb.execute(sql);&amp;#xA;if (rs.hasNext()) {&amp;#xA;   libraryAlias = rs.get(&amp;quot;AliasName&amp;quot;);&amp;#xA;} else {&amp;#xA;   workflow.setFailed(&amp;quot;failed to retrieve library for drive pool &amp;quot;+drivePoolId);&amp;#xA;   return;&amp;#xA;}&amp;#xA;&amp;#xA;sql = &amp;quot;select name from APP_Client where id = &amp;quot;+ma_id;&amp;#xA;rs = csdb.execute(sql);&amp;#xA;if (rs.hasNext()) {&amp;#xA;   mediaAgent = rs.get(&amp;quot;name&amp;quot;);&amp;#xA;} else {&amp;#xA;   workflow.setFailed(&amp;quot;failed to client name for id &amp;quot;+ma_id);&amp;#xA;}&amp;#xA;&amp;#xA;workflow.setVariable(&amp;quot;GDSPMediaAgent&amp;quot;, mediaAgent);&amp;#xA;workflow.setVariable(&amp;quot;GDSPLibrary&amp;quot;, libraryAlias);&amp;#xA;&amp;#xA;&quot; />&lt;/inputs>"/>

                <transition activity="CreateSPCopy_3" commented="0"

                    originalStyle="" points="" sourceX="268"

                    sourceY="57" status="0" style="defaultEdge"

                    targetX="436" targetY="57" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1329170428202" description=""

                displayName="Seconday Copy" height="34" interactive="0"

                name="SPCopy"

                namespaceUri="commvault.cte.workflow.activities.cmd.create"

                originalStyle="" skipAttempt="0"

                style="label;image=CreateSPCopy"

                uniqueName="CreateSPCopy_3" waitSetting="0" width="131"

                x="300" y="212">

                <inputs val="&lt;inputs>&lt;storagePolicy class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/StoragePolicyToSeed}&lt;/storagePolicy>&lt;copy class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/copyName}&lt;/copy>&lt;mediaAgent class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/GDSPMediaAgent}&lt;/mediaAgent>&lt;library class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/GDSPLibrary}&lt;/library>&lt;drivePool class=&quot;java.lang.String&quot; />&lt;scratchPool class=&quot;java.lang.String&quot; />&lt;dedupPath class=&quot;java.lang.String&quot; />&lt;encryptData class=&quot;workflow.types.cmd.Answer&quot; />&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

                <transition activity="Script_6" commented="0"

                    originalStyle="" points="" sourceX="444"

                    sourceY="57" status="0" style="defaultEdge"

                    targetX="603" targetY="62" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1329170686304"

                description="activity to execute code snippets in the selected language"

                displayName="Make GDSP" height="34" interactive="0"

                name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Script" uniqueName="Script_6"

                waitSetting="0" width="107" x="602" y="212">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;String storagePolicy = xpath:{/workflow/inputs/StoragePolicyToSeed}.getStoragePolicyName();&amp;#xA;String copyName = xpath:{/workflow/variables/copyName};&amp;#xA;String GDSP = xpath:{/workflow/inputs/GDSPName}.getStoragePolicyName();&amp;#xA;&amp;#xA;String sql;&amp;#xA;DataSet rs;&amp;#xA;&amp;#xA;int sidbStoreID;&amp;#xA;int copyId;&amp;#xA;&amp;#xA;sql = &amp;quot;select SIDBStoreId from archCopySIDBStore where CopyId = ( select id from archGroupCopy where archGroupId = ( select id from archGroup where name = ''&amp;quot; + GDSP + &amp;quot;'' ))&amp;quot;;&amp;#xA;rs = csdb.execute(sql);&amp;#xA;if (rs.hasNext()) {&amp;#xA;   sidbStoreID = rs.get(&amp;quot;SIDBStoreId&amp;quot;);&amp;#xA;} else {&amp;#xA;   workflow.setFailed(&amp;quot;failed to retrieve SIDBStoreId for &amp;quot;+GDSP);&amp;#xA;}&amp;#xA;&amp;#xA;sql = &amp;quot;Update archGroupCopy set dedupeFlags = dedupeFlags | 134217728 | 524288 | 262144 | 33554432 | 67108864 , SIDBStoreId = &amp;quot; + sidbStoreID + &amp;quot;, SIDBSnapIntervalHours = 8, nDataInstance = 1, nSiloStreams = 0, sealStoreTaskId = 0 where name = ''&amp;quot;+copyName+&amp;quot;'' and ( archGroupId in ( select id from archGroup where name = ''&amp;quot;+storagePolicy+&amp;quot;'') )&amp;quot;;&amp;#xA;csdb.executeUpdate(sql);&amp;#xA;&amp;#xA;sql = &amp;quot;select id from archGroupCopy where name = ''&amp;quot;+copyName+&amp;quot;'' and archGroupId in (select id from archGroup where name = ''&amp;quot;+storagePolicy+&amp;quot;'')&amp;quot;;&amp;#xA;rs = csdb.execute(sql);&amp;#xA;if (rs.hasNext()) {&amp;#xA;   copyId = rs.get(&amp;quot;id&amp;quot;);&amp;#xA;} else {&amp;#xA;   workflow.setFailed(&amp;quot;failed to retrieve archGroupCopy for &amp;quot;+copyName);&amp;#xA;}&amp;#xA;&amp;#xA;sql = &amp;quot;Insert into archCopySIDBStore values(&amp;quot; + copyId + &amp;quot;,&amp;quot; + sidbStoreID + &amp;quot;,2,0,0,0)&amp;quot;;&amp;#xA;csdb.executeUpdate(sql);&amp;#xA;&amp;#xA;&quot; />&lt;/inputs>"/>

                <transition activity="CommServDBQuery_2" commented="0"

                    originalStyle="" points="" sourceX="630"

                    sourceY="57" status="0" style="defaultEdge"

                    targetX="782" targetY="54" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1363901934049" description=""

                displayName="addUseCacheDB" height="34" interactive="0"

                name="Execute"

                namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                originalStyle="" skipAttempt="0"

                style="label;image=Execute" uniqueName="Execute_2"

                waitSetting="0" width="138" x="79" y="123">

                <inputs val="&lt;inputs>&lt;inputXml class=&quot;java.lang.String&quot;>&amp;lt;App_SetClientPropertiesRequest&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;association&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;entity&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;clientName&amp;gt;xpath:{/workflow/variables/GDSPMA}&amp;lt;/clientName&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/entity&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;/association&amp;gt;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;  &amp;lt;clientProperties&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;clientProps&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;registryKeys&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;deleted&amp;gt;0&amp;lt;/deleted&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;enabled&amp;gt;1&amp;lt;/enabled&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;isInheritedFromClientGroup&amp;gt;false&amp;lt;/isInheritedFromClientGroup&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;keyName&amp;gt;UseCacheDB&amp;lt;/keyName&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;relativepath&amp;gt;MediaAgent&amp;lt;/relativepath&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;type&amp;gt;INTEGER&amp;lt;/type&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;value&amp;gt;1&amp;lt;/value&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/registryKeys&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/clientProps&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;/clientProperties&amp;gt;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&amp;lt;/App_SetClientPropertiesRequest&amp;gt;&lt;/inputXml>&lt;commandArgs class=&quot;java.lang.String&quot; />&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

                <transition activity="Script_5" commented="0"

                    originalStyle="" points="" sourceX="148"

                    sourceY="140" status="0" style="defaultEdge"

                    targetX="141" targetY="223" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1381436219347" description=""

                displayName="addUseCacheDB Client" height="38"

                interactive="0" name="Execute"

                namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                originalStyle="" skipAttempt="0"

                style="label;image=Execute" uniqueName="Execute_3"

                waitSetting="0" width="180" x="570" y="443">

                <inputs val="&lt;inputs>&lt;inputXml class=&quot;java.lang.String&quot;>&amp;lt;App_SetClientPropertiesRequest&amp;gt;&amp;#xD;   &amp;lt;association&amp;gt;&amp;#xD;     &amp;lt;entity&amp;gt;&amp;#xD;       &amp;lt;clientName&amp;gt;xpath:{/workflow/variables/LocalMA}&amp;lt;/clientName&amp;gt;&amp;#xD;     &amp;lt;/entity&amp;gt;&amp;#xD;   &amp;lt;/association&amp;gt;&amp;#xD; &amp;#xD;   &amp;lt;clientProperties&amp;gt;&amp;#xD;     &amp;lt;clientProps&amp;gt;&amp;#xD;       &amp;lt;registryKeys&amp;gt;&amp;#xD;         &amp;lt;deleted&amp;gt;0&amp;lt;/deleted&amp;gt;&amp;#xD;         &amp;lt;enabled&amp;gt;1&amp;lt;/enabled&amp;gt;&amp;#xD;         &amp;lt;isInheritedFromClientGroup&amp;gt;false&amp;lt;/isInheritedFromClientGroup&amp;gt;&amp;#xD;         &amp;lt;keyName&amp;gt;UseCacheDB&amp;lt;/keyName&amp;gt;&amp;#xD;         &amp;lt;relativepath&amp;gt;MediaAgent&amp;lt;/relativepath&amp;gt;&amp;#xD;         &amp;lt;type&amp;gt;INTEGER&amp;lt;/type&amp;gt;&amp;#xD;         &amp;lt;value&amp;gt;1&amp;lt;/value&amp;gt;&amp;#xD;       &amp;lt;/registryKeys&amp;gt;&amp;#xD;     &amp;lt;/clientProps&amp;gt;&amp;#xD;   &amp;lt;/clientProperties&amp;gt;&amp;#xD; &amp;#xD; &amp;lt;/App_SetClientPropertiesRequest&amp;gt;&lt;/inputXml>&lt;commandArgs class=&quot;java.lang.String&quot; />&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

                <transition activity="Email_1" commented="0"

                    originalStyle="" points="" sourceX="599"

                    sourceY="300" status="0" style="defaultEdge"

                    targetX="782" targetY="305" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1381436666269" description=""

                displayName="deleteUseCacheDB" height="34"

                interactive="0" name="Execute"

                namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                originalStyle="" skipAttempt="0"

                style="label;image=Execute" uniqueName="Execute_4"

                waitSetting="0" width="159" x="268" y="445">

                <inputs val="&lt;inputs>&lt;inputXml class=&quot;java.lang.String&quot;>&amp;lt;App_SetClientPropertiesRequest&amp;gt;&amp;#xD;   &amp;lt;association&amp;gt;&amp;#xD;     &amp;lt;entity&amp;gt;&amp;#xD;       &amp;lt;clientName&amp;gt;xpath:{/workflow/variables/LocalMA}&amp;lt;/clientName&amp;gt;&amp;#xD;     &amp;lt;/entity&amp;gt;&amp;#xD;   &amp;lt;/association&amp;gt;&amp;#xD; &amp;#xD;   &amp;lt;clientProperties&amp;gt;&amp;#xD;     &amp;lt;clientProps&amp;gt;&amp;#xD;       &amp;lt;registryKeys&amp;gt;&amp;#xD;         &amp;lt;deleted&amp;gt;0&amp;lt;/deleted&amp;gt;&amp;#xD;         &amp;lt;enabled&amp;gt;1&amp;lt;/enabled&amp;gt;&amp;#xD;         &amp;lt;isInheritedFromClientGroup&amp;gt;false&amp;lt;/isInheritedFromClientGroup&amp;gt;&amp;#xD;         &amp;lt;keyName&amp;gt;UseCacheDB&amp;lt;/keyName&amp;gt;&amp;#xD;         &amp;lt;relativepath&amp;gt;MediaAgent&amp;lt;/relativepath&amp;gt;&amp;#xD;         &amp;lt;type&amp;gt;INTEGER&amp;lt;/type&amp;gt;&amp;#xD;         &amp;lt;value&amp;gt;1&amp;lt;/value&amp;gt;&amp;#xD;       &amp;lt;/registryKeys&amp;gt;&amp;#xD;     &amp;lt;/clientProps&amp;gt;&amp;#xD;   &amp;lt;/clientProperties&amp;gt;&amp;#xD; &amp;#xD; &amp;lt;/App_SetClientPropertiesRequest&amp;gt;&lt;/inputXml>&lt;commandArgs class=&quot;java.lang.String&quot; />&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

                <transition activity="Execute_3" commented="0"

                    originalStyle="" points="" sourceX="356"

                    sourceY="305" status="0" style="defaultEdge"

                    targetX="642" targetY="304" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1381768230151" description=""

                displayName="ChangeControllerMP" height="34"

                interactive="0" name="ExecuteScript"

                namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                originalStyle="" skipAttempt="0"

                style="label;image=ExecuteScript"

                uniqueName="ExecuteScript_1" waitSetting="0" width="177"

                x="612" y="123">

                <inputs val="&lt;inputs>&lt;scriptName class=&quot;java.lang.String&quot;>ChangeDeviceControllerPathForMP&lt;/scriptName>&lt;arguments class=&quot;java.lang.String&quot;>-si xpath:{/workflow/UserInput_1/DataCenterMA} -si xpath:{/workflow/variables/sharedLibrary} -si xpath:{/workflow/UserInput_1/USBMountPath}&lt;/arguments>&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

                <transition activity="ExecuteScript_4" commented="0"

                    originalStyle="" points="" sourceX="672"

                    sourceY="140" status="0" style="defaultEdge"

                    targetX="204" targetY="138" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1382647557534"

                description="activity to execute code snippets in the selected language"

                displayName="Update MA" height="34" interactive="0"

                name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Script" uniqueName="Script_8"

                waitSetting="0" width="101" x="876" y="40">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;String testval = xpath:{/workflow/UserInput_1/DataCenterMA};&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;GDSPMA&amp;quot;, testval);&quot; />&lt;/inputs>"/>

                <transition activity="SPCopy_3" commented="0"

                    originalStyle="" points="" sourceX="282"

                    sourceY="83" status="0" style="defaultEdge"

                    targetX="534" targetY="58" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1382124282755"

                description="executes queries against the commserv database"

                displayName="ListGDSPMAs" height="34" interactive="0"

                name="CommServDBQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=CommServDBQuery"

                uniqueName="CommServDBQuery_6" waitSetting="0"

                width="162" x="302" y="40">

                <inputs val="&lt;inputs>&lt;commCell>&lt;/commCell>&lt;query>Select name,jobResultDir from APP_Client where id in (select HostClientId from MMDataPath where CopyId in ( select id from archGroupCopy where name like ''%Primary%'' and archGroupId in ( select id from archGroup where name = ''xpath:{/workflow/inputs/GDSPName/storagePolicyName}'')))&lt;/query>&lt;/inputs>"/>

                <transition activity="UserInput_1" commented="0"

                    originalStyle="" points="" sourceX="293"

                    sourceY="55" status="0" style="defaultEdge"

                    targetX="472" targetY="49" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1382673769624" description=""

                displayName="USB Mount Path" height="34" interactive="0"

                name="UserInput"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=UserInput" uniqueName="UserInput_1"

                waitSetting="0" width="136" x="566" y="40">

                <activitySchema>

                    <inputs attribute="0" listType="0" name="inputs"

                        required="1" type="">

                        <children attribute="0"

                            className="java.lang.String" controlType="0"

                            inputType="java.lang.String" listType="0"

                            name="USBMountPath" required="1" type="{http://www.w3.org/2001/XMLSchema}string"/>

                        <children attribute="0"

                            className="java.lang.String" controlType="2"

                            inputType="java.lang.String" listType="0"

                            name="DataCenterMA" required="1" type="{http://www.w3.org/2001/XMLSchema}string">

                            <options val="xpath:{/workflow/CommServDBQuery_6/resultSets/row/col[1]}"/>

                        </children>

                    </inputs>

                    <outputs attribute="0" listType="0" name="outputs"

                        required="1" type="">

                        <children attribute="0"

                            className="java.lang.String" controlType="0"

                            inputType="java.lang.String" listType="0"

                            name="USBMountPath" required="1" type="{http://www.w3.org/2001/XMLSchema}string"/>

                        <children attribute="0"

                            className="java.lang.String" controlType="2"

                            inputType="java.lang.String" listType="0"

                            name="DataCenterMA" required="1" type="{http://www.w3.org/2001/XMLSchema}string">

                            <options val="xpath:{/workflow/CommServDBQuery_6/resultSets/row/col[1]}"/>

                        </children>

                        <children

                            className="commvault.msgs.CvEntities.UserEntity"

                            inputType="commvault.msgs.CvEntities.UserEntity"

                            name="completedBy" type="{commvault.msgs.CvEntities}UserEntity">

                            <children className="java.lang.String"

                                inputType="java.lang.String"

                                name="userName" type="{http://www.w3.org/2001/XMLSchema}string"/>

                            <children className="java.lang.Integer"

                                inputType="java.lang.Integer"

                                name="userId" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                        </children>

                        <children className="java.lang.String"

                            inputType="java.lang.String"

                            name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string"/>

                    </outputs>

                </activitySchema>

                <inputs val="&lt;inputs>&lt;interactionUsers class=&quot;commvault.msgs.CvEntities.UserEntity&quot;>&lt;userName>admin&lt;/userName>&lt;userId>1&lt;/userId>&lt;/interactionUsers>&lt;interactionUsers>xpath:{/workflow/system/executor/userName}&lt;/interactionUsers>&lt;inputs>&lt;USBMountPath class=&quot;java.lang.String&quot; />&lt;DataCenterMA class=&quot;java.lang.String&quot; />&lt;/inputs>&lt;subject>Mount Path and MA&lt;/subject>&lt;sendEmail>true&lt;/sendEmail>&lt;email>&lt;from>DDBSeeding@xpath:{/workflow/system/commCellName}&lt;/from>&lt;to />&lt;cc />&lt;bcc />&lt;subject>DDB Seeding requires input&lt;/subject>&lt;attachments />&lt;body>&amp;lt;p&amp;gt;&#xd;&#xa;      DDB Seeding workflow is waiting for User Input : New Mounth path of USB &#xd;&#xa;      Drive on DataCenter MA&#xd;&#xa;    &amp;lt;/p&amp;gt;&lt;/body>&lt;html>true&lt;/html>&lt;/email>&lt;/inputs>"/>

                <transition activity="Script_8" commented="0"

                    originalStyle="" points="" sourceX="293"

                    sourceY="55" status="0" style="defaultEdge"

                    targetX="649" targetY="56" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1373920916721" description=""

                displayName="add_DataPath" height="34" interactive="0"

                name="SPCopy"

                namespaceUri="commvault.cte.workflow.activities.cmd.modify"

                originalStyle="" skipAttempt="0"

                style="label;image=SPCopy" uniqueName="SPCopy_3"

                waitSetting="0" width="136" x="864" y="123">

                <inputs val="&lt;inputs>&lt;storagePolicy class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/StoragePolicyToSeed/storagePolicyName}&lt;/storagePolicy>&lt;copy class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/newSourceCopy}&lt;/copy>&lt;operation class=&quot;java.lang.String&quot;>add_datapath&lt;/operation>&lt;mediaAgent class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/GDSPMA}&lt;/mediaAgent>&lt;library class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/sharedLibrary}&lt;/library>&lt;drivePool class=&quot;java.lang.String&quot; />&lt;scratchPool class=&quot;java.lang.String&quot; />&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

                <transition activity="ExecuteScript_1" commented="0"

                    originalStyle="" points="" sourceX="1007"

                    sourceY="99" status="0" style="defaultEdge"

                    targetX="957" targetY="151" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1382724306052" description=""

                displayName="ChangeControllerMP" height="34"

                interactive="0" name="ExecuteScript"

                namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                originalStyle="" skipAttempt="0"

                style="label;image=ExecuteScript"

                uniqueName="ExecuteScript_4" waitSetting="0" width="177"

                x="340" y="123">

                <inputs val="&lt;inputs>&lt;scriptName class=&quot;java.lang.String&quot;>ChangeDeviceControllerPathForMP&lt;/scriptName>&lt;arguments class=&quot;java.lang.String&quot;>-si xpath:{/workflow/variables/LocalMA} -si xpath:{/workflow/variables/sharedLibrary} -si xpath:{/workflow/UserInput_1/USBMountPath}&lt;/arguments>&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

                <transition activity="Execute_2" commented="0"

                    originalStyle="" points="" sourceX="400"

                    sourceY="171" status="0" style="defaultEdge"

                    targetX="209" targetY="139" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

        </superProcess>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0"

        created="1371752673259"

        description="creates a super process group"

        displayName="Cleanup" height="321" interactive="0"

        name="ProcessBlock"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ProcessBlock_3" waitSetting="0" width="273" x="1648" y="555">

        <activitySchema>

            <inputs attribute="0" listType="0" name="inputs" required="1"/>

            <outputs attribute="0" listType="0" name="outputs" required="1"/>

        </activitySchema>

        <inputs val="&lt;inputs>&lt;inputs />&lt;/inputs>"/>

        <superProcess>

            <Start breakpoint="0" commented="0" continueOnFailure="0"

                created="1371752673259" description=""

                displayName="Start" height="30" interactive="0"

                name="Start" originalStyle="" skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_9" waitSetting="0" width="120" x="83" y="31">

                <inputs val="&lt;inputs />"/>

                <transition activity="SPCopy_2" commented="0"

                    originalStyle="" points="" sourceX="143"

                    sourceY="46" status="0" style="defaultEdge"

                    targetX="142" targetY="204" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1371752781540" description=""

                displayName="Delete usb copy" height="34"

                interactive="0" name="SPCopy"

                namespaceUri="commvault.cte.workflow.activities.cmd.delete"

                originalStyle="" skipAttempt="0"

                style="label;image=SPCopy" uniqueName="SPCopy_2"

                waitSetting="0" width="135" x="75" y="104">

                <inputs val="&lt;inputs>&lt;storagePolicy class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/StoragePolicyToSeed}&lt;/storagePolicy>&lt;copy class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/newSourceCopy}&lt;/copy>&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

                <transition activity="ExecuteCommand_4" commented="0"

                    originalStyle="" points="" sourceX="142"

                    sourceY="121" status="0" style="defaultEdge"

                    targetX="153" targetY="189" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1371752786202" description="Ends the workflow"

                displayName="WorkflowEnd" height="34" interactive="0"

                name="WorkflowEnd"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=WorkflowEnd"

                uniqueName="WorkflowEnd_2" waitSetting="0" width="119"

                x="86" y="248">

                <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; />&lt;failureMessage class=&quot;java.lang.String&quot; />&lt;/inputs>"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0"

                created="1372172377644"

                description="Execute a list of commands"

                displayName="Delete Temp Library" height="34"

                interactive="0" name="ExecuteCommand"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=ExecuteCommand"

                uniqueName="ExecuteCommand_4" waitSetting="0"

                width="177" x="60" y="168">

                <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>&lt;clientName />&lt;clientId>0&lt;/clientId>&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; />&lt;startUpPath class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/pathSimpana}\Base&lt;/startUpPath>&lt;command class=&quot;java.lang.String&quot;>ScanScsiTool.exe&lt;/command>&lt;arguments class=&quot;java.lang.String&quot;>-X xpath:{/workflow/variables/sharedLibrary}&lt;/arguments>&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

                <transition activity="WorkflowEnd_2" commented="0"

                    originalStyle="" points="" sourceX="149"

                    sourceY="190" status="0" style="defaultEdge"

                    targetX="150" targetY="261" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

        </superProcess>

    </Activity>

    <schema>

        <inputs attribute="0" className="" listType="0" name="inputs"

            required="1" type="">

            <children attribute="0" className="java.lang.String"

                hidden="0" inputType="java.lang.String" listType="0"

                name="LibraryPath" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0"

                className="commvault.msgs.CvEntities.StoragePolicyEntity"

                hidden="0"

                inputType="commvault.msgs.CvEntities.StoragePolicyEntity"

                listType="0" name="StoragePolicyToSeed" required="0" type="{commvault.msgs.CvEntities}StoragePolicyEntity">

                <children attribute="0" className="java.lang.String"

                    inputType="java.lang.String" listType="0"

                    name="storagePolicyName" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children attribute="0" className="java.lang.Integer"

                    inputType="java.lang.Integer" listType="0"

                    name="storagePolicyId" required="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            </children>

            <children attribute="0"

                className="commvault.msgs.CvEntities.StoragePolicyEntity"

                hidden="0"

                inputType="commvault.msgs.CvEntities.StoragePolicyEntity"

                listType="0" name="GDSPName" required="0" type="{commvault.msgs.CvEntities}StoragePolicyEntity">

                <children attribute="0" className="java.lang.String"

                    inputType="java.lang.String" listType="0"

                    name="storagePolicyName" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children attribute="0" className="java.lang.Integer"

                    inputType="java.lang.Integer" listType="0"

                    name="storagePolicyId" required="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            </children>

            <children attribute="0" className="java.lang.Boolean"

                hidden="0" inputType="java.lang.Boolean" listType="0"

                name="skipSourceSideOperation" required="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

        </inputs>

        <variables attribute="0" className="" listType="0"

            name="variables" required="1" type="">

            <children attribute="0" className="java.lang.String"

                hidden="0" inputType="java.lang.String" listType="0"

                name="copyName" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                hidden="0" inputType="java.lang.String" listType="0"

                name="newSourceCopy" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.Integer"

                hidden="0" inputType="java.lang.Integer" listType="1"

                name="backupJobs" required="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.String"

                hidden="0" inputType="java.lang.String" listType="0"

                name="GDSPMA" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                hidden="0" inputType="java.lang.String" listType="0"

                name="LocalMA" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                hidden="0" inputType="java.lang.String" listType="0"

                name="GDSPMediaAgent" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                hidden="0" inputType="java.lang.String" listType="0"

                name="GDSPLibrary" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                hidden="0" inputType="java.lang.String" listType="0"

                name="sharedLibrary" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                hidden="0" inputType="java.lang.String" listType="0"

                name="sourceInstance" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                hidden="0" inputType="java.lang.String" listType="0"

                name="targetInstance" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                hidden="0" inputType="java.lang.String" listType="0"

                name="destPath" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                hidden="0" inputType="java.lang.String" listType="0"

                name="sourcePath" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                hidden="0" inputType="java.lang.String" listType="0"

                name="destHostName" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                hidden="0" inputType="java.lang.String" listType="0"

                name="pathSimpana" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" hidden="0" inputType="java.lang.String"

                listType="0" name="dcmaList" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

        </variables>

        <outputs className="" name="outputs" type=""/>

    </schema>

</workflow>'

IF not exists (select * from WF_Definition where Name = @name)

BEGIN
	INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision)


	VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision)

	SET @workflowId = @@IDENTITY
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


	VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

	SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = ISNULL(revision, '') From WF_Definition WHERE Name = @name

	IF (@currentFlags & 4 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0) AND (@currentRevision <> @revision)

	BEGIN

		SET @version = @version + 1

		UPDATE WF_Definition

		SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision

		WHERE Name = @name

		IF (@flags & 8 > 0 OR @flags & 16 > 0)

		BEGIN

			UPDATE WF_Definition

			SET flags = @flags

			WHERE Name = @name

		END
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


		VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

	END

END


