

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_DBMaintenance.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/WFD_DBMaintenance.script,v $ $Id: WFD_DBMaintenance.script,v 1.5.2.3.8.1 2021/02/19 00:55:05 yeshwanthr Exp $";
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER ON

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.5.2.3.8.1 $'

SET @name = 'DBMaintenance'

SET @description = 'performs db maintenance utilities against the CommCell database'

SET @version = 1

SET @flags = 6

SET @definition = '<workflow apiMode="0" config="&lt;configuration />"

    description="Performs db maintenance utilities against the CommCell database"

    executeOnWeb="0"

    inputs="&lt;inputs>&lt;type class=&quot;java.lang.String&quot; />&lt;DBNAMES class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>Commserv&lt;/DBNAMES>&lt;/inputs>"

    interactive="0" isHtmlDescription="0" manualPercentageComplete="0"

    name="DBMaintenance" outputs="&lt;outputs />"

    revision="$Revision: 1.5.2.3.8.1 $" tags=""

    uniqueGuid="2c793a3b-fe70-4584-9ff5-e675fdeeed32"

    variables="&lt;variables>&lt;Success_string class=&quot;java.lang.String&quot; _list_=&quot;true&quot; />&lt;Success_EmailString class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;Failure_string class=&quot;java.lang.String&quot; _list_=&quot;true&quot; />&lt;Failure_EmailString class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;DBNames class=&quot;java.lang.String&quot; _list_=&quot;true&quot; />&lt;str_success class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;str_failure class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;Path class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/variables>"

    webHidden="0" workflowId="0">

    <schema>

        <outputs className="" name="outputs" type=""/>

        <variables attribute="0" className="" listType="0"

            name="variables" required="1" type="">

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="1" name="Success_string" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="Success_EmailString" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="1" name="Failure_string" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="Failure_EmailString" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="1" name="DBNames" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="str_success" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="str_failure" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" hidden="0"

                inputType="java.lang.String" listType="0" name="Path" type="{http://www.w3.org/2001/XMLSchema}string"/>

        </variables>

        <inputs attribute="0" className="" listType="0" name="inputs"

            required="1" type="">

            <children alignment="0" attribute="0"

                className="java.lang.String" controlHidden="0"

                controlType="2" defaultValue=""

                displayName="Select database(s) to perform DBMaintenance"

                documentation="" hidden="0" inputType="java.lang.String"

                listType="1" maximumValue="" minimumValue=""

                name="DBNAMES" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string">

                <options val="Commserv"/>

                <options val="HistoryDB"/>

                <options val="WFEngine"/>

                <options val="CVCloud"/>

            </children>

            <children alignment="0" attribute="0"

                className="java.lang.String" controlHidden="0"

                controlType="2" defaultValue=""

                displayName="DBMaintenance type" documentation=""

                hidden="0" inputType="java.lang.String" listType="0"

                maximumValue="" minimumValue="" name="type" readOnly="0"

                required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string">

                <options val="full"/>

                <options val="reindexrecommended"/>

                <options val="recommended"/>

                <options val="checkdb"/>

                <options val="reindexall"/>

                <options val="shrinkdb"/>

            </children>

        </inputs>

        <config className="" name="configuration" type=""/>

    </schema>

    <Start commented="0" continueOnFailure="0" created="0"

        description="" displayName="Start" height="55" interactive="0"

        jobMode="0" name="Start" originalStyle="" skipAttempt="0"

        style="image;image=/images/jgraphx/house.png"

        uniqueName="Start_1" waitSetting="0" width="61" x="4" y="37">

        <inputs val="&lt;inputs />"/>

        <transition activity="Script_1" commented="0" originalStyle=""

            points="" sourceX="76" sourceY="246" status="0"

            style="defaultEdge" targetX="164" targetY="253"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Start>

    <Activity commented="0" continueOnFailure="0"

        created="1549313049453"

        description="iterates a group of activities over a list of values"

        displayName="ForEach" height="296" interactive="0" jobMode="0"

        name="ForEach" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ForEach_1" waitSetting="0" width="590" x="292" y="14">

        <onExit language="1" script="String SuccesslistString = &quot;&quot;; &#xa;String FailurelistString = &quot;&quot;; &#xa;if (xpath:{/workflow/variables/Success_string}!= null) &#xa;for (String s : xpath:{/workflow/variables/Success_string}) &#xa;{ &#xa;   SuccesslistString += &quot;\n&quot; + s; &#xa;   &#xa;} &#xa;if (xpath:{/workflow/variables/Failure_string}!= null) &#xa;{ &#xa;for (String s : xpath:{/workflow/variables/Failure_string}) &#xa;{ &#xa;   FailurelistString += &quot;\n&quot; + s; &#xa;   &#xa;} &#xa;} &#xa; &#xa;workflow.setVariable(&quot;Success_EmailString&quot;,SuccesslistString); &#xa;workflow.setVariable(&quot;Failure_EmailString&quot;,FailurelistString); &#xa;"/>

        <inputs val="&lt;inputs>&lt;name class=&quot;java.lang.String&quot;>DBNames&lt;/name>&lt;values class=&quot;java.lang.Object&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/DBNames}&lt;/values>&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>1&lt;/numberOfParallelExecutions>&lt;continueOnFailure class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/continueOnFailure>&lt;/inputs>"/>

        <superProcess>

            <Start commented="0" continueOnFailure="0"

                created="1549313049453" description=""

                displayName="Start" height="30" interactive="0"

                jobMode="0" name="Start" originalStyle=""

                skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_2" waitSetting="0" width="120" x="21" y="35">

                <inputs val="&lt;inputs />"/>

                <transition activity="ExecuteCommand_6" commented="0"

                    originalStyle="" points="" sourceX="78" sourceY="45"

                    status="0" style="defaultEdge" targetX="98"

                    targetY="158" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity commented="0" continueOnFailure="1"

                created="1371061976178"

                description="Execute a list of commands"

                displayName="execute dbmaintenance " height="34"

                interactive="0" jobMode="0" maxRestarts="0"

                name="ExecuteCommand"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=ExecuteCommand"

                uniqueName="ExecuteCommand_6" waitSetting="0"

                width="212" x="19" y="97">

                <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>&lt;clientName class=&quot;java.lang.String&quot; />&lt;clientId class=&quot;java.lang.Integer&quot; />&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; />&lt;command class=&quot;java.lang.String&quot;>DBMaintenance -N xpath:{/workflow/ForEach_1/DBNames} -xpath:{/workflow/inputs/type}&lt;/command>&lt;arguments class=&quot;java.lang.String&quot; />&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

                <transition activity="Decision_2" commented="0"

                    originalStyle="" points="" sourceX="133"

                    sourceY="168" status="0" style="defaultEdge"

                    targetX="368" targetY="125" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1549313495434"

                description="if/else based decision"

                displayName="Success" height="100" interactive="0"

                jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_2"

                waitSetting="0" width="100" x="273" y="48">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/ExecuteCommand_6/exitCode}==0 &amp;amp;&amp;amp; xpath:{/workflow/ExecuteCommand_6/errorCode}==0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="LogEvent_4" commented="0"

                    displayName="Yes" originalStyle="" points=""

                    sourceX="404" sourceY="131" status="0"

                    style="defaultEdge" targetX="606" targetY="132"

                    transitionIndex="0" value="true" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="LogEvent_3" commented="0"

                    displayName="No" originalStyle="" points=""

                    sourceX="404" sourceY="131" status="0"

                    style="defaultEdge" targetX="408" targetY="215"

                    transitionIndex="0" value="false" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1549313520921"

                description="logs an event in the commcell console with the specified severity level"

                displayName="Failed Event" height="34" interactive="0"

                jobMode="0" name="LogEvent"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=LogEvent" uniqueName="LogEvent_3"

                waitSetting="0" width="111" x="266" y="192">

                <onExit language="1" script="String s1= &quot;***************************************************************************&quot;+&quot;\n&quot;+&quot;DBmaintenance type [ &quot; + xpath:{/workflow/inputs/type} +&quot; ] failed on the commcell [ &quot;+  xpath:{/workflow/system/commCellName} + &quot;  ] for DB [ &quot;+ xpath:{/workflow/ForEach_1/DBNames}+ &quot; ]&quot; +&quot;\n\n&quot;+ &quot;Error:  &quot;+&quot;\n&quot;+ xpath:{/workflow/ExecuteCommand_6/commandOutput} + &quot;\n\n&quot;+&quot;Status:&quot;+&quot;\n&quot;+xpath:{/workflow/ExecuteCommand_6/system/status}+&quot;\n\n&quot;+&quot;***************************************************************************&quot;+&quot;\n&quot;; &#xa;workflow.setVariable(&quot;str_failure&quot;,s1);"/>

                <inputs val="&lt;inputs>&lt;severity class=&quot;workflow.types.SeverityLevel&quot;>MAJOR&lt;/severity>&lt;message class=&quot;java.lang.String&quot;>dbmaintenance type [xpath:{/workflow/inputs/type}] for Database[xpath:{/workflow/ForEach_1/DBNames}] failed&lt;/message>&lt;/inputs>"/>

                <transition activity="AddToList_2" commented="0"

                    originalStyle="" points="" sourceX="405"

                    sourceY="222" status="0" style="defaultEdge"

                    targetX="406" targetY="281" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1549313531409"

                description="logs an event in the commcell console with the specified severity level"

                displayName="Success Event" height="34" interactive="0"

                jobMode="0" name="LogEvent"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=LogEvent" uniqueName="LogEvent_4"

                waitSetting="0" width="124" x="450" y="81">

                <onExit language="1" script="String s1= &quot;***************************************************************************&quot; + &quot;\n&quot; +&quot;DBmaintenance type [ &quot; + xpath:{/workflow/inputs/type} +&quot; ] completed on the commcell [ &quot;+  xpath:{/workflow/system/commCellName} + &quot;  ] for DB [ &quot;+ xpath:{/workflow/ForEach_1/DBNames}+ &quot; ]&quot; +&quot;\n\n&quot;+ &quot;Command Output: &quot;+&quot;\n&quot;+ xpath:{/workflow/ExecuteCommand_6/commandOutput} + &quot;\n&quot;+&quot;Status:&quot;+&quot;\n&quot;+xpath:{/workflow/ExecuteCommand_6/system/status}+&quot;\n&quot; + &quot;***************************************************************************&quot;+&quot;\n&quot;; &#xa;workflow.setVariable(&quot;str_success&quot;,s1);"/>

                <inputs val="&lt;inputs>&lt;severity class=&quot;workflow.types.SeverityLevel&quot;>INFO&lt;/severity>&lt;message class=&quot;java.lang.String&quot;>dbmaintenance type [xpath:{/workflow/inputs/type}] for Database[xpath:{/workflow/ForEach_1/DBNames}] completed&lt;/message>&lt;/inputs>"/>

                <transition activity="AddToList_1" commented="0"

                    originalStyle="" points="" sourceX="648"

                    sourceY="129" status="0" style="defaultEdge"

                    targetX="657" targetY="189" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1552024129501"

                description="utility to add objects to a list"

                displayName="Passed" height="34" interactive="0"

                jobMode="0" name="AddToList"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.ListActivityAdd"

                uniqueName="AddToList_1" waitSetting="0" width="100"

                x="453" y="143">

                <onExit language="1" script=" &#xa;"/>

                <inputs val="&lt;inputs>&lt;addToList class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/Success_string}&lt;/addToList>&lt;itemToAdd class=&quot;java.lang.Object&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/str_success}&lt;/itemToAdd>&lt;/inputs>"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1552029715485"

                description="utility to add objects to a list"

                displayName="Failed " height="34" interactive="0"

                jobMode="0" name="AddToList"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.ListActivityAdd"

                uniqueName="AddToList_2" waitSetting="0" width="100"

                x="268" y="247">

                <inputs val="&lt;inputs>&lt;addToList class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/Failure_string}&lt;/addToList>&lt;itemToAdd class=&quot;java.lang.Object&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/str_failure}&lt;/itemToAdd>&lt;/inputs>"/>

            </Activity>

        </superProcess>

        <activitySchema>

            <outputs name="outputs">

                <children attribute="0" className="java.lang.String"

                    controlType="0" defaultValue="" displayName=""

                    documentation="" hidden="0"

                    inputType="java.lang.String" listType="0"

                    name="DBNames" type="{http://www.w3.org/2001/XMLSchema}string"/>

            </outputs>

            <inputs className="" name="" type="">

                <children attribute="0" className="java.lang.String"

                    hidden="0" inputType="java.lang.String" listType="0"

                    name="name" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children attribute="0" className="java.lang.Object"

                    hidden="0" inputType="java.lang.Object" listType="0"

                    name="values" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                <children attribute="0" className="java.lang.Integer"

                    defaultValue="1" hidden="0"

                    inputType="java.lang.Integer" listType="0"

                    name="numberOfParallelExecutions" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                <children attribute="0" className="java.lang.Boolean"

                    defaultValue="false" hidden="0"

                    inputType="java.lang.Boolean" listType="0"

                    name="continueOnFailure" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

            </inputs>

        </activitySchema>

        <transition activity="Email_1" commented="0" originalStyle=""

            points="" sourceX="675" sourceY="201" status="0"

            style="defaultEdge" targetX="1177" targetY="210"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1549319262224"

        description="activity to execute code snippets in the selected language"

        displayName="Process &#xa;DBNames" height="42" interactive="0"

        jobMode="0" name="Script"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.ScriptActivity"

        uniqueName="Script_1" waitSetting="0" width="100" x="126" y="42">

        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;Vector dbinputs =xpath:{/workflow/inputs/DBNAMES};&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;DBNames&amp;quot;,dbinputs);&amp;#xD;&amp;#xA;logger.info(&amp;quot;Database need to be process  : &amp;quot;+workflow.getVariable(&amp;quot;DBNames&amp;quot;));&amp;#xD;&amp;#xA;String[] str_success={};&amp;#xD;&amp;#xA;String[] str_failure={};&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;Success_string&amp;quot;,str_success);&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;Failure_string&amp;quot;,str_failure);&quot; />&lt;/inputs>"/>

        <transition activity="ForEach_1" commented="0" originalStyle=""

            sourceX="176" sourceY="63" status="0" style="defaultEdge"

            targetX="523" targetY="22" transitionIndex="0" x="0" y="0">

            <condition language="4" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="1"

        created="1371062203820"

        description="Sends an email to a list of users"

        displayName="Email" height="34" interactive="0" jobMode="0"

        maxRestarts="0" name="Email"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Email"

        uniqueName="Email_1" waitSetting="0" width="100" x="949" y="146">

        <inputs val="&lt;inputs>&lt;email>&lt;from />&lt;to>xpath:{/workflow/system/executor/userName}&lt;/to>&lt;cc />&lt;bcc />&lt;subject>dbmaintenance job status &lt;/subject>&lt;attachments />&lt;repeatInterval />&lt;body>DBmaintenance Job Status for job id [xpath:{/workflow/system/jobId}]&amp;#xD; &amp;#xD;&amp;#xD; &amp;#xD;xpath:{/workflow/variables/Success_EmailString}&amp;#xD; &amp;#xD;xpath:{/workflow/variables/Failure_EmailString}&amp;#xD; &amp;#xD;&amp;#xD; &amp;#xD;&lt;/body>&lt;html>false&lt;/html>&lt;/email>&lt;/inputs>"/>

    </Activity>

    <formProperties css="" formVersion="0" javaScript="" pageMode="0">

        <rules/>

    </formProperties>

</workflow>

'

IF not exists (select * from WF_Definition where Name = @name)

BEGIN
	INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision)


	VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision)

	SET @workflowId = @@IDENTITY
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


	VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

	SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = ISNULL(revision, '') From WF_Definition WHERE Name = @name

	IF (@currentFlags & 4 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0) AND (@currentRevision <> @revision)

	BEGIN

		SET @version = @version + 1

		UPDATE WF_Definition

		SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision

		WHERE Name = @name

		IF (@flags & 8 > 0 OR @flags & 16 > 0)

		BEGIN

			UPDATE WF_Definition

			SET flags = @flags

			WHERE Name = @name

		END
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


		VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

	END

END

