

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_CreateMountPathLabels.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/WFD_CreateMountPathLabels.script,v $ $Id: WFD_CreateMountPathLabels.script,v 1.1.2.7 2020/10/04 01:03:58 abilbrey Exp $"
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER ON

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.1.2.7 $'

SET @name = 'CreateMountPathLabels'

SET @description = 'Run this workflow to create mount path labels on mount paths that does not have it.'

SET @version = 21

SET @flags = 6 -- AUTODEPLOY=2,  CV_WORKFLOW=4

SET @definition = '<workflow apiMode="0" config="&lt;configuration />"

    description="Run this workflow to create mount path labels on mount paths that does not have it."

    executeOnWeb="0"

    inputs="&lt;inputs>&lt;mountPathId class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;/inputs>"

    interactive="1" isHtmlDescription="0" manualPercentageComplete="0"

    name="CreateMountPathLabels" outputs="&lt;outputs />"

    revision="$Revision: 1.1.2.7 $" tags=""

    uniqueGuid="1f601112-e557-4167-a490-d9d4ccffa43b"

    variables="&lt;variables>&lt;table class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;selectedMPs class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;loopVar class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;arglist class=&quot;java.lang.String&quot; _list_=&quot;true&quot; />&lt;libName class=&quot;java.lang.String&quot; _list_=&quot;true&quot; />&lt;folderName class=&quot;java.lang.String&quot; _list_=&quot;true&quot; />&lt;nLabelsCreated class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;result class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;nLabelsExisting class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;nMountPathsSelected class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;failedRows class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;successRows class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;mediaAgentName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/variables>"

    webHidden="0" workflowId="0">

    <schema>

        <outputs className="" name="outputs" type=""/>

        <variables attribute="0" className="" name="variables" type="">

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="table" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="selectedMPs" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="arguments" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.Integer"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0"

                inputType="java.lang.Integer" listType="0"

                name="loopVar" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="1" name="arglist" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="1" name="libName" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="1" name="folderName" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.Integer"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0"

                inputType="java.lang.Integer" listType="0"

                name="nLabelsCreated" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="result" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.Integer"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0"

                inputType="java.lang.Integer" listType="0"

                name="nLabelsExisting" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.Integer"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.Integer" listType="0"

                name="nMountPathsSelected" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="failedRows" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="successRows" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="mediaAgentName" type="{http://www.w3.org/2001/XMLSchema}string"/>

        </variables>

        <inputs attribute="0" className="" name="inputs" type="">

            <children attribute="0" className="java.lang.Integer"

                controlHidden="1" controlType="0" defaultValue=""

                displayName="" documentation="" hidden="0"

                inputType="java.lang.Integer" listType="0"

                maximumValue="" minimumValue="" name="mountPathId"

                readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

        </inputs>

        <config className="" name="configuration" type=""/>

    </schema>

    <Start commented="0" continueOnFailure="0" created="0"

        description="" displayName="Start" height="36" interactive="0"

        jobMode="0" name="Start" originalStyle="" skipAttempt="0"

        style="image;image=/images/jgraphx/house.png"

        uniqueName="Start_1" waitSetting="0" width="58" x="51" y="47">

        <inputs val="&lt;inputs />"/>

        <transition activity="Decision_3" commented="0" originalStyle=""

            points="" sourceX="81" sourceY="43" status="0"

            style="defaultEdge" targetX="221" targetY="63"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Start>

    <Activity commented="0" continueOnFailure="0"

        created="1469702010375"

        description="executes queries against a commcell database"

        displayName="Get MountPath Details" height="34" interactive="0"

        jobMode="0" name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.CommServDBQuery"

        uniqueName="CommServDBQuery_1" waitSetting="0" width="155"

        x="459" y="254">

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>&amp;#xD;&#xd;&#xa;IF OBJECT_ID(&apos;tempdb.dbo.#tmpMountPathInfo&apos;) IS NOT NULL DROP TABLE #tmpMountPathInfo&amp;#xD;&#xd;&#xa;SELECT&#x9;DC.Folder, MP.MountPathName, MP.LibraryId, MP.MountPathId, ML.AliasName, DC.UserName, DC.UserPassword,&amp;#xD;&#xd;&#xa;&#x9;&#x9;(SELECT number FROM APP_CommCell WHERE id = MP.origCCcommCellID) CommcellNumber, DC.CredentialAssocId&amp;#xD;&#xd;&#xa;INTO    #tmpMountPathInfo&amp;#xD;&#xd;&#xa;FROM&#x9;MMDeviceController DC&amp;#xD;&#xd;&#xa;        INNER JOIN MMMountPathToStorageDevice MPSD ON MPSD.DeviceId = DC.DeviceId&amp;#xD;&#xd;&#xa;        INNER JOIN MMMountPath MP ON MP.MountPathId = MPSD.MountPathId&amp;#xD;&#xd;&#xa;&#x9;&#x9;INNER JOIN MMLibrary ML ON ML.LibraryId = MP.LibraryId&amp;#xD;&#xd;&#xa;where&#x9;DC.ClientId = xpath:{/workflow/PopupInput_1/mediaAgent/mediaAgentId}  &amp;#xD;&#xd;&#xa;&#x9;&#x9;AND ML.LibraryTypeId = 3&amp;#xD;&#xd;&#xa;&#x9;&#x9;AND MP.MountPathTypeId = 4&amp;#xD;&#xd;&#xa;&#x9;&#x9;AND DC.DeviceAccessType &amp;amp; 2 = 2 &amp;#xD;&#xd;&#xa;&#x9;&#x9;AND DC.DeviceAccessType &amp;amp; 16 = 0 &amp;#xD;&#xd;&#xa;&#x9;&#x9;AND DC.DeviceAccessType &amp;amp; 32 = 0 &amp;#xD;&#xd;&#xa;&#x9;&#x9;AND DC.DeviceAccessType &amp;amp; 128 = 0&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;EXEC MMS2GetDeviceControllerCredentials &apos;#tmpMountPathInfo&apos;, &apos;CredentialAssocId&apos;, &apos;UserName&apos;, &apos;UserPassword&apos;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;SELECT  *&amp;#xD;&#xd;&#xa;FROM    #tmpMountPathInfo&lt;/query>&lt;/inputs>"/>

        <transition activity="Script_2" commented="0" originalStyle=""

            points="" sourceX="376" sourceY="227" status="0"

            style="defaultEdge" targetX="606" targetY="474"

            transitionIndex="0" x="73" y="-1">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;xpath:{/workflow/CommServDBQuery_1/resultSets/rowCount}!=0;"/>

        </transition>

        <transition activity="WorkflowEnd_4" commented="0"

            originalStyle="" points="" sourceX="549" sourceY="252"

            status="0" style="defaultEdge" targetX="546" targetY="328"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;xpath:{/workflow/CommServDBQuery_1/resultSets/rowCount}==0;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1469703039057"

        description="activity to execute code snippets in the selected language"

        displayName="Script" height="34" interactive="0" jobMode="0"

        name="Script" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.ScriptActivity"

        uniqueName="Script_2" waitSetting="0" width="148" x="709" y="254">

        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;&amp;#xD;&amp;#xA;Vector resultSet=null;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if(xpath:{/workflow/inputs/mountPathId} != null){  &amp;#xD;&amp;#xA;    resultSet =xpath:{/workflow/CommServDBQuery_6/resultSets};&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;mediaAgentName&amp;quot;,xpath:{/workflow/PopupInput_6/MediaAgent});&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;else if(xpath:{/workflow/PopupInput_1/forAllMountPaths}){&amp;#xD;&amp;#xA;    resultSet = xpath:{/workflow/CommServDBQuery_1/resultSets};&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;mediaAgentName&amp;quot;, xpath:{/workflow/PopupInput_1/mediaAgent/mediaAgentName});&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;else{&amp;#xD;&amp;#xA;    resultSet = xpath:{/workflow/CommServDBQuery_4/resultSets};&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;mediaAgentName&amp;quot;, xpath:{/workflow/PopupInput_1/mediaAgent/mediaAgentName});  &amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;if (resultSet == null)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    return null;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;int nMountPaths=0;&amp;#xD;&amp;#xA;List arg = new ArrayList();&amp;#xD;&amp;#xA;List libName = new ArrayList();&amp;#xD;&amp;#xA;List folderName = new ArrayList();&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if(!resultSet.isEmpty())&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    DataSet ds; //workflow.types.data.DataSet&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    if (resultSet instanceof List )&amp;#xD;&amp;#xA;        ds = (DataSet) ((List) resultSet).get(0); &amp;#xD;&amp;#xA;    else &amp;#xD;&amp;#xA;        ds = (DataSet) resultSet;&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;   &amp;#xD;&amp;#xA;    for (int r = 0; r &amp;lt; ds.getRowCount(); r++) &amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        boolean isNwPath=false, isUnixPath=false;&amp;#xD;&amp;#xA;        String folder       =   String.valueOf(ds.getRows().get(r).get(0));&amp;#xD;&amp;#xA;        String MpName       =   String.valueOf(ds.getRows().get(r).get(1));&amp;#xD;&amp;#xA;        String LibId        =   String.valueOf(ds.getRows().get(r).get(2));&amp;#xD;&amp;#xA;        String MpId         =   String.valueOf(ds.getRows().get(r).get(3));&amp;#xD;&amp;#xA;        String LibName      =   String.valueOf(ds.getRows().get(r).get(4));&amp;#xD;&amp;#xA;        String Username     =   String.valueOf(ds.getRows().get(r).get(5));&amp;#xD;&amp;#xA;        String Password     =   String.valueOf(ds.getRows().get(r).get(6));&amp;#xD;&amp;#xA;        String CC_num       =   String.valueOf(ds.getRows().get(r).get(7));&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        if(folder.charAt(0) == &apos;\\&apos; &amp;amp;&amp;amp; folder.charAt(1) == &apos;\\&apos;)&amp;#xD;&amp;#xA;           isNwPath = true;&amp;#xD;&amp;#xA;        if(folder.charAt(0) == &apos;/&apos;)&amp;#xD;&amp;#xA;            isUnixPath = true;&amp;#xD;&amp;#xA;        String userinfo = isNwPath ? &amp;quot; -username &amp;quot; + Username + &amp;quot; -password &amp;quot; + Password : &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;        if(isUnixPath)&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            arg.add( CC_num + &amp;quot; \&amp;quot;&amp;quot;                     //Commcell number&amp;#xD;&amp;#xA;                          + folder + &amp;quot;/&amp;quot;                 //Folder name and a &apos;\&apos;&amp;#xD;&amp;#xA;                          + MpName + &amp;quot;/CV_MAGNETIC\&amp;quot; &amp;quot;   //MountPath name&amp;#xD;&amp;#xA;                          + LibId + &amp;quot; &amp;quot;                   //Library ID&amp;#xD;&amp;#xA;                          + MpId                          //MountPath ID&amp;#xD;&amp;#xA;                          + userinfo);                    //Username and Password in case of NW paths&amp;#xD;&amp;#xA;            &amp;#xD;&amp;#xA;            folderName.add(folder+&amp;quot;/&amp;quot; + MpName);    //Folder name + \ + MountPathName&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;        else&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            arg.add( CC_num + &amp;quot; \&amp;quot;&amp;quot;                     //Commcell number&amp;#xD;&amp;#xA;                        + folder + &amp;quot;\\&amp;quot;                 //Folder name and a &apos;\&apos;&amp;#xD;&amp;#xA;                        + MpName + &amp;quot;\\CV_MAGNETIC\&amp;quot; &amp;quot;   //MountPath name&amp;#xD;&amp;#xA;                        + LibId + &amp;quot; &amp;quot;                   //Library ID&amp;#xD;&amp;#xA;                        + MpId                          //MountPath ID&amp;#xD;&amp;#xA;                        + userinfo);                    //Username and Password in case of NW paths&amp;#xD;&amp;#xA;            &amp;#xD;&amp;#xA;            folderName.add(folder+&amp;quot;\\&amp;quot; + MpName);    //Folder name + \ + MountPathName&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        libName.add(LibName);       //Library name&amp;#xD;&amp;#xA;        nMountPaths++;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;arglist&amp;quot;, arg);&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;libName&amp;quot;, libName);&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;folderName&amp;quot;, folderName);&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;nMountPathsSelected&amp;quot;, nMountPaths);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;logger.info(&amp;quot;Arglist: &amp;quot; + arg);&amp;#xD;&amp;#xA;logger.info(&amp;quot;libName: &amp;quot; + libName);&amp;#xD;&amp;#xA;logger.info(&amp;quot;folderName: &amp;quot; + folderName);&amp;#xD;&amp;#xA;logger.info(&amp;quot;nMountPathsSelected: &amp;quot; + nMountPaths);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;nLabelsCreated&amp;quot;, 0);&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;nLabelsExisting&amp;quot;, 0);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;String table=&amp;quot;\n&amp;lt;table &amp;gt;\n  &amp;lt;tr&amp;gt;\n    &amp;lt;th&amp;gt;Library&amp;lt;/th&amp;gt;\n    &amp;lt;th&amp;gt;MountPath&amp;lt;/th&amp;gt;\n    &amp;lt;th&amp;gt;Status&amp;lt;/th&amp;gt;\n    &amp;lt;th&amp;gt;Details&amp;lt;/th&amp;gt;\n  &amp;lt;/tr&amp;gt;\n&amp;quot;;&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;table&amp;quot;, table);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;loopVar&amp;quot;, 0);&quot; />&lt;/inputs>"/>

        <transition activity="Decision_2" commented="0"

            displayName="Set i = 0" originalStyle="" points=""

            sourceX="753" sourceY="243" status="0" style="defaultEdge"

            targetX="894" targetY="314" transitionIndex="0" x="73" y="-1">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1469774290642"

        description="popups an input form for the user to fill out"

        displayName="Select Media Agent" height="34" interactive="0"

        jobMode="0" maxRestarts="0" name="PopupInput"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.InteractiveInputActivity"

        uniqueName="PopupInput_1" waitSetting="0" width="139" x="229" y="148">

        <inputs val="&lt;inputs>&lt;inputs>&lt;mediaAgent class=&quot;commvault.msgs.CvEntities.MediaAgentEntity&quot; _list_=&quot;false&quot;>&lt;mediaAgentName />&lt;mediaAgentId />&lt;/mediaAgent>&lt;forAllMountPaths class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/forAllMountPaths>&lt;/inputs>&lt;subject>Select Media Agent&lt;/subject>&lt;formProperties>&amp;lt;?xml version=&apos;1.0&apos; encoding=&apos;UTF-8&apos;?&amp;gt;&amp;lt;Workflow_FormProperties css=&quot;&quot; javaScript=&quot;&quot; /&amp;gt;&lt;/formProperties>&lt;/inputs>"/>

        <activitySchema>

            <outputs className="" defaultValue="" listType="0"

                name="outputs" type="">

                <children attribute="0"

                    className="commvault.msgs.CvEntities.MediaAgentEntity"

                    controlHidden="0" controlType="2" defaultValue=""

                    displayName="Media Agent" documentation=""

                    hidden="0"

                    inputType="commvault.msgs.CvEntities.MediaAgentEntity"

                    listType="0" maximumValue="" minimumValue=""

                    name="mediaAgent" readOnly="0" required="1"

                    searchable="0" type="{commvault.msgs.CvEntities}MediaAgentEntity">

                    <children attribute="0" className="java.lang.String"

                        defaultValue="" inputType="java.lang.String"

                        listType="0" name="mediaAgentName" type="{http://www.w3.org/2001/XMLSchema}string"/>

                    <children attribute="0"

                        className="java.lang.Integer" defaultValue=""

                        inputType="java.lang.Integer" listType="0"

                        name="mediaAgentId" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                </children>

                <children attribute="0" className="java.lang.Boolean"

                    controlHidden="0" controlType="5" defaultValue=""

                    displayName="Create label files for all mount paths associated with this Media Agent"

                    documentation="" hidden="0"

                    inputType="java.lang.Boolean" listType="0"

                    maximumValue="" minimumValue=""

                    name="forAllMountPaths" readOnly="0" required="0"

                    searchable="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                <children className="java.lang.Boolean"

                    inputType="java.lang.Boolean" name="okClicked" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                <children className="java.lang.String"

                    inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string"/>

            </outputs>

            <inputs className="" defaultValue="" listType="0"

                name="inputs" type="">

                <children attribute="0"

                    className="commvault.msgs.CvEntities.MediaAgentEntity"

                    controlHidden="0" controlType="2" defaultValue=""

                    displayName="Media Agent" documentation=""

                    hidden="0"

                    inputType="commvault.msgs.CvEntities.MediaAgentEntity"

                    listType="0" maximumValue="" minimumValue=""

                    name="mediaAgent" readOnly="0" required="1"

                    searchable="0" type="{commvault.msgs.CvEntities}MediaAgentEntity">

                    <children attribute="0" className="java.lang.String"

                        defaultValue="" inputType="java.lang.String"

                        listType="0" name="mediaAgentName" type="{http://www.w3.org/2001/XMLSchema}string"/>

                    <children attribute="0"

                        className="java.lang.Integer" defaultValue=""

                        inputType="java.lang.Integer" listType="0"

                        name="mediaAgentId" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                </children>

                <children attribute="0" className="java.lang.Boolean"

                    controlHidden="0" controlType="5" defaultValue=""

                    displayName="Create label files for all mount paths associated with this Media Agent"

                    documentation="" hidden="0"

                    inputType="java.lang.Boolean" listType="0"

                    maximumValue="" minimumValue=""

                    name="forAllMountPaths" readOnly="0" required="0"

                    searchable="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

            </inputs>

        </activitySchema>

        <transition activity="Decision_1" commented="0" originalStyle=""

            points="" sourceX="160" sourceY="118" status="0"

            style="defaultEdge" targetX="188" targetY="189"

            transitionIndex="0" x="73" y="-1">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;xpath:{/workflow/PopupInput_1/okClicked};"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1469787572991"

        description="displays an informational message to the user"

        displayName="Display Results" height="34" interactive="0"

        jobMode="0" name="InformationalMessage"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.InteractiveMessageActivity"

        uniqueName="InformationalMessage_5" waitSetting="0" width="157"

        x="1319" y="257">

        <inputs val="&lt;inputs>&lt;message>xpath:{/workflow/variables/result}&lt;/message>&lt;dialogType>Popup&lt;/dialogType>&lt;iconType>Information&lt;/iconType>&lt;title>MountPath Label Creation Result&lt;/title>&lt;html>true&lt;/html>&lt;formProperties>&amp;lt;?xml version=&apos;1.0&apos; encoding=&apos;UTF-8&apos;?&amp;gt;&amp;lt;Workflow_FormProperties css=&quot;table,th,td {&amp;amp;#xd;&amp;amp;#xa;border:1px solid blue;&amp;amp;#xd;&amp;amp;#xa;border-collapse: collapse;&amp;amp;#xd;&amp;amp;#xa; }&quot; javaScript=&quot;&quot; /&amp;gt;&lt;/formProperties>&lt;/inputs>"/>

        <activitySchema>

            <outputs className="" defaultValue="" listType="0"

                name="outputs" type="">

                <children attribute="0" className="java.lang.String"

                    defaultValue="" hidden="0"

                    inputType="java.lang.String" listType="0"

                    name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string"/>

            </outputs>

            <inputs className="" defaultValue="" listType="0"

                name="inputs" type=""/>

        </activitySchema>

        <onEnter language="1" script="&#xd;&#xa;logger.info(&quot;Result:&quot; + xpath:{/workflow/variables/result});"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1469795732409"

        description="popups an input form for the user to fill out"

        displayName="Select Library" height="37" interactive="0"

        jobMode="0" name="PopupInput"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.InteractiveInputActivity"

        uniqueName="PopupInput_2" waitSetting="0" width="171" x="213" y="482">

        <onExit language="1" script="logger.info(&quot;Selected library:&quot;+xpath:{/workflow/PopupInput_2/library});"/>

        <inputs val="&lt;inputs>&lt;inputs>&lt;library class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/CommServDBQuery_2/resultSets/row/col[1]}&lt;/library>&lt;/inputs>&lt;subject>Select Library&lt;/subject>&lt;formProperties>&amp;lt;?xml version=&apos;1.0&apos; encoding=&apos;UTF-8&apos;?&amp;gt;&amp;lt;Workflow_FormProperties css=&quot;&quot; javaScript=&quot;&quot; /&amp;gt;&lt;/formProperties>&lt;/inputs>"/>

        <activitySchema>

            <outputs className="" defaultValue="" listType="0"

                name="outputs" type="">

                <children attribute="0" className="java.lang.String"

                    controlType="2" defaultValue=""

                    displayName="Library" documentation="" hidden="0"

                    inputType="java.lang.String" listType="0"

                    maximumValue="" minimumValue="" name="library"

                    readOnly="0" required="1" searchable="1" type="{http://www.w3.org/2001/XMLSchema}string">

                    <options val="xpath:{/workflow/CommServDBQuery_2/resultSets/row/col}"/>

                </children>

                <children className="java.lang.Boolean"

                    inputType="java.lang.Boolean" name="okClicked" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                <children className="java.lang.String"

                    inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string"/>

            </outputs>

            <inputs className="" defaultValue="" listType="0"

                name="inputs" type="">

                <children attribute="0" className="java.lang.String"

                    controlType="2" defaultValue=""

                    displayName="Library" documentation="" hidden="0"

                    inputType="java.lang.String" listType="0"

                    maximumValue="" minimumValue="" name="library"

                    readOnly="0" required="1" searchable="1" type="{http://www.w3.org/2001/XMLSchema}string">

                    <options val="xpath:{/workflow/CommServDBQuery_2/resultSets/row/col}"/>

                </children>

            </inputs>

        </activitySchema>

        <transition activity="CommServDBQuery_4" commented="0"

            originalStyle="" points="" sourceX="345" sourceY="229"

            status="0" style="defaultEdge" targetX="350" targetY="366"

            transitionIndex="0" x="73" y="-1">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;xpath:{/workflow/PopupInput_2/okClicked};"/>

        </transition>

        <onEnter language="1" script="logger.info(&quot;Magnetic library list: &quot;+xpath:{/workflow/CommServDBQuery_2/resultSets/row/col});"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1470035521996" description="if/else based decision"

        displayName="Create for All?" height="100" interactive="0"

        jobMode="0" name="Decision"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_1" waitSetting="0" width="111" x="243" y="221">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/PopupInput_1/forAllMountPaths}==true&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="CommServDBQuery_2" commented="0"

            displayName="No" originalStyle="" points="" sourceX="172"

            sourceY="217" status="0" style="defaultEdge" targetX="172"

            targetY="304" transitionIndex="0" value="false" x="73" y="-1">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="CommServDBQuery_1" commented="0"

            displayName="Yes" originalStyle="" points="" sourceX="160"

            sourceY="230" status="0" style="straight" targetX="175"

            targetY="379" transitionIndex="0" value="true" x="73" y="-1">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <onEnter language="1" script="logger.info(&quot;Selected MA: [&quot;+xpath:{/workflow/PopupInput_1/mediaAgent/mediaAgentId}+&quot;]&quot;+xpath:{/workflow/PopupInput_1/mediaAgent/mediaAgentName});&#xd;&#xa;logger.info(&quot;Create for all:&quot;+xpath:{/workflow/PopupInput_1/forAllMountPaths});"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1470048843840"

        description="executes queries against a commcell database"

        displayName="Get Details of Selected Mount Paths" height="36"

        interactive="0" jobMode="0" name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.CommServDBQuery"

        uniqueName="CommServDBQuery_4" waitSetting="0" width="246"

        x="611" y="483">

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>IF OBJECT_ID(&apos;tempdb.dbo.#tmpMountPathInfo&apos;) IS NOT NULL DROP TABLE #tmpMountPathInfo&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;SELECT  DC.Folder, MP.MountPathName, MP.LibraryId, MP.MountPathId, &apos;xpath:{/workflow/PopupInput_2/library}&apos; LibraryName, DC.UserName, DC.UserPassword, &amp;#xD;&#xd;&#xa;        (SELECT number FROM APP_CommCell WHERE id = MP.origCCcommCellID) CommcellNumber, DC.CredentialAssocId&amp;#xD;&#xd;&#xa;INTO    #tmpMountPathInfo&amp;#xD;&#xd;&#xa;FROM    MMDeviceController DC&amp;#xD;&#xd;&#xa;        INNER JOIN MMMountPathToStorageDevice MPSD ON MPSD.DeviceId = DC.DeviceId&amp;#xD;&#xd;&#xa;        INNER JOIN MMMountPath MP ON MP.MountPathId = MPSD.MountPathId&amp;#xD;&#xd;&#xa;WHERE   MP.LibraryId = (SELECT TOP 1 LibraryId FROM MMLibrary WHERE AliasName = &apos;xpath:{/workflow/PopupInput_2/library}&apos;)&amp;#xD;&#xd;&#xa;        AND DC.ClientId = xpath:{/workflow/PopupInput_1/mediaAgent/mediaAgentId}&amp;#xD;&#xd;&#xa;        -- AND Folder + &apos;\&apos; + MountPathName IN ( xpath:{/workflow/variables/selectedMPs})&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;EXEC MMS2GetDeviceControllerCredentials &apos;#tmpMountPathInfo&apos;, &apos;CredentialAssocId&apos;, &apos;UserName&apos;, &apos;UserPassword&apos;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;SELECT  *&amp;#xD;&#xd;&#xa;FROM    #tmpMountPathInfo&lt;/query>&lt;/inputs>"/>

        <transition activity="Script_2" commented="0" originalStyle=""

            points="" sourceX="291" sourceY="479" status="0"

            style="defaultEdge" targetX="558" targetY="470"

            transitionIndex="0" x="73" y="-1">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1470118544998" description="if/else based decision"

        displayName="i &lt; no. of mountpaths" height="119"

        interactive="0" jobMode="0" name="Decision"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_2" waitSetting="0" width="167" x="1044" y="213">

        <onExit language="1" script="if(xpath:{/workflow/variables/loopVar}>=xpath:{/workflow/variables/nMountPathsSelected})&#xd;&#xa;{&#xd;&#xa;    String style=&#xd;&#xa;         &quot;&lt;style>&quot; +&#xd;&#xa;             &quot;table, th, td { border: 1px solid #454545; border-collapse: collapse; font-family: Helvetica, Calibri, \&quot;Times New Roman\&quot;, serif; } font-size: 14px; font-weight:normal; color:#515151;&quot; + &#xd;&#xa;             &quot;th, td {padding: 10px; } &quot; + &#xd;&#xa;             &quot;th {vertical-align: top; text-align: center; background-color: rgb(0, 195, 195);} &quot; + &#xd;&#xa;             &quot;td {text-align: left;} &quot; + &#xd;&#xa;         &quot;&lt;/style>&quot; ;&#xd;&#xa;&#xd;&#xa;    String table= &#xd;&#xa;        &quot;&lt;table>&quot; + &#xd;&#xa;        &quot;&lt;tbody>&quot; +&#xd;&#xa;            &quot;&lt;tr>&quot; +&#xd;&#xa;                &quot;&lt;th>Library&lt;/th>&quot; +&#xd;&#xa;                &quot;&lt;th>MountPath&lt;/th>&quot; +&#xd;&#xa;                &quot;&lt;th>Status&lt;/th>&quot; +&#xd;&#xa;                &quot;&lt;th>Details&lt;/th>&quot; +&#xd;&#xa;            &quot;&lt;/tr>&quot;;&#xd;&#xa;    table = table + xpath:{/workflow/variables/failedRows} + xpath:{/workflow/variables/successRows} + &quot;&lt;/table>&quot;;&#xd;&#xa;    workflow.setVariable(&quot;table&quot;,table);&#xd;&#xa;    &#xd;&#xa;    logger.info(&quot;nLabelsCreated:&quot;+xpath:{/workflow/variables/nLabelsCreated});&#xd;&#xa;    logger.info(&quot;nLabelsExisting:&quot;+xpath:{/workflow/variables/nLabelsExisting});&#xd;&#xa;    logger.info(&quot;nMountPathsSelected:&quot; + xpath:{/workflow/variables/nMountPathsSelected});&#xd;&#xa;    &#xd;&#xa;    String result=&quot;&quot;;&#xd;&#xa;    table=((int)xpath:{/workflow/variables/nMountPathsSelected})==0?&quot;&quot;:table;//Dont print the table if its empty&#xd;&#xa;     &#xd;&#xa;    result = style+&#xd;&#xa;               &quot;&lt;table>&quot; + &#xd;&#xa;               &quot;&lt;tbody>&quot; +&#xd;&#xa;               &quot;&lt;tr>&quot; +&#xd;&#xa;                   &quot;&lt;th>Number of MountPaths selected: &lt;/th>&quot; +&#xd;&#xa;                   &quot;&lt;td>&quot;+xpath:{/workflow/variables/nMountPathsSelected}+&quot;&lt;/td>&quot; +&#xd;&#xa;               &quot;&lt;/tr>&quot;+&#xd;&#xa;               &quot;&lt;tr>&quot;+&#xd;&#xa;                   &quot;&lt;th>Number of MountPaths on which labels were created: &lt;/th>&quot; +&#xd;&#xa;                   &quot;&lt;td>&quot;+xpath:{/workflow/variables/nLabelsCreated}+&quot;&lt;/td>&quot; +&#xd;&#xa;               &quot;&lt;/tr>&quot;+&#xd;&#xa;               &quot;&lt;tr>&quot;+&#xd;&#xa;                   &quot;&lt;th>Number of MountPaths already having labels: &lt;/th>&quot; +&#xd;&#xa;                   &quot;&lt;td>&quot;+xpath:{/workflow/variables/nLabelsExisting}+&quot;&lt;/td>&quot; +&#xd;&#xa;               &quot;&lt;/tr>&quot;+&#xd;&#xa;               &quot;&lt;tr>&quot;+&#xd;&#xa;                   &quot;&lt;th>Number of MountPaths on which label creation failed: &lt;/th>&quot; +&#xd;&#xa;                   &quot;&lt;td>&quot;+(xpath:{/workflow/variables/nMountPathsSelected} -xpath:{/workflow/variables/nLabelsCreated} - xpath:{/workflow/variables/nLabelsExisting})+&quot;&lt;/td>&quot; +&#xd;&#xa;               &quot;&lt;/tr>&quot;+&#xd;&#xa;               &quot;&lt;/table>&lt;br>&quot;+&#xd;&#xa;               table;&#xd;&#xa;    workflow.setVariable(&quot;result&quot;,result);&#xd;&#xa;}"/>

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/loopVar}&amp;lt;xpath:{/workflow/variables/nMountPathsSelected}&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="InformationalMessage_5" commented="0"

            displayName="No" originalStyle="" points="" sourceX="1127"

            sourceY="246" status="0" style="straight" targetX="1708"

            targetY="255" transitionIndex="0" value="false" x="248" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="Script_3" commented="0" displayName="Yes"

            originalStyle="" points="" sourceX="1090" sourceY="272"

            status="0" style="defaultEdge" targetX="1090" targetY="457"

            transitionIndex="0" value="true" x="248" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="1"

        created="1470119517065"

        description="Execute a command on a remote machine"

        displayName="ExecuteCommand" height="37" interactive="0"

        jobMode="0" maxRestarts="0" name="ExecuteCommand"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.ExecuteCommand"

        uniqueName="ExecuteCommand_2" waitSetting="0" width="148"

        x="968" y="374">

        <onExit language="1" script="logger.info(&quot;Exit Code:&quot; +xpath:{/workflow/ExecuteCommand_2/exitCode}+&quot; Error Code:&quot;+xpath:{/workflow/ExecuteCommand_2/errorCode});&#xd;&#xa;logger.info(&quot;Command Output:&quot;+xpath:{/workflow/ExecuteCommand_2/commandOutput});&#xd;&#xa;String output=xpath:{/workflow/ExecuteCommand_2/commandOutput};&#xd;&#xa;&#xd;&#xa;&#xd;&#xa;String failedRows=xpath:{/workflow/variables/failedRows};&#xd;&#xa;String successRows=xpath:{/workflow/variables/successRows};&#xd;&#xa;String lib=xpath:{/workflow/variables/libName}.get(xpath:{/workflow/variables/loopVar});&#xd;&#xa;String folder=xpath:{/workflow/variables/folderName}.get(xpath:{/workflow/variables/loopVar});&#xd;&#xa;String detail=&quot;&quot;;&#xd;&#xa;int exitCode=xpath:{/workflow/ExecuteCommand_2/exitCode};&#xd;&#xa;boolean success=(exitCode==0)||(exitCode==1);&#xd;&#xa;detail=output.split(&quot;\n&quot;)[0];//show only first line in table&#xd;&#xa;&#xd;&#xa;if(success)&#xd;&#xa;{&#xd;&#xa;    if(exitCode==0)&#xd;&#xa;        workflow.setVariable(&quot;nLabelsCreated&quot;,xpath:{/workflow/variables/nLabelsCreated}+1);&#xd;&#xa;    else if(exitCode==1)&#xd;&#xa;        workflow.setVariable(&quot;nLabelsExisting&quot;,xpath:{/workflow/variables/nLabelsExisting}+1);&#xd;&#xa;    successRows = successRows + &quot;  &lt;tr>\n    &lt;td>&quot;+lib+&quot;&lt;/td>\n    &lt;td>&quot;+folder+&quot;&lt;/td>\n    &lt;td>Success&lt;/td>\n    &lt;td>&quot;+detail+&quot;&lt;/td>\n  &lt;/tr>\n&quot;;&#xd;&#xa;}&#xd;&#xa;else &#xd;&#xa;{&#xd;&#xa;    if(exitCode!=2)&#xd;&#xa;        detail=&quot;Failed due an internal error. Check log for details&quot;;&#xd;&#xa;    failedRows = failedRows + &quot;  &lt;tr>\n    &lt;td>&quot;+lib+&quot;&lt;/td>\n    &lt;td>&quot;+folder+&quot;&lt;/td>\n    &lt;td>Failed&lt;/td>\n    &lt;td>&quot;+detail+&quot;&lt;/td>\n  &lt;/tr>\n&quot;;&#xd;&#xa;}&#xd;&#xa;        &#xd;&#xa;&#xd;&#xa;logger.info(&quot;Tool Stdout: &quot;+ output);&#xd;&#xa;&#xd;&#xa;&#xd;&#xa;workflow.setVariable(&quot;successRows&quot;,successRows);&#xd;&#xa;workflow.setVariable(&quot;failedRows&quot;,failedRows);&#xd;&#xa;&#xd;&#xa;workflow.setVariable(&quot;loopVar&quot;,xpath:{/workflow/variables/loopVar}+1);"/>

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/mediaAgentName}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>CreateMountPathLabel&lt;/command>&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/arguments}&lt;/arguments>&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="Decision_2" commented="0"

            displayName="i++" originalStyle="" points="" sourceX="1243"

            sourceY="434" status="0" style="defaultEdge" targetX="1168"

            targetY="275" transitionIndex="0" x="248" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <onEnter language="1" script="&#xd;&#xa;logger.info(&quot;arguments:&quot;+xpath:{/workflow/variables/arguments});"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1470122030976"

        description="activity to execute code snippets in the selected language"

        displayName="Set Arguments" height="36" interactive="0"

        jobMode="0" name="Script"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.ScriptActivity"

        uniqueName="Script_3" waitSetting="0" width="132" x="1167" y="375">

        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;List arg=xpath:{/workflow/variables/arglist};&amp;#xD;&amp;#xA;logger.info(&amp;quot;Arg(&amp;quot;+xpath:{/workflow/variables/loopVar}+&amp;quot;):&amp;quot;+arg.get(xpath:{/workflow/variables/loopVar}));&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;arguments&amp;quot;,&amp;quot;-directinput &amp;quot;+ arg.get(xpath:{/workflow/variables/loopVar}));&quot; />&lt;/inputs>"/>

        <transition activity="ExecuteCommand_2" commented="0"

            originalStyle="" points="" sourceX="1065" sourceY="427"

            status="0" style="straight" targetX="1261" targetY="421"

            transitionIndex="0" x="247" y="-7">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1472553078384"

        description="executes queries against a commcell database"

        displayName="Get Magnetic Library List" height="34"

        interactive="0" jobMode="0" name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.CommServDBQuery"

        uniqueName="CommServDBQuery_2" waitSetting="0" width="171"

        x="213" y="376">

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>SELECT ML.AliasName&amp;#xD;&#xd;&#xa;FROM   MMLibrary ML&amp;#xD;&#xd;&#xa;WHERE  ML.LibraryTypeId = 3 &amp;#xD;&#xd;&#xa;              AND ML.LibraryId IN (      SELECT DISTINCT MP.LibraryId&amp;#xD;&#xd;&#xa;                                         FROM   MMMountPath MP &amp;#xD;&#xd;&#xa;                                                INNER JOIN MMMountPathToStorageDevice MPSD ON MP.MountPathId = MPSD.MountPathId &amp;#xD;&#xd;&#xa;                                                INNER JOIN MMDeviceController DC ON MPSD.DeviceId = DC.DeviceId &amp;#xD;&#xd;&#xa;                                         WHERE  MP.MountPathTypeId = 4 &amp;#xD;&#xd;&#xa;                                                AND DC.ClientId = xpath:{/workflow/PopupInput_1/mediaAgent/mediaAgentId}&amp;#xD;&#xd;&#xa;                                                AND DC.DeviceAccessType &amp;amp; 2 = 2 &amp;#xD;&#xd;&#xa;                                                AND DC.DeviceAccessType &amp;amp; 16 = 0 &amp;#xD;&#xd;&#xa;                                                AND DC.DeviceAccessType &amp;amp; 32 = 0 &amp;#xD;&#xd;&#xa;                                                AND DC.DeviceAccessType &amp;amp; 128 = 0&amp;#xD;&#xd;&#xa;                                  )&lt;/query>&lt;/inputs>"/>

        <transition activity="WorkflowEnd_4" commented="0"

            originalStyle="" points="" sourceX="298" sourceY="290"

            status="0" style="straight" targetX="82" targetY="366"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;xpath:{/workflow/CommServDBQuery_2/resultSets/rowCount}==0;"/>

        </transition>

        <transition activity="PopupInput_2" commented="0"

            originalStyle="" points="" sourceX="288" sourceY="282"

            status="0" style="defaultEdge" targetX="293" targetY="346"

            transitionIndex="0" x="73" y="-1">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;xpath:{/workflow/CommServDBQuery_2/resultSets/rowCount}!=0;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1473947546381" description="Ends the workflow"

        displayName="WorkflowEnd" height="34" interactive="0"

        jobMode="0" name="WorkflowEnd"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.EndActivity"

        uniqueName="WorkflowEnd_3" waitSetting="0" width="106" x="484" y="148">

        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;>COMPLETED_WITH_ERRORS&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>No Media Agent has local or UNC access to this mount path&lt;/failureMessage>&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1494847058685" description="if/else based decision"

        displayName="Called from MP Level?" height="100" interactive="0"

        jobMode="0" name="Decision"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_3" waitSetting="0" width="156" x="220" y="15">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/mountPathId} != null&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="PopupInput_1" commented="0"

            displayName="No" originalStyle="" points="" sourceX="295"

            sourceY="7" status="0" style="defaultEdge" targetX="277"

            targetY="83" transitionIndex="0" value="false" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="CommServDBQuery_5" commented="0"

            displayName="Yes" originalStyle="" points="" sourceX="296"

            sourceY="62" status="0" style="defaultEdge" targetX="531"

            targetY="62" transitionIndex="0" value="true" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1494847464529"

        description="executes queries against a commcell database"

        displayName="Get Media Agents Associated" height="34"

        interactive="0" jobMode="0" name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.CommServDBQuery"

        uniqueName="CommServDBQuery_5" waitSetting="0" width="196"

        x="439" y="48">

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>SELECT AC.name&amp;#xD;&#xd;&#xa;    FROM APP_Client AC&amp;#xD;&#xd;&#xa;        INNER JOIN MMDeviceController DC ON DC.ClientId = AC.id&amp;#xD;&#xd;&#xa;        INNER JOIN MMMountPathToStorageDevice MPSD ON MPSD.DeviceId = DC.DeviceId&amp;#xD;&#xd;&#xa;    WHERE MPSD.MountPathId= xpath:{/workflow/inputs/mountPathId}&amp;#xD;&#xd;&#xa;        AND DC.DeviceAccessType &amp;amp; 2 = 2 &amp;#xD;&#xd;&#xa;        AND DC.DeviceAccessType &amp;amp; 16 = 0 &amp;#xD;&#xd;&#xa;        AND DC.DeviceAccessType &amp;amp; 32 = 0 &amp;#xD;&#xd;&#xa;        AND DC.DeviceAccessType &amp;amp; 128 = 0&lt;/query>&lt;/inputs>"/>

        <transition activity="PopupInput_6" commented="0"

            originalStyle="" points="" sourceX="527" sourceY="65"

            status="0" style="defaultEdge" targetX="758" targetY="65"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;xpath:{/workflow/CommServDBQuery_5/resultSets/rowCount}!=0;"/>

        </transition>

        <transition activity="WorkflowEnd_3" commented="0"

            originalStyle="" points="" sourceX="558" sourceY="62"

            status="0" style="defaultEdge" targetX="545" targetY="168"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;xpath:{/workflow/CommServDBQuery_5/resultSets/rowCount}==0;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1494847740268"

        description="popups an input form for the user to fill out"

        displayName="Select Media Agent" height="34" interactive="0"

        jobMode="0" name="PopupInput"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.InteractiveInputActivity"

        uniqueName="PopupInput_6" waitSetting="0" width="139" x="718" y="48">

        <inputs val="&lt;inputs>&lt;inputs>&lt;MediaAgent class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/inputs>&lt;subject>Select Media Agent&lt;/subject>&lt;formProperties>&amp;lt;?xml version=&apos;1.0&apos; encoding=&apos;UTF-8&apos;?&amp;gt;&amp;lt;Workflow_FormProperties css=&quot;&quot; javaScript=&quot;&quot; /&amp;gt;&lt;/formProperties>&lt;/inputs>"/>

        <activitySchema>

            <outputs className="" defaultValue="" listType="0"

                name="outputs" type="">

                <children attribute="0" className="java.lang.String"

                    controlHidden="0" controlType="2" defaultValue=""

                    displayName="Media Agents" documentation=""

                    hidden="0" inputType="java.lang.String" listType="0"

                    maximumValue="" minimumValue="" name="MediaAgent"

                    readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string">

                    <options val="xpath:{/workflow/CommServDBQuery_5/resultSets/row/col[1]}"/>

                </children>

                <children className="java.lang.Boolean"

                    inputType="java.lang.Boolean" name="okClicked" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                <children className="java.lang.String"

                    inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string"/>

            </outputs>

            <inputs className="" defaultValue="" listType="0"

                name="inputs" type="">

                <children attribute="0" className="java.lang.String"

                    controlHidden="0" controlType="2" defaultValue=""

                    displayName="Media Agents" documentation=""

                    hidden="0" inputType="java.lang.String" listType="0"

                    maximumValue="" minimumValue="" name="MediaAgent"

                    readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string">

                    <options val="xpath:{/workflow/CommServDBQuery_5/resultSets/row/col[1]}"/>

                </children>

            </inputs>

        </activitySchema>

        <transition activity="CommServDBQuery_6" commented="0"

            originalStyle="" points="" sourceX="758" sourceY="65"

            status="0" style="defaultEdge" targetX="760" targetY="165"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;xpath:{/workflow/PopupInput_6/okClicked};"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1494848101243"

        description="executes queries against a commcell database"

        displayName="Get MountPath Details" height="34" interactive="0"

        jobMode="0" name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.CommServDBQuery"

        uniqueName="CommServDBQuery_6" waitSetting="0" width="155"

        x="702" y="148">

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>IF OBJECT_ID(&apos;tempdb.dbo.#tmpMountPathInfo&apos;) IS NOT NULL DROP TABLE #tmpMountPathInfo&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;SELECT&#x9;DC.Folder, MP.MountPathName, MP.LibraryId, MP.MountPathId, ML.AliasName, DC.UserName, DC.UserPassword, &amp;#xD;&#xd;&#xa;&#x9;&#x9;(SELECT number FROM APP_CommCell WHERE id = MP.origCCcommCellID) CommcellNumber, DC.CredentialAssocId&amp;#xD;&#xd;&#xa;INTO    #tmpMountPathInfo&amp;#xD;&#xd;&#xa;FROM&#x9;MMDeviceController DC&amp;#xD;&#xd;&#xa;&#x9;&#x9;INNER JOIN MMMountPathToStorageDevice MPSD ON MPSD.DeviceId = DC.DeviceId&amp;#xD;&#xd;&#xa;&#x9;&#x9;INNER JOIN MMMountPath MP ON MP.MountPathId = MPSD.MountPathId&amp;#xD;&#xd;&#xa;&#x9;&#x9;INNER JOIN MMLibrary ML ON ML.LibraryId = MP.LibraryId&amp;#xD;&#xd;&#xa;WHERE&#x9;DC.ClientId = (SELECT AC.id FROM APP_Client AC WHERE AC.name LIKE &apos;xpath:{/workflow/PopupInput_6/MediaAgent}&apos;)&amp;#xD;&#xd;&#xa;&#x9;&#x9;AND ML.LibraryTypeId = 3&amp;#xD;&#xd;&#xa;&#x9;&#x9;AND MP.MountPathTypeId = 4&amp;#xD;&#xd;&#xa;&#x9;&#x9;AND MP.MountPathId = xpath:{/workflow/inputs/mountPathId}&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;EXEC MMS2GetDeviceControllerCredentials &apos;#tmpMountPathInfo&apos;, &apos;CredentialAssocId&apos;, &apos;UserName&apos;, &apos;UserPassword&apos;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;SELECT  *&amp;#xD;&#xd;&#xa;FROM    #tmpMountPathInfo&lt;/query>&lt;/inputs>"/>

        <transition activity="Script_2" commented="0" originalStyle=""

            points="" sourceX="760" sourceY="170" status="0"

            style="defaultEdge" targetX="746" targetY="305"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;xpath:{/workflow/CommServDBQuery_6/resultSets/rowCount}!=0;"/>

        </transition>

        <transition activity="WorkflowEnd_3" commented="0"

            originalStyle="" points="" sourceX="760" sourceY="170"

            status="0" style="straight" targetX="597" targetY="172"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;xpath:{/workflow/CommServDBQuery_6/resultSets/rowCount}==0;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1496813385323" description="Ends the workflow"

        displayName="WorkflowEnd" height="34" interactive="0"

        jobMode="0" name="WorkflowEnd"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.EndActivity"

        uniqueName="WorkflowEnd_4" waitSetting="0" width="106" x="484" y="376">

        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;>COMPLETED_WITH_ERRORS&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>This Media Agent does not have local or UNC access to any Mount Paths&lt;/failureMessage>&lt;/inputs>"/>

    </Activity>

    <formProperties css="" javaScript=""/>

</workflow>'

IF not exists (select * from WF_Definition where Name = @name)

BEGIN
	INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision)	


	VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision)

	SET @workflowId = @@IDENTITY
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


	VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

	SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = ISNULL(revision, '') From WF_Definition WHERE Name = @name

	IF (@currentRevision <> @revision)

	BEGIN

		SET @version = @version + 1

		UPDATE WF_Definition

		SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision, flags = @flags

		WHERE Name = @name
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


		VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

	END

END
