

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_CreateCollaborativeShares.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/WFD_CreateCollaborativeShares.script,v $ $Id: WFD_CreateCollaborativeShares.script,v 1.1.2.9 2020/10/04 01:04:02 abilbrey Exp $";
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER ON

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.1.2.9 $'

SET @name = 'Create Collaborative Shares'

SET @description = 'Create shared Edge Drive folders among users'

SET @version = 1

SET @flags = 6

SET @definition = '<workflow apiMode="0"

    description="Create shared folders among users"

    inputs="&lt;inputs>&lt;shareName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;usersName class=&quot;java.lang.String&quot; _list_=&quot;true&quot; />&lt;/inputs>"

    interactive="1" isHtmlDescription="0"

    name="Create Collaborative Shares" outputs="&lt;outputs />"

    revision="$Revision: 1.1.2.9 $"

    uniqueGuid="bd629c67-f175-40b0-ac70-cf014d5da879"

    variables="&lt;variables>&lt;usersList class=&quot;java.lang.String&quot; _list_=&quot;true&quot; />&lt;EdgeDriveRestEndpointURL class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>http://localhost.commvault.com/webconsole/api&lt;/EdgeDriveRestEndpointURL>&lt;EdgeDriveUsername class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&lt;/EdgeDriveUsername>&lt;EdgeDrivePassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; />&lt;sameFolderCount class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>1&lt;/sameFolderCount>&lt;createdFolderGUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;userToken class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;passwordEncoded class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;userListXml class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;invalidUsersList class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;errorMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;ldapEndpointURL class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&lt;/ldapEndpointURL>&lt;ldapPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot;>&lt;/ldapPassword>&lt;ldapQuery class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&lt;/ldapQuery>&lt;ldapSearchBase class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&lt;/ldapSearchBase>&lt;executorSharedTo class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;executorOwner class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;parentShareId class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;parentShareName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;domainName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&lt;/domainName>&lt;/variables>" workflowId="0">

    <schema>

        <outputs className="" name="outputs" type=""/>

        <variables attribute="0" className="" name="variables" type="">

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="1" name="usersList" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="EdgeDriveRestEndpointURL"

                readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="EdgeDriveUsername" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0"

                className="workflow.types.EncryptedString"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0"

                inputType="workflow.types.EncryptedString" listType="0"

                name="EdgeDrivePassword" readOnly="0" type="{workflow.types}EncryptedString"/>

            <children attribute="0" className="java.lang.Integer"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0"

                inputType="java.lang.Integer" listType="0"

                name="sameFolderCount" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="createdFolderGUID" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="userToken" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="passwordEncoded" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="userListXml" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="invalidUsersList" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="errorMessage" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="ldapEndpointURL" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="ldapQuery" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

			<children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="ldapSearchBase" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" 

				className="workflow.types.EncryptedString"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="workflow.types.EncryptedString"

                listType="0" name="ldapPassword" readOnly="0" type="{workflow.types}EncryptedString"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="executorSharedTo" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="executorOwner" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="parentShareId" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="parentShareName" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="domainName" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

        </variables>

        <inputs attribute="0" className="" name="inputs" type="">

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName="Share Name"

                documentation="Provide the collaborative share name"

                hidden="0" inputType="java.lang.String" listType="0"

                maximumValue="" minimumValue="" name="shareName"

                readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue=""

                displayName="Collaborators"

                documentation="Enter comma seperated list of collaborators"

                hidden="0" inputType="java.lang.String" listType="0"

                maximumValue="" minimumValue="" name="usersName"

                readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

        </inputs>

    </schema>

    <Start commented="0" continueOnFailure="0" created="0"

        description="" displayName="Start" height="36" interactive="0"

        jobMode="0" name="Start" originalStyle="" skipAttempt="0"

        style="image;image=/images/jgraphx/house.png"

        uniqueName="Start_1" waitSetting="0" width="58" x="41" y="103">

        <inputs val="&lt;inputs />"/>

        <transition activity="ImpersonateCreator_1" commented="0"

            originalStyle="" points="" sourceX="72" sourceY="190"

            status="0" style="defaultEdge" targetX="157" targetY="277"

            transitionIndex="0" x="2" y="72">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Start>

    <Activity commented="0" continueOnFailure="0"

        created="1465383165148" description="Ends the workflow"

        displayName="WorkflowEnd" height="18" interactive="0"

        jobMode="0" name="WorkflowEnd"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=WorkflowEnd"

        uniqueName="WorkflowEnd_1" waitSetting="0" width="106" x="1234" y="173">

        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;>COMPLETED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1465408335865" description="performs http operations"

        displayName="Create Folder" height="15" interactive="0"

        jobMode="0" name="HttpClient"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=HttpClient"

        uniqueName="createFolder" waitSetting="0" width="106" x="134" y="258">

        <onExit language="3" script="if(xpath:{/workflow/createFolder/statusCode}==401){&#xd;&#xa;    workflow.setVariable(&quot;createdFolderGUID&quot;,&quot;NONE&quot;);&#xd;&#xa;    workflow.setVariable(&quot;errorMessage&quot;, &quot;QSDK Token invalid&quot;);&#xd;&#xa;}else{&#xd;&#xa;    var response = JSON.parse(xpath:{/workflow/createFolder/output});&#xd;&#xa;    if(response.error.errorCode == 0){&#xd;&#xa;        workflow.setVariable(&quot;createdFolderGUID&quot;,response.fileResource.GUID);&#xd;&#xa;    }else{&#xd;&#xa;        logger.info(&quot;Error in Create Folder with message: &quot; + response.error.errorMessage);&#xd;&#xa;        workflow.setVariable(&quot;createdFolderGUID&quot;,&quot;NONE&quot;);&#xd;&#xa;        workflow.setVariable(&quot;errorMessage&quot;, response.error.errorMessage);&#xd;&#xa;    }&#xd;&#xa;}"/>

        <inputs val="&lt;inputs>&lt;request>&lt;url>xpath:{/workflow/variables/EdgeDriveRestEndpointURL}/contentstore/action/createfolder&lt;/url>&lt;method>POST&lt;/method>&lt;postType>Raw&lt;/postType>&lt;postContent>&amp;lt;App_FileResourceInfo name=&quot;xpath:{/workflow/inputs/shareName}&quot; parentPath=&quot;\&quot;/&amp;gt;&lt;/postContent>&lt;postContentType>application/xml;&lt;/postContentType>&lt;headers>&lt;name>Authtoken&lt;/name>&lt;value>xpath:{/workflow/variables/userToken}&lt;/value>&lt;/headers>&lt;headers>&lt;name>Accept&lt;/name>&lt;value>application/json&lt;/value>&lt;/headers>&lt;/request>&lt;/inputs>"/>

        <transition activity="Switch_1" commented="0" originalStyle=""

            points="196.0,297.0" sourceX="660" sourceY="537" status="1"

            style="defaultEdge" targetX="685" targetY="626"

            transitionIndex="0" x="-31" y="122">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1465409200321" description="performs http operations"

        displayName="Create folder repeated request" height="19"

        interactive="0" jobMode="0" name="HttpClient"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=HttpClient"

        uniqueName="createFolderRepeated" waitSetting="0" width="200"

        x="779" y="343">

        <onExit language="3" script="var response = JSON.parse(xpath:{/workflow/createFolderRepeated/output});&#xd;&#xa;if(response.error.errorCode == 0){&#xd;&#xa;    workflow.setVariable(&quot;createdFolderGUID&quot;,response.fileResource.GUID);&#xd;&#xa;}else if(response.error.errorCode == 409){&#xd;&#xa;    var count = xpath:{/workflow/variables/sameFolderCount};&#xd;&#xa;    count = count + 1;&#xd;&#xa;    count = count | 0;&#xd;&#xa;    workflow.setVariable(&quot;sameFolderCount&quot;,count);&#xd;&#xa;}else{&#xd;&#xa;    logger.info(&quot;Error in login with message: &quot; + response.error.errorCode);&#xd;&#xa;    workflow.setVariable(&quot;createdFolderGUID&quot;,&quot;NONE&quot;);&#xd;&#xa;}"/>

        <inputs val="&lt;inputs>&lt;request>&lt;url>xpath:{/workflow/variables/EdgeDriveRestEndpointURL}/contentstore/action/createfolder&lt;/url>&lt;method>POST&lt;/method>&lt;postType>Raw&lt;/postType>&lt;postContent>&amp;lt;App_FileResourceInfo name=&quot;xpath:{/workflow/inputs/shareName}(xpath:{/workflow/variables/sameFolderCount})&quot; parentPath=&quot;\&quot;/&amp;gt;&lt;/postContent>&lt;postContentType>application/xml;&lt;/postContentType>&lt;headers>&lt;name>Authtoken&lt;/name>&lt;value>xpath:{/workflow/variables/userToken}&lt;/value>&lt;/headers>&lt;headers>&lt;name>Accept&lt;/name>&lt;value>application/json&lt;/value>&lt;/headers>&lt;/request>&lt;/inputs>"/>

        <transition activity="Switch_2" commented="0" originalStyle=""

            points="878.0,400.0" sourceX="1074" sourceY="602" status="1"

            style="defaultEdge" targetX="1070" targetY="649"

            transitionIndex="0" x="-31" y="122">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1465409963020" description="performs http operations"

        displayName="Share Folder to Requestor" height="15"

        interactive="0" jobMode="0" name="HttpClient"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=HttpClient"

        uniqueName="shareFolder" waitSetting="0" width="178" x="121" y="311">

        <onExit language="3" script="if(xpath:{/workflow/shareFolder/statusCode}==401){&#xd;&#xa;    workflow.setVariable(&quot;parentShareId&quot;,&quot;NONE&quot;);&#xd;&#xa;    workflow.setVariable(&quot;errorMessage&quot;, &quot;QSDK Token invalid&quot;);&#xd;&#xa;}else{&#xd;&#xa;    var response = JSON.parse(xpath:{/workflow/shareFolder/output});&#xd;&#xa;    if(response.resp.errorCode == 0){&#xd;&#xa;           workflow.setVariable(&quot;parentShareId&quot;,response.shareInfo.shareFolder.syncWebFolderId);&#xd;&#xa;           workflow.setVariable(&quot;parentShareName&quot;,response.shareInfo.shareFolder.syncWebFolderName);&#xd;&#xa;    }else{&#xd;&#xa;           logger.info(&quot;Error in Share Folder to requestor with message: &quot; + response.resp.errorMessage);&#xd;&#xa;           workflow.setVariable(&quot;parentShareId&quot;,&quot;NONE&quot;);&#xd;&#xa;           workflow.setVariable(&quot;errorMessage&quot;, response.resp.errorMessage);&#xd;&#xa;    }&#xd;&#xa;}&#xd;&#xa;logger.info(&quot;The parentShareId is &quot; + response.shareInfo.shareFolder.syncWebFolderId);"/>

        <inputs val="&lt;inputs>&lt;request>&lt;url>xpath:{/workflow/variables/EdgeDriveRestEndpointURL}/contentstore/file/xpath:{/workflow/variables/createdFolderGUID}/action/share&lt;/url>&lt;method>POST&lt;/method>&lt;postType>Raw&lt;/postType>&lt;postContent>&amp;lt;App_ShareInfo sharedToOperationType=&quot;2&quot; status=&quot;0&quot; canReshare=&quot;1&quot;&amp;gt;&amp;lt;browseInfo&amp;gt;&amp;lt;emailInfo dontSendEmail=&quot;0&quot; emailMessage=&quot;This folder has been created via workflow&quot;/&amp;gt;&amp;lt;/browseInfo&amp;gt;&amp;lt;shareFolder syncWebFolderName=&quot;xpath:{/workflow/inputs/shareName}&quot;/&amp;gt;&amp;lt;sharedTo permission=&quot;2&quot; userType=&quot;1&quot;&amp;gt;&amp;lt;user userName=&quot;xpath:{/workflow/system/executor/userName}&quot;/&amp;gt;&amp;lt;/sharedTo&amp;gt;&amp;lt;/App_ShareInfo&amp;gt;&lt;/postContent>&lt;postContentType>application/xml;&lt;/postContentType>&lt;headers>&lt;name>Authtoken&lt;/name>&lt;value>xpath:{/workflow/variables/userToken}&lt;/value>&lt;/headers>&lt;headers>&lt;name>Accept&lt;/name>&lt;value>application/json&lt;/value>&lt;/headers>&lt;/request>&lt;/inputs>"/>

        <transition activity="Decision_2" commented="0" originalStyle=""

            points="153.0,375.0" sourceX="232" sourceY="567" status="0"

            style="defaultEdge" targetX="377" targetY="705"

            transitionIndex="0" x="2" y="72">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1465485199524"

        description="activity to execute code snippets in the selected language"

        displayName="Encode Password" height="15" interactive="0"

        jobMode="0" name="Script"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Script"

        uniqueName="encodePassword" waitSetting="0" width="133" x="127" y="173">

        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;String password = xpath:{/workflow/variables/EdgeDrivePassword}.getPlainText();&amp;#xD;&amp;#xA;String encoded = Base64.getEncoder().encodeToString(password.getBytes());&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;passwordEncoded&amp;quot;,encoded);&quot; />&lt;/inputs>"/>

        <transition activity="getQSDKToken" commented="0"

            originalStyle="" points="193.0,200.0" sourceX="643"

            sourceY="404" status="0" style="defaultEdge" targetX="644"

            targetY="488" transitionIndex="0" x="-31" y="122">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="1"

        created="1465486753080" description="performs http operations"

        displayName="Login Edge Drive User" height="17" interactive="0"

        jobMode="0" name="HttpClient"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="1" style="label;image=HttpClient"

        uniqueName="getQSDKToken" waitSetting="0" width="154" x="126" y="211">

        <onExit language="3" script="var response = JSON.parse(xpath:{/workflow/getQSDKToken/output});&#xd;&#xa;var error = response.errList;&#xd;&#xa;if(error.length > 0){&#xd;&#xa;    logger.info(&quot;Error in login with message: &quot; + error[0].errLogMessage);&#xd;&#xa;    workflow.setVariable(&quot;errorMessage&quot;, error[0].errLogMessage);&#xd;&#xa;    workflow.setVariable(&quot;userToken&quot;,&quot;NONE&quot;);&#xd;&#xa;}else{&#xd;&#xa;    workflow.setVariable(&quot;userToken&quot;,response.token);&#xd;&#xa;}"/>

        <inputs val="&lt;inputs>&lt;request>&lt;url>xpath:{/workflow/variables/EdgeDriveRestEndpointURL}/Login&lt;/url>&lt;method>POST&lt;/method>&lt;postType>Raw&lt;/postType>&lt;postContent>&amp;lt;DM2ContentIndexing_CheckCredentialReq mode=&quot;Webconsole&quot; username=&quot;xpath:{/workflow/variables/EdgeDriveUsername}&quot; password=&quot;xpath:{/workflow/variables/passwordEncoded}&quot;  /&amp;gt;&lt;/postContent>&lt;postContentType>application/xml; charset=UTF-8&lt;/postContentType>&lt;headers>&lt;name>Accept&lt;/name>&lt;value>application/json&lt;/value>&lt;/headers>&lt;/request>&lt;/inputs>"/>

        <transition activity="loginCheckDecision" commented="0"

            originalStyle="" points="511.0,219.0" sourceX="788"

            sourceY="367" status="0" style="defaultEdge" targetX="648"

            targetY="453" transitionIndex="0" x="-55" y="231">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1465548025267" description="if/else based decision"

        displayName="Check Login Status" height="39" interactive="0"

        jobMode="0" name="Decision"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="loginCheckDecision" waitSetting="0" width="140"

        x="529" y="201">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/userToken}.equals(&quot;NONE&quot;)&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="GenericResponse_5" commented="0"

            displayName="Login Failed" offsetX="-45" offsetY="0"

            originalStyle="" points="" sourceX="410" sourceY="504"

            status="0" style="defaultEdge" targetX="1270" targetY="477"

            transitionIndex="0" value="true" x="-55" y="231">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="createFolder" commented="0"

            displayName="Login Successful" offsetX="72" offsetY="15"

            originalStyle="" points="598.0,263.0" sourceX="410"

            sourceY="504" status="0" style="defaultEdge" targetX="627"

            targetY="558" transitionIndex="0" value="false" x="2" y="72">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1465559132714" description="switch based decision"

        displayName="Folder Creation Status" height="52" interactive="0"

        jobMode="0" name="Switch"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Switch_1" waitSetting="0" width="156" x="542" y="270">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/createFolder/statusCode}&lt;/expression>&lt;/inputs>"/>

        <transition activity="createFolderRepeated" commented="0"

            displayName="Folder Already Exists" offsetX="-12"

            offsetY="20" originalStyle="" points="632.0,358.0"

            sourceX="835" sourceY="484" status="0" style="defaultEdge"

            targetX="1030" targetY="614" transitionIndex="0" value="409"

            x="2" y="72">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="GenericResponse_6" commented="0"

            displayName="Folder Creation Failed" offsetX="3"

            offsetY="27" originalStyle="" points="" sourceX="707"

            sourceY="545" status="0" style="defaultEdge" targetX="1261"

            targetY="362" transitionIndex="1" x="2" y="72">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="shareFolder" commented="0"

            displayName="Folder Created" offsetX="72" offsetY="18"

            originalStyle="" points="270.0,355.0" sourceX="835"

            sourceY="484" status="0" style="defaultEdge" targetX="192"

            targetY="689" transitionIndex="0" value="201" x="2" y="72">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1465561826971" description="switch based decision"

        displayName="Folder Creation Status" height="45" interactive="0"

        jobMode="0" name="Switch"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Switch_2" waitSetting="0" width="156" x="1105" y="315">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/createFolderRepeated/statusCode}&lt;/expression>&lt;/inputs>"/>

        <transition activity="createFolderRepeated" commented="0"

            displayName="Repeat till new folder" offsetX="8"

            offsetY="77" originalStyle="" points="1177.0,307.0"

            sourceX="1347" sourceY="579" status="0" style="defaultEdge"

            targetX="1114" targetY="585" transitionIndex="0" value="409"

            x="2" y="72">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="shareFolder" commented="0"

            displayName="New folder created" offsetX="-179" offsetY="32"

            originalStyle="" points="247.0,411.0" sourceX="1347"

            sourceY="579" status="0" style="defaultEdge" targetX="914"

            targetY="742" transitionIndex="0" value="201" x="2" y="72">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="GenericResponse_9" commented="0"

            displayName="Folder Creation Failed" offsetX="48"

            offsetY="-3" originalStyle="" points="" sourceX="1384"

            sourceY="575" status="0" style="defaultEdge" targetX="1305"

            targetY="363" transitionIndex="1" x="2" y="72">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1465809548235"

        description="activity to execute code snippets in the selected language"

        displayName="Parse Users As List" height="21" interactive="0"

        jobMode="0" name="Script"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Script"

        uniqueName="parseUsersList" waitSetting="0" width="143" x="129" y="127">

        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;String usersListString = xpath:{/workflow/inputs/usersName} ;&amp;#xD;&amp;#xA;List usersList = new ArrayList(); &amp;#xD;&amp;#xA;if(!(&amp;quot;&amp;quot;.equals(usersListString.trim()))){&amp;#xD;&amp;#xA;    for(String userName:usersListString.split(&amp;quot;,&amp;quot;)){&amp;#xD;&amp;#xA;        String temp = userName.trim();&amp;#xD;&amp;#xA;        if(!(&amp;quot;&amp;quot;.equals(temp))){&amp;#xD;&amp;#xA;            usersList.add(temp);&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;usersList&amp;quot;,usersList);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;String executorName = xpath:{/workflow/system/executor/userName};&amp;#xD;&amp;#xA;logger.info(&amp;quot;The executor user name is &amp;quot; + executorName);&amp;#xD;&amp;#xA;String[] executorNameSplit = executorName.split(&amp;quot;\\\\&amp;quot;);&amp;#xD;&amp;#xA;if (executorNameSplit.length &amp;gt;= 2)&amp;#xD;&amp;#xA;     executorName = executorNameSplit[1];&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;executorSharedTo&amp;quot;, executorName);&quot; />&lt;/inputs>"/>

        <transition activity="ForEach_1" commented="0" originalStyle=""

            points="" sourceX="212" sourceY="196" status="0"

            style="defaultEdge" targetX="454" targetY="190"

            transitionIndex="0" x="8" y="128">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1465809916129"

        description="iterates a group of activities over a list of values"

        displayName="Validate Users List" height="155" interactive="0"

        jobMode="0" name="ForEach"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ForEach_1" waitSetting="0" width="455" x="319" y="18">

        <inputs val="&lt;inputs>&lt;name class=&quot;java.lang.String&quot;>usersList&lt;/name>&lt;values class=&quot;java.lang.Object&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/usersList}&lt;/values>&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>1&lt;/numberOfParallelExecutions>&lt;continueOnFailure class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/continueOnFailure>&lt;/inputs>"/>

        <superProcess>

            <Start commented="0" continueOnFailure="0"

                created="1465809916129" description=""

                displayName="Start" height="12" interactive="0"

                jobMode="0" name="Start" originalStyle=""

                skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_2" waitSetting="0" width="75" x="9" y="34">

                <inputs val="&lt;inputs />"/>

                <transition activity="Script_5" commented="0"

                    originalStyle="" points="" sourceX="46" sourceY="40"

                    status="0" style="defaultEdge" targetX="181"

                    targetY="40" transitionIndex="0" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity commented="0" continueOnFailure="0"

                created="1418116269405"

                description="activity to execute code snippets in the selected language"

                displayName="Get Member Info" height="15"

                interactive="0" jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Script" uniqueName="Script_3"

                waitSetting="0" width="126" x="298" y="37">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;import java.util.*;&amp;#xD;&amp;#xA;import javax.naming.*;&amp;#xD;&amp;#xA;import javax.naming.directory.*;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;import org.apache.commons.lang.StringEscapeUtils;&amp;#xD;&amp;#xA;Hashtable ldapEnv = new Hashtable();&amp;#xD;&amp;#xA;ldapEnv.put(Context.INITIAL_CONTEXT_FACTORY, &amp;quot;com.sun.jndi.ldap.LdapCtxFactory&amp;quot;);&amp;#xD;&amp;#xA;ldapEnv.put(Context.PROVIDER_URL,  xpath:{/workflow/variables/ldapEndpointURL});&amp;#xD;&amp;#xA;ldapEnv.put(Context.SECURITY_AUTHENTICATION, &amp;quot;simple&amp;quot;); &amp;#xD;&amp;#xA;ldapEnv.put(Context.SECURITY_PRINCIPAL, xpath:{/workflow/variables/ldapQuery});&amp;#xD;&amp;#xA;ldapEnv.put(Context.SECURITY_CREDENTIALS, xpath:{/workflow/variables/ldapPassword}.getPlainText());&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;DirContext ldapContext = new InitialDirContext(ldapEnv);&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;String searchBase = xpath:{/workflow/variables/ldapSearchBase};&amp;#xD;&amp;#xA;String userFullname;&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;String accountName = xpath:{/workflow/ForEach_1/usersList};&amp;#xD;&amp;#xA;logger.info(&amp;quot;The user name is &amp;quot; + accountName);&amp;#xD;&amp;#xA;String[] accountNameSplit = accountName.split(&amp;quot;\\\\&amp;quot;);&amp;#xD;&amp;#xA;if (accountNameSplit.length &amp;gt;= 2)&amp;#xD;&amp;#xA;     accountName = accountNameSplit[1];&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;String searchFilter = &amp;quot;(&amp;amp;(|(objectClass=user)(objectClass=group))(|(sAMAccountName=&amp;quot; + accountName + &amp;quot;)(mailNickName=&amp;quot;+accountName+&amp;quot;)(mail=&amp;quot;+accountName+&amp;quot;)))&amp;quot;;&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;SearchControls searchControls = new SearchControls();&amp;#xD;&amp;#xA;String[] returnedAtts={&amp;quot;displayName&amp;quot;,&amp;quot;mail&amp;quot;, &amp;quot;objectClass&amp;quot;};&amp;#xD;&amp;#xA;searchControls.setReturningAttributes(returnedAtts);&amp;#xD;&amp;#xA;searchControls.setSearchScope(SearchControls.SUBTREE_SCOPE);&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;NamingEnumeration answer =  ldapContext.search(searchBase, searchFilter, searchControls);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;//set accountName value back to original value which include domain prefix&amp;#xD;&amp;#xA;accountName = xpath:{/workflow/variables/domainName} + &amp;quot;\\&amp;quot; + accountName;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if(!(answer.hasMoreElements()))&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;        String invalidUsersList = xpath:{/workflow/variables/invalidUsersList};&amp;#xD;&amp;#xA;        if(&amp;quot;&amp;quot;.equals(invalidUsersList)){&amp;#xD;&amp;#xA;            invalidUsersList = accountName;&amp;#xD;&amp;#xA;        }else{&amp;#xD;&amp;#xA;            invalidUsersList = invalidUsersList + &amp;quot;, &amp;quot; + accountName;&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;        workflow.setVariable(&amp;quot;invalidUsersList&amp;quot;,invalidUsersList);&amp;#xD;&amp;#xA;        return;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;while (answer.hasMoreElements())&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;       SearchResult sr = (SearchResult) answer.next();&amp;#xD;&amp;#xA;       Attributes attrs = sr.getAttributes();&amp;#xD;&amp;#xA;                   &amp;#xD;&amp;#xA;       if (attrs.get(&amp;quot;objectClass&amp;quot;) != null){ &amp;#xD;&amp;#xA;                   //workflow.setVariable(&amp;quot;Address&amp;quot;, String.valueOf(attrs.get(&amp;quot;streetAddress&amp;quot;).get()));&amp;#xD;&amp;#xA;                   String objectType = attrs.get(&amp;quot;objectClass&amp;quot;).get(1);&amp;#xD;&amp;#xA;                   String userXmlList = xpath:{/workflow/variables/userListXml};&amp;#xD;&amp;#xA;                   if(objectType.equals(&amp;quot;group&amp;quot;)){&amp;#xD;&amp;#xA;                       userXmlList = userXmlList + &amp;quot;&amp;lt;sharedTo permission=\&amp;quot;2\&amp;quot; userType=\&amp;quot;4\&amp;quot;&amp;gt;&amp;lt;externalGroup externalGroupName=\&amp;quot;&amp;quot; + StringEscapeUtils.escapeXml(accountName) + &amp;quot;\&amp;quot;/&amp;gt;&amp;lt;/sharedTo&amp;gt;&amp;quot;;&amp;#xD;&amp;#xA;                       workflow.setVariable(&amp;quot;userListXml&amp;quot;,userXmlList);&amp;#xD;&amp;#xA;                   }else if(objectType.equals(&amp;quot;person&amp;quot;)){&amp;#xD;&amp;#xA;                       userXmlList = userXmlList + &amp;quot;&amp;lt;sharedTo permission=\&amp;quot;2\&amp;quot; userType=\&amp;quot;1\&amp;quot;&amp;gt;&amp;lt;user userName=\&amp;quot;&amp;quot; + StringEscapeUtils.escapeXml(accountName) + &amp;quot;\&amp;quot;/&amp;gt;&amp;lt;/sharedTo&amp;gt;&amp;quot;;&amp;#xD;&amp;#xA;                       workflow.setVariable(&amp;quot;userListXml&amp;quot;,userXmlList);&amp;#xD;&amp;#xA;                   }else{&amp;#xD;&amp;#xA;                           String invalidUsersList = xpath:{/workflow/variables/invalidUsersList};&amp;#xD;&amp;#xA;                           if(&amp;quot;&amp;quot;.equals(invalidUsersList)){&amp;#xD;&amp;#xA;                               invalidUsersList = accountName;&amp;#xD;&amp;#xA;                           }else{&amp;#xD;&amp;#xA;                               invalidUsersList = invalidUsersList + &amp;quot;, &amp;quot; + accountName;&amp;#xD;&amp;#xA;                           }&amp;#xD;&amp;#xA;                           workflow.setVariable(&amp;quot;invalidUsersList&amp;quot;,invalidUsersList);&amp;#xD;&amp;#xA;                   }&amp;#xD;&amp;#xA;                   logger.info(&amp;quot;objectClass: &amp;quot; + String.valueOf(attrs.get(&amp;quot;objectClass&amp;quot;).get(1)));&amp;#xD;&amp;#xA;       }else{&amp;#xD;&amp;#xA;           String invalidUsersList = xpath:{/workflow/variables/invalidUsersList};&amp;#xD;&amp;#xA;           if(&amp;quot;&amp;quot;.equals(invalidUsersList)){&amp;#xD;&amp;#xA;               invalidUsersList = accountName;&amp;#xD;&amp;#xA;           }else{&amp;#xD;&amp;#xA;               invalidUsersList = invalidUsersList + &amp;quot;, &amp;quot; + accountName;&amp;#xD;&amp;#xA;           }&amp;#xD;&amp;#xA;           workflow.setVariable(&amp;quot;invalidUsersList&amp;quot;,invalidUsersList);&amp;#xD;&amp;#xA;       }&amp;#xD;&amp;#xA;              &amp;#xD;&amp;#xA;        if (attrs.get(&amp;quot;mail&amp;quot;) != null){ &amp;#xD;&amp;#xA;            workflow.setVariable(&amp;quot;Email&amp;quot;, String.valueOf(attrs.get(&amp;quot;mail&amp;quot;).get()));&amp;#xD;&amp;#xA;            logger.info(&amp;quot;Email: &amp;quot; + String.valueOf(attrs.get(&amp;quot;mail&amp;quot;).get()));&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;       &amp;#xD;&amp;#xA;        if (attrs.get(&amp;quot;displayName&amp;quot;) != null){ &amp;#xD;&amp;#xA;            workflow.setVariable(&amp;quot;Name&amp;quot;, String.valueOf(attrs.get(&amp;quot;displayName&amp;quot;).get()));&amp;#xD;&amp;#xA;            logger.info(&amp;quot;Name: &amp;quot; + String.valueOf(attrs.get(&amp;quot;displayName&amp;quot;).get()));&amp;#xD;&amp;#xA;            userFullName = String.valueOf(attrs.get(&amp;quot;displayName&amp;quot;).get());&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&quot; />&lt;/inputs>"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1467389312002"

                description="activity to execute code snippets in the selected language"

                displayName="Check User Type" height="19"

                interactive="0" jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Script" uniqueName="Script_5"

                waitSetting="0" width="126" x="118" y="31">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;String accountName = xpath:{/workflow/ForEach_1/usersList};&amp;#xD;&amp;#xA;//logger.info(&amp;quot;The user name is &amp;quot; + accountName);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;int email = accountName.indexOf(&amp;quot;@&amp;quot;);&amp;#xD;&amp;#xA;int ADaccount = accountName.indexOf(&amp;quot;\\&amp;quot;);&amp;#xD;&amp;#xA;String userXmlList = xpath:{/workflow/variables/userListXml};&amp;#xD;&amp;#xA;if (email != -1) {&amp;#xD;&amp;#xA;    logger.info(accountName + &amp;quot; is a email&amp;quot;);&amp;#xD;&amp;#xA;    userXmlList = userXmlList + &amp;quot;&amp;lt;sharedTo email=\&amp;quot;&amp;quot; + accountName + &amp;quot;\&amp;quot; permission=\&amp;quot;2\&amp;quot; userType=\&amp;quot;2\&amp;quot;&amp;gt;&amp;lt;/sharedTo&amp;gt;&amp;quot;;&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;userListXml&amp;quot;,userXmlList);&amp;#xD;&amp;#xA;    return 1;&amp;#xD;&amp;#xA;} else if (ADaccount != -1) {&amp;#xD;&amp;#xA;    logger.info(accountName + &amp;quot; is an AD user/group&amp;quot;);&amp;#xD;&amp;#xA;    return 2;&amp;#xD;&amp;#xA;} else {&amp;#xD;&amp;#xA;    logger.info(accountName + &amp;quot; is a commcell user/group&amp;quot;);&amp;#xD;&amp;#xA;    return 3;&amp;#xD;&amp;#xA;}&quot; />&lt;/inputs>"/>

                <transition activity="Script_3" commented="0"

                    displayName="AD user/group" offsetX="2" offsetY="0"

                    originalStyle="" points="271.0,46.0" sourceX="181"

                    sourceY="40" status="0" style="defaultEdge"

                    targetX="420" targetY="121" transitionIndex="0"

                    x="0" y="-25">

                    <condition language="1" script="xpath:{/workflow/Script_5/output}==2"/>

                </transition>

                <transition activity="CommServDBQuery_1" commented="0"

                    displayName="Commcell user/group" originalStyle=""

                    points="" sourceX="181" sourceY="40" status="0"

                    style="defaultEdge" targetX="92" targetY="119"

                    transitionIndex="0" x="0" y="0">

                    <condition language="1" script="xpath:{/workflow/Script_5/output}==3&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1467390949907"

                description="executes queries against a commcell database"

                displayName="Get Commcell User Info" height="21"

                interactive="0" jobMode="0" name="CommServDBQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=CommServDBQuery"

                uniqueName="CommServDBQuery_1" waitSetting="0"

                width="163" x="11" y="109">

                <onExit language="1" script="import org.apache.commons.lang.StringEscapeUtils;&#xd;&#xa;String accountName = StringEscapeUtils.escapeXml(xpath:{/workflow/ForEach_1/usersList});&#xd;&#xa;String userXmlList = xpath:{/workflow/variables/userListXml};&#xd;&#xa;if (!xpath:{/workflow/CommServDBQuery_1/resultSets}.isEmpty())&#xd;&#xa;{&#xd;&#xa;    if (xpath:{/workflow/CommServDBQuery_1/resultSets[1]/rowCount} > 0)&#xd;&#xa;    {&#xd;&#xa;        if (xpath:{/workflow/CommServDBQuery_1/resultSets[1]/row[1]/col[2]} == 1)&#xd;&#xa;        {&#xd;&#xa;             userXmlList = userXmlList + &quot;&lt;sharedTo permission=\&quot;2\&quot; userType=\&quot;1\&quot;>&lt;user userName=\&quot;&quot; + accountName + &quot;\&quot;/>&lt;/sharedTo>&quot;;&#xd;&#xa;        }&#xd;&#xa;        else if (xpath:{/workflow/CommServDBQuery_1/resultSets[1]/row[1]/col[2]} == 3)&#xd;&#xa;        {&#xd;&#xa;             userXmlList = userXmlList + &quot;&lt;sharedTo permission=\&quot;2\&quot; userType=\&quot;3\&quot;>&lt;group userGroupName=\&quot;&quot; + accountName + &quot;\&quot;/>&lt;/sharedTo>&quot;;&#xd;&#xa;        }&#xd;&#xa;        workflow.setVariable(&quot;userListXml&quot;,userXmlList);&#xd;&#xa;    }&#xd;&#xa;}"/>

                <inputs val="&lt;inputs>&lt;commCell />&lt;query>DECLARE @userId INT = 0&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;SET @userId = ISNULL((SELECT id from UMUsers where login = ''xpath:{/workflow/ForEach_1/usersList}'' and enabled = 1), 0)&amp;#xD;&#xd;&#xa;IF @userId = 0&amp;#xD;&#xd;&#xa;BEGIN&amp;#xD;&#xd;&#xa;    SET @userId = ISNULL((SELECT id from UMGroups where name = ''xpath:{/workflow/ForEach_1/usersList}''), 0)&amp;#xD;&#xd;&#xa;    IF @userId &amp;lt;&amp;gt; 0&amp;#xD;&#xd;&#xa;    BEGIN&amp;#xD;&#xd;&#xa;        SELECT @userId, 3&amp;#xD;&#xd;&#xa;    END&amp;#xD;&#xd;&#xa;END&amp;#xD;&#xd;&#xa;ELSE&amp;#xD;&#xd;&#xa;BEGIN&amp;#xD;&#xd;&#xa;    SELECT @userId, 1&amp;#xD;&#xd;&#xa;END&lt;/query>&lt;/inputs>"/>

            </Activity>

        </superProcess>

        <activitySchema>

            <outputs name="outputs">

                <children attribute="0" className="java.lang.String"

                    controlType="0" defaultValue="" displayName=""

                    documentation="" hidden="0"

                    inputType="java.lang.String" listType="0"

                    name="usersList" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            </outputs>

            <inputs>

                <children className="java.lang.String"

                    inputType="java.lang.String" name="name" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children className="java.lang.Object"

                    inputType="java.lang.Object" name="values" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                <children className="java.lang.Integer" defaultValue="1"

                    inputType="java.lang.Integer"

                    name="numberOfParallelExecutions" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                <children className="java.lang.Boolean"

                    defaultValue="false" inputType="java.lang.Boolean"

                    name="continueOnFailure" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

            </inputs>

        </activitySchema>

        <transition activity="ImpersonateExecutor_1" commented="0"

            originalStyle="" points="" sourceX="546" sourceY="95"

            status="0" style="defaultEdge" targetX="883" targetY="36"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1465834990099" description="if/else based decision"

        displayName="Any User Left" height="52" interactive="0"

        jobMode="0" name="Decision"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_1" waitSetting="0" width="106" x="575" y="487">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&quot;&quot;.equals(xpath:{/workflow/variables/invalidUsersList})&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="GenericResponse_3" commented="0"

            displayName="Some users left" originalStyle="" points=""

            sourceX="706" sourceY="693" status="0" style="defaultEdge"

            targetX="1021" targetY="783" transitionIndex="0"

            value="false" x="331" y="67">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="GenericResponse_2" commented="0"

            displayName="No user left" offsetX="1" offsetY="-16"

            originalStyle="" points="" sourceX="740" sourceY="714"

            status="0" style="defaultEdge" targetX="937" targetY="706"

            transitionIndex="0" value="true" x="2" y="72">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1465925355489" description="if/else based decision"

        displayName="Check Share Created" height="51" interactive="0"

        jobMode="0" name="Decision"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_2" waitSetting="0" width="151" x="77" y="380">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/shareFolder/statusCode}==200&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="HttpClient_1" commented="0"

            displayName="Share created successfully" offsetX="-7"

            offsetY="13" originalStyle="" points="" sourceX="425"

            sourceY="638" status="0" style="defaultEdge" targetX="786"

            targetY="617" transitionIndex="0" value="true" x="2" y="72">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="GenericResponse_10" commented="0"

            displayName="Fail" offsetX="-84" offsetY="114"

            originalStyle="" points="" sourceX="468" sourceY="622"

            status="0" style="defaultEdge" targetX="1342" targetY="331"

            transitionIndex="0" value="false" x="2" y="72">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1467315150968" description="performs http operations"

        displayName="Share Folder to Users" height="15" interactive="0"

        jobMode="0" name="HttpClient"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=HttpClient"

        uniqueName="HttpClient_1" waitSetting="0" width="153" x="79" y="504">

        <inputs val="&lt;inputs>&lt;request>&lt;url>xpath:{/workflow/variables/EdgeDriveRestEndpointURL}/CreateShareFolder&lt;/url>&lt;method>POST&lt;/method>&lt;postType>Raw&lt;/postType>&lt;postContent>&amp;lt;App_CreateShareFolderReq&amp;gt;&#xd;&#xa;    &amp;lt;shareInfo status=&quot;0&quot; sharedToOperationType=&quot;2&quot; userPermission=&quot;2&quot; canReshare=&quot;0&quot; reshareOperationType=&quot;1&quot;&amp;gt;&#xd;&#xa;        &amp;lt;shareFolder syncWebFolderName=&quot;xpath:{/workflow/inputs/shareName}&quot;/&amp;gt;&#xd;&#xa;        &amp;lt;browseInfo edgeClient=&quot;0&quot;&amp;gt;&#xd;&#xa;            &amp;lt;paths path=&quot;xpath:{/workflow/variables/createdFolderGUID}&quot; directory=&quot;1&quot;/&amp;gt;&#xd;&#xa;            &amp;lt;emailInfo dontSendEmail=&quot;0&quot; emailMessage=&quot;&quot;/&amp;gt;&#xd;&#xa;        &amp;lt;/browseInfo&amp;gt;&#xd;&#xa;        xpath:{/workflow/variables/userListXml}&#xd;&#xa;        &amp;lt;parentShare shareId=&quot;xpath:{/workflow/variables/parentShareId}&quot;/&amp;gt;&#xd;&#xa;    &amp;lt;/shareInfo&amp;gt;&#xd;&#xa;&amp;lt;/App_CreateShareFolderReq&amp;gt;&lt;/postContent>&lt;postContentType>application/xml;&lt;/postContentType>&lt;headers>&lt;name>Authtoken&lt;/name>&lt;value>QSDKONLY xpath:{/workflow/system/token}&lt;/value>&lt;/headers>&lt;headers>&lt;name>Accept&lt;/name>&lt;value>application/xml&lt;/value>&lt;/headers>&lt;/request>&lt;/inputs>"/>

        <transition activity="Decision_3" commented="0" originalStyle=""

            points="" sourceX="155" sourceY="511" status="0"

            style="defaultEdge" targetX="590" targetY="515"

            transitionIndex="0" x="2" y="72">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1467320650990" description="if/else based decision"

        displayName="Check Share Created" height="51" interactive="0"

        jobMode="0" name="Decision"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_3" waitSetting="0" width="151" x="282" y="489">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/HttpClient_1/statusCode}==200&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="Decision_1" commented="0"

            displayName="Successful" originalStyle="" points=""

            sourceX="357" sourceY="514" status="0" style="defaultEdge"

            targetX="585" targetY="514" transitionIndex="0" value="true"

            x="2" y="72">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="GenericResponse_1" commented="0"

            displayName="Fail" originalStyle="" points="" sourceX="357"

            sourceY="514" status="0" style="defaultEdge" targetX="359"

            targetY="593" transitionIndex="0" value="false" x="2" y="72">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1467320712267" description="Ends the workflow"

        displayName="WorkflowEnd" height="18" interactive="0"

        jobMode="0" name="WorkflowEnd"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=WorkflowEnd"

        uniqueName="WorkflowEnd_2" waitSetting="0" width="106" x="306" y="680">

        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;>COMPLETED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1467391303593"

        description="activity to execute code snippets in the selected language"

        displayName="Display User xml" height="23" interactive="0"

        jobMode="0" name="Script"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Script"

        uniqueName="Script_7" waitSetting="0" width="125" x="842" y="83">

		<inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;import org.apache.commons.lang.StringEscapeUtils;&amp;#xD;&amp;#xA;String tempShareName = StringEscapeUtils.escapeXml(xpath:{/workflow/inputs/shareName});&amp;#xD;&amp;#xA;workflow.setInput(&amp;quot;shareName&amp;quot;,tempShareName);&amp;#xD;&amp;#xA;logger.info(xpath:{/workflow/variables/userListXml});&quot; />&lt;/inputs>"/>

        <transition activity="encodePassword" commented="0"

            originalStyle="" points="914.0,181.0" sourceX="904"

            sourceY="94" status="0" style="defaultEdge" targetX="243"

            targetY="179" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1467989246504"

        description="returns a message to the caller of the workflow"

        displayName="CreateShareToUsers failure response" height="34"

        interactive="0" jobMode="0" name="GenericResponse"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=GenericResponse"

        uniqueName="GenericResponse_1" waitSetting="0" width="265"

        x="297" y="589">

        <inputs val="&lt;inputs>&lt;errorCode class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>xpath:{/workflow/HttpClient_1/statusCode}&lt;/errorCode>&lt;errorMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>Failed to create the share.&lt;/errorMessage>&lt;/inputs>"/>

        <transition activity="WorkflowEnd_2" commented="0"

            originalStyle="" points="" sourceX="359" sourceY="576"

            status="0" style="defaultEdge" targetX="358" targetY="634"

            transitionIndex="0" x="2" y="72">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1467999577614"

        description="returns a message to the caller of the workflow"

        displayName="Success response" height="24" interactive="0"

        jobMode="0" name="GenericResponse"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=GenericResponse"

        uniqueName="GenericResponse_2" waitSetting="0" width="198"

        x="992" y="452">

        <inputs val="&lt;inputs>&lt;errorCode class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>0&lt;/errorCode>&lt;errorMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>Folder &quot;xpath:{/workflow/inputs/shareName}&quot; has been created and collaborated with all users.&lt;/errorMessage>&lt;/inputs>"/>

        <transition activity="WorkflowEnd_1" commented="0"

            originalStyle="" points="1464.0,347.0" sourceX="691"

            sourceY="627" status="0" style="defaultEdge" targetX="1346"

            targetY="178" transitionIndex="0" x="2" y="72">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1467999705075"

        description="returns a message to the caller of the workflow"

        displayName="Success warning" height="21" interactive="0"

        jobMode="0" name="GenericResponse"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=GenericResponse"

        uniqueName="GenericResponse_3" waitSetting="0" width="198"

        x="995" y="560">

        <inputs val="&lt;inputs>&lt;errorCode class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>-1&lt;/errorCode>&lt;errorMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>Folder &quot;xpath:{/workflow/inputs/shareName}&quot; has been created and collaborated with all users except &quot;xpath:{/workflow/variables/invalidUsersList}&quot;&lt;/errorMessage>&lt;/inputs>"/>

        <transition activity="WorkflowEnd_1" commented="0"

            originalStyle="" points="1499.0,370.0" sourceX="693"

            sourceY="680" status="0" style="defaultEdge" targetX="1348"

            targetY="182" transitionIndex="0" x="2" y="72">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1468007065342"

        description="returns a message to the caller of the workflow"

        displayName="Login response" height="25" interactive="0"

        jobMode="0" name="GenericResponse"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=GenericResponse"

        uniqueName="GenericResponse_5" waitSetting="0" width="135"

        x="943" y="189">

        <inputs val="&lt;inputs>&lt;errorCode class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>xpath:{/workflow/getQSDKToken/statusCode}&lt;/errorCode>&lt;errorMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/getQSDKToken/statusText}&lt;/errorMessage>&lt;/inputs>"/>

        <transition activity="WorkflowEnd_1" commented="0"

            originalStyle="" points="" sourceX="1222" sourceY="432"

            status="0" style="defaultEdge" targetX="1308" targetY="295"

            transitionIndex="0" x="-31" y="122">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1468007346758"

        description="returns a message to the caller of the workflow"

        displayName="Create Folder response" height="25" interactive="0"

        jobMode="0" name="GenericResponse"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=GenericResponse"

        uniqueName="GenericResponse_6" waitSetting="0" width="163"

        x="942" y="228">

        <inputs val="&lt;inputs>&lt;errorCode class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>xpath:{/workflow/createFolder/statusCode}&lt;/errorCode>&lt;errorMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/createFolder/statusText}&lt;/errorMessage>&lt;/inputs>"/>

        <transition activity="WorkflowEnd_1" commented="0"

            originalStyle="" points="" sourceX="1023" sourceY="240"

            status="0" style="defaultEdge" targetX="1287" targetY="182"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1468010911221"

        description="returns a message to the caller of the workflow"

        displayName="Create folder repeated failure response"

        height="34" interactive="0" jobMode="0" name="GenericResponse"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=GenericResponse"

        uniqueName="GenericResponse_9" waitSetting="0" width="200"

        x="1185" y="221">

        <inputs val="&lt;inputs>&lt;errorCode class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>xpath:{/workflow/createFolderRepeated/statusCode}&lt;/errorCode>&lt;errorMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/createFolderRepeated/statusText}&lt;/errorMessage>&lt;/inputs>"/>

        <transition activity="WorkflowEnd_1" commented="0"

            originalStyle="" points="" sourceX="1285" sourceY="238"

            status="0" style="defaultEdge" targetX="1282" targetY="190"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1468011110995"

        description="returns a message to the caller of the workflow"

        displayName="CreateShareToRequestor failure response"

        height="34" interactive="0" jobMode="0" name="GenericResponse"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=GenericResponse"

        uniqueName="GenericResponse_10" waitSetting="0" width="281"

        x="610" y="426">

        <inputs val="&lt;inputs>&lt;errorCode class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>xpath:{/workflow/shareFolder/statusCode}&lt;/errorCode>&lt;errorMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/shareFolder/statusText}&lt;/errorMessage>&lt;/inputs>"/>

        <transition activity="WorkflowEnd_1" commented="0"

            originalStyle="" points="1445.0,318.0" sourceX="750"

            sourceY="443" status="0" style="defaultEdge" targetX="1287"

            targetY="182" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1468951914166"

        description="impersonates the user who created the workflow"

        displayName="ImpersonateCreator" height="34" interactive="0"

        jobMode="0" name="ImpersonateCreator"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ImpersonateCreator"

        uniqueName="ImpersonateCreator_1" waitSetting="0" width="145"

        x="146" y="57">

        <inputs val="&lt;inputs />"/>

        <transition activity="parseUsersList" commented="0"

            originalStyle="" points="" sourceX="206" sourceY="74"

            status="0" style="defaultEdge" targetX="201" targetY="133"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1468951976544"

        description="impersonates the user who executes the workflow"

        displayName="ImpersonateExecutor" height="34" interactive="0"

        jobMode="0" name="ImpersonateExecutor"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ImpersonateExecutor"

        uniqueName="ImpersonateExecutor_1" waitSetting="0" width="153"

        x="839" y="27">

        <inputs val="&lt;inputs />"/>

        <transition activity="Script_7" commented="0" originalStyle=""

            points="" sourceX="915" sourceY="44" status="0"

            style="defaultEdge" targetX="914" targetY="82"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <formProperties css="" javaScript=""/>

</workflow>

'

IF not exists (select * from WF_Definition where Name = @name)

BEGIN
	INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision)


	VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision)

	SET @workflowId = @@IDENTITY
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


	VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

	SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = ISNULL(revision, '') From WF_Definition WHERE Name = @name

	IF (@currentFlags & 4 > 0 OR (@flags & (6|8|16) > 0)) AND (@currentRevision <> @revision)

	BEGIN

		SET @version = @version + 1

		UPDATE WF_Definition

		SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision

		WHERE Name = @name

		IF (@flags & 8 > 0 OR @flags & 16 > 0)

		BEGIN

			UPDATE WF_Definition

			SET flags = @flags

			WHERE Name = @name

		END
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


		VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

	END

END

