

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_ConfigureSharepoint.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/WFD_ConfigureSharepoint.script,v $ $Id: WFD_ConfigureSharepoint.script,v 1.1.2.5 2020/10/04 00:57:44 abilbrey Exp $";
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER ON

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.1.2.5 $'

SET @name = 'Configure SharePoint'

SET @description = 'Auto configure SharePoint farm setup'

SET @version = 1

SET @flags = 30

SET @definition = '<workflow apiMode="0" config="&lt;configuration /&gt;" description="Auto configure SharePoint farm setup" executeOnWeb="0" inputs="&lt;inputs&gt;&lt;SQLServerName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;SQLUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;SharePointAdminName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;StoragePolicy class=&quot;commvault.msgs.CvEntities.StoragePolicyEntity&quot; _list_=&quot;false&quot;&gt;&lt;storagePolicyName /&gt;&lt;storagePolicyId /&gt;&lt;/StoragePolicy&gt;&lt;SQLPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; /&gt;&lt;SharePointAdminPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; /&gt;&lt;PseudoClientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;SchedulePolicy class=&quot;commvault.msgs.CvEntities.SchedulePolicyEntity&quot; _list_=&quot;false&quot;&gt;&lt;schedulePolicyName /&gt;&lt;schedulePolicyId /&gt;&lt;/SchedulePolicy&gt;&lt;SQLServerInstanceName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/inputs&gt;" interactive="0" isHtmlDescription="0" name="Configure SharePoint" outputs="&lt;outputs&gt;&lt;Successfull class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot; /&gt;&lt;errorString class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/outputs&gt;" revision="$Revision: 1.1.2.5 $" tags="" uniqueGuid="56369947-b093-46da-84f7-5b67c76651c1" variables="&lt;variables&gt;&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;installJobList class=&quot;java.lang.Integer&quot; _list_=&quot;true&quot; /&gt;&lt;clientHostNames class=&quot;java.lang.String&quot; _list_=&quot;true&quot; /&gt;&lt;sharePointClientHostNamesStr class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;sharePointFarmPseudoClientId class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; /&gt;&lt;sharePointPseudoClientPrimaryNodeClientId class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; /&gt;&lt;sharePointPseudoClientEntity class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;&gt;&lt;clientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;clientId class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; /&gt;&lt;/sharePointPseudoClientEntity&gt;&lt;multipleSQLServersDetected class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/multipleSQLServersDetected&gt;&lt;SPNodeIdsStr class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;tempDir class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;workflowLoggerPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;nodesFailedCheckReadinessForDataProtection class=&quot;java.lang.String&quot; _list_=&quot;true&quot; /&gt;&lt;sqlServerName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;multipleSQLInstanceDetected class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/multipleSQLInstanceDetected&gt;&lt;usernameForInstallAgentJob class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;passwordForInstallAgentJob class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; /&gt;&lt;shouldConfigureSQLSubclient class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/shouldConfigureSQLSubclient&gt;&lt;preExistingSPClientIds class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;0&lt;/preExistingSPClientIds&gt;&lt;/variables&gt;" webHidden="0" workflowId="129">

  <schema>

    <inputs attribute="0" className="" name="inputs" type="">

      <children attribute="0" className="java.lang.String" controlHidden="0" controlType="0" defaultValue="" displayName="Client Name" documentation="Client name to be given to the auto configured SharePoint farm client" hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="PseudoClientName" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string" />

      <children attribute="0" className="java.lang.String" controlHidden="0" controlType="0" defaultValue="" displayName="SQL Server Hostname" documentation="Host name of the SQL Server hosting the configuration database" hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="SQLServerName" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string" />

      <children attribute="0" className="java.lang.String" controlHidden="0" controlType="0" defaultValue="" displayName="SQL Server Instance Name" documentation="SQL instance name hosting the SharePoint configuration database. Do not append hostname and leave blank for default instance. " hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="SQLServerInstanceName" readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string" />

      <children attribute="0" className="java.lang.String" controlHidden="0" controlType="0" defaultValue="" displayName="SQL Server Username" documentation="SQL Username" hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="SQLUserName" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string" />

      <children attribute="0" className="workflow.types.EncryptedString" controlHidden="0" controlType="0" defaultValue="" displayName="SQL Server Password" documentation="" hidden="0" inputType="workflow.types.EncryptedString" listType="0" maximumValue="" minimumValue="" name="SQLPassword" readOnly="0" required="1" searchable="0" type="{workflow.types}EncryptedString" />

      <children attribute="0" className="java.lang.String" controlHidden="0" controlType="0" defaultValue="" displayName="SharePoint Admin Name" documentation="SharePoint Admin Username" hidden="0" inputType="java.lang.String" listType="0" maximumValue="" minimumValue="" name="SharePointAdminName" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string" />

      <children attribute="0" className="workflow.types.EncryptedString" controlHidden="0" controlType="0" defaultValue="" displayName="SharePoint Admin Password" documentation="SharePoint Admin Password" hidden="0" inputType="workflow.types.EncryptedString" listType="0" maximumValue="" minimumValue="" name="SharePointAdminPassword" readOnly="0" required="1" searchable="0" type="{workflow.types}EncryptedString" />

      <children attribute="0" className="commvault.msgs.CvEntities.StoragePolicyEntity" controlHidden="0" controlType="2" defaultValue="" displayName="Storage Policy" documentation="Storage policy to be associated to the auto configured subclient" hidden="0" inputType="commvault.msgs.CvEntities.StoragePolicyEntity" listType="0" maximumValue="" minimumValue="" name="StoragePolicy" readOnly="0" required="1" searchable="0" type="{commvault.msgs.CvEntities}StoragePolicyEntity">

        <children attribute="0" className="java.lang.String" defaultValue="" inputType="java.lang.String" listType="0" name="storagePolicyName" type="{http://www.w3.org/2001/XMLSchema}string" />

        <children attribute="0" className="java.lang.Integer" defaultValue="" inputType="java.lang.Integer" listType="0" name="storagePolicyId" type="{http://www.w3.org/2001/XMLSchema}integer" />

      </children>

      <children attribute="0" className="commvault.msgs.CvEntities.SchedulePolicyEntity" controlHidden="0" controlType="2" defaultValue="" displayName="Schedule Policy" documentation="Schedule policy to be associated to the auto configured subclient" hidden="0" inputType="commvault.msgs.CvEntities.SchedulePolicyEntity" listType="0" maximumValue="" minimumValue="" name="SchedulePolicy" readOnly="0" required="0" searchable="0" type="{commvault.msgs.CvEntities}SchedulePolicyEntity">

        <children attribute="0" className="java.lang.String" defaultValue="" inputType="java.lang.String" listType="0" name="schedulePolicyName" type="{http://www.w3.org/2001/XMLSchema}string" />

        <children attribute="0" className="java.lang.Integer" defaultValue="" inputType="java.lang.Integer" listType="0" name="schedulePolicyId" type="{http://www.w3.org/2001/XMLSchema}integer" />

      </children>

    </inputs>

    <variables attribute="0" className="" name="variables" type="">

      <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="failureMessage" type="{http://www.w3.org/2001/XMLSchema}string" />

      <children attribute="0" className="java.lang.Integer" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Integer" listType="1" name="installJobList" type="{http://www.w3.org/2001/XMLSchema}integer" />

      <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="1" name="clientHostNames" type="{http://www.w3.org/2001/XMLSchema}string" />

      <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="sharePointClientHostNamesStr" type="{http://www.w3.org/2001/XMLSchema}string" />

      <children attribute="0" className="java.lang.Integer" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Integer" listType="0" name="sharePointFarmPseudoClientId" type="{http://www.w3.org/2001/XMLSchema}integer" />

      <children attribute="0" className="java.lang.Integer" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Integer" listType="0" name="sharePointPseudoClientPrimaryNodeClientId" type="{http://www.w3.org/2001/XMLSchema}integer" />

      <children attribute="0" className="commvault.msgs.CvEntities.ClientEntity" controlType="2" defaultValue="" displayName="" documentation="" hidden="0" inputType="commvault.msgs.CvEntities.ClientEntity" listType="0" name="sharePointPseudoClientEntity" type="{commvault.msgs.CvEntities}ClientEntity">

        <children attribute="0" className="java.lang.String" defaultValue="" inputType="java.lang.String" listType="0" name="clientName" type="{http://www.w3.org/2001/XMLSchema}string" />

        <children attribute="0" className="java.lang.Integer" defaultValue="" inputType="java.lang.Integer" listType="0" name="clientId" type="{http://www.w3.org/2001/XMLSchema}integer" />

      </children>

      <children attribute="0" className="java.lang.Boolean" controlType="5" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Boolean" listType="0" name="multipleSQLServersDetected" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}boolean" />

      <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="SPNodeIdsStr" type="{http://www.w3.org/2001/XMLSchema}string" />

      <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="tempDir" type="{http://www.w3.org/2001/XMLSchema}string" />

      <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="workflowLoggerPath" type="{http://www.w3.org/2001/XMLSchema}string" />

      <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="1" name="nodesFailedCheckReadinessForDataProtection" type="{http://www.w3.org/2001/XMLSchema}string" />

      <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="sqlServerName" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

      <children attribute="0" className="java.lang.Boolean" controlType="5" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Boolean" listType="0" name="multipleSQLInstanceDetected" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}boolean" />

      <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="usernameForInstallAgentJob" type="{http://www.w3.org/2001/XMLSchema}string" />

      <children attribute="0" className="workflow.types.EncryptedString" controlType="0" defaultValue="" displayName="" hidden="0" inputType="workflow.types.EncryptedString" listType="0" name="passwordForInstallAgentJob" type="{workflow.types}EncryptedString" />

      <children attribute="0" className="java.lang.Boolean" controlType="5" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Boolean" listType="0" name="shouldConfigureSQLSubclient" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}boolean" />

      <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="preExistingSPClientIds" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

    </variables>

    <outputs className="" name="outputs" type="">

      <children attribute="0" className="java.lang.Boolean" controlType="5" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Boolean" listType="0" name="Successfull" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}boolean" />

      <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="errorString" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

    </outputs>

    <config className="" name="configuration" type="" />

  </schema>

  <formProperties css="" formVersion="0" javaScript="" pageMode="0">

    <rules />

  </formProperties>

  <Start commented="0" continueOnFailure="0" created="0" description="" displayName="Start" height="38" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="0" style="image;image=/images/jgraphx/house.png" uniqueName="Start_1" waitSetting="0" width="92" x="118" y="33">

    <onEnter language="1" script="String slogFile = &quot;&quot;; &#xD;&#xA;slogFile = commvault.cte.workflow.WorkflowRegistry.getInstance().getLoggingDirectory();&#xD;&#xA;slogFile = slogFile + &quot;/AutoConfigureSharePointFarm&quot; + &quot;.log&quot;; &#xD;&#xA;workflow.setVariable(&quot;workflowLoggerPath&quot;, slogFile);&#xD;&#xA;&#xD;&#xA;logger.path(slogFile).info(&quot;Starting Auto configure SharePoint workflow with inputs: \n Pseudo ClientName:[&quot; + xpath:{/workflow/inputs/PseudoClientName} +&quot;]\n SQL ServerName:[&quot;+ xpath:{/workflow/inputs/SQLServerName} + &quot;]\n SQL Instance Name: [&quot; + xpath:{/workflow/inputs/SQLServerInstanceName} +&quot;]\n SQL Username:[&quot; + xpath:{/workflow/inputs/SQLUserName} + &quot;]\n SharePoint Admin name:[&quot; + xpath:{/workflow/inputs/SharePointAdminName} + &quot;]\n Storage Policy:[&quot; + xpath:{/workflow/inputs/StoragePolicy/storagePolicyName} + &quot;]&quot; );&#xD;&#xA;&#xD;&#xA;if(xpath:{/workflow/inputs/SQLServerInstanceName} != null || xpath:{/workflow/inputs/SQLServerInstanceName} != &quot;&quot;)&#xD;&#xA;{&#xD;&#xA;    String sqlServerInstanceName = xpath:{/workflow/inputs/SQLServerInstanceName};&#xD;&#xA;    &#xD;&#xA;    //If instance name is provided in the form of &lt;hostname&gt;/instance strip out the hostname and form sql server name using the hostname input of workflow.     &#xD;&#xA;    int pos = sqlServerInstanceName.indexOf(''\\'');&#xD;&#xA;    &#xD;&#xA;    if(pos != -1)&#xD;&#xA;    {&#xD;&#xA;        sqlServerInstanceName = sqlServerInstanceName.substring(pos + 1);&#xD;&#xA;    }&#xD;&#xA;    &#xD;&#xA;    if(sqlServerInstanceName.equalsIgnoreCase(&quot;MSSQLSERVER&quot;))&#xD;&#xA;    {&#xD;&#xA;        sqlServerInstanceName = &quot;&quot;;&#xD;&#xA;        workflow.setVariable(&quot;sqlServerName&quot;, xpath:{/workflow/inputs/SQLServerName});&#xD;&#xA;    }&#xD;&#xA;    else&#xD;&#xA;    {&#xD;&#xA;        workflow.setVariable(&quot;sqlServerName&quot;, xpath:{/workflow/inputs/SQLServerName} + &quot;\\&quot; + sqlServerInstanceName);&#xD;&#xA;    }   &#xD;&#xA;}&#xD;&#xA;else&#xD;&#xA;{&#xD;&#xA;    workflow.setVariable(&quot;sqlServerName&quot;, xpath:{/workflow/inputs/SQLServerName});&#xD;&#xA;}&#xD;&#xA;&#xD;&#xA;&#xD;&#xA;" />

    <inputs val="&lt;inputs /&gt;" />

    <transition activity="SQLQuery_1" commented="0" originalStyle="" points="" sourceX="265" sourceY="48" status="0" style="defaultEdge" targetX="260" targetY="170" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Start>

  <Activity commented="0" continueOnFailure="1" created="1550642683562" description="executes queries against a specified database" displayName="Detect Farm Configuration" height="40" interactive="0" jobMode="0" maxRestarts="0" name="SQLQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.GenercicDBQuery" uniqueName="SQLQuery_1" waitSetting="0" width="200" x="60" y="140">

    <onEnter language="1" script="logger.path(xpath:{/workflow/variables/workflowLoggerPath}).info(&quot;Connecting to SQL Server: [&quot; + xpath:{/workflow/variables/sqlServerName} +&quot;] to detect farm configuration....&quot;);" />

    <onExit language="1" script="if (xpath:{/workflow/SQLQuery_1/errorCode} != 0 || xpath:{/workflow/SQLQuery_1/resultSets} == null)&#xD;&#xA;{&#xD;&#xA;   logger.path(xpath:{/workflow/variables/workflowLoggerPath}).info(&quot;Failed to execute SQL to detect farm configuration with error code [&quot; + xpath:{/workflow/SQLQuery_1/errorCode} + &quot;].&quot;);&#xD;&#xA;   workflow.setVariable(&quot;failureMessage&quot;,&quot;Failed to detect SharePoint farm configuration. Try resubmitting the job and make sure SQL credentials provided are correct.&quot;);&#xD;&#xA;}&#xD;&#xA;else if(xpath:{/workflow/SQLQuery_1/resultSets[1]/rowCount} == 0)&#xD;&#xA;{&#xD;&#xA;    logger.path(xpath:{/workflow/variables/workflowLoggerPath}).info(&quot;No servers found in Farm configuration.&quot;);&#xD;&#xA;    workflow.setVariable(&quot;failureMessage&quot;,&quot;No servers found in Farm configuration.&quot;);&#xD;&#xA;}&#xD;&#xA;else if(xpath:{/workflow/SQLQuery_1/resultSets[2]} == null || xpath:{/workflow/SQLQuery_1/resultSets[2]/rowCount} == 0)&#xD;&#xA;{&#xD;&#xA;    logger.path(xpath:{/workflow/variables/workflowLoggerPath}).info(&quot;No SQL nodes found in Farm configuration.&quot;);&#xD;&#xA;    workflow.setVariable(&quot;failureMessage&quot;,&quot;Failed to detect SharePoint farm configuration.&quot;);&#xD;&#xA;}&#xD;&#xA;else&#xD;&#xA;{&#xD;&#xA;    workflow.setVariable(&quot;sharePointClientHostNamesStr&quot;,xpath:{/workflow/SQLQuery_1/resultSets[1]/row/col[''serverhostname'']}.toString().replaceAll(&quot;\\[&quot;,&quot;&quot;).replaceAll(&quot;\\]&quot;,&quot;&quot;));&#xD;&#xA;    &#xD;&#xA;    //Workflow does not currently support auto configuring of multiple SQL servers&#xD;&#xA;    if(xpath:{/workflow/SQLQuery_1/resultSets[2]/rowCount} &gt; 1)&#xD;&#xA;    {&#xD;&#xA;        logger.path(xpath:{/workflow/variables/workflowLoggerPath}).info(&quot;Multiple SQL Servers detected.&quot;);&#xD;&#xA;        workflow.setVariable(&quot;multipleSQLServersDetected&quot;,true);&#xD;&#xA;    }&#xD;&#xA;}&#xD;&#xA;&#xD;&#xA;" />

    <inputs val="&lt;inputs&gt;&lt;databaseType class=&quot;workflow.types.DatabaseType&quot; _list_=&quot;false&quot;&gt;MSSQL&lt;/databaseType&gt;&lt;server class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/variables/sqlServerName}&lt;/server&gt;&lt;databaseName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;master&lt;/databaseName&gt;&lt;properties class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;userName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/inputs/SQLUserName}&lt;/userName&gt;&lt;password class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/inputs/SQLPassword}&lt;/password&gt;&lt;query class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;SET NOCOUNT ON&amp;#xD;&#xD;&#xA;Begin Try&amp;#xD;&#xD;&#xA;Declare @configTable nvarchar(max)&amp;#xD;&#xD;&#xA;DECLARE @MyCursor CURSOR;&amp;#xD;&#xD;&#xA;DECLARE @MyField nvarchar(max),@sql nvarchar(max),@class nvarchar(max),@sql1 nvarchar(max);&amp;#xD;&#xD;&#xA;set @class = ''Classes''&amp;#xD;&#xD;&#xA;BEGIN&amp;#xD;&#xD;&#xA;    SET @MyCursor = CURSOR FOR&amp;#xD;&#xD;&#xA;    SELECT name&amp;#xD;&#xD;&#xA;    FROM master.dbo.sysdatabases &amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;    OPEN @MyCursor &amp;#xD;&#xD;&#xA;    FETCH NEXT FROM @MyCursor &amp;#xD;&#xD;&#xA;    INTO @MyField&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;    WHILE @@FETCH_STATUS = 0&amp;#xD;&#xD;&#xA;    BEGIN&amp;#xD;&#xD;&#xA;    &amp;#xD;&#xD;&#xA;    set @sql = ''use ''+ quotename(@MyField)+ '';SELECT count(*) FROM information_schema.tables where table_name = ''''Classes'''' or table_name = ''''Objects''''''&amp;#xD;&#xD;&#xA;    declare @result table(rcount int);&amp;#xD;&#xD;&#xA;    insert into @result(rcount)&amp;#xD;&#xD;&#xA;    Exec (@sql)&amp;#xD;&#xD;&#xA;    &amp;#xD;&#xD;&#xA;    declare @rcount int = (select top (1) rcount from @result);&amp;#xD;&#xD;&#xA;    delete from  @result&amp;#xD;&#xD;&#xA;    &amp;#xD;&#xD;&#xA;    set @sql1 = ''use ''+ quotename(@MyField) + '';SELECT count(*) FROM information_schema.routines where specific_name = ''''proc_GetObject'''' or specific_name = ''''proc_getObjectsByBaseClass''''''&amp;#xD;&#xD;&#xA;    declare @result1 table(rcount int);&amp;#xD;&#xD;&#xA;    insert into @result1(rcount)&amp;#xD;&#xD;&#xA;    Exec (@sql1)&amp;#xD;&#xD;&#xA;    &amp;#xD;&#xD;&#xA;    declare @rcount1 int = (select top (1) rcount from @result1);&amp;#xD;&#xD;&#xA;    delete from  @result1&amp;#xD;&#xD;&#xA;    &amp;#xD;&#xD;&#xA;    if @rcount = 2 and @rcount1 = 2&amp;#xD;&#xD;&#xA;    begin&amp;#xD;&#xD;&#xA;    set @configTable = @MyField&amp;#xD;&#xD;&#xA;&#x9;goto nextline&amp;#xD;&#xD;&#xA;    end&amp;#xD;&#xD;&#xA;      FETCH NEXT FROM @MyCursor &amp;#xD;&#xD;&#xA;      INTO @MyField &amp;#xD;&#xD;&#xA;    END; &amp;#xD;&#xD;&#xA;nextline:&amp;#xD;&#xD;&#xA;    CLOSE @MyCursor ;&amp;#xD;&#xD;&#xA;    DEALLOCATE @MyCursor;&amp;#xD;&#xD;&#xA;    &amp;#xD;&#xD;&#xA;END;&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;---select @configTable&amp;#xD;&#xD;&#xA;declare @sql4 nvarchar(max)&amp;#xD;&#xD;&#xA;--set @configTable = ''SharePoint_Config''&amp;#xD;&#xD;&#xA;declare @sql3 nvarchar(max)&amp;#xD;&#xD;&#xA;--select @configTable&amp;#xD;&#xD;&#xA;set @sql3 = ''use [''+ @configTable + ''] exec dbo.proc_getObjectsByBaseClass @BaseClassId=''''280E2581-1E2B-40C7-80C2-2E0032BCFBE4'''',&amp;#xD;&#xD;&#xA;            @ParentId=NULL,@RequestGuid=''''00000000-0000-0000-0000-000000000000'''' ''&amp;#xD;&#xD;&#xA;--280E2581-1E2B-40C7-80C2-2E0032BCFBE4&amp;#xD;&#xD;&#xA;Declare @tableoutput Table(Id uniqueidentifier)&amp;#xD;&#xD;&#xA;Insert into @tableoutput &amp;#xD;&#xD;&#xA;Exec (@sql3)&amp;#xD;&#xD;&#xA;--select * from @tableoutput&amp;#xD;&#xD;&#xA;set @sql4 = ''use [''+ @configTable +''] SELECT Id,Name,Properties  &amp;#xD;&#xD;&#xA;  FROM [dbo].[Objects]''&amp;#xD;&#xD;&#xA;-- get the objects with server id and the xml properties&amp;#xD;&#xD;&#xA;Declare @tableoutput2 Table(Id uniqueidentifier,Name nvarchar(max),Properties xml)&amp;#xD;&#xD;&#xA;Insert into @tableoutput2 &amp;#xD;&#xD;&#xA;exec (@sql4)&amp;#xD;&#xD;&#xA;  --select * from  @tableoutput2&amp;#xD;&#xD;&#xA;Declare @tableoutput3 Table(Name nvarchar(max),Properties xml)&amp;#xD;&#xD;&#xA;Insert into @tableoutput3(Name,Properties) &amp;#xD;&#xD;&#xA;SELECT Name,Properties from @tableoutput2&amp;#xD;&#xD;&#xA;  where id in (select * from @tableoutput)&amp;#xD;&#xD;&#xA;  --select * from  @tableoutput3&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;IF EXISTS (SELECT 1 FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N''tempdb..#tempServer'')) DROP TABLE #tempServer&amp;#xD;&#xD;&#xA;create table #tempServer (serverhostname nvarchar(max), type int)&amp;#xD;&#xD;&#xA; insert into #tempServer&amp;#xD;&#xD;&#xA; select Name, case when m.c.value(''(text())[1]'', ''nvarchar(max)'') Like ''Invalid'' then  1 else 0 end&amp;#xD;&#xD;&#xA; from @tableoutput3 as s&amp;#xD;&#xD;&#xA;    outer apply s.Properties.nodes(''(/object/fld)'') as m(c)  where (m.c.value(''@name'', ''nvarchar(max)'') Like ''m_ServerRole'')&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;select serverhostname from #tempServer where #tempServer.type = 0&amp;#xD;&#xD;&#xA;select serverhostname from #tempServer where #tempServer.type = 1&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;drop table  #tempServer&amp;#xD;&#xD;&#xA;END Try&amp;#xD;&#xD;&#xA;begin catch  &amp;#xD;&#xD;&#xA; select ''Failed with Error:'',ERROR_MESSAGE() AS ErrorMessage;&amp;#xD;&#xD;&#xA;end catch&amp;#xD;&#xD;&#xA;&lt;/query&gt;&lt;/inputs&gt;" />

    <transition activity="PreExistingClientsQuery" commented="0" originalStyle="" points="" sourceX="160" sourceY="160" status="0" style="defaultEdge" targetX="150" targetY="260" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;xpath:{/workflow/SQLQuery_1/errorCode} == 0 &amp;&amp; xpath:{/workflow/SQLQuery_1/resultSets} != null &amp;&amp; xpath:{/workflow/SQLQuery_1/resultSets[1]/rowCount} &gt; 0 &amp;&amp; xpath:{/workflow/SQLQuery_1/resultSets[2]} != null &amp;&amp; xpath:{/workflow/SQLQuery_1/resultSets[2]/rowCount} &gt; 0" />

    </transition>

    <transition activity="WorkflowEnd_2" commented="0" originalStyle="" points="436.0,168.0" sourceX="149" sourceY="209" status="0" style="defaultEdge" targetX="147" targetY="340" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;xpath:{/workflow/SQLQuery_1/errorCode} != 0 || xpath:{/workflow/SQLQuery_1/resultSets} == null || xpath:{/workflow/SQLQuery_1/resultSets[1]/rowCount} == 0 || xpath:{/workflow/SQLQuery_1/resultSets[2]} == null || xpath:{/workflow/SQLQuery_1/resultSets[2]/rowCount} == 0" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1550675339662" description="Ends the workflow" displayName="Failed" height="40" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.EndActivity" uniqueName="WorkflowEnd_2" waitSetting="0" width="130" x="332" y="330">

    <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;&gt;FAILED&lt;/completionStatus&gt;&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/variables/failureMessage}&lt;/failureMessage&gt;&lt;/inputs&gt;" />

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1550828884502" description="Ends the workflow" displayName="Failed" height="50" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.EndActivity" uniqueName="WorkflowEnd_4" waitSetting="0" width="200" x="390" y="710">

    <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;&gt;FAILED&lt;/completionStatus&gt;&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/variables/failureMessage}&lt;/failureMessage&gt;&lt;/inputs&gt;" />

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1551094530349" description="executes queries against a commcell database" displayName="Get Client Details" height="40" interactive="0" jobMode="0" maxRestarts="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_2" waitSetting="0" width="200" x="60" y="500">

    <onEnter language="1" script="logger.path(xpath:{/workflow/variables/workflowLoggerPath}).info(&quot;Sharepoint clientHostNames: &quot; + xpath:{/workflow/SQLQuery_1/resultSets[1]/row/col[''serverhostname'']}.toString());  " />

    <onExit language="1" script="if(xpath:{/workflow/CommServDBQuery_2/resultSets} == null || xpath:{/workflow/CommServDBQuery_2/errorCode} != 0)&#xD;&#xA;{&#xD;&#xA;    logger.path(xpath:{/workflow/variables/workflowLoggerPath}).info(&quot;Failed to fetch SharePoint client details.&quot;);&#xD;&#xA;    workflow.setVariable(&quot;failureMessage&quot;,&quot;Failed to fetch SharePoint client details&quot;);&#xD;&#xA;} &#xD;&#xA;else if(xpath:{/workflow/CommServDBQuery_2/resultSets[1]/row[1]/col[&quot;SharePointClientsCount&quot;]} &lt; xpath:{/workflow/SQLQuery_1/resultSets[1]/rowCount})&#xD;&#xA;{&#xD;&#xA;    logger.path(xpath:{/workflow/variables/workflowLoggerPath}).info(&quot;Could not find all the needed SharePoint clients on the Commserver. Found [&quot; + xpath:{/workflow/CommServDBQuery_2/resultSets[1]/row[1]/col[&quot;SharePointClientsCount&quot;]} + &quot;], Expected [&quot; + xpath:{/workflow/SQLQuery_1/resultSets[1]/rowCount} +&quot;].&quot;);&#xD;&#xA;    workflow.setVariable(&quot;failureMessage&quot;,&quot;Could not find all the needed SharePoint clients on the Commserver. Found [&quot; + xpath:{/workflow/CommServDBQuery_2/resultSets[1]/row[1]/col[&quot;SharePointClientsCount&quot;]} + &quot;], Expected [&quot; + xpath:{/workflow/SQLQuery_1/resultSets[1]/rowCount} +&quot;].&quot;);&#xD;&#xA;}&#xD;&#xA;else if(xpath:{/workflow/CommServDBQuery_2/resultSets[1]/row[1]/col[&quot;SharePointClientsCount&quot;]} &gt; xpath:{/workflow/SQLQuery_1/resultSets[1]/rowCount})&#xD;&#xA;{&#xD;&#xA;    logger.path(xpath:{/workflow/variables/workflowLoggerPath}).info(&quot;Found multiple clients matching SharePoint clients hostnames on the Commserver.&quot;);&#xD;&#xA;    workflow.setVariable(&quot;failureMessage&quot;,&quot;Found multiple clients matching SharePoint clients hostnames on the Commserver.&quot;);&#xD;&#xA;}&#xD;&#xA;else &#xD;&#xA;{&#xD;&#xA;    workflow.setVariable(&quot;sharePointPseudoClientPrimaryNodeClientId&quot;,xpath:{/workflow/CommServDBQuery_2/resultSets[3]/row[1]/col[&quot;primaryMemberServerClientId&quot;]});&#xD;&#xA;    &#xD;&#xA;    String temp = xpath:{/workflow/CommServDBQuery_2/resultSets[4]/row/col[&quot;clientId&quot;]}.toString();&#xD;&#xA;    temp = temp.replace(''['','' '').replace('']'','' '');&#xD;&#xA;    workflow.setVariable(&quot;SPNodeIdsStr&quot;, temp);&#xD;&#xA;    &#xD;&#xA;    logger.path(xpath:{/workflow/variables/workflowLoggerPath}).info(&quot;Selected primary node: &quot; + xpath:{/workflow/CommServDBQuery_2/resultSets[3]/row[1]/col[&quot;primaryMemberServerClientId&quot;]});  &#xD;&#xA;    logger.path(xpath:{/workflow/variables/workflowLoggerPath}).info(&quot;Sharepoint node client Ids: &quot; + temp);  &#xD;&#xA;}&#xD;&#xA;&#xD;&#xA;" />

    <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;IF object_id(''tempdb.dbo.#PseudoClientMemberServers'') IS NOT NULL DROP TABLE #PseudoClientMemberServers&amp;#xD;&#xD;&#xA;CREATE TABLE #PseudoClientMemberServers (clientId INT, name VARCHAR(max), hostname varchar(max), memberType INT, preExisted BIT)&amp;#xD;&#xD;&#xA;DECLARE @primaryMemberServerClientId INT&amp;#xD;&#xD;&#xA;DECLARE @multipleSQLServerNodeDetected BIT = ?&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;-- Insert SharePoint nodes&amp;#xD;&#xD;&#xA;INSERT INTO #PseudoClientMemberServers &amp;#xD;&#xD;&#xA;SELECT AC.id, AC.name, AC.net_hostname, 78, CASE WHEN AC.id IN (xpath:{/workflow/variables/preExistingSPClientIds}) THEN 1 ELSE 0 END &amp;#xD;&#xD;&#xA;FROM App_Client AC WITH(NOLOCK) &amp;#xD;&#xD;&#xA;INNER JOIN (SELECT * FROM dbo.split(?, '', '')) T ON AC.net_hostname LIKE  T.data + ''.%'' OR AC.net_hostname = T.Data&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;-- Insert SQL node Not needed as of now. Commenting it out&amp;#xD;&#xD;&#xA;--INSERT INTO #PseudoClientMemberServers &amp;#xD;&#xD;&#xA;--SELECT AC.id, AC.name, AC.net_hostname, 81 FROM App_Client AC WITH(NOLOCK) &amp;#xD;&#xD;&#xA;--WHERE AC.net_hostname = ?&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;SELECT COUNT(*) AS SharePointClientsCount FROM #PseudoClientMemberServers WHERE memberType = 78&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;--Get primary SharePoint node&amp;#xD;&#xD;&#xA;SET @primaryMemberServerClientId = (SELECT TOP 1 clientId FROM #PseudoClientMemberServers WHERE memberType = 78)&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;SELECT&amp;#xD;&#xD;&#xA;(&amp;#xD;&#xD;&#xA;    SELECT &amp;#xD;&#xD;&#xA;        (&amp;#xD;&#xD;&#xA;            SELECT&amp;#xD;&#xD;&#xA;                    27 AS ''@clientType'',&amp;#xD;&#xD;&#xA;                    (&amp;#xD;&#xD;&#xA;                        SELECT &amp;#xD;&#xD;&#xA;                                23 AS ''@sharePointVersion'',&amp;#xD;&#xD;&#xA;                                CASE WHEN @multipleSQLServerNodeDetected = 1 &amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9; THEN 0&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9; ELSE 1 &amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;END AS ''@SharePointFarmAutoConfigured'',&amp;#xD;&#xD;&#xA;                                (&amp;#xD;&#xD;&#xA;                                    SELECT &amp;#xD;&#xD;&#xA;                                            23 AS ''@sharePointVersion'',&amp;#xD;&#xD;&#xA;                                            (&amp;#xD;&#xD;&#xA;                                                SELECT &amp;#xD;&#xD;&#xA;                                                        hostname AS ''@hostname'', &amp;#xD;&#xD;&#xA;                                                        name AS ''@clientName'', &amp;#xD;&#xD;&#xA;                                                        clientId AS ''@clientId''&amp;#xD;&#xD;&#xA;                                                FROM #PseudoClientMemberServers &amp;#xD;&#xD;&#xA;                                                WHERE clientId = @primaryMemberServerClientId&amp;#xD;&#xD;&#xA;                                                FOR XML PATH(''client''), TYPE&amp;#xD;&#xD;&#xA;                                            )&amp;#xD;&#xD;&#xA;    &amp;#xD;&#xD;&#xA;                                    FOR XML PATH(''primaryMemberServer''), TYPE&amp;#xD;&#xD;&#xA;                                ),&amp;#xD;&#xD;&#xA;                                (&amp;#xD;&#xD;&#xA;                                    SELECT &amp;#xD;&#xD;&#xA;                                    (&amp;#xD;&#xD;&#xA;                                        SELECT&amp;#xD;&#xD;&#xA;                                            23 AS ''@sharePointVersion'',&amp;#xD;&#xD;&#xA;                                            memberType AS ''@o365MemberType'',&amp;#xD;&#xD;&#xA;                                            (&amp;#xD;&#xD;&#xA;                                                SELECT hostname AS ''@hostName'', name AS ''@clientName'', clientId AS ''@clientId''&amp;#xD;&#xD;&#xA;                                                FOR XML PATH(''client''), TYPE&amp;#xD;&#xD;&#xA;                                            )&amp;#xD;&#xD;&#xA;                                        FROM #PseudoClientMemberServers &amp;#xD;&#xD;&#xA;                                        WHERE clientId &amp;lt;&amp;gt; @primaryMemberServerClientId --AND (@multipleSQLServerNodeDetected = 0 OR (@multipleSQLServerNodeDetected = 1 AND memberType != 81)) -- primary server is not added in secondary servers&amp;#xD;&#xD;&#xA;                                        FOR XML PATH(''memberServers''), TYPE&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&amp;#xD;&#xD;&#xA;                                    )&amp;#xD;&#xD;&#xA;                                    FOR XML PATH(''spMemberServers''), TYPE&amp;#xD;&#xD;&#xA;                                )&amp;#xD;&#xD;&#xA;                        FOR XML PATH(''sharepointPseudoClientProperties''), TYPE&amp;#xD;&#xD;&#xA;                    )&amp;#xD;&#xD;&#xA;                &amp;#xD;&#xD;&#xA;            FOR XML PATH(''clientInfo''), TYPE&amp;#xD;&#xD;&#xA;        ),&amp;#xD;&#xD;&#xA;        (SELECT ''xpath:{/workflow/inputs/PseudoClientName}'' AS ''@clientName'', 3 AS &quot;@_type_&quot; FOR XML PATH(''entity''), TYPE)&amp;#xD;&#xD;&#xA;    &amp;#xD;&#xD;&#xA;    FOR XML PATH(''''),&amp;#xD;&#xD;&#xA;    ROOT(''App_CreatePseudoClientRequest'')&amp;#xD;&#xD;&#xA;)&amp;#xD;&#xD;&#xA;AS createPseudoClientXML&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;SELECT @primaryMemberServerClientId AS primaryMemberServerClientId&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;SELECT clientId FROM #PseudoClientMemberServers WHERE memberType = 78&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;-- only for not pre existing clients update the service account details.&amp;#xD;&#xD;&#xA;SELECT clientId FROM #PseudoClientMemberServers WHERE memberType = 78 AND preExisted = 0&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;IF object_id(''tempdb.dbo.#PseudoClientMemberServers'') IS NOT NULL DROP TABLE #PseudoClientMemberServers&amp;#xD;&#xD;&#xA;&lt;/query&gt;&lt;parameters&gt;&lt;value&gt;xpath:{/workflow/variables/multipleSQLServersDetected}&lt;/value&gt;&lt;type&gt;OBJECT&lt;/type&gt;&lt;/parameters&gt;&lt;parameters&gt;&lt;value&gt;xpath:{/workflow/variables/sharePointClientHostNamesStr}&lt;/value&gt;&lt;type&gt;OBJECT&lt;/type&gt;&lt;/parameters&gt;&lt;/inputs&gt;" />

    <transition activity="ForEach_6" commented="0" originalStyle="" points="" sourceX="160" sourceY="510" status="0" style="defaultEdge" targetX="160" targetY="580" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;xpath:{/workflow/CommServDBQuery_2/resultSets[1]/row[1]/col[&quot;SharePointClientsCount&quot;]} == xpath:{/workflow/SQLQuery_1/resultSets[1]/rowCount}" />

    </transition>

    <transition activity="WorkflowEnd_2" commented="0" originalStyle="" points="400.0,470.0" sourceX="160" sourceY="490" status="0" style="defaultEdge" targetX="430" targetY="160" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;xpath:{/workflow/CommServDBQuery_2/errorCode} != 0 || xpath:{/workflow/CommServDBQuery_2/resultSets} == null || xpath:{/workflow/CommServDBQuery_2/resultSets[1]/row[1]/col[&quot;SharePointClientsCount&quot;]} != xpath:{/workflow/SQLQuery_1/resultSets[1]/rowCount}" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1551268845771" description="creates a super process group" displayName="Push Install Process Block" height="500" interactive="0" jobMode="0" name="ProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="swimlane" uniqueName="ProcessBlock_1" waitSetting="0" width="840" x="60" y="990">

    <activitySchema>

      <inputs className="" defaultValue="" listType="0" name="inputs" type="">

        <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="1" name="clientHostnames" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

        <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="installPackageXML" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

      </inputs>

      <outputs className="" defaultValue="" listType="0" name="outputs" type="">

        <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="1" name="clientHostnames" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

        <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="installPackageXML" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

      </outputs>

    </activitySchema>

    <inputs val="&lt;inputs&gt;&lt;inputs&gt;&lt;clientHostnames class=&quot;java.lang.String&quot; _list_=&quot;true&quot; /&gt;&lt;installPackageXML class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/inputs&gt;&lt;/inputs&gt;" />

    <superProcess>

      <Start commented="0" continueOnFailure="0" created="1551268845772" description="" displayName="Start" height="30" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="0" style="label;fillColor=#FFFF33;gradientColor=#FFFF00" uniqueName="Start_6" waitSetting="0" width="120" x="216" y="33">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="ForEach_3" commented="0" originalStyle="" points="280.0,80.0" sourceX="188" sourceY="45" status="0" style="defaultEdge" targetX="185" targetY="97" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Start>

      <Activity commented="0" continueOnFailure="0" created="1551269041858" description="iterates a group of activities over a list of values" displayName="Push Install Agents" height="370" interactive="0" jobMode="0" name="ForEach" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="swimlane" uniqueName="ForEach_3" waitSetting="0" width="530" x="20" y="100">

        <activitySchema>

          <inputs>

            <children className="java.lang.String" inputType="java.lang.String" name="name" type="{http://www.w3.org/2001/XMLSchema}string" />

            <children className="java.lang.Object" inputType="java.lang.Object" name="values" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            <children className="java.lang.Integer" defaultValue="1" inputType="java.lang.Integer" name="numberOfParallelExecutions" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.Boolean" defaultValue="false" inputType="java.lang.Boolean" name="continueOnFailure" type="{http://www.w3.org/2001/XMLSchema}boolean" />

          </inputs>

          <outputs name="outputs">

            <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="clientHostnames" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

          </outputs>

        </activitySchema>

        <inputs val="&lt;inputs&gt;&lt;name class=&quot;java.lang.String&quot;&gt;clientHostnames&lt;/name&gt;&lt;values class=&quot;java.lang.Object&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/ProcessBlock_1/clientHostnames}&lt;/values&gt;&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;&gt;9999&lt;/numberOfParallelExecutions&gt;&lt;continueOnFailure class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/continueOnFailure&gt;&lt;/inputs&gt;" />

        <transition activity="WaitForJobCompletion_4" commented="0" originalStyle="" points="580.0,300.0" sourceX="208" sourceY="271" status="0" style="defaultEdge" targetX="568" targetY="294" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

        <superProcess>

          <Start commented="0" continueOnFailure="0" created="1550755506961" description="" displayName="Start" height="30" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="0" style="label;fillColor=#FFFF33;gradientColor=#FFFF00" uniqueName="Start_9" waitSetting="0" width="120" x="60" y="34">

            <inputs val="&lt;inputs /&gt;" />

            <transition activity="AddToList_3" commented="0" originalStyle="" points="" sourceX="120" sourceY="49" status="0" style="defaultEdge" targetX="120" targetY="114" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Start>

          <Activity commented="0" continueOnFailure="0" created="1550755538001" description="" displayName="Install agent" height="34" interactive="0" jobMode="0" name="Execute" namespaceUri="commvault.cte.workflow.activities.cmd.operation" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.cmd.operation.OperationExecute" uniqueName="Execute_3" waitSetting="0" width="200" x="19" y="171">

            <onEnter language="1" script="logger.path(xpath:{/workflow/variables/workflowLoggerPath}).info(&quot;On host :&quot; + xpath:{/workflow/ForEach_3/clientHostnames} + &quot;, installing packages from XML &quot; + xpath:{/workflow/ProcessBlock_1/installPackageXML});&#xD;&#xA;&#xD;&#xA;" />

            <onExit language="1" script="if (xpath:{/workflow/Execute_3/exitCode} != 0)&#xD;&#xA;{&#xD;&#xA;        workflow.setVariable(&quot;failureMessage&quot;,&quot;Failed to install agent. Try resubmitting the job and make sure SharePoint admin credentials provided are correct.&quot;);&#xD;&#xA;        logger.path(xpath:{/workflow/variables/workflowLoggerPath}).info(&quot;Failed to install packages in XML [&quot; + xpath:{/workflow/ProcessBlock_1/installPackageXML} + &quot;] on host [&quot; + xpath:{/workflow/ForEach_3/clientHostnames} + &quot;]. Output XML: &quot; + xpath:{/workflow/Execute_3/outputXml});&#xD;&#xA;}     " />

            <inputs val="&lt;inputs&gt;&lt;inputXml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;&amp;lt;?xml version=&quot;1.0&quot; encoding=&quot;UTF-8&quot; standalone=&quot;no&quot; ?&amp;gt;&amp;#xD;&#xD;&#xA; &amp;lt;TMMsg_CreateTaskReq&amp;gt;&amp;#xD;&#xD;&#xA;   &amp;lt;taskInfo&amp;gt;&amp;#xD;&#xD;&#xA;     &amp;lt;task&amp;gt;&amp;#xD;&#xD;&#xA;       &amp;lt;taskName&amp;gt;&amp;lt;/taskName&amp;gt;&amp;#xD;&#xD;&#xA;       &amp;lt;taskFlags&amp;gt;&amp;#xD;&#xD;&#xA;         &amp;lt;disabled&amp;gt;false&amp;lt;/disabled&amp;gt;&amp;#xD;&#xD;&#xA;       &amp;lt;/taskFlags&amp;gt;&amp;#xD;&#xD;&#xA;       &amp;lt;taskType&amp;gt;IMMEDIATE&amp;lt;/taskType&amp;gt;&amp;#xD;&#xD;&#xA;       &amp;lt;initiatedFrom&amp;gt;COMMANDLINE&amp;lt;/initiatedFrom&amp;gt;&amp;#xD;&#xD;&#xA;     &amp;lt;/task&amp;gt;&amp;#xD;&#xD;&#xA;     &amp;lt;associations/&amp;gt;&amp;#xD;&#xD;&#xA;     &amp;lt;subTasks&amp;gt;&amp;#xD;&#xD;&#xA;       &amp;lt;subTask&amp;gt;&amp;#xD;&#xD;&#xA;         &amp;lt;subTaskType&amp;gt;ADMIN&amp;lt;/subTaskType&amp;gt;&amp;#xD;&#xD;&#xA;         &amp;lt;operationType&amp;gt;INSTALL_CLIENT&amp;lt;/operationType&amp;gt;&amp;#xD;&#xD;&#xA;       &amp;lt;/subTask&amp;gt;&amp;#xD;&#xD;&#xA;       &amp;lt;options&amp;gt;&amp;#xD;&#xD;&#xA;         &amp;lt;adminOpts&amp;gt;&amp;#xD;&#xD;&#xA;           &amp;lt;updateOption/&amp;gt;&amp;#xD;&#xD;&#xA;           &amp;lt;clientInstallOption&amp;gt;&amp;#xD;&#xD;&#xA;             &amp;lt;clientDetails&amp;gt;&amp;#xD;&#xD;&#xA;               &amp;lt;clientEntity&amp;gt;&amp;#xD;&#xD;&#xA;                 &amp;lt;commCellName&amp;gt;xpath:{/workflow/system/commCellName}&amp;lt;/commCellName&amp;gt;&amp;#xD;&#xD;&#xA;                 &amp;lt;clientName&amp;gt;xpath:{/workflow/ForEach_3/clientHostnames}&amp;lt;/clientName&amp;gt;&amp;#xD;&#xD;&#xA;               &amp;lt;/clientEntity&amp;gt;&amp;#xD;&#xD;&#xA;             &amp;lt;/clientDetails&amp;gt;&amp;#xD;&#xD;&#xA;             &amp;lt;installOSType&amp;gt;WINDOWS&amp;lt;/installOSType&amp;gt;&amp;#xD;&#xD;&#xA;             &amp;lt;discoveryType&amp;gt;MANUAL&amp;lt;/discoveryType&amp;gt;&amp;#xD;&#xD;&#xA;             &amp;lt;installerOption&amp;gt;&amp;#xD;&#xD;&#xA;               &amp;lt;RemoteClient&amp;gt;false&amp;lt;/RemoteClient&amp;gt;&amp;#xD;&#xD;&#xA;               &amp;lt;requestType&amp;gt;PRE_DECLARE_CLIENT&amp;lt;/requestType&amp;gt;&amp;#xD;&#xD;&#xA;               &amp;lt;User&amp;gt;&amp;#xD;&#xD;&#xA;                 &amp;lt;userName&amp;gt;admin&amp;lt;/userName&amp;gt;&amp;#xD;&#xD;&#xA;               &amp;lt;/User&amp;gt;&amp;#xD;&#xD;&#xA;               &amp;lt;Operationtype&amp;gt;INSTALL_CLIENT&amp;lt;/Operationtype&amp;gt;&amp;#xD;&#xD;&#xA;               &amp;lt;CommServeHostName&amp;gt;xpath:{/workflow/system/commCellHost}&amp;lt;/CommServeHostName&amp;gt;&amp;#xD;&#xD;&#xA;               &amp;lt;CommServeInfo/&amp;gt;&amp;#xD;&#xD;&#xA;               &amp;lt;clientComposition&amp;gt;&amp;#xD;&#xD;&#xA;                 &amp;lt;overrideSoftwareCache&amp;gt;false&amp;lt;/overrideSoftwareCache&amp;gt;&amp;#xD;&#xD;&#xA;                 &amp;lt;clientInfo&amp;gt;&amp;#xD;&#xD;&#xA;                   &amp;lt;client&amp;gt;&amp;#xD;&#xD;&#xA;                     &amp;lt;cvdPort&amp;gt;0&amp;lt;/cvdPort&amp;gt;&amp;#xD;&#xD;&#xA;                   &amp;lt;/client&amp;gt;&amp;#xD;&#xD;&#xA;                 &amp;lt;/clientInfo&amp;gt;&amp;#xD;&#xD;&#xA;                 &amp;lt;components&amp;gt;&amp;#xD;&#xD;&#xA;                   xpath:{/workflow/ProcessBlock_1/installPackageXML}&amp;#xD;&#xD;&#xA;                   &amp;lt;commonInfo&amp;gt;&amp;#xD;&#xD;&#xA;                     &amp;lt;storagePolicyToUse&amp;gt;&amp;#xD;&#xD;&#xA;                       &amp;lt;storagePolicyName&amp;gt;xpath:{/workflow/inputs/StoragePolicy/storagePolicyName}&amp;lt;/storagePolicyName&amp;gt;&amp;#xD;&#xD;&#xA;                     &amp;lt;/storagePolicyToUse&amp;gt;  &amp;#xD;&#xD;&#xA;                   &amp;lt;/commonInfo&amp;gt;&amp;#xD;&#xD;&#xA;                   &amp;lt;sharePointInfo&amp;gt;&amp;#xD;&#xD;&#xA;                    &amp;lt;SQLUserAccount&amp;gt;&amp;#xD;&#xD;&#xA;                        &amp;lt;userName&amp;gt;xpath:{/workflow/inputs/SharePointAdminName}&amp;lt;/userName&amp;gt;&amp;#xD;&#xD;&#xA;                        &amp;lt;password&amp;gt;xpath:{/workflow/inputs/SharePointAdminPassword}&amp;lt;/password&amp;gt;&amp;#xD;&#xD;&#xA;                        &amp;lt;domainName&amp;gt;&amp;lt;/domainName&amp;gt;&amp;#xD;&#xD;&#xA;                    &amp;lt;/SQLUserAccount&amp;gt;&amp;#xD;&#xD;&#xA;                   &amp;lt;/sharePointInfo&amp;gt;&amp;#xD;&#xD;&#xA;                   &amp;lt;sqlAgent&amp;gt;&amp;#xD;&#xD;&#xA;                     &amp;lt;userAccount&amp;gt;&amp;#xD;&#xD;&#xA;                       &amp;lt;userName&amp;gt;xpath:{/workflow/inputs/SQLUserName}&amp;lt;/userName&amp;gt;&amp;#xD;&#xD;&#xA;                       &amp;lt;password&amp;gt;xpath:{/workflow/inputs/SQLPassword}&amp;lt;/password&amp;gt;&amp;#xD;&#xD;&#xA;                       &amp;lt;domainName&amp;gt;&amp;lt;/domainName&amp;gt;&amp;#xD;&#xD;&#xA;                     &amp;lt;/userAccount&amp;gt;&amp;#xD;&#xD;&#xA;                   &amp;lt;/sqlAgent&amp;gt;&amp;#xD;&#xD;&#xA;                 &amp;lt;/components&amp;gt;&amp;#xD;&#xD;&#xA;                 &amp;lt;packageDeliveryOption&amp;gt;CopyPackage&amp;lt;/packageDeliveryOption&amp;gt;&amp;#xD;&#xD;&#xA;                 &amp;lt;clientRoles&amp;gt;&amp;#xD;&#xD;&#xA;                   &amp;lt;bLaptopBackup&amp;gt;false&amp;lt;/bLaptopBackup&amp;gt;&amp;#xD;&#xD;&#xA;                   &amp;lt;bNetworkProxy&amp;gt;false&amp;lt;/bNetworkProxy&amp;gt;&amp;#xD;&#xD;&#xA;                 &amp;lt;/clientRoles&amp;gt;&amp;#xD;&#xD;&#xA;               &amp;lt;/clientComposition&amp;gt;&amp;#xD;&#xD;&#xA;               &amp;lt;installFlags&amp;gt;&amp;#xD;&#xD;&#xA;                 &amp;lt;install32Base&amp;gt;false&amp;lt;/install32Base&amp;gt;&amp;#xD;&#xD;&#xA;                 &amp;lt;allowMultipleInstances&amp;gt;false&amp;lt;/allowMultipleInstances&amp;gt;&amp;#xD;&#xD;&#xA;                 &amp;lt;disableOSFirewall&amp;gt;false&amp;lt;/disableOSFirewall&amp;gt;&amp;#xD;&#xD;&#xA;                 &amp;lt;forceReboot&amp;gt;false&amp;lt;/forceReboot&amp;gt;&amp;#xD;&#xD;&#xA;                 &amp;lt;stopOracleServices&amp;gt;false&amp;lt;/stopOracleServices&amp;gt;&amp;#xD;&#xD;&#xA;                 &amp;lt;skipClientsOfCS&amp;gt;false&amp;lt;/skipClientsOfCS&amp;gt;&amp;#xD;&#xD;&#xA;                 &amp;lt;advancedOptions&amp;gt;&amp;lt;/advancedOptions&amp;gt;&amp;#xD;&#xD;&#xA;                 &amp;lt;restoreOnlyAgents&amp;gt;false&amp;lt;/restoreOnlyAgents&amp;gt;&amp;#xD;&#xD;&#xA;                 &amp;lt;overrideClientInfo&amp;gt;true&amp;lt;/overrideClientInfo&amp;gt;&amp;#xD;&#xD;&#xA;                 &amp;lt;skipConfigureLaptopBackupMonitor&amp;gt;false&amp;lt;/skipConfigureLaptopBackupMonitor&amp;gt;&amp;#xD;&#xD;&#xA;                 &amp;lt;skipConfigureProcessManager&amp;gt;false&amp;lt;/skipConfigureProcessManager&amp;gt;&amp;#xD;&#xD;&#xA;                 &amp;lt;skipConfigureMigrationAssistant&amp;gt;false&amp;lt;/skipConfigureMigrationAssistant&amp;gt;&amp;#xD;&#xD;&#xA;                 &amp;lt;autoInstallPassiveNodes&amp;gt;false&amp;lt;/autoInstallPassiveNodes&amp;gt;&amp;#xD;&#xD;&#xA;                 &amp;lt;autoRebootPassiveNodes&amp;gt;false&amp;lt;/autoRebootPassiveNodes&amp;gt;&amp;#xD;&#xD;&#xA;                 &amp;lt;patchStandbyCS&amp;gt;false&amp;lt;/patchStandbyCS&amp;gt;&amp;#xD;&#xD;&#xA;                 &amp;lt;hideApps&amp;gt;false&amp;lt;/hideApps&amp;gt;&amp;#xD;&#xD;&#xA;               &amp;lt;/installFlags&amp;gt;&amp;#xD;&#xD;&#xA;             &amp;lt;/installerOption&amp;gt;&amp;#xD;&#xD;&#xA;             &amp;lt;clientAuthForJob&amp;gt;&amp;#xD;&#xD;&#xA;               &amp;lt;userName&amp;gt;xpath:{/workflow/variables/usernameForInstallAgentJob}&amp;lt;/userName&amp;gt;&amp;#xD;&#xD;&#xA;               &amp;lt;password&amp;gt;xpath:{/workflow/variables/passwordForInstallAgentJob}&amp;lt;/password&amp;gt;&amp;#xD;&#xD;&#xA;             &amp;lt;/clientAuthForJob&amp;gt;&amp;#xD;&#xD;&#xA;           &amp;lt;/clientInstallOption&amp;gt;&amp;#xD;&#xD;&#xA;         &amp;lt;/adminOpts&amp;gt;&amp;#xD;&#xD;&#xA;       &amp;lt;/options&amp;gt;&amp;#xD;&#xD;&#xA;       &amp;lt;subTaskOperation&amp;gt;OVERWRITE&amp;lt;/subTaskOperation&amp;gt;&amp;#xD;&#xD;&#xA;     &amp;lt;/subTasks&amp;gt;&amp;#xD;&#xD;&#xA;   &amp;lt;/taskInfo&amp;gt;&amp;#xD;&#xD;&#xA; &amp;lt;/TMMsg_CreateTaskReq&amp;gt;&amp;#xD;&#xD;&#xA; &lt;/inputXml&gt;&lt;escapeXml class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/escapeXml&gt;&lt;commandArgs class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;&gt;&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/useImpersonatedAccount&gt;&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/sessionOptions&gt;&lt;/inputs&gt;" />

            <transition activity="XPathQuery_3" commented="0" originalStyle="" points="120.0,210.0" sourceX="155" sourceY="125" status="0" style="defaultEdge" targetX="155" targetY="191" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;xpath:{/workflow/Execute_3/exitCode} == 0" />

            </transition>

            <transition activity="WorkflowEnd_5" commented="0" originalStyle="" points="250.0,190.0" sourceX="101" sourceY="126" status="0" style="defaultEdge" targetX="252" targetY="128" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;xpath:{/workflow/Execute_3/exitCode} != 0" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1550755548102" description="retrieves a list of values from xml" displayName="Get job ID from output" height="34" interactive="0" jobMode="0" name="XPathQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.XMLQueryActivity" uniqueName="XPathQuery_3" waitSetting="0" width="200" x="27" y="247">

            <inputs val="&lt;inputs&gt;&lt;xml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/Execute_3/outputXml}&lt;/xml&gt;&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;/TMMsg_CreateTaskResp/jobIds/@val&lt;/xpath&gt;&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;&gt;Integer&lt;/outputType&gt;&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/outputAsList&gt;&lt;/inputs&gt;" />

            <transition activity="AddToList_2" commented="0" originalStyle="" points="120.0,300.0" sourceX="113" sourceY="205" status="0" style="defaultEdge" targetX="103" targetY="287" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1550755622112" description="Ends the workflow" displayName="Failed" height="34" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.EndActivity" uniqueName="WorkflowEnd_5" waitSetting="0" width="200" x="303" y="171">

            <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;&gt;FAILED&lt;/completionStatus&gt;&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/variables/failureMessage}&lt;/failureMessage&gt;&lt;/inputs&gt;" />

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1550828647877" description="utility to add objects to a list" displayName="Add job to list" height="34" interactive="0" jobMode="0" name="AddToList" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.ListActivityAdd" uniqueName="AddToList_2" waitSetting="0" width="200" x="26" y="319">

            <onExit language="1" script="if(xpath:{/workflow/AddToList_2/added} == false)&#xD;&#xA;    workflow.setVariable(&quot;failureMessage&quot;,&quot;Failed to add install job ID to list.&quot;);&#xD;&#xA;else&#xD;&#xA;{&#xD;&#xA;    logger.path(xpath:{/workflow/variables/workflowLoggerPath}).info(&quot;Started job [&quot; + xpath:{/workflow/XPathQuery_3/result} + &quot;] to install packages from XML [&quot; + xpath:{/workflow/ProcessBlock_1/installPackageXML} + &quot;] on host :&quot; + xpath:{/workflow/ForEach_3/clientHostnames});&#xD;&#xA;}" />

            <inputs val="&lt;inputs&gt;&lt;addToList class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/variables/installJobList}&lt;/addToList&gt;&lt;itemToAdd class=&quot;java.lang.Object&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/XPathQuery_3/result}&lt;/itemToAdd&gt;&lt;/inputs&gt;" />

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1552310613840" description="utility to add objects to a list" displayName="Add Client to list" height="34" interactive="0" jobMode="0" name="AddToList" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.ListActivityAdd" uniqueName="AddToList_3" waitSetting="0" width="200" x="19" y="99">

            <inputs val="&lt;inputs&gt;&lt;addToList class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/variables/clientHostNames}&lt;/addToList&gt;&lt;itemToAdd class=&quot;java.lang.Object&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/ProcessBlock_1/clientHostnames}&lt;/itemToAdd&gt;&lt;/inputs&gt;" />

            <transition activity="Execute_3" commented="0" originalStyle="" points="120.0,150.0" sourceX="120" sourceY="108" status="0" style="defaultEdge" targetX="120" targetY="159" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Activity>

        </superProcess>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1551269087971" description="waits until the list of jobs completes" displayName="WaitForJobCompletion" height="34" interactive="0" jobMode="0" name="WaitForJobCompletion" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.WaitForJobCompletion" uniqueName="WaitForJobCompletion_4" waitSetting="0" width="200" x="612" y="286">

        <onExit language="1" script="if (xpath:{/workflow/WaitForJobCompletion_4/successful} == false)&#xD;&#xA;{&#xD;&#xA;    logger.path(xpath:{/workflow/variables/workflowLoggerPath}).info(&quot;Failed to push install agent. Failed Jobs: &quot; + xpath:{/workflow/WaitForJobCompletion_4/failedJobs} + &quot;.&quot;);&#xD;&#xA;    workflow.setVariable(&quot;failureMessage&quot;,&quot;Failed to push install agent. Failed Jobs: &quot; + xpath:{/workflow/WaitForJobCompletion_4/failedJobs} + &quot;. Try resubmitting the job and make sure SharePoint admin credentials provided are correct.&quot;);&#xD;&#xA;}&#xD;&#xA;else if (xpath:{/workflow/WaitForJobCompletion_4/exitCode} != 0)&#xD;&#xA;{&#xD;&#xA;     logger.path(xpath:{/workflow/variables/workflowLoggerPath}).info(&quot;Failed while waiting for push install jobs to complete.&quot;);&#xD;&#xA;    workflow.setVariable(&quot;failureMessage&quot;,&quot;Failed while waiting for push install jobs to complete. Try resubmitting the auto configuration job.&quot;);&#xD;&#xA;}&#xD;&#xA;    " />

        <inputs val="&lt;inputs&gt;&lt;jobId class=&quot;java.lang.Integer&quot; _list_=&quot;true&quot;&gt;xpath:{/workflow/variables/installJobList}&lt;/jobId&gt;&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;&gt;&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/useImpersonatedAccount&gt;&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/sessionOptions&gt;&lt;/inputs&gt;" />

        <transition activity="WorkflowEnd_6" commented="0" originalStyle="" points="" sourceX="570" sourceY="270" status="0" style="defaultEdge" targetX="572" targetY="356" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;xpath:{/workflow/WaitForJobCompletion_4/successful} == false || xpath:{/workflow/WaitForJobCompletion_4/exitCode} != 0" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1551271713725" description="Ends the workflow" displayName="Failed" height="34" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.EndActivity" uniqueName="WorkflowEnd_6" waitSetting="0" width="200" x="612" y="397">

        <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;&gt;FAILED&lt;/completionStatus&gt;&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/variables/failureMessage}&lt;/failureMessage&gt;&lt;/inputs&gt;" />

      </Activity>

    </superProcess>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1551271281261" description="executes a defined process block within the workflow" displayName="Push Install SharePoint" height="40" interactive="0" jobMode="0" name="ExecuteProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.ExecuteSuperProcess" uniqueName="ExecuteProcessBlock_1" waitSetting="0" width="200" x="60" y="320">

    <activitySchema>

      <inputs className="" defaultValue="" listType="0" name="inputs" type="">

        <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="1" name="clientHostnames" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

        <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="installPackageXML" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

      </inputs>

      <outputs name="ProcessBlock_1">

        <children name="Start_6" />

        <children name="WaitForJobCompletion_4">

          <children className="java.lang.Integer" inputType="java.lang.Integer" listType="1" name="successfullJobs" type="{http://www.w3.org/2001/XMLSchema}integer" />

          <children className="java.lang.Integer" inputType="java.lang.Integer" listType="1" name="failedJobs" type="{http://www.w3.org/2001/XMLSchema}integer" />

          <children className="java.lang.Boolean" inputType="java.lang.Boolean" name="successful" type="{http://www.w3.org/2001/XMLSchema}boolean" />

          <children className="java.lang.Integer" documentation="return code from the executable" inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

          <children className="java.lang.String" documentation="command output" inputType="java.lang.String" name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string" />

        </children>

        <children name="WorkflowEnd_6" />

      </outputs>

    </activitySchema>

    <onEnter language="1" script="/*Set credentials to SharePoint timer account for push install*/&#xD;&#xA; workflow.setVariable(&quot;usernameForInstallAgentJob&quot;, xpath:{/workflow/inputs/SharePointAdminName});&#xD;&#xA; workflow.setVariable(&quot;passwordForInstallAgentJob&quot;, xpath:{/workflow/inputs/SharePointAdminPassword});" />

    <inputs val="&lt;inputs&gt;&lt;inputs&gt;&lt;clientHostnames class=&quot;java.lang.String&quot; _list_=&quot;true&quot;&gt;xpath:{/workflow/SQLQuery_1/resultSets[1]/row}&lt;/clientHostnames&gt;&lt;installPackageXML class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;&amp;lt;componentInfo&amp;gt;&amp;lt;ComponentName&amp;gt;SharePoint iDataAgent&amp;lt;/ComponentName&amp;gt;&amp;lt;osType&amp;gt;Windows&amp;lt;/osType&amp;gt;&amp;lt;consumeLicense&amp;gt;true&amp;lt;/consumeLicense&amp;gt;&amp;lt;clientSidePackage&amp;gt;true&amp;lt;/clientSidePackage&amp;gt;&amp;lt;/componentInfo&amp;gt;&lt;/installPackageXML&gt;&lt;/inputs&gt;&lt;processBlock&gt;ProcessBlock_1&lt;/processBlock&gt;&lt;outputs /&gt;&lt;/inputs&gt;" />

    <transition activity="ExecuteProcessBlock_2" commented="0" originalStyle="" points="" sourceX="477" sourceY="209" status="0" style="defaultEdge" targetX="738" targetY="208" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;xpath:{/workflow/ExecuteProcessBlock_1/WaitForJobCompletion_4/exitCode} == 0 &amp;&amp; xpath:{/workflow/ExecuteProcessBlock_1/WaitForJobCompletion_4/successful} == true" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1551799882457" description="executes a defined process block within the workflow" displayName="Push Install SQL and Media Agent" height="40" interactive="0" jobMode="0" name="ExecuteProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.ExecuteSuperProcess" uniqueName="ExecuteProcessBlock_2" waitSetting="0" width="200" x="60" y="410">

    <activitySchema>

      <inputs className="" defaultValue="" listType="0" name="inputs" type="">

        <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="1" name="clientHostnames" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

        <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="installPackageXML" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

      </inputs>

      <outputs name="ProcessBlock_1">

        <children name="Start_6" />

        <children name="WaitForJobCompletion_4">

          <children className="java.lang.Integer" inputType="java.lang.Integer" listType="1" name="successfullJobs" type="{http://www.w3.org/2001/XMLSchema}integer" />

          <children className="java.lang.Integer" inputType="java.lang.Integer" listType="1" name="failedJobs" type="{http://www.w3.org/2001/XMLSchema}integer" />

          <children className="java.lang.Boolean" inputType="java.lang.Boolean" name="successful" type="{http://www.w3.org/2001/XMLSchema}boolean" />

          <children className="java.lang.Integer" documentation="return code from the executable" inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

          <children className="java.lang.String" documentation="command output" inputType="java.lang.String" name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string" />

        </children>

        <children name="WorkflowEnd_6" />

      </outputs>

    </activitySchema>

    <onEnter language="1" script="/*Set credentials to SQL authentication for push install*/&#xD;&#xA; workflow.setVariable(&quot;usernameForInstallAgentJob&quot;, xpath:{/workflow/inputs/SQLUserName});&#xD;&#xA; workflow.setVariable(&quot;passwordForInstallAgentJob&quot;, xpath:{/workflow/inputs/SQLPassword});" />

    <inputs val="&lt;inputs&gt;&lt;inputs&gt;&lt;clientHostnames class=&quot;java.lang.String&quot; _list_=&quot;true&quot;&gt;xpath:{/workflow/inputs/SQLServerName}&lt;/clientHostnames&gt;&lt;installPackageXML class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt; &amp;lt;componentInfo&amp;gt;&amp;lt;ComponentName&amp;gt;MediaAgent&amp;lt;/ComponentName&amp;gt;&amp;lt;osType&amp;gt;Windows&amp;lt;/osType&amp;gt;&amp;lt;consumeLicense&amp;gt;true&amp;lt;/consumeLicense&amp;gt;&amp;lt;clientSidePackage&amp;gt;true&amp;lt;/clientSidePackage&amp;gt;&amp;lt;/componentInfo&amp;gt;&amp;lt;componentInfo&amp;gt;&amp;lt;ComponentName&amp;gt;VSS Provider&amp;lt;/ComponentName&amp;gt;&amp;lt;osType&amp;gt;Windows&amp;lt;/osType&amp;gt;&amp;lt;consumeLicense&amp;gt;true&amp;lt;/consumeLicense&amp;gt;&amp;lt;clientSidePackage&amp;gt;true&amp;lt;/clientSidePackage&amp;gt;&amp;lt;/componentInfo&amp;gt;&amp;lt;componentInfo&amp;gt;&amp;lt;ComponentName&amp;gt;iDA for MSSQL Server&amp;lt;/ComponentName&amp;gt;&amp;lt;osType&amp;gt;Windows&amp;lt;/osType&amp;gt;&amp;lt;consumeLicense&amp;gt;true&amp;lt;/consumeLicense&amp;gt;&amp;lt;clientSidePackage&amp;gt;true&amp;lt;/clientSidePackage&amp;gt;&amp;lt;/componentInfo&amp;gt;&lt;/installPackageXML&gt;&lt;/inputs&gt;&lt;processBlock&gt;ProcessBlock_1&lt;/processBlock&gt;&lt;outputs /&gt;&lt;/inputs&gt;" />

    <transition activity="CommServDBQuery_2" commented="0" originalStyle="" points="" sourceX="719" sourceY="209" status="0" style="defaultEdge" targetX="947" targetY="216" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;//xpath:{/workflow/ExecuteProcessBlock_1/WaitForJobCompletion_4/exitCode} == 0 &amp;&amp; xpath:{/workflow/ExecuteProcessBlock_1/WaitForJobCompletion_4/successful} == true" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1552388844967" description="performs http operations" displayName="Create Pseudo Client" height="50" interactive="0" jobMode="0" name="HttpClient" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.HttpClientActivity" timeout="300" uniqueName="HttpClient_1" waitSetting="0" width="230" x="50" y="860">

    <onEnter language="1" script=" logger.path(xpath:{/workflow/variables/workflowLoggerPath}).info(&quot;Creating Psudeo client with XML: &quot; + xpath:{/workflow/CommServDBQuery_2/resultSets[2]/row[1]/col[''createPseudoClientXML'']});  " />

    <onExit language="1" script=" if(xpath:{/workflow/HttpClient_1/statusCode} != 200)&#xD;&#xA; {&#xD;&#xA;    workflow.setVariable(&quot;failureMessage&quot;,&quot;Failed to send request to create SharePoint farm pseudo client&quot;);&#xD;&#xA;    logger.path(xpath:{/workflow/variables/workflowLoggerPath}).info(&quot;Failed to send request to create Pseudo client. Status code returned [&quot; + xpath:{/workflow/HttpClient_1/statusCode} + &quot;] Response: [&quot; + xpath:{/workflow/HttpClient_1/output} +&quot;]&quot;);  &#xD;&#xA; }&#xD;&#xA; else&#xD;&#xA; {&#xD;&#xA;     logger.path(xpath:{/workflow/variables/workflowLoggerPath}).info(&quot;Response from Rest API: &quot; + xpath:{/workflow/HttpClient_1/output});&#xD;&#xA; }  &#xD;&#xA;&#xD;&#xA;" />

    <inputs val="&lt;inputs&gt;&lt;request&gt;&lt;url&gt;/SearchSvc/CVWebService.svc/Client&lt;/url&gt;&lt;method&gt;POST&lt;/method&gt;&lt;postType&gt;Raw&lt;/postType&gt;&lt;postContent&gt;xpath:{/workflow/CommServDBQuery_2/resultSets[2]/row[1]/col[''createPseudoClientXML'']}&lt;/postContent&gt;&lt;postContentType&gt;application/xml; charset=UTF-8&lt;/postContentType&gt;&lt;headers&gt;&lt;name&gt;Authtoken&lt;/name&gt;&lt;value&gt;QSDKONLY xpath:{/workflow/system/token}&lt;/value&gt;&lt;/headers&gt;&lt;headers&gt;&lt;name&gt;Accept&lt;/name&gt;&lt;value&gt;application/xml&lt;/value&gt;&lt;/headers&gt;&lt;/request&gt;&lt;/inputs&gt;" />

    <transition activity="WorkflowEnd_4" commented="0" originalStyle="" points="430.0,850.0" sourceX="1206" sourceY="209" status="0" style="defaultEdge" targetX="1191" targetY="327" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;xpath:{/workflow/HttpClient_1/statusCode} != 200 " />

    </transition>

    <transition activity="XPathQuery_4" commented="0" originalStyle="" points="500.0,900.0" sourceX="1206" sourceY="209" status="0" style="defaultEdge" targetX="1248" targetY="388" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;xpath:{/workflow/HttpClient_1/statusCode} == 200" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1552545899265" description="retrieves a list of values from xml" displayName="Get client ID from response" height="50" interactive="0" jobMode="0" name="XPathQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.XMLQueryActivity" uniqueName="XPathQuery_4" waitSetting="0" width="200" x="770" y="860">

    <onExit language="1" script="if(xpath:{/workflow/XPathQuery_4/result} == 0 || xpath:{/workflow/XPathQuery_4/result} == null)&#xD;&#xA;{&#xD;&#xA;    workflow.setVariable(&quot;failureMessage&quot;,&quot;Failed to create SharePoint farm Pseudo client&quot;);&#xD;&#xA;}&#xD;&#xA;else&#xD;&#xA;{&#xD;&#xA;    workflow.setVariable(&quot;sharePointFarmPseudoClientId&quot;, xpath:{/workflow/XPathQuery_4/result});&#xD;&#xA;}" />

    <inputs val="&lt;inputs&gt;&lt;xml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/HttpClient_1/output}&lt;/xml&gt;&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;App_CreatePseudoClientResponse/response/entity/@clientId&lt;/xpath&gt;&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;&gt;String&lt;/outputType&gt;&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/outputAsList&gt;&lt;/inputs&gt;" />

    <transition activity="WorkflowEnd_4" commented="0" originalStyle="" points="550.0,850.0" sourceX="1254" sourceY="388" status="0" style="defaultEdge" targetX="947" targetY="328" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;xpath:{/workflow/XPathQuery_4/result} == 0 || xpath:{/workflow/XPathQuery_4/result} == null" />

    </transition>

    <transition activity="HttpClient_3" commented="0" originalStyle="" points="880.0,820.0" sourceX="160" sourceY="740" status="0" style="defaultEdge" targetX="150" targetY="830" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;xpath:{/workflow/XPathQuery_4/result} != 0 &amp;&amp; xpath:{/workflow/XPathQuery_4/result} != null&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1552546920066" description="executes queries against a commcell database" displayName="Generate XML for subclient" height="40" interactive="0" jobMode="0" maxRestarts="1" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_3" waitSetting="0" width="200" x="770" y="580">

    <onExit language="1" script="if(xpath:{/workflow/CommServDBQuery_3/resultSets[2]/row[1]/col[&quot;numInstances&quot;]} == null || xpath:{/workflow/CommServDBQuery_3/resultSets[2]/row[1]/col[&quot;numInstances&quot;]} == 0)&#xD;&#xA;{&#xD;&#xA;    workflow.setVariable(&quot;failureMessage&quot;,&quot;Failed to determine SQL instance.&quot;);&#xD;&#xA;    logger.path(xpath:{/workflow/variables/workflowLoggerPath}).info(&quot;Failed to determine SQL instance.&quot;); &#xD;&#xA;}&#xD;&#xA;else&#xD;&#xA;{&#xD;&#xA;   logger.path(xpath:{/workflow/variables/workflowLoggerPath}).info(&quot;Detected [&quot; + xpath:{/workflow/CommServDBQuery_3/resultSets[2]/row[1]/col[&quot;numInstances&quot;]} + &quot;] instance in SQL client&quot;); &#xD;&#xA;   if(xpath:{/workflow/CommServDBQuery_3/resultSets[2]/row[1]/col[&quot;numInstances&quot;]} &gt; 1)&#xD;&#xA;   {&#xD;&#xA;        workflow.setVariable(&quot;multipleSQLInstanceDetected&quot;,true);&#xD;&#xA;        workflow.setVariable(&quot;shouldConfigureSQLSubclient&quot;,false);&#xD;&#xA;   }&#xD;&#xA;}&#xD;&#xA;" />

    <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;IF object_id(''tempdb.dbo.#SQLServerSubclientDetail'') IS NOT NULL DROP TABLE #SQLServerSubclientDetail&amp;#xD;&#xD;&#xA;DECLARE @sharePointPseudoClientPrimaryNodeClientId INT = ?&amp;#xD;&#xD;&#xA;DECLARE @contentPathXML XML&amp;#xD;&#xD;&#xA;DECLARE @storagePolicyName VARCHAR(MAX) = ?&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;CREATE TABLE #SQLServerSubclientDetail(clientId INT, clientName VARCHAR(MAX), instanceId INT, instanceName VARCHAR(MAX), backupsetId INT, backupsetName VARCHAR(max), subclientId INT)&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;SET @contentPathXML = (SELECT&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;1000 AS ''@objectType'',&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;''\MB\'' + CAST(@sharePointPseudoClientPrimaryNodeClientId AS varchar(max)) + ''\Farm'' AS ''@contentPath'',&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;''Farm'' AS ''relativePath'',&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;(&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;SELECT&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;@sharePointPseudoClientPrimaryNodeClientId AS ''@clientId'',&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;name AS ''@clientName'',&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;GUID AS ''@clientGUID''&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;FROM App_Client WHERE id = @sharePointPseudoClientPrimaryNodeClientId&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;FOR XML PATH(''localClient''), TYPE&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;)&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;FOR XML PATH(''EVGui_SharePointItem''), TYPE)&amp;#xD;&#xD;&#xA;SELECT&amp;#xD;&#xD;&#xA;(&amp;#xD;&#xD;&#xA;    SELECT&amp;#xD;&#xD;&#xA;        2 AS ''@contentOperationType'',&amp;#xD;&#xD;&#xA;        (&amp;#xD;&#xD;&#xA;            SELECT  DISTINCT&amp;#xD;&#xD;&#xA;                    AC.id AS ''@clientId'', &amp;#xD;&#xD;&#xA;                    AC.name AS ''@clientName'',&amp;#xD;&#xD;&#xA;                    AC.name AS ''@displayName'',&amp;#xD;&#xD;&#xA;                    78 AS ''@applicationId'',&amp;#xD;&#xD;&#xA;                    ''Sharepoint Server'' AS ''@appName'',&amp;#xD;&#xD;&#xA;                    I.id AS ''@instanceId'',&amp;#xD;&#xD;&#xA;                    I.name AS ''@instanceName'', &amp;#xD;&#xD;&#xA;                    BS.id AS ''@backupsetId'',&amp;#xD;&#xD;&#xA;                    BS.Name AS ''@backupsetName'',&amp;#xD;&#xD;&#xA;                    ''Auto Configured Subclient'' AS ''@subclientName''&amp;#xD;&#xD;&#xA;            FROM APP_BackupSetName BS WITH(NOLOCK) JOIN App_Application SC WITH(NOLOCK) on BS.id = SC.backupSet JOIN APP_Client AC WITH(NOLOCK) ON AC.id = sc.clientId &amp;#xD;&#xD;&#xA;            JOIN App_InstanceName I WITH(NOLOCK) ON I.id = SC.instance WHERE AC.id = ? AND SC.appTypeId = 78 AND BS.name = ''Databases''&amp;#xD;&#xD;&#xA;            FOR XML PATH(''subClientEntity''), TYPE&amp;#xD;&#xD;&#xA;        ),&amp;#xD;&#xD;&#xA;        (&amp;#xD;&#xD;&#xA;            SELECT&amp;#xD;&#xD;&#xA;            (&amp;#xD;&#xD;&#xA;                SELECT&amp;#xD;&#xD;&#xA;                        (&amp;#xD;&#xD;&#xA;                            SELECT @storagePolicyName AS ''@storagePolicyName''&amp;#xD;&#xD;&#xA;                            FOR XML PATH(''dataBackupStoragePolicy''), TYPE&amp;#xD;&#xD;&#xA;                        )&amp;#xD;&#xD;&#xA;                FOR XML PATH(''storageDevice''), TYPE&amp;#xD;&#xD;&#xA;            )&amp;#xD;&#xD;&#xA;            FOR XML PATH (''commonProperties''), TYPE&amp;#xD;&#xD;&#xA;        ),&amp;#xD;&#xD;&#xA;        (&amp;#xD;&#xD;&#xA;            SELECT &amp;#xD;&#xD;&#xA;                    (&amp;#xD;&#xD;&#xA;                        SELECT &amp;#xD;&#xD;&#xA;                                CAST(@contentPathXML AS varchar(max)) AS ''@ContentPath''&amp;#xD;&#xD;&#xA;                        FOR XML PATH(''sharepointContents''), TYPE&amp;#xD;&#xD;&#xA;                    )&amp;#xD;&#xD;&#xA;            FOR XML PATH (''content''), TYPE&amp;#xD;&#xD;&#xA;        )&amp;#xD;&#xD;&#xA;    FOR XML PATH(''subClientProperties''), ROOT(''App_CreateSubClientRequest'')&amp;#xD;&#xD;&#xA;) AS createSharePointSubclientXML&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;-- XML to configure SQL subclient&amp;#xD;&#xD;&#xA;INSERT INTO #SQLServerSubclientDetail&amp;#xD;&#xD;&#xA;SELECT AC.id, AC.name, I.id, I.name, BS.id, BS.name, SC.id&amp;#xD;&#xD;&#xA;FROM APP_BackupSetName BS WITH(NOLOCK) JOIN App_Application SC WITH(NOLOCK) on BS.id = SC.backupSet JOIN APP_Client AC WITH(NOLOCK) ON AC.id = sc.clientId &amp;#xD;&#xD;&#xA;JOIN App_InstanceName I WITH(NOLOCK) ON I.id = SC.instance WHERE AC.net_hostname = ? AND SC.appTypeId = 81 AND SC.subclientName = ''default''&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;-- Get number of instances present under SQL node&amp;#xD;&#xD;&#xA;SELECT COUNT(*) AS ''numInstances'' FROM #SQLServerSubclientDetail  &amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;SELECT&amp;#xD;&#xD;&#xA;(&amp;#xD;&#xD;&#xA;    SELECT&amp;#xD;&#xD;&#xA;            (&amp;#xD;&#xD;&#xA;                SELECT&amp;#xD;&#xD;&#xA;                        (&amp;#xD;&#xD;&#xA;                            SELECT&amp;#xD;&#xD;&#xA;                                    (&amp;#xD;&#xD;&#xA;                                        SELECT &amp;#xD;&#xD;&#xA;                                                (&amp;#xD;&#xD;&#xA;                                                    SELECT @storagePolicyName AS ''storagePolicyName''&amp;#xD;&#xD;&#xA;                                                    FOR XML PATH(''dataBackupStoragePolicy''), TYPE&amp;#xD;&#xD;&#xA;                                                ),&amp;#xD;&#xD;&#xA;                                                (&amp;#xD;&#xD;&#xA;                                                    SELECT @storagePolicyName AS ''storagePolicyName''&amp;#xD;&#xD;&#xA;                                                    FOR XML PATH(''logBackupStoragePolicy''), TYPE&amp;#xD;&#xD;&#xA;                                                )&amp;#xD;&#xD;&#xA;                                        FOR XML PATH(''storageDevice''), TYPE&amp;#xD;&#xD;&#xA;                                    )&amp;#xD;&#xD;&#xA;                            FOR XML PATH(''commonProperties''), TYPE&amp;#xD;&#xD;&#xA;                        ),&amp;#xD;&#xD;&#xA;                        (&amp;#xD;&#xD;&#xA;                            SELECT 1 AS ''@useBlockLevelBackupWithOptimizedRecovery''&amp;#xD;&#xD;&#xA;                            FOR XML PATH(''mssqlSubClientProp''), TYPE&amp;#xD;&#xD;&#xA;                        )&amp;#xD;&#xD;&#xA;                FOR XML PATH(''subClientProperties''), TYPE&amp;#xD;&#xD;&#xA;            ),&amp;#xD;&#xD;&#xA;            (&amp;#xD;&#xD;&#xA;                SELECT&amp;#xD;&#xD;&#xA;                        (&amp;#xD;&#xD;&#xA;                            SELECT &amp;#xD;&#xD;&#xA;                                    clientId AS ''@clientId'',&amp;#xD;&#xD;&#xA;                                    clientName AS ''@clientName'',&amp;#xD;&#xD;&#xA;                                    instanceId AS ''@instanceId'',&amp;#xD;&#xD;&#xA;                                    instanceName AS ''@instanceName'',&amp;#xD;&#xD;&#xA;                                    backupsetId AS ''@backupsetId'',&amp;#xD;&#xD;&#xA;                                    backupsetName AS ''@backupsetName'',&amp;#xD;&#xD;&#xA;                                    ''SQL Server'' AS ''@appName'',&amp;#xD;&#xD;&#xA;                                    81 AS ''@applicationId'',&amp;#xD;&#xD;&#xA;                                    subclientId AS ''@subclientId'',&amp;#xD;&#xD;&#xA;                                    ''default'' AS ''@subclientName''&amp;#xD;&#xD;&#xA;                            FROM #SQLServerSubclientDetail&amp;#xD;&#xD;&#xA;                            FOR XML PATH(''entity''), TYPE&amp;#xD;&#xD;&#xA;                        )&amp;#xD;&#xD;&#xA;                FOR XML PATH(''association''), TYPE&amp;#xD;&#xD;&#xA;            )&amp;#xD;&#xD;&#xA;    FOR XML PATH(''''), ROOT(''App_UpdateSubClientPropertiesRequest'')&amp;#xD;&#xD;&#xA;) AS SqlSubclientUpdateXML&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;SELECT  clientName, instanceName, backupsetName FROM #SQLServerSubclientDetail -- Get SQL subclient details &amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;IF object_id(''tempdb.dbo.#SQLServerSubclientDetail'') IS NOT NULL DROP TABLE #SQLServerSubclientDetail&amp;#xD;&#xD;&#xA;&lt;/query&gt;&lt;parameters&gt;&lt;value&gt;xpath:{/workflow/variables/sharePointPseudoClientPrimaryNodeClientId}&lt;/value&gt;&lt;type&gt;OBJECT&lt;/type&gt;&lt;/parameters&gt;&lt;parameters&gt;&lt;value&gt;xpath:{/workflow/inputs/StoragePolicy/storagePolicyName}&lt;/value&gt;&lt;type&gt;OBJECT&lt;/type&gt;&lt;/parameters&gt;&lt;parameters&gt;&lt;value&gt;xpath:{/workflow/variables/sharePointFarmPseudoClientId}&lt;/value&gt;&lt;type&gt;OBJECT&lt;/type&gt;&lt;/parameters&gt;&lt;parameters&gt;&lt;value&gt;xpath:{/workflow/inputs/SQLServerName}&lt;/value&gt;&lt;type&gt;OBJECT&lt;/type&gt;&lt;/parameters&gt;&lt;/inputs&gt;" />

    <transition activity="ExecuteProcessBlock_4" commented="0" originalStyle="" points="" sourceX="880" sourceY="600" status="0" style="defaultEdge" targetX="870" targetY="440" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;xpath:{/workflow/CommServDBQuery_3/errorCode} == 0 &amp;&amp; xpath:{/workflow/CommServDBQuery_3/resultSets[2]/row[1]/col[&quot;numInstances&quot;]} != null &amp;&amp; xpath:{/workflow/CommServDBQuery_3/resultSets[2]/row[1]/col[&quot;numInstances&quot;]} != 0" />

    </transition>

    <transition activity="WorkflowEnd_17" commented="0" originalStyle="" points="680.0,610.0" sourceX="880" sourceY="600" status="0" style="defaultEdge" targetX="600" targetY="500" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;xpath:{/workflow/CommServDBQuery_3/errorCode} != 0 || xpath:{/workflow/CommServDBQuery_3/resultSets[2]/row[1]/col[&quot;numInstances&quot;]} == null || xpath:{/workflow/CommServDBQuery_3/resultSets[2]/row[1]/col[&quot;numInstances&quot;]} == 0" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="1" created="1553247747288" description="" displayName="Check Readiness of SP Nodes" height="50" interactive="0" jobMode="0" name="CheckReady" namespaceUri="commvault.cte.workflow.activities.cmd.operation" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.cmd.operation.OperationCheckReady" uniqueName="CheckReady_4" waitSetting="0" width="200" x="772" y="130">

    <onEnter language="1" script="logger.path(xpath:{/workflow/variables/workflowLoggerPath}).info(&quot;Started check readiness for pseudo client [&quot; + xpath:{/workflow/inputs/PseudoClientName} + &quot;)&quot;);  " />

    <onExit language="1" script="if(xpath:{/workflow/CheckReady_4/exitCode} != 0)&#xD;&#xA;{&#xD;&#xA;     workflow.setVariable(&quot;failureMessage&quot;,&quot;Check readiness failed for pseudo client [&quot; + xpath:{/workflow/inputs/PseudoClientName} + &quot;]&quot;);&#xD;&#xA;     logger.path(xpath:{/workflow/variables/workflowLoggerPath}).info(&quot;Check readiness failed for pseudo client [&quot; + xpath:{/workflow/inputs/PseudoClientName} + &quot;)&quot;);  &#xD;&#xA;}&#xD;&#xA;else&#xD;&#xA;{&#xD;&#xA;    logger.path(xpath:{/workflow/variables/workflowLoggerPath}).info(&quot;Check readiness succeeded for pseudo client [&quot; + xpath:{/workflow/inputs/PseudoClientName} + &quot;)&quot;);  &#xD;&#xA;}" />

    <inputs val="&lt;inputs&gt;&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/inputs/PseudoClientName}&lt;/client&gt;&lt;reportType class=&quot;workflow.types.cmd.ReportInformationType&quot; _list_=&quot;false&quot;&gt;Summary&lt;/reportType&gt;&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;&gt;&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/useImpersonatedAccount&gt;&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/sessionOptions&gt;&lt;/inputs&gt;" />

    <transition activity="CommServDBQuery_4" commented="0" originalStyle="" points="1490.0,190.0" sourceX="830" sourceY="560" status="0" style="defaultEdge" targetX="825" targetY="440" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;xpath:{/workflow/CheckReady_4/exitCode} == 0" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1553519925342" description="executes queries against a commcell database" displayName="Form check readiness &#xA;browse query " height="40" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_4" waitSetting="0" width="210" x="1386" y="251">

    <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;IF object_id(''tempdb.dbo.#SharePointClientNodes'') IS NOT NULL DROP TABLE #SharePointClientNodes&amp;#xD;&#xD;&#xA;CREATE TABLE #SharePointClientNodes(clientId INT, clientName VARCHAR(MAX), instanceId INT)&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;INSERT INTO #SharePointClientNodes&amp;#xD;&#xD;&#xA;SELECT DISTINCT AC.id, AC.name, APP.instance &amp;#xD;&#xD;&#xA;FROM App_Client AC WITH(NOLOCK) INNER JOIN APP_Application APP WITH(NOLOCK) ON AC.id = APP.clientId AND APP.appTypeId = 78 &amp;#xD;&#xD;&#xA;WHERE AC.id IN (xpath:{/workflow/variables/SPNodeIdsStr})&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;SELECT SPCN.clientName, &amp;#xD;&#xD;&#xA;&#x9;(&amp;#xD;&#xD;&#xA;&#x9;&#x9;SELECT&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;0 AS ''@opType'',&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;(&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;SELECT &amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;4 AS ''@_type_'',&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;''Sharepoint Server'' AS ''@appName'',&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;78 AS ''@applicationId'',&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;0 AS ''@backupsetId'',&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;SPCN.clientId AS ''@clientId'',&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;SPCN.clientName AS ''@clientName'',&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;SPCN.instanceId AS ''@instanceId'',&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;0 AS ''@subclientId''&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;FOR XML PATH(''entity''), TYPE&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;),&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;(&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;SELECT&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;(&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;SELECT &amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;(&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;SELECT &amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;78 AS ''@appType'',&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;1 AS ''@isApplicationMiningReq'',&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;(&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;SELECT &amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;(&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;SELECT &amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;''xpath:{/workflow/inputs/SharePointAdminName}'' AS ''@userName'',&amp;#xD;&#xD;&#xA;                                                                            ''xpath:{/workflow/inputs/SharePointAdminPassword}'' AS ''@password''&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;FOR XML PATH(''userAccount''), TYPE&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;)&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;FOR XML PATH(''browseInitReq''), TYPE&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;),&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;(&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;SELECT &amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;(&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;SELECT &amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;''0'' AS ''@spPermissionType''&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;FOR XML PATH(''spBrowseReq''), TYPE&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;)&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;FOR XML PATH(''browseReq''), TYPE&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;)&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;FOR XML PATH(''applicationMining''), TYPE&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;)&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;FOR XML PATH(''advConfig''), TYPE&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;)&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;&#x9;FOR XML PATH(''advOptions''), TYPE&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&#x9;)&amp;#xD;&#xD;&#xA;&#x9;&#x9;FOR XML PATH(''databrowse_BrowseRequest'')&amp;#xD;&#xD;&#xA;&#x9;)&amp;#xD;&#xD;&#xA;FROM #SharePointClientNodes AS SPCN&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;IF object_id(''tempdb.dbo.#SharePointClientNodes'') IS NOT NULL DROP TABLE #SharePointClientNodes&lt;/query&gt;&lt;/inputs&gt;" />

    <transition activity="ExecuteProcessBlock_3" commented="0" originalStyle="" points="1490.0,330.0" sourceX="825" sourceY="440" status="0" style="defaultEdge" targetX="825" targetY="349" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1553701764402" description="creates a super process group" displayName="Check Readiness For Data Protection" height="500" interactive="0" jobMode="0" name="ProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="swimlane" uniqueName="ProcessBlock_2" waitSetting="0" width="570" x="950" y="990">

    <activitySchema>

      <inputs className="" defaultValue="" listType="0" name="inputs" type="" />

      <outputs className="" defaultValue="" listType="0" name="outputs" type="" />

    </activitySchema>

    <inputs val="&lt;inputs&gt;&lt;inputs /&gt;&lt;/inputs&gt;" />

    <superProcess>

      <Start commented="0" continueOnFailure="0" created="1553701764402" description="" displayName="Start" height="30" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="0" style="label;fillColor=#FFFF33;gradientColor=#FFFF00" uniqueName="Start_11" waitSetting="0" width="120" x="18" y="30">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="ForEach_4" commented="0" originalStyle="" points="" sourceX="78" sourceY="45" status="0" style="defaultEdge" targetX="111" targetY="103" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Start>

      <Activity commented="0" continueOnFailure="0" created="1553581458492" description="iterates a group of activities over a list of values" displayName="ForEach" height="340" interactive="0" jobMode="0" name="ForEach" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="swimlane" uniqueName="ForEach_4" waitSetting="0" width="320" x="10" y="100">

        <activitySchema>

          <inputs>

            <children className="java.lang.String" inputType="java.lang.String" name="name" type="{http://www.w3.org/2001/XMLSchema}string" />

            <children className="java.lang.Object" inputType="java.lang.Object" name="values" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            <children className="java.lang.Integer" defaultValue="1" inputType="java.lang.Integer" name="numberOfParallelExecutions" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.Boolean" defaultValue="false" inputType="java.lang.Boolean" name="continueOnFailure" type="{http://www.w3.org/2001/XMLSchema}boolean" />

          </inputs>

          <outputs name="outputs">

            <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="0" name="row" type="{workflow.types.data}DataRow">

              <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            </children>

          </outputs>

        </activitySchema>

        <onExit language="1" script="if(xpath:{/workflow/variables/nodesFailedCheckReadinessForDataProtection}.size() &gt; 0)&#xD;&#xA;{&#xD;&#xA;    workflow.setVariable(&quot;failureMessage&quot;,&quot;Check readiness for data protection failed for &quot; + xpath:{/workflow/variables/nodesFailedCheckReadinessForDataProtection} + &quot; SharePoint node/s.&quot;);&#xD;&#xA;    logger.path(xpath:{/workflow/variables/workflowLoggerPath}).info(&quot;Check readiness for data protection failed for &quot; + xpath:{/workflow/variables/nodesFailedCheckReadinessForDataProtection} + &quot; SharePoint nodes.&quot;);&#xD;&#xA;}&#xD;&#xA;else&#xD;&#xA;{&#xD;&#xA;    logger.path(xpath:{/workflow/variables/workflowLoggerPath}).info(&quot;Check readiness for data protection succeeded for all SharePoint nodes&quot;);&#xD;&#xA;}" />

        <inputs val="&lt;inputs&gt;&lt;name class=&quot;java.lang.String&quot;&gt;row&lt;/name&gt;&lt;values class=&quot;java.lang.Object&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/CommServDBQuery_4/resultSets[1]/row}&lt;/values&gt;&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;&gt;1&lt;/numberOfParallelExecutions&gt;&lt;continueOnFailure class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/continueOnFailure&gt;&lt;/inputs&gt;" />

        <transition activity="WorkflowEnd_10" commented="0" originalStyle="" points="428.0,272.0" sourceX="168" sourceY="272" status="0" style="defaultEdge" targetX="418" targetY="272" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;xpath:{/workflow/variables/nodesFailedCheckReadinessForDataProtection}.size() &gt; 0" />

        </transition>

        <superProcess>

          <Start commented="0" continueOnFailure="0" created="1553581458492" description="" displayName="Start" height="30" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="0" style="label;fillColor=#FFFF33;gradientColor=#FFFF00" uniqueName="Start_10" waitSetting="0" width="120" x="38" y="30">

            <inputs val="&lt;inputs /&gt;" />

            <transition activity="HttpClient_2" commented="0" originalStyle="" points="100.0,84.0" sourceX="88" sourceY="44" status="0" style="defaultEdge" targetX="95" targetY="115" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Start>

          <Activity commented="0" continueOnFailure="0" created="1553603278518" description="performs http operations" displayName="Do Browse" height="30" interactive="0" jobMode="0" name="HttpClient" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.HttpClientActivity" timeout="600" uniqueName="HttpClient_2" waitSetting="0" width="170" x="20" y="100">

            <onExit language="1" script="if(xpath:{/workflow/HttpClient_2/statusCode} != 200)&#xD;&#xA;{&#xD;&#xA;    workflow.setVariable(&quot;failureMessage&quot;,&quot;Check readiness for data protection for client [&quot; + xpath:{/workflow/ForEach_4/row/col[1]} + &quot;] failed.&quot;);&#xD;&#xA;    logger.path(xpath:{/workflow/variables/workflowLoggerPath}).info(&quot;Check readiness for data protection for client [&quot; + xpath:{/workflow/ForEach_4/row/col[1]} + &quot;] failed. Status code returned [&quot; + xpath:{/workflow/HttpClient_2/statusCode} + &quot;]&quot;);  &#xD;&#xA;}&#xD;&#xA;else&#xD;&#xA;{&#xD;&#xA;    logger.path(xpath:{/workflow/variables/workflowLoggerPath}).info(&quot;Check readiness for data protection for client [&quot; + xpath:{/workflow/ForEach_4/row/col[1]} + &quot; got response: [&quot; + xpath:{/workflow/HttpClient_2/output} + &quot;]&quot;);  &#xD;&#xA;}&#xD;&#xA;&#xD;&#xA;" />

            <inputs val="&lt;inputs&gt;&lt;request&gt;&lt;url&gt;/SearchSvc/CVWebService.svc/DoBrowse&lt;/url&gt;&lt;method&gt;POST&lt;/method&gt;&lt;postType&gt;Raw&lt;/postType&gt;&lt;postContent&gt;xpath:{/workflow/ForEach_4/row/col[2]}&lt;/postContent&gt;&lt;postContentType&gt;application/xml; charset=UTF-8&lt;/postContentType&gt;&lt;headers&gt;&lt;name&gt;Authtoken&lt;/name&gt;&lt;value&gt;QSDKONLY xpath:{/workflow/system/token}&lt;/value&gt;&lt;/headers&gt;&lt;headers&gt;&lt;name&gt;Accept&lt;/name&gt;&lt;value&gt;application/xml&lt;/value&gt;&lt;/headers&gt;&lt;/request&gt;&lt;/inputs&gt;" />

            <transition activity="XPathQuery_5" commented="0" originalStyle="" points="" sourceX="105" sourceY="115" status="0" style="defaultEdge" targetX="102" targetY="191" transitionIndex="0" x="-962" y="-1038">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;xpath:{/workflow/HttpClient_2/statusCode} == 200" />

            </transition>

            <transition activity="AddToList_4" commented="0" originalStyle="" points="238.0,152.0" sourceX="95" sourceY="115" status="0" style="defaultEdge" targetX="338" targetY="273" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;xpath:{/workflow/HttpClient_2/statusCode} != 200" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1553698760754" description="retrieves a list of values from xml" displayName="Analyze response" height="34" interactive="0" jobMode="0" name="XPathQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.XMLQueryActivity" uniqueName="XPathQuery_5" waitSetting="0" width="169" x="18" y="174">

            <inputs val="&lt;inputs&gt;&lt;xml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/HttpClient_2/output}&lt;/xml&gt;&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;databrowse_BrowseResponseList/browseResponses/browseResult/advConfig/applicationMining/browseResp/spBrowseResp/permissionsResults/compatibilityItemResults/@assignResult&lt;/xpath&gt;&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;&gt;Integer&lt;/outputType&gt;&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/outputAsList&gt;&lt;/inputs&gt;" />

            <transition activity="AddToList_4" commented="0" originalStyle="" points="" sourceX="98" sourceY="192" status="0" style="defaultEdge" targetX="178" targetY="262" transitionIndex="0" x="0" y="0">

              <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;xpath:{/workflow/XPathQuery_5/result}.contains(1)" />

            </transition>

          </Activity>

          <Activity commented="0" continueOnFailure="0" created="1553701889343" description="utility to add objects to a list" displayName="Add to failed list" height="40" interactive="0" jobMode="0" name="AddToList" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.ListActivityAdd" uniqueName="AddToList_4" waitSetting="0" width="270" x="20" y="260">

            <inputs val="&lt;inputs&gt;&lt;addToList class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/variables/nodesFailedCheckReadinessForDataProtection}&lt;/addToList&gt;&lt;itemToAdd class=&quot;java.lang.Object&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/ForEach_4/row/col[1]}&lt;/itemToAdd&gt;&lt;/inputs&gt;" />

          </Activity>

        </superProcess>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1553702799948" description="Ends the workflow" displayName="Failed" height="40" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.EndActivity" uniqueName="WorkflowEnd_10" waitSetting="0" width="133" x="424" y="252">

        <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;&gt;FAILED&lt;/completionStatus&gt;&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/variables/failureMessage}&lt;/failureMessage&gt;&lt;/inputs&gt;" />

      </Activity>

    </superProcess>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1553702374899" description="executes a defined process block within the workflow" displayName="Check Readniess for&#xA; Data protection" height="40" interactive="0" jobMode="0" name="ExecuteProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.ExecuteSuperProcess" uniqueName="ExecuteProcessBlock_3" waitSetting="0" width="210" x="1384" y="356">

    <activitySchema>

      <inputs className="" defaultValue="" listType="0" name="inputs" type="" />

      <outputs name="ProcessBlock_2">

        <children name="Start_11" />

        <children name="WorkflowEnd_10" />

      </outputs>

    </activitySchema>

    <onEnter language="1" script="logger.path(xpath:{/workflow/variables/workflowLoggerPath}).info(&quot;Started check readiness for data protection on member servers of pseudo client [&quot; + xpath:{/workflow/inputs/PseudoClientName} + &quot;)&quot;);  " />

    <onExit language="1" script="if(xpath:{/workflow/variables/multipleSQLServersDetected})&#xD;&#xA;{&#xD;&#xA;    workflow.setVariable(&quot;failureMessage&quot;, &quot;Detected multiple SQL Servers hosting content databases. Please configure them manually.&quot;);&#xD;&#xA;}&#xD;&#xA;else if(xpath:{/workflow/variables/multipleSQLInstanceDetected})&#xD;&#xA;{&#xD;&#xA;    workflow.setVariable(&quot;failureMessage&quot;, &quot;Detected multiple SQL Instances on SQL node. Please configure it manually.&quot;);&#xD;&#xA;}&#xD;&#xA;else if(xpath:{/workflow/variables/shouldConfigureSQLSubclient} == false)&#xD;&#xA;{&#xD;&#xA;    workflow.setVariable(&quot;failureMessage&quot;, &quot;Skipped configuring SQL client as it pre existed on CommServer. Please configure it manually.&quot;);&#xD;&#xA;}" />

    <inputs val="&lt;inputs&gt;&lt;inputs /&gt;&lt;processBlock&gt;ProcessBlock_2&lt;/processBlock&gt;&lt;outputs /&gt;&lt;/inputs&gt;" />

    <transition activity="WorkflowEnd_11" commented="0" offsetX="25" offsetY="5" originalStyle="" points="1570.0,440.0" sourceX="830" sourceY="340" status="0" style="defaultEdge" targetX="825" targetY="253" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;xpath:{/workflow/variables/multipleSQLServersDetected} == false&#xA;" />

    </transition>

    <transition activity="WorkflowEnd_12" commented="0" originalStyle="" points="1410.0,440.0" sourceX="830" sourceY="340" status="0" style="defaultEdge" targetX="1130" targetY="340" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;xpath:{/workflow/variables/multipleSQLServersDetected} == true" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1554125716188" description="Ends the workflow" displayName="Success" height="40" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.EndActivity" uniqueName="WorkflowEnd_11" waitSetting="0" width="130" x="1540" y="487">

    <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;&gt;COMPLETED&lt;/completionStatus&gt;&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/variables/failureMessage}&lt;/failureMessage&gt;&lt;/inputs&gt;" />

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1554125743816" description="Ends the workflow" displayName="Completed with errors" height="40" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.EndActivity" uniqueName="WorkflowEnd_12" waitSetting="0" width="187" x="1308" y="485">

    <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;&gt;COMPLETED_WITH_ERRORS&lt;/completionStatus&gt;&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/variables/failureMessage}&lt;/failureMessage&gt;&lt;/inputs&gt;" />

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1554211434518" description="performs http operations" displayName="Update SharePoint&#xA; Service Account Details" height="50" interactive="0" jobMode="0" name="HttpClient" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.HttpClientActivity" timeout="300" uniqueName="HttpClient_3" waitSetting="0" width="210" x="770" y="710">

    <onEnter language="1" script=" logger.path(xpath:{/workflow/variables/workflowLoggerPath}).info(&quot;Updating SharePoint Service account for pseudo client with XML: &quot; + xpath:{/workflow/CommServDBQuery_2/resultSets[2]/row[1]/col[''createPseudoClientXML'']});  " />

    <onExit language="1" script="if(xpath:{/workflow/HttpClient_1/statusCode} != 200)&#xD;&#xA;{&#xD;&#xA;    workflow.setVariable(&quot;failureMessage&quot;,&quot;Failed to update SharePoint service account details for SharePoint farm client [&quot; + xpath:{/workflow/inputs/PseudoClientName} + &quot;]&quot;);&#xD;&#xA;    logger.path(xpath:{/workflow/variables/workflowLoggerPath}).info(&quot;Failed to send request to update SharePoint service account details. Status code returned [&quot; + xpath:{/workflow/HttpClient_3/statusCode} + &quot;] Response: [&quot; + xpath:{/workflow/HttpClient_3/output} +&quot;]&quot;);  &#xD;&#xA;}&#xD;&#xA;else&#xD;&#xA;{&#xD;&#xA;    logger.path(xpath:{/workflow/variables/workflowLoggerPath}).info(&quot;Successfully updated SharePoint service Account details. Response: &quot; + xpath:{/workflow/HttpClient_1/output});&#xD;&#xA;}" />

    <inputs val="&lt;inputs&gt;&lt;request&gt;&lt;url&gt;/SearchSvc/CVWebService.svc/Agent&lt;/url&gt;&lt;method&gt;POST&lt;/method&gt;&lt;postType&gt;Raw&lt;/postType&gt;&lt;postContent&gt;&amp;lt;?xml version=&quot;1.0&quot; encoding=&quot;UTF-8&quot;?&amp;gt;&amp;lt;App_SetAgentPropertiesRequest&amp;gt;&#xD;&#xA;    &amp;lt;agentProperties&amp;gt;&#xD;&#xA;        &amp;lt;idaEntity _type_=&quot;4&quot; clientId=&quot;xpath:{/workflow/variables/sharePointFarmPseudoClientId}&quot; applicationId=&quot;78&quot;/&amp;gt;&#xD;&#xA;        &amp;lt;sharePointProp&amp;gt;&#xD;&#xA;            &amp;lt;userAccount userName=&quot;xpath:{/workflow/inputs/SharePointAdminName}&quot; password=&quot;java:{xpath:{/workflow/inputs/SharePointAdminPassword}.getPlainText()}&quot;/&amp;gt;&#xD;&#xA;        &amp;lt;/sharePointProp&amp;gt;&#xD;&#xA;    &amp;lt;/agentProperties&amp;gt;&#xD;&#xA;&amp;lt;/App_SetAgentPropertiesRequest&amp;gt;&lt;/postContent&gt;&lt;postContentType&gt;application/xml; charset=UTF-8&lt;/postContentType&gt;&lt;headers&gt;&lt;name&gt;Authtoken&lt;/name&gt;&lt;value&gt;QSDKONLY xpath:{/workflow/system/token}&lt;/value&gt;&lt;/headers&gt;&lt;headers&gt;&lt;name&gt;Accept&lt;/name&gt;&lt;value&gt;application/xml&lt;/value&gt;&lt;/headers&gt;&lt;/request&gt;&lt;/inputs&gt;" />

    <transition activity="CommServDBQuery_3" commented="0" originalStyle="" points="880.0,700.0" sourceX="160" sourceY="840" status="0" style="defaultEdge" targetX="740" targetY="830" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;xpath:{/workflow/HttpClient_1/statusCode} == 200" />

    </transition>

    <transition activity="WorkflowEnd_4" commented="0" originalStyle="" points="620.0,740.0" sourceX="160" sourceY="860" status="0" style="defaultEdge" targetX="520" targetY="630" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;xpath:{/workflow/HttpClient_1/statusCode} != 200" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1554383716803" description="iterates a group of activities over a list of values" displayName="Update service account details" height="210" interactive="0" jobMode="0" name="ForEach" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="swimlane" uniqueName="ForEach_6" waitSetting="0" width="240" x="50" y="590">

    <activitySchema>

      <inputs>

        <children className="java.lang.String" inputType="java.lang.String" name="name" type="{http://www.w3.org/2001/XMLSchema}string" />

        <children className="java.lang.Object" inputType="java.lang.Object" name="values" type="{http://www.w3.org/2001/XMLSchema}anyType" />

        <children className="java.lang.Integer" defaultValue="1" inputType="java.lang.Integer" name="numberOfParallelExecutions" type="{http://www.w3.org/2001/XMLSchema}integer" />

        <children className="java.lang.Boolean" defaultValue="false" inputType="java.lang.Boolean" name="continueOnFailure" type="{http://www.w3.org/2001/XMLSchema}boolean" />

      </inputs>

      <outputs name="outputs">

        <children className="java.lang.Object" inputType="java.lang.Object" listType="0" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

      </outputs>

    </activitySchema>

    <onEnter language="1" script="logger.path(xpath:{/workflow/variables/workflowLoggerPath}).info(&quot;Updating service account details on SharePoint member servers.&quot;); " />

    <inputs val="&lt;inputs&gt;&lt;name class=&quot;java.lang.String&quot;&gt;col&lt;/name&gt;&lt;values class=&quot;java.lang.Object&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/CommServDBQuery_2/resultSets[5]/row/col[&quot;clientId&quot;]}&lt;/values&gt;&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;&gt;1&lt;/numberOfParallelExecutions&gt;&lt;continueOnFailure class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/continueOnFailure&gt;&lt;/inputs&gt;" />

    <transition activity="HttpClient_1" commented="0" originalStyle="" points="160.0,850.0" sourceX="160" sourceY="690" status="0" style="defaultEdge" targetX="150" targetY="840" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

    <superProcess>

      <Start commented="0" continueOnFailure="0" created="1554383716803" description="" displayName="Start" height="30" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="0" style="label;fillColor=#FFFF33;gradientColor=#FFFF00" uniqueName="Start_14" waitSetting="0" width="120" x="47" y="27">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="HttpClient_5" commented="0" originalStyle="" points="110.0,70.0" sourceX="98" sourceY="48" status="0" style="defaultEdge" targetX="105" targetY="130" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Start>

      <Activity commented="0" continueOnFailure="0" created="1554383962071" description="performs http operations" displayName="Update SharePoint&#xA; Service Account Details" height="40" interactive="0" jobMode="0" name="HttpClient" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.HttpClientActivity" timeout="300" uniqueName="HttpClient_5" waitSetting="0" width="200" x="17" y="87">

        <onExit language="1" script="if(xpath:{/workflow/HttpClient_5/statusCode} != 200)&#xD;&#xA;{&#xD;&#xA;    logger.path(xpath:{/workflow/variables/workflowLoggerPath}).info(&quot;Failed to update SharePoint service account details for client id [&quot;+ xpath:{/workflow/ForEach_6/col} + &quot;]. Status code received: [&quot; + xpath:{/workflow/HttpClient_5/statusCode} + &quot;].&quot;);  &#xD;&#xA;    workflow.setVariable(&quot;failureMessage&quot;,&quot;Failed to update SharePoint member servers service account details.&quot;);&#xD;&#xA;}&#xD;&#xA;" />

        <inputs val="&lt;inputs&gt;&lt;request&gt;&lt;url&gt;/SearchSvc/CVWebService.svc/Agent&lt;/url&gt;&lt;method&gt;POST&lt;/method&gt;&lt;postType&gt;Raw&lt;/postType&gt;&lt;postContent&gt;&amp;lt;?xml version=&quot;1.0&quot; encoding=&quot;UTF-8&quot;?&amp;gt;&amp;lt;App_SetAgentPropertiesRequest&amp;gt;&#xD;&#xA;    &amp;lt;agentProperties&amp;gt;&#xD;&#xA;        &amp;lt;idaEntity _type_=&quot;4&quot; clientId=&quot;xpath:{/workflow/ForEach_6/col}&quot; applicationId=&quot;78&quot;/&amp;gt;&#xD;&#xA;        &amp;lt;sharePointProp&amp;gt;&#xD;&#xA;            &amp;lt;userAccount userName=&quot;xpath:{/workflow/inputs/SharePointAdminName}&quot; password=&quot;java:{xpath:{/workflow/inputs/SharePointAdminPassword}.getPlainText()}&quot;/&amp;gt;&#xD;&#xA;        &amp;lt;/sharePointProp&amp;gt;&#xD;&#xA;    &amp;lt;/agentProperties&amp;gt;&#xD;&#xA;&amp;lt;/App_SetAgentPropertiesRequest&amp;gt;&lt;/postContent&gt;&lt;postContentType&gt;application/xml; charset=UTF-8&lt;/postContentType&gt;&lt;headers&gt;&lt;name&gt;Authtoken&lt;/name&gt;&lt;value&gt;QSDKONLY xpath:{/workflow/system/token}&lt;/value&gt;&lt;/headers&gt;&lt;headers&gt;&lt;name&gt;Accept&lt;/name&gt;&lt;value&gt;application/xml&lt;/value&gt;&lt;/headers&gt;&lt;/request&gt;&lt;/inputs&gt;" />

        <transition activity="WorkflowEnd_14" commented="0" originalStyle="" points="110.0,140.0" sourceX="105" sourceY="130" status="0" style="defaultEdge" targetX="105" targetY="195" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;xpath:{/workflow/HttpClient_5/statusCode} != 200" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1554384331499" description="Ends the workflow" displayName="Failed" height="30" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.EndActivity" uniqueName="WorkflowEnd_14" waitSetting="0" width="180" x="28" y="162">

        <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;&gt;FAILED&lt;/completionStatus&gt;&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/variables/failureMessage}&lt;/failureMessage&gt;&lt;/inputs&gt;" />

      </Activity>

    </superProcess>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1556535370270" description="creates a super process group" displayName="Configure subclient and assign schedule policy" height="280" interactive="0" jobMode="0" name="ProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="swimlane" uniqueName="ProcessBlock_3" waitSetting="0" width="550" x="60" y="1540">

    <activitySchema>

      <inputs className="" defaultValue="" listType="0" name="inputs" type="">

        <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="subclientConfigXML" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

        <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="backupsetName" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

        <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="clientName" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

        <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="instanceName" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

        <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="subclientName" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

        <children attribute="0" className="java.lang.Integer" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Integer" listType="0" name="agentID" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}integer" />

      </inputs>

      <outputs className="" defaultValue="" listType="0" name="outputs" type="">

        <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="subclientConfigXML" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

        <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="backupsetName" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

        <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="clientName" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

        <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="instanceName" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

        <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="subclientName" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

        <children attribute="0" className="java.lang.Integer" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Integer" listType="0" name="agentID" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}integer" />

      </outputs>

    </activitySchema>

    <inputs val="&lt;inputs&gt;&lt;inputs&gt;&lt;subclientConfigXML class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;backupsetName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;clientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;instanceName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;subclientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;agentID class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; /&gt;&lt;/inputs&gt;&lt;/inputs&gt;" />

    <superProcess>

      <Start commented="0" continueOnFailure="0" created="1556535370270" description="" displayName="Start" height="30" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="0" style="label;fillColor=#FFFF33;gradientColor=#FFFF00" uniqueName="Start_15" waitSetting="0" width="120" x="65" y="30">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="Execute_8" commented="0" originalStyle="" points="" sourceX="125" sourceY="45" status="0" style="defaultEdge" targetX="125" targetY="125" transitionIndex="0" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Start>

      <Activity commented="0" continueOnFailure="0" created="1556535438017" description="" displayName="Configure subclient" height="30" interactive="0" jobMode="0" name="Execute" namespaceUri="commvault.cte.workflow.activities.cmd.operation" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.cmd.operation.OperationExecute" uniqueName="Execute_8" waitSetting="0" width="210" x="20" y="110">

        <onEnter language="1" script="logger.path(xpath:{/workflow/variables/workflowLoggerPath}).info(&quot;Configuring subclient for agent ID [&quot; + xpath:{/workflow/ProcessBlock_3/agentID} + &quot;] with request [&quot; + xpath:{/workflow/ProcessBlock_3/subclientConfigXML} + &quot;]&quot;);" />

        <onExit language="1" script="if(xpath:{/workflow/Execute_8/exitCode} != 0)&#xD;&#xA;{&#xD;&#xA;    workflow.setVariable(&quot;failureMessage&quot;,&quot;Failed to configure subclient for agent ID [&quot; + xpath:{/workflow/ProcessBlock_3/agentID} + &quot;]&quot;);&#xD;&#xA;    logger.path(xpath:{/workflow/variables/workflowLoggerPath}).info(&quot;Failed to configure subclient for agent ID [&quot; + xpath:{/workflow/ProcessBlock_3/agentID} + &quot;]&quot;); &#xD;&#xA;}&#xD;&#xA;else&#xD;&#xA;{&#xD;&#xA;    logger.path(xpath:{/workflow/variables/workflowLoggerPath}).info(&quot;Successfully configured subclient for agent ID [&quot; + xpath:{/workflow/ProcessBlock_3/agentID} + &quot;]&quot;); &#xD;&#xA;}" />

        <inputs val="&lt;inputs&gt;&lt;inputXml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/ProcessBlock_3/subclientConfigXML}&lt;/inputXml&gt;&lt;escapeXml class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/escapeXml&gt;&lt;commandArgs class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;&gt;&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/useImpersonatedAccount&gt;&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/sessionOptions&gt;&lt;/inputs&gt;" />

        <transition activity="Execute_9" commented="0" originalStyle="" points="" sourceX="125" sourceY="125" status="0" style="defaultEdge" targetX="125" targetY="225" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;xpath:{/workflow/inputs/SchedulePolicy} != null &amp;&amp; xpath:{/workflow/inputs/SchedulePolicy/schedulePolicyName} != null &amp;&amp; xpath:{/workflow/inputs/SchedulePolicy/schedulePolicyName} != &quot;&quot; &amp;&amp; xpath:{/workflow/Execute_8/exitCode} == 0" />

        </transition>

        <transition activity="WorkflowEnd_16" commented="0" originalStyle="" points="270.0,150.0" sourceX="130" sourceY="130" status="0" style="defaultEdge" targetX="320" targetY="160" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;xpath:{/workflow/Execute_8/exitCode} != 0" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1556535445252" description="" displayName="Assign schedule policy" height="30" interactive="0" jobMode="0" name="Execute" namespaceUri="commvault.cte.workflow.activities.cmd.operation" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.cmd.operation.OperationExecute" uniqueName="Execute_9" waitSetting="0" width="210" x="20" y="210">

        <onEnter language="1" script="logger.path(xpath:{/workflow/variables/workflowLoggerPath}).info(&quot;Assigning schedule policy for client [&quot; + xpath:{/workflow/ProcessBlock_3/clientName} + &quot;] agent ID [&quot; + xpath:{/workflow/ProcessBlock_3/agentID} + &quot;] instance [&quot; + xpath:{/workflow/ProcessBlock_3/instanceName} + &quot;] backupset [&quot; + xpath:{/workflow/ProcessBlock_3/backupsetName} + &quot;]&quot;);" />

        <onExit language="1" script="if(xpath:{/workflow/Execute_9/exitCode} != 0)&#xD;&#xA;{&#xD;&#xA;    workflow.setVariable(&quot;failureMessage&quot;,&quot;Failed to assign schedule policy for agent ID [&quot; + xpath:{/workflow/ProcessBlock_3/agentID} + &quot;]&quot;);&#xD;&#xA;    logger.path(xpath:{/workflow/variables/workflowLoggerPath}).info(&quot;Failed to assign schedule policy for agent ID [&quot; + xpath:{/workflow/ProcessBlock_3/agentID} + &quot;]&quot;); &#xD;&#xA;}&#xD;&#xA;else&#xD;&#xA;{&#xD;&#xA;    logger.path(xpath:{/workflow/variables/workflowLoggerPath}).info(&quot;Successfully assigned schedule policy for agent ID [&quot; + xpath:{/workflow/ProcessBlock_3/agentID} + &quot;]&quot;); &#xD;&#xA;}" />

        <inputs val="&lt;inputs&gt;&lt;inputXml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;&amp;lt;?xml version=&quot;1.0&quot; encoding=&quot;UTF-8&quot; standalone=&quot;no&quot; ?&amp;gt;&amp;#xD;&#xD;&#xA;&amp;lt;TMMsg_ModifyTaskReq&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&amp;lt;taskInfo taskOperation=&quot;2&quot;&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&#x9;&amp;lt;task policyType=&quot;0&quot; taskName=&quot;xpath:{/workflow/inputs/SchedulePolicy/schedulePolicyName}&quot; taskType=&quot;4&quot;&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&amp;lt;originalCC commCellId=&quot;2&quot;/&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;&amp;lt;task taskName=&quot;xpath:{/workflow/inputs/SchedulePolicy/schedulePolicyName}&quot;/&amp;gt;&amp;lt;/task&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&#x9;&amp;lt;associations _type_=&quot;7&quot; applicationId=&quot;xpath:{/workflow/ProcessBlock_3/agentID}&quot; backupsetName=&quot;xpath:{/workflow/ProcessBlock_3/backupsetName}&quot; clientName=&quot;xpath:{/workflow/ProcessBlock_3/clientName}&quot; instanceName=&quot;xpath:{/workflow/ProcessBlock_3/instanceName}&quot; subclientName=&quot;xpath:{/workflow/ProcessBlock_3/subclientName}&quot;/&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&amp;lt;/taskInfo&amp;gt;&amp;#xD;&#xD;&#xA;&amp;lt;/TMMsg_ModifyTaskReq&amp;gt;&lt;/inputXml&gt;&lt;escapeXml class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/escapeXml&gt;&lt;commandArgs class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;&gt;&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/useImpersonatedAccount&gt;&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/sessionOptions&gt;&lt;/inputs&gt;" />

        <transition activity="WorkflowEnd_16" commented="0" originalStyle="" points="270.0,180.0" sourceX="125" sourceY="225" status="0" style="defaultEdge" targetX="404" targetY="173" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;xpath:{/workflow/Execute_9/exitCode} != 0" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1556535722990" description="Ends the workflow" displayName="Failed" height="40" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.EndActivity" uniqueName="WorkflowEnd_16" waitSetting="0" width="140" x="334" y="153">

        <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;&gt;FAILED&lt;/completionStatus&gt;&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/variables/failureMessage}&lt;/failureMessage&gt;&lt;/inputs&gt;" />

      </Activity>

    </superProcess>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1556535886978" description="executes a defined process block within the workflow" displayName="Configure SharePoint subclient" height="40" interactive="0" jobMode="0" name="ExecuteProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.ExecuteSuperProcess" uniqueName="ExecuteProcessBlock_4" waitSetting="0" width="200" x="773" y="460">

    <activitySchema>

      <inputs className="" defaultValue="" listType="0" name="inputs" type="">

        <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="subclientConfigXML" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

        <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="backupsetName" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

        <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="clientName" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

        <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="instanceName" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

        <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="subclientName" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

        <children attribute="0" className="java.lang.Integer" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Integer" listType="0" name="agentID" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}integer" />

      </inputs>

      <outputs name="ProcessBlock_3">

        <children name="Start_15" />

        <children name="Execute_8">

          <children className="java.lang.String" documentation="xml output contents" inputType="java.lang.String" name="outputXml" type="{http://www.w3.org/2001/XMLSchema}string" />

          <children className="java.lang.Integer" documentation="return code from the executable" inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

          <children className="java.lang.String" documentation="command output" inputType="java.lang.String" name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string" />

        </children>

        <children name="Execute_9">

          <children className="java.lang.String" documentation="xml output contents" inputType="java.lang.String" name="outputXml" type="{http://www.w3.org/2001/XMLSchema}string" />

          <children className="java.lang.Integer" documentation="return code from the executable" inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

          <children className="java.lang.String" documentation="command output" inputType="java.lang.String" name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string" />

        </children>

        <children name="WorkflowEnd_16" />

      </outputs>

    </activitySchema>

    <inputs val="&lt;inputs&gt;&lt;inputs&gt;&lt;subclientConfigXML class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/CommServDBQuery_3/resultSets[1]/row[1]/col[&quot;createSharePointSubclientXML&quot;]}&lt;/subclientConfigXML&gt;&lt;backupsetName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;Databases&lt;/backupsetName&gt;&lt;clientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/inputs/PseudoClientName}&lt;/clientName&gt;&lt;instanceName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;defaultInstanceName&lt;/instanceName&gt;&lt;agentID class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;&gt;78&lt;/agentID&gt;&lt;subclientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;Auto Configured Subclient&lt;/subclientName&gt;&lt;/inputs&gt;&lt;processBlock&gt;ProcessBlock_3&lt;/processBlock&gt;&lt;outputs /&gt;&lt;/inputs&gt;" />

    <transition activity="ExecuteProcessBlock_5" commented="0" originalStyle="" points="" sourceX="878" sourceY="480" status="0" style="defaultEdge" targetX="771" targetY="322" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;xpath:{/workflow/variables/shouldConfigureSQLSubclient} == true" />

    </transition>

    <transition activity="CheckReady_4" commented="0" displayName="Multiple Instances detected&#xA;or&#xA;SQL client pre existed in Commserver" offsetX="0" offsetY="-61" originalStyle="" points="930.0,300.0" sourceX="880" sourceY="420" status="0" style="defaultEdge" targetX="960" targetY="160" transitionIndex="0" x="0" y="-10">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;xpath:{/workflow/variables/shouldConfigureSQLSubclient} == false" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1556535903641" description="executes a defined process block within the workflow" displayName="Configure SQL subclient" height="40" interactive="0" jobMode="0" name="ExecuteProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.ExecuteSuperProcess" uniqueName="ExecuteProcessBlock_5" waitSetting="0" width="210" x="666" y="302">

    <activitySchema>

      <inputs className="" defaultValue="" listType="0" name="inputs" type="">

        <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="subclientConfigXML" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

        <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="backupsetName" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

        <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="clientName" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

        <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="instanceName" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

        <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="subclientName" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string" />

        <children attribute="0" className="java.lang.Integer" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Integer" listType="0" name="agentID" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}integer" />

      </inputs>

      <outputs name="ProcessBlock_3">

        <children name="Start_15" />

        <children name="Execute_8">

          <children className="java.lang.String" documentation="xml output contents" inputType="java.lang.String" name="outputXml" type="{http://www.w3.org/2001/XMLSchema}string" />

          <children className="java.lang.Integer" documentation="return code from the executable" inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

          <children className="java.lang.String" documentation="command output" inputType="java.lang.String" name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string" />

        </children>

        <children name="Execute_9">

          <children className="java.lang.String" documentation="xml output contents" inputType="java.lang.String" name="outputXml" type="{http://www.w3.org/2001/XMLSchema}string" />

          <children className="java.lang.Integer" documentation="return code from the executable" inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer" />

          <children className="java.lang.String" documentation="command output" inputType="java.lang.String" name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string" />

        </children>

        <children name="WorkflowEnd_16" />

      </outputs>

    </activitySchema>

    <inputs val="&lt;inputs&gt;&lt;inputs&gt;&lt;subclientConfigXML class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/CommServDBQuery_3/resultSets[3]/row[1]/col[&quot;SqlSubclientUpdateXML&quot;]}&lt;/subclientConfigXML&gt;&lt;backupsetName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/CommServDBQuery_3/resultSets[4]/row[1]/col[3]}&lt;/backupsetName&gt;&lt;clientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/CommServDBQuery_3/resultSets[4]/row[1]/col[1]}&lt;/clientName&gt;&lt;instanceName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/CommServDBQuery_3/resultSets[4]/row[1]/col[2]}&lt;/instanceName&gt;&lt;agentID class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;&gt;81&lt;/agentID&gt;&lt;subclientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;default&lt;/subclientName&gt;&lt;/inputs&gt;&lt;processBlock&gt;ProcessBlock_3&lt;/processBlock&gt;&lt;outputs /&gt;&lt;/inputs&gt;" />

    <transition activity="CheckReady_4" commented="0" originalStyle="" points="" sourceX="790" sourceY="290" status="0" style="defaultEdge" targetX="810" targetY="170" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1556536196395" description="Ends the workflow" displayName="Failed" height="30" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.EndActivity" uniqueName="WorkflowEnd_17" waitSetting="0" width="150" x="532" y="587">

    <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;&gt;FAILED&lt;/completionStatus&gt;&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/variables/failureMessage}&lt;/failureMessage&gt;&lt;/inputs&gt;" />

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1557472660023" description="executes queries against a commcell database" displayName="Detect pre existing clients&#xA;" height="40" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="PreExistingClientsQuery" waitSetting="0" width="200" x="60" y="230">

    <onEnter language="1" script="logger.path(xpath:{/workflow/variables/workflowLoggerPath}).info(&quot;Detecting pre existing clients....&quot;);" />

    <onExit language="1" script="if(xpath:{/workflow/PreExistingClientsQuery/errorCode} != 0)&#xD;&#xA;{&#xD;&#xA;    logger.path(xpath:{/workflow/variables/workflowLoggerPath}).info(&quot;Failed to detect pre-existing clients with error code [&quot; + xpath:{/workflow/SQLQuery_1/errorCode} + &quot;]&quot;);&#xD;&#xA;    workflow.setVariable(&quot;failureMessage&quot;,&quot;Failed to detect pre-existing clients on the Commserver before configuration.&quot;);&#xD;&#xA;}&#xD;&#xA;else&#xD;&#xA;{&#xD;&#xA;    //Pre existing SharePoint clients&#xD;&#xA;    if(xpath:{/workflow/PreExistingClientsQuery/resultSets[1]} != null &amp;&amp; xpath:{/workflow/PreExistingClientsQuery/resultSets[1]/rowCount} != 0)&#xD;&#xA;    {&#xD;&#xA;        logger.path(xpath:{/workflow/variables/workflowLoggerPath}).info(&quot;Service account update will be skipped for SharePoint clients &quot; + xpath:{/workflow/PreExistingClientsQuery/resultSets[1]/row/col[3]} + &quot; as they already exist on the commserver.&quot;);&#xD;&#xA;        workflow.setVariable(&quot;preExistingSPClientIds&quot;, xpath:{/workflow/PreExistingClientsQuery/resultSets[1]/row/col[1]}.toString().replace(''['','' '').replace('']'','' ''));&#xD;&#xA;    }&#xD;&#xA;&#xD;&#xA;    // Pre existing SQL client&#xD;&#xA;    if(xpath:{/workflow/PreExistingClientsQuery/resultSets[2]} != null &amp;&amp; xpath:{/workflow/PreExistingClientsQuery/resultSets[2]/rowCount} != 0)&#xD;&#xA;    {&#xD;&#xA;        logger.path(xpath:{/workflow/variables/workflowLoggerPath}).info(&quot;Configuration will be skipped for SQL clients &quot; + xpath:{/workflow/PreExistingClientsQuery/resultSets[2]/row/col[2]} + &quot; as they already exist on the commserver.&quot;);&#xD;&#xA;        workflow.setVariable(&quot;shouldConfigureSQLSubclient&quot;,false);&#xD;&#xA;    }&#xD;&#xA;}" />

    <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;-- Get pre existing SharePoint clients&amp;#xD;&#xD;&#xA;SELECT AC.id, AC.name, AC.net_hostname, 78 FROM App_Client AC WITH(NOLOCK) &amp;#xD;&#xD;&#xA;INNER JOIN (SELECT * FROM dbo.split(?, '', '')) T ON AC.net_hostname LIKE  T.data + ''.%'' OR AC.net_hostname = T.Data&amp;#xD;&#xD;&#xA;INNER JOIN APP_IDAName IDA ON AC.id = IDA.clientId WHERE IDA.appTypeId = 78 &amp;#xD;&#xD;&#xA;AND IDA.status &amp;amp; (0x00004) = 0 --deleted&amp;#xD;&#xD;&#xA;AND IDA.status &amp;amp; (0x00002) = 0 --uninstalled&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;--Get pre existing SQL clients&amp;#xD;&#xD;&#xA;SELECT AC.id, AC.name, AC.net_hostname, 81 FROM App_Client AC WITH(NOLOCK) INNER JOIN APP_IDAName IDA WITH(NOLOCK) ON AC.id = IDA.clientId &amp;#xD;&#xD;&#xA;WHERE IDA.appTypeId = 81 AND AC.net_hostname = ? &amp;#xD;&#xD;&#xA;AND IDA.status &amp;amp; (0x00004) = 0 --deleted &amp;#xD;&#xD;&#xA;AND IDA.status &amp;amp; (0x00002) = 0 --uninstalled&lt;/query&gt;&lt;parameters&gt;&lt;value&gt;xpath:{/workflow/variables/sharePointClientHostNamesStr}&lt;/value&gt;&lt;type&gt;OBJECT&lt;/type&gt;&lt;/parameters&gt;&lt;parameters&gt;&lt;value&gt;xpath:{/workflow/inputs/SQLServerName}&lt;/value&gt;&lt;type&gt;STRING&lt;/type&gt;&lt;/parameters&gt;&lt;/inputs&gt;" />

    <transition activity="ExecuteProcessBlock_1" commented="0" originalStyle="" points="" sourceX="160" sourceY="250" status="0" style="defaultEdge" targetX="160" targetY="320" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;xpath:{/workflow/PreExistingClientsQuery/errorCode} == 0" />

    </transition>

    <transition activity="WorkflowEnd_2" commented="0" originalStyle="" points="360.0,250.0" sourceX="160" sourceY="250" status="0" style="defaultEdge" targetX="340" targetY="320" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;xpath:{/workflow/PreExistingClientsQuery/errorCode} != 0" />

    </transition>

  </Activity>

</workflow>'

IF not exists (select * from WF_Definition where Name = @name)

BEGIN
	INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision)


	VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision)

	SET @workflowId = @@IDENTITY
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


	VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

	SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = ISNULL(revision, '') From WF_Definition WHERE Name = @name

	IF (@currentFlags & 4 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0) AND (@currentRevision <> @revision)

	BEGIN

		SET @version = @version + 1

		UPDATE WF_Definition

		SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision

		WHERE Name = @name

		IF (@flags & 8 > 0 OR @flags & 16 > 0)

		BEGIN

			UPDATE WF_Definition

			SET flags = @flags

			WHERE Name = @name

		END
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


		VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

	END

END

