

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_CommCellReadinessCheck.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/WFD_CommCellReadinessCheck.script,v $ $Id: WFD_CommCellReadinessCheck.script,v 1.1.2.3 2016/08/18 22:21:49 dnavaneethan Exp $";
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER OFF

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.1.2.3 $'

SET @name = 'CommCell readiness check for metrics report'

SET @description = 'Run CommCell readiness check and save the outcome in metrics upload folder'

SET @version = 1

SET @flags = 30

SET @definition = '<workflow apiMode="1"

    description="Run CommCell readiness check and save the outcome in metrics upload folder"

    inputs="&lt;inputs />" interactive="0" isHtmlDescription="0"

    name="CommCell readiness check for metrics report"

    outputs="&lt;outputs />" revision="$Revision: 1.1.2.3 $"

    uniqueGuid="0ebc7342-bdb9-4c93-94e2-a7d77e9236e4"

    variables="&lt;variables>&lt;destinationPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;reportName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;isPublicEnabled class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;isPrivateEnabled class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;publicCG class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&lt;/publicCG>&lt;privateCG class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&lt;/privateCG>&lt;/variables>" workflowId="0">

    <schema>

        <outputs className="" name="outputs" type=""/>

        <variables attribute="0" className="" name="variables" type="">

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="destinationPath" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="reportName" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.Integer"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0"

                inputType="java.lang.Integer" listType="0"

                name="isPublicEnabled" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.Integer"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0"

                inputType="java.lang.Integer" listType="0"

                name="isPrivateEnabled" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="publicCG" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="privateCG" type="{http://www.w3.org/2001/XMLSchema}string"/>

        </variables>

        <inputs className="" name="inputs" type=""/>

    </schema>

    <Start commented="0" continueOnFailure="0" created="0"

        description="" displayName="Start" height="36" interactive="0"

        jobMode="0" name="Start" originalStyle="" skipAttempt="0"

        style="image;image=/images/jgraphx/house.png"

        uniqueName="Start_1" waitSetting="0" width="55" x="5" y="52">

        <inputs val="&lt;inputs />"/>

        <transition activity="CommServDBQuery_1" commented="0"

            originalStyle="" points="" sourceX="32" sourceY="70"

            status="0" style="defaultEdge" targetX="157" targetY="70"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Start>

    <Activity commented="0" continueOnFailure="0"

        created="1443640681127"

        description="executes queries against the commserv database"

        displayName="Get Temp Report File" height="34" interactive="0"

        jobMode="0" name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=CommServDBQuery"

        uniqueName="CommServDBQuery_1" waitSetting="0" width="178"

        x="108" y="57">

        <onExit language="1" script="long unixTime = System.currentTimeMillis() / 1000L;&#xd;&#xa;&#xd;&#xa;workflow.setVariable(&quot;destinationPath&quot;, xpath:{/workflow/CommServDBQuery_1/resultSets/row/col[1]} + &quot;Reports&quot;);&#xd;&#xa;&#xd;&#xa;workflow.setVariable(&quot;reportName&quot;, &#xd;&#xa;&quot;CSS&quot; + String.valueOf(unixTime) + &quot;_&quot; &#xd;&#xa;+ xpath:{/workflow/CommServDBQuery_1/resultSets/row/col[2]} + &quot;_&quot;&#xd;&#xa;+ xpath:{/workflow/CommServDBQuery_1/resultSets/row/col[3]} + &quot;_CCR&quot;);&#xd;&#xa;&#xd;&#xa;if (xpath:{/workflow/CommServDBQuery_1/resultSets/row/col[4]} == 1 &amp;&amp; xpath:{/workflow/CommServDBQuery_1/resultSets/row/col[5]} == 1)&#xd;&#xa;    workflow.setVariable(&quot;isPublicEnabled&quot;, 1);&#xd;&#xa;else&#xd;&#xa;    workflow.setVariable(&quot;isPublicEnabled&quot;, 0);&#xd;&#xa;    &#xd;&#xa;if (xpath:{/workflow/CommServDBQuery_1/resultSets/row/col[6]} == 1 &amp;&amp; xpath:{/workflow/CommServDBQuery_1/resultSets/row/col[7]} == 1)&#xd;&#xa;    workflow.setVariable(&quot;isPrivateEnabled&quot;, 1);&#xd;&#xa;else&#xd;&#xa;    workflow.setVariable(&quot;isPrivateEnabled&quot;, 0);    "/>

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>SELECT&amp;#xD;&#xd;&#xa;&#x9;(SELECT SUBSTRING(jobresultdir, 1, CHARINDEX(''\iDataAgent\JobResults'', jobresultdir)) FROM App_Client WITH(NOLOCK) WHERE id = 2) AS ReportsDir,&amp;#xD;&#xd;&#xa;&#x9;(SELECT TOP 1 dbo.ConvertBigIntToHexStr(CommCellId) FROM LicCsl WITH(NOLOCK) ORDER BY id DESC) AS CommCellID,&amp;#xD;&#xd;&#xa;&#x9;(SELECT csGUID FROM APP_CommCell WITH(NOLOCK) WHERE id = 2) AS CSGUID,&amp;#xD;&#xd;&#xa;&#x9;(SELECT CAST(VALUE AS INT) FROM GXGlobalParam WITH(NOLOCK) WHERE name = ''CommservSurveyEnabled'') AS ''PublicEnabled'',&amp;#xD;&#xd;&#xa;&#x9;CASE WHEN isEnabled &amp;amp; 1 = 1 THEN 1 ELSE 0 END AS ''PublicHealth'',&amp;#xD;&#xd;&#xa;&#x9;(SELECT CAST(VALUE AS INT) FROM GXGlobalParam WITH(NOLOCK) WHERE name = ''CommservSurveyPrivateEnabled'') AS ''PrivateEnabled'',&amp;#xD;&#xd;&#xa;&#x9;CASE WHEN isEnabled &amp;amp; 2 = 2 THEN 1 ELSE 0 END AS ''PrivateHealth''&amp;#xD;&#xd;&#xa;FROM CloudMonitoringService WITH(NOLOCK) WHERE id = 1&lt;/query>&lt;/inputs>"/>

        <transition activity="Decision_5" commented="0" originalStyle=""

            points="156.0,121.0" sourceX="219" sourceY="74" status="0"

            style="defaultEdge" targetX="145" targetY="150"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1460693495391" description="if/else based decision"

        displayName="Public or Private Enabled" height="100"

        interactive="0" jobMode="0" name="Decision"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_4" waitSetting="0" width="171" x="271" y="358">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/isPublicEnabled} == 1 || xpath:{/workflow/variables/isPrivateEnabled} == 1 &lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="Decision_8" commented="0"

            displayName="Yes" originalStyle="" sourceX="356"

            sourceY="408" status="0" style="defaultEdge" targetX="585"

            targetY="398" transitionIndex="0" value="true" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="WorkflowEnd_2" commented="0"

            displayName="No" originalStyle="" points="" sourceX="356"

            sourceY="408" status="0" style="defaultEdge" targetX="360"

            targetY="549" transitionIndex="0" value="false" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1471524756459"

        description="executes queries against a commcell database"

        displayName="Get Public Client Groups" height="34"

        interactive="0" jobMode="0" name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.CommServDBQuery"

        uniqueName="CommServDBQuery_2" waitSetting="0" width="166"

        x="271" y="152">

        <onExit language="1" script="workflow.setVariable(&quot;publicCG&quot;, xpath:{/workflow/CommServDBQuery_2/resultSets/row/col[1]});"/>

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>DECLARE @CG NVARCHAR(2048)&amp;#xD;&#xd;&#xa;SELECT @CG = value FROM GXGlobalParam WHERE name = ''CommservSurveySpecialClientGroup'' AND modified = 0&amp;#xD;&#xd;&#xa;IF (@CG = ''-1'')&amp;#xD;&#xd;&#xa;&#x9;SELECT ''&amp;lt;computerSelectionList&amp;gt;&amp;lt;includeAll&amp;gt;true&amp;lt;/includeAll&amp;gt;&amp;lt;/computerSelectionList&amp;gt;''&amp;#xD;&#xd;&#xa;ELSE&amp;#xD;&#xd;&#xa;SELECT&amp;#xD;&#xd;&#xa;&#x9;(SELECT name AS ''clientGroupName'' FROM APP_ClientGroup WHERE id in (SELECT _ID FROM dbo.SplitStringByDelimiter(@CG, '','')) FOR XML PATH(''clientGroupList''), TYPE),&amp;#xD;&#xd;&#xa;&#x9;''false'' AS ''includeAll''&amp;#xD;&#xd;&#xa;&#x9;FOR XML PATH(''computerSelectionList'')&lt;/query>&lt;/inputs>"/>

        <transition activity="Decision_6" commented="0" originalStyle=""

            points="" sourceX="354" sourceY="169" status="0"

            style="defaultEdge" targetX="241" targetY="225"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1471524842525" description="if/else based decision"

        displayName="Is Public Enabled" height="62" interactive="0"

        jobMode="0" name="Decision"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_5" waitSetting="0" width="126" x="87" y="135">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/isPublicEnabled} == 1&amp;#xD;&#xd;&#xa;&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="CommServDBQuery_2" commented="0"

            displayName="Yes" originalStyle="" points="" sourceX="258"

            sourceY="162" status="0" style="defaultEdge" targetX="226"

            targetY="265" transitionIndex="0" value="true" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="Decision_6" commented="0" displayName="No"

            originalStyle="" points="" sourceX="150" sourceY="166"

            status="0" style="defaultEdge" targetX="230" targetY="269"

            transitionIndex="0" value="false" x="29" y="-109">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1471525199155" description="if/else based decision"

        displayName="Is Private Enabled" height="73" interactive="0"

        jobMode="0" name="Decision"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_6" waitSetting="0" width="146" x="157" y="233">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/isPrivateEnabled} == 1 &lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="CommServDBQuery_3" commented="0"

            displayName="Yes" originalStyle="" points="" sourceX="230"

            sourceY="269" status="0" style="defaultEdge" targetX="421"

            targetY="267" transitionIndex="0" value="true" x="29" y="-109">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="Decision_4" commented="0" displayName="No"

            originalStyle="" points="227.0,348.0" sourceX="230"

            sourceY="269" status="0" style="defaultEdge" targetX="297"

            targetY="410" transitionIndex="0" value="false" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1471525413815"

        description="executes queries against a commcell database"

        displayName="Get Private Client Group" height="34"

        interactive="0" jobMode="0" name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.CommServDBQuery"

        uniqueName="CommServDBQuery_3" waitSetting="0" width="164"

        x="339" y="250">

        <onExit language="1" script="workflow.setVariable(&quot;privateCG&quot;, xpath:{/workflow/CommServDBQuery_3/resultSets/row/col[1]});"/>

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>DECLARE @CG NVARCHAR(2048)&amp;#xD;&#xd;&#xa;SELECT @CG = value FROM GXGlobalParam WHERE name = ''CommservSurveyPrivateSpecialClientGroup'' AND modified = 0&amp;#xD;&#xd;&#xa;IF (@CG = ''-1'')&amp;#xD;&#xd;&#xa;&#x9;SELECT ''&amp;lt;computerSelectionList&amp;gt;&amp;lt;includeAll&amp;gt;true&amp;lt;/includeAll&amp;gt;&amp;lt;/computerSelectionList&amp;gt;''&amp;#xD;&#xd;&#xa;ELSE&amp;#xD;&#xd;&#xa;SELECT&amp;#xD;&#xd;&#xa;&#x9;(SELECT name AS ''clientGroupName'' FROM APP_ClientGroup WHERE id in (SELECT _ID FROM dbo.SplitStringByDelimiter(@CG, '','')) FOR XML PATH(''clientGroupList''), TYPE),&amp;#xD;&#xd;&#xa;&#x9;''false'' AS ''includeAll''&amp;#xD;&#xd;&#xa;&#x9;FOR XML PATH(''computerSelectionList'')&lt;/query>&lt;/inputs>"/>

        <transition activity="Decision_4" commented="0" originalStyle=""

            points="" sourceX="421" sourceY="267" status="0"

            style="defaultEdge" targetX="359" targetY="388"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1471530610583" description="Ends the workflow"

        displayName="WorkflowEnd" height="34" interactive="0"

        jobMode="0" name="WorkflowEnd"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.EndActivity"

        uniqueName="WorkflowEnd_2" waitSetting="0" width="608" x="379" y="609">

        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot; />&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1471530799329"

        description="creates a super process group"

        displayName="Run CCR Job and Save Results file" height="488"

        interactive="0" jobMode="0" name="ProcessBlock"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ProcessBlock_1" waitSetting="0" width="465" x="1105" y="40">

        <inputs val="&lt;inputs>&lt;inputs>&lt;copyToPublic class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot; />&lt;copyToPrivate class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot; />&lt;cglist class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/inputs>&lt;/inputs>"/>

        <superProcess>

            <Start commented="0" continueOnFailure="0"

                created="1471530799329" description=""

                displayName="Start" height="30" interactive="0"

                jobMode="0" name="Start" originalStyle=""

                skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_2" waitSetting="0" width="120" x="258" y="38">

                <inputs val="&lt;inputs />"/>

                <transition activity="Execute_2" commented="0"

                    originalStyle="" points="" sourceX="318"

                    sourceY="53" status="0" style="defaultEdge"

                    targetX="315" targetY="116" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity commented="0" continueOnFailure="0"

                created="1471530954020" description=""

                displayName="Execute CCR Report" height="34"

                interactive="0" jobMode="0" name="Execute"

                namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                originalStyle="" skipAttempt="0"

                style="label;image=Execute" uniqueName="Execute_2"

                waitSetting="0" width="144" x="248" y="97">

                <inputs val="&lt;inputs>&lt;inputXml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&amp;lt;?xml version=&quot;1.0&quot; encoding=&quot;UTF-8&quot; standalone=&quot;no&quot; ?&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;TMMsg_CreateTaskReq&amp;gt;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;  &amp;lt;taskInfo&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;appGroup/&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;subTasks&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;options&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;adminOpts&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;reportOption&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;agentList&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;flags&amp;gt;&amp;#xD;&#xd;&#xa;                &amp;lt;include&amp;gt;true&amp;lt;/include&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;/flags&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;/agentList&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;ccReadinessReport&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;IncludeDisabledClients&amp;gt;false&amp;lt;/IncludeDisabledClients&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;indexCacheOption&amp;gt;true&amp;lt;/indexCacheOption&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;networkOption&amp;gt;true&amp;lt;/networkOption&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;resourceCapacityOption&amp;gt;true&amp;lt;/resourceCapacityOption&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;showFailedComponentsOnly&amp;gt;true&amp;lt;/showFailedComponentsOnly&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;/ccReadinessReport&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;commonOpt&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;dateFormat&amp;gt;mm/dd/yyyy&amp;lt;/dateFormat&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;locale&amp;gt;&amp;#xD;&#xd;&#xa;                &amp;lt;country&amp;gt;English&amp;lt;/country&amp;gt;&amp;#xD;&#xd;&#xa;                &amp;lt;language&amp;gt;UnitedStates&amp;lt;/language&amp;gt;&amp;#xD;&#xd;&#xa;                &amp;lt;localeName&amp;gt;en-us&amp;lt;/localeName&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;/locale&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;onCS&amp;gt;true&amp;lt;/onCS&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;outputFormat&amp;gt;&amp;#xD;&#xd;&#xa;                &amp;lt;isNetworkDrive&amp;gt;false&amp;lt;/isNetworkDrive&amp;gt;&amp;#xD;&#xd;&#xa;                &amp;lt;outputType&amp;gt;FULL_TEXT&amp;lt;/outputType&amp;gt;&amp;#xD;&#xd;&#xa;                &amp;lt;textDelimiter&amp;gt;,&amp;lt;/textDelimiter&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;/outputFormat&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;overrideDateTimeFormat&amp;gt;NONE&amp;lt;/overrideDateTimeFormat&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;reportCustomName&amp;gt;xpath:{/workflow/variables/reportName}.csv&amp;lt;/reportCustomName&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;reportType&amp;gt;COMMCELL_READINESS_REPORT&amp;lt;/reportType&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;summaryOnly&amp;gt;false&amp;lt;/summaryOnly&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;timeFormat&amp;gt;hh:mm:ss am/pm&amp;lt;/timeFormat&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;/commonOpt&amp;gt;&amp;#xD;&#xd;&#xa;            xpath:{/workflow/ProcessBlock_1/cglist}&amp;#xD;&#xd;&#xa;            &amp;lt;mediaAgentList&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;flags&amp;gt;&amp;#xD;&#xd;&#xa;                &amp;lt;include&amp;gt;true&amp;lt;/include&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;/flags&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;/mediaAgentList&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;/reportOption&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;/adminOpts&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/options&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;subTask&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;operationType&amp;gt;REPORT&amp;lt;/operationType&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;subTaskName&amp;gt;&amp;lt;/subTaskName&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;subTaskType&amp;gt;ADMIN&amp;lt;/subTaskType&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/subTask&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/subTasks&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;task&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;initiatedFrom&amp;gt;COMMANDLINE&amp;lt;/initiatedFrom&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;taskFlags&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;disabled&amp;gt;false&amp;lt;/disabled&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/taskFlags&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;taskType&amp;gt;IMMEDIATE&amp;lt;/taskType&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/task&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;/taskInfo&amp;gt;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&amp;lt;/TMMsg_CreateTaskReq&amp;gt;&amp;#xD;&#xd;&#xa;&lt;/inputXml>&lt;commandArgs class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

                <transition activity="XPathQuery_2" commented="0"

                    originalStyle="" points="" sourceX="327"

                    sourceY="112" status="0" style="defaultEdge"

                    targetX="321" targetY="163" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1471531087192"

                description="retrieves a list of values from xml"

                displayName="Get Report Jobid" height="34"

                interactive="0" jobMode="0" name="XPathQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=XPathQuery" uniqueName="XPathQuery_2"

                waitSetting="0" width="124" x="260" y="158">

                <inputs val="&lt;inputs>&lt;xml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/Execute_2/outputXml}&lt;/xml>&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>/TMMsg_CreateTaskResp/jobIds[1]/@val&lt;/xpath>&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;>String&lt;/outputType>&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/outputAsList>&lt;/inputs>"/>

                <transition activity="Decision_7" commented="0"

                    originalStyle="" points="" sourceX="322"

                    sourceY="175" status="0" style="defaultEdge"

                    targetX="325" targetY="242" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1471531181455"

                description="if/else based decision"

                displayName="Decision" height="74" interactive="0"

                jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_7"

                waitSetting="0" width="79" x="285" y="223">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/Execute_2/exitCode} == 0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="Break_1" commented="0"

                    displayName="Failed" originalStyle="" points=""

                    sourceX="324" sourceY="260" status="0"

                    style="defaultEdge" targetX="227" targetY="349"

                    transitionIndex="0" value="false" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="WaitForJobCompletion_2"

                    commented="0" displayName="Success" originalStyle=""

                    points="" sourceX="324" sourceY="260" status="0"

                    style="defaultEdge" targetX="142" targetY="256"

                    transitionIndex="0" value="true" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1471531253367"

                description="waits until the list of jobs completes"

                displayName="WaitForJobCompletion" height="34"

                interactive="0" jobMode="0" name="WaitForJobCompletion"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=WaitForJobCompletion"

                uniqueName="WaitForJobCompletion_2" waitSetting="0"

                width="159" x="63" y="245">

                <inputs val="&lt;inputs>&lt;jobId class=&quot;java.lang.Integer&quot; _list_=&quot;true&quot;>xpath:{/workflow/XPathQuery_2/result}&lt;/jobId>&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

                <transition activity="Script_2" commented="0"

                    originalStyle="" points="" sourceX="374"

                    sourceY="322" status="0" style="defaultEdge"

                    targetX="372" targetY="387" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1471531369790"

                description="interrupts a process block execution"

                displayName="Break" height="34" interactive="0"

                jobMode="0" name="Break"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.InterruptActivity"

                uniqueName="Break_1" waitSetting="0" width="100" x="277" y="424">

                <inputs val="&lt;inputs />"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1471531458770"

                description="activity to execute code snippets in the selected language"

                displayName="Save Files in Upload Dir" height="34"

                interactive="0" jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Script" uniqueName="Script_2"

                waitSetting="0" width="161" x="64" y="354">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;//Do this for each file in xpath:{/workflow/variables/destinationPath} matching xpath:{/workflow/variables/reportName}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;File dir = new File(xpath:{/workflow/variables/destinationPath});&amp;#xD;&amp;#xA;File[] foundFiles = dir.listFiles(new FilenameFilter() {&amp;#xD;&amp;#xA;    public boolean accept(File dir, String name) {&amp;#xD;&amp;#xA;        return name.startsWith(xpath:{/workflow/variables/reportName});&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;});&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;for (File afile : foundFiles) {&amp;#xD;&amp;#xA;    // Process file&amp;#xD;&amp;#xA;    //String tmpFileName = xpath:{/workflow/variables/reportName} + &amp;quot;.csv&amp;quot;;&amp;#xD;&amp;#xA;    //File afile = new File(xpath:{/workflow/variables/destinationPath} + &amp;quot;\\&amp;quot; + tmpFileName);&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    if (xpath:{/workflow/ProcessBlock_1/copyToPublic} == true)&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        //Copy to public upload folder&amp;#xD;&amp;#xA;        File publicFile = new File(xpath:{/workflow/variables/destinationPath} + &amp;quot;\\CommservSurvey\\publicupload\\&amp;quot; + afile.getName());&amp;#xD;&amp;#xA;        InputStream inStream = new FileInputStream(afile);&amp;#xD;&amp;#xA;        OutputStream outStream = new FileOutputStream(publicFile);&amp;#xD;&amp;#xA;        byte[] buffer = new byte[1024];&amp;#xD;&amp;#xA;        int length;&amp;#xD;&amp;#xA;        while ((length = inStream.read(buffer)) &amp;gt; 0){&amp;#xD;&amp;#xA;            outStream.write(buffer, 0, length);&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;        inStream.close();&amp;#xD;&amp;#xA;        outStream.close();&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    if(xpath:{/workflow/ProcessBlock_1/copyToPrivate} == true)&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        //Copy to private upload folder&amp;#xD;&amp;#xA;        File privateFile = new File(xpath:{/workflow/variables/destinationPath} + &amp;quot;\\CommservSurvey\\privateupload\\&amp;quot; + afile.getName());&amp;#xD;&amp;#xA;        InputStream inStream = new FileInputStream(afile);&amp;#xD;&amp;#xA;        OutputStream outStream = new FileOutputStream(privateFile);&amp;#xD;&amp;#xA;        byte[] buffer = new byte[1024];&amp;#xD;&amp;#xA;        int length;&amp;#xD;&amp;#xA;        while ((length = inStream.read(buffer)) &amp;gt; 0){&amp;#xD;&amp;#xA;            outStream.write(buffer, 0, length);&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;        inStream.close();&amp;#xD;&amp;#xA;        outStream.close();&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    afile.delete();        &amp;#xD;&amp;#xA;} &amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;&quot; />&lt;/inputs>"/>

                <transition activity="Break_1" commented="0"

                    originalStyle="" points="" sourceX="144"

                    sourceY="371" status="0" style="defaultEdge"

                    targetX="282" targetY="446" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

        </superProcess>

        <activitySchema>

            <outputs className="" defaultValue="" listType="0"

                name="outputs" type="">

                <children attribute="0" className="java.lang.Boolean"

                    controlType="5" defaultValue="" displayName=""

                    documentation="" hidden="0"

                    inputType="java.lang.Boolean" listType="0"

                    name="copyToPublic" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                <children attribute="0" className="java.lang.Boolean"

                    controlType="5" defaultValue="" displayName=""

                    documentation="" hidden="0"

                    inputType="java.lang.Boolean" listType="0"

                    name="copyToPrivate" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                <children attribute="0" className="java.lang.String"

                    controlType="0" defaultValue="" displayName=""

                    documentation="" hidden="0"

                    inputType="java.lang.String" listType="0"

                    name="cglist" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            </outputs>

            <inputs className="" defaultValue="" listType="0"

                name="inputs" type="">

                <children attribute="0" className="java.lang.Boolean"

                    controlType="5" defaultValue="" displayName=""

                    documentation="" hidden="0"

                    inputType="java.lang.Boolean" listType="0"

                    name="copyToPublic" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                <children attribute="0" className="java.lang.Boolean"

                    controlType="5" defaultValue="" displayName=""

                    documentation="" hidden="0"

                    inputType="java.lang.Boolean" listType="0"

                    name="copyToPrivate" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                <children attribute="0" className="java.lang.String"

                    controlType="0" defaultValue="" displayName=""

                    documentation="" hidden="0"

                    inputType="java.lang.String" listType="0"

                    name="cglist" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            </inputs>

        </activitySchema>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1471534587408" description="if/else based decision"

        displayName="Run Once?" height="100" interactive="0" jobMode="0"

        name="Decision" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_8" waitSetting="0" width="138" x="528" y="302">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>(xpath:{/workflow/variables/isPublicEnabled} == 1 &amp;amp;&amp;amp; xpath:{/workflow/variables/isPrivateEnabled} == 1) &amp;#xD;&#xd;&#xa;&amp;amp;&amp;amp; &amp;#xD;&#xd;&#xa;(xpath:{/workflow/variables/publicCG}.equals(xpath:{/workflow/variables/privateCG}))&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="ExecuteProcessBlock_1" commented="0"

            displayName="Yes" originalStyle="" status="0"

            style="defaultEdge" transitionIndex="0" value="true" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="Decision_9" commented="0" displayName="No"

            originalStyle="" sourceX="599" sourceY="408" status="0"

            style="defaultEdge" targetX="842" targetY="391"

            transitionIndex="0" value="false" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1471536175943"

        description="executes a defined process block within the workflow"

        displayName="Execute Both Public and Private" height="34"

        interactive="0" jobMode="0" name="ExecuteProcessBlock"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.ExecuteSuperProcess"

        uniqueName="ExecuteProcessBlock_1" waitSetting="0" width="200"

        x="499" y="445">

        <inputs val="&lt;inputs>&lt;inputs>&lt;copyToPublic class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/copyToPublic>&lt;copyToPrivate class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/copyToPrivate>&lt;cglist class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/publicCG}&lt;/cglist>&lt;/inputs>&lt;processBlock>ProcessBlock_1&lt;/processBlock>&lt;outputs />&lt;/inputs>"/>

        <activitySchema>

            <outputs name="ProcessBlock_1">

                <children name="Start_2"/>

                <children name="Execute_2">

                    <children className="java.lang.String"

                        documentation="xml output contents"

                        inputType="java.lang.String" name="outputXml" type="{http://www.w3.org/2001/XMLSchema}string"/>

                    <children className="java.lang.Integer"

                        documentation="return code from the executable"

                        inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                    <children className="java.lang.String"

                        documentation="command output"

                        inputType="java.lang.String"

                        name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string"/>

                </children>

                <children name="XPathQuery_2">

                    <children className="java.lang.Object"

                        inputType="java.lang.Object" listType="0"

                        name="result" type="{http://www.w3.org/2001/XMLSchema}string"/>

                </children>

                <children className="" defaultValue="" listType="0"

                    name="Decision_7" type=""/>

                <children name="WaitForJobCompletion_2">

                    <children className="java.lang.Integer"

                        inputType="java.lang.Integer" listType="1"

                        name="successfullJobs" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                    <children className="java.lang.Integer"

                        inputType="java.lang.Integer" listType="1"

                        name="failedJobs" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                    <children className="java.lang.Boolean"

                        inputType="java.lang.Boolean" name="successful" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                    <children className="java.lang.Integer"

                        documentation="return code from the executable"

                        inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                    <children className="java.lang.String"

                        documentation="command output"

                        inputType="java.lang.String"

                        name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string"/>

                </children>

                <children name="Break_1"/>

                <children name="Script_2">

                    <children className="java.lang.Object"

                        inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                </children>

            </outputs>

            <inputs className="" defaultValue="" listType="0"

                name="inputs" type="">

                <children attribute="0" className="java.lang.Boolean"

                    controlType="5" defaultValue="" displayName=""

                    documentation="" hidden="0"

                    inputType="java.lang.Boolean" listType="0"

                    name="copyToPublic" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                <children attribute="0" className="java.lang.Boolean"

                    controlType="5" defaultValue="" displayName=""

                    documentation="" hidden="0"

                    inputType="java.lang.Boolean" listType="0"

                    name="copyToPrivate" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                <children attribute="0" className="java.lang.String"

                    controlType="0" defaultValue="" displayName=""

                    documentation="" hidden="0"

                    inputType="java.lang.String" listType="0"

                    name="cglist" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            </inputs>

        </activitySchema>

        <transition activity="WorkflowEnd_2" commented="0"

            originalStyle="" sourceX="615" sourceY="548" status="0"

            style="defaultEdge" targetX="388" targetY="550"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1471536279904" description="if/else based decision"

        displayName="Execute Public?" height="100" interactive="0"

        jobMode="0" name="Decision"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_9" waitSetting="0" width="121" x="692" y="206">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/isPublicEnabled} == 1 &lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="Decision_10" commented="0"

            displayName="No" originalStyle="" sourceX="813"

            sourceY="410" status="0" style="defaultEdge" targetX="922"

            targetY="535" transitionIndex="0" value="false" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="ExecuteProcessBlock_2" commented="0"

            displayName="Yes" originalStyle="" status="0"

            style="defaultEdge" transitionIndex="0" value="true" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1471536360954"

        description="executes a defined process block within the workflow"

        displayName="Execute Public" height="34" interactive="0"

        jobMode="0" name="ExecuteProcessBlock"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.ExecuteSuperProcess"

        uniqueName="ExecuteProcessBlock_2" waitSetting="0" width="156"

        x="871" y="235">

        <inputs val="&lt;inputs>&lt;inputs>&lt;copyToPublic class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/copyToPublic>&lt;copyToPrivate class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/copyToPrivate>&lt;cglist class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/publicCG}&lt;/cglist>&lt;/inputs>&lt;processBlock>ProcessBlock_1&lt;/processBlock>&lt;outputs />&lt;/inputs>"/>

        <activitySchema>

            <outputs name="ProcessBlock_1">

                <children name="Start_2"/>

                <children name="Execute_2">

                    <children className="java.lang.String"

                        documentation="xml output contents"

                        inputType="java.lang.String" name="outputXml" type="{http://www.w3.org/2001/XMLSchema}string"/>

                    <children className="java.lang.Integer"

                        documentation="return code from the executable"

                        inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                    <children className="java.lang.String"

                        documentation="command output"

                        inputType="java.lang.String"

                        name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string"/>

                </children>

                <children name="XPathQuery_2">

                    <children className="java.lang.Object"

                        inputType="java.lang.Object" listType="0"

                        name="result" type="{http://www.w3.org/2001/XMLSchema}string"/>

                </children>

                <children className="" defaultValue="" listType="0"

                    name="Decision_7" type=""/>

                <children name="WaitForJobCompletion_2">

                    <children className="java.lang.Integer"

                        inputType="java.lang.Integer" listType="1"

                        name="successfullJobs" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                    <children className="java.lang.Integer"

                        inputType="java.lang.Integer" listType="1"

                        name="failedJobs" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                    <children className="java.lang.Boolean"

                        inputType="java.lang.Boolean" name="successful" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                    <children className="java.lang.Integer"

                        documentation="return code from the executable"

                        inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                    <children className="java.lang.String"

                        documentation="command output"

                        inputType="java.lang.String"

                        name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string"/>

                </children>

                <children name="Break_1"/>

                <children name="Script_2">

                    <children className="java.lang.Object"

                        inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                </children>

            </outputs>

            <inputs className="" defaultValue="" listType="0"

                name="inputs" type="">

                <children attribute="0" className="java.lang.Boolean"

                    controlType="5" defaultValue="" displayName=""

                    documentation="" hidden="0"

                    inputType="java.lang.Boolean" listType="0"

                    name="copyToPublic" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                <children attribute="0" className="java.lang.Boolean"

                    controlType="5" defaultValue="" displayName=""

                    documentation="" hidden="0"

                    inputType="java.lang.Boolean" listType="0"

                    name="copyToPrivate" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                <children attribute="0" className="java.lang.String"

                    controlType="0" defaultValue="" displayName=""

                    documentation="" hidden="0"

                    inputType="java.lang.String" listType="0"

                    name="cglist" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            </inputs>

        </activitySchema>

        <transition activity="Decision_10" commented="0"

            originalStyle="" sourceX="1011" sourceY="411" status="0"

            style="defaultEdge" targetX="967" targetY="527"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1471536418672" description="if/else based decision"

        displayName="Execute Private?" height="100" interactive="0"

        jobMode="0" name="Decision"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_10" waitSetting="0" width="177" x="755" y="318">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/isPrivateEnabled} == 1 &lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="WorkflowEnd_2" commented="0"

            displayName="No" originalStyle="" sourceX="839"

            sourceY="368" status="0" style="defaultEdge" targetX="838"

            targetY="636" transitionIndex="0" value="false" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="ExecuteProcessBlock_3" commented="0"

            displayName="Yes" originalStyle="" status="0"

            style="defaultEdge" transitionIndex="0" value="true" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1471536581654"

        description="executes a defined process block within the workflow"

        displayName="Execute Private" height="34" interactive="0"

        jobMode="0" name="ExecuteProcessBlock"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.ExecuteSuperProcess"

        uniqueName="ExecuteProcessBlock_3" waitSetting="0" width="156"

        x="883" y="452">

        <inputs val="&lt;inputs>&lt;inputs>&lt;copyToPublic class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/copyToPublic>&lt;copyToPrivate class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/copyToPrivate>&lt;cglist class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/privateCG}&lt;/cglist>&lt;/inputs>&lt;processBlock>ProcessBlock_1&lt;/processBlock>&lt;outputs />&lt;/inputs>"/>

        <activitySchema>

            <outputs name="ProcessBlock_1">

                <children name="Start_2"/>

                <children name="Execute_2">

                    <children className="java.lang.String"

                        documentation="xml output contents"

                        inputType="java.lang.String" name="outputXml" type="{http://www.w3.org/2001/XMLSchema}string"/>

                    <children className="java.lang.Integer"

                        documentation="return code from the executable"

                        inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                    <children className="java.lang.String"

                        documentation="command output"

                        inputType="java.lang.String"

                        name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string"/>

                </children>

                <children name="XPathQuery_2">

                    <children className="java.lang.Object"

                        inputType="java.lang.Object" listType="0"

                        name="result" type="{http://www.w3.org/2001/XMLSchema}string"/>

                </children>

                <children className="" defaultValue="" listType="0"

                    name="Decision_7" type=""/>

                <children name="WaitForJobCompletion_2">

                    <children className="java.lang.Integer"

                        inputType="java.lang.Integer" listType="1"

                        name="successfullJobs" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                    <children className="java.lang.Integer"

                        inputType="java.lang.Integer" listType="1"

                        name="failedJobs" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                    <children className="java.lang.Boolean"

                        inputType="java.lang.Boolean" name="successful" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                    <children className="java.lang.Integer"

                        documentation="return code from the executable"

                        inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                    <children className="java.lang.String"

                        documentation="command output"

                        inputType="java.lang.String"

                        name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string"/>

                </children>

                <children name="Break_1"/>

                <children name="Script_2">

                    <children className="java.lang.Object"

                        inputType="java.lang.Object" name="output" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                </children>

            </outputs>

            <inputs className="" defaultValue="" listType="0"

                name="inputs" type="">

                <children attribute="0" className="java.lang.Boolean"

                    controlType="5" defaultValue="" displayName=""

                    documentation="" hidden="0"

                    inputType="java.lang.Boolean" listType="0"

                    name="copyToPublic" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                <children attribute="0" className="java.lang.Boolean"

                    controlType="5" defaultValue="" displayName=""

                    documentation="" hidden="0"

                    inputType="java.lang.Boolean" listType="0"

                    name="copyToPrivate" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                <children attribute="0" className="java.lang.String"

                    controlType="0" defaultValue="" displayName=""

                    documentation="" hidden="0"

                    inputType="java.lang.String" listType="0"

                    name="cglist" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            </inputs>

        </activitySchema>

        <transition activity="WorkflowEnd_2" commented="0"

            originalStyle="" sourceX="990" sourceY="463" status="0"

            style="defaultEdge" targetX="928" targetY="621"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

</workflow>'

IF not exists (select * from WF_Definition where Name = @name)

BEGIN
	INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision)


	VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision)

	SET @workflowId = @@IDENTITY
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


	VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

	SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = ISNULL(revision, '') From WF_Definition WHERE Name = @name

	IF (@currentFlags & 4 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0) AND (@currentRevision <> @revision)

	BEGIN

		SET @version = @version + 1

		UPDATE WF_Definition

		SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision

		WHERE Name = @name

		IF (@flags & 8 > 0 OR @flags & 16 > 0)

		BEGIN

			UPDATE WF_Definition

			SET flags = @flags

			WHERE Name = @name

		END
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


		VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

	END

END


