

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_CloneOperations.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/WFD_CloneOperations.script,v $ $Id: WFD_CloneOperations.script,v 1.5.2.3 2020/10/04 01:03:35 abilbrey Exp $";
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER ON

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @oldName nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.5.2.3 $'

SET @name = 'Snap-TestCloneOperations'

SET @oldName = 'CloneOperations'

SET @description = 'Used for operations other than creating test clones, for example, extend and delete.'

SET @version = 1

SET @flags = 30

SET @definition = '<workflow apiMode="0"

    description="Used for operations other than creating test clones, for example, extend and delete."

    inputSchema="&lt;xs:schema xmlns:xs=&quot;http://www.w3.org/2001/XMLSchema&quot; xmlns:tns=&quot;S_34096e1f-d12c-4ac1-b8e5-f6b844057dc6&quot; targetNamespace=&quot;S_34096e1f-d12c-4ac1-b8e5-f6b844057dc6&quot;>&lt;xs:element name=&quot;inputs&quot;>&lt;xs:complexType>&lt;xs:sequence>&lt;xs:element name=&quot;reserveParam1&quot; type=&quot;xs:integer&quot; minOccurs=&quot;0&quot; default=&quot;&quot;>&lt;xs:annotation>&lt;xs:appinfo>&lt;readOnly>false&lt;/readOnly>&lt;displayName>&lt;/displayName>&lt;controlType>TEXTBOX&lt;/controlType>&lt;/xs:appinfo>&lt;xs:documentation>&lt;/xs:documentation>&lt;/xs:annotation>&lt;/xs:element>&lt;xs:element name=&quot;reserveParam2&quot; type=&quot;xs:integer&quot; minOccurs=&quot;0&quot; default=&quot;&quot;>&lt;xs:annotation>&lt;xs:appinfo>&lt;readOnly>false&lt;/readOnly>&lt;displayName>&lt;/displayName>&lt;controlType>TEXTBOX&lt;/controlType>&lt;/xs:appinfo>&lt;xs:documentation>&lt;/xs:documentation>&lt;/xs:annotation>&lt;/xs:element>&lt;xs:element name=&quot;strReserveParam&quot; type=&quot;xs:string&quot; minOccurs=&quot;0&quot; default=&quot;&quot;>&lt;xs:annotation>&lt;xs:appinfo>&lt;readOnly>false&lt;/readOnly>&lt;displayName>&lt;/displayName>&lt;controlType>TEXTBOX&lt;/controlType>&lt;/xs:appinfo>&lt;xs:documentation>&lt;/xs:documentation>&lt;/xs:annotation>&lt;/xs:element>&lt;xs:element name=&quot;userId&quot; type=&quot;xs:integer&quot; minOccurs=&quot;0&quot; default=&quot;&quot;>&lt;xs:annotation>&lt;xs:appinfo>&lt;readOnly>false&lt;/readOnly>&lt;displayName>&lt;/displayName>&lt;controlType>TEXTBOX&lt;/controlType>&lt;/xs:appinfo>&lt;xs:documentation>&lt;/xs:documentation>&lt;/xs:annotation>&lt;/xs:element>&lt;xs:element name=&quot;InputXml&quot; type=&quot;xs:string&quot; minOccurs=&quot;0&quot; default=&quot;&quot;>&lt;xs:annotation>&lt;xs:appinfo>&lt;readOnly>false&lt;/readOnly>&lt;displayName>&lt;/displayName>&lt;controlType>TEXTBOX&lt;/controlType>&lt;/xs:appinfo>&lt;xs:documentation>&lt;/xs:documentation>&lt;/xs:annotation>&lt;/xs:element>&lt;/xs:sequence>&lt;/xs:complexType>&lt;/xs:element>&lt;/xs:schema>"

    inputs="&lt;inputs>&lt;reserveParam1 class=&quot;java.lang.Integer&quot; />&lt;reserveParam2 class=&quot;java.lang.Integer&quot; />&lt;strReserveParam class=&quot;java.lang.String&quot; />&lt;userId class=&quot;java.lang.Integer&quot; />&lt;InputXml class=&quot;java.lang.String&quot; />&lt;/inputs>"

    interactive="0" isHtmlDescription="0"

    name="Snap-TestCloneOperations"

    outputSchema="&lt;xs:schema xmlns:xs=&quot;http://www.w3.org/2001/XMLSchema&quot; xmlns:tns=&quot;S_aaa9cccf-18b5-4008-9511-fba3bf0d9663&quot; targetNamespace=&quot;S_aaa9cccf-18b5-4008-9511-fba3bf0d9663&quot;>&lt;xs:element name=&quot;outputs&quot;>&lt;xs:complexType>&lt;xs:sequence />&lt;/xs:complexType>&lt;/xs:element>&lt;/xs:schema>"

    outputs="&lt;outputs />" revision="$Revision: 1.5.2.3 $"

    uniqueGuid="e29cee2e-11f3-4102-9e61-129b508d3f16"

    variableSchema="&lt;xs:schema xmlns:xs=&quot;http://www.w3.org/2001/XMLSchema&quot; xmlns:tns=&quot;S_0d4034cf-9c08-4a19-a702-d8378c2546d8&quot; targetNamespace=&quot;S_0d4034cf-9c08-4a19-a702-d8378c2546d8&quot;>&lt;xs:element name=&quot;variables&quot;>&lt;xs:complexType>&lt;xs:sequence>&lt;xs:element name=&quot;strErrorCode&quot; type=&quot;xs:string&quot; minOccurs=&quot;0&quot; default=&quot;&quot;>&lt;xs:annotation>&lt;xs:appinfo>&lt;readOnly>false&lt;/readOnly>&lt;displayName>&lt;/displayName>&lt;controlType>TEXTBOX&lt;/controlType>&lt;/xs:appinfo>&lt;xs:documentation>&lt;/xs:documentation>&lt;/xs:annotation>&lt;/xs:element>&lt;xs:element name=&quot;strErrorMessage&quot; type=&quot;xs:string&quot; minOccurs=&quot;0&quot; default=&quot;&quot;>&lt;xs:annotation>&lt;xs:appinfo>&lt;readOnly>false&lt;/readOnly>&lt;displayName>&lt;/displayName>&lt;controlType>TEXTBOX&lt;/controlType>&lt;/xs:appinfo>&lt;xs:documentation>&lt;/xs:documentation>&lt;/xs:annotation>&lt;/xs:element>&lt;xs:element name=&quot;opType&quot; type=&quot;xs:string&quot; minOccurs=&quot;0&quot; default=&quot;&quot;>&lt;xs:annotation>&lt;xs:appinfo>&lt;readOnly>false&lt;/readOnly>&lt;displayName>&lt;/displayName>&lt;controlType>TEXTBOX&lt;/controlType>&lt;/xs:appinfo>&lt;xs:documentation>&lt;/xs:documentation>&lt;/xs:annotation>&lt;/xs:element>&lt;xs:element name=&quot;inputOpData&quot; type=&quot;xs:string&quot; minOccurs=&quot;0&quot; maxOccurs=&quot;unbounded&quot; default=&quot;&quot;>&lt;xs:annotation>&lt;xs:appinfo>&lt;readOnly>false&lt;/readOnly>&lt;displayName>&lt;/displayName>&lt;controlType>TEXTBOX&lt;/controlType>&lt;/xs:appinfo>&lt;xs:documentation>&lt;/xs:documentation>&lt;/xs:annotation>&lt;/xs:element>&lt;xs:element name=&quot;tempExtendPeriod&quot; type=&quot;xs:string&quot; minOccurs=&quot;0&quot; default=&quot;&quot;>&lt;xs:annotation>&lt;xs:appinfo>&lt;readOnly>false&lt;/readOnly>&lt;displayName>&lt;/displayName>&lt;controlType>TEXTBOX&lt;/controlType>&lt;/xs:appinfo>&lt;xs:documentation>&lt;/xs:documentation>&lt;/xs:annotation>&lt;/xs:element>&lt;xs:element name=&quot;numberOfRequests&quot; type=&quot;xs:integer&quot; minOccurs=&quot;0&quot; default=&quot;&quot;>&lt;xs:annotation>&lt;xs:appinfo>&lt;readOnly>false&lt;/readOnly>&lt;displayName>&lt;/displayName>&lt;controlType>TEXTBOX&lt;/controlType>&lt;/xs:appinfo>&lt;xs:documentation>&lt;/xs:documentation>&lt;/xs:annotation>&lt;/xs:element>&lt;xs:element name=&quot;strSnapBackupOperationRequest&quot; type=&quot;xs:string&quot; minOccurs=&quot;0&quot; default=&quot;&quot;>&lt;xs:annotation>&lt;xs:appinfo>&lt;readOnly>false&lt;/readOnly>&lt;displayName>&lt;/displayName>&lt;controlType>TEXTBOX&lt;/controlType>&lt;/xs:appinfo>&lt;xs:documentation>&lt;/xs:documentation>&lt;/xs:annotation>&lt;/xs:element>&lt;xs:element name=&quot;snapOperationWFJobIDs&quot; type=&quot;xs:integer&quot; minOccurs=&quot;0&quot; maxOccurs=&quot;unbounded&quot; default=&quot;&quot;>&lt;xs:annotation>&lt;xs:appinfo>&lt;readOnly>false&lt;/readOnly>&lt;displayName>&lt;/displayName>&lt;controlType>TEXTBOX&lt;/controlType>&lt;/xs:appinfo>&lt;xs:documentation>&lt;/xs:documentation>&lt;/xs:annotation>&lt;/xs:element>&lt;/xs:sequence>&lt;/xs:complexType>&lt;/xs:element>&lt;/xs:schema>"

    variables="&lt;variables>&lt;strErrorCode class=&quot;java.lang.String&quot; />&lt;strErrorMessage class=&quot;java.lang.String&quot; />&lt;opType class=&quot;java.lang.String&quot; />&lt;inputOpData class=&quot;java.lang.String&quot; _list_=&quot;true&quot; />&lt;tempExtendPeriod class=&quot;java.lang.String&quot; />&lt;numberOfRequests class=&quot;java.lang.Integer&quot; />&lt;strSnapBackupOperationRequest class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;snapOperationWFJobIDs class=&quot;java.lang.Integer&quot; _list_=&quot;true&quot; />&lt;/variables>" workflowId="0">

    <Start commented="0" continueOnFailure="0" created="0"

        description="" displayName="Start" height="44" interactive="0"

        name="Start" originalStyle="" skipAttempt="0"

        style="image;image=/images/jgraphx/house.png"

        uniqueName="Start_1" waitSetting="0" width="61" x="2" y="303">

        <inputs val="&lt;inputs />"/>

        <transition activity="ImpersonateCreator_1" commented="0"

            originalStyle="" points="" sourceX="26" sourceY="462"

            status="0" style="defaultEdge" targetX="140" targetY="351"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Start>

    <Activity commented="0" continueOnFailure="0"

        created="1384535327606"

        description="activity to execute code snippets in the selected language"

        displayName="Parse Input Xml" height="34" interactive="0"

        maxRestarts="0" name="Script"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Script"

        uniqueName="Script_6" waitSetting="0" width="136" x="270" y="308">

        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;import commvault.msgs.EVGui.CloneOperationReq;&amp;#xD;&amp;#xA;import commvault.msgs.EVGui.CloneOperationInput;&amp;#xD;&amp;#xA;import commvault.cte.common.xml.XMLDecoder;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;try &amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    CloneOperationReq oCloneOperationReq = (CloneOperationReq)XMLDecoder.decode(xpath:{/workflow/inputs/InputXml});&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    int opInputListSize = oCloneOperationReq.getOpInput().size();&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;    String [] inputOpData = new String[opInputListSize];&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;numberOfRequests&amp;quot;, opInputListSize);&amp;#xD;&amp;#xA;    logger.info (&amp;quot;numberOfRequests&amp;quot; + Integer.toString(opInputListSize));&amp;#xD;&amp;#xA;    if( opInputListSize == 0)&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        workflow.setFailed(&amp;quot;No clone job ids passed for clone operation.&amp;quot;);&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    for (int temp = 0; temp &amp;lt; opInputListSize; temp++) &amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;       CloneOperationInput oCloneOperationInput = oCloneOperationReq.getOpInput().get(temp);&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;       if (oCloneOperationInput!= null)&amp;#xD;&amp;#xA;       {&amp;#xD;&amp;#xA;           if ( oCloneOperationReq.getOpType().getEnumValue() == 0 ) // EXTEND&amp;#xD;&amp;#xA;           {&amp;#xD;&amp;#xA;                String data = Integer.toString(oCloneOperationInput.getCloneJobId());// + &amp;quot;-&amp;quot; + Integer.toString(oCloneOperationInput.getExtendPeriod());&amp;#xD;&amp;#xA;                workflow.setVariable(&amp;quot;tempExtendPeriod&amp;quot;, oCloneOperationInput.getExtendPeriod());&amp;#xD;&amp;#xA;                inputOpData[temp]  = data;&amp;#xD;&amp;#xA;                logger.info(&amp;quot;data for extend:&amp;quot; + data);&amp;#xD;&amp;#xA;           }&amp;#xD;&amp;#xA;           else&amp;#xD;&amp;#xA;           {&amp;#xD;&amp;#xA;                String data = Integer.toString(oCloneOperationInput.getCloneJobId());&amp;#xD;&amp;#xA;                inputOpData[temp]  = data;&amp;#xD;&amp;#xA;                logger.info(&amp;quot;data for delete:&amp;quot; + data);&amp;#xD;&amp;#xA;           }                   &amp;#xD;&amp;#xA;       }&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#x9; &amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;inputOpData&amp;quot;,inputOpData);&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;opType&amp;quot;, oCloneOperationReq.getOpType().getEnumValue());      &amp;#xD;&amp;#xA;} &amp;#xD;&amp;#xA;catch (Exception e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    workflow.setFailed(&amp;quot;Error in parsing the clone operation request. Error Details:&amp;quot;+ e.getMessage());         &amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&quot; />&lt;/inputs>"/>

        <transition activity="Switch_1" commented="0" originalStyle=""

            points="" sourceX="208" sourceY="462" status="0"

            style="defaultEdge" targetX="420" targetY="473"

            transitionIndex="0" x="-51" y="364">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1384546753028" description="switch based decision"

        displayName="Switch" height="100" interactive="0" name="Switch"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Switch_1" waitSetting="0" width="100" x="424" y="274">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/opType}&lt;/expression>&lt;/inputs>"/>

        <transition activity="ForEach_2" commented="0"

            displayName="Extend" originalStyle="" points=""

            sourceX="477" sourceY="98" status="0" style="defaultEdge"

            targetX="797" targetY="38" transitionIndex="0" value="0"

            x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="ForEach_3" commented="0"

            displayName="Delete" originalStyle="" points=""

            sourceX="426" sourceY="462" status="0" style="defaultEdge"

            targetX="705" targetY="469" transitionIndex="0" value="1"

            x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <onEnter language="1" script="logger.info (&quot;tempExtendPeriod:&quot; + xpath:{/workflow/variables/tempExtendPeriod});"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1384548445601"

        description="iterates a group of activities over a list of values"

        displayName="Extend a clone" height="368" interactive="0"

        name="ForEach" namespaceUri="commvault.cte.workflow.activities"

        originalStyle=""

        schema="&lt;xs:schema xmlns:xs=&quot;http://www.w3.org/2001/XMLSchema&quot; xmlns:tns=&quot;S_6079ef33-90b9-4a98-9e84-b753eeeee94c&quot; targetNamespace=&quot;S_6079ef33-90b9-4a98-9e84-b753eeeee94c&quot;>&lt;xs:complexType name=&quot;ForEach&quot;>&lt;xs:sequence>&lt;xs:element name=&quot;inputs&quot;>&lt;xs:complexType>&lt;xs:sequence>&lt;xs:element name=&quot;name&quot; type=&quot;xs:string&quot; minOccurs=&quot;0&quot; default=&quot;&quot;>&lt;xs:annotation>&lt;xs:appinfo>&lt;readOnly>false&lt;/readOnly>&lt;displayName>&lt;/displayName>&lt;/xs:appinfo>&lt;xs:documentation>&lt;/xs:documentation>&lt;/xs:annotation>&lt;/xs:element>&lt;xs:element name=&quot;values&quot; type=&quot;xs:anyType&quot; minOccurs=&quot;0&quot; default=&quot;&quot;>&lt;xs:annotation>&lt;xs:appinfo>&lt;readOnly>false&lt;/readOnly>&lt;displayName>&lt;/displayName>&lt;/xs:appinfo>&lt;xs:documentation>&lt;/xs:documentation>&lt;/xs:annotation>&lt;/xs:element>&lt;xs:element name=&quot;numberOfParallelExecutions&quot; type=&quot;xs:integer&quot; minOccurs=&quot;0&quot; default=&quot;1&quot;>&lt;xs:annotation>&lt;xs:appinfo>&lt;readOnly>false&lt;/readOnly>&lt;displayName>&lt;/displayName>&lt;/xs:appinfo>&lt;xs:documentation>&lt;/xs:documentation>&lt;/xs:annotation>&lt;/xs:element>&lt;xs:element name=&quot;continueOnFailure&quot; type=&quot;xs:boolean&quot; minOccurs=&quot;0&quot; default=&quot;false&quot;>&lt;xs:annotation>&lt;xs:appinfo>&lt;readOnly>false&lt;/readOnly>&lt;displayName>&lt;/displayName>&lt;/xs:appinfo>&lt;xs:documentation>&lt;/xs:documentation>&lt;/xs:annotation>&lt;/xs:element>&lt;/xs:sequence>&lt;/xs:complexType>&lt;/xs:element>&lt;xs:element name=&quot;outputs&quot;>&lt;xs:complexType>&lt;xs:sequence>&lt;xs:element name=&quot;inputOpData&quot; type=&quot;xs:string&quot; minOccurs=&quot;0&quot; default=&quot;&quot;>&lt;xs:annotation>&lt;xs:appinfo>&lt;readOnly>false&lt;/readOnly>&lt;displayName>&lt;/displayName>&lt;controlType>TEXTBOX&lt;/controlType>&lt;/xs:appinfo>&lt;xs:documentation>&lt;/xs:documentation>&lt;/xs:annotation>&lt;/xs:element>&lt;/xs:sequence>&lt;/xs:complexType>&lt;/xs:element>&lt;/xs:sequence>&lt;/xs:complexType>&lt;/xs:schema>"

        skipAttempt="0" style="swimlane" uniqueName="ForEach_2"

        waitSetting="0" width="488" x="650" y="24">

        <inputs val="&lt;inputs>&lt;name class=&quot;java.lang.String&quot;>inputOpData&lt;/name>&lt;values class=&quot;java.lang.Object&quot;>xpath:{/workflow/variables/inputOpData}&lt;/values>&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot;>1&lt;/numberOfParallelExecutions>&lt;continueOnFailure class=&quot;java.lang.Boolean&quot;>true&lt;/continueOnFailure>&lt;/inputs>"/>

        <superProcess>

            <Start commented="0" continueOnFailure="0"

                created="1384548445601" description=""

                displayName="Start" height="30" interactive="0"

                name="Start" originalStyle="" skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_6" waitSetting="0" width="120" x="23" y="33">

                <inputs val="&lt;inputs />"/>

                <transition activity="CommServDBQuery_1" commented="0"

                    originalStyle="" points="" sourceX="83" sourceY="48"

                    status="0" style="defaultEdge" targetX="347"

                    targetY="44" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <onEnter language="1" script="workflow.setVariable(&quot;strSnapBackupOperationRequest&quot;,&quot;&quot;);"/>

            </Start>

            <Activity commented="0" continueOnFailure="0"

                created="1384551258385"

                description="executes queries against the commserv database"

                displayName="Get Clone Details" height="34"

                interactive="0" name="CommServDBQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=CommServDBQuery"

                uniqueName="CommServDBQuery_1" waitSetting="0"

                width="162" x="222" y="31">

                <inputs val="&lt;inputs>&lt;commCell />&lt;query>SELECT&#x9;&#x9;MVOL.CommCellId, MVOL.Id, MVOL.SMVolumeId&amp;#xD;&#xd;&#xa;FROM&#x9;&#x9;SMMountVolume MVOL (NOLOCK)&amp;#xD;&#xd;&#xa;WHERE&#x9;&#x9;MVOL.MountJobId=xpath:{/workflow/ForEach_2/inputOpData}&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;SELECT TOP 1 VOL.SourceClientId FROM SMMountVolume MVOL (NOLOCK) INNER JOIN SMVolume VOL (NOLOCK) ON MVOL.SMVolumeId = VOL.SMVolumeId WHERE&#x9;MVOL.MountJobId=xpath:{/workflow/ForEach_2/inputOpData}&lt;/query>&lt;/inputs>"/>

                <transition activity="Script_9" commented="0"

                    originalStyle="" points="" sourceX="331"

                    sourceY="156" status="0" style="defaultEdge"

                    targetX="342" targetY="257" transitionIndex="0"

                    x="30" y="101">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1384551352096"

                description="activity to execute code snippets in the selected language"

                displayName="Set Clone Details" height="34"

                interactive="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Script" uniqueName="Script_9"

                waitSetting="0" width="143" x="234" y="99">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;import commvault.msgs.EVGui.SnapBackupOperationRequest;&amp;#xD;&amp;#xA;import commvault.msgs.EVGui.VolSnapEntity;&amp;#xD;&amp;#xA;import commvault.msgs.EVGui.AppId;&amp;#xD;&amp;#xA;import commvault.cte.common.xml.XMLEncoder;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    int rows = xpath:{/workflow/CommServDBQuery_1/resultSets[1]/rowCount};&amp;#xD;&amp;#xA;&amp;#x9;int rows2 = xpath:{/workflow/CommServDBQuery_1/resultSets[2]/rowCount};&amp;#xD;&amp;#xA;    if (rows == 0)&amp;#xD;&amp;#xA;    {   &amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;workflow.setFailed(&amp;quot;No details found for clone job id:&amp;quot; + xpath:{/workflow/ForEach_2/inputOpData}); &amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    if (rows2 == 0)&amp;#xD;&amp;#xA;    {  &amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;workflow.setFailed(&amp;quot;No source details found for clone job id:&amp;quot; + xpath:{/workflow/ForEach_2/inputOpData}); &amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;&amp;#x9;&amp;#xD;&amp;#xA;&amp;#x9;SnapBackupOperationRequest oSnapBackupOperationRequest = new SnapBackupOperationRequest();&amp;#xD;&amp;#xA;    oSnapBackupOperationRequest.setOperation(4);&amp;#xD;&amp;#xA;    oSnapBackupOperationRequest.setReserveField(xpath:{/workflow/variables/tempExtendPeriod});&amp;#xD;&amp;#xA;                &amp;#xD;&amp;#xA;    List oSnapSnotIds = new ArrayList();&amp;#xD;&amp;#xA;    List oVolSnapEntityList = new ArrayList();&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    DataSet ds = xpath:{/workflow/CommServDBQuery_1/resultSets}.get(0);&amp;#xD;&amp;#xA;    while (ds.hasNext()){&amp;#xD;&amp;#xA;        oSnapSnotIds.add(ds.get(&amp;quot;Id&amp;quot;));&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        VolSnapEntity oVolSnapEntity = new VolSnapEntity();&amp;#xD;&amp;#xA;        oVolSnapEntity.setCommCellId(ds.get(&amp;quot;CommCellId&amp;quot;));&amp;#xD;&amp;#xA;        oVolSnapEntity.setVolumeId(ds.get(&amp;quot;SMVolumeId&amp;quot;));&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        oVolSnapEntityList.add(oVolSnapEntity);&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    oSnapBackupOperationRequest.setSnapShotId(oSnapSnotIds);&amp;#xD;&amp;#xA;    oSnapBackupOperationRequest.setVolumes(oVolSnapEntityList);&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;    DataSet ds2 = xpath:{/workflow/CommServDBQuery_1/resultSets}.get(1);&amp;#xD;&amp;#xA;    while (ds2.hasNext()){&amp;#xD;&amp;#xA;        AppId oAppId = new AppId();&amp;#xD;&amp;#xA;        oAppId.setClientId(ds2.get(&amp;quot;SourceClientId&amp;quot;));&amp;#xD;&amp;#xA;        oSnapBackupOperationRequest.setAppId(oAppId); &amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;&amp;#x9;&amp;#xD;&amp;#xA;    String strSnapBackupOperationRequest= &amp;quot;&amp;quot;; &amp;#xD;&amp;#xA;    try {&amp;#xD;&amp;#xA;        strSnapBackupOperationRequest = XMLEncoder.encode(oSnapBackupOperationRequest);&amp;#xD;&amp;#xA;        workflow.setVariable(&amp;quot;strSnapBackupOperationRequest&amp;quot;,strSnapBackupOperationRequest);&amp;#xD;&amp;#xA;        logger.info(&amp;quot;strSnapBackupOperationRequest:::&amp;quot; + strSnapBackupOperationRequest);&amp;#xD;&amp;#xA;    } catch (Exception excep) {&amp;#xD;&amp;#xA;        logger.info(excep.getMessage());&amp;#xD;&amp;#xA;        workflow.setFailed(&amp;quot;Error in encoding the extend clone request. &amp;quot;);   &amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(Exception e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(e.getMessage());&amp;#xD;&amp;#xA;    workflow.setFailed(&amp;quot;Error while getting the clone job details. &amp;quot;);&amp;#xD;&amp;#xA;}&quot; />&lt;/inputs>"/>

                <transition activity="ImpersonateExecutor_3"

                    commented="0" originalStyle="" points=""

                    sourceX="92" sourceY="125" status="0"

                    style="defaultEdge" targetX="100" targetY="200"

                    transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1384551420359" description=""

                displayName="Extend a Clone" height="34" interactive="0"

                name="Execute"

                namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                originalStyle="" skipAttempt="0"

                style="label;image=Execute" uniqueName="Execute_1"

                waitSetting="0" width="159" x="31" y="165">

                <inputs val="&lt;inputs>&lt;inputXml class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/strSnapBackupOperationRequest}&lt;/inputXml>&lt;commandArgs class=&quot;java.lang.String&quot; />&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

                <transition activity="ImpersonateCreator_2"

                    commented="0" originalStyle="" points=""

                    sourceX="341" sourceY="209" status="0"

                    style="defaultEdge" targetX="347" targetY="280"

                    transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1384551478269"

                description="activity to execute code snippets in the selected language"

                displayName="Set Return Message" height="34"

                interactive="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Script" uniqueName="Script_10"

                waitSetting="0" width="161" x="251" y="232">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;import commvault.msgs.CVGui.GenericResp;&amp;#xD;&amp;#xA;import commvault.cte.common.xml.XMLDecoder;&amp;#xD;&amp;#xA;import commvault.msgs.EVGui.SnapBackupOperationResponse;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;try &amp;#xD;&amp;#xA;{   &amp;#xD;&amp;#xA;   String xmlString = xpath:{/workflow/Execute_1/commandOutput};&amp;#xD;&amp;#xA;   if ( xmlString.toLowerCase().contains(&amp;quot;CVGui_GenericResp&amp;quot;.toLowerCase()) )&amp;#xD;&amp;#xA;   {   &amp;#xD;&amp;#xA;       GenericResp oGenericResp = (GenericResp)XMLDecoder.decode(xpath:{/workflow/Execute_1/commandOutput});&amp;#xD;&amp;#xA;      &amp;#xD;&amp;#xA;       logger.info(&amp;quot;ErrorCode::&amp;quot; + oGenericResp.getErrorCode());&amp;#xD;&amp;#xA;       logger.info(&amp;quot;ErrorMsg::&amp;quot; + oGenericResp.getErrorMessage());&amp;#xD;&amp;#xA;       logger.info(&amp;quot;ErrorrMessage ::&amp;quot; +workflow.getVariable(&amp;quot;strErrorMessage&amp;quot;) );&amp;#xD;&amp;#xA;       &amp;#xD;&amp;#xA;       if ( oGenericResp.getErrorCode() != 0)&amp;#xD;&amp;#xA;       {   &amp;#xD;&amp;#xA;           workflow.setVariable(&amp;quot;strErrorCode&amp;quot;, oGenericResp.getErrorCode());&amp;#xD;&amp;#xA;           workflow.setVariable(&amp;quot;strErrorMessage&amp;quot;, workflow.getVariable(&amp;quot;strErrorMessage&amp;quot;) +&amp;quot;Error for Clone Job id:&amp;quot; + xpath:{/workflow/ForEach_2/inputOpData} + &amp;quot; is &amp;quot;+  oGenericResp.getErrorMessage());&amp;#xD;&amp;#xA;       }&amp;#xD;&amp;#xA;   }&amp;#xD;&amp;#xA;   else if ( xmlString.toLowerCase().contains(&amp;quot;SnapBackupOperationResponse&amp;quot;.toLowerCase()) )&amp;#xD;&amp;#xA;   {    &amp;#xD;&amp;#xA;        SnapBackupOperationResponse oSnapBackupOperationResponse = (SnapBackupOperationResponse)XMLDecoder.decode(xpath:{/workflow/Execute_1/commandOutput});&amp;#xD;&amp;#xA;        if ( oSnapBackupOperationResponse.getError() != null &amp;amp;&amp;amp; oSnapBackupOperationResponse.getError().getErrorCode() !=0)&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            workflow.setVariable(&amp;quot;strErrorCode&amp;quot;, oSnapBackupOperationResponse.getError().getErrorCode());&amp;#xD;&amp;#xA;            workflow.setVariable(&amp;quot;strErrorMessage&amp;quot;, workflow.getVariable(&amp;quot;strErrorMessage&amp;quot;) +&amp;quot;Error for Clone Job id:&amp;quot; + xpath:{/workflow/ForEach_2/inputOpData} + &amp;quot; is &amp;quot;+ oSnapBackupOperationResponse.getError().getErrorMessage());&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;        if ( oSnapBackupOperationResponse.getJobId() !=null )&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            return oSnapBackupOperationResponse.getJobId(); &amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;   }&amp;#xD;&amp;#xA;} &amp;#xD;&amp;#xA;catch(Exception e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;logger.info(e.getMessage());&amp;#xD;&amp;#xA;   workflow.setFailed(&amp;quot;Error in getting response from Extend Clone Request&amp;quot;);&amp;#xD;&amp;#xA;}&quot; />&lt;/inputs>"/>

                <transition activity="AddToList_2" commented="0"

                    originalStyle="" points="" sourceX="331"

                    sourceY="249" status="0" style="defaultEdge"

                    targetX="126" targetY="244" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1384886599255"

                description="executes queries against the commserv database"

                displayName="Update metadata for alerts" height="34"

                interactive="0" name="CommServDBQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=CommServDBQuery"

                uniqueName="CommServDBQuery_3" waitSetting="0"

                width="200" x="23" y="305">

                <inputs val="&lt;inputs>&lt;commCell />&lt;query>update&#x9;SMMetaData set MetaData = CAST(''0'' AS NVARCHAR(MAX) ) where&#x9;RefId in (select id from SMMountVolume where MountJobId = xpath:{/workflow/ForEach_2/inputOpData}) and MetaDataType = 58 and RefType = 10&lt;/query>&lt;/inputs>"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1402515988342"

                description="impersonates the user who executes the workflow"

                displayName="ImpersonateExecutor" height="34"

                interactive="0" name="ImpersonateExecutor"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=ImpersonateExecutor"

                uniqueName="ImpersonateExecutor_3" waitSetting="0"

                width="172" x="17" y="96">

                <inputs val="&lt;inputs />"/>

                <transition activity="Execute_1" commented="0"

                    originalStyle="" points="" sourceX="117"

                    sourceY="208" status="0" style="defaultEdge"

                    targetX="305" targetY="192" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1402516043084"

                description="impersonates the user who created the workflow"

                displayName="ImpersonateCreator" height="34"

                interactive="0" name="ImpersonateCreator"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=ImpersonateCreator"

                uniqueName="ImpersonateCreator_2" waitSetting="0"

                width="164" x="251" y="166">

                <inputs val="&lt;inputs />"/>

                <transition activity="Script_10" commented="0"

                    originalStyle="" points="" sourceX="339"

                    sourceY="285" status="0" style="defaultEdge"

                    targetX="344" targetY="373" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1438360760150"

                description="utility to add objects to a list"

                displayName="AddToList" height="34" interactive="0"

                name="AddToList"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=AddToList" uniqueName="AddToList_2"

                waitSetting="0" width="100" x="64" y="235">

                <inputs val="&lt;inputs>&lt;addToList class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/snapOperationWFJobIDs}&lt;/addToList>&lt;itemToAdd class=&quot;java.lang.Object&quot; _list_=&quot;false&quot;>xpath:{/workflow/Script_10/output}&lt;/itemToAdd>&lt;/inputs>"/>

                <transition activity="CommServDBQuery_3" commented="0"

                    originalStyle="" points="" sourceX="114"

                    sourceY="252" status="0" style="defaultEdge"

                    targetX="113" targetY="323" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

        </superProcess>

        <transition activity="WaitForJobCompletion_1" commented="0"

            originalStyle="" points="" sourceX="952" sourceY="303"

            status="0" style="defaultEdge" targetX="1032" targetY="667"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1384553838571"

        description="returns a message to the caller of the workflow"

        displayName="Respond To Web Console" height="34" interactive="0"

        name="GenericResponse"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=GenericResponse"

        uniqueName="GenericResponse_1" waitSetting="0" width="196"

        x="1298" y="407">

        <inputs val="&lt;inputs>&lt;errorCode class=&quot;java.lang.Integer&quot;>xpath:{/workflow/variables/strErrorCode}&lt;/errorCode>&lt;errorMessage class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/strErrorMessage}&lt;/errorMessage>&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1384793406469"

        description="iterates a group of activities over a list of values"

        displayName="Delete a clone" height="268" interactive="0"

        name="ForEach" namespaceUri="commvault.cte.workflow.activities"

        originalStyle=""

        schema="&lt;xs:schema xmlns:xs=&quot;http://www.w3.org/2001/XMLSchema&quot; xmlns:tns=&quot;S_8afb4b62-065f-4483-8a0f-44a6a3a5c509&quot; targetNamespace=&quot;S_8afb4b62-065f-4483-8a0f-44a6a3a5c509&quot;>&lt;xs:complexType name=&quot;ForEach&quot;>&lt;xs:sequence>&lt;xs:element name=&quot;inputs&quot;>&lt;xs:complexType>&lt;xs:sequence>&lt;xs:element name=&quot;name&quot; type=&quot;xs:string&quot; minOccurs=&quot;0&quot; default=&quot;&quot;>&lt;xs:annotation>&lt;xs:appinfo>&lt;readOnly>false&lt;/readOnly>&lt;displayName>&lt;/displayName>&lt;/xs:appinfo>&lt;xs:documentation>&lt;/xs:documentation>&lt;/xs:annotation>&lt;/xs:element>&lt;xs:element name=&quot;values&quot; type=&quot;xs:anyType&quot; minOccurs=&quot;0&quot; default=&quot;&quot;>&lt;xs:annotation>&lt;xs:appinfo>&lt;readOnly>false&lt;/readOnly>&lt;displayName>&lt;/displayName>&lt;/xs:appinfo>&lt;xs:documentation>&lt;/xs:documentation>&lt;/xs:annotation>&lt;/xs:element>&lt;xs:element name=&quot;numberOfParallelExecutions&quot; type=&quot;xs:integer&quot; minOccurs=&quot;0&quot; default=&quot;1&quot;>&lt;xs:annotation>&lt;xs:appinfo>&lt;readOnly>false&lt;/readOnly>&lt;displayName>&lt;/displayName>&lt;/xs:appinfo>&lt;xs:documentation>&lt;/xs:documentation>&lt;/xs:annotation>&lt;/xs:element>&lt;xs:element name=&quot;continueOnFailure&quot; type=&quot;xs:boolean&quot; minOccurs=&quot;0&quot; default=&quot;false&quot;>&lt;xs:annotation>&lt;xs:appinfo>&lt;readOnly>false&lt;/readOnly>&lt;displayName>&lt;/displayName>&lt;/xs:appinfo>&lt;xs:documentation>&lt;/xs:documentation>&lt;/xs:annotation>&lt;/xs:element>&lt;/xs:sequence>&lt;/xs:complexType>&lt;/xs:element>&lt;xs:element name=&quot;outputs&quot;>&lt;xs:complexType>&lt;xs:sequence>&lt;xs:element name=&quot;inputOpData&quot; type=&quot;xs:string&quot; minOccurs=&quot;0&quot; default=&quot;&quot;>&lt;xs:annotation>&lt;xs:appinfo>&lt;readOnly>false&lt;/readOnly>&lt;displayName>&lt;/displayName>&lt;controlType>TEXTBOX&lt;/controlType>&lt;/xs:appinfo>&lt;xs:documentation>&lt;/xs:documentation>&lt;/xs:annotation>&lt;/xs:element>&lt;/xs:sequence>&lt;/xs:complexType>&lt;/xs:element>&lt;/xs:sequence>&lt;/xs:complexType>&lt;/xs:schema>"

        skipAttempt="0" style="swimlane" uniqueName="ForEach_3"

        waitSetting="0" width="488" x="650" y="421">

        <inputs val="&lt;inputs>&lt;name class=&quot;java.lang.String&quot;>inputOpData&lt;/name>&lt;values class=&quot;java.lang.Object&quot;>xpath:{/workflow/variables/inputOpData}&lt;/values>&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot;>1&lt;/numberOfParallelExecutions>&lt;continueOnFailure class=&quot;java.lang.Boolean&quot;>true&lt;/continueOnFailure>&lt;/inputs>"/>

        <superProcess>

            <Start commented="0" continueOnFailure="0"

                created="1384548445601" description=""

                displayName="Start" height="30" interactive="0"

                name="Start" originalStyle="" skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_9" waitSetting="0" width="120" x="23" y="33">

                <inputs val="&lt;inputs />"/>

                <transition activity="CommServDBQuery_2" commented="0"

                    originalStyle="" points="" sourceX="83" sourceY="48"

                    status="0" style="defaultEdge" targetX="297"

                    targetY="78" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <onEnter language="1" script="workflow.setVariable(&quot;strSnapBackupOperationRequest&quot;,&quot;&quot;);"/>

            </Start>

            <Activity commented="0" continueOnFailure="0"

                created="1384551258385"

                description="executes queries against the commserv database"

                displayName="Get Clone Details" height="34"

                interactive="0" name="CommServDBQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=CommServDBQuery"

                uniqueName="CommServDBQuery_2" waitSetting="0"

                width="162" x="251" y="31">

                <inputs val="&lt;inputs>&lt;commCell />&lt;query>SELECT&#x9;&#x9;MVOL.CommCellId, MVOL.Id, MVOL.SMVolumeId&amp;#xD;&#xd;&#xa;FROM&#x9;&#x9;SMMountVolume MVOL (NOLOCK)&amp;#xD;&#xd;&#xa;WHERE&#x9;&#x9;MVOL.MountJobId=xpath:{/workflow/ForEach_3/inputOpData}&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;SELECT TOP 1 VOL.SourceClientId FROM SMMountVolume MVOL (NOLOCK) INNER JOIN SMVolume VOL (NOLOCK) ON MVOL.SMVolumeId = VOL.SMVolumeId WHERE&#x9;MVOL.MountJobId=xpath:{/workflow/ForEach_3/inputOpData}&lt;/query>&lt;/inputs>"/>

                <transition activity="Script_12" commented="0"

                    originalStyle="" points="" sourceX="331"

                    sourceY="156" status="0" style="defaultEdge"

                    targetX="342" targetY="257" transitionIndex="0"

                    x="30" y="101">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1384551352096"

                description="activity to execute code snippets in the selected language"

                displayName="Set Clone Details" height="34"

                interactive="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Script" uniqueName="Script_12"

                waitSetting="0" width="143" x="253" y="92">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;import commvault.msgs.EVGui.SnapBackupOperationRequest;&amp;#xD;&amp;#xA;import commvault.msgs.EVGui.VolSnapEntity;&amp;#xD;&amp;#xA;import commvault.msgs.EVGui.AppId;&amp;#xD;&amp;#xA;import commvault.cte.common.xml.XMLEncoder;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    int rows = xpath:{/workflow/CommServDBQuery_2/resultSets[1]/rowCount};&amp;#xD;&amp;#xA;    int rows2 = xpath:{/workflow/CommServDBQuery_2/resultSets[2]/rowCount};&amp;#xD;&amp;#xA;    if (rows == 0)&amp;#xD;&amp;#xA;    {   &amp;#xD;&amp;#xA;        workflow.setFailed(&amp;quot;No details found for clone job id:&amp;quot; + xpath:{/workflow/ForEach_2/inputOpData}); &amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    if (rows2 == 0)&amp;#xD;&amp;#xA;    {  &amp;#xD;&amp;#xA;        workflow.setFailed(&amp;quot;No source details found for clone job id:&amp;quot; + xpath:{/workflow/ForEach_2/inputOpData}); &amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    SnapBackupOperationRequest oSnapBackupOperationRequest = new SnapBackupOperationRequest();&amp;#xD;&amp;#xA;    oSnapBackupOperationRequest.setOperation(2);&amp;#xD;&amp;#xA;  &amp;#xD;&amp;#xA;    List oSnapSnotIds = new ArrayList();&amp;#xD;&amp;#xA;    List oVolSnapEntityList = new ArrayList();&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;    DataSet ds = xpath:{/workflow/CommServDBQuery_2/resultSets}.get(0);&amp;#xD;&amp;#xA;    while (ds.hasNext()){&amp;#xD;&amp;#xA;        oSnapSnotIds.add(ds.get(&amp;quot;Id&amp;quot;));        &amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        VolSnapEntity oVolSnapEntity = new VolSnapEntity();&amp;#xD;&amp;#xA;        oVolSnapEntity.setCommCellId(ds.get(&amp;quot;CommCellId&amp;quot;));&amp;#xD;&amp;#xA;        oVolSnapEntity.setVolumeId(ds.get(&amp;quot;SMVolumeId&amp;quot;));&amp;#xD;&amp;#xA;                &amp;#xD;&amp;#xA;        oVolSnapEntityList.add(oVolSnapEntity);&amp;#xD;&amp;#xA;    }  &amp;#xD;&amp;#xA;    oSnapBackupOperationRequest.setSnapShotId(oSnapSnotIds);&amp;#xD;&amp;#xA;    oSnapBackupOperationRequest.setVolumes(oVolSnapEntityList);&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    DataSet ds2 = xpath:{/workflow/CommServDBQuery_2/resultSets}.get(1);&amp;#xD;&amp;#xA;    while (ds2.hasNext()){&amp;#xD;&amp;#xA;        AppId oAppId = new AppId();&amp;#xD;&amp;#xA;        oAppId.setClientId(ds2.get(&amp;quot;SourceClientId&amp;quot;));&amp;#xD;&amp;#xA;        oSnapBackupOperationRequest.setAppId(oAppId);  &amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;     &amp;#xD;&amp;#xA;    String strSnapBackupOperationRequest= &amp;quot;&amp;quot;; &amp;#xD;&amp;#xA;        try {&amp;#xD;&amp;#xA;            strSnapBackupOperationRequest = XMLEncoder.encode(oSnapBackupOperationRequest);&amp;#xD;&amp;#xA;            workflow.setVariable(&amp;quot;strSnapBackupOperationRequest&amp;quot;,strSnapBackupOperationRequest);&amp;#xD;&amp;#xA;            logger.info(&amp;quot;strSnapBackupOperationRequest:::&amp;quot; + strSnapBackupOperationRequest);&amp;#xD;&amp;#xA;        } catch (Exception excep) {&amp;#xD;&amp;#xA;            logger.info(excep.getMessage());&amp;#xD;&amp;#xA;            workflow.setFailed(&amp;quot;Error in encoding the delete clone request. &amp;quot;);   &amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(Exception e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(e.getMessage());&amp;#xD;&amp;#xA;    workflow.setFailed(&amp;quot;Error while getting the clone job details. &amp;quot;);&amp;#xD;&amp;#xA;}&quot; />&lt;/inputs>"/>

                <transition activity="ImpersonateExecutor_4"

                    commented="0" originalStyle="" points=""

                    sourceX="92" sourceY="125" status="0"

                    style="defaultEdge" targetX="99" targetY="210"

                    transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1384551420359" description=""

                displayName="Delete a Clone" height="34" interactive="0"

                name="Execute"

                namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                originalStyle="" skipAttempt="0"

                style="label;image=Execute" uniqueName="Execute_2"

                waitSetting="0" width="159" x="20" y="151">

                <inputs val="&lt;inputs>&lt;inputXml class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/strSnapBackupOperationRequest}&lt;/inputXml>&lt;commandArgs class=&quot;java.lang.String&quot; />&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

                <transition activity="ImpersonateCreator_3"

                    commented="0" originalStyle="" points=""

                    sourceX="312" sourceY="216" status="0"

                    style="defaultEdge" targetX="312" targetY="301"

                    transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1384551478269"

                description="activity to execute code snippets in the selected language"

                displayName="Set Return Message" height="34"

                interactive="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Script" uniqueName="Script_13"

                waitSetting="0" width="161" x="245" y="215">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;import commvault.msgs.CVGui.GenericResp;&amp;#xD;&amp;#xA;import commvault.cte.common.xml.XMLDecoder;&amp;#xD;&amp;#xA;import commvault.msgs.EVGui.SnapBackupOperationResponse;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;try &amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    String xmlString = xpath:{/workflow/Execute_2/commandOutput};&amp;#xD;&amp;#xA;       if ( xmlString.toLowerCase().contains(&amp;quot;CVGui_GenericResp&amp;quot;.toLowerCase()) )&amp;#xD;&amp;#xA;       {   &amp;#xD;&amp;#xA;           GenericResp oGenericResp = (GenericResp)XMLDecoder.decode(xpath:{/workflow/Execute_2/commandOutput});&amp;#xD;&amp;#xA;          &amp;#xD;&amp;#xA;           logger.info(&amp;quot;ErrorCode::&amp;quot; + oGenericResp.getErrorCode());&amp;#xD;&amp;#xA;           logger.info(&amp;quot;ErrorMsg::&amp;quot; + oGenericResp.getErrorMessage());&amp;#xD;&amp;#xA;           logger.info(&amp;quot;ErrorrMessage ::&amp;quot; +workflow.getVariable(&amp;quot;strErrorMessage&amp;quot;) );&amp;#xD;&amp;#xA;           &amp;#xD;&amp;#xA;           if ( oGenericResp.getErrorCode() != 0)&amp;#xD;&amp;#xA;           {   &amp;#xD;&amp;#xA;               workflow.setVariable(&amp;quot;strErrorCode&amp;quot;, oGenericResp.getErrorCode());&amp;#xD;&amp;#xA;               workflow.setVariable(&amp;quot;strErrorMessage&amp;quot;, workflow.getVariable(&amp;quot;strErrorMessage&amp;quot;) +&amp;quot;Error for Clone Job id:&amp;quot; + xpath:{/workflow/ForEach_3/inputOpData} + &amp;quot; is &amp;quot;+  oGenericResp.getErrorMessage());&amp;#xD;&amp;#xA;           }&amp;#xD;&amp;#xA;       }&amp;#xD;&amp;#xA;       else if ( xmlString.toLowerCase().contains(&amp;quot;SnapBackupOperationResponse&amp;quot;.toLowerCase()) )&amp;#xD;&amp;#xA;       {    &amp;#xD;&amp;#xA;            SnapBackupOperationResponse oSnapBackupOperationResponse = (SnapBackupOperationResponse)XMLDecoder.decode(xpath:{/workflow/Execute_2/commandOutput});&amp;#xD;&amp;#xA;            if ( oSnapBackupOperationResponse.getError() != null &amp;amp;&amp;amp; oSnapBackupOperationResponse.getError().getErrorCode() !=0)&amp;#xD;&amp;#xA;            {&amp;#xD;&amp;#xA;                workflow.setVariable(&amp;quot;strErrorCode&amp;quot;, oSnapBackupOperationResponse.getError().getErrorCode());&amp;#xD;&amp;#xA;                workflow.setVariable(&amp;quot;strErrorMessage&amp;quot;, workflow.getVariable(&amp;quot;strErrorMessage&amp;quot;) +&amp;quot;Error for Clone Job id:&amp;quot; + xpath:{/workflow/ForEach_3/inputOpData} + &amp;quot; is &amp;quot;+ oSnapBackupOperationResponse.getError().getErrorMessage());&amp;#xD;&amp;#xA;            }&amp;#xD;&amp;#xA;            if ( oSnapBackupOperationResponse.getJobId() !=null )&amp;#xD;&amp;#xA;            {&amp;#xD;&amp;#xA;                return oSnapBackupOperationResponse.getJobId(); &amp;#xD;&amp;#xA;            }&amp;#xD;&amp;#xA;       }&amp;#xD;&amp;#xA;} &amp;#xD;&amp;#xA;catch(Exception e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;   workflow.setFailed(&amp;quot;Error in getting response from delete Clone Request&amp;quot;);&amp;#xD;&amp;#xA;}&quot; />&lt;/inputs>"/>

                <transition activity="AddToList_3" commented="0"

                    originalStyle="" points="" sourceX="325"

                    sourceY="232" status="0" style="defaultEdge"

                    targetX="117" targetY="229" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1402516072350"

                description="impersonates the user who executes the workflow"

                displayName="ImpersonateExecutor" height="34"

                interactive="0" name="ImpersonateExecutor"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=ImpersonateExecutor"

                uniqueName="ImpersonateExecutor_4" waitSetting="0"

                width="172" x="12" y="91">

                <inputs val="&lt;inputs />"/>

                <transition activity="Execute_2" commented="0"

                    originalStyle="" points="" sourceX="107"

                    sourceY="215" status="0" style="defaultEdge"

                    targetX="279" targetY="215" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1402516106200"

                description="impersonates the user who created the workflow"

                displayName="ImpersonateCreator" height="34"

                interactive="0" name="ImpersonateCreator"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=ImpersonateCreator"

                uniqueName="ImpersonateCreator_3" waitSetting="0"

                width="164" x="245" y="152">

                <inputs val="&lt;inputs />"/>

                <transition activity="Script_13" commented="0"

                    originalStyle="" points="" sourceX="313"

                    sourceY="305" status="0" style="defaultEdge"

                    targetX="128" targetY="305" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1438361850790"

                description="utility to add objects to a list"

                displayName="AddToList" height="34" interactive="0"

                name="AddToList"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=AddToList" uniqueName="AddToList_3"

                waitSetting="0" width="100" x="53" y="212">

                <inputs val="&lt;inputs>&lt;addToList class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/snapOperationWFJobIDs}&lt;/addToList>&lt;itemToAdd class=&quot;java.lang.Object&quot; _list_=&quot;false&quot;>xpath:{/workflow/Script_13/output}&lt;/itemToAdd>&lt;/inputs>"/>

            </Activity>

        </superProcess>

        <transition activity="WaitForJobCompletion_1" commented="0"

            originalStyle="" points="" sourceX="894" sourceY="642"

            status="0" style="defaultEdge" targetX="1371" targetY="365"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1402515953178"

        description="impersonates the user who created the workflow"

        displayName="ImpersonateCreator" height="34" interactive="0"

        name="ImpersonateCreator"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ImpersonateCreator"

        uniqueName="ImpersonateCreator_1" waitSetting="0" width="164"

        x="79" y="309">

        <inputs val="&lt;inputs />"/>

        <transition activity="Script_6" commented="0" originalStyle=""

            points="" sourceX="158" sourceY="357" status="0"

            style="defaultEdge" targetX="295" targetY="470"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1438357774093"

        description="waits until the list of jobs completes"

        displayName="WaitForJobCompletion" height="34" interactive="0"

        name="WaitForJobCompletion"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=WaitForJobCompletion"

        uniqueName="WaitForJobCompletion_1" waitSetting="0" width="159"

        x="1316" y="330">

        <onExit language="1" script="if (xpath:{/workflow/WaitForJobCompletion_1/failedJobs}.size() > 0)&#xd;&#xa;{&#xd;&#xa;    String strFailedJobs = &quot;&quot;;&#xd;&#xa;&#xd;&#xa;    for (Integer jobId : xpath:{/workflow/WaitForJobCompletion_1/failedJobs})&#xd;&#xa;    {&#xd;&#xa;        strFailedJobs += Integer.toString(jobId) + &quot;, &quot;;&#xd;&#xa;    }&#xd;&#xa;    strFailedJobs = strFailedJobs.substring(0, strFailedJobs.length()-2);&#xd;&#xa;    workflow.setVariable(&quot;strErrorCode&quot;, &quot;1&quot;);&#xd;&#xa;    workflow.setVariable(&quot;strErrorMessage&quot;, &quot;Please check jobs [&quot; +  strFailedJobs + &quot;] for details.&quot;);&#xd;&#xa;}   "/>

        <inputs val="&lt;inputs>&lt;jobId class=&quot;java.lang.Integer&quot; _list_=&quot;true&quot;>xpath:{/workflow/variables/snapOperationWFJobIDs}&lt;/jobId>&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

        <transition activity="GenericResponse_1" commented="0"

            originalStyle="" points="" sourceX="1508" sourceY="499"

            status="0" style="defaultEdge" targetX="1444" targetY="359"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

</workflow>'

IF not exists (select * from WF_Definition where Name in  (@name, @oldName ))

BEGIN
	INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision)


	VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision)

	SET @workflowId = @@IDENTITY
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


	VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

	DECLARE @currName nvarchar(255)

	IF exists (select * from WF_Definition where Name =  @oldName )

	BEGIN

		SET @currName = @oldName

	END

	ELSE 

	BEGIN

		SET @currName = @name

	END

	SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = ISNULL(revision,'') From WF_Definition WHERE Name = @currName

	IF (@currentFlags & 4 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0) AND (@currentRevision <> @revision)

	BEGIN

		SET @version = @version + 1

		UPDATE WF_Definition

		SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision, name = @Name

		WHERE Name = @currName

		IF (@flags & 8 > 0 OR @flags & 16 > 0)

		BEGIN

			UPDATE WF_Definition

			SET flags = @flags

			WHERE Name = @Name

		END
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


		VALUES (@workflowId, @version, @currName, @description, @definition, @nowTime, 1)

	END

END

