

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_ChangeIndexServer.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/WFD_ChangeIndexServer.script,v $ $Id: WFD_ChangeIndexServer.script,v 1.3 2015/07/14 17:05:03 pkumar Exp $"
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER OFF

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.3 $'

SET @name = 'Change Index Server'

SET @description = 'Allows the user to change the current index server for a set of clients'

SET @version = 1

SET @flags = 6

SET @definition = '<Workflow_WorkflowDefinition apiMode="0" description="Workflow that allows the user to change the current index server for a set of clients" inputs="&lt;inputs>&lt;choice class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/inputs>" interactive="1" isHtmlDescription="0" name="Change Index Server" outputs="&lt;outputs />" revision="$Revision: 1.3 $" uniqueGuid="ad2f8fce-98d4-48d2-aa47-891473b30c7b" variables="&lt;variables>&lt;choice class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/variables>">

    <schema>

        <outputs attribute="0" className="" listType="0" name="outputs" required="1" type=""/>

        <variables attribute="0" className="" listType="0" name="variables" required="1" type="">

            <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" hidden="0" inputType="java.lang.String" listType="0" name="choice" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

        </variables>

        <inputs attribute="0" className="" listType="0" name="inputs" required="1" type="">

            <children attribute="0" className="java.lang.String" controlType="4" defaultValue="" displayName="Choose the Component" hidden="0" inputType="java.lang.String" listType="0" name="choice" required="1" type="{http://www.w3.org/2001/XMLSchema}string">

                <options val="Clients"/>

                <options val="Client Group"/>

                <options val="MediaAgent"/>

            </children>

        </inputs>

    </schema>

    <Start breakpoint="0" commented="0" continueOnFailure="0" created="0" description="" displayName="Start" height="36" interactive="0" name="Start" originalStyle="" skipAttempt="0" style="image;image=/images/jgraphx/house.png" uniqueName="Start_1" waitSetting="0" width="58" x="438" y="41">

        <inputs val="&lt;inputs />"/>

        <transition activity="CommServDBQuery_1" commented="0" originalStyle="" points="" sourceX="465" sourceY="59" status="0" style="defaultEdge" targetX="638" targetY="59" transitionIndex="0" x="393" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Start>

    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1430805443367" description="executes queries against a commcell database" displayName="Filter Clients and Media Agents" height="34" interactive="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=CommServDBQuery" uniqueName="CommServDBQuery_1" waitSetting="0" width="232" x="554" y="42">

        <onExit language="1" script="int retCode=0;&#xd;&#xa;&#xd;&#xa;if(xpath:{/workflow/inputs/choice}.equals(&quot;Clients&quot;))&#xd;&#xa;    retCode=0;&#xd;&#xa;if(xpath:{/workflow/inputs/choice}.equals(&quot;Client Group&quot;))&#xd;&#xa;    retCode=1;&#xd;&#xa;if(xpath:{/workflow/inputs/choice}.equals(&quot;MediaAgent&quot;))&#xd;&#xa;    retCode=2;&#xd;&#xa;    &#xd;&#xa;workflow.setVariable(&quot;choice&quot;,retCode);"/>

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>select name,id from APP_Client where id in (select componentNameId from APP_ClientProp where attrName=&apos;IndexingV2&apos; and attrVal=1)&amp;#xD;&#xd;&#xa;select name,id from APP_Client where name in (select MAname from CommCellMediaAgentInfo where MAStatus=&apos;Enable&apos;) and releaseId &amp;gt;= 16&lt;/query>&lt;/inputs>"/>

        <transition activity="Switch_1" commented="0" originalStyle="" points="" sourceX="666" sourceY="59" status="0" style="defaultEdge" targetX="664" targetY="184" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1430810225329" description="popups an input form for the user to fill out" displayName="Get Client List" height="34" interactive="0" name="PopupInput" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=PopupInput" uniqueName="PopupInput_1" waitSetting="0" width="134" x="954" y="320">

        <inputs val="&lt;inputs>&lt;inputs>&lt;clientList class=&quot;java.lang.String&quot; _list_=&quot;true&quot; />&lt;newIndexServer class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/inputs>&lt;subject>Change Primary IndexServer&lt;/subject>&lt;formProperties>&amp;lt;?xml version=&apos;1.0&apos; encoding=&apos;UTF-8&apos;?&amp;gt;&amp;lt;Workflow_FormProperties javaScript=&quot;&quot; css=&quot;&quot; /&amp;gt;&lt;/formProperties>&lt;/inputs>"/>

        <activitySchema>

            <outputs attribute="0" listType="0" name="outputs" required="1" type="">

                <children attribute="0" className="java.lang.String" controlType="2" defaultValue="" displayName="Client(s)" inputType="java.lang.String" listType="1" name="clientList" required="1" type="{http://www.w3.org/2001/XMLSchema}string">

                    <options val="xpath:{/workflow/CommServDBQuery_1/resultSets[1]/row/col[1]}"/>

                </children>

                <children attribute="0" className="java.lang.String" controlType="2" defaultValue="" displayName="New Index Server" inputType="java.lang.String" listType="0" name="newIndexServer" required="1" type="{http://www.w3.org/2001/XMLSchema}string">

                    <options val="xpath:{/workflow/CommServDBQuery_1/resultSets[2]/row/col[1]}"/>

                </children>

                <children className="java.lang.Boolean" inputType="java.lang.Boolean" name="okClicked" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                <children className="java.lang.String" inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string"/>

            </outputs>

            <inputs attribute="0" listType="0" name="inputs" required="1" type="">

                <children attribute="0" className="java.lang.String" controlType="2" defaultValue="" displayName="Client(s)" inputType="java.lang.String" listType="1" name="clientList" required="1" type="{http://www.w3.org/2001/XMLSchema}string">

                    <options val="xpath:{/workflow/CommServDBQuery_1/resultSets[1]/row/col[1]}"/>

                </children>

                <children attribute="0" className="java.lang.String" controlType="2" defaultValue="" displayName="New Index Server" inputType="java.lang.String" listType="0" name="newIndexServer" required="1" type="{http://www.w3.org/2001/XMLSchema}string">

                    <options val="xpath:{/workflow/CommServDBQuery_1/resultSets[2]/row/col[1]}"/>

                </children>

            </inputs>

        </activitySchema>

        <transition activity="Script_1" commented="0" originalStyle="" points="" sourceX="1021" sourceY="337" status="0" style="defaultEdge" targetX="787" targetY="462" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1430906229980" description="switch based decision" displayName="Choice" height="100" interactive="0" name="Switch" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1" uniqueName="Switch_1" waitSetting="0" width="100" x="623" y="143">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/choice}&lt;/expression>&lt;/inputs>"/>

        <transition activity="PopupInput_1" commented="0" displayName="Client List" originalStyle="" points="" sourceX="673" sourceY="193" status="0" style="defaultEdge" targetX="901" targetY="56" transitionIndex="0" value="0" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="PopupInput_2" commented="0" displayName="Client Group" originalStyle="" points="" sourceX="673" sourceY="193" status="0" style="defaultEdge" targetX="674" targetY="340" transitionIndex="0" value="1" x="393" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="PopupInput_3" commented="0" displayName="MediaAgent" originalStyle="" points="" sourceX="673" sourceY="193" status="0" style="defaultEdge" targetX="378" targetY="200" transitionIndex="0" value="2" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1430906249856" description="popups an input form for the user to fill out" displayName="Get Client Group" height="34" interactive="0" name="PopupInput" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=PopupInput" uniqueName="PopupInput_2" waitSetting="0" width="135" x="607" y="323">

        <inputs val="&lt;inputs>&lt;inputs>&lt;clientGroup class=&quot;commvault.msgs.CvEntities.ClientGroupEntity&quot; _list_=&quot;false&quot;>&lt;clientGroupName />&lt;clientGroupId />&lt;/clientGroup>&lt;newIndexServer class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/inputs>&lt;subject>Select Client Group&lt;/subject>&lt;formProperties>&amp;lt;?xml version=&apos;1.0&apos; encoding=&apos;UTF-8&apos;?&amp;gt;&amp;lt;Workflow_FormProperties javaScript=&quot;&quot; css=&quot;&quot; /&amp;gt;&lt;/formProperties>&lt;/inputs>"/>

        <activitySchema>

            <outputs attribute="0" listType="0" name="outputs" required="1" type="">

                <children attribute="0" className="commvault.msgs.CvEntities.ClientGroupEntity" controlType="2" defaultValue="" displayName="Client Group" inputType="commvault.msgs.CvEntities.ClientGroupEntity" listType="0" name="clientGroup" required="1" type="{commvault.msgs.CvEntities}ClientGroupEntity">

                    <children attribute="0" className="java.lang.String" inputType="java.lang.String" listType="0" name="clientGroupName" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

                    <children attribute="0" className="java.lang.Integer" inputType="java.lang.Integer" listType="0" name="clientGroupId" required="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                </children>

                <children attribute="0" className="java.lang.String" controlType="2" defaultValue="" displayName="New Index Server" inputType="java.lang.String" listType="0" name="newIndexServer" required="1" type="{http://www.w3.org/2001/XMLSchema}string">

                    <options val="xpath:{/workflow/CommServDBQuery_1/resultSets[2]/row/col[1]}"/>

                </children>

                <children className="java.lang.Boolean" inputType="java.lang.Boolean" name="okClicked" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                <children className="java.lang.String" inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string"/>

            </outputs>

            <inputs attribute="0" listType="0" name="inputs" required="1" type="">

                <children attribute="0" className="commvault.msgs.CvEntities.ClientGroupEntity" controlType="2" defaultValue="" displayName="Client Group" inputType="commvault.msgs.CvEntities.ClientGroupEntity" listType="0" name="clientGroup" required="1" type="{commvault.msgs.CvEntities}ClientGroupEntity">

                    <children attribute="0" className="java.lang.String" inputType="java.lang.String" listType="0" name="clientGroupName" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

                    <children attribute="0" className="java.lang.Integer" inputType="java.lang.Integer" listType="0" name="clientGroupId" required="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                </children>

                <children attribute="0" className="java.lang.String" controlType="2" defaultValue="" displayName="New Index Server" inputType="java.lang.String" listType="0" name="newIndexServer" required="1" type="{http://www.w3.org/2001/XMLSchema}string">

                    <options val="xpath:{/workflow/CommServDBQuery_1/resultSets[2]/row/col[1]}"/>

                </children>

            </inputs>

        </activitySchema>

        <transition activity="Script_1" commented="0" originalStyle="" points="" sourceX="674" sourceY="340" status="0" style="defaultEdge" targetX="665" targetY="454" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1430906301306" description="popups an input form for the user to fill out" displayName="Get MediaAgent" height="34" interactive="0" name="PopupInput" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=PopupInput" uniqueName="PopupInput_3" waitSetting="0" width="144" x="253" y="316">

        <inputs val="&lt;inputs>&lt;inputs>&lt;oldIndexServer class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;newIndexServer class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/inputs>&lt;subject>Select MediaAgent&lt;/subject>&lt;formProperties>&amp;lt;?xml version=&apos;1.0&apos; encoding=&apos;UTF-8&apos;?&amp;gt;&amp;lt;Workflow_FormProperties javaScript=&quot;&quot; css=&quot;&quot; /&amp;gt;&lt;/formProperties>&lt;/inputs>"/>

        <activitySchema>

            <outputs attribute="0" listType="0" name="outputs" required="1" type="">

                <children attribute="0" className="java.lang.String" controlType="2" defaultValue="" displayName="MediaAgent" inputType="java.lang.String" listType="0" name="oldIndexServer" required="1" type="{http://www.w3.org/2001/XMLSchema}string">

                    <options val="xpath:{/workflow/CommServDBQuery_1/resultSets[2]/row/col[1]}"/>

                </children>

                <children attribute="0" className="java.lang.String" controlType="2" defaultValue="" displayName="New Index Server" inputType="java.lang.String" listType="0" name="newIndexServer" required="1" type="{http://www.w3.org/2001/XMLSchema}string">

                    <options val="xpath:{/workflow/CommServDBQuery_1/resultSets[2]/row/col[1]}"/>

                </children>

                <children className="java.lang.Boolean" inputType="java.lang.Boolean" name="okClicked" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                <children className="java.lang.String" inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string"/>

            </outputs>

            <inputs attribute="0" listType="0" name="inputs" required="1" type="">

                <children attribute="0" className="java.lang.String" controlType="2" defaultValue="" displayName="MediaAgent" inputType="java.lang.String" listType="0" name="oldIndexServer" required="1" type="{http://www.w3.org/2001/XMLSchema}string">

                    <options val="xpath:{/workflow/CommServDBQuery_1/resultSets[2]/row/col[1]}"/>

                </children>

                <children attribute="0" className="java.lang.String" controlType="2" defaultValue="" displayName="New Index Server" inputType="java.lang.String" listType="0" name="newIndexServer" required="1" type="{http://www.w3.org/2001/XMLSchema}string">

                    <options val="xpath:{/workflow/CommServDBQuery_1/resultSets[2]/row/col[1]}"/>

                </children>

            </inputs>

        </activitySchema>

        <transition activity="Script_1" commented="0" originalStyle="" points="" sourceX="325" sourceY="333" status="0" style="defaultEdge" targetX="672" targetY="466" transitionIndex="0" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1430912823960" description="activity to execute code snippets in the selected language" displayName="Change Primary Index Server" height="34" interactive="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=Script" uniqueName="Script_1" waitSetting="0" width="270" x="537" y="449">

        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;List clientNames=new Vector();&amp;#xD;&amp;#xA;String clientGroup=&amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;String newIndexServer=&amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;String oldIndexServer=&amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;if(xpath:{/workflow/variables/choice}==0)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    clientNames=xpath:{/workflow/PopupInput_1/clientList};&amp;#xD;&amp;#xA;    newIndexServer=xpath:{/workflow/PopupInput_1/newIndexServer};&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;if(xpath:{/workflow/variables/choice}==1)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    clientGroup=xpath:{/workflow/PopupInput_2/clientGroup/clientGroupId}.toString();&amp;#xD;&amp;#xA;    newIndexServer=xpath:{/workflow/PopupInput_2/newIndexServer};&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;if(xpath:{/workflow/variables/choice}==2)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    oldIndexServer=xpath:{/workflow/PopupInput_3/oldIndexServer};&amp;#xD;&amp;#xA;    newIndexServer=xpath:{/workflow/PopupInput_3/newIndexServer};&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;List clientIdList=new Vector();&amp;#xD;&amp;#xA;DataSet ds=csdb.execute(&amp;quot;select name,id from App_Client where releaseId &amp;gt;= 16&amp;quot;);&amp;#xD;&amp;#xA;while (ds.hasNext())&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    for(Object temp:clientNames)&amp;#xD;&amp;#xA;        if(temp.equals(ds.get(&amp;quot;name&amp;quot;)))&amp;#xD;&amp;#xA;            clientIdList.add(ds.get(&amp;quot;id&amp;quot;));&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if(!clientGroup.equals(&amp;quot;&amp;quot;))&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    ds=csdb.execute(&amp;quot;select clientId from app_clientgroupassoc where clientGroupId = &amp;quot;+clientGroup);&amp;#xD;&amp;#xA;    while(ds.hasNext())&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        if(!clientIdList.contains(ds.get(&amp;quot;clientId&amp;quot;)))&amp;#xD;&amp;#xA;            clientIdList.add(ds.get(&amp;quot;clientId&amp;quot;));&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;ds=csdb.execute(&amp;quot;select id from App_Client where name = &apos;&amp;quot;+newIndexServer+&amp;quot;&apos;&amp;quot;);&amp;#xD;&amp;#xA;if(ds.hasNext())&amp;#xD;&amp;#xA;    newIndexServer=ds.get(&amp;quot;id&amp;quot;).toString();&amp;#xD;&amp;#xA;else&amp;#xD;&amp;#xA;    return false; &amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if(!clientIdList.isEmpty())&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    for(Object client:clientIdList)&amp;#xD;&amp;#xA;        csdb.executeUpdate(&amp;quot;update App_IndexDbInfo set currentIdxServer = &amp;quot;+newIndexServer+&amp;quot; where backupSetId in (select backupSet from APP_Application where clientId = &amp;quot;+client+&amp;quot;)&amp;quot;);&amp;#xD;&amp;#xA;        return true;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;ds=csdb.execute(&amp;quot;select id from App_Client where name = &apos;&amp;quot;+oldIndexServer+&amp;quot;&apos;&amp;quot;);&amp;#xD;&amp;#xA;if(ds.hasNext())&amp;#xD;&amp;#xA;    oldIndexServer=ds.get(&amp;quot;id&amp;quot;).toString();&amp;#xD;&amp;#xA;if(!oldIndexServer.isEmpty())&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    csdb.executeUpdate(&amp;quot;update App_IndexDbInfo set currentIdxServer = &amp;quot;+newIndexServer+ &amp;quot;where currentIdxServer = &amp;quot;+oldIndexServer);&amp;#xD;&amp;#xA;    return true;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;return false;&quot; />&lt;/inputs>"/>

        <transition activity="Decision_1" commented="0" originalStyle="" points="" sourceX="672" sourceY="466" status="0" style="defaultEdge" targetX="677" targetY="570" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1431444199752" description="displays an informational message to the user" displayName="Success Message" height="34" interactive="0" name="InformationalMessage" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=InformationalMessage" uniqueName="InformationalMessage_1" waitSetting="0" width="157" x="605" y="689">

        <inputs val="&lt;inputs>&lt;message class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>Successfully changed Index Server&amp;#xD;&#xd;&#xa;&lt;/message>&lt;html class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/html>&lt;dialogType class=&quot;commvault.msgs.Workflow.MessageDialogType&quot; _list_=&quot;false&quot;>Popup&lt;/dialogType>&lt;iconType class=&quot;commvault.msgs.Workflow.MessageIconType&quot; _list_=&quot;false&quot;>Information&lt;/iconType>&lt;title class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>Message&lt;/title>&lt;/inputs>"/>

        <transition activity="WorkflowEnd_1" commented="0" originalStyle="" points="" sourceX="683" sourceY="706" status="0" style="defaultEdge" targetX="344" targetY="601" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1431444952464" description="if/else based decision" displayName="Is Successful?" height="100" interactive="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1" uniqueName="Decision_1" waitSetting="0" width="114" x="623" y="546">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/Script_1/output}&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="InformationalMessage_1" commented="0" displayName="Success" originalStyle="" points="" sourceX="680" sourceY="596" status="0" style="defaultEdge" targetX="673" targetY="700" transitionIndex="0" value="true" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="WorkflowEnd_1" commented="0" displayName="Failure" originalStyle="" points="" sourceX="680" sourceY="596" status="0" style="defaultEdge" targetX="358" targetY="598" transitionIndex="0" value="false" x="-68" y="127">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1431445259058" description="Ends the workflow" displayName="WorkflowEnd" height="34" interactive="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=WorkflowEnd" uniqueName="WorkflowEnd_1" waitSetting="0" width="115" x="301" y="581">

        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot; />&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/inputs>"/>

    </Activity>

    <formProperties css="" javaScript=""/>

</Workflow_WorkflowDefinition>'

IF not exists (select * from WF_Definition where Name = @name)

BEGIN
	INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision)


	VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision)

	SET @workflowId = @@IDENTITY
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


	VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

	SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = revision From WF_Definition WHERE Name = @name

	IF (@currentFlags & 4 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0) AND (@currentRevision <> @revision)

	BEGIN

		SET @version = @version + 1

		UPDATE WF_Definition

		SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision

		WHERE Name = @name

		IF (@flags & 8 > 0 OR @flags & 16 > 0)

		BEGIN

			UPDATE WF_Definition

			SET flags = @flags

			WHERE Name = @name

		END
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


		VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

	END

END


