

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_Analytics.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/WFD_Analytics.script,v $ $Id: WFD_Analytics.script,v 1.4.2.3 2017/03/17 16:20:22 pankajkumar Exp $";
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER OFF

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @guid nvarchar(256)

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.4.2.3 $'

SET @name = 'Analytics'

SET @description = 'Perform analytics on files and e-mail data'

SET @version = 1

SET @flags = 6

SET @guid = '0fd0a7f2-7449-4dcb-ba1d-f7df06047ed5'

SET @definition = '<workflow apiMode="0"

    description="Perform analytics on files and e-mail data"

    inputs="&lt;inputs>&lt;clientGroupName class=&quot;commvault.msgs.CvEntities.ClientGroupEntity&quot;>&lt;clientGroupName />&lt;clientGroupId />&lt;/clientGroupName>&lt;appType class=&quot;java.lang.String&quot;>FileSystem&lt;/appType>&lt;analyticsEngine class=&quot;commvault.msgs.CvEntities.MediaAgentEntity&quot;>&lt;mediaAgentName />&lt;mediaAgentId />&lt;/analyticsEngine>&lt;DiscoveryOutput class=&quot;java.lang.String&quot;>C:\Windows\temp&lt;/DiscoveryOutput>&lt;WindowsUserName class=&quot;java.lang.String&quot; />&lt;WindowsUserPassword class=&quot;workflow.types.EncryptedString&quot; />&lt;clientType class=&quot;java.lang.String&quot;>WINDOWS&lt;/clientType>&lt;clientsNameFile class=&quot;java.lang.String&quot;>Generate File for NAS Subclients&lt;/clientsNameFile>&lt;PerformCCM class=&quot;java.lang.Boolean&quot; />&lt;CommCellType class=&quot;java.lang.String&quot;>Local&lt;/CommCellType>&lt;remotecommcell class=&quot;java.lang.String&quot; />&lt;nParallelPush class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>2&lt;/nParallelPush>&lt;/inputs>"

    interactive="0" isHtmlDescription="0" name="Analytics"

    outputs="&lt;outputs />" revision="$Revision: 1.4.2.3 $"

    uniqueGuid="ebed6c07-3469-44cc-8034-a98463bb2748"

    variables="&lt;variables>&lt;PseudoClientType class=&quot;java.lang.String&quot; />&lt;ClientInstallDir class=&quot;java.lang.String&quot; />&lt;workingDirectory class=&quot;java.lang.String&quot; />&lt;ClientGroup class=&quot;java.lang.String&quot; />&lt;csvFiles class=&quot;java.lang.String&quot; _list_=&quot;true&quot; />&lt;ExchClient class=&quot;java.lang.String&quot; />&lt;mahostname class=&quot;java.lang.String&quot; />&lt;DiscoveryClientType class=&quot;java.lang.String&quot; />&lt;DiscoveryClientName class=&quot;java.lang.String&quot; />&lt;DiscoveredClients class=&quot;java.lang.String&quot; />&lt;DiscoveryInputFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/variables>" workflowId="0">

    <schema>

        <outputs attribute="0" className="" listType="0" name="outputs"

            required="1" type=""/>

        <variables attribute="0" className="" listType="0"

            name="variables" required="1" type="">

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="PseudoClientType" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="ClientInstallDir" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="workingDirectory" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="ClientGroup" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="1"

                name="csvFiles" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="ExchClient" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="mahostname" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" hidden="0"

                inputType="java.lang.String" listType="0"

                name="DiscoveryClientType" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="DiscoveryClientName" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="DiscoveredClients" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="DiscoveryInputFile" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

        </variables>

        <inputs attribute="0" className="" listType="0" name="inputs"

            required="1" type="">

            <children attribute="0"

                className="commvault.msgs.CvEntities.ClientGroupEntity"

                controlType="2" defaultValue=""

                displayName="Client Group"

                documentation="Select Client Group." hidden="0"

                inputType="commvault.msgs.CvEntities.ClientGroupEntity"

                listType="0" maximumValue="" minimumValue=""

                name="clientGroupName" readOnly="0" required="1"

                searchable="0" type="{commvault.msgs.CvEntities}ClientGroupEntity">

                <children attribute="0" className="java.lang.String"

                    inputType="java.lang.String" listType="0"

                    name="clientGroupName" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children attribute="0" className="java.lang.Integer"

                    inputType="java.lang.Integer" listType="0"

                    name="clientGroupId" required="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            </children>

            <children attribute="0" className="java.lang.String"

                controlType="2" defaultValue="FileSystem"

                displayName="Application Type"

                documentation="Please select the operation type."

                hidden="0" inputType="java.lang.String" listType="0"

                name="appType" required="1" type="{http://www.w3.org/2001/XMLSchema}string">

                <options val="FileSystem"/>

                <options val="VirtualServer"/>

                <options val="NAS"/>

                <options val="SystemDiscovery"/>

                <options val="CleanupAnalyticsEngine"/>

            </children>

            <children attribute="0"

                className="commvault.msgs.CvEntities.MediaAgentEntity"

                controlType="2" defaultValue=""

                displayName="Analytics Engine MA"

                documentation="Select MA which has analytics engine running."

                hidden="0"

                inputType="commvault.msgs.CvEntities.MediaAgentEntity"

                listType="0" name="analyticsEngine" required="1" type="{commvault.msgs.CvEntities}MediaAgentEntity">

                <children attribute="0" className="java.lang.String"

                    inputType="java.lang.String" listType="0"

                    name="mediaAgentName" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children attribute="0" className="java.lang.Integer"

                    inputType="java.lang.Integer" listType="0"

                    name="mediaAgentId" required="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            </children>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue=""

                displayName="Temporary Working Area"

                documentation="Enter directory for temporary work"

                hidden="0" inputType="java.lang.String" listType="0"

                name="DiscoveryOutput" required="1" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue=""

                displayName="System Discovery Username" hidden="0"

                inputType="java.lang.String" listType="0"

                name="WindowsUserName" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0"

                className="workflow.types.EncryptedString"

                controlType="0" defaultValue=""

                displayName="System Discovery Password" hidden="0"

                inputType="workflow.types.EncryptedString" listType="0"

                name="WindowsUserPassword" required="0" type="{workflow.types}EncryptedString"/>

            <children attribute="0" className="java.lang.String"

                controlType="2" defaultValue="WINDOWS"

                displayName="System Discovery Client Type" hidden="0"

                inputType="java.lang.String" listType="0"

                name="clientType" required="0" type="{http://www.w3.org/2001/XMLSchema}string">

                <options val="WINDOWS"/>

                <options val="UNIX"/>

                <options val="NAS"/>

                <options val="EXCHANGE"/>

            </children>

            <children attribute="0" className="java.lang.String"

                controlType="0"

                defaultValue="Generate File for NAS Subclients"

                displayName="System Discovery Input File Path on Analytics MA"

                documentation="File containing System Discovery Inputs."

                hidden="0" inputType="java.lang.String" listType="0"

                name="clientsNameFile" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.Boolean"

                controlType="5" defaultValue=""

                displayName="Perform Commcell Migration" hidden="0"

                inputType="java.lang.Boolean" listType="0"

                name="PerformCCM" required="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

            <children attribute="0" className="java.lang.String"

                controlType="2" defaultValue="Local"

                displayName="CommCell Type" hidden="0"

                inputType="java.lang.String" listType="0"

                name="CommCellType" required="1" type="{http://www.w3.org/2001/XMLSchema}string">

                <options val="Local"/>

                <options val="Remote"/>

            </children>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue=""

                displayName="Remote Commcell AliasName" hidden="0"

                inputType="java.lang.String" listType="0"

                name="remotecommcell" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.Integer"

                controlType="0" defaultValue=""

                displayName="Number of Parallel Solr Push"

                documentation="" hidden="0"

                inputType="java.lang.Integer" listType="0"

                maximumValue="" minimumValue="" name="nParallelPush"

                readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

        </inputs>

    </schema>

    <Start commented="0" continueOnFailure="0" created="0"

        description="" displayName="Start" height="46" interactive="0"

        jobMode="0" name="Start" originalStyle="" skipAttempt="0"

        style="image;image=/images/jgraphx/house.png"

        uniqueName="Start_1" waitSetting="0" width="67" x="-11" y="106">

        <inputs val="&lt;inputs />"/>

        <transition activity="CommServDBQuery_5" commented="0"

            originalStyle="" points="" sourceX="22" sourceY="129"

            status="0" style="defaultEdge" targetX="111" targetY="59"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Start>

    <Activity commented="0" continueOnFailure="0"

        created="1385134139418"

        description="activity to execute code snippets in the selected language"

        displayName="Read Input File" height="34" interactive="0"

        jobMode="0" name="Script"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Script"

        uniqueName="Script_1" waitSetting="0" width="130" x="44" y="499">

        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;import java.io.*;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;List lines = new ArrayList();&amp;#xD;&amp;#xA;List linesExch = new ArrayList();&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;String ClientType = xpath:{/workflow/inputs/clientType};&amp;#xD;&amp;#xA;String filePath = xpath:{/workflow/inputs/clientsNameFile};&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;DiscoveryInputFile&amp;quot;, filePath);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;File f = new File(filePath);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if (f.exists() &amp;amp;&amp;amp; f.isFile()) {&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;    BufferedReader br = new BufferedReader(new FileReader(f));&amp;#xD;&amp;#xA;    String sCurrentLine;&amp;#xD;&amp;#xA;    while ((sCurrentLine = br.readLine()) != null) {&amp;#xD;&amp;#xA;            if(sCurrentLine.indexOf(&amp;quot;ComcellClientName&amp;quot;) &amp;gt; -1 &amp;amp;&amp;amp; ClientType.indexOf(&amp;quot;EXCHANGE&amp;quot;) &amp;gt; -1 ){               &amp;#xD;&amp;#xA;        &amp;#x9;   linesExch.add(sCurrentLine);&amp;#xD;&amp;#xA;        &amp;#x9;   br.close();&amp;#xD;&amp;#xA;        &amp;#x9;   return linesExch;&amp;#xD;&amp;#xA;            }&amp;#xD;&amp;#xA;    &amp;#x9;    lines.add(sCurrentLine);&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    br.close();&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;return lines;&quot; />&lt;/inputs>"/>

        <transition activity="ForEach_1" commented="0" originalStyle=""

            points="" sourceX="109" sourceY="516" status="0"

            style="defaultEdge" targetX="429" targetY="385"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1385134403870"

        description="iterates a group of activities over a list of values"

        displayName="ForEach" height="239" interactive="0" jobMode="0"

        name="ForEach" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="1" style="swimlane"

        uniqueName="ForEach_1" waitSetting="0" width="226" x="348" y="373">

        <inputs val="&lt;inputs>&lt;name class=&quot;java.lang.String&quot;>output&lt;/name>&lt;values class=&quot;java.lang.Object&quot;>xpath:{/workflow/Script_1/output}&lt;/values>&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot;>1&lt;/numberOfParallelExecutions>&lt;continueOnFailure class=&quot;java.lang.Boolean&quot;>false&lt;/continueOnFailure>&lt;/inputs>"/>

        <superProcess>

            <Start commented="0" continueOnFailure="0"

                created="1385134403870" description=""

                displayName="Start" height="30" interactive="0"

                jobMode="0" name="Start" originalStyle=""

                skipAttempt="1"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_2" waitSetting="0" width="120" x="47" y="33">

                <inputs val="&lt;inputs />"/>

                <transition activity="Script_2" commented="0"

                    originalStyle="" points="" sourceX="108"

                    sourceY="49" status="0" style="defaultEdge"

                    targetX="101" targetY="118" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity commented="0" continueOnFailure="0"

                created="1385134450668" description=""

                displayName="Create Client" height="34" interactive="0"

                jobMode="0" name="Execute"

                namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                originalStyle="" skipAttempt="1"

                style="label;image=Execute" uniqueName="CreateClient"

                waitSetting="0" width="159" x="27" y="135">

                <inputs val="&lt;inputs>&lt;inputXml class=&quot;java.lang.String&quot;>&amp;lt;App_CreatePseudoClientRequest&amp;gt;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;  &amp;lt;clientInfo&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;clientType&amp;gt;xpath:{/workflow/variables/PseudoClientType}&amp;lt;/clientType&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;openVMSProperties&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;cvdPort&amp;gt;0&amp;lt;/cvdPort&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;userAccount&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;userName&amp;gt;&amp;lt;/userName&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/userAccount&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/openVMSProperties&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;/clientInfo&amp;gt;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;  &amp;lt;entity&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;clientName&amp;gt;xpath:{/workflow/Script_2/output}&amp;lt;/clientName&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;hostName&amp;gt;xpath:{/workflow/Script_2/output}&amp;lt;/hostName&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;/entity&amp;gt;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;  &amp;lt;registerClient&amp;gt;false&amp;lt;/registerClient&amp;gt;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&amp;lt;/App_CreatePseudoClientRequest&amp;gt;&amp;#xD;&#xd;&#xa;&lt;/inputXml>&lt;commandArgs class=&quot;java.lang.String&quot; />&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

                <transition activity="AddtoGroup" commented="0"

                    originalStyle="" points="" sourceX="109"

                    sourceY="206" status="0" style="defaultEdge"

                    targetX="106" targetY="295" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1385138224970"

                description="activity to execute code snippets in the selected language"

                displayName="ClientName" height="34" interactive="0"

                jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="1"

                style="label;image=Script" uniqueName="Script_2"

                waitSetting="0" width="106" x="52" y="82">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;String InputData = xpath:{/workflow/ForEach_1/output};&amp;#xD;&amp;#xA;String ClientType = xpath:{/workflow/inputs/clientType};&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;PseudoClientType&amp;quot;, ClientType);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if(InputData.indexOf(&amp;quot;ComcellClientName&amp;quot;) &amp;gt; -1 &amp;amp;&amp;amp; ClientType.indexOf(&amp;quot;EXCHANGE&amp;quot;) &amp;gt; -1 ){&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;PseudoClientType&amp;quot;, &amp;quot;WINDOWS&amp;quot;);&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;DiscoveryClientType&amp;quot;, &amp;quot;EXCHANGE&amp;quot;);    &amp;#xD;&amp;#xA;    String[] temp = InputData.split(&amp;quot;\&amp;quot;&amp;quot;,4);    &amp;#xD;&amp;#xA;    temp = temp[1].split(&amp;quot;;&amp;quot;,2);    &amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;ExchClient&amp;quot;, temp[0]);    &amp;#xD;&amp;#xA;    return temp[0];         &amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if(ClientType.indexOf(&amp;quot;WINDOWS&amp;quot;) &amp;gt; -1 ){&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;PseudoClientType&amp;quot;, &amp;quot;WINDOWS&amp;quot;);&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;DiscoveryClientType&amp;quot;, &amp;quot;WINDOWS&amp;quot;);        &amp;#xD;&amp;#xA;    String[] parts = InputData.split(&amp;quot;,&amp;quot;);&amp;#xD;&amp;#xA;    if (parts != null &amp;amp;&amp;amp; parts.length &amp;gt; 0) {&amp;#xD;&amp;#xA;        workflow.setVariable(&amp;quot;DiscoveryClientName&amp;quot;, parts[0]);&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;String first = parts[0];&amp;#xD;&amp;#xA;        return first;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    return &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;if(ClientType.indexOf(&amp;quot;UNIX&amp;quot;) &amp;gt; -1 ){&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;PseudoClientType&amp;quot;, &amp;quot;UNIX&amp;quot;);&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;DiscoveryClientType&amp;quot;, &amp;quot;UNIX&amp;quot;);        &amp;#xD;&amp;#xA;    String[] parts = InputData.split(&amp;quot;,&amp;quot;);&amp;#xD;&amp;#xA;    if (parts != null &amp;amp;&amp;amp; parts.length &amp;gt; 0) {&amp;#xD;&amp;#xA;        workflow.setVariable(&amp;quot;DiscoveryClientName&amp;quot;, parts[0]);&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;String first = parts[0];&amp;#x9;&amp;#x9; &amp;#xD;&amp;#xA;        return first;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    return &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if(ClientType.indexOf(&amp;quot;NAS&amp;quot;) &amp;gt; -1 ){    &amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;PseudoClientType&amp;quot;, &amp;quot;WINDOWS&amp;quot;);&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;DiscoveryClientType&amp;quot;, &amp;quot;WINDOWS&amp;quot;);        &amp;#xD;&amp;#xA;        String[] parts = InputData.split(&amp;quot;,&amp;quot;);&amp;#xD;&amp;#xA;    if (parts != null &amp;amp;&amp;amp; parts.length &amp;gt; 0) {&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;String first = parts[0];&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;while( first.startsWith(&amp;quot;\\&amp;quot;) ) {&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;&amp;#x9;first = first.replaceFirst(&amp;quot;\\\\&amp;quot;,&amp;quot;&amp;quot;);&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;}&amp;#x9;&amp;#x9;&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;&amp;#x9;&amp;#x9;&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;&amp;#xD;&amp;#xA;        while( first.indexOf(&amp;quot;\\&amp;quot;) &amp;gt; -1 ) {&amp;#xD;&amp;#xA;            first = first.replaceFirst(&amp;quot;\\\\&amp;quot;,&amp;quot;__&amp;quot;);&amp;#xD;&amp;#xA;        }&amp;#x9;&amp;#x9;&amp;#xD;&amp;#xA;                &amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;String[] machineName = first.split(&amp;quot;__&amp;quot;);&amp;#x9;&amp;#x9;&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;workflow.setVariable(&amp;quot;DiscoveryClientName&amp;quot;, machineName[0]);    &amp;#x9;  &amp;#x9;&amp;#x9;&amp;#x9;&amp;#x9;&amp;#x9;&amp;#x9;&amp;#xD;&amp;#xA;  &amp;#x9;    String temp = workflow.getVariable(&amp;quot;DiscoveredClients&amp;quot;);&amp;#xD;&amp;#xA;  &amp;#x9;    if(temp.indexOf(&amp;quot;addNewClients&amp;quot;) &amp;gt; -1 )&amp;#xD;&amp;#xA;  &amp;#x9;    {&amp;#xD;&amp;#xA;  &amp;#x9;         logger.info(&amp;quot;This is first time we are adding client ..&amp;quot;);&amp;#xD;&amp;#xA;  &amp;#x9;         temp = &amp;quot;''''&amp;quot; + first + &amp;quot;''''&amp;quot; ;&amp;#xD;&amp;#xA;  &amp;#x9;    }&amp;#xD;&amp;#xA;  &amp;#x9;    else&amp;#xD;&amp;#xA;  &amp;#x9;    {&amp;#xD;&amp;#xA;  &amp;#x9;         temp = temp + &amp;quot;, ''''&amp;quot; + first + &amp;quot;''''&amp;quot;;&amp;#x9;&amp;#x9;&amp;#x9;        &amp;#xD;&amp;#xA;  &amp;#x9;    }  &amp;#x9;    &amp;#x9;&amp;#x9;&amp;#x9;  &amp;#xD;&amp;#xA;  &amp;#x9;      &amp;#xD;&amp;#xA;&amp;#x9;    workflow.setVariable(&amp;quot;DiscoveredClients&amp;quot;, temp);&amp;#x9;    &amp;#xD;&amp;#xA;        return first;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    return &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;}&quot; />&lt;/inputs>"/>

                <transition activity="CreateClient" commented="0"

                    originalStyle="" points="" sourceX="106"

                    sourceY="109" status="0" style="defaultEdge"

                    targetX="99" targetY="235" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1386011414504"

                description="executes queries against the commserv database"

                displayName="Add Client to Group" height="34"

                interactive="0" jobMode="0" name="CommServDBQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="1"

                style="label;image=CommServDBQuery"

                uniqueName="AddtoGroup" waitSetting="0" width="162"

                x="26" y="190">

                <inputs val="&lt;inputs>&lt;commCell />&lt;query>DECLARE @ClientID int = ( SELECT TOP 1 id FROM App_Client WHERE name = ''xpath:{/workflow/Script_2/output}'' )&amp;#xD;&#xd;&#xa;DECLARE @ClientGroupId int = ( SELECT TOP 1 id FROM App_ClientGroup WHERE name = ''xpath:{/workflow/inputs/clientGroupName/clientGroupName}'' )&amp;#xD;&#xd;&#xa;IF NOT EXISTS ( SELECT clientGroupId FROM APP_ClientGroupAssoc WHERE clientId = @ClientID AND clientGroupId = @ClientGroupId)&amp;#xD;&#xd;&#xa;BEGIN&amp;#xD;&#xd;&#xa;&#x9;INSERT INTO APP_ClientGroupAssoc VALUES ( @ClientGroupId, @ClientID )&amp;#xD;&#xd;&#xa;END&lt;/query>&lt;/inputs>"/>

            </Activity>

        </superProcess>

        <activitySchema>

            <outputs name="outputs">

                <children className="java.lang.Object"

                    inputType="java.lang.Object" listType="0"

                    name="output" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

            </outputs>

            <inputs>

                <children className="java.lang.String"

                    inputType="java.lang.String" name="name" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children className="java.lang.Object"

                    inputType="java.lang.Object" name="values" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                <children className="java.lang.Integer" defaultValue="1"

                    inputType="java.lang.Integer"

                    name="numberOfParallelExecutions" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                <children className="java.lang.Boolean"

                    defaultValue="false" inputType="java.lang.Boolean"

                    name="continueOnFailure" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

            </inputs>

        </activitySchema>

        <transition activity="Switch_2" commented="0" originalStyle=""

            points="" sourceX="427" sourceY="403" status="0"

            style="defaultEdge" targetX="634" targetY="297"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1385141079859"

        description="executes queries against the commserv database"

        displayName="Set FLA Parameters" height="34" interactive="0"

        jobMode="0" name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=CommServDBQuery" uniqueName="Set_FLA_Params"

        waitSetting="0" width="162" x="1147" y="41">

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>SET NOCOUNT ON&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;DECLARE @ExchangeCommClientName varchar(max) = ''xpath:{/workflow/variables/ExchClient}''&amp;#xD;&#xd;&#xa;DECLARE @AnalyticsEngine varchar(max) = ''xpath:{/workflow/inputs/analyticsEngine/mediaAgentName}''&amp;#xD;&#xd;&#xa;DECLARE @ClientGroupName varchar(max) = ''xpath:{/workflow/inputs/clientGroupName/clientGroupName}''&amp;#xD;&#xd;&#xa;DECLARE @OperationType varchar(max) = ''xpath:{/workflow/inputs/appType}''&amp;#xD;&#xd;&#xa;DECLARE @OSType varchar(max) = ''xpath:{/workflow/inputs/clientType}''&amp;#xD;&#xd;&#xa;DECLARE @ClientNameFile varchar(max) = ''xpath:{/workflow/inputs/clientsNameFile}''&amp;#xD;&#xd;&#xa;DECLARE @CurrentDiscoveredClients varchar(max) = ''('' + ''xpath:{/workflow/variables/DiscoveredClients}'' + '')''&amp;#xD;&#xd;&#xa;DECLARE @JobId int = xpath:{/workflow/system/jobId}&amp;#xD;&#xd;&#xa;DECLARE @ClientName varchar(max) = ''''&amp;#xD;&#xd;&#xa;DECLARE @EngineName varchar (max) = ''''&amp;#xD;&#xd;&#xa;DECLARE @ClientId int = 0&amp;#xD;&#xd;&#xa;DECLARE @EngineMAId int = 0&amp;#xD;&#xd;&#xa;DECLARE @CloudId int = 0&amp;#xD;&#xd;&#xa;DECLARE @OrigCCID int = 0&amp;#xD;&#xd;&#xa;DECLARE @AppId int = 0&amp;#xD;&#xd;&#xa;DECLARE @ExchangeInstance int = 0&amp;#xD;&#xd;&#xa;DECLARE @PruneSOLRData int = 0&amp;#xD;&#xd;&#xa;DECLARE @ArchFileId int = 0&amp;#xD;&#xd;&#xa;DECLARE @VMname varchar(max) = ''''&amp;#xD;&#xd;&#xa;DECLARE @CSVPath varchar(max) = ''''&amp;#xD;&#xd;&#xa;DECLARE @BackupSetID int = 1&amp;#xD;&#xd;&#xa;DECLARE @EngineInstanceName varchar(max) = ''''&amp;#xD;&#xd;&#xa;DECLARE @ClientGroupId int = 0&amp;#xD;&#xd;&#xa;DECLARE @VSASubID int = 0&amp;#xD;&#xd;&#xa;DECLARE @AppType int = 33&amp;#xD;&#xd;&#xa;DECLARE @DataArchGroupId int = 1&amp;#xD;&#xd;&#xa;DECLARE @AppGroup varchar(max) = ''''&amp;#xD;&#xd;&#xa;DECLARE @DiscoveryClientName varchar(max) = '' ''&amp;#xD;&#xd;&#xa;DECLARE @ReleaseID int = 16&amp;#xD;&#xd;&#xa;DECLARE @CommandTable TABLE ( ClientName varchar(max), ClientId int, AnalyticsEngine varchar(max) , SubclientId int, BackupSetId int ,VMname varchar(max) , CSVPath varchar(max) , AppType int, EngineMAId int, VSASubClientID int, PruneSOLRData int, InstanceName varchar(max) ) &amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;IF @OperationType like ''%FileSystem%'' OR @OperationType like ''%NAS%'' &amp;#xD;&#xd;&#xa;BEGIN&amp;#xD;&#xd;&#xa;&#x9;SET @AppGroup = ''File System''&#x9;&amp;#xD;&#xd;&#xa;END&amp;#xD;&#xd;&#xa;ELSE IF @OperationType like ''%Exchange%''&amp;#xD;&#xd;&#xa;BEGIN&#x9;&amp;#xD;&#xd;&#xa;    SET @AppType = 54&amp;#xD;&#xd;&#xa;&#x9;SET @AppGroup = ''Mailbox''&#x9;&#x9;&amp;#xD;&#xd;&#xa;END&amp;#xD;&#xd;&#xa;ELSE IF @OperationType like ''%Sharepoint%''&amp;#xD;&#xd;&#xa;BEGIN&amp;#xD;&#xd;&#xa;&#x9;SET @AppGroup = ''Sharepoint''&#x9;&#x9;&amp;#xD;&#xd;&#xa;END&amp;#xD;&#xd;&#xa;ELSE IF @OperationType like ''%All%''&amp;#xD;&#xd;&#xa;BEGIN&amp;#xD;&#xd;&#xa;&#x9;SET @AppGroup = ''''&#x9;&#x9;&amp;#xD;&#xd;&#xa;END&amp;#xD;&#xd;&#xa;ELSE IF @OperationType like ''%Discovery%'' OR @OperationType like ''%Virtual%''&amp;#xD;&#xd;&#xa;BEGIN&amp;#xD;&#xd;&#xa;&#x9;IF @OSType like ''%EXCH%''&amp;#xD;&#xd;&#xa;&#x9;BEGIN&amp;#xD;&#xd;&#xa;&#x9;&#x9;SET @AppType = 54&amp;#xD;&#xd;&#xa;&#x9;END&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;IF @OSType like ''%WIN%''&amp;#xD;&#xd;&#xa;&#x9;BEGIN&amp;#xD;&#xd;&#xa;&#x9;&#x9;SET @AppType = 33&amp;#xD;&#xd;&#xa;&#x9;END&#x9;&#x9;&amp;#xD;&#xd;&#xa;    IF @OSType like ''%NAS%''&amp;#xD;&#xd;&#xa;&#x9;BEGIN&amp;#xD;&#xd;&#xa;&#x9;&#x9;SET @AppType = 13&amp;#xD;&#xd;&#xa;&#x9;END&#x9;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;IF @OSType like ''%UNIX%'' &amp;#xD;&#xd;&#xa;&#x9;BEGIN&amp;#xD;&#xd;&#xa;&#x9;&#x9;SET @AppType = 29&amp;#xD;&#xd;&#xa;&#x9;END&#x9;&#x9;&#x9;&#x9;&amp;#xD;&#xd;&#xa;END&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;SET @CloudId  = ( SELECT TOP 1 CloudId FROM DM2SearchServerCoreInfo S,APP_Client,DM2CloudCoreRole R WHERE ClientId=id AND name = @AnalyticsEngine AND s.CloudId = R.CloudId )&amp;#xD;&#xd;&#xa;SET @EngineMAId = ( SELECT TOP 1 id FROM APP_Client WHERE name = @AnalyticsEngine )&amp;#xD;&#xd;&#xa;SET @EngineName = ( SELECT TOP 1 net_hostname FROM APP_Client WHERE name = @AnalyticsEngine )&amp;#xD;&#xd;&#xa;SET @ClientGroupId = ( SELECT TOP 1 id FROM APP_ClientGroup WHERE name = @ClientGroupName  )&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;DECLARE CurC CURSOR FORWARD_ONLY FOR ( SELECT name FROM App_Client,APP_ClientGroupAssoc WHERE clientGroupId = @ClientGroupId AND id = clientId );&amp;#xD;&#xd;&#xa;OPEN CurC;&amp;#xD;&#xd;&#xa;FETCH NEXT FROM CurC into @ClientName;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;-- Set the Engine InstanceName&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;SET @EngineInstanceName = ( SELECT attrVal FROM APP_ClientProp WHERE attrName= ''Galaxy Instance name'' and componentNameId=@EngineMAId ) &amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;--- Loop for each Client&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;WHILE @@FETCH_STATUS = 0&amp;#xD;&#xd;&#xa;BEGIN&#x9;&amp;#xD;&#xd;&#xa;&#x9;&amp;#xD;&#xd;&#xa;&#x9;SET @ClientId = ( SELECT id FROM App_Client WHERE name = @ClientName )&#x9;&amp;#xD;&#xd;&#xa;&#x9;SET @OrigCCID = ( SELECT origCCId FROM APP_Client WHERE id = @ClientId ) &amp;#xD;&#xd;&#xa;&#x9;&amp;#xD;&#xd;&#xa;   &#x9;-- Do this only for clean up operations&amp;#xD;&#xd;&#xa;&#x9;&amp;#xD;&#xd;&#xa;&#x9;IF ( @OperationType like ''%Cleanup%'' )&amp;#xD;&#xd;&#xa;&#x9;BEGIN&amp;#xD;&#xd;&#xa;&#x9;&#x9;SET @PruneSOLRData = 2&amp;#xD;&#xd;&#xa;&#x9;&#x9;DECLARE SubClientCursor CURSOR FORWARD_ONLY FOR &amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;SELECT id,backupSet,appTypeId FROM APP_Application WHERE clientId = @ClientId &#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;AND id IN ( SELECT appId FROM archFile WHERE id IN ( SELECT archFileId FROM archFLAIndexingInfo WHERE cloudId=@CloudId ) )&amp;#xD;&#xd;&#xa;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;OPEN SubClientCursor;&amp;#xD;&#xd;&#xa;&#x9;&#x9;FETCH NEXT FROM SubClientCursor INTO @AppId, @BackupSetId, @AppType&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;WHILE @@FETCH_STATUS = 0&amp;#xD;&#xd;&#xa;&#x9;&#x9;BEGIN&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;                &amp;#xD;&#xd;&#xa;            DELETE FROM archFLAIndexingInfo WHERE archFileId in ( SELECT id FROM archFile WHERE appId = @AppId ) AND cloudId = @CloudId&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;INSERT @CommandTable ( ClientName , ClientId , AnalyticsEngine , SubclientId ,BackupSetId, VMname  , CSVPath , AppType , EngineMAId , VSASubClientID , PruneSOLRData, InstanceName )  VALUES ( @ClientName,@ClientId, @EngineName, @AppId, @BackupSetID, @VMname, @CSVPath , @AppType , @EngineMAId , @AppId , @PruneSOLRData, @EngineInstanceName )&#x9;&#x9;&#x9;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;FETCH NEXT FROM SubClientCursor INTO @AppId, @BackupSetId, @AppType&amp;#xD;&#xd;&#xa;&#x9;&#x9;END&amp;#xD;&#xd;&#xa;&#x9;&#x9;CLOSE SubClientCursor&amp;#xD;&#xd;&#xa;&#x9;&#x9;DEALLOCATE SubClientCursor&amp;#xD;&#xd;&#xa;&#x9;END&amp;#xD;&#xd;&#xa;&#x9;&amp;#xD;&#xd;&#xa;&#x9;-- Do this only for System Discovery and VSA&amp;#xD;&#xd;&#xa;&#x9;&amp;#xD;&#xd;&#xa;&#x9;IF ( @OperationType like ''%Virtual%'' OR @OperationType like ''%Discovery%'' OR @OrigCCID &amp;gt; 2 )&amp;#xD;&#xd;&#xa;&#x9;BEGIN&#x9;&#x9;&#x9;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;-- Insert subclient if not there already and use BackupSetId as 1 always&#x9;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;IF NOT EXISTS ( SELECT id FROM APP_Application WHERE clientId = @ClientId AND subclientName not like ''IndexingSubclient'' )&amp;#xD;&#xd;&#xa;&#x9;&#x9;BEGIN&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;INSERT INTO APP_InstanceName VALUES ( ''CVFLA_defaultInstance'',0,0,0,0,0,@OrigCCID,NEWID())&amp;#xD;&#xd;&#xa;&#x9;&#x9;    SET @ExchangeInstance = ( SELECT TOP 1 id FROM APP_InstanceName ORDER BY id DESC )&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;INSERT INTO APP_Application VALUES ( @ClientId,@AppType,@ExchangeInstance,1,0,1,1,0,0,''CV_FLA_DUMMY'',0,0,0,@OrigCCID,NEWID()) &#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;END&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&#x9;&#x9;SET @AppId = ( SELECT TOP 1 id FROM APP_Application WHERE clientId = @ClientId AND subclientName not like ''IndexingSubclient'' )&amp;#xD;&#xd;&#xa;&#x9;&#x9;SET @DataArchGroupId = ( SELECT dataArchGrpID FROM APP_Application WHERE id = @AppId )&amp;#xD;&#xd;&#xa;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;IF @OSType like ''%EXCH%''&amp;#xD;&#xd;&#xa;&#x9;&#x9;BEGIN&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;SET @ExchangeInstance = ( SELECT instance FROM APP_Application WHERE id = @AppId )&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;IF NOT EXISTS ( SELECT * FROM APP_InstanceProp WHERE attrName = ''Server Name'' AND componentNameId = @ExchangeInstance )&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;BEGIN&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;INSERT INTO APP_InstanceProp VALUES (@ExchangeInstance,''Server Name'',1,''''+@ClientName+'''',(SELECT DATEDIFF(s, ''1970-01-01 00:00:00'', GETUTCDATE())),0,0 )&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;END&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;UPDATE APP_Application SET appTypeId = 54 WHERE id = @AppId&amp;#xD;&#xd;&#xa;&#x9;&#x9;END&amp;#xD;&#xd;&#xa;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;-- Insert archFile if not there or update ctime&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&#x9;&#x9;IF  @AppId is not null &amp;#xD;&#xd;&#xa;&#x9;&#x9;BEGIN&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;IF NOT EXISTS ( SELECT id FROM archFile WHERE appId = @AppId AND fileType = 1 and isValid = 1 )&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;BEGIN&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;INSERT INTO archFile VALUES ( ''CV_FLA_DUMMY_ARCHFILE'',@OrigCCID,@DataArchGroupId,'''',0,@AppId,1,(SELECT DATEDIFF(s, ''1970-01-01 00:00:00'', (SELECT DATEADD(DAY,90,GETUTCDATE())))),0,1,1,0,0,0 )&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;END&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;ELSE&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;UPDATE archFile SET cTime = (SELECT DATEDIFF(s, ''1970-01-01 00:00:00'', (SELECT DATEADD(DAY,90,GETUTCDATE())))) WHERE appId = @AppId AND name like ''CV_FLA_DUMMY_ARCHFILE'' &amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;-- Add archFLAIndexingInfo record for archFile if not there else update indexTime&#x9;&#x9;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;IF NOT EXISTS ( SELECT archFileId FROM archFLAIndexingInfo WHERE archFileId in ( SELECT id FROM archFile WHERE appId = @AppId and archGroupId = @DataArchGroupId and fileType = 1) AND cloudId = @CloudId )&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;BEGIN&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;-- Get the latest archFile which is not already in FLA table against different clouds and put it in archFLAIndexingInfo&#x9;&#x9;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;IF NOT EXISTS ( SELECT TOP 1 id FROM archFile WHERE id not in ( SELECT archFileId FROM archFLAIndexingInfo ) AND appId = @AppId and archGroupId = @DataArchGroupId and fileType = 1 and isValid = 1 ORDER BY cTime DESC )&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;BEGIN&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;INSERT INTO archFile VALUES ( ''CV_FLA_DUMMY_ARCHFILE'',@OrigCCID,@DataArchGroupId,'''',0,@AppId,1,(SELECT DATEDIFF(s, ''1970-01-01 00:00:00'', (SELECT DATEADD(DAY,90,GETUTCDATE())))),0,1,1,0,0,0 )&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;END&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;SET @ArchFileId = ( SELECT TOP 1 id FROM archFile WHERE id not in ( SELECT archFileId FROM archFLAIndexingInfo ) AND appId = @AppId and archGroupId = @DataArchGroupId and fileType = 1 and isValid = 1 ORDER BY cTime DESC )&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;IF @ArchFileId &amp;gt; 1&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;BEGIN&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;INSERT INTO archFLAIndexingInfo VALUES ( @ArchFileId,@OrigCCID,0,0,(SELECT DATEDIFF(s, ''1970-01-01 00:00:00'', GETUTCDATE())),@CloudId,@AppId,@ClientName,@ClientId,0 )&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;END &#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;END&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;ELSE&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;BEGIN&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;    SET @ArchFileId = ( SELECT TOP 1 archFileId FROM archFLAIndexingInfo WHERE archFileId in ( SELECT id FROM archFile WHERE appId = @AppId and archGroupId = @DataArchGroupId  and fileType = 1) AND cloudId = @CloudId )&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;UPDATE archFLAIndexingInfo SET indexTime = (SELECT DATEDIFF(s, ''1970-01-01 00:00:00'', GETUTCDATE())) WHERE archFileId = @ArchFileId&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;END&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;END&amp;#xD;&#xd;&#xa;&#x9;END&amp;#xD;&#xd;&#xa;&#x9;&amp;#xD;&#xd;&#xa;&#x9;-- IF PSEUDO CLIENT, SET CSV PATH&amp;#xD;&#xd;&#xa;&#x9;&amp;#xD;&#xd;&#xa;&#x9;IF ( @OperationType like ''%Discovery%'' AND @AppId is not null )&amp;#xD;&#xd;&#xa;&#x9;BEGIN&amp;#xD;&#xd;&#xa;&#x9;&#x9;IF ( @OSType like ''%windows%'' )&amp;#xD;&#xd;&#xa;&#x9;&#x9;BEGIN&amp;#xD;&#xd;&#xa;&#x9;&#x9;   SET @OSType = ''WIN''&amp;#xD;&#xd;&#xa;&#x9;&#x9;END&amp;#xD;&#xd;&#xa;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;SET @PruneSOLRData = 1&amp;#xD;&#xd;&#xa;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;IF @OSType like ''%EXCH%'' and @AppType = 54&amp;#xD;&#xd;&#xa;&#x9;&#x9;BEGIN&amp;#xD;&#xd;&#xa;&#x9;&#x9;    SET @PruneSOLRData = 0&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;SET @CSVPath = ''xpath:{/workflow/inputs/DiscoveryOutput}\'' + CONVERT(varchar(max),@JobId) + ''\EmailDiscovery\XML\ExSysDiscoveryOutput.csv''&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;END&amp;#xD;&#xd;&#xa;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;IF @OSType like ''%NAS%'' and @ClientNameFile like ''%Generate File for NAS Subclients%''&amp;#xD;&#xd;&#xa;        BEGIN&amp;#xD;&#xd;&#xa;            SET @OSType = ''WIN''&amp;#xD;&#xd;&#xa;        END    &amp;#xD;&#xd;&#xa;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;IF @OSType like ''%NAS%'' and @AppType = 13&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;BEGIN&amp;#xD;&#xd;&#xa;&#x9;&#x9;  SET @DiscoveryClientName = ''EMPTY''&amp;#xD;&#xd;&#xa;&#x9;&#x9;  &amp;#xD;&#xd;&#xa;&#x9;&#x9;  IF(Charindex(''__'',@ClientName) &amp;gt; 0 AND Charindex(@ClientName,@CurrentDiscoveredClients) &amp;gt; 0 )&amp;#xD;&#xd;&#xa;&#x9;&#x9;  BEGIN&amp;#xD;&#xd;&#xa;&#x9;&#x9;      SET @DiscoveryClientName = ( SELECT ltrim(rtrim(Substring(@ClientName,1,Charindex(''__'',@ClientName)-1))) )&amp;#xD;&#xd;&#xa;&#x9;&#x9;  END&amp;#xD;&#xd;&#xa;&#x9;&#x9;  ELSE IF(Charindex(@ClientName,@CurrentDiscoveredClients) &amp;gt; 0)&amp;#xD;&#xd;&#xa;&#x9;&#x9;  BEGIN&amp;#xD;&#xd;&#xa;&#x9;&#x9;      SET @DiscoveryClientName = @ClientName&amp;#xD;&#xd;&#xa;&#x9;&#x9;  END &amp;#xD;&#xd;&#xa;&#x9;&#x9;      &amp;#xD;&#xd;&#xa;&#x9;&#x9;  SET @CSVPath = ''xpath:{/workflow/inputs/DiscoveryOutput}\'' + CONVERT(varchar(max),@JobId) + ''\Clients\'' + @DiscoveryClientName + ''\analysis_WIN_'' + @DiscoveryClientName + ''.cvf''&amp;#xD;&#xd;&#xa;&#x9;&#x9;  &amp;#xD;&#xd;&#xa;&#x9;&#x9;END&amp;#xD;&#xd;&#xa;&#x9;&#x9;ELSE&amp;#xD;&#xd;&#xa;&#x9;&#x9;BEGIN&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;SET @CSVPath = ''xpath:{/workflow/inputs/DiscoveryOutput}\'' + CONVERT(varchar(max),@JobId) + ''\Clients\'' + @ClientName + ''\analysis_'' + @OSType + ''_'' + @ClientName + ''.cvf''&amp;#xD;&#xd;&#xa;&#x9;&#x9;END&amp;#xD;&#xd;&#xa;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;SET @BackupSetID = 0&amp;#xD;&#xd;&#xa;&#x9;&#x9;SET @VSASubID = @AppId&amp;#xD;&#xd;&#xa;&#x9;&#x9;SET @VMname = ''''&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&amp;#xD;&#xd;&#xa;        IF  @ExchangeCommClientName = @ClientName and @OSType like ''%EXCH%''&amp;#xD;&#xd;&#xa;        BEGIN&amp;#xD;&#xd;&#xa;          INSERT @CommandTable ( ClientName , ClientId , AnalyticsEngine , SubclientId ,BackupSetId, VMname  , CSVPath , AppType , EngineMAId , VSASubClientID , PruneSOLRData, InstanceName )  VALUES ( @ClientName,@ClientId, @EngineName, @AppId, @BackupSetID, @VMname, @CSVPath , @AppType , @EngineMAId , @VSASubID , @PruneSOLRData, @EngineInstanceName )&amp;#xD;&#xd;&#xa;        END&amp;#xD;&#xd;&#xa;        &amp;#xD;&#xd;&#xa;        IF  @OSType like ''%NAS%'' AND @DiscoveryClientName not like ''%EMPTY%''&amp;#xD;&#xd;&#xa;        BEGIN&amp;#xD;&#xd;&#xa;          INSERT @CommandTable ( ClientName , ClientId , AnalyticsEngine , SubclientId ,BackupSetId, VMname  , CSVPath , AppType , EngineMAId , VSASubClientID , PruneSOLRData, InstanceName )  VALUES ( @ClientName,@ClientId, @EngineName, @AppId, @BackupSetID, @VMname, @CSVPath , @AppType , @EngineMAId , @VSASubID , @PruneSOLRData, @EngineInstanceName )&amp;#xD;&#xd;&#xa;        END               &amp;#xD;&#xd;&#xa;        ELSE IF @OSType not like ''%NAS%'' AND @OSType not like ''%EXCH%'' -- FOR all other        &amp;#xD;&#xd;&#xa;        BEGIN&amp;#xD;&#xd;&#xa;          INSERT @CommandTable ( ClientName , ClientId , AnalyticsEngine , SubclientId ,BackupSetId, VMname  , CSVPath , AppType , EngineMAId , VSASubClientID , PruneSOLRData, InstanceName )  VALUES ( @ClientName,@ClientId, @EngineName, @AppId, @BackupSetID, @VMname, @CSVPath , @AppType , @EngineMAId , @VSASubID , @PruneSOLRData, @EngineInstanceName )&amp;#xD;&#xd;&#xa;        END&amp;#xD;&#xd;&#xa;&#x9;&amp;#xD;&#xd;&#xa;&#x9;END&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&#x9;-- IF VSA &amp;#xD;&#xd;&#xa;&#x9;&amp;#xD;&#xd;&#xa;&#x9;ELSE IF EXISTS ( SELECT VMclientId FROM APP_VMProp WHERE VMclientId = @ClientId ) AND @OperationType like ''%Virtual%'' AND  @AppId is not null &amp;#xD;&#xd;&#xa;&#x9;BEGIN&amp;#xD;&#xd;&#xa;&#x9;&#x9;SET @VMname = @ClientName&amp;#xD;&#xd;&#xa;&#x9;&#x9;SET @ClientName = ( SELECT TOP 1 name FROM APP_Client WHERE id in&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;( SELECT clientId FROM APP_Application WHERE id in&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;( SELECT appId FROM JMBkpStats WHERE jobId in&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;( SELECT max(jobId) FROM APP_VMProp WHERE VMclientId = @ClientId ))))&#x9;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&#x9;&#x9;SET @VSASubID = ( SELECT TOP 1 appId FROM JMBkpStats WHERE jobId in  &amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;  ( SELECT max(jobId) FROM APP_VMProp WHERE VMclientId = @ClientId ))&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&#x9;&#x9;SET @BackupSetID = ( SELECT TOP 1 id FROM APP_BackupSetName WHERE id in &amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;( SELECT backupSet FROM APP_Application WHERE id = @VSASubID ))&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;SET @CSVPath = ''''&amp;#xD;&#xd;&#xa;&#x9;&#x9;SET @PruneSOLRData = 1&amp;#xD;&#xd;&#xa;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;INSERT @CommandTable ( ClientName , ClientId , AnalyticsEngine , SubclientId ,BackupSetId, VMname  , CSVPath , AppType , EngineMAId , VSASubClientID , PruneSOLRData, InstanceName )  VALUES ( @ClientName,@ClientId, @EngineName, @AppId, @BackupSetID, @VMname, @CSVPath , 106 , @EngineMAId , @VSASubID , @PruneSOLRData, @EngineInstanceName )&amp;#xD;&#xd;&#xa;&#x9;END&amp;#xD;&#xd;&#xa;&#x9;&amp;#xD;&#xd;&#xa;&#x9;-- Else for WINFS\UNIXFS\EXCHANGE\SHAREPOINT\NAS-NDMP\Cleanup ADD rows for every Subclient&amp;#xD;&#xd;&#xa;&#x9;ELSE IF @AppId is not null AND @OperationType not like ''%Cleanup%''&amp;#xD;&#xd;&#xa;&#x9; &amp;#xD;&#xd;&#xa;&#x9;BEGIN&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;DECLARE SubClientCursor CURSOR FORWARD_ONLY FOR &amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;SELECT id,backupSet,appTypeId FROM APP_Application WHERE clientId = @ClientId AND appTypeId in (&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;SELECT appTypeId FROM App_AppTypeGroups WHERE ( appGroup like ''%'' + @AppGroup + ''%'' ) OR ( App like ''%'' + @AppGroup + ''%'' ) ) AND (&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;subclientStatus &amp;amp; 16 &amp;lt;&amp;gt; 16 and subclientStatus &amp;amp; 32 &amp;lt;&amp;gt; 32 and subclientStatus &amp;amp; 4 &amp;lt;&amp;gt; 4 and subclientStatus &amp;lt;&amp;gt; 2 ) &amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;AND subclientName not like ''%IndexingSubclient%'' AND subclientName not like ''%DDBBackup%''&amp;#xD;&#xd;&#xa;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;OPEN SubClientCursor;&amp;#xD;&#xd;&#xa;&#x9;&#x9;FETCH NEXT FROM SubClientCursor INTO @AppId, @BackupSetId, @AppType&amp;#xD;&#xd;&#xa;&#x9;&#x9;SET @PruneSOLRData = 1&amp;#xD;&#xd;&#xa;&#x9;&#x9;WHILE @@FETCH_STATUS = 0&amp;#xD;&#xd;&#xa;&#x9;&#x9;BEGIN&#x9;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;-- Check if it has any valid data archive file &amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;IF EXISTS ( SELECT id FROM archFile WHERE appId = @AppId and fileType = 1 and isValid = 1 )&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;BEGIN&amp;#xD;&#xd;&#xa;                IF NOT EXISTS ( SELECT archFileId FROM archFLAIndexingInfo WHERE archFileId in ( SELECT id FROM archFile WHERE appId = @AppId and fileType = 1 and isValid = 1 ) AND cloudId = @CloudId )&amp;#xD;&#xd;&#xa;                BEGIN                    &amp;#xD;&#xd;&#xa;                    -- Get the latest archFile which is not already in FLA table against different clouds and put it in archFLAIndexingInfo&amp;#xD;&#xd;&#xa;                    SET @ArchFileId = ( SELECT TOP 1 id FROM archFile WHERE id not in ( SELECT archFileId FROM archFLAIndexingInfo ) AND appId = @AppId and fileType = 1 and isValid = 1 ORDER BY cTime DESC )&amp;#xD;&#xd;&#xa;                    IF @ArchFileId &amp;gt; 1&amp;#xD;&#xd;&#xa;                    BEGIN&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;INSERT INTO archFLAIndexingInfo VALUES ( @ArchFileId,@OrigCCID,0,0,(SELECT DATEDIFF(s, ''1970-01-01 00:00:00'', GETUTCDATE())),@CloudId,@AppId,@ClientName,@ClientId,0 )&amp;#xD;&#xd;&#xa;                    END&amp;#xD;&#xd;&#xa;                END&amp;#xD;&#xd;&#xa;                &amp;#xD;&#xd;&#xa;                -- See if any unknown appType is in input&amp;#xD;&#xd;&#xa;                IF @AppType NOT IN ( 33,29,13,63 )&amp;#xD;&#xd;&#xa;                BEGIN                                       &amp;#xD;&#xd;&#xa;                    DECLARE @GroupName varchar(max) = ''''                &amp;#xD;&#xd;&#xa;                    SET @GroupName = ( SELECT osGroup FROM App_AppTypeGroups WHERE appTypeId =  @AppType )                &amp;#xD;&#xd;&#xa;                    IF @GroupName = ''Unix'' OR @GroupName = ''Centera'' OR @GroupName = ''Netware'' OR @GroupName = ''SGI'' OR @GroupName = ''Centera''  &amp;#xD;&#xd;&#xa;                    BEGIN&amp;#xD;&#xd;&#xa;                        SET @AppType = 29&amp;#xD;&#xd;&#xa;                    END&amp;#xD;&#xd;&#xa;                    ELSE&amp;#xD;&#xd;&#xa;                        SET @AppType = 33&amp;#xD;&#xd;&#xa;                END&amp;#xD;&#xd;&#xa;                &amp;#xD;&#xd;&#xa;                &amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;-- Now insert in final push &amp;#xD;&#xd;&#xa;                SET @PruneSOLRData = 1&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;INSERT @CommandTable ( ClientName , ClientId , AnalyticsEngine , SubclientId ,BackupSetId, VMname  , CSVPath , AppType , EngineMAId , VSASubClientID , PruneSOLRData, InstanceName )  VALUES ( @ClientName,@ClientId, @EngineName, @AppId, @BackupSetID, @VMname, @CSVPath , @AppType , @EngineMAId , @AppId , @PruneSOLRData, @EngineInstanceName )&#x9;&#x9;&#x9;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;END&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;FETCH NEXT FROM SubClientCursor INTO @AppId, @BackupSetId, @AppType&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;END&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&#x9;&#x9;CLOSE SubClientCursor&amp;#xD;&#xd;&#xa;&#x9;&#x9;DEALLOCATE SubClientCursor&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&#x9;END&amp;#xD;&#xd;&#xa;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;FETCH NEXT FROM CurC into @ClientName;&amp;#xD;&#xd;&#xa;&#x9;&amp;#xD;&#xd;&#xa;END&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;CLOSE CurC;&amp;#xD;&#xd;&#xa;DEALLOCATE CurC;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;SELECT * FROM @CommandTable&lt;/query>&lt;/inputs>"/>

        <transition activity="ForEach_2" commented="0" originalStyle=""

            points="" sourceX="1228" sourceY="58" status="0"

            style="defaultEdge" targetX="1535" targetY="118"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1385141137636" description="Execute a list of commands"

        displayName="WINFS Discovery" height="32" interactive="0"

        jobMode="0" maxRestarts="0" name="ExecuteCommand"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ExecuteCommand" uniqueName="ExecuteCommand_1"

        waitSetting="0" width="147" x="968" y="232">

        <onExit language="1" script="import java.io.*;&#xd;&#xa;String directoryName = xpath:{/workflow/inputs/DiscoveryOutput} + &quot;\\&quot; +xpath:{/workflow/system/jobId} + &quot;\\Clients\\&quot; + xpath:{/workflow/variables/DiscoveryClientName};&#xd;&#xa;boolean filesPresent = false;&#xd;&#xa;&#xd;&#xa;File directory = new File(directoryName);&#xd;&#xa;if(directory.exists())&#xd;&#xa;{&#xd;&#xa;    File[] fList = directory.listFiles();&#xd;&#xa;    for (File file : fList) &#xd;&#xa;    {&#xd;&#xa;        if (file.isFile()) &#xd;&#xa;        {&#xd;&#xa;           if (file.getName().endsWith(&quot;.cvf&quot;)) &#xd;&#xa;           {&#xd;&#xa;               filesPresent = true;&#xd;&#xa;               break;&#xd;&#xa;           }&#xd;&#xa;        }&#xd;&#xa;    }&#xd;&#xa;}&#xd;&#xa;if(!filesPresent)&#xd;&#xa;{&#xd;&#xa;    logger.info(&quot;Discovery File is not present &quot;);&#xd;&#xa;    workflow.setStatus(commvault.cte.common.workflow.ProcessStatus.FAILED);&#xd;&#xa;    workflow.setFailureReason(&quot;Failed to complete System Discovery Process. Please check logs from C:\\Windows\\Temp\\&quot; + xpath:{/workflow/system/jobId});&#xd;&#xa;}"/>

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>&lt;clientName />&lt;clientId />&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/WindowsUserName}&lt;/impersonateUserName>&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot;>xpath:{/workflow/inputs/WindowsUserPassword}&lt;/impersonateUserPassword>&lt;startUpPath class=&quot;java.lang.String&quot; />&lt;command class=&quot;java.lang.String&quot;>cmd.exe&lt;/command>&lt;arguments class=&quot;java.lang.String&quot;>/C &quot;cd /d &quot;xpath:{/workflow/variables/ClientInstallDir}\Base\CVSysDiscoveryUI64&quot; &amp;amp;&amp;amp; SysDiscoveryCmd.exe -type xpath:{/workflow/variables/DiscoveryClientType} -input xpath:{/workflow/inputs/clientsNameFile} -files -output  xpath:{/workflow/inputs/DiscoveryOutput}\xpath:{/workflow/system/jobId} -debug 4&quot;&lt;/arguments>&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="DisableLogging_2" commented="0"

            originalStyle="" points="" sourceX="957" sourceY="191"

            status="0" style="defaultEdge" targetX="1209" targetY="263"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1385141935334"

        description="iterates a group of activities over a list of values"

        displayName="Push CTree" height="240" interactive="0"

        jobMode="0" name="ForEach"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="1" style="swimlane"

        uniqueName="ForEach_2" waitSetting="0" width="213" x="1416" y="116">

        <inputs val="&lt;inputs>&lt;name class=&quot;java.lang.String&quot;>row&lt;/name>&lt;values class=&quot;java.lang.Object&quot;>xpath:{/workflow/Set_FLA_Params/resultSets/row}&lt;/values>&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot;>xpath:{/workflow/inputs/nParallelPush}&lt;/numberOfParallelExecutions>&lt;continueOnFailure class=&quot;java.lang.Boolean&quot;>false&lt;/continueOnFailure>&lt;/inputs>"/>

        <superProcess>

            <Start commented="0" continueOnFailure="0"

                created="1385141935334" description=""

                displayName="Start" height="30" interactive="0"

                jobMode="0" name="Start" originalStyle=""

                skipAttempt="1"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_3" waitSetting="0" width="120" x="37" y="40">

                <inputs val="&lt;inputs />"/>

                <transition activity="DisableLogging_4" commented="0"

                    originalStyle="" points="" sourceX="97" sourceY="55"

                    status="0" style="defaultEdge" targetX="102"

                    targetY="121" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity commented="0" continueOnFailure="1"

                created="1416498606961"

                description="Execute a list of commands"

                displayName="Push Lucene" height="34" interactive="0"

                jobMode="0" maxRestarts="0" name="ExecuteCommand"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="1"

                style="label;image=ExecuteCommand"

                uniqueName="ExecuteCommand_2" waitSetting="0"

                width="147" x="40" y="169">

                <onExit language="1" script="import java.io.*;&#xd;&#xa;&#xd;&#xa;workflow.setStatus(commvault.cte.common.workflow.ProcessStatus.RUNNING);&#xd;&#xa;String sql = &quot;&quot;;&#xd;&#xa;String SYS_DISCOVERY = xpath:{/workflow/ForEach_2/row/col[@name=&quot;CSVPath&quot;]};&#xd;&#xa;int PruneData = xpath:{/workflow/ForEach_2/row/col[@name=&quot;PruneSOLRData&quot;]};&#xd;&#xa;&#xd;&#xa;if(SYS_DISCOVERY.equals(&quot;&quot;))&#xd;&#xa;{&#xd;&#xa;&#x9;if(activity.exitCode > 0)&#xd;&#xa;&#x9;{&#xd;&#xa;&#x9;&#x9;sql = &quot;UPDATE archFLAIndexingInfo SET pushedItemCount=&quot;+ activity.exitCode +&quot;,indexTime=(SELECT DATEDIFF(s, ''1970-01-01 00:00:00'', GETUTCDATE())),flags=64 WHERE archFileId in ( SELECT id FROM archFile WHERE appId = &quot;+xpath:{/workflow/ForEach_2/row/col[@name=&quot;VSASubClientID&quot;]}+&quot; )&quot;;    &#xd;&#xa;&#x9;}&#xd;&#xa;    else &#xd;&#xa;&#x9;{&#xd;&#xa;        sql = &quot;UPDATE archFLAIndexingInfo SET pushedItemCount=&quot;+ activity.exitCode +&quot;,indexTime=(SELECT DATEDIFF(s, ''1970-01-01 00:00:00'', GETUTCDATE())),flags=0  WHERE archFileId in ( SELECT id FROM archFile WHERE appId = &quot;+xpath:{/workflow/ForEach_2/row/col[@name=&quot;VSASubClientID&quot;]}+&quot; )&quot;;&#xd;&#xa;    }&#xd;&#xa;    &#xd;&#xa;    logger.info(&quot;Total Items &quot;+activity.exitCode);&#xd;&#xa;    logger.info(&quot;Subclient &quot;+xpath:{/workflow/ForEach_2/row/col[@name=&quot;VSASubClientID&quot;]});        &#xd;&#xa;    logger.info(sql);&#xd;&#xa;}&#xd;&#xa;else&#xd;&#xa;{&#xd;&#xa;&#x9;if(activity.exitCode == 0)&#xd;&#xa;&#x9;{&#xd;&#xa;&#x9;&#x9;sql = &quot;UPDATE archFLAIndexingInfo SET indexTime=(SELECT DATEDIFF(s, ''1970-01-01 00:00:00'', GETUTCDATE())),flags=64 WHERE archFileId in ( SELECT id FROM archFile WHERE appId = &quot;+xpath:{/workflow/ForEach_2/row/col[@name=&quot;VSASubClientID&quot;]}+&quot; )&quot;;    &#xd;&#xa;&#x9;}&#xd;&#xa;    else &#xd;&#xa;&#x9;{&#xd;&#xa;        sql = &quot;UPDATE archFLAIndexingInfo SET indexTime=(SELECT DATEDIFF(s, ''1970-01-01 00:00:00'', GETUTCDATE())),flags=0  WHERE archFileId in ( SELECT id FROM archFile WHERE appId = &quot;+xpath:{/workflow/ForEach_2/row/col[@name=&quot;VSASubClientID&quot;]}+&quot; )&quot;;&#xd;&#xa;    }&#xd;&#xa;    &#xd;&#xa;    logger.info(&quot;Total Items &quot;+activity.exitCode);&#xd;&#xa;    logger.info(&quot;Subclient &quot;+xpath:{/workflow/ForEach_2/row/col[@name=&quot;VSASubClientID&quot;]});        &#xd;&#xa;    logger.info(sql);&#xd;&#xa;}&#xd;&#xa;&#xd;&#xa;csdb.executeUpdate(sql);"/>

                <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/inputs/analyticsEngine/mediaAgentName}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; />&lt;command class=&quot;java.lang.String&quot;>CVCIAnalytics.exe&lt;/command>&lt;arguments class=&quot;java.lang.String&quot;>-cvworkflow xpath:{/workflow/system/jobId} -cln &quot;xpath:{/workflow/ForEach_2/row/col[@name=&quot;ClientName&quot;]}&quot; -c xpath:{/workflow/ForEach_2/row/col[@name=&quot;ClientId&quot;]} -m &quot;xpath:{/workflow/ForEach_2/row/col[@name=&quot;AnalyticsEngine&quot;]}&quot; -s xpath:{/workflow/ForEach_2/row/col[@name=&quot;SubclientId&quot;]} -vmname &quot;xpath:{/workflow/ForEach_2/row/col[@name=&quot;VMname&quot;]}&quot; -csv &quot;xpath:{/workflow/ForEach_2/row/col[@name=&quot;CSVPath&quot;]}&quot; -backupsetid xpath:{/workflow/ForEach_2/row/col[@name=&quot;BackupSetId&quot;]} -a xpath:{/workflow/ForEach_2/row/col[@name=&quot;AppType&quot;]} -ma xpath:{/workflow/ForEach_2/row/col[@name=&quot;EngineMAId&quot;]} -vsaAppId xpath:{/workflow/ForEach_2/row/col[@name=&quot;VSASubClientID&quot;]} -pruneSolrData xpath:{/workflow/ForEach_2/row/col[@name=&quot;PruneSOLRData&quot;]} -vm &quot;xpath:{/workflow/ForEach_2/row/col[@name=&quot;InstanceName&quot;]}&quot;&lt;/arguments>&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1450120194453"

                description="turns off all logging, except for errors, for current job"

                displayName="DisableLogging" height="34" interactive="0"

                jobMode="0" name="DisableLogging"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=DisableLogging"

                uniqueName="DisableLogging_4" waitSetting="0"

                width="117" x="51" y="100">

                <inputs val="&lt;inputs />"/>

                <transition activity="ExecuteCommand_2" commented="0"

                    originalStyle="" points="" sourceX="109"

                    sourceY="117" status="0" style="defaultEdge"

                    targetX="106" targetY="184" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

        </superProcess>

        <activitySchema>

            <outputs name="outputs">

                <children attribute="0"

                    className="workflow.types.data.DataRow"

                    defaultValue="" hidden="0"

                    inputType="workflow.types.data.DataRow" listType="0"

                    name="row" type="{workflow.types.data}DataRow">

                    <children attribute="0" className="java.lang.Object"

                        defaultValue="" hidden="0"

                        inputType="java.lang.Object" listType="1"

                        name="col" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                </children>

            </outputs>

            <inputs>

                <children className="java.lang.String"

                    inputType="java.lang.String" name="name" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children className="java.lang.Object"

                    inputType="java.lang.Object" name="values" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                <children className="java.lang.Integer" defaultValue="1"

                    inputType="java.lang.Integer"

                    name="numberOfParallelExecutions" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                <children className="java.lang.Boolean"

                    defaultValue="false" inputType="java.lang.Boolean"

                    name="continueOnFailure" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

            </inputs>

        </activitySchema>

        <transition activity="Switch_4" commented="0" originalStyle=""

            points="" sourceX="1522" sourceY="198" status="0"

            style="defaultEdge" targetX="1704" targetY="209"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1389027022119" description="Execute a list of commands"

        displayName="Emails Discovery" height="31" interactive="0"

        jobMode="0" maxRestarts="0" name="ExecuteCommand"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ExecuteCommand" uniqueName="ExecuteCommand_3"

        waitSetting="0" width="154" x="903" y="412">

        <onExit language="1" script="import java.io.*;&#xd;&#xa;&#xd;&#xa;String directoryName = xpath:{/workflow/inputs/DiscoveryOutput} + &quot;\\&quot;  + xpath:{/workflow/system/jobId} + &quot;\\EmailDiscovery\\XML&quot; ;&#xd;&#xa;boolean filesPresent = false;&#xd;&#xa;&#xd;&#xa;File directory = new File(directoryName);&#xd;&#xa;if(directory.exists())&#xd;&#xa;{&#xd;&#xa;    File[] fList = directory.listFiles();&#xd;&#xa;    for (File file : fList) &#xd;&#xa;    {&#xd;&#xa;        if (file.isFile()) &#xd;&#xa;        {&#xd;&#xa;           if (file.getName().endsWith(&quot;.csv&quot;)) &#xd;&#xa;           {&#xd;&#xa;               filesPresent = true;&#xd;&#xa;               break;&#xd;&#xa;           }&#xd;&#xa;        }&#xd;&#xa;    }&#xd;&#xa;}&#xd;&#xa;if(!filesPresent)&#xd;&#xa;{&#xd;&#xa;    logger.info(&quot;Discovery File is not present &quot;);&#xd;&#xa;    workflow.setStatus(commvault.cte.common.workflow.ProcessStatus.FAILED);&#xd;&#xa;    workflow.setFailureReason(&quot;Failed to complete System Discovery Process. Please check logs from C:\\Windows\\Temp\\&quot; + xpath:{/workflow/system/jobId});&#xd;&#xa;}"/>

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>&lt;clientName />&lt;clientId />&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/WindowsUserName}&lt;/impersonateUserName>&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot;>xpath:{/workflow/inputs/WindowsUserPassword}&lt;/impersonateUserPassword>&lt;startUpPath class=&quot;java.lang.String&quot; />&lt;command class=&quot;java.lang.String&quot;>cmd.exe&lt;/command>&lt;arguments class=&quot;java.lang.String&quot;>/C &quot;cd /d &quot;xpath:{/workflow/variables/ClientInstallDir}\Base&quot; &amp;amp;&amp;amp; ExSysDiscoveryWrapper.exe -type xpath:{/workflow/variables/DiscoveryClientType} -input xpath:{/workflow/inputs/clientsNameFile} -output xpath:{/workflow/inputs/DiscoveryOutput}\xpath:{/workflow/system/jobId} -debug 4&quot;&lt;/arguments>&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="DisableLogging_2" commented="0"

            originalStyle="" points="" sourceX="1109" sourceY="379"

            status="0" style="defaultEdge" targetX="1056" targetY="145"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1389027225295" description="switch based decision"

        displayName="Client Types" height="100" interactive="0"

        jobMode="0" name="Switch"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Switch_2" waitSetting="0" width="111" x="633" y="309">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/clientType}&lt;/expression>&lt;/inputs>"/>

        <transition activity="ExecuteCommand_1" commented="0"

            displayName="WINDOWS" originalStyle="" points=""

            sourceX="506" sourceY="452" status="0" style="defaultEdge"

            targetX="509" targetY="326" transitionIndex="0"

            value="WINDOWS" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="ExecuteCommand_3" commented="0"

            displayName="Exchange" originalStyle="" points=""

            sourceX="514" sourceY="394" status="0" style="defaultEdge"

            targetX="509" targetY="540" transitionIndex="0"

            value="EXCHANGE" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="ExecuteCommand_4" commented="0"

            displayName="Unix" originalStyle="" points="" sourceX="514"

            sourceY="400" status="0" style="defaultEdge" targetX="804"

            targetY="398" transitionIndex="0" value="UNIX" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="ExecuteCommand_7" commented="0"

            displayName="NAS" originalStyle="" points="" sourceX="684"

            sourceY="312" status="0" style="defaultEdge" targetX="868"

            targetY="110" transitionIndex="0" value="NAS" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1389030444158" description="Execute a list of commands"

        displayName="UNIX Discovery" height="34" interactive="0"

        jobMode="0" maxRestarts="0" name="ExecuteCommand"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ExecuteCommand" uniqueName="ExecuteCommand_4"

        waitSetting="0" width="135" x="961" y="343">

        <onExit language="1" script="import java.io.*;&#xd;&#xa;String directoryName = xpath:{/workflow/inputs/DiscoveryOutput} + &quot;\\&quot; +xpath:{/workflow/system/jobId} + &quot;\\Clients\\&quot; + xpath:{/workflow/variables/DiscoveryClientName};&#xd;&#xa;boolean filesPresent = false;&#xd;&#xa;&#xd;&#xa;File directory = new File(directoryName);&#xd;&#xa;if(directory.exists())&#xd;&#xa;{&#xd;&#xa;    File[] fList = directory.listFiles();&#xd;&#xa;    for (File file : fList) &#xd;&#xa;    {&#xd;&#xa;        if (file.isFile()) &#xd;&#xa;        {&#xd;&#xa;           if (file.getName().endsWith(&quot;.cvf&quot;)) &#xd;&#xa;           {&#xd;&#xa;               filesPresent = true;&#xd;&#xa;               break;&#xd;&#xa;           }&#xd;&#xa;        }&#xd;&#xa;    }&#xd;&#xa;}&#xd;&#xa;if(!filesPresent)&#xd;&#xa;{&#xd;&#xa;    logger.info(&quot;Discovery File is not present &quot;);&#xd;&#xa;    workflow.setStatus(commvault.cte.common.workflow.ProcessStatus.FAILED);&#xd;&#xa;    workflow.setFailureReason(&quot;Failed to complete System Discovery Process. Please check logs from C:\\Windows\\Temp\\&quot; + xpath:{/workflow/system/jobId});&#xd;&#xa;}"/>

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>&lt;clientName />&lt;clientId />&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/WindowsUserName}&lt;/impersonateUserName>&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot;>xpath:{/workflow/inputs/WindowsUserPassword}&lt;/impersonateUserPassword>&lt;startUpPath class=&quot;java.lang.String&quot; />&lt;command class=&quot;java.lang.String&quot;>cmd.exe&lt;/command>&lt;arguments class=&quot;java.lang.String&quot;>/C &quot;cd /d &quot;xpath:{/workflow/variables/ClientInstallDir}\Base\CVSysDiscoveryUI64&quot; &amp;amp;&amp;amp; SysDiscoveryCmd.exe -type xpath:{/workflow/variables/DiscoveryClientType} -input xpath:{/workflow/inputs/clientsNameFile} -files -output  xpath:{/workflow/inputs/DiscoveryOutput}\xpath:{/workflow/system/jobId} -debug 4&quot;&lt;/arguments>&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="DisableLogging_2" commented="0"

            originalStyle="" points="" sourceX="917" sourceY="254"

            status="0" style="defaultEdge" targetX="1008" targetY="144"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1389199338422"

        description="activity to execute code snippets in the selected language"

        displayName="Operation Type" height="34" interactive="0"

        jobMode="0" name="Script"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Script"

        uniqueName="Script_3" waitSetting="0" width="132" x="312" y="82">

        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;String sql = &amp;quot;SELECT TOP 1 install_dir FROM APP_Platform WHERE clientId = ( SELECT id FROM App_Client WHERE name = ''&amp;quot;+xpath:{/workflow/inputs/analyticsEngine/mediaAgentName}+&amp;quot;'' )&amp;quot;;&amp;#xD;&amp;#xA;DataSet ds = csdb.execute(sql);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if (ds.hasNext())&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;ClientInstallDir&amp;quot;, ds.get(&amp;quot;install_dir&amp;quot;));&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;else&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    workflow.setFailed(&amp;quot;failed to retrieve install_dir&amp;quot;);&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;String commcell =  xpath:{/workflow/inputs/CommCellType};&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if( commcell.indexOf(&amp;quot;Remote&amp;quot;) &amp;gt; -1 )&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    return &amp;quot;CrossCommcell&amp;quot;;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;else&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    return xpath:{/workflow/inputs/appType};&amp;#xD;&amp;#xA;   //return &amp;quot;Data&amp;quot;;&amp;#xD;&amp;#xA;} &amp;#xD;&amp;#xA; &quot; />&lt;/inputs>"/>

        <transition activity="ExecuteCommand_5" commented="0"

            displayName="Cross Commcells" originalStyle="" points=""

            sourceX="201" sourceY="155" status="0" style="defaultEdge"

            targetX="84" targetY="648" transitionIndex="0" x="0" y="0">

            <condition language="1" script="return activity.output.equalsIgnoreCase(&quot;CrossCommcell&quot;)"/>

        </transition>

        <transition activity="Decision_6" commented="0"

            displayName="System Discovery" originalStyle="" points=""

            sourceX="378" sourceY="99" status="0" style="defaultEdge"

            targetX="372" targetY="185" transitionIndex="0" x="0" y="0">

            <condition language="1" script="return activity.output.equalsIgnoreCase(&quot;SystemDiscovery&quot;)&#xa;"/>

        </transition>

        <transition activity="DisableLogging_5" commented="0"

            displayName="File System \ NAS" originalStyle="" points=""

            sourceX="378" sourceY="99" status="0" style="defaultEdge"

            targetX="882" targetY="82" transitionIndex="0" x="0" y="0">

            <condition language="1" script="return activity.output.equalsIgnoreCase(&quot;FileSystem&quot;) || activity.output.equalsIgnoreCase(&quot;NAS&quot;) || activity.output.equalsIgnoreCase(&quot;CleanupAnalyticsEngine&quot;);"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1368553774280"

        description="activity to execute code snippets in the selected language"

        displayName="Create_ENV" height="34" interactive="0" jobMode="0"

        name="Script" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Script"

        uniqueName="CreateWorkingDir" waitSetting="0" width="127"

        x="142" y="842">

        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;import java.io.File;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;String WorkingDirPath =  xpath:{/workflow/inputs/DiscoveryOutput} + &amp;quot;\\&amp;quot; + xpath:{/workflow/system/jobId};&amp;#xD;&amp;#xA;logger.info(WorkingDirPath);&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;workingDirectory&amp;quot;, WorkingDirPath);&amp;#xD;&amp;#xA;File dir = new File(WorkingDirPath);&amp;#xD;&amp;#xA;dir.mkdirs();&amp;#xD;&amp;#xA;return dir.getAbsolutePath();&quot; />&lt;/inputs>"/>

        <transition activity="GetCommCells" commented="0"

            originalStyle="" points="" sourceX="267" sourceY="783"

            status="0" style="defaultEdge" targetX="417" targetY="654"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1368554466972"

        description="executes queries against the commserv database"

        displayName="Get_CommCell_Info" height="34" interactive="0"

        jobMode="0" name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=CommServDBQuery" uniqueName="GetCommCells"

        waitSetting="0" width="164" x="398" y="679">

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>select aliasName, id from APP_CommCell WHERE id &amp;gt; 2 AND aliasName like ''%xpath:{/workflow/inputs/remotecommcell}%''&lt;/query>&lt;/inputs>"/>

        <transition activity="Decision_5" commented="0" originalStyle=""

            points="" sourceX="503" sourceY="69" status="0"

            style="defaultEdge" targetX="500" targetY="142"

            transitionIndex="0" x="10" y="10">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1368555377748"

        description="iterates a group of activities over a list of values"

        displayName="PerformCCM" height="364" interactive="0"

        jobMode="0" name="ForEach"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="CCMIterator" waitSetting="0" width="532" x="67" y="915">

        <inputs val="&lt;inputs>&lt;name class=&quot;java.lang.String&quot;>row&lt;/name>&lt;values class=&quot;java.lang.Object&quot;>xpath:{/workflow/GetCommCells/resultSets/row}&lt;/values>&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot;>1&lt;/numberOfParallelExecutions>&lt;continueOnFailure class=&quot;java.lang.Boolean&quot;>false&lt;/continueOnFailure>&lt;/inputs>"/>

        <superProcess>

            <Start commented="0" continueOnFailure="0"

                created="1368555377748" description=""

                displayName="Start" height="30" interactive="0"

                jobMode="0" name="Start" originalStyle=""

                skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_7" waitSetting="0" width="120" x="17" y="41">

                <inputs val="&lt;inputs />"/>

                <transition activity="GetClientGroups" commented="0"

                    originalStyle="" points="" sourceX="77" sourceY="56"

                    status="0" style="defaultEdge" targetX="91"

                    targetY="142" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity commented="0" continueOnFailure="0"

                created="1368555523069"

                description="executes queries against the commserv database"

                displayName="Get_ClientGroup_ID" height="32"

                interactive="0" jobMode="0" name="CommServDBQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=CommServDBQuery"

                uniqueName="GetClientGroups" waitSetting="0" width="165"

                x="183" y="42">

                <inputs val="&lt;inputs>&lt;commCell>xpath:{/workflow/CCMIterator/row/col[1]}&lt;/commCell>&lt;query>SELECT id FROM APP_ClientGroup WHERE name = ''xpath:{/workflow/inputs/clientGroupName/clientGroupName}''&lt;/query>&lt;/inputs>"/>

                <transition activity="GetCommCellID" commented="0"

                    originalStyle="" points="" sourceX="258"

                    sourceY="56" status="0" style="defaultEdge"

                    targetX="376" targetY="56" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1368555626724"

                description="executes queries against the commserv database"

                displayName="Fetch_CCID" height="35" interactive="0"

                jobMode="0" name="CommServDBQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=CommServDBQuery"

                uniqueName="GetCommCellID" waitSetting="0" width="109"

                x="398" y="40">

                <inputs val="&lt;inputs>&lt;commCell>xpath:{/workflow/CCMIterator/row/col[1]}&lt;/commCell>&lt;query>SELECT number FROM APP_CommCell WHERE id=2&lt;/query>&lt;/inputs>"/>

                <transition activity="SQLInfo" commented="0"

                    originalStyle="" points="" sourceX="392"

                    sourceY="56" status="0" style="defaultEdge"

                    targetX="556" targetY="53" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1368556235804"

                description="activity to execute code snippets in the selected language"

                displayName="Set_Export_Path" height="34"

                interactive="0" jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Script" uniqueName="ExportFolder"

                waitSetting="0" width="143" x="10" y="162">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;import java.io.File;&amp;#xD;&amp;#xA;File exportDir = new File(xpath:{/workflow/CreateWorkingDir/output}, xpath:{/workflow/CCMIterator/row/col[1]}+&amp;quot;_ccmexport&amp;quot;);&amp;#xD;&amp;#xA;exportDir.mkdirs();&amp;#xD;&amp;#xA;return exportDir.getAbsolutePath();&quot; />&lt;/inputs>"/>

                <transition activity="CommServDBQuery_3" commented="0"

                    originalStyle="" points="" sourceX="81"

                    sourceY="180" status="0" style="defaultEdge"

                    targetX="213" targetY="180" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1368558314824"

                description="executes queries against the commserv database"

                displayName="Get_SQL_Creds" height="34" interactive="0"

                jobMode="0" name="CommServDBQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=CommServDBQuery" uniqueName="SQLInfo"

                waitSetting="0" width="137" x="366" y="105">

                <inputs val="&lt;inputs>&lt;commCell />&lt;query>Select CCHostName, sqlInstance, sqlAccessInfo From APP_CommCellInfo where commcellId = xpath:{/workflow/CCMIterator/row/col[2]}&lt;/query>&lt;/inputs>"/>

                <transition activity="SQLUserID" commented="0"

                    originalStyle="" points="" sourceX="559"

                    sourceY="56" status="0" style="defaultEdge"

                    targetX="691" targetY="58" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1368558958509"

                description="activity to execute code snippets in the selected language"

                displayName="Save_SQL_User" height="34" interactive="0"

                jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Script" uniqueName="SQLUserID"

                waitSetting="0" width="140" x="186" y="104">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;EncryptedString ec = new EncryptedString(xpath:{/workflow/SQLInfo/resultSets[1]/row[1]/col[@name=&amp;quot;sqlAccessInfo&amp;quot;]});&amp;#xD;&amp;#xA;String plainPass = ec.getPlainText();&amp;#xD;&amp;#xA;int ul = Integer.parseInt(plainPass.substring(0, 2));&amp;#xD;&amp;#xA;return plainPass.substring(2, 2+ul);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;&quot; />&lt;/inputs>"/>

                <transition activity="SQLPassword" commented="0"

                    originalStyle="" points="" sourceX="721"

                    sourceY="142" status="0" style="defaultEdge"

                    targetX="618" targetY="143" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1368558972586"

                description="activity to execute code snippets in the selected language"

                displayName="Save_SQL_pwd" height="34" interactive="0"

                jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Script" uniqueName="SQLPassword"

                waitSetting="0" width="137" x="18" y="104">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;EncryptedString ec = new EncryptedString(xpath:{/workflow/SQLInfo/resultSets[1]/row[1]/col[@name=&amp;quot;sqlAccessInfo&amp;quot;]});&amp;#xD;&amp;#xA;String plainPass = ec.getPlainText();&amp;#xD;&amp;#xA;int ul = Integer.parseInt(plainPass.substring(0, 2));&amp;#xD;&amp;#xA;return plainPass.substring(2+ul);&quot; />&lt;/inputs>"/>

                <transition activity="ExportFolder" commented="0"

                    originalStyle="" points="" sourceX="573"

                    sourceY="259" status="0" style="defaultEdge"

                    targetX="463" targetY="259" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1368561999533"

                description="waits until the list of jobs completes"

                displayName="Wait_For_Export" height="34"

                interactive="0" jobMode="0" name="WaitForJobCompletion"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=WaitForJobCompletion"

                uniqueName="WaitOnCaptureJob" waitSetting="0"

                width="144" x="188" y="230">

                <inputs val="&lt;inputs>&lt;jobId class=&quot;java.lang.Integer&quot; _list_=&quot;true&quot;>xpath:{/workflow/CommServDBQuery_1/resultSets[1]/row[1]/col[1]}&lt;/jobId>&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

                <transition activity="CommServDBQuery_2" commented="0"

                    originalStyle="" points="" sourceX="258"

                    sourceY="247" status="0" style="defaultEdge"

                    targetX="101" targetY="246" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1368562063035"

                description="waits until the list of jobs completes"

                displayName="Wait_For_Import" height="34"

                interactive="0" jobMode="0" name="WaitForJobCompletion"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=WaitForJobCompletion"

                uniqueName="WaitOnMergeJob" waitSetting="0" width="146"

                x="187" y="296">

                <inputs val="&lt;inputs>&lt;jobId class=&quot;java.lang.Integer&quot; _list_=&quot;true&quot;>xpath:{/workflow/CommServDBQuery_2/resultSets[1]/row[1]/col[1]}&lt;/jobId>&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1368654080001"

                description="executes queries against the commserv database"

                displayName="CCM_Export" height="34" interactive="0"

                jobMode="0" name="CommServDBQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=CommServDBQuery"

                uniqueName="CommServDBQuery_1" waitSetting="0"

                width="116" x="360" y="163">

                <inputs val="&lt;inputs>&lt;commCell />&lt;query>SET NOCOUNT ON&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;DECLARE @jobId BIGINT&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;EXEC @jobId = TM_GetNextJobId&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;DECLARE @i_userId INT = 1&amp;#xD;&#xd;&#xa;DECLARE @i_UserGUID NVARCHAR(100) = '''' -- ONLY NEEDED IF USERID IS NOT USED, OTHER WISE EMPTY&amp;#xD;&#xd;&#xa;DECLARE @i_sequenceNumber NVARCHAR(100) = ''12345'' -- FOR IMMEDIATE JOBS JOB MANAGER CHECKS FOR SEQUENCE NUMBER BEFORE STARTING &amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;DECLARE @xmlText XML&amp;#xD;&#xd;&#xa;SET @xmlText = ''&amp;lt;TMMsg_CreateTaskReq&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&amp;lt;taskInfo&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&amp;lt;appGroup /&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&amp;lt;associations _type_=&quot;0&quot;&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&amp;lt;flags exclude=&quot;0&quot; /&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&amp;lt;/associations&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&amp;lt;subTasks&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&amp;lt;options&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&amp;lt;adminOpts&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&amp;lt;ccmOption&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&amp;lt;captureOptions copyDumpToRemoteCS=&quot;0&quot;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;useJobResultsDirForExport=&quot;0&quot; lastHours=&quot;60&quot;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;isabsoluteOrRelativeTime=&quot;2&quot; pruneExportedDump=&quot;0&quot;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;autopickCluster=&quot;0&quot; remoteDumpDir=&quot;&quot; remoteCSName=&quot;&quot;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;captureMediaAgents=&quot;0&quot;&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&amp;lt;captureFromDB csName=&quot;xpath:{/workflow/CCMIterator/row/col[1]}&quot;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;csDbName=&quot;CommServ&quot; csNumber=&quot;xpath:{/workflow/GetCommCellID/resultSets[1]/row[1]/col[1]}&quot; /&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&amp;lt;entities _type_=&quot;28&quot; clientGroupName=&quot;xpath:{/workflow/inputs/clientGroupName/clientGroupName}&quot;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;clientGroupId=&quot;xpath:{/workflow/GetClientGroups/resultSets[1]/row[1]/col[1]}&quot; commCellName=&quot;xpath:{/workflow/CCMIterator/row/col[1]}&quot; /&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&amp;lt;timeRange TimeZoneID=&quot;0&quot; fromTime=&quot;0&quot; toTime=&quot;0&quot; /&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&amp;lt;/captureOptions&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&amp;lt;commonOptions dumpFolder=&quot;xpath:{/workflow/ExportFolder/output}&quot; pathType=&quot;0&quot;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;otherSqlInstance=&quot;1&quot;&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&amp;lt;sqlLinkedServer sqlServerName=&quot;xpath:{/workflow/SQLInfo/resultSets/row/col[@name=&quot;CCHostName&quot;]}\xpath:{/workflow/SQLInfo/resultSets/row/col[@name=&quot;sqlInstance&quot;]}&quot;&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&amp;lt;sqlUserAccount userName=&quot;xpath:{/workflow/SQLUserID/output}&quot;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;password=&quot;java:{utils.encodePassword(utils.encryptString(xpath:{/workflow/SQLPassword/output}))}&quot; /&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&amp;lt;/sqlLinkedServer&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&amp;lt;userAccount /&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&amp;lt;/commonOptions&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&amp;lt;/ccmOption&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&amp;lt;/adminOpts&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&amp;lt;backupOpts&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&amp;lt;vsaBackupOptions /&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&amp;lt;/backupOpts&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&amp;lt;commonOpts&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&amp;lt;jobRetryOpts enableNumberOfRetries=&quot;0&quot;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;killRunningJobWhenTotalRunningTimeExpires=&quot;0&quot; numberOfRetries=&quot;0&quot;&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&amp;lt;runningTime enableTotalRunningTime=&quot;0&quot;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;totalRunningTime=&quot;3600&quot; /&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&amp;lt;/jobRetryOpts&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&amp;lt;prePostOpts runPostWhenFail=&quot;0&quot;&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&amp;lt;impersonation level=&quot;0&quot;&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&amp;lt;user /&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&amp;lt;/impersonation&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&amp;lt;/prePostOpts&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&amp;lt;startUpOpts startInSuspendedState=&quot;0&quot; /&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&amp;lt;/commonOpts&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&amp;lt;restoreOptions&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&amp;lt;destination&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&amp;lt;destClient _type_=&quot;3&quot; /&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&amp;lt;/destination&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&amp;lt;/restoreOptions&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&amp;lt;serverOptions jobId=&quot;'' + cast(@jobId as varchar(50)) + ''&quot; /&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&amp;lt;/options&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&amp;lt;subTask operationType=&quot;4029&quot; subTaskType=&quot;1&quot; /&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&amp;lt;/subTasks&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&amp;lt;task initiatedFrom=&quot;2&quot; isEditing=&quot;0&quot; policyType=&quot;0&quot; taskType=&quot;1&quot;&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&amp;lt;taskFlags disabled=&quot;0&quot; /&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&amp;lt;/task&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&amp;lt;/taskInfo&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/TMMsg_CreateTaskReq&amp;gt;''&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;INSERT INTO TM_CreateTaskRequest (xmlValue, userId, GUID, localeId, sequenceNumber, processed, created)&amp;#xD;&#xd;&#xa;VALUES (@xmlText, @i_userId, @i_UserGUID, 0, @i_sequenceNumber, 0, dbo.getUnixTime(GetUTCDate()))&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;--SELECT @jobId&lt;/query>&lt;/inputs>"/>

                <transition activity="Delay_1" commented="0"

                    originalStyle="" points="" sourceX="418"

                    sourceY="180" status="0" style="defaultEdge"

                    targetX="425" targetY="257" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1368654529476"

                description="activity to delay the workflow execution in minutes"

                displayName="Process_Sleep" height="34" interactive="0"

                jobMode="0" name="Delay"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Delay" uniqueName="Delay_1"

                waitSetting="0" width="128" x="368" y="230">

                <inputs val="&lt;inputs>&lt;delayLength class=&quot;java.lang.Integer&quot;>30&lt;/delayLength>&lt;delayInterval class=&quot;workflow.types.DelayInterval&quot;>Seconds&lt;/delayInterval>&lt;/inputs>"/>

                <transition activity="WaitOnCaptureJob" commented="0"

                    originalStyle="" points="" sourceX="418"

                    sourceY="253" status="0" style="defaultEdge"

                    targetX="287" targetY="252" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1368654583404"

                description="executes queries against the commserv database"

                displayName="CCM_Import" height="34" interactive="0"

                jobMode="0" name="CommServDBQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=CommServDBQuery"

                uniqueName="CommServDBQuery_2" waitSetting="0"

                width="113" x="30" y="230">

                <inputs val="&lt;inputs>&lt;commCell />&lt;query>SET NOCOUNT ON&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;DECLARE @jobId BIGINT&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;EXEC @jobId = TM_GetNextJobId&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;DECLARE @i_userId INT = 1&amp;#xD;&#xd;&#xa;DECLARE @i_UserGUID NVARCHAR(100) = '''' -- ONLY NEEDED IF USERID IS NOT USED, OTHER WISE EMPTY&amp;#xD;&#xd;&#xa;DECLARE @i_sequenceNumber NVARCHAR(100) = ''12345'' -- FOR IMMEDIATE JOBS JOB MANAGER CHECKS FOR SEQUENCE NUMBER BEFORE STARTING &amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;DECLARE @xmlText XML&amp;#xD;&#xd;&#xa;SET @xmlText = ''&amp;lt;TMMsg_CreateTaskReq&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&amp;lt;taskInfo&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&amp;lt;associations _type_=&quot;0&quot; /&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&amp;lt;subTasks&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&amp;lt;options&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&amp;lt;adminOpts&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&amp;lt;ccmOption&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&amp;lt;commonOptions bRoboJob=&quot;0&quot;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;databaseConfiguredRemote=&quot;0&quot; dumpFolder=&quot;xpath:{/workflow/ExportFolder/output}&quot; pathType=&quot;0&quot;&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&amp;lt;userAccount /&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&amp;lt;/commonOptions&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&amp;lt;mergeOptions deleteEntitiesIfOnlyfromSource=&quot;0&quot;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;deleteEntitiesNotPresent=&quot;0&quot; failIfEntityAlreadyExists=&quot;0&quot;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;forceOverwrite=&quot;1&quot; forceOverwriteHolidays=&quot;0&quot;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;forceOverwriteOperationWindow=&quot;0&quot; forceOverwriteSchedule=&quot;0&quot;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;mergeActivityControl=&quot;0&quot; mergeHolidays=&quot;0&quot; mergeOperationWindow=&quot;0&quot;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;mergeSchedules=&quot;0&quot; pruneImportedDump=&quot;0&quot; reuseTapes=&quot;0&quot;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;skipConflictMedia=&quot;0&quot; specifyStagingPath=&quot;0&quot; stagingPath=&quot;C:\&quot; /&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&amp;lt;/ccmOption&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&amp;lt;/adminOpts&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&amp;lt;commonOpts&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&amp;lt;jobRetryOpts enableNumberOfRetries=&quot;0&quot;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;killRunningJobWhenTotalRunningTimeExpires=&quot;0&quot; numberOfRetries=&quot;0&quot;&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&amp;lt;runningTime enableTotalRunningTime=&quot;0&quot;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;totalRunningTime=&quot;3600&quot; /&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&amp;lt;/jobRetryOpts&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&amp;lt;startUpOpts startInSuspendedState=&quot;0&quot; /&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&amp;lt;/commonOpts&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&amp;lt;serverOptions jobId=&quot;'' + cast(@jobId as varchar(50)) + ''&quot; /&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&amp;lt;/options&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&amp;lt;subTask operationType=&quot;4030&quot; subTaskType=&quot;1&quot; /&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&amp;lt;/subTasks&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&amp;lt;task initiatedFrom=&quot;2&quot; taskType=&quot;1&quot;&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&amp;lt;taskFlags disabled=&quot;0&quot; /&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&amp;lt;/task&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&amp;lt;/taskInfo&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/TMMsg_CreateTaskReq&amp;gt;''&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;INSERT INTO TM_CreateTaskRequest (xmlValue, userId, GUID, localeId, sequenceNumber, processed, created)&amp;#xD;&#xd;&#xa;VALUES (@xmlText, @i_userId, @i_UserGUID, 0, @i_sequenceNumber, 0, dbo.getUnixTime(GetUTCDate()))&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;--SELECT @jobId&lt;/query>&lt;/inputs>"/>

                <transition activity="Delay_2" commented="0"

                    originalStyle="" points="" sourceX="84"

                    sourceY="247" status="0" style="defaultEdge"

                    targetX="93" targetY="313" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1368654790480"

                description="activity to delay the workflow execution in minutes"

                displayName="Process_Sleep" height="34" interactive="0"

                jobMode="0" name="Delay"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Delay" uniqueName="Delay_2"

                waitSetting="0" width="128" x="34" y="296">

                <inputs val="&lt;inputs>&lt;delayLength class=&quot;java.lang.Integer&quot;>30&lt;/delayLength>&lt;delayInterval class=&quot;workflow.types.DelayInterval&quot;>Seconds&lt;/delayInterval>&lt;/inputs>"/>

                <transition activity="WaitOnMergeJob" commented="0"

                    originalStyle="" points="" sourceX="84"

                    sourceY="313" status="0" style="defaultEdge"

                    targetX="213" targetY="317" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1369072569267"

                description="executes queries against the commserv database"

                displayName="Link_Server" height="34" interactive="0"

                jobMode="0" name="CommServDBQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=CommServDBQuery"

                uniqueName="CommServDBQuery_3" waitSetting="0"

                width="130" x="202" y="163">

                <inputs val="&lt;inputs>&lt;commCell />&lt;query>EXEC addSQL_LinkedServer 1, ''&amp;lt;TMMsg_SqlLinkedServer sqlServerName=&quot;xpath:{/workflow/SQLInfo/resultSets/row/col[@name=&quot;CCHostName&quot;]}\xpath:{/workflow/SQLInfo/resultSets/row/col[@name=&quot;sqlInstance&quot;]}&quot; linkedServerName=&quot;CCM_Export_LinkedServer&quot;&amp;gt;&amp;lt;sqlUserAccount userName=&quot;xpath:{/workflow/SQLUserID/output}&quot; password=&quot;xpath:{/workflow/SQLPassword/output}&quot; /&amp;gt;&amp;lt;/TMMsg_SqlLinkedServer&amp;gt;''&amp;#xD;&#xd;&#xa;&lt;/query>&lt;/inputs>"/>

                <transition activity="CommServDBQuery_1" commented="0"

                    originalStyle="" points="" sourceX="251"

                    sourceY="180" status="0" style="defaultEdge"

                    targetX="395" targetY="179" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

        </superProcess>

        <activitySchema>

            <outputs name="outputs">

                <children attribute="0"

                    className="workflow.types.data.DataRow"

                    defaultValue="" hidden="0"

                    inputType="workflow.types.data.DataRow" listType="0"

                    name="row" type="{workflow.types.data}DataRow">

                    <children attribute="0" className="java.lang.Object"

                        defaultValue="" hidden="0"

                        inputType="java.lang.Object" listType="1"

                        name="col" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                </children>

            </outputs>

            <inputs>

                <children className="java.lang.String"

                    inputType="java.lang.String" name="name" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children className="java.lang.Object"

                    inputType="java.lang.Object" name="values" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                <children className="java.lang.Integer" defaultValue="1"

                    inputType="java.lang.Integer"

                    name="numberOfParallelExecutions" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                <children className="java.lang.Boolean"

                    defaultValue="false" inputType="java.lang.Boolean"

                    name="continueOnFailure" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

            </inputs>

        </activitySchema>

        <transition activity="CommCellIterator" commented="0"

            originalStyle="" points="" sourceX="296" sourceY="1036"

            status="0" style="defaultEdge" targetX="934" targetY="459"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1368562413115"

        description="iterates a group of activities over a list of values"

        displayName="CommCells" height="634" interactive="0" jobMode="0"

        name="ForEach" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="1" style="swimlane"

        uniqueName="CommCellIterator" waitSetting="0" width="891"

        x="835" y="465">

        <inputs val="&lt;inputs>&lt;name class=&quot;java.lang.String&quot;>row&lt;/name>&lt;values class=&quot;java.lang.Object&quot;>xpath:{/workflow/GetCommCells/resultSets/row}&lt;/values>&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot;>1&lt;/numberOfParallelExecutions>&lt;continueOnFailure class=&quot;java.lang.Boolean&quot;>false&lt;/continueOnFailure>&lt;/inputs>"/>

        <superProcess>

            <Start commented="0" continueOnFailure="0"

                created="1368562413115" description=""

                displayName="Start" height="30" interactive="0"

                jobMode="0" name="Start" originalStyle=""

                skipAttempt="1"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_4" waitSetting="0" width="120" x="62" y="43">

                <inputs val="&lt;inputs />"/>

                <transition activity="CSWorkDirectory" commented="0"

                    originalStyle="" points="" sourceX="103"

                    sourceY="-51" status="0" style="defaultEdge"

                    targetX="268" targetY="-53" transitionIndex="0"

                    x="27" y="-104">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <onEnter language="1" script="logger.info(&quot;processing commcell [&quot; + xpath:{/workflow/CommCellIterator/row/col[@name=&quot;aliasName&quot;]} + &quot;]&quot;);"/>

            </Start>

            <Activity commented="0" continueOnFailure="0"

                created="1368564043938"

                description="activity to execute code snippets in the selected language"

                displayName="Read_Registry" height="30" interactive="0"

                jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="1"

                style="label;image=Script" uniqueName="GalaxyInstance"

                waitSetting="0" width="127" x="459" y="49">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;import com.sun.jna.platform.win32.Advapi32Util;&amp;#xD;&amp;#xA;import com.sun.jna.platform.win32.WinReg;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;String galaxyKey = &amp;quot;Software\\CommVault Systems\\Galaxy&amp;quot;;&amp;#xD;&amp;#xA;String[] ikeys = Advapi32Util.registryGetKeys(WinReg.HKEY_LOCAL_MACHINE, galaxyKey);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;for (String instance : ikeys) {&amp;#xD;&amp;#xA;&amp;#x9;if(instance.contains(&amp;quot;Instance&amp;quot;))&amp;#xD;&amp;#xA;&amp;#x9;{&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;String subkey = galaxyKey + &amp;quot;\\&amp;quot; + instance + &amp;quot;\\CommServe&amp;quot;;&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;String tempName = Advapi32Util.registryGetStringValue(WinReg.HKEY_LOCAL_MACHINE, subkey, &amp;quot;sCSCLIENTNAME&amp;quot;);&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;if (tempName.equalsIgnoreCase(xpath:{/workflow/CommCellIterator/row/col[1]}))  {&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;&amp;#x9;logger.info(&amp;quot;Instance found -- &amp;quot; + instance );&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;&amp;#x9;galaxyKey = &amp;quot;Software\\CommVault Systems\\Galaxy&amp;quot; + &amp;quot;\\&amp;quot; + instance + &amp;quot;\\Machines&amp;quot;;&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;&amp;#x9;ikeys = Advapi32Util.registryGetKeys(WinReg.HKEY_LOCAL_MACHINE, galaxyKey);&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;&amp;#x9;for (String machinename : ikeys) {&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;&amp;#x9;&amp;#x9;subkey = galaxyKey + &amp;quot;\\&amp;quot; + machinename;&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;&amp;#x9;&amp;#x9;tempName = Advapi32Util.registryGetStringValue(WinReg.HKEY_LOCAL_MACHINE, subkey, &amp;quot;sHOSTNAME&amp;quot;);&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;&amp;#x9;&amp;#x9;logger.info(&amp;quot;Found ma machine hostname as &amp;quot; + tempName );&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;&amp;#x9;&amp;#x9;workflow.setVariable(&amp;quot;mahostname&amp;quot;, tempName);&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;&amp;#x9;&amp;#x9;return instance;&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;&amp;#x9;}&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;}&amp;#xD;&amp;#xA;&amp;#x9;}&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;workflow.setFailureReason(&amp;quot;Mediaagent instance not found for commcell&amp;quot; + xpath:{/workflow/CommCellIterator/row/col[1]});&amp;#xD;&amp;#xA;throw new Exception(&amp;quot;could not find installed instance for commcell [&amp;quot; + xpath:{/workflow/CommCellIterator/row/col[1]} + &amp;quot;]&amp;quot;;&quot; />&lt;/inputs>"/>

                <transition activity="GalaxyBaseDir" commented="0"

                    originalStyle="" points="" sourceX="392"

                    sourceY="-51" status="0" style="defaultEdge"

                    targetX="496" targetY="-51" transitionIndex="0"

                    x="27" y="-104">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1368565280221"

                description="activity to execute code snippets in the selected language"

                displayName="Create_CSDIR" height="34" interactive="0"

                jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="1"

                style="label;image=Script" uniqueName="CSWorkDirectory"

                waitSetting="0" width="126" x="264" y="41">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;import java.io.File;&amp;#xD;&amp;#xA;File dir = new File(xpath:{/workflow/CreateWorkingDir/output}, xpath:{/workflow/CommCellIterator/row/col[1]}+&amp;quot;_&amp;quot;+xpath:{/workflow/CommCellIterator/row/col[2]});&amp;#xD;&amp;#xA;dir.mkdirs();&amp;#xD;&amp;#xA;return dir.getAbsolutePath();&quot; />&lt;/inputs>"/>

                <transition activity="GalaxyInstance" commented="0"

                    originalStyle="" points="" sourceX="257"

                    sourceY="-51" status="0" style="defaultEdge"

                    targetX="411" targetY="-51" transitionIndex="0"

                    x="27" y="-104">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1368565455521"

                description="executes queries against the commserv database"

                displayName="Get_Clients" height="34" interactive="0"

                jobMode="0" name="CommServDBQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="1"

                style="label;image=CommServDBQuery"

                uniqueName="GetMemberClients" waitSetting="0"

                width="111" x="663" y="134">

                <inputs val="&lt;inputs>&lt;commCell />&lt;query>DECLARE @ClientGroupId int = ( SELECT TOP 1 id FROM App_ClientGroup WHERE name = ''xpath:{/workflow/inputs/clientGroupName/clientGroupName}'' )&amp;#xD;&#xd;&#xa;DECLARE @ClientId int = 0&amp;#xD;&#xd;&#xa;DECLARE CurC CURSOR FORWARD_ONLY FOR ( SELECT id FROM App_Client WHERE origCCID = xpath:{/workflow/CommCellIterator/row/col[2]} AND id not in ( SELECT clientId FROM App_Commcell ) )&amp;#xD;&#xd;&#xa;OPEN CurC;&amp;#xD;&#xd;&#xa;FETCH NEXT FROM CurC into @ClientId;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;WHILE @@FETCH_STATUS = 0&amp;#xD;&#xd;&#xa;BEGIN&amp;#xD;&#xd;&#xa;&#x9;IF NOT EXISTS ( SELECT clientGroupId FROM APP_ClientGroupAssoc WHERE clientId = @ClientID AND clientGroupId = @ClientGroupId)&amp;#xD;&#xd;&#xa;&#x9;BEGIN&amp;#xD;&#xd;&#xa;&#x9;&#x9;INSERT INTO APP_ClientGroupAssoc VALUES ( @ClientGroupId, @ClientID )&amp;#xD;&#xd;&#xa;&#x9;END&amp;#xD;&#xd;&#xa;&#x9;FETCH NEXT FROM CurC into @ClientId&amp;#xD;&#xd;&#xa;END&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;SELECT id as clientId, name as clientName &amp;#xD;&#xd;&#xa;FROM APP_Client &amp;#xD;&#xd;&#xa;WHERE origCCId = xpath:{/workflow/CommCellIterator/row/col[2]} AND id not in ( SELECT clientId FROM App_Commcell )&amp;#xD;&#xd;&#xa;&lt;/query>&lt;/inputs>"/>

                <transition activity="SET_FLA" commented="0"

                    originalStyle="" points="" sourceX="820"

                    sourceY="35" status="0" style="defaultEdge"

                    targetX="491" targetY="39" transitionIndex="0"

                    x="27" y="-104">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1368567026082"

                description="activity to execute code snippets in the selected language"

                displayName="Get_Base" height="34" interactive="0"

                jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="1"

                style="label;image=Script" uniqueName="GalaxyBaseDir"

                waitSetting="0" width="106" x="661" y="42">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;import com.sun.jna.platform.win32.Advapi32Util;&amp;#xD;&amp;#xA;import com.sun.jna.platform.win32.WinReg;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;//return Advapi32Util.registryGetExpandableStringValue(WinReg.HKEY_LOCAL_MACHINE, baseKey, &amp;quot;dBASEHOME&amp;quot;);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;String baseKey = &amp;quot;Software\\CommVault Systems\\Galaxy\\&amp;quot;+xpath:{/workflow/GalaxyInstance/output}+&amp;quot;\\Base&amp;quot;;&amp;#xD;&amp;#xA;TreeMap map = Advapi32Util.registryGetValues(WinReg.HKEY_LOCAL_MACHINE, baseKey);&amp;#xD;&amp;#xA;return map.get(&amp;quot;dBASEHOME&amp;quot;);&amp;#xD;&amp;#xA;&quot; />&lt;/inputs>"/>

                <transition activity="GetMemberClients" commented="0"

                    originalStyle="" points="" sourceX="736"

                    sourceY="53" status="0" style="defaultEdge"

                    targetX="735" targetY="142" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1386713005126"

                description="executes queries against the commserv database"

                displayName="Set FLA Params" height="34" interactive="0"

                jobMode="0" name="CommServDBQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="1"

                style="label;image=CommServDBQuery" uniqueName="SET_FLA"

                waitSetting="0" width="135" x="366" y="134">

                <inputs val="&lt;inputs>&lt;commCell />&lt;query>SET NOCOUNT ON&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;DECLARE @ExchangeCommClientName varchar(max) = ''xpath:{/workflow/variables/ExchClient}''&amp;#xD;&#xd;&#xa;DECLARE @AnalyticsEngine varchar(max) = ''xpath:{/workflow/inputs/analyticsEngine/mediaAgentName}''&amp;#xD;&#xd;&#xa;DECLARE @ClientGroupName varchar(max) = ''xpath:{/workflow/inputs/clientGroupName/clientGroupName}''&amp;#xD;&#xd;&#xa;DECLARE @OperationType varchar(max) = ''xpath:{/workflow/inputs/appType}''&amp;#xD;&#xd;&#xa;DECLARE @OSType varchar(max) = ''xpath:{/workflow/inputs/clientType}''&amp;#xD;&#xd;&#xa;DECLARE @ClientNameFile varchar(max) = ''xpath:{/workflow/inputs/clientsNameFile}''&amp;#xD;&#xd;&#xa;DECLARE @CurrentDiscoveredClients varchar(max) = ''('' + ''xpath:{/workflow/variables/DiscoveredClients}'' + '')''&amp;#xD;&#xd;&#xa;DECLARE @JobId int = xpath:{/workflow/system/jobId}&amp;#xD;&#xd;&#xa;DECLARE @ClientName varchar(max) = ''''&amp;#xD;&#xd;&#xa;DECLARE @EngineName varchar (max) = ''''&amp;#xD;&#xd;&#xa;DECLARE @ClientId int = 0&amp;#xD;&#xd;&#xa;DECLARE @EngineMAId int = 0&amp;#xD;&#xd;&#xa;DECLARE @CloudId int = 0&amp;#xD;&#xd;&#xa;DECLARE @OrigCCID int = 0&amp;#xD;&#xd;&#xa;DECLARE @AppId int = 0&amp;#xD;&#xd;&#xa;DECLARE @ExchangeInstance int = 0&amp;#xD;&#xd;&#xa;DECLARE @PruneSOLRData int = 0&amp;#xD;&#xd;&#xa;DECLARE @ArchFileId int = 0&amp;#xD;&#xd;&#xa;DECLARE @VMname varchar(max) = ''''&amp;#xD;&#xd;&#xa;DECLARE @CSVPath varchar(max) = ''''&amp;#xD;&#xd;&#xa;DECLARE @BackupSetID int = 1&amp;#xD;&#xd;&#xa;DECLARE @EngineInstanceName varchar(max) = ''''&amp;#xD;&#xd;&#xa;DECLARE @ClientGroupId int = 0&amp;#xD;&#xd;&#xa;DECLARE @VSASubID int = 0&amp;#xD;&#xd;&#xa;DECLARE @AppType int = 33&amp;#xD;&#xd;&#xa;DECLARE @DataArchGroupId int = 1&amp;#xD;&#xd;&#xa;DECLARE @AppGroup varchar(max) = ''''&amp;#xD;&#xd;&#xa;DECLARE @DiscoveryClientName varchar(max) = '' ''&amp;#xD;&#xd;&#xa;DECLARE @ReleaseID int = 16&amp;#xD;&#xd;&#xa;DECLARE @CommandTable TABLE ( ClientName varchar(max), ClientId int, AnalyticsEngine varchar(max) , SubclientId int, BackupSetId int ,VMname varchar(max) , CSVPath varchar(max) , AppType int, EngineMAId int, VSASubClientID int, PruneSOLRData int, InstanceName varchar(max) ) &amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;IF @OperationType like ''%FileSystem%'' OR @OperationType like ''%NAS%'' &amp;#xD;&#xd;&#xa;BEGIN&amp;#xD;&#xd;&#xa;&#x9;SET @AppGroup = ''File System''&#x9;&amp;#xD;&#xd;&#xa;END&amp;#xD;&#xd;&#xa;ELSE IF @OperationType like ''%Exchange%''&amp;#xD;&#xd;&#xa;BEGIN&#x9;&amp;#xD;&#xd;&#xa;    SET @AppType = 54&amp;#xD;&#xd;&#xa;&#x9;SET @AppGroup = ''Mailbox''&#x9;&#x9;&amp;#xD;&#xd;&#xa;END&amp;#xD;&#xd;&#xa;ELSE IF @OperationType like ''%Sharepoint%''&amp;#xD;&#xd;&#xa;BEGIN&amp;#xD;&#xd;&#xa;&#x9;SET @AppGroup = ''Sharepoint''&#x9;&#x9;&amp;#xD;&#xd;&#xa;END&amp;#xD;&#xd;&#xa;ELSE IF @OperationType like ''%All%''&amp;#xD;&#xd;&#xa;BEGIN&amp;#xD;&#xd;&#xa;&#x9;SET @AppGroup = ''''&#x9;&#x9;&amp;#xD;&#xd;&#xa;END&amp;#xD;&#xd;&#xa;ELSE IF @OperationType like ''%Discovery%'' OR @OperationType like ''%Virtual%''&amp;#xD;&#xd;&#xa;BEGIN&amp;#xD;&#xd;&#xa;&#x9;IF @OSType like ''%EXCH%''&amp;#xD;&#xd;&#xa;&#x9;BEGIN&amp;#xD;&#xd;&#xa;&#x9;&#x9;SET @AppType = 54&amp;#xD;&#xd;&#xa;&#x9;END&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;IF @OSType like ''%WIN%''&amp;#xD;&#xd;&#xa;&#x9;BEGIN&amp;#xD;&#xd;&#xa;&#x9;&#x9;SET @AppType = 33&amp;#xD;&#xd;&#xa;&#x9;END&#x9;&#x9;&amp;#xD;&#xd;&#xa;    IF @OSType like ''%NAS%''&amp;#xD;&#xd;&#xa;&#x9;BEGIN&amp;#xD;&#xd;&#xa;&#x9;&#x9;SET @AppType = 13&amp;#xD;&#xd;&#xa;&#x9;END&#x9;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;IF @OSType like ''%UNIX%'' &amp;#xD;&#xd;&#xa;&#x9;BEGIN&amp;#xD;&#xd;&#xa;&#x9;&#x9;SET @AppType = 29&amp;#xD;&#xd;&#xa;&#x9;END&#x9;&#x9;&#x9;&#x9;&amp;#xD;&#xd;&#xa;END&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;SET @CloudId  = ( SELECT TOP 1 CloudId FROM DM2SearchServerCoreInfo S,APP_Client,DM2CloudCoreRole R WHERE ClientId=id AND name = @AnalyticsEngine AND s.CloudId = R.CloudId )&amp;#xD;&#xd;&#xa;SET @EngineMAId = ( SELECT TOP 1 id FROM APP_Client WHERE name = @AnalyticsEngine )&amp;#xD;&#xd;&#xa;SET @EngineName = ( SELECT TOP 1 net_hostname FROM APP_Client WHERE name = @AnalyticsEngine )&amp;#xD;&#xd;&#xa;SET @ClientGroupId = ( SELECT TOP 1 id FROM APP_ClientGroup WHERE name = @ClientGroupName  )&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;DECLARE CurC CURSOR FORWARD_ONLY FOR ( SELECT name FROM App_Client,APP_ClientGroupAssoc WHERE clientGroupId = @ClientGroupId AND id = clientId );&amp;#xD;&#xd;&#xa;OPEN CurC;&amp;#xD;&#xd;&#xa;FETCH NEXT FROM CurC into @ClientName;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;-- Set the Engine InstanceName&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;SET @EngineInstanceName = ( SELECT attrVal FROM APP_ClientProp WHERE attrName= ''Galaxy Instance name'' and componentNameId=@EngineMAId ) &amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;--- Loop for each Client&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;WHILE @@FETCH_STATUS = 0&amp;#xD;&#xd;&#xa;BEGIN&#x9;&amp;#xD;&#xd;&#xa;&#x9;&amp;#xD;&#xd;&#xa;&#x9;SET @ClientId = ( SELECT id FROM App_Client WHERE name = @ClientName )&#x9;&amp;#xD;&#xd;&#xa;&#x9;SET @OrigCCID = ( SELECT origCCId FROM APP_Client WHERE id = @ClientId ) &amp;#xD;&#xd;&#xa;&#x9;&amp;#xD;&#xd;&#xa;   &#x9;-- Do this only for clean up operations&amp;#xD;&#xd;&#xa;&#x9;&amp;#xD;&#xd;&#xa;&#x9;IF ( @OperationType like ''%Cleanup%'' )&amp;#xD;&#xd;&#xa;&#x9;BEGIN&amp;#xD;&#xd;&#xa;&#x9;&#x9;SET @PruneSOLRData = 2&amp;#xD;&#xd;&#xa;&#x9;&#x9;DECLARE SubClientCursor CURSOR FORWARD_ONLY FOR &amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;SELECT id,backupSet,appTypeId FROM APP_Application WHERE clientId = @ClientId &#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;AND id IN ( SELECT appId FROM archFile WHERE id IN ( SELECT archFileId FROM archFLAIndexingInfo WHERE cloudId=@CloudId ) )&amp;#xD;&#xd;&#xa;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;OPEN SubClientCursor;&amp;#xD;&#xd;&#xa;&#x9;&#x9;FETCH NEXT FROM SubClientCursor INTO @AppId, @BackupSetId, @AppType&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;WHILE @@FETCH_STATUS = 0&amp;#xD;&#xd;&#xa;&#x9;&#x9;BEGIN&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;                &amp;#xD;&#xd;&#xa;            DELETE FROM archFLAIndexingInfo WHERE archFileId in ( SELECT id FROM archFile WHERE appId = @AppId ) AND cloudId = @CloudId&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;INSERT @CommandTable ( ClientName , ClientId , AnalyticsEngine , SubclientId ,BackupSetId, VMname  , CSVPath , AppType , EngineMAId , VSASubClientID , PruneSOLRData, InstanceName )  VALUES ( @ClientName,@ClientId, @EngineName, @AppId, @BackupSetID, @VMname, @CSVPath , @AppType , @EngineMAId , @AppId , @PruneSOLRData, @EngineInstanceName )&#x9;&#x9;&#x9;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;FETCH NEXT FROM SubClientCursor INTO @AppId, @BackupSetId, @AppType&amp;#xD;&#xd;&#xa;&#x9;&#x9;END&amp;#xD;&#xd;&#xa;&#x9;&#x9;CLOSE SubClientCursor&amp;#xD;&#xd;&#xa;&#x9;&#x9;DEALLOCATE SubClientCursor&amp;#xD;&#xd;&#xa;&#x9;END&amp;#xD;&#xd;&#xa;&#x9;&amp;#xD;&#xd;&#xa;&#x9;-- Do this only for System Discovery and VSA&amp;#xD;&#xd;&#xa;&#x9;&amp;#xD;&#xd;&#xa;&#x9;IF ( @OperationType like ''%Virtual%'' OR @OperationType like ''%Discovery%'' OR @OrigCCID &amp;gt; 2 )&amp;#xD;&#xd;&#xa;&#x9;BEGIN&#x9;&#x9;&#x9;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;-- Insert subclient if not there already and use BackupSetId as 1 always&#x9;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;IF NOT EXISTS ( SELECT id FROM APP_Application WHERE clientId = @ClientId AND subclientName not like ''IndexingSubclient'' )&amp;#xD;&#xd;&#xa;&#x9;&#x9;BEGIN&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;INSERT INTO APP_InstanceName VALUES ( ''CVFLA_defaultInstance'',0,0,0,0,0,@OrigCCID,NEWID())&amp;#xD;&#xd;&#xa;&#x9;&#x9;    SET @ExchangeInstance = ( SELECT TOP 1 id FROM APP_InstanceName ORDER BY id DESC )&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;INSERT INTO APP_Application VALUES ( @ClientId,@AppType,@ExchangeInstance,1,0,1,1,0,0,''CV_FLA_DUMMY'',0,0,0,@OrigCCID,NEWID()) &#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;END&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&#x9;&#x9;SET @AppId = ( SELECT TOP 1 id FROM APP_Application WHERE clientId = @ClientId AND subclientName not like ''IndexingSubclient'' )&amp;#xD;&#xd;&#xa;&#x9;&#x9;SET @DataArchGroupId = ( SELECT dataArchGrpID FROM APP_Application WHERE id = @AppId )&amp;#xD;&#xd;&#xa;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;IF @OSType like ''%EXCH%''&amp;#xD;&#xd;&#xa;&#x9;&#x9;BEGIN&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;SET @ExchangeInstance = ( SELECT instance FROM APP_Application WHERE id = @AppId )&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;IF NOT EXISTS ( SELECT * FROM APP_InstanceProp WHERE attrName = ''Server Name'' AND componentNameId = @ExchangeInstance )&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;BEGIN&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;INSERT INTO APP_InstanceProp VALUES (@ExchangeInstance,''Server Name'',1,''''+@ClientName+'''',(SELECT DATEDIFF(s, ''1970-01-01 00:00:00'', GETUTCDATE())),0,0 )&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;END&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;UPDATE APP_Application SET appTypeId = 54 WHERE id = @AppId&amp;#xD;&#xd;&#xa;&#x9;&#x9;END&amp;#xD;&#xd;&#xa;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;-- Insert archFile if not there or update ctime&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&#x9;&#x9;IF  @AppId is not null &amp;#xD;&#xd;&#xa;&#x9;&#x9;BEGIN&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;IF NOT EXISTS ( SELECT id FROM archFile WHERE appId = @AppId AND fileType = 1 and isValid = 1 )&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;BEGIN&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;INSERT INTO archFile VALUES ( ''CV_FLA_DUMMY_ARCHFILE'',@OrigCCID,@DataArchGroupId,'''',0,@AppId,1,(SELECT DATEDIFF(s, ''1970-01-01 00:00:00'', (SELECT DATEADD(DAY,90,GETUTCDATE())))),0,1,1,0,0,0 )&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;END&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;ELSE&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;UPDATE archFile SET cTime = (SELECT DATEDIFF(s, ''1970-01-01 00:00:00'', (SELECT DATEADD(DAY,90,GETUTCDATE())))) WHERE appId = @AppId AND name like ''CV_FLA_DUMMY_ARCHFILE'' &amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;-- Add archFLAIndexingInfo record for archFile if not there else update indexTime&#x9;&#x9;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;IF NOT EXISTS ( SELECT archFileId FROM archFLAIndexingInfo WHERE archFileId in ( SELECT id FROM archFile WHERE appId = @AppId and archGroupId = @DataArchGroupId and fileType = 1) AND cloudId = @CloudId )&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;BEGIN&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;-- Get the latest archFile which is not already in FLA table against different clouds and put it in archFLAIndexingInfo&#x9;&#x9;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;IF NOT EXISTS ( SELECT TOP 1 id FROM archFile WHERE id not in ( SELECT archFileId FROM archFLAIndexingInfo ) AND appId = @AppId and archGroupId = @DataArchGroupId and fileType = 1 and isValid = 1 ORDER BY cTime DESC )&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;BEGIN&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;INSERT INTO archFile VALUES ( ''CV_FLA_DUMMY_ARCHFILE'',@OrigCCID,@DataArchGroupId,'''',0,@AppId,1,(SELECT DATEDIFF(s, ''1970-01-01 00:00:00'', (SELECT DATEADD(DAY,90,GETUTCDATE())))),0,1,1,0,0,0 )&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;END&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;SET @ArchFileId = ( SELECT TOP 1 id FROM archFile WHERE id not in ( SELECT archFileId FROM archFLAIndexingInfo ) AND appId = @AppId and archGroupId = @DataArchGroupId and fileType = 1 and isValid = 1 ORDER BY cTime DESC )&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;IF @ArchFileId &amp;gt; 1&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;BEGIN&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;INSERT INTO archFLAIndexingInfo VALUES ( @ArchFileId,@OrigCCID,0,0,(SELECT DATEDIFF(s, ''1970-01-01 00:00:00'', GETUTCDATE())),@CloudId,@AppId,@ClientName,@ClientId )&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;END &#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;END&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;ELSE&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;BEGIN&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;    SET @ArchFileId = ( SELECT TOP 1 archFileId FROM archFLAIndexingInfo WHERE archFileId in ( SELECT id FROM archFile WHERE appId = @AppId and archGroupId = @DataArchGroupId  and fileType = 1) AND cloudId = @CloudId )&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;UPDATE archFLAIndexingInfo SET indexTime = (SELECT DATEDIFF(s, ''1970-01-01 00:00:00'', GETUTCDATE())) WHERE archFileId = @ArchFileId&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;END&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;END&amp;#xD;&#xd;&#xa;&#x9;END&amp;#xD;&#xd;&#xa;&#x9;&amp;#xD;&#xd;&#xa;&#x9;-- IF PSEUDO CLIENT, SET CSV PATH&amp;#xD;&#xd;&#xa;&#x9;&amp;#xD;&#xd;&#xa;&#x9;IF ( @OperationType like ''%Discovery%'' AND @AppId is not null )&amp;#xD;&#xd;&#xa;&#x9;BEGIN&amp;#xD;&#xd;&#xa;&#x9;&#x9;IF ( @OSType like ''%windows%'' )&amp;#xD;&#xd;&#xa;&#x9;&#x9;BEGIN&amp;#xD;&#xd;&#xa;&#x9;&#x9;   SET @OSType = ''WIN''&amp;#xD;&#xd;&#xa;&#x9;&#x9;END&amp;#xD;&#xd;&#xa;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;SET @PruneSOLRData = 1&amp;#xD;&#xd;&#xa;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;IF @OSType like ''%EXCH%'' and @AppType = 54&amp;#xD;&#xd;&#xa;&#x9;&#x9;BEGIN&amp;#xD;&#xd;&#xa;&#x9;&#x9;    SET @PruneSOLRData = 0&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;SET @CSVPath = ''xpath:{/workflow/inputs/DiscoveryOutput}\'' + CONVERT(varchar(max),@JobId) + ''\EmailDiscovery\XML\ExSysDiscoveryOutput.csv''&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;END&amp;#xD;&#xd;&#xa;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;IF @OSType like ''%NAS%'' and @ClientNameFile like ''%Generate File for NAS Subclients%''&amp;#xD;&#xd;&#xa;        BEGIN&amp;#xD;&#xd;&#xa;            SET @OSType = ''WIN''&amp;#xD;&#xd;&#xa;        END    &amp;#xD;&#xd;&#xa;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;IF @OSType like ''%NAS%'' and @AppType = 13&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;BEGIN&amp;#xD;&#xd;&#xa;&#x9;&#x9;  SET @DiscoveryClientName = ''EMPTY''&amp;#xD;&#xd;&#xa;&#x9;&#x9;  &amp;#xD;&#xd;&#xa;&#x9;&#x9;  IF(Charindex(''__'',@ClientName) &amp;gt; 0 AND Charindex(@ClientName,@CurrentDiscoveredClients) &amp;gt; 0 )&amp;#xD;&#xd;&#xa;&#x9;&#x9;  BEGIN&amp;#xD;&#xd;&#xa;&#x9;&#x9;      SET @DiscoveryClientName = ( SELECT ltrim(rtrim(Substring(@ClientName,1,Charindex(''__'',@ClientName)-1))) )&amp;#xD;&#xd;&#xa;&#x9;&#x9;  END&amp;#xD;&#xd;&#xa;&#x9;&#x9;  ELSE IF(Charindex(@ClientName,@CurrentDiscoveredClients) &amp;gt; 0)&amp;#xD;&#xd;&#xa;&#x9;&#x9;  BEGIN&amp;#xD;&#xd;&#xa;&#x9;&#x9;      SET @DiscoveryClientName = @ClientName&amp;#xD;&#xd;&#xa;&#x9;&#x9;  END &amp;#xD;&#xd;&#xa;&#x9;&#x9;      &amp;#xD;&#xd;&#xa;&#x9;&#x9;  SET @CSVPath = ''xpath:{/workflow/inputs/DiscoveryOutput}\'' + CONVERT(varchar(max),@JobId) + ''\Clients\'' + @DiscoveryClientName + ''\analysis_WIN_'' + @DiscoveryClientName + ''.cvf''&amp;#xD;&#xd;&#xa;&#x9;&#x9;  &amp;#xD;&#xd;&#xa;&#x9;&#x9;END&amp;#xD;&#xd;&#xa;&#x9;&#x9;ELSE&amp;#xD;&#xd;&#xa;&#x9;&#x9;BEGIN&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;SET @CSVPath = ''xpath:{/workflow/inputs/DiscoveryOutput}\'' + CONVERT(varchar(max),@JobId) + ''\Clients\'' + @ClientName + ''\analysis_'' + @OSType + ''_'' + @ClientName + ''.cvf''&amp;#xD;&#xd;&#xa;&#x9;&#x9;END&amp;#xD;&#xd;&#xa;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;SET @BackupSetID = 0&amp;#xD;&#xd;&#xa;&#x9;&#x9;SET @VSASubID = @AppId&amp;#xD;&#xd;&#xa;&#x9;&#x9;SET @VMname = ''''&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&amp;#xD;&#xd;&#xa;        IF  @ExchangeCommClientName = @ClientName and @OSType like ''%EXCH%''&amp;#xD;&#xd;&#xa;        BEGIN&amp;#xD;&#xd;&#xa;          INSERT @CommandTable ( ClientName , ClientId , AnalyticsEngine , SubclientId ,BackupSetId, VMname  , CSVPath , AppType , EngineMAId , VSASubClientID , PruneSOLRData, InstanceName )  VALUES ( @ClientName,@ClientId, @EngineName, @AppId, @BackupSetID, @VMname, @CSVPath , @AppType , @EngineMAId , @VSASubID , @PruneSOLRData, @EngineInstanceName )&amp;#xD;&#xd;&#xa;        END&amp;#xD;&#xd;&#xa;        &amp;#xD;&#xd;&#xa;        IF  @OSType like ''%NAS%'' AND @DiscoveryClientName not like ''%EMPTY%''&amp;#xD;&#xd;&#xa;        BEGIN&amp;#xD;&#xd;&#xa;          INSERT @CommandTable ( ClientName , ClientId , AnalyticsEngine , SubclientId ,BackupSetId, VMname  , CSVPath , AppType , EngineMAId , VSASubClientID , PruneSOLRData, InstanceName )  VALUES ( @ClientName,@ClientId, @EngineName, @AppId, @BackupSetID, @VMname, @CSVPath , @AppType , @EngineMAId , @VSASubID , @PruneSOLRData, @EngineInstanceName )&amp;#xD;&#xd;&#xa;        END               &amp;#xD;&#xd;&#xa;        ELSE IF @OSType not like ''%NAS%'' AND @OSType not like ''%EXCH%'' -- FOR all other        &amp;#xD;&#xd;&#xa;        BEGIN&amp;#xD;&#xd;&#xa;          INSERT @CommandTable ( ClientName , ClientId , AnalyticsEngine , SubclientId ,BackupSetId, VMname  , CSVPath , AppType , EngineMAId , VSASubClientID , PruneSOLRData, InstanceName )  VALUES ( @ClientName,@ClientId, @EngineName, @AppId, @BackupSetID, @VMname, @CSVPath , @AppType , @EngineMAId , @VSASubID , @PruneSOLRData, @EngineInstanceName )&amp;#xD;&#xd;&#xa;        END&amp;#xD;&#xd;&#xa;&#x9;&amp;#xD;&#xd;&#xa;&#x9;END&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&#x9;-- IF VSA &amp;#xD;&#xd;&#xa;&#x9;&amp;#xD;&#xd;&#xa;&#x9;ELSE IF EXISTS ( SELECT VMclientId FROM APP_VMProp WHERE VMclientId = @ClientId ) AND @OperationType like ''%Virtual%'' AND  @AppId is not null &amp;#xD;&#xd;&#xa;&#x9;BEGIN&amp;#xD;&#xd;&#xa;&#x9;&#x9;SET @VMname = @ClientName&amp;#xD;&#xd;&#xa;&#x9;&#x9;SET @ClientName = ( SELECT TOP 1 name FROM APP_Client WHERE id in&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;( SELECT clientId FROM APP_Application WHERE id in&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;( SELECT appId FROM JMBkpStats WHERE jobId in&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;( SELECT max(jobId) FROM APP_VMProp WHERE VMclientId = @ClientId ))))&#x9;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&#x9;&#x9;SET @VSASubID = ( SELECT TOP 1 appId FROM JMBkpStats WHERE jobId in  &amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;  ( SELECT max(jobId) FROM APP_VMProp WHERE VMclientId = @ClientId ))&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&#x9;&#x9;SET @BackupSetID = ( SELECT TOP 1 id FROM APP_BackupSetName WHERE id in &amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;( SELECT backupSet FROM APP_Application WHERE id = @VSASubID ))&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;SET @CSVPath = ''''&amp;#xD;&#xd;&#xa;&#x9;&#x9;SET @PruneSOLRData = 1&amp;#xD;&#xd;&#xa;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;INSERT @CommandTable ( ClientName , ClientId , AnalyticsEngine , SubclientId ,BackupSetId, VMname  , CSVPath , AppType , EngineMAId , VSASubClientID , PruneSOLRData, InstanceName )  VALUES ( @ClientName,@ClientId, @EngineName, @AppId, @BackupSetID, @VMname, @CSVPath , 106 , @EngineMAId , @VSASubID , @PruneSOLRData, @EngineInstanceName )&amp;#xD;&#xd;&#xa;&#x9;END&amp;#xD;&#xd;&#xa;&#x9;&amp;#xD;&#xd;&#xa;&#x9;-- Else for WINFS\UNIXFS\EXCHANGE\SHAREPOINT\NAS-NDMP\Cleanup ADD rows for every Subclient&amp;#xD;&#xd;&#xa;&#x9;ELSE IF @AppId is not null AND @OperationType not like ''%Cleanup%''&amp;#xD;&#xd;&#xa;&#x9; &amp;#xD;&#xd;&#xa;&#x9;BEGIN&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;DECLARE SubClientCursor CURSOR FORWARD_ONLY FOR &amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;SELECT id,backupSet,appTypeId FROM APP_Application WHERE clientId = @ClientId AND appTypeId in (&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;SELECT appTypeId FROM App_AppTypeGroups WHERE ( appGroup like ''%'' + @AppGroup + ''%'' ) OR ( App like ''%'' + @AppGroup + ''%'' ) ) AND (&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;subclientStatus &amp;amp; 16 &amp;lt;&amp;gt; 16 and subclientStatus &amp;amp; 32 &amp;lt;&amp;gt; 32 and subclientStatus &amp;amp; 4 &amp;lt;&amp;gt; 4 and subclientStatus &amp;lt;&amp;gt; 2 ) &amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;AND subclientName not like ''%IndexingSubclient%'' AND subclientName not like ''%DDBBackup%''&amp;#xD;&#xd;&#xa;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;OPEN SubClientCursor;&amp;#xD;&#xd;&#xa;&#x9;&#x9;FETCH NEXT FROM SubClientCursor INTO @AppId, @BackupSetId, @AppType&amp;#xD;&#xd;&#xa;&#x9;&#x9;SET @PruneSOLRData = 1&amp;#xD;&#xd;&#xa;&#x9;&#x9;WHILE @@FETCH_STATUS = 0&amp;#xD;&#xd;&#xa;&#x9;&#x9;BEGIN&#x9;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;-- Check if it has any valid data archive file &amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;IF EXISTS ( SELECT id FROM archFile WHERE appId = @AppId and fileType = 1 and isValid = 1 )&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;BEGIN&amp;#xD;&#xd;&#xa;                IF NOT EXISTS ( SELECT archFileId FROM archFLAIndexingInfo WHERE archFileId in ( SELECT id FROM archFile WHERE appId = @AppId and fileType = 1 and isValid = 1 ) AND cloudId = @CloudId )&amp;#xD;&#xd;&#xa;                BEGIN                    &amp;#xD;&#xd;&#xa;                    -- Get the latest archFile which is not already in FLA table against different clouds and put it in archFLAIndexingInfo&amp;#xD;&#xd;&#xa;                    SET @ArchFileId = ( SELECT TOP 1 id FROM archFile WHERE id not in ( SELECT archFileId FROM archFLAIndexingInfo ) AND appId = @AppId and fileType = 1 and isValid = 1 ORDER BY cTime DESC )&amp;#xD;&#xd;&#xa;                    IF @ArchFileId &amp;gt; 1&amp;#xD;&#xd;&#xa;                    BEGIN&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;INSERT INTO archFLAIndexingInfo VALUES ( @ArchFileId,@OrigCCID,0,0,(SELECT DATEDIFF(s, ''1970-01-01 00:00:00'', GETUTCDATE())),@CloudId,@AppId,@ClientName,@ClientId )&amp;#xD;&#xd;&#xa;                    END&amp;#xD;&#xd;&#xa;                END&amp;#xD;&#xd;&#xa;                &amp;#xD;&#xd;&#xa;                -- See if any unknown appType is in input&amp;#xD;&#xd;&#xa;                IF @AppType NOT IN ( 33,29,13,63 )&amp;#xD;&#xd;&#xa;                BEGIN                                       &amp;#xD;&#xd;&#xa;                    DECLARE @GroupName varchar(max) = ''''                &amp;#xD;&#xd;&#xa;                    SET @GroupName = ( SELECT osGroup FROM App_AppTypeGroups WHERE appTypeId =  @AppType )                &amp;#xD;&#xd;&#xa;                    IF @GroupName = ''Unix'' OR @GroupName = ''Centera'' OR @GroupName = ''Netware'' OR @GroupName = ''SGI'' OR @GroupName = ''Centera''  &amp;#xD;&#xd;&#xa;                    BEGIN&amp;#xD;&#xd;&#xa;                        SET @AppType = 29&amp;#xD;&#xd;&#xa;                    END&amp;#xD;&#xd;&#xa;                    ELSE&amp;#xD;&#xd;&#xa;                        SET @AppType = 33&amp;#xD;&#xd;&#xa;                END&amp;#xD;&#xd;&#xa;                &amp;#xD;&#xd;&#xa;                &amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;-- Now insert in final push &amp;#xD;&#xd;&#xa;                SET @PruneSOLRData = 1&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;INSERT @CommandTable ( ClientName , ClientId , AnalyticsEngine , SubclientId ,BackupSetId, VMname  , CSVPath , AppType , EngineMAId , VSASubClientID , PruneSOLRData, InstanceName )  VALUES ( @ClientName,@ClientId, @EngineName, @AppId, @BackupSetID, @VMname, @CSVPath , @AppType , @EngineMAId , @AppId , @PruneSOLRData, @EngineInstanceName )&#x9;&#x9;&#x9;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;END&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;FETCH NEXT FROM SubClientCursor INTO @AppId, @BackupSetId, @AppType&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;&#x9;END&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&#x9;&#x9;CLOSE SubClientCursor&amp;#xD;&#xd;&#xa;&#x9;&#x9;DEALLOCATE SubClientCursor&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&#x9;END&amp;#xD;&#xd;&#xa;&#x9;&#x9;&amp;#xD;&#xd;&#xa;&#x9;FETCH NEXT FROM CurC into @ClientName;&amp;#xD;&#xd;&#xa;&#x9;&amp;#xD;&#xd;&#xa;END&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;CLOSE CurC;&amp;#xD;&#xd;&#xa;DEALLOCATE CurC;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;SELECT * FROM @CommandTable&lt;/query>&lt;/inputs>"/>

                <transition activity="SubclientIterator" commented="0"

                    originalStyle="" points="" sourceX="433"

                    sourceY="151" status="0" style="defaultEdge"

                    targetX="440" targetY="234" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1368566518080"

                description="iterates a group of activities over a list of values"

                displayName="Subclients" height="391" interactive="0"

                jobMode="0" name="ForEach"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0" style="swimlane"

                uniqueName="SubclientIterator" waitSetting="0"

                width="846" x="20" y="227">

                <inputs val="&lt;inputs>&lt;name class=&quot;java.lang.String&quot;>row&lt;/name>&lt;values class=&quot;java.lang.Object&quot;>xpath:{/workflow/SET_FLA/resultSets/row}&lt;/values>&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot;>5&lt;/numberOfParallelExecutions>&lt;continueOnFailure class=&quot;java.lang.Boolean&quot;>false&lt;/continueOnFailure>&lt;/inputs>"/>

                <superProcess>

                    <Start commented="0" continueOnFailure="0"

                        created="1368566518080" description=""

                        displayName="Start" height="30" interactive="0"

                        jobMode="0" name="Start" originalStyle=""

                        skipAttempt="0"

                        style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                        uniqueName="Start_6" waitSetting="0" width="120"

                        x="24" y="43">

                        <inputs val="&lt;inputs />"/>

                        <transition activity="SubclientWorkDir"

                            commented="0" originalStyle="" points=""

                            sourceX="78" sourceY="45" status="0"

                            style="defaultEdge" targetX="214"

                            targetY="47" transitionIndex="0" x="0" y="0">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Start>

                    <Activity commented="0" continueOnFailure="0"

                        created="1368566552505"

                        description="activity to execute code snippets in the selected language"

                        displayName="Create_SubClient_Dir" height="34"

                        interactive="0" jobMode="0" name="Script"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="1"

                        style="label;image=Script"

                        uniqueName="SubclientWorkDir" waitSetting="0"

                        width="175" x="187" y="41">

                        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;import java.io.File;&amp;#xD;&amp;#xA;File clientDir = new File(xpath:{/workflow/CSWorkDirectory/output}, xpath:{/workflow/SubclientIterator/row/col[@name=&amp;quot;ClientName&amp;quot;]});&amp;#xD;&amp;#xA;File scDir = new File(clientDir, String.valueOf(xpath:{/workflow/SubclientIterator/row/col[@name=&amp;quot;SubclientId&amp;quot;]}));&amp;#xD;&amp;#xA;scDir.mkdirs();&amp;#xD;&amp;#xA;return scDir.getAbsolutePath();&quot; />&lt;/inputs>"/>

                        <transition activity="PatternFile" commented="0"

                            originalStyle="" points="" sourceX="243"

                            sourceY="49" status="0" style="defaultEdge"

                            targetX="405" targetY="53"

                            transitionIndex="0" x="0" y="0">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity commented="0" continueOnFailure="1"

                        created="1368568583226"

                        description="Execute a list of commands"

                        displayName="GetBackupList" height="34"

                        interactive="0" jobMode="0" maxRestarts="0"

                        name="ExecuteCommand"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="1"

                        style="label;image=ExecuteCommand"

                        uniqueName="ExecuteBackupList" waitSetting="0"

                        width="139" x="505" y="198">

                        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/inputs/analyticsEngine/mediaAgentName}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; />&lt;command class=&quot;java.lang.String&quot;>cmd.exe&lt;/command>&lt;arguments class=&quot;java.lang.String&quot;>/C &quot;&quot;xpath:{/workflow/GalaxyBaseDir/output}\getBackupList.exe&quot; -appType &quot;xpath:{/workflow/CommServDBQuery_4/resultSets/row/col[@name=&quot;iDAName&quot;]}&quot; -unixtime -backupset &quot;xpath:{/workflow/CommServDBQuery_4/resultSets/row/col[@name=&quot;backupSetName&quot;]}&quot; -format &quot;full_file_name,mod_time,file_size&quot; -patternfile &quot;xpath:{/workflow/PatternFile/output}&quot; -outfile &quot;xpath:{/workflow/GetCVSName/output}&quot; -ma &quot;xpath:{/workflow/variables/mahostname}&quot; -client &quot;xpath:{/workflow/SubclientIterator/row/col[@name=&quot;ClientName&quot;]}&quot; -vm &quot;xpath:{/workflow/GalaxyInstance/output}&quot; -subclient &quot;xpath:{/workflow/CommServDBQuery_4/resultSets/row/col[@name=&quot;subclientName&quot;]}&quot;&quot;&lt;/arguments>&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

                        <transition activity="Decision_3" commented="0"

                            originalStyle="" points="" sourceX="574"

                            sourceY="215" status="0" style="defaultEdge"

                            targetX="441" targetY="171"

                            transitionIndex="0" x="0" y="0">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity commented="0" continueOnFailure="0"

                        created="1368573551423"

                        description="activity to execute code snippets in the selected language"

                        displayName="Generate_SOLR_CSV" height="34"

                        interactive="0" jobMode="0" name="Script"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="1"

                        style="label;image=Script"

                        uniqueName="GenerateCVS" waitSetting="0"

                        width="173" x="44" y="155">

                        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;import java.io.File;&amp;#xD;&amp;#xA;import java.io.FileWriter;&amp;#xD;&amp;#xA;import java.io.BufferedReader;&amp;#xD;&amp;#xA;import java.io.FileReader;&amp;#xD;&amp;#xA;import org.apache.commons.lang.StringUtils;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;String baseName; &amp;#xD;&amp;#xA;String fullName;&amp;#xD;&amp;#xA;String size;&amp;#xD;&amp;#xA;String extension;&amp;#xD;&amp;#xA;String fileSystemName;&amp;#xD;&amp;#xA;String modifiedTime;&amp;#xD;&amp;#xA;String clid = String.valueOf(xpath:{/workflow/SubclientIterator/row/col[@name=&amp;quot;ClientId&amp;quot;]});&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;String extraFields = clid + &amp;quot;,&amp;quot; + xpath:{/workflow/SubclientIterator/row/col[@name=&amp;quot;SubclientId&amp;quot;]} + &amp;quot;,0,17,1&amp;quot;;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;File commandCSV = new File(xpath:{/workflow/GetCVSName/output});&amp;#xD;&amp;#xA;File solrCSV = new File(xpath:{/workflow/SubclientWorkDir/output}, &amp;quot;FinalSolrPush.csv&amp;quot;);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;FileWriter writer = new FileWriter(solrCSV);&amp;#xD;&amp;#xA;BufferedReader br = new BufferedReader(new FileReader(commandCSV));&amp;#xD;&amp;#xA;String fileLine;&amp;#xD;&amp;#xA;int i=0;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;while ((fileLine = br.readLine()) != null) {&amp;#xD;&amp;#xA;    i++;&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    fileLine = StringUtils.replace(fileLine, &amp;quot;\\\\&amp;quot;, &amp;quot;\\&amp;quot;);&amp;#xD;&amp;#xA;                     &amp;#xD;&amp;#xA;    String[] line = StringUtils.splitPreserveAllTokens(fileLine, &amp;quot;\&amp;quot;&amp;quot;);&amp;#xD;&amp;#xA;    if (line.length == 3) {&amp;#xD;&amp;#xA;        // Get Full Name from 2nd Element from Array Line&amp;#xD;&amp;#xA;        fullName = StringUtils.removeStart(line[1], &amp;quot;\\&amp;quot;);&amp;#xD;&amp;#xA;        String[] tempArr;&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        // Get BaseName from Last Element of Full Name&amp;#xD;&amp;#xA;        if (fullName.indexOf(&amp;quot;/&amp;quot;) &amp;gt; -1) {&amp;#xD;&amp;#xA;             tempArr = StringUtils.splitPreserveAllTokens(line[1], &amp;quot;/&amp;quot;);&amp;#xD;&amp;#xA;        } else {&amp;#xD;&amp;#xA;             tempArr = StringUtils.splitPreserveAllTokens(line[1], &amp;quot;\\&amp;quot;);&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        baseName = tempArr[tempArr.length - 1];&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        // Get FileSystemName which is 1st Element of FullName. Change delimeters for unix and windows&amp;#xD;&amp;#xA;        if (fullName.indexOf(&amp;quot;/&amp;quot;) &amp;gt; -1) {&amp;#xD;&amp;#xA;            fileSystemName = &amp;quot;/&amp;quot; + tempArr[1];&amp;#xD;&amp;#xA;        } else {&amp;#xD;&amp;#xA;            fileSystemName = tempArr[1] + &amp;quot;\\&amp;quot;;&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        // Get Modified date and size from Line[2] &amp;#xD;&amp;#xA;        tempArr = StringUtils.splitPreserveAllTokens(line[2], &amp;quot;,&amp;quot;);&amp;#xD;&amp;#xA;        modifiedTime = tempArr[1];&amp;#xD;&amp;#xA;        size = tempArr[2];&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        // Get Extension from BaseName&amp;#xD;&amp;#xA;        tempArr = StringUtils.splitPreserveAllTokens(baseName, &amp;quot;.&amp;quot;);&amp;#xD;&amp;#xA;        if (tempArr.length &amp;gt;= 2) {&amp;#xD;&amp;#xA;            extension = tempArr[tempArr.length-1];&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;     &amp;#xD;&amp;#xA;        //writer.write(i + &amp;quot;,&amp;quot; + extraFields + &amp;quot;,\&amp;quot;&amp;quot; + fileSystemName + &amp;quot;\&amp;quot;,\&amp;quot;&amp;quot; + baseName + &amp;quot;\&amp;quot;,&amp;quot; + size + &amp;quot;,\&amp;quot;&amp;quot; + extension + &amp;quot;\&amp;quot;,&amp;quot; + modifiedTime + &amp;quot;,\&amp;quot;&amp;quot; + fullName + &amp;quot;\&amp;quot;&amp;quot; + System.getProperty(&amp;quot;line.separator&amp;quot;));&amp;#xD;&amp;#xA;        writer.write(extraFields + &amp;quot;,\&amp;quot;&amp;quot; + fileSystemName + &amp;quot;\&amp;quot;,&amp;quot; + i + &amp;quot;,0,\&amp;quot;&amp;quot; + baseName + &amp;quot;\&amp;quot;,&amp;quot; + size + &amp;quot;,0,0,\&amp;quot;NA\&amp;quot;,\&amp;quot;NA\&amp;quot;,\&amp;quot;&amp;quot; + extension + &amp;quot;\&amp;quot;,0,0,&amp;quot; + modifiedTime + &amp;quot;,0,0,0,0,&amp;quot; + size + &amp;quot;,\&amp;quot;&amp;quot; + fullName + &amp;quot;\&amp;quot;,0,0,0&amp;quot; + System.getProperty(&amp;quot;line.separator&amp;quot;));&amp;#xD;&amp;#xA;    } else {&amp;#xD;&amp;#xA;        //writer.write(i + &amp;quot;,&amp;quot; + extraFields + &amp;quot;,\&amp;quot;FileSystemName\&amp;quot;,\&amp;quot;BaseName\&amp;quot;,0,\&amp;quot;Extension\&amp;quot;,0,\&amp;quot;FullName\&amp;quot;&amp;quot; + System.getProperty(&amp;quot;line.separator&amp;quot;));&amp;#xD;&amp;#xA;        writer.write(extraFields + &amp;quot;,\&amp;quot;&amp;quot; + fileSystemName + &amp;quot;\&amp;quot;,&amp;quot; + i + &amp;quot;,0,\&amp;quot;&amp;quot; + baseName + &amp;quot;\&amp;quot;,&amp;quot; + size + &amp;quot;,0,0,\&amp;quot;NA\&amp;quot;,\&amp;quot;NA\&amp;quot;,\&amp;quot;&amp;quot; + extension + &amp;quot;\&amp;quot;,0,0,&amp;quot; + modifiedTime + &amp;quot;,0,0,0,0,&amp;quot; + size + &amp;quot;,\&amp;quot;&amp;quot; + fullName + &amp;quot;\&amp;quot;,0,0,0&amp;quot; + System.getProperty(&amp;quot;line.separator&amp;quot;));&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;br.close();&amp;#xD;&amp;#xA;writer.close();&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;return solrCSV.getAbsolutePath();&quot; />&lt;/inputs>"/>

                        <transition activity="ExecuteCommand_6"

                            commented="0" originalStyle="" points=""

                            sourceX="279" sourceY="141" status="0"

                            style="defaultEdge" targetX="139"

                            targetY="141" transitionIndex="0" x="0" y="0">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity commented="0" continueOnFailure="0"

                        created="1368574298406"

                        description="if/else based decision"

                        displayName="Success" height="100"

                        interactive="0" jobMode="0" name="Decision"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="rhombus;fontStyle=1"

                        uniqueName="Decision_3" waitSetting="0"

                        width="100" x="343" y="123">

                        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/ExecuteBackupList/exitCode} == 0 &amp;amp;&amp;amp; xpath:{/workflow/ExecuteBackupList/commandOutput}.indexOf(&quot;getBackupList succeeded&quot;) &amp;gt; -1&lt;/expression>&lt;/inputs>"/>

                        <transition activity="GenerateCVS" commented="0"

                            displayName="Yes" originalStyle="" points=""

                            sourceX="703" sourceY="113" status="0"

                            style="defaultEdge" targetX="535"

                            targetY="179" transitionIndex="0"

                            value="true" x="0" y="0">

                            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                        <transition activity="Script_14" commented="0"

                            displayName="No" originalStyle="" points=""

                            sourceX="522" sourceY="141" status="0"

                            style="defaultEdge" targetX="685"

                            targetY="140" transitionIndex="0"

                            value="false" x="0" y="0">

                            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity commented="0" continueOnFailure="0"

                        created="1368574380786"

                        description="activity to execute code snippets in the selected language"

                        displayName="Log_Error" height="34"

                        interactive="0" jobMode="0" name="Script"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="1"

                        style="label;image=Script"

                        uniqueName="Script_14" waitSetting="0"

                        width="100" x="345" y="301">

                        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;logger.info(&amp;quot;GetBackupList failed for client [&amp;quot; + xpath:{/workflow/SubclientIterator/row/col[@name=&amp;quot;ClientName&amp;quot;]} + &amp;quot;], backupSet [&amp;quot; + xpath:{/workflow/CommServDBQuery_4/resultSets/row/col[@name=&amp;quot;backupSetName&amp;quot;]} + &amp;quot;], subclient [&amp;quot; + xpath:{/workflow/CommServDBQuery_4/resultSets/row/col[@name=&amp;quot;subclientName&amp;quot;]} + &amp;quot;]&amp;quot;);&quot; />&lt;/inputs>"/>

                    </Activity>

                    <Activity commented="0" continueOnFailure="0"

                        created="1368705371621"

                        description="activity to execute code snippets in the selected language"

                        displayName="Set_CSV_Name" height="34"

                        interactive="0" jobMode="0" name="Script"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=Script"

                        uniqueName="GetCVSName" waitSetting="0"

                        width="135" x="636" y="40">

                        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;import java.io.File;&amp;#xD;&amp;#xA;File cvs = new File(xpath:{/workflow/SubclientWorkDir/output}, &amp;quot;GetBackupOutput_&amp;quot; + xpath:{/workflow/SubclientIterator/row/col[@name=&amp;quot;SubclientId&amp;quot;]} + &amp;quot;.csv&amp;quot;);&amp;#xD;&amp;#xA;return cvs.getAbsolutePath();&quot; />&lt;/inputs>"/>

                        <transition activity="CommServDBQuery_4"

                            commented="0" originalStyle="" points=""

                            sourceX="703" sourceY="57" status="0"

                            style="defaultEdge" targetX="724"

                            targetY="141" transitionIndex="0" x="0" y="0">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity commented="0" continueOnFailure="0"

                        created="1370898622732"

                        description="activity to execute code snippets in the selected language"

                        displayName="Create_Pattern_File" height="34"

                        interactive="0" jobMode="0" name="Script"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="0"

                        style="label;image=Script"

                        uniqueName="PatternFile" waitSetting="0"

                        width="165" x="414" y="41">

                        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;import java.io.File;&amp;#xD;&amp;#xA;import java.io.FileWriter;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;File patternFile = new File(xpath:{/workflow/SubclientWorkDir/output}, &amp;quot;pattern_&amp;quot; + xpath:{/workflow/SubclientIterator/row/col[@name=&amp;quot;SubclientId&amp;quot;]} + &amp;quot;.txt&amp;quot;);&amp;#xD;&amp;#xA;FileWriter writer = new FileWriter(patternFile);&amp;#xD;&amp;#xA;writer.write(&amp;quot;\\**\\*&amp;quot; + System.getProperty(&amp;quot;line.separator&amp;quot;));&amp;#xD;&amp;#xA;writer.write(&amp;quot;/**/*&amp;quot;);&amp;#xD;&amp;#xA;writer.close();&amp;#xD;&amp;#xA;return patternFile.getAbsolutePath();&amp;#xD;&amp;#xA;&quot; />&lt;/inputs>"/>

                        <transition activity="GetCVSName" commented="0"

                            originalStyle="" points="" sourceX="424"

                            sourceY="49" status="0" style="defaultEdge"

                            targetX="621" targetY="47"

                            transitionIndex="0" x="0" y="0">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                    <Activity commented="0" continueOnFailure="1"

                        created="1389911646702"

                        description="Execute a list of commands"

                        displayName="Push Lucene" height="34"

                        interactive="0" jobMode="0" maxRestarts="0"

                        name="ExecuteCommand"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="1"

                        style="label;image=ExecuteCommand"

                        uniqueName="ExecuteCommand_6" waitSetting="0"

                        width="147" x="65" y="265">

                        <onExit language="1" script="workflow.setStatus(commvault.cte.common.workflow.ProcessStatus.RUNNING);&#xd;&#xa;String sql = &quot;UPDATE archFLAIndexingInfo SET indexTime=(SELECT DATEDIFF(s, ''1970-01-01 00:00:00'', GETUTCDATE())),flags=64 WHERE archFileId in ( SELECT id FROM archFile WHERE appId = &quot;+ xpath:{/workflow/SubclientIterator/row/col[@name=&quot;SubclientId&quot;]} +&quot; )&quot;;&#xd;&#xa;csdb.executeUpdate(sql);"/>

                        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/inputs/analyticsEngine/mediaAgentName}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; />&lt;command class=&quot;java.lang.String&quot;>CVCIAnalytics.exe&lt;/command>&lt;arguments class=&quot;java.lang.String&quot;>-cvworkflow xpath:{/workflow/system/jobId} -cln &quot;xpath:{/workflow/SubclientIterator/row/col[@name=&quot;ClientName&quot;]}&quot; -c xpath:{/workflow/SubclientIterator/row/col[@name=&quot;ClientId&quot;]} -m &quot;xpath:{/workflow/SubclientIterator/row/col[@name=&quot;AnalyticsEngine&quot;]}&quot; -s xpath:{/workflow/SubclientIterator/row/col[@name=&quot;SubclientId&quot;]} -vmname &quot;xpath:{/workflow/SubclientIterator/row/col[@name=&quot;VMname&quot;]}&quot; -csv &quot;xpath:{/workflow/GenerateCVS/output}&quot; -backupsetid xpath:{/workflow/SubclientIterator/row/col[@name=&quot;BackupSetId&quot;]} -a xpath:{/workflow/SubclientIterator/row/col[@name=&quot;AppType&quot;]} -ma xpath:{/workflow/SubclientIterator/row/col[@name=&quot;EngineMAId&quot;]} -vsaAppId xpath:{/workflow/SubclientIterator/row/col[@name=&quot;VSASubClientID&quot;]} -pruneSolrData xpath:{/workflow/SubclientIterator/row/col[@name=&quot;PruneSOLRData&quot;]} -vm &quot;xpath:{/workflow/SubclientIterator/row/col[@name=&quot;InstanceName&quot;]}&quot;&lt;/arguments>&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

                    </Activity>

                    <Activity commented="0" continueOnFailure="0"

                        created="1416441945191"

                        description="executes queries against the commserv database"

                        displayName="Get_SubClient" height="34"

                        interactive="0" jobMode="0"

                        name="CommServDBQuery"

                        namespaceUri="commvault.cte.workflow.activities"

                        originalStyle="" skipAttempt="1"

                        style="label;image=CommServDBQuery"

                        uniqueName="CommServDBQuery_4" waitSetting="0"

                        width="125" x="683" y="128">

                        <inputs val="&lt;inputs>&lt;commCell />&lt;query>SELECT DISTINCT backupset as backupSetName, subclient as subclientName, xmlDisplayName as iDAName&amp;#xD;&#xd;&#xa;FROM CommCellSubClientConfig &amp;#xD;&#xd;&#xa;WHERE &amp;#xD;&#xd;&#xa;subclient not like ''IndexingSubclient''&amp;#xD;&#xd;&#xa;AND subclientstatus not like ''Uninstalled''&amp;#xD;&#xd;&#xa;AND appid = xpath:{/workflow/SubclientIterator/row/col[@name=&quot;SubclientId&quot;]}&lt;/query>&lt;/inputs>"/>

                        <transition activity="ExecuteBackupList"

                            commented="0" originalStyle="" points=""

                            sourceX="727" sourceY="146" status="0"

                            style="defaultEdge" targetX="636"

                            targetY="207" transitionIndex="0" x="0" y="0">

                            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                        </transition>

                    </Activity>

                </superProcess>

                <activitySchema>

                    <outputs name="outputs">

                        <children attribute="0"

                            className="workflow.types.data.DataRow"

                            defaultValue="" hidden="0"

                            inputType="workflow.types.data.DataRow"

                            listType="0" name="row" type="{workflow.types.data}DataRow">

                            <children attribute="0"

                                className="java.lang.Object"

                                defaultValue="" hidden="0"

                                inputType="java.lang.Object"

                                listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                        </children>

                    </outputs>

                    <inputs>

                        <children className="java.lang.String"

                            inputType="java.lang.String" name="name" type="{http://www.w3.org/2001/XMLSchema}string"/>

                        <children className="java.lang.Object"

                            inputType="java.lang.Object" name="values" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                        <children className="java.lang.Integer"

                            defaultValue="1"

                            inputType="java.lang.Integer"

                            name="numberOfParallelExecutions" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                        <children className="java.lang.Boolean"

                            defaultValue="false"

                            inputType="java.lang.Boolean"

                            name="continueOnFailure" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                    </inputs>

                </activitySchema>

            </Activity>

        </superProcess>

        <activitySchema>

            <outputs name="outputs">

                <children attribute="0"

                    className="workflow.types.data.DataRow"

                    defaultValue="" hidden="0"

                    inputType="workflow.types.data.DataRow" listType="0"

                    name="row" type="{workflow.types.data}DataRow">

                    <children attribute="0" className="java.lang.Object"

                        defaultValue="" hidden="0"

                        inputType="java.lang.Object" listType="1"

                        name="col" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                </children>

            </outputs>

            <inputs>

                <children className="java.lang.String"

                    inputType="java.lang.String" name="name" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children className="java.lang.Object"

                    inputType="java.lang.Object" name="values" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                <children className="java.lang.Integer" defaultValue="1"

                    inputType="java.lang.Integer"

                    name="numberOfParallelExecutions" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                <children className="java.lang.Boolean"

                    defaultValue="false" inputType="java.lang.Boolean"

                    name="continueOnFailure" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

            </inputs>

        </activitySchema>

        <transition activity="ExecuteCommand_8" commented="0"

            originalStyle="" points="" sourceX="1280" sourceY="782"

            status="0" style="defaultEdge" targetX="1738" targetY="359"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="1"

        created="1389890586728" description="Execute a list of commands"

        displayName="Cleanup_ENV" height="34" interactive="0"

        jobMode="0" maxRestarts="0" name="ExecuteCommand"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ExecuteCommand" uniqueName="ExecuteCommand_5"

        waitSetting="0" width="119" x="135" y="745">

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>&lt;clientName class=&quot;java.lang.String&quot; />&lt;clientId class=&quot;java.lang.Integer&quot; />&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; />&lt;command class=&quot;java.lang.String&quot;>cmd.exe&lt;/command>&lt;arguments class=&quot;java.lang.String&quot;>/C rd xpath:{/workflow/variables/workingDirectory} /S /Q&lt;/arguments>&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="CreateWorkingDir" commented="0"

            originalStyle="" points="" sourceX="215" sourceY="695"

            status="0" style="defaultEdge" targetX="276" targetY="772"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1369079579539" description="if/else based decision"

        displayName="Perform CCM" height="100" interactive="0"

        jobMode="0" name="Decision"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_5" waitSetting="0" width="117" x="408" y="764">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/PerformCCM}&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="CCMIterator" commented="0"

            displayName="Yes" originalStyle="" points="" sourceX="502"

            sourceY="162" status="0" style="defaultEdge" targetX="505"

            targetY="240" transitionIndex="0" value="true" x="10" y="10">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="CommCellIterator" commented="0"

            displayName="No" originalStyle="" points="" sourceX="502"

            sourceY="162" status="0" style="defaultEdge" targetX="696"

            targetY="29" transitionIndex="0" value="false" x="10" y="10">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1404326077908"

        description="turns off all logging, except for errors, for current job"

        displayName="Stop SQL Logging" height="34" interactive="0"

        jobMode="0" name="DisableLogging"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=DisableLogging" uniqueName="DisableLogging_2"

        waitSetting="0" width="148" x="1240" y="283">

        <inputs val="&lt;inputs />"/>

        <transition activity="Set_FLA_Params" commented="0"

            originalStyle="" points="" sourceX="1287" sourceY="270"

            status="0" style="defaultEdge" targetX="1208" targetY="80"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1404917546760" description="Execute a list of commands"

        displayName="NAS Discovery" height="26" interactive="0"

        jobMode="0" maxRestarts="0" name="ExecuteCommand"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ExecuteCommand" uniqueName="ExecuteCommand_7"

        waitSetting="0" width="138" x="895" y="163">

        <onExit language="1" script="import java.io.*;&#xd;&#xa;String directoryName = xpath:{/workflow/inputs/DiscoveryOutput} + &quot;\\&quot; +xpath:{/workflow/system/jobId} + &quot;\\Clients\\&quot; ;&#xd;&#xa;boolean filesPresent = false;&#xd;&#xa;logger.info(directoryName);&#xd;&#xa;File directory = new File(directoryName);&#xd;&#xa;if(directory.exists())&#xd;&#xa;{&#xd;&#xa;    File[] dList = directory.listFiles();&#xd;&#xa;&#x9;for( File dirName : dList)&#xd;&#xa;&#x9;{&#xd;&#xa;&#x9;&#x9;logger.info(dirName.getName());&#xd;&#xa;&#x9;&#x9;File[] fList = dirName.listFiles();&#xd;&#xa;&#x9;&#x9;for (File file : fList) &#xd;&#xa;&#x9;&#x9;{&#xd;&#xa;&#x9;&#x9;&#x9;if (file.isFile()) &#xd;&#xa;&#x9;&#x9;&#x9;{&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;if (file.getName().endsWith(&quot;.cvf&quot;)) &#xd;&#xa;&#x9;&#x9;&#x9;&#x9;{&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;filesPresent = true;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;&#x9;break;&#xd;&#xa;&#x9;&#x9;&#x9;&#x9;}&#xd;&#xa;&#x9;&#x9;&#x9;}&#xd;&#xa;&#x9;&#x9;}&#xd;&#xa;    }&#xd;&#xa;}&#xd;&#xa;&#xd;&#xa;&#xd;&#xa;if(false)&#xd;&#xa;{&#xd;&#xa;    logger.info(&quot;Discovery File is not present &quot;);&#xd;&#xa;    workflow.setStatus(commvault.cte.common.workflow.ProcessStatus.FAILED);&#xd;&#xa;    workflow.setFailureReason(&quot;Failed to complete System Discovery Process. Please check logs from &quot; + xpath:{/workflow/inputs/DiscoveryOutput} + &quot;\\&quot; +xpath:{/workflow/system/jobId});&#xd;&#xa;}"/>

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>&lt;clientName />&lt;clientId />&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/WindowsUserName}&lt;/impersonateUserName>&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot;>xpath:{/workflow/inputs/WindowsUserPassword}&lt;/impersonateUserPassword>&lt;startUpPath class=&quot;java.lang.String&quot; />&lt;command class=&quot;java.lang.String&quot;>cmd.exe&lt;/command>&lt;arguments class=&quot;java.lang.String&quot;>/C &quot;cd /d &quot;xpath:{/workflow/variables/ClientInstallDir}\Base\CVSysDiscoveryUI64&quot; &amp;amp;&amp;amp; SysDiscoveryCmd.exe -type windows -input &quot;xpath:{/workflow/variables/DiscoveryInputFile}&quot; -files -output xpath:{/workflow/inputs/DiscoveryOutput}\xpath:{/workflow/system/jobId} -debug 4&quot;&lt;/arguments>&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="DisableLogging_2" commented="0"

            originalStyle="" points="" sourceX="964" sourceY="114"

            status="0" style="defaultEdge" targetX="1173" targetY="264"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1408552822478"

        description="turns on all logging for the current job"

        displayName="EnableLogging" height="34" interactive="0"

        jobMode="0" name="EnableLogging"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=EnableLogging" uniqueName="EnableLogging_3"

        waitSetting="0" width="126" x="50" y="369">

        <inputs val="&lt;inputs />"/>

        <transition activity="Script_1" commented="0" originalStyle=""

            points="" sourceX="113" sourceY="386" status="0"

            style="defaultEdge" targetX="100" targetY="520"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1416506634315"

        description="executes queries against the commserv database"

        displayName="Check Analytics Engine" height="34" interactive="0"

        jobMode="0" name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=CommServDBQuery"

        uniqueName="CommServDBQuery_5" waitSetting="0" width="182"

        x="88" y="34">

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>DECLARE @AnalyticsEngine varchar(max) = ''xpath:{/workflow/inputs/analyticsEngine/mediaAgentName}''&amp;#xD;&#xd;&#xa;IF EXISTS ( SELECT TOP 1 CloudId FROM DM2SearchServerCoreInfo,APP_Client WHERE ClientId=id AND name = @AnalyticsEngine )&amp;#xD;&#xd;&#xa;BEGIN&amp;#xD;&#xd;&#xa;    SELECT 1&amp;#xD;&#xd;&#xa;END&amp;#xD;&#xd;&#xa;ELSE&amp;#xD;&#xd;&#xa;    SELECT 0&lt;/query>&lt;/inputs>"/>

        <transition activity="Switch_3" commented="0" originalStyle=""

            points="" sourceX="187" sourceY="40" status="0"

            style="defaultEdge" targetX="136" targetY="148"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1416506804030" description="switch based decision"

        displayName="Switch" height="66" interactive="0" jobMode="0"

        name="Switch" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Switch_3" waitSetting="0" width="77" x="82" y="121">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/CommServDBQuery_5/resultSets/row/col}&lt;/expression>&lt;/inputs>"/>

        <transition activity="Script_3" commented="0"

            displayName="Enabled" originalStyle="" points=""

            sourceX="127" sourceY="154" status="0" style="defaultEdge"

            targetX="289" targetY="193" transitionIndex="0" value="1"

            x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="Script_15" commented="0"

            displayName="Disabled" originalStyle="" points=""

            sourceX="136" sourceY="148" status="0" style="defaultEdge"

            targetX="134" targetY="216" transitionIndex="0" value="0"

            x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1416507036179"

        description="activity to execute code snippets in the selected language"

        displayName="Log_Error" height="34" interactive="0" jobMode="0"

        name="Script" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Script"

        uniqueName="Script_15" waitSetting="0" width="100" x="58" y="266">

        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;workflow.setStatus(commvault.cte.common.workflow.ProcessStatus.FAILED);&amp;#xD;&amp;#xA;workflow.setFailureReason(&amp;quot;Analytics Engine is not enabled on selected media agent &amp;quot; + xpath:{/workflow/inputs/analyticsEngine/mediaAgentName});&quot; />&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1431047867861"

        description="Execute a command on a remote machine"

        displayName="Cleanup Temporary Files" height="34"

        interactive="0" jobMode="0" name="ExecuteCommand"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ExecuteCommand" uniqueName="ExecuteCommand_8"

        waitSetting="0" width="194" x="1657" y="343">

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/analyticsEngine/mediaAgentName}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/WindowsUserName}&lt;/impersonateUserName>&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/WindowsUserPassword}&lt;/impersonateUserPassword>&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>rmdir xpath:{/workflow/inputs/DiscoveryOutput}\xpath:{/workflow/system/jobId} /S /Q&lt;/command>&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1431048138488" description="switch based decision"

        displayName="Cleanup" height="100" interactive="0" jobMode="0"

        name="Switch" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Switch_4" waitSetting="0" width="100" x="1681" y="156">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/appType}&lt;/expression>&lt;/inputs>"/>

        <transition activity="ExecuteCommand_8" commented="0"

            displayName="Clean upSystem  discovery files"

            originalStyle="" points="" sourceX="1734" sourceY="217"

            status="0" style="defaultEdge" targetX="1740" targetY="373"

            transitionIndex="0" value="SystemDiscovery" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1436548763300"

        description="executes queries against a commcell database"

        displayName="Populate Content Paths" height="34" interactive="0"

        jobMode="0" name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=CommServDBQuery"

        uniqueName="CommServDBQuery_6" waitSetting="0" width="163"

        x="612" y="119">

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>&amp;#xD;&#xd;&#xa;SET NOCOUNT ON&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;DECLARE @UNCPathUserName varchar(max) = ''''&amp;#xD;&#xd;&#xa;DECLARE @UNCPathPassword varchar(max) = ''''&amp;#xD;&#xd;&#xa;DECLARE @ClientGroupId   int = 5&amp;#xD;&#xd;&#xa;DECLARE @ShareName       varchar(max) = ''''&amp;#xD;&#xd;&#xa;DECLARE @appId           int = 0&amp;#xD;&#xd;&#xa;DECLARE @DefaultUserName varchar(max) = ''''&amp;#xD;&#xd;&#xa;DECLARE @DefaultPassword varchar(max) = ''''&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;DECLARE @ShareTable TABLE ( ClientName varchar(max), UserName varchar(max), UserPassword varchar(max) )&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;DECLARE CurC CURSOR FORWARD_ONLY FOR (SELECT fileName,componentNameId FROM APP_ScFilterFile WHERE fileName like ''%UNC-NT%'' AND modified = 0 AND componentNameId in&amp;#xD;&#xd;&#xa;( SELECT id FROM APP_Application WHERE clientId in ( SELECT clientId FROM APP_ClientGroupAssoc WHERE clientGroupId=@ClientGroupId ) ) );&amp;#xD;&#xd;&#xa;OPEN CurC;&amp;#xD;&#xd;&#xa;FETCH NEXT FROM CurC into @ShareName,@appId;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;WHILE @@FETCH_STATUS = 0&amp;#xD;&#xd;&#xa;BEGIN&#x9;&amp;#xD;&#xd;&#xa;&#x9;SET @ShareName = REPLACE(@ShareName,''UNC-NT_'',''\\'')&amp;#xD;&#xd;&#xa;&#x9;SET @UNCPathUserName = ( SELECT TOP 1 attrVal FROM APP_SubClientProp WHERE attrName like ''%UNCPath user name%'' AND componentNameId = @appId )&amp;#xD;&#xd;&#xa;&#x9;SET @UNCPathPassword = ( SELECT TOP 1 attrVal FROM APP_SubClientProp WHERE attrName like ''%UNCPath password%'' AND componentNameId = @appId )&#x9;&amp;#xD;&#xd;&#xa;&#x9;INSERT @ShareTable ( ClientName,UserName,UserPassword) VALUES ( @ShareName,@UNCPathUserName,@UNCPathPassword)&amp;#xD;&#xd;&#xa;&#x9;FETCH NEXT FROM CurC into @ShareName,@appId;&amp;#xD;&#xd;&#xa;END&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;CLOSE CurC&amp;#xD;&#xd;&#xa;DEALLOCATE CurC&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;SELECT * FROM @ShareTable&amp;#xD;&#xd;&#xa;&lt;/query>&lt;/inputs>"/>

        <transition activity="EnableLogging_4" commented="0"

            originalStyle="" points="" sourceX="693" sourceY="136"

            status="0" style="defaultEdge" targetX="692" targetY="178"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1437511969343"

        description="converts a result set to a delimited string"

        displayName="Gather ShareNames" height="34" interactive="0"

        jobMode="0" name="ResultSetToText"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ResultSetToText"

        uniqueName="ResultSetToText_1" waitSetting="0" width="145"

        x="624" y="226">

        <inputs val="&lt;inputs>&lt;resultSet class=&quot;java.lang.Object&quot; _list_=&quot;false&quot;>xpath:{/workflow/CommServDBQuery_6/resultSets}&lt;/resultSet>&lt;delimiter class=&quot;workflow.types.Delimiter&quot; _list_=&quot;false&quot;>Comma&lt;/delimiter>&lt;headers class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/headers>&lt;/inputs>"/>

        <transition activity="Script_17" commented="0" originalStyle=""

            points="" sourceX="689" sourceY="243" status="0"

            style="defaultEdge" targetX="493" targetY="300"

            transitionIndex="0" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1437512201715"

        description="activity to execute code snippets in the selected language"

        displayName="Create Input File" height="34" interactive="0"

        jobMode="0" name="Script"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Script"

        uniqueName="Script_17" waitSetting="0" width="121" x="433" y="283">

        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;import java.io.File;&amp;#xD;&amp;#xA;import java.io.FileWriter;&amp;#xD;&amp;#xA;import java.io.BufferedReader;&amp;#xD;&amp;#xA;import java.io.FileReader;&amp;#xD;&amp;#xA;import org.apache.commons.lang.StringUtils;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;String filePath = xpath:{/workflow/inputs/DiscoveryOutput} + &amp;quot;\\&amp;quot; + xpath:{/workflow/system/jobId}  + &amp;quot;\\SystemDiscoveryInput.ini&amp;quot; ;&amp;#xD;&amp;#xA;final File file = new File(filePath);&amp;#xD;&amp;#xA;final File parent_directory = file.getParentFile();&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;DiscoveryClientType&amp;quot;, &amp;quot;WINDOWS&amp;quot;);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if (null != parent_directory)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    parent_directory.mkdirs();&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;DiscoveryInputFile&amp;quot;, filePath);&amp;#xD;&amp;#xA;FileWriter writer = new FileWriter(filePath);&amp;#xD;&amp;#xA;writer.write(xpath:{/workflow/ResultSetToText_1/output});&amp;#xD;&amp;#xA;writer.close();&quot; />&lt;/inputs>"/>

        <transition activity="Switch_2" commented="0" originalStyle=""

            points="" sourceX="493" sourceY="300" status="0"

            style="defaultEdge" targetX="671" targetY="331"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1437512543335"

        description="turns off all logging, except for errors, for current job"

        displayName="No Log" height="34" interactive="0" jobMode="0"

        name="DisableLogging"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=DisableLogging" uniqueName="DisableLogging_3"

        waitSetting="0" width="81" x="481" y="145">

        <inputs val="&lt;inputs />"/>

        <transition activity="CommServDBQuery_6" commented="0"

            originalStyle="" points="" sourceX="511" sourceY="192"

            status="0" style="defaultEdge" targetX="593" targetY="145"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1437660988314" description="if/else based decision"

        displayName="Decision" height="100" interactive="0" jobMode="0"

        name="Decision" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_6" waitSetting="0" width="100" x="313" y="196">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>new String(xpath:{/workflow/inputs/clientsNameFile}).contains(&quot;Generate&quot;)&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="EnableLogging_3" commented="0"

            displayName="User Input" originalStyle="" points=""

            sourceX="373" sourceY="223" status="0" style="defaultEdge"

            targetX="130" targetY="374" transitionIndex="0"

            value="False" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="DisableLogging_3" commented="0"

            displayName="Generate Input" originalStyle="" points=""

            sourceX="373" sourceY="223" status="0" style="defaultEdge"

            targetX="469" targetY="184" transitionIndex="0" value="True"

            x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1437677825845"

        description="turns on all logging for the current job"

        displayName="EnableLogging" height="34" interactive="0"

        jobMode="0" name="EnableLogging"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=EnableLogging" uniqueName="EnableLogging_4"

        waitSetting="0" width="113" x="643" y="170">

        <inputs val="&lt;inputs />"/>

        <transition activity="ResultSetToText_1" commented="0"

            originalStyle="" points="" sourceX="699" sourceY="187"

            status="0" style="defaultEdge" targetX="691" targetY="251"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1450120389897"

        description="turns off all logging, except for errors, for current job"

        displayName="Stop SQL Logs" height="34" interactive="0"

        jobMode="0" name="DisableLogging"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=DisableLogging" uniqueName="DisableLogging_5"

        waitSetting="0" width="130" x="864" y="70">

        <inputs val="&lt;inputs />"/>

        <transition activity="Set_FLA_Params" commented="0"

            originalStyle="" points="" sourceX="922" sourceY="87"

            status="0" style="defaultEdge" targetX="1204" targetY="49"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <formProperties css="" height="600" javaScript="" width="500"/>

</workflow>'

IF not exists (select * from WF_Definition where Name = @name)

BEGIN
	INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision, uniqueGuid)


	VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision, @guid)

	SET @workflowId = @@IDENTITY
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


	VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

	SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = ISNULL(revision, '') From WF_Definition WHERE Name = @name

	IF (@currentFlags & 4 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0) AND (@currentRevision <> @revision)

	BEGIN

		SET @version = @version + 1

		UPDATE WF_Definition

		SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision, uniqueGuid = @guid

		WHERE Name = @name

		IF (@flags & 8 > 0 OR @flags & 16 > 0)

		BEGIN

			UPDATE WF_Definition

			SET flags = @flags

			WHERE Name = @name

		END
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


		VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

	END

END

