

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_APSSExcludeSLA.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER ON

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @guid nvarchar(256)

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.1.4.4 $'

SET @name = 'APSS Exclude SLA'

SET @description = 'This workflow requires "Proactive Support" to be enabled under the Cloud Metrics Reporting control panel and requires the "APSS - Missed SLA Report" from the software store.&#xd;&#xa;&#xd;&#xa;Run the custom report in the webconsole, and click the button next to the subclient that needs to be excluded from SLA.'

SET @version = 1

SET @flags = 14

SET @guid = '8057d4af-6f15-47bd-8438-b12094a55c14'

SET @definition = '<workflow apiMode="0" appCategory="6" 

    description="This workflow requires &quot;Proactive Support&quot; to be enabled under the Cloud Metrics Reporting control panel and requires the &quot;APSS - Missed SLA Report&quot; from the software store.&#xd;&#xa;&#xd;&#xa;Run the custom report in the webconsole, and click the button next to the subclient that needs to be excluded from SLA."

    inputs="&lt;inputs>&lt;subclientID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;Client class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;Agent class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;Subclient class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/inputs>"

    interactive="1" isHtmlDescription="0" name="APSS Exclude SLA"

    outputs="&lt;outputs />" revision="$Revision: 1.1.4.4 $"

    uniqueGuid="8057d4af-6f15-47bd-8438-b12094a55c14"

    variables="&lt;variables>&lt;version class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>1.0.4&lt;/version>&lt;/variables>" workflowId="0">

    <schema>

        <outputs attribute="0" className="" listType="0" name="outputs"

            required="1" type=""/>

        <variables attribute="0" className="" listType="0"

            name="variables" required="1" type="">

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="1.0.0" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="version" readOnly="0" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

        </variables>

        <inputs attribute="0" className="" listType="0" name="inputs"

            required="1" type="">

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName="Client:"

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" maximumValue="" minimumValue=""

                name="Client" readOnly="1" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName="Agent:"

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" maximumValue="" minimumValue=""

                name="Agent" readOnly="1" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName="Subclient:"

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" maximumValue="" minimumValue=""

                name="Subclient" readOnly="1" required="0"

                searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue=""

                displayName="Subclient ID:" documentation="" hidden="0"

                inputType="java.lang.String" listType="0"

                maximumValue="" minimumValue="" name="subclientID"

                readOnly="1" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

        </inputs>

    </schema>

    <Start commented="0" continueOnFailure="0" created="0"

        description="" displayName="Start" height="36" interactive="0"

        jobMode="0" name="Start" originalStyle="" skipAttempt="0"

        style="image;image=/images/jgraphx/house.png"

        uniqueName="Start_1" waitSetting="0" width="58" x="43" y="38">

        <inputs val="&lt;inputs />"/>

        <transition activity="CommServDBQuery_3" commented="0"

            originalStyle="" points="" sourceX="72" sourceY="56"

            status="0" style="defaultEdge" targetX="257" targetY="104"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Start>

    <Activity commented="0" continueOnFailure="0"

        created="1449859383481"

        description="creates a super process group"

        displayName="Exclude From SLA" height="392" interactive="0"

        jobMode="0" name="ProcessBlock"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ProcessBlock_1" waitSetting="0" width="372" x="502" y="13">

        <inputs val="&lt;inputs>&lt;inputs>&lt;userSecurityGroup class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;subclientID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/inputs>&lt;/inputs>"/>

        <superProcess>

            <Start commented="0" continueOnFailure="0"

                created="1449859383481" description=""

                displayName="Start" height="27" interactive="0"

                jobMode="0" name="Start" originalStyle=""

                skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_3" waitSetting="0" width="58" x="17" y="28">

                <inputs val="&lt;inputs />"/>

                <transition activity="ExecuteScript_2" commented="0"

                    originalStyle="" points="" sourceX="446"

                    sourceY="53" status="0" style="defaultEdge"

                    targetX="450" targetY="203" transitionIndex="0"

                    x="309" y="6">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity commented="0" continueOnFailure="1"

                created="1473777529020"

                description="executes queries against a commcell database"

                displayName="subclientToEnable_SQL" height="22"

                interactive="0" jobMode="0" maxRestarts="0"

                name="CommServDBQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.CommServDBQuery"

                uniqueName="CommServDBQuery_2" waitSetting="0"

                width="165" x="34" y="153">

                <inputs val="&lt;inputs>&lt;commCell />&lt;query>-- Subclient to Exclude&amp;#xD;&#xd;&#xa;SELECT A.id AS AppId, &amp;#xD;&#xd;&#xa;CL.name AS ClientName, &amp;#xD;&#xd;&#xa;IT.name AS AppTypeName, &amp;#xD;&#xd;&#xa;INS.name AS InstanceName, &amp;#xD;&#xd;&#xa;BS.name AS BackupsetName, &amp;#xD;&#xd;&#xa;A.SubclientName&amp;#xD;&#xd;&#xa;FROM&#x9;APP_Application A&amp;#xD;&#xd;&#xa;INNER JOIN APP_Client CL ON A.clientId = CL.id&amp;#xD;&#xd;&#xa;INNER JOIN APP_iDAType IT ON A.appTypeId = IT.type&amp;#xD;&#xd;&#xa;INNER JOIN APP_InstanceName INS ON A.instance = INS.id&amp;#xD;&#xd;&#xa;INNER JOIN APP_BackupSetName BS ON A.backupSet = BS.id&amp;#xD;&#xd;&#xa;where a.id = xpath:{/workflow/ProcessBlock_1/subclientID}&lt;/query>&lt;/inputs>"/>

                <transition activity="Decision_6" commented="0"

                    originalStyle="" sourceX="116" sourceY="164"

                    status="0" style="defaultEdge" targetX="202"

                    targetY="228" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1449859723561" description=""

                displayName="Exclude_SubClient" height="16"

                interactive="0" jobMode="0" name="Execute"

                namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                originalStyle="" skipAttempt="0"

                style="label;image=Execute" uniqueName="Execute_1"

                waitSetting="0" width="136" x="55" y="347">

                <inputs val="&lt;inputs>&lt;inputXml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&amp;lt;?xml version=&quot;1.0&quot; encoding=&quot;UTF-8&quot; standalone=&quot;no&quot; ?&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;App_UpdateSubClientPropertiesRequest&amp;gt;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;  &amp;lt;association&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;entity&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;appName&amp;gt;xpath:{/workflow/CommServDBQuery_2/resultSets/row/col[3]}&amp;lt;/appName&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;backupsetName&amp;gt;xpath:{/workflow/CommServDBQuery_2/resultSets/row/col[5]}&amp;lt;/backupsetName&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;clientName&amp;gt;xpath:{/workflow/CommServDBQuery_2/resultSets/row/col[2]}&amp;lt;/clientName&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;instanceName&amp;gt;xpath:{/workflow/CommServDBQuery_2/resultSets/row/col[4]}&amp;lt;/instanceName&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;subclientName&amp;gt;xpath:{/workflow/CommServDBQuery_2/resultSets/row/col[6]}&amp;lt;/subclientName&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/entity&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;/association&amp;gt;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;  &amp;lt;subClientProperties&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;commonProperties&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;excludeFromSLA&amp;gt;True&amp;lt;/excludeFromSLA&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/commonProperties&amp;gt;&amp;#xD;&#xd;&#xa;   &amp;lt;/subClientProperties&amp;gt;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&amp;lt;/App_UpdateSubClientPropertiesRequest&amp;gt;&lt;/inputXml>&lt;commandArgs class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1473780660869"

                description="if/else based decision"

                displayName="Decision" height="58" interactive="0"

                jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_5"

                waitSetting="0" width="79" x="112" y="75">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/ExecuteScript_2/commandOutput}.contains(&quot;True&quot;)&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="WorkflowEnd_3" commented="0"

                    displayName="False" originalStyle="" points=""

                    sourceX="151" sourceY="104" status="0"

                    style="defaultEdge" targetX="293" targetY="106"

                    transitionIndex="0" value="false" x="20" y="109">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="CommServDBQuery_2" commented="0"

                    displayName="True" originalStyle="" points=""

                    sourceX="344" sourceY="83" status="0"

                    style="defaultEdge" targetX="206" targetY="141"

                    transitionIndex="0" value="true" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1473780696766" description="Ends the workflow"

                displayName="WorkflowEnd" height="21" interactive="0"

                jobMode="0" name="WorkflowEnd"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.EndActivity"

                uniqueName="WorkflowEnd_3" waitSetting="0" width="106"

                x="240" y="96">

                <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;>FAILED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>Invalid subclient ID was received.  Please execute this workflow from the SLA Custom Report.&lt;/failureMessage>&lt;/inputs>"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1473781119033"

                description="Execute a script on a remote machine"

                displayName="validateInput" height="20" interactive="0"

                jobMode="0" name="ExecuteScript"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.ExecuteScript"

                uniqueName="ExecuteScript_2" waitSetting="0" width="102"

                x="108" y="32">

                <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>&lt;clientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;clientId class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;clientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;hostName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;clientGUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;displayName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;commCellName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;csGUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;type class=&quot;commvault.msgs.CvEntities.CommCellType&quot; _list_=&quot;false&quot; />&lt;flags class=&quot;commvault.msgs.CvEntities.EntityFlags&quot; _list_=&quot;false&quot; />&lt;GUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;newName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;scriptType class=&quot;commvault.msgs.App.ScriptType&quot; _list_=&quot;false&quot;>PowerShell&lt;/scriptType>&lt;script class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>## Validate numeric input&amp;#xD;&#xd;&#xa;$x = ''xpath:{/workflow/ProcessBlock_1/subclientID}''&amp;#xD;&#xd;&#xa;$x -match ''^\d+$''&lt;/script>&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>-ExecutionPolicy Bypass&lt;/arguments>&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

                <transition activity="Decision_5" commented="0"

                    originalStyle="" points="" sourceX="194"

                    sourceY="45" status="0" style="defaultEdge"

                    targetX="201" targetY="147" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1474377690729"

                description="if/else based decision" displayName="VM?"

                height="100" interactive="0" jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_6"

                waitSetting="0" width="100" x="68" y="199">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/CommServDBQuery_2/resultSets/row/col[3]}.equals(&quot;Virtual Server&quot;)&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="Execute_1" commented="0"

                    displayName="Not VM" originalStyle="" sourceX="221"

                    sourceY="253" status="0" style="defaultEdge"

                    targetX="140" targetY="346" transitionIndex="0"

                    value="False" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="Execute_2" commented="0"

                    displayName="VM" originalStyle="" status="0"

                    style="defaultEdge" transitionIndex="0" value="true"

                    x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1474378737432" description=""

                displayName="excludeVM" height="19" interactive="0"

                jobMode="0" name="Execute"

                namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.cmd.operation.OperationExecute"

                uniqueName="Execute_2" waitSetting="0" width="100"

                x="233" y="239">

                <inputs val="&lt;inputs>&lt;inputXml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&amp;lt;?xml version=&quot;1.0&quot; encoding=&quot;UTF-8&quot; standalone=&quot;no&quot; ?&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;App_SetClientPropertiesRequest&amp;gt;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;  &amp;lt;association&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;entity&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;clientName&amp;gt;&amp;lt;/clientName&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/entity&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;/association&amp;gt;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;  &amp;lt;clientProperties&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;client&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;clientDescription&amp;gt;&amp;lt;/clientDescription&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;clientEntity&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;clientName&amp;gt;&amp;lt;/clientName&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;commCellName&amp;gt;&amp;lt;/commCellName&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;hostName&amp;gt;&amp;lt;/hostName&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/clientEntity&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;cvdPort&amp;gt;&amp;lt;/cvdPort&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;evmgrcPort&amp;gt;&amp;lt;/evmgrcPort&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;installDirectory&amp;gt;&amp;lt;/installDirectory&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;jobResulsDir&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;path&amp;gt;&amp;lt;/path&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;userAccount&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;userName&amp;gt;&amp;lt;/userName&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;/userAccount&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/jobResulsDir&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/client&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;clientGroups&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;clientGroupName&amp;gt;&amp;lt;/clientGroupName&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/clientGroups&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;clientGroups&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;clientGroupName&amp;gt;&amp;lt;/clientGroupName&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/clientGroups&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;clientProps&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;AltCachePartitionForQSnap&amp;gt;&amp;lt;/AltCachePartitionForQSnap&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;AutoUpdateLocation&amp;gt;&amp;lt;/AutoUpdateLocation&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;CDRLogFileLocation&amp;gt;&amp;lt;/CDRLogFileLocation&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;CenteraResourceFilename&amp;gt;&amp;lt;/CenteraResourceFilename&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;CipherType&amp;gt;&amp;lt;/CipherType&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;DirectMediaAccessFlag&amp;gt;&amp;lt;/DirectMediaAccessFlag&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;EnableCollectDelegateInfo&amp;gt;&amp;lt;/EnableCollectDelegateInfo&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;EnableContentIndexing&amp;gt;&amp;lt;/EnableContentIndexing&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;EnableEncryption&amp;gt;&amp;lt;/EnableEncryption&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;EncryptionSettings&amp;gt;&amp;lt;/EncryptionSettings&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;EnableRetryOnNetworkError&amp;gt;&amp;lt;/EnableRetryOnNetworkError&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;EnableSnapBackups&amp;gt;&amp;lt;/EnableSnapBackups&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;EncryptKeyLength&amp;gt;&amp;lt;/EncryptKeyLength&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;JobPriority&amp;gt;&amp;lt;/JobPriority&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;JobResultsDiskCapThreshold&amp;gt;&amp;lt;/JobResultsDiskCapThreshold&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;JobResultsRetentionDays&amp;gt;&amp;lt;/JobResultsRetentionDays&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;JobResultsThresholdMB&amp;gt;&amp;lt;/JobResultsThresholdMB&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;OptimizeDataForSearch&amp;gt;&amp;lt;/OptimizeDataForSearch&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;PathToExchangeMiningTool&amp;gt;&amp;lt;/PathToExchangeMiningTool&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;RestoreAccessFlag&amp;gt;&amp;lt;/RestoreAccessFlag&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;RetryCountOnNetworkError&amp;gt;&amp;lt;/RetryCountOnNetworkError&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;RetryFrequencyInSecOnNetworkError&amp;gt;&amp;lt;/RetryFrequencyInSecOnNetworkError&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;WebServer/&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;  &amp;lt;advancedClientProperties&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;excludeFromSLA&amp;gt;&amp;lt;/excludeFromSLA&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;mailServerRole&amp;gt;&amp;lt;/mailServerRole&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/advancedClientProperties&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;cacheSource&amp;gt;&amp;lt;/cacheSource&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;clientActivityControl&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;activityControlOptions&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;activityType&amp;gt;&amp;lt;/activityType&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;dateTime/&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;enableActivityType&amp;gt;&amp;lt;/enableActivityType&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;enableAfterADelay&amp;gt;&amp;lt;/enableAfterADelay&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;/activityControlOptions&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/clientActivityControl&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;securityAssociations&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&amp;lt;associationsOperationType&amp;gt;&amp;lt;/associationsOperationType&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;associations&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;properties&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;role&amp;gt;&amp;#xD;&#xd;&#xa;              &amp;lt;roleName&amp;gt;&amp;lt;/roleName&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;/role&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;/properties&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;userOrGroup&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&amp;lt;userName&amp;gt;&amp;lt;/userName&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;  &amp;lt;/userOrGroup&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;  &amp;lt;userOrGroup&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&amp;lt;userGroupName&amp;gt;&amp;lt;/userGroupName&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;  &amp;lt;/userOrGroup&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;  &amp;lt;userOrGroup&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&amp;lt;externalGroupName&amp;gt;&amp;lt;/externalGroupName&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&amp;lt;providerDomainName&amp;gt;&amp;lt;/providerDomainName&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;/userOrGroup&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;/associations&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;ownerAssociations&amp;gt;&#x9;&#x9;&#x9;&amp;#xD;&#xd;&#xa;          &amp;lt;categoryPermission&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&amp;lt;categoriesPermissionOperationType&amp;gt;&amp;lt;/categoriesPermissionOperationType&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;categoriesPermissionList&amp;gt;              &amp;#xD;&#xd;&#xa;              &amp;lt;permissionName&amp;gt;&amp;lt;/permissionName&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;/categoriesPermissionList&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;/categoryPermission&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;  &amp;lt;ownersOperationType&amp;gt;&amp;lt;/ownersOperationType&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;owners&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;userGroupName&amp;gt;&amp;lt;/userGroupName&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;/owners&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;  &amp;lt;owners&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&#x9;&amp;lt;userName&amp;gt;&amp;lt;/userName&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;  &amp;lt;/owners&amp;gt;&amp;#xD;&#xd;&#xa;&#x9;&#x9;&amp;lt;/ownerAssociations&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/securityAssociations&amp;gt;   &amp;#xD;&#xd;&#xa;      &amp;lt;deDuplicationProperties&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;cacheBufferSize&amp;gt;&amp;lt;/cacheBufferSize&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;clientSideDeduplication&amp;gt;&amp;lt;/clientSideDeduplication&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;enableClientSideDiskCache&amp;gt;&amp;lt;/enableClientSideDiskCache&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;enableHighLatencyOptimization&amp;gt;&amp;lt;/enableHighLatencyOptimization&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;enableVariableContentAlignment&amp;gt;&amp;lt;/enableVariableContentAlignment&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;maxCacheDb&amp;gt;&amp;lt;/maxCacheDb&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;performClientSideDeduplication&amp;gt;&amp;lt;/performClientSideDeduplication&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/deDuplicationProperties&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;dlpPropertise&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;dlpEnableClientKeys&amp;gt;&amp;lt;/dlpEnableClientKeys&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;dlpMinFileAgeMins&amp;gt;&amp;lt;/dlpMinFileAgeMins&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;dlpRMProperties&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;dlpRmNow&amp;gt;&amp;lt;/dlpRmNow&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;dlpRmOfflineDays&amp;gt;&amp;lt;/dlpRmOfflineDays&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;enableRmDLP&amp;gt;&amp;lt;/enableRmDLP&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;/dlpRMProperties&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;dlpScanIntervalMins&amp;gt;&amp;lt;/dlpScanIntervalMins&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;dlpStolen&amp;gt;&amp;lt;/dlpStolen&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;enableDLP&amp;gt;&amp;lt;/enableDLP&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/dlpPropertise&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;enableAccessControl&amp;gt;&amp;lt;/enableAccessControl&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;fileLevelAnalyticsLicense&amp;gt;&amp;lt;/fileLevelAnalyticsLicense&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;isWebServerInstalled&amp;gt;true&amp;lt;/isWebServerInstalled&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;overrideGlobalDesktopGuiProperties&amp;gt;&amp;lt;/overrideGlobalDesktopGuiProperties&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;recallService&amp;gt;&amp;lt;/recallService&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;rightManagementServiceProperties&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;SMTPAddressOfTheRMSSuperUser&amp;gt;&amp;lt;/SMTPAddressOfTheRMSSuperUser&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;decryptRMSDocumentDuringContentIndexing&amp;gt;&amp;lt;/decryptRMSDocumentDuringContentIndexing&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;rmsCredentials&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;userName&amp;gt;&amp;lt;/userName&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;/rmsCredentials&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;smtpAddressOfRMSSuperUser&amp;gt;&amp;lt;/smtpAddressOfRMSSuperUser&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/rightManagementServiceProperties&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;spWebServerProperties&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;enableOnlineSearch&amp;gt;&amp;lt;/enableOnlineSearch&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;spWebServerUserPassword/&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/spWebServerProperties&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;webSearchServer&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;clientName&amp;gt;&amp;lt;/clientName&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;hostName&amp;gt;&amp;lt;/hostName&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/webSearchServer&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;webSearchServerForSuperSearch/&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;webSearchServiceUrl&amp;gt;&amp;lt;/webSearchServiceUrl&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/clientProps&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;clusterClientProperties&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;configureClusterClient&amp;gt;&amp;lt;/configureClusterClient&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;showAllAgents&amp;gt;&amp;lt;/showAllAgents&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/clusterClientProperties&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;pseudoClientInfo&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;openVMSProperties&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;cvdPort&amp;gt;&amp;lt;/cvdPort&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;userAccount&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;userName&amp;gt;&amp;lt;/userName&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;/userAccount&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/openVMSProperties&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/pseudoClientInfo&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;/clientProperties&amp;gt;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&amp;lt;/App_SetClientPropertiesRequest&amp;gt;&lt;/inputXml>&lt;commandArgs class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>-clientName ''xpath:{/workflow/inputs/Client}'' -excludeFromSLA true&lt;/commandArgs>&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&lt;/tokenFile>&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&lt;/token>&lt;/sessionOptions>&lt;/inputs>"/>

            </Activity>

        </superProcess>

        <activitySchema>

            <outputs attribute="0" className="" defaultValue=""

                listType="0" name="outputs" required="1" type="">

                <children attribute="0" className="java.lang.String"

                    controlType="0" defaultValue="" displayName=""

                    documentation="" hidden="0"

                    inputType="java.lang.String" listType="0"

                    name="userSecurityGroup" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children attribute="0" className="java.lang.String"

                    controlType="0" defaultValue="" displayName=""

                    documentation="" hidden="0"

                    inputType="java.lang.String" listType="0"

                    name="subclientID" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            </outputs>

            <inputs attribute="0" className="" defaultValue=""

                listType="0" name="inputs" required="1" type="">

                <children attribute="0" className="java.lang.String"

                    controlType="0" defaultValue="" displayName=""

                    documentation="" hidden="0"

                    inputType="java.lang.String" listType="0"

                    name="userSecurityGroup" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children attribute="0" className="java.lang.String"

                    controlType="0" defaultValue="" displayName=""

                    documentation="" hidden="0"

                    inputType="java.lang.String" listType="0"

                    name="subclientID" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            </inputs>

        </activitySchema>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1449859844214"

        description="executes a defined process block within the workflow"

        displayName="Exclude From SLA" height="19" interactive="0"

        jobMode="0" name="ExecuteProcessBlock"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ExecuteProcessBlock"

        uniqueName="ExecuteProcessBlock_3" waitSetting="0" width="133"

        x="138" y="185">

        <inputs val="&lt;inputs>&lt;inputs>&lt;userSecurityGroup class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/CommServDBQuery_3/resultSets/row/col[1]}&lt;/userSecurityGroup>&lt;subclientID class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/subclientID}&lt;/subclientID>&lt;/inputs>&lt;processBlock>ProcessBlock_1&lt;/processBlock>&lt;outputs />&lt;/inputs>"/>

        <activitySchema>

            <outputs name="ProcessBlock_1">

                <children className="" name="Start_3" type=""/>

                <children className="" defaultValue="" listType="0"

                    name="CommServDBQuery_2" type="">

                    <children attribute="0"

                        className="workflow.types.data.DataSet"

                        defaultValue="" hidden="0"

                        inputType="workflow.types.data.DataSet"

                        listType="1" name="resultSets" type="{workflow.types.data}DataSet">

                        <children attribute="0"

                            className="java.lang.Integer"

                            defaultValue="" hidden="0"

                            inputType="java.lang.Integer" listType="0"

                            name="rowCount" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                        <children attribute="0"

                            className="java.lang.Integer"

                            defaultValue="" hidden="0"

                            inputType="java.lang.Integer" listType="0"

                            name="columnCount" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                        <children attribute="0"

                            className="commvault.msgs.CvEntities.CommCellEntity"

                            defaultValue="" hidden="0"

                            inputType="commvault.msgs.CvEntities.CommCellEntity"

                            listType="1" name="commCell" type="{commvault.msgs.CvEntities}CommCellEntity">

                            <children attribute="0"

                                className="java.lang.String"

                                defaultValue=""

                                inputType="java.lang.String"

                                listType="0" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string"/>

                            <children attribute="0"

                                className="java.lang.Integer"

                                defaultValue=""

                                inputType="java.lang.Integer"

                                listType="0" name="commCellId" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                            <children attribute="0"

                                className="java.lang.String"

                                defaultValue=""

                                inputType="java.lang.String"

                                listType="0" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string"/>

                            <children attribute="0"

                                className="java.lang.String"

                                defaultValue=""

                                inputType="java.lang.String"

                                listType="0" name="csGUID" type="{http://www.w3.org/2001/XMLSchema}string"/>

                            <children attribute="0"

                                className="commvault.msgs.CvEntities.CommCellType"

                                defaultValue=""

                                inputType="commvault.msgs.CvEntities.CommCellType"

                                listType="0" name="type" type="{commvault.msgs.CvEntities}CommCellType">

                                <options val="GALAXY"/>

                                <options val="NBU"/>

                                <options val="NETAPP"/>

                                <options val="TSM"/>

                                <options val="VEEAM"/>

                            </children>

                            <children attribute="0"

                                className="commvault.msgs.CvEntities.EntityFlags"

                                defaultValue=""

                                inputType="commvault.msgs.CvEntities.EntityFlags"

                                listType="0" name="flags" type="{commvault.msgs.CvEntities}EntityFlags"/>

                            <children attribute="0"

                                className="java.lang.String"

                                defaultValue=""

                                inputType="java.lang.String"

                                listType="0" name="GUID" type="{http://www.w3.org/2001/XMLSchema}string"/>

                            <children attribute="0"

                                className="java.lang.String"

                                defaultValue=""

                                inputType="java.lang.String"

                                listType="0" name="newName" type="{http://www.w3.org/2001/XMLSchema}string"/>

                        </children>

                        <children attribute="0"

                            className="workflow.types.data.DataRow"

                            defaultValue="" hidden="0"

                            inputType="workflow.types.data.DataRow"

                            listType="1" name="row" type="{workflow.types.data}DataRow">

                            <children attribute="0"

                                className="java.lang.Object"

                                defaultValue="" hidden="0"

                                inputType="java.lang.Object"

                                listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                        </children>

                    </children>

                    <children attribute="0"

                        className="java.lang.Integer" defaultValue=""

                        hidden="0" inputType="java.lang.Integer"

                        listType="0" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                    <children attribute="0" className="java.lang.String"

                        defaultValue="" hidden="0"

                        inputType="java.lang.String" listType="0"

                        name="errorMessage" type="{http://www.w3.org/2001/XMLSchema}string"/>

                </children>

                <children className="" defaultValue="" listType="0"

                    name="Execute_1" type="">

                    <children attribute="0" className="java.lang.String"

                        defaultValue=""

                        documentation="xml output contents" hidden="0"

                        inputType="java.lang.String" listType="0"

                        name="outputXml" type="{http://www.w3.org/2001/XMLSchema}string"/>

                    <children attribute="0"

                        className="java.lang.Integer" defaultValue=""

                        documentation="return code from the executable"

                        hidden="0" inputType="java.lang.Integer"

                        listType="0" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                    <children attribute="0" className="java.lang.String"

                        defaultValue="" documentation="command output"

                        hidden="0" inputType="java.lang.String"

                        listType="0" name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string"/>

                </children>

                <children className="" defaultValue="" listType="0"

                    name="Decision_5" type=""/>

                <children name="WorkflowEnd_3"/>

                <children className="" name="ExecuteScript_2" type="">

                    <children className="java.lang.Integer"

                        documentation="the exitCode recieved from executing the command"

                        inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                    <children className="java.lang.Integer"

                        documentation="the return code recieved from completion of the command"

                        inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                    <children className="java.lang.String"

                        documentation="the output from the command or error message if it failed"

                        inputType="java.lang.String"

                        name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string"/>

                </children>

                <children className="" defaultValue="" listType="0"

                    name="Decision_6" type=""/>

                <children className="" defaultValue="" listType="0"

                    name="Execute_2" type="">

                    <children attribute="0" className="java.lang.String"

                        defaultValue=""

                        documentation="xml output contents" hidden="0"

                        inputType="java.lang.String" listType="0"

                        name="outputXml" type="{http://www.w3.org/2001/XMLSchema}string"/>

                    <children attribute="0"

                        className="java.lang.Integer" defaultValue=""

                        documentation="return code from the executable"

                        hidden="0" inputType="java.lang.Integer"

                        listType="0" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                    <children attribute="0" className="java.lang.String"

                        defaultValue="" documentation="command output"

                        hidden="0" inputType="java.lang.String"

                        listType="0" name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string"/>

                </children>

            </outputs>

            <inputs attribute="0" className="" defaultValue=""

                listType="0" name="inputs" required="1" type="">

                <children attribute="0" className="java.lang.String"

                    controlType="0" defaultValue="" displayName=""

                    documentation="" hidden="0"

                    inputType="java.lang.String" listType="0"

                    name="userSecurityGroup" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children attribute="0" className="java.lang.String"

                    controlType="0" defaultValue="" displayName=""

                    documentation="" hidden="0"

                    inputType="java.lang.String" listType="0"

                    name="subclientID" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            </inputs>

        </activitySchema>

        <transition activity="ExecuteProcessBlock_4" commented="0"

            originalStyle="" points="" sourceX="204" sourceY="198"

            status="0" style="defaultEdge" targetX="309" targetY="236"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1448306682277"

        description="creates a super process group"

        displayName="Get Emails From User Group" height="130"

        interactive="0" jobMode="0" name="ProcessBlock"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ProcessBlock_8" waitSetting="0" width="189" x="503" y="417">

        <inputs val="&lt;inputs>&lt;inputs>&lt;apssSecurityGroup class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/inputs>&lt;/inputs>"/>

        <superProcess>

            <Start commented="0" continueOnFailure="0"

                created="1448306682277" description=""

                displayName="Start" height="19" interactive="0"

                jobMode="0" name="Start" originalStyle=""

                skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_10" waitSetting="0" width="120" x="18" y="30">

                <inputs val="&lt;inputs />"/>

                <transition activity="CommServDBQuery_8" commented="0"

                    originalStyle="" points="" sourceX="78" sourceY="45"

                    status="0" style="defaultEdge" targetX="173"

                    targetY="138" transitionIndex="0" x="-1809" y="-400">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity commented="0" continueOnFailure="0"

                created="1448306692317"

                description="executes queries against a commcell database"

                displayName="get_emails_SQL" height="18" interactive="0"

                jobMode="0" name="CommServDBQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=CommServDBQuery"

                uniqueName="CommServDBQuery_8" waitSetting="0"

                width="143" x="12" y="66">

                <inputs val="&lt;inputs>&lt;commCell />&lt;query>--Get User to UserGroup associations to extract Email accounts&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;--select umu.login as UserLogin, umu.email as UserEmail from UMGroups as umg WITH (NOLOCK)&amp;#xD;&#xd;&#xa;select umu.email as UserEmail from UMGroups as umg WITH (NOLOCK)&amp;#xD;&#xd;&#xa;INNER JOIN UMUserGroup as umug WITH (NOLOCK)&amp;#xD;&#xd;&#xa;ON umg.id = umug.GroupId&amp;#xD;&#xd;&#xa;INNER JOIN UMUsers as umu WITH (NOLOCK)&amp;#xD;&#xd;&#xa;ON umug.userId = umu.id&amp;#xD;&#xd;&#xa;WHERE umg.name = ''xpath:{/workflow/ProcessBlock_8/apssSecurityGroup}'' and umu.email not like ''''&lt;/query>&lt;/inputs>"/>

                <transition activity="ExecuteScript_8" commented="0"

                    originalStyle="" points="" sourceX="173"

                    sourceY="138" status="0" style="defaultEdge"

                    targetX="190" targetY="231" transitionIndex="0"

                    x="-1809" y="-400">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1448306710047"

                description="Execute a script on a remote machine"

                displayName="format_emails_PS" height="14"

                interactive="0" jobMode="0" name="ExecuteScript"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=ExecuteScript"

                uniqueName="ExecuteScript_8" waitSetting="0" width="154"

                x="4" y="100">

                <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>&lt;clientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;clientId class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;clientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;hostName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;_type_ class=&quot;commvault.msgs.CvEntities.EntityType&quot; _list_=&quot;false&quot; />&lt;clientGUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;displayName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;commCellName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;csGUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;type class=&quot;commvault.msgs.CvEntities.CommCellType&quot; _list_=&quot;false&quot; />&lt;_type_ class=&quot;commvault.msgs.CvEntities.EntityType&quot; _list_=&quot;false&quot; />&lt;_type_ class=&quot;commvault.msgs.CvEntities.EntityType&quot; _list_=&quot;false&quot; />&lt;flags class=&quot;commvault.msgs.CvEntities.EntityFlags&quot; _list_=&quot;false&quot; />&lt;GUID class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;newName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;scriptType class=&quot;commvault.msgs.App.ScriptType&quot; _list_=&quot;false&quot;>PowerShell&lt;/scriptType>&lt;script class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>##Script to format SQL output&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;$str = ''xpath:{/workflow/CommServDBQuery_8/resultSets/row/col[1]}''&amp;#xD;&#xd;&#xa;$newstr = $str -replace &quot;\[&quot;, &quot;&quot; | ForEach-Object {$_ -replace &quot;\]&quot;,&quot;&quot;}&amp;#xD;&#xd;&#xa;Write-Host -NoNewline $newstr&lt;/script>&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>-ExecutionPolicy Bypass&lt;/arguments>&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

            </Activity>

        </superProcess>

        <activitySchema>

            <outputs attribute="0" className="" defaultValue=""

                listType="0" name="outputs" required="1" type="">

                <children attribute="0" className="java.lang.String"

                    controlType="0" defaultValue="" documentation=""

                    hidden="0" inputType="java.lang.String" listType="0"

                    name="apssSecurityGroup" readOnly="0" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            </outputs>

            <inputs attribute="0" className="" defaultValue=""

                listType="0" name="inputs" required="1" type="">

                <children attribute="0" className="java.lang.String"

                    controlType="0" defaultValue="" documentation=""

                    hidden="0" inputType="java.lang.String" listType="0"

                    name="apssSecurityGroup" readOnly="0" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            </inputs>

        </activitySchema>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1473777982668"

        description="executes queries against a commcell database"

        displayName="init_SQL" height="23" interactive="0" jobMode="0"

        name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.CommServDBQuery"

        uniqueName="CommServDBQuery_3" waitSetting="0" width="78"

        x="167" y="39">

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>--requires V11 SP5 with Proactive Enabled.&amp;#xD;&#xd;&#xa;select name from UmGroups UG&amp;#xD;&#xd;&#xa;Inner Join UMGroupsProp UGP on UG.id = UGP.componentNameId&amp;#xD;&#xd;&#xa;where UGP.attrName = ''apssSecurityGroup'' and UGP.attrVal = 1 and UGP.modified = 0&lt;/query>&lt;/inputs>"/>

        <transition activity="Decision_4" commented="0" originalStyle=""

            points="" sourceX="206" sourceY="50" status="0"

            style="defaultEdge" targetX="204" targetY="121"

            transitionIndex="0" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1473778832978" description="if/else based decision"

        displayName="proactive enabled?" height="54" interactive="0"

        jobMode="0" name="Decision"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_4" waitSetting="0" width="141" x="134" y="94">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/CommServDBQuery_3/resultSets/rowCount}==0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="ExecuteProcessBlock_3" commented="0"

            displayName="Yes" originalStyle="" points="" sourceX="297"

            sourceY="140" status="0" style="defaultEdge" targetX="255"

            targetY="246" transitionIndex="0" value="no" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="WorkflowEnd_2" commented="0"

            displayName="No" originalStyle="" points="" sourceX="204"

            sourceY="121" status="0" style="defaultEdge" targetX="361"

            targetY="118" transitionIndex="0" value="true" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1473778909003" description="Ends the workflow"

        displayName="WorkflowEnd" height="17" interactive="0"

        jobMode="0" name="WorkflowEnd"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.EndActivity"

        uniqueName="WorkflowEnd_2" waitSetting="0" width="106" x="332" y="113">

        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;>FAILED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>The APSS user security group is not found.  Please enable Proactive Support in the Cloud Metrics control panel.&lt;/failureMessage>&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1449860190664"

        description="Sends an email to a list of users"

        displayName="Email" height="25" interactive="0" jobMode="0"

        name="Email" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Email"

        uniqueName="Email_3" waitSetting="0" width="75" x="43" y="397">

        <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot; _list_=&quot;false&quot;>&lt;to class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/ExecuteProcessBlock_4/ExecuteScript_8/commandOutput}&lt;/to>&lt;cc class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;bcc class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;from class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;subject class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>Subclients have been excluded from the SLA and Strike Count Reports CS:[xpath:{/workflow/system/commCellName}]&lt;/subject>&lt;body class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&amp;lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; width=&quot;803&quot;&amp;gt;&#xd;&#xa;      &amp;lt;tr&amp;gt;&#xd;&#xa;        &amp;lt;td&amp;gt;&#xd;&#xa;          &amp;lt;p&amp;gt;&#xd;&#xa;            &amp;lt;img border-right-style=&quot;solid&quot; border-top-width=&quot;0px&quot; src=&quot;https://clu.commvault.com/webconsole/OEM/1/images/banner.png&quot; border-right-width=&quot;0px&quot; border-left-style=&quot;solid&quot; alt=&quot;APSS Health Solutions&quot; border-bottom-width=&quot;0px&quot; border-bottom-style=&quot;solid&quot; id=&quot;_x0000_i1025&quot; border-left-width=&quot;0px&quot; border-top-style=&quot;solid&quot;&amp;gt;&#xd;&#xa;            &#xd;&#xa;          &amp;lt;/p&amp;gt;&#xd;&#xa;        &amp;lt;/td&amp;gt;&#xd;&#xa;      &amp;lt;/tr&amp;gt;&#xd;&#xa;      &amp;lt;tr&amp;gt;&#xd;&#xa;        &amp;lt;td style=&quot;width: 800px&quot;&amp;gt;&#xd;&#xa;          &amp;lt;p&amp;gt;&#xd;&#xa;            &#xd;&#xa;          &amp;lt;/p&amp;gt;&#xd;&#xa;          &amp;lt;p&amp;gt;&#xd;&#xa;            &amp;lt;font face=&quot;Tahoma&quot; size=&quot;3&quot;&amp;gt;Hello &#xd;&#xa;            [xpath:{/workflow/system/executor/userName}], &amp;lt;/font&amp;gt;&#xd;&#xa;          &amp;lt;/p&amp;gt;&#xd;&#xa;          &amp;lt;p&amp;gt;&#xd;&#xa;            &#xd;&#xa;          &amp;lt;/p&amp;gt;&#xd;&#xa;          &amp;lt;p&amp;gt;&#xd;&#xa;            &amp;lt;font face=&quot;Tahoma&quot; size=&quot;3&quot;&amp;gt;The &#xd;&#xa;            [xpath:{/workflow/system/workflow/workflowName}] Workflow has &#xd;&#xa;            successfully excluded the following subclient from SLA and Stike &#xd;&#xa;            counts:&amp;lt;br&amp;gt;&amp;lt;/font&amp;gt;&#xd;&#xa;          &amp;lt;/p&amp;gt;&#xd;&#xa;          &amp;lt;p&amp;gt;&#xd;&#xa;            &#xd;&#xa;          &amp;lt;/p&amp;gt;&#xd;&#xa;          &amp;lt;p&amp;gt;&#xd;&#xa;            &amp;lt;font face=&quot;Tahoma&quot; size=&quot;3&quot;&amp;gt;&amp;lt;b&amp;gt;Client&amp;lt;/b&amp;gt;: &#xd;&#xa;            [xpath:{/workflow/ExecuteProcessBlock_3/CommServDBQuery_2/resultSets/row/col[2]}] &#xd;&#xa;            &amp;lt;/font&amp;gt;&#xd;&#xa;          &amp;lt;/p&amp;gt;&#xd;&#xa;          &amp;lt;p&amp;gt;&#xd;&#xa;            &amp;lt;font face=&quot;Tahoma&quot; size=&quot;3&quot;&amp;gt;&amp;lt;b&amp;gt;Application&amp;lt;/b&amp;gt;: &#xd;&#xa;            [xpath:{/workflow/ExecuteProcessBlock_3/CommServDBQuery_2/resultSets/row/col[3]}] &#xd;&#xa;            &amp;lt;/font&amp;gt;&#xd;&#xa;          &amp;lt;/p&amp;gt;&#xd;&#xa;          &amp;lt;p&amp;gt;&#xd;&#xa;            &amp;lt;font face=&quot;Tahoma&quot; size=&quot;3&quot;&amp;gt;&amp;lt;b&amp;gt;Instance&amp;lt;/b&amp;gt;: &#xd;&#xa;            [xpath:{/workflow/ExecuteProcessBlock_3/CommServDBQuery_2/resultSets/row/col[4]}]&amp;lt;/font&amp;gt;&#xd;&#xa;          &amp;lt;/p&amp;gt;&#xd;&#xa;          &amp;lt;p&amp;gt;&#xd;&#xa;            &amp;lt;font face=&quot;Tahoma&quot; size=&quot;3&quot;&amp;gt;&amp;lt;b&amp;gt;BackupSet&amp;lt;/b&amp;gt;: &#xd;&#xa;            [xpath:{/workflow/ExecuteProcessBlock_3/CommServDBQuery_2/resultSets/row/col[5]}] &#xd;&#xa;            &amp;lt;/font&amp;gt;&#xd;&#xa;          &amp;lt;/p&amp;gt;&#xd;&#xa;          &amp;lt;p&amp;gt;&#xd;&#xa;            &amp;lt;font face=&quot;Tahoma&quot; size=&quot;3&quot;&amp;gt;&amp;lt;b&amp;gt;Subclient&amp;lt;/b&amp;gt;: &#xd;&#xa;            [xpath:{/workflow/ExecuteProcessBlock_3/CommServDBQuery_2/resultSets/row/col[6]}]&amp;lt;/font&amp;gt;&#xd;&#xa;          &amp;lt;/p&amp;gt;&#xd;&#xa;          &amp;lt;p&amp;gt;&#xd;&#xa;            &#xd;&#xa;          &amp;lt;/p&amp;gt;&#xd;&#xa;          &amp;lt;p&amp;gt;&#xd;&#xa;            &amp;lt;font face=&quot;Tahoma&quot; size=&quot;3&quot;&amp;gt;Thank you, &amp;lt;/font&amp;gt;&#xd;&#xa;          &amp;lt;/p&amp;gt;&#xd;&#xa;          &amp;lt;p&amp;gt;&#xd;&#xa;            &amp;lt;font face=&quot;Tahoma&quot; size=&quot;3&quot;&amp;gt;Commvault Proactive Solutions&amp;lt;/font&amp;gt;&#xd;&#xa;          &amp;lt;/p&amp;gt;&#xd;&#xa;          &amp;lt;p&amp;gt;&#xd;&#xa;            &#xd;&#xa;          &amp;lt;/p&amp;gt;&#xd;&#xa;        &amp;lt;/td&amp;gt;&#xd;&#xa;      &amp;lt;/tr&amp;gt;&#xd;&#xa;    &amp;lt;/table&amp;gt;&#xd;&#xa;    &amp;lt;div style=&quot;clear: both&quot;&amp;gt;&#xd;&#xa;      &#xd;&#xa;    &amp;lt;/div&amp;gt;&#xd;&#xa;    &amp;lt;pre&amp;gt;&amp;lt;/pre&amp;gt;&lt;/body>&lt;attachments class=&quot;java.lang.Object&quot; _list_=&quot;false&quot; />&lt;html class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/html>&lt;replyTo class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;repeatInterval class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;/email>&lt;/inputs>"/>

        <transition activity="LogEvent_1" commented="0" originalStyle=""

            points="" sourceX="80" sourceY="409" status="0"

            style="defaultEdge" targetX="82" targetY="460"

            transitionIndex="0" x="-126" y="118">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1473779547369"

        description="executes a defined process block within the workflow"

        displayName="Get Emails From User Group" height="22"

        interactive="0" jobMode="0" name="ExecuteProcessBlock"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.ExecuteSuperProcess"

        uniqueName="ExecuteProcessBlock_4" waitSetting="0" width="189"

        x="113" y="231">

        <inputs val="&lt;inputs>&lt;inputs>&lt;apssSecurityGroup class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/CommServDBQuery_3/resultSets/row/col[1]}&lt;/apssSecurityGroup>&lt;/inputs>&lt;processBlock>ProcessBlock_8&lt;/processBlock>&lt;outputs />&lt;/inputs>"/>

        <activitySchema>

            <outputs name="ProcessBlock_8">

                <children name="Start_10"/>

                <children className="" defaultValue="" listType="0"

                    name="CommServDBQuery_8" type="">

                    <children attribute="0"

                        className="workflow.types.data.DataSet"

                        defaultValue="" hidden="0"

                        inputType="workflow.types.data.DataSet"

                        listType="1" name="resultSets" type="{workflow.types.data}DataSet">

                        <children attribute="0"

                            className="java.lang.Integer"

                            defaultValue="" hidden="0"

                            inputType="java.lang.Integer" listType="0"

                            name="rowCount" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                        <children attribute="0"

                            className="java.lang.Integer"

                            defaultValue="" hidden="0"

                            inputType="java.lang.Integer" listType="0"

                            name="columnCount" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                        <children attribute="0"

                            className="commvault.msgs.CvEntities.CommCellEntity"

                            defaultValue="" hidden="0"

                            inputType="commvault.msgs.CvEntities.CommCellEntity"

                            listType="1" name="commCell" type="{commvault.msgs.CvEntities}CommCellEntity">

                            <children attribute="0"

                                className="java.lang.String"

                                defaultValue=""

                                inputType="java.lang.String"

                                listType="0" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string"/>

                            <children attribute="0"

                                className="java.lang.Integer"

                                defaultValue=""

                                inputType="java.lang.Integer"

                                listType="0" name="commCellId" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                            <children attribute="0"

                                className="java.lang.String"

                                defaultValue=""

                                inputType="java.lang.String"

                                listType="0" name="commCellName" type="{http://www.w3.org/2001/XMLSchema}string"/>

                            <children attribute="0"

                                className="java.lang.String"

                                defaultValue=""

                                inputType="java.lang.String"

                                listType="0" name="csGUID" type="{http://www.w3.org/2001/XMLSchema}string"/>

                            <children attribute="0"

                                className="commvault.msgs.CvEntities.CommCellType"

                                defaultValue=""

                                inputType="commvault.msgs.CvEntities.CommCellType"

                                listType="0" name="type" type="{commvault.msgs.CvEntities}CommCellType">

                                <options val="GALAXY"/>

                                <options val="NBU"/>

                                <options val="NETAPP"/>

                                <options val="TSM"/>

                                <options val="VEEAM"/>

                            </children>

                            <children attribute="0"

                                className="commvault.msgs.CvEntities.EntityFlags"

                                defaultValue=""

                                inputType="commvault.msgs.CvEntities.EntityFlags"

                                listType="0" name="flags" type="{commvault.msgs.CvEntities}EntityFlags"/>

                            <children attribute="0"

                                className="java.lang.String"

                                defaultValue=""

                                inputType="java.lang.String"

                                listType="0" name="GUID" type="{http://www.w3.org/2001/XMLSchema}string"/>

                            <children attribute="0"

                                className="java.lang.String"

                                defaultValue=""

                                inputType="java.lang.String"

                                listType="0" name="newName" type="{http://www.w3.org/2001/XMLSchema}string"/>

                        </children>

                        <children attribute="0"

                            className="workflow.types.data.DataRow"

                            defaultValue="" hidden="0"

                            inputType="workflow.types.data.DataRow"

                            listType="1" name="row" type="{workflow.types.data}DataRow">

                            <children attribute="0"

                                className="java.lang.Object"

                                defaultValue="" hidden="0"

                                inputType="java.lang.Object"

                                listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                        </children>

                    </children>

                    <children attribute="0"

                        className="java.lang.Integer" defaultValue=""

                        hidden="0" inputType="java.lang.Integer"

                        listType="0" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                    <children attribute="0" className="java.lang.String"

                        defaultValue="" hidden="0"

                        inputType="java.lang.String" listType="0"

                        name="errorMessage" type="{http://www.w3.org/2001/XMLSchema}string"/>

                </children>

                <children className="" name="ExecuteScript_8" type="">

                    <children className="java.lang.Integer"

                        documentation="the exitCode recieved from executing the command"

                        inputType="java.lang.Integer" name="exitCode" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                    <children className="java.lang.Integer"

                        documentation="the return code recieved from completion of the command"

                        inputType="java.lang.Integer" name="errorCode" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                    <children className="java.lang.String"

                        documentation="the output from the command or error message if it failed"

                        inputType="java.lang.String"

                        name="commandOutput" type="{http://www.w3.org/2001/XMLSchema}string"/>

                </children>

            </outputs>

            <inputs attribute="0" className="" defaultValue=""

                listType="0" name="inputs" required="1" type="">

                <children attribute="0" className="java.lang.String"

                    controlType="0" defaultValue="" documentation=""

                    hidden="0" inputType="java.lang.String" listType="0"

                    name="apssSecurityGroup" readOnly="0" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            </inputs>

        </activitySchema>

        <transition activity="Decision_7" commented="0" originalStyle=""

            points="" sourceX="324" sourceY="240" status="0"

            style="defaultEdge" targetX="216" targetY="297"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1473790026810"

        description="logs an event in the commcell console with the specified severity level"

        displayName="LogEvent" height="19" interactive="0" jobMode="0"

        name="LogEvent" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.LogEventActivity"

        uniqueName="LogEvent_1" waitSetting="0" width="82" x="45" y="445">

        <inputs val="&lt;inputs>&lt;severity class=&quot;workflow.types.SeverityLevel&quot; _list_=&quot;false&quot;>INFO&lt;/severity>&lt;message class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>The [xpath:{/workflow/system/workflow/workflowName}] Workflow has successfully disabled the following subclient from SLA and Stike counts: &amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;Client: [xpath:{/workflow/ExecuteProcessBlock_3/CommServDBQuery_2/resultSets/row/col[2]}] &amp;#xD;&#xd;&#xa;Application: [xpath:{/workflow/ExecuteProcessBlock_3/CommServDBQuery_2/resultSets/row/col[3]}] &amp;#xD;&#xd;&#xa;Instance: [xpath:{/workflow/ExecuteProcessBlock_3/CommServDBQuery_2/resultSets/row/col[4]}]&amp;#xD;&#xd;&#xa;BackupSet: [xpath:{/workflow/ExecuteProcessBlock_3/CommServDBQuery_2/resultSets/row/col[5]}] &amp;#xD;&#xd;&#xa;Subclient: [xpath:{/workflow/ExecuteProcessBlock_3/CommServDBQuery_2/resultSets/row/col[6]}]&lt;/message>&lt;/inputs>"/>

        <transition activity="InformationalMessage_1" commented="0"

            originalStyle="" points="" sourceX="86" sourceY="454"

            status="0" style="defaultEdge" targetX="86" targetY="495"

            transitionIndex="0" x="-126" y="118">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1474053210371"

        description="displays an informational message to the user"

        displayName="InfoMsg" height="22" interactive="0" jobMode="0"

        name="InformationalMessage"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.InteractiveMessageActivity"

        uniqueName="InformationalMessage_1" waitSetting="0" width="100"

        x="36" y="484">

        <inputs val="&lt;inputs>&lt;message>The following subclient was successfully excluded from the SLA and Stike counts: &amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;Client: [xpath:{/workflow/ExecuteProcessBlock_3/CommServDBQuery_2/resultSets/row/col[2]}] &amp;#xD;&#xd;&#xa;Application: [xpath:{/workflow/ExecuteProcessBlock_3/CommServDBQuery_2/resultSets/row/col[3]}] &amp;#xD;&#xd;&#xa;Instance: [xpath:{/workflow/ExecuteProcessBlock_3/CommServDBQuery_2/resultSets/row/col[4]}]&amp;#xD;&#xd;&#xa;BackupSet: [xpath:{/workflow/ExecuteProcessBlock_3/CommServDBQuery_2/resultSets/row/col[5]}] &amp;#xD;&#xd;&#xa;Subclient: [xpath:{/workflow/ExecuteProcessBlock_3/CommServDBQuery_2/resultSets/row/col[6]}]&amp;#xD;&#xd;&#xa;&lt;/message>&lt;dialogType>Popup&lt;/dialogType>&lt;iconType>Information&lt;/iconType>&lt;title>Informational Message&lt;/title>&lt;html>false&lt;/html>&lt;formProperties />&lt;/inputs>"/>

        <activitySchema>

            <outputs className="" defaultValue="" listType="0"

                name="outputs" type="">

                <children attribute="0" className="java.lang.String"

                    defaultValue="" hidden="0"

                    inputType="java.lang.String" listType="0"

                    name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string"/>

            </outputs>

            <inputs className="" defaultValue="" listType="0"

                name="inputs" type=""/>

        </activitySchema>

        <transition activity="WorkflowEnd_4" commented="0"

            originalStyle="" points="" sourceX="86" sourceY="495"

            status="0" style="defaultEdge" targetX="87" targetY="537"

            transitionIndex="0" x="-126" y="118">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1474053305069" description="Ends the workflow"

        displayName="WorkflowEnd" height="20" interactive="0"

        jobMode="0" name="WorkflowEnd"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.EndActivity"

        uniqueName="WorkflowEnd_4" waitSetting="0" width="106" x="34" y="520">

        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;>COMPLETED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1474378887099" description="if/else based decision"

        displayName="Decision" height="100" interactive="0" jobMode="0"

        name="Decision" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_7" waitSetting="0" width="100" x="153" y="275">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/ExecuteProcessBlock_3/CommServDBQuery_2/resultSets/row/col[3]}.equals(&quot;Virtual Server&quot;)&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="Email_3" commented="0"

            displayName="Not VM" originalStyle="" sourceX="285"

            sourceY="325" status="0" style="defaultEdge" targetX="130"

            targetY="358" transitionIndex="0" value="false" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="Email_4" commented="0" displayName="VM"

            originalStyle="" status="0" style="defaultEdge"

            transitionIndex="0" value="True" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1474378989273"

        description="Sends an email to a list of users"

        displayName="Email" height="25" interactive="0" jobMode="0"

        name="Email" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Email"

        uniqueName="Email_4" waitSetting="0" width="75" x="295" y="393">

        <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot; _list_=&quot;false&quot;>&lt;to class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/ExecuteProcessBlock_4/ExecuteScript_8/commandOutput}&lt;/to>&lt;cc class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;bcc class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;from class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;subject class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>A Virtual Machine has been excluded from the SLA and Strike Count Reports CS:[xpath:{/workflow/system/commCellName}]&lt;/subject>&lt;body class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&amp;lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; width=&quot;803&quot;&amp;gt;&#xd;&#xa;      &amp;lt;tr&amp;gt;&#xd;&#xa;        &amp;lt;td&amp;gt;&#xd;&#xa;          &amp;lt;p&amp;gt;&#xd;&#xa;            &amp;lt;img border-right-style=&quot;solid&quot; border-top-width=&quot;0px&quot; src=&quot;https://clu.commvault.com/webconsole/OEM/1/images/banner.png&quot; border-right-width=&quot;0px&quot; border-left-style=&quot;solid&quot; alt=&quot;APSS Health Solutions&quot; border-bottom-width=&quot;0px&quot; border-bottom-style=&quot;solid&quot; id=&quot;_x0000_i1025&quot; border-left-width=&quot;0px&quot; border-top-style=&quot;solid&quot;&amp;gt;&#xd;&#xa;            &#xd;&#xa;          &amp;lt;/p&amp;gt;&#xd;&#xa;        &amp;lt;/td&amp;gt;&#xd;&#xa;      &amp;lt;/tr&amp;gt;&#xd;&#xa;      &amp;lt;tr&amp;gt;&#xd;&#xa;        &amp;lt;td style=&quot;width: 800px&quot;&amp;gt;&#xd;&#xa;          &amp;lt;p&amp;gt;&#xd;&#xa;            &#xd;&#xa;          &amp;lt;/p&amp;gt;&#xd;&#xa;          &amp;lt;p&amp;gt;&#xd;&#xa;            &amp;lt;font face=&quot;Tahoma&quot; size=&quot;3&quot;&amp;gt;Hello &#xd;&#xa;            [xpath:{/workflow/system/executor/userName}], &amp;lt;/font&amp;gt;&#xd;&#xa;          &amp;lt;/p&amp;gt;&#xd;&#xa;          &amp;lt;p&amp;gt;&#xd;&#xa;            &#xd;&#xa;          &amp;lt;/p&amp;gt;&#xd;&#xa;          &amp;lt;p&amp;gt;&#xd;&#xa;            &amp;lt;font face=&quot;Tahoma&quot; size=&quot;3&quot;&amp;gt;The &#xd;&#xa;            [xpath:{/workflow/system/workflow/workflowName}] Workflow has &#xd;&#xa;            successfully excluded the following Virtual Machine from SLA and &#xd;&#xa;            Stike counts:&amp;lt;br&amp;gt;&amp;lt;/font&amp;gt;&#xd;&#xa;          &amp;lt;/p&amp;gt;&#xd;&#xa;          &amp;lt;p&amp;gt;&#xd;&#xa;            &#xd;&#xa;          &amp;lt;/p&amp;gt;&#xd;&#xa;          &amp;lt;p&amp;gt;&#xd;&#xa;            &amp;lt;font face=&quot;Tahoma&quot; size=&quot;3&quot;&amp;gt;Client: &#xd;&#xa;            [xpath:{/workflow/inputs/Client}] &amp;lt;/font&amp;gt;&#xd;&#xa;          &amp;lt;/p&amp;gt;&#xd;&#xa;          &amp;lt;p&amp;gt;&#xd;&#xa;            &#xd;&#xa;          &amp;lt;/p&amp;gt;&#xd;&#xa;          &amp;lt;p&amp;gt;&#xd;&#xa;            &amp;lt;font face=&quot;Tahoma&quot; size=&quot;3&quot;&amp;gt;Thank you, &amp;lt;/font&amp;gt;&#xd;&#xa;          &amp;lt;/p&amp;gt;&#xd;&#xa;          &amp;lt;p&amp;gt;&#xd;&#xa;            &amp;lt;font face=&quot;Tahoma&quot; size=&quot;3&quot;&amp;gt;Commvault Proactive Solutions&amp;lt;/font&amp;gt;&#xd;&#xa;          &amp;lt;/p&amp;gt;&#xd;&#xa;          &amp;lt;p&amp;gt;&#xd;&#xa;            &#xd;&#xa;          &amp;lt;/p&amp;gt;&#xd;&#xa;        &amp;lt;/td&amp;gt;&#xd;&#xa;      &amp;lt;/tr&amp;gt;&#xd;&#xa;    &amp;lt;/table&amp;gt;&#xd;&#xa;    &amp;lt;div style=&quot;clear: both&quot;&amp;gt;&#xd;&#xa;      &#xd;&#xa;    &amp;lt;/div&amp;gt;&#xd;&#xa;    &amp;lt;pre&amp;gt;&amp;lt;/pre&amp;gt;&lt;/body>&lt;attachments class=&quot;java.lang.Object&quot; _list_=&quot;false&quot; />&lt;html class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/html>&lt;replyTo class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;repeatInterval class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;/email>&lt;/inputs>"/>

        <transition activity="LogEvent_2" commented="0" originalStyle=""

            status="0" style="defaultEdge" transitionIndex="0" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1474379094626"

        description="logs an event in the commcell console with the specified severity level"

        displayName="LogEvent" height="19" interactive="0" jobMode="0"

        name="LogEvent" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.LogEventActivity"

        uniqueName="LogEvent_2" waitSetting="0" width="82" x="292" y="446">

        <inputs val="&lt;inputs>&lt;severity class=&quot;workflow.types.SeverityLevel&quot; _list_=&quot;false&quot;>INFO&lt;/severity>&lt;message class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>The [xpath:{/workflow/system/workflow/workflowName}] Workflow has successfully excluded the following Virtual Machine from SLA and Stike counts: &amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;Client: [xpath:{/workflow/inputs/Client}]&lt;/message>&lt;/inputs>"/>

        <transition activity="InformationalMessage_2" commented="0"

            originalStyle="" status="0" style="defaultEdge"

            transitionIndex="0" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1474379094650"

        description="displays an informational message to the user"

        displayName="InfoMsg" height="15" interactive="0" jobMode="0"

        name="InformationalMessage"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.InteractiveMessageActivity"

        uniqueName="InformationalMessage_2" waitSetting="0" width="100"

        x="285" y="486">

        <inputs val="&lt;inputs>&lt;message>The following Virtual Machine was successfully excluded from the SLA and Stike counts: &amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;Client: [xpath:{/workflow/inputs/Client}]&lt;/message>&lt;dialogType>Popup&lt;/dialogType>&lt;iconType>Information&lt;/iconType>&lt;title>Informational Message&lt;/title>&lt;html>false&lt;/html>&lt;formProperties />&lt;/inputs>"/>

        <activitySchema>

            <outputs className="" defaultValue="" listType="0"

                name="outputs" type="">

                <children attribute="0" className="java.lang.String"

                    defaultValue="" hidden="0"

                    inputType="java.lang.String" listType="0"

                    name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string"/>

            </outputs>

            <inputs className="" defaultValue="" listType="0"

                name="inputs" type=""/>

        </activitySchema>

        <transition activity="WorkflowEnd_5" commented="0"

            originalStyle="" status="0" style="defaultEdge"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1474379094717" description="Ends the workflow"

        displayName="WorkflowEnd" height="20" interactive="0"

        jobMode="0" name="WorkflowEnd"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.EndActivity"

        uniqueName="WorkflowEnd_5" waitSetting="0" width="106" x="284" y="522">

        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;>COMPLETED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/inputs>"/>

    </Activity>

    <formProperties css="" javaScript=""/>

</workflow>'

IF not exists (select * from WF_Definition where Name = @name)

BEGIN
	INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision, uniqueGuid)


	VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision, @guid)

	SET @workflowId = @@IDENTITY
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


	VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

	SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = revision From WF_Definition WHERE Name = @name

	-- IF (@currentFlags & 4 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0) AND (@currentRevision <> @revision)

	BEGIN

		SET @version = @version + 1

		UPDATE WF_Definition

		SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision, uniqueGuid = @guid

		WHERE Name = @name

		--IF (@flags & 8 > 0 OR @flags & 16 > 0)

		BEGIN

			UPDATE WF_Definition

			SET flags = @flags

			WHERE Name = @name

		END
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


		VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

	END

END
