

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_AIXSolaris_LinuxMigration.script] ---------- 


SET QUOTED_IDENTIFIER OFF

/*

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/WFD_AIXSolaris_LinuxMigration.script,v $ $Id: WFD_AIXSolaris_LinuxMigration.script,v 1.1.4.3 2020/10/04 00:53:05 abilbrey Exp $";
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

*/

SET QUOTED_IDENTIFIER ON

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.1.4.3 $'

SET @name = 'RDSMigration'

SET @description = 'Work flow to Migrate Oracle Database from Solaris to Linux'

SET @version = 1

SET @flags = 6

SET @definition = '<Workflow apiMode="0" config="&lt;configuration />"

    description="This workflow will be used to migrate Standalone Oracle databases from AIX to Linux or Solaris to Linux"

    inputs="&lt;inputs>&lt;SourceClientName class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>&lt;clientName>&lt;/clientName>&lt;clientId />&lt;/SourceClientName>&lt;TargetClientName class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>&lt;clientName />&lt;clientId />&lt;/TargetClientName>&lt;StagePath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;SourceDBName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;TargetDBName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&amp;lt;DB will be overwritten if it exists&amp;gt;&lt;/TargetDBName>&lt;TargetStagePath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;TargetOraHome class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;TgtSysPasswd class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;TgtCharacterSet class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>AL32UTF8&lt;/TgtCharacterSet>&lt;DuplicateDBName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;DuplicateDBLocation class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&lt;/DuplicateDBLocation>&lt;DuplicateDBPfileLocation class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&lt;/DuplicateDBPfileLocation>&lt;/inputs>"

    interactive="0" isHtmlDescription="0"

    name="AIXSolaris_LinuxMigration" outputs="&lt;outputs />"

    revision="$Revision: 1.1.4.3 $"

    uniqueGuid="71f3f6de-937c-42f1-92fc-5c1d6d87afd1"

    variables="&lt;variables>&lt;srcdistro class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;tgtdistro class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;srcorahome class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;tgtorahome class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;srccvhome class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;tgtcvhome class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/variables>"

    webHidden="0">

    <schema>

        <outputs className="" name="outputs" type=""/>

        <variables attribute="0" className="" name="variables" type="">

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="srcdistro" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="tgtdistro" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="srcorahome" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="tgtorahome" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" hidden="0"

                inputType="java.lang.String" listType="0"

                name="srccvhome" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" hidden="0"

                inputType="java.lang.String" listType="0"

                name="tgtcvhome" type="{http://www.w3.org/2001/XMLSchema}string"/>

        </variables>

        <inputs attribute="0" className="" name="inputs" type="">

            <children alignment="0" attribute="0"

                className="commvault.msgs.CvEntities.ClientEntity"

                controlHidden="0" controlType="2" defaultValue=""

                displayName="Source Client Name"

                documentation="Provide the name of the source database server"

                hidden="0"

                inputType="commvault.msgs.CvEntities.ClientEntity"

                listType="0" maximumValue="" minimumValue=""

                name="SourceClientName" readOnly="0" required="1"

                searchable="0" type="{commvault.msgs.CvEntities}ClientEntity">

                <children attribute="0" className="java.lang.String"

                    defaultValue="" inputType="java.lang.String"

                    listType="0" name="clientName" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children attribute="0" className="java.lang.Integer"

                    defaultValue="" inputType="java.lang.Integer"

                    listType="0" name="clientId" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            </children>

            <children alignment="0" attribute="0"

                className="commvault.msgs.CvEntities.ClientEntity"

                controlHidden="0" controlType="2" defaultValue=""

                displayName="Target Client Name"

                documentation="Client name where database will be migrated to"

                hidden="0"

                inputType="commvault.msgs.CvEntities.ClientEntity"

                listType="0" maximumValue="" minimumValue=""

                name="TargetClientName" readOnly="0" required="1"

                searchable="0" type="{commvault.msgs.CvEntities}ClientEntity">

                <children attribute="0" className="java.lang.String"

                    defaultValue="" inputType="java.lang.String"

                    listType="0" name="clientName" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children attribute="0" className="java.lang.Integer"

                    defaultValue="" inputType="java.lang.Integer"

                    listType="0" name="clientId" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            </children>

            <children alignment="0" attribute="0"

                className="java.lang.String" controlHidden="0"

                controlType="0" defaultValue=""

                displayName="Source Database Name"

                documentation="Oracle instance name for source database"

                hidden="0" inputType="java.lang.String" listType="0"

                maximumValue="" minimumValue="" name="SourceDBName"

                readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children alignment="0" attribute="0"

                className="java.lang.String" controlHidden="0"

                controlType="0" defaultValue=""

                displayName="Duplicate Database Name"

                documentation="Name of the duplicate database name"

                hidden="0" inputType="java.lang.String" listType="0"

                maximumValue="" minimumValue="" name="DuplicateDBName"

                readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children alignment="0" attribute="0"

                className="java.lang.String" controlHidden="0"

                controlType="0" defaultValue=""

                displayName="Duplicate DB datafile location"

                documentation="Location of datafiles for duplicate database"

                hidden="0" inputType="java.lang.String" listType="0"

                maximumValue="" minimumValue=""

                name="DuplicateDBLocation" readOnly="0" required="1"

                searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children alignment="0" attribute="0"

                className="java.lang.String" controlHidden="0"

                controlType="0" defaultValue=""

                displayName="Duplicate DB Pfile"

                documentation="Location of duplicate db pfile"

                hidden="0" inputType="java.lang.String" listType="0"

                maximumValue="" minimumValue=""

                name="DuplicateDBPfileLocation" readOnly="0"

                required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children alignment="0" attribute="0"

                className="java.lang.String" controlHidden="0"

                controlType="0" defaultValue=""

                displayName="Target Database Name"

                documentation="Name of the target database" hidden="0"

                inputType="java.lang.String" listType="0"

                maximumValue="" minimumValue="" name="TargetDBName"

                readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children alignment="0" attribute="0"

                className="java.lang.String" controlHidden="0"

                controlType="0" defaultValue=""

                displayName="Target Oracle Home"

                documentation="Oracle Home location in Target Database"

                hidden="0" inputType="java.lang.String" listType="0"

                maximumValue="" minimumValue="" name="TargetOraHome"

                readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children alignment="0" attribute="0"

                className="java.lang.String" controlHidden="0"

                controlType="0" defaultValue=""

                displayName="Data Stage Path"

                documentation="Provide a path on source where backup files will be stored"

                hidden="0" inputType="java.lang.String" listType="0"

                maximumValue="" minimumValue="" name="StagePath"

                readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children alignment="0" attribute="0"

                className="java.lang.String" controlHidden="0"

                controlType="0" defaultValue=""

                displayName="Target Stage Path"

                documentation="Target Stage Path" hidden="0"

                inputType="java.lang.String" listType="0"

                maximumValue="" minimumValue="" name="TargetStagePath"

                readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children alignment="0" attribute="0"

                className="java.lang.String" controlHidden="0"

                controlType="0" defaultValue=""

                displayName="Target Character set"

                documentation="Character set for Target Database"

                hidden="0" inputType="java.lang.String" listType="0"

                maximumValue="" minimumValue="" name="TgtCharacterSet"

                readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children alignment="0" attribute="0"

                className="java.lang.String" controlHidden="0"

                controlType="0" defaultValue=""

                displayName="Target Sys Password"

                documentation="Sys Password for Target database if it exists"

                hidden="0" inputType="java.lang.String" listType="0"

                maximumValue="" minimumValue="" name="TgtSysPasswd"

                readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

        </inputs>

        <config className="" name="configuration" type=""/>

    </schema>

    <Start commented="0" continueOnFailure="0" created="0"

        description="" displayName="Start" height="36" interactive="0"

        jobMode="0" name="Start" originalStyle="" skipAttempt="0"

        style="image;image=/images/jgraphx/house.png"

        uniqueName="Start_1" waitSetting="0" width="55" x="45" y="41">

        <inputs val="&lt;inputs />"/>

        <transition activity="InputPB1" commented="0" originalStyle=""

            points="" sourceX="72" sourceY="59" status="0"

            style="defaultEdge" targetX="271" targetY="29"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Start>

    <Activity commented="0" continueOnFailure="0"

        created="1492786233114" description="Ends the workflow"

        displayName="WorkflowEnd" height="34" interactive="0"

        jobMode="0" name="WorkflowEnd"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.EndActivity"

        uniqueName="WorkflowEnd_1" waitSetting="0" width="106" x="906" y="184">

        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;>FAILED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>Source and Duplicate Client should be SunOS/AIX and Target Should be Linux&lt;/failureMessage>&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1492786488543"

        description="creates a super process group"

        displayName="Validate Inputs" height="296" interactive="0"

        jobMode="0" name="ProcessBlock"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="InputPB1" waitSetting="0" width="310" x="172" y="15">

        <inputs val="&lt;inputs>&lt;inputs />&lt;/inputs>"/>

        <superProcess>

            <Start commented="0" continueOnFailure="0"

                created="1492786488543" description=""

                displayName="Start" height="30" interactive="0"

                jobMode="0" name="Start" originalStyle=""

                skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_2" waitSetting="0" width="120" x="96" y="27">

                <inputs val="&lt;inputs />"/>

                <transition activity="GetClientDistro_CSDBQ1"

                    commented="0" originalStyle="" points=""

                    sourceX="156" sourceY="42" status="0"

                    style="defaultEdge" targetX="163" targetY="167"

                    transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity commented="0" continueOnFailure="0"

                created="1493128981805"

                description="executes queries against a commcell database"

                displayName="Get Client Distro" height="34"

                interactive="0" jobMode="0" name="CommServDBQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.CommServDBQuery"

                uniqueName="GetClientDistro_CSDBQ1" waitSetting="0"

                width="143" x="80" y="115">

                <inputs val="&lt;inputs>&lt;commCell />&lt;query>DECLARE @srcdistro NVARCHAR(30)&amp;#xD;&#xd;&#xa;DECLARE @tgtdistro NVARCHAR(30)&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;set @srcdistro = (select cp.attrVal from APP_ClientProp cp WITH(NOLOCK)&amp;#xD;&#xd;&#xa;            inner join APP_Client c WITH(NOLOCK)&amp;#xD;&#xd;&#xa;            on cp.componentNameId = c.id&amp;#xD;&#xd;&#xa;            and cp.attrName = ''Sim OS Info''&amp;#xD;&#xd;&#xa;            and c.id = xpath:{/workflow/inputs/SourceClientName/clientId});&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;set @tgtdistro = (select cp.attrVal from APP_ClientProp cp WITH(NOLOCK)&amp;#xD;&#xd;&#xa;            inner join APP_Client c WITH(NOLOCK)&amp;#xD;&#xd;&#xa;            on cp.componentNameId = c.id&amp;#xD;&#xd;&#xa;            and cp.attrName = ''Sim OS Info''&amp;#xD;&#xd;&#xa;            and c.id = xpath:{/workflow/inputs/TargetClientName/clientId});&amp;#xD;&#xd;&#xa;            &amp;#xD;&#xd;&#xa;select @srcdistro as SrcClientDistro&amp;#xD;&#xd;&#xa;  &amp;#xD;&#xd;&#xa;select @tgtdistro as TgtClientDistro&lt;/query>&lt;/inputs>"/>

                <transition activity="SetDistro_SCR1" commented="0"

                    originalStyle="" points="" sourceX="151"

                    sourceY="132" status="0" style="defaultEdge"

                    targetX="153" targetY="223" transitionIndex="0"

                    x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1493130508379"

                description="activity to execute code snippets in the selected language"

                displayName="SetDistro" height="34" interactive="0"

                jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.ScriptActivity"

                uniqueName="SetDistro_SCR1" waitSetting="0" width="100"

                x="103" y="206">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;if (xpath:{/workflow/GetClientDistro_CSDBQ1/resultSets/row/col[@name=&amp;quot;SrcClientDistro&amp;quot;]}.startsWith(&amp;quot;AIX&amp;quot;)) &amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Detected AIX in source machine. Setting variable.&amp;quot;);&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;srcdistro&amp;quot;, &amp;quot;AIX&amp;quot;);&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if (xpath:{/workflow/GetClientDistro_CSDBQ1/resultSets/row/col[@name=&amp;quot;SrcClientDistro&amp;quot;]}.startsWith(&amp;quot;SunOS&amp;quot;)) &amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Detected SunOS in source machine. Setting variable.&amp;quot;);&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;srcdistro&amp;quot;, &amp;quot;SunOS&amp;quot;);&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if (xpath:{/workflow/GetClientDistro_CSDBQ1/resultSets/row/col[@name=&amp;quot;TgtClientDistro&amp;quot;]}.toLowerCase().contains(&amp;quot;linux&amp;quot;)) &amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Detected Linux in target machine. Setting variable.&amp;quot;);&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;tgtdistro&amp;quot;, &amp;quot;Linux&amp;quot;);&amp;#xD;&amp;#xA;}&quot; />&lt;/inputs>"/>

            </Activity>

        </superProcess>

        <activitySchema>

            <outputs className="" defaultValue="" listType="0"

                name="outputs" type=""/>

            <inputs className="" defaultValue="" listType="0"

                name="inputs" type=""/>

        </activitySchema>

        <transition activity="SrcDistro_DEC1" commented="0"

            originalStyle="" points="" sourceX="327" sourceY="163"

            status="0" style="defaultEdge" targetX="692" targetY="95"

            transitionIndex="0" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1493133463715" description="if/else based decision"

        displayName="Is Source OS AIX/SunOS" height="100"

        interactive="0" jobMode="0" name="Decision"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="SrcDistro_DEC1" waitSetting="0" width="168" x="594" y="0">

        <inputs val="&lt;inputs>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/srcdistro}.equals(&quot;SunOS&quot;) || xpath:{/workflow/variables/srcdistro}.equals(&quot;AIX&quot;) &lt;/expression>&lt;/inputs>"/>

        <transition activity="WorkflowEnd_1" commented="0"

            displayName="No" originalStyle="" points="" sourceX="692"

            sourceY="95" status="0" style="defaultEdge" targetX="1345"

            targetY="436" transitionIndex="0" value="false" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="TgtDistro_DEC2" commented="0"

            displayName="Yes" originalStyle="" points="" sourceX="678"

            sourceY="50" status="0" style="defaultEdge" targetX="674"

            targetY="320" transitionIndex="0" value="true" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1493133539759" description="if/else based decision"

        displayName="Is Target OS Linux" height="100" interactive="0"

        jobMode="0" name="Decision"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="TgtDistro_DEC2" waitSetting="0" width="134" x="615" y="220">

        <inputs val="&lt;inputs>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/tgtdistro}.equals(&quot;Linux&quot;)&lt;/expression>&lt;/inputs>"/>

        <transition activity="WorkflowEnd_1" commented="0"

            displayName="No" originalStyle="" points="" sourceX="692"

            sourceY="253" status="0" style="defaultEdge" targetX="1301"

            targetY="453" transitionIndex="0" value="false" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="OracleDuplicateGeneric_1" commented="0"

            displayName="Yes" originalStyle="" sourceX="682"

            sourceY="270" status="0" style="defaultEdge" targetX="683"

            targetY="356" transitionIndex="0" value="true" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1493133577366"

        description="creates a super process group"

        displayName="Export Database" height="497" interactive="0"

        jobMode="0" name="ProcessBlock"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ExportSource_PB1" waitSetting="0" width="413"

        x="462" y="422">

        <inputs val="&lt;inputs>&lt;inputs />&lt;/inputs>"/>

        <superProcess>

            <Start commented="0" continueOnFailure="0"

                created="1493133577366" description=""

                displayName="Start" height="30" interactive="0"

                jobMode="0" name="Start" originalStyle=""

                skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_3" waitSetting="0" width="120" x="53" y="27">

                <inputs val="&lt;inputs />"/>

                <transition activity="GetDetails_CSD2" commented="0"

                    originalStyle="" points="" sourceX="113"

                    sourceY="42" status="0" style="defaultEdge"

                    targetX="119" targetY="105" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity commented="0" continueOnFailure="0"

                created="1494429495949"

                description="Execute a script on a remote machine"

                displayName="Run Export" height="34" interactive="0"

                jobMode="0" name="ExecuteScript"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.ExecuteScript"

                uniqueName="ExecuteScript_1" waitSetting="0" width="110"

                x="255" y="249">

                <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/SourceClientName}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;scriptType class=&quot;commvault.msgs.App.ScriptType&quot; _list_=&quot;false&quot;>UnixShell&lt;/scriptType>&lt;script class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>touch /tmp/migrateOracle.log&amp;#xD;&#xd;&#xa;chmod 777 /tmp/migrateOracle.log&amp;#xD;&#xd;&#xa;touch /tmp/db_users.sql&amp;#xD;&#xd;&#xa;chmod 777 /tmp/db_users.sql&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;chown oracle:oinstall xpath:{/workflow/inputs/StagePath}&amp;#xD;&#xd;&#xa;chmod 777 xpath:{/workflow/inputs/StagePath}&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;rm -f xpath:{/workflow/inputs/StagePath}/*.bck&amp;#xD;&#xd;&#xa;rm -f xpath:{/workflow/inputs/StagePath}/*.txt&amp;#xD;&#xd;&#xa;rm -f xpath:{/workflow/inputs/StagePath}/*.sql&amp;#xD;&#xd;&#xa;rm -f xpath:{/workflow/inputs/StagePath}/*.rcv&amp;#xD;&#xd;&#xa;rm -f xpath:{/workflow/inputs/StagePath}/*.log&amp;#xD;&#xd;&#xa;rm -f xpath:{/workflow/inputs/StagePath}/*.dmp&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;cd xpath:{/workflow/variables/srccvhome}/Base/CvOracleTools&amp;#xD;&#xd;&#xa;sh ./CvOracleTools 2&amp;gt; /dev/null&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;su oracle &amp;lt;&amp;lt;''EOFD''&amp;#xD;&#xd;&#xa;ORACLE_HOME=xpath:{/workflow/variables/srcorahome}&amp;#xD;&#xd;&#xa;export ORACLE_HOME&amp;#xD;&#xd;&#xa;PATH=$PATH:$ORACLE_HOME/bin&amp;#xD;&#xd;&#xa;export PATH&amp;#xD;&#xd;&#xa;LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$ORACLE_HOME/lib&amp;#xD;&#xd;&#xa;export LD_LIBRARY_PATH&amp;#xD;&#xd;&#xa;ORACLE_SID=xpath:{/workflow/inputs/SourceDBName}&amp;#xD;&#xd;&#xa;export ORACLE_SID&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;sqlplus -s /nolog &amp;lt;&amp;lt;EOF&amp;#xD;&#xd;&#xa;connect / as sysdba&amp;#xD;&#xd;&#xa;set echo off&amp;#xD;&#xd;&#xa;set head off&amp;#xD;&#xd;&#xa;set autoprint off&amp;#xD;&#xd;&#xa;set termout off&amp;#xD;&#xd;&#xa;set feedback off&amp;#xD;&#xd;&#xa;set lines 200&amp;#xD;&#xd;&#xa;set pages 2000&amp;#xD;&#xd;&#xa;spool /tmp/db_users.sql&amp;#xD;&#xd;&#xa;select ''alter user ''||username||'' default tablespace ''||default_tablespace||'';'' from dba_users;&amp;#xD;&#xd;&#xa;spool off;&amp;#xD;&#xd;&#xa;exit;&amp;#xD;&#xd;&#xa;EOF&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;cd xpath:{/workflow/variables/srccvhome}/Base/CvOracleTools/dist&amp;#xD;&#xd;&#xa;./migrate -d xpath:{/workflow/inputs/SourceDBName} -em export -l xpath:{/workflow/inputs/StagePath} -m rman_convert -e full&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;cd xpath:{/workflow/inputs/StagePath}&amp;#xD;&#xd;&#xa;for i in $(ls cv_rman_*.bck); do echo &quot;xpath:{/workflow/inputs/TargetStagePath}/${i}&quot; &amp;gt;&amp;gt; filelist.txt; done&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;EOFD&lt;/script>&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

                <transition activity="Decision_1" commented="0"

                    originalStyle="" points="" sourceX="310"

                    sourceY="266" status="0" style="defaultEdge"

                    targetX="159" targetY="292" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1494555808471"

                description="executes queries against a commcell database"

                displayName="Get Details" height="34" interactive="0"

                jobMode="0" name="CommServDBQuery"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.CommServDBQuery"

                uniqueName="GetDetails_CSD2" waitSetting="0" width="143"

                x="39" y="103">

                <inputs val="&lt;inputs>&lt;commCell />&lt;query>DECLARE @srcorahome NVARCHAR(80)&amp;#xD;&#xd;&#xa;DECLARE @srccvhome NVARCHAR(80)&amp;#xD;&#xd;&#xa;DECLARE @tgtcvhome NVARCHAR(80)&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;set @srccvhome = (select cp.attrVal from APP_ClientProp cp&amp;#xD;&#xd;&#xa;    inner join APP_Client c&amp;#xD;&#xd;&#xa;    on c.id = cp.componentNameId&amp;#xD;&#xd;&#xa;    and cp.attrName = ''Patch Local Location''&amp;#xD;&#xd;&#xa;    and c.id = xpath:{/workflow/inputs/SourceClientName/clientId});&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;set @tgtcvhome = (select cp.attrVal from APP_ClientProp cp&amp;#xD;&#xd;&#xa;        inner join APP_Client c&amp;#xD;&#xd;&#xa;        on c.id = cp.componentNameId&amp;#xD;&#xd;&#xa;        and cp.attrName = ''Patch Local Location''&amp;#xD;&#xd;&#xa;        and c.id = xpath:{/workflow/inputs/TargetClientName/clientId});&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;set @srcorahome = (select top 1 ip.attrVal from APP_InstanceProp ip&amp;#xD;&#xd;&#xa;            inner join APP_InstanceName ain&amp;#xD;&#xd;&#xa;            on ain.id = ip.componentNameId&amp;#xD;&#xd;&#xa;            inner join APP_Application a&amp;#xD;&#xd;&#xa;            on a.instance = ain.id&amp;#xD;&#xd;&#xa;            and a.clientId = xpath:{/workflow/inputs/SourceClientName/clientId}&amp;#xD;&#xd;&#xa;            and ip.attrName=''Oracle Home''&amp;#xD;&#xd;&#xa;            and ain.name = ''xpath:{/workflow/inputs/SourceDBName}'');&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;            &amp;#xD;&#xd;&#xa;select @srcorahome as SrcOraHome  &amp;#xD;&#xd;&#xa;select @srccvhome as SrcCvHome&amp;#xD;&#xd;&#xa;select @tgtcvhome as TgtCvHome&lt;/query>&lt;/inputs>"/>

                <transition activity="Script_1" commented="0"

                    originalStyle="" points="" sourceX="110"

                    sourceY="120" status="0" style="defaultEdge"

                    targetX="42" targetY="147" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1494556764279"

                description="activity to execute code snippets in the selected language"

                displayName="Set Variables" height="34" interactive="0"

                jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.ScriptActivity"

                uniqueName="Script_1" waitSetting="0" width="126" x="53" y="174">

                <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;logger.info(&amp;quot;Detected oracle home in source machine as &amp;quot;+xpath:{/workflow/GetDetails_CSD2/resultSets/row/col[@name=&amp;quot;SrcOraHome&amp;quot;]});&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;srcorahome&amp;quot;, xpath:{/workflow/GetDetails_CSD2/resultSets/row/col[@name=&amp;quot;SrcOraHome&amp;quot;]});&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;logger.info(&amp;quot;Detected commvault home in source machine as &amp;quot;+xpath:{/workflow/GetDetails_CSD2/resultSets/row/col[@name=&amp;quot;SrcCvHome&amp;quot;]});&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;srccvhome&amp;quot;, xpath:{/workflow/GetDetails_CSD2/resultSets/row/col[@name=&amp;quot;SrcCvHome&amp;quot;]});&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;logger.info(&amp;quot;Detected commvault home in target machine as &amp;quot;+xpath:{/workflow/GetDetails_CSD2/resultSets/row/col[@name=&amp;quot;TgtCvHome&amp;quot;]});&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;tgtcvhome&amp;quot;, xpath:{/workflow/GetDetails_CSD2/resultSets/row/col[@name=&amp;quot;TgtCvHome&amp;quot;]});&quot; />&lt;/inputs>"/>

                <transition activity="ExecuteScript_6" commented="0"

                    originalStyle="" points="" sourceX="116"

                    sourceY="191" status="0" style="defaultEdge"

                    targetX="271" targetY="188" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1494595720881"

                description="Execute a script on a remote machine"

                displayName="Store User Data" height="34"

                interactive="0" jobMode="0" name="ExecuteScript"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.ExecuteScript"

                uniqueName="ExecuteScript_3" waitSetting="0" width="120"

                x="54" y="342">

                <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/SourceClientName}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;scriptType class=&quot;commvault.msgs.App.ScriptType&quot; _list_=&quot;false&quot;>UnixShell&lt;/scriptType>&lt;script class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>cat /tmp/db_users.sql&lt;/script>&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

                <transition activity="ExecuteScript_4" commented="0"

                    originalStyle="" points="" sourceX="120"

                    sourceY="339" status="0" style="defaultEdge"

                    targetX="113" targetY="399" transitionIndex="0"

                    x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1494595846787"

                description="Execute a script on a remote machine"

                displayName="Place Data in Target" height="34"

                interactive="0" jobMode="0" name="ExecuteScript"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.ExecuteScript"

                uniqueName="ExecuteScript_4" waitSetting="0" width="144"

                x="43" y="442">

                <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/TargetClientName}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;scriptType class=&quot;commvault.msgs.App.ScriptType&quot; _list_=&quot;false&quot;>UnixShell&lt;/scriptType>&lt;script class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>touch /tmp/db_users.sql&amp;#xD;&#xd;&#xa;chmod 777 /tmp/db_users.sql&amp;#xD;&#xd;&#xa;echo &quot;xpath:{/workflow/ExecuteScript_3/commandOutput}&quot; &amp;gt; /tmp/db_users.sql&lt;/script>&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1495997810839"

                description="Execute a script on a remote machine"

                displayName="Pre-Processing" height="34" interactive="0"

                jobMode="0" name="ExecuteScript"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.ExecuteScript"

                uniqueName="ExecuteScript_6" waitSetting="0" width="127"

                x="250" y="174">

                <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/TargetClientName}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;scriptType class=&quot;commvault.msgs.App.ScriptType&quot; _list_=&quot;false&quot;>UnixShell&lt;/scriptType>&lt;script class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>su oracle &amp;lt;&amp;lt;''EOFD''&amp;#xD;&#xd;&#xa;ORACLE_HOME=xpath:{/workflow/inputs/TargetOraHome}&amp;#xD;&#xd;&#xa;export ORACLE_HOME&amp;#xD;&#xd;&#xa;PATH=$PATH:$ORACLE_HOME/bin&amp;#xD;&#xd;&#xa;export PATH&amp;#xD;&#xd;&#xa;LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$ORACLE_HOME/lib&amp;#xD;&#xd;&#xa;export LD_LIBRARY_PATH&amp;#xD;&#xd;&#xa;ORACLE_SID=xpath:{/workflow/inputs/TargetDBName}&amp;#xD;&#xd;&#xa;export ORACLE_SID&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;if ps -ef | grep pmon | grep xpath:{/workflow/inputs/TargetDBName}; then&amp;#xD;&#xd;&#xa;&#x9;dbca -silent -deleteDatabase -sourceDB xpath:{/workflow/inputs/TargetDBName} -sysDBAUserName sys -sysDBAPassword xpath:{/workflow/inputs/TgtSysPasswd}&amp;#xD;&#xd;&#xa;&#x9;if [ &quot;$?&quot; -ne &quot;0&quot; ]; then&amp;#xD;&#xd;&#xa;&#x9;&#x9;if grep xpath:{/workflow/inputs/TargetDBName} /etc/oratab; then&amp;#xD;&#xd;&#xa;sqlplus -s /nolog &amp;lt;&amp;lt;EOF&amp;#xD;&#xd;&#xa;connect / as sysdba&amp;#xD;&#xd;&#xa;set echo off&amp;#xD;&#xd;&#xa;set head off&amp;#xD;&#xd;&#xa;set autoprint off&amp;#xD;&#xd;&#xa;set termout off&amp;#xD;&#xd;&#xa;set feedback off&amp;#xD;&#xd;&#xa;set lines 200&amp;#xD;&#xd;&#xa;set pages 2000&amp;#xD;&#xd;&#xa;shut abort;&amp;#xD;&#xd;&#xa;exit;&amp;#xD;&#xd;&#xa;EOF&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;sed -i -- ''s/^xpath:{/workflow/inputs/TargetDBName}/#xpath:{/workflow/inputs/TargetDBName}/g'' /etc/oratab&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&#x9;&#x9;fi&amp;#xD;&#xd;&#xa;&#x9;fi&amp;#xD;&#xd;&#xa;fi&amp;#xD;&#xd;&#xa;EOFD&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;rm -f xpath:{/workflow/inputs/TargetStagePath}/*.txt&amp;#xD;&#xd;&#xa;rm -f xpath:{/workflow/inputs/TargetStagePath}/*.sql&amp;#xD;&#xd;&#xa;rm -f xpath:{/workflow/inputs/TargetStagePath}/*.rcv&amp;#xD;&#xd;&#xa;rm -f xpath:{/workflow/inputs/TargetStagePath}/*.log&amp;#xD;&#xd;&#xa;rm -f xpath:{/workflow/inputs/TargetStagePath}/*.dmp&lt;/script>&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

                <transition activity="ExecuteScript_1" commented="0"

                    originalStyle="" points="" sourceX="311"

                    sourceY="194" status="0" style="defaultEdge"

                    targetX="155" targetY="260" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1496929737093"

                description="if/else based decision"

                displayName="Is Export Successful" height="100"

                interactive="0" jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_1"

                waitSetting="0" width="147" x="237" y="309">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/ExecuteScript_1/exitCode}==0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="ExecuteScript_3" commented="0"

                    displayName="Yes" originalStyle="" points=""

                    sourceX="115" sourceY="267" status="0"

                    style="defaultEdge" targetX="107" targetY="375"

                    transitionIndex="0" value="true" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="WorkflowEnd_3" commented="0"

                    displayName="No" originalStyle="" points=""

                    sourceX="310" sourceY="359" status="0"

                    style="defaultEdge" targetX="311" targetY="462"

                    transitionIndex="0" value="false" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1496929919207" description="Ends the workflow"

                displayName="WorkflowEnd" height="34" interactive="0"

                jobMode="0" name="WorkflowEnd"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.EndActivity"

                uniqueName="WorkflowEnd_3" waitSetting="0" width="106"

                x="258" y="445">

                <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;>FAILED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>Errors detected at export phase&lt;/failureMessage>&lt;/inputs>"/>

            </Activity>

        </superProcess>

        <activitySchema>

            <outputs className="" defaultValue="" listType="0"

                name="outputs" type=""/>

            <inputs className="" defaultValue="" listType="0"

                name="inputs" type=""/>

        </activitySchema>

        <transition activity="ProcessBlock_2" commented="0"

            originalStyle="" points="" sourceX="644" sourceY="653"

            status="0" style="defaultEdge" targetX="885" targetY="306"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1493134767051"

        description="creates a super process group"

        displayName="Import Database" height="342" interactive="0"

        jobMode="0" name="ProcessBlock"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ProcessBlock_1" waitSetting="0" width="227" x="1320" y="499">

        <inputs val="&lt;inputs>&lt;inputs />&lt;/inputs>"/>

        <superProcess>

            <Start commented="0" continueOnFailure="0"

                created="1493134767051" description=""

                displayName="Start" height="30" interactive="0"

                jobMode="0" name="Start" originalStyle=""

                skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_4" waitSetting="0" width="120" x="59" y="33">

                <inputs val="&lt;inputs />"/>

                <transition activity="ExecuteScript_2" commented="0"

                    originalStyle="" points="" sourceX="146"

                    sourceY="45" status="0" style="defaultEdge"

                    targetX="153" targetY="154" transitionIndex="0"

                    x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity commented="0" continueOnFailure="0"

                created="1494594820684"

                description="Execute a script on a remote machine"

                displayName="Run Import" height="34" interactive="0"

                jobMode="0" name="ExecuteScript"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.ExecuteScript"

                uniqueName="ExecuteScript_2" waitSetting="0" width="110"

                x="73" y="132">

                <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/TargetClientName}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;scriptType class=&quot;commvault.msgs.App.ScriptType&quot; _list_=&quot;false&quot;>UnixShell&lt;/scriptType>&lt;script class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>touch /tmp/migrateOracle.log&amp;#xD;&#xd;&#xa;chmod 777 /tmp/migrateOracle.log&amp;#xD;&#xd;&#xa;touch /tmp/db_users.log&amp;#xD;&#xd;&#xa;chmod 777 /tmp/db_users.log&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;cd xpath:{/workflow/variables/tgtcvhome}/Base/CvOracleTools&amp;#xD;&#xd;&#xa;sh ./CvOracleTools 2&amp;gt; /dev/null&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;su oracle &amp;lt;&amp;lt;''EOFD''&amp;#xD;&#xd;&#xa;ORACLE_HOME=xpath:{/workflow/inputs/TargetOraHome}&amp;#xD;&#xd;&#xa;export ORACLE_HOME&amp;#xD;&#xd;&#xa;PATH=$PATH:$ORACLE_HOME/bin&amp;#xD;&#xd;&#xa;export PATH&amp;#xD;&#xd;&#xa;LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$ORACLE_HOME/lib&amp;#xD;&#xd;&#xa;export LD_LIBRARY_PATH&amp;#xD;&#xd;&#xa;ORACLE_SID=xpath:{/workflow/inputs/TargetDBName}&amp;#xD;&#xd;&#xa;export ORACLE_SID&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;cd xpath:{/workflow/variables/tgtcvhome}/Base/CvOracleTools/dist&amp;#xD;&#xd;&#xa;./migrate -d xpath:{/workflow/inputs/TargetDBName} -em import -l xpath:{/workflow/inputs/TargetStagePath} -fl xpath:{/workflow/inputs/TargetStagePath}/filelist.txt -m rman_convert -e full&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;sqlplus -s /nolog &amp;lt;&amp;lt;EOF&amp;#xD;&#xd;&#xa;connect / as sysdba&amp;#xD;&#xd;&#xa;set echo on&amp;#xD;&#xd;&#xa;set head off&amp;#xD;&#xd;&#xa;set autoprint off&amp;#xD;&#xd;&#xa;set termout off&amp;#xD;&#xd;&#xa;set lines 200&amp;#xD;&#xd;&#xa;set pages 2000&amp;#xD;&#xd;&#xa;spool /tmp/db_users.log&amp;#xD;&#xd;&#xa;@/tmp/db_users.sql&amp;#xD;&#xd;&#xa;spool off;&amp;#xD;&#xd;&#xa;exit;&amp;#xD;&#xd;&#xa;EOF&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;EOFD&lt;/script>&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

                <transition activity="ExecuteScript_7" commented="0"

                    originalStyle="" points="" sourceX="153"

                    sourceY="154" status="0" style="defaultEdge"

                    targetX="158" targetY="209" transitionIndex="0"

                    x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1496756489669"

                description="Execute a script on a remote machine"

                displayName="Validate Objects" height="34"

                interactive="0" jobMode="0" name="ExecuteScript"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.ExecuteScript"

                uniqueName="ExecuteScript_7" waitSetting="0" width="123"

                x="66" y="205">

                <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/TargetClientName}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;scriptType class=&quot;commvault.msgs.App.ScriptType&quot; _list_=&quot;false&quot;>UnixShell&lt;/scriptType>&lt;script class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>su oracle &amp;lt;&amp;lt;''EOFD''&amp;#xD;&#xd;&#xa;ORACLE_HOME=xpath:{/workflow/inputs/TargetOraHome}&amp;#xD;&#xd;&#xa;export ORACLE_HOME&amp;#xD;&#xd;&#xa;PATH=$PATH:$ORACLE_HOME/bin&amp;#xD;&#xd;&#xa;export PATH&amp;#xD;&#xd;&#xa;LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$ORACLE_HOME/lib&amp;#xD;&#xd;&#xa;export LD_LIBRARY_PATH&amp;#xD;&#xd;&#xa;ORACLE_SID=xpath:{/workflow/inputs/TargetDBName}&amp;#xD;&#xd;&#xa;export ORACLE_SID&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;sqlplus -s /nolog &amp;lt;&amp;lt;EOF&amp;#xD;&#xd;&#xa;connect / as sysdba&amp;#xD;&#xd;&#xa;set echo off&amp;#xD;&#xd;&#xa;set head off&amp;#xD;&#xd;&#xa;set autoprint off&amp;#xD;&#xd;&#xa;set termout off&amp;#xD;&#xd;&#xa;set feedback off&amp;#xD;&#xd;&#xa;set lines 200&amp;#xD;&#xd;&#xa;set pages 2000&amp;#xD;&#xd;&#xa;@?/rdbms/admin/utlrp.sql&amp;#xD;&#xd;&#xa;exit;&amp;#xD;&#xd;&#xa;EOF&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;EOFD&lt;/script>&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

            </Activity>

        </superProcess>

        <activitySchema>

            <outputs className="" defaultValue="" listType="0"

                name="outputs" type=""/>

            <inputs className="" defaultValue="" listType="0"

                name="inputs" type=""/>

        </activitySchema>

        <transition activity="WorkflowEnd_2" commented="0"

            originalStyle="" points="" sourceX="1063" sourceY="539"

            status="0" style="defaultEdge" targetX="1412" targetY="469"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1494422236967" description="Ends the workflow"

        displayName="WorkflowEnd" height="34" interactive="0"

        jobMode="0" name="WorkflowEnd"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.EndActivity"

        uniqueName="WorkflowEnd_2" waitSetting="0" width="106" x="1391" y="889">

        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;>COMPLETED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1495920151524"

        description="creates a super process group"

        displayName="Prepare Target Environment" height="473"

        interactive="0" jobMode="0" name="ProcessBlock"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ProcessBlock_2" waitSetting="0" width="341" x="952" y="434">

        <inputs val="&lt;inputs>&lt;inputs />&lt;/inputs>"/>

        <superProcess>

            <Start commented="0" continueOnFailure="0"

                created="1495920151524" description=""

                displayName="Start" height="30" interactive="0"

                jobMode="0" name="Start" originalStyle=""

                skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_5" waitSetting="0" width="120" x="56" y="28">

                <inputs val="&lt;inputs />"/>

                <transition activity="ExecuteScript_5" commented="0"

                    originalStyle="" points="" sourceX="109"

                    sourceY="44" status="0" style="defaultEdge"

                    targetX="115" targetY="188" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity commented="0" continueOnFailure="0"

                created="1495920225118"

                description="Execute a script on a remote machine"

                displayName="Create Target Database" height="34"

                interactive="0" jobMode="0" name="ExecuteScript"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.ExecuteScript"

                uniqueName="ExecuteScript_5" waitSetting="0" width="165"

                x="33" y="171">

                <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/TargetClientName}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;scriptType class=&quot;commvault.msgs.App.ScriptType&quot; _list_=&quot;false&quot;>UnixShell&lt;/scriptType>&lt;script class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>chown -R oracle:oinstall xpath:{/workflow/inputs/TargetStagePath}&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;su oracle &amp;lt;&amp;lt;''EOFD''&amp;#xD;&#xd;&#xa;ORACLE_HOME=xpath:{/workflow/inputs/TargetOraHome}&amp;#xD;&#xd;&#xa;export ORACLE_HOME&amp;#xD;&#xd;&#xa;PATH=$PATH:$ORACLE_HOME/bin&amp;#xD;&#xd;&#xa;export PATH&amp;#xD;&#xd;&#xa;LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$ORACLE_HOME/lib&amp;#xD;&#xd;&#xa;export LD_LIBRARY_PATH&amp;#xD;&#xd;&#xa;ORACLE_SID=xpath:{/workflow/inputs/TargetDBName}&amp;#xD;&#xd;&#xa;export ORACLE_SID&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;cp ${ORACLE_HOME}/assistants/dbca/dbca.rsp .&amp;#xD;&#xd;&#xa;sed -i -- ''s/^GDBNAME.*/GDBNAME = &quot;xpath:{/workflow/inputs/TargetDBName}&quot;/g'' dbca.rsp&amp;#xD;&#xd;&#xa;sed -i -- ''s/^SID.*/SID = &quot;xpath:{/workflow/inputs/TargetDBName}&quot;/g'' dbca.rsp&amp;#xD;&#xd;&#xa;sed -i -- ''s/^#CHARACTERSET.*/CHARACTERSET = &quot;xpath:{/workflow/inputs/TgtCharacterSet}&quot;/g'' dbca.rsp&amp;#xD;&#xd;&#xa;sed -i -- ''s/^#NATIONALCHARACTERSET.*/NATIONALCHARACTERSET= &quot;AL16UTF16&quot;/g'' dbca.rsp&amp;#xD;&#xd;&#xa;sed -i -- ''s/^#SYSTEMPASSWORD.*/SYSTEMPASSWORD = &quot;sys&quot;/g'' dbca.rsp&amp;#xD;&#xd;&#xa;sed -i -- ''s/^#SYSPASSWORD.*/SYSPASSWORD = &quot;sys&quot;/g'' dbca.rsp&amp;#xD;&#xd;&#xa;sed -i -- ''s/^#INITPARAMS.*/INITPARAMS = db_files=1024/g'' dbca.rsp&amp;#xD;&#xd;&#xa;sed -i -- ''s/^#TOTALMEMORY.*/TOTALMEMORY = &quot;800&quot;/g'' dbca.rsp&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;dbca -silent -responseFile ./dbca.rsp&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;EOFD&lt;/script>&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

                <transition activity="Decision_2" commented="0"

                    originalStyle="" points="" sourceX="115"

                    sourceY="188" status="0" style="defaultEdge"

                    targetX="91" targetY="302" transitionIndex="0" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1496929994442"

                description="if/else based decision"

                displayName="Is DB creation successful" height="100"

                interactive="0" jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_2"

                waitSetting="0" width="175" x="4" y="252">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/ExecuteScript_5/exitCode}==0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="WorkflowEnd_4" commented="0"

                    displayName="No" originalStyle="" points=""

                    sourceX="91" sourceY="302" status="0"

                    style="defaultEdge" targetX="90" targetY="433"

                    transitionIndex="0" value="false" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="ExecuteScript_8" commented="0"

                    displayName="Yes" originalStyle="" points=""

                    sourceX="91" sourceY="302" status="0"

                    style="defaultEdge" targetX="274" targetY="301"

                    transitionIndex="0" value="true" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1496930041619" description="Ends the workflow"

                displayName="WorkflowEnd" height="34" interactive="0"

                jobMode="0" name="WorkflowEnd"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.EndActivity"

                uniqueName="WorkflowEnd_4" waitSetting="0" width="106"

                x="37" y="416">

                <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;>FAILED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>Errors creating target database&lt;/failureMessage>&lt;/inputs>"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1496930119956"

                description="Execute a script on a remote machine"

                displayName="Rename USERS" height="34" interactive="0"

                jobMode="0" name="ExecuteScript"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.ExecuteScript"

                uniqueName="ExecuteScript_8" waitSetting="0" width="119"

                x="215" y="284">

                <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/TargetClientName}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;scriptType class=&quot;commvault.msgs.App.ScriptType&quot; _list_=&quot;false&quot;>UnixShell&lt;/scriptType>&lt;script class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>su oracle &amp;lt;&amp;lt;''EOFD''&amp;#xD;&#xd;&#xa;ORACLE_HOME=xpath:{/workflow/inputs/TargetOraHome}&amp;#xD;&#xd;&#xa;export ORACLE_HOME&amp;#xD;&#xd;&#xa;PATH=$PATH:$ORACLE_HOME/bin&amp;#xD;&#xd;&#xa;export PATH&amp;#xD;&#xd;&#xa;LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$ORACLE_HOME/lib&amp;#xD;&#xd;&#xa;export LD_LIBRARY_PATH&amp;#xD;&#xd;&#xa;ORACLE_SID=xpath:{/workflow/inputs/TargetDBName}&amp;#xD;&#xd;&#xa;export ORACLE_SID&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;sqlplus -s /nolog &amp;lt;&amp;lt;EOF&amp;#xD;&#xd;&#xa;connect / as sysdba&amp;#xD;&#xd;&#xa;set echo off&amp;#xD;&#xd;&#xa;set head off&amp;#xD;&#xd;&#xa;set autoprint off&amp;#xD;&#xd;&#xa;set termout off&amp;#xD;&#xd;&#xa;set feedback off&amp;#xD;&#xd;&#xa;set lines 200&amp;#xD;&#xd;&#xa;set pages 2000&amp;#xD;&#xd;&#xa;alter tablespace users rename to users_old;&amp;#xD;&#xd;&#xa;shut immediate;&amp;#xD;&#xd;&#xa;startup mount;&amp;#xD;&#xd;&#xa;alter database archivelog;&amp;#xD;&#xd;&#xa;alter database open;&amp;#xD;&#xd;&#xa;exit;&amp;#xD;&#xd;&#xa;EOF&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;EOFD&lt;/script>&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

            </Activity>

        </superProcess>

        <activitySchema>

            <outputs className="" defaultValue="" listType="0"

                name="outputs" type=""/>

            <inputs className="" defaultValue="" listType="0"

                name="inputs" type=""/>

        </activitySchema>

        <transition activity="ProcessBlock_1" commented="0"

            originalStyle="" points="" sourceX="1007" sourceY="576"

            status="0" style="defaultEdge" targetX="1203" targetY="356"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1498832134036"

        description="A generic workflow to take minimum parameters to run the duplicate database command"

        displayName="OracleDuplicateGeneric" height="34" interactive="0"

        jobMode="0" name="OracleDuplicateGeneric"

        namespaceUri="commvault.workflow.activities" originalStyle=""

        skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.ExecuteWorkflow"

        uniqueName="OracleDuplicateGeneric_1" waitSetting="0"

        width="165" x="599" y="354">

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/SourceClientName/clientName}&lt;/client>&lt;destClient class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/SourceClientName/clientName}&lt;/destClient>&lt;instance class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/SourceDBName}&lt;/instance>&lt;noCatalog class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/noCatalog>&lt;restoreStreams class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>5&lt;/restoreStreams>&lt;duplicateToName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/DuplicateDBName}&lt;/duplicateToName>&lt;duplicateDataPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/DuplicateDBLocation}&lt;/duplicateDataPath>&lt;duplicateToPFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/DuplicateDBPfileLocation}&lt;/duplicateToPFile>&lt;redirectTempFiles class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/DuplicateDBLocation}&lt;/redirectTempFiles>&lt;duplicateToLogFile class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/duplicateToLogFile>&lt;latestSCN class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>&lt;/latestSCN>&lt;email class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&lt;/email>&lt;/inputs>"/>

        <transition activity="ExportSource_PB1" commented="0"

            originalStyle="" sourceX="681" sourceY="371" status="0"

            style="defaultEdge" targetX="681" targetY="423"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <formProperties css="" javaScript=""/>

</Workflow>'

IF not exists (select * from WF_Definition where Name = @name)

BEGIN
    INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision)


    VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision)

    SET @workflowId = @@IDENTITY
    INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


    VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

    SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = ISNULL(revision, '') From WF_Definition WHERE Name = @name

    IF (@currentFlags & 4 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0) AND (@currentRevision <> @revision)

    BEGIN

        SET @version = @version + 1

        UPDATE WF_Definition

        SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision

        WHERE Name = @name

        IF (@flags & 8 > 0 OR @flags & 16 > 0)

        BEGIN

            UPDATE WF_Definition

            SET flags = @flags

            WHERE Name = @name

        END
        INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


        VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

    END

END

