

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/UpgradeRDSInstances.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

------------------------------------------------------------------------

-- rcsid[]='@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/UpgradeRDSInstances.script

SET NOCOUNT ON

DECLARE @isUpgradeRDSInstance INT = 0

DECLARE @uniqueScriptID uniqueidentifier = '69F0BB1F-964A-4331-BF38-8EE73DE9C0ED'

SELECT @isUpgradeRDSInstance = 1 FROM GXUniqueSQLScriptExecTracking WITH(NOLOCK) WHERE SqlScriptGUID = @uniqueScriptID

DECLARE @nowTime  INTEGER =  DATEDIFF(second, '01/01/1970', GETUTCDATE())

DECLARE @DateTimeArg datetime

SET @DateTimeArg = getUTCdate()

IF @isUpgradeRDSInstance = 0

BEGIN

	BEGIN TRANSACTION UpgradeRDSInstanceTran

	BEGIN TRY

		DECLARE @clientName VARCHAR(1024) = ''

		DECLARE @arrayName VARCHAR(1024) = ''

		DECLARE @clientId INT = 0

		DECLARE @rdsInstanceId INT = 0

		DECLARE @vsaInstanceId INT = 0

		DECLARE @controlHostId INT = 0

		DECLARE @newControlHostId INT = 0

		DECLARE @adminInstanceId INT = 0

		DECLARE @vsMemberServers NVARCHAR(MAX) = ''

		DECLARE @encryptedAccessKey NVARCHAR(MAX) = ''

		DECLARE @decryptedAccessKey NVARCHAR(MAX) = ''

		DECLARE Instance_Cursor CURSOR LOCAL FAST_FORWARD FOR

			SELECT DISTINCT CL.name, CL.id, Prop.componentNameId, vsaApp.instance

			FROM APP_InstanceProp Prop INNER JOIN APP_Application APP ON Prop.componentNameId = APP.instance 

				INNER JOIN APP_Application vsaApp ON vsaApp.clientId = app.clientId AND vsaApp.appTypeId = 106

				INNER JOIN APP_Client CL ON CL.id = vsaApp.clientId

			WHERE Prop.attrName = 'Cloud Apps Instance Type' AND Prop.attrVal = '4' /* AMAZON_RDS */ AND Prop.modified = 0

		OPEN Instance_Cursor

		FETCH NEXT FROM Instance_Cursor INTO @clientName, @clientId, @rdsInstanceId, @vsaInstanceId

		WHILE (@@FETCH_STATUS = 0)

		BEGIN

			SET @adminInstanceId = 0

			SET @controlHostId = 0

			SET @vsMemberServers = ''

			SET @controlHostId = ISNULL( (SELECT CAST(attrVal AS INT) FROM APP_ClientProp WHERE componentNameId = @clientId AND attrName = 'Snap Control Host ID' AND modified = 0), 0)

			DELETE APP_InstanceProp

			WHERE attrName IN ('Array ID','Virtual Server Host','Vs Member Servers','Secret Key','Access Key') AND componentNameId = @rdsInstanceId

			-- If VSA agent using admin instance, then use admin instance's member servers.

			IF EXISTS(SELECT 1 FROM APP_InstanceProp WHERE attrName = 'Amazon Enable Admin Account' AND attrVal = '1')

			BEGIN

				SET @adminInstanceId = ISNULL( (SELECT CAST(attrVal AS INT)		

												FROM APP_InstanceProp 

												WHERE componentNameId = @vsaInstanceId 

												AND attrName = 'Amazon Admin Instance Id' 

												AND modified = 0), 0

											)

				IF @adminInstanceId > 0

				BEGIN

					SET @vsMemberServers = ISNULL((SELECT attrVal 

													FROM APP_InstanceProp 

													WHERE componentNameId = @adminInstanceId 

													AND attrName = 'Vs Member Servers' 

													AND modified = 0), ''

												)

				END

			END
			INSERT INTO APP_ClientProp


			SELECT @clientId, A.attrName, A.attrType, CASE WHEN A.attrName = 'Vs Member Servers' AND LEN(@vsMemberServers) > 0 THEN @vsMemberServers ELSE A.attrVal END, A.created, A.modified, A.ccpId

			FROM APP_InstanceProp A

			WHERE A.attrName IN ('Amazon Center Access Key', 'Amazon Center Secret Key', 'Vs Member Servers', 'Virtual Server Host') 

				AND A.componentNameId = @vsaInstanceId 

				AND A.modified = 0

				AND NOT EXISTS (SELECT 1 FROM APP_ClientProp B WHERE A.attrName = B.attrName AND B.componentNameId = @clientId AND B.modified = 0)
			INSERT INTO APP_InstanceProp


			SELECT @rdsInstanceId, A.attrName, A.attrType, CASE WHEN A.attrName = 'Vs Member Servers' AND LEN(@vsMemberServers) > 0 THEN @vsMemberServers ELSE A.attrVal END, A.created, A.modified, A.ccpId

			FROM APP_InstanceProp A

			WHERE A.attrName IN ('Amazon Center Access Key', 'Amazon Center Secret Key', 'Vs Member Servers', 'Virtual Server Host') 

				AND A.componentNameId = @vsaInstanceId 

				AND A.modified = 0

				AND NOT EXISTS (SELECT 1 FROM APP_InstanceProp B WHERE A.attrName = B.attrName AND B.componentNameId = @rdsInstanceId  AND B.modified = 0)

			IF @controlHostId > 0

			BEGIN

				SET @arrayName = 'aws-RDS-'+ @clientName + '-' + CAST(@clientId AS VARCHAR(128))		-- << "aws-" << serviceName << "-" << clientName.c_str() << "-" << clientId;

				-- Create new array.
				INSERT INTO SMControlHost


				SELECT	SnapShotEngineId, SnapVendorName, @arrayName, SMHostIP, SMHostName, SMHostPortNumber, SMHostUserName, SMHostPassword, SMHostFlags, SMHostStatus, SMHostDescription, 

						SnapShotEngineName, DeviceGroupName, SMHostOption, SourceId, OrigCCId, NEWID(), ReserveField1, ReserveField2, ReserveFieldStr, ClientId, SoftState, IsEnabled, IsActive, 

						BrokenCode, ReasonCode, Flags, AdminConsole, Properties, ReserveField3, ReserveField4, GroupingId, UniqueIdentifier, @DateTimeArg, @DateTimeArg, CredentialId						

				FROM SMControlHost

				WHERE ControlHostId = @controlHostId

				SET @newControlHostId =  SCOPE_IDENTITY()
				INSERT INTO SMHostAlias


				SELECT RefType, @newControlHostId, Status, Flags, @arrayName, @DateTimeArg, OrigCCId, NEWID(), ReserveField1, ReserveField2 ,ReserveField3, ReserveField4, ReserveFieldStr

				FROM SMHostAlias

				WHERE RefType = 5 AND RefId = @controlHostId

				-- Set array access nodes.
				INSERT INTO SMArrayController


				SELECT @newControlHostId, MMHostId, AssocId, AssocType, Options, Flag

				FROM SMArrayController WHERE ArrayNum = @controlHostId

				-- Set the newly created array for RDS instance.
				INSERT INTO APP_InstanceProp


				SELECT @rdsInstanceId, 'Array ID', 10, @newControlHostId, @nowTime, 0, 0

				-- Move snaps from old array to newly created array.

				UPDATE SMSnap

				SET ControlHostId = @newControlHostId

				FROM SMSnap S INNER JOIN SMVolSnapMap M ON S.SMSnapId = M.SMSnapId

					INNER JOIN SMVolume V ON M.SMVolumeId = V.SMVolumeId

					INNER JOIN APP_Application APP ON V.AppId = APP.id

				WHERE APP.instance = @rdsInstanceId AND S.ControlHostId = @controlHostId

			END

			-- Decrypt the access key.

			SET @encryptedAccessKey = ISNULL((SELECT attrVal FROM APP_InstanceProp WHERE componentNameId = @rdsInstanceId AND attrName = 'Amazon Center Access Key' AND modified = 0), '')

			IF LEN(@encryptedAccessKey) > 0

			BEGIN

				EXEC miscProc2 @encryptedAccessKey, @decryptedAccessKey OUTPUT

				UPDATE APP_InstanceProp

				SET attrVal = @decryptedAccessKey

				WHERE componentNameId = @rdsInstanceId AND attrName = 'Amazon Center Access Key' AND modified = 0

				-- Since same accessKey is set for the client, so we can use the same decryptedAccessKey.

				UPDATE APP_ClientProp

				SET attrVal = @decryptedAccessKey

				WHERE componentNameId = @clientId AND attrName = 'Amazon Center Access Key' AND modified = 0

			END

		FETCH NEXT FROM Instance_Cursor INTO @clientName, @clientId, @rdsInstanceId, @vsaInstanceId

		END

		CLOSE Instance_Cursor

		DEALLOCATE Instance_Cursor
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@uniqueScriptID, 'UpgradeRDSInstances','Sets RDS instance properties.', @nowTime, 16, 0, (16 + 1))

		COMMIT TRANSACTION UpgradeRDSInstanceTran

	END TRY

	BEGIN CATCH

		PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

		ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

		ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

		ERROR MESSAGE: ' + ERROR_MESSAGE() + '

		ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

		ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		PRINT 'Rolling back transaction'

		ROLLBACK TRANSACTION UpgradeRDSInstanceTran

	END CATCH   	

END

SET NOCOUNT OFF

