

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/UpgradeRDSContent.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

------------------------------------------------------------------------

-- rcsid[]='@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/UpgradeRDSContent.script

GO

SET QUOTED_IDENTIFIER ON

GO

SET NOCOUNT ON

DECLARE @isUpgradeRDSContent INT = 0

DECLARE @uniqueScriptID uniqueidentifier = '10582D4C-1180-4D9C-A6A6-59DE40384316'

SELECT @isUpgradeRDSContent = 1 FROM GXUniqueSQLScriptExecTracking WITH(NOLOCK) WHERE SqlScriptGUID = @uniqueScriptID

DECLARE @nowTime  INTEGER =  DATEDIFF(second, '01/01/1970', GETUTCDATE())

IF @isUpgradeRDSContent = 0

BEGIN    

    BEGIN TRY

		BEGIN TRANSACTION UpgradeRDSContentTran

		IF OBJECT_ID('tempdb..#Subclients') IS NOT NULL

		DROP TABLE #Subclients

		CREATE TABLE #Subclients (

		scId          INT PRIMARY KEY,

		dynContent    TINYINT,

		autoUpd       TINYINT

		)
		INSERT INTO #Subclients (scId, dynContent, autoUpd)


		SELECT 

		  APP.id,

		  CASE

				 WHEN dscp.id IS NULL THEN 0

				 ELSE 1

		  END,

		  CASE

				 WHEN ascp.id IS NULL THEN 0

				 ELSE 1

		  END

		FROM APP_InstanceProp Prop 

		  INNER JOIN APP_Application APP ON 

				 Prop.componentNameId = APP.instance

		  LEFT OUTER JOIN APP_SubClientProp dscp ON

				 dscp.componentNameId = APP.id

				 AND dscp.attrName = N'Cloud DB Dynamic Content' 

				 AND dscp.cs_attrName = CHECKSUM(N'Cloud DB Dynamic Content')

				 AND dscp.modified = 0

		  LEFT OUTER JOIN APP_SubClientProp ascp ON

				 ascp.componentNameId = APP.id

				 AND ascp.attrName = N'Auto update instance list' AND ascp.attrVal = '1'

				 AND ascp.cs_attrName = CHECKSUM(N'Auto update instance list')

				 AND ascp.modified = 0

		WHERE 

		  Prop.attrName = N'Cloud Apps Instance Type' 

		  AND Prop.attrVal = '4' /* AMAZON_RDS */ 

		  AND Prop.modified = 0
		INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)


		SELECT s.scId, 'Cloud DB Dynamic Content', 1,

				(CASE

						 WHEN s.dynContent = 0 AND s.autoUpd = 0 THEN (

							   ISNULL((

									  SELECT 

											 1          AS allOrAnyChildren, 

											 dbName 	AS displayName, 

											 dbName 	AS name, 

											 0        	AS negation, 

											 (SELECT B.RegionCode FROM App_CloudVendorRegion B WHERE B.Id = A.regionId) AS path,

											 50         AS type

									  FROM App_RDSSubclientContentMap A

									  WHERE A.modified = 0 AND A.subclientId = s.scid

									  FOR XML RAW ('children'), ROOT ('App_CloudDBEntity')

								), '')

						 )

						 WHEN s.dynContent = 0 AND s.autoUpd = 1 THEN (

							   SELECT '<App_CloudDBEntity><children type="17"/></App_CloudDBEntity>' 

						 )					 

					END				  

				)  

				, @nowTime, 0, 0

		FROM #Subclients s

		WHERE (s.dynContent = 0 AND s.autoUpd = 0 ) OR (s.dynContent = 0 AND s.autoUpd = 1 )
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@uniqueScriptID, 'UpgradeRDSContent','RDS content conversion for existing clients to new format.', @nowTime, 16, 0, (16 + 1))

		COMMIT TRANSACTION UpgradeRDSContentTran

    END TRY

    BEGIN CATCH

        PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

        ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

        ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

        ERROR MESSAGE: ' + ERROR_MESSAGE() + '

        ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

        ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

        PRINT 'Rolling back transaction'

        ROLLBACK TRANSACTION UpgradeRDSContentTran

    END CATCH       

END

SET NOCOUNT OFF

GO

SET QUOTED_IDENTIFIER ON

GO

