

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/UpgradeCloudDBClient.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

------------------------------------------------------------------------

-- rcsid[]='@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/UpgradeCloudDBClient.script

SET NOCOUNT ON

DECLARE @isUpgradeCloudClient INT = 0

DECLARE @uniqueScriptID uniqueidentifier = '4E87E4A7-F77A-4C1D-8D76-DC76D61912C9'

SELECT @isUpgradeCloudClient = 1 FROM GXUniqueSQLScriptExecTracking WITH(NOLOCK) WHERE SqlScriptGUID = @uniqueScriptID

DECLARE @nowTime  INTEGER =  DATEDIFF(second, '01/01/1970', GETUTCDATE())

IF @isUpgradeCloudClient = 0

BEGIN

	BEGIN TRY

		BEGIN TRANSACTION UpgradeCloudDBClientTran

			CREATE TABLE #PsuedoClients_List_To_Upgrade

			(

				clientId INT,

				cloudInstanceType INT

			)
			INSERT INTO #PsuedoClients_List_To_Upgrade


				 SELECT  DISTINCT CL.id , IP.attrVal

						FROM    APP_Client CL INNER JOIN APP_IDAName IDA      ON (IDA.clientId = CL.id) 

											  INNER JOIN APP_Application APP  ON (APP.clientId = CL.id AND App.appTypeId = IDA.appTypeId)

											  INNER JOIN APP_InstanceProp IP  ON (IP.componentNameId = APP.instance AND IP.attrName = 'Virtual Server Instance Type' AND IP.modified = 0 AND IP.attrVal IN ( '301' , '402' , '1301' , '1401' , '403' ))  -- Select only Amazon - 301 , Azure - 402 , Google - 1301 , Alibaba - 1401 , Azure Stack - 403 clients

						WHERE   (IDA.appTypeId = 106)

								AND((CL.status  & 4)  = 0)

								AND((IDA.status & 4)  = 0)
				INSERT INTO APP_ClientProp( componentNameId , attrName , attrType , attrVal , created , modified , ccpId )


					SELECT clientId , 'Client App Type' , 7 , 1 , @nowTime , 0 , 0 

						FROM #PsuedoClients_List_To_Upgrade

						WHERE NOT EXISTS ( SELECT 1 FROM APP_ClientProp WHERE componentNameId = clientId AND attrName = 'Client App Type'and modified = 0 )
				INSERT INTO APP_ClientProp( componentNameId , attrName , attrType , attrVal , created , modified , ccpId )


					SELECT clientId , 'Cloud Hypervisor Type' , 7 , cloudInstanceType , @nowTime , 0 , 0 

						FROM #PsuedoClients_List_To_Upgrade

						WHERE NOT EXISTS ( SELECT 1 FROM APP_ClientProp WHERE componentNameId = clientId AND attrName = 'Cloud Hypervisor Type' and modified = 0 )
				INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@uniqueScriptID, 'UpgradeCloudDBClient','Sets Cloud DB client properties.', @nowTime, 16, 0, (16 + 1))

			COMMIT TRANSACTION UpgradeCloudDBClientTran

	END TRY

	BEGIN CATCH

		PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

		ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

		ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

		ERROR MESSAGE: ' + ERROR_MESSAGE() + '

		ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

		ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		PRINT 'Rolling back transaction'

		ROLLBACK TRANSACTION UpgradeCloudDBClientTran

	END CATCH   	

	if object_id('tempdb.dbo.#PsuedoClients_List_To_Upgrade') is not null DROP TABLE #PsuedoClients_List_To_Upgrade   	

END

SET NOCOUNT OFF

