

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/UpgradeBlobStorageCredentials.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

/*

Credential upgrade script:

Get the list of instances which are not using credential id already.

Collect the instance names, vendor types, user name, password, record types

Convert the passwords for S3 and Blob (pswEncryptionManaged)

Create the credential with name instance-vendor-inst-credential. Build credential request and run AppAddCMCredentials.

Get the credential id and create a credential association to the instance.

*/

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WITH(NOLOCK) WHERE SqlScriptGUID = 'DE596853-70A9-403F-8855-2C4D4A68EF68')

BEGIN

	DECLARE @ErrorCode INT = 0

	DECLARE @ErrorMsg NVARCHAR(MAX)

	DECLARE @timeNow INT

	SET @timeNow = DATEDIFF(ss, '1970-01-01', GETUTCDATE())

	BEGIN TRANSACTION

	BEGIN TRY

		DECLARE @cloudInstanceList TABLE (InstanceId INT, InstanceName NVARCHAR(1024), userName NVARCHAR(1024), passwd NVARCHAR(1024), vendorType INT, recordType INT)
		INSERT INTO @cloudInstanceList (InstanceId, instanceName, vendorType, recordType)


		SELECT	DISTINCT I.id, I.name, IP.attrVal,

			CASE IP.attrVal

				WHEN '5' THEN 102 -- CredentialType_AMAZON_S3

				WHEN '6' THEN 103 -- CredentialType_MICROSOFT_AZURE

				WHEN '20' THEN 119 -- CredentialType_GOOGLE_CLOUD

				WHEN '21' THEN 103 -- CredentialType_MICROSOFT_AZURE

				WHEN '24' THEN 130 -- CredentialType_IBM_CLOUD

				WHEN '25' THEN 123 -- CredentialType_ALICLOUD_OSS

			END

		FROM	APP_InstanceName I

			INNER JOIN APP_Application A

ON I.id = A.instance AND A.appTypeId = 134

			INNER JOIN APP_InstanceProp IP

				ON I.id = IP.componentNameId AND IP.attrName = 'Cloud Apps Instance Type' AND IP.modified = 0 AND IP.attrVal IN ('5', '6', '20', '21', '24','25')

			LEFT OUTER JOIN APP_InstanceProp IP2

				ON I.id = IP2.componentNameId AND IP2.attrName = 'Cloud Credential ID' AND IP2.modified = 0

		WHERE	IP2.attrVal IS NULL

		--Update username

		UPDATE	TC

		SET		TC.userName = IP.attrVal

		FROM	@cloudInstanceList TC

			INNER JOIN APP_InstanceProp IP

				ON TC.InstanceId = IP.componentNameId AND IP.modified = 0

			AND ((IP.attrName = 'Amazon S3 Access Key Id' AND TC.vendorType = 5) --CloudAppsInstanceType_AMAZON_S3

				OR (IP.attrName = 'Azure Account Name' AND TC.vendorType = 6) --CloudAppsInstanceType_AZURE_BLOB

				OR (IP.attrName = 'Google Cloud Cloud User' AND TC.vendorType = 20) --CloudAppsInstanceType_GOOGLE_CLOUD

				OR (IP.attrName = 'Azure DL Cloud User' AND TC.vendorType = 21) --CloudAppsInstanceType_AZURE_DATA_LAKE

				OR (IP.attrName = 'IBM COS Cloud User' AND TC.vendorType = 24) --CloudAppsInstanceType_IBM_COS

				OR (IP.attrName = 'Ali OSS Cloud User' AND TC.vendorType = 25)) --CloudAppsInstanceType_ALIBABA_OSS

		--Update password

		UPDATE	TC

		SET		TC.passwd = CASE WHEN TC.vendorType IN (5, 6) THEN IP.attrVal ELSE dbo.base64Encode(IP.attrVal) END --For Amazon and Azure password will be encrypted in the next block and then encoded.

		FROM	@cloudInstanceList TC

			INNER JOIN APP_InstanceProp IP

				ON TC.InstanceId = IP.componentNameId AND IP.modified = 0

			AND ((IP.attrName = 'Amazon S3 Secret Access Key' AND TC.vendorType = 5) --CloudAppsInstanceType_AMAZON_S3

				OR (IP.attrName = 'Azure Access Key' AND TC.vendorType = 6) --CloudAppsInstanceType_AZURE_BLOB

				OR (IP.attrName = 'Google Cloud Cloud Password' AND TC.vendorType = 20) --CloudAppsInstanceType_GOOGLE_CLOUD

				OR (IP.attrName = 'Azure DL Cloud Password' AND TC.vendorType = 21) --CloudAppsInstanceType_AZURE_DATA_LAKE

				OR (IP.attrName = 'IBM COS Cloud Password' AND TC.vendorType = 24) --CloudAppsInstanceType_IBM_COS

				OR (IP.attrName = 'Ali OSS Cloud Password' AND TC.vendorType = 25)) --CloudAppsInstanceType_ALIBABA_OSS

		-- Encrypt password for Amazon S3 and Azure Blob

		DECLARE @instid INT

		DECLARE @plainP NVARCHAR(1024)

		DECLARE @encP NVARCHAR(1024)

		DECLARE ENCRCURSOR CURSOR FOR

		SELECT InstanceId, passwd FROM @cloudInstanceList WHERE vendorType IN (5, 6) --CloudAppsInstanceType_AMAZON_S3, CloudAppsInstanceType_AZURE_BLOB

		OPEN ENCRCURSOR

		FETCH NEXT FROM ENCRCURSOR INTO @instId, @plainP

		WHILE @@FETCH_STATUS = 0

		BEGIN

			SET @encP = N''

			EXEC pswEncryptionManaged @plainP, @encP OUTPUT

			UPDATE	@cloudInstanceList

			SET		passwd = dbo.base64Encode(@encP)

			WHERE	InstanceID = @instid

			FETCH NEXT FROM ENCRCURSOR INTO @instId, @plainP

		END 

		CLOSE ENCRCURSOR

		DEALLOCATE ENCRCURSOR

		-- Now we have the details we need. Build the request and create credential

		DECLARE @xmlReq XML

		DECLARE @instanceId INT

		DECLARE @instanceName NVARCHAR(1024)

		DECLARE @userName NVARCHAR(1024)

		DECLARE @passwd NVARCHAR(1024)

		DECLARE @vendorType INT

		DECLARE @recordType INT

		DECLARE @credName NVARCHAR(1024)

		DECLARE @credId INT

		DECLARE @credAssocTbl TABLE (credAssocId INT)

		DECLARE @creatCredTbl TABLE (outXML XML)

		DECLARE @credAssocId INT

		DECLARE credCursor CURSOR FOR

		SELECT	InstanceId, InstanceName, userName, passwd, vendorType, recordType FROM @cloudInstanceList

		OPEN credCursor

		FETCH NEXT FROM credCursor INTO @instanceId, @instanceName, @userName, @passwd, @vendorType, @recordType

		WHILE @@FETCH_STATUS = 0

		BEGIN

			SET @credName = @instanceName + '-' + CAST(@vendorType AS NVARCHAR(8)) + '-' + CAST(@instanceId AS NVARCHAR(8)) + '-Credential'

			SET @credId = 0

			SET @xmlReq = 

			(

				SELECT	1 as 'processinginstructioninfo/user/@userId',

						0 as 'processinginstructioninfo/locale/@localeId',

						'Automatically created by System' as 'credentialRecordInfo/@description',

						@recordType as 'credentialRecordInfo/@recordType',

						174 as 'credentialRecordInfo/credentialRecord/@_type_',

						@credName as 'credentialRecordInfo/credentialRecord/@credentialName',

						@passwd as 'credentialRecordInfo/record/@password',

						@userName as 'credentialRecordInfo/record/@userName',

						1 as 'credentialRecordInfo/securityAssociations/@associationsOperationType',

						13 as 'credentialRecordInfo/createAs/user/user/@_type_',

						1 as 'credentialRecordInfo/createAs/user/user/@userId'

				FOR XML PATH('App_AddCredentialRecordReq')

			)

			EXEC AppAddCMCredentials @xmlReq, 1

			SELECT @credId = credentialId FROM APP_Credentials WHERE credentialName = @credName

			IF (ISNULL(@credId, 0) = 0)

			BEGIN

				SET @ErrorMsg = 'Failed to create credential for ' + @credName + '. InstanceId ' + CAST(@instanceId AS NVARCHAR(8))

				SET @ErrorCode = 2

				GOTO END_PROC

			END

			--Created credential. Now create a credential association and add the association id to instance properties

			DELETE @credAssocTbl
			INSERT INTO @credAssocTbl


EXEC AppUpdateCredentialAssocForEntity @instanceId, 5, @credId

			SELECT @credAssocId = credAssocId FROM @credAssocTbl

			IF (@credAssocId = -1)

			BEGIN

				SET @ErrorMsg = 'Failed to create credential association for instance Id ' + CAST(@instanceId AS NVARCHAR(8))

				SET @ErrorCode = 3

				GOTO END_PROC

			END
			INSERT INTO APP_InstanceProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpid)


			VALUES (@instanceId, 'Cloud Credential ID', 7, @credAssocId, @timeNow, 0, 0)

			FETCH NEXT FROM credCursor INTO @instanceId, @instanceName, @userName, @passwd, @vendorType, @recordType

		END 

		CLOSE credCursor

		DEALLOCATE credCursor

	END TRY

	BEGIN CATCH

		SET @ErrorMsg = 'Failed to upgrade the cloud credentials to Credential IDs. Error: ' + ERROR_MESSAGE()

		SET @ErrorCode = 1

	END CATCH

	END_PROC:

	IF @ErrorCode = 0

		COMMIT TRANSACTION

	ELSE

	BEGIN

		ROLLBACK TRANSACTION

		RAISERROR(@ErrorMsg, 16, 1)

	END
INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('DE596853-70A9-403F-8855-2C4D4A68EF68', 'UpgradeBlobStorageCredentials', 'Upgrade cloud blob credentials to Credential ID', @timeNow, 16, 0, (16 + 1))

END

