

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/UpgradeAzureVSAInstance.script] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON

DECLARE @needUpgradeAzureVSAInstance INT = 0

DECLARE @uniqueScriptID uniqueidentifier = '3B11D031-6409-41BB-B823-D36AFC4F0716'

SELECT @needUpgradeAzureVSAInstance = 1 FROM GXUniqueSQLScriptExecTracking WITH (READUNCOMMITTED) WHERE SqlScriptGUID = @uniqueScriptID

DECLARE @clientName VARCHAR(1024) = ''

DECLARE @clientId INT = 0

DECLARE @instanceId INT = 0

DECLARE @subscriptionId VARCHAR(1024) = ''

DECLARE @tenantId VARCHAR(1024) = ''

DECLARE @appId VARCHAR(1024) = ''

DECLARE @appPassword VARCHAR(1024) = ''

DECLARE @arrayName VARCHAR(1024) = '' 

DECLARE @controlHostId INT = 0 

DECLARE @nowTime  INTEGER =  DATEDIFF(second, '01/01/1970', GETUTCDATE())

DECLARE @arrayDetails XML

IF @needUpgradeAzureVSAInstance = 0

BEGIN

	DECLARE Instance_Cursor CURSOR LOCAL FAST_FORWARD FOR

		SELECT  DISTINCT A.clientId, C.name, A.instance

			FROM    APP_Application A WITH (READUNCOMMITTED)

					INNER JOIN APP_Client C WITH (READUNCOMMITTED)

						ON A.clientId = C.id

					INNER JOIN APP_InstanceProp IP WITH (READUNCOMMITTED)

						ON A.instance = IP.componentNameId AND IP.attrName = 'Virtual Server Instance Type' AND IP.attrVal = 402 /* APP_VIRTSERV_AZURE_V2 */ AND IP.modified = 0

					LEFT OUTER JOIN APP_ClientProp CP WITH (READUNCOMMITTED)

						ON CP.componentNameId = C.id AND CP.attrName = 'Snap Control Host ID' AND IP.modified = 0

			WHERE   A.appTypeId = 106

				AND CP.attrVal IS NULL

	OPEN Instance_Cursor

	FETCH NEXT FROM Instance_Cursor INTO @clientId, @clientName, @instanceId

	BEGIN TRANSACTION UpgradeAzureVSAInstanceTran

    BEGIN TRY

	WHILE (@@FETCH_STATUS = 0)

		BEGIN

			SET @arrayName = 'AzureRM-VSA-' + CONVERT(varchar(12), @clientId) + '-' + @clientName

			SET @subscriptionId = (SELECT attrVal FROM APP_InstanceProp WITH (READUNCOMMITTED) WHERE componentNameId = @instanceId AND attrName = 'Azure Subscription Id' /* CV_VIRTSERVER_AZURE_SUBSCRIPTION_ID */)

			SET @tenantId = (SELECT attrVal FROM APP_InstanceProp WITH (READUNCOMMITTED) WHERE componentNameId = @instanceId AND attrName = 'Azure Tenant Id' /* CV_VIRTSERVER_AZURE_TENANT_ID  */)

			SET @appId = (SELECT attrVal FROM APP_InstanceProp WITH (READUNCOMMITTED) WHERE componentNameId = @instanceId AND attrName = 'Virtual Server User' /* CV_VIRTSERVER_USERNAME */)

			SET @appPassword = (SELECT attrVal FROM APP_InstanceProp WITH (READUNCOMMITTED) WHERE componentNameId = @instanceId AND attrName = 'Virtual Server Password' /* CV_VIRTSERVER_PASSWORD */)

			SET @arrayDetails = (SELECT 

									'1' AS '@add',

									@clientId AS '@clientId',

									(SELECT

										@subscriptionId AS '@ctrlHostName',

										(SELECT

36 AS '@id',

'Microsoft Azure' AS '@name'

										FOR XML PATH('vendor'), TYPE),

										(SELECT

											@arrayName AS '@name'

										FOR XML PATH('arrayName'), TYPE),

										(SELECT

											@appId AS '@userName',

											@appPassword AS '@password'

										FOR XML PATH('userPswd'), TYPE)

									FOR XML PATH ('info'), TYPE),

									(SELECT

										(SELECT

											'1' AS '@isEnabled',

256 AS '@masterConfigId',

8	AS '@type',

											@tenantId AS '@value',

											(SELECT

'Tenant ID' AS '@name'

											FOR XML PATH ('name'), TYPE)

										FOR XML PATH ('configList'), TYPE)

									FOR XML PATH ('configs'), TYPE)

								FOR XML PATH ('EVGui_MMSMSetArrayDetailsReq'), TYPE)

			EXEC MM_SMXMLSetArrayDetails @arrayDetails

			SET @controlHostId = (SELECT ControlHostId FROM SMControlHost WITH (READUNCOMMITTED) WHERE SMArrayId = @arrayName)
			INSERT INTO APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified) 


				VALUES (@clientId, 'Snap Control Host ID' /*CV_PROP_VIRTUAL_SERVER_SNAP_CONTROL_HOST*/, 7, CONVERT(varchar(12), @controlHostId), @nowTIme, 0)

			FETCH NEXT FROM Instance_Cursor INTO @clientId, @clientName, @instanceId	  

		END

		CLOSE Instance_Cursor

		DEALLOCATE Instance_Cursor
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@uniqueScriptID, 'UpgradeAzureVSAInstance','Create and associate SMControlHost entry for Azure VSA instances without any association.', @nowTime, 16, 0, (16 + 1))

        COMMIT TRANSACTION UpgradeAzureVSAInstanceTran

	END TRY

    BEGIN CATCH

        PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

        ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

        ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

        ERROR MESSAGE: ' + ERROR_MESSAGE() + '

        ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

        ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

        PRINT 'Rolling back transaction'

        ROLLBACK TRANSACTION UpgradeAzureVSAInstanceTran

    END CATCH 

END
