

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/UpgradeAzureClients.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

------------------------------------------------------------------------

-- rcsid[]='@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/UpgradeAzureClients.script

GO

SET QUOTED_IDENTIFIER ON

GO

SET NOCOUNT ON

DECLARE @isUpgradeAzureClients INT = 0

DECLARE @uniqueScriptID UNIQUEIDENTIFIER = 'FC3A5DCF-0C06-4B2F-A8F8-EB7F14E8D22A'

SELECT @isUpgradeAzureClients = 1 FROM GXUniqueSQLScriptExecTracking WITH(NOLOCK) WHERE SqlScriptGUID = @uniqueScriptID

DECLARE @nowTime  INTEGER =  DATEDIFF(second, '01/01/1970', GETUTCDATE())

IF @isUpgradeAzureClients = 0

BEGIN

	BEGIN TRANSACTION UpgradeAzureClientsTran

	BEGIN TRY

		IF OBJECT_ID('tempdb.dbo.#olderAzureClients') IS NOT NULL

			DROP TABLE #olderAzureClients

		CREATE TABLE #olderAzureClients(name NVARCHAR(MAX), clientId BIGINT, vsInstanceId INT, vsMemberServers XML)
		INSERT INTO #olderAzureClients(name, clientId, vsInstanceId)


		SELECT DISTINCT cl.name AS name, cl.id AS clientId, ins.componentNameId AS vsInstanceId from APP_InstanceProp ins   

		INNER JOIN APP_Application app WITH (NOLOCK) ON app.instance = ins.componentNameId

		INNER JOIN APP_Client cl WITH (NOLOCK) ON app.clientId = cl.id 

LEFT JOIN APP_ClientProp prop WITH (NOLOCK) ON prop.componentNameId = cl.id and prop.attrName IN ('Cloud Apps Credentials', 'Vs Member Servers')

		WHERE ins.attrName = 'Virtual Server Instance Type' AND ins.attrVal = '402' AND ins.modified = 0 AND  prop.attrVal IS NULL

		IF OBJECT_ID('tempdb.dbo.#credsTable') IS NOT NULL

			DROP TABLE #credsTable

		CREATE TABLE #credsTable(clientId BIGINT, ccpId INT, credsXml XML)
		INSERT INTO #credsTable(credsXml, clientId, ccpId)


		SELECT (SELECT [Virtual Server Host] as '@serverName', [Azure Subscription Id] as '@subscriptionId', [Azure Tenant Id] as '@tenantId',

			(

				SELECT [Virtual Server User] as '@userName', [Virtual Server Password] as '@password' FOR XML PATH('credentials'), TYPE

			) FOR XML PATH('App_AzureResourceManager')) as credsXml, clientId, ccpId

		FROM (

			SELECT attrName, attrVal, componentNameId, cl.clientId, prop.ccpId from APP_InstanceProp prop

			INNER JOIN #olderAzureClients cl ON prop.componentNameId = cl.vsInstanceId 

			WHERE attrName IN ('Virtual Server Host', 'Virtual Server User', 'Virtual Server Password', 'Azure Subscription Id', 'Azure Tenant Id') 

			AND modified = 0

		) t

		PIVOT (MAX(attrVal) FOR attrName IN ([Virtual Server Host], [Virtual Server User], [Virtual Server Password], [Azure Subscription Id], [Azure Tenant Id], [Vs Member Servers])) as p

		UPDATE clients

		SET vsMemberServers = CAST(attrVal AS xml).query('App_MemberServers')

		FROM #olderAzureClients clients

INNER JOIN APP_InstanceProp ins WITH (NOLOCK) ON ins.componentNameId = clients.vsInstanceId AND attrName = 'Vs Member Servers' AND modified = 0

		PRINT('Inserting credentials xml to client')
		INSERT INTO APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)


SELECT clients.clientId AS componentNameId, 'Cloud Apps Credentials' AS attrName, 1 AS attrType, CAST(creds.credsXml AS NVARCHAR(MAX)) AS attrVal, @nowTime AS created, 0 AS modified, creds.ccpId FROM #olderAzureClients clients

		INNER JOIN #credsTable creds ON creds.clientId = clients.clientId

		PRINT('Inserting member servers xml to client')
		INSERT INTO APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)


SELECT clients.clientId AS componentNameId, 'Vs Member Servers' AS attrName, 1 AS attrType, CAST(vsMemberServers AS NVARCHAR(MAX)) AS attrVal, @nowTime AS created, 0 AS modified, creds.ccpId FROM #olderAzureClients clients

		INNER JOIN #credsTable creds ON creds.clientId = clients.clientId
		INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES (@uniqueScriptID, 'UpgradeAzureClients','Sets Azure cloud properties.', @nowTime, 16, 0, (16 + 1))

		IF OBJECT_ID('tempdb.dbo.#olderAzureClients') IS NOT NULL

			DROP TABLE #olderAzureClients

		IF OBJECT_ID('tempdb.dbo.#credsTable') IS NOT NULL

			DROP TABLE #credsTable

		COMMIT TRANSACTION UpgradeAzureClientsTran 

	END TRY

	BEGIN CATCH

		PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

        ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

        ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

        ERROR MESSAGE: ' + ERROR_MESSAGE() + '

        ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

        ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

        PRINT 'Rolling back transaction'

		ROLLBACK TRANSACTION UpgradeAzureClientsTran

	END CATCH

END

SET NOCOUNT OFF

GO

SET QUOTED_IDENTIFIER ON

GO

