

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/UpdateTimezoneInEntities.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- ALLOW_COMMENTS_BELOW_HERE:

 -- ----------------------------------------------------------------------

 --                                                                      

 --           Copyright (c) 1998  CommVault Systems, Inc.                

 --                  All rights reserved.                                

 --                                                                      

 --                                                                   

 --        This is unpublished proprietary source code of CommVault  

 --        Systems, Inc. The copyright notice above does not evidence 

 --        any actual or intended publication of such source code. 

 -- ----------------------------------------------------------------------*/

 -- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/UpdateTimezoneInEntities.script,v $ $Id: UpdateTimezoneInEntities.script,v 1.1.4.2 2020/12/16 19:57:54 mnatarajan Exp $";

 SET QUOTED_IDENTIFIER ON

-- Run this script once for Linux CS. 

IF (dbo.IsOSOnCSWindows()=1)

BEGIN

	RETURN

END

DECLARE @guid uniqueidentifier = '93C8BD02-B488-4197-87D6-F478AF2CD911'

DECLARE @curUtcDateTime BIGINT = datediff(second, '01/01/1970', GetUTCdate())       

DECLARE @globalParamExec INT = 0

SELECT @globalParamExec = 1

FROM

    GXUniqueSQLScriptExecTracking gp WITH(NOLOCK)

WHERE

    gp.SqlScriptGUID = @guid

IF (@globalParamExec = 0)        -- not done, update it for linux

BEGIN	

BEGIN TRY

       BEGIN TRAN

	IF object_id('tempdb.dbo.#schedTimezoneTemp') is not null

    		DROP TABLE #schedTimezoneTemp

	CREATE TABLE #schedTimezoneTemp

	(

		TimeZoneID				integer		,

		TimeZoneName			nvarchar(510),

TimeZoneStdName			varchar(255)	,

WindowsTimeZoneStdName	varchar(255),

		WindowsTzId				INT,

		DSTFlag					INT,

		Bias					INT

	)

	CREATE CLUSTERED INDEX schedTimezoneTemp_WindowsTzId_idx ON #schedTimezoneTemp (WindowsTzId)

	IF object_id('tempdb.dbo.#ClientsScInNeedOfTzUpdate') is not null

    		DROP TABLE #ClientsScInNeedOfTzUpdate

	CREATE TABLE #ClientsScInNeedOfTzUpdate

	(

		ID				INTEGER,

		entityId		INTEGER,

		attrName		NVARCHAR(2048),

		attrVal		    NVARCHAR(2048),

		TimeZoneID		INT

	)	

	CREATE CLUSTERED INDEX ClientsScInNeedOfTzUpdate_entityId_idx ON #ClientsScInNeedOfTzUpdate (entityId)

	-- Enter unix timezones with mapped windows timezones (one unix TZ for each windows TZ)
	INSERT INTO #schedTimezoneTemp


	SELECT  SchedTimezone.TimezoneId, TimezoneName, TimeZoneStdName, WindowsTimeZoneStdName, 

		(

			SELECT TOP 1 WindowsTZ.TimezoneID FROM SchedTimezone WindowsTZ 

			WHERE WindowsTZ.TimezoneStdName = SchedTimeZone.WindowsTimeZoneStdName

			AND (WindowsTZ.flags&1)>0 -- windows timezones have flag 1 set. 

			AND WindowsTZ.WindowsTimeZoneStdName = SchedTimeZone.WindowsTimeZoneStdName

		) WindowsTzId, DSTFlag, Bias/60*-1 

	FROM SchedTimeZone (NOLOCK)

	INNER JOIN 

	(

		-- For each windows timezone, find corresponding unix timezone. 

		SELECT MAX(TimeZoneID) TimeZoneID

		FROM SchedTimeZone(NOLOCK) UnixTZ  

		WHERE (UnixTZ.flags&1) = 0 AND UnixTZ.WindowsTimeZoneStdName IS NOT NULL AND LEN(UnixTZ.WindowsTimeZoneStdName)>0

		GROUP By UnixTZ.WindowsTimeZoneStdName

	) T 

	ON T.TimezoneId = SchedTimezone.TimezoneId

	-- Add windows timezones not in above list which are not mapped to any unix TZ
	INSERT INTO #schedTimezoneTemp


	SELECT  0, '', '',WindowsTZ.TimezoneStdName,WindowsTZ.TimezoneId,0,0

	FROM SchedTimezone WindowsTZ 

	LEFT JOIN #schedTimezoneTemp ON #schedTimezoneTemp.WindowsTzId = WindowsTZ.TimezoneId

	WHERE #schedTimezoneTemp.WindowsTzId IS NULL 

	AND WindowsTZ.TimezoneStdName = WindowsTZ.WindowsTimeZoneStdName

	AND (WindowsTZ.flags&1)>0 -- windows timezones have flag 1 set. 	

	-- Set modified as current time for client properties related to timezone. 
	INSERT INTO #ClientsScInNeedOfTzUpdate(ID, entityId , attrName , attrVal, TimeZoneID)	


	SELECT Id, componentNameId,attrName,attrVal,

		(SELECT TOP 1 schedTimezoneTemp.timezoneId FROM #schedTimezoneTemp schedTimezoneTemp

		WHERE APP_ClientProp.attrVal = CAST(schedTimezoneTemp.WindowsTzId AS NVARCHAR(10)) )

	FROM APP_ClientProp WITH(NOLOCK)

	WHERE attrName IN ('Commcell timezone Id','timezone Id') AND modified = 0 		

	AND attrVal IN 	

	(

		SELECT CAST(schedTimezoneTemp.WindowsTzId AS NVARCHAR(10)) FROM #schedTimezoneTemp schedTimezoneTemp

	)

	UPDATE App_ClientProp	

	SET modified = @curUtcDateTime

	FROM App_ClientProp INNER JOIN 

	(

		SELECT Id FROM #ClientsScInNeedOfTzUpdate		

		UNION ALL

		--Reset timezone attribute also for clients whose timezone needs to be updated. 

		SELECT App_ClientProp.ID FROM App_ClientProp(NOLOCK)

		INNER JOIN #ClientsScInNeedOfTzUpdate ON App_ClientProp.componentnameId = #ClientsScInNeedOfTzUpdate.entityId

		AND App_ClientProp.attrName = 'Timezone'

		AND App_ClientProp.modified = 0		

	) T

	ON T.Id = App_ClientProp.Id	
	INSERT INTO APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)


	SELECT entityId, attrName, 8, CAST(TimezoneID AS NVARCHAR(10)), @curUtcDateTime, 0 , 0

	FROM #ClientsScInNeedOfTzUpdate

	WHERE TimezoneID>0

	UNION -- Having union here to have unique attributes inserted. For CS Client, multiple timezone attributes could be inserted. 

	-- One for Timezone ID and one for Commcell timezone Id attribute. 

	SELECT entityId,'Timezone', 1,CAST(DSTflag AS NVARCHAR(10))+':'+CAST(Bias AS NVARCHAR(10))+':'+ TimeZoneStdName, @curUtcDateTime, 0 , 0

	FROM #ClientsScInNeedOfTzUpdate

	INNER JOIN #schedTimezoneTemp ON #ClientsScInNeedOfTzUpdate.TimezoneId = #schedTimezoneTemp.TimezoneId	

	AND #schedTimezoneTemp.TimezoneId>0

	TRUNCATE TABLE #ClientsScInNeedOfTzUpdate
	INSERT INTO #ClientsScInNeedOfTzUpdate(ID, entityId , attrName , attrVal, TimeZoneID)	


	SELECT Id, componentNameId,attrName,attrVal,

		(SELECT TOP 1 schedTimezoneTemp.timezoneId FROM #schedTimezoneTemp schedTimezoneTemp

		WHERE APP_SubclientProp.attrVal = CAST(schedTimezoneTemp.WindowsTzId AS NVARCHAR(10)) )

	FROM APP_SubclientProp WITH(NOLOCK)

	WHERE attrName = N'timezone Id' AND cs_attrName = CHECKSUM(N'timezone Id') AND modified = 0

	AND attrVal IN 	

	(

		SELECT CAST(schedTimezoneTemp.WindowsTzId AS NVARCHAR(10)) FROM #schedTimezoneTemp schedTimezoneTemp

	)

	UPDATE APP_SubclientProp	

	SET modified = @curUtcDateTime

	FROM APP_SubclientProp INNER JOIN 

	(

		SELECT Id FROM #ClientsScInNeedOfTzUpdate		

		UNION ALL

		--Reset timezone attribute also for clients whose timezone needs to be updated. 

		SELECT APP_SubclientProp.ID FROM APP_SubclientProp(NOLOCK)

		INNER JOIN #ClientsScInNeedOfTzUpdate ON APP_SubclientProp.componentnameId = #ClientsScInNeedOfTzUpdate.entityId

		AND APP_SubclientProp.attrName = 'Timezone'

		AND cs_attrname = CHECKSUM(N'Timezone')

		AND APP_SubclientProp.modified = 0		

	) T

	ON T.Id = APP_SubclientProp.Id	
	INSERT INTO APP_SubclientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)


	SELECT entityId, attrName, 8, CAST(TimezoneID AS NVARCHAR(10)), @curUtcDateTime, 0 , 0

	FROM #ClientsScInNeedOfTzUpdate

	WHERE TimezoneID>0

	UNION -- Having union here to have unique attributes inserted. 

	SELECT entityId,'Timezone', 1,CAST(DSTflag AS NVARCHAR(10))+':'+CAST(Bias AS NVARCHAR(10))+':'+ TimeZoneStdName, @curUtcDateTime, 0 , 0

	FROM #ClientsScInNeedOfTzUpdate

	INNER JOIN #schedTimezoneTemp ON #ClientsScInNeedOfTzUpdate.TimezoneId = #schedTimezoneTemp.TimezoneId	

	AND #schedTimezoneTemp.TimezoneId>0

	TRUNCATE TABLE #ClientsScInNeedOfTzUpdate

	-- Update timezone in schedules in TM_Pattern

	 UPDATE TM_Pattern

	 SET tzId = CASE WHEN #schedTimezoneTemp.TimeZoneId>0 THEN #schedTimezoneTemp.TimeZoneId ELSE 1000 END -- Assign cs timezone in case no matching unix TZ

	 FROM TM_Pattern INNER JOIN #schedTimezoneTemp ON #schedTimezoneTemp.windowsTZID = TM_Pattern.tzID

	 AND TM_pattern.tzID NOT IN (1000,10001) -- exclude CS timezones and client timezones. 

	 -- Update Timezone in archgroup table

	 /*

	 */

	 UPDATE ArchGroup

	 SET TimeZone = #schedTimezoneTemp.TimezoneStdName

	 FROM ArchGroup

	 INNER JOIN SchedTimezone (NOLOCK) ON Timezone = SchedTimezone.TimezoneStdName

	 INNER JOIN #schedTimezoneTemp ON #schedTimezoneTemp.windowsTZID = SchedTimezone.TimezoneId

	 WHERE timezoneType = 2

	 IF object_id('tempdb.dbo.#schedulesInNeedOfUpdate') is not null

    		DROP TABLE #schedulesInNeedOfUpdate

	 -- Update in job options

	CREATE TABLE #schedulesInNeedOfUpdate

	(

		subTaskId		INTEGER,

		optionID		INTEGER, 

		attrName		NVARCHAR(100),

		attrType		INT,

		newValue        NVARCHAR(2048)

	)	

	CREATE CLUSTERED INDEX schedulesInNeedOfUpdate_subTaskId_idx ON #schedulesInNeedOfUpdate (subTaskId)
	INSERT INTO #schedulesInNeedOfUpdate


	SELECT TM_SubtaskOptions.subTaskID,TM_SubtaskOptions.optionID,'TimeZoneID',8, CAST(#schedTimezoneTemp.TimezoneId AS NVARCHAR(10) )

	FROM TM_SubtaskOptions (NOLOCK)

	INNER JOIN TM_StaticTaskOption (NOLOCK) ON TM_SubtaskOptions.OptionId = tm_StaticTaskOption.OptionId

	AND tm_StaticTaskOption.xPath like '%TimezoneId'

	INNER JOIN #schedTimezoneTemp ON CAST(#schedTimezoneTemp.windowsTZID AS NVARCHAR(10)) = TM_SubtaskOptions.Value

	AND #schedTimezoneTemp.TimezoneId>0

	INNER JOIN TM_Subtask (NOLOCK) ON TM_SubtaskOptions.subtaskID = TM_Subtask.subtaskID

	INNER JOIN TM_Task (NOLOCK) ON TM_Task.taskId = TM_Subtask.taskID WHERE TM_Task.taskType!=1 -- No need to process immediate job requests. 

	UNION ALL

	SELECT TM_SubtaskOptions.subTaskID,TM_SubtaskOptions.optionID,'TimeZoneName', 1, #schedTimezoneTemp.TimeZoneName

	FROM TM_SubtaskOptions (NOLOCK)

	INNER JOIN TM_StaticTaskOption (NOLOCK) ON TM_SubtaskOptions.OptionId = tm_StaticTaskOption.OptionId

	AND tm_StaticTaskOption.xPath like '%TimezoneName'

	INNER JOIN SchedTimeZone (NOLOCK) ON SchedTimeZone.timezoneName = TM_SubtaskOptions.Value

	INNER JOIN #schedTimezoneTemp ON #schedTimezoneTemp.windowsTZID  = SchedTimeZone.TimezoneId

	INNER JOIN TM_Subtask (NOLOCK) ON TM_SubtaskOptions.subtaskID = TM_Subtask.subtaskID

	INNER JOIN TM_Task (NOLOCK) ON TM_Task.taskId = TM_Subtask.taskID WHERE TM_Task.taskType!=1 -- No need to process immediate job requests. 

	-- Age of job options and job xml options

	UPDATE TM_JobXMLOptions

    SET modified = @curUtcDateTime

    FROM    TM_JobXMLOptions

    INNER JOIN #schedulesInNeedOfUpdate subTaskTble ON subTaskTble.subTaskId = TM_JobXMLOptions.subTaskId AND modified = 0 AND JobId = 0

	UPDATE TM_JobOptions

	SET modified = @curUtcDateTime

    FROM    TM_JobOptions

    INNER JOIN #schedulesInNeedOfUpdate subTaskTble ON subTaskTble.subTaskId = TM_JobOptions.subTaskId 

	AND TM_JobOptions.optionId = subTaskTble.optionId

	AND modified = 0 AND JobId = 0

	-- Update tm_subtaskoptions and Insert into TM_jobOptions

	UPDATE TM_SubtaskOptions

	SET value = newValue

	FROM TM_SubtaskOptions

	INNER JOIN #schedulesInNeedOfUpdate subTaskTble ON subTaskTble.subTaskId = TM_SubtaskOptions.subTaskId 

	AND TM_SubtaskOptions.optionId = subTaskTble.optionId
	INSERT INTO TM_JobOptions(jobId, optionId, type, value, taskId, subTaskId,lastJobId, created,modified)


    SELECT 0,optionId, attrType, newValue, taskId,#schedulesInNeedOfUpdate.subTaskId,0,@curUtcDateTime,0

    FROM #schedulesInNeedOfUpdate

	INNER JOIN TM_Subtask (NOLOCK) ON #schedulesInNeedOfUpdate.subtaskId = TM_Subtask.subtaskId
	INSERT INTO TM_JobXMLOptions(jobId, xmlValue, taskId, subTaskId, lastJobId, created, modified)


    SELECT  0,TM_JobXMLOptions.xmlValue,TM_JobXMLOptions.taskId,TM_JobXMLOptions.subTaskId,0,@curUtcDateTime, 0

    FROM  TM_JobXMLOptions 

	INNER JOIN 

	(

		SELECT DISTINCT subtaskID FROM #schedulesInNeedOfUpdate 

	)subTaskTble

    ON subTaskTble.subTaskId = TM_JobXMLOptions.subTaskId AND modified=@curUtcDateTime AND  JobId = 0

	IF ( CURSOR_STATUS('global', 'subtaskCursor') >= 0   OR CURSOR_STATUS('local', 'subtaskCursor') >= 0 )  -- CLOSE CURSOR IF OPEN

		CLOSE subtaskCursor

	IF ( CURSOR_STATUS('global','subtaskCursor') = -1     OR CURSOR_STATUS('local','subtaskCursor') = -1 )

		DEALLOCATE subtaskCursor

	DECLARE @l_subTaskId INT

	DECLARE @xPath NVARCHAR(2048), @attrName NVARCHAR(100), @newValue NVARCHAR(2048)

	-- Update xml options with new value. 

	DECLARE subtaskCursor CURSOR LOCAL FORWARD_ONLY READ_ONLY FOR

			-- Replace first node of xpath below. Xpath below will start with options[1] and we need the root to be TMMsg_JobOption

            SELECT  subTaskId, 'TMMsg_JobOption[1]/'+substring(TM_StaticTaskOption.xPath,11,len(TM_StaticTaskOption.xPath) ) , #schedulesInNeedOfUpdate.attrName,#schedulesInNeedOfUpdate.newValue

            FROM    #schedulesInNeedOfUpdate

			INNER JOIN TM_StaticTaskOption (NOLOCK) ON TM_StaticTaskOption.OptionId = #schedulesInNeedOfUpdate.OptionId

    OPEN subtaskCursor

    FETCH NEXT FROM subtaskCursor INTO @l_subTaskId, @xPath , @attrName, @newValue 

    WHILE @@FETCH_STATUS = 0

    BEGIN

		DECLARE @XMLValue NVARCHAR(MAX) = '' 

		SET @XMLValue = '' 

		SELECT @xmlValue = CAST(xmlValue AS NVARCHAR(MAX)) FROM TM_SubTaskXMLOptions (NOLOCK)

		where subTaskId=@l_subTaskId

		DECLARE @xml NVARCHAR(MAX) = CAST( (SELECT @xpath '@xPathElem',  @newValue '@xPathVal', @attrName '@attrName'

		FOR XML PATH('entity'), ROOT('CustomReplacer')) AS NVARCHAR(MAX))

		DECLARE @retainError as int = 1		

		EXEC ReplaceXMLAttributesNew @xmlValue OUTPUT,@xml , 1, @retainerror OUTPUT

		IF @retainerror = 0

		BEGIN

			UPDATE TM_SubTaskXMLOptions

			SET XmlValue = @xmlValue WHERE subtaskId = @l_subTaskId

			UPDATE TM_JobXMLOptions

			SET XmlValue = @xmlValue WHERE subtaskId = @l_subTaskId AND modified = 0

			AND JobId = 0

		END

		FETCH NEXT FROM subtaskCursor INTO @l_subTaskId, @xPath , @attrName, @newValue 

	END

	CLOSE subtaskCursor

	DEALLOCATE subtaskCursor

	-- Delete from runtime so that next runtime s are calculated correctly. 

	DELETE FROM TM_Runtime

	IF object_id('tempdb.dbo.#schedTimezoneTemp') is not null

    		DROP TABLE #schedTimezoneTemp

	IF object_id('tempdb.dbo.#ClientsScInNeedOfTzUpdate') is not null

    		DROP TABLE #ClientsScInNeedOfTzUpdate

	IF object_id('tempdb.dbo.#schedulesInNeedOfUpdate') is not null

    		DROP TABLE #schedulesInNeedOfUpdate
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@guid, 'UpdateSchedtimezoneLinux', 'Update schedtimezone for linux CS', @curUtcDateTime, 16, 0 , (16 + 2))

		COMMIT TRAN

	END TRY

BEGIN CATCH

       PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

       ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

       ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

       ERROR MESSAGE: ' + ERROR_MESSAGE() + '

       ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

       ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

       rollback tran

END CATCH

END

SET NOCOUNT OFF

GO

