

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/UpdateHadoopBkpSetName.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/UpdateHadoopBkpSetName.script,v $ $Id: UpdateHadoopBkpSetName.script,v 1.1.4.4 2020/10/04 01:07:47 abilbrey Exp $";

GO

SET QUOTED_IDENTIFIER ON

GO

DECLARE @curTime INT 

-- Replacing GETDATE with GETUTCDATE

SET @curTime  = dbo.getUnixTime(GETUTCDATE())

-- Changing hadoop default backupset name to HDFS

IF NOT EXISTS(SELECT * FROM GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = 'DC5F0D55-569A-4A64-9204-62D712A88FA4')

BEGIN

	DECLARE @hdfsDescription NVARCHAR(128) = 'Changing hadoop default backupset name to HDFS'

	DECLARE @hdfsName NVARCHAR(64) = 'HDFS upgrade'

	UPDATE bkpName

SET bkpName.name = 'HDFS'

	FROM App_Application app

		INNER JOIN APP_InstanceProp iProp on app.instance = iProp.componentNameId 

		INNER JOIN APP_BackupSetName bkpName on bkpName.id = app.backupSet

	WHERE

		iProp.attrName='Distributed Cluster Type' 

		AND iProp.attrVal = '2'

		AND iProp.modified = 0

		AND bkpName.name = 'defaultBackupSet'

AND (bkpName.status & 0x00008) = 0x00008

	-- Tbl script file should not have any function calls because they may not exist during upgrade
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('DC5F0D55-569A-4A64-9204-62D712A88FA4', @hdfsName, @hdfsDescription, @curTime, 16, 0, (16 + 2))

END

SET NOCOUNT OFF

GO

SET QUOTED_IDENTIFIER ON

GO

