

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/UMUsersProp.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

GO

SET QUOTED_IDENTIFIER ON

GO

SET NOCOUNT ON

DECLARE @nowTime INT = DATEDIFF(second, '01/01/1970', GetUTCdate())

-- Update the user creation code to insert SID as XML 

IF NOT EXISTS(SELECT * FROM   GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = '6EC69ED4-9AEF-4EE7-B7FD-B75042C469D6' )

BEGIN

		UPDATE UMUsersProp SET attrval=CAST(

												(

													SELECT attrval as '@uSID'

													FOR XML PATH('App_ADSIDInfo'),TYPE

												) 

											   as nvarchar(max)

										   )

where attrName='User SID' and modified=0

		and convert(xml,attrval).exist('//App_ADSIDInfo')=0
		INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


			VALUES('6EC69ED4-9AEF-4EE7-B7FD-B75042C469D6', 'User SID Property', 

'Update AD user SID in XML format ', @nowTime, 16, 0, (16 + 2))

END

GO

-- Update the invalid SID XML saved in DB

IF NOT EXISTS(SELECT * FROM   GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = '2051d1f2-8caf-4a69-9718-51a89d1d072e' )

BEGIN

	UPDATE UU

	SET UU.attrVal=CAST(CAST(ref.value('@uSID', 'NVARCHAR(MAX)') AS XML) AS NVARCHAR(MAX))

	FROM UMUsersProp UU

	INNER JOIN 

	(

SELECT CAST(attrval AS XML) AS attrval , componentNameId, attrName from UMUsersProp WHERE attrName='User SID' AND attrVal like '%<App_ADSIDInfo uSID="&lt;App_ADSidInfo%'

	) T

	ON T.componentNameId=UU.componentNameId AND T.attrName=UU.attrName

	CROSS APPLY T.attrval.nodes('App_ADSIDInfo') R ( ref )

WHERE UU.attrName='User SID' AND UU.attrVal like '%<App_ADSIDInfo uSID="&lt;App_ADSidInfo%' and UU.modified=0

DELETE FROM UMUsersProp WHERE attrName='User SID' AND modified=0 AND attrVal='<App_ADSIDInfo/>'
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES('2051d1f2-8caf-4a69-9718-51a89d1d072e', 'Update Invalid User SID Property', 'Update AD user invalid SID to correct XML format ', DATEDIFF(second, '01/01/1970', GetUTCdate()), 16, 0, (16 + 2))

END

GO

-- Update wrong user preference for adminconsole

IF NOT EXISTS(SELECT * FROM   GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE gp.SqlScriptGUID = 'fc06ef33-ecad-44c3-a7e2-f94289c2f4ba' )

BEGIN

		DECLARE @tempTbl TABLE(userId INT PRIMARY KEY)
		INSERT INTO @tempTbl


		SELECT DISTINCT componentNameId FROM UMUsersProp UU

		 where UU.attrName='adminConsolePrefs' and (UU.attrval like '%dloDevicesTable%' OR UU.attrval like '%clientGroupDetailsTable%')

		UPDATE UMUsersProp SET attrVal=replace(attrval, 'clientGroupDetailsTable', 'renamedinvalidgroup') where attrName='adminConsolePrefs' and attrval like '%clientGroupDetailsTable%'

		UPDATE UMUsersProp SET attrVal=replace(attrval, 'dloDevicesTable', 'renamedinvaliddevice') where attrName='adminConsolePrefs' and attrval like '%dloDevicesTable%'

		DELETE UD

		FROM UMQSDKSessions UD

		INNER JOIN @tempTbl TT

			ON TT.userId=UD.userId AND UD.consoleType=21
		INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


			VALUES('fc06ef33-ecad-44c3-a7e2-f94289c2f4ba', 'User Preference Property for Adminconsole', 

'Rename dlodevicetable and clientGroupDetailsTable', DATEDIFF(second, '01/01/1970', GetUTCdate()), 16, 0, (16 + 2))

END

GO

SET NOCOUNT OFF

GO

SET QUOTED_IDENTIFIER ON

GO

